;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

;;;  $Id: acc-4-cascaded-tanks.lisp,v 1.3 1991/09/16 14:11:03 clancy Exp $
(in-package :qsim)
; Part II of chatter2.

; Four cascaded-tanks. 
;  1. Four-cascaded-tanks with no curvature constraints.
;  2. Four-cascaded-tanks with automatic calculation of curvature constraints.
;  3. Four-cascaded-tanks with automatic calculation of curvature constraints
;     and sd3-constraints.

(define-QDE Four-cascaded-tanks
  (text "Four cascaded tanks")
  (quantity-spaces
    (amounta    ( 0    inf)   "amount(A)")
    (inflowa    ( 0    inf)   "flow(ext->A)")
    (outflowa   ( 0    inf)   "flow(A->b)")
    (netflowa   (minf 0 inf)  "d amount(A)")
    (amountb    ( 0    inf)   "amount(B)")
    (inflowb    ( 0    inf)   "flow(a->B)")
    (outflowb   ( 0    inf)   "flow(B->out)")
    (netflowb   (minf 0 inf)  "d amount(B)")
    (amountc    ( 0    inf)   "amount(C)")
    (inflowc    ( 0    inf)   "flow(b->C)")
    (outflowc   ( 0    inf)   "flow(C->out)")
    (netflowc   (minf 0 inf)  "d amount(C)")
    (amountd    ( 0    inf)   "amount(D)")
    (inflowd    ( 0    inf)   "flow(c->D)")
    (outflowd   ( 0    inf)   "flow(D->out)")
    (netflowd   (minf 0 inf)  "d amount(D)")
    )
  (constraints
    ((M+    amounta   outflowa        )     (0 0)    (inf inf))
    ((add   outflowa  netflowa inflowa))
    ((d/dt amounta   netflowa        ))
    ((M+    outflowa  inflowb         )     (0 0)    (inf inf))	; a -> b
    ((M+    amountb   outflowb        )     (0 0)    (inf inf))
    ((add   outflowb  netflowb inflowb))
    ((d/dt amountb   netflowb        ))
    ((M+    outflowb  inflowc         )     (0 0)    (inf inf))	; b -> c
    ((M+    amountc   outflowc        )     (0 0)    (inf inf))
    ((add   outflowc  netflowc inflowc))
    ((d/dt amountc   netflowc        ))
    ((M+    outflowc  inflowd         )     (0 0)    (inf inf))	; c -> d
    ((M+    amountd   outflowd        )     (0 0)    (inf inf))
    ((add   outflowd  netflowd inflowd))
    ((d/dt amountd   netflowd        ))
    ((constant inflowa))
    )
  (layout
     (amounta  amountb  amountc  amountd )
     (inflowa  inflowb  inflowc  inflowd )
     (outflowa outflowb outflowc outflowd)
     (netflowa netflowb netflowc netflowd)))

; Four-cascaded-tanks:  fill-from-empty and increase-inflow-rate
;   1.  No curvature constraints:  (acc = nil; sd3 = nil)
;   2.  Automatic derivation of curvature constraints:  (acc = t; sd3 = nil)
;   3.  Automatic curvature and sd3 constraints:  (acc = t; sd3 = t)
;       It will derive:
;	 (sd3-constraint ((netflowd (add (sd1 netflowb)(minus (sd1 netflowc))))
;			  (netflowc (add (sd1 netflowa)(minus (sd1 netflowb))))
;			  (netflowb (minus (sd1 netflowa)))))

(defun increase-4-cascade-inflow-rate (acc sd3)
  (setf (qde-derived-sd2-expressions four-cascaded-tanks) nil)
  (let* ((sim (make-sim :HOD-constraints acc
			:SD3-constraints sd3
			:analytic-functions-only t))
	 (normal (make-new-state :from-qde four-cascaded-tanks
				 :assert-values '((inflowa ((0 inf) std))
						  (amounta ((0 inf) std))
						  (amountb ((0 inf) std))
						  (amountc ((0 inf) std))
						  (amountd ((0 inf) std)))
				 :sim sim))
	 (init (make-new-state :from-state normal
			       :perturb '((inflowa +))
			       :inherit '(amounta amountb amountc amountd))))
    (qsim init)
    (qsim-display init :reference-states `((normal ,normal)))))

(defun fill-4-cascade-from-empty (acc sd3)
  (setf (qde-derived-sd2-expressions four-cascaded-tanks) nil)
  (let* ((sim (make-sim :HOD-constraints acc
			:SD3-constraints sd3
			:analytic-functions-only t))
	 (init (make-new-state :from-qde four-cascaded-tanks
			       :assert-values '((inflowa ((0 inf) std))
						(amounta (0 nil))
						(amountb (0 nil))
						(amountc (0 nil))
						(amountd (0 nil)))
			       :sim sim)))
    (qsim init)
    (qsim-display init)))
