;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

;;;  $Id: acc-3-cascaded-tanks.lisp,v 1.5 1991/09/16 14:08:39 clancy Exp $
(in-package :qsim)
; Part I of chatter2.

; 1. Three-cascaded-tanks with no curvature constraints.
; 2. Three-cascaded-tanks with automatic calculation of curvature constraints.
; 3. Three-cascaded-tanks with automatic calculation of curvature constraints 
;     and sd3-constraints.

; 1. Three cascaded-tanks without curvature constraints. 

(define-QDE Three-cascaded-tanks
  (text "Three cascaded tanks")
  (quantity-spaces
    (amounta    ( 0   inf)    "amount(A)")
    (inflowa    ( 0   inf)    "flow(ext->A)")
    (outflowa   ( 0   inf)    "flow(A->b)")
    (netflowa   (minf 0 inf)  "d amount(A)")
    (amountb    ( 0   inf)    "amount(B)")
    (inflowb    ( 0   inf)    "flow(a->B)")
    (outflowb   ( 0   inf)    "flow(B->out)")
    (netflowb   (minf 0 inf)  "d amount(B)")
    (amountc    ( 0   inf)    "amount(C)")
    (inflowc    ( 0   inf)    "flow(b->C)")
    (outflowc   ( 0   inf)    "flow(C->out)")
    (netflowc   (minf 0 inf)  "d amount(C)")
    )
  (constraints
    ((M+    amounta   outflowa        )     (0 0) (inf inf))
    ((add   outflowa  netflowa inflowa))
    ((d/dt amounta   netflowa        ))
    ((M+    outflowa  inflowb         )     (0 0) (inf inf))	; a -> b
    ((M+    amountb   outflowb        )     (0 0) (inf inf))
    ((add   outflowb  netflowb inflowb))
    ((d/dt amountb   netflowb        ))
    ((M+    outflowb  inflowc         )     (0 0) (inf inf))	; b -> c
    ((M+    amountc   outflowc        )     (0 0) (inf inf))
    ((add   outflowc  netflowc inflowc))
    ((d/dt amountc   netflowc        ))
    ((constant inflowa))
    )
  (layout
     (amounta  amountb  amountc  )
     (inflowa  inflowb  inflowc  )
     (outflowa outflowb outflowc )
     (netflowa netflowb netflowc )))

; 1. continued: (three-cascaded-tanks without curvature constraints)

(defun increase-3-cascade-inflow-rate ()
  (let* ((sim (make-sim :HOD-constraints nil
			:SD3-constraints nil
			:analytic-functions-only nil))
	 (normal (make-new-state :from-qde three-cascaded-tanks
				 :assert-values '((inflowa ((0 inf) std))
						  (amounta ((0 inf) std))
						  (amountb ((0 inf) std))
						  (amountc ((0 inf) std)))
				 :sim sim))
	 (init (make-new-state :from-state normal
			       :perturb '((inflowa +))
			       :inherit '(amounta amountb amountc))))
    (qsim init)
    (qsim-display init :reference-states `((normal ,normal)))))

(defun fill-3-cascade-from-empty ()
  (let* ((sim (make-sim :HOD-constraints nil
			:SD3-constraints nil
			:analytic-functions-only nil))
	 (init (make-new-state :from-qde three-cascaded-tanks
			       :assert-values '((inflowa ((0 inf) std))
						(amounta (0 nil))
						(amountb (0 nil))
						(amountc (0 nil)))
			       :text "Fill 3-cascade from empty"
			       :sim sim)))
    (qsim init)
    (qsim-display init)))


; 2. Three cascaded-tanks with automatic calculation of curvature constraints. 

(defun increase-3-cascade-inflow-rate-acc ()
  (setf (qde-derived-sd2-expressions three-cascaded-tanks) nil)
  (let* ((sim (make-sim :HOD-constraints t
			:SD3-constraints nil
			:analytic-functions-only t
			:state-limit 50))
	 (normal (make-new-state :from-qde three-cascaded-tanks
				 :assert-values '((inflowa ((0 inf) std))
						  (amounta ((0 inf) std))
						  (amountb ((0 inf) std))
						  (amountc ((0 inf) std)))
				 :sim sim))
	 (init (make-new-state :from-state normal
			       :perturb '((inflowa +))
			       :inherit '(amounta amountb amountc))))
    (qsim init)
    (qsim-display init :reference-states `((normal ,normal)))))

(defun fill-3-cascade-from-empty-acc ()
  (setf (qde-derived-sd2-expressions three-cascaded-tanks) nil)
  (let* ((sim (make-sim :HOD-constraints t
		       :SD3-constraints nil
		       :analytic-functions-only t
		       :state-limit 50))
	 (init (make-new-state :from-qde three-cascaded-tanks
			       :assert-values '((inflowa ((0 inf) std))
						(amounta (0 nil))
						(amountb (0 nil))
						(amountc (0 nil)))
			       :text "Fill 3-cascade from empty"
			       :sim sim)))
    (qsim init)
    (qsim-display init)))

; 3. Three cascaded-tanks with automatic calculation of curvature constraints. 
;    It could have been entered manually as:
;     (other
;	 (sd3-constraint ((netflowc (add (sd1 netflowa) (minus (sd1 netflowb))))
;			  (netflowb (minus (sd1 netflowa))))))

(defun increase-3-cascade-inflow-rate-acc-sd3 ()
  (setf (qde-derived-sd2-expressions three-cascaded-tanks) nil)
  (let* ((sim (make-sim :HOD-constraints t
			:SD3-constraints t
			:analytic-functions-only t
			:state-limit 50))
	 (normal (make-new-state :from-qde three-cascaded-tanks
				 :assert-values '((inflowa ((0 inf) std))
						  (amounta ((0 inf) std))
						  (amountb ((0 inf) std))
						  (amountc ((0 inf) std)))
				 :sim sim))
	 (init (make-new-state :from-state normal
			       :perturb '((inflowa +))
			       :inherit '(amounta amountb amountc))))
    (qsim init)
    (qsim-display init :reference-states `((normal ,normal)))))

(defun fill-3-cascade-from-empty-acc-sd3 ()
  (setf (qde-derived-sd2-expressions three-cascaded-tanks) nil)
  (let* ((sim (make-sim :HOD-constraints t
		       :SD3-constraints t
		       :analytic-functions-only t
		       :state-limit 50))
	 (init (make-new-state :from-qde three-cascaded-tanks
			       :assert-values '((inflowa ((0 inf) std))
						(amounta (0 nil))
						(amountb (0 nil))
						(amountc (0 nil)))
			       :text "Fill 3-cascade from empty"
			       :sim sim)))
    (qsim init)
    (qsim-display init)))


