;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-
;
; Author: Charles Chiu.
; Completion date:  August 1987.  Revised November 1988.
; See curvature.lisp for details.
;

(in-package :qsim) ;changed DJC

(defvar chatter4 nil)

; W-tube model:
;   1.1 Curvature constraint with the inclusion of system property. 
;   1.2 Map out the phase space diagram.

; W-tube model with various relative crossflows in the left and right conduits. 
 
; 1.1. Starting from the initial state where tubes b and c are empty.

(add-to-catalog 'chatter4
  '(w-tube-bc-empty
     ("coeffs-w-tube")
     nil
     ((crossflow-left>right  nil (w-tube t))
      (crossflow-left=right  nil (w-tube 0))
      (crossflow-left<right  nil (w-tube nil))
      )))

; 1.2. Starting from the initial state, where tube a is at the asymptotic level, 
;     b below the asymptotic level and c above this level. 

(add-to-catalog 'chatter4
  '(w-tube-b-lo-c-hi
     ("coeffs-w-tube")
     nil
     ((crossflow-left>right  nil (w-tube1 t))
      (crossflow-left=right  nil (w-tube1 0))
      (crossflow-left<right  nil (w-tube1 nil))
      )))

; 2. 3-tank heart model: Demonstration of the hod-system-property:

(add-to-catalog 'chatter4
		'(heart-sys-property
		   ("coeffs-heart")
		   nil
		   ((heart-ttttt nil (heart-3t t t   t   t   t))
		    (heart-ttttn nil (heart-3t t t   t   t nil))
		    (heart-tttnn nil (heart-3t t t   t nil nil))
		    (heart-ttnnn nil (heart-3t t t nil nil nil))
		    (heart-ttztt nil (heart-3t t t   0   t   t))
		    (heart-tttnt nil (heart-3t t t   t nil   t))
		    (heart-ttnnt nil (heart-3t t t nil nil   t))
		    )))
