;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)


; 
; [Refs: Kuipers and Chiu,  IJCAI-87.
;        Chiu and Kuipers, The curvature constraint algorithm and QSIM based total
;                          envisionment scheme, U-Texas CS-TR, forthcoming. ]
; 
; Chatter3.  Simple spring, damped spring and glaucoma model.
 
; This catalog includes the examples illustrating some technical points
; in connection with the derivation of curvature constraints.

; Some features:  
; a. For the simple spring case, its derivative chain forms a closed loop. Here the
;    curvature constraints are satisfied automatically. Switch on the curvature constraint
;    filter does not lead to the reduction of number of QSIM behaviors.
 
; b. Spring-with-friction: Here the curvature at steady point always comes out finite, the
;    curvature constraints are effective in eliminating all the chattering behavior.
;    However, there are also other constraints as described in
;    [W. W. Lee, C. Chiu and B. J. Kuipers. 1987. Developments Towards Coinstraining
;    Qualitative simulation. U-Texas AI-TR87-44.]
;    which further reduce a number of QSIM behaviors, undesirable from other considerations.
 
; c. The glaucoma model is an unfinished work. However, it is included merely for 
;    illustrating the derivation of curvature constraints where a multiplicative operator
;    is involved. User may switch on the "HOD trees and curvatures" control in the 
;    acc-control-menu to inspect the intermediate steps of the derivation. 
;        Now it works fine (BK:  11-16-89)
        
(defvar Chatter3 nil)
(setq *available-catalogs* (adjoin 'Chatter3 *available-catalogs*))

; 1. The spring-system. 

(add-to-catalog 'Chatter3
  '(spring
     ("springs")
     nil
     ((release-from-max nil (release-spring))
      )))

(add-to-catalog 'Chatter3
  '(spring-acc
     ("springs")
     nil
     ((release-from-max nil (release-spring-acc))
      )))


; 2. The spring with friction. 

(add-to-catalog 'Chatter3
  '(spring-wf
     ("springs")
     nil
     ((release-from-max nil (release-spring-w-friction))
      )))

(add-to-catalog 'Chatter3
  '(spring-wf-acc
     ("springs")
     nil
     ((release-from-max nil (release-spring-w-friction-acc))
      )))

; 3. Glaucoma

(add-to-catalog 'Chatter3
  '(glaucoma					; Glaucoma without ACC
     ("glaucoma")
     nil
     ((low-flow-facility nil (low-flow-facility nil))
      )))

(add-to-catalog 'Chatter3
  '(glaucoma-acc				; Glaucoma with ACC
     ("glaucoma")
     nil
     ((low-flow-facility nil (low-flow-facility t))
      )))
