;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)


;
; [Refs: Kuipers and Chiu,  IJCAI-87.
;        Chiu and Kuipers, The curvature constraint algorithm and QSIM based total
;                          envisionment scheme, U-Texas CS-TR, forthcoming. ] 
;
; Chatter2: 3 cascaded tanks, 4 cascaded tanks, 5 cascaded tanks, and 3 coupled tanks.
; For these cases, curvature constraint alone is no longer adequate. 
; There are two sources which cause the ineffectiveness of curvature constraints:
;
; i. Both HOD' and HOD" vanish simultaneously. Here HOD''' is needed to predict the
; next move of HOD. This constraint is referred to as the sd3-constraint.
; 
; ii. HOD" is indeterminent due to ambiguity in qualitative mathematics. This is a genuine
; limitation of the present qualitative approach.
;
;
; Some features in these examples:
;
; a. Runs with single behavior for 3, 4, 5 cascaded tanks: acc+sd3
;    (i)   State limit: 30
;    (ii)  Accept only analytic function: Yes
;    (iii) Run with a larger stack

; b. Cascaded tanks:As tank number increases, curvature filter becomes less and less adequate.
; Here chattering is due to the vanishing of HOD".
; Inclusion of the sd3-constraint eliminates chattering. 
;
; c. 3 coupled tank: Both sources of ineffectiveness mentioned above contribute.
; Application of curvature constraints together with the sd3-constraints
; only partially tames the branching behavior.
; Details: (sd3 netflowb) = - (sd1 netflowa) - (sd1 netflowc).
; When (sd1 netflowa) & (sd1 netflowc) have opposite sign, (sd3 netflowb) is indeterminant. 

(defvar Chatter2 nil)
(setq *available-catalogs* (adjoin 'Chatter2 *available-catalogs*))

; 1.1 Three-cascaded-tanks without curvature constraints

(add-to-catalog 'Chatter2
  '(3-casc-tanks
     ("acc-3-cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-3-cascade-from-empty))
      )))

; 1.2 Three-cascaded-tanks with curvature constraints.

(add-to-catalog 'Chatter2
  '(3-casc-tanks-acc
     ("acc-3-cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-3-cascade-from-empty-acc))
      )))

; 1.3 Three-cascaded-tanks with curvature constraints and sd3-constraint.

(add-to-catalog 'Chatter2
  '(3-casc-tanks-acc-sd3
     ("acc-3-cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-3-cascade-from-empty-acc-sd3))
      )))

; 2.1 Four-cascaded-tanks without curvature constraints

(add-to-catalog 'Chatter2
  '(4-casc-tanks
     ("acc-4-cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-4-cascade-from-empty nil nil))
      )))

; 2.2 Four-cascaded-tanks with curvature constraints.

(add-to-catalog 'Chatter2
  '(4-casc-tanks-acc
     ("acc-4-cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-4-cascade-from-empty t nil))
      )))

; 2.3 Four-cascaded-tanks with curvature constraints and sd3-constraints.

(add-to-catalog 'Chatter2
  '(4-casc-tanks-acc-sd3
     ("acc-4-cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-4-cascade-from-empty t t))
      )))


; 3.1 Five-cascaded-tanks with curvature constraints.

(add-to-catalog 'Chatter2
  '(5-casc-tanks
     ("acc-5-cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-5-cascade-from-empty nil nil))
      )))

; 3.2 Five-cascaded-tanks with curvature constraints.

(add-to-catalog 'Chatter2
  '(5-casc-tanks-acc
     ("acc-5-cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-5-cascade-from-empty t nil))
      )))

; 3.3 Five-cascaded-tanks with curvature constraints and sd3-constraints.

(add-to-catalog 'Chatter2
  '(5-casc-tanks-acc-sd3
     ("acc-5-cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-5-cascade-from-empty t t))
      )))

; 4.1 The coupled three-tank system.

(add-to-catalog 'Chatter2
		'(three-tank
		   ("acc-three-tank")
		   nil
		   ((fill-from-empty nil (fill-three-tanks-from-empty nil nil))
		    ))) 

; 4.2 The coupled three-tank system with curvature constraints.

(add-to-catalog 'Chatter2
		'(three-tank-acc
		   ("acc-three-tank")
		   nil
		   ((fill-from-empty nil (fill-three-tanks-from-empty t nil))
		    ))) 

; 4.3 The coupled three-tank system with curvature constraints and sd3-constraints.

(add-to-catalog 'Chatter2
		'(three-tank-acc-sd3
		   ("acc-three-tank")
		   nil
		   ((fill-from-empty nil (fill-three-tanks-from-empty t t))
		    ))) 

