;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)

; These now use the single QDE, with multiple SIMs, in cascaded-tanks.lisp and two-tanks.lisp.
;   BJK: 10-10-90.

; 
; [Refs: Kuipers and Chiu,  IJCAI-87.
;        Chiu and Kuipers, The curvature constraint algorithm and QSIM based total
;                          envisionment scheme, U-Texas CS-TR, forthcoming. ]
; 
; Chatter1: Examples of two-cascaded tanks and two-coupled tanks.
; They are simple examples demonstrating the applications of "ignore-qdirs" and 
; "curvature-constraints" in taming the explosive branching behaviors in QSIM.

; Some features:
; a. Switch on the analytic function control eliminates QSIM behavior when any parameter
; value is constant over a time interval.
; Example: For the "fill-from-empty"  of 1.2, 1.3, 1.4 cases, this control reduces 2 behaviors
; to one behavior.
; b. "Curvataure-constraint description" is at a more detail level as compared to the
; "ignore-qdir" description. There are cases where the global behavior of the two 
; descriptions are similar except that the curvature-constraint description has more time
; intervals.
; c. The two-tank-pdmi case of Sec. 2 shows that after the branching behavior is tamed and
; analytic function control is switched on, there are still three QSIM behaviors. 
; d. Go to chatter2 for more complex systems. 

(defvar Chatter1 nil)
(setq *available-catalogs* (adjoin 'Chatter1 *available-catalogs*))

; TWO TANKS.

; 1. Cascaded-tanks.
 

(add-to-catalog 'chatter1
  '(cascaded-tanks
     ("cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-cascade-from-empty))
      (increase-inflow-rate nil (increase-cascade-inflow-rate))
      )))

; 1.2 Cascade-tanks with ignore-qdirs.

(add-to-catalog 'Chatter1
  '(cascaded-tanks-ign-qdirs
     ("cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-cascade-from-empty-ign))
      (increase-inflow-rate nil (increase-cascade-inflow-rate-ign))
      )))

; 1.3 Cascade-tanks with curvature constraints given as input data.
    
(add-to-catalog 'Chatter1
  '(cascade-tanks-curvature
     ("cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-cascade-from-empty-with-curvature-constraint))
      (increase-inflow-rate nil (increase-cascade-inflow-rate-with-curvature-constraint))
      )))

; 1.4 The cascaded-tanks with automatic determination of curvature constraints (acc).

(add-to-catalog 'Chatter1
  '(cascaded-tanks-acc
     ("cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-cascade-from-empty-acc))
      (increase-inflow-rate nil (increase-cascade-inflow-rate-acc))
      )))


; 2. A coupled two-tank system.

; The "pdmi" case: the initial "reduced amount" in tank a being plus and decreasing,
; that in tank b being minus and increasing, where the "reduced amount" is defined to
; be the difference between the amount and its asymptotic value. 
; 

; 2.1 The coupled two-tank system.

(add-to-catalog 'Chatter1
		'(two-tank
		   ("two-tanks")
		   nil
		   ((fill-from-empty nil (fill-two-tanks-from-empty))
		    (two-tank-pdmi nil (two-tank-pdmi))
		    ))) 


; 2.2 The coupled two-tank system ignore qdirs of the relevant parameters.
; The ignore qdirs here are applied to delta-ab outflowa inflowb

(add-to-catalog 'Chatter1
		'(two-tank-ign
		   ("two-tanks")
		   nil
		   (( fill-from-empty nil (fill-two-tanks-from-empty-ign-NFB))
		    (two-tank-pdmi nil (two-tank-ign-pdmi))
		    ))) 

; 2.3 The coupled two-tank system with the automatic determination of curvature constraints.

(add-to-catalog 'Chatter1
		'(two-tank-acc
		   ("two-tanks")
		   nil
		   ((fill-from-empty nil (fill-two-tanks-from-empty-acc))
		    (two-tank-pdmi nil (two-tank-pdmi-acc))
		    ))) 

