;; -*- LISP -*-

;;;; RT Zgraph
;;   Translated from Hogge's version for Symbolics 6.1/ TI Explorers
;;     by H. Kim, University of Illinois.

;; This system definition simplifies loading and compiling. 

(defvar *zgraph-pathname*
  #+HAL-9000 "/u/zgraph/"
  #+QRG-RT "/u/kim/zgraph/"
  )

(pcl::defsystem ZGRAPH *zgraph-pathname*
;; <name> <for loading> <for compiling> <recompile if changed>
 ((defs () () ())
  (swind (defs) (defs) (defs))
  (window (swind) (swind) (swind))
  (gtype (window) (window) (window))
  (graph (defs gtype) (defs gtype) (defs gtype))
  (interf (graph) (graph) (graph))
  (example (interf) (interf) (interf))
  ))

(defun load-zgraph ()
  (pcl::operate-on-system 'zgraph :load))

(defun compile-zgraph ()
  (pcl::operate-on-system 'zgraph :compile))

(defun recompile-zgraph ()
  (pcl::operate-on-system 'zgraph :recompile))
