;;; -*- Mode: LISP; Syntax: Common-lisp; Base: 10; PACKAGE: ZG; Default-character-style: (:FIX :ROMAN :NORMAL) -*-

D,#TD1PsT[Begin using 006 escapes](1 0 (NIL 0) (NIL :BOLD-EXTENDED NIL) "CPTFONTB");;Copyright (c) 1986 by John C. Hogge, The University of Illinois.
;;
;;File FINTERFACE.LISP of system Zgraph.

(2 0 (NIL 0) (NIL NIL NIL) "CPTFONT")(DECLARE (SPECIAL *my-graph-type* *my-graph* *my-window*))

1;;
;;This code provides an example of how to make use of Zgraph within your own user interface.
;;For more information, see the documentation strings for flavors ZG:GRAPH-TYPE, ZG:GRAPH, and
;;ZG:GRAPH-DISPLAY-PANE.  (Use meta-point to get to them.)

;;WARNING: This example doesn't run on the TI Explorer (release 2.0, no patches) due to 
;;window problems.  The window will come up, but panning via LHold causes a bad message to
;;be sent to TV:MAIN-SCREEN.  I haven't a clue, but at least the problem doesn't occur when the
;;GRAPH-DISPLAY-PANE is a part of a constraint frame.  Pop-up use is out for now.

;;
2(DEFUN functional-interface-example ()
  1;;Create a graph display window.  :EXTENDED-WIDTH and :EXTENDED-HEIGHT are required 
2  1;;keywords.  They specify how big to make the hidden bit array used when outputting graphs 
2  1;;on *MY-WINDOW*.  In this case, the hidden bit array is (500 + 1000) by (500 + 1000),
2  1;;Since *MY-WINDOW* is 500x500 and the two keywords extend these dimensions 1000 pixels
2  1;;in each direction.  :KEYSTROKE-COMMANDS and :MENU-COMMANDS specify what commands 
2  1;;*MY-WINDOW* can process when sent a :HANDLE-INPUT message (as shown below).  I've just
2  1;;kept the defaults--if any of the commands are inappropriate, remove them.  If your
2  1;;application needs to add its own commands, add them in the manner described in
2  1;;the doc string form ZG:GRAPH-DISPLAY-PANE.
2  (SETQ *my-window*
	(TV:MAKE-WINDOW 'GRAPH-DISPLAY-PANE
   			:WIDTH 500
			:HEIGHT 500
			:EXTENDED-WIDTH 1000
			:EXTENDED-HEIGHT 1000
			:KEYSTROKE-COMMANDS *default-graph-display-pane-keystroke-commands*
			:MENU-COMMANDS *default-graph-display-pane-menu-commands*
			:LABEL (SI:STRING "To exit, press 
")))

  1;;Create a graph type.  Here, *MY-GRAPH-TYPE* is set up to behave just like the 
  ;;SAMPLE-GRAPH-TYPE.
2  (SETQ *my-graph-type*
	(MAKE-INSTANCE
	  'GRAPH-TYPE
	  :NAME 'my-graph-type
	  :TRAVERSAL-FUNCTION 'sample-graph-traversal-function
	  1;;Determines whether or not traversal function is to be applied
2	  1;;recursively (depth first search from the root vertices), which is
2	  1;;the default, or simply mapped onto the root vertices.
2	  :TRAVERSE-RECURSIVELY? T
	  1;;Controls how vertices and edges are printed
2	  :VERTEX-PRINT-STRING-FUNCTION 'default-vertex-print-string-function
	  :EDGE-PRINT-STRING-FUNCTION 'default-edge-print-string-function
	  1;;Specifies handling of mouse-selection of vertices and edges
2	  :VERTEX/EDGE-SELECTION-HANDLER 'default-vertex/edge-selection-handler
	  1;;Specifies means of dumping to a scroll window a description of vertices and edges.
2	  1;;This is only called in the Zgraph user interface when the user selects a vertex
2	  1;;or edge to be described.
2	  :VERTEX/EDGE-DESCRIPTION-FUNCTION 'default-vertex/edge-description-function))
	 
  1;;Create a graph.  *MY-GRAPH* is set up to be one of Zgraph's sample graphs.
2  1;;:ROOT-VERTICES is a list of root elements in the data structure, from which all 
2  1;;vertices and edges are found by the traversal function.  :TYPE specifies the graph 
2  1;;type we've  defined above
2  (SETQ *my-graph* (MAKE-INSTANCE 'GRAPH
				  :NAME 'my-graph
				  :ROOT-VERTICES '(v1)
				  :TYPE *my-graph-type*))

1  ;;Bind this to NIL so that debug warnings, status messages, and such are not output by
2  1;;Zgraph code.
2  (LET ((*GRAPH-DEBUG-ACTIONS* NIL))
    1;;Find all vertices and edges given ROOT-VERTICES and
2    1;;;the traversal-function of (SEND graph :type).
2    (SEND *my-graph* :CONSTRUCT)
    1;;Assign window coordinates to vertices, based on sizes of *my-window* and its REAL-WINDOW
2    (SEND *my-graph* :PLOT-VERTICES *my-window*)

    1;;Pop up the window
2    (TV:WINDOW-CALL (*my-window* :BURY)
      1;;This does alot of work due to a :BEFORE demon.
2      1;;1. Stores GRAPH in *DISPLAY-IO* so that mouse-sensitivity is activated.
2      1;;2. Resets the graph display window's displacement (from pans of previous graphs).
2      1;;3. Outputs graph onto *display-io*'s real-window.
2      1;;4. Copies bit array from *GRAPH-OUTPUT* to *DISPLAY-IO*.
2      1;;:SET-GRAPH can subsequently be used to replace the currently displayed graph with
2      1;;a new one (not shown in this example).
2      (SEND *my-window* :SET-GRAPH *my-graph*)
      1;;Bind ZG:*DISPLAY-IO* and ZG:*GRAPH-OUTPUT* to the graph display window.  This is
2      1;;required in order for the graph display window's local commands to work right.
2      (LET ((*TERMINAL-IO* *my-window*)
	    (*DISPLAY-IO* *my-window*)
	    (*GRAPH-OUTPUT* (SEND *my-window* :real-window)))
	(LOOP FOR command = (SEND *my-window* :ANY-TYI) DO
	  1;;Exit when END key is pressed.
2	  (IF (char-equal command '#\end) 
	      (RETURN T)
	      1;;If input isn't recognizable by our command loop, have the graph display
2	      1;;window handle it.
2	      (SEND *my-window* :HANDLE-INPUT command)))))))


