" (c) 1993 Copyright (c) University of Washington
  Written by Tony Barrett.

  All rights reserved. Use of this software is permitted for non-commercial
  research purposes, and it may be copied only for that use.  All copies must
  include this copyright message.  This software is made available AS IS, and
  neither the authors nor the University of Washington make any warranty about
  the software or its performance.

  When you first acquire this software please send mail to
  bug-ucpop@cs.washington.edu; the same address should be used for problems."

(in-package "UCPOP")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 5. Special purpose search controllers

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Mimicing the old best first search
;;;
;;; (sc-control 'sussman-anomaly #'bf-mimic)

(defun bf-mimic (prob)
  (declare (ignore prob))
  (reset-controller)
  (define (scr select-ranked)
      :when '((:node $p $r) (rank-plan $p $n))
      :effect '(:rank :node $n $p))
  (define (scr select-threats)
      :when '((:current :node $n)
	      (:flaw $g1)
	      (threat $n $g1 $l $t))
      :effect '(:rank :flaw -1 $g1))
  (define (clause (rank-plan p n))
      (bound! 'rank-plan p)
    (when (plan-p p)
      (matchb n (list (rank3 p))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; A search controller for the prodigy blocks world domain
;;;
;;; (sc-control 'prodigy-sussman #'speed-prodigy-bw)

(defun speed-prodigy-bw (prob)
  (bf-mimic prob)
  (define (scr rank-goals)
      :when '((:flaw $f) (rank-goals $f $n))
      :effect '(:rank :flaw $n $f))
  (define (scr only-puton-for-goals)
      :when '((:current :flaw $g)
	      (:node $p (:step $s $add))
	      (operator $s (stack $b $c) $p)
	      (goal $p $g $t $sn) (neq $sn :goal))
      :effect '(:reject :node $p))
  (define (scr prefer-ons)
      :when '((:candidate :flaw 3 $g1)
	      (:candidate :flaw 3 $g2)
	      (:current :node $p)
	      (goal $p $g1 (on $a $b) :goal)
	      (goal $p $g2 (on $b $c) :goal))
      :effect '(:prefer :flaw $g2 $g1))
  (define (clause (rank-goals g n))
      (bound! 'rank-goals g)
    (when (and (openc-p g) 
	       (member (car (openc-condition g)) 
		       '(on on-table holding clear arm-empty)))
      (matchb n (list (cdr (assoc (car (openc-condition g)) 
				  '((on . 3) (on-table . 2)
				    (holding . 1) (clear . 4)
				    (arm-empty . 5)))))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; A search controller for the prodigy processp domain (not included)
;;;
;;; (sc-control (make-metal-prob "p101") #'speed-machine)

(defun speed-machine (prob)
  (bf-mimic prob)
  (define (scr rank-goals)
      :when '((:flaw $t) (rank-goals $t $n))
      :effect '(:rank :flaw $n $t))
  (define (clause (rank-goals g n))
      (bound! 'rank-goals g)
    (when (and (openc-p g) 
	       (member (car (openc-condition g))
		       '(is-a is-of-type :or)))
      (matchb n (list (cdr (assoc (car (openc-condition g))
				  '((is-a . -2) (is-of-type . -2) 
				    (:or . -1)))))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; A search controller for the refridgerator domain
;;;
;;; (sc-control 'fixa #'speed-fridge)
;;; (sc-control 'fixb #'speed-fridge)
  
(defun speed-fridge (prob)
  (bf-mimic prob)
  (define (scr reject-symmetric-holds)
      :when '((:node $p1 (:link 0 (holds $a1 $f)))
	      (:node $p2 (:link 0 (holds $a2 $f)))
	      (prefered-screw $a1 $a2))
      :effect '(:reject :node $p2))
  (define (scr no-screw-abstraction)
      :when '((:flaw $s) 
	      (:current :node $p)
	      (goal $p $s $g $sn) (no-screw-abstraction $g))
      :effect '(:rank :flaw -1 $s))
  (define (clause (prefered-screw a1 a2))
      (bound! 'prefered-screw a1 a2)
    (when (and (symbolp a1) (symbolp a2)
	       (string< (symbol-name a1) (symbol-name a2)))
      '(nil)))
  (define (clause (no-screw-abstraction g))
      (bound! 'no-screw-abstraction g)
    (when (not (member (if (eq (car g) :not) (caadr g) (car g))
		       '(screwed screw)))
      '(nil))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; A search controller for the ferry domain
;;;
;;; (sc-control 'test-ferry #'speed-ferry)

(defun speed-ferry (prob)
  (declare (ignore prob))
  (reset-controller)
  (define (scr select-threats)
      :when '((:current :node $n)
	      (:flaw $f)
	      (threat $n $f $l $t))
      :effect '(:rank :flaw -2 $f))
  (define (scr road-abstraction)
      :when '((:current :node $p) (:flaw $s)
	      (goal $p $s $g $sn) (in-road-abstraction $g))
      :effect '(:rank :flaw -1 $s))
  (define (scr price-plan)
      :when   '((:node $p $r) (sail-cost $p $n))
      :effect '(:rank :node $n $p))
  (define (scr reject-partial-sails)
      :when '((:current :flaw $g)
	      (:node $p (:step $s $a))
	      (operator $s (debark $x $y) $p)
	      (goal $p $g $t $sn) (neq $sn :goal))
      :effect '(:reject :node $p))
  (define (clause (in-road-abstraction g))
      (bound! 'in-road-abstraction g)
    (when (member (car g) '(at empty-ferry on auto place))
       '(nil)))
  (define (clause (sail-cost p n))
      (bound! 'sail-cost p)
    (when (plan-p p)
      (let ((cost 0))
	(dolist (s (plan-steps p))
	  (incf cost (case (car (p-step-action s))
		       ('sail 40)
		       ('board 2)
		       ('debark 2)
		       (t 0))))
	(matchb n (list cost))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; A search controller for the STRIPS world
;;;
;;; (sc-control 'move-boxes #'speed-strips)

(defun speed-strips (prob)
  (bf-mimic prob)
  (define (scr rank-goals)
      :when '((:flaw $f) (rank-goals $f $n))
      :effect '(:rank :flaw $n $f))
  (define (scr ignore-locations-1)
      :when '((:node $p (:step $s $add))
	      (operator $s (goto-loc $b $c $d) $p))
      :effect '(:reject :node $p))
  (define (scr ignore-locations-2)
      :when '((:node $p (:step $s $add))
	      (operator $s (push-to-loc $a $b $c $d) $p))
      :effect '(:reject :node $p))
  (define (clause (rank-goals g n))
      (bound! 'rank-goals g)
    (when (openc-p g)
      (let ((x (assoc (car (openc-condition g))
		      '((in-room . 1) (is-type . 0) (connects . -1)
			(loc-in-room . 8) (pushable . 0) (next-to . 5)
			(statis . 6)))))
	(when x 
	  (setf x (if (member 'robot (openc-condition g))
		      (1+ (cdr x)) (cdr x))))
	(when x (matchb n (list x)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;

(defun test-sussman ()
  (sc-control 'sussman-anomaly #'bf-mimic))

(defun test-prodigy-bw ()
  (sc-control 'prodigy-sussman #'speed-prodigy-bw))

(defun test-fixa ()
  (sc-control 'fixa #'speed-fridge))

(defun test-fixb ()
  (sc-control 'fixb #'speed-fridge))

(defun test-ferry ()
  (sc-control 'test-ferry #'speed-ferry))