(in-package 'spa)

;**************************************************************
; RENAMING
;   Replace the variables and step-ids in the patterns with new versions,
;   having a number appended.  These don't really depend on any of the 
;   constraint machinery; this only gets applied to templates.

(defun rename-term (term number)
  (cond
	((variable? term) 
	 (make-same-variable term number))
	((condx-p term)
	 (make-condx :form (rename-term (cond-form term) number)
		     :value (cond-value term)))
	((constraint-p term)
	 (make-constraint :equals (cf-equals term)
			  :var1 (rename-term (cf-var1 term) number)
			  :var2 (rename-term (cf-var2 term) number)))
	((listp term) 
	 (mapcar #'(lambda (subt) (rename-term subt number)) term))
	(t term)))


(defun rename-step (step num)
  (make-step
   :id num
   :action (rename-term (step-action step) num)
   :precond (mapcar #'(lambda (s) (rename-term s num)) (step-precond step))
   :postcond (mapcar #'(lambda (s) (rename-term s num)) (step-postcond step))
   :cost (step-cost step)))

