(in-package 'user)

;;;**************************************************************
;;;  Routines to load and compile the SPA system.   This duplicates
;;;  the functionality of the code in SPA.SYSTEM for those who 
;;;  don't have the CMU DEFSYSTEM utility.   Entry points are 
;;;  LOAD-SPA and COMPILE-SPA.  Check the variables that define 
;;;  what directories to find files in. 

;;;  Stops the system from whining when redefining OPEN and STEP
#+:allegro-v4.1(setf excl::*enable-package-locked-errors* NIL)

(defconstant *spa-home-directory* "~/spa")
(defconstant *spa-library-directory* "~/spa/library")

(defvar *binary-extension*)

;;; Binary extension depends on the version + machine
#+:sun4(setf *binary-extension* "sfasl")
#+:mips(setf *binary-extension* "fasl")
#+:allegro-v4.1(setf *binary-extension* "sfasl4")

;;;*************************

(unless (find-package 'spa)
  (make-package 'spa))

;;;*************************


;;;*************************

(defvar *spa-files* 
  '("cmenu"
    "macros"
    "structs"
    "debug"
    "printing"
    "top-sort"
    "copy-support"
    "constraints"
    "rename"
    "copy"
    "adapt"
    "snlp"
    "retract"
    "domains"
    "fitting"
    "retrieval-support"
    "library-support"
    "retrieval"
    "frontend"
    "standard-control-funs"         
    "demo" 
    "experiments"
    "blocksworld-control-funs" 
    "blocksworld-experiments"))

(defvar *spa-library-files*
    '("rao-experiments"))

;;;******************************

(defun load-spa ()
  (dolist (file *spa-files*)
    (load (make-pathname :directory *spa-home-directory* :name file))))

(defun compile-spa ()
  (let ((dir-pn (make-pathname :directory *spa-home-directory*))
        (lib-pn (make-pathname 
                  :directory *spa-library-directory*))
        (obj-pn (make-pathname :type *binary-extension*)))
    (dolist (file *spa-files*)
      (let ((file-pn (merge-pathnames dir-pn (make-pathname :name file))))
        (compile-file file-pn
                      :outfile (merge-pathnames file-pn obj-pn))
        (load file-pn)))
    (dolist (file *spa-library-files*)
      (let ((file-pn (merge-pathnames lib-pn (make-pathname :name file))))
        (compile-file file-pn
                      :outfile (merge-pathnames file-pn obj-pn))
        (load file-pn)))))
