(in-package 'spa)

(defparameter *default-rank-fun* #'last-goal-earliest)

(defun standard-plan-generator (name)
  #'(lambda ()
      (debug-msg :planlib "Generating library plan for ~a" name)
      (let ((the-plan (plan-from-scratch :problem-name name 
                                         :rank-fun *default-rank-fun*)))
        (cond
          ((not (snlp-plan-p the-plan))
           (format t "WARNING:  This plan is not complete!~%")
           the-plan)
          (t (variabilize-plan-selectively the-plan 'all '(table)))))))

;;;  Fitter is a function that takes a plan, initial, and goal, 
;;;  and produces a mapping from constants in the initial/goal 
;;;  to variables in the plan.  Choices at the moment are 
;;;     BOTTOM-UP-FITTER (blocks-world specific)
;;;     MAXIMIZE-SATISFIED-GOALS  (general, but expensive)
;;;  both of these defined in RETRIEVAL-SUPPORT.LISP

(defvar *fitter* 'maximize-satisfied-goals)

(defun standard-plan-checker (name domain-name)
  #'(lambda (initial goal)
      (let ((the-entry (find-lib-entry name)))
        (cond
         ((null the-entry) NIL)
         ((not (eq domain-name (lib-entry-domain-name the-entry)))
          NIL)
         (t (funcall *fitter* (lib-entry-plan the-entry) initial goal))))))


;;;(bottom-up-fitter (lib-entry-plan the-entry) initial goal))))))
;;;(t (best-match initial goal (lib-entry-plan the-entry)))))))

(defun define-standard-bs-plan (name stack-list)
  (define-stacking-plan name
    :initial-on-table stack-list
    :initial-cleartop stack-list
    :initial-on '()
    :goal-stack (reverse stack-list)))

(defvar *bw-domain-name* 'rao-blocksworld)

(defun define-stacking-plan (name &key (initial-on-table '())
                                       (initial-cleartop '())
                                       (initial-on '())
                                       (goal-stack '()))
  (let ((initial '((cleartop table)))
        (goal '()))
    (dolist (ot initial-on-table)
      (push `(on ,ot table) initial))
    (dolist (ct initial-cleartop)
      (push `(cleartop ,ct) initial))
    (dolist (on-pair initial-on)
      (push `(on ,(car on-pair) ,(cadr on-pair)) initial))
    (do ((gs goal-stack (cdr gs)))
        ((null gs) (values))
      (when (not (null (cadr gs)))
        (push `(on ,(cadr gs) ,(car gs)) goal)))
    (add-planlib-entry name 
                       *bw-domain-name*
                       initial 
                       goal 
                       (standard-plan-generator name)
                       (standard-plan-checker name *bw-domain-name*))))

;;;*************************************************************************    
(define-standard-bs-plan '2bs '(a b))
(define-standard-bs-plan '3bs '(a b c))
(define-standard-bs-plan '4bs '(a b c d))
(define-standard-bs-plan '5bs '(a b c d e))
(define-standard-bs-plan '6bs '(a b c d e f))
(define-standard-bs-plan '7bs '(a b c d e f g))
(define-standard-bs-plan '8bs '(a b c d e f g h))
(define-standard-bs-plan '9bs '(a b c d e f g h aa))
(define-standard-bs-plan '10bs '(a b c d e f g h aa bb))
(define-standard-bs-plan '11bs '(a b c d e f g h aa bb cc))
(define-standard-bs-plan '12bs '(a b c d e f g h aa bb cc dd))
(define-standard-bs-plan '13bs '(a b c d e f g h aa bb cc dd ee))


(define-stacking-plan '2bs1
  :initial-on-table '(i)
  :initial-cleartop '(j)
  :initial-on '((j i))
  :goal-stack '(i j))

(define-stacking-plan '3bs1
  :initial-on-table '(i k)
  :initial-cleartop '(i j)
  :initial-on '((j k))
  :goal-stack '(i j k))

(define-stacking-plan '4bs1
  :initial-on-table '(i k l)
  :initial-cleartop '(i k j)
  :initial-on '((j l))
  :goal-stack '(i j k l))

(define-stacking-plan '5bs1
  :initial-on-table '(i k l ll)
  :initial-cleartop '(i k j ll)
  :initial-on '((j l))
  :goal-stack '(i j k l ll))

(define-stacking-plan '6bs1
  :initial-on-table '(i k l ll)
  :initial-cleartop '(i k j jj)
  :initial-on '((j l) (jj ll))
  :goal-stack '(i j k l jj ll))

(define-stacking-plan '6bsez
  :initial-on-table '(k l m o p)
  :initial-cleartop '(k l m n o)
  :initial-on '((n p))
  :goal-stack '(k l m n o p))

(define-stacking-plan '7bs1
  :initial-on-table '(i k l ii ll)
  :initial-cleartop '(i k j ii jj)
  :initial-on '((j l) (jj ll))
  :goal-stack '(i j k l jj ll ii))

(define-stacking-plan '8bs1
  :initial-on-table '(i k l m o p)
  :initial-cleartop '(i k j m o n)
  :initial-on '((j l) (n p))
  :goal-stack '(i j k l m n o p))

(define-stacking-plan '9bs1
  :initial-on-table '(i k l ll iii jjj kkk)
  :initial-cleartop '(i k iii jjj kkk j jj)
  :initial-on '((j l) (jj ll))
  :goal-stack '(i j k l jj ll iii jjj kkk))

(define-stacking-plan '10bs1
  :initial-on-table '(i k l ll iii kkk lll)
  :initial-cleartop '(i j k jj iii jjj kkk)
  :initial-on '((j l) (jj ll) (jjj lll))
  :goal-stack '(i j k l jj ll iii jjj kkk lll))

(define-stacking-plan '12bs1
  :initial-on-table '(i k l ii kk ll iii kkk lll)
  :initial-cleartop '(i k j ii kk jj iii kkk jjj)
  :initial-on '((j l) (jj ll) (jjj lll))
  :goal-stack '(i j k l ii jj kk ll iii jjj kkk lll))
  

