" (c) 1991 Copyright (c) University of Washington 
  Written by Daniel Weld.

  All rights reserved. Use of this software is permitted for non-commercial
  research purposes, and it may be copied only for that use.  All copies must
  include this copyright message.  This software is made available AS IS, and
  neither the authors nor the University of Washington make any warranty about
  the software or its performance.

  When you first acquire this software please send mail to 
  bug-snlp@cs.washington.edu; the same address should be used for problems."

(in-package 'spa)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This is the main plan adaptor
;;; It assumes that you can give it an incomplete plan formed by
;;; integrating the library plan with your current initial state and goals
;;; Note that this "fitting" process can involve some hassling with
;;; links etc.

(defun ADAPT-PLAN (init-plan &key (rank-fun #'crank))
  (setq *the-queue* (make-empty-q rank-fun))
  (init-id-generator (snlp-plan-high-id init-plan))
  (enqueue-entries *the-queue* 
                   `(,(make-qentry :iplan init-plan :dir :extend)
                     ,(make-qentry :iplan (copy-plan-completely init-plan)
				   :dir :retract)))
  (when *debug-save-tree* (setf *dbst-last-plan* nil))
  (let ((count 0)
	(final-plan nil))
    (setf final-plan
      (loop
        (incf (q-iterations *the-queue*))
        (when (empty-q? *the-queue*) (return nil))
        (when (resource-limit-exceeded? *the-queue*)
          ;;(format t "~%Allowed resources exceeded - increase *cbr-iplan-limit*")
          (return nil))
        (let* ((entry (dequeue *the-queue*))
               (iplan (qentry-iplan entry))
               (dir (qentry-dir entry)))
          (when *debug-save-tree*
            (setf (qentry-prev entry) *dbst-last-plan*)
            (when *dbst-last-plan*
              (setf (qentry-next *dbst-last-plan*) entry))
            (setf (qentry-order entry) (incf count))
            (setf *dbst-last-plan* entry))
          (cond
           ((finished-plan? iplan)
            (return (remove-unnecessary-steps iplan)))
           ((eql dir :extend)
            (enqueue-entries *the-queue* (extend-plan entry)))
           ((eql dir :retract)
            (enqueue-entries *the-queue* (retract-plan entry)))
           (t (error "Bad transformation, ~a~%" dir))))))
    (set-plan-stat *the-queue* init-plan final-plan)
    (when final-plan
      (setf (snlp-plan-high-id final-plan) *id-generator*))
    (values final-plan)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun EXTEND-PLAN (qentry)
  (let ((nqe (mapcar #'(lambda (new-plan)
			 (make-qentry :iplan new-plan :dir :extend))
		     (plan-refinements (qentry-iplan qentry)))))
    (when *debug-save-tree*
      (setf (qentry-children qentry) (mapcar #'qd-list nqe))
      (setf (qentry-resolved qentry) *dbst-resolved*)
      (dolist (n nqe)
	(setf (qentry-parent n) qentry)))
    (values nqe)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Priority Queue handling functions

(defun MAKE-EMPTY-Q (rank-fun)
  (make-q :entries nil
          :rank-fun rank-fun
          :cpu-time-created (get-internal-run-time)
          :real-time-created (get-internal-real-time)
          :iplans-enqueued 0
	  :iplans-dequeued 0
          :max-length 0
          :length 0
          ))

(defun EMPTY-Q? (q)
  (= (q-length q) 0))

(defun DEQUEUE (q)
  (let ((head (pop (q-entries q))))
    (decf (q-length q))
    (debug-msg :q "Dequeueing ~a" head)
    (debug-display :q-d head)
    (incf (q-iplans-dequeued q))
    head))

(defun ENQUEUE-ENTRIES (q entries)
  (debug-msg :q "Enqueuing ~a entries to Q of length ~a" 
         (length entries) (q-length q))
  (mapc #'(lambda (e)
            (setf (qentry-rank e) (funcall (q-rank-fun q) e))
            (debug-msg :q "    Entry ~a" e))
        entries)
  (incf (q-length q) (length entries))
  (incf (q-iplans-enqueued q) (length entries))
  (setf (q-entries q) (merge 'list
                        (q-entries q)
                        (sort entries #'< :key #'qentry-rank)
                        #'< :key #'qentry-rank))
  (setf (q-max-length q) (max (q-max-length q) (q-length q)))
  )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Cleanup stuff for end

(defun FINISHED-PLAN? (ip)
  (and (null (snlp-plan-unsafe ip))
       (null (snlp-plan-open ip))))

(defun REMOVE-UNNECESSARY-STEPS (iplan)
  iplan)

(defun RESOURCE-LIMIT-EXCEEDED? (q)
  (> (q-iplans-enqueued q) *cbr-iplan-limit*))

