@device(PostScript)
@make(slides)
@LibraryFile(STable)
@definelinetype(normalline, weight=50)
@definelinetype(thickline, weight=200)
@Define(D, FaceCode D, TabExport)
@set(page = 1)
@Style(TopMargin = 0.5 inch, BottomMargin = 0.5 inch,
	LeftMargin 0.8 inch, RightMargin 1 inch)
@style(TableHeadingWidth On)
@pagefooting[left "TAQL Tutorial", center "Gregg Yost", right <@value(page)>]
@pageheading()
@Define(Indent5=Transparent, LeftMargin +5)
@Define(taqlcode=Format,
		AfterEntry "@tabclear()@tabset(.4 inch, +.4 inch, +.4 inch, +.4 inch, +.4 inch, +.4 inch)")
@commandstring(mdash = "@y[M]")
@begin(format)
@tabclear
@tabset(.5 in, 1.0 in, 1.5 in, 2.0 in, 2.5 in, 3.0 in, 3.5 in, 4.0 in)
@center{Transparencies for
@b[TAQL Tutorial]}

@center{EuroSoar-4 Workshop
Twente University, Enschede, NL
January 18, 1991}

@begin(center, spread 0.3)
@b[Gregg Yost]
School of Computer Science
Carnegie Mellon University
File: @begin(transparent, size -4)@value(FullManuscript)@end(transparent)
Current Version: @value(RootFileDate)
@end(center)

@center[TABLE OF CONTENTS]

1. Title page
2. Introduction
3. Topics covered
4. Task structure
5. A multiple-space system
6. Problem space components
7. Language structure
8. Some important TAQL constructs
9. Conditions
10. Actions
11. Developing TAQL programs
12. TAQL program template
13. Loading and running programs
14. Debugging
15. How to avoid common pitfalls
16. How to avoid common pitfalls #2
17. Unexpected impasse bugs
18. Operator application spaces
19. Propose space
20. Propose-space example
21. Propose initial state
22. Propose-initial-state example
23. Result superstate
24. Result-superstate example
25. Operator application space example
26. Operator application space example #2
27. Other operator application space examples
28. Overview of the selection space
29. What happens in/below the selection space
30. The evaluate-object operator
31. Sample trace
32. Hill-climbing vs. depth-first search
33. Running example:  Monkey and bananas
34. Example - hill climbing, symbolic values
35. Example - hill climbing, numeric values
36. Example - depth-first search
37. State copying - motivation
38. State copying - how
39. Conjunctive negations
40. TAQL and IO
41. Operator termination
42. What we didn't cover
@set(page = 0)
@newpage@begin(group)
@blankspace(1 inch)

@heading{TAQL Tutorial}



@center{@b<Gregg Yost & Erik Altmann>}
@center{School of Computer Science}
@center{Carnegie Mellon University}
@center{gry@@cs.cmu.edu, altmann@@cs.cmu.edu}


@center{January 18, 1991}
@end(group)@newpage@begin(group)
@center{INTRODUCTION}


TAQL = @i[Task Acquisition Language]

@\Problem-space oriented programming language

@\Compiles to Soar productions

Tutorial structure

@\One long class session, with a short break

@\Cover the most important TAQL features

@\@\Learn more advanced features from the manual

@\Tutorial packet includes exercises, other material

@\We assume basic knowledge of Soar, problem spaces

Contact information

@\Gregg Yost:
@\@\WeH 8101
@\@\(412) 268-3060
@\@\gry@@cs.cmu.edu

@\Erik Altmann:
@\@\WeH 5123
@\@\(412) 268-5728
@\@\altmann@@cs.cmu.edu
@end(group)@newpage@begin(group)
@center{TOPICS COVERED}


Problem spaces and task structure

TAQL language structure

Developing TAQL programs

Loading and running programs

Debugging

@\@mdash All limited to a single problem space, at first

Multiple problem spaces

@\Operator application spaces

@\The selection space
@end(group)@newpage@begin(group)
@center{TASK STRUCTURE}


A task is expressed as a collection of problem spaces

@\Each performing some aspect of the task

@\Top-level space is called the @i[task space]

@\Subspaces perform complicated subtasks


Basic problem solving method:

@\Select problem space
@\Select initial state
@\While the current state is not a desired state
@\@\Propose operators to apply to current state
@\@\Select the best one
@\@\Apply it, creating a new current state

Subgoals are generated automatically when problem solving
@\can't proceed in the current space because knowledge
@\of how to perform one of these steps is missing.

E.g., no knowledge of how to apply current operator
@\==> apply operator in a subgoal
@end(group)@newpage@begin(group)
@center{A MULTIPLE-SPACE SYSTEM}

@center{@graphic(postscript=fig13.ps,
                 boundingbox="1.25in,1.75in,7.75in,10.25in")}
@end(group)@newpage@begin(group)
@center{PROBLEM SPACE COMPONENTS}


Within-space:

@\Propose initial state
@\Recognize desired state
@\Propose operators
@\Select operator
@\Apply operator
@\Elaborate state


Between-space:

@\Propose space for current goal
@\Return results to supergoal
@end(group)@newpage@begin(group)
@center{LANGUAGE STRUCTURE}


TAQL program = set of @i[TCs] (TAQL Constructs)

Each TC describes some aspect of a problem space

General form:

   (TC-TYPE NAME {KEYWORD VALUE}*)


Example:

(propose-operator mab*po*reach
    :space mab
    :when ((state ^at bananas))
    :op reach)
@end(group)@newpage@begin(group)
@center{SOME IMPORTANT TAQL CONSTRUCTS}


Within-space:

@\Propose initial state
@\@\Propose-initial-state
@\@\Propose-task-state
@\Recognize desired state
@\@\Goal-test-group
@\Propose operators
@\@\Propose-operator
@\@\Propose-task-operator
@\Select operator
@\@\Prefer
@\@\Compare
@\Apply operator
@\@\Apply-operator
@\Elaborate state
@\@\Augment


Between-space:

@\Propose space for current goal
@\@\Propose-space
@\Return results to supergoal
@\@\Result-superstate
@end(group)@newpage@begin(group)
@center{CONDITIONS}


The :when keyword specifies conditions

Value is a list of Soar conditions

Some conditions are treated specially

@\If class is context object and id missing,
@\condition refers to specified context slot

@\One of goal, problem-space, state, operator,
@\supergoal, superspace, superstate, superoperator,
@\top-goal, top-space, top-state, top-operator

Multiple :when clauses are conjoined


@begin(taqlcode)
(propose-operator mab*po*move
@\:space mab
@\:when ((problem-space ^place <place>))
@\:when ((state - ^at <place> ^on-box false))
@\:op (move ^to <place>))
@end(taqlcode)


Conditions at different levels conjoined


@begin(taqlcode)
(propose-operator switch*po*set-switch
@\:space switch
@\:when ((state ^switch <switch>))
@\:op (set-switch ^switch <switch> ^position off
@\@\@\:when ((switch <switch> ^position on)))
@\:op (set-switch ^switch <switch> ^position on
@\@\@\:when ((switch <switch> ^position off))))
@end(taqlcode)
@end(group)@newpage@begin(group, rightmargin -1)
@center{ACTIONS@ }


ACTION-SPEC says how to create new things

ACTION-SPECs @mdash three forms:

@\ATT-NAME RVALUE+
@begin(verbatim)
@\(propose-initial-state example*pis
@\   :space example
@\   :new (color red white blue))
@end(verbatim)
@\@\For easy specification of simple values



@\ATT-NAME (SOAR-ACTION+)+
@begin(verbatim)
@\:new (shape
@\      ((circle ^radius 2 ^center <point>)
@\       (point <point> ^x 7 ^y 15))
@end(verbatim)
@\@\For specification of new structure



@\(ACTION-TAIL) SOAR-ACTION*
@begin(verbatim)
@\:new
@\ ((^item <item1> + &, <item2> + &)
@\  (item <item1> ^prior nil ^next <item2>)
@\  (item <item2> ^prior <item1> ^next nil))
@end(verbatim)
@\@\For new things that point to each other
@end(group)@newpage@begin(group)
@center{DEVELOPING TAQL PROGRAMS}


Initially, three steps:

@\Comprehend task in its own terms
@\@\e.g. read/understand English MAB spec
@\@\MAB = Monkey-and-bananas

@\Design problem space structure
@\@\abstract, informal
@\@\e.g. develop MAB pseudo-trace and space specs

@\Write TAQL code
@\@\Formalizing the abstract space spec


Then debug

@\May involve redoing parts of any of these steps
@end(group)@newpage@begin(group)
@center{TAQL PROGRAM TEMPLATE}


;==============
; Soar switches
;==============

(user-select ...)
(trace-attributes ...)
(multi-attributes ...)

;===========
; Task setup
;===========

; ---- propose task state and operator:

;===========
; Task space
;===========

; ---- propose space:

; ---- propose initial state:

; ---- goal test:

; ---- return results:

; ---- state elaborations:

; ---- propose operators:

; ---- apply operators:

; ---- search control (select operator):
@end(group)@newpage@begin(group)
@center{LOADING AND RUNNING PROGRAMS}


Very simple

@\Start Soar, and load TAQL

@\Load TAQL source files

@\@\This compiles TCs to SPs and loads the SPs

@\Run it as a Soar system


Soar functions extended to do the right thing for TAQL

@\Functions take SP or TC names, :all, and :types

@\@\(spm :all)
@\@\(excise mab*ao*move :types prefer compare)


Taql-stats prints release info, # TCs, # SPs


Some of the most useful Soar functions for running:

@\init-soar, d, load, run, run-task, user-select,
@\watch, print-stats, excise, excise-task

@\You should be familiar with all of these @mdash
@\@\See the Soar 5 manual
@end(group)@newpage@begin(group, rightmargin -2)
@center{DEBUGGING@ @ }

Essentially, debug as Soar program

@\Trace Soar program to find buggy productions

@\Fix the TCs those productions came from

@\Reload changed TCs

@\@\Automatically excises old productions

Compiled production names have the form
@\SPACE<>TAQL-ABBREV<>TC-NAME<>MESSAGE<>ID
@\e.g. mab<>p-o<>mab*po*move<>14


Some useful Soar commands for debugging:

@\pbreak/unpbreak, ptrace/unptrace, tally, decide-trace
@\cs, smatches, full-matches, pgs, spm, spo, spr, swm,
@\wm, excise, preferences


TAQL commands useful for debugging:

@\taqln @mdash return names of specified TCs
@\@\(taqln :types prefer)

@\taqlp @mdash return SP names compiled from TCs
@\@\(taqlp mab*ao*move)

@\ptaql @mdash return TC names that created SPs
@\@\(ptaql mab<>p-o<>mab*po*move<>14)

@\@\@\But TC name is part of SP name
@end(group)@newpage@begin(group, rightmargin -1)
@center{HOW TO AVOID COMMON PITFALLS@ }

In ACTION-SPECs:

@\Leave id out of first item

@\Don't forget outer parens when only
@\@\one item in list
@begin(verbatim)
@\:new (shape ((circle ^radius 2)))
@end(verbatim)

@\For third form, omit class, id of first item
@begin(verbatim)
@\:new
@\ ((^item <item1> + &, <item2> + &)
@\  (item <item1> ^prior nil ^next <item2>)
@\  (item <item2> ^prior <item1> ^next nil))
@end(verbatim)

@\Don't forget "+ &" for multi-attributes
@\@\See previous example
@\@\And don't forget comma after &

Don't forget outer parens when only one COND in list
@begin(verbatim)
@\:when ((state ^color red ^shape square))
@end(verbatim)

# printed during TC load in a fresh system probably
@\indicates two TCs with the same name
@end(group)@newpage@begin(group)
@center{HOW TO AVOID COMMON PITFALLS #2}


Good to make negative info explicit

@\e.g. @i[^on-box false] better than @i[- ^on-box]
@\but @i[- ^color red] better than @i[^color <> red]

@\@\Both help chunking

Require preferences can conflict with TAQL internals:
@\final-state, evaluate-state operators

Don't copy entailments to initial states
@\Instead, regenerate them in the subgoal
@\Otherwise they won't retract

If something you return from a subgoal disappears,
@\use (watch 3) to see if the internal chunk that
@\should support it is rejecting it instead.  Or,
@\the internal chunk may retract early because it
@\is overgeneral.  These are both Soar bugs, the
@\latter a deep one.

@\This often shows up when you copy up a pointer to
@\an object @mdash the substructure may go away.  To fix,
@\explicitly copy up each bit of substructure.  A real
@\pain.
@end(group)@newpage@begin(group)
@center{UNEXPECTED IMPASSE BUGS}


Operator no-change

@\1. Apply-operator conds not satisfied
@\2. Operator missing, or incorrect parameters

@\Probably followed by goal no-change
@\Examine state with spo, productions with smatches

State no-change

@\Propose-operator conds not satisfied,
@\or TCs missing

Operator tie

@\1. Propose-operator conds not selective enough
@\2. Prefer, compare conds not satisfied
@\3. Search control not complete enough

Problem space no-change

@\Propose-initial-state conds not satisfied,
@\or TC missing

Attribute tie

@\Missing parallel preference (&) when
@\a multi-attribute is created
@end(group)@newpage@begin(group)
@center{OPERATOR APPLICATION SPACES}


If apply-operator TCs don't apply,
@\get operator no-change impasse

Apply operator in subgoal

@\Propose space to apply operator

@\Set up initial state as function of
@\@\superstate, superoperator

@\Apply operators to reach desired state

@\Return results of problem solving

@\@\By editing the superstate


TCs that support subgoaling, result return

@\Propose-space
@\Propose-initial-state
@\Result-superstate
@end(group)@newpage@begin(group)
@center{PROPOSE SPACE}


Defines problem space to use in subgoal

@begin(taqlcode)
(propose-space NAME
@\:space SPACE
@\:function (FUNCTION)
@\[:when (COND+)]*
@\[:copy (ATT@!-NAME*
@/[:from OBJECT-SPEC]
@/[:copy-new (ATT-NAME+)]
@/[:when (COND+)]*)]*
@\[:rename ({ATT-NAME ATT-NAME}*
@/[:from OBJECT-SPEC]
@/[:copy-new ({ATT-NAME ATT-NAME}+)]
@/[:when (COND+)]*)]*
@\[:new (ACTION-SPEC
@/[:when (COND+)]*)]*
@\[:use {superspace | top-space | <id>}])

FUNCTION ::= @!apply operator OPERATOR-COND |
@/{propose | select} {initial-state | operator}
@\@\@\@\@\@\for SPACE |
@/{propose | select} space that will FUNCTION
@end(taqlcode)


:space gives name of space to propose

:function describes purpose of space
@\specifies impasse situation to propose in

:copy, :rename, :new define substructure
@\of the proposed problem space object
@end(group)@newpage@begin(group)
@center{PROPOSE-SPACE EXAMPLE}


@begin(taqlcode)
(propose-space conf-boards*select-space
@\:function (apply operator boards-into-backplane)
@\:space configure-boards
@\:new (configuring-kmc11 true
@\@\@\@\:when (@!(superstate ^module <mod>)
@/(module <mod> ^name kmc11))))
@end(taqlcode)
@end(group)@newpage@begin(group)
@center{PROPOSE INITIAL STATE}


Defines initial state in subgoal

@begin(taqlcode)
(propose-initial-state NAME
@\[:space SPACE]
@\[:when (COND+)]*
@\[:copy (ATT@!-NAME*
@/[:from OBJECT-SPEC]
@/[:copy-new (ATT-NAME+)]
@/[:when (COND+)]*
@/)]*
@\[:rename ({ATT-NAME ATT-NAME}*
@/[:from OBJECT-SPEC]
@/[:copy-new ({ATT-NAME ATT-NAME}+)]
@/[:when (COND+)]*
@/)]*
@\[:new (ACTION-SPEC [:when (COND+)]*)]*
@\[:use {superstate | top-state | ID}])
@end(taqlcode)


:copy, :rename take attributes from superstate

:copy-new makes a copy of the @i[object] the source
@\attribute points to

:use uses an existing state for the initial state
@end(group)@newpage@begin(group)
@center{PROPOSE-INITIAL-STATE EXAMPLE}


@begin(taqlcode)
(propose-initial-state conf-mods*initial-state
@\:space configure-modules
@\:copy (bac@!kplane ub-load-left
@/:copy-new (power-available configuration))
@\:rename (current-module current-node)
@\:new (phase process-node))
@end(taqlcode)
@end(group)@newpage@begin(group)
@center{RESULT SUPERSTATE}


Defines result state of superoperator

Like apply-operator for final-state operator

@begin(taqlcode)
(result-superstate@index(result-superstate) NAME
@\[:space SPACE]
@\[:group-name {GROUP-NAME | ID}]
@\[:group-type {success | failure | ID}]
@\[:when (COND+)]*
@\[:terminate-when ([COND+])]* 
@\[:use {superstate | final-state | ID]]
@\[:bind ID]*
@\[EDIT]*)
@end(taqlcode)


:group-type, :group-name from goal-test-group

:use uses existing state as result state

Typically (edit :what superstate ...)
@end(group)@newpage@begin(group, rightmargin -4)
@center{RESULT-SUPERSTATE EXAMPLE@ @ @ @ }


@begin(taqlcode)
(result-superstate find-assignment*success
@\:space find-assignment
@\:group-type success

@\(edit :what superstate
@\@\:copy (successful-assignment)
@\@\:rename (made-assignment successful-assignment)
@\@\:replace (found-assignment :by true)))






(result-superstate find-assignment*failure
@\:space find-assignment
@\:group-type failure

@\(edit :what superstate
@\@\:replace (found-assignment :by false)))
@end(taqlcode)
@end(group)@newpage@begin(group)
@center{OPERATOR APPLICATION SPACE EXAMPLE}


We've already seen an operator application space

@\Though I didn't emphasize it

@\The MAB space applies the do-mab task operator


But no information was copied down for the initial state

@\And no results copied up on reaching final state


Let's change it to something more complicated

@\Store initial monkey, box locations in top task state

@\Copy them down into MAB initial state

@\When done in MAB copy new locations to task state
@end(group)@newpage@begin(group)
@center{OPERATOR APPLICATION SPACE EXAMPLE #2}


Store initial locations on task state

@begin(taqlcode)
@\(propose-task-state do-mab*pts
@\@\:new (at place1)
@\@\:new (box-at place2))
@end(taqlcode)


Copy locations down to MAB initial state

@begin(taqlcode)
@\(propose-initial-state mab*pis
@\@\:space mab
@\@\:new (on-box false)
@\@\:copy (at box-at))
@end(taqlcode)


Return updated locations to task state

@begin(taqlcode)
@\(result-superstate mab*rs
@\@\:space mab
@\@\:group-type success

@\@\(edit :what superstate
@\@\@\:copy (at box-at :remove target)))
@end(taqlcode)
@end(group)@newpage@begin(group)
@center{OTHER OPERATOR APPLICATION SPACE EXAMPLES}


The files member.taql and member-driver.taql in the
tutorial packet give more complicated examples of
operator application spaces.  The problem spaces
defined in those files implement and test a @i[member]
operator on linked lists.



You should study these examples on your own.  You will
need to understand them to do the second problem set.
@end(group)@newpage@begin(group)@center[
@comment(title) OVERVIEW OF THE SELECTION SPACE
]

Part of Soar's default knowledge

Lets Soar:

@\1.@\Evaluate
@\@\@\"Assess the options"
@\@\@\"Learn what is rewarding"

@\2.@\Search
@\@\@\"Look ahead from current state of knowledge"
@\@\@\"Simulate the real world"

Selected for tie impasses, usually between operators

Provides:

@\1.@\Language for expressing @i(evaluations)

@\@\Statements about worth of an object:
@\@\@\Numeric and symbolic values

@\2.@\Support for @i(lookahead search)

@\@\Default attempt to generate evaluation knowledge

@\@\In a subgoal, 
@\@\@\Duplicate tie-context
@\@\@\Try out a tied operator
@\@\@\Recurse, if a new tie arises
@\@\@\Backtrack, if evaluation knowledge arises

@end(group)@newpage@begin(group)@center[
@comment(title) WHAT HAPPENS IN/BELOW THE SELECTION SPACE
]

1.@\Operator-tie impasse arises in task space

2.@\Soar:

@\1.@\Proposes selection space for subgoal
@\@\@\Made worst, so user space can override

@\2.@\Generates evaluate-object operators
@\@\@\One instance per tied object

@\3.@\Selects an evaluate-object operator indifferently

@\4.@\Terminates it when it has a value
@\@\@\Assigning a value = Application
@\@\@\Application @i(direct) or in @i(evaluation subgoal)

@\@\Evaluation subgoal:
@\@\@\1.@\Re-establishes the tie-context
@\@\@\2.@\Selects the tied operator being evaluated
@\@\@\3.@\Passes control to task to apply operator

3.@\More task operators can apply in evaluation subgoal

@\At any point after first operator is applied, either

@\@\1A.@\Evaluation knowledge applies
@\@\@\@\Effect:  @i(hill-climbing)
@\@\@\@i(or)
@\@\1B.@\Another tie arises
@\@\@\@\Effect:  @i(depth-first search)

@end(group)@newpage@begin(group)@center[
@comment(title) THE EVALUATE-OBJECT OPERATOR
]

Tied object is a parameter

Soar processes value assigned to evaluate-object

@\Value becomes preference for parameter in tie context

@\Unary preference example:

@\@\Evaluate-object(op1) = "success"
@\@\@\--> @!op1 "best" for tie goal

@\Binary preference example:

@\@\Evaluate-object(op1) = "5"  &
@\@\   Evaluate-object(op2) = "4"
@\@\@\--> @!op1 "better" than op2 for tie goal

@\Equal values are made indifferent

TAQL interface:

@\The @i(evaluate-object) TC

@\@\Specifies @i(evaluation function)
@\@\@\Values, when to assign, to what objects

@\The @i(evaluation-properties) TC

@\@\Controls parameters for:
@\@\@\Tie-context duplication
@\@\@\Evaluation function

@\@\TAQL provides comprehensive defaults

@end(group)@newpage@begin(group,rightmargin -11)@center[
@comment(title) SAMPLE TRACE
]
@begin(verbatim, size -4)
0  G: g1 
1  P: p4 (top-space)
2  S: s5 
3  O: o12 (do-mab)
4  ==>G: g16 (operator no-change)
5     P: p23 (mab)
6     S: s31 
   ...
59    O: o99 (bananas move-box)
60    ==>G: g447 (operator tie)
61       P: p448 (selection)
62       S: s454 
63       O: o303 ((on climb) evaluate-object)
64       ==>G: g474 (operator no-change)
65          P: p23 (mab)
66          S: d483 
67          O: o484 (on climb)
68          ==>G: g497 (operator tie)
69             P: p654 (selection)
70             S: s532 
71             O: o507 ((off climb) evaluate-object)
72             ==>G: g528 (operator no-change)
73                P: p23 (mab)
74                S: d509 
75                O: o511 (off climb)
76                O: e559 (-1 evaluate-state)
                  Evaluation of operator o511 (climb) is -1
77             O: o510 ((reach) evaluate-object)
78             ==>G: g557 (operator no-change)
79                P: p23 (mab)
80                S: d540 
81                O: o541 (reach)
82                O: e592 (success evaluate-state)
                  Evaluation of operator o541 (reach) is success
83    O: o299 (on climb)
84    ==>G: g590 (operator tie)
85       P: p696 (selection)
86       S: s629 
87       O: o552 ((off climb) evaluate-object)
88       ==>G: g624 (operator no-change)
89          P: p23 (mab)
90          S: d591 
91          O: o570 (off climb)
92          O: e669 (-1 evaluate-state)  ...
@end(verbatim)
@end(group)@newpage@begin(group,rightmargin -4)@center[
@comment(title) HILL-CLIMBING VS. DEPTH-FIRST SEARCH
]

The two most common paradigms of use
@bar()

Hill-climbing (HC):  determine best local move

@\Procedure:

@\@\Try out each tied operator
@\@\Evaluate each result state
@\@\Compare the values

@\HC can suffice when operators are invertible

@bar()

Depth-first search: determine successful move sequence

@\Procedure:

@\@\Try out an operator
@\@\If another tie arises, recurse
@\@\Terminate with successful state

@\Soar "backs-up" success to top selection
@\@\Ideally, chunks remember the solution path

@\Backtrack (only) from states not on solution path
@\@\Assign any non-"success" value

@\Depth-first-search required for non-invertible operators
@\@\Every selection tentative, till success

@end(group)@newpage@begin(group)@center[
@comment(title) RUNNING EXAMPLE:  MONKEY AND BANANAS
]

Initial configuration:

@\Monkey at "place1",
@\Box at "place2",
@\Bananas at "bananas"

Optimal operator sequence:

@\O1: Move to place2
@\O2: Move-box to bananas
@\O3: Climb on box
@\O4: Reach

Hill-climbing sample solution:

@\1. Try out each tied operator
@\2. Score resulting state
@\@\Better scores for smaller differences
@\@\Failure for really dumb moves
@\3. Pick operator with best score
@\4. Goto 1.

Depth-first search sample solution:

@\Specify how to detect a state cycle

@\Recursively try out operators
@\@\If a cycle is detected, backtrack

@\Remember the successful path in chunks

@\Chunks apply at top level

@end(group)@newpage@begin(group)@center[
@comment(title) EXAMPLE - HILL CLIMBING, SYMBOLIC VALUES
]

Basic symbolic values:  success, failure, novalue

@\Success:@\terminates lookahead search
@\Failure:@\@\rejects last alternative
@\Novalue:@\@\says only, "Backtrack, please"
@\@\Learns no chunks, generally "safer" than failure

Example:  Climbing when not at bananas is "fruitless"...
@begin(verbatim, size -2)
  ...
  O: o35 (place2 move)
  ==>G: g123 (operator tie)
     P: p124 (selection)
     S: s130 
     O: o134 (evaluate-object (climb on))
     ==>G: g150 (operator no-change)
        P: p23 (mab)
        S: d159 
        O: o160 (climb on)
        O: e152 (evaluate-state failure)
        Evaluation of o160 (climb) is failure
     ...
@end(verbatim)
TAQL implementation:
@begin(verbatim, size -2)
  (evaluate-object eo*lookahead*failure
    :space mab
    :what lookahead-state
    :when ((state ^tried climbing-on
                - ^at bananas))
    :symbolic-value failure)
@end(verbatim)

Shortcut for symbolic values:
@begin(verbatim, size -2)
  (goal-test-group gtg*mab
    :group-type success        ;;  <----
    :when ((state ^reached bananas)))
@end(verbatim)
@\:group-type converted automatically

@end(group)@newpage@begin(group)@center[
@comment(title) EXAMPLE - HILL CLIMBING, NUMERIC VALUES
]

State is given numeric value

@\Operators preferred relative to each other

Example:

@begin(verbatim, size -2)
  (evaluate-object eo*lookahead*numeric-values
    :space mab
    :what lookahead-state

    :numeric-value (0
      :when ((state ^at <place> 
                  - ^box-at <place>
                  - ^tried)))

    :numeric-value (1
      :when ((state ^at { <> bananas <place> }
                    ^box-at <place>
                  - ^tried)))

    :numeric-value (2
      :when ((state ^at bananas
                    ^box-at bananas))))
@end(verbatim)

Useful when state has numeric attributes

@\E.g., R1-Soar @t(compute)s evaluations

@end(group)@newpage@begin(group)@center[
@comment(title) EXAMPLE - DEPTH-FIRST SEARCH
]

Climbing on, then climbing off, is a cycle
@begin(verbatim, size -2)
  ...
  G: g400 (operator tie)
  P: p448 (selection)
  S: s419 
  O: o221 (evaluate-object (climb on))
  ==>G: g528 (operator no-change)
     P: p23 (mab)
     S: d537 
     O: o522 (climb on)
     ==>G: g557 (operator tie)
        P: p654 (selection)
        S: s594 
        O: o567 (evaluate-object (climb off))
        ==>G: g590 (operator no-change)
           P: p23 (mab)
           S: d569 
           O: o571 (climb off)
           O: e626 (evaluate-state novalue)
           State cycle: d569 and d395.
           Evaluation of o571 (climb) is novalue
        O: o570 ((reach) evaluate-object)
        ...
@end(verbatim)

TAQL implementation:
@begin(verbatim, size -2)
  (evaluate-object eo*mab*depth-first
    :space mab
    :what
      (lookahead-state
        :cycle-when
          ((state ^on-box <ob> ^at <at>)))
    :symbolic-value novalue)
@end(verbatim)

@\:cycle-when is tested pairwise across all goals

@\"If current ^on-box and ^at match a previous state,
@\@\then cycle exists."

@end(group)@newpage@begin(group)@center[
@comment(title) STATE COPYING - MOTIVATION
]

Can't select original state from tie-context

@\Trying one operator destroys it for alternatives

So, Soar @i(duplicates):

@\1. The tie-context state

@\@\Creates a new state
@\@\Copies augmentations from original

@\2. Designated objects @i(attached) to tie-context state

@\@\Creates new objects
@\@\Copies augmentations from originals

@\2. The tied operator

@\@\Creates a new operator
@\@\Copies augmentations from original

@i(But...)

Copying is not so simple

@\May not need all state augmentations

@\Have to designate which objects to duplicate

@\Lots of interactions

Copying controlled by @i(evaluation-properties) TC

@end(group)@newpage@begin(group)@center[
@comment(title) STATE-COPYING - HOW
]
TC controls state-copying (and changes defaults)

Semantics of copy keywords:

@\:copy-new - duplicates objects below the state
@\@\List attributes whose objects will be edited

@\:copy - transfers objects to new state
@\@\List attributes with constant values
@\@\List attributes whose objects won't be edited

@\:dont-copy - leave objects behind
@\@\List state entailments
@\@\@\Won't retract properly if copied
@\@\List unneeded attributes

@\@i(Default):  :copy (:all)

Example:
@begin(verbatim, size -2)
  (evaluation-properties ep*switchyard
    :space switchyard
    :lookahead
      (:copy-new (car)
       :copy (:all)   ; copies siding-clear
       :dont-copy (in-position)))
@end(verbatim)

@\^car - a multi-attribute of car objects
@\@\Cars are edited when position changes

@\^siding-clear - status flag
@\@\Takes a constant value

@\^in-position - state entailment
@\@\Values are cars that are in position
@\@\Must retract if cars moved out of position

@end(group)@newpage@begin(group)@center[
@comment(title) CONJUNCTIVE NEGATIONS
]

Given working memory of the form:

@begin(verbatim, size -2)
  (state s1 ^language l2 l3 ... )
  (language l2 ^syntax foo )
@end(verbatim)


Express the condition:

@\@\"No language has perfect syntax"

@bar()

Wrong:
@begin(verbatim, size -2)
 :when ((state - ^language <c>)
        (language <c> ^syntax perfect))
@end(verbatim)


Right:
@begin(verbatim, size -2)
 :when ( -{(state ^language <c>)
           (language <c> ^syntax perfect)} )
@end(verbatim)
@end(group)@newpage@begin(group)@center[
@comment(title) TAQL AND IO
]

Top-state access

@\Reading:  @i(top-state) as a CONTEXT-OBJECT

@\Writing:  (edit :what top-state ... )


Asynchronous operators

@\@i(:terminate-when) for apply-operator

@\@\Explicit termination conditions

@\@i(:type sliding) for edit clauses

@\@\Freestyle editing
@\@\Edits can chain, react to IO, loop...

@end(group)@newpage@begin(group)@center[
@comment(title) OPERATOR TERMINATION 
]

When applied directly:

@\Three alternatives in apply-operator:

@\1.@\No :terminate-when

@\@\@\Reconsider if an edit clause applies
@\@\@\No-change impasse if none apply

@\2.@\:terminate-when, with conditions

@\@\@\Reconsider when conditions satisfied
@\@\@\Don't reconsider from edit clauses

@\@\@\Uses:@\Monitor WM changing from IO
@\@\@\@\Goal test, if state edited from subgoal

@\3.@\:terminate-when, with no conditions

@\@\@\No reconsider generated, anywhere

@\@\@\Uses:@\Partial direct application
@\@\@\@\TC does generic edits


When applied in a subgoal:

@\Reconsider when result-superstate applies in subgoal

@\@\See the manual

@end(group)@newpage@begin(group)@center[
@comment(title) WHAT WE DIDN'T COVER
]

Representation issues

@\Separate static from dynamic knowledge

Didn't use "model" representation

@\See next Soar manual

Search control

@\Can be confusing:
@\@\Things can be better than best...

@\See Soar 5 manual

Data types

Operator-control TC

Advanced and little-used options to some TCs
@end(group)
@end(format)
