
;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/GAD-scroll-parts.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;;  GAD-scroll-parts
;;;
;;;  This module is a collection of schema definitions required by the trill
;;;  device and all scroll bars and sliders.
;;;
;;;  Written by Andrew Mickish
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

;;;  CHANGE LOG
;;;  01/18/90  Andrew Mickish - Changed the following formulas to consider the
;;;            :scroll-p slot of the top level gadget:
;;;                1) :active of TRILL-INTER      3) :active of SLIDE-INTER
;;;                2) :visible of INDICATOR-TEXT  4) :active of JUMP-INTER
;;;  03/11/90  Andrew Mickish - Simplified VAL-1-FN and VAL-2-FN by calling
;;;            S-VALUE instead of INCF and DECF.
;;;  07/01/90  Andrew Mickish - Considered :window slot in :active formulas
;;;            of all interactors
;;;  11/30/90  Pavan Reddy - used "format" instead of "prin1-to-string" in
;;;            INDICATOR-TEXT to allow use of floats.
;;;

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

;;;
;;;  TRILL INTERACTOR AND INCREMENTOR FUNCTIONS
;;;

;;;  Used to increment (or decrement) the value closer to VAL-1
;;;
(defun VAL-1-FN (interactor final-obj-over)
  (declare (ignore final-obj-over))
  (let* ((parent (g-value interactor :operates-on :parent))
	 (val-1 (g-value parent :val-1))
	 (val-2 (g-value parent :val-2))
	 (value (g-value parent :value))
	 (inc-by (g-value interactor :operates-on :inc-by)))

    (cond 
     ;; there is a max and a min
     ((and val-1 val-2)
      (if (< val-1 val-2)
	  (let ((thresh-val (+ val-1 inc-by)))
	    (if (> value thresh-val)
		(s-value parent :value (- value inc-by))
		(s-value parent :value val-1)))
	  (let ((thresh-val (- val-1 inc-by)))
	    (if (< value thresh-val)
		(s-value parent :value (+ value inc-by))
		(s-value parent :value val-1)))))

     ;; there is no max
     ((and val-1 (not val-2))
      (let ((thresh-val (+ val-1 inc-by)))
	(if (> value thresh-val)
	    (s-value parent :value (- value inc-by))
	    (s-value parent :value val-1))))

     ;; there is no min
     (t (s-value parent :value (- value inc-by))))))

;;;  Used to increment (or decrement) the value closer to VAL-2
;;;	   
(defun VAL-2-FN (interactor final-obj-over)
  (declare (ignore final-obj-over))
  (let* ((parent (g-value interactor :operates-on :parent))
	 (val-1 (g-value parent :val-1))
	 (val-2 (g-value parent :val-2))
	 (value (g-value parent :value))
	 (inc-by (g-value interactor :operates-on :inc-by)))

    (cond
     ; there is a max and a min
     ((and val-1 val-2)
      (if (< val-1 val-2)
	  (let ((thresh-val (- val-2 inc-by)))
	    (if (< value thresh-val)
		(s-value parent :value (+ value inc-by))
		(s-value parent :value val-2)))
	  (let ((thresh-val (+ val-2 inc-by)))
	    (if (> value thresh-val)
		(s-value parent :value (- value inc-by))
		(s-value parent :value val-2)))))

     ; there is no min
     ((and (not val-1) val-2)
      (let ((thresh-val (- val-2 inc-by)))
	(if (< value thresh-val)
	    (s-value parent :value (+ value inc-by))
	    (s-value parent :value val-2))))

     ; there is no max
     (t (s-value parent :value (+ value inc-by))))))


(create-instance 'TRILL-INTER inter:Button-Interactor
   (:active (o-formula (and (gvl :operates-on :visible)
			    (gvl :window)
			    (gvl :operates-on :parent :scroll-p))))
   (:window (o-formula (gv-local :self :operates-on :window)))
   (:start-event :leftdown)
   (:start-where (o-formula (list :in-box (gvl :operates-on :frame))))
   (:start-action #'VAL-1-FN)
   (:final-function #'(lambda (interactor obj)
			(declare (ignore obj))
			(kr-send (g-value interactor :operates-on :parent)
				 :selection-function
				 (g-value interactor :operates-on :parent)
				 (g-value interactor :operates-on :parent
					  :value)))))


;;;
;;;  FRAME FOR TRILL BOXES
;;;


(create-instance 'TRILL-FRAME opal:rectangle
   (:left (o-formula (gv (path 0 :parent) :left)))
   (:top (o-formula (gv (path 0 :parent) :top)))
   (:width (o-formula (gv (path 0 :parent) :width)))
   (:height (o-formula (gv (path 0 :parent) :height)))
   (:visible (o-formula (gv (path 0 :parent) :visible))))


;;;
;;;  BACKGROUND INDICATOR MOVES IN
;;;

(create-instance 'BOUND-BOX opal:rectangle
   (:left (o-formula (gv (path 0 :parent) :bound-left)))
   (:top (o-formula (gv (path 0 :parent) :bound-top)))
   (:width (o-formula (gv (path 0 :parent) :bound-width)))
   (:height (o-formula (gv (path 0 :parent) :bound-height))))


;;;
;;;  INCDICATOR TEXT
;;;

(create-instance 'INDICATOR-TEXT opal:text
   (:left (o-formula (- (+ (gv (path 0 :parent :indicator) :left)
			   (floor (gv (path 0 :parent :indicator) :width) 2))
			(floor (gvl :width) 2))))
   (:top (o-formula (- (+ (gv (path 0 :parent :indicator) :top)
			  (floor (gv (path 0 :parent :indicator) :height) 2))
		       (floor (gvl :height) 2))))
   (:string (o-formula (format NIL (gv (path 0 :parent) :format-string)
			       (gv (path 0 :parent) :value))))
   (:font (o-formula (gv (path 0 :parent) :indicator-font)))
   (:visible (o-formula (and (gv (path 0 :parent) :indicator-text-p)
			     (gv (path 0 :parent) :scroll-p)))))

;;;
;;; INTERACTORS TO MOVE INDICATOR WITH MOUSE
;;;

(defun SLIDE-SEL-FN (interactor obj points)
  (call-prototype-method interactor obj points)
  (when (not (g-value interactor :operates-on :int-feedback-p))
    (slide-final-fn interactor obj points)))

(defun SLIDE-FINAL-FN (interactor obj points)
  (declare (ignore obj points))
  (kr-send (g-value interactor :operates-on)
	   :selection-function
	   (g-value interactor :operates-on)
	   (g-value interactor :operates-on :value)))


(create-instance 'SLIDE-INTER inter:Move-Grow-Interactor
   (:window (o-formula (gv-local :self :operates-on :window)))
   (:active (o-formula (and (gvl :window) (gvl :operates-on :scroll-p))))
   (:start-where (o-formula (list :in-box (gvl :operates-on :indicator))))
   (:running-where (o-formula (list :in-box (gvl :operates-on :bounding-area))))
   (:outside NIL)
   (:obj-to-be-moved (o-formula (gvl :operates-on :indicator)))
   (:feedback-obj (o-formula (if (gvl :operates-on :int-feedback-p)
				(gvl :operates-on :int-feedback)
				(gvl :operates-on :indicator))))
   (:waiting-priority inter:high-priority-level)
   (:grow-p NIL)
   (:start-action #'SLIDE-SEL-FN)
   (:running-action #'SLIDE-SEL-FN)
   (:final-function #'SLIDE-FINAL-FN))


(create-instance 'JUMP-INTER inter:Move-Grow-Interactor
   (:window (o-formula (gv-local :self :operates-on :window)))
   (:active (o-formula (and (gvl :window) (gvl :operates-on :scroll-p))))
   (:start-event :leftdown)
   (:start-where (o-formula (list :in-box (gvl :operates-on :bounding-area))))
   (:running-where (o-formula (list :in-box (gvl :operates-on :bounding-area))))
   (:outside NIL)
   (:obj-to-be-moved (o-formula (gvl :operates-on :indicator)))
   (:feedback-obj (o-formula (gvl :operates-on :indicator)))
   (:attach-point :n)
   (:grow-p NIL)
   (:final-function #'SLIDE-FINAL-FN))


;;  Tell the world that GAD-scroll-parts has been loaded
;;
#-release-garnet(setf (get :garnet-modules :GAD-scroll-parts) T)
#-release-garnet(provide 'GAD-scroll-parts)

;;  All other dependent "parts" modules must be reloaded
;;
;(setf (get :garnet-modules :GAD-slider-parts) NIL)
;(setf (get :garnet-modules :GAD-h-boxes) NIL)
;(setf (get :garnet-modules :GAD-v-boxes) NIL)

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/GAD-slider-parts.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;;  GAD-slider-parts
;;;
;;;  This module is a collection of schema definitions required by the trill
;;;  device and all sliders.
;;;
;;;  Written by Andrew Mickish
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

;;;  CHANGE LOG:
;;;  01/18/90  Andrew Mickish - Changed :active slot of VALUE-INTER to consider
;;;            :scroll-p of top-level object
;;;  02/24/90  Andrew Mickish - Removed :visible slots from VALUE-RECT and
;;;            VALUE-TEXT
;;;  03/01/90  Andrew Mickish - Removed :draw-function slot from VALUE-TEXT
;;;  06/16/90  Andrew Mickish - Condensed SET-POSITION
;;;  07/01/90  Andrew Mickish - Removed :cursor-index from VALUE-TEXT and put
;;;            distinct values in instances.
;;;  11/30/90  Pavan Reddy - changed :string slot of VALUE-TEXT to support
;;;            floating-point numbers.

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))


;;;  Set-Position is used to update the top level :value slot when the
;;;  position of the slider has been changed by direct editing of the
;;;  value text.
;;;
(defun SET-POSITION (interactor cur-text-obj stop-event)
  (declare (ignore cur-text-obj stop-event))

  ; Turn off cursor
  (s-value (g-value (g-value interactor :operates-on) :value-text)
	   :cursor-index
	   NIL)

  ; Check to see that the string is convertable to a number.
  (let* ((parent (g-value interactor :operates-on :parent))
	 (string (g-value interactor :operates-on :value-text :string))
	 (symbol (read-from-string string))
	 (number (when (numberp symbol) symbol)))

    ; If the string was a valid number, then set the :value slot to the
    ; value just calculated and execute the :selection-function.
    ; Else, mark the current :value as changed in order to cause
    ; the old value to be redisplayed and sound the buzzer.
    (if number
	(let* ((val-1 (g-value parent :val-1))
	       (val-2 (g-value parent :val-2))
	       (new-value (cond ((and val-1 val-2)
				 (inter:Clip-and-Map number val-1 val-2))
				((and val-1 (not val-2))
				 (if (> number val-1)
				     (if (integerp val-1) (round number) number)
				     val-1))
				((and (not val-1) val-2)
				 (if (< number val-2)
				     (if (integerp val-2) (round number) number)
				     val-2))
				(t number))))
	  (s-value parent :value new-value)
	  (kr-send parent :selection-function parent new-value))
	(inter::beep))
    (mark-as-changed parent :value)))

;;;
;;;  OBJECTS USED TO REPORT SLIDER POSITION
;;;

(create-instance 'VALUE-RECT opal:rectangle
   (:left (o-formula (gv (path 0 :parent) :left)))
   (:top (o-formula (gv (path 0 :parent) :top)))
   (:width (o-formula (gv (path 0 :parent) :width)))
   (:height (o-formula (gv (path 0 :parent) :height))))
      

(create-instance 'VALUE-TEXT opal:cursor-text
   (:string (o-formula (let ((p (path 0 :parent :parent)))
			 (format NIL (gv p :format-string) (gv p :value)))))
   (:left (o-formula (- (+ (gv (path 0 :parent) :left)
			   (floor (gv (path 0 :parent) :width) 2))
			(floor (gvl :width) 2))))
   (:top (o-formula (- (+ (gv (path 0 :parent) :top)
			  (floor (gv (path 0 :parent) :height) 2))
		       (floor (gvl :height) 2))))
   (:font (o-formula (gv (path 0 :parent) :font))))


(create-instance 'VALUE-INTER inter:Text-Interactor
   (:window (o-formula (gv-local :self :operates-on :window)))
   (:start-where (o-formula (list :in-box (gvl :operates-on :value-rect))))
   (:start-event :leftdown)
   (:stop-event #\RETURN)
   (:feedback-obj (o-formula (gvl :operates-on :value-text)))
   (:active (o-formula (and (gvl :operates-on :visible)
			    (gvl :operates-on :parent :scroll-p))))
   (:stop-action #'SET-POSITION))


;;  Tell the world that GAD-slider-parts has been loaded
;;
;(setf (get :garnet-modules :GAD-slider-parts) T)
#-release-garnet(provide 'GAD-slider-parts)

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/GAD-v-arrows.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

;;;
;;;  GAD-v-arrows
;;;
;;;  This module is a collection of schemata definitions required by vertical
;;;  sliders and veritcal scroll bars.
;;;
;;;  Written by Andrew Mickish

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

;;;
;;;  VERTICAL SINGLE TRILL ARROWS
;;;

(create-instance 'UP-ARROW opal:polyline
   (:visible (o-formula (gv (path 0 :parent) :visible)))
   (:width (o-formula (gv (path 0 :parent) :width)))
   (:width/7 (o-formula (round (gvl :width) 7)))
   (:width/3 (o-formula (round (gvl :width) 3)))
   (:width/2 (o-formula (round (gvl :width) 2)))
   (:bottom (o-formula (+ (gv (path 0 :parent) :top)
			  (gv (path 0 :parent) :height))))
   (:right (o-formula (+ (gv (path 0 :parent) :left)
			 (gv (path 0 :parent) :width))))
   (:x1 (o-formula (+ (gv (path 0 :parent) :left) (gvl :width/2))))
   (:y1 (o-formula (+ (gv (path 0 :parent) :top) (gvl :width/7))))
   (:x2 (o-formula (+ (gv (path 0 :parent) :left) (gvl :width/7))))
   (:y2 (o-formula (+ (gv (path 0 :parent) :top) (gvl :width/2))))
   (:x3 (o-formula (+ (gv (path 0 :parent) :left) (gvl :width/3))))
   (:y3 (o-formula (gvl :y2)))
   (:x4 (o-formula (gvl :x3)))
   (:y4 (o-formula (- (gvl :bottom) (gvl :width/7))))
   (:x5 (o-formula (- (gvl :right) (gvl :width/3))))
   (:y5 (o-formula (gvl :y4)))
   (:x6 (o-formula (gvl :x5)))
   (:y6 (o-formula (gvl :y3)))
   (:x7 (o-formula (- (gvl :right) (gvl :width/7))))
   (:y7 (o-formula (gvl :y2)))
   (:x8 (o-formula (gvl :x1)))
   (:y8 (o-formula (gvl :y1)))
   (:point-list (o-formula (list
			   (gvl :x1) (gvl :y1) (gvl :x2) (gvl :y2)
			   (gvl :x3) (gvl :y3) (gvl :x4) (gvl :y4)
			   (gvl :x5) (gvl :y5) (gvl :x6) (gvl :y6)
			   (gvl :x7) (gvl :y7) (gvl :x8) (gvl :y8)))))


(create-instance 'DOWN-ARROW up-arrow
   (:y1 (o-formula (- (gvl :bottom) (gvl :width/7))))
   (:y2 (o-formula (- (gvl :bottom) (gvl :width/2))))
   (:y4 (o-formula (+ (gv (path 0 :parent) :top) (gvl :width/7)))))


;;;
;;;  VERTICAL DOUBLE PAGE ARROWS
;;;

(create-instance 'PAGE-UP-ARROWHEAD opal:polyline
   (:right (o-formula (+ (gv (path 0 :parent) :left)
			 (gv (path 0 :parent) :width))))
   (:width (o-formula (gv (path 0 :parent) :width)))
   (:width/7 (o-formula (round (gvl :width) 7)))
   (:width/5 (o-formula (round (gvl :width) 5)))
   (:width/3 (o-formula (round (gvl :width) 3)))
   (:width/2 (o-formula (round (gvl :width) 2)))
   (:x1 (o-formula (+ (gv (path 0 :parent) :left) (gvl :width/2))))
   (:y1 (o-formula (gvl :y-origin)))
   (:x2 (o-formula (+ (gv (path 0 :parent) :left) (gvl :width/7))))
   (:y2 (o-formula (+ (gvl :y1) (gvl :width/3))))
   (:x3 (o-formula (- (gvl :right) (gvl :width/7))))
   (:y3 (o-formula (gvl :y2)))
   (:point-list (o-formula (list
			   (gvl :x1) (gvl :y1) (gvl :x2) (gvl :y2)
			   (gvl :x3) (gvl :y3) (gvl :x1) (gvl :y1))))
   (:filling-style opal:white-fill)
   (:visible (o-formula (gv (path 0 :parent) :visible))))

(create-instance 'PAGE-DOWN-ARROWHEAD page-up-arrowhead
   (:y2 (o-formula (- (gvl :y1) (gvl :width/3)))))

(create-instance 'PAGE-UP-ARROW opal:aggregadget
   (:left (o-formula (gv (path 0 :parent) :left)))
   (:top (o-formula (gv (path 0 :parent) :top)))
   (:width (o-formula (gv (path 0 :parent) :width)))
   (:visible (o-formula (gv (path 0 :parent) :visible)))
   (:parts
    `((:top-arrowhead ,page-up-arrowhead
		      (:y-origin ,(o-formula (+ (gv (path 0 :parent) :top)
						(gvl :width/5)))))
      (:bot-arrowhead ,page-up-arrowhead
		      (:y-origin ,(o-formula (+ (gv (path 0 :parent) :top)
						(* 2 (gvl :width/5)))))))))

(create-instance 'PAGE-DOWN-ARROW opal:aggregadget
   (:left (o-formula (gv (path 0 :parent) :left)))
   (:bottom (o-formula (+ (gv (path 0 :parent) :top)
			  (gv (path 0 :parent) :height))))
   (:width (o-formula (gv (path 0 :parent) :width)))
   (:visible (o-formula (gv (path 0 :parent) :visible)))
   (:parts
    `((:top-arrowhead ,page-down-arrowhead
		      (:y-origin ,(o-formula (- (gv (path 0 :parent) :bottom)
						(gvl :width/5)))))
      (:bot-arrowhead ,page-down-arrowhead
		      (:y-origin ,(o-formula (- (gv (path 0 :parent) :bottom)
						(* 2 (gvl :width/5)))))))))


;;  Tell the world that GAD-v-arrows has been loaded
;;
  #-release-garnet(setf (get :garnet-modules :GAD-v-arrows) T)
  #-release-garnet(provide 'GAD-v-arrows)

;;  All other dependent "parts" modules must be reloaded
;;
  #-release-garnet(setf (get :garnet-modules :GAD-v-boxes) NIL)

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/GAD-v-boxes.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;;  GAD-v-boxes
;;;
;;;  This module is a collection of schemata definitions required by vertical
;;;  sliders and veritcal scroll bars.
;;;
;;;  Written by Andrew Mickish
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

;;;  CHANGE LOG:
;;;
;;;  Andrew Mickish - Changed :visible slots of TOP-SCR-TRILL, BOT-SCR-TRILL,
;;;                   TOP-PAGE-TRILL, and BOT-PAGE-TRILL to consider :visible
;;;                   slot of :parent.

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))


(create-instance 'TOP-SCR-TRILL opal:aggregadget
   (:left (o-formula (gv (path 0 :parent) :trill-box-left)))
   (:top (o-formula (gv (path 0 :parent) :top-scr-top)))
   (:width (o-formula (gv (path 0 :parent) :bound-width)))
   (:height (o-formula (gv (path 0 :parent) :trill-height)))
   (:visible (o-formula (and (gv (path 0 :parent) :scr-trill-p)
			     (gv (path 0 :parent) :visible))))
   (:inc-by (o-formula (gv (path 0 :parent) :scr-incr)))
   (:parts
    `((:frame ,trill-frame)
      (:arrow ,up-arrow)))
   (:interactors
    `((:trill ,trill-inter))))


(create-instance 'BOT-SCR-TRILL opal:aggregadget
   (:left (o-formula (gv (path 0 :parent) :trill-box-left)))
   (:top (o-formula (gv (path 0 :parent) :bot-scr-top)))
   (:width (o-formula (gv (path 0 :parent) :bound-width)))
   (:height (o-formula (gv (path 0 :parent) :trill-height)))
   (:inc-by (o-formula (gv (path 0 :parent) :scr-incr)))
   (:visible (o-formula (and (gv (path 0 :parent) :scr-trill-p)
			     (gv (path 0 :parent) :visible))))
   (:parts
    `((:frame ,trill-frame)
      (:arrow ,down-arrow)))
   (:interactors
    `((:trill ,trill-inter
	      (:start-action VAL-2-FN)))))


(create-instance 'TOP-PAGE-TRILL opal:aggregadget
   (:left (o-formula (gv (path 0 :parent) :trill-box-left)))
   (:top (o-formula (gv (path 0 :parent) :top-page-top)))
   (:width (o-formula (gv (path 0 :parent) :bound-width)))
   (:height (o-formula (gv (path 0 :parent) :trill-height)))
   (:inc-by (o-formula (gv (path 0 :parent) :page-incr)))
   (:visible (o-formula (and (gv (path 0 :parent) :page-trill-p)
			     (gv (path 0 :parent) :visible))))
   (:parts
    `((:frame ,trill-frame)
      (:arrow ,page-up-arrow)))
   (:interactors
    `((:trill ,trill-inter))))


(create-instance 'BOT-PAGE-TRILL opal:aggregadget
   (:left (o-formula (gv (path 0 :parent) :trill-box-left)))
   (:top (o-formula (gv (path 0 :parent) :bot-page-top)))
   (:width (o-formula (gv (path 0 :parent) :bound-width)))
   (:height (o-formula (gv (path 0 :parent) :trill-height)))
   (:inc-by (o-formula (gv (path 0 :parent) :page-incr)))
   (:visible (o-formula (and (gv (path 0 :parent) :page-trill-p)
			     (gv (path 0 :parent) :visible))))
   (:parts
    `((:frame ,trill-frame)
      (:arrow ,page-down-arrow)))
   (:interactors
    `((:trill ,trill-inter
	      (:start-action VAL-2-FN)))))


;;  Tell the world that GAD-v-boxes has been loaded
;;
  #-release-garnet(setf (get :garnet-modules :GAD-v-boxes) T)
  #-release-garnet(provide 'GAD-v-boxes)

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/GAD-h-arrows.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;;  GAD-h-arrows
;;;
;;;  This module is a collection of schemata definitions required by horizontal
;;;  scroll bars, horizontal sliders, and the trill device.
;;;
;;;  Written by Andrew Mickish
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))


;;;
;;;  HORIZONTAL SINGLE TRILL ARROWS
;;;

(create-instance 'LEFT-ARROW opal:polyline
   (:visible (o-formula (gvl :parent :visible)))
   (:height (o-formula (gvl :parent :height)))
   (:height/7 (o-formula (round (gvl :height) 7)))
   (:height/3 (o-formula (round (gvl :height) 3)))
   (:height/2 (o-formula (round (gvl :height) 2)))
   (:bottom (o-formula (+ (gvl :parent :top)
			 (gvl :parent :height))))
   (:right (o-formula (+ (gvl :parent :left)
			(gvl :parent :width))))

   (:x1 (o-formula (+ (gvl :parent :left) (gvl :height/7))))
   (:y1 (o-formula (+ (gvl :parent :top) (gvl :height/2))))
   (:x2 (o-formula (+ (gvl :parent :left) (gvl :height/2))))
   (:y2 (o-formula (- (gvl :bottom) (gvl :height/7))))
   (:x3 (o-formula (gvl :x2)))
   (:y3 (o-formula (- (gvl :bottom) (gvl :height/3))))
   (:x4 (o-formula (- (gvl :right) (gvl :height/7))))
   (:y4 (o-formula (gvl :y3)))
   (:x5 (o-formula (gvl :x4)))
   (:y5 (o-formula (+ (gvl :parent :top) (gvl :height/3))))
   (:x6 (o-formula (gvl :x2)))
   (:y6 (o-formula (gvl :y5)))
   (:x7 (o-formula (gvl :x2)))
   (:y7 (o-formula (+ (gvl :parent :top) (gvl :height/7))))
   (:x8 (o-formula (gvl :x1)))
   (:y8 (o-formula (gvl :y1)))
   (:point-list (o-formula (list
			   (gvl :x1) (gvl :y1) (gvl :x2) (gvl :y2)
			   (gvl :x3) (gvl :y3) (gvl :x4) (gvl :y4)
			   (gvl :x5) (gvl :y5) (gvl :x6) (gvl :y6)
			   (gvl :x7) (gvl :y7) (gvl :x8) (gvl :y8)))))


(create-instance 'RIGHT-ARROW left-arrow
   (:x1 (o-formula (- (gvl :right) (gvl :height/7))))
   (:x2 (o-formula (- (gvl :right) (gvl :height/2))))
   (:x4 (o-formula (+ (gvl :parent :left) (gvl :height/7)))))



;;;
;;;  HORIZONTAL DOUBLE PAGE ARROWS
;;;

(create-instance 'PAGE-LEFT-ARROWHEAD opal:polyline
   (:bottom (o-formula (+ (gvl :parent :top) (gvl :parent :height))))
   (:height (o-formula (gvl :parent :height)))
   (:height/7 (o-formula (round (gvl :height) 7)))
   (:height/5 (o-formula (round (gvl :height) 5)))
   (:height/3 (o-formula (round (gvl :height) 3)))
   (:height/2 (o-formula (round (gvl :height) 2)))
   (:x1 (o-formula (gvl :x-origin)))
   (:y1 (o-formula (+ (gvl :parent :top) (gvl :height/2))))
   (:x2 (o-formula (+ (gvl :x1) (gvl :height/3))))
   (:y2 (o-formula (+ (gvl :parent :top) (gvl :height/7))))
   (:x3 (o-formula (gvl :x2)))
   (:y3 (o-formula (- (gvl :bottom) (gvl :height/7))))
   (:point-list (o-formula (list
			   (gvl :x1) (gvl :y1) (gvl :x2) (gvl :y2)
			   (gvl :x3) (gvl :y3) (gvl :x1) (gvl :y1))))
   (:filling-style opal:white-fill)
   (:visible (o-formula (gvl :parent :visible))))

(create-instance 'PAGE-RIGHT-ARROWHEAD page-left-arrowhead
   (:x2 (o-formula (- (gvl :x1) (gvl :height/3)))))

(create-instance 'PAGE-LEFT-ARROW opal:aggregadget
   (:left (o-formula (gvl :parent :left)))
   (:top (o-formula (gvl :parent :top)))
   (:height (o-formula (gvl :parent :height)))
   (:visible (o-formula (gvl :parent :visible)))
   (:parts
    `((:left-arrowhead ,page-left-arrowhead
		      (:x-origin ,(o-formula (+ (gvl :parent :left)
						(gvl :height/5)))))
      (:right-arrowhead ,page-left-arrowhead
			(:x-origin ,(o-formula (+ (gvl :parent :left)
						  (* 2 (gvl :height/5)))))))))

(create-instance 'PAGE-RIGHT-ARROW opal:aggregadget
   (:left (o-formula (gvl :parent :left)))
   (:top (o-formula (gvl :parent :top)))
   (:right (o-formula (+ (gvl :parent :left) (gvl :parent :width))))
   (:height (o-formula (gvl :parent :height)))
   (:visible (o-formula (gvl :parent :visible)))
   (:parts
    `((:right-arrowhead ,page-right-arrowhead
		      (:x-origin ,(o-formula (- (gvl :parent :right)
						(gvl :height/5)))))
      (:left-arrowhead ,page-right-arrowhead
		      (:x-origin ,(o-formula (- (gvl :parent :right)
						(* 2 (gvl :height/5)))))))))


;;  Tell the world that GAD-h-arrows has been loaded
;;
#-release-garnet(setf (get :garnet-modules :GAD-h-arrows) T)
#-release-garnet(provide 'GAD-h-arrows)

;;  All other dependent "parts" modules must be reloaded
;;
#-release-garnet(setf (get :garnet-modules :GAD-h-boxes) NIL)

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/GAD-h-boxes.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;;  GAD-h-boxes
;;;
;;;  This module is a collection of schemata definitions required by horizontal
;;;  scroll bars, horizontal sliders, and the trill device.
;;;
;;;  Written by Andrew Mickish
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

;;;  CHANGE LOG:
;;;
;;;  Andrew Mickish - Changed :visible slots of LEFT-SCR-TRILL,
;;;                   RIGHT-SCR-TRILL, LEFT-PAGE-TRILL, and RIGHT-PAGE-TRILL
;;;                   to consider :visible slot of :parent.

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))


(create-instance 'LEFT-SCR-TRILL opal:aggregadget
   (:top (o-formula (gv (path 0 :parent) :trill-box-top)))
   (:left (o-formula (gv (path 0 :parent) :left-scr-left)))
   (:height (o-formula (gv (path 0 :parent) :bound-height)))
   (:width (o-formula (gv (path 0 :parent) :trill-width)))
   (:visible (o-formula (and (gv (path 0 :parent) :scr-trill-p)
			     (gv (path 0 :parent) :visible))))
   (:inc-by (o-formula (gv (path 0 :parent) :scr-incr)))
   (:parts
    `((:frame ,trill-frame)
      (:arrow ,left-arrow)))
   (:interactors
    `((:trill ,trill-inter))))


(create-instance 'RIGHT-SCR-TRILL opal:aggregadget
   (:top (o-formula (gv (path 0 :parent) :trill-box-top)))
   (:left (o-formula (gv (path 0 :parent) :right-scr-left)))
   (:height (o-formula (gv (path 0 :parent) :bound-height)))
   (:width (o-formula (gv (path 0 :parent) :trill-width)))
   (:inc-by (o-formula (gv (path 0 :parent) :scr-incr)))
   (:visible (o-formula (and (gv (path 0 :parent) :scr-trill-p)
			     (gv (path 0 :parent) :visible))))
   (:parts
    `((:frame ,trill-frame)
      (:arrow ,right-arrow)))
   (:interactors
    `((:trill ,trill-inter
	      (:start-action VAL-2-FN)))))


(create-instance 'LEFT-PAGE-TRILL opal:aggregadget
   (:top (o-formula (gv (path 0 :parent) :trill-box-top)))
   (:left (o-formula (gv (path 0 :parent) :left-page-left)))
   (:height (o-formula (gv (path 0 :parent) :bound-height)))
   (:width (o-formula (gv (path 0 :parent) :trill-width)))
   (:inc-by (o-formula (gv (path 0 :parent) :page-incr)))
   (:visible (o-formula (and (gv (path 0 :parent) :page-trill-p)
			     (gv (path 0 :parent) :visible))))
   (:parts
    `((:frame ,trill-frame)
      (:arrow ,page-left-arrow)))
   (:interactors
    `((:trill ,trill-inter))))


(create-instance 'RIGHT-PAGE-TRILL opal:aggregadget
   (:top (o-formula (gv (path 0 :parent) :trill-box-top)))
   (:left (o-formula (gv (path 0 :parent) :right-page-left)))
   (:height (o-formula (gv (path 0 :parent) :bound-height)))
   (:width (o-formula (gv (path 0 :parent) :trill-width)))
   (:inc-by (o-formula (gv (path 0 :parent) :page-incr)))
   (:visible (o-formula (and (gv (path 0 :parent) :page-trill-p)
			     (gv (path 0 :parent) :visible))))
   (:parts
    `((:frame ,trill-frame)
      (:arrow ,page-right-arrow)))
   (:interactors
    `((:trill ,trill-inter
	      (:start-action VAL-2-FN)))))


;;  Tell the world that GAD-h-boxes has been loaded
;;
#-release-garnet(setf (get :garnet-modules :GAD-h-boxes) T)
#-release-garnet(provide 'GAD-h-boxes)








;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/v-scroll-loader.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;; 
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;  V-SCROLL-LOADER:  Loads the gadgets module "v-scroll-bar" and
;;;                    "parts" modules if required.

#|
==================================================================
Change log:
   03/22/90 Robert Cook - Define the package "GARNET-GADGETS"
                          for the TI Explorer
   01/30/90 Andrew Mickish - Added check before loading v-scroll-loader
   10/19/89 Andrew Mickish - Created
==================================================================
|#

(in-package "USER" :use '("LISP"))

;(setf *load-verbose* t)
;
;;; check first to see if place is set
;(unless (boundp 'Garnet-Gadgets-PathName)
;  (error "Load 'Garnet-Loader' first to set Garnet-Gadgets-PathName before
;  loading Gadgets."))
;
;;;; Load Aggregadgets unless already loaded (this will load others if necessary)
;#+cmu
;(unless (get :garnet-modules :aggregadgets)
;  (load Garnet-Aggregadgets-Loader))
;#+(not cmu)
;(require 'aggregadgets Garnet-Aggregadgets-Loader)
;
;#+explorer
;(unless (find-package "GARNET-GADGETS")
;  (make-package "GARNET-GADGETS" :use '("LISP" "KR")))
;
;
;(unless (get :garnet-modules :v-scroll-bar)
;  (format t "Loading V-Scroll-Bar...~%")
;  (dolist (pair '((:GAD-scroll-parts "GAD-scroll-parts")
;                  (:GAD-v-arrows "GAD-v-arrows")
;                  (:GAD-v-boxes "GAD-v-boxes")
;                  (:v-scroll-bar "v-scroll-bar")))
;    (unless (get :garnet-modules (car pair))
;      (load (merge-pathnames (cadr pair)
;                             #+cmu "gadgets:"
;                             #+(not cmu) Garnet-Gadgets-PathName)
;            :verbose T)))
;  (format t "...Done V-Scroll-Bar.~%"))
;
;
;(setf (get :garnet-modules :v-scroll-bar) t)
;(provide 'v-scroll-bar)


;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/h-scroll-loader.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;; 
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;;  H-SCROLL-LOADER:  Loads the module "h-scroll-bar" and "parts"
;;;                    modules if necessary

#|
==================================================================
Change log:
    03/22/90 Robert Cook - Define the package "GARNET-GADGETS"
                           for the TI Explorer
    01/30/89 Andrew Mickish - Added check before loading h-scroll-bar
    10/19/89 Andrew Mickish - Created
==================================================================
|#

(in-package "USER" :use '("LISP"))

(setf *load-verbose* t)

;;; check first to see if place is set
;(unless (boundp 'Garnet-Gadgets-PathName)
;  (error "Load 'Garnet-Loader' first to set Garnet-Gadgets-PathName before
;  loading Gadgets."))
;
;;;; Load Aggregadgets unless already loaded (this will load others if necessary)
;#+cmu
;(unless (get :garnet-modules :aggregadgets)
;  (load Garnet-Aggregadgets-Loader))
;#+(not cmu)
;(require 'aggregadgets Garnet-Aggregadgets-Loader)
;
;#+explorer
;(unless (find-package "GARNET-GADGETS")
;  (make-package "GARNET-GADGETS" :use '("LISP" "KR")))
;
;
;(unless (get :garnet-modules :h-scroll-bar)
;  (format t "Loading H-Scroll-Bar...~%")
;  (dolist (pair '((:GAD-scroll-parts "GAD-scroll-parts")
;		  (:GAD-h-arrows "GAD-h-arrows")
;		  (:GAD-h-boxes "GAD-h-boxes")
;		  (:h-scroll-bar "h-scroll-bar")))
;    (unless (get :garnet-modules (car pair))
;      (load (merge-pathnames (cadr pair)
;			     #+cmu "gadgets:"
;			     #+(not cmu) Garnet-Gadgets-PathName)
;	    :verbose T)))
;  (format t "...Done H-Scroll-Bar.~%"))
;
;
;(setf (get :garnet-modules :h-scroll-bar) t)
(provide 'h-scroll-bar)

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/v-scroll-bar.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;  Vertical scroll bar
;;;
;;;  Features and operation of the vertical scroll bar:
;;;     1)  Drag the indicator with the left mouse button
;;;     2)  Click the left mouse button in the scroll bar background to cause
;;;         the indicator to jump to mouse location
;;;     3)  Click the left mouse button in the trill boxes to move the
;;;         indicator by :scr-incr and :page-incr increments
;;;     4)  Text centered in the indicator changes to reflect new indicator
;;;         position
;;;     5)  The top level :value slot is the position of the indicator.
;;;         This slot may be set directly and formulae may depend on it.
;;;     6)  The function specified in :selection-function will be executed
;;;         when the :values slot changes.
;;;
;;;  Customizable slots:
;;;     1)  Left, top, height
;;;     2)  Min-width --  Will be overridden by the value calculated in
;;;                       :indicator-width if the width of the text in the
;;;                       indicator exceeds this width
;;;     3)  Scr-trill-p  --  Whether to have single arrow trill boxes that
;;;                          increment by :scr-incr
;;;     4)  Page-trill-p --  Whether to have double arrow trill boxes that
;;;                          increment by :page-incr
;;;     5)  Indicator-text-p -- Whether to report indicator position numerically
;;;                             inside the indicator
;;;     6)  Int-feedback-p  --  Whether to follow mouse with thick outline box
;;;                             instead of with indicator directly
;;;     7)  Val-1, Val-2  --  Range of values the indicator spans.
;;;                           Val-1 corresponds to the top of the scroll bar.
;;;     8)  Scr-Incr  --  Value to increment position by in single arrow box
;;;     9)  Page-incr  --  Value to increment postion by in double arrow box
;;;    10)  Value -- The current value chosen by the user
;;;    11)  Scroll-p -- Whether to allow scrolling
;;;    12)  Selection-function -- Function executed whenever :value changes
;;;    13)  Indicator-font -- Font to report indicator position with
;;;    14)  Format-string -- formatting string of indicator value
;;;
;;;  NOTE:  This module requires schemata defined in GAD-scroll-parts,
;;;         GAD-v-arrows, and GAD-v-boxes.
;;;
;;;  Vertical scroll bar demo:
;;;     This module contains a function which creates a window and a scroll bar
;;;     in the window.  To run it, enter (GARNET-GADGETS:v-scroll-go).
;;;     To stop, enter (GARNET-GADGETS:v-scroll-stop).
;;;
;;;  Designed by Brad Myers
;;;  Written by Andrew Mickish

;;;  CHANGE LOG:
;;;  01/18/90  Andrew Mickish - Changed :box of V-INDICATOR-BOX to '(0 0 0 0),
;;;     Added :scroll-p slot to V-SCROLL-BAR, changed :filling-style in
;;;     BOUNDING-AREA component of V-SCROLL-BAR, added :visible slot to
;;;     V-INDICATOR-BOX.
;;;  07/01/90  Andrew Mickish - Removed :box from V-INDICATOR-BOX and placed
;;;     distinct values in each instance instead.  Changed :visible slot of
;;;     :INT-FEEDBACK to depend on local :obj-over.
;;;  08/01/90  Pavan Reddy - fixed divide-by-zero error that occurs when
;;;     :val-1 and :val-2 slots of V-SCROLL-BAR are equal.  Fix contributed
;;;     by Rod Williams.
;;;  11/30/90  Pavan Reddy - added use of :format-string slot so floats work.
;;;  

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

(export '(V-Scroll-Bar
	 ; V-Scroll-Go V-Scroll-Stop V-Scroll-Obj
))


;;;
;;; VERTICAL INDICATOR BOX
;;;

(create-instance 'V-INDICATOR-BOX opal:rectangle
   (:top (o-formula (let ((p (path 0 :parent)))
		      (if (/= (gv p :val-1) (gv p :val-2))
			  (inter:Clip-and-Map (gv p :value)
					      (gv p :val-1) (gv p :val-2)
					      (gv p :bound-top)
					      (- (gv p :bound-bottom)
						 (gvl :height)))
			  (opal:gv-center-y-is-center-of (gv p))))))
   (:left (o-formula (+ 1 (gv (path 0 :parent) :left))))
   (:width (o-formula (- (gv (path 0 :parent) :bound-width) 2)))
   (:height (o-formula (gvl :width)))
   (:filling-style opal:white-fill)
   (:visible (o-formula (let ((p (path 0 :parent)))
			  (and (gv p :scroll-p)
			       (/= (gv p :val-1) (gv p :val-2)))))))

;;;
;;; TOP LEVEL AGGREGADGET
;;;

(create-instance 'V-SCROLL-BAR opal:aggregadget

   ;; Customizable slots
   ;;
   (:left 0)(:top 0)(:height 250)
   (:min-width 20)   ; Overridden by :indicator-width if indicator-text
                     ; doesn't fit.  
   (:val-1 0)
   (:val-2 100)
   (:scr-trill-p T)
   (:page-trill-p T)
   (:indicator-text-p T)
   (:page-incr 5)
   (:scr-incr 1)
   (:int-feedback-p T)
   (:scroll-p T)
   (:selection-function NIL)
   (:format-string "~a")
   (:indicator-font (create-instance NIL opal:font
				     (:size :small)))

   ;; Generally non-customizable slots
   ;;
   (:value (o-formula (inter:Clip-and-Map (second (gvl :indicator :box))
					  (gvl :bound-top)
					  (- (gvl :bound-bottom)
					     (gvl :indicator :height) 2)
					  (gvl :val-1)
					  (gvl :val-2))))
   (:widest-value-width
    (o-formula (max (opal:string-width (gvl :indicator-font)
				       (format NIL (gvl :format-string)
					       (gvl :val-1)))
		    (opal:string-width (gvl :indicator-font)
				       (format NIL (gvl :format-string)
					       (gvl :val-2))))))
   (:indicator-width (o-formula (if (gvl :indicator-text-p)
				     (gvl :widest-value-width)
				     0)))  ; zero ensures use of :min-width
   (:trill-height (o-formula (gvl :bound-width)))
   (:bottom (o-formula (+ (gvl :top) (gvl :height))))
   (:num-trills (o-formula (+ (if (gvl :scr-trill-p) 1 0)
			     (if (gvl :page-trill-p) 1 0))))
   (:trill-box-left (o-formula (gvl :left)))
   (:top-scr-top (o-formula (gvl :top)))
   (:top-page-top (o-formula (if (gvl :scr-trill-p)
				(+ (gvl :top) (gvl :trill-height))
				(gvl :top))))
   (:bot-page-top (o-formula (if (gvl :scr-trill-p)      ;; The top of the 
				(- (gvl :bottom)         ;; bottom page box
				   (* 2 (gvl :trill-height)))
				(- (gvl :bottom) (gvl :trill-height)))))
   (:bot-scr-top (o-formula (- (gvl :bottom) (gvl :trill-height))))
   (:bound-left (o-formula (gvl :left)))
   (:bound-top (o-formula (+ (gvl :top) (* (gvl :num-trills)
					  (gvl :trill-height)))))
   (:bound-bottom (o-formula (- (gvl :bottom) (* (gvl :num-trills)
						(gvl :trill-height)))))
   (:bound-height (o-formula (- (gvl :bound-bottom) (gvl :bound-top))))
   (:bound-width (o-formula (if (and (gvl :indicator-text-p)
				     (> (gvl :indicator-width)
					(gvl :min-width)))
				(gvl :indicator-width)
				(gvl :min-width))))

   (:parts
    `((:BOUNDING-AREA ,bound-box
		      (:filling-style
		       ,(o-formula (let ((p (path 0 :parent)))
				     (if (and (gv p :scroll-p)
					      (/= (gv p :val-1) (gv p :val-2)))
					 opal:gray-fill
					 opal:white-fill)))))
      (:TOP-SCR-TRILL ,top-scr-trill)
      (:BOT-SCR-TRILL ,bot-scr-trill)
      (:TOP-PAGE-TRILL ,top-page-trill)
      (:BOT-PAGE-TRILL ,bot-page-trill)
      (:INDICATOR ,v-indicator-box
          (:box (0 0 0 0)))
      (:INDICATOR-TEXT ,indicator-text)
      (:INT-FEEDBACK ,v-indicator-box
	  (:box (0 0 0 0))
	  (:top ,(o-formula (second (gvl :box))))
	  (:line-style ,opal:line-2)
	  (:filling-style NIL)
	  (:visible ,(o-formula (gv-local (gv :self) :obj-over))))))
   (:interactors
    `((:SLIDE ,slide-inter
	      (:attach-point :where-hit))
      (:JUMP ,jump-inter))))


#|

;;;
;;;  DEMO FUNCTION
;;;

(defparameter v-scroll-win NIL)
(defparameter v-scroll-top-agg NIL)
(defparameter v-scroll-obj NIL)

(defun V-Scroll-Go ()

  (create-instance 'v-scroll-win inter:interactor-window
		   (:left 700) (:top 10) (:width 200) (:height 300))

  (s-value v-scroll-win
	   :aggregate
	   (create-instance 'v-scroll-top-agg opal:aggregate
			    (:overlapping T)))

  (create-instance 'v-scroll-obj v-scroll-bar (:left 60) (:top 30))
  (opal:add-components v-scroll-top-agg v-scroll-obj)

  (format t "1)  Drag the indicator with the left mouse button.~%")
  (format t "2)  Click the left mouse button in the scroll bar background~%")
  (format t "    to cause the indicator to jump to mouse location.~%")
  (format t "3)  Click the left mouse button in the trill boxes to move the~%")
  (format t "    indicator by :scr-incr and :page-incr increments.~%")
  (format t "4)  Text centered in the indicator changes to reflect new~%")
  (format t "    indicator position.~%")

  (opal:update v-scroll-win))


(defun V-Scroll-Stop ()
  (opal:destroy v-scroll-win))

|#

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/h-scroll-bar.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;
;;;  Horizontal scroll bar
;;;
;;;  Features and operation of the horizontal scroll bar:
;;;     1)  Drag the indicator with the left mouse button
;;;     2)  Click the left mouse button in the scroll bar background to cause
;;;         the indicator to jump to mouse location
;;;     3)  Click the left mouse button in the trill boxes to move the
;;;         indicator by :scr-incr and :page-incr increments
;;;     4)  Text centered in the indicator changes to reflect new indicator
;;;         position
;;;     5)  The top level :value slot is the position of the indicator.
;;;         This slot may be set directly and formulae may depend on it.
;;;     6)  The function in :selection-function will be executed when the
;;;         :value slot is updated.
;;;
;;;  Customizable slots:
;;;     1)  Left, top, width
;;;     2)  Min-height -- Will be overridden by the value calculated in
;;;                       :indicator-height if the width of the text in
;;;                       the indicator exceeds this width (the indicator
;;;                       is constructed as a square)
;;;     3)  Scr-trill-p  --  Whether to have single arrow trill boxes that
;;;                          increment by :scr-incr
;;;     4)  Page-trill-p --  Whether to have double arrow trill boxes that
;;;                          increment by :page-incr
;;;     5)  Indicator-text-p -- Whether to report indicator position numerically
;;;                             inside the indicator
;;;     6)  Int-feedback-p  --  Whether to follow mouse with thick outline box
;;;                             instead of with indicator directly
;;;     7)  Val-1, Val-2  --  Range of values the indicator spans.
;;;                           Val-1 corresponds to the left of the scroll bar.
;;;     8)  Scr-Incr  --  Value to increment position by in single arrow box
;;;     9)  Page-incr  --  Value to increment postion by in double arrow box
;;;    10)  Value -- The value currently selected by the user
;;;    11)  Scroll-p -- Whether to allow scrolling
;;;    12)  Selection-function -- Function executed when :value changes
;;;    13)  Indicator-font -- Font to report indicator position with
;;;    14)  Format-string -- formatting string of indicator value
;;;
;;;  NOTE:  This module requires schemata defined in GAD-scroll-parts,
;;;         GAD-h-arrows, and GAD-h-boxes.
;;;
;;;  Horizontal scroll bar demo:
;;;     This module contains a function which creates a window and a scroll bar
;;;     in the window.  To run it, enter (GARNET-GADGETS:h-scroll-go).
;;;     To stop, enter (GARNET-GADGETS:h-scroll-stop).
;;;
;;;  Designed by Brad Myers
;;;  Written by Andrew Mickish

;;;  CHANGE LOG:
;;;  01/18/90  Andrew Mickish - Changed :box of H-INDICATOR-BOX to '(0 0 0 0),
;;;     Added :scroll-p slot to H-SCROLL-BAR, changed :filling-style in
;;;     BOUNDING-AREA component of H-SCROLL-BAR, added :visible slot to
;;;     H-INDICATOR-BOX.
;;;  07/01/90  Andrew Mickish - Removed :box from H-INDICATOR-BOX and placed
;;;     distinct values in each instance instead.  Changed :visible slot of
;;;     :INT-FEEDBACK to depend on local :obj-over.
;;;  08/01/90  Pavan Reddy - fixed divide-by-zero error that occurs when
;;;     :val-1 and :val-2 slots of H-SCROLL-BAR are equal.  Fix contributed
;;;     by Rod Williams.
;;;  11/30/90  Pavan Reddy - added use of :format-string slot so floats work.
;;;

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

(export '(H-Scroll-Bar
	;  H-Scroll-Go H-Scroll-Stop H-Scroll-Obj
))

;;;
;;; HORIZONTAL INDICATOR BOX
;;;

(create-instance 'H-INDICATOR-BOX opal:rectangle
   (:left (o-formula (let ((p (path 0 :parent)))
		       (if (/= (gv p :val-1) (gv p :val-2))
			   (inter:Clip-and-Map (gv p :value)
					       (gv p :val-1) (gv p :val-2)
					       (gv  p :bound-left)
					       (- (gv p :bound-right)
						  (gvl :width)))
			   (opal:gv-center-x-is-center-of (gv p))))))
   (:top (o-formula (+ 1 (gv (path 0 :parent) :top))))
   (:height (o-formula (- (gv (path 0 :parent) :bound-height) 2)))
   (:width (o-formula (gvl :height)))
   (:filling-style opal:white-fill)
   (:visible (o-formula (let ((p (path 0 :parent)))
			  (and (gv p :scroll-p)
			       (/= (gv p :val-1) (gv p :val-2)))))))

;;;
;;; TOP LEVEL AGGREGADGET
;;;

(create-instance 'H-SCROLL-BAR opal:aggregadget

   ;; Customizable slots
   ;;
   (:left 0)(:top 0)(:width 250)
   (:min-height 20)  ; Overridden by :indicator-height if indicator-text
                     ; doesn't fit.
   (:val-1 0)
   (:val-2 100)
   (:selection-function NIL)
   (:scr-trill-p T)
   (:page-trill-p T)
   (:indicator-text-p T)
   (:page-incr 5)
   (:scr-incr 1)
   (:int-feedback-p T)
   (:scroll-p T)
   (:format-string "~a")
   (:indicator-font (create-instance NIL opal:font
				     (:size :small)))

   ;; Generally non-customizable slots
   ;;
   (:value (o-formula (inter:Clip-and-Map (first (gvl :indicator :box))
					  (gvl :bound-left)
					  (- (gvl :bound-right)
					     (gvl :indicator :width) 2)
					  (gvl :val-1)
					  (gvl :val-2))))
   (:widest-value-width
    (o-formula (max (opal:string-width (gvl :indicator-font)
				       (format NIL (gvl :format-string)
					       (gvl :val-1)))
		    (opal:string-width (gvl :indicator-font)
				       (format NIL (gvl :format-string)
					       (gvl :val-2))))))
   (:indicator-height (o-formula (if (gvl :indicator-text-p)
				     (gvl :widest-value-width)
				     0)))  ; zero ensures use of :min-height
   (:trill-width (o-formula (gvl :bound-height)))
   (:right (o-formula (+ (gvl :left) (gvl :width))))
   (:num-trills (o-formula (+ (if (gvl :scr-trill-p) 1 0)
			     (if (gvl :page-trill-p) 1 0))))
   (:trill-box-top (o-formula (gvl :top)))
   (:left-scr-left (o-formula (gvl :left)))
   (:left-page-left (o-formula (if (gvl :scr-trill-p)
				(+ (gvl :left) (gvl :trill-width))
				(gvl :left))))
   (:right-page-left (o-formula (if (gvl :scr-trill-p)      ;; The left of the 
				    (- (gvl :right)         ;; right page box
				   (* 2 (gvl :trill-width)))
				(- (gvl :right) (gvl :trill-width)))))
   (:right-scr-left (o-formula (- (gvl :right) (gvl :trill-width))))
   (:bound-left (o-formula (+ (gvl :left) (* (gvl :num-trills)
					  (gvl :trill-width)))))
   (:bound-top (o-formula (gvl :top)))
   (:bound-width (o-formula (- (gvl :bound-right) (gvl :bound-left))))
   (:bound-height (o-formula (if (and (gvl :indicator-text-p)
				      (> (gvl :indicator-height)
					 (gvl :min-height)))
				 (gvl :indicator-height)
				 (gvl :min-height))))
   (:bound-right (o-formula (- (gvl :right) (* (gvl :num-trills)
					      (gvl :trill-width)))))

   (:parts
    `((:BOUNDING-AREA ,bound-box
		      (:filling-style
		       ,(o-formula (let ((p (path 0 :parent)))
				     (if (and (gv p :scroll-p)
					      (/= (gv p :val-1) (gv p :val-2)))
					 opal:gray-fill
					 opal:white-fill)))))
      (:LEFT-SCR-TRILL ,left-scr-trill)
      (:RIGHT-SCR-TRILL ,right-scr-trill)
      (:LEFT-PAGE-TRILL ,left-page-trill)
      (:RIGHT-PAGE-TRILL ,right-page-trill)
      (:INDICATOR ,h-indicator-box
          (:box (0 0 0 0)))
      (:INDICATOR-TEXT ,indicator-text)
      (:INT-FEEDBACK ,h-indicator-box
          (:box (0 0 0 0))
	  (:left ,(o-formula (first (gvl :box))))
	  (:line-style ,opal:line-2)
	  (:filling-style NIL)
	  (:visible ,(o-formula (gv-local (gv :self) :obj-over))))))
   (:interactors
    `((:SLIDE ,slide-inter
	      (:attach-point :where-hit))
      (:JUMP ,jump-inter
	     (:attach-point :w)))))


;;;
;;;  DEMO FUNCTION
;;;
;
;(defparameter h-scroll-win NIL)
;(defparameter h-scroll-top-agg NIL)
;(defparameter h-scroll-obj NIL)
;
;(defun H-Scroll-Go ()
;
;  (create-instance 'h-scroll-win inter:interactor-window
;     (:left 700) (:top 10) (:width 300) (:height 200))
;
;  (s-value h-scroll-win
;	   :aggregate
;	   (create-instance 'h-scroll-top-agg opal:aggregate
;	      (:overlapping T)))
;
;  (create-instance 'h-scroll-obj h-scroll-bar (:left 10) (:top 100))
;  (opal:add-components h-scroll-top-agg h-scroll-obj)
;
;  (format t "1)  Drag the indicator with the left mouse button.~%")
;  (format t "2)  Click the left mouse button in the scroll bar background~%")
;  (format t "    to cause the indicator to jump to mouse location.~%")
;  (format t "3)  Click the left mouse button in the trill boxes to move the~%")
;  (format t "    indicator by :scr-incr and :page-incr percent.~%")
;  (format t "4)  Text centered in the indicator changes to reflect new~%")
;  (format t "    indicator position.~%")
;
;  (opal:update h-scroll-win))
;
;
;(defun H-Scroll-Stop ()
;  (opal:destroy h-scroll-win))


;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/trill-device.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;  Trill Device
;;;
;;;  Features and operation of the trill device:
;;;     1)  Click the left mouse button in the trill boxes to change the value
;;;         by :scr-incr and :page-incr increments.
;;;     2)  Text inside the feedback box changes to indicate the current value
;;;     3)  The value text may be edited directly after clicking the left
;;;         mouse button on it.
;;;     4)  The top level :value slot is the currently chosen value.
;;;         This slot may be set directly and formulae may depend on it.
;;;
;;;  Customizable slots:
;;;     1)  Left, top
;;;     2)  Min-Frame-Width -- If :val-1 and :val-2 are both non-NIL, then this 
;;;                      slot is overridden if the width of the widest allowed
;;;                      feedback value is wider than this specified value
;;;                      (i.e., a fixed width is calculated).
;;;                      If either :val-1 or :val-2 are NIL, then this slot is
;;;                      overridden when the width of a feedback value exceeds
;;;                      this value (i.e., the width is dynamic).
;;;     2)  Min-height -- Overridden when the height of the text in the
;;;                       value feedback box is taller than this value
;;;     2)  Scr-trill-p  --  Whether to have trills that incr by :scr-incr
;;;     3)  Page-trill-p --  Whether to have trills that incr by :page-incr
;;;     4)  Scr-Incr, Page-incr  --  Values to increment position by in single
;;;                                    and double arrow boxes, respectively
;;;     5)  Val-1, Val-2  --  Range of values to be spanned.  Val-1 corresponds
;;;                           to the left side of the trill device.
;;;                           If val-1 is NIL, val-2 is max; there is no min.
;;;                           If val-2 is NIL, val-1 is min; there is no max.
;;;     6)  Value -- The currently selected value
;;;     7)  Selection-function -- Function called when :value changes
;;;     8)  Value-feedback-p  --  Whether to report the value in the value
;;;                               feedback box
;;;     9)  Value-feedback-font -- Font to report current value with
;;;    10)  Scroll-p -- Whether to allow the value to be changed
;;;    11)  Format-string -- formatting string for current value
;;;
;;;  NOTE:  This module requires schemata defined in GAD-scroll-parts,
;;;         GAD-slider-parts, GAD-h-arrows, and GAD-h-boxes.
;;;
;;;  Trill device demo:
;;;     This module contains a function which creates a window and a trill
;;;     device in the window.  To run it, enter (GARNET-GADGETS:trill-go).
;;;     To stop, enter (GARNET-GADGETS:trill-stop).
;;;
;;;  Designed by Brad Myers
;;;  Written by Andrew Mickish

;;;  CHANGE LOG:
;;;  01/30/90 Andrew Mickish - Added :scroll-p slot to TRILL-DEVICE
;;;  08/14/90 Pavan Reddy - changed use of "prin1-to-string" to "format" and
;;;           added a :format-string slot at the top level aggregadget for
;;;           formatting.  All this at the request of a user.
;;;  11/30/90 Pavan Reddy - moved use of "format" (vs "prin1-to-string") to
;;;           lower-level module (GAD-slider-parts).

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

(export '(Trill-Device
	;  Trill-Go Trill-Stop Trill-Obj
))


(create-instance 'DEVICE-FEEDBACK opal:aggregadget
   (:left (o-formula (gv (path 0 :parent) :value-feedback-left)))
   (:top (o-formula (gv (path 0 :parent) :top)))
   (:height (o-formula (gv (path 0 :parent) :value-feedback-height)))
   (:width (o-formula (gv (path 0 :parent) :value-feedback-width)))
   (:font (o-formula (gv (path 0 :parent) :value-feedback-font)))
   (:visible (o-formula (gv (path 0 :parent) :value-feedback-p)))
   (:parts
    `((:value-rect ,value-rect)
      (:value-text ,value-text)))
   (:interactors
    `((:value-inter ,value-inter))))


;;;
;;;  TOP LEVEL AGGREGADGET
;;;

(create-instance 'TRILL-DEVICE opal:aggregadget

   ;; Customizable slots
   ;;
   (:left 0)(:top 0)
   (:min-frame-width 20)
   (:min-height 20)
   (:scr-incr 1)
   (:page-incr 5)
   (:val-1 0)          ;; Range of values
   (:val-2 100)        ;;   :value may assume
   (:scr-trill-p T)
   (:page-trill-p T)
   (:scroll-p T)
   (:selection-function NIL)
   (:value-feedback-p T)
   (:format-string "~a")
   (:value-feedback-font opal:default-font)

   ;; Generally non-customizable slots
   ;;
   (:value 0)
   (:widest-value-width
    (o-formula (if (and (gvl :val-1) (gvl :val-2))
		   (max (opal:string-width (gvl :value-feedback-font)
					   (format NIL (gvl :format-string)
						   (gvl :val-1)))
			(opal:string-width (gvl :value-feedback-font)
					   (format NIL (gvl :format-string)
						   (gvl :val-2))))
		   (max (gvl :min-frame-width)
			(gvl :value-feedback :value-text :width)))))
   (:value-feedback-width (o-formula (if (gvl :value-feedback-p)
					 (+ 5 (gvl :widest-value-width))
					 0)))
   (:highest-value-height
    (o-formula (max (if (gvl :val-1)
			(opal:string-height (gvl :value-feedback-font)
					    (format NIL (gvl :format-string)
						    (gvl :val-1))
					    :actual-heightp T)
			0)
		    (if (gvl :val-2)
			(opal:string-height (gvl :value-feedback-font)
					    (format NIL (gvl :format-string)
						    (gvl :val-2))
					    :actual-heightp T)
			0)
		    (if (gvl :value)
			(opal:string-height (gvl :value-feedback-font)
					    (format NIL (gvl :format-string)
						    (gvl :value))
					    :actual-heightp T)
			0))))
   (:value-feedback-height
    (o-formula (if (gvl :value-feedback-p)
		   (max (gvl :min-height)
			(+ 2 (gvl :highest-value-height)))
		   (gvl :min-height))))
   (:value-feedback-left (o-formula (if (gvl :page-trill-p)
					(+ (gvl :left-page-left)
					   (gvl :trill-width))
					(gvl :left-page-left))))
   (:trill-width (o-formula (gvl :height)))
   (:num-trills (o-formula (+ (if (gvl :scr-trill-p) 1 0)
			     (if (gvl :page-trill-p) 1 0))))
   (:trill-box-top (o-formula (gvl :top)))
   (:left-scr-left (o-formula (gvl :left)))
   (:left-page-left (o-formula (if (gvl :scr-trill-p)
				   (+ (gvl :left-scr-left) (gvl :trill-width))
				   (gvl :left-scr-left))))
   (:right-page-left (o-formula (+ (gvl :value-feedback-left)
				   (gvl :value-feedback-width))))
   (:right-scr-left (o-formula (if (gvl :page-trill-p)
				   (+ (gvl :right-page-left) (gvl :trill-width))
				   (gvl :right-page-left))))
   (:bound-height (o-formula (gvl :value-feedback-height)))
   (:width (o-formula (+ (* 2 (gvl :num-trills) (gvl :trill-width))
			 (gvl :value-feedback-width))))
   (:height (o-formula (gvl :value-feedback-height)))
   (:parts
    `((:value-feedback ,device-feedback)      ; report value in box
      (:left-scr-trill ,left-scr-trill)
      (:right-scr-trill ,right-scr-trill)
      (:left-page-trill ,left-page-trill)
      (:right-page-trill ,right-page-trill))))



;;;
;;;  DEMO FUNCTION
;;;
;
;(defparameter trill-win NIL)
;(defparameter trill-top-agg NIL)
;(defparameter trill-obj NIL)
;
;(defun Trill-Go ()
;
;  (create-instance 'trill-win inter:interactor-window
;     (:left 650) (:top 10) (:width 350) (:height 200))
;
;  (s-value trill-win
;	   :aggregate
;	   (create-instance 'trill-top-agg opal:aggregate
;	      (:overlapping T)))
;				  
;  (create-instance 'trill-obj trill-device (:left 50) (:top 50))
;  (opal:add-components trill-top-agg trill-obj)
;
;  (opal:update trill-win))
;
;
;(defun Trill-Stop ()
;  (opal:destroy trill-win ))

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/GAD-button-parts.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;;  GAD-button-parts
;;;
;;;  This module contains definitions of schemata required for the button
;;;  items in the Garnet Gadgets.
;;;
;;;  This module must be loaded before any of the garnet button modules.
;;;
;;;  Written by Andrew Mickish
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

;;;
;;; Change log:
;;;
;;; 01/12/90: Andrew Mickish - Removed :visible slots of BUTTON-SHADOW-RECT
;;;           and BUTTON-SHADOW-CIRC.
;;; 02/26/90: Andrew Mickish - Removed :fixed-width-size and :fixed-height-size
;;;           from ITEMS-AGGLIST, set :fixed-width-p and :fixed-height-p to NIL
;;; 06/21/90: Andrew Mickish - Fixed :left slot of INSIDE-BUTTON-TEXT and
;;;           BESIDE-BUTTON-TEXT to consider value of :h-align
;;; 06/25/90: Andrew Mickish - Removed BUTTON-INV-CIRC
;;; 07/02/90: Andrew Mickish - Removed BUTTON-INV-RECT
;;; 07/04/90: Pavan Reddy - changed formulas for :top slot of GRAY-*-OUTLINE,
;;;           BUTTON-SHADOW-*, and *-BUTTON-TEXT for better centering
;;; 01/18/91: Andrew Mickish - Removed "path" from :direction formula of
;;;                            ITEMS-AGGLIST
;;;

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))


  #-release-garnet
(defun Report-Selection (top-level-obj string)
  (let ((value-obj (g-value top-level-obj :value-obj)))
    (format t "Item ~S selected with string ~S.~%" value-obj string)))


;;;  GRAY-RECT-OUTLINE:  This rectangle is laid on top of the shadow.
;;;  It will be partially covered by a white rectangle, giving the appearance
;;;  that this is just a gray border
;;;
(create-instance 'GRAY-RECT-OUTLINE opal:rectangle
   (:left (o-formula (gv (path 0 :parent) :floating-left)))
   (:top (o-formula (gv (path 0 :parent) :floating-top)))
   (:width (o-formula (gv (path 0 :parent) :button-width)))
   (:height (o-formula (gv (path 0 :parent) :button-height)))
   (:filling-style opal:gray-fill))


;;;  WHITE-RECT-FIELD:  This rectangle is laid on top of the gray rectangle,
;;;  leaving a gray border.
;;;
(create-instance 'WHITE-RECT-FIELD opal:rectangle
   (:left (o-formula (+ (gv (path 0 :parent) :floating-left)
			(gv (path 0 :parent) :gray-width))))
   (:top (o-formula (+ (gv (path 0 :parent) :floating-top)
		       (gv (path 0 :parent) :gray-width))))
   (:width (o-formula (- (gv (path 0 :parent) :button-width)
			 (* 2 (gv (path 0 :parent) :gray-width)))))
   (:height (o-formula (- (gv (path 0 :parent) :button-height)
			  (* 2 (gv (path 0 :parent) :gray-width)))))
   (:filling-style opal:white-fill))


;;;  BUTTON-SHADOW-RECT:  This black box is below all other objects, giving the
;;;  appearance that the button casts a shadow.
;;;
;(create-instance 'BUTTON-SHADOW-RECT opal:rectangle
;   (:left (o-formula (+ (gv (path 0 :parent) :button-left)
;                        (gv (path 0 :parent) :shadow-offset))))
;   (:top (o-formula (+ (gv (path 0 :parent) :button-top)
;                       (gv (path 0 :parent) :shadow-offset))))
;   (:width (o-formula (gv (path 0 :parent) :button-width)))
;   (:height (o-formula (gv (path 0 :parent) :button-height)))
;   (:filling-style opal:black-fill))

;;;  IN-BUTTON-TEXT:  This text object is laid on top of the white rectangle
;;; 
(create-instance 'IN-BUTTON-TEXT opal:text
   (:left (o-formula (opal:gv-center-x-is-center-of
		      (path 0 :parent :white-field))))
   (:top (o-formula (opal:gv-center-y-is-center-of
		     (path 0 :parent :white-field))))
   (:string (o-formula (let ((s (gv (path 0 :parent) :string)))
			 (if (stringp s)
			     s
			     (string-capitalize (string-trim ":" s))))))
   (:font (o-formula (gv (path 0 :parent) :font))))


;;;  BESIDE-BUTTON-TEXT:  This text object is placed either to the left or
;;;  the right of the button.
;;; 
(create-instance 'BESIDE-BUTTON-TEXT opal:text
   (:left (o-formula (let ((p (path 0 :parent)))
		       (if (gv p :text-on-left-p)
			   (gv p :left)
			   (+ (gv p :left) (gv p :button-unit-width)
			      (gv p :text-offset))))))
   (:top (o-formula (- (gv (path 0 :parent) :center-y)
		       (floor (gvl :height) 2))))
   (:string (o-formula (let ((s (gv (path 0 :parent) :string)))
			 (if (stringp s)
			     s
			     (string-capitalize (string-trim ":" s))))))
   (:font (o-formula (gv (path 0 :parent) :font))))


;;;  ITEMS-AGGLIST:  Generic aggrelist.  Note that all aggrelist slots must be
;;;  inherited in case the user specifies them.
;;;  Pitfall:  Be sure to put appropriate default values in the parent.
;;;
(create-instance 'ITEMS-AGGLIST opal:aggrelist
   (:left (o-formula (gv (path 0 :parent) :left)))
   (:top (o-formula (gv (path 0 :parent) :top)))
   (:direction (o-formula (gvl :parent :direction)))
   (:h-align (o-formula (gv (path 0 :parent) :h-align)))
   (:v-spacing (o-formula (gv (path 0 :parent) :v-spacing)))
   (:h-spacing (o-formula (gv (path 0 :parent) :h-spacing)))
   (:fixed-width-p NIL)
   (:fixed-height-p NIL)
   (:rank-margin (o-formula (gv (path 0 :parent) :rank-margin)))
   (:pixel-margin (o-formula (gv (path 0 :parent) :pixel-margin)))
   (:indent (o-formula (gv (path 0 :parent) :indent)))
   (:items (o-formula (gv (path 0 :parent) :items))))


; Declare that GAD-button-parts has been loaded
;
#-release-garnet(setf (get :garnet-modules :GAD-button-parts) T)
#-release-garnet(provide 'GAD-button-parts)

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/x-buttons.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;  X-Button-Panel
;;;
;;;  Features and operation of X-buttons:
;;;     1)  X-button-panel is a set of rectangular buttons with text on one
;;;         side.  Any number of buttons may be selected at one time.
;;;     2)  Click the left mouse button in a button to cause an X to be
;;;         superimposed on the button.
;;;     3)  The top level :value slot points to a list of the strings of the
;;;         currently selected buttons.
;;;     4)  The top level :value-obj slot points to the list of currently
;;;         selected buttons, and can be set directly with S-VALUE to select
;;;         a set of buttons.
;;;     5)  The :items slot may contain functions to be executed as each
;;;         button becomes selected, and :selection-function may contain a
;;;         function to be executed when any button becomes selected.
;;;
;;;  Customizable slots:
;;;     1)  All customizable slots of an aggrelist:
;;;            Direction -- :vertical or :horizontal
;;;            V-spacing -- distance between buttons, if vertical orientation
;;;            H-spacing -- same, if horizontal orientation
;;;            Fixed-width-p -- whether to put buttons in fields of constant
;;;                             width, specified in :fixed-width-size.
;;;            Fixed-height-p -- same, but with heights
;;;            Fixed-width-size -- width of all components (default is the
;;;                                width of the widest button)
;;;            Fixed-height-size -- same, but with heights 
;;;            H-align -- how to align buttons, if vertical orientation
;;;                       :left, :center, or :right
;;;            Rank-margin -- after this many components, a new row (or column)
;;;                           will be started
;;;            Pixel-margin -- absolute position in pixels after which a new
;;;                            row (or column) will be started
;;;            Indent -- amount to indent the new row (or column) in pixels
;;;     2)  Left, top, button-width, button-height
;;;     3)  Shadow-offset -- the amount of shadow that shows under the buttons
;;;     4)  Text-offset -- the distance from the text to the buttons
;;;     5)  Gray-width -- the width of the gray border on the buttons
;;;     6)  Font -- the font in which the button labels will appear
;;;     7)  Text-on-left-p -- whether text will appear on left side of buttons
;;;                           (NIL implies text will appear to the right)
;;;     8)  Items -- This can be: 
;;;                  A list of strings, as in '("Large" ...), or
;;;                  a list of atoms, as in '(:center ...), or
;;;                  a list of string/function pairs, '(("Cut" Cut-FN) ...), or
;;;                  a list of atom/function pairs, '((:center Center-FN) ...).
;;;                  Each function will be executed when the associated button
;;;                  becomes selected.  The parameters are the top-level
;;;                  GADGET and the ITEM-STRING.
;;;     9)  Selection-function -- Global function to be executed when any button
;;;                               is selected.  Parameters are the top-level
;;;                               GADGET and the ITEM-STRING.
;;;
;;;  NOTE:  This module requires several schemata defined in GAD-button-parts.
;;;         Thus, GAD-button-parts.fasl must be loaded before this module.
;;;
;;;  X-buttons demo:
;;;     This module contains a function which creates a window and a panel of
;;;     X-buttons.  To run it, enter (GARNET-GADGETS:x-buttons-go).  To stop,
;;;     enter (GARNET-GADGETS:x-buttons-stop).
;;;
;;;  Designed by Brad Myers
;;;  Written by Andrew Mickish

;;; CHANGE LOG:
;;; 01/30/90  Andrew Mickish -  Added :selected slot to X-BUTTON-LIST
;;;              so that :value of panel can be set directly.
;;; 07/02/90  Andrew Mickish - Converted circularity between :value and
;;;              :selected slot;  Now the final-function sets :value-obj which
;;;              propagates to :value and :selected.
;;; 07/03/90 Pavan Reddy - altered X-BUTTON and X-BUTTON-LIST prototypes
;;;              so single button instances can be created
;;; 07/04/90 Pavan Reddy - changed the font default to opal:default-font
;;;

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

(export '(X-Button X-Button-Panel
	;  X-Buttons-Go X-Buttons-Stop
	;  X-Buttons-Obj X-Buttons-Top-Agg X-Buttons-Win
))


(create-instance 'X-BUTTON opal:aggregadget
   (:left 0) (:top 0)
   (:button-width 20)
   (:button-height 20)
   (:shadow-offset 0) (:text-offset 5) (:gray-width 3)
   (:text-on-left-p T)
   (:string "X Button")
   (:font opal:default-font)
   (:selection-function NIL)

   (:value (o-formula (if (gvl :selected) (gvl :string))))
   (:selected (o-formula (gvl :value)))

   ;; modified from original 20-Nov-91 -fer
   (:floating-left (o-formula (gvl :button-left)))
   ;; modified from original 20-Nov-91 -fer
   (:floating-top (o-formula (gvl :button-top)))

   (:button-left (o-formula (if (gvl :text-on-left-p)
				(+ (gvl :left) (gvl :text-width)
				   (gvl :text-offset))
				(gvl :left))))
   (:button-top (o-formula (- (gvl :center-y)
			      (floor (gvl :button-unit-height) 2))))
   (:button-unit-width (o-formula (+ (gvl :button-width) (gvl :shadow-offset))))
   (:button-unit-height (o-formula (+ (gvl :button-height)
				      (gvl :shadow-offset))))
   (:text-width (o-formula (gvl :text :width)))
   (:width (o-formula (+ (gvl :text-width) (gvl :text-offset)
			 (gvl :button-unit-width))))
   (:height (o-formula (MAX (gvl :text :height)
			    (gvl :button-unit-height))))
   (:center-y (o-formula (+ (gvl :top)
			    (floor (gvl :height) 2))))
   (:parts
    `(;(:shadow ,BUTTON-SHADOW-RECT)
      (:gray-outline ,GRAY-RECT-OUTLINE)
      (:white-field ,WHITE-RECT-FIELD)
      (:text ,BESIDE-BUTTON-TEXT)
      (:feedback-obj ,opal:aggregadget
           (:left ,(o-formula (gv (path 0 :parent :white-field) :left)))
	   (:top ,(o-formula (gv (path 0 :parent :white-field) :top)))
	   (:width ,(o-formula (gv (path 0 :parent :white-field) :width)))
	   (:height ,(o-formula (- (gv (path 0 :parent :white-field) :height)
				   1)))
	   (:right ,(o-formula (+ (gvl :left) (gvl :width))))
	   (:bottom ,(o-formula (+ (gvl :top) (gvl :height))))
	   (:visible ,(o-formula (gv (path 0  :parent) :selected)))
	   (:parts
	    ((:neg-slope ,opal:line
		 (:x1 ,(o-formula (gv (path 0 :parent) :left)))
		 (:y1 ,(o-formula (gv (path 0 :parent) :top)))
		 (:x2 ,(o-formula (gv (path 0 :parent) :right)))
		 (:y2 ,(o-formula (gv (path 0 :parent) :bottom)))
		 (:line-style ,opal:line-2))
	     (:pos-slope ,opal:line
		 (:x1 ,(o-formula (gv (path 0 :parent) :left)))
		 (:y1 ,(o-formula (gv (path 0 :parent) :bottom)))
		 (:x2 ,(o-formula (gv (path 0 :parent) :right)))
		 (:y2 ,(o-formula (gv (path 0 :parent) :top)))
		 (:line-style ,opal:line-2)))))))

   (:interactors
    `((:x-button-press ,inter:button-interactor
	(:window ,(o-formula (gv-local :self :operates-on :window)))
	(:start-where ,(o-formula (list :in-box (gvl :operates-on))))
	(:how-set :toggle)
	(:final-function
	 ,#'(lambda (interactor button)
	      (declare (ignore interactor))
	      (let ((selected (g-value button :selected)))
	      ; Execute selection function
	      (kr-send button :selection-function button selected))))))))



(create-instance 'X-BUTTON-PANEL opal:aggregadget
   
   ;; Customizable slots
   ;;
   (:left 0) (:top 0)
   (:width (o-formula (gvl :x-button-list :width)))
   (:height (o-formula (gvl :x-button-list :height)))
   (:direction :vertical)
   (:v-spacing 5) (:h-spacing 5)
   (:h-align (o-formula (if (gvl :text-on-left-p) :right :left)))
   (:fixed-width-p T)
   (:fixed-width-size (o-formula (+ (gvl :x-button-list :tail
					 :max-text-width-thus-far)
				    (gvl :button-unit-width)
				    (gvl :text-offset))))
   (:fixed-height-p NIL)
   (:fixed-height-size (o-formula (MAX (gvl :x-button-list :head :text :height)
				       (gvl :button-unit-height))))
   (:indent 0)
   (:button-width 20)
   (:button-height 20)
   (:shadow-offset 0)
   (:text-offset 5)
   (:gray-width 3)
   (:text-on-left-p T)
   (:font opal:default-font)
   (:selection-function NIL)
   (:items '("X-label 1" "X-label 2" #-release-garnet"X-label 3"))

   (:value-obj NIL)
   (:value (o-formula (let ((obj-list (gvl :value-obj)))
			(if obj-list
			    (mapcar #'(lambda (object)
					(g-value object :string))
				    obj-list)))))

   (:actions-p (o-formula (listp (first (gvl :items)))))

   ;; modified from original 20-Nov-91 -fer
   (:button-unit-width (o-formula (gvl :button-width)))
   (:button-unit-height (o-formula (gvl :button-height)
				   ))

   (:parts
    `((:x-button-list ,ITEMS-AGGLIST
       (:selected
	,(o-formula
	  (let ((value-list (gv (path 0 :parent) :value)))
	    (if value-list
		(let ((components (get-values (gv :self) :components))
		      (index-list
		       (if (gvl :parent :actions-p)
			   (mapcar #'(lambda (item)
				       (position item (gvl :items) :test
						 #'(lambda (val item)
						     (equal val (car item)))))
				   value-list)
			   (mapcar #'(lambda (item)
				       (position item (gvl :items)
						 :test #'equal))
				   value-list))))
		  (mapcar #'(lambda (index) (nth index components))
			  index-list))))))
       (:item-prototype
	(,X-BUTTON
         ;; modified from original 20-Nov-91 -fer
	 (:shadow-offset 0)
	 (:text-offset ,(o-formula (gv (path 0 :parent :parent) :text-offset)))
	 (:gray-width ,(o-formula (gv (path 0 :parent :parent) :gray-width)))
	 (:text-on-left-p ,(o-formula (gv (path 0 :parent :parent)
					  :text-on-left-p)))
	 (:max-text-width-thus-far
	  ,(o-formula (if (gvl :prev-visible)
			  (MAX (gvl :prev-visible
				    :max-text-width-thus-far)
			       (gvl :text :width))
			  (gvl :text :width))))
	 (:button-width ,(o-formula (gv (path 0 :parent :parent)
					:button-width)))
	 (:button-height ,(o-formula (gv (path 0 :parent :parent)
					 :button-height)))
	 (:button-unit-width ,(o-formula (gv (path 0 :parent :parent)
					     :button-unit-width)))
	 (:button-unit-height ,(o-formula (gv (path 0 :parent :parent)
					      :button-unit-height)))
	 (:text-width
	  ,(o-formula (if (gv (path 0 :parent :parent) :fixed-width-p)
			  (- (gv (path 0 :parent :parent)
				 :fixed-width-size)
			     (gvl :button-unit-width) (gvl :text-offset))
			  (gvl :text :width))))
	 (:height ,(o-formula (if (gv (path 0 :parent :parent) :fixed-height-p)
				  (gv (path 0 :parent :parent)
				      :fixed-height-size)
				  (MAX (gvl :text :height)
				       (gvl :button-unit-height)))))
      
	 ;; Conditional formulas are required to allow either a list of
	 ;; strings or a list of string/function pairs in the :items slot.
	 (:string ,(o-formula (if (gv (path 0 :parent :parent) :actions-p)
				  (first (nth (gvl :rank)
					      (gv (path 0 :parent) :items)))
				  (nth (gvl :rank)
				       (gv (path 0 :parent) :items)))))
	 (:action ,(o-formula (when (gv (path 0 :parent :parent) :actions-p)
				(second (nth (gvl :rank)
					     (gv (path 0 :parent) :items))))))
      
	 (:font ,(o-formula (gv (path 0 :parent :parent) :font)))
	 (:parts
	  (  ; :shadow
           :gray-outline :white-field
	   (:text :modify
		  (:left
		   ,(o-formula
		     (let* ((p (path 0 :parent))
			    (base-left (+ (gv p :left)
					  (if (gv p :text-on-left-p) 0
					      (+ (gv p :button-unit-width)
						 (gv p :text-offset))))))
		       (case (gv (path 1 :parent :parent :parent) :h-align)
			 (:left base-left)
			 (:center (+ base-left
				     (floor (- (gv p :text-width)
					       (gvl  :width)) 2)))
			 (:right (+ base-left (- (gv p :text-width)
						 (gvl :width)))))))))
	   (:feedback-obj :modify
			  (:visible ,(o-formula (member (gvl :parent)
							(gvl :parent :parent
							     :selected)))))))
      (:interactors
       ((:x-button-press :omit))))))))

   (:interactors
    `((:X-BUTTON-PRESS ,inter:button-interactor 
	(:start-where ,(o-formula (list :element-of
					(gvl :operates-on :x-button-list))))
	(:window ,(o-formula (gv-local :self :operates-on :window)))
	(:how-set :list-toggle)
	(:final-function
	 ,#'(lambda (interactor final-obj-over)
	      (let* ((action (g-value final-obj-over :action))
		     (gadget (g-value interactor :operates-on))
		     (string (g-value final-obj-over :string))
		     (value-obj (g-value gadget :x-button-list :selected)))

		;; Propagate change toward :value slot
		(s-value gadget :value-obj value-obj)

		;; Global function executed whenever selections change
		(kr-send gadget :selection-function gadget
			 (mapcar #'(lambda (object) (g-value object :string))
				 value-obj))

		; If the button is selected, then execute the local function
		(when (member final-obj-over value-obj)
		  (when action
		    (funcall action gadget string))))))))))



;;;
;;;  DEMO FUNCTION
;;;
;
;(defparameter X-Buttons-win NIL)
;(defparameter X-Buttons-top-agg NIL)
;(defparameter X-Buttons-Obj NIL)
;
;(defun X-Buttons-Go ()
;
;  (create-instance 'x-buttons-win inter:interactor-window
;     (:height 360)(:width 350)(:top 5)(:left 650))
;
;  (s-value X-Buttons-win
;	   :aggregate
;	   (create-instance 'x-buttons-top-agg opal:aggregate
;	      (:overlapping NIL)))
;
;  (create-instance 'x-buttons-obj X-Button-Panel
;     (:left 30) (:top 20)
;     (:items '("Ether" "Phlogiston" "Quintessence" "Alkahest")))
;  (opal:add-components X-Buttons-top-agg X-Buttons-Obj)
;
;  (format t "Leftdown on an X-button causes an X to be superimposed on the~%")
;  (format t "button, executes the function locally assigned to the button~%")
;  (format t "(if there is one), and executes the function specified in~%")
;  (format t ":selection-function (if there is one).~%")
;
;  (opal:update X-Buttons-win))
;
;
;(defun X-Buttons-Stop ()
;  (opal:destroy X-Buttons-win))

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/text-buttons.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;  Text-buttons
;;;
;;;  Features and operation of text-buttons:
;;;     1)  Click the left mouse button in a text button to select it.
;;;     2)  (Optional)  The text of the selected button will appear in inverse
;;;         video.
;;;     3)  The top level :value points to the string of the currently selected
;;;         button.
;;;     4)  The top level :value-obj slot points to the currently selected
;;;         button, and can be set directly with S-VALUE to select a button.
;;;     5)  The :items slot may contain functions to be executed as each
;;;         button is selected, and :selection-function may contain a
;;;         function to be executed when any button becomes selected.
;;;
;;;  Customizable slots:
;;;     1)  All customizable slots of an aggrelist:
;;;            Direction -- :vertical or :horizontal
;;;            V-spacing -- distance between buttons, if vertical orientation
;;;            H-spacing -- same, if horizontal orientation
;;;            Fixed-width-p -- whether all the buttons should be the width of
;;;                             :fixed-width-size (default is T)
;;;            Fixed-height-p -- same, but with heights
;;;            Fixed-width-size -- width of all components (default is the
;;;                                width of the widest button)
;;;            Fixed-height-size -- same, but with heights 
;;;            H-align -- how to align text within buttons horizontally
;;;                       :left, :center, or :right (default is :center)
;;;            V-align -- how to align text within buttons, vertically
;;;                       :top, :bottom, or :center (default is :center)
;;;            Rank-margin -- after this many components, a new row (or column)
;;;                           will be started
;;;            Pixel-margin -- absolute position in pixels after which a new
;;;                            row (or column) will be started
;;;            Indent -- amount to indent the new row (or column) in pixels
;;;     2)  Left, top
;;;     3)  Shadow-offset -- the amount of shadow that shows under the buttons
;;;     4)  Text-offset -- the distance from the edge of the longest text to
;;;                        the frame of the button
;;;     5)  Gray-width -- the width of the gray border on the buttons
;;;     6)  Font -- the font in which the text will appear
;;;     7)  Items -- This can be: 
;;;                  A list of strings, as in '("Large" ...), or
;;;                  a list of atoms, as in '(:center ...), or
;;;                  a list of string/function pairs, '(("Cut" Cut-FN) ...), or
;;;                  a list of atom/function pairs, '((:center Center-FN) ...).
;;;                  Each function will be executed when the associated button
;;;                  becomes selected.  The parameters are the top-level
;;;                  GADGET and the ITEM-STRING.
;;;     8)  Final-feedback-p -- whether to cause the text of the selected
;;;                             button to appear in inverse video
;;;     9)  Selection-function -- Global function to be executed when any button
;;;                               is selected.  Parameters are the top-level
;;;                               GADGET and the ITEM-STRING.
;;;
;;;  NOTE:  This module requires several schemata defined in GAD-button-parts.
;;;         Thus, GAD-button-parts.fasl must be loaded before this module.
;;;
;;;  Text-buttons demo:
;;;     This module contains a function which creates a window and a panel of
;;;     text-buttons.  To run it, enter (GARNET-GADGETS:text-buttons-go).
;;;     To stop, enter (GARNET-GADGETS:text-buttons-stop).
;;;
;;;  Designed by Brad Myers
;;;  Written by Andrew Mickish

;;; CHANGE LOG:
;;; 01/30/90  Andrew Mickish -  Added :selected slot to TEXT-BUTTON-LIST
;;;              so that :value of panel can be set directly.
;;; 02/24/90  Andrew Mickish -  Changed :font to Opal default font
;;; 06/01/90  Andrew Mickish -  Changed :text-button-press to be a menu-inter
;;; 07/02/90  Andrew Mickish -  Converted circularity between :value and
;;;              :selected slot;  Now the final-function sets :value-obj which
;;;              propagates to :value and :selected.
;;; 07/02/90  Andrew Mickish -  Added :FINAL-FEEDBACK part to TEXT-BUTTON-PANEL
;;; 07/16/90  Andrew Mickish -  Reimplemented TEXT-BUTTON and TEXT-BUTTON-LIST
;;;              prototypes so single button instances can be created.
;;; 11/28/90  Pavan Reddy - Added formula to :value-obj slot of TEXT-BUTTON-
;;;              PANEL so :value and :value-obj slots remain consistent.
;;;

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

(export '(Text-Button Text-Button-Panel
	;  Text-Buttons-Go Text-Buttons-Stop
	;  Text-Buttons-Obj Text-Buttons-Top-Agg Text-Buttons-Win
))


(create-instance 'TEXT-BUTTON opal:aggregadget
   (:left 0) (:top 0)
   (:shadow-offset 0)
   (:text-offset 5)
   (:gray-width 5)
   (:string "Text Button")
   (:font opal:default-font)
   (:final-feedback-p T)
   (:selection-function NIL)

   (:value (o-formula (if (gvl :selected) (gvl :string))))
   (:selected (o-formula (gvl :value)))

   (:floating-left (o-formula (+ (gvl :button-left)
				 (if (gvl :interim-selected)
				     (gvl :shadow-offset)
				     0))))
   (:floating-top (o-formula (+ (gvl :button-top)
				(if (gvl :interim-selected)
				    (gvl :shadow-offset)
				    0))))

   (:button-left (o-formula (gvl :left)))
   (:button-top (o-formula (gvl :top)))
   (:button-width (o-formula (+ (* 2 (gvl :gray-width))
				(* 2 (gvl :text-offset))
				(gvl :text-width))))
   (:button-height (o-formula (+ (* 2 (gvl :gray-width))
				(* 2 (gvl :text-offset))
				(gvl :text :height))))
   (:button-unit-width (o-formula (+ (gvl :button-width) (gvl :shadow-offset))))
   (:button-unit-height (o-formula (+ (gvl :button-height)
				      (gvl :shadow-offset))))

   (:text-width (o-formula (gvl :text :width)))

   (:width (o-formula (gvl :button-unit-width)))
   (:height (o-formula (gvl :button-unit-height)))

   (:parts
    `(  ;  (:shadow ,BUTTON-SHADOW-RECT)
      (:gray-outline ,GRAY-RECT-OUTLINE)
      (:white-field ,WHITE-RECT-FIELD)
      (:text ,IN-BUTTON-TEXT)
      (:feedback-obj ,opal:rectangle
          (:left ,(o-formula (gv (path 0 :parent :white-field) :left)))
	  (:top ,(o-formula (gv (path 0 :parent :white-field) :top)))
	  (:width ,(o-formula (gv (path 0 :parent :white-field) :width)))
	  (:height ,(o-formula (gv (path 0 :parent :white-field) :height)))
          (:filling-style ,opal:black-fill)
	  (:line-style NIL)
	  (:fast-redraw-p T) (:draw-function :xor)
	  (:visible ,(o-formula (let ((p (path 0 :parent)))
				  (and (gv p :final-feedback-p)
				       (gv p :selected))))))))
   (:interactors
    `((:text-button-press ,inter:button-interactor
        (:window ,(o-formula (gv-local :self :operates-on :window)))
	(:start-where ,(o-formula (list :in-box (gvl :operates-on))))
	(:how-set :toggle)
	(:final-function
	 ,#'(lambda (interactor button)
	      (declare (ignore interactor))
	      (let ((selected (g-value button :selected)))
		; Execute selection function
		(kr-send button :selection-function button selected))))))))


;;;
;;;  TOP LEVEL AGGREGADGET
;;;

(create-instance 'TEXT-BUTTON-PANEL opal:aggregadget
   
   ;; Customizable slots
   ;;
   (:left 0) (:top 0)
   (:width (o-formula (gvl :text-button-list :width)))
   (:height (o-formula (gvl :text-button-list :height)))
   (:direction :vertical)
   (:v-spacing 5) (:h-spacing 5)
   (:h-align :center)
   (:fixed-width-p T)
   (:fixed-width-size (o-formula (+ (* 2 (gvl :gray-width))
				    (* 2 (gvl :text-offset))
				    (gvl :text-button-list :tail
					 :max-text-width-thus-far))))
   (:fixed-height-p T)
   (:fixed-height-size (o-formula (+ (* 2 (gvl :gray-width))
				     (* 2 (gvl :text-offset))
				     (gvl :text-button-list :head :text
					  :height))))
   (:indent 0)

   (:shadow-offset 0) (:text-offset 5) (:gray-width 5)
   (:final-feedback-p T)
   (:font opal:default-font)

   (:selection-function NIL)
   (:items '("Text 1" "Text 2" "Text 3" "Text 4"))

   (:value-obj (o-formula (gvl :text-button-list :selected)))
   (:value (o-formula (let ((obj (gvl :value-obj)))
			(if obj (gv obj :string)))))

   (:actions-p (o-formula (listp (first (gvl :items)))))

   (:parts
    `((:text-button-list ,ITEMS-AGGLIST
       (:selected ,(o-formula
		    (let ((value (gv (path 0 :parent) :value)))
		      (if value
			  (nth (if (gv (path 0 :parent) :actions-p)
				   (position value (gvl :items) :test
					     #'(lambda (val item)
						 (equal val (car item))))
				   (position value (gvl :items) :test #'equal))
			       (get-values (gv :self) :components))))))
       (:item-prototype
	(,TEXT-BUTTON
	  (:shadow-offset ,(o-formula (gv (path 0 :parent :parent)
					  :shadow-offset)))
	  (:text-offset ,(o-formula (gv (path 0 :parent :parent) :text-offset)))
	  (:gray-width ,(o-formula (gv (path 0 :parent :parent) :gray-width)))
	  (:max-text-width-thus-far
	   ,(o-formula (if (gvl :prev-visible)
			   (MAX (gvl :prev-visible
				     :max-text-width-thus-far)
				(gvl :text :width))
			   (gvl :text :width))))
	  (:button-width ,(o-formula (let ((p (path 0 :parent :parent)))
				       (if (gv p :fixed-width-p)
					   (gv p :fixed-width-size)
					   (+ (* 2 (gvl :gray-width))
					      (* 2 (gvl :text-offset))
					      (gvl :text :width))))))
	  (:button-height ,(o-formula (let ((p (path 0 :parent :parent)))
					(if (gv p :fixed-height-p)
					    (gv p :fixed-height-size)
					    (+ (* 2 (gvl :gray-width))
					       (* 2 (gvl :text-offset))
					       (gvl :text :height))))))
	  (:button-unit-width ,(o-formula (+ (gvl :button-width)
					     (gvl :shadow-offset))))
	  (:button-unit-height ,(o-formula (+ (gvl :button-height)
					      (gvl :shadow-offset))))

	  ;; Conditional formulas are required to allow either a list of
	  ;; strings or a list of string/function pairs in the :items slot.
	  (:string ,(o-formula (if (gv (path 0 :parent :parent) :actions-p)
				   (first (nth (gvl :rank)
					       (gv (path 1 :parent) :items)))
				   (nth (gvl :rank)
					(gv (path 1 :parent) :items)))))
	  (:action ,(o-formula (when (gv (path 0 :parent :parent) :actions-p)
				 (second (nth (gvl :rank)
					      (gv (path 1 :parent) :items))))))
	  (:font ,(o-formula (gv (path 0 :parent :parent) :font)))
	  (:parts
	   (  ; :shadow
            :gray-outline :white-field
	    (:text :modify
	     (:left ,(o-formula
		      (let ((white-field (path 0 :parent :white-field)))
			(case (gv (path 1 :parent :parent :parent) :h-align)
			  (:left (+ (gv white-field :left)
				    (gv (path 2 :parent) :text-offset)))
			  (:center (opal:gv-center-x-is-center-of white-field))
			  (:right (- (opal:gv-right white-field)
				     (gv (path 2 :parent) :text-offset)
				     (gvl :width))))))))
	    (:feedback-obj :omit)))
	  (:interactors
	   ((:text-button-press :omit))))))

      (:FINAL-FEEDBACK ,opal:rectangle
          (:obj-over ,(o-formula (gvl :parent :text-button-list :selected)))
	  (:left ,(o-formula (gvl :obj-over :white-field :left)))
	  (:top ,(o-formula (gvl :obj-over :white-field :top)))
	  (:width ,(o-formula (gvl :obj-over :white-field :width)))
	  (:height ,(o-formula (gvl :obj-over :white-field :height)))
	  (:visible ,(o-formula (and (gvl :parent :final-feedback-p)
				     (gvl :obj-over))))
	  (:fast-redraw-p T)(:draw-function :xor)
	  (:line-style NIL)
	  (:filling-style ,opal:black-fill))))

   (:interactors
    `((:TEXT-BUTTON-PRESS ,inter:menu-interactor 
	(:start-where ,(o-formula (list :element-of
					(gvl :operates-on :text-button-list))))
	(:window ,(o-formula (gv-local :self :operates-on :window)))
	(:how-set :set)
	(:final-function
	 ,#'(lambda (interactor final-obj-over)
	      (let* ((action (g-value final-obj-over :action))
		     (gadget (g-value interactor :operates-on))
		     (string (g-value final-obj-over :string)))
	   
		;; Propagate new selection toward :value slot
		(s-value gadget :value-obj final-obj-over)

		;; Global function for all items
		(kr-send gadget :selection-function gadget string)

		;; Local function assigned to item
		(when action
		  (funcall action gadget string)))))))))


;;;
;;;  DEMO FUNCTION
;;;
;
;(defparameter Text-Buttons-win NIL)
;(defparameter Text-Buttons-top-agg NIL)
;(defparameter Text-Buttons-Obj NIL)
;
;(defun Text-Buttons-Go ()
;
;  (create-instance 'text-buttons-win inter:interactor-window
;     (:height 360)(:width 350)(:top 5)(:left 650))
;
;  (s-value Text-Buttons-win
;	   :aggregate
;	   (create-instance 'text-buttons-top-agg opal:aggregate
;	      (:overlapping NIL)))
;
;  (create-instance 'text-buttons-obj Text-Button-Panel
;     (:left 30) (:top 20)
;     (:selection-function #'Report-Selection)
;     (:items '("Mozart" "Bach" "Beethoven" "Ravel" "Strauss")))
;  (opal:add-component text-buttons-top-agg text-buttons-obj)
;
;  (format t "Leftdown on a text-button causes an inverse box to be~%")
;  (format t "superimposed on the button, executes the function locally~%")
;  (format t "assigned to the button (if there is one), and executes the~%")
;  (format t "function specified in :selection-function (if there is one).~%")
;
;  (opal:update Text-Buttons-win))
;
;
;(defun Text-Buttons-Stop ()
;  (opal:destroy Text-Buttons-win))

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/radio-buttons.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;  Radio-Button-Panel
;;;
;;;  Features and operation of Radio Buttons:
;;;     1)  Radio-button-panel is a set of circular buttons with text on one
;;;         side.  Only one button may be selected at a time.
;;;     2)  Click the left mouse button in a button to cause an inverse circle
;;;         to be superimposed on the button.
;;;     3)  The top level :value slot points to the string of the currently
;;;         selected button.
;;;     4)  The top level :value-obj slot points to the currently selected
;;;         button, and can be set directly with S-VALUE to select a button.  
;;;     5)  The :items slot may contain functions to be executed as each
;;;         button becomes selected, and :selection-function may contain a
;;;         function to be executed when any button becomes selected.
;;;
;;;  Customizable slots:
;;;     1)  All customizable slots of an aggrelist:
;;;            Direction -- :vertical or :horizontal
;;;            V-spacing -- distance between buttons, if vertical orientation
;;;            H-spacing -- same, if horizontal orientation
;;;            Fixed-width-p -- whether to put buttons in fields of constant
;;;                             width, specified in :fixed-width-size.
;;;            Fixed-height-p -- same, but with heights
;;;            Fixed-width-size -- width of all components (default is the
;;;                                width of the widest button)
;;;            Fixed-height-size -- same, but with heights 
;;;            H-align -- how to align buttons, if vertical orientation
;;;                       :left, :center, or :right
;;;            Rank-margin -- after this many components, a new row (or column)
;;;                           will be started
;;;            Pixel-margin -- absolute position in pixels after which a new
;;;                            row (or column) will be started
;;;            Indent -- amount to indent the new row (or column) in pixels
;;;     2)  Left, top, button-diameter
;;;     3)  Shadow-offset -- the amount of shadow that shows under the buttons
;;;     4)  Text-offset -- the distance from the text to the buttons
;;;     5)  Gray-width -- the width of the gray border on the buttons
;;;     6)  Text-on-left-p -- whether text will appear on left side of buttons
;;;                           (NIL implies text will appear to the right)
;;;     7)  Font  --  The font in which the button labels will appear
;;;     8)  Items -- This can be: 
;;;                  A list of strings, as in '("Large" ...), or
;;;                  a list of atoms, as in '(:center ...), or
;;;                  a list of string/function pairs, '(("Cut" Cut-FN) ...), or
;;;                  a list of atom/function pairs, '((:center Center-FN) ...).
;;;                  Each function will be executed when the associated button
;;;                  becomes selected.  The parameters are the top-level
;;;                  GADGET and the ITEM-STRING.
;;;     9)  Selection-function -- Global function to be executed when any button
;;;                               is selected.  Parameters are the top-level
;;;                               GADGET and the ITEM-STRING.
;;;
;;;  NOTE:  This module requires several schemata defined in GAD-button-parts.
;;;         Thus, GAD-button-parts.fasl must be loaded before this module.
;;;
;;;  Radio Buttons demo:
;;;     This module contains a function which creates a window and a panel of
;;;     Radio Buttons.  To run it, enter (GARNET-GADGETS:radio-buttons-go).
;;;     To stop, enter (GARNET-GADGETS:radio-buttons-stop).
;;;
;;;  Designed by Brad Myers
;;;  Written by Andrew Mickish

;;; CHANGE LOG:
;;; 01/30/90  Andrew Mickish - Added :selected slot to RADIO-BUTTON-LIST
;;;              so that :value of panel can be set directly.
;;; 06/25/90  Andrew Mickish - Added :FINAL-FEEDBACK part to RADIO-BUTTON-PANEL
;;;              to utilize fast-redraw-p technology
;;; 07/02/90  Andrew Mickish - Converted circularity between :value and
;;;              :selected slot;  Now the final-function sets :value-obj which
;;;              propagates to :value and :selected.
;;; 07/03/90  Andrew Mickish - Moved objects from GAD-button-parts.lisp into
;;;              :parts slot of RADIO-BUTTON; reimplemented RADIO-BUTTON so
;;;              that single instances can be created.
;;; 11/28/90  Pavan Reddy - added formula to :value-obj slot of RADIO-BUTTON-
;;;              PANEL so :value and :value-obj slots remain consistent.
;;;

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

(export '(Radio-Button Radio-Button-Panel
	;  Radio-Buttons-Go Radio-Buttons-Stop
	;  Radio-Buttons-Obj Radio-Buttons-Top-Agg Radio-Buttons-Win
))


(create-instance 'RADIO-BUTTON opal:aggregadget
   (:left 0) (:top 0)
   (:button-diameter 23)
   (:shadow-offset 0)
   (:text-offset 5) (:gray-width 3)
   (:string "Radio button")
   (:text-on-left-p T)
   (:font opal:default-font)
   (:value (o-formula (if (gvl :selected) (gvl :string))))
   (:selection-function NIL)

   (:floating-left (o-formula (+ (gvl :button-left)
				 (if (gvl :interim-selected)
				     (gvl :shadow-offset)
				     0))))
   (:floating-top (o-formula (+ (gvl :button-top)
				 (if (gvl :interim-selected)
				     (gvl :shadow-offset)
				     0))))

   (:button-left (o-formula (if (gvl :text-on-left-p)
				(+ (gvl :left) (gvl :text-width)
				   (gvl :text-offset))
				(gvl :left))))
   (:button-top (o-formula (- (gvl :center-y)
			      (floor (gvl :button-unit-height) 2))))
   (:button-unit-width (o-formula (+ (gvl :button-diameter)
				     (gvl :shadow-offset))))
   (:button-unit-height (o-formula (gvl :button-unit-width)))
   (:text-left (o-formula (if (gvl :text-on-left-p)
			      (gvl :left)
			      (+ (gvl :left) (gvl :button-unit-width)
				 (gvl :text-offset)))))
   (:text-width (o-formula (gvl :text :width)))
   (:width (o-formula (+ (gvl :text-width) (gvl :text-offset)
			 (gvl :button-unit-width))))
   (:height (o-formula (MAX (gvl :button-unit-height)
			    (gvl :text :height))))
   (:center-y (o-formula (+ (gvl :top)
			    (floor (gvl :height) 2))))

   (:selected (o-formula (gvl :value)))  ; Set by interactor

   (:parts
    `(;(:shadow ,opal:circle
      ;    (:left ,(o-formula (+ (gv (path 0 :parent) :button-left)
	;			(gv (path 0 :parent) :shadow-offset))))
	;  (:top ,(o-formula (+ (gv (path 0 :parent) :button-top)
	;		       (gv (path 0 :parent) :shadow-offset))))
	;  (:width ,(o-formula (gv (path 0 :parent) :button-diameter)))
	;  (:height ,(o-formula (gv (path 0 :parent) :button-diameter)))
	;  (:filling-style ,opal:black-fill))
      (:gray-outline ,opal:circle
          (:left ,(o-formula (gv (path 0 :parent) :floating-left)))
	  (:top ,(o-formula (gv (path 0 :parent) :floating-top)))
	  (:width ,(o-formula (gv (path 0 :parent) :button-diameter)))
	  (:height ,(o-formula (gv (path 0 :parent) :button-diameter)))
	  (:filling-style ,opal:gray-fill))
      (:white-field ,opal:circle
	  (:left ,(o-formula (+ (gv (path 0 :parent) :floating-left)
				(gv (path 0 :parent) :gray-width))))
	  (:top ,(o-formula (+ (gv (path 0 :parent) :floating-top)
			       (gv (path 0 :parent) :gray-width))))
	  (:width ,(o-formula (- (gv (path 0 :parent) :button-diameter)
				 (* 2 (gv (path 0 :parent) :gray-width)))))
	  (:height ,(o-formula (- (gv (path 0 :parent) :button-diameter)
				  (* 2 (gv (path 0 :parent) :gray-width)))))
	  (:filling-style ,opal:white-fill))
      (:text ,BESIDE-BUTTON-TEXT)
      (:feedback-obj ,opal:circle
	  (:left ,(o-formula (+ 3 (gv (path 0 :parent) :floating-left)
				  (gv (path 0 :parent) :gray-width))))
	  (:top ,(o-formula (+ 3 (gv (path 0 :parent) :floating-top)
			         (gv (path 0 :parent) :gray-width))))
	  (:width ,(o-formula (- (gv (path 0 :parent) :button-diameter)
				 (* 2 (gv (path 0 :parent) :gray-width)) 6)))
	  (:height ,(o-formula (- (gv (path 0 :parent) :button-diameter)
				  (* 2 (gv (path 0 :parent) :gray-width)) 6)))
	  (:visible ,(o-formula (gvl :parent :selected)))
	  (:line-style NIL) (:filling-style ,opal:black-fill)
	  (:fast-redraw-p T)(:draw-function :xor))))
   (:interactors
    `((:radio-button-press ,inter:button-interactor
	(:window ,(o-formula (gv-local :self :operates-on :window)))
	(:start-where ,(o-formula (list :in-box (gvl :operates-on))))
	(:how-set :set)
	(:final-function
	 ,#'(lambda (interactor button)
	      (declare (ignore interactor))
	      (let ((string (g-value button :string)))
		; Execute the selection-function
		(kr-send button :selection-function button string))))))))




(create-instance 'RADIO-BUTTON-PANEL opal:aggregadget
   
   ;; Customizable slots
   ;;
   (:left 0) (:top 0)
   (:width (o-formula (gvl :radio-button-list :width)))
   (:height (o-formula (gvl :radio-button-list :height)))
   (:direction :vertical)
   (:v-spacing 5) (:h-spacing 5)
   (:h-align (o-formula (if (gvl :text-on-left-p) :right :left)))
   (:fixed-width-p T)
   (:fixed-width-size (o-formula (+ (gvl :radio-button-list :tail
					 :max-text-width-thus-far)
				    (gvl :button-unit-width)
				    (gvl :text-offset))))
   (:fixed-height-p T)
   (:fixed-height-size (o-formula (MAX (gvl :radio-button-list :head :text
					    :height)
				       (gvl :button-unit-width))))
   (:indent 0)
   (:button-diameter 23)
   (:shadow-offset 0) (:text-offset 5) (:gray-width 3)
   (:text-on-left-p T)
   (:font opal:default-font)
   (:selection-function NIL)
   (:items '("Radio-text 1" "Radio-text 2" "Radio-text 3" "Radio-text 4"))

   (:value-obj (o-formula (gvl :radio-button-list :selected)))
   (:value (o-formula (let ((obj (gvl :value-obj)))
			(if obj (gv obj :string)))))

   (:actions-p (o-formula (listp (first (gvl :items)))))
   (:button-unit-width (o-formula (+ (gvl :button-diameter)
				     (gvl :shadow-offset))))

   (:parts
    `((:radio-button-list ,ITEMS-AGGLIST
         (:selected ,(o-formula
		      (let ((value (gv (path 0 :parent) :value)))
			(if value
			    (nth (if (gv (path 0 :parent) :actions-p)
				     (position value (gvl :items) :test
					       #'(lambda (val item)
						   (equal val (car item))))
				     (position value (gvl :items)
					       :test #'equal))
				 (get-values (gv :self) :components))))))
	 (:item-prototype
	  (,RADIO-BUTTON
	   (:shadow-offset ,(o-formula (gv (path 0 :parent :parent)
					   :shadow-offset)))
	   (:text-offset ,(o-formula (gv (path 0 :parent :parent)
					 :text-offset)))
	   (:gray-width ,(o-formula (gv (path 0 :parent :parent) :gray-width)))
	   (:button-diameter ,(o-formula (gv (path 0 :parent :parent)
					     :button-diameter)))
	   (:text-on-left-p ,(o-formula (gv (path 0 :parent :parent)
					    :text-on-left-p)))
	   (:max-text-width-thus-far
	    ,(o-formula (if (gvl :prev-visible)
			    (MAX (gvl :prev-visible :max-text-width-thus-far)
				 (gvl :text :width))
			    (gvl :text :width))))
	   (:text-width
	    ,(o-formula (if (gv (path 0 :parent :parent) :fixed-width-p)
			    (- (gv (path 0 :parent :parent) :fixed-width-size)
			       (gvl :button-unit-width) (gvl :text-offset))
			    (gvl :text :width))))
	   (:height
	    ,(o-formula (if (gv (path 0 :parent :parent) :fixed-height-p)
			    (gv (path 0 :parent :parent) :fixed-height-size)
			    (MAX (gvl :text :height)
				 (gvl :button-unit-height)))))

	   ;; Conditional formulas are required to allow either a list of
	   ;; strings or a list of string/function pairs in the :items slot.
	   (:string
	    ,(o-formula (if (gv (path 0 :parent :parent) :actions-p)
			    (first (nth (gvl :rank)
					(gv (path 1 :parent) :items)))
			    (nth (gvl :rank) (gv (path 1 :parent) :items)))))
	   (:action ,(o-formula (when (gvl :parent :parent :actions-p)
				  (second (nth (gvl :rank)
					       (gvl :parent :items))))))
	   (:font ,(o-formula (gv (path 0 :parent :parent) :font)))
	   (:parts
	    ( ; :shadow
             :gray-outline :white-field
	     (:text :modify
		    (:left
		     ,(o-formula
		       (let* ((p (path 0 :parent))
			      (base-left (+ (gv p :left)
					    (if (gv p :text-on-left-p) 0
						(+ (gv p :button-unit-width)
						   (gv p :text-offset))))))
			 (case (gv (path 1 :parent :parent :parent) :h-align)
			   (:left base-left)
			   (:center (+ base-left
				       (floor (- (gv p :text-width)
						 (gvl  :width)) 2)))
			   (:right (+ base-left (- (gv p :text-width)
						   (gvl :width)))))))))
	     (:feedback-obj :omit)))
	   (:interactors
	    ((:radio-button-press :omit))))))
      (:FINAL-FEEDBACK ,opal:circle
          (:obj-over ,(o-formula (gvl :parent :radio-button-list :selected)))
	  (:left ,(o-formula (+ 3 (gvl :obj-over :white-field :left))))
	  (:top ,(o-formula (+ 3 (gvl :obj-over :white-field :top))))
	  (:width ,(o-formula (- (gvl :obj-over :white-field :width) 6)))
	  (:height ,(o-formula (- (gvl :obj-over :white-field :height) 6)))
	  (:visible ,(o-formula (gvl :obj-over)))
	  (:fast-redraw-p T) (:draw-function :xor)
	  (:line-style NIL)
	  (:filling-style ,opal:black-fill))))

   (:interactors
    `((:RADIO-BUTTON-PRESS ,inter:button-interactor 
	(:start-where ,(o-formula (list :element-of
					(gvl :operates-on :radio-button-list))))
	(:window ,(o-formula (gv-local :self :operates-on :window)))
	(:how-set :set)
	(:final-function
	 ,#'(lambda (interactor final-obj-over)
	      (let* ((action (g-value final-obj-over :action))
		     (gadget (g-value interactor :operates-on))
		     (string (g-value final-obj-over :string)))

		;; Propagate new selection toward :value slot
		(s-value gadget :value-obj final-obj-over)

		;; Global function for all items
		(kr-send gadget :selection-function gadget string)

		;; Local function assigned to item
		(when action
		  (funcall action gadget string)))))))))


;;;
;;;  DEMO FUNCTION
;;;
;
;(defparameter Radio-Buttons-win NIL)
;(defparameter Radio-Buttons-top-agg NIL)
;(defparameter Radio-Buttons-Obj NIL)
;
;(defun Radio-Buttons-Go ()
;
;  (create-instance 'radio-buttons-win inter:interactor-window
;     (:height 360)(:width 350)(:top 5)(:left 650))
;
;  (s-value Radio-Buttons-win
;	   :aggregate
;	   (create-instance 'radio-buttons-top-agg opal:aggregate
;			    (:overlapping NIL)))
;
;
;  (create-instance 'radio-buttons-obj Radio-Button-Panel
;     (:left 30) (:top 20)
;     (:selection-function #'Report-Selection)
;     (:items '("Einstein" "Fermi" "Lorentz" "Maxwell" "Planck")))
;  (opal:add-components Radio-Buttons-top-agg Radio-Buttons-Obj)
;
;  (format t "Leftdown on a radio button causes an inverse circle to be~%")
;  (format t "superimposed on the button, executes the function locally~%")
;  (format t "assigned to the button (if there is one), and executes the~%")
;  (format t "function specified in :selection-function (if there is one).~%")
;
;  (opal:update Radio-Buttons-win))
;
;
;(defun Radio-Buttons-Stop ()
;  (opal:destroy Radio-Buttons-win))

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/scrolling-window-loader.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;; 
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;

#|
==================================================================
Change log:
     3/14/91  Brad Myers - Added Parts file
     7/5/90 Brad Myers - Created
     8/6/90 Ed Pervin - Moved load of h-scroll-loader, v-scroll-loader
			from scrolling-window.lisp to here.
==================================================================
|#

(in-package "USER" :use '("LISP"))

(setf *load-verbose* t)

;;; check first to see if place is set
;(unless (boundp 'Garnet-Gadgets-PathName)
;  (error "Load 'Garnet-Loader' first to set Garnet-Gadgets-PathName before loading Gadgets."))
;
;;;; Load Aggregadgets unless already loaded (this will load others if necessary)
;#+cmu
;(unless (get :garnet-modules :aggregadgets)
;  (load Garnet-Aggregadgets-Loader))
;#+(not cmu)
;(require 'aggregadgets Garnet-Aggregadgets-Loader)
;
;#+explorer
;(unless (find-package "GARNET-GADGETS")
;  (make-package "GARNET-GADGETS" :use '("LISP" "KR")))
;
;;;; Now load the scrolling-window module
;;;;
;(unless (get :garnet-modules :scrolling-window)
;  (format t "Loading Scrolling-Window...~%")
;  (dolist (pair '((:h-scroll-bar "h-scroll-loader")
;                  (:v-scroll-bar "v-scroll-loader")
;                  (:scrolling-window-parts "scrolling-window-parts")
;                  (:scrolling-window "scrolling-window")))
;    (unless (get :garnet-modules (car pair))
;      (load (merge-pathnames (cadr pair)
;                             #+cmu "gadgets:"
;                             #+(not cmu) Garnet-Gadgets-PathName)
;            :verbose T)))
;  (format t "...Done Scrolling-Window.~%"))
;
;(setf (get :garnet-modules :scrolling-window-parts) t)
;(setf (get :garnet-modules :scrolling-window) t)
(provide 'scrolling-window)


;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/scrolling-window-parts.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;  Scrolling Window Parts
;;;      see the file Scrolling-window for an explanation
#|
============================================================
Change log:
	 3/14/91  Brad Myers - Separated from Scrolling-window to allow 
                               Motif-scrolling-window-with-bars
============================================================
|#

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))
 
(export '(Scrolling-Window
	  Scroll-Win-Inc Scroll-Win-To
	  ;Scrolling-Window-Go Scrolling-Window-Stop
))

(defconstant min-win-size 20) ; windows smaller than this size sometimes
			   ; cause an X error


;; This might be called directly by the user, in which case we need to
;; destroy the window, or it might be called when the window is destroyed,
;; in which case we don't want to destroy the window.  The gethash call
;; determines which case this is.
(defun Scrolling-Window-Destroy (window-gadget &optional erase)
  ;; have to destroy the windows
  (let ((window (g-value window-gadget :outer-window)))
    ;; make sure the window is not being destroyed already
    (when (and window
	       (schema-p window)
	       (gethash (get-local-value window :drawable)
			opal::*drawable-to-window-mapping*))
      (opal:destroy window)))
  (call-prototype-method window-gadget erase))

;;; Must return outer window
(defun Scrolling-Window-Creator (window-gadget)
  (let* ((outer-window (create-instance NIL inter:interactor-window
		 (:left (o-formula (gvl :scroll-win-gadget :left)))
		 (:top (o-formula (gvl :scroll-win-gadget :top)))
		 (:position-by-hand (o-formula (gvl :scroll-win-gadget
						    :position-by-hand)))
		 (:width (o-formula (gvl :scroll-win-gadget :width)))
		 (:height (o-formula (gvl :scroll-win-gadget :height)))
		 (:border-width (o-formula (gvl :scroll-win-gadget
						:border-width)))
		 (:title (o-formula (gvl :scroll-win-gadget :title)))
		 (:icon-title (o-formula (gvl :scroll-win-gadget :icon-title)))
		 (:visible (o-formula (gvl :scroll-win-gadget :visible)))
		 (:scroll-win-gadget window-gadget)
		  ; use g-value for the next one because parent can't change
		 (:parent (g-value window-gadget :parent-window))))
	 (outer-agg (create-instance NIL opal:aggregate))
	 (inner-window (create-instance NIL inter:interactor-window
                 (:scroll-win-gadget window-gadget)
		 (:left (o-formula (gvl :scroll-win-gadget :X-Offset)))
		 (:top (o-formula (gvl :scroll-win-gadget :Y-Offset)))
		 (:width (o-formula
			  (let ((w (gvl :scroll-win-gadget :total-width)))
			    (if w (max min-win-size w) min-win-size))))
		 (:height (o-formula
			   (let ((h (gvl :scroll-win-gadget :total-height)))
			     (if h (max h min-win-size) min-win-size))))
		 (:border-width 0) ; no border
		 (:double-buffered-p
		  (o-formula (gvl :scroll-win-gadget :double-buffered-p)))
		 (:parent outer-window)))
	 (inner-agg (create-instance NIL opal:aggregate)))
    (s-value outer-window :aggregate outer-agg) ; is an aggregate needed?
    (s-value inner-window :aggregate inner-agg)
    (s-value window-gadget :inner-window inner-window)
    (s-value window-gadget :outer-window outer-window)
    (s-value window-gadget :inner-aggregate inner-agg)
    outer-window))

;;; This can be called from the top level, as if the gadget was a window, in
;;; which case it updates the window, creating it first if it is not there.  It
;;; can tell whether it is being called from the top level or from the user by
;;; the presence of the second parameter with a value.
;;; Actually, the window update call does NOT use a message send to call update
;;; on the children, but rather calls update-method-aggregate directly, so this
;;; method will NOT be called recursively when it is used to update the window,
;;; but leave the checks in just to be safe!
;;; 
;;; This method is used by both scrolling windows and scrolling-windows-with-bars.
(defun Scrolling-Window-Update
       (agg &optional (update-info :top-level)
	    line-style-gc filling-style-gc drawable
	    root-window clip-mask-1 bbox-1 clip-mask-2 bbox-2 (total-p nil))
  (if (or (eq update-info :top-level)
	  (eq update-info T))
      ; then is a top level call from the user, so create windows if necessary
      ; and update the window
      (let ((win (g-value agg :outer-window)))
	(unless win
	  (setq win (kr-send agg :Creator-Func agg)))
	(opal:update win (if (eq update-info T) T NIL)))
      ;; else update the object normally
      (call-prototype-method agg update-info line-style-gc filling-style-gc
			     drawable root-window clip-mask-1 bbox-1 clip-mask-2
			     bbox-2 total-p)))

(create-instance 'Scrolling-Window opal:aggregadget
   ; Customizable slots
   (:left 0) (:top 0)
   (:position-by-hand NIL)
   (:width 150)(:height 150)  ; note: is INNER width and height of outer window
   (:border-width 2)
   (:parent-window NIL)
   (:double-buffered-p NIL)
   (:title "Scrolling-Window")
   (:icon-title (o-formula (gvl :title)))
   (:total-width 200)
   (:total-height 200)
   (:X-Offset 0)
   (:Y-Offset 0)
   (:visible T)
      ; read-only slots
   (:Inner-Window NIL)  ; these are created by the update method
   (:inner-aggregate NIL) ; add your objects to this aggregate (but have to
			  ; update first)
   (:outer-window NIL) ; call Opal:Update on this window (or on gadget itself)

      ; internal slots
   (:destroy-me 'Scrolling-Window-Destroy)
   (:Update 'Scrolling-Window-Update)
   (:Creator-Func 'Scrolling-Window-Creator)
   )

#| *** The following code was to make sure the :left, :top etc. of the
| scroll gadget was set whenever the window was moved, but since it has
| to go in the Update function of the window, which is called all the
| time, it is too expensive.
| 
| ;;; HACK function to set the value of a slot and make sure that there
| ;;; are no implications for any formulas that might depend on it.
| ;;; This is used in the update method to make sure that changes to
| ;;; the gadget do not affect the windows even though there are formulas.
| (defun safe-s-value (obj slot value)
|   (let ((form (get-value obj slot)))
|     (if (formula-p form)
| 	(setf (kr::cached-value form) value)
| 	(let ((entry (kr::slot-accessor obj slot)))
| 	  (setf (cadr entry) value)
| 	  (kr::set-slot-accessor obj slot entry)))))
| 
| ;;; This is a method placed on the outer-window of a scrolling window
| ;;; so that if it changes size, we can adjust the position of the
| ;;; scrolling window gadget.
| (defun Scrolling-Win-Update (outerwindow &optional total)
|   (call-prototype-method outerwindow total)
|   (format T "update total ~s~%" total))
| 
|   (let ((gadget (g-value outerwindow :scroll-win-gadget)))
|     (safe-s-value gadget :left (g-value outerwindow :left))
|     (safe-s-value gadget :top (g-value outerwindow :top))
|     (safe-s-value gadget :width (g-value outerwindow :width))
|      (safe-s-value gadget :height (g-value outerwindow :height))))
|#

;;; Must return the outer-window
(defun Scrolling-Window-With-Bars-Creator (window-gadget)
  (let* ((outer-window (create-instance NIL inter:interactor-window
		 (:scroll-win-gadget window-gadget)
		 (:left (o-formula (gvl :scroll-win-gadget :left)))
		 (:top (o-formula (gvl :scroll-win-gadget :top)))
		 (:position-by-hand (o-formula (gvl :scroll-win-gadget
						    :position-by-hand)))
		 (:width (o-formula (gvl :scroll-win-gadget :width)))
		 (:height (o-formula (gvl :scroll-win-gadget :height)))
		 (:title (o-formula (gvl :scroll-win-gadget :title)))
		 (:icon-title (o-formula (gvl :scroll-win-gadget :icon-title)))
		 (:visible (o-formula (gvl :scroll-win-gadget :visible)))
		 (:border-width (o-formula (gvl :scroll-win-gadget
						:border-width)))
		  ; use g-value for the next one because parent can't change
		 (:parent (g-value window-gadget :parent-window))))
	 (outer-agg (create-instance NIL opal:aggregate))
	 (clip-window (create-instance NIL inter:interactor-window
	      (:scroll-win-gadget window-gadget)
	      (:left (o-formula (gvl :scroll-win-gadget :clip-win-left)))
	      (:top (o-formula (gvl :scroll-win-gadget :clip-win-top)))
	      (:width (o-formula (gvl :scroll-win-gadget :inner-width)))
	      (:height (o-formula (gvl :scroll-win-gadget :inner-height)))
	      (:border-width 0)
	      (:parent outer-window)))
	 (clip-agg (create-instance NIL opal:aggregate))
	 (inner-window (create-instance NIL inter:interactor-window
                 (:scroll-win-gadget window-gadget)
		 (:left (o-formula (gvl :scroll-win-gadget :X-Offset)))
		 (:top (o-formula (gvl :scroll-win-gadget :Y-Offset)))
		 (:width (o-formula
			  (let ((w (gvl :scroll-win-gadget :total-width)))
			    (if w (max min-win-size w) min-win-size))))
		 (:height (o-formula
			   (let ((h (gvl :scroll-win-gadget :total-height)))
			     (if h (max h min-win-size) min-win-size))))
		 (:border-width 0) ; no border
		 (:double-buffered-p
		  (o-formula (gvl :scroll-win-gadget :double-buffered-p)))
		 (:parent clip-window)))
	 (inner-agg (create-instance NIL opal:aggregate)))
    (s-value outer-window :aggregate outer-agg)
    (s-value clip-window :aggregate clip-agg) ; is an aggregate needed?
    (s-value inner-window :aggregate inner-agg)
    (s-value window-gadget :inner-window inner-window)
    (s-value window-gadget :clip-window clip-window)
    (s-value window-gadget :outer-window outer-window)
    (s-value window-gadget :inner-aggregate inner-agg)
    (opal:add-component outer-agg window-gadget)
    outer-window
    ))

;; This might be called directly by the user, in which case we need to
;; destroy the window, or it might be called when the window is destroyed,
;; in which case we don't want to destroy the window.  The gethash call
;; determines which case this is.
;; This is in this file, since it used by both the Garnet and Motif
;; scrolling window with bars.
(defun Scrolling-Window-With-Bars-Destroy (window-gadget &optional erase)
  ;; First, remove the gadget from its window so when the window is
  ;; destroyed, the gadget will not be.  Then destroy the gadget itself
  ;; using call-prototype-method
  (let ((agg (g-value window-gadget :parent))
	(window (g-value window-gadget :outer-window)))
    (when agg
      (opal:remove-component agg window-gadget))
    ;; make sure window isn't already being destroyed
    (when (and window
	       (schema-p window)
	       (gethash (get-local-value window :drawable)
			opal::*drawable-to-window-mapping*))
      (opal:destroy window))
    (call-prototype-method window-gadget erase))
  )

#| *** The following code was to make sure the :left, :top etc. of the
| scroll gadget was set whenever the window was moved, but since it has
| to go in the Update function of the window, which is called all the
| time, it is too expensive.
| 
| ;;; HACK function to set the value of a slot and make sure that there
| ;;; are no implications for any formulas that might depend on it.
| ;;; This is used in the update method to make sure that changes to
| ;;; the gadget do not affect the windows even though there are formulas.
| (defun safe-s-value (obj slot value)
|   (let ((form (get-value obj slot)))
|     (if (formula-p form)
| 	(setf (kr::cached-value form) value)
| 	(let ((entry (kr::slot-accessor obj slot)))
| 	  (setf (cadr entry) value)
| 	  (kr::set-slot-accessor obj slot entry)))))
| 
| ;;; This is a method placed on the outer-window of a scrolling window
| ;;; so that if it changes size, we can adjust the position of the
| ;;; scrolling window gadget.
| (defun Scrolling-Win-Update (outerwindow &optional total)
|   (call-prototype-method outerwindow total)
|   (format T "update total ~s~%" total))
| 
|   (let ((gadget (g-value outerwindow :scroll-win-gadget)))
|     (safe-s-value gadget :left (g-value outerwindow :left))
|     (safe-s-value gadget :top (g-value outerwindow :top))
|     (safe-s-value gadget :width (g-value outerwindow :width))
|      (safe-s-value gadget :height (g-value outerwindow :height))))
|#

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Exported functions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; When a program explicitly sets the x-offset and y-offset, set the
;;   :value slots of the h and v scroll bars, so the indicator will move.
(defun Set-Scroll-Bar-Values (scroll-win-gadget)
  ;; grrrr: first have to call g-value to set up constraints in case it has
  ;; never been called yet
  (s-value (g-value scroll-win-gadget :v-scroll) :value 
	   (- (g-value scroll-win-gadget :y-offset)))
  (s-value (g-value scroll-win-gadget :h-scroll) :value 
	   (- (g-value scroll-win-gadget :x-offset)))) 


(defun Scroll-Win-To (scroll-win-gadget x y)
  #-release-garnet
  "Scroll the specified window to the specified x and y offset (absolute)"
  (s-value scroll-win-gadget :x-offset x)
  (s-value scroll-win-gadget :y-offset y)
  (if (g-value scroll-win-gadget :h-scroll)
      (Set-Scroll-Bar-Values scroll-win-gadget))
  (opal:update (g-value scroll-win-gadget :outer-window)))

(defun Scroll-Win-Inc (scroll-win-gadget x y)
  #-release-garnet
"Scroll the specified window to by the specified amount in x and y (relative)"
  (incf (g-value scroll-win-gadget :x-offset) x)
  (incf (g-value scroll-win-gadget :y-offset) y)
  (if (g-value scroll-win-gadget :h-scroll)
      (Set-Scroll-Bar-Values scroll-win-gadget))
  (opal:update (g-value scroll-win-gadget :outer-window)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Demo programs 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;(defun Internal-Scrolling-Window-Go (which-obj dont-enter-main-event-loop
;					       double-buffered-p)
;  (declare (ignore dont-enter-main-event-loop))
;  (let* ((My-Scrolling-Window (create-instance NIL which-obj
;		   (:left 650)(:top 10)(:width 300)(:height 400)
;		   (:title "Scrolling Window")
;		   (:int-feedback-p NIL) ; used only for ..-with-bars
;		   (:double-buffered-p double-buffered-p)
;		   (:total-width 500)
;		   (:total-height 500)))
;	 agg)
;    (opal:update My-Scrolling-Window)
;    ;; agg not available until after the update
;    (setq agg (g-value My-Scrolling-Window :inner-aggregate))
;    (opal:add-components agg
;	(create-instance NIL opal:rectangle
;			 (:Left 0)(:top 0)(:width 30)(:height 30))
;	(create-instance NIL opal:rectangle
;			 (:Left 470)(:top 0)(:width 30)(:height 30)
;			 (:line-style NIL)
;			 (:filling-style opal:black-fill))
;	(create-instance NIL opal:rectangle
;			 (:Left 0)(:top 470)(:width 30)(:height 30)
;			 (:filling-style opal:gray-fill))
;	(create-instance NIL opal:rectangle
;			 (:Left 470)(:top 470)(:width 30)(:height 30)
;			 (:filling-style opal:light-gray-fill))
;	(create-instance NIL opal:circle
;			 (:Left 235)(:top 235)(:width 30)(:height 30)
;			 (:filling-style opal:diamond-fill)))
;    (opal:update My-Scrolling-Window)
;    My-Scrolling-Window))
;
;(defparameter Scrolling-Window-Obj NIL)
;
;(defun Scrolling-Window-Go (&key dont-enter-main-event-loop double-buffered-p)
;  (setq Scrolling-Window-Obj
;	(Internal-Scrolling-Window-Go Scrolling-Window 
;				      dont-enter-main-event-loop
;				      double-buffered-p)))
;
;(defun Scrolling-Window-Stop ()
;  (opal:destroy Scrolling-Window-Obj))


;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/scrolling-window.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;  Scrolling Window
;;;    set the x-offset and y-offset fields to move the contents
;;; 
;;;     Customizable slots
;;;   	  :left, :top, :width, :height, Default=0,0,150,150 - left, top,
;;; 				width and height of outer window
;;;	  :position-by-hand, default=NIL - if T, the user is asked for the outer
;;; 				window's position.
;;;       :border-width, default=2 - of outer window
;;;       :parent-window, default=NIL - window this scrolling-window is
;;;				inside of, or NIL
;;;       :double-buffered-p, default=NIL
;;;       :title, default="Scrolling-Window"
;;;       :icon-title, default=(same as title)
;;;       :total-width, default=200 - total size of the scrollable area inside
;;;       :total-height, default=200)  
;;;       :X-Offset, default=0 - offset in the scrollable area
;;;       :Y-Offset, default=0
;;;       :visible, default=T - whether the entire window is visible (mapped)
;;;    Read-Only slots
;;;       :Inner-Window - these are created by the update method
;;;       :inner-aggregate - add your objects to this aggregate (but have to
;;;			  	update first)
;;;       :outer-window - call Opal:Update on this window (or on gadget itself)
;;; 
;;; Useful functions:
;;;     Scroll-Win-Inc (scroll-win-gadget xinc yinc) - scroll a window by
;;; 			adding the specified values (can be negative)
;;;     Scroll-Win-To (scroll-win-gadget x y) - specify the position to scroll to
;;;
;;;
;;;  Scrolling-Window-With-Bars
;;;    contains two optional scroll bars
;;; 
;;;     Customizable slots
;;;   	  :left, :top, :width, :height, Default=0,0,150,150 - left, top,
;;; 				width and height of outer window (size of visible
;;; 				portion smaller by :min-scroll-bar-width)
;;;	  :position-by-hand, default=NIL - if T, the user is asked for the outer
;;; 				window's position.
;;;       :border-width, default=2 - of outer window
;;;       :parent-window, default=NIL - window this scrolling-window is
;;;				inside of, or NIL
;;;       :double-buffered-p, default=NIL
;;;       :title, default="Scrolling-Window"
;;;       :icon-title, default=(same as title)
;;;       :total-width, default=200 - total size of the scrollable area inside
;;;       :total-height, default=200)  
;;;       :X-Offset, default=0 - offset in the scrollable area; DO NOT SET
;;; 			THESE OR PUT FORMULAS IN THEM, use the exported functions
;;;       :Y-Offset, default=0   
;;;       :visible, default=T - whether the entire window is visible (mapped)
;;;
;;;       :h-scroll-bar-p, default=T - Is there a horizontal scroll bar?
;;;       :v-scroll-bar-p, default=T - Is there a vertical scroll bar?
;;;
;;;     Scroll Bar slots
;;;       :h-scroll-on-top-p, default=NIL - whether horiz bar is on top or bottom
;;;       :v-scroll-on-left-p, default=T - whether vert bar is on left or right
;;;       :min-scroll-bar-width, default=20 - these control both scroll bars
;;;       :scr-trill-p, default=T
;;;       :page-trill-p, default=T
;;;       :indicator-text-p, default=NIL - Whether the pixel position is
;;; 						shown in the bars
;;;       :h-scr-incr, default=10 - in pixels
;;;       :h-page-incr - default jumps one page
;;;       :v-scr-incr, default=10 - in pixels
;;;       :v-page-incr - default jumps one page
;;;       :int-feedback-p, default=T - use NIL to have contents move continuously
;;;       :indicator-font
;;;
;;;    Read-Only slots
;;;       :Inner-Window - these are created by the update method
;;;       :inner-aggregate - add your objects to this aggregate (but have to
;;;				  ; update first)
;;;       :outer-window - call Opal:Update on this window (or on gadget itself)
;;;       :clip-window
;;;
;;; NOTE: Create either of these, then call Update on it.  Do not add it
;;; to an aggregate or a window.  If you want the scrolling window in
;;; another window, specify the :parent-window slot instead:
;;;     (create-instance NIL garnet-gadgets:scrolling-window(-with-bars)
;;; 			(...)(:parent-window other-window) )
;;;
;;;  Designed and written by Brad Myers
;;;  Based on an idea from Roderick J. Williams at the University of Leeds
;;;
;;;  *** KNOWN BUG *** When the user changes the size or position of the outer
;;;  window with the window manager, the fields of the scrolling
;;;  window gadget are not updated.  Circular constraints won't work
;;;  because the user will usually override the values for the slots
;;;  when the window is created.  I think the fix will have to wait
;;;  for eager evaluation --BAM

#|
============================================================
Change log:
	 3/14/91  Brad Myers - Separated into two files so can have a 
                               Motif-Scrolling-Window-With-Bars
	 3/8/91   Brad Myers - Made work better when outer window changes size
	 1/9/91   Brad Myers - Fixed bug in scrolling-windows (without bars)
	 8/22/90  Brad Myers - Fixed comments and provide default title
	 8/16/90  Brad Myers - Fixed so Scroll-Win-Inc and -To work on
				scrolling-window-with-bars; also fixed so
			        user can change size using window manager
	 8/10/90  Brad Myers - Fixed so size correct now that w,h of windows is 
				inside, added comments
	 8/6/90   Ed Pervin - Moved load of h-scroll-loader, v-scroll-loader
		        to scrolling-window-loader.
         7/25/90  Brad Myers - fix so destroy more robust, and so setting
			:visible works
	 6/20/90  Brad Myers - created 
============================================================
|#

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))
 
(export '(Scrolling-Window-With-Bars
	  ;Scrolling-Window-With-Bars-Go Scrolling-Window-With-Bars-Stop
))

;;; ** Scrolling-window-parts must be loaded first **

;;; Must return the outer-window
;;; removed as duplicate code, 21-Jul-91 - FER
;(defun Scrolling-Window-With-Bars-Creator (window-gadget)
;  (let* ((outer-window (create-instance NIL inter:interactor-window
;                 (:scroll-win-gadget window-gadget)
;                 (:left (o-formula (gvl :scroll-win-gadget :left)))
;                 (:top (o-formula (gvl :scroll-win-gadget :top)))
;                 (:position-by-hand (o-formula (gvl :scroll-win-gadget
;                                                    :position-by-hand)))
;                 (:width (o-formula (gvl :scroll-win-gadget :width)))
;                 (:height (o-formula (gvl :scroll-win-gadget :height)))
;                 (:title (o-formula (gvl :scroll-win-gadget :title)))
;                 (:icon-title (o-formula (gvl :scroll-win-gadget :icon-title)))
;                 (:visible (o-formula (gvl :scroll-win-gadget :visible)))
;                 (:border-width (o-formula (gvl :scroll-win-gadget
;                                                :border-width)))
;                  ; use g-value for the next one because parent can't change
;                 (:parent (g-value window-gadget :parent-window))))
;         (outer-agg (create-instance NIL opal:aggregate))
;         (clip-window (create-instance NIL inter:interactor-window
;              (:scroll-win-gadget window-gadget)
;              (:left (o-formula (gvl :scroll-win-gadget :clip-win-left)))
;              (:top (o-formula (gvl :scroll-win-gadget :clip-win-top)))
;              (:width (o-formula (gvl :scroll-win-gadget :inner-width)))
;              (:height (o-formula (gvl :scroll-win-gadget :inner-height)))
;              (:border-width 0)
;              (:parent outer-window)))
;         (clip-agg (create-instance NIL opal:aggregate))
;         (inner-window (create-instance NIL inter:interactor-window
;                 (:scroll-win-gadget window-gadget)
;                 (:left (o-formula (gvl :scroll-win-gadget :X-Offset)))
;                 (:top (o-formula (gvl :scroll-win-gadget :Y-Offset)))
;                 (:width (o-formula
;                          (let ((w (gvl :scroll-win-gadget :total-width)))
;                            (if w (max min-win-size w) min-win-size))))
;                 (:height (o-formula
;                           (let ((h (gvl :scroll-win-gadget :total-height)))
;                             (if h (max h min-win-size) min-win-size))))
;                 (:border-width 0) ; no border
;                 (:double-buffered-p
;                  (o-formula (gvl :scroll-win-gadget :double-buffered-p)))
;                 (:parent clip-window)))
;         (inner-agg (create-instance NIL opal:aggregate)))
;    (s-value outer-window :aggregate outer-agg)
;    (s-value clip-window :aggregate clip-agg) ; is an aggregate needed?
;    (s-value inner-window :aggregate inner-agg)
;    (s-value window-gadget :inner-window inner-window)
;    (s-value window-gadget :clip-window clip-window)
;    (s-value window-gadget :outer-window outer-window)
;    (s-value window-gadget :inner-aggregate inner-agg)
;    (opal:add-component outer-agg window-gadget)
;    outer-window
;    ))

(create-instance 'Scrolling-Window-With-Bars opal:aggregadget
       ; Customizable slots
   (:left 0) (:top 0)
   (:position-by-hand NIL)
   (:width 150)(:height 150) ; note: is INNER width and height of outermost window
   (:border-width 2)
   (:parent-window NIL)
   (:double-buffered-p NIL)
   (:title "Scrolling-Window")
   (:icon-title (o-formula (gvl :title)))
   (:total-width 200)  ; of the full area that graphics will be in
   (:total-height 200) ; of the full area that graphics will be in
   (:X-Offset 0)  ; can be set explicitly, and is set by scroll bars
   (:Y-Offset 0)  ; can be set explicitly, and is set by scroll bars
   (:h-scroll-bar-p T)  ; Is there a horizontal scroll bar?
   (:v-scroll-bar-p T)  ; Is there a vertical scroll bar?
   (:visible T)

      ;scroll bar slots
   (:h-scroll-on-top-p NIL)  ; whether scroll bar is on left or right
   (:v-scroll-on-left-p T)  ; whether scroll bar is on top or bottom
   (:min-scroll-bar-width 20)
   (:scr-trill-p T)
   (:page-trill-p T)
   (:indicator-text-p NIL)
   (:h-scr-incr 10)  ; in pixels
   (:h-page-incr (o-formula (- (gvl :outer-window :width) 10)))
   (:v-scr-incr 10)  ; in pixels
   (:v-page-incr (o-formula (- (gvl :outer-window :height) 10)))
   (:int-feedback-p T)
   (:indicator-font (create-instance NIL opal:font (:size :small)))

      ; read-only slots
   (:Inner-Window NIL)  ; these are created by the update method
   (:inner-aggregate NIL) ; add your objects to this aggregate
   (:outer-window NIL) ; call Opal:Update on this window (or on gadget itself)
   (:clip-window NIL)

     ; internal slots
   			; make the next two depend on the outer window in
			; case it is changed by the user using the window manager.
   (:outer-win-inner-height (o-formula (gvl :outer-window :height) 50))
   (:outer-win-inner-width (o-formula (gvl :outer-window :width) 50))
   (:inner-width (o-formula (- (gvl :outer-win-inner-width)
			       (if (gvl :v-scroll-bar-p)
				   (gvl :v-scroll :width)
				   0))))
   (:inner-height (o-formula (- (gvl :outer-win-inner-height)
				(if (gvl :h-scroll-bar-p)
				  ; (gvl :h-scroll :height) ;** should use this
				  			    ; but it is NIL
				    (gvl :min-scroll-bar-width) 
				    0))))
   (:clip-win-left (o-formula (if (and (gvl :v-scroll-bar-p)
				       (gvl :v-scroll-on-left-p))
				  (gvl :v-scroll :width)
				  0)))
   (:clip-win-top (o-formula (if (and (gvl :h-scroll-bar-p)
				      (gvl :h-scroll-on-top-p))
				 (gvl :h-scroll :height)
				 0)))
   (:destroy-me 'Scrolling-Window-With-Bars-Destroy)
   (:update 'Scrolling-Window-Update)
   (:creator-func 'Scrolling-Window-With-Bars-Creator)

   (:parts 
    `((:v-scroll ,garnet-gadgets:v-scroll-bar
		 (:left ,(o-formula (if (gvl :parent :v-scroll-on-left-p)
					0
					; else at right
					(- (gvl :parent :outer-win-inner-width)
					   (gvl :min-width)))))
		 (:top ,(o-formula (if (and (gvl :parent :h-scroll-bar-p)
					    (gvl :parent :h-scroll-on-top-p))
					;** should use this
					;** but it is NIL
				       ; (gvl :parent :h-scroll :height)
				       (gvl :parent :min-scroll-bar-width)
				       0)))
		 (:val-1 0)
		 (:scr-trill-p ,(o-formula (gvl :parent :scr-trill-p)))
		 (:page-trill-p ,(o-formula (gvl :parent :page-trill-p)))
		 (:indicator-text-p ,(o-formula (gvl :parent :indicator-text-p)))
		 (:int-feedback-p ,(o-formula (gvl :parent :int-feedback-p)))

		 (:height ,(o-formula (gvl :parent :inner-height)))
		 (:min-width ,(o-formula (gvl :parent :min-scroll-bar-width)))
		 (:val-2 ,(o-formula (Max 1 (- (gvl :parent :total-height)
					       (gvl :parent :inner-height))) 0))
		 (:scr-incr ,(o-formula (gvl :parent :v-scr-incr)))
		 (:page-incr ,(o-formula (gvl :parent :v-page-incr)))
		 (:scroll-p ,(o-formula
			      (and (gvl :window)
				   (or (/= 0 (gvl :parent :y-offset))
				       (>= (gvl :parent :total-height)
					   (gvl :parent :inner-height))))))
		 (:visible ,(o-formula (gvl :parent :v-scroll-bar-p)))
		 (:selection-function
		  ,#'(lambda (gadget new-val)
		       (s-value (g-value gadget :parent) :y-offset
				(- new-val)))))
      (:h-scroll ,garnet-gadgets:h-scroll-bar
		 (:left ,(o-formula (if (and (gvl :parent :v-scroll-bar-p)
					     (gvl :parent :v-scroll-on-left-p))
					(gvl :parent :v-scroll :width)
					0)))
		 (:val-1 0)
		 (:scr-trill-p ,(o-formula (gvl :parent :scr-trill-p)))
		 (:page-trill-p ,(o-formula (gvl :parent :page-trill-p)))
		 (:indicator-text-p ,(o-formula (gvl :parent :indicator-text-p)))
		 (:int-feedback-p ,(o-formula (gvl :parent :int-feedback-p)))

		 (:top ,(o-formula (if (gvl :parent :h-scroll-on-top-p)
				       0
				       (- (gvl :parent :outer-win-inner-height)
					  (gvl :min-height)))))
		 (:width ,(o-formula (gvl :parent :inner-width)))
		 (:min-height ,(o-formula (gvl :parent :min-scroll-bar-width)))
		 (:val-2 ,(o-formula (Max 1 (- (gvl :parent :total-width)
					       (gvl :parent :inner-width))) 0))
		 (:scr-incr ,(o-formula (gvl :parent :h-scr-incr)))
		 (:page-incr ,(o-formula (gvl :parent :h-page-incr)))
		 (:scroll-p ,(o-formula
			      (and (gvl :window)
				   (or (/= 0 (gvl :parent :x-offset))
				       (>= (gvl :parent :total-width)
					   (gvl :parent :inner-width))))))
		 (:visible ,(o-formula (gvl :parent :h-scroll-bar-p)))
		 (:selection-function
		  ,#'(lambda (gadget new-val)
		       (s-value (g-value gadget :parent) :x-offset
				(- new-val))))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Demo programs 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;(defparameter Scrolling-Window-With-Bars-Obj NIL)
;
;(defun Scrolling-Window-With-Bars-Go (&key dont-enter-main-event-loop
;					   double-buffered-p)
;  (setq Scrolling-Window-With-Bars-Obj
;	(Internal-Scrolling-Window-Go Scrolling-Window-With-Bars
;				      dont-enter-main-event-loop
;				      double-buffered-p)))
;
;(defun Scrolling-Window-With-Bars-Stop ()
;  (opal:destroy Scrolling-Window-With-Bars-Obj))


;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/scrolling-menu.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1990, Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;  Scrolling Menu
;;;
;;;  Features and operation of Scrolling-Menu:
;;;     1)  The Scrolling-Menu object is a vertical list of strings framed by
;;;         a white box with a scroll bar on one side.  Moving the indicator
;;;         of the scroll bar causes different subsets of the full list of
;;;         items to appear in the menu frame.  An optional title may
;;;         appear over the menu frame.
;;;     2)  Click the left mouse button on a menu item to select the item,
;;;         or if multiple-selection is enabled, click the left mouse button
;;;         while holding down the shift key to select multiple items.
;;;     3)  If the interim menu feedback is enabled, a box will be drawn
;;;         around the selected item momentarily.
;;;     4)  If the final menu feedback is enabled, the selected item(s) will
;;;         appear in inverse-video.
;;;     5)  The top level :value slot contains a list of strings of the
;;;         currently selected items (or a list of one string, if multiple
;;;         selection is not enabled).
;;;     6)  Items may be manually selected by setting the :selected-ranks slot
;;;         to be a list of the ranks of the desired items as they appear in
;;;         the :items list (the rankings start at 0).
;;;     6)  The :items slot may contain functions to be executed as each
;;;         item is selected, and :menu-selection-function may contain a
;;;         function to be executed when there is a change in the currently
;;;         selected items.
;;;
;;;  Customizable slots:
;;;     1)  Left, top
;;;     2)  Scroll-on-left-p -- whether to put the scroll bar to the left of
;;;                             the menu frame
;;;     3)  Min-Scroll-Bar-Width -- The minimum width of the scroll bar.  This
;;;            width will be overridden if it is too narrow to accomodate the
;;;            text in the indicator.
;;;     4)  Scr-trill-p  --  Whether to have single arrow trill boxes that
;;;                          increment by :scr-incr
;;;     5)  Page-trill-p --  Whether to have double arrow trill boxes that
;;;                          increment by :page-incr
;;;     6)  Scr-Incr  --  Value to increment position by in single arrow box
;;;     7)  Page-incr  --  Value to increment postion by in double arrow box
;;;     8)  Indicator-text-p -- Whether to report indicator position numerically
;;;                             inside the indicator
;;;     9)  Int-scroll-feedback-p  --  Whether a thick-lined box should follow
;;;            the mouse when moving the indicator.  A value of NIL causes the
;;;            indicator to follow the mouse directly.
;;;    10)  Indicator-font -- Font to report indicator position with
;;;    11)  Scroll-selection-function -- a function to be executed whenever
;;;            the scroll bar is moved.  Parameters are the SCROLL-BAR of
;;;            the scrolling menu and the VALUE of the scroll bar.
;;;    12)  Min-frame-width -- the minimum width of the frame around the menu
;;;    13)  V-spacing -- distance between menu items
;;;    14)  H-align -- how to justify the items (:left, :center, or :right)
;;;    15)  Multiple-p -- whether to allow multiple selections from the menu
;;;                       (using shift-leftdown)
;;;    16)  Items -- This can be: 
;;;                  A list of strings, as in '("Large" ...), or
;;;                  a list of atoms, as in '(:center ...), or
;;;                  a list of string/function pairs, '(("Cut" Cut-FN) ...), or
;;;                  a list of atom/function pairs, '((:center Center-FN) ...).
;;;                  Each function will be executed when the associated button
;;;                  becomes selected.  The parameters are the top-level
;;;                  GADGET and the ITEM-STRING.
;;;    17)  Item-To-String-Function -- a function which takes an ITEM and
;;;            returns a string to be displayed in the menu corresponding to
;;;            that item.  For example, if the :items slot contains a list of
;;;            Garnet schemas, then the function would return the name of a
;;;            schema.  If each item is a string/fn or atom/fn pair, only the
;;;            CAR of the pair is sent to the :item-to-string-function.
;;;            The default function assumes that :items contains a list of
;;;            strings.
;;;    18)  Num-visible -- the number of items to show in the menu
;;;            Note:  When s-valued, the following function call must be made
;;;            afterwards:  (opal:notice-items-changed
;;;                          (g-value your-sm-obj :menu-item-list))
;;;    19)  Int-menu-feedback-p -- whether to cause a box outline to appear
;;;                                around an item during selection
;;;    20)  Final-feedback-p -- whether to cause the selected item(s) to
;;;                             appear in inverse-video
;;;    21)  Text-offset -- the distance from the longest text to the menu frame
;;;    22)  Title -- a string to appear in inverse at the top of the menu
;;;                  (a value of NIL implies no title will appear)
;;;    23)  Title-Font and Item-Font
;;;    24)  Selected-Ranks -- A list of indices corresponding to the ranks of
;;;            the currently selected items in the :items list (the first item
;;;            in the :items list has rank 0).  This slot may be set to select
;;;            items and formulas may depend on it.
;;;    25)  Menu-selection-function -- Global function to be executed whenever
;;;            there is a change in the list of currently selected items.
;;;            Parameters are the top-level SCROLLING-MENU gadget and the
;;;            ITEM-OBJ that was just selected.  (The name of the item that
;;;            was just selected can be obtained by g-value'ing the :item slot
;;;            of the ITEM-OBJ.)
;;;
;;;  Scrolling-Menu demo:
;;;     This module contains a function which creates a window and a scrolling
;;;     menu.  To run it, enter (GARNET-GADGETS:scrolling-menu-go).
;;;     To stop, enter (GARNET-GADGETS:scrolling-menu-stop).
;;;
;;;  NOTE:  This module requires the scroll bar module and all of its parts
;;;         modules.  Thus, GAD-scroll-parts, GAD-v-arrows, GAD-v-boxes,
;;;         and v-scroll-bar must be loaded before this module.
;;;
;;;  Designed by Brad Myers
;;;  Written by Andrew Mickish

;;;  Change Log:
;;;
;;;  06/16/90 - Andrew Mickish - Reimplemented :v-spacing and :text-offset to
;;;     conform precisely to design requirements.  Changed :selected slot in
;;;     top-level gadget to :selected-ranks.  Changed :direction of aggrelist
;;;     to NIL and supplied formulas in :left and :top of S-M-ITEM.
;;;  06/18/90 - Andrew Mickish - Considered length of :items list in :end slot
;;;

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

(export '(Scrolling-Menu Scrolling-Menu-Frame Scrolling-Menu-Feedback-Rect
	  Scrolling-Menu-Title Scrolling-Menu-Item Scrolling-Menu-Item-List
	  Scrolling-Menu-Selector Scrolling-Menu-Scroll-Bar
	;  Scrolling-Menu-Go Scrolling-Menu-Stop
	;  Scrolling-Menu-Obj Scrolling-Menu-Win Scrolling-Menu-Top-Agg
))


(create-instance 'SCROLLING-MENU-FRAME opal:rectangle
   (:filling-style opal:white-fill)
   (:left (o-formula (gv (path 0 :parent) :frame-left)))
   (:top (o-formula (gv (path 0 :parent) :top)))
   (:width (o-formula (gv (path 0 :parent) :frame-width)))
   (:height (o-formula (gv (path 0 :parent) :frame-height))))


(create-instance 'SCROLLING-MENU-INTERIM-FEEDBACK opal:rectangle
   (:left (o-formula (+ 1 (gv (path 0 :parent) :frame-left))))
   (:top (o-formula (if (gvl :obj-over :prev)
			(gvl :obj-over :top)
			(+ (gvl :obj-over :top) 1))))
   (:width (o-formula (- (gv (path 0 :parent) :frame-width) 2)))
   (:height (o-formula (if (and (gvl :obj-over :prev)
				(gvl :obj-over :next))
			   (gvl :obj-over :height)
			   (- (gvl :obj-over :height) 1))))
   (:draw-function :xor)
   (:fast-redraw-p T)
   (:visible (o-formula (and (gv (path 0 :parent) :int-menu-feedback-p)
			     (gvl :obj-over)))))


(create-instance 'SCROLLING-MENU-TITLE opal:aggregadget
   (:left (o-formula (gv (path 0 :parent) :frame-left)))
   (:top (o-formula (gv (path 0 :parent) :top)))
   (:title (o-formula (gv (path 0 :parent) :title)))
   (:font (o-formula (gv (path 0 :parent) :title-font)))
   (:string-width (o-formula (if (gvl :title)
				 (+ (gvl :text :width)
				    (* 2 (gv (path 0 :parent) :text-offset)))
				 0)))
   (:width (o-formula (gv (path 0 :parent) :frame-width)))
   (:height (o-formula (if (gvl :title) (gvl :parent :title-height) 0)))
   (:visible (o-formula (gvl :title)))
   (:parts
    `((:text ,opal:text
	     (:left ,(o-formula (- (+ (gv (path 0 :parent) :left)
				      (floor (gv (path 0 :parent) :width) 2))
				   (floor (gvl :width) 2))))
	     (:top ,(o-formula (+ (gv (path 0 :parent) :top)
				  (floor (gv (path 1 :parent :parent)
					     :v-spacing) 2))))
	     (:string ,(o-formula (gv (path 0 :parent) :title)))
	     (:font ,(o-formula (gv (path 0 :parent) :font))))
      (:rect ,opal:rectangle
	     (:left ,(o-formula (gv (path 0 :parent) :left)))
	     (:top ,(o-formula (gv (path 0 :parent) :top)))
	     (:width ,(o-formula (gv (path 0 :parent) :width)))
	     (:height ,(o-formula (gv (path 0 :parent) :height)))
	     (:line-style ,opal:line-2)))))


(create-instance 'SCROLLING-MENU-ITEM opal:aggregadget
   (:left (o-formula (gv (path 0 :parent) :left)))
   (:top (o-formula (+ (gv (path 0 :parent) :top)
		       (* (gvl :rank)
			  (gv (path 1 :parent :parent) :item-height)))))
   (:width (o-formula (gv (path 0 :parent :parent) :frame-width)))
   (:height (o-formula (gv (path 0 :parent :parent) :item-height)))

   (:item (o-formula (if (gv (path 0 :parent :parent) :actions-p)
			 (first (nth (gvl :rank) (gv (path 1 :parent) :items)))
			 (nth (gvl :rank) (gv (path 1 :parent) :items)))))
   (:real-rank (o-formula (+ (gvl :rank) (gv (path 0 :parent :parent) :start))))
   (:highlighted (o-formula (and (gv (path 0 :parent :parent) :final-feedback-p)
				 (member (gvl :real-rank)
					 (gv (path 0 :parent :parent)
					     :selected-ranks)))))
   (:visible (o-formula (not (equal (gvl :text :string) ""))))
   (:item-to-string-function (o-formula (gv (path 0 :parent :parent)
					     :item-to-string-function)))
   (:parts
    `((:text ,opal:text
	     (:left ,(o-formula
		      (let* ((p0 (path 0 :parent))
			     (p1 (path 1 :parent :parent :parent))
			     (text-offset (gv p1 :text-offset)))
			(case (gv p1 :h-align)
			  (:left (+ (gv p0 :left) text-offset))
			  (:center (- (+ (gv p0 :left) (floor (gv p0 :width) 2))
				      (floor (gvl :width) 2)))
			  (:right (- (+ (gv p0 :left) (gv p0 :width))
				     (gvl :width) text-offset))))))
	     (:top ,(o-formula (+ (gv (path 0 :parent) :top)
				  (floor (gv (path 1 :parent :parent :parent)
					     :v-spacing) 2))))
	     (:string
	      ,(o-formula
		(let* ((p (path 0 :parent))
		       (fn (gv p :item-to-string-function)))
		  (declare (ignore fn))
		  (kr-send p :item-to-string-function (gv p :item)))))
	     (:font ,(o-formula (gv (path 0 :parent :parent :parent)
				    :item-font))))
      (:final-feedback ,opal:rectangle
	     (:left ,(o-formula (+ 1 (gv (path 0 :parent) :left))))
	     (:top ,(o-formula (let ((p (path 0 :parent)))
				 (if (gv p :prev)
				     (gv p :top)
				     (+ (gv p :top) 1)))))
	     (:width ,(o-formula (- (gv (path 0 :parent) :width) 2)))
	     (:height ,(o-formula (let ((p (path 0 :parent)))
				    (if (and (gv p :prev) (gv p :next))
					(gv p :height)
					(- (gv p :height) 1)))))
	     (:draw-function :xor)
	     (:fast-redraw-p T)
	     (:filling-style ,opal:black-fill)
	     (:visible ,(o-formula (and (gv (path 0 :parent) :visible)
					(gv (path 0 :parent) :highlighted))))))))


(create-instance 'SCROLLING-MENU-ITEM-LIST opal:aggrelist
   (:left (o-formula (gv (path 0 :parent) :frame-left)))
   (:top (o-formula (+ (gv (path 0 :parent) :top)
			   (gv (path 1 :parent :menu-title) :height))))
   (:width (o-formula (gv (path 0 :parent) :frame-width)))
   (:height (o-formula (gv (path 0 :parent) :items-height)))
   (:direction NIL)
   (:items (o-formula (gv (path 0 :parent) :visible-items)))
   (:item-prototype scrolling-menu-item))


(create-instance 'SCROLLING-MENU-SCROLL-BAR garnet-gadgets:v-scroll-bar
   (:left (o-formula (gv (path 0 :parent) :scroll-left)))
   (:top (o-formula (gv (path 0 :parent) :top)))
   (:height (o-formula (gv (path 0 :parent) :frame-height)))
   (:val-1 0)
   (:val-2 (o-formula (gv (path 0 :parent) :val-2)))
   (:min-width (o-formula (gv (path 0 :parent) :min-scroll-bar-width)))
   (:scr-trill-p (o-formula (gv (path 0 :parent) :scr-trill-p)))
   (:page-trill-p (o-formula (gv (path 0 :parent) :page-trill-p)))
   (:scr-incr (o-formula (gv (path 0 :parent) :scr-incr)))
   (:page-incr (o-formula (gv (path 0 :parent) :page-incr)))
   (:int-feedback-p (o-formula (gv (path 0 :parent) :int-scroll-feedback-p)))
   (:indicator-text-p (o-formula (gv (path 0 :parent) :indicator-text-p)))
   (:scroll-p (o-formula (gv (path 0 :parent) :scroll-p)))
   (:indicator-font (o-formula (gv (path 0 :parent) :indicator-font)))
   (:selection-function (o-formula (gv (path 0 :parent)
				       :scroll-selection-function))))


(create-instance 'SCROLLING-MENU-SELECTOR inter:menu-interactor
   (:window (o-formula (gv-local :self :operates-on :window)))
   (:start-where (o-formula (list :element-of
				   (gvl :operates-on :menu-item-list))))
   (:feedback-obj (o-formula (gvl :operates-on :feedback-obj)))
   (:start-event (o-formula (if (gvl :operates-on :multiple-p)
				 '(:leftdown :shift-leftdown)
				 :leftdown)))
   (:how-set :toggle)
   (:stop-action
    #'(lambda (interactor obj-under-mouse)
	(let* ((rank (g-value obj-under-mouse :real-rank))
	       (gadget (g-value interactor :operates-on))
	       (action (when (g-value gadget :actions-p)
			 (second (nth rank (g-value gadget :items)))))
	       (selected-ranks (g-value gadget :selected-ranks))
	       (feedback-obj (g-value interactor :feedback-obj))
	       (new-selected (case (g-value interactor :start-char)
			       (:shift-leftdown
				(set-exclusive-or (list rank) selected-ranks))
			       (:leftdown
				(set-difference (list rank) selected-ranks)))))

	  (s-value feedback-obj :obj-over NIL)
	  (s-value gadget :selected-ranks new-selected)
	
	  ;; Global function executed whenever selections change
	  (kr-send gadget :menu-selection-function
		   gadget
		   obj-under-mouse) 

	  ;; Local function assigned to item
	  (when action
	    (when (member rank new-selected)
	      (funcall action
		       gadget
		       (g-value obj-under-mouse :text :string))))
	  ))))



(create-instance 'SCROLLING-MENU opal:aggregadget

   ;;; Customizable slots
   ;;;
   (:left 0) (:top 0)

   ;; Scroll bar slots
   (:scroll-on-left-p T)
   (:min-scroll-bar-width 20)
   (:scr-trill-p T)
   (:page-trill-p T)
   (:indicator-text-p NIL)
   (:scr-incr 1)
   (:page-incr 5)
   (:int-scroll-feedback-p NIL)
   (:indicator-font (create-instance NIL opal:font (:size :small)))
   (:scroll-selection-function NIL)

   ;; Menu slots
   (:min-frame-width 0)
   (:v-spacing 6)
   (:h-align :left)     ; Implemented in MENU-ITEM code, not through aggrelists
   (:multiple-p T)
   (:items '("Item 1" "Item 2" "Item 3" "Item 4" ; "Item 5" "Item 6" "Item 7"
	     ;"Item 8" "Item 9" "Item 10" "Item 11" "Item 12" "Item 13"
	     ;"Item 14" "Item 15" "Item 16" "Item 17" "Item 18" "Item 19"
	     "Item 20"))
   (:item-to-string-function
    #'(lambda (item)
	(if item
	    (if (stringp item)
		item
		(string-capitalize (string-trim ":" item)))
	    "")))
   (:item-font opal:default-font)
   (:num-visible 5)
   (:int-menu-feedback-p T)
   (:final-feedback-p T)
   (:text-offset 4)
   (:title NIL)
   (:title-font (create-instance NIL opal:font
		   (:family :serif)
		   (:size :large)
		   (:face :roman)))
   (:menu-selection-function NIL)
   (:selected-ranks NIL)

   ;; Generally non-customizable slots
   ;;
   (:value (o-formula (mapcar #'(lambda (rank)
				  (if (gvl :actions-p)
				      (first (nth rank (gvl :items)))
				      (nth rank (gvl :items))))
			      (gvl :selected-ranks))))
   (:scroll-p (o-formula (> (length (gvl :items)) (gvl :num-visible))))
   (:actions-p (o-formula (and (car (gvl :items)) (listp (car (gvl :items))))))
   (:start (o-formula (if (gvl :scroll-p)
			  (gvl :scroll-bar :value)
			  0)))
   (:end (o-formula (+ (gvl :start) (MIN (length (gvl :items))
					 (gvl :num-visible)))))
   (:visible-items (o-formula (subseq (gvl :items) (gvl :start) (gvl :end))))
   (:max-item-width
    (o-formula
     (do* ((fn (gvl :item-to-string-function))
	   (items (if (gvl :actions-p)
		      (mapcar #'car (gvl :items))
		      (gvl :items)))
	   (font (gvl :item-font))
	   (items-len (length items))
	   (i 0 (+ i 1))
	   (item (nth i items) (nth i items))
	   (str (kr-send (gv :self) :item-to-string-function item)
		(kr-send (gv :self) :item-to-string-function item))
	   (str-width (opal:string-width font str) (opal:string-width font str))
	   (max-width str-width
		      (if (> str-width max-width) str-width max-width)))
	  ((= i items-len) (+ max-width (* 2 (gvl :text-offset))))
       (declare (ignore fn)))))
   (:scroll-left-on-right (o-formula (+ (gvl :left) (gvl :frame-width))))
   (:scroll-left (o-formula (if (gvl :scroll-on-left-p)
				(gvl :left)
				(gvl :scroll-left-on-right))))
   (:val-2 (o-formula (if (gvl :scroll-p)
			  (- (length (gvl :items)) (gvl :num-visible))
			  1)))
   (:frame-left-on-right (o-formula (+ (gvl :left)
				       (gvl :scroll-bar :bound-width))))
   (:frame-left (o-formula (if (gvl :scroll-on-left-p)
			       (gvl :frame-left-on-right)
			       (gvl :left))))
   (:frame-width (o-formula (MAX (gvl :menu-title :string-width)
				 (gvl :max-item-width)
				 (gvl :min-frame-width))))
   (:frame-height (o-formula (+ (gvl :title-height) (gvl :items-height))))
   (:title-height (o-formula (+ (gvl :v-spacing)
				(opal:string-height (gvl :title-font) "X"))))
   (:item-height (o-formula (+ (gvl :v-spacing)
			       (opal:string-height (gvl :item-font) "X"))))
   (:items-height (o-formula (* (gvl :num-visible) (gvl :item-height))))
   (:width (o-formula (+ (gvl :frame-width) (gvl :scroll-bar :width))))
   (:height (o-formula (+ (gvl :items-height) (gvl :title-height))))
   (:parts
    `((:scroll-bar ,scrolling-menu-scroll-bar)
      (:frame ,scrolling-menu-frame)
      (:feedback-obj ,scrolling-menu-interim-feedback)
      (:menu-title ,scrolling-menu-title)
      (:menu-item-list ,scrolling-menu-item-list)))
   (:interactors
    `((:selector ,scrolling-menu-selector))))



#|
;;;
;;;  FUNCTION TO DISPLAY SCROLLING MENU IN A WINDOW
;;;

(defun Report-Change (gadget item-object)
  (let ((item-string (g-value item-object :item)))
    (format t "~%Clicked on string ~S in gadget ~S.~%" item-string gadget)))

(defparameter scrolling-menu-win NIL)
(defparameter scrolling-menu-top-agg NIL)
(defparameter scrolling-menu-obj NIL)

(defun Scrolling-Menu-Go ()

  (create-instance 'scrolling-menu-win inter:interactor-window
     (:left 700)(:top 5)(:height 360)(:width 300))
  (s-value scrolling-menu-WIN
	   :aggregate
	   (create-instance 'scrolling-menu-top-agg opal:aggregate
	      (:overlapping T)))

  (create-instance 'scrolling-menu-obj scrolling-menu
     (:left 30) (:top 30)
     (:title "Menu")
     (:menu-selection-function #'Report-Change)
     (:items '(("Geneva" geneva-fn) ("Times" times-fn)
	       ("Roman" roman-fn) ("Courier" courier-fn)
	       ("Helvetica" helvetica-fn) ("Chicago" chicago-fn)
	       ("Symbol" symbol-fn) ("Monaco" monaco-fn)
	       ("Venice" venice-fn) ("Gothic" gothic-fn)
	       ("Celtic" celtic-fn))))
  (opal:add-components scrolling-menu-top-agg scrolling-menu-Obj)

  (opal:update scrolling-menu-WIN))


(defun Scrolling-Menu-Stop ()
  (opal:destroy scrolling-menu-win))


;;;  These functions are included to show that selection of one of the
;;;  menu items causes the associated local function to be called.

(defun geneva-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function GENEVA-FN called~%"))
(defun times-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function TIMES-FN called~%"))
(defun roman-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function ROMAN-FN called~%"))
(defun courier-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function COURIER-FN called~%"))
(defun helvetica-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function HELVETICA-FN called~%"))
(defun chicago-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function CHICAGO-FN called~%"))
(defun symbol-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function SYMBOL-FN called~%"))
(defun monaco-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function MONACO-FN called~%"))
(defun venice-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function VENICE-FN called~%"))
(defun gothic-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function GOTHIC-FN called~%"))
(defun celtic-fn (gadget item-string)
  (declare (ignore gadget item-string))
  (format t "Function CELTIC-FN called~%"))

|#

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/menu.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;  Menu
;;;
;;;  Features and operation of Menu:
;;;     1)  The Menu object is a vertical list of strings framed by a white box.
;;;         An optional title may appear at the top of the menu in inverse
;;;         video.
;;;     2)  Click the left mouse button on a menu item to select the item.
;;;     3)  A box will be drawn around the selected item momentarily.
;;;     4)  The top level :value slot points to the string of the currently
;;;         selected item.
;;;     5)  The top level :value-obj slot points to the currently selected
;;;         item object, and can be set directly with S-VALUE to select an item.
;;;     6)  The :items slot may contain functions to be executed as each
;;;         item is selected, and :selection-function may contain a function
;;;         to be executed when any item selected.
;;;
;;;  Customizable slots:
;;;     1)  Left, top
;;;     2)  V-spacing -- distance between menu items
;;;     3)  H-align -- how to justify the items (:left, :center, or :right)
;;;     3)  Shadow-offset -- the amount of shadow that shows under the menu
;;;     4)  Text-offset -- the distance from the longest text to the menu frame
;;;     4)  Title -- a string to appear in inverse at the top of the menu
;;;                  (a value of NIL implies no title will appear)
;;;     5)  Title-Font and Item-Font
;;;     6)  Items -- This can be: 
;;;                  A list of strings, as in '("Large" ...), or
;;;                  a list of atoms, as in '(:center ...), or
;;;                  a list of string/function pairs, '(("Cut" Cut-FN) ...), or
;;;                  a list of atom/function pairs, '((:center Center-FN) ...).
;;;                  Each function will be executed when the associated button
;;;                  becomes selected.  The parameters are the top-level
;;;                  GADGET and the ITEM-STRING.
;;;     7)  Selection-function -- Global function to be executed when any button
;;;                               is selected.  Parameters are the top-level
;;;                               GADGET and the ITEM-STRING.
;;;
;;;     NOTE:  When the menu object is exported (as in the demo function
;;;            below), slots can be changed on the fly as well when the objects
;;;            are created.
;;;
;;;  Menu demo:
;;;     This module contains a function which creates a window and a menu.
;;;     To run it, enter (GARNET-GADGETS:menu-go).
;;;     To stop, enter (GARNET-GADGETS:menu-stop).
;;;
;;;  NOTE:  This module requires several schemata defined in GAD-button-parts.
;;;         Thus, GAD-button-parts.fasl must be loaded before this module.
;;;
;;;  Designed by Brad Myers
;;;  Written by Andrew Mickish

;;; CHANGE LOG
;;; 04/17/91 Andrew Mickish - Changed MENU's :frame-width formula to look at
;;;            the :width of the aggrelist instead of the :max-width
;;;

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

(export '(Menu
	  ;Menu-Go Menu-Stop Menu-Obj
))


;(create-instance 'MENU-SHADOW-RECT opal:rectangle
;   (:left (o-formula (+ (gv (path 0 :parent) :left)
;			(gv (path 0 :parent) :shadow-offset))))
;   (:top (o-formula (+ (gv (path 0 :parent) :top)
;		       (gv (path 0 :parent) :shadow-offset))))
;   (:width (o-formula (gv (path 0 :parent :frame) :width)))
;   (:height (o-formula (gv (path 0 :parent :frame) :height)))
;   (:filling-style opal:black-fill))


(create-instance 'MENU-FRAME opal:rectangle
   (:filling-style opal:white-fill)
   (:left (o-formula (gv (path 0 :parent) :left)))
   (:top (o-formula (gv (path 0 :parent) :top)))
   (:width (o-formula (gv (path 0 :parent) :frame-width)))
   (:height (o-formula (gv (path 0 :parent) :frame-height))))


(create-instance 'MENU-FEEDBACK-RECT opal:rectangle
   (:left (o-formula (+ 1 (gvl :obj-over :left))))
   (:top (o-formula (+ 1 (gvl :obj-over :top))))
   (:width (o-formula (- (gvl :obj-over :width) 2)))
   (:height (o-formula (- (gvl :obj-over :height) 2)))
   (:visible (o-formula (gvl :obj-over))))


(create-instance 'MENU-TITLE opal:aggregadget
   (:text-offset (o-formula (gv (path 0 :parent) :text-offset)))
   (:text-offset2 (o-formula (gv (path 0 :parent) :text-offset2)))
   (:left (o-formula (gv (path 0 :parent) :left)))
   (:top (o-formula (gv (path 0 :parent) :top)))
   (:title (o-formula (gv (path 0 :parent) :title)))
   (:font (o-formula (gv (path 0 :parent) :title-font)))
   (:string-width (o-formula (if (gvl :title)
				 (+ (gvl :text :width) (gvl :text-offset2))
				 0)))
   (:width (o-formula (gv (path 0 :parent) :frame-width)))
   (:height (o-formula (if (gvl :title)
			   (+ (gvl :text :height) (gvl :text-offset2))
			   0)))
   (:visible (o-formula (gvl :title)))

   (:parts
    `((:text ,opal:text
	     (:left ,(o-formula (- (+ (gv (path 0 :parent) :left)
				      (floor (gv (path 0 :parent) :width) 2))
				   (floor (gvl :width) 2))))
	     (:top ,(o-formula (+ (gv (path 0 :parent) :top)
				  (gv (path 0 :parent) :text-offset))))
	     (:string ,(o-formula (gv (path 0 :parent) :title)))
	     (:font ,(o-formula (gv (path 0 :parent) :font)))
	     (:visible ,(o-formula (gv (path 0 :parent) :visible))))
      (:rect ,opal:rectangle
	     (:left ,(o-formula (+ 1 (gv (path 0 :parent) :left))))
	     (:top ,(o-formula (+ 1 (gv (path 0 :parent) :top))))
	     (:width ,(o-formula (- (gv (path 0 :parent) :width) 2)))
	     (:height ,(o-formula (- (gv (path 0 :parent) :height) 2)))
	     (:draw-function :xor)
	     (:filling-style ,opal:black-fill)
	     (:visible ,(o-formula (gv (path 0 :parent) :visible)))))))

(create-instance 'MENU-ITEM opal:aggregadget
   ;; Conditional formulas are required to allow either a list of strings or
   ;; a list of string/function pairs in the :items slot.
   (:string (o-formula (if (gv (path 0 :parent :parent) :actions-p)
			   (first (nth (gvl :rank)
				       (gv (path 1 :parent) :items)))
			   (nth (gvl :rank) (gv (path 0 :parent) :items)))))
   (:action (o-formula (when (gv (path 0 :parent :parent) :actions-p)
			 (second (nth (gvl :rank)
				      (gv (path 1 :parent) :items))))))

   (:font (o-formula (gv (path 0 :parent :parent) :item-font)))
   (:text-offset (o-formula (gv (path 0 :parent :parent) :text-offset)))
   (:text-offset2 (o-formula (gv (path 0 :parent :parent) :text-offset2)))
   (:h-align (o-formula (gv (path 0 :parent :parent) :h-align)))
   (:max-text-width-thus-far
       (o-formula (if (gvl :prev-visible)
		      (MAX (gvl :prev-visible :max-text-width-thus-far)
			   (gvl :text :width))
		      (gvl :text :width))))

   ;; These slots are used by the parent aggrelist in calculating its own
   ;; :max-width and :height slots.
   (:height (o-formula (+ (gvl :text :height) (gvl :text-offset2))))
   (:width (o-formula (MAX (gv (path 0 :parent :parent :menu-title)
			       :string-width)
			   (+ (gvl :parent :tail :max-text-width-thus-far)
			      (gvl :text-offset2)))))


   ;; An aggregadget is implemented for each text item so that there is no
   ;; "dead" space between menu items.
   (:parts
    `((:text ,opal:text
	     (:left ,(o-formula (case (gv (path 0 :parent) :h-align)
				  (:left (+ (gv (path 0 :parent) :left)
					    (gv (path 0 :parent) :text-offset)))
				  (:center (- (+ (gv (path 0 :parent) :left)
						 (floor (gv (path 0 :parent)
							    :width) 2))
					      (floor (gvl :width) 2)))
				  (:right (- (+ (gv (path 0 :parent) :left)
						(gv (path 0 :parent) :width))
					     (gvl :width)
					     (gv (path 0 :parent)
						 :text-offset))))))
	     (:top ,(o-formula (+ (gv (path 0 :parent) :top)
				  (gv (path 0 :parent) :text-offset))))
	     (:string
	      ,(o-formula (let ((s (gv (path 0 :parent) :string)))
			    (if (stringp s)
				s
				(string-capitalize (string-trim ":" s))))))
	     (:font ,(o-formula (gv (path 0 :parent) :font)))))))

(create-instance 'MENU-ITEM-LIST opal:aggrelist
   (:left (o-formula (gv (path 0 :parent) :left)))
   (:top (o-formula (gv (path 0 :parent) :items-top)))
   (:v-spacing (o-formula (gv (path 0 :parent) :v-spacing)))
   (:items (o-formula (gv (path 0 :parent) :items)))
   (:item-prototype menu-item))


(create-instance 'MENU opal:aggregadget

   ;; Customizable slots
   ;;
   (:left 0) (:top 0) 
   (:v-spacing 0)
   (:h-align :left)     ; Implemented in MENU-ITEM code, not through aggrelists
   (:shadow-offset 0)
   (:text-offset 4)
   (:title NIL)
   (:title-font (create-instance NIL opal:font
		   (:family :serif)
		   (:size :large)
		   (:face :roman)))
   (:items '("Item 1" "Item 2" "Item 3" "Item 4"))
   (:item-font opal:default-font)
   (:selection-function NIL)

   (:value-obj NIL)
   (:value (o-formula (gvl :value-obj :string)))

   ;; Generally non-customizable slots
   ;;
   (:actions-p (o-formula (listp (first (gvl :items)))))
   (:items-top (o-formula (+ (gvl :top) (gvl :menu-title :height))))
   (:text-offset2 (o-formula (* 2 (gvl :text-offset))))
   (:frame-width (o-formula (gvl :menu-item-list :width)))
   (:frame-height (o-formula (+ (gvl :menu-title :height)
				(gvl :menu-item-list :height))))
   (:parts 
    `( ;(:shadow ,menu-shadow-rect)
      (:frame ,menu-frame)
      (:feedback ,menu-feedback-rect)
      (:menu-title ,menu-title)
      (:menu-item-list ,menu-item-list)))
   (:interactors
    `((:selector ,inter:menu-interactor
		 (:window ,(o-formula (gv-local :self :operates-on :window)))
		 (:start-where ,(o-formula (list :element-of
						 (gvl :operates-on
						      :menu-item-list))))
		 (:running-where ,(o-formula (list :element-of
						   (gvl :operates-on
							:menu-item-list))))
		 (:how-set NIL)
		 (:feedback-obj ,(o-formula (gvl :operates-on :feedback)))
		 (:stop-action
		    (lambda (interactor obj-under-mouse)
		      (let ((action (g-value obj-under-mouse :action))
			    (gadget (g-value interactor :operates-on))
			    (string (g-value obj-under-mouse :string)))

			(s-value (g-value gadget :feedback) :obj-over NIL)
			(s-value gadget :value-obj obj-under-mouse)
			
			;; Global function for all items
			(kr-send gadget :selection-function gadget string)

			;; Local function assigned to item
			(when action
			  (funcall action gadget string)))))))))


;;;
;;;  MENU-GO
;;;
;
;(defparameter Menu-win NIL)
;(defparameter Menu-top-agg NIL)
;(defparameter Menu-Obj NIL)
;
;(defun Report-Item (top-level-obj string)
;  (let ((value-obj (g-value top-level-obj :value-obj)))
;    (format t "Menu-item object ~S selected with string ~S.~%"
;	    value-obj string)))
;
;(defun Menu-Go ()
;
;  (create-instance 'menu-win inter:interactor-window
;     (:top 5)(:left 700)(:height 360)(:width 300))
;
;  (s-value Menu-win
;	   :aggregate
;	   (create-instance 'menu-top-agg opal:aggregate
;	      (:overlapping NIL)))
;
;
;  (create-instance 'menu-obj Menu
;     (:left 20) (:top 20)
;     (:selection-function #'Report-Item)
;     (:title "Menu")
;     (:items '(("Cut" my-cut) ("Copy" my-copy)
;	       ("Paste" my-paste) ("Undo" my-undo) ("Cancel" my-cancel))))
;  (opal:add-components Menu-top-agg Menu-Obj)
;
;  (format t "Leftdown on a menu item causes a box to be drawn around the~%")
;  (format t "button, executes the function locally assigned to the item~%")
;  (format t "(if there is one), and executes the function specified in~%")
;  (format t ":selection-function (if there is one).~%")
;
;  (opal:update Menu-win)
;
;  NIL)
;
;
;;;;
;;;;  MENU-STOP
;;;;
;
;(defun Menu-Stop ()
;  (opal:destroy Menu-win))
;  
;
;;;;  These functions are included to show that selection of one of the
;;;;  menu items causes the associated local function to be called.
;
;(defun my-cut (gadget item-string)
;  (declare (ignore gadget item-string))
;  (format t "Function CUT called~%~%"))
;(defun my-copy (gadget item-string)
;  (declare (ignore gadget item-string))
;  (format t "Function COPY called~%~%"))
;(defun my-paste (gadget item-string)
;  (declare (ignore gadget item-string))
;  (format t "Function PASTE called~%~%"))
;(defun my-undo (gadget item-string)
;  (declare (ignore gadget item-string))
;  (format t "Function UNDO called~%~%"))
;(defun my-cancel (gadget item-string)
;  (declare (ignore gadget item-string))
;  (format t "Function CANCEL called~%~%"))



;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/labeled-box.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;;  Labeled Box
;;;
;;;  Features and operation of the labeled box:
;;;    1)  The labeled-box object is a box with text inside and beside the box.
;;;    2)  Click the left mouse button on the framed text to edit it, and press
;;;        return to stop editing.
;;;    3)  The top level :value slot is the string currently appearing inside
;;;        the box.  This slot may be set directly and formulae may depend
;;;        on it.
;;;    4)  A function may be specified in the :selection-function slot to be
;;;        executed after the field text has changed (i.e., after the carriage
;;;        return).
;;;
;;;  Customizable slots:
;;;    1)  Left, top
;;;    2)  Label-offset -- The distance between the label and the box
;;;    3)  Field-offset -- The distance between the field text and the box
;;;    4)  Min-frame-width -- The minimum width of the frame around the text
;;;    5)  Label-string -- The string that will appear beside the box
;;;    6)  Value -- The string that will originally appear in the box and that
;;;                 will be changed
;;;    7)  Selection-Function -- Function to be executed after editing text
;;;    8)  Label-font -- The font of the string beside the box
;;;    9)  Field-font -- The font of the string inside the box
;;;
;;;  Labeled box demo:
;;;    This module contains a function which creates a window and a labeled box
;;;    in the window.  To run it, enter (GARNET-GADGETS:labeled-box-go).
;;;    To stop, enter (GARNET-GADGETS:labeled-box-stop).
;;;
;;;  Designed by Brad Myers
;;;  Written by Andrew Mickish

;;; Change log
;;;
;;;  2/27/91 moved field to be beneath the prompt, allowed user to type
;;;          CR to take default -fer
;;; 06/20/90 Andrew Mickish - Removed :text-height slot; now :frame-height
;;;            only depends on the height of the field-text.
;;; 06/25/90 Andrew Mickish - Changed :top slots of LABEL-TEXT and FRAME
;;;            to center according to maximum height
;;; 07/04/90 Andrew Mickish - Added :label-height and :field-height slots
;;;            to reduce the evaluation of the top-level :height formula

(eval-when (eval compile load)
  (in-package "GARNET-GADGETS" :use '("LISP" "KR")))

(eval-when (eval compile load)
  (export '(Labeled-Box query-with-labeled-box))
  (proclaim '(special Label-PRIORITY-LEVEL)))

;; swipped whole hog from error-gadget
;(defun ADD-label-PRIORITY-LEVEL ()
  (unless (and (boundp 'label-PRIORITY-LEVEL)
	       (member LABEL-PRIORITY-LEVEL inter:priority-level-list))
    (push (create-instance 'LABEL-PRIORITY-LEVEL inter:priority-level)
	  inter:priority-level-list))

;(add-label-priority-level)


(defun query-with-labeled-box (box-gadget title string)
  #-release-garnet
  "Popup an labeled-box window."
  (if (g-value box-gadget :modal-p)
      (s-value label-PRIORITY-LEVEL :stop-when :always)
      (s-value label-PRIORITY-LEVEL :stop-when :if-any))
  ;; set up the box
  (s-value box-gadget :label-string title)
  (s-value box-gadget :value string)
  ;; Turn visibility on
  (let ((window (g-value box-gadget :window)))
    (s-value window :left (g-value window :left))
    (s-value window :top (g-value window :top))     ; Won't size correctly
    (s-value window :width (g-value window :width))   ;  without these lines
    (s-value window :height (g-value window :height))
    (s-value window :visible T)
    (opal:update window))
  (inter:beep)
    ;; make sure it gets clicked if really-modal-p
  (if (g-value box-gadget :really-modal-p)
      (prog ((sleep-time (g-value box-gadget :sleep-time))
	     (display (let ((win1 (caar (opal::get-table-contents))))
	                (if win1
 			    (xlib:window-display win1)
                            opal::*default-x-display*))) )
	    start
	    ;; call the event handler to get anything
            (opal::default-event-handler display :timeout 0)
            (sleep sleep-time)
	    (if (g-value box-gadget :window :visible)
		(go start))
	    (return (g-value box-gadget :value))
	    ))
  )


(create-instance 'LABELED-BOX opal:aggregadget

   ; Customizable slots
   (:really-modal-p nil) 
   ;;for really-modal-p, time in sec to sleep between checking if done
   (:sleep-time 0.1)
   (:window-width (o-formula (+ 20 (gvl :width))))    ; 10 on each side
   (:window-height (o-formula (+ 40 (gvl :height))))  ; 20 on top, bottom
   
   (:left 0) (:top 0)
   (:label-offset 5)  ;now vertical displacement
   (:field-offset 6)
   (:min-frame-width 10)
   (:label-string "Label:")
   (:value "Field")
   (:selection-function NIL)
   (:field-font opal:default-font)
   (:label-font (create-instance NIL opal:font
		    (:face :bold)))

   ; Generally non-customizable slots
   (:field-height (o-formula (opal:string-height (gvl :field-font) "X")))
   (:label-height (o-formula (opal:string-height (gvl :label-font) "X")))

   (:frame-left (o-formula (- (gvl :left) 2)))
   (:frame-width (o-formula (max (+ (* 2 (gvl :field-offset))
				    (gvl :field-text :width))
				 (gvl :min-frame-width))))
   (:frame-height (o-formula (+ 4 (gvl :field-height))))
   (:width (o-formula (MAX (gvl :frame-width)
                           (gvl :label-text :width))))
   (:height (o-formula (+ (gvl :frame-height) (gvl :label-offset)
			  (gvl :label-text :height))))
   (:center-y (o-formula (+ (gvl :top) (floor (gvl :height) 2))))
   (:parts
    `((:LABEL-TEXT ,opal:text
		  (:left ,(o-formula (gvl :parent :left)))
		  (:top ,(o-formula (- (gvl :parent :center-y)
				       (floor (gvl :height) 2))))
		  (:string ,(o-formula (gvl :parent :label-string)))
		  (:font ,(o-formula (gvl :parent :label-font))))
      (:FIELD-TEXT ,opal:cursor-text
       		  (:left ,(o-formula (gvl :parent :left)))
		  (:top ,(o-formula (+ 2 (gvl :parent :label-text :top)
				       (gvl :parent :label-text :height))))
		  (:string ,(o-formula (let ((value (gvl :parent :value)))
					 (if value value ""))))
		  (:font ,(o-formula (gvl :parent :field-font))))
      (:FRAME ,opal:rectangle
	     (:left ,(o-formula (gvl :parent :frame-left)))
	     (:top ,(o-formula (- (gvl :parent :field-text :top)
				  2)))
	     (:width ,(o-formula (gvl :parent :frame-width)))
	     (:height ,(o-formula (gvl :parent :frame-height))))))
   (:interactors `(
      (:fast-ok-inter ,inter:button-interactor
           (:start-where t)
           (:waiting-priority ,label-PRIORITY-LEVEL)
	   (:running-priority ,label-PRIORITY-LEVEL)       
	   (:window ,(o-formula (gv-local :self :operates-on :window)))
           (:start-event #\RETURN)
	   (:final-function
		    (lambda (interactor obj)
		      (declare (ignore obj))
                      ;; make it invisible if really-modal-p
                      (if (g-value interactor :operates-on :really-modal-p)
                          (s-value (g-value interactor :operates-on :window)
				   :visible nil))
		      ;; return preset value
                      (g-value interactor :operates-on :value)))
           (:continuous nil))
      (:TEXT-INTER ,inter:text-interactor
		   (:window ,(o-formula (gv-local :self :operates-on :window)))
		   (:start-where ,(o-formula (list :in-box (gvl :operates-on
								:frame))))
		   (:start-event :leftdown)
                   (:waiting-priority ,label-PRIORITY-LEVEL)
		   (:active T)  ;?
		   (:running-priority ,label-PRIORITY-LEVEL)
		   (:stop-event #\RETURN)
		   (:obj-to-change ,(o-formula (gvl :operates-on :field-text)))
		   (:final-function
		    (lambda (interactor obj event final-string x y)
		      (declare (ignore obj event x y))
		      (s-value (g-value interactor :operates-on)
			       :value
			       final-string)
                      ;; make it invisible if really-modal-p
                      (if (g-value interactor :operates-on :really-modal-p)
                          (s-value (g-value interactor :operates-on :window)
				   :visible nil))
		      ;; Execute global :selection-function
		      (kr-send (g-value interactor :operates-on)
			       :selection-function
			       (g-value interactor :operates-on)
			       final-string)))))))

;;;
;;;  DEMO FUNCTION
;;;

#|

(defparameter Labeled-Box-win NIL)
(defparameter Labeled-Box-top-agg NIL)
(defparameter Labeled-Box-Obj NIL)

(defun Labeled-Box-Go ()

  (create-instance 'labeled-box-win inter:interactor-window
     (:height 360)(:width 350)(:top 5)(:left 650))
  (s-value Labeled-Box-win
	   :aggregate
	   (create-instance 'labeled-box-top-agg opal:aggregate
			    (:overlapping NIL)))

  (create-instance 'labeled-box-obj Labeled-Box
     (:left 50) (:top 50))
  (opal:add-components Labeled-Box-top-agg Labeled-Box-Obj)

  (opal:update Labeled-Box-win))



(defun Labeled-Box-Stop ()
  (opal:destroy Labeled-Box-win))
|#

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/arrow-line.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;;  Arrow-line and Double-arrow-line
;;;
;;;
;;; Arrow-line
;;; ==========
;;; Features and operation of the arrow-line:
;;;   1)  An arrowhead appears at one end of the line.
;;;   2)  The endpoints of the arrow-line may be customized formulae which
;;;       depend on the position of other objects.  Such constraints would
;;;       cause the arrow-line to stay attached to the specified objects
;;;       when the objects are moved.
;;;   3)  No interactors are defined in the arrow-line prototype.
;;;
;;; Customizable slots:  (see the documentation for lines and arrowheads in
;;;                       the Opal manual)
;;;   1)  :x1, :y1 - source end point
;;;   2)  :x2, :y2 - end point with the arrowhead
;;;   3)  :line-style - thickness of all lines (default: line-0)
;;;   4)  :filling-style - filling of arrowhead (default: no-fill)
;;;   5)  :open-p - whether arrowhead is open or not  (default: T)
;;;   6)  To set other parameters of the arrowhead (such as :length and
;;;       :diameter), the arrowhead object must be accessed through the
;;;       slot :arrowhead.
;;;
;;; Note:  If the line is too short for an arrowhead to be drawn at one "end",
;;;        the arrowhead is drawn anyway (there is no special handling for
;;;        this case).
;;;
;;;
;;; Double-Arrow-line
;;; =================
;;; Features and operation of the double-arrow-line:
;;;   1)  Arrowheads may appear at either or both ends of the line.
;;;   2)  The slot determining the location of the arrowheads may be set
;;;       directly.  This feature is convenient for use in editors where the
;;;       user may turn on and off the arrowheads.
;;;   3)  The endpoints of the double-arrow-line may be customized formulae
;;;       which depend on the position of other objects.  Such constraints
;;;       would cause the arrows to stay attached to the specified objects
;;;       when the objects are moved.
;;;   4)  No interactors are defined in the double-arrow-line prototype.
;;;
;;; Customizable slots:  (see the documentation for lines and arrowheads in
;;;                       the Opal manual)
;;;   1)  :x1, :y1 - one end point
;;;   2)  :x2, :y2 - other end-point
;;;   3)  :line-style - thickness of all lines (default: line-0)
;;;   4)  :filling-style - filling of arrowheads (default: no-fill)
;;;   5)  :open-p - whether arrowheads are open or not  (default: T)
;;;   6)  :arrowhead-p  - where the arrow heads should be.  Legal values are:
;;;             NIL, or 0  - no arrowheads
;;;             1          - arrowhead at end-point 1
;;;             2          - arrowhead at end-point 2
;;;             :both or 3 - arrowhead at both end-points
;;;             (default = :both)
;;;   7)  To set other parameters of the arrowheads (such as :length and
;;;       :diameter), the arrowhead objects must be accessed through the
;;;       slots :arrowhead1 and :arrowhead2 of the double-arrow-line object.
;;;   8)  The default formulae in the arrowheads may also be overriden
;;;       (e.g., for two arrowheads with different :filling-styles).
;;;
;;; Note:  If only one arrowhead is desired, Arrow-line should be used.
;;;
;;; Arrow-line and Double-arrow-line demo
;;; =====================================
;;;   This module contains a function which creates a window with an arrow-line
;;;   and a double-arrow-line object in the window.  There are extra interactors
;;;   defined so that the arrows may be moved with the mouse.  To run the
;;;   demo, enter (GARNET-GADGETS:arrow-line-go).  To stop, enter
;;;   (GARNET-GADGETS:arrow-line-stop).
;;;
;;;  Designed and written by Brad Myers

(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

(export '(Arrow-Line ;Double-Arrow-Line
		     ;arrow-line-go arrow-line-stop
          ))

;;
;; Functions to determine whether the point (x,y) is inside the object
;;
(defun ArrowPointInGob (obj x y)
  (when (call-prototype-method obj x y)
    (or (let ((lin (g-value obj :line)))
	  (KR-Send lin :point-in-gob lin x y))
	(let ((hed (g-value obj :arrowhead)))
	  (KR-Send hed :point-in-gob hed x y)))))

(defun Arrow2PointInGob (obj x y)
  (when (call-prototype-method obj x y)
    (or (let ((lin (g-value obj :line)))
	  (KR-Send lin :point-in-gob lin x y))
	(let ((hed (g-value obj :arrowhead1)))
	  (KR-Send hed :point-in-gob hed x y))
	(let ((hed (g-value obj :arrowhead2)))
	  (KR-Send hed :point-in-gob hed x y)))))

;;;
;;;  ARROW-LINE
;;;

(create-instance 'ARROW-LINE opal:aggregadget
   ; Customizable slots
   (:X1 0)
   (:Y1 0)
   (:X2 20)
   (:Y2 20)
   (:line-style Opal:line-0)
   (:open-p T)
   (:filling-style Opal:no-fill)

   ; Generally non-customizable slots
   (:point-in-gob #'ArrowPointInGob)
   (:parts
    `((:line ,Opal:Line
	     (:x1 ,(o-formula (gv (path 0 :parent) :x1)))
	     (:y1 ,(o-formula (gv (path 0 :parent) :y1)))
	     (:x2 ,(o-formula
		    (if (and (gv (path 0 :parent :arrowhead) :open-p)
			     (null (gv (path 0 :parent :arrowhead)
				       :filling-style)))
			; then go to head
			(gv (path 1 :parent) :x2)
			; else go to connect-x
			(gv (path 0 :parent :arrowhead) :connect-x))))
	     (:y2 ,(o-formula
		    (if (and (gv (path 0 :parent :arrowhead) :open-p)
			     (null (gv (path 0 :parent :arrowhead)
				       :filling-style)))
			; then go to head
			(gv (path 1 :parent) :y2)
			; else go to connect-y
			(gv (path 0 :parent :arrowhead) :connect-y))))
	     (:line-style ,(o-formula (gv (path 0 :parent) :line-style))))
      (:arrowhead ,Opal:Arrowhead
	     (:from-x ,(o-formula (gv (path 0 :parent) :x1)))
	     (:from-y ,(o-formula (gv (path 0 :parent) :y1)))
	     (:head-x ,(o-formula (gv (path 0 :parent) :x2)))
	     (:head-y ,(o-formula (gv (path 0 :parent) :y2)))
	     (:line-style ,(o-formula (gv (path 0 :parent) :line-style)))
	     (:open-p ,(o-formula (gv (path 0 :parent) :open-p)))
	     (:filling-style ,(o-formula (gv (path 0 :parent)
					     :filling-style)))))))

;;;
;;;  DOUBLE-ARROW-LINE
;;;

;(create-instance 'DOUBLE-ARROW-LINE opal:aggregadget
;   ;; Customizable slots
;   (:X1 0)
;   (:Y1 0)
;   (:X2 40)
;   (:Y2 40)
;   (:line-style Opal:line-0)
;   (:open-p T)
;   (:filling-style Opal:no-fill)
;   (:arrowhead-p :both)  ; legal values are:
;			 ;  NIL, or 0  - no arrowheads
;			 ;  1          - arrowhead at end-point 1
;			 ;  2          - arrowhead at end-point 2
;			 ;  :both or 3 - arrowhead at both end-points
;
;   ; Generally non-customizable slots
;   (:point-in-gob #'Arrow2PointInGob)
;   (:arrow1-p (o-formula (case (gvl :arrowhead-p)
;			      ((NIL 0) NIL)
;			      (1 T)
;			      (2 NIL)
;			      ((:both 3) T))))
;   (:arrow2-p (o-formula (case (gvl :arrowhead-p)
;			      ((NIL 0) NIL)
;			      (1 NIL)
;			      (2 T)
;			      ((:both 3) T))))
;   (:parts
;    `((:line ,Opal:Line
;	     (:x1 ,(o-formula
;		    (if (or (not (gv (path 0 :parent) :arrow1-p))
;			    (and (gv (path 1 :parent :arrowhead1) :open-p)
;				 (null (gv (path 1 :parent :arrowhead1)
;					   :filling-style))))
;			; then go to head
;			(gv (path 0 :parent) :x1)
;			; else go to connect-x
;			(gv (path 1 :parent :arrowhead1) :connect-x))))
;	     (:y1 ,(o-formula
;		    (if (or (not (gv (path 0 :parent) :arrow1-p))
;			    (and (gv (path 1 :parent :arrowhead1) :open-p)
;				 (null (gv (path 1 :parent :arrowhead1)
;					    :filling-style))))
;			; then go to head
;			(gv (path 0 :parent) :y1)
;			; else go to connect-y
;			(gv (path 1 :parent :arrowhead1) :connect-y))))
;	     (:x2 ,(o-formula
;		    (if (or (not (gv (path 0 :parent) :arrow2-p))
;			    (and (gv (path 1 :parent :arrowhead2) :open-p)
;				 (null (gv (path 1 :parent :arrowhead2)
;					   :filling-style))))
;			; then go to head
;			(gv (path 0 :parent) :x2)
;			; else go to connect-x
;			(gv (path 1 :parent :arrowhead2) :connect-x))))
;	     (:y2 ,(o-formula
;		    (if (or (not (gv (path 0 :parent) :arrow2-p))
;			    (and (gv (path 1 :parent :arrowhead2) :open-p)
;				 (null (gv (path 1 :parent :arrowhead2)
;					   :filling-style))))
;			; then go to head
;			(gv (path 0 :parent) :y2)
;			; else go to connect-y
;			(gv (path 1 :parent :arrowhead2) :connect-y))))
;	     (:line-style ,(o-formula (gv (path 0 :parent) :line-style))))
;      (:arrowhead1 ,Opal:Arrowhead
;	     (:visible ,(o-formula (gv (path 0 :parent) :arrow1-p)))
;	     (:from-x ,(o-formula (gv (path 0 :parent) :x2)))
;	     (:from-y ,(o-formula (gv (path 0 :parent) :y2)))
;	     (:head-x ,(o-formula (gv (path 0 :parent) :x1)))
;	     (:head-y ,(o-formula (gv (path 0 :parent) :y1)))
;	     (:line-style ,(o-formula (gv (path 0 :parent) :line-style)))
;	     (:open-p ,(o-formula (gv (path 0 :parent) :open-p)))
;	     (:filling-style ,(o-formula (gv (path 0 :parent) :filling-style))))
;      (:arrowhead2 ,Opal:Arrowhead
;	     (:visible ,(o-formula (gv (path 0 :parent) :arrow2-p)))
;	     (:from-x ,(o-formula (gv (path 0 :parent) :x1)))
;	     (:from-y ,(o-formula (gv (path 0 :parent) :y1)))
;	     (:head-x ,(o-formula (gv (path 0 :parent) :x2)))
;	     (:head-y ,(o-formula (gv (path 0 :parent) :y2)))
;	     (:line-style ,(o-formula (gv (path 0 :parent) :line-style)))
;	     (:open-p ,(o-formula (gv (path 0 :parent) :open-p)))
;	     (:filling-style ,(o-formula (gv (path 0 :parent)
;					     :filling-style)))))))
;


;;;
;;;  DEMO FUNCTION
;;;
#|
(defun arrow-line-go ()

  (create-instance 'arrow-line-win inter:interactor-window
		   (:left 700) (:top 10) (:width 300) (:height 300)
		   (:aggregate
		    (create-instance 'arrow-line-agg Opal:aggregate)))

  ;;
  ;; Buttons which change the appearance of the arrow lines
  ;;
  (create-instance 'arrowbutton Opal:text
		   (:selected 2)
		   (:string (o-formula (case (gvl :selected)
					 (0 "No Arrows")
					 (1 "At initial end")
					 (2 "At final end")
					 (3 "At both ends")
					 (T (Error "bad value")))))
		   (:left 20)(:top 10))
  (create-instance 'arrowfillbutton Opal:text
		   (:selected 0)
		   (:fill (o-formula (case (gvl :selected)
					 (0 NIL)
					 (1 Opal:Black-Fill)
					 (2 Opal:Light-Gray-Fill)
					 (T (Error "bad value")))))
		   (:string (o-formula (case (gvl :selected)
					 (0 "No Fill")
					 (1 "Black Fill")
					 (2 "Light-Gray Fill")
					 (T (Error "bad value")))))
		   (:left 20)(:top 30))
  (create-instance 'arrowOpenpbutton Opal:text
		   (:selected T)
		   (:string (o-formula (if (gvl :selected)
					   "Open"
					   "Not Open")))
		   (:left 200)(:top 10))


  ;;
  ;; Objects that the arrows are attached to
  ;;
  (create-instance 'single-circle opal:circle
     (:box (list 10 100 20 20))  ; changed by the interactor
     (:left (o-formula (first (gvl :box))))
     (:top (o-formula (second (gvl :box))))
     (:width (o-formula (third (gvl :box))))
     (:height (o-formula (fourth (gvl :box))))
     (:right (o-formula (+ (gvl :left) (gvl :width))))
     (:center-y (o-formula (+ (gvl :top)
			      (floor (gvl :height) 2)))))
  (create-instance 'single-rect opal:rectangle
     (:box (list 150 110 30 30))  ; changed by the interactor
     (:left (o-formula (first (gvl :box))))
     (:top (o-formula (second (gvl :box))))
     (:width (o-formula (third (gvl :box))))
     (:height (o-formula (fourth (gvl :box)))))
  (create-instance 'double-circle opal:circle
     (:box (list 10 170 20 20))  ; changed by the interactor
     (:left (o-formula (first (gvl :box))))
     (:top (o-formula (second (gvl :box))))
     (:width (o-formula (third (gvl :box))))
     (:height (o-formula (fourth (gvl :box))))
     (:right (o-formula (+ (gvl :left) (gvl :width))))
     (:center-y (o-formula (+ (gvl :top)
			      (floor (gvl :height) 2)))))
  (create-instance 'double-rect opal:rectangle
     (:box (list 150 180 30 30))  ; changed by the interactor
     (:left (o-formula (first (gvl :box))))
     (:top (o-formula (second (gvl :box))))
     (:width (o-formula (third (gvl :box))))
     (:height (o-formula (fourth (gvl :box)))))


  ;;
  ;; Definition of the arrow line instances
  ;;
  (create-instance 'myarrow1 Arrow-line
		   (:x1 (o-formula (gv single-circle :right)))
		   (:y1 (o-formula (gv single-circle :center-y)))
		   (:x2 (o-formula (gv single-rect :left)))
		   (:y2 (o-formula (gv single-rect :top)))
		   (:open-p (o-formula (gv arrowOpenpbutton :selected)))
		   (:filling-style (o-formula (gv arrowfillbutton :fill))))

  (create-instance 'myarrow2 Double-arrow-line
		   (:x1 (o-formula (gv double-circle :right)))
		   (:y1 (o-formula (gv double-circle :center-y)))
		   (:x2 (o-formula (gv double-rect :left)))
		   (:y2 (o-formula (gv double-rect :top)))
		   (:open-p (o-formula (gv arrowOpenpbutton :selected)))
		   (:arrowhead-p (o-formula (gv arrowbutton :selected)))
		   (:filling-style (o-formula (gv arrowfillbutton :fill))))

  (Opal:add-components arrow-line-agg arrowbutton arrowOpenpbutton
		       arrowfillbutton myarrow1 myarrow2 single-circle
		       single-rect double-circle double-rect)
  (Opal:Update arrow-line-win)


  ;;
  ;; Interactors for the mode buttons
  ;;
  (create-instance 'interarrowbutton Inter:button-interactor
		   (:continuous NIL)
		   (:start-where `(:in ,arrowbutton))
		   (:window arrow-line-win)
		   ;; use a list of 2 numbers and interactor will do MOD
		   (:waiting-priority inter:high-priority-level)
		   (:how-set (list 1 4)))
  (create-instance 'interarrowfillbutton Inter:button-interactor
		   (:continuous NIL)
		   (:start-where `(:in ,arrowfillbutton))
		   (:window arrow-line-win)
		   (:waiting-priority inter:high-priority-level)
		   (:how-set (list 1 3)))
  (create-instance 'interarrowopenpbutton Inter:button-interactor
		   (:continuous NIL)
		   (:start-where `(:in ,arrowOpenpbutton))
		   (:window arrow-line-win)
		   (:waiting-priority inter:high-priority-level)
		   (:how-set :toggle))

  ;;
  ;; Interactors to move the objects that the arrows are attached to
  ;;
  (create-instance 'intersinglecirc Inter:Move-Grow-Interactor
		   (:start-where `(:in ,single-circle))
		   (:running-where T)
		   (:window arrow-line-win)
		   (:line-p NIL))
  (create-instance 'intersinglerect Inter:Move-Grow-Interactor
		   (:start-where `(:in ,single-rect))
		   (:window arrow-line-win)
		   (:running-where T)
		   (:line-p NIL))
  (create-instance 'interdoublecirc Inter:Move-Grow-Interactor
		   (:start-where `(:in ,double-circle))
		   (:running-where T)
		   (:window arrow-line-win)
		   (:line-p NIL))
  (create-instance 'interdoublerect Inter:Move-Grow-Interactor
		   (:start-where `(:in ,double-rect))
		   (:window arrow-line-win)
		   (:running-where T)
		   (:line-p NIL))

  (format T "ArrowLines:
   Press on the text at the top of the window with the left mouse button
   to change modes.
   Press on and drag one of the circles or rectangles to move it.~%")

  (Opal:Update arrow-line-win))


(defun arrow-line-stop ()
  (Opal:destroy arrow-line-win))
|#

;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/gadgets-changes.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : gadgets-changes.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Sun Jul 21 17:15:10 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Feb 21 11:39:11 1992
;;;; Update Count    : 13
;;;; 
;;;; PURPOSE
;;;; 	|>Description of module's purpose<|
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

(eval-when (eval compile load)
  (in-package "GARNET-GADGETS"))

(eval-when (eval compile load)
  (proclaim '(special x-set-function-button-panel
                      x-variable-button-panel))
  (export '(;; variables & schema
            x-set-function-button-panel
            x-variable-button-panel
            ;; functions
            x-button-interactor-final-function 
           )
    (find-package "GARNET-GADGETS")))



;;;
;;; 	II.	X-button-interactor
;;;

;; removed the shadow in the x-button in x-button-panel
;; removed the shadow in the x-button, see the garnet source
;; set shadow offset to be 0
;; did the same for radio buttons to save space

(defun x-button-interactor-final-function (interactor final-obj-over)
  #-release-garnet
 "The essential code from x-button.lisp for x-buttons final-function"
 (let* ((action (g-value final-obj-over :action))
	(gadget (g-value interactor :operates-on))
	(string (g-value final-obj-over :string))
	(value-obj (g-value gadget :x-button-list :selected)))
   ;; Propagate change toward :value slot
   (s-value gadget :value-obj value-obj)
   ;; Global function executed whenever selections change
   (kr-send gadget :selection-function gadget
	    (mapc #'(lambda (object) (g-value object :string))
		  value-obj))
   ;; If the button is selected, then execute the local function
   (when (member final-obj-over value-obj)
	 (when action
	    (funcall action gadget string)))  ))

;;;
;;;	III.	x-set-function-button-panel
;;;

(defun xno-op (&optional &rest args) 
  #-release-garnet
  "Does nothing."
  (declare (ignore args))
  nil)

;; just like an x-button but calls the set-function and unset-function
;; gadget is bound to the button for the set and unser functions to use

(create-instance 'x-set-function-button-panel garnet-gadgets:x-button-panel
  (:text-on-left-p nil)
  (:set-function 'xno-op)
  (:unset-function 'xno-op)
  (:interactors
  `((:X-BUTTON-PRESS ,inter:button-interactor 
      (:start-where ,(o-formula (list :element-of
      				(gvl :operates-on :x-button-list))))
      (:window ,(o-formula (gv-local :self :operates-on :window)))
      (:how-set :list-toggle)
      (:final-function  ;have problems compiling this full force, ie ,#'
       ,#'(lambda (interactor final-obj-over)
	   (let ( (gadget (g-value interactor :operates-on)) )
            (x-button-interactor-final-function interactor final-obj-over)
            (funcall (if (g-value gadget :x-button-list :selected)
			 (g-value gadget :set-function)
			 (g-value gadget :unset-function))
		      gadget))))))))


;; just like an x-button but sets and unsets the :variable
(create-instance 'x-variable-button-panel garnet-gadgets:x-button-panel
  (:left 10)
  (:text-on-left-p nil)
  (:top 20)
  (:items nil)
  (:variable nil)  ;must have a variable here!
  (:interactors
  `((:X-BUTTON-PRESS ,inter:button-interactor 
      (:start-where ,(o-formula (list :element-of
      				(gvl :operates-on :x-button-list))))
      (:window ,(o-formula (gv-local :self :operates-on :window)))
      (:how-set :list-toggle)
      (:final-function
       ,#'(lambda (interactor final-obj-over)
            (x-button-interactor-final-function interactor final-obj-over)  
            (let* ((gadget (g-value interactor :operates-on))
                   (value-obj (g-value gadget :x-button-list :selected)))
             (if value-obj (set (g-value gadget :variable) t) 
                           (set (g-value gadget :variable) nil)))))))))

;;; Concatenated from type module "contrib" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/contrib/f1.4/choice-gadget.lisp".
;;; -*- mode: Lisp; syntax: common-lisp; package: GARNET-GADGETS; base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : choice-gadget.lisp
;;;; author          : frank ritter
;;;; created on      : fri feb 22 13:41:50 1991
;;;; last modified by: Thomas McGinnis
;;;; last modified on: Wed Apr  1 14:22:26 1992
;;;; update count    : 87
;;;; 
;;;; purpose
;;;; 	provides a gadget for presenting a multiple valued choice to the user.
;;;  
;;;; table of contents
;;;;
;;;;	i.	disclaimer and programmer notes
;;;;	ii.	package initialization and such
;;;;
;;;;	I.	display-choice function
;;;;	II.	graphic-yes-or-no-p
;;;;	III.	new change-priority level
;;;;	IV.	Choice-gadget
;;;;	V.	initialize & destroy methods for Choice-Gadget
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;; Optimizations: doc-strings; proclaim vars funs; declares; lambdas
;;;      no optional, no keywords


;;;
;;;	i.	disclaimer and programmer notes
;;;___________________________________________________________________
;;; the garnet user interface development environment
;;; copyright (c) 1990, carnegie mellon university
;;; all rights reserved.  the cmu software license agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; if you want to use this code or anything developed as part of the
;;; garnet project, please contact brad myers (brad.myers@cs.cmu.edu).
;;;___________________________________________________________________
;;;
;;;  choice gadget, Copyright 1991, frank ritter
;;;
;;;   features: the choice-gadget can be used in applications where
;;;   the designer wants to allow (or force) the user to make a
;;;   choice.  when the display-choice function (described below) is
;;;   called, the choice window becomes visible (at the appropriate
;;;   size) and displays the choices.  if modal-p the user must then
;;;   click on a choice button before proceeding graphically.  if
;;;   really-modal-p, then lisp hangs also.  the slot names and
;;;   behavior are similar to the error-gadget and the labeled box gadget.
;;;
;;;  customizable slots: 
;;;   1) parent-window - the window that the choice window should be centered
;;;          inside of
;;;   2) font - the font for the prompt, and help string
;;;      items-font - the font for the items
;;;   3) justification - how to justify the multi-line message
;;;   4) modal-p - whether to shut down all other interactors until a
;;;          button has been pressed
;;;   4b) really-modal-p - whether to hang all lisp processing until a
;;;      button has been pressed.
;;;   5) window-left, window-top -- where the window will appear.  
;;;       The default is centered in the parent window, or at 100, 200.
;;;       You can set these.
;;;      window-width, window-height - dimensions of the choice window
;;;          (automagically set, you should  not set these slots)
;;;   6) window - the window created by the error-gadget (do not set this slot)
;;;   7) sleep-time - how often to check (really-modal-p)
;;;          to see if the user has done anything.
;;;   8) choices -- the default choices are "yes" and "no".  these can be set
;;;          by hand, or with display-choice
;;;
;;;  programmer's interface:
;;;   in order to associate an choice window with an application, an instance
;;;   of the choice-gadget should be created with the :parent-window slot
;;;   set to the window of the application.  to activate the choice
;;;   window, call the function display-choice, which takes the instance of
;;;   the choice-gadget, the choices and the desired message as parameters.
;;;   this is very similar to the error gadget.
;;;
;;;  caveats:
;;;   1) update the parent window before instantiating the choice-gadget.
;;;   2) the instance of the choice-gadget should not be added to an aggregate.
;;;      bookkeeping for the parent window is automatically taken care of
;;;      during the create-instance call.
;;;
;;; change log
;;; 6-26-91 - commented out shadow info
;;; 02/26/91  created fer
;;;


;;;
;;;	ii.	package initialization and such
;;;

(eval-when (load eval compile)
  (in-package "GARNET-GADGETS"))

(eval-when (load eval compile)
  (deftype logical () '(or t nil))
  (deftype a-schema-type () '(member a-schema))
  (deftype a-schema-or-nil () '(or a-schema-type nil))
  (deftype image-x () '(or image-x)))

(eval-when (load eval compile)
  (export '(choice-gadget display-choice graphic-yes-or-no-p)
      (find-package "GARNET-GADGETS")))

(eval-when (load eval compile)
  (proclaim '(special CHOICE-GADGET CHOICE-PRIORITY-LEVEL))
  (proclaim '(type a-schema-type CHOICE-GADGET CHOICE-PRIORITY-LEVEL))
)


;;;
;;;	I.	display-choice function
;;;

(defun display-choice (&optional gadget prompt choices beep-p)
 #-release-garnet
 "Display the choice-gadget using choices and prompt."
  (declare (type a-schema-or-nil gadget)
           (string prompt) (list choices) (type logical beep-p))
  (if (not gadget) (setf gadget choice-gadget))
  ;; activate modal feature if appropriate
  (if (g-value gadget :modal-p)
      (s-value choice-priority-level :stop-when :always)
      (s-value choice-priority-level :stop-when :if-any))

  ;; set the prompt and choices to be displayed
  (if prompt (s-value gadget :string prompt))
  (if choices (s-value gadget :choices choices))

  ;; this may work, or else remove-component all elem, & add-component them
  (opal:notice-items-changed (g-value gadget :buttons :text-button-list))

  ;; turn visibility on
  (let ((window (g-value gadget :window)))
    (s-value window :left (g-value window :left))
    (s-value window :top (g-value window :top))     ; won't size correctly
    (s-value window :width (g-value window :width))   ;  without these lines
    (s-value window :height (g-value window :height))
    (opal:update window)  ; this resizes before drawing
    (s-value window :visible t)
    (opal:update window)
    )
  (if beep-p
      (inter:beep))
  ;; make sure it gets clicked if really-modal-p
  (if (g-value gadget :really-modal-p)
      (prog ((sleep-time (g-value gadget :sleep-time))
	     (display (let ((win1 (caar (opal::get-table-contents))))
	                (if win1
 			    (xlib:window-display win1)
                            opal::*default-x-display*))) )
	  start
	    ;; call the event handler to get anything
            (opal::default-event-handler display :timeout 0)
            (sleep sleep-time)
	    (if (g-value gadget :window :visible)
		(go start))
	    (return (g-value gadget :value))))
  (g-value gadget :buttons :value)  )

;;;
;;;	II.	graphic-yes-or-no-p
;;; 

(defun graphic-yes-or-no-p (gadget prompt &optional (choices '("Yes" "No")))
  (declare (type a-schema-type gadget) (string prompt) (list choices))
  (if (string= (first choices)
	       (display-choice gadget prompt choices))
      t
      nil))



;;;
;;;	III.	New change-priority level
;;;

;;    This function creates a new priority level and adds it to the front
;; of the interactors priority level list.  Thus, this level has higher
;; priority than the default inter-levels.
;;    This priority level are needed in case the choice-gadget is modal.
;; The idea is to set the CHOICE-PRIORITY-LEVEL's :stop-when to :always
;; when the choice-gadget is modal, so that the choice buttons are the
;; only gadgets that will work in the entire interface while the
;; choice-window is visible.  So, the effect is to shut down the rest of
;; the interface until the user clicks on a button (if the choice-gadget
;; is modal).  Other things can happen in lisp unless the really-modal-p
;; is chosen.

  (unless (and (boundp 'CHOICE-PRIORITY-LEVEL)
	       (member CHOICE-PRIORITY-LEVEL inter:priority-level-list))
    (push (create-instance 'CHOICE-PRIORITY-LEVEL inter:priority-level)
	  inter:priority-level-list))


;;;
;;;	IV.	Choice-gadget
;;;

;; NOTE:  If :parent-window is specified, then the parent window must already
;; have been opal:update'd when the instance of CHOICE-GADGET is created.
;;

(create-instance 'CHOICE-GADGET opal:aggregadget
   (:width (o-formula (MAX (gvl :text :width)
			   (gvl :help-text :width) (gvl :buttons :width))))
   (:height (o-formula (+ 30 (gvl :text :height) (gvl :help-text :height) (gvl :buttons :height))))

   ;; If there is no parent window, then the choice window is created at
   ;; position (200, 200).
   (:window-left (o-formula (if (gvl :parent-window)
				(- (floor (gvl :parent-window :width) 2)
				   (floor (gvl :window-width) 2))
				100)))
   (:window-top (o-formula (if (gvl :parent-window)
			       (- (floor (gvl :parent-window :height) 2)
				  (floor (gvl :window-height) 2))
			       100)))
   (:window-width (o-formula (+ 20 (gvl :width))))    ; 10 on each side
   (:window-height (o-formula (+ 40 (gvl :height))))  ; 20 on top, bottom
   (:window-title "Choice message")
   (:modal-p T)
   (:string "Choice?")
   (:help-string "(click on choice to proceed)")
   (:really-modal-p nil) ; do you force user to click before doing *anything*
   (:sleep-time 0.1) ;for really-modal-p, time in s between checking if done
   (:parent-window NIL)    ;; The parent of the choice-window
   (:choices '("Yes" "No"))
   (:font opal:default-font)
   (:items-font opal:default-font)   
   (:justification :center)
   (:destroy 'Choice-Gadget-Destroy)
   (:parts `(
      (:text ,opal:multi-text
         (:left ,(o-formula 10))
         (:top 20)
         (:justification ,(o-formula (gvl :parent :justification)))
	 (:string ,(o-formula (gvl :parent :string)))
	 (:font ,(o-formula (gvl :parent :font))))
      (:help-text ,opal:multi-text
         (:left ,(o-formula 10))
         (:top ,(o-formula (+ 20 (opal:gv-bottom (gvl :parent :text)))))       
         (:justification ,(o-formula (gvl :parent :justification)))
	 (:string ,(o-formula (gvl :parent :help-string)))
	 (:font ,(o-formula (gvl :parent :font)))) 
      (:buttons ,text-button-panel
        (:left ,(o-formula 30))
        (:top ,(o-formula (+ 20 (opal:gv-bottom (gvl :parent :help-text)))))
        (:items ,(o-formula (gvl :parent :choices)))
        (:font ,(o-formula (gvl :parent :items-font)))
        (:h-align :center)
        (:text-on-left-p nil)
        ; shadow offset set to 0 to save space and time
        (:shadow-offset 0) (:text-offset 5) (:gray-width 3)
        (:final-feedback-p NIL)
	(:selection-function
		,#'(lambda (gadget value)
		     (declare (ignore value) (type a-schema-type gadget))
		     (let ((window (g-value gadget :window)))
		       (s-value window :visible NIL)
        	       ;(opal:update window)
		       (s-value CHOICE-PRIORITY-LEVEL :stop-when NIL))))
        (:interactors (
           (:text-BUTTON-PRESS :modify
	   (:waiting-priority ,CHOICE-PRIORITY-LEVEL)
           (:active T)
	   (:running-priority ,CHOICE-PRIORITY-LEVEL))))   )))
)


;;;
;;;	V.	initialize & destroy methods for Choice-Gadget
;;;

(define-method :initialize CHOICE-GADGET (choice-gadget)
  (call-prototype-method choice-gadget)
  (let ((window
	 (create-instance NIL inter:interactor-window
	    (:left (o-formula (gvl :aggregate :components :window-left)))
	    (:top (o-formula (gvl :aggregate :components :window-top)))
	    (:title (o-formula (gvl :aggregate :components :window-title)))
	    (:width (o-formula (gvl :aggregate :components :window-width)))
	    (:height (o-formula (gvl :aggregate :components :window-height)))
	    (:parent (g-value choice-gadget :parent-window))
	    (:visible NIL)))
	(aggregate (create-instance NIL opal:aggregate)))
    (s-value window :aggregate aggregate)
    ;;; The :window slot of choice-gadget is automatically set by add-component
    (opal:add-component aggregate choice-gadget)
    (opal:update window)))

(defun Choice-Gadget-Destroy (choice-gadget &optional erase)
  ;; first, remove the gadget from its window so when the window is
  ;; destroyed, the gadget will not be.  
  ;; Then destroy the gadget itself
  ;; using call-prototype-method
  (declare (type a-schema-type choice-gadget))
  (let ((agg (g-value choice-gadget :parent))
	(window (g-value choice-gadget :window)))
    (when agg
      (opal:remove-component agg choice-gadget))
    ;; make sure window isn't already being destroyed
    (when (and window
	       (schema-p window)
	       (gethash (get-local-value window :drawable)
			opal::*drawable-to-window-mapping*))
      (opal:destroy window))
    (call-prototype-method choice-gadget erase)))


;;;
;;;	V.	Demo code
;;;

#|  
;;; Take off # | comments markers at front and end to run

(defparameter test-choice NIL)

(defun choice-gadget-Go ()
  (create-instance 'test-choice gg:choice-gadget
     (:window-title "Test question")
     (:really-modal-p t)
     (:top 5) (:left 650))

 (format t "Asked the user and got ~a back.~%" (display-choice test-choice))
  
 ;; Test choice has two choices, then 3 choices, and Hobson's choice is
 ;; no choice at all, which should be one alternative.

 (gg:display-choice test-choice "Future Big 10 Teams:"
		    '("Chatham" "MIT" "Pitt"))

 (gg:display-choice test-choice "Hobsen's choices:"
		    '("Pick me!"))
 (gg:graphic-yes-or-no-p "Do we really have a choice in the end?")
 )

(defun choice-gadget-Stop ()
  (opal:destroy text-Buttons-win))

(export '(choice-gadget-go choice-gadget-Stop)
	(find-package "GARNET-GADGETS"))
|#

;;; Concatenated from type module "contrib" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/contrib/f1.4/popup-inter.lisp".
;;; -*- Mode: lisp; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : popup-inter.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Mon Jan  7 18:36:18 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Feb 21 15:43:24 1992
;;;; Update Count    : 31
;;;; 
;;;; PURPOSE
;;;; This file contains an interactor to popup menus.
;;;; It should be loaded after Interactors.lisp and movegrow.lisp.
;;;;
;;;; TABLE OF CONTENTS
;;;;	i.	minor inits
;;;; 	ii.	Main Default Procedures to go into the slots
;;;;	iii.	go procedures
;;;; 	I.	popup-interactor schema
;;;; 
;;;; (C) Copyright 1990, Frank Ritter, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;
;;; Designed and implemented by Brad A. Myers & Frank Ritter
#|


============================================================
Change log:
        1/17/91  Frank Ritter - wrote a popup-interactor.
        ...
	8/8/88 Brad Myers - analogous code started
============================================================
|#

;;;
;;;	i.	minor inits
;;;

(in-package "INTERACTORS" :use '("LISP" "KR") :nicknames '("INTER"))
(export '(popup-interactor))
(proclaim '(special popup-Interactor))
;; requires move-grow interactors


;;;
;;; 	ii.	Main Default Procedures to go into the slots
;;;============================================================
;;;

(defun popup-Int-Start-Action (an-interactor object-being-changed
						  first-points)
#+release-garnet (declare (ignore an-interactor object-being-changed
						  first-points))
#-release-garnet  (if-debug an-interactor 
     (format T "Popup int-start moving ~s firstpoints=~s~%"
             object-being-changed first-points))
  )

(defun popup-Int-Running-Action (an-interactor object-being-changed
						    new-points)
#+release-garnet (declare (ignore an-interactor object-being-changed
						  new-points))
#-release-garnet  (if-debug an-interactor 
     (format T "Popup int-running, obj = ~s, popups=~s~%"
	      object-being-changed new-points))
  )

(defun popup-Int-Back-Inside-Action 
       (an-interactor outside-control object-being-changed new-inside-points)
#+release-garnet (declare (ignore an-interactor outside-control
                                  object-being-changed new-inside-points))
#-release-garnet (declare (ignore outside-control))
#-release-garnet  (if-debug an-interactor 
	    (format T "Popup int-back-in, obj = ~s, new popups=~s~%"
		    object-being-changed new-inside-points))
  )

(defun popup-Int-Stop-Action (an-interactor object-being-changed)
#-release-garnet  (if-debug an-interactor (format T "Popup int-stop obj ~s "
				  object-being-changed ))
  ;;turn off feedback
  (KR-Send an-interactor :final-function an-interactor object-being-changed))

(defun popup-Int-Abort-Action (an-interactor object-being-changed)
#+release-garnet (declare (ignore an-interactor object-being-changed))
#-release-garnet  (if-debug an-interactor (format T "Popup int-abort moving ~s~%"
				  object-being-changed))
  )
  
(defun popup-Interactor-Initialize (new-Move-Grow-schema)
#-release-garnet  (if-debug new-Move-Grow-schema (format T "Select change initialize ~s~%"
					 new-Move-Grow-schema))
  (Check-Interactor-Type new-Move-Grow-schema inter:popup-Interactor)
#-release-garnet
  (Check-Required-Slots new-Move-Grow-schema)
  (Set-Up-Defaults new-Move-Grow-schema)  )


;;;
;;;	iii.	go procedures
;;;============================================================
;;; Go procedure utilities
;;;============================================================

;;; if continuous: (remove from start level, add to stop and abort
;;; 		    level, change state to running)
;;; save object over, call start procedure.
(defun popup-do-start (an-interactor new-obj-over event)
  #-release-garnet  (if-debug an-interactor (format T "Popup starting over ~s~%" new-obj-over))
  ;; note where you came from for later use
  (s-value an-interactor :x (event-x event))
  (s-value an-interactor :y (event-y event))
  (if (g-value an-interactor :continuous)  ;then will go to running state
      (progn
        (GoToRunningState an-interactor T)
        (kr-send an-interactor :start-action an-interactor new-obj-over))
    ;else call stop-action
    (progn
      (kr-send an-interactor :stop-action an-interactor new-obj-over)
      (GoToStartState an-interactor NIL)))
 )


(defun popup-do-back-inside (an-interactor obj event)
#+release-garnet (declare (ignore an-interactor obj event))
#-release-garnet  (if-debug an-interactor (format T "Popup back-inside over ~s at:~s~%"
				  obj event))
  )

(defun popup-do-running (an-interactor obj event)
#+release-garnet (declare (ignore an-interactor obj event))
#-release-garnet  (if-debug an-interactor (format T "Popup running over ~s at:~s~%" obj event))
  )

(defun popup-do-stop (an-interactor obj event)
#+release-garnet (declare (ignore an-interactor obj event))
#-release-garnet  (if-debug an-interactor (format T "Point stop over ~s at:~s~%" obj event))
)


;;;
;;; 	I.	popup schema
;;;============================================================

(Create-Schema 'inter:Popup-Interactor
     (:is-a inter:interactor)
     (:name :First-Move-Grow-interactor)
     (:start-action 'popup-Int-Start-Action)
     (:running-action 'popup-Int-Running-Action)
     (:stop-action 'popup-Int-Stop-Action)
     (:abort-action 'popup-Int-Abort-Action)
     (:outside-action 'popup-Int-Outside-Action)
     (:back-inside-action 'popup-Int-Back-Inside-Action)
     (:obj-to-change NIL)  ;supplied by application program
     (:attach-popup :where-hit) ; where attach to object
     (:x-off 0) ; needed for :where-hit.  Offset from where
     (:y-off 0)    ;    hit to top left of object
     (:saved-original-points NIL) ; used for ABORT or outside
     (:saved-last-points NIL) ; used if stop and outside and
                              ; outside control is :last
     (:Go 'General-Go)  ; proc executed when events happen
     (:Do-Start 'popup-Do-Start)     ; these are
     (:Do-Running 'popup-Do-Running) ;   called by GO
     (:Do-Stop 'popup-Do-Stop)       ;   to do
     (:Do-Abort 'Move-Grow-Do-Abort)     ;   the real work.
     (:Do-Outside 'Move-Grow-Do-Outside) ;   They call the
     (:Do-Back-Inside 'popup-Do-Back-Inside)  ; appropriate
     (:Do-Outside-Stop 'Move-Grow-Do-Outside-Stop); -action
                                                  ; procedures
     (:initialize 'popup-Interactor-Initialize))

;;; Concatenated from type module "contrib" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/contrib/f1.4/popup-menu.lisp".
`;;;; -*- Mode: Lisp; package: garnet-gadgets -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : popup-menu.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jul 13 18:26:30 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Sun Mar 15 15:57:12 1992
;;;; Update Count    : 230
;;;; 
;;;; PURPOSE
;;;; 	provides a pop-up-menu for the sx, based on garnet.
;;;; TABLE OF CONTENTS
;;;;
;;;;	i.	inits
;;;;	I.	create-pop-up-menu
;;;	II.	Popup-window
;;;; 
;;;; (C) Copyright 1990, Frank Ritter, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

;;;
;;;	i.	inits
;;;


(eval-when (load eval compile)
 ;; make sure to avoid soarsyntax changes
  #+soar5(and (soarsyntax) (soarresetsyntax))
  )

(in-package "OPAL")

(export '(font-fixed-bold-medium
          default-double-buffer-p))

(create-instance 'opal:font-fixed-bold-medium opal:font
   (:family :fixed)
   (:face :bold)
   (:size :medium))

;; have to define it here too in case user doesn't have opal-changes loaded,
;; but with a dispatch macro we'll get rid of it in our code....
;; 21-Feb-92 -FER
#-release-garnet
(defvar default-double-buffer-p  nil
   "*If T windows are double-buffered for faster redisplay with
corresponding increase in space.")


(in-package "GARNET-GADGETS" :use '("LISP" "KR"))

(export '(create-pop-up-menu  popup-window))

;;;
;;;	I.	create-pop-up-menu
;;;

(defun create-pop-up-menu
     (&key (double-buffered-p opal:default-double-buffer-p)
           items click-window
	   (menu-window-name 'popup-menu-window)
	   (title "POPUP-MENU")
	   (icon-title "POPUP")
           (disappear-after-selection t)
           (after-action nil)
	   (menu-event :ANY-mouseDOWN)
	   (start-event :ANY-mouseDOWN) )  ;had been LEFT
  #-release-garnet
  "Create a pop-up-menu with MENU-window-NAME (the actual menu item is in its
:menu slot) of ITEMS, with TITLE and ICON-TITLE,
bring up on START-EVENT in CLICK-WINDOW, DOUBLE-BUFFERED-P iff T.  After
each action, execute AFTER-ACTION, and if DISAPPEAR-AFTER-SELECTION is t,
then hide the menu."
  ;; remembers what you previously selected and puts you there
  ;; clips to keep menu on the screen
  (let ((sub-menu (intern (format nil "~s-GADGET" menu-window-name)))
	(menu-agg (intern (format nil "~s-menu-agg" menu-window-name)))
	(menu-inter (intern (format nil "~s-INTER" menu-window-name))) )
  (if (and (boundp sub-menu) (schema-p (eval sub-menu)))
      (progn (opal:destroy (g-value (eval sub-menu) :selector))
	     (opal:destroy (eval sub-menu))))
  (if (and (boundp menu-window-name)
	   (schema-p menu-window-name))
      (opal:destroy menu-window-name))
  (create-instance menu-window-name inter:interactor-window
   (:double-buffered-p double-buffered-p)
   (:left 0) (:top 30) (:width 210) (:height 170)
   (:visible nil)
   (:aggregate (create-instance nil opal:aggregate
			        (:overlapping NIL)))
   (:title title)
   (:icon-title icon-title))
  (set menu-agg (g-value (eval menu-window-name) :aggregate))
  (create-instance sub-menu garnet-gadgets:menu
    (:left 0)    (:top 0)    (:shadow-offset 0)
    (:item-font opal:font-fixed-bold-medium)
    (:after-action after-action)
    (:title nil)
    (:disappear-after-selection disappear-after-selection)
    (:V-spacing -1) ; default appears to be 0
    (:items items)
    (:interactors
     `((:selector ,inter:menu-interactor
	 (:window ,(o-formula (gv-local :self :operates-on :window)))  
         (:start-where ,(o-formula (list :element-of
					(gvl :operates-on
					      :menu-item-list))))
	 (:running-where ,(o-formula (list :element-of
					   (gvl :operates-on
						:menu-item-list))))
	 (:start-event ,menu-event)
     	 (:how-set NIL)            
         (:menu ,(o-formula (gvl :operates-on :window))) ;store the window
	 (:feedback-obj ,(o-formula (gvl :operates-on :feedback)))
       	 (:abort-action
	    ,#'(lambda (interactor obj-over)
		 (call-prototype-method interactor obj-over)
                 (if (g-value interactor :operates-on
                              :disappear-after-selection)
                     (s-value (g-value interactor :menu) :visible NIL))))
         (:stop-action
          ,#'(lambda (interactor obj-under-mouse)
	      (let* ((action (g-value obj-under-mouse :action))
		     (gadget (g-value interactor :operates-on))
                     (after-action (g-value gadget :after-action))
		     (string (g-value obj-under-mouse :string)))
		(s-value (g-value gadget :feedback) :obj-over NIL)
		(s-value gadget :value-obj obj-under-mouse)
		;; Global function for all items
		(kr-send gadget :selection-function gadget string)
                (if (g-value interactor :operates-on
                              :disappear-after-selection)
                     (s-value (g-value interactor :menu) :visible NIL))
		(opal:update (g-value interactor :menu))
        	;; Local function assigned to item
		(when action
		  (funcall action gadget string))
                (when after-action
		  (funcall after-action gadget string)))))
            )))   )
  (eval (list 'opal:add-components menu-agg
       sub-MENU))
  (eval (list 'opal:update menu-window-name))
  (eval (list 's-value menu-window-name :menu sub-menu))
  ;; resize menu to fit
  (eval `(s-value ,menu-window-name :width (g-value ,sub-menu :width)))
  (eval `(s-value ,menu-window-name :height (g-value ,sub-menu :height)))
  ;; now create inter
  (if (and (boundp menu-inter)
	   (schema-p menu-inter))
      (opal:destroy menu-inter))
  ;; create inter to popup the menu
  (if start-event
      (create-instance menu-inter inter:popup-interactor
         (:start-where t)
         (:start-event start-event)
         (:window click-window)
         (:final-function
          `(lambda (an-interactor object-being-changed)
            (popup-window ,menu-window-name
             ;; this bit of magic here puts you over last item
          	:y-offset
         	(let* ((previous-object (g-value ,sub-menu :selector
                                              :remembered-last-object)) )
                  (if previous-object ;you've been there before
                      (- (g-value ,menu-window-name :height)
     		         (g-value previous-object :base-top)
                         (floor (/ (g-value ,menu-window-name :height) 2))
                          ) ;popup's correction
              	      0)))))
         (:continuous nil)
         (:running-where t)))
   ))


;;;
;;;	II.	Popup-window
;;;

;; cut 15-Mar-92 -FER, delete 1 may-92 or later
;; (defconstant max-display-width opal:*screen-width*) ;1000
;; (defconstant max-display-height opal:*screen-height*) ;800

(defun popup-window (possible-window &optional &key
		     (pop-to-last-mouse t)
		     (y-offset 0) (x-offset 0))
  #-release-garnet
  "De-iconify a window and move it to front of display list.
If it is common thing with a window (so far: scrolling-window-with-bars),
gracefully pop it instead."
  (let ( (window (cond ( (null possible-window)
                          (format t "popup-window passed ~s." possible-window)
			  (return-from popup-window nil))
                       ( (is-a-p possible-window inter:interactor-window)
			 possible-window)
                       ( (is-a-p possible-window
                                 GARNET-GADGETS:scrolling-window-with-bars)
			 (g-value possible-window :outer-window))
                       ( (is-a-p possible-window (g-value possible-window :window))
			 (g-value possible-window :window))
                       (t (format t "popup-window passed ~s." possible-window)
			  (return-from popup-window nil)) ))   )
  (s-value window :visible t)
  (if pop-to-last-mouse
      (progn 
        (s-value window :left (inter:clip-and-map
			  (- (+ x-offset (inter:event-x inter:*current-event*))
                             (floor (/ (g-value window :width) 2)) )
			  0 (-  opal:*screen-width* (g-value window :width)) ))
        (s-value window :top (inter:clip-and-map
			 (- (+ y-offset (inter:event-y inter:*current-event*))
                            (floor (/ (g-value window :height) 2)))
			 0 (- opal:*screen-height* (g-value window :height))))
	))
  ;; this deiconifies too
  (opal:raise-window window)
  ;  (setf (xlib:window-priority (g-value window :drawable))
  ;            :above)
  (s-value window :visible t)
  ;; this may be redundent...
  (kr-send window :update-yourself window)
  (opal:update window)  ))



;;; Concatenated from type module "contrib" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/contrib/f1.4/garnet-loop.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : garnet-loop.lisp<2>
;;;; Author          : Frank Ritter
;;;; Created On      : Thu Sep 27 14:10:14 1990
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Wed Apr  1 14:21:14 1992
;;;; Last really Modified On: Fri Mar  6 13:11:10 1992
;;;; Update Count    : 125
;;;; 
;;;; PURPOSE
;;;; 	A top level read-eval-print loop that allows lisp and Garnet to run
;;;; at the same time.
;;;;
;;;; TABLE OF CONTENTS
;;;;	i.	Overview
;;;;	ii.	Declares & proclaims & requires
;;;;	iii. 	Variable definitions
;;;;	iv.	Export statements
;;;;	v. 	Advanced user or Non-user variables
;;;;	vi.	Default commands for the loop
;;;;	vii.	Helper functions
;;;;	viii.	Necessary Extensions to Garnet
;;;;
;;;;	I.	Setting the cursor stuff
;;;;	II.	Run-uninterruptible-garnet-commands
;;;;	III.	g-inter-lam
;;;;	IV. 	Garnet read-eval-print loop (grepl)
;;;;	V.	Garnet-event-and-lisp-loop
;;;;	VI.	Garnet-lisp-repl
;;;;	VII.	Change to default-event-handler
;;;; 
;;;; Copyright 1990, Frank Ritter, permission to copy subject to the 
;;;; conditions below.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares; lambdas
;;;      not done:  optional, no keywords
;;; copies to:  Martin  zaidel@muzungu.cis.upenn.edu, bam,
;;;             "Sang K. Cha" <chask@eclipse.Stanford.EDU>
;;;             Joe Lammens <lammens@cs.Buffalo.EDU>
;;;             Michael Sannella <sannella@CS.WASHINGTON.EDU>
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

(eval-when (load eval compile)
  (in-package "OPAL"))


;;;
;;;	i.	Overview
;;;

#|
A small package for running the core of Garnet (the guts of
inter:main-event-loop) and lisp (eval) concurrently, for all machines,
without using parallel processes.  It's not great, but the price is
right.  Feel free to use it subject to the Free Software Foundation's
copyleft agreement.  It should also be fairly extendable.  This is not
an official part of Garnet, and comes with no guarantees whatsoever
(although I find it tremendously useful).

To use it, call the function grepl in the opal package.

Within garnet loop the prompt appears as "<garnet:current-package-name>".
In addition to running the essentials of inter:main-event-loop, 
several other actions are supported through forms on *garnet-repl-conditions*.

Beginning users need to set only the following variables:
  - garnet-Hour-Glass-Windows
  - *grepl-conditions*

Grepl works best if it has its input line buffered, as emacs does for
lisps running in a buffer.  Olin Shiver's (shivers@cs.cmu.edu) cmulisp
mode and Chris Chris McConnell's (ccm@cs.cmu.edu) ilisp both work well
with grepl.

Grepl is a busy loop.  To make this less onerous, you can nice the
lisp process down or increase the sleep time (with
grepl-loop-sleep-time).  I'm open to other suggestions.  I don't
notice a degredation on my workstation from running this loop, when
I'm just running garnet, but I admit to noticing it when doing other
things, or running a second lisp job.

Putting :release-garnet on *features* will lead to faster compiled code.
It strips out nonessential doc strings.

The header courtesy of software from Hucka@umich, file format taken 
from Milnes@cs.cmu.edu.

Frank Ritter@psy.cmu.edu, September 28, 1990
With comments by Pedro Szekely@venera.isi.edu, Ed Pervin@cs.cmu.edu
|#


;;; 
;;;	ii.	Declares & proclaims & requires
;;;

#-kr-deftypes
(eval-when (load eval compile)
  (deftype logical () '(or t nil))
  ;; fix for bonghan 14-Feb-92 -FER
  (deftype a-schema-type () '(member a-schema))
  (deftype a-schema-or-nil () '(or a-schema-type nil))
  (deftype image-x () '(or image-x)))

(eval-when (load eval compile)
  (proclaim '(type logical *quit-grepl*
                           *garnet-running*))
  (proclaim '(cons RegularCursor HourGlassCursor))
  (proclaim '(list garnet-Hour-Glass-Windows
                   unrun-garnet-commands
                   *grepl-conditions*              
                   grepl-history))
  (proclaim '(string grepl-supersystem-name
                     grepl-loading-directory
                     rewelcome-to-grepl
                     goodbye-to-grepl
                     welcome-to-grepl))
  (proclaim '(number grepl-loop-sleep-time))
  ;; how do you proclaim a variable that holds a fun with keyword args?
  ;;(proclaim '(function grepl-prompt-function))
  (proclaim '(function print-grepl-help-message () nil))
  (proclaim '(function whitespace-char-p (character) logical))
  (proclaim '(function update-all-windows () nil))
  ;;; I.
  (proclaim '(function Get-Garnet-Bitmap (string) a-schema-type))
  (proclaim '(function grepl () ()))
)


;;;
;;;	iii. 	Variable definitions and Export statements
;;;
;;; You can set these in your lisp init file (such as .clinit-cl for Allegro).
;;;
;;; *'s indicate variables most developers will have or may wish to change
;;; There are no user variables per se in this loop.

(defparameter garnet-Hour-Glass-Windows nil
  #-release-garnet
 "*Windows that get the hourglass on them when long computations are started.")

(defvar grepl-prompt-function 'print-grepl-prompt  ;no sharp before definition
  #-release-garnet
  "*Function to call to print prompt.  Expects a stream to be passed as arg.")

(defvar grepl-supersystem-name "garnet"
  #-release-garnet
  "*Name of system using garnet, such as Soar; this appears in prompt.")

(defparameter grepl-loading-directory "/usr/"
  #-release-garnet
  "*Default dir to load files from.")

(defvar grepl-loop-sleep-time .4
  #-release-garnet
  "*Time in seconds to sleep each time through the loop")

(defparameter *garnet-running* nil #-release-garnet
  "Set to t when a function has been called that is protected by
run-ininteruptable-garnet-commands.")

(defparameter unrun-garnet-commands nil #-release-garnet
  "Save the commands that are being held until previous commands in
run-ininteruptable-garnet-commands finish.")

(defvar welcome-to-grepl "Welcome to garnet"
  #-release-garnet
  "*Message to print on entering grepl.")

(defvar rewelcome-to-grepl "Re-Welcome to garnet"
  #-release-garnet
  "*Message to print on reentering grepl after pop up from a break.")

(defvar goodbye-to-grepl "Say goodnight, Garnet"
  #-release-garnet
  "*Message to print on quiting grepl.")


;;;
;;;	iv.	Export statements
;;;
;;;   This is really just a hedge in case this stuff gets moved to the inter
;;; package, and to show that I have hair on my chest and can use exports.

(eval-when (load eval compile)
  (export '(;; variables & schema
            goodbye-to-grepl
            garnet-Hour-Glass-Windows
            grepl-supersystem-name
            grepl-history
            grepl-loop-sleep-time
            grepl-prompt-function
            grepl-loading-directory
            old-grepl-package
            old-grepl-supersystem-name
            old-grepl-prompt
            rewelcome-to-grepl
            welcome-to-grepl
            *grepl-conditions*
            unrun-garnet-commands
            
            ;; functions & macros
            SetGarnetHourGlassCursor
            RestoreGarnetRegularCursor         
            ;clear-X-events
            garnet-event-and-lisp-loop
            garnet-inter-unwind-stuff
            g-inter-lam
            grepl
            grepl-test
            update-all-windows
            with-hourglasscursor-set   
            with-regularcursor-set
            )
   (find-package "OPAL")))


;;;
;;;	v. 	Advanced user or Non-user variables
;;;

(defparameter *quit-grepl* nil 
  #-release-garnet
  "Flag used to quit the event-and-lisp-loop.")

(defparameter grepl-history nil
  #-release-garnet
  "Where the previous command lives")

(defparameter grepl-item nil
  #-release-garnet
  "Where the current command keyword lives")

(defconstant *whitespace-chars* 
  '(#\Space #\Newline #\Tab #\Page #\Rubout #\Linefeed #\Return #\Backspace)
  #-release-garnet
  "A list of characters read as whitespace by the garnet-repl")

(defconstant *newline-chars* 
  '(#\Newline #\Linefeed #\Return)
  #-release-garnet
  "A list of characters read as new-lines by the grepl")

;; These are used to make a prompt and that gets printed until it changes
(defparameter old-grepl-package nil)
(defparameter old-grepl-supersystem-name nil)
(defparameter old-grepl-prompt "")


;;;
;;;	vi.	Default commands for the loop
;;;
;;;     You can only push onto this list.
;;; The format is (test-form doc-string &rest things-to-do)
;;; The test-form gets evaled.  The doc-string is required.
;;; grepl-item is bound (in a deep sense) to the current input for tests.

(defvar *grepl-conditions*   '(

  ((or (equal :? grepl-item)
       (equal :help grepl-item))
   ":? or :help will give you a copy of all help messages."
   (print-grepl-help-message))

  ((or (grepl-test :quit quit)
       (grepl-test :stop stop)
       (grepl-test :q q))
  ":quit will quit the loop.  Otherwise all errors are caught and
return to garnet-loop at the top level rather than to the standard
lisp read-eval-print loop."
   (setq *quit-grepl* t)
   (throw 'exit-grepl t))

  ((grepl-test :pack pack)
 ":pack will set the package to the package corresponding to the string, atom, 
   or evaluated literal expression that it is passed as a second argument."
   (let* ((p1 (or (pop input)
                  (progn (if (not (listen *standard-input*))
                             (format t "Package to use: "))
                         (read *standard-input*))))
          (p2 (cond ((stringp p1) p1) 
                    ((listp p1) (eval p1)) ;quoted list or form
                    ((boundp p1) (eval p1))
                    (t p1))) )
     (push p2 grepl-history)
     (in-package p2)))

  ((or (equal :update grepl-item)
       (equal :up grepl-item))
   ":update or :up will update all windows"
   (opal:update-all-windows))

  ((grepl-test :user user)
   ":user sets the package to user." (in-package "USER"))
  ((grepl-test :opal opal)
   ":opal will set the package to OPAL." (in-package "OPAL"))

  ((grepl-test :redo redo)
   ":redo will redo the last command."
    (setq grepl-item (pop opal:grepl-history))
    (do* ((tests *grepl-conditions*)
          (test (pop tests) (pop tests))  )
         ( (or (not test) (eval (car test)))
           (eval `(progn ,@(cddr test)))   ))   )
  ;((equal :redo grepl-item) 
  ; ":redo will redo the last command"
  ; (grepl grepl-history))

;  ((equal :clearx grepl-item) 
;   ":clearx will clear out any X events that might be out there."
;   (opal:clear-X-events))

  ((equal :load grepl-item) 
   ":load will reload a file from the grepl-loading-directory you define."
   (let ((file (cond (input (pop input))
                     (t (and (not (listen *standard-input*))
                             (format t "File to load w/o extension: "))
                        (read)))))
     (push file grepl-history)
     (load (format nil "~a~a" grepl-loading-directory file))
     (terpri)))
  ;; unmatched keywords get a petite help message
  ((keywordp grepl-item)
    ""
   (format t "Type `:?' or `:help' for the list of commands."))
  ;; this need to be last
  (t "Anything else is evaluated and the result printed out."
     (format t "~s" (cond ((listp grepl-item) (eval grepl-item))
                          ((atom grepl-item)
                           (if (boundp grepl-item)
                               (eval grepl-item)
                               (format nil "~s not bound" grepl-item))))))
))


;;;
;;;	vii.	Helper functions
;;;

(defmacro grepl-test (keyword symbol)
  #-release-garnet
  "Tests for keyword and unbound symbols bound to grepl-item."
  `(or (eq grepl-item ,keyword)
       (and (symbolp grepl-item)
	    (string-equal grepl-item ',symbol)
	    (not (boundp ',symbol))))  )

(defun print-grepl-prompt (&key (stream t))
  #-release-garnet
 "Print out the garnet-prompt"
 (if (and (eq old-grepl-package *package*)
          (string= old-grepl-supersystem-name grepl-supersystem-name))
     nil
     (progn
       (setq old-grepl-supersystem-name grepl-supersystem-name)
       (setq old-grepl-package *package*)
       (setq old-grepl-prompt
             (format nil "<~a:~a> "
                     grepl-supersystem-name
                     (string-downcase (package-name *package*))))))
 (format stream "~a" old-grepl-prompt))


(defun print-grepl-help-message ()
  #-release-garnet
 "Print out a help message based on the commands on *grepl-conditions*."
 (do* ((help-items (copy-list *grepl-conditions*))
       (help-item (second (pop help-items))
                  (second (pop help-items))))
     ((null help-items)
      (if help-item
         (format t "* ~a~%" help-item)))
   (if help-item
     (format t "* ~a~%" help-item)))
 nil)

(proclaim '(inline whitespace-char-p))

(defun whitespace-char-p (achar)
  #-release-garnet
  "Returns t if achar is whitespace."
  (and (member achar *whitespace-chars* :test #'char=)
       t))


;;;
;;;	viii.	Necessary Extensions to Garnet
;;;

;; This code doesnt' work, so we will just leave it out.
;(defun clear-X-events (&optional awindow)
;  #-release-garnet
; "Clear the event queue, really more advanced version"
; (let ((display (if awindow
;                    (opal::display-info-display (g-value awindow :display-info))
;	            (let ((win1 (caar (opal::get-table-contents))))
;		       (if win1
;			   (xlib:window-display win1)
;                           opal::*default-x-display*)))))
; (and (discard-current-event display)
;      (clear-X-events))))

(defun update-all-windows ()
  #-release-garnet
 "Update items on the display until done."
 (do ((display  (let ((win1 (caar (opal::get-table-contents))))
		       (if win1
			   (xlib:window-display win1)
                           *default-x-display*))))
      ((not (xlib:event-listen display)))
   (default-event-handler display :timeout 0))
 nil)


;;;
;;;	I.	Setting the cursor stuff
;;;

(defun Get-Garnet-Bitmap (bitmapname)
  (opal:read-image (merge-pathnames bitmapname
                         user::garnet-bitmap-pathname)))

(defparameter RegularCursor (g-value opal:window :cursor))

(defparameter HourGlassCursor
  (cons (create-instance NIL opal:bitmap
			 (:image (Get-Garnet-Bitmap "hourglass.cursor")))
	(create-instance NIL opal:bitmap
			 (:image (Get-Garnet-Bitmap "hourglass.mask")))))


(defmacro with-hourglasscursor-set (&rest body)
  `(let ((extra-glass-windows nil))
   ;; extra-glass-windows used to be (get-values *sx* :examiner-windows)
   (unwind-protect
       (progn
	 (SetGarnetHourGlassCursor extra-glass-windows)
         ,@ body)
       (RestoreGarnetRegularCursor extra-glass-windows))))

(defmacro with-regularcursor-set (target-window &rest body)
  `(let ((old-cursor (g-value ,target-window :cursor)))
   (unwind-protect
       (progn
          (s-value ,target-window :cursor opal::RegularCursor)
          (opal:update ,target-window)
          ,@ body)
       (s-value ,target-window :cursor old-cursor)
       (opal:update ,target-window))))


(defun SetGarnetHourGlassCursor (&optional extrawindows)
  (dolist (win garnet-hour-glass-windows)
    (s-value win :cursor HourGlassCursor)
    (opal:update win))
  (dolist (win extrawindows)
    (s-value win :cursor HourGlassCursor)
    (opal:update win)))


(defun RestoreGarnetRegularCursor (&optional extrawindows)
  (dolist (win garnet-hour-glass-windows)
    (s-value win :cursor RegularCursor)
    (opal:update win))
  (dolist (win extrawindows)
    (s-value win :cursor RegularCursor)
    (opal:update win)))


;;;
;;;	II.	Run-uninterruptible-garnet-commands
;;;

;; do proclaims on better-cursors.lisp

(eval-when (load eval compile)
  (in-package "OPAL"))

(defmacro run-uninterruptible-garnet-commands (&rest commands)
   #-release-garnet
   "Protects commands that run in garnet from clobbering each other."
 `(let ((I-am-top nil))
   (unwind-protect
    ; (format t "entering run-garnet-commands with garnet-running: ~s
    ;       old-commands: ~s ~%" *garnet-running* unrun-garnet-commands)
    (with-hourglasscursor-set
    (if *garnet-running*
	;; save comands for later
	(progn
          ; (format t "saving1 ~s" ',commands)
	  (setf unrun-garnet-commands
		(append unrun-garnet-commands ',commands)))
	(progn
          ; (format t "plain running ~s" ',commands)
          (setf i-am-top t)
          (setf *garnet-running* t)
          ,@commands
        ;; run unrun commands
        ;(format t "~% proceeding to run ~s" unrun-garnet-commands)
        (prog ()
           start
          (if (not unrun-garnet-commands)
    	      (go end)
              (eval (pop unrun-garnet-commands)))
          (go start)
          end))))
    ;; make sure you do this
   (if I-am-top
       (progn
         (setf unrun-garnet-commands nil)
         (setf *garnet-running* nil)))))
   ;; also cleared on an init-soar via clear-sx
 )


;;;
;;;	III.	g-inter-lam
;;;
;;; This provides a lambda form that is smart about running, using
;;; commands defined with this loop.  That is, they are uninteruptable,
;;; and they put hourglass cursors up.
;;;

(defmacro garnet-inter-unwind-stuff (&rest body)
  `(unwind-protect
     (progn (SetGarnetHourGlassCursor garnet-Hour-Glass-Windows)
            (run-uninterruptible-garnet-commands ,@ body))
     (RestoreGarnetRegularCursor garnet-Hour-Glass-Windows) ))
         
(defmacro g-inter-lam (&rest body)
   (list 'function
     `(lambda (x y)
        (declare (ignore x y))
         ;; this is the internals with hourglass cursor set...
        (garnet-inter-unwind-stuff  ,@ body)))) 


;;;
;;;	IV. 	Garnet read-eval-print loop (grepl)
;;;
;;;    This is an event loop that read lisp if it appears, and runs an
;;; event handler when x events appear.  Call this at the top level for
;;; programming-fanuegen (programming pleasure).

(defun grepl ()
  #-release-garnet
 "The top level function, mostly just catches errors."
  (prog ()
    (format t "~%~a ~%" welcome-to-grepl)
    start
    (setq *quit-grepl* nil)
    (unwind-protect 
      (block nil 
	    (catch 'exit-grepl (garnet-event-and-lisp-loop)))
      (cond (*quit-grepl* nil) ;user wants out
            (t (format t "~a ~%" rewelcome-to-grepl)
               (go start))))  ;user made a boo-boo
    (format t "~a~%" goodbye-to-grepl)))


;;;
;;;	V. 	Garnet-event-and-lisp-loop
;;;
;;;    This is an event loop that read lisp if it appears, and runs an
;;; event handler when x events appear.
;;;

(defun garnet-event-and-lisp-loop (&optional awindow)
  #-release-garnet
  "A loop that reads input and calls code to handle xevents
when they happen."
  (funcall grepl-prompt-function :stream *standard-output*)
  (let ((display (if awindow
                     (display-info-display (g-value awindow :display-info))
		     (let ((win1 (caar (get-table-contents))))
		       (if win1
			   (xlib:window-display win1)
                           *default-x-display*)))))
  ;; gnu will buffer input for us, so that's cool, and event-listen
  ;; tells us when there's an x-event.  If gnu is not there, a user
  ;; is committed to typing something if he starts to.
  (prog () start
        (cond ( (listen *standard-input*) 
		(garnet-lisp-repl) )
	      ( (xlib:event-listen display)
                ;; uses keyword based event-handler sent to Garnet Fall 90
                (opal::default-event-handler display :timeout 0) )
              ( t (sleep grepl-loop-sleep-time) ))
	(go start))
   (format t "~a~%" goodbye-to-grepl)
   ;; dump the event that made you quit?
   (xlib:event-case (display :discard-p t :timeout 5) ; discard current event
     (otherwise () t))   ))


;;;
;;;	VI.	Garnet-lisp-repl
;;;
;;; when you get here you have input, but if just a whitespace, pitch it
;;; could be smarter about errors, and not getting thrown past
;;; somewhat shaky history item
;;;

(defun garnet-lisp-repl (&optional input)
  #-release-garnet
  "Read-Eval-Print-Loop (repl) for Garnet that runs once per call of grepl."
  (declare (special input)) ; necc for the evals below
  (setq grepl-history (reverse grepl-history))
  ;; reverse up here for safty
  (if (and (not input)
           (whitespace-char-p (peek-char nil *standard-input*)))
      ;; read some deadspace, else doit
      (if (member (read-char *standard-input*) *newline-chars* :test #'char=)
	  (funcall grepl-prompt-function :stream *standard-output*))
      (progv '(grepl-item)
              (list (or (pop input)
                        (read *standard-input*)))
        (if (not (or (eq grepl-item :redo) (eq grepl-item 'redo)))
            (setq grepl-history (list grepl-item)))
        (cond ((stringp grepl-item) (format t "~s" grepl-item))
              ( (do* ((tests *grepl-conditions*)
                      (test (pop tests) (pop tests))  )
                     ( (or (not test) (eval (car test)))
                      (garnet-inter-unwind-stuff
                       (eval `(progn ,@(cddr test)))   )
                       (if test t nil))) )
              (t (format t "~a" (cond ((listp grepl-item) (eval grepl-item))
                          ((atom grepl-item)
                           (if (boundp grepl-item)
                               (eval grepl-item)
                               (format nil "~s not bound" grepl-item)))))))
        (if (not (eq grepl-item :redo))
            (funcall grepl-prompt-function :stream *standard-output*)))))


;;;
;;;	VII.	Change to default-event-handler
;;;
;;; Gives it standard keywords.
;;; Change posted to Garnet [12March91], but not included in 1.4.
;;;

;; Don't include it if loading the Soar interface, for it will be loaded
;; from inter-changes.  Otherwise, load it.

#-inter-changes
(eval-when (load eval compile)
    (in-package "INTERACTORS"))

#-inter-changes
(defun opal::default-event-handler
      (display &optional &key (discard-p t) (force-output-p t)
                              (peek-p nil) (timeout nil))
  #-release-garnet
 "Event handler for the interactor windows"
  (declare (ignore force-output-p discard-p))
  (xlib:event-case (display :discard-p t :force-output-p t
                    :force-output-p force-output-p :peek-p peek-p 
                    :timeout timeout)
    (:MAP-NOTIFY (event-window)
                 (opal::Map-Notify (debug-p :event) event-window)
                 #-cmu nil)
    (:UNMAP-NOTIFY (event-window)
                   (opal::Unmap-Notify (debug-p :event) event-window)
                   #-cmu nil)
    (:REPARENT-NOTIFY (event-window x y)
                      (opal::Reparent-Notify (debug-p :event) event-window x y)
                      #-cmu nil)
    (:CIRCULATE-NOTIFY () (opal::Circulate-Notify (debug-p :event))
                           #-cmu nil)
    (:GRAVITY-NOTIFY () (opal::Gravity-Notify (debug-p :event)) #-cmu nil)
    (:DESTROY-NOTIFY (event-window)
                     (opal::Destroy-Notify (debug-p :event) event-window)
                     #-cmu nil)
    (:CONFIGURE-NOTIFY (x y width height event-window above-sibling)
                       (opal::Configure-Notify (debug-p :event) x y
                                              width height
                                              event-window above-sibling)
                        #-cmu nil)
    (:EXPOSURE (event-window count x y width height)
               (opal::Exposure (debug-p :event) event-window count x y width height display)
               #-cmu nil)
    (:KEY-PRESS (event-window x y state code time)
                (if *trans-from-file* T ; ignore events when read transcript
                    (Key-Press event-window x y state code time))
                #-cmu nil)
    (:BUTTON-PRESS (event-window x y state code event-key time)
                   (if *trans-from-file* T ; ignore events when read transcript
                       (Button-Press event-window x y
                                     state code event-key time))
                   #-cmu nil)
    (:BUTTON-RELEASE (event-window x y state code event-key time)
                     (if *trans-from-file* T ; ignore events when read transcript
                         (Button-Release event-window x y
                                         state code event-key time))
                     #-cmu nil)
    (:MOTION-NOTIFY (event-window x y)
                    (if *trans-from-file* T ; ignore events when read transcript
                        (Motion-Notify event-window x y display))
                    #-cmu nil)
    (:NO-EXPOSURE () t #-cmu nil)
    (OTHERWISE () (format t "illegal event") t #-cmu nil)))


;;; Concatenated from type module "contrib" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/contrib/f1.4/sx-error-gadget.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-GADGETS; Base: 10 -*-
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1990, Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;  Error Gadget
;;;
;;;  Features:
;;;   The error-gadget can be used in applications where the designer wants to
;;;   tell the user that some error (possibly caused by the user) has been
;;;   encountered.  When the display-error function (described below) is called,
;;;   the error window becomes visible and displays an error message.  The user
;;;   must then click on the "OK" button before proceeding.
;;;
;;;  Customizable slots:
;;;   1) Parent-window - The window that the error window should be centered
;;;                      inside of
;;;   2) Font - The font for the message
;;;   3) Justification - How to justify the multi-line message
;;;   4) Modal-p - Whether to shut down all other interactors until the
;;;                "OK" button has been pressed
;;;   4b) really-modal-p - whether to hang all processing until the ok
;;;      button has been pressed.
;;;   5) Window-left, window-top, window-width, window-height - dimensions of
;;;        the error window (do not set these slots)
;;;   6) Window - The window created by the error-gadget (do not set this slot)
;;;
;;;  Programmer's interface:
;;;   In order to associate an error window with an application, an instance
;;;   of the error-gadget should be created with the :parent-window slot
;;;   set to the window of the application.  To activate the error
;;;   window, call the function DISPLAY-ERROR, which takes the instance of
;;;   the error-gadget and the desired message as parameters.
;;;
;;;  Caveats:
;;;   1) Update the parent window before instantiating the error-gadget.
;;;   2) The instance of the error-gadget should not be added to an aggregate.
;;;      Bookkeeping for the parent window is automatically taken care of
;;;      during the create-instance call.

;;; CHANGE LOG
;;; 6-26-91 - fer commented out shadows for faster and more importantly smaller
;;;           version
;;; 02/21/91  Added window-title and really-modal-p -fer
;;; 07/16/90  Andrew Mickish - Rewrote button part using new aggregadgets
;;; 08/14/90  Pavan Reddy - removed one error-priority-level since only a
;;;           single level is needed.  Also, set :active slot of :text-button-
;;;           press interactor to T to fix a bug that leaves the interactor
;;;           inactive.
;;;

(eval-when (load eval compile)
  (in-package "GARNET-GADGETS"))

(eval-when (load eval compile)
  (export '(ERROR-GADGET DISPLAY-ERROR)))

#-kr-deftypes
(eval-when (load eval compile)
  (deftype a-schema-type () '(member a-schema)))

(eval-when (load eval compile)
  (proclaim '(function DISPLAY-ERROR (a-schema-type string logical) (or t nil)))
  (proclaim '(special ERROR-PRIORITY-LEVEL ERROR-GADGET))
  (proclaim '(type a-schema-type ERROR-PRIORITY-LEVEL ERROR-GADGET))
  ;; (proclaim '(function Error-Gadget-Destroy (a-schema-type) (or t nil)))
  )

(defun DISPLAY-ERROR (error-gadget string beep-p)
  (declare (type a-schema-type error-gadget) (string string)
           (type (or t nil) beep-p))
  ;; Activate modal feature if appropriate
  (if (g-value error-gadget :modal-p)
      (s-value ERROR-PRIORITY-LEVEL :stop-when :always)
      (s-value ERROR-PRIORITY-LEVEL :stop-when :if-any))
  ;; Set the message to be displayed
  (s-value error-gadget :string string)
  ;; Turn visibility on
  (let ((window (g-value error-gadget :window)))
   ;;(format t "oldL  ~d Oldt ~d" (g-value window :left) (g-value window :top))
    ;; maybe we can leave left and top out, top moves the window
    ;(s-value window :left (g-value window :left))
    ;(s-value window :top (g-value window :top))     ; Won't size correctly
    (s-value window :width (g-value window :width))   ;  without these lines
    (s-value window :height (g-value window :height))
    ;; this will resize window before display rather than during -fer
   ;;(format t "~%newL ~d newt ~d" (g-value window :left)(g-value window :top))
    (opal:update window)    
    (s-value window :visible T)
    (opal:update window))
  (if beep-p (inter:beep))
  ;; make sure it gets clicked if really-modal-p
  (if (g-value error-gadget :really-modal-p)
      (prog ( (sleep-time (g-value error-gadget :sleep-time))
	      (display (let ((win1 (caar (opal::get-table-contents))))
	                 (if win1
 		             (xlib:window-display win1)
                             opal::*default-x-display*)))  )
	    start
	    ;; call the event handler to get anything
            (opal::default-event-handler display :timeout 0)
            (sleep sleep-time)
	    (if (g-value error-gadget :window :visible)
		(go start))))
  )

;;    This function creates a new priority level and adds them to the front
;; of the interactorts priority level list.  Thus, this level has higher
;; priority than the default inter-levels.
;;    This priority level are needed in case the error-gadget is modal.
;; The idea is to set the ERROR-PRIORITY-LEVEL's :stop-when to :always
;; when the error-gadget is modal, so that the "OK" button is the only gadget
;; that will work in the entire interface while the error-window is visible.
;;    So, the effect is to shut down the rest of the interface until the user
;; clicks on "OK" (if the error-gadget is modal).
;;


  (unless (and (boundp 'ERROR-PRIORITY-LEVEL)
	       (member ERROR-PRIORITY-LEVEL inter:priority-level-list))
    (push (create-instance 'ERROR-PRIORITY-LEVEL inter:priority-level)
	  inter:priority-level-list))

;; NOTE:  If :parent-window is specified, then the parent window must already
;; have been opal:update'd when the instance of ERROR-GADGET is created.
;;
(create-instance 'ERROR-GADGET opal:aggregadget
   (:width (o-formula (MAX (gvl :text :width) (gvl :button :width))))
   (:height (o-formula (+ 20 (gvl :text :height) (gvl :button :height))))

   ; If there is no parent window, then the error window is created at
   ; position (200, 200).
   (:window-left (o-formula (if (gvl :parent-window)
				(- (floor (gvl :parent-window :width) 2)
				   (floor (gvl :window-width) 2))
				200)))
   (:window-top (o-formula (if (gvl :parent-window)
			       (- (floor (gvl :parent-window :height) 2)
				  (floor (gvl :window-height) 2))
			       200)))
   (:window-width (o-formula (+ 20 (gvl :width))))    ; 10 on each side
   (:window-height (o-formula (+ 40 (gvl :height))))  ; 20 on top, bottom
   ;; change here, fer 2/91
   (:window-title "Error message")
   ;; do you force user to click before doing *anything*
   (:really-modal-p nil) 
   ;;for really-modal-p, time in sec to sleep between checking if done
   (:sleep-time 0.1) 

   (:parent-window NIL)    ;; The parent of the error-window
   (:string "Error")
   (:font opal:default-font)
   (:justification :center)
   (:modal-p T)

   (:destroy 'Error-Gadget-Destroy)

   (:parts
    `((:text ,opal:multi-text
	     (:left ,(o-formula
		      (+ 10 (- (floor (MAX (gvl :width)
					   (gvl :parent :button :width)) 2)
			       (floor (gvl :width) 2)))))
	     (:top 20)
	     (:justification ,(o-formula (gvl :parent :justification)))
	     (:string ,(o-formula (gvl :parent :string)))
	     (:font ,(o-formula (gvl :parent :font))))

      (:button ,TEXT-BUTTON
         (:left ,(o-formula
	                (+ 10 (- (floor (MAX (gvl :width)
					     (gvl :parent :text :width)) 2)
				 (floor (gvl :width) 2)))))
         (:top ,(o-formula (+ 20 (opal:gv-bottom (gvl :parent :text)))))
	 (:string "OK")
	 (:shadow-offset 0) (:text-offset 5) (:gray-width 3)
	 (:final-feedback-p NIL)
	 (:selection-function
		,#'(lambda (gadget value)
		     (declare (ignore value))
		     (let ((window (g-value gadget :window)))
		       (s-value window :visible NIL)
		       (opal:update window)
		       (s-value ERROR-PRIORITY-LEVEL :stop-when NIL))))
	 (:parts
	     ( ; :shadow
               :gray-outline :white-field :text
	     (:feedback-obj :omit)))
	 (:interactors (
	    (:fast-ok-inter ,inter:button-interactor
               (:start-where t)
	       (:active T)
               (:window ,(o-formula (gv-local :self :operates-on :window)))
               (:waiting-priority ,error-PRIORITY-LEVEL)
               (:running-priority ,error-PRIORITY-LEVEL)
	       (:final-function
		,#'(lambda (gadget value)
		     (declare (type a-schema-type gadget) (ignore value))
		     (let ((window (g-value gadget :window)))
		       (s-value window :visible NIL)
		       (opal:update window)
		       (s-value ERROR-PRIORITY-LEVEL :stop-when NIL))))
               (:start-event #\RETURN)
               (:continuous nil))
            (:TEXT-BUTTON-PRESS :modify
	       (:waiting-priority ,ERROR-PRIORITY-LEVEL)
	       (:active T)
	       (:running-priority ,ERROR-PRIORITY-LEVEL))))))))



(define-method :initialize ERROR-GADGET (error-gadget)
  (call-prototype-method error-gadget)
  (let ((window
	 (create-instance NIL inter:interactor-window
	    (:left (o-formula (gvl :aggregate :components :window-left)))
	    (:top (o-formula (gvl :aggregate :components :window-top)))
	    (:title (o-formula (gvl :aggregate :components :window-title)))
	    (:width (o-formula (gvl :aggregate :components :window-width)))
	    (:height (o-formula (gvl :aggregate :components :window-height)))
	    (:parent (g-value error-gadget :parent-window))
	    (:visible NIL)))
	(aggregate (create-instance NIL opal:aggregate)))
    (s-value window :aggregate aggregate)
    ;;; The :window slot of error-gadget is automatically set by add-component
    (opal:add-component aggregate error-gadget)
    (opal:update window)))


(defun Error-Gadget-Destroy (error-gadget &optional erase)
  ;; first, remove the gadget from its window so when the window is
  ;; destroyed, the gadget will not be.  Then destroy the gadget itself
  ;; using call-prototype-method
  (declare (type a-schema-type error-gadget) (type (or t nil) erase))
  (let ((agg (g-value error-gadget :parent))
	(window (g-value error-gadget :window)))
    (when agg
      (opal:remove-component agg error-gadget))
    ;; make sure window isn't already being destroyed
    (when (and window
	       (schema-p window)
	       (gethash (get-local-value window :drawable)
			opal::*drawable-to-window-mapping*))
      (opal:destroy window))
    (call-prototype-method error-gadget erase)))


;;; Concatenated from type module "contrib" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/contrib/f1.4/point-inter.lisp".
;;; -*- Mode: lisp; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : point-inter.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Mon Jan  7 18:36:18 1991
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Wed Apr  1 14:25:07 1992
;;;; Update Count    : 43
;;;; 
;;;; PURPOSE
;;;; This file contains the mouse and keyboard interactors to select objects
;;;; and move them around or grow them.  It should be loaded after
;;;; Interactors.lisp and movegrow.lisp
;;;;
;;;; TABLE OF CONTENTS
;;;;	i.	Rewritten helper functions
;;;; 	ii.	Main Default Procedures to go into the slots
;;;; 	I.	point schema
;;;; 
;;;; (C) Copyright 1990, Frank Ritter, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s
;;;
;;;
;;; Designed and implemented by Brad A. Myers & Frank Ritter
#|

============================================================
Change log:
        1/7/91  Frank Ritter - changed into a point interactor
                from movegrow.lisp
        ...
	8/8/88 Brad Myers - started
============================================================
|#

(in-package "INTERACTORS" :use '("LISP" "KR") :nicknames '("INTER"))

(export '(point-interactor))

(proclaim '(special Point-Interactor))
;; requires move-grow interactors

#-kr-deftypes
(eval-when (load eval compile)
    (deftype a-schema-type () '(member a-schema))
    (deftype a-schema-or-nil () '(or a-schema-type nil))
    (deftype display-or-nil () '(or xlib:display nil)))

;; made a lot of these return nil, to save time? 20-Jan-92 -FER
(eval-when (load eval compile)
  (proclaim '(function Copy-point (list list) list))
  (proclaim '(function set-obj-list4-slot-no-db
              (a-schema-type keyword list) nil))
  (proclaim '(function point-Int-Start-Action
              (a-schema-type a-schema-or-nil list) nil))
  (proclaim '(function point-Int-Running-Action
              (a-schema-type a-schema-type list) nil))
  (proclaim '(function Move-Grow-Int-Outside-Action
              (a-schema-type keyword a-schema-type) nil))
  (proclaim '(function point-Int-Back-Inside-Action
              (a-schema-type  keyword a-schema-type list) nil))
  (proclaim '(function point-Int-Stop-Action
              (a-schema-type a-schema-type list) nil))
  (proclaim '(function point-Int-Abort-Action
              (a-schema-type a-schema-type) nil))
  (proclaim '(function point-Interactor-Initialize
              (a-schema-type) nil))
  (proclaim '(function CalcChangeBoxOrLineOrPoint
              (a-schema-type a-schema-type integer integer) list))
  (proclaim '(special *glo-points2*))
  (proclaim '(list *glo-points2*))
  (proclaim '(function CalcPointMove (a-schema-type integer integer) list))
  (proclaim '(function point-do-start (a-schema-type a-schema-type inter::event)
              nil))
  (proclaim '(function SetPointInitialSlots (a-schema-type a-schema-type integer integer)
              nil))
  (proclaim '(function point-do-back-inside (a-schema-type a-schema-type inter::event)
              nil))
  (proclaim '(function point-do-running (a-schema-type a-schema-type inter::event)
              nil))
  (proclaim '(function point-do-stop (a-schema-type a-schema-type inter::event)
              nil))
  )


;;;
;;;	i.	Rewritten helper functions
;;;

(defun Copy-point (old-list4 new-list4)
#-release-garnet"New-list may be a real list, old is a cons cell."
  (declare (list old-list4 new-list4))
  (setf (car old-list4) (first new-list4))
  (setf (cdr old-list4) (second new-list4))  )

;(defun my-trace-inter ()
;  (inter:trace-inter t)
;  (trace mark-as-changed  copy-point 
;         set-obj-list4-slot
; 	 obj-or-feedback-change  set-obj-list4-slot-no-db))

(defun set-obj-list4-slot-no-db (obj slot new-list4)
  (declare (type a-schema-type obj) (keyword slot) (list new-list4))
  (when obj
    (let ((oldval (get-local-value obj slot)))
      (cond
       ((eq slot :point)
	; turn new-list4 into a cons cell
	(if (and oldval (listp oldval))
	    (progn (Copy-point oldval new-list4)
                   (Mark-As-Changed obj slot)) ; do this to get constraints to go
            ;; else create a new one
           (s-value obj slot (copy-point (cons nil nil) new-list4))))
       (t (if (and oldval (listp oldval) (eq 4 (length oldval)))
              ; then re-use old slots so no cons-ing
              (progn (Copy-List4 oldval new-list4)
	             (Mark-As-Changed obj slot)) ; do this to get constraints to go
               ; else create a new one
               (s-value obj slot (copy-list new-list4)))))))
  nil)


;;;
;;; 	ii.	Main Default Procedures to go into the slots
;;;============================================================

(defun point-Int-Start-Action (an-interactor object-being-changed
						  first-points)
   (declare (type a-schema-type an-interactor)
            (type a-schema-or-nil object-being-changed)
            (list first-points))
#-release-garnet  (if-debug an-interactor 
     (format T "Point int-start moving ~s firstpoints=~s~%"
             object-being-changed first-points))
  ;;change feedback or object first so no flicker when turned visible
  (let ((feedback (g-value an-interactor :feedback-obj)))
    (obj-or-feedback-change feedback object-being-changed
			    first-points
			    :point
			    an-interactor)
    (when feedback (sel-change-feedback-visible 
		    an-interactor feedback object-being-changed T)      ))
  nil)

(defun point-Int-Running-Action (an-interactor object-being-changed
						    new-points)
  (declare (type a-schema-type an-interactor object-being-changed)
            (list new-points))
#-release-garnet  (if-debug an-interactor 
      (format T "Point int-running, obj = ~s, points=~s~%"
	      object-being-changed new-points))
  (obj-or-feedback-change (g-value an-interactor :feedback-obj)
			object-being-changed
                        new-points
			:point
			an-interactor)
  nil)

(defun Move-Grow-Int-Outside-Action (an-interactor outside-control
						  object-being-changed)
  (declare (type a-schema-type an-interactor object-being-changed)
           (keyword outside-control))
#-release-garnet(if-debug an-interactor
                          (format T "Point int-outside, mov = ~s~%"
				  object-being-changed))
  (unless (eq :last outside-control)
    (let ((feedback (g-value an-interactor :feedback-obj)))
      (if feedback
	  (sel-change-feedback-visible
	   an-interactor feedback object-being-changed NIL)
	  (set-obj-list4-slot object-being-changed
			      (if (g-value an-interactor :line-p)
				  :points
				  (if (g-value an-interactor :point-p)
				      :point
                                      :box))
			      (g-value an-interactor :saved-original-points)
			      an-interactor NIL))))
  nil)

(defun point-Int-Back-Inside-Action
       (an-interactor outside-control object-being-changed new-inside-points) 
  (declare (type a-schema-type  an-interactor object-being-changed)
           (keyword outside-control) (list new-inside-points))
#-release-garnet(if-debug an-interactor 
	    (format T "Point int-back-in, obj = ~s, new points=~s~%"
		    object-being-changed new-inside-points))
  ;;first change the feedback or object to the new position, and then make it
  ;; visible, if necessary
  (let ((feedback (g-value an-interactor :feedback-obj)))
    (obj-or-feedback-change feedback object-being-changed
			  new-inside-points
			  (if (g-value an-interactor :line-p)
			      :points
			      (if (g-value an-interactor :point-p)
				    :point
                                    :box))
			  an-interactor)
    (when (and feedback
	       (null outside-control))
      (sel-change-feedback-visible an-interactor feedback
                                   object-being-changed T)))
  nil)

(defun point-Int-Stop-Action (an-interactor object-being-changed
						 final-points)
  (declare (type a-schema-type an-interactor object-being-changed)
           (list final-points))
#-release-garnet(if-debug an-interactor
                          (format T "Point int-stop obj ~s final-points=~s~%"
				  object-being-changed final-points))
  ;;turn off feedback
  (sel-change-feedback-visible an-interactor
                               (g-value an-interactor :feedback-obj)
			       object-being-changed NIL)
  ;;set object to final position
  (set-obj-list4-slot object-being-changed
		      (if (g-value an-interactor :line-p)
			  :points
			  (if (g-value an-interactor :point-p)
			      :point
                              :box))
		      final-points an-interactor NIL)
  (KR-Send an-interactor :final-function an-interactor object-being-changed
	   final-points)
  nil)

(defun point-Int-Abort-Action (an-interactor object-being-changed)
  (declare (type a-schema-type  an-interactor object-being-changed))
#-release-garnet(if-debug an-interactor
                          (format T "Point int-abort moving ~s~%"
				  object-being-changed))
  (let ((feedback (g-value an-interactor :feedback-obj)))
    (if feedback
	(sel-change-feedback-visible an-interactor feedback object-being-changed NIL)
	(set-obj-list4-slot object-being-changed
			    (if (g-value an-interactor :line-p)
			        :points
			        (if (g-value an-interactor :point-p)
			            :point
                                    :box))
			    (g-value an-interactor :saved-original-points)
			    an-interactor NIL)))
  nil)
  
(defun point-Interactor-Initialize (new-Move-Grow-schema)
  (declare (type a-schema-type Move-Grow-schema))
#-release-garnet(if-debug new-Move-Grow-schema
                          (format T "Select change initialize ~s~%"
					 new-Move-Grow-schema))
  (Check-Interactor-Type new-Move-Grow-schema inter:point-Interactor)
#-release-garnet
  (Check-Required-Slots new-Move-Grow-schema)
  (Set-Up-Defaults new-Move-Grow-schema)
  nil)


;;;============================================================
;;; Go procedure utilities
;;;============================================================

(defun CalcChangeBoxOrLineOrPoint (an-interactor obj x y)
  (declare (type a-schema-type an-interactor obj)
           (integer x y))
  (cond ((g-value an-interactor :line-p)
         (if (g-value an-interactor :grow-p)
	     (CalcLineEndPoint an-interactor x y)
             (CalcLineMove an-interactor x y)))
	((g-value an-interactor :point-p)
	 ;; doesn't make sense to grow a point
         (CalcPointMove an-interactor x y))
	(t (if (g-value an-interactor :grow-p)
               (CalcSizeAndPosition an-interactor obj x y)
               (CalcPosition an-interactor obj x y)))))

(defparameter *glo-points2* (list 0 0))  ; use this to avoid cons-ing

;;; Calculates an point's position as it is moved 
(defun CalcPointMove (an-interactor x y)
  (declare (type a-schema-type an-interactor) (integer x y))
  (let ((attach (g-value an-interactor :attach-point))
	(origxdist (g-value an-interactor :orig-x-dist))
	(origydist (g-value an-interactor :orig-y-dist))
	xoff yoff)
#-release-garnet(if-debug an-interactor
                          (format T "   CalcPointMove attach=~s, x,y=(~s,~s)~%"
                                  attach x y))
    (when (eq attach :where-hit)
      (setq xoff (g-value an-interactor :x-off))  ;these are + or - as needed
      (setq yoff (g-value an-interactor :y-off)))
    ;; use a global to avoid cons-ing
    (setf (first *glo-points2*)
	  (case attach
	    (1 x)
	    (2 (- x origxdist))
	    (:center (- x origxdist))
	    (:where-hit (- x xoff))
	    (t (error "bad attach ~s on interactor ~s" attach an-interactor))))
    (setf (second *glo-points2*)
	  (case attach
	    (1 y)
	    (2 (- y origydist))
	    (:center (- y origydist))
	    (:where-hit (- y yoff))))
    *glo-points2*))

;;; if continuous: (remove from start level, add to stop and abort
;;; 		    level, change state to running)
;;; save object over, call start procedure.
(defun point-do-start (an-interactor new-obj-over event)
   (declare (type a-schema-type an-interactor new-obj-over)
            (type inter::event event))
#-release-garnet(if-debug an-interactor
                          (format T "Point starting over ~s~%" new-obj-over))
        ;; if obj-to-change supplied, then use that, otherwise use whatever was
	;; under the mouse when started
  (let ((x (event-x event))
	(y (event-y event))
	(obj (or (g-value an-interactor :obj-to-change) new-obj-over))
	points line-p point-p)
#-release-garnet(if-debug an-interactor (format T "   Point moving ~s~%" obj))
   (s-value an-interactor :obj-being-changed obj)
   ;; don't check line-p until the previous slots have been set, in case
   ;; there are formulas
   (setq line-p (g-value an-interactor :line-p))
   (setq point-p (g-value an-interactor :point-p))
   (s-value an-interactor :saved-original-points
     (cond (line-p (list (g-value obj :x1) (g-value obj :y1)
                         (g-value obj :x2) (g-value obj :y2)))
	   (point-p (list (car (g-value obj :point)) (cdr (g-value obj :point))))
	   (t (list (g-value obj :left) (g-value obj :top)
		    (g-value obj :width) (g-value obj :height)))))
    (if (and obj (not (eq obj T)))
	(progn
	  (cond (line-p
                 (SetLineInitialSlots an-interactor obj x y))
		(point-p
                 (SetPointInitialSlots an-interactor obj x y))
		(t
	      ;; otherwise, left,top,width,height
	      (when (eq :where-hit (g-value an-interactor :attach-point))
		(if (g-value an-interactor :grow-p)
		    (CalcWhereHitAttach an-interactor x y) ; for growing
		    (progn 		               ; for moving
		      (s-value an-interactor :x-off (- x (g-value obj :left)))
		      (s-value an-interactor :y-off (- y (g-value obj :top))))))))
	  (setf points (CalcChangeBoxOrLineOrPoint an-interactor obj x y)) )
	;else no object, just return x y
	(setf points (list x y 10 10)))  ; what use here for w h?
    (if (g-value an-interactor :continuous)  ;then will go to running state
	(progn
	  (Move-Grow-Fix-Running-where an-interactor new-obj-over)
	  (when (g-value an-interactor :outside) ;needed if stop while outside
	    (set-obj-list4-slot-no-db an-interactor :saved-last-points points))
	  (GoToRunningState an-interactor T)
	  (kr-send an-interactor :start-action an-interactor obj points))
	;; else call stop-action
	(progn
	  (kr-send an-interactor :stop-action an-interactor obj points)
	  (GoToStartState an-interactor NIL))))
  nil)



;; ----------------------------------------------------------------------
;; functions to deal with :where-hit and initialize the interactor
;; ----------------------------------------------------------------------
;; Orig-?-dist is the distance from x2 to x1, unless centered in which case it
;; is half the distance.
(defun SetPointInitialSlots (an-interactor obj x y)
  (declare (type a-schema-type an-interactor obj)
           (integer x y))
  (let* ( (point (g-value obj :point))
          (obj-x (car point))
          (obj-y (cdr point))
          (attach (g-value an-interactor :attach-point)) )
    (s-value an-interactor :orig-x-dist obj-x)
    (s-value an-interactor :orig-y-dist obj-y)
    (when (eq :where-hit attach)
      ;; then also set up where to grow from or offsets
       (s-value an-interactor :x-off (- x obj-x))
       (s-value an-interactor :y-off (- y obj-y))) )
  nil)

(defun point-do-back-inside (an-interactor obj event)
  (declare #-release-garnet(type a-schema-type an-interactor obj)
           #+release-garnet(type a-schema-type an-interactor)
           #+release-garnet(ignore obj)
           (type inter::event event))
#-release-garnet(if-debug an-interactor
                          (format T "Point back-inside over ~s at:~s~%"
				  obj event))
  (let ((x (event-x event))
	(y (event-y event)))
    (s-value an-interactor :current-state :running)
    (let* ((moving-obj (g-value an-interactor :obj-being-changed))
	   (points (CalcChangeBoxOrLineOrPoint an-interactor moving-obj x y)))
      (when (g-value an-interactor :outside) ;needed if stop while outside
	(set-obj-list4-slot-no-db an-interactor :saved-last-points points))
      (kr-send an-interactor :back-inside-action an-interactor
		   (g-value an-interactor :outside)
		   moving-obj points)))
  nil)

(defun point-do-running (an-interactor obj event)
  (declare #-release-garnet(type a-schema-type an-interactor obj)
           #+release-garnet(type a-schema-type an-interactor)
           #+release-garnet(ignore obj)
           (type inter::event event))
#-release-garnet(if-debug an-interactor
                          (format T "Point running over ~s at:~s~%" obj event))
  (let ((x (event-x event))
	(y (event-y event)))
  (let* ((moving-obj (g-value an-interactor :obj-being-changed))
         (points (CalcChangeBoxOrLineOrPoint an-interactor moving-obj x y)))
      (when (g-value an-interactor :outside) ;needed if stop while outside
	(set-obj-list4-slot-no-db an-interactor :saved-last-points points))
      (kr-send an-interactor :running-action an-interactor
		   moving-obj points)))
  nil)


(defun point-do-stop (an-interactor obj event)
  (declare #-release-garnet(type a-schema-type an-interactor obj)
           #+release-garnet(type a-schema-type an-interactor)
           #+release-garnet(ignore obj)
           (type inter::event event))
#-release-garnet(if-debug an-interactor
                          (format T "Point stop over ~s at:~s~%" obj event))
  (let ((x (event-x event))
	(y (event-y event)))
    (Move-Grow-do-stop-helper an-interactor
		      (CalcChangeBoxOrLineOrPoint
		       an-interactor (g-value an-interactor
					      :obj-being-changed) x y)))
  nil)


;;;
;;; 	I.	point schema
;;;============================================================

(Create-Schema 'inter:Point-Interactor
     (:is-a inter:interactor)
     (:name :First-Move-Grow-interactor)
     (:start-action 'point-Int-Start-Action)
     (:running-action 'point-Int-Running-Action)
     (:stop-action 'point-Int-Stop-Action)
     (:abort-action 'point-Int-Abort-Action)
     (:outside-action 'point-Int-Outside-Action)
     (:back-inside-action 'point-Int-Back-Inside-Action)
     (:obj-to-change NIL)  ;supplied by application program
     (:Min-width 0); minimum allowed width and height
     (:Min-height 0)
     (:attach-point :where-hit) ; where attach to object
     (:grow-p NIL) ; if T then grow, else move
     (:point-p T)  ; if T, then move the point
     (:line-p NIL) ; if T, then move an end of the line,
		   ; else move left,top,width,height of rectangle
     (:x-off 0) ; needed for :where-hit.  Offset from where
     (:y-off 0)    ;    hit to top left of object
     (:saved-original-points NIL) ; used for ABORT or outside
     (:saved-last-points NIL) ; used if stop and outside and
                              ; outside control is :last
     (:obj-being-changed NIL) ; saved object under the mouse
     (:Go 'General-Go)  ; proc executed when events happen
     (:Do-Start 'point-Do-Start)     ; these are
     (:Do-Running 'point-Do-Running) ;   called by GO
     (:Do-Stop 'point-Do-Stop)       ;   to do
     (:Do-Abort 'Move-Grow-Do-Abort)     ;   the real work.
     (:Do-Outside 'Move-Grow-Do-Outside) ;   They call the
     (:Do-Back-Inside 'point-Do-Back-Inside)  ; appropriate
     (:Do-Outside-Stop 'Move-Grow-Do-Outside-Stop); -action
                                                  ; procedures
     (:initialize 'point-Interactor-Initialize))
