;;; -*- Mode: Text -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 
;; File            : taql312.tpl
;;; Author : Frank Ritter 
;;; Created On : Tue Jul 10 21:51:51 1990 
;;; Last Modified By: Frank Ritter
;;; Last Modified On: Wed Nov 13 15:36:04 1991
;;; Update Count : 260
;;; 
;;; PURPOSE 
;;; 	The templates to create taql constructs.  
;;; This is designed to work with TAQL 3.1.1, 
;;; not all Taql 3.0.* constructs are supported.  
;;; 
;;; TABLE OF CONTENTS 
;;; 	I.  The main menu 
;;; 	II.  The main constructs 
;;; 	III.  Text templates 
;;;	IV.  Construct name templates 
;;; 
;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Theory: things are autocompleted (with !) if linear path, no menu
;;;   choices, & on bottom level, or menu on bottom level that is v. clear.
;;; "You have to be able to see what's coming."
;;; * 
;;; 
; Naming conventions
;
;  Current                                            manual
;{fu}   is required, once only                     {fu}
;{?fu}  is optional                                [fu]
;{fus}  is a bunch (and at least one) fu           [fu]+
;{?fus} is 0,1 or more fu's                        [fu]*
;
;Another approach would be:  this would be less formal, and perhaps
;more accessable.
;
;[!fu]  (or {} if I can't get [] to work)
;[?fu]
;[+fu]
;[*fu]
;
;Clauses are complicated with sub-templates
;conditions bottom out with text
;
;Lists with more than 1 line of items get parens matched in column.
;
;Relative sizes of various template sets on 8/8/90:
;
;  1382  awk.tpl
;  2715  c.tpl
;  2548  latex.tpl
;  2808  elisp.tpl
;  3401  pascal.tpl
;  5484  bib.tpl
;  6151  scribe.tpl
;  8459  texinfo.tpl
; 30180  taql.tpl
;



;;; ****************************************************************
;;;        I.   the main menu
;;; ****************************************************************

Template taql-construct Selection
:begin
    PROBLEM-SPACE-PROPOSAL-AND-INITIALIZATION:
propose-space:	  	
propose-initial-state:
propose-task-state:  
    OPERATOR-PROPOSAL:
propose-task-operator:	
propose-operator:	
    OPERATOR-SELECTION:
prefer:
compare:
    OPERATOR-APPLICATION:
apply-operator:		
result-superstate:
propose-superobjects:	
    GOAL-TESTING-and-EVALUATION:
goal-test-group:	
evaluate-object:	
evaluation-properties:	
    ELABORATION:
augment:
    OTHER-TEMPLATES:
sp:			; the simple sp
taql-program-template:	; Yost's outline
:end
         5 /14 finished noon 2 aug
         6 /14 finished 1416 2 aug
         7 /14 finished 1951 2 aug
         8 /14 finished 1354 3 aug
         9 /14 finished 2323 3 aug
         10/14 finished 1737 5 aug
         11/14 finished 1007 6 aug
         12/14 finished 2042 8 aug
         13/14 finished 2053 8 aug

;;; ****************************************************************
;;; 	II.   The main constructs
;;;
;;; The large constructs here, then the small ones down below.  Both
;;; should be alphabetic.  Constructs only used within one TC are 
;;; included up here.
;;; ****************************************************************

;;;
;;;    PROBLEM SPACE PROPOSAL AND INITIALIZATION
;;;

Template PROBLEM-SPACE-PROPOSAL-AND-INITIALIZATION Selection
:begin
propose-space:
propose-initial-state:
propose-task-state:
:end


Template propose-space Sequence
:begin
(propose-space {!propose-space-name}
  {space-to-propose}
  {subspace-function-clause}
  {?when-conditions}
  {?copy-clauses}
  {?rename-clauses}
  {?new-addition-clauses}
  {?use-superspace-or-top-space-or-id-clause}
)
:end

Template space-to-propose Sequence
:begin
:space {!textenter:problem-space-name}
:end


;;;
;;; Subspace-function
;;;

Template subspace-function-clause Sequence
:begin
:function ({subspace-function})
:end

Template subspace-function Selection
:begin
apply-operator-operator-condition:
propose-or-select-initial-state-or-operator-for-space:
propose-or-select-space-that-will-perform-function:
:end

Template apply-operator-operator-condition Sequence
:begin
apply operator {!operator-condition}
:end

Template propose-or-select Selection
:begin
propose
select
:end

Template propose-or-select-initial-state-or-operator-for-space Sequence
:begin
{propose-or-select} {initial-state-or-oper} for {!textenter:problem-space-name}
:end

Template initial-state-or-oper Selection
:begin
initial-state
operator
:end

Template propose-or-select-space-that-will-perform-function Sequence
:begin
{propose-or-select} space that will {!subspace-function}
:end



;;;
;;;   propose-initial-state 
;;;

Template propose-initial-state Sequence
:begin
(propose-initial-state {!propose-initial-state-name}
  {?space-condition}
  {?when-conditions}
  {?copy-clauses}
  {?rename-clauses}
  {?new-addition-clauses}
  {?use-superstate-or-top-state-or-id-clause}
)
:end


Template use-superstate-or-top-state-or-id-clause Sequence
:begin
:use {!superstate-or-top-state-or-id}
:end

Template superstate-or-top-state-or-id Selection
:begin
superstate
top-state
id:
:end

Template propose-task-state Sequence
:begin
(propose-task-state {!propose-task-state-name}
  {?space-condition}
  {?when-conditions}
  {?new-addition-clauses}
)
:end



;;;
;;;    OPERATOR PROPOSAL
;;;

Template OPERATOR-PROPOSAL Selection
:begin
propose-task-operator:
propose-operator:
:end

Template propose-task-operator Sequence
:begin
(propose-task-operator {!propose-task-operator-name}
  {?space-condition}
  {PTO-operator-creation-clause}
  {?when-conditions}
)
:end

Template PTO-operator-creation-clause Sequence
:begin
:op {!simple-name-or-operator-creation-spec}
:end

Template operator-substructure-clause Sequence
:begin
:substructure {soar-actions}
:end

Template operator-name-or-no-name Selection
:begin
operator:
:no-name
:end

Template operator Sequence
:begin
{!textenter:operator-name}
:end




;;; 
;;;  Propose-operator
;;; 

Template propose-operator Sequence
:begin
(propose-operator {!propose-operator-name}
  {PO-operator-creation-clauses}
  {?space-condition}
  {?when-conditions}
  {?select-once-only}
)
:end

Template PO-operator-creation-clauses Repetition
:begin

{PO-operator-creation-clause}
:end

Template PO-operator-creation-clause Selection
:begin
PO-operator-creation-clause-by-id:
PO-operator-creation-clause-by-spec:
:end

Template PO-operator-creation-clause-by-id Sequence
:begin
:op-id <{!textenter:operator-id}>
:end

Template PO-operator-creation-clause-by-spec Sequence
:begin
:op {simple-name-or-operator-creation-spec}
:end

Template simple-name-or-operator-creation-spec Selection
:begin
operator:
operator-creation-spec:
:end


Template operator-creation-spec Sequence
:begin
({operator-name-or-no-name}{attribute-value-pairs}
 {?when-conditions}
 {?operator-substructure-clause})
:end


;;;
;;;    OPERATOR SELECTION	
;;;

Template  OPERATOR-SELECTION Selection
:begin
prefer:
compare:
:end

Template prefer Sequence
:begin
(prefer {!prefer-name}
  {?space-condition}
  {?when-conditions}
  {?operator-condition-clause}
  {preferences-clauses}
  {?obscure-prefer-clauses}
)
:end

;;;
;;; Preferences
;;;

Template preferences-clauses Repetition
:begin

{preference-clause}
:end

Template preference-clause Sequence
:begin
:value {preference}
:end

Template preference Selection
:begin
best
worst
indifferent
reject
require
prohibit
reconsider
:end



;;;
;;;  COMPARE
;;;

Template compare Sequence
:begin
(compare {!compare-name}
  {?space-condition}
  {?when-conditions}
  {?op1-and-op2}
  {relation}
  {?obscure-compare-clauses}
)
:end

Template obscure-compare-clauses Sequence
:begin
{?for-goal-condition}
{?object-type-spec}
{?object1-and-object2}
:end

Template object1-and-object2 Sequence
:begin
:object1 <{!textenter:id-name}>
:object2 <{!textenter:id-name}>
:end

Template op1-and-op2 Sequence
:begin
:op1 {operator-condition}
:op2 {operator-condition}
:end

Template relation Sequence
:begin
:relation {better-or-worse-or-indifferent}
:end

Template better-or-worse-or-indifferent Selection
:begin
better
worse
indifferent
:end



;;;
;;;    OPERATOR APPLICATION
;;;

Template OPERATOR-APPLICATION Selection
:begin
apply-operator:
result-superstate:
propose-superobjects:
:end

Template apply-operator Sequence
:begin
(apply-operator {!apply-operator-name}
  {operator-condition-clause}
  {?space-condition}
  {?when-conditions}
  {?terminate-when-conditions}
  {?AO-edits}
)
:end

Template terminate-when-conditions Repetition
:begin

{terminate-when-condition}
:end

Template terminate-when-condition Sequence
:begin
:terminate-when ({conditions})
:end

Template AO-edits Repetition
:begin

{AO-edit}
:end

Template AO-edit Sequence
:begin
(edit :what {state-or-top-state-or-state-attribute}
  {?AO-edit-type}
  {?when-conditions}
  {?replace-AO-edit-clauses}
  {?rename-AO-edit-clauses}
  {?remove-AO-edit-clauses}
  {?new-addition-clauses}
)
:end


Template state-or-top-state-or-state-attribute Selection
:begin
state
top-state
state-attribute:
:end

Template state-attribute Sequence
:begin
({state-attribute-or-none} {!textenter:class} {?id})
:end

Template state-attribute-or-none Selection
:begin
state-attribute-name:
:none
:end

Template state-attribute-name Sequence
;; this looksalot like attribute
:begin
{!textenter:attribute-name}
:end

;;;
;;; replace-AO-edit clauses
;;;

Template replace-AO-edit-clauses Repetition
:begin

{replace-AO-edit-clause}
:end

Template replace-AO-edit-clause Sequence
:begin
:replace ({!attribute-name}{?var-or-const}
          :by {!value}
          {?when-conditions}
         )
:end

;;;
;;; Rename-AO-edit clauses
;;;

Template rename-AO-edit-clauses Repetition
:begin

{rename-AO-edit-clause}
:end

Template rename-AO-edit-clause Sequence
:begin
:rename ({attribute-name}{?var-or-const} :to {!attribute-name}
         {?when-conditions}
         )
:end

;;;
;;; remove-AO-edit clauses
;;;

Template remove-AO-edit-clauses Repetition
:begin

{remove-AO-edit-clause}
:end

Template remove-AO-edit-clause Sequence
:begin
:remove ({attribute-name-or-all}{?var-or-const}
         {?when-conditions}
         )
:end

Template AO-edit-type Sequence
:begin 
:type {!sliding-or-one-shot}
:end

Template sliding-or-one-shot Selection
:begin
sliding
one-shot
:end



;;;
;;;  More operator application
;;;

Template result-superstate Sequence
:begin
(result-superstate {!result-superstate-name}
  {?space-condition}
  {?group-type-condition}
  {?group-name-condition}
  {?when-conditions}
  {?RS-add-clauses}
  {?RS-replace-clauses}
  {?RS-remove-clauses}
  {?RS-selective-remove-clauses}
  {?use-superstate-or-final-state-or-id}
)
:end

Template RS-add-clauses Repetition
:begin

{RS-add-clause}
:end

Template RS-add-clause Sequence
:begin
:add {RS-edit}
:end

Template RS-replace-clauses Repetition
:begin

{RS-replace-clause}
:end

Template RS-replace-clause Sequence
:begin
:replace {RS-edit}
:end

Template RS-replace-clauses Repetition
:begin

{RS-replace-clause}
:end

Template RS-edit Sequence
:begin
({?when-conditions}
 {?copied-attributes-conditions}
 {?renamed-attributes-conditions}
 {?RS-action-specs}
)
:end

Template copied-attributes-conditions Repetition
:begin

{copied-attributes-condition}
:end

Template copied-attributes-condition Sequence
:begin
:copy {?attribute-names}
:end

Template renamed-attributes-conditions Repetition
:begin

{!renamed-attributes-condition}
:end

Template renamed-attributes-condition Sequence
:begin
:rename {?attribute-name-pairs}
:end

Template RS-remove-clause Sequence
:begin
:remove {RS-remove}
:end

Template RS-remove-clauses Repetition
:begin

{RS-remove-clause}
:end

Template RS-remove Sequence
:begin
({?when-conditions}
{RS-items-to-remove}
)
:end

Template RS-selective-remove-clause Sequence
:begin
:selective-remove {RS-remove}
:end

Template RS-selective-remove-clauses Repetition
:begin

{RS-selective-remove-clause}
:end

Template RS-items-to-remove Repetition
:begin

{RS-item-to-remove}
:end

Template RS-item-to-remove Sequence
:begin
{attribute-name-or-all}{?var-or-const}
:end

Template RS-action-spec Sequence
:begin
:new {action-spec}
:end

Template RS-action-specs Repetition
:begin

{RS-action-spec}
:end

Template use-superstate-or-final-state-or-id Sequence
:begin
:use {superstate-or-final-state-or-id}
:end

Template superstate-or-final-state-or-id Selection
:begin
superstate
final-state
id:
:end

;*[The syntax of RS-EDIT bears some
;examination.  In particular, one fewer level of parentheses are used
;with :copy, :rename, and :new keywords here than elsewhere.] 
;
;** [VAR-OR-CONST in RS-REMOVE  must be present in conjunction with
;:selective-remove, and cannot be present in conjunction with :remove.]



;;;
;;;   More operator application
;;; 

Template propose-superobjects Sequence
:begin
(propose-superobjects {!propose-superobjects-name}
  {?space-condition}
  {?group-type-condition}
  {?group-name-condition}
  {?when-conditions}
  {object-type-spec}
  {superobjects-to-propose}
)
:end

Template superobjects-to-propose Repetition
:begin

{!superobject}
:end

Template superobject Sequence
:begin
:object <{!textenter:id-name}>
:end


;;;
;;;      GOAL TESTING and EVALUATION
;;;

Template GOAL-TESTING-and-EVALUATION Selection
:begin
goal-test-group:
evaluate-object:
evaluation-properties:
:end

Template goal-test-group Sequence
:begin
(goal-test-group {!goal-test-group-name}
  {?space-condition}
  {?when-conditions}
  {?group-type-condition}
  {?group-name-condition}
  {?test-conditions}
)
:end

Template test-condition Sequence
:begin
:test ({!textenter:test-name} {when-conditions})
:end

Template test-conditions Repetition
:begin

{!test-condition}
:end


;;;
;;;   Evaluate-object
;;;

Template evaluate-object Sequence
:begin
(evaluate-object {!evaluate-object-name}
  {?space-condition}
  {?when-conditions}
  {?bind-object-id}
  {objects-to-evaluate}
  {?numeric-value-clauses}
  {?symbolic-value-clauses}
)
:end

Template object-to-evaluate Sequence
:begin
:what {object-type-or-condition-to-evaluate}
:end

Template objects-to-evaluate Repetition
:begin

{!object-to-evaluate}
:end

Template object-type-or-condition-to-evaluate Selection
:begin
evaluate-object-type:
evaluate-object-condition:
:end

Template evaluate-object-condition Sequence
:begin
({evaluate-object-type} {?when-conditions}
  {?bind-object-id}
  {?cycle-when-condition}
  {?return-when-conditions}
)
:end

Template evaluate-object-type Selection
:begin
problem-space
state
operator
lookahead-state
:end


Template numeric-value-clause Sequence
:begin
:numeric-value {simple-numeric-value-or-condition}
:end

Template numeric-value-clauses Repetition
:begin

{!numeric-value-clause}
:end

Template simple-numeric-value-or-condition Selection
:begin
novalue-or-integer:
novalue-or-integer-condition:
:end

Template novalue-or-integer-condition Sequence
:begin
({novalue-or-integer}
 {?when-conditions}
 {?bind-object-id} 
)
:end

;;;
;;;  Symbolic values
;;; 

Template symbolic-value-clause Sequence
:begin
:symbolic-value {symbolic-value-or-condition}
:end

Template symbolic-value-clauses Repetition
:begin

{!symbolic-value-clause}
:end

Template symbolic-value-or-condition Selection
:begin
symbolic-value-type:
symbolic-value-type-condition:
:end

Template symbolic-value-type-condition Sequence
:begin
({symbolic-value-type}
 {?when-conditions}
 {?bind-object-id} 
)
:end


Template cycle-when-condition Sequence
:begin
:cycle-when {!conditions}
:end

Template return-when-condition Sequence
:begin
:return-when {!conditions}
:end

Template return-when-conditions Repetition
:begin

{return-when-condition}
:end


Template bind-object-id Sequence 
:begin
:bind-object <{!textenter:id-name}>
:end

Template object-type-evaluate Sequence
:begin
:object-type {!ps-or-state-or-oper-or-lookahead-state}
:end

Template novalue-or-integer Selection
:begin
novalue
integer:
:end

;; we could put a lexical test in here later
Template integer Sequence
:begin
{!text:integer-or-compute-call}
:end

Template symbolic-value-type  Selection
:begin
novalue
success
failure
prohibit-failure
indifferent
less-common-symbolic-value-type:
:end

Template less-common-symbolic-value-type Selection
:begin
partial-success
partial-failure
required-success
prohibit-failure
lose
win
draw
:end



;;;
;;;  Evaluation-properties 
;;;

Template evaluation-properties Sequence
:begin
(evaluation-properties {!evaluation-properties-name}
  {space-condition}
  {?when-conditions}
  {?better-spec}
  {?if-multiple-spec}
  {?attributes-to-copy-in-lookahead}
)
:end

Template better-spec Sequence
:begin
:better {!higher-or-lower}
:end

Template higher-or-lower Selection
:begin
higher
lower
:end

Template if-multiple-spec Sequence
:begin
:if-multiple {pessimistic-or-optimistic-or-all}
:end

Template pessimistic-or-optimistic-or-all Selection
:begin
pessimistic
optimistic
all
:end

Template attributes-to-copy-in-lookahead Sequence
:begin
:lookahead ( {?monotonic-increasing-or-decreasing}
             {?EP-copy-attributes}
             {?EP-dont-copy-attributes}
             {?EP-copy-new-attributes}
           )
:end

Template monotonic-increasing-or-decreasing Sequence
:begin
:monotonic {!increasing-or-decreasing}
:end

Template EP-copy-attributes Sequence
:begin
:copy ({?attribute-names-or-all})
:end

Template EP-dont-copy-attributes Sequence
:begin
:dont-copy ({?attribute-names-or-any})
:end

Template EP-copy-new-attributes Sequence
:begin
:copy-new ({?attribute-names-or-all})
:end

Template increasing-or-decreasing Selection
:begin
increasing
decreasing
:end



;;;
;;;    ELABORATION
;;;

Template ELABORATION Selection
:begin
augment:
:end

Template augment Sequence
:begin
(augment {!augment-name} 
  {?space-condition}            
  {?when-conditions}
  {augmentations}
)
:end

;;;
;;;  Augmentations
;;;

Template augmentations Repetition
:begin

{!augmentation}
:end

Template augmentation Sequence
:begin
({first-soar-action} 
 {?other-soar-actions}
)
:end


;;;****************************************************************
;;;            II.   The helper parts
;;;****************************************************************
;;;
;;;  These are templates shared by more than one construct
;;;

Template new-addition-clause Sequence
;;for apply-operator and others
:begin
:new ({action-spec}
      {?when-conditions})
:end

Template new-addition-clauses Repetition
:begin

{new-addition-clause}
:end

Template action-spec Selection
:begin
attribute-and-simple-result:           ;{attribute-name}{results}
attribute-and-substructured-result:    ;{attribute-name}{soar-actions}
attribute-with-interlocked-results:    ;{attribute-value-pairs}{soar-actions}
:end

Template attribute-and-simple-result Sequence
:begin
{!textenter:attribute-name}{results}
:end

Template attribute-and-substructured-result Sequence
:begin
{!textenter:attribute-name} {soar-actions}
:end

Template attribute-with-interlocked-results Sequence
:begin
({attribute-value-pairs})
{?soar-actions}
:end


;;; Attributes

Template attribute-names Repetition
:begin
{!textenter:attribute-name}
:end

Template attribute-name Sequence
:begin
 {!textenter:attribute-name}
:end

Template attribute-name-pairs Repetition
:begin

{attribute-name-pair}
:end

Template attribute-name-pair Sequence
:begin
{!textenter:attribute-name} {!textenter:attribute-name}
:end

Template attribute-value-pair Sequence
:begin
 {?negation}^{textenter:attribute-name}{var-or-const-or-function-call}
:end

Template negation String
:begin
- 
:end

Template attribute-value-pairs Repetition
:begin
 {attribute-value-pair}
:end

Template value Selection
:begin
variable-name:
constant:
function-call:
soar-actions:
:end

Template attribute-name-or-all Selection
:begin
attribute-name:
:all
:end

Template attribute-names-or-all Selection
:begin
attribute-names:
 :all
:end

Template attribute-names-or-any Selection
:begin
attribute-names:
 :any
:end


;;;
;;; Conditions
;;;
;; this can be replaced by attribute-value-pairs directly....go away 1sept90
Template condition-tail Repetition
:begin
 {attribute-value-pairs}
:end

Template first-when-condition Sequence
:begin
({context-object-or-class-and-id}{!attribute-value-pairs})
:end

Template other-when-condition Sequence
:begin
({class-and-id}{!attribute-value-pairs})
:end

Template other-when-conditions Repetition
:begin

{other-when-condition}
:end

Template conditions Sequence
:begin
{first-when-condition}
{?other-when-conditions}
:end

Template constant Sequence
:begin
 {!textenter:constant}
:end

Template context-object Selection
:begin
goal
problem-space
state
operator
supergoal
superspace
superstate
superoperator
top-goal
top-space
top-state
top-operator
:end


;;;
;;; Copy clauses
;;;

Template copy-clauses Repetition
:begin

{!copy-clause}
:end

Template copy-clause Sequence
:begin
:copy ({?attribute-names}
            {?copy-new-clauses}
            {?when-conditions}
      )
:end

Template copy-new-clauses Repetition
:begin

:copy-new ({attribute-names})
:end

Template rename-copy-new-clauses Repetition
:begin

:copy-new ({attribute-name-pairs})
:end

;;;
;;;  First-soar-action
;;;

Template first-soar-action Sequence
:begin
({context-object-or-class} {attribute-value-pairs})
:end

Template context-object-or-class-and-id Selection
:begin
context-object:
class-and-id:
:end

Template context-object-or-class Selection
:begin
context-object:
class:
:end

Template class Sequence
:begin
{!textenter:class}
:end


Template class-and-id Sequence
:begin
{!textenter:class} <{!textenter:id-name}>
:end

Template for-goal-condition Sequence
:begin
:for-goal {!supergoal-or-id}
:end

Template function-call Sequence
:begin
 ({!textenter:function-n-args})
:end

;;;
;;;  Group test items
;;; 

Template group-name-condition Sequence
:begin
:group-name {constant-or-variable-group-name}
:end

Template constant-or-variable-group-name Selection
:begin
constant-group-name:
variable-group-name:
:end

Template constant-group-name Sequence
:begin
{!textenter:group-name}
:end

Template variable-group-name Sequence
:begin
<{!textenter:group-name}>
:end

Template group-type-condition Sequence
:begin
:group-type {success-or-failure}
:end

Template success-or-failure Selection
:begin
success
failure
:end


Template object-type-spec Sequence
:begin
:object-type {ps-or-state-or-oper}
:end

Template object-condition Sequence
:begin
:object <{!textenter:id-name}>
:end

Template operator-condition-clause Sequence
:begin
:op {!operator-condition}
:end

Template operator-condition Selection
:begin
operator:
operator-spec:
:end

Template operator-name-or-any-name Selection
:begin
operator:
:any-name
:end

Template operator-spec Sequence
:begin
({operator-name-or-any-name}{?attribute-value-pairs}
 {?when-conditions})
:end



Template ps-or-state-or-oper Selection
:begin
problem-space
state
operator
:end

Template ps-or-state-or-oper-or-lookahead-state Selection
:begin
problem-space
state
operator
lookahead-state
:end




;;;
;;; Rename clauses
;;;

Template rename-clauses Repetition
:begin

{rename-clause}
:end

Template rename-clause Sequence
:begin
:rename ({?attribute-name-pairs}
            {?rename-copy-new-condition}
            {?when-conditions}
        )
:end

Template rename-copy-new-condition Sequence
:begin
:copy-new ({attribute-name-pairs})
:end

;;;
;;; 
;;;

Template results Repetition
:begin

{var-or-const-or-function-call}
:end

Template select-once-only String
:begin
:select-once-only
:end


;;;
;;; Soar-actions
;;;

Template soar-action Sequence
:begin
({class-and-id}{!attribute-value-pairs})
:end

Template soar-actions Sequence
:begin
({first-soar-action} 
 {?other-soar-actions}
)
:end

Template other-soar-actions Sequence
:begin
{soar-action}
{?soar-action}
:end


;;;
;;;  Superspace and state names
;;;

Template space-condition Sequence
:begin
:space {!textenter:problem-space-name}
:end

Template use-superspace-or-top-space-or-id-clause Sequence
:begin
:use {!superspace-or-top-space-or-id}
:end

Template superspace-or-top-space-or-id Selection
:begin
superspace
top-space
id:
:end

Template supergoal-or-id Selection
:begin
id:
supergoal
:end

Template id Sequence
:begin
<{!textenter:id-name}>
:end


;;;
;;;  Var, constant, and when conditions
;;;

Template var-or-const Selection
:begin
variable-name:
constant:
:end

Template var-or-const-or-function-call Selection
:begin
variable-name:
constant:
function-call:
null-item:
:end

Template null-item String
:begin
:end

Template variable-name Sequence
:begin
 <{!textenter:variable-name}>
:end

Template when-condition Sequence
:begin
:when ({!conditions})
:end

Template when-conditions Repetition
:begin

{when-condition}
:end



;;; ****************************************************************
;;;        III.   Text and other templates
;;; ****************************************************************

Template OTHER-TEMPLATES Selection
:begin
sp:			; the simple sp
taql-program-template:	; Yost's outline
template:    		; for making more templates
:end


Template sp Sequence
:begin
(sp {!textenter:sp-name}
    {conditions}
  -->
    {actions})

:end

Template action Sequence
:begin
({textlong:action})
:end

Template actions Repetition
;; this is only used in sp
:begin

{action}
:end

Template template Sequence
:begin
Template {text:template-name} {template-type}
:begin
{textlong}
{template-end}

:end

Template template-end Function
:begin
":end"
:end

Template template-type Selection
:begin
Sequence
Selection
Repetition
String
Lexical
Function
:end


Template taql-program-template String
:begin
;==============
; Soar switches
;==============

(user-select ...)
(trace-attributes ...)
(multi-attributes ...)

;===========
; Task setup
;===========

; ---- propose task state and operator:

;===========
; Task space
;===========

; ---- propose space:

; ---- propose initial state:

; ---- goal test:

; ---- return results:

; ---- state elaborations:

; ---- propose operators:

; ---- apply operators:

; ---- search control (select operator):

:end


;;;****************************************************************
;;;	IV.	Construct name templates
;;;****************************************************************

Template problem-space-name Sequence
:begin
{!textenter:problem-space-name}*
:end

Template name-message Sequence
:begin
*{!textenter:name-message}
:end

Template operator-name Sequence
:begin
*{!textenter:operator-name}
:end

Template task-name Sequence
:begin
*{!textenter:task-name}
:end

;; used in names only
Template group-type-or-name Sequence
:begin
*{!group-type-or-name-choice}
:end

Template group-type-or-name-choice Selection
:begin
group-name:
success-or-failure:
:end

Template group-name Sequence
:begin
*{!textenter:group-name}
:end



Template propose-space-name Sequence
:begin
{!problem-space-name}PS{?name-message}
:end

Template propose-initial-state-name Sequence
:begin
{!problem-space-name}PIS{?name-message}
:end

;; took off {!problem-space-name} b/c GRY doesn't think its used much 6/91
Template propose-task-state-name Sequence
:begin
PTS{?task-name}{?name-message}
:end

;; took off {!problem-space-name} b/c GRY doesn't think its used much 6/91
Template propose-task-operator-name  Sequence
:begin
PTO{!task-name}{?name-message}
:end

Template propose-operator-name Sequence
:begin
{!problem-space-name}PO{!operator-name}{?name-message}
:end

Template prefer-name Sequence
:begin
{!problem-space-name}P{!operator-name}{?name-message}
:end

Template compare-name Sequence
:begin
{!problem-space-name}C{!operator-name}{!operator-name}{?name-message}
:end

Template apply-operator-name Sequence
:begin
{!problem-space-name}AO{!operator-name}{?name-message}
:end

Template result-superstate-name Sequence
:begin
{!problem-space-name}RS{group-type-or-name}{?name-message}
:end

Template propose-superobjects-name Sequence
:begin
{!problem-space-name}PSO{group-type-or-name}{?name-message}
:end

Template goal-test-group-name Sequence
:begin
{!problem-space-name}GTG{group-type-or-name}{?name-message}
:end

Template evaluation-properties-name Sequence
:begin
{!problem-space-name}EP{?name-message}
:end

Template evaluate-object-name Sequence
:begin
{!problem-space-name}EO{?name-message}
:end

Template augment-name Sequence
:begin
{!problem-space-name}A{?name-message}
:end

Template sp-name Sequence
:begin
{!problem-space-name}SP{?name-message}
:end


;;;****************************************************************
;;;	V.	Subselection templates
;;;****************************************************************
;;;
;;;  These are automatically generated by the Make-sub-selection-template
;;; function in soar-template.el, and then inserted here.
;;;

Template propose-space-clauses Selection
:begin
propose-space-name:
space-to-propose:
subspace-function-clause:
when-conditions:
copy-clauses:
rename-clauses:
new-addition-clauses:
use-superspace-top-space-or-id-clause:
:end

Template propose-initial-state-clauses Selection
:begin
propose-initial-state-name:
space-condition:
when-conditions:
copy-clauses:
rename-clauses:
new-addition-clauses:
use-superstate-or-top-state-or-id-clause:
:end

Template propose-task-state-clauses Selection
:begin
propose-task-state-name:
space-condition:
when-conditions:
new-addition-clauses:
:end

Template propose-task-operator-clauses Selection
:begin
propose-task-operator-name:
PTO-operator-creation-clause:
space-condition:
when-conditions:
:end


Template propose-operator-clauses Selection
:begin
propose-operator-name:
PO-operator-creation-clauses:
space-condition:
when-conditions:
select-once-only:
:end


Template prefer-clauses Selection
:begin
prefer-name:
space-condition:
when-conditions:
for-goal-condition:
object-type-spec:
object-condition:
operator-condition-clause:
preferences-clauses:
:end


Template compare-clauses Selection
:begin
compare-name:
space-condition:
when-conditions:
for-goal-condition:
object-type-spec:
object1-and-object2:
op1-and-op2:
relation:
:end


Template apply-operator-clauses Selection
:begin
apply-operator-name:
operator-condition-clause:
space-condition:
when-conditions:
terminate-when-conditions:
AO-edits:
:end


Template result-superstate-clauses Selection
:begin
result-superstate-name:
space-condition:
group-name-condition:
group-type-condition:
when-conditions:
RS-add-clauses:
RS-replace-clauses:
RS-remove-clauses:
RS-selective-remove-clauses:
use-superstate-or-final-state-or-id:
:end


Template propose-superobjects-clauses Selection
:begin
propose-superobjects-name:
space-condition:
group-name-condition:
group-type-condition:
when-conditions:
object-type-spec:
superobjects-to-propose:
:end


Template goal-test-group-clauses Selection
:begin
goal-test-group-name:
space-condition:
when-conditions:
group-name-condition:
group-type-condition:
test-conditions:
:end


Template evaluate-object-clauses Selection
:begin
evaluate-object-name:
space-condition:
when-conditions:
bind-object-id:
objects-to-evaluate:
numeric-value-clause:
symbolic-value-clause:
:end


Template evaluation-properties-clauses Selection
:begin
evaluation-properties-name:
space-condition:
when-conditions:
better-spec:
if-multiple-spec:
attributes-to-copy-in-lookahead:
:end


Template augment-clauses Selection
:begin
augment-name:
space-condition:
when-conditions:
augmentations:
:end


Local Variables:
tpl-begin-template-definition:"^Template"
tpl-begin-template-body:"^:begin"
tpl-end-template-body:"^:end"
end:
