;;;; -*- Mode: Emacs-Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : taql-simple-menus.el
;;;; Author          : Frank Ritter
;;;; Created On      : Wed Nov 13 15:34:03 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Wed Apr  8 16:05:25 1992
;;;; Update Count    : 3
;;;; 
;;;; PURPOSE
;;;; 	Set up simple menus for taql-mode.
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Status          : Unknown, Use with caution!
;;;; HISTORY
;;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;
;;; test functions

(defun run-soar-menu () 
  "provide a menu of commands for Soar and Taql."
  (interactive)
  (run-menu 'soar-menu))

(if (and (boundp 'soar-menu) (not soar-menu))
    (add-to-menu 'soar-menu
		 '(("TAQL          Do Taql commands." taql-menu)))
    (def-menu
      'soar-menu
      "" ;main prompt
      "The menu key allows you to select various command options" ;help prompt
      '(("TAQL          Do Taql commands." taql-menu) ))
)

(def-menu
  'taql-document-menu 
  "" ;main prompt
  "The menu key allows you to select various documents to browse:" ;help prompt
  ;; all manuals should live in the manuals sub-directory
 '(("1-taql311    Old TAQL manual."
       (goto-manual "taql-manual311.doc" 'taql-mode))
   ("2-taql313    Main TAQL manual."
       (goto-manual "taql-manual313.doc" 'taql-mode))
   ("3-taql313rn  TAQL 313 release notes."
       (goto-manual "taql313-rnotes.doc"  'taql-mode))
   ("4-taql314rn  TAQL 314 release notes."
       (goto-manual "release-notes.3.1.4.doc" 'taql-mode))
   ("5-taql315rn  Release notes for TAQL 3.1.5 (and hidden 314 features)."
       (goto-manual "release-notes.3.1.5.doc" 'taql-mode))
   ("6-taql-mode  Taql-mode manual."
       (goto-manual "taql-mode.doc" 'taql-mode))
))

(def-menu 'taql-menu 
  "TC commands" ;main prompt
  "" ;help prompt
 '(
    ("Template Insert   Insert a TC template." taql-insert-construct)
    ("Expand            Expand all placeholders in a template." 
                        taql-expand-construct)
    ("1Expand           Expand just the current clause (^u then above Expand keys)."
                        taql-expand-clause)
    ("Add               Add another clause to a template."  taql-add-clause)
    ("Fixup             Cleanup a completed  template."  taql-fixup-construct)
    ("Docs              TAQL and taql-mode documents."    taql-document-menu)
    ("List              List the taql TC's in the current buffer." 
                        taql-list-tc-names)
    ("/AutoComp         Auto complete a partial word
                   (also bound to TAB when expanding a TC & always ESC-/)."
                   dabbrev-expand)
    ("Bug               Generate a bug report to send in." taql-bug)
))
