;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/windows.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Changes:
;;; 21-Feb-91 Pervin  New exported routine iconify-window.
;;; 31-Jan-91 Pervin  In fix-properties, when a window is made visible,
;;;                   call xlib:map-window last.
;;; 12-Nov-90 Pervin  Made first argument to convert-coordinates optional.
;;;  9-Nov-90 Pervin  Made second argument to convert-coordinates optional.
;;; 31-Oct-90 Pervin  Finally added convert-coordinates, which I'd
;;;                   forgotten before.
;;; 29-Oct-90 Pervin  Fixed bug found by Brad VanderZanden involving
;;;                   expanding a double-buffered window (caused by
;;;                   misprint in Configure-Notify).
;;; 25-Oct-90 Pervin  New exported commands opal:raise-window and
;;;                     opal:lower-window which move window to front or
;;;                     back of screen.
;;; 10-Sep-90 Meltsner Fixed bug in initialize-window-border-widths of
;;;		      DECWindow users.     w5 --> p5
;;;  6-Sep-90 Pervin  Added an update-all at the end of Configure-Notify.
;;; 24-Aug-90 Pervin  You can now reset the :title and :icon-title
;;;		      of a window.
;;; 15-Aug-90 Pervin  Removed :display branch of case statement
;;;		      in fix-properties.
;;; 13-Aug-90 Pervin  Added code to handle DECWindows window manager.
;;; 10-Aug-90 Pervin  It turns out that I did need that event-case at
;;;		      the end of create-x-drawable after all (see 2-Aug-90).
;;;  9-Aug-90 Pervin  Added temporary #+pmax stuff because currently
;;;		      xlib:query-tree does not work on the Pmax.
;;;  3-Aug-90 Pervin  In Configure-Notify, check is window has parent.
;;;  2-Aug-90 Pervin  Reparent-notify must reset :lineage slot.
;;;		      Also, didn't need event-case at end of create-x-drawable.
;;;  1-Aug-90 Pervin  Made it so that the :width and :height slots of
;;;		      windows are based on the inside, rather than the
;;;		      outside of the window.
;;; 30-Jul-90 Pervin  Big changes in initialize-window-border-widths
;;;		      and Configure-Notify to handle MWM window manager.
;;;		      Got rid of :just-did-configure slot, but added
;;;		      new :lineage slot.
;;; 18-Jul-90 Pervin  Moved the call to initialize-window-border-widths
;;;		      yet again -- this time, to inside Configure-Notify.
;;;		      Also, expand-buffer uses :width, :height slots of
;;;		      window being expanded.
;;; 13-Jul-90 Pervin  New :destroy-me method for windows.
;;;		      I had to remove the optional erase argument.
;;;  5-Jul-90 Pervin  In Exposure, don't need special case for
;;;		      double-buffered window.
;;;  2-Jul-90 Pervin  If an expose event occurs, just refresh the parts
;;;                   of the window that were exposed.
;;; 26-Jun-90 Pervin  Extended :just-did-configure test to :width and
;;;                   :height slots, as well as :top and :left.
;;; 18-Jun-90 Pervin  Variable *clear* for erasing buffers.
;;;  5-Jun-90 Pervin  Implemented double-buffering.
;;;  4-Jun-90 Myers   Added :just-did-configure slot to windows
;;;		      in order to get rid of *twm-bug*
;;; 25-May-90 Pervin  Call initialize-window-border-widths only at the
;;;		      very end of create-x-drawable.
;;;  8-May-90 Sannella/Pervin
;;;                   The way of specifying a user-positioned window
;;;                   has changed.  Now we use the :user-specified-position-p
;;;                   argument to xlib:set-standard-properties.
;;; 19-Mar-90 Pervin  Changed :tile to :stipple.  Added reference to *twm-bug*
;;; 12-Mar-90 Pervin  Setting :title and :icon-title of windows
;;;		      in :initialize method.
;;; 28-Feb-90 Pervin  Fixed bug in set-window-cursor.
;;;		      Now it works in Lucid and Allegro too!
;;; 14-Feb-90 Pervin  Commented out body of set-window-cursor.
;;; 13-Feb-90 Pervin  Implemented color.
;;;  5-Dec-89 Pervin  Moved new-garnet-window-name to new-defs.lisp
;;;

(in-package "OPAL" :use '("LISP" "KR"))

;;; Windows

;;; Class Window 
;;; To create a window for displaying gobs, create a schema which is an
;;; instance of the window class described below specifying slots as
;;; needed. For example:
;;; 
;;; (create-instance my-window opal:window
;;;   (:width 100)
;;;   (:height 100))
;;; 

(define-method :point-in-gob opal:window (gob x y)
  (and (<= 0 x (g-value gob :width))
       (<= 0 y (g-value gob :height))))

;;; A couple routines useful for windows with backing store

;;; Create a buffer the same size as drawable.
(defun create-x-buffer (a-window)
  (let ((drawable (g-value a-window :drawable)))
    (xlib:create-pixmap :width (g-value a-window :width)
		        :height (g-value a-window :height)
		        :depth (xlib:drawable-depth drawable)
		        :drawable drawable)))

;;; Initalize the buffer to be white.
(defun clear-buffer (buffer gc)
  (xlib:with-gcontext (gc :function opal::*clear*)
    (xlib:draw-rectangle buffer gc 0 0
	(xlib:drawable-width buffer)
	(xlib:drawable-height buffer) t)))

(defun expand-buffer (a-window)
  (let* ((old-buffer (g-value a-window :buffer))
	 (new-buffer (create-x-buffer a-window))
         (old-buffer-gc (g-value a-window :buffer-gcontext))
	 (new-buffer-gc (xlib:create-gcontext :drawable new-buffer)))
    (xlib:copy-gcontext-components old-buffer-gc new-buffer-gc :foreground :background)
    (clear-buffer new-buffer new-buffer-gc)
    (xlib:copy-area old-buffer old-buffer-gc 0 0
                    (g-value a-window :width)
		    (g-value a-window :height)
		    new-buffer 0 0)
    (xlib:free-gcontext old-buffer-gc)
    (xlib:free-pixmap old-buffer)
    (s-value a-window :buffer-gcontext new-buffer-gc)
    (s-value a-window :buffer new-buffer)))


(defun Map-Notify (event-debug event-window)
  (when event-debug (format t "map-notify ~S~%" (xlib:window-id event-window)))
  (let ((a-window (gethash event-window
			 *drawable-to-window-mapping*)))
    (when a-window
      (s-value a-window :visible t)))
  t)

(defun Unmap-Notify (event-debug event-window)
  (when event-debug (format t "unmap-notify ~S~%" (xlib:window-id event-window)))
  (let ((a-window (gethash event-window
			 *drawable-to-window-mapping*)))
    (when a-window
      (s-value a-window :visible NIL)))
  t)

(defun Circulate-Notify (event-debug)
  (when event-debug (format t "circulate-notify~%"))
  t)

(defun Gravity-Notify (event-debug)
  (when event-debug (format t "gravity-notify~%"))
  t)

;; Returns list of drawable, parent, grandparent, ... , root.
(defun lineage-of-drawable (drawable)
#-comment
;;; Warning: In Allegro Common Lisp running under the Mach
;;; operating system, the latest of version of CLX has a
;;; bug: it crashes when you call xlib:query-tree.
;;; If this is the case, switch the #+ and #- in the
;;; following code.
  (multiple-value-bind (children parent root)
		       (xlib:query-tree drawable)
    (declare (ignore children))
    (if (eq parent root)
	(list drawable root)
	(cons drawable (lineage-of-drawable parent))))
#+comment
  (list drawable opal::*default-x-root*)
)

(defun Reparent-Notify (event-debug event-window x y)
  (when event-debug (format t "reparent-notify ~s ~s ~s~%" event-window x y))
  (let ((a-window (gethash event-window *drawable-to-window-mapping*)))
    (when (and a-window (= (xlib:window-id (g-value a-window :drawable))
			   (xlib:window-id event-window)))
      (s-value a-window :already-initialized-border-widths nil)
      (s-value a-window :lineage (lineage-of-drawable event-window))))
  t)

;;;       snarfed in it's entirety from hemlock code
;;; removes any events still drifting about on the queue that are meant for
;;; the window that is about to be destroyed
(defun deleting-window-drop-events (display win)
#-cmu (declare (ignore win))
  (xlib:display-finish-output display)
#+cmu  
  (let ((result nil))
    (xlib:process-event
     display :timeout 0
     :handler #'(lambda (&key event-window a-window &allow-other-keys)
		  (if (or (eq event-window win) (eq a-window win))
		      (setf result t)
		      nil)))
    result)
#-cmu
  (xlib:discard-current-event display)
  )

(defun Destroy-Notify (event-debug event-window)
  ;; do nothing, actually, probably destroy aggregate ?
  (when event-debug (format t " destroy-notify ~s~%" (xlib:window-id
						      event-window)))
  (deleting-window-drop-events (xlib:window-display event-window)
			       event-window)

  t)

#+clx-mit-r4
(defun iconify-window (a-window)
  (xlib:iconify-window (g-value a-window :drawable)
		       opal::*default-x-screen*)
  (xlib:display-force-output opal::*default-x-display*))

#-clx-mit-r4
(defun iconify-window (a-window) (declare (ignore a-window)))

(defun raise-window (a-window)
  (setf (xlib:window-priority (g-value a-window :drawable)) :above)
  (update a-window))

(defun lower-window (a-window)
  (setf (xlib:window-priority (g-value a-window :drawable)) :below)
  (update a-window))

(defun convert-coordinates (win1 x y &optional win2)
  (let ((draw1 (when win1 (g-value win1 :drawable)))
	(draw2 (when win2 (g-value win2 :drawable))))
    (when (and draw1 (null win2))
      (setq draw2 (xlib:drawable-root draw1)))
    (when (and draw2 (null win1))
      (setq draw1 (xlib:drawable-root draw2)))
    (if (and draw1 draw2)
	(xlib:translate-coordinates draw1 x y draw2)
	(let ((left1 (if win1 (g-value win1 :left) 0))
	      (top1  (if win1 (g-value win1 :top) 0))
	      (left2 (if win2 (g-value win2 :left) 0))
	      (top2  (if win2 (g-value win2 :top) 0)))
	  (values (- (+ x left1) left2)
		  (- (+ y top1)  top2))))))


(defun simple-initialize-window-border-widths (a-window border-width)
  (s-value a-window :left-border-width border-width)
  (s-value a-window :top-border-width border-width)
  (s-value a-window :right-border-width border-width)
  (s-value a-window :bottom-border-width border-width))


(defun initialize-window-border-widths (a-window drawable)
  ;; find out what borders really are
  (if (g-value a-window :parent)  ;; window is really subwindow
      (simple-initialize-window-border-widths a-window 
				  (xlib:drawable-border-width drawable))
      (let ((lineage (g-value a-window :lineage)))
	(case (length lineage)
	  (2		;;; UWM or window without title
	   (simple-initialize-window-border-widths a-window
				  (xlib:drawable-border-width drawable)))
	  (3		;;; TWM
	   (let ((border-width (xlib:drawable-border-width (second lineage))))
	       (s-value a-window :left-border-width
			(+ border-width (xlib:drawable-x drawable)))
	       (s-value a-window :top-border-width
			(+ border-width (xlib:drawable-y drawable)))
	       (s-value a-window :right-border-width border-width)
	       (s-value a-window :bottom-border-width border-width)))
	  (4		;;; MWM
	   (let ((parent (second lineage))
		 (grandparent (third lineage)))
	     (s-value a-window :left-border-width (xlib:drawable-x parent))
	     (s-value a-window :top-border-width (xlib:drawable-y parent))
	     (s-value a-window :right-border-width
		      (- (xlib:drawable-width grandparent)
			 (xlib:drawable-width parent)
			 (xlib:drawable-x parent)))
	     (s-value a-window :bottom-border-width
		      (- (xlib:drawable-height grandparent)
			 (xlib:drawable-height parent)
			 (xlib:drawable-y parent)))))
	  (6            ;;; DECWindows
	   (let* ((p4 (fourth lineage))
		  (p5 (fifth lineage))
		  (w4 (xlib:drawable-border-width p4))
		  (w5 (xlib:drawable-border-width p5)))
	     (s-value a-window :left-border-width (+ w4 w5))
	     (s-value a-window :top-border-width (+ w4 (xlib:drawable-x p5)))
	     (s-value a-window :right-border-width (+ w4 w5))
	     (s-value a-window :bottom-border-width (+ w4 w5))))))))

(defun Configure-Notify (event-debug x y width height event-window above-sibling)
  (when event-debug
    (format t "Configure-notify win=~s ~s ~s ~s ~s ~s~%"
	    (xlib:window-id event-window) x y
	    width height (if above-sibling
			     (xlib:window-id above-sibling))))
  (let ((a-window (gethash event-window *drawable-to-window-mapping*)))
    (when (and a-window (= (xlib:window-id (g-value a-window :drawable))
			   (xlib:window-id event-window)))
      (if (g-value a-window :parent)
	  (progn			; If it's a subwindow, we don't
	    (s-value a-window :left x)  ; have to check lineage.
	    (s-value a-window :top y))
	  (let ((lineage (or (g-value a-window :lineage)
			     (s-value a-window :lineage
				      (lineage-of-drawable event-window)))))
	    (case (length lineage)
	      (2	;;; UWM or window without label.
	       (s-value a-window :left x)
	       (s-value a-window :top y))
	      (3	;;; TWM
	       (s-value a-window :left (xlib:drawable-x (second lineage)))
	       (s-value a-window :top (xlib:drawable-y (second lineage))))
	      (4	;;; MWM
	       (s-value a-window :left (xlib:drawable-x (third lineage)))
	       (s-value a-window :top (xlib:drawable-y (third lineage))))
	      (6        ;;; DECWindows
	       (s-value a-window :left (xlib:drawable-x (fourth lineage)))
	       (s-value a-window :top (xlib:drawable-y (fourth lineage)))))))
      (unless (g-value a-window :already-initialized-border-widths)
	(initialize-window-border-widths a-window event-window)
	(s-value a-window :already-initialized-border-widths t))
      (s-value a-window :width width)
      (s-value a-window :height height)
      ;; Don't want top, left, width, height to be invalid,
      ;; or else we might get a drifting window.
      (let ((win-info (g-value a-window :win-update-info)))
	(setf (win-update-info-invalid-slots win-info)
	      (set-difference (win-update-info-invalid-slots win-info)
			      '(:left :top :width :height))))
      (let ((old-buffer (g-value a-window :buffer)))
	(when (and old-buffer
		   (or (> height (xlib:drawable-height old-buffer))
		       (> width  (xlib:drawable-width old-buffer))))
	  (expand-buffer a-window)))
      ;; Update windows which have formulas dependent on a-window.
      (opal:update-all)
      ))
  t)

(defun Exposure (event-debug event-window count x y width height display)
  (when event-debug
    (format t "exposure, count = ~S window-id=~s"
	    count (xlib:window-id event-window))
    (if (xlib:wm-hints-p event-window)
	(format t "title = ~S~%")
	(format t "~%")))
  (let ((a-window (gethash event-window *drawable-to-window-mapping*))
	bbox)
    (when (and a-window
	       (= (xlib:window-id (g-value a-window :drawable))
		  (xlib:window-id event-window)))
      (setq bbox (opal::make-bbox :x1 x :y1 y
				  :x2 (+ x width) :y2 (+ y height)
			          :valid-p t))
      ;; throw away extra exposure events on this window
      ;; drop out of this loop, once any other events show up
      #-cmu
      (unless (eq count 0)
	(xlib:event-case (display :discard-p t :timeout 0)
		  (:EXPOSURE ((:event-window this-window)
                              (:count this-count)
			      (:x x1)
			      (:y y1)
			      (:width w)
			      (:height h))
			     (merge-bbox bbox
			       (make-bbox :x1 x1 :y1 y1 :x2 (+ x1 w)
				 :y2 (+ y1 h) :valid-p t))
			     (if (and (eq event-window this-window)
                                      (> this-count 0))
				 (when *expose-debug*
				   (incf *expose-throw-aways*))
				 (return))
			     nil) ;; keep looping
		  (t () (return)))) ;; any other event, return
      #+cmu
      (loop
        (unless (xlib:event-case (display :discard-p nil :timeout 0)
                  (:EXPOSURE ((:event-window this-window)
                              (:x x1)
                              (:y y1)
                              (:width w)
                              (:height h))
                             (merge-bbox bbox
                               (make-bbox :x1 x1 :y1 y1 :x2 (+ x1 w)
                                 :y2 (+ y1 h) :valid-p t))
                             (when (eq this-window event-window)
			       (when *expose-debug*
				 (incf *expose-throw-aways*))
			       t))
		  (t () nil)) ;; any other event, return nil (causes
	  ;; event-case to terminate), which causes
	  ;; loop to terminate
	  (return)))
      
      ;; done throwing away interim exposure events
      (s-value a-window :exposed-bbox bbox)
      (kr-send a-window :update a-window t)
      (s-value a-window :exposed-bbox nil)))
  t)

;; 1st version of default-event-handler, commented out
;; 21-Jul-91 - FER
;(defun default-event-handler (display)
;  "Event handler for the interactor windows"
;  ;; yes indeed, every clause should return T, not NIL!
;  (xlib:event-case (display :discard-p t)
;    (:MAP-NOTIFY (event-window) (Map-notify *event-debug* event-window))
;    (:UNMAP-NOTIFY (event-window) (Unmap-notify *event-debug* event-window))
;    (:CIRCULATE-NOTIFY () (Circulate-notify *event-debug*))
;    (:REPARENT-NOTIFY (event-window x y)
;                         (Reparent-Notify *event-debug* event-window x y)) 
;    (:GRAVITY-NOTIFY () (Gravity-notify *event-debug*))
;    (:DESTROY-NOTIFY (event-window) (Destroy-notify *event-debug* event-window))
;    (:CONFIGURE-NOTIFY (x y width height event-window above-sibling)
;                       (Configure-Notify *event-debug* x y width height
;                                         event-window above-sibling))
;    (:EXPOSURE (event-window count x y width height)
;               (Exposure *event-debug* event-window count x y width height display))
;    (:NO-EXPOSURE () t)
;    (OTHERWISE () (format t "illegal event") t)))

(defun display-info-printer (s stream ignore)
  (declare (ignore ignore))
  (format stream "#<OPAL-DISPLAY-INFO ~A>" (display-info-display s)))

(defun initialize-display (display-name)
  (let ((display 
	 (cdr (assoc display-name *display-name-to-display-mapping*
		     :test '(lambda (s1 s2)
			      (let ((end (min (length s1)
					      (length s2))))
				(string-equal s1 s2
					      :end1 end)))))))
    (when (null display)
      (let* ((x-display (xlib:open-display display-name))
	     (x-screen (nth user::Garnet-Screen-Number
                            (xlib:display-roots x-display)))
	     (x-root (xlib:screen-root x-screen))
	     (x-line-style-gc
	      (xlib:create-gcontext :drawable x-root
				    :function 2
				    :foreground opal::*black*
				    :background opal::*white*
				    :line-width 0
				    :line-style :solid
				    :cap-style :butt
				    :join-style :miter
				    :fill-style :solid
				    :fill-rule :even-odd))
	     (x-filling-style-gc
	      (xlib:create-gcontext :drawable x-root
				    :function 2
				    :foreground opal::*black*
				    :background opal::*white*
				    :line-width 0
				    :line-style :solid
				    :cap-style :butt
				    :join-style :miter
				    :fill-style :solid
				    :fill-rule :even-odd))
	     (opal-line-style-gc
		(make-opal-gc	:gcontext x-line-style-gc
				:opal-style NIL
				:function 2
				:line-width 0
				:line-style :solid
				:cap-style  :butt
				:join-style :miter
				:dashes NIL
				:font   NIL
				:fill-style :solid
				:fill-rule  :even-odd
				:stipple   NIL
				:clip-mask :none))
	     (opal-filling-style-gc
		(make-opal-gc	:gcontext x-filling-style-gc
				:opal-style NIL
				:function 2
				:line-width 0
				:line-style :solid
				:cap-style  :butt
				:join-style :miter
				:dashes NIL
				:font   NIL
				:fill-style :solid
				:fill-rule  :even-odd
				:stipple   NIL
				:clip-mask :none)))
	(setf display
	      (make-display-info :display x-display
				 :screen x-screen
				 :root-window x-root
				 :line-style-gc opal-line-style-gc
				 :filling-style-gc opal-filling-style-gc))
	#+cmu (ext:enable-clx-event-handling x-display
				       'default-event-handler))
      (push (cons display-name display) *display-name-to-display-mapping*))
    display))


(defun set-window-cursor (display-info a-window  cursor-slot)

    (let* ((root-window (display-info-root-window display-info))
	   (gc nil)
	   (screen (display-info-screen display-info))
	   (cursor-bm (g-value (car cursor-slot) :image))
	   (cursor-width (xlib:image-width cursor-bm))
	   (cursor-height (xlib:image-height cursor-bm))
	   (cursor-pm (xlib:create-pixmap :width cursor-width
					  :height cursor-height
					  :depth 1
					  :drawable root-window))
	   (mask-bm (g-value (cdr cursor-slot) :image))
	   (mask-pm nil) (mask-width nil) (mask-height nil))

      (when mask-bm
	(setf mask-pm (xlib:create-pixmap
		       :width (setf mask-width
				    (xlib:image-width mask-bm))
		       :height (setf mask-height
				     (xlib:image-height mask-bm))
		       :depth 1
		       :drawable root-window))
	(setf gc (xlib:create-gcontext
		  :drawable mask-pm :function boole-1
		  :foreground (xlib:screen-white-pixel screen)
		  :background (xlib:screen-black-pixel screen)))
	(xlib:put-image mask-pm gc mask-bm :x 0 :y 0
		   :width mask-width :height mask-height)
	(xlib:free-gcontext gc))
	
      (when cursor-bm
	(setf gc (xlib:create-gcontext
		  :drawable cursor-pm :function boole-1
		  :foreground (xlib:screen-white-pixel screen)
		  :background (xlib:screen-black-pixel screen)))
	(xlib:put-image cursor-pm gc cursor-bm :x 0 :y 0
		   :width cursor-width :height cursor-height)
	(xlib:free-gcontext gc)
	(setf (xlib:window-cursor a-window)
	      (xlib:create-cursor :source cursor-pm
				  :mask (when mask-bm mask-pm)
				  :x (or (xlib:image-x-hot cursor-bm) 0)
				  :y (or (xlib:image-y-hot cursor-bm) 0)
				  :foreground (g-value opal:black :xcolor)
				  :background (g-value opal:white :xcolor)))))
  t)

;;; Set the :window slot of the window to be the window itself!
(define-method :initialize opal:window (a-window)
  (let ((win-info (make-win-update-info)))
    (call-prototype-method a-window)
    (unless (get-local-value a-window :title)
      (s-value a-window :title (new-garnet-window-name)))
    (unless (get-local-value a-window :icon-title)
      (s-value a-window :icon-title (g-value a-window :title)))
    (s-value a-window :win-update-info win-info)
    (s-value a-window :window
	(setf (update-info-window (get-local-value a-window :update-info))
		a-window))
    (push a-window (cdr *windows-that-have-never-been-updated*))
    (let ((parent (g-value a-window :parent)))
      (when parent
	(kr:append-value parent :child a-window)))
    (setf (win-update-info-new-bbox win-info) (make-bbox))
    (setf (win-update-info-clip-mask-1 win-info) (make-list 4))
    (setf (win-update-info-clip-mask-2 win-info) (make-list 4))))

;;;; This now returns the drawable it creates.
(defun create-x-drawable (a-window)
  (let* ((display-info (initialize-display (g-value a-window :display)))
	 (title-name (g-value a-window :title))
	 (left (g-value a-window :left))
	 (top  (g-value a-window :top))
	 (border-width (g-value a-window :border-width))
	 (width  (g-value a-window :width))
	 (height (g-value a-window :height))
	 (parent (get-parent-win a-window display-info))
	 (screen (display-info-screen display-info))
	 (white-pixel (xlib:screen-white-pixel screen))
	 (black-pixel (xlib:screen-black-pixel screen))
	 (drawable (xlib:create-window
		    :parent parent
		    :x left
		    :y top
		    :width width
		    :height height
		    :background white-pixel
		    :border-width border-width
		    :border black-pixel
	       	    :override-redirect :off
		    :event-mask *exposure-event-mask*
		    :class :input-output)))
    (if (g-value a-window :position-by-hand)
	(xlib:set-standard-properties drawable
				   :name title-name
				   :icon-name (or (g-value a-window :icon-title)
						  title-name)
				   :resource-name "Garnet"
				   :width width
				   :height height
				   :user-specified-position-p nil)
	(xlib:set-standard-properties drawable
				   :name title-name
				   :icon-name (or (g-value a-window :icon-title)
						  title-name)
				   :resource-name "Garnet"
				   :width width
				   :height height
				   :x left :y top
				   :user-specified-position-p t))
       
    (setf (g-value a-window :drawable) drawable)
    (setf (g-value a-window :display-info) display-info)
    (setf (gethash drawable *drawable-to-window-mapping*) a-window)
    (when (g-value a-window :double-buffered-p)
      (let* ((buffer (create-x-buffer a-window))
	     (buffer-gc (xlib:create-gcontext :drawable buffer
				:foreground black-pixel
				:background white-pixel)))
        (s-value a-window :buffer buffer)
        (s-value a-window :buffer-gcontext buffer-gc)
	(clear-buffer buffer buffer-gc)))
	
    (s-value a-window :top-border-width border-width)
    (s-value a-window :left-border-width border-width)
    (s-value a-window :bottom-border-width border-width)
    (s-value a-window :right-border-width border-width)

    (setf *windows-that-have-never-been-updated*
      (delete a-window *windows-that-have-never-been-updated*))

    ;; set the cursor to hemlock's cursor or specified cursor/mask combo
    ;; (cursor-file . mask-file)
    (set-window-cursor display-info
		       drawable
		       (g-value a-window :cursor))

;;;  WE NO LONGER PROPAGATE DOWN INTO OBJECTS!!!
    ;; if an aggregate is specified, propagate the drawable, and
    ;; display-info structures down through it
    ;;;(let ((a-aggregate (g-value a-window :aggregate)))
      ;;;(when a-aggregate
	;;;(propagate-down a-aggregate drawable display-info)))

    ;; bring up the window, and display it
    (when (g-value a-window :visible)
      (xlib:map-window drawable)
      (xlib:display-force-output (display-info-display display-info))

      ;; Wait until map-notify actually takes place.
      ;; Otherwise, objects won't appear first time in Lucid, Allegro.
#-cmu
      (xlib:event-case ((display-info-display display-info) :discard-p nil
                        :peek-p t :timeout 15)
        (:map-notify (event-window) (eq event-window drawable))))

    drawable))



(define-method :fix-properties opal:window (a-window changed-slots)
  (let ((drawable (g-value a-window :drawable))
	(make-new-buffer nil)
	(map-window-at-end-of-fix-properties nil))
    (xlib:with-state (drawable)
      (dolist (slot changed-slots)	 
	(case slot
	  ((:aggregate :drawable)
	   (let* ((display-info (g-value a-window :display-info))
		  (win-info (g-value a-window :win-update-info))
		  (old-agg  (win-update-info-old-aggregate win-info))
		  (agg      (g-value a-window :aggregate)))
	     (set-window-cursor display-info
				drawable
				(g-value a-window :cursor))
	     (unless (eq old-agg agg)
	       (if (and old-agg (eq (g-value old-agg :window)
				    a-window))
		   (set-display-slots old-agg NIL NIL))
	       (if agg
		   (set-display-slots agg a-window T))
	       (setf (win-update-info-old-aggregate win-info) agg)
	       (if (and old-agg (null agg))
		   (xlib:clear-area drawable)))))
	  (:parent
	   (let ((display-info (g-value a-window :display-info))
		 (parent (g-value (g-value a-window :parent) :drawable))
		 (left (g-value a-window :left))
		 (top (g-value a-window :top)))
	     (s-value a-window :lineage nil)
	     (if parent
		 (if (is-a-p (g-value a-window :parent) opal:window)
		     (xlib:reparent-window drawable parent left top)
		     (format t "Parent must be of type window~%"))
		 (xlib:reparent-window drawable (display-info-root-window display-info)
				       left top))))
	  (:cursor
	   (let ((display-info (g-value a-window :display-info)))
	     (set-window-cursor display-info
				drawable
				(g-value a-window :cursor))))
	  (:title
	   (setf (xlib:wm-name drawable)
		 (g-value a-window :title))
	   (xlib:set-standard-properties drawable
				   :name (g-value a-window :title)))
	  (:icon-title
	   (xlib:set-standard-properties drawable
				   :icon-name (g-value a-window :icon-title)))
	  (:top
	   (let ((hints (xlib:wm-normal-hints drawable))
		 (new-y (g-value a-window :top)))
	     (setf (xlib:drawable-y drawable) new-y
		   (xlib:wm-size-hints-y hints) new-y
		   (xlib:wm-normal-hints drawable) hints)))
	  (:left
	   (let ((hints (xlib:wm-normal-hints drawable))
		 (new-x (g-value a-window :left)))
	     (setf (xlib:drawable-x drawable) new-x
		   (xlib:wm-size-hints-x hints) new-x
		   (xlib:wm-normal-hints drawable) hints)))
	  (:width
	   (setf (xlib:drawable-width drawable)
		 (max 0 (g-value a-window :width)))
	   (let ((old-buffer (g-value a-window :buffer)))
	     (when (and old-buffer
			(> (g-value a-window :width)
			   (xlib:drawable-width old-buffer)))
	       (setq make-new-buffer t))))
	  (:height
	   (setf (xlib:drawable-height drawable)
		 (max 0 (g-value a-window :height)))
	   (let ((old-buffer (g-value a-window :buffer)))
	     (when (and old-buffer
			(> (g-value a-window :height)
			   (xlib:drawable-height old-buffer)))
                 (setq make-new-buffer t))))
	  (:visible
	   (if (g-value a-window :visible)
	       (setq map-window-at-end-of-fix-properties t)
	       (xlib:unmap-window drawable)))
;	  (:display
;	   (s-value a-window :lineage nil)
;	   (xlib:destroy-window drawable)
;	   (xlib:display-finish-output
;	    (display-info-display (g-value a-window :display-info)))
;	   (remhash drawable *drawable-to-window-mapping*)
;	   (create-x-drawable a-window))
          )))
    ; Do this last so that window does not momentarily flicker
    ; in its old position
    (when map-window-at-end-of-fix-properties
      (xlib:map-window drawable))
    ; Expand buffer after the with-state, but within let.
    (when make-new-buffer
      (expand-buffer a-window)))
)

(define-method :destroy-me opal:window (a-window)
  ;; first recursively destroy all subwindows
  (dolist (child (get-values a-window :child))
    (when (eq a-window (g-value child :parent))
      (destroy child)))
  ;; then destroy main window
  (let ((drawable (g-value a-window :drawable)))
    (when drawable
      (xlib:destroy-window drawable)
      (remhash drawable *drawable-to-window-mapping*)
      (xlib:display-force-output
       (display-info-display (g-value a-window :display-info)))))
  (setf *windows-that-have-never-been-updated*
    (delete a-window *windows-that-have-never-been-updated*))
  (let ((agg (g-value a-window :aggregate)))
    (when agg (destroy agg nil)))
  (s-value a-window :window nil)
  (when (g-value a-window :buffer)
    (xlib:free-pixmap (g-value a-window :buffer))
    (xlib:free-gcontext (g-value a-window :buffer-gcontext)))
  (call-prototype-method a-window))

(define-method :destroy opal:window (a-window)
  (dolist (instance (copy-list (get-local-values a-window :is-a-inv)))
    (destroy instance))
  (destroy-me a-window))

(define-method :flush opal:window (a-window)
  (xlib:display-force-output
   (display-info-display (g-value a-window :display-info))))

;;; The following two functions have been added to be used by interactors.
;;; They are exported from Opal.
(defun Get-X-Cut-Buffer (window)
    (if window
      (xlib:cut-buffer
       (opal::display-info-display (g-value window :display-info)))
      ; else return the empty string
      ""))

(defun Set-X-Cut-Buffer (window newstring)
    (when window
      (setf (xlib:cut-buffer
             (opal::display-info-display (g-value window :display-info)))
            newstring)))


;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/update.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Changes:
;;; 3/25/91 ECP In update method for aggregates, in the dovalues loop,
;;;		added :local t so that we just draw local components.
;;; 6/12/90 BVZ Added call to clear-dirty-bits in :update method of aggregate
;;; 5/31/90 ECP Removed type-checking for :justification slot
;;; 4/12/90 ECP When updating an element of :update-slots-values, if the
;;;		new value is a list, we want to put in a copy-list of
;;;		the value.  Otherwise they'll be pointing to the same
;;;		thing, and we won't be able to tell if the value changes.
;;; 1/25/90 ECP Removed references to xlib:image-p, which is not in
;;;             the R4 release of CLX.
;;; 2/1/90  ECP Changed eq to equal.
(in-package "OPAL" :use '("LISP" "KR"))
(defvar *opal-type-check* T)

;;; This macros demands that there be at least ONE invalid object in the
;;; window, lest it do strange things...

(defmacro free-invalid-objects(win-info invalid-objs last-invalid-obj)
  `(progn
	(setf (cdr ,last-invalid-obj) *free-cons*)
	(setf *free-cons* ,invalid-objs)
	(setf (win-update-info-invalid-objects ,win-info)
	  (setf (win-update-info-last-invalid-obj ,win-info)
		NIL))))

;;; This is a type-checking facility, called any time an object's slot has
;;; changed its value.  It's only invoked if *opal-type-check* is non-NIL.
;;; All boolean slots (:visible :fast-redraw-p :open-p :actual-heightp)
;;; cannot be type-checked, since any non-NIL value is True.
(defun legal-type-p (object slot value)
  (let ((expected-string
   (case slot
    ((:top :left :x1 :x2 :y1 :y2 :head-x :head-y :from-x :from-y)
	(unless (typep value 'integer)
	  "integer"))
    ((:width :height :draw-radius :length :diameter)
	(unless (and (typep value 'integer) (>= value 0))
	  "non-negative integer"))
    (:line-style
	(unless (or (null value)
		    (and (schema-p value)
			 (is-a-p value opal:line-style)))
	  "NIL or opal:line-style"))
    (:filling-style
	(unless (or (null value)
		    (and (schema-p value)
			 (is-a-p value opal:filling-style)))
	  "NIL or opal:filling-style"))
    (:draw-function
	(unless (assoc value *function-alist*)
	  "car-member of opal::*function-alist*"))
    (:radius
	(unless (or (and (typep value 'integer) (>= value 0))
		    (member value '(:small :medium :large)))
		"non-negative integer, or one of (:small :medium :large)"))
    ((:angle1 :angle2)
	(unless (numberp value)
	  "number"))
    (:point-list
      (unless
	(and (listp value)
	     (zerop (mod (length value) 2))		;; of even length?
	     (not (dolist (coord value)
		    (unless (typep coord 'integer) (return T)))))
	"Even-length list of integers"))
    ((:string :title :icon-title)
	(unless (or (null value) (stringp value))
	  "NIL or string"))
    (:x-substr
	(unless (stringp value)
	  "string"))
    (:font
       (unless
	(and (schema-p value)
	     (or (is-a-p value opal:font)
		 (is-a-p value opal:font-from-file)))
	"opal:font or opal:font-from-file"))
    (:xfont
	(unless (xlib:font-p value)
	  "anything s.t. xlib:font-p returns T"))
    (:text-extents
	(unless (listp value)
	  "list"))
    (:cursor-index
      (unless
	(or (null value)
	    (and (typep value 'integer) (>= value 0)))
	"NIL or non-negative integer"))
    (:cut-strings
      (unless
	(and (listp value)
	     (not (dolist (cut-string-member value)
		    (unless (cut-string-p cut-string-member) (return T)))))
	"possibly empty list of opal:cut-string"))
    (:image			;; bitmap
	(unless (typep value 'xlib::image)
	  "anything of type xlib::image"))
    (:aggregate
      (unless
	(or (null value)
	    (is-a-p value opal:aggregate))
	"NIL or opal:aggregate"))
    (:parent			;; window's can only have window's!
      (unless
	(or (null value)
	    (and (schema-p value)
		 (if (is-a-p object opal:window)
		     (is-a-p value opal:window)
		     T)))
	(if (is-a-p object opal:window)
		"NIL or opal:window"
		"NIL or any opal schema")))
    (:cursor
      (unless
	(and (listp value)
	     (is-a-p (car value) opal:bitmap)
	     (is-a-p (cdr value) opal:bitmap))
	"(opal:bitmap  .  opal:bitmap)"))
    (:display
	(unless (stringp value)
	  "string"))
    (otherwise
	NIL)
   )))
   (if expected-string
    (progn
     (format t "~%*** Warning, Illegal value! --  Object  ~A~%" object)
     (format t   "                                Slot    :~A~%" slot)
     (format t   "                                Value   ")
     (if (keywordp value) (format t ":"))
     (format t "~A~%" value)
     (if (and value (atom value))
      (format t
	 "*** This is an atom, perhaps it is quoted where it shouldn't be?~%"))
     (format t "*** Expected type -- ~A~%~%" expected-string)
     NIL
    )
    T)
  )
)


;; This is the EXPORTED function which turns on and off the type-checking.
;; If you call it with no arguments, then it tells the status of type-checking.
(defun type-check (&rest t-or-nil)
  (cond	((null t-or-nil)
		(format t "Opal's Type-Checking is ~A~%"
			(if *opal-type-check* "ON" "OFF"))
		*opal-type-check*)
	((cdr t-or-nil)
		(format t "*** opal:type-check takes no more than 1 arg!~%"))
	(t
		(setq *opal-type-check* (car t-or-nil)))))

;;; This updates the :update-slots-values slot, which should hold a list
;;; containing the values of the update-slots at the last update.  It also
;;; returns T iff one of them has changed (ie, we need to be updated).
;;; This also sets update-info-force-computation-p to NIL, since we definitely
;;; don't need to do this after running this macro.
(defun update-slots-values-changed (object first-changed obj-update-info)
 (let* ((update-slots-values (get-local-value object :update-slots-values))
	 (start-slot-list (get-local-value object :update-slots))
	 (first-p (null update-slots-values))
	  changed-p new-value)
   (if first-p
	(setq update-slots-values
	  (s-value object :update-slots-values
	    (make-array (length start-slot-list)))))
   (setf (update-info-force-computation-p obj-update-info) NIL)
   (dotimes (x first-changed)
	(setq start-slot-list (cdr start-slot-list)))
   (do  ((slot-list start-slot-list (cdr slot-list))
	 (vals-indx first-changed (1+ vals-indx)))
	((null slot-list) changed-p)
	(if (equal (aref update-slots-values vals-indx)
		   (setq new-value (g-value object (car slot-list))))
            #-release-garnet
	  (and *opal-type-check*
	       first-p
	       (legal-type-p object (car slot-list) new-value))
            #+release-garnet nil
	  (progn
            #-release-garnet
	    (if *opal-type-check*
                (legal-type-p object (car slot-list) new-value))
	    (setf (aref update-slots-values vals-indx)
		(if (listp new-value) (copy-list new-value) new-value))
	    (setq changed-p T))))))

;;; This is the same as the previous call, but it only checks if a value has
;;; changed.  If so, it returns the index into update-slots-values of the first
;;; changed entry.  Elsewise, it returns NIL.  This does not alter anything!
;;; It is used in only one place, to check if a fastdraw object has really
;;; changed when it is invalidated.
;;; If there is no update-slots-values entry, it just returns 0.
(defun simple-update-slots-values-changed (object)
 (let ((update-slots-values (get-local-value object :update-slots-values)))
  (if update-slots-values
   (do  ((slot-list (get-local-value object :update-slots) (cdr slot-list))
	 (vals-indx 0 (1+ vals-indx)))
	((null slot-list) NIL)
	(unless (equal (aref update-slots-values vals-indx)
		       (g-value object (car slot-list)))
	  (return vals-indx)))
   0)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Now makes the aggregate's :old-bbox valid at all times!!!
;;; DO NOT CALL THIS UNLESS THE AGGREGATE IS DEFINITELY VISIBLE!!!
(define-method :update opal:aggregate (agg update-info
				       line-style-gc filling-style-gc
				       drawable root-window
				       clip-mask-1 bbox-1 clip-mask-2 bbox-2
				       &optional (total-p NIL))
  #+comment
  (debug 1
    (format t "Updating Aggregate ~A, total-p is ~A~%" agg total-p))
  (let ((dirty-p (update-info-dirty-p update-info))
	(agg-bbox (update-info-old-bbox update-info)))
      (when
	(or  dirty-p
	     total-p
	     (and (bbox-valid-p agg-bbox)
	          (bbox-intersects-either-p agg-bbox bbox-1 bbox-2)))
	(let (child-update-info child-bbox)
	  (setf (bbox-valid-p agg-bbox) NIL)		;; clear the old one!
	  (dovalues (child agg :components :local t)
	    (if (g-value child :visible)
		(progn
		  (setq child-bbox
			(update-info-old-bbox
			 (setq child-update-info
			       (get-local-value child :update-info))))
		  (if (update-info-aggregate-p child-update-info)
		      (update-method-aggregate child child-update-info
					  line-style-gc filling-style-gc
					  drawable root-window
					  clip-mask-1 bbox-1 clip-mask-2 bbox-2
					  total-p)
		      (update-method-graphical-object child child-update-info
					  line-style-gc filling-style-gc
					  drawable root-window
					  clip-mask-1 bbox-1 clip-mask-2 bbox-2
					  total-p))
		  (merge-bbox agg-bbox child-bbox))	;; and set the new one!
		; else
		;; if the child's dirty bit is set, recursively visit the child
		;; and all its children and turn off their dirty bits
		(let ((child-update-info (get-local-value child :update-info)))
		  (when (update-info-dirty-p child-update-info)
		     (clear-dirty-bits child child-update-info)))))
	  (if dirty-p (setf (update-info-dirty-p update-info) NIL))
	))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This will not be called unless the gob is already visible!!!
(define-method :update opal:graphical-object (gob update-info
				       line-style-gc filling-style-gc
				       drawable root-window
				       clip-mask-1 bbox-1 clip-mask-2 bbox-2
				       &optional (total-p NIL))
 #+comment
 (debug 1
  (format t "Updating Graphical-Object ~A, total-p is ~A~%" gob total-p))
  (let ((old-bbox (update-info-old-bbox update-info)))
    (unless (update-info-on-fastdraw-list-p update-info)
      (cond (total-p
		(update-slots-values-changed gob 0 update-info)
		(update-bbox gob old-bbox)
		(draw gob line-style-gc filling-style-gc drawable
			root-window :none) ;draw w/o mask
		(setf (update-info-dirty-p update-info) NIL))

	    ((update-info-dirty-p update-info)
		(when (update-info-force-computation-p update-info)
		   (update-slots-values-changed gob 0 update-info)
		   (update-bbox gob old-bbox))
		(if clip-mask-2		 	; are there 2 valid clip masks?
		  (progn
		     (if (and (bbox-valid-p old-bbox)
			      (bbox-intersect-p old-bbox bbox-1))
		        (draw gob line-style-gc filling-style-gc drawable
				root-window clip-mask-1))
		     (draw gob line-style-gc filling-style-gc drawable
				root-window clip-mask-2))
		  (draw gob line-style-gc filling-style-gc drawable
				root-window clip-mask-1))
		(setf (update-info-dirty-p update-info) NIL))

	    (clip-mask-2			; 2 valid clip-masks?
		(if (bbox-intersect-p old-bbox bbox-1)
		     (draw gob line-style-gc filling-style-gc drawable
				root-window clip-mask-1))
		(if (bbox-intersect-p old-bbox bbox-2)
		     (draw gob line-style-gc filling-style-gc drawable
				root-window clip-mask-2)))
	    ((bbox-intersect-p old-bbox bbox-1)
		(draw gob line-style-gc filling-style-gc drawable
				root-window clip-mask-1))))))
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/update-window.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Changes:
;;;  5-Feb-91 Dave Kosbie & Andrew Mickish
;;;		  Changed first UNLESS clause in :update method to fix bug
;;;               in placement of subwindows.
;;; 28-Sep-90 ECP After drawing a fastdraw object, update the bboxes of
;;;               its ancestors
;;; 23-Aug-90 ECP Added two lines to :update to activate invalidate-demons
;;;		  associated with :width and :height
;;; 13-Aug-90 ECP Changed g-value to get-local-value in test to see
;;;		  if window already has a :drawable.
;;; 18-Jul-90 ECP Fixed bug with resizing double-buffered window.
;;;  9-Jul-90 ECP Added test for kr::a-schema-name of invalid objects.
;;;  2-Jul-90 ECP If an expose event occurs, just refresh the parts
;;;		  of the window that were exposed.
;;; 20-Jun-90 ECP Lots of debugging of double-buffering.  If you
;;;		  de-iconify such a window and no other changes
;;;		  have taken place, just do a copy-area.
;;;  6-Jun-90 ECP Implemented double-buffering.
(in-package "OPAL" :use '("LISP" "KR"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Notes on the current implementation:
;;;	This always does a display-force-output at the end of the call!

;; comment ** (this refers to where '**' appears in the code below):  this line
;; is necessary because: if object A's visibility depends on its parent P,
;; which is in window W, and we set P's visibility from
;; T to NIL, and then we do a total update on W, so it traverses P,
;; sees that it's not visible, and stops there.  This will put up the correct
;; picture, but...  The visibility of P is *valid* and NIL, and the visibility
;; of A is *invalid*.  Then, we set P's visibility to T.  This does not put
;; P on W's invalid-objects list because aggregates have no 'interesting'
;; slots; nor does it put A there, since its visibility slot was already
;; invalid!!!  Thus, there is no record that A is now visible (though invalid),
;; and nothing happens on subsequent updates.
;; The fix:  in a total update, get the visibility slot of all invalid objects
;; (via g-value).  Why does this work?  Because, in the previous example, A's
;; visible slot would NOT be invalid when we set P to visible, thus resulting
;; in A's visible slot being invalidated, so A would wind up on the
;; invalid-objects list.
;; Note that there's a little more to it, since you have to also *record* that
;; A was invalid in the :update-slots-values array (aref ... 0), and in the
;; valid-p entry of the old-bbox in the :update-info of A.  Ack!

(define-method :update opal:window (a-window &optional (total-p NIL))
 #+comment
 (debug 0
	(format t "Updating Window ~A, total-p is ~A~%" a-window total-p))
 (let* ((window-agg      (g-value a-window :aggregate))
	(visible         (g-value a-window :visible))
        (win-info        (get-local-value a-window :win-update-info))
	(invalid-objects (win-update-info-invalid-objects win-info))
	(last-inv-obj    (win-update-info-last-invalid-obj win-info))
	(win-new-bbox	 (win-update-info-new-bbox win-info))
	win-old-bbox line-style-gc filling-style-gc
	drawable display-info root-window
	only-changed-visible
	fastdraw-objects
	buffer buffer-gc
	exposed-bbox
	exposed-clip-mask
      )
  (unless (setq drawable (get-local-value a-window :drawable))
        (when window-agg
          (set-display-slots window-agg a-window T)
          (setf (win-update-info-old-aggregate win-info) window-agg))
        (setq drawable (create-x-drawable a-window)))
  (when (g-value a-window :buffer)
    (setq only-changed-visible	;; Nothing changed but :visible slot.
      (and (null invalid-objects)
	   (null (remove :visible (win-update-info-invalid-slots win-info))))))
  (setq total-p (or (fix-properties-and-validate a-window) total-p))
  ;; These next two lines are being added to fix a bug Bryan Loyall found.
  ;; If you had a subwindow whose width and height are dependent on its parents,
  ;; which were in turn dependent on a formula, the size of the inner window
  ;; was not being marked as invalid. -- Pervin 8/23/90
  (g-value a-window :width)
  (g-value a-window :height)
  (setq buffer (g-value a-window :buffer))
  (setq buffer-gc (g-value a-window :buffer-gcontext))
  (setq line-style-gc (display-info-line-style-gc
			(setq display-info (g-value a-window :display-info))))
  (setq filling-style-gc (display-info-filling-style-gc display-info))
  (setq root-window (display-info-root-window display-info))
  (when (and window-agg
	     (if buffer
		 (and visible (not only-changed-visible))
		 visible))
    (if invalid-objects
  	 (setf (cdr last-inv-obj) NIL))		;; it was an ill-formed list!
     #+comment
    (debug 1
      (format t "~%   Window agg:      ~A~%" window-agg)
      (format t "   Invalid-Objects: ~A~%" invalid-objects)
      (format t "   Drawable:        ~A~%" drawable)
      (format t "   Display:         ~A~%" (display-info-display display-info))
      (format t "   Win's old-bbox:  ~A~%"
	(update-info-old-bbox (get-local-value a-window :update-info))))
    (if total-p
      (progn
	#+comment
	(debug 1 (format t "Performing a total-update...~%"))

	;; Exposed-bbox tell whether the window was just exposed,
	;; and nothing else happened to it.
	(setq exposed-bbox (and (null invalid-objects)
			        (g-value a-window :exposed-bbox)))
	(if exposed-bbox 
	  (progn
	    (setq exposed-clip-mask (make-list 4))
	    (bbox-to-clip-mask exposed-bbox exposed-clip-mask)
	    (erase-bbox exposed-bbox drawable nil nil))
	  (if buffer
	    (clear-buffer buffer buffer-gc)
	    (xlib:clear-area drawable)))

	(dolist (object invalid-objects)
                                        ;; See comment '**' above...
         (let ((obj-us-values (get-local-value object :update-slots-values))
               (obj-update-info (get-local-value object :update-info)))
            (g-value object :visible)
            (and obj-us-values
                (not (update-info-aggregate-p obj-update-info))
                (setf (aref obj-us-values 0) NIL))
            (setf (bbox-valid-p
                     (update-info-old-bbox obj-update-info))
                  NIL))
	 (let ((info (get-local-value object :update-info)))
	   (if info
	     (setf (update-info-invalid-p info) NIL))))
	(when (g-value window-agg :visible)
	  (update-method-aggregate window-agg
		   (get-local-value window-agg :update-info)
		   line-style-gc filling-style-gc (or buffer drawable) root-window
		   exposed-clip-mask exposed-bbox NIL NIL
		   (not exposed-bbox)))
	(if invalid-objects (free-invalid-objects win-info invalid-objects
						  last-inv-obj)))

   ;else
     (when (and (g-value window-agg :visible)
	        (or (bbox-valid-p (setq win-old-bbox
				(update-info-old-bbox
				  (get-local-value a-window :update-info))))
	       	    invalid-objects))
      (let (obj-update-info obj-old-bbox temp-bbox obj-update-slots-values
	    first-changed this-inv-obj prev-inv-obj temp non-fastdraw-p object)
	(setf (bbox-valid-p win-new-bbox) NIL)
	(when invalid-objects
	 #+comment
	 (debug 1 (format t "Checking Invalid Objects for FastRedraws~%"))
						;;; First Deal with FASTDRAWs
	 (setq prev-inv-obj NIL)
	 (loop
	  (if (null (setq this-inv-obj (if prev-inv-obj (cdr prev-inv-obj)
							invalid-objects)))
	      (return))
	  #+comment
	  (debug 2 (format t "Checking ~A~%" (car this-inv-obj)))
	  (setq non-fastdraw-p T)
		; Check if it *is* a FASTDRAW OBJECT and
		; either *was* a FASTDRAW OBJECT  or  *was* invisible (or
		; wasn't even an object last time!)
	  (when (and (g-value (setq object (car this-inv-obj)) :fast-redraw-p)
		     (or (not (setq obj-update-slots-values
				(get-local-value object :update-slots-values)))
			 (aref obj-update-slots-values 1)
			 (not (aref obj-update-slots-values 0))))
		#+comment
		(debug 2 (format t "~A *is* and *was* a fast-redraw object~%"
			(car this-inv-obj)))
	  	(setf (update-info-invalid-p 
		    	    (setq obj-update-info
				(get-local-value object :update-info)))
			    NIL)
					;; Check if it really has changed!
	        (when (setq first-changed
			(simple-update-slots-values-changed object))
					;; if it was visible, erase it...
		  #+comment
		  (debug 2 (format t "~A has slots that have changed~%"
					(car this-inv-obj)))
		  (when (and obj-update-slots-values
			     (aref obj-update-slots-values 0))
		     #+comment
		     (debug 2 (format t "~A was visible, so erase it!~%"
					(car this-inv-obj)))
		     (draw object line-style-gc filling-style-gc drawable
			   root-window :none)
		     (when buffer
			(draw object line-style-gc filling-style-gc buffer
			    root-window :none)))
					;; if it is visible, set its visible
		  (if (g-value object :visible)
		   (progn
		     #+comment
		     (debug 2
			(format t "~A is visible, adding to fastdraw-objects~%"
				   (car this-inv-obj)))
					;; The following code was here, I'm not
					;; sure why, so I'm excluding it...

;;		    (if (zerop first-changed)
;;			(setf (aref obj-update-slots-values 0) T))

					;; Add object's "first-changed" to
					;; the fastdraw list!
		   (if *free-cons*
		    (progn
			(setq temp (cdr *free-cons*))
			(setf (cdr *free-cons*) fastdraw-objects)
			(setf (car (setq fastdraw-objects *free-cons*))
			      first-changed)
			(setq *free-cons* temp))
		    (setq fastdraw-objects (cons first-changed
						 fastdraw-objects)))
					;; Now add it to the fastdraw list so
					;; it will be drawn later...  Also
					;; remove it from the invalid-objects
		    (if prev-inv-obj
			(setf (cdr prev-inv-obj) (cdr this-inv-obj))
			(setq invalid-objects (cdr this-inv-obj)))
		    (setq temp fastdraw-objects)
		    (setf (cdr (setq fastdraw-objects this-inv-obj)) temp)
		    (setf (update-info-on-fastdraw-list-p obj-update-info) T)
		    (setq non-fastdraw-p NIL))
					;;; ELSE it's NOT VISIBLE....
		   (progn
			(if obj-update-slots-values
			  (setf (aref obj-update-slots-values 0) NIL))
			(setf (bbox-valid-p
				(update-info-old-bbox obj-update-info))
			      NIL)
		   ))))
	  (if non-fastdraw-p (setq prev-inv-obj this-inv-obj)))

				;; Now process non-FASTDRAWs, first fixing the
				;; last-inv-obj pointer, if necessary!
	 (if fastdraw-objects (setq last-inv-obj (last invalid-objects)))
	 #+comment
	 (debug 1
		(format t "Midway thru update,~%")
		(format t "   Fastdraw-Objects = ~A~%" fastdraw-objects)
		(format t "   Invalid-Objects  = ~A~%" invalid-objects)
		(format t "   Now onto processing the Invalid-Objects...~%"))
	 (dolist (object invalid-objects)
	  #+comment
	  (debug 2 (format t "Processing ~A~%" object))
	   ;; The next line represents a temporary hack to deal with a
	   ;; problem discovered in demo-arith, in which occasionally
	   ;; objects marked as *DESTROYED* were still contained in
	   ;; the invalid objects list.
	  (when (kr::a-schema-name object)
	    (setq obj-old-bbox
		(update-info-old-bbox
		    (setq obj-update-info
			(get-local-value object :update-info))))
	    (setf (update-info-invalid-p obj-update-info) NIL)
	    (setq obj-update-slots-values
		(get-local-value object :update-slots-values))
	    (if (g-value object :visible)
					;; Object is a VISIBLE NORMAL OBJ
	      (if (bbox-valid-p obj-old-bbox)	
	             				;;object IS and WAS visible
	       (when (update-slots-values-changed object 0 obj-update-info)
		  (merge-bbox win-old-bbox obj-old-bbox)
		  (update-bbox object obj-old-bbox)
		  (merge-bbox win-new-bbox obj-old-bbox)
		  (propagate-dirty-bit object obj-update-info)
		  )
	       (progn				;;object IS and WAS NOT visible
		(update-bbox object obj-old-bbox)
		(update-slots-values-changed object 0 obj-update-info)
		(merge-bbox win-new-bbox obj-old-bbox)
		(propagate-dirty-bit object obj-update-info)
		))
	    (when (bbox-valid-p obj-old-bbox)	;;object IS NOT and WAS visible
		(merge-bbox win-old-bbox obj-old-bbox)
		(setf (bbox-valid-p obj-old-bbox)
		   (setf (aref obj-update-slots-values 0)
			NIL))
	    )
						;;if object IS NOT and WAS NOT
						;;visible, then do nothing!!
	  )))
	(if invalid-objects
		(free-invalid-objects win-info invalid-objects last-inv-obj)
		(setf (win-update-info-invalid-objects win-info)
		  (setf (win-update-info-last-invalid-obj win-info)
		    NIL))))

					;; Now only perform the update if one
					;; of the two window's bboxes is valid
	(let ((old-bbox-valid (bbox-valid-p win-old-bbox))
	      (new-bbox-valid (bbox-valid-p win-new-bbox))
	      (clip-mask-1 (win-update-info-clip-mask-1 win-info))
	      (clip-mask-2 (win-update-info-clip-mask-2 win-info))
	      two-bboxes-p)
	  (when (or new-bbox-valid old-bbox-valid)

;;;; TEMPORARY CODE DUE TO X-BUG...
;;;; After running this, either *two-bboxes-p* is True, and both *clip-mask-1*
;;;; and *clip-mask-2* are set, or it is NIL, and only *clip-mask-1* is set,
;;;; and *new-bbox* holds the valid one, whether or not it's the new one!
;;;; Also, if the old-bbox of the window was valid, it is herein set to NIL.
;;;; [NB:  The X-Bug is that if you have a tiled object and you have a clip
;;;; mask with more than one rectangle in it, X will only clip to the first
;;;; rectangle!!!!  Thus, we need several distinct clip masks...]
	    (if (setq two-bboxes-p (and new-bbox-valid old-bbox-valid))
               (if (bbox-intersect-p win-old-bbox win-new-bbox) ;they intrsect?
		   (progn
                        (merge-bbox win-new-bbox win-old-bbox)  ;merge into new
                        (setf (bbox-valid-p win-old-bbox)     ;; Clr win's old!
                           (setq two-bboxes-p NIL))         ;; really only 1!
                        (erase-bbox win-new-bbox drawable buffer buffer-gc)
                        (bbox-to-clip-mask win-new-bbox clip-mask-1))
                   (progn
			(setf (bbox-valid-p win-old-bbox) NIL) ;;Clr win's old!
			(erase-bbox win-old-bbox drawable buffer buffer-gc)
			(erase-bbox win-new-bbox drawable buffer buffer-gc)
			(bbox-to-clip-mask win-old-bbox clip-mask-1)
			(bbox-to-clip-mask win-new-bbox clip-mask-2)))

               (progn                           ;; Only one valid bbox
			(when old-bbox-valid
				(setf (bbox-valid-p win-old-bbox) NIL)
				(setq temp-bbox win-new-bbox)
				(setq win-new-bbox win-old-bbox)
				(setq win-old-bbox temp-bbox))
			(erase-bbox win-new-bbox drawable buffer buffer-gc)
			(bbox-to-clip-mask win-new-bbox clip-mask-1)))
;;;; END OF TEMPORARY CODE!!!

	    (if two-bboxes-p
	         (update-method-aggregate window-agg
		   (get-local-value window-agg :update-info)
		   line-style-gc filling-style-gc 
		   (or buffer drawable) root-window
		   clip-mask-1 win-old-bbox clip-mask-2 win-new-bbox
		   NIL)
		  (update-method-aggregate window-agg
		   (get-local-value window-agg :update-info)
		   line-style-gc filling-style-gc
		   (or buffer drawable) root-window
		   clip-mask-1 win-new-bbox NIL NIL
		   NIL)
	     )
	   )))
      (let (f-obj-update-info f-obj-old-bbox)
					;; If there are fastdraw objects, draw
					;; them, then clear the list....
	(when fastdraw-objects
	  #+comment
	  (debug 1 (format t "Postprocessing of fastdraw-objects...~%"))
	   (do* ((flist         fastdraw-objects (cddr flist))
	         (fastdraw-obj  (first flist) (first flist))
	         (first-changed (second flist) (second flist)))
	        ((null flist))
		#+comment
		(debug 2 (format t "Processing ~A~%" fastdraw-obj))
		(setq f-obj-old-bbox
		   (update-info-old-bbox
		      (setq f-obj-update-info (get-local-value fastdraw-obj
							       :update-info))))
                (update-slots-values-changed fastdraw-obj first-changed
					     f-obj-update-info)
		(update-bbox fastdraw-obj f-obj-old-bbox)
		(draw fastdraw-obj line-style-gc filling-style-gc
		      drawable root-window :none)
	        (do ((parent (get-local-value fastdraw-obj :parent)
			     (get-local-value parent :parent)))
		    ((null parent))
		  (update-bbox parent (update-info-old-bbox
				       (get-local-value parent :update-info))))
		(when buffer
		  (draw fastdraw-obj line-style-gc filling-style-gc
		      buffer root-window :none))
		(setf (update-info-on-fastdraw-list-p f-obj-update-info)
		      NIL))
	   (setf (cdr (last fastdraw-objects)) *free-cons*)
	   (setq *free-cons* fastdraw-objects)
	))
     )))
   ; When using double-buffering, copy buffer into window.
   (when (and visible buffer)
     (if total-p
	 (xlib:copy-area buffer buffer-gc 0 0
			 (g-value a-window :width)
			 (g-value a-window :height)
			 drawable 0 0)
	 (let ((bbox (copy-bbox win-new-bbox))
	       (bbox2 (when win-old-bbox (copy-bbox win-old-bbox))))
	   (when (and bbox2 (bbox-x1 bbox2))
	     ; Have to set valid-p = T, or merge-bbox won't work.
	     (setf (bbox-valid-p bbox2) t)
	     (when (bbox-x1 bbox)
	       (setf (bbox-valid-p bbox) t))
	     (merge-bbox bbox bbox2))
	   (let ((x1 (or (bbox-x1 bbox) 0))
		 (x2 (or (bbox-x2 bbox) (g-value a-window :width)))
		 (y1 (or (bbox-y1 bbox) 0))
		 (y2 (or (bbox-y2 bbox) (g-value a-window :height))))
	     (xlib:copy-area buffer buffer-gc x1 y1 (- x2 x1) (- y2 y1)
			     drawable x1 y1)))))
   (xlib:display-force-output (display-info-display display-info))
   ; Recursively update children
   (dolist (c (get-values a-window :child))
     (if (eq a-window (g-value c :parent))
       (update c)
       (kr:delete-value-n a-window :child
			  (position c (get-values a-window :child)))))))

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/cursor-text.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;;  3/04/91 D'Souza - Removed nickname "MO" of package Opal.
;;;  2/04/91 ecp -- Cursor of cursor-text now has draw function :xor.
;;;  2/28/90 ecp -- Cursor of cursor text now has same draw function
;;;		    as the text.
;;;  3/11/89 lkb -- bug fixes, cursor now shows wven when string is empty
;;;                 height of cursor reflects value of :actual-heightp slot
;;;                 calls to X are more limited than before (more speed!!!)

(in-package "OPAL" :use '("LISP" "KR"))

(define-method :initialize opal:cursor-text (gob)
  (call-prototype-method gob))
				     
(define-method :draw opal:cursor-text (gob line-style-gc filling-style-gc
				       drawable root-window clip-mask)
  (call-prototype-method gob line-style-gc filling-style-gc
			 drawable root-window clip-mask)
  (when (g-value gob :cursor-index)
    (let* ((update-vals (get-local-value gob :update-slots-values))
	   (xfont (aref update-vals *text-xfont*))
	   (xlib-gc-line (opal-gc-gcontext line-style-gc))
	   (left (aref update-vals *text-left*))
	   (top (aref update-vals *text-top*))
	   (height (aref update-vals *text-height*))
	   (width (aref update-vals *text-width*))
	   (substring (aref update-vals *cursor-text-x-substr*))
	   (text-extents (aref update-vals *text-text-extents*))
	   cursor-offset)
      (when xfont
	(setq cursor-offset (- (xlib:text-width xfont substring)
			       (the-left-bearing text-extents)
			       1))
	(setq cursor-offset (min cursor-offset
				 (- width (ceiling *cursor-width* 2))))
	(setq cursor-offset (max cursor-offset (floor *cursor-width* 2)))
	(xlib:with-gcontext (xlib-gc-line
			      :line-width *cursor-width*
			      :function (get :xor :x-draw-function)
			      :fill-style :solid
			      :clip-mask clip-mask)
	  (xlib:draw-line drawable xlib-gc-line
			      (+ left cursor-offset)
			      top
			      (+ left cursor-offset)
			      (+ top height)))))))

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/clean-up.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; CHANGE LOG:
;;; 15-Aug-90 ECP Total rewrite of change-garnet-display.
;;; 21-Aug-90 ECP In clean-up, make sure each window hasn't
;;;               already been destroyed.
;;;
;;;
(in-package "OPAL" :use '("LISP" "KR"))

(defun get-table-contents ()
  (let ((windows nil))
    (maphash #'(lambda (key val)
		 (push (cons key val) windows))
	     *drawable-to-window-mapping*)
    (values windows)))


(defmacro already-been-destroyed (a-window)
  `(and (kr:schema-p ,a-window)
	(not (kr::a-schema-name ,a-window))))

(defun clean-up (&optional (how-to :orphans-only))
  #-release-dsi
  "options are: 
  1) :opal => destroy all garnet windows by calling xlib:destroy-window on orphaned
  clx-windows and opal:destroy on non-orphaned windows
  2) :opal-set-agg-to-nil => same as above, but before calling opal:destroy,
  set the aggregate to nil so it won't get destroyed too
  3) :orphans-only => destroy all orphaned garnet windows
  4) :clx => destroy all garnet windows by calling xlib:destroy-window

  return value is how many windows were destroyed"

  (let ((windows (get-table-contents))
	(num-killed 0))
    (case how-to
      ;; destroy all garnet windows by calling xlib:destroy-window on orphaned
      ;; clx-windows and opal:destroy on non-orphaned windows
      (:opal
       (dolist (window-pair windows)
	 (let* ((opal-window (opal-window window-pair))
		(clx-window (clx-window window-pair))
		(display (xlib:window-display clx-window)))
	   (unless (already-been-destroyed opal-window)
	     (if (not (equal clx-window (g-value opal-window :drawable)))
		 (progn
		   (xlib:destroy-window clx-window)
		   (when display
		     (xlib:display-force-output display)))
		 (destroy opal-window))
	     (remhash clx-window *drawable-to-window-mapping*))
	   ))
       (dolist (w (cdr *windows-that-have-never-been-updated*))
	 (destroy w)))
      (:opal-set-agg-to-nil
       ;; same as above, but before calling opal:destroy,
       ;; set the aggregate to nil so it won't get destroyed too
       (dolist (window-pair windows)
	 (let* ((opal-window (opal-window window-pair))
		(clx-window (clx-window window-pair))
		(display (xlib:window-display clx-window)))
	   (unless (already-been-destroyed opal-window)
	     (if (not (equal clx-window (g-value opal-window :drawable)))
		 (progn
		   (xlib:destroy-window clx-window)
		   (when display
		     (xlib:display-force-output display)))
		 (progn
		   (s-value opal-window :aggregate nil)
		   (destroy opal-window)))
	     (remhash clx-window *drawable-to-window-mapping*))
	   ))
       (dolist (w (cdr *windows-that-have-never-been-updated*))
	 (unless (already-been-destroyed w)
	   (s-value w :aggregate nil)
	   (destroy w))))
      (:orphans-only
       ;;  destroy all orphaned garnet windows
       (dolist (window-pair windows)
	 (let* ((opal-window (opal-window window-pair))
		(clx-window (clx-window window-pair))
		(display (xlib:window-display clx-window)))
	   (unless (already-been-destroyed opal-window)
	     (when (not (equal clx-window (g-value opal-window :drawable)))
	       (incf num-killed)
	       (xlib:destroy-window clx-window )
	       (remhash clx-window *drawable-to-window-mapping*)
	       (when display
		 (xlib:display-force-output display))))))   )
      (:clx
       ;; destroy all garnet windows by calling xlib:destroy-window"
       (dolist (window-pair windows)
	 (let* ((clx-window (clx-window window-pair))
		(display (xlib:window-display clx-window)))
	   (xlib:destroy-window clx-window )
	   (remhash clx-window *drawable-to-window-mapping*)
	   (when display
	     (xlib:display-force-output display)))))
      (t (format t "options are :opal, :opal-set-agg-to-nil, :orphans-only, :clx")))
    (if (eq how-to :orphans-only) num-killed
	(length windows))))

#-release-garnet
(defun change-garnet-display (new-display)
  (disconnect-garnet)
  (reconnect-garnet new-display))

(defun update-all ()
  ; update all top-level windows
  (maphash #'(lambda (drawable window)
	       (declare (ignore drawable))
	       (unless (g-value window :parent)
		 (update window)))
	   *drawable-to-window-mapping*)
  (dolist (window (cdr *windows-that-have-never-been-updated*))
    (unless (g-value window :parent)
      (update window))))

(defun reset-cursor (a-window)
  (s-value a-window :cursor (cons arrow-cursor arrow-cursor-mask))
  (update a-window))


;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/multi-text.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;;  4-Feb-91 ecp Cursor of cursor-multi-text now has draw function :xor.
;;; 23-Mar-90 ecp  New slot :fill-background-p for text objects.
;;; 14-Mar-90 ecp Move-cursor-* functions added.
;;; 28-Feb-90 ecp Cursor of cursor-multi-text now has same draw
;;;		  function as the text itself.
;;;
(in-package "OPAL" :use '("KR" "LISP"))


(define-method :draw opal:multi-text (gob line-style-gc filling-style-gc
					  drawable root-window clip-mask)
  (declare (ignore filling-style-gc))
  (let* ((update-vals (get-local-value gob :update-slots-values))
	 (xfont (aref update-vals *text-xfont*))
	 (xlib-gc-line (opal-gc-gcontext line-style-gc))
	 (left (aref update-vals *text-left*))
	 (top (aref update-vals *text-top*))
	 (max-line-width (aref update-vals *text-width*))
	 (justification (aref update-vals *multi-text-justification*))
	 (ascent (xlib:max-char-ascent xfont))
	 (height (+ ascent (xlib:max-char-descent xfont))))
    (with-line-styles ( (aref update-vals *text-lstyle*) line-style-gc
			xlib-gc-line root-window
		        (get (aref update-vals *text-draw-function*)
			     :x-draw-function)
		        clip-mask)
      (set-gc line-style-gc xlib-gc-line :font xfont)
      (do ((count 0 (1+ count))
	   (remaining (aref update-vals *multi-text-cut-strings*)
		      (cdr remaining)))
	  ((null remaining))
	(let* ((cut-string (car remaining))
	       (width (cut-string-width cut-string))
	       (string (cut-string-string cut-string))
	       (left-bearing (cut-string-left-bearing cut-string)))
          (if (aref update-vals *text-fill-background-p*)
	      (xlib:draw-image-glyphs drawable
			    xlib-gc-line
			    (+ (- left left-bearing)
			       (case justification
				 (:right (- max-line-width width))
				 (:center (floor (- max-line-width width) 2))
				 (t 0)))
			    (+ top ascent (* count height))
			    string)
	      (xlib:draw-glyphs drawable
			    xlib-gc-line
			    (+ (- left left-bearing)
			       (case justification
				 (:right (- max-line-width width))
				 (:center (floor (- max-line-width width) 2))
				 (t 0)))
			    (+ top ascent (* count height))
			    string)))))))


(defun cursor-index-to-line-number (cut-strings index)
  (let (length-of-this-line)
    (dotimes (line-num (length cut-strings))
      (setq length-of-this-line (length (cut-string-string (car cut-strings))))
      (if (<= index length-of-this-line)
	  (return line-num)
	  (progn
	    (setq index (- index 1 length-of-this-line))
	    (setq cut-strings (cdr cut-strings)))))))

(define-method :draw opal:cursor-multi-text (gob line-style-gc filling-style-gc
						 drawable root-window clip-mask)
  (call-prototype-method gob line-style-gc filling-style-gc
			 drawable root-window clip-mask)
  (when (g-value gob :cursor-index)
   (let* ((update-vals (get-local-value gob :update-slots-values))
	 (xlib-gc-line (opal-gc-gcontext line-style-gc))
	 (xfont (aref update-vals *text-xfont*))
	 (left (aref update-vals *text-left*))
	 (top (aref update-vals *text-top*))
	 (max-line-width (aref update-vals *text-width*))
	 (justification (aref update-vals *multi-text-justification*))
	 (cut-strings (aref update-vals *multi-text-cut-strings*))
	 (cursor-index
	  (max 0 (min (aref update-vals *cursor-multi-text-cursor-index*)
		      (length (aref update-vals *text-string*)))))
	 (line-number (cursor-index-to-line-number cut-strings cursor-index))
	 (cut-string (nth line-number cut-strings))
	 (line-height (+ (xlib:max-char-ascent xfont)
			 (xlib:max-char-descent xfont)))
	 (line-left-bearing (cut-string-left-bearing cut-string))
	 (line-width (cut-string-width cut-string))
	 (substring (aref update-vals *cursor-multi-text-x-substr*))
	 (cursor-offset (+ (case justification
			     (:right (- max-line-width line-width))
			     (:center (floor (- max-line-width line-width) 2))
			     (t 0))
			   (xlib:text-width xfont substring)
			   (- line-left-bearing)
			   -1)))
    (setq cursor-offset (min cursor-offset
			     (- max-line-width (ceiling *cursor-width* 2))))
    (setq cursor-offset (max cursor-offset (floor *cursor-width* 2)))
    (xlib:with-gcontext (xlib-gc-line
			    :line-width *cursor-width*
			    :function (get :xor :x-draw-function)
			    :fill-style :solid
			    :clip-mask clip-mask)
      (xlib:draw-line drawable xlib-gc-line
		      (+ left cursor-offset)
		      (+ top (* line-number line-height))
		      (+ left cursor-offset)
		      (+ top (* (1+ line-number) line-height))
		      )))))


(defun move-cursor-down-one-line (gob)
  (when (and (is-a-p gob opal:cursor-multi-text)
             (g-value gob :cursor-index))
    (let* ((cut-strings (g-value gob :cut-strings))
	   (x-substr (g-value gob :x-substr))
	   (xfont (g-value gob :xfont))
	   (line-height (+ (xlib:max-char-ascent xfont)
			   (xlib:max-char-descent xfont)))
	   (index (g-value gob :cursor-index))
	   (line-number (cursor-index-to-line-number cut-strings index)))
      (when (< line-number (1- (length cut-strings)))
	(let ((cut-string (nth line-number cut-strings)))
	  (s-value gob :cursor-index
		   (opal::get-cursor-index
		    gob
		    (+ (g-value gob :left)
		       (case (g-value gob :justification)
			 (:right (- (g-value gob :width)
				    (cut-string-width cut-string)))
			 (:center (floor (- (g-value gob :width)
					    (cut-string-width cut-string))
					 2))
			 (t 0))
		       (xlib:text-width xfont x-substr))
		    (+ (g-value gob :top)
		       (* line-height (1+ line-number))))))))))

(defun move-cursor-up-one-line (gob)
  (when (and (is-a-p gob opal:cursor-multi-text)
             (g-value gob :cursor-index))
    (let* ((cut-strings (g-value gob :cut-strings))
	   (x-substr (g-value gob :x-substr))
	   (xfont (g-value gob :xfont))
	   (line-height (+ (xlib:max-char-ascent xfont)
			   (xlib:max-char-descent xfont)))
	   (index (g-value gob :cursor-index))
	   (line-number (cursor-index-to-line-number cut-strings index)))
      (when (> line-number 0)
	(let ((cut-string (nth line-number cut-strings)))
	  (s-value gob :cursor-index
		   (opal::get-cursor-index
		    gob
		    (+ (g-value gob :left)
		       (case (g-value gob :justification)
			 (:right (- (g-value gob :width)
				    (cut-string-width cut-string)))
			 (:center (floor (- (g-value gob :width)
					    (cut-string-width cut-string))
					 2))
			 (t 0))
		       (xlib:text-width xfont x-substr))
		    (+ (g-value gob :top)
		       (* line-height (1- line-number))))))))))

(defun move-cursor-to-beginning-of-line (gob)
  (let ((index (g-value gob :cursor-index)))
    (if (and index (is-a-p gob opal:cursor-multi-text))
        (s-value gob :cursor-index
	       (- index (length (g-value gob :x-substr))))
        (s-value gob :cursor-index 0))))

(defun move-cursor-to-end-of-line (gob)
  (let ((index (g-value gob :cursor-index)))
    (if (and index (is-a-p gob opal:cursor-multi-text))
        (let* ((cut-strings (g-value gob :cut-strings))
	       (line-number (cursor-index-to-line-number cut-strings index)))
	  (s-value gob :cursor-index
		   (+ (- index (length (g-value gob :x-substr)))
		      (length (cut-string-string (nth line-number cut-strings))))))
       (s-value gob :cursor-index (length (g-value gob :string))))))

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/open-and-close.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1990, Carnegie-Mellon University
;;; All rights reserved.  The CMU Software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Close all connections to the X server by saying:
;;;     (opal:Disconnect-Garnet)
;;;
;;; While the connection to the X server is closed, you may
;;; save a core image of Garnet.  To save a core image:
;;;   In CMU Common Lisp say        (ext:save-lisp filename)
;;;   In Allegro Lisp say           (excl:dumplisp)
;;;   In Lucid Lisp the command is  (disksave filename)
;;;
;;; Reopen all connections to the X server by saying:
;;;     (opal:Reconnect-Garnet)
;;;
#|
CHANGE LOG:
	26-Mar-91 ECP kcl patch
        24-Mar-91 ECP Fixed bug involving reconnect to a color screen.
         7-Mar-91 ECP The question of whether the screen is color or
                      black-and-white is now determined inside
                      initialize-default-x-values in defs.lisp.
	14-Feb-91 ECP More changes to color for connect and disconnect
         8-Feb-91 ECP Added :color-p slot to opal:color to tell if
                      screen is black-and-white or color.
        11-Sep-90 ECP Get display name in allegro by (sys::getenv "DISPLAY")
                      Use (short-site-name) as an #+allegro alternative
                      to (machine-instance)
        15-Aug-90 ECP Yet more debugging.  Disconnect-garnet must
                      set windows :lineage slot to NIL.
                      Reconnect-garnet has an optional argument.
                      Call to initialize-default-x-values.
	14-Aug-90 ECP In reconnect-garnet, just explicitly update
			top level windows.
	10-Aug-90 ECP In reconnect-garnet, recompute display name.
	21-Mar-90 ECP Lots of debugging, as well as the above comments.
	9-Mar-90 ECP Released locally
|#

(in-package "OPAL" :use '("KR" "LISP"))

(export '(Disconnect-Garnet Reconnect-Garnet))

(defvar *all-the-windows*)
(defvar *all-windows-which-have-been-closed*)

(defun all-the-instances (x)
  (cons x (mapcan #'all-the-instances (kr:get-local-values x :is-a-inv))))

;;; 22-Jul-91 - later defined, so comment out now -FER
;(defun Disconnect-Garnet ()
;  (setq *all-the-windows*
;    (remove-if                               ;       This should remove
;      #'(lambda (w)                          ;     just opal:window and
;          (kr:get-local-value w :update))    ;  inter:interactor-window
;      (all-the-instances opal:window)))      ; from list of all windows
;  (setq *all-windows-which-have-been-closed* nil)
;  ;;; Make all the windows invisible.
;  (dolist (w *all-the-windows*) 
;    (when (kr:g-value w :visible)
;       (push w *all-windows-which-have-been-closed*)
;       (kr:s-value w :visible nil) 
;       (funcall (kr:g-value w :update) w)))  ; generalized update
;  ;;; Remove all connections to X from the text objects,
;  ;;; (even those hidden in the :update-slots-values slot!)
;  (dolist (txt (all-the-instances opal:text))
;    (when (kr:g-cached-value txt :xfont)
;      (xlib:close-font (kr:g-cached-value txt :xfont))
;      (kr:s-value txt :xfont nil))
;    (when (kr:g-cached-value txt :update-slots-values)
;      (setf (aref (kr:g-cached-value txt :update-slots-values)
;                  opal::*text-xfont*)
;            nil)))
;  (dolist (fnt (all-the-instances opal:font-from-file))
;    (kr:s-value fnt :display-xfont-plist nil))
;  ;;; Remove all connections to X from the window objects.
;  (setf opal::*display-name-to-display-mapping* nil)
;  (clrhash opal::*drawable-to-window-mapping*)
;  (dolist (w *all-the-windows*)
;    (kr:s-value w :drawable nil)
;    (kr:s-value w :lineage nil)
;    (kr:s-value w :already-initialized-border-widths nil)
;    (kr:s-value w :event-mask nil)
;    (let ((d (kr:g-cached-value w :display-info)))
;      (when d
;        (kr:s-value w :display-info nil)
;  #+cmu (ext:disable-clx-event-handling (opal::display-info-display d)))))
;  ;;; Clear all colors.
;  (dotimes (n *colormap-index-table-size*)
;    (setf (aref *colormap-index-table* n) 0))
;)
;
;
;(defun Reconnect-Garnet (&optional display-name)
;  (unless display-name
;    (setq display-name    ;;; this code is copied from defs.lisp
;          #+cmu
;          (cdr (assoc :DISPLAY lisp::*environment-list*))
;          #+(or allegro lispworks kcl)
;          (sys::getenv "DISPLAY")
;          #+(and lucid lcl3.0)
;          (lucid-common-lisp:environment-variable "DISPLAY")
;          #+(and lucid (not lcl3.0))
;          (system:environment-variable "DISPLAY")
;          )
;    (let ((colon-posn (position #\: display-name)))
;      (when colon-posn
;        (setq display-name (subseq display-name 0 colon-posn)))))
;  (setf opal::*default-x-display-name*
;        (or display-name #-allegro (machine-instance)
;                         #+allegro (short-site-name)))
;  (kr:s-value opal:window :display opal::*default-x-display-name*)
;
;  (opal::initialize-default-x-values) ;; defined in defs.lisp
;  (opal::set-draw-functions)          ;; defined in basics.lisp
;
;  (s-value opal:color :color-p *is-this-a-color-screen?*)
;
;  (when *is-this-a-color-screen?*
;    (let ((indices (xlib:alloc-color-cells opal::*default-x-colormap* 1)))
;      (setq *first-allocatable-colormap-index* (car indices))
;      (xlib:free-colors opal::*default-x-colormap* indices)))
;
;  (dolist (c (all-the-instances opal:color))
;    (s-value c :xcolor (xlib:make-color :red (g-value c :red)
;                                        :green (g-value c :green)
;                                        :blue (g-value c :blue))))
;
;  (dolist (w *all-windows-which-have-been-closed*)
;    (kr:s-value w :visible t))
;  (dolist (w *all-windows-which-have-been-closed*)
;    (unless (kr:g-value w :parent)
;      (funcall (kr:g-value w :update) w t))))





;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/opal-changes.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : opal-changes.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Sun Jul 21 17:13:09 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Tue Feb  4 11:11:52 1992
;;;; Update Count    : 28
;;;; 
;;;; PURPOSE
;;;; 	|>Description of module's purpose<|
;;;; TABLE OF CONTENTS
;;;;	I.	configure-notify
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



(in-package "OPAL")

(export '(;; variables & schema
          default-double-buffer-p	  
          line-3
          ;line-6
          ;line-7
          ;; new functions & macros
          ;clear-X-events
	  all-windows
          )
   (find-package "OPAL"))

(defvar default-double-buffer-p  nil
   #-release-garnet
   "*If T windows are double-buffered for faster redisplay with
corresponding increase in space.")


;;;
;;;	I.	configure-notify
;;;

(defun Configure-Notify (event-debug x y width height event-window above-sibling)
  (when event-debug
    (format t "Configure-notify win=~s ~s ~s ~s ~s ~s~%"
	    (xlib:window-id event-window) x y
	    width height (if above-sibling
			     (xlib:window-id above-sibling))))
  (let ((a-window (gethash event-window *drawable-to-window-mapping*)))
    (when (and a-window (= (xlib:window-id (g-value a-window :drawable))
			   (xlib:window-id event-window))
 ;; szekely: added test for window being visible.  This eliminates the
 ;; problem of the configure notify that olwm sends before mapping a window.
               (g-value a-window :visible))
      (if (g-value a-window :parent)
	  (progn			; If it's a subwindow, we don't
	    (s-value a-window :left x)  ; have to check lineage.
	    (s-value a-window :top y))
	  (let ((lineage (or (g-value a-window :lineage)
			     (s-value a-window :lineage
				      (lineage-of-drawable event-window)))))
	    (case (length lineage)
	      (2	;;; UWM or window without label.
	       (s-value a-window :left x)
	       (s-value a-window :top y))
	      (3	;;; TWM
	       (s-value a-window :left (xlib:drawable-x (second lineage)))
	       (s-value a-window :top (xlib:drawable-y (second lineage))))
	      (4	;;; MWM
	       (s-value a-window :left (xlib:drawable-x (third lineage)))
	       (s-value a-window :top (xlib:drawable-y (third lineage))))
	      (6        ;;; DECWindows
	       (s-value a-window :left (xlib:drawable-x (fourth lineage)))
	       (s-value a-window :top (xlib:drawable-y (fourth lineage)))))))
      (unless (g-value a-window :already-initialized-border-widths)
	(initialize-window-border-widths a-window event-window)
	(s-value a-window :already-initialized-border-widths t))
      (s-value a-window :width width)
      (s-value a-window :height height)
      ;; Don't want top, left, width, height to be invalid,
      ;; or else we might get a drifting window.
      (let ((win-info (g-value a-window :win-update-info)))
	(setf (win-update-info-invalid-slots win-info)
	      (set-difference (win-update-info-invalid-slots win-info)
			      '(:left :top :width :height))))
      (let ((old-buffer (g-value a-window :buffer)))
	(when (and old-buffer
		   (or (> height (xlib:drawable-height old-buffer))
		       (> width  (xlib:drawable-width old-buffer))))
	  (expand-buffer a-window)))
      ;; Update windows which have formulas dependent on a-window.
      (opal:update-all)
      ))
  t)


;; old version from first attempt?  dunno, save till all works at osu
;; 14-Oct-91 -FER
;(defun Configure-Notify (event-debug x y width height event-window above-sibling)
;  (when event-debug
;    (format t "Configure-notify win=~s ~s ~s ~s ~s ~s~%"
;            (xlib:window-id event-window) x y
;            width height (if above-sibling
;                             (xlib:window-id above-sibling))))
;  (let ((a-window (gethash event-window *drawable-to-window-mapping*)))
;    (when (and a-window (= (xlib:window-id (g-value a-window :drawable))
;                           (xlib:window-id event-window))
; ;; szekely: added test for window being visible.  This eliminates the
; ;; problem of the configure notify that olwm sends before mapping a window.
;               (g-value a-window :visible))
;      (if (g-value a-window :parent)
;          (progn                        ; If it's a subwindow, we don't
;            (s-value a-window :left x)  ; have to check lineage.
;            (s-value a-window :top y))
;          (unless (eq (g-value a-window :visible) :iconified)
;           (let ((lineage (or (g-value a-window :lineage)
;                              (s-value a-window :lineage
;                                      (lineage-of-drawable event-window)))))
;            (case (length lineage)
;              (2        ;;; UWM or window without label.
;               (s-value a-window :left x)
;               (s-value a-window :top y))
;              (3        ;;; TWM
;               (s-value a-window :left (xlib:drawable-x (second lineage)))
;               (s-value a-window :top (xlib:drawable-y (second lineage))))
;              ((4 6)    ;;; MWM and DECWindows
;               (s-value a-window :left (xlib:drawable-x (third lineage)))
;               (s-value a-window :top (xlib:drawable-y (third lineage))))))))
;;             (6        ;;; DECWindows
;;              (s-value a-window :left (xlib:drawable-x (fourth lineage)))
;;              (s-value a-window :top (xlib:drawable-y (fourth lineage))))))))
;      (unless (or (g-value a-window :already-initialized-border-widths)
;                  (eq (g-value a-window :visible) :iconified))
;        (initialize-window-border-widths a-window event-window)
;        (s-value a-window :already-initialized-border-widths t))
;      (s-value a-window :width width)
;      (s-value a-window :height height)
;      ;; Don't want top, left, width, height to be invalid,
;      ;; or else we might get a drifting window.
;      (let ((win-info (g-value a-window :win-update-info)))
;        (setf (win-update-info-invalid-slots win-info)
;              (set-difference (win-update-info-invalid-slots win-info)
;                              '(:left :top :width :height))))
;      (let ((old-buffer (g-value a-window :buffer)))
;        (when (and old-buffer
;                   (or (> height (xlib:drawable-height old-buffer))
;                       (> width  (xlib:drawable-width old-buffer))))
;          (expand-buffer a-window)))
;      ;; Update windows which have formulas dependent on a-window.
;      (opal:update-all)
;      ))
;  t)



;;;
;;;	VI. 	disconnect-garnet
;;;

(in-package "OPAL")

;; also need to set this, sometimes reconnect could be called first
(defvar *visible-windows-which-have-been-closed* nil)
(defvar *invisible-windows-which-have-been-closed* nil)

(defun Disconnect-Garnet ()
  (setq *all-the-windows*
    (remove-if                               ;       This should remove
      #'(lambda (w)                          ;     just opal:window and
          (kr:get-local-value w :update))    ;  inter:interactor-window
      (all-the-instances opal:window)))      ; from list of all windows
  (setq *invisible-windows-which-have-been-closed* nil)  ;-fer
  (setq *visible-windows-which-have-been-closed* nil)    ;-fer
  ;;; Make all the windows invisible or visible.         ;-fer
  (dolist (w *all-the-windows*)
    (if (kr:g-value w :visible)
        (progn
          (push w *visible-windows-which-have-been-closed*)
          (kr:s-value w :visible nil)
          (funcall (kr:g-value w :update) w))  ; generalized update
        (push w *invisible-windows-which-have-been-closed*))  )
  ;;; Remove all connections to X from the text objects,
  ;;; (even those hidden in the :update-slots-values slot!)
  (dolist (txt (all-the-instances opal:text))
    (when (kr:g-cached-value txt :xfont)
      (xlib:close-font (kr:g-cached-value txt :xfont))
      (kr:s-value txt :xfont nil))
    (when (kr:g-cached-value txt :update-slots-values)
      (setf (aref (kr:g-cached-value txt :update-slots-values)
		  opal::*text-xfont*)
	    nil)))
  (dolist (fnt (all-the-instances opal:font-from-file))
   (kr:s-value fnt :display-xfont-plist nil))
  ;;; Remove all connections to X from the window objects.
  (setf opal::*display-name-to-display-mapping* nil)
  (clrhash opal::*drawable-to-window-mapping*)
  (dolist (w *all-the-windows*)
    (kr:s-value w :drawable nil)
    (kr:s-value w :lineage nil)
    (kr:s-value w :already-initialized-border-widths nil)
    (kr:s-value w :event-mask nil)
    (let ((d (kr:g-cached-value w :display-info)))
      (when d
        (kr:s-value w :display-info nil)
  #+cmu (ext:disable-clx-event-handling (opal::display-info-display d)))))
  ;;; Clear all colors.
  (dotimes (n *colormap-index-table-size*)
    (setf (aref *colormap-index-table* n) 0))
  ; (xlib:close-display *default-x-display*)  ;-fer for neatness's sake
)


;;;
;;;	VIII.	Reconnect-garnet
;;;
;;; this is slightly smarter about hooking up windows, and notes that
;;; they are hooked up by settting *(in)visible-windows-which-have-been-closed* 
;;; to nil.
;;;

(defun Reconnect-Garnet (&optional display-name)
  (unless display-name
    (setq display-name    ;;; this code is copied from defs.lisp
	  #+cmu
	  (cdr (assoc :DISPLAY lisp::*environment-list*))
	  #+(or allegro lispworks kcl)
	  (sys::getenv "DISPLAY")
	  #+(and lucid lcl3.0)
	  (lucid-common-lisp:environment-variable "DISPLAY")
	  #+(and lucid (not lcl3.0))
	  (system:environment-variable "DISPLAY") )
    (let ((colon-posn (position #\: display-name)))
      (when colon-posn
	(setq display-name (subseq display-name 0 colon-posn)))))
  (setf opal::*default-x-display-name* display-name)
   ;; #-allegro (machine-instance)  ;; essentially dead code removed
   ;; #+allegro (short-site-name)   ;; 4-Feb-92 -FER

  (kr:s-value opal:window :display opal::*default-x-display-name*)

  (opal::initialize-default-x-values) ;; defined in defs.lisp
  (opal::set-draw-functions)	      ;; defined in basics.lisp
  (s-value opal:color :color-p *is-this-a-color-screen?*)

  (when *is-this-a-color-screen?*
    (let ((indices (xlib:alloc-color-cells opal::*default-x-colormap* 1)))
      (setq *first-allocatable-colormap-index* (car indices))
      (xlib:free-colors opal::*default-x-colormap* indices)))

  (dolist (c (all-the-instances opal:color))
    (s-value c :xcolor (xlib:make-color :red (g-value c :red)
					:green (g-value c :green)
					:blue (g-value c :blue))))
; not in reconnect 1.4
;  ;; fix up all the fonts: -fer 4/1/91
; put back in 3-Feb-92 -FER
;  (dolist (txt (all-the-instances opal:text))
;    (if (and (g-value txt :window)
;             (g-value txt :font))
;        (recompute-formula  txt :xfont)))

  (dolist (w *visible-windows-which-have-been-closed*)
    (kr:s-value w :visible t)
    (sleep 1.0)
    (unless (kr:g-value w :parent)
      (funcall (kr:g-value w :update) w)))

  ;; now bring the invisible ones back -fer
  ;; hide-invisible-windows has to be called later
  (dolist (w *invisible-windows-which-have-been-closed*)
    (kr:s-value w :visible t)
    (sleep 1.0)
    (unless (kr:g-value w :parent)
      (funcall (kr:g-value w :update) w)) )
  ;; these seem useful to have around, so don't set these variabls to nil
  ;;;  in production version
  ;; (setq *visible-windows-which-have-been-closed* nil)
  ;; (setq *invisible-windows-which-have-been-closed* nil)
  )


;;;
;;;	IX.	all-windows
;;;

(defun all-windows (&optional (print t))
  #-release-garnet
  "Returns list of all opal windows, prints them if print is t."
  (let (result)
    (maphash #'(lambda (x-window opal-window)
		 (declare (ignore x-window))
		 (and print (where opal-window))
		 (push opal-window result))
	     opal::*drawable-to-window-mapping*)
    result))

;;;
;;;	X.	more lines
;;;
;;; Garnet declines to include them b/c they are so easy to do, and they are
;;; easy to do, and we do them here.

(in-package "OPAL")

(create-instance 'opal:line-3 opal:line-style
  (:line-thickness 3))
;
;(create-instance 'opal:line-6 opal:line-style
;  (:line-thickness 6))

;;;
;;;	XI.	lineage-of-drawable
;;;

;; Returns list of drawable, parent, grandparent, ... , root.
(defun lineage-of-drawable (drawable)
;;; Warning: In Allegro Common Lisp running under the Mach
;;; operating system, the latest of version of CLX has a
;;; bug: it crashes when you call xlib:query-tree.
;;; If this is the case, switch the #+ and #- in the
;;; following code.
#-pmax
  (multiple-value-bind (children parent root)
		       (xlib:query-tree drawable)
    (declare (ignore children))
    (if (eq parent root)
	(list drawable root)
	(cons drawable (lineage-of-drawable parent))))
#+pmax  ;; what's the #+comment do?
  (list drawable opal::*default-x-root*)
)

;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/inter-loader.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
#|
============================================================
Change log:
	 3/22/90 Robert Cook - Define the package "INTERACTORS"
				for the TI Explorer.
	 3/14/90 Brad Myers - added textkeyhandling
	 1/4/90 Ed Pervin - Added version number
         6/7/89 Brad Myers - Made to work with Sun Lucid Lisp also
         5/24/89 Brad Myers - Added angleinter
         4/13/89 Brad Myers - Changed name "interactors-loader" to "inter-loader"
         4/7/89 Brad Myers - Added new key translation files
         3/11/89 lkb -- removed loading of cursor-text which was moved to opal
============================================================
|#

(in-package "USER" :use '("LISP"))

(defparameter Interactors-Version-Number "1.0")
;
;(format t "Loading Interactors...~%")
;(setf *load-verbose* t)
;
;;; check first to see if place is set
;(unless (boundp 'Garnet-Inter-PathName)
;  (error "Load 'Garnet-Loader' first to set Garnet-Inter-PathName before loading interactors."))
;
;;;; Load Opal unless already loaded  (this will load KR if necessary)
;#+cmu
;(unless (get :garnet-modules :opal)
;  (load Garnet-Opal-Loader))
;
;#+(not cmu)
;(require 'opal Garnet-Opal-Loader)
;
;#+explorer
;(unless (find-package "INTERACTORS")
;  (make-package "INTERACTORS" :use '("LISP") :nicknames '("INTER")))
;
;;; ---- Load interactors themselves
;
;;;This is a defvar so it can be overridden if you don't want to compile everything
;
;(Defvar Garnet-Inter-Files
;  '(
;            ;; key translation files
;    #+kcl "control-reader"
;    "garnet-keytrans"
;    "define-keys"
;    "define-mouse-keys"
;
;            ;; interactor files
;    "interactors"
;    "i-windows"
;    "menuinter"
;    "movegrowinter"
;    "buttoninter"
;    "twopointinter"
;    "textkeyhandling"
;    "textinter"
;    "angleinter"))
;
;(dolist (file Garnet-Inter-Files)
;  (load (merge-pathnames file 
;                         #+cmu "inter:"
;                         #+(not cmu) Garnet-Inter-PathName
;                         )
;        :verbose T))
;
;(setf (get :garnet-modules :inter)  t)
(provide 'inter)
;
;
;(format t "...Done Interactors.~%")


;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/garnet-keytrans.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs

;;; Most of the code in here was snarfed from Hemlock. Certainly the concepts were.
;;; The snarfed Hemlock code/documentation was written by Bill Chiles.
;;; Incorporated in the Garnet code in March 1989.

;;; This code is part of the effort to make the event handling code in Garnet
;;; as portable as possible.  
;;; There are four tables.  Two of them map the mouse buttons to 
;;; Garnet mouse keywords (like :leftdown, :shift-control-rightup, etc)
;;; The other two map keyboard keysyms to Lisp characters.  
;;; To alter the contents of the tables, see the (define-xxx ...) calls in
;;; define-xxx-keys.lisp

#|
============================================================
Change log:
	 8/21/90 Ken Meltsner - Added *ignore-undefined-keys*
	10/25/89 Brad Myers - modified so that keywords can be used as key names
	 9/16/89 Brad Myers - Removed the exports to avoid name conflicts
         4/7/89 Brad Myers - Moved to Interactors package
         3/15/89 Lynn Baumeister - created by editing Hemlock code
============================================================
|#

(in-package "INTERACTORS" :use '("LISP") :nicknames '("INTER"))

;;;;;;;; begin a section snarfed from Hemlock

;;; X modifier bits translation
;;;
(defvar *modifier-translations* ())

(defun define-keyboard-modifier (clx-mask modifier-name)
  #-release-garnet
  "Causes clx-mask to be interpreted as modifier-name which must be one of
:control, :meta, :super, :hyper, :shift, or :lock."
  (let ((map (assoc clx-mask *modifier-translations*)))
    (if map
	(rplacd map modifier-name)
	(push (cons clx-mask modifier-name) *modifier-translations*))))

(define-keyboard-modifier (xlib:make-state-mask :control) :control)
(define-keyboard-modifier (xlib:make-state-mask :mod-1) :meta)
(define-keyboard-modifier (xlib:make-state-mask :shift) :shift)
(define-keyboard-modifier (xlib:make-state-mask :lock) :lock)

;;; end section snarfed from Hemlock

(defparameter *num-modifier-keys* 4) 


(defparameter *num-mouse-buttons* 3)
(defparameter *mouse-translation-dimensions*
  (list  (1+ *num-mouse-buttons*) (* *num-modifier-keys* *num-modifier-keys*)))

(defparameter *mouse-down-translations* (make-array *mouse-translation-dimensions*))
(defparameter *mouse-up-translations* (make-array *mouse-translation-dimensions*))
 
;;; modifier-bits = '(:shift :control)

(defmacro mouse-index (modifier-bits)
  `(let ((sum 0))
     (dolist (mod-bit ,modifier-bits)
       (incf sum (car (rassoc mod-bit *modifier-translations*)))) sum))


;;; X11 documentation merely says that pointer keycode numbers begin at 1
;;; at CMU on the RT's, they get numbered left->right (makes sense)
(defvar *left-button* 1)
(defvar *middle-button* 2)
(defvar *right-button* 3)


(defmacro define-mouse-up (button modifier-bits garnet-keyword)
  `(setf (aref *mouse-up-translations* ,button (mouse-index, modifier-bits))
	,garnet-keyword))

(defmacro define-mouse-down (button modifier-bits garnet-keyword)
  `(setf (aref *mouse-down-translations* ,button (mouse-index, modifier-bits))
	,garnet-keyword))


(defmacro modifier-index (incoming-bits)
  `(let ((sum 0))
    (dolist (ele *modifier-translations*)
      (let ((bit (car ele)))
	(unless (zerop (logand bit ,incoming-bits))
	  (incf sum bit))))
    sum))


(defun translate-mouse-character (button-code modifier-bits event-key)
  (case event-key
    (:button-release
     (aref *mouse-up-translations*  button-code (modifier-index modifier-bits)))
    (:button-press
     (aref *mouse-down-translations*  button-code (modifier-index modifier-bits)))))



;;;     Borrowed from Hemlock -- substitute "Garnet" for "Hemlock" below
;;; Hemlock uses its own keysym to character translation since this is easier
;;; and more versatile than the CLX design.  Also, using CLX's mechanism is no
;;; more portable than writing our own translation based on the X11 protocol
;;; keysym specification.
;;;
;;; In the first table, nil indicates a non-event which is pertinent to
;;; ignoring modifier keys being pressed prior to pressing a key to be
;;; modified.  In the second table, nil simply indicates that there is no
;;; special shift translation for the keysym, and that the CLX shifted keysym
;;; should be looked up as normal (see TRANSLATE-CHARACTER).
;;;
;;; This mapping is initialized with DEFINE-KEYSYM in define-keys.Lisp
;;;

(defvar *ignore-undefined-keys* T)

(defvar *keysym-translations* (make-hash-table))
(defvar *shifted-keysym-translations* (make-hash-table))
(defvar *the-keyword-package* (find-package 'keyword))

;;; Will also handle symbols in the keyword package as characters
(defun define-keysym (keysym char &optional shifted-char)
  #-release-garnet
  "Defines a keysym for Hemlock's translation.  If shifted-char is supplied,
   it is a character to use when the :shift modifier is on for an incoming
   keysym.  If shifted-char is not supplied, and the :shift modifier is set,
   then XLIB:KEYCODE->KEYSYM is called with an index of 1 instead of 0.  If
   a :lock modifier is set, it is treated as a caps-lock.  See
   DEFINE-KEYBOARD-MODIFIER."
  (if (and (symbolp char)(eq (symbol-package char) *the-keyword-package*))
      ;; then just hash the keyword
      (setf (gethash keysym *keysym-translations*) char)
      ;; else make sure it is a character, and hash both shifted and regular
      (progn
	(check-type char character)
	(setf (gethash keysym *keysym-translations*) char)
	(when (and shifted-char (check-type shifted-char character))
	  (setf (gethash keysym *shifted-keysym-translations*) shifted-char))))
  t)

(defun translate-character (display scan-code bits)
#-release-garnet  
  "Translates scan-code and modifier bits to a Lisp character.  The scan code
   is first mapped to a keysym with index 0 for unshifted and index 1 for
   shifted.  If this keysym does not map to a character, and it is not a
   modifier key (shift, ctrl, etc.), then an error is signaled.  If the keysym
   is a modifier key, then nil is returned.  If we do have a character, and the
   shift bit is off, and the lock bit is on, and the character is alphabetic,
   then we get a new keysym with index 1, mapping it to a character.  If this
   does not result in a character, an error is signaled.  If we have a
   character, and the shift bit is on, then we look for a special shift mapping
   for the original keysym.  This allows for distinct characters for scan
   codes that map to the same keysym, shifted or unshifted, (e.g., number pad
   or arrow keys)."
  (let ((dummy #\?)
	shiftp lockp)
    (dolist (ele *modifier-translations*)
      (unless (zerop (logand (car ele) bits))
	(case (cdr ele)
	  (:shift (setf shiftp t))
	  (:lock (setf lockp t))
	  (t (setf dummy (set-char-bit dummy (cdr ele) t))))))
    (let* ((keysym (xlib:keycode->keysym display scan-code (if shiftp 1 0)))
	   (temp-char (gethash keysym *keysym-translations*)))
      (cond ((not temp-char)
	     (if (<= 65505 keysym 65518) ;modifier keys.
		 nil
		 (unless *ignore-undefined-keys*
		   (error "Undefined keysym ~S, describe OPAL:DEFINE-KEYSYM."
			  keysym))))
	    ((keywordp temp-char) ; special, create a symbol for the keyword
	     (make-keyword-char temp-char bits))
	    ((and (not shiftp) lockp (alpha-char-p temp-char))
	     (let* ((keysym (xlib:keycode->keysym display scan-code 1))
		    (char (gethash keysym *keysym-translations*)))
	       (unless char
		 (unless *ignore-undefined-keys*
		   (error "Undefined keysym ~S, describe EXT:DEFINE-KEYSYM."
			  keysym)))
	       (make-char char (logior (char-bits char) (char-bits dummy)))))
	    (shiftp
	     (let ((char (gethash keysym *shifted-keysym-translations*)))
	       (if char
		   (make-char char (logior (char-bits char) (char-bits dummy)))
		   (make-char temp-char (logior (char-bits temp-char)
						(char-bits dummy))))))
	    (t (make-char temp-char (logior (char-bits temp-char)
					    (char-bits dummy))))))))
(defparameter *prefixes* 
  (make-array 16 :initial-contents
	      '(NIL	     ;0
		"SHIFT-"     ;1
		"SHIFT-"     ;2
		"SHIFT-"     ;3
		"CONTROL-"   ;4
		"SHIFT-CONTROL-" ;5
		"SHIFT-CONTROL-" ;6
		"SHIFT-CONTROL-" ;7
		"META-"       ;8
		"SHIFT-META-" ;9
		"SHIFT-META-" ;10
		"SHIFT-META-" ;11
		"CONTROL-META-" ;12
		"SHIFT-CONTROL-META-" ;13
		"SHIFT-CONTROL-META-" ;14
		"SHIFT-CONTROL-META-"))) ;15

(defun make-keyword-char (symbol bits)
  (let ((prefix (aref *prefixes* (logand bits 15))))
    (if prefix
      (intern (concatenate 'simple-string prefix (symbol-name symbol))
		      'keyword)
      symbol)))

;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/define-keys.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs

;;;
;;; **********************************************************************
;;; This file was originally written as part of the Spice Lisp project at
;;; Carnegie-Mellon University, and has been placed in the public domain.
;;; Spice Lisp is currently incomplete and under active development.
;;; If you want to use this code or any part of Spice Lisp, please contact
;;; Scott Fahlman (FAHLMAN@CMUC). 
;;; **********************************************************************
;;;
;;; This file initializes character translation.
;;;
#|
============================================================
Change log:
	3/26/91 - Greg Sylvain - Changes for kcl.
        8/22/90 - Brad Myers - Removed CMU #\F1, etc. use :F1 like others
        8/21/90 - Ed Pervin - Added DECSystem keys
	3/23/90 - Ed Pervin - Added Sun :F10
	11/89 - Ed Pervin - Revised to work on Sun keyboard
	3/89 - Incorporated into Garnet
	Written by Bill Chiles
============================================================
|#
;;; The IBM RT keyboard has X11 keysyms defined for the following modifier
;;; keys, but we leave them mapped to nil indicating that they are non-events
;;; to be ignored:
;;;    ctrl		65507
;;;    meta (left)	65513  -- 65511 on Sun
;;;    meta (right)	65514  -- 65512 on Sun
;;;    shift (left)	65505
;;;    shift (right)	65506
;;;    lock		65509

(in-package "INTERACTORS")


;;; Function keys for the RT.
;;;
#+cmu
(progn
  (define-keysym 65470 :f1)
  (define-keysym 65471 :f2)
  (define-keysym 65472 :f3)
  (define-keysym 65473 :f4)
  (define-keysym 65474 :f5)
  (define-keysym 65475 :f6)
  (define-keysym 65476 :f7)
  (define-keysym 65477 :f8)
  (define-keysym 65478 :f9)
  (define-keysym 65479 :f10)
  (define-keysym 65480 :f11)
  (define-keysym 65481 :f12)
;;; Upper right key bank.
  (define-keysym 65377 :printscreen)
;; Couldn't type scroll lock.
  (define-keysym 65299 :pause)
;;; Middle right key bank.
  (define-keysym 65379 :insert)
  (define-keysym 65360 :home)
  (define-keysym 65365 :pageup)
  (define-keysym 65367 :end)
  (define-keysym 65366 :pagedown)
;;; Arrows.
  (define-keysym 65361 :leftarrow)
  (define-keysym 65362 :uparrow)
  (define-keysym 65364 :downarrow)
  (define-keysym 65363 :rightarrow)
;;; Number pad.
  (define-keysym 65407 :numlock)
  (define-keysym 65421 #\super-return)		;num-pad-enter
  (define-keysym 65455 #\super-/ #\super-/)	;num-pad-/
  (define-keysym 65450 #\super-* #\super-*)	;num-pad-*
  (define-keysym 65453 #\super-- #\super--)	;num-pad--
  (define-keysym 65451 #\super-+ #\super-+)	;num-pad-+
  (define-keysym 65456 #\super-0 #\super-0)	;num-pad-0
  (define-keysym 65457 #\super-1 #\super-1)	;num-pad-1
  (define-keysym 65458 #\super-2 #\super-2)	;num-pad-2
  (define-keysym 65459 #\super-3 #\super-3)	;num-pad-3
  (define-keysym 65460 #\super-4 #\super-4)	;num-pad-4
  (define-keysym 65461 #\super-5 #\super-5)	;num-pad-5
  (define-keysym 65462 #\super-6 #\super-6)	;num-pad-6
  (define-keysym 65463 #\super-7 #\super-7)	;num-pad-7
  (define-keysym 65464 #\super-8 #\super-8)	;num-pad-8
  (define-keysym 65465 #\super-9 #\super-9)	;num-pad-9
  (define-keysym 65454 #\super-. #\super-.)	;num-pad-.
) ; end +cmu


;;; Function keys for the Sun and other machines.
;;;
#+kcl
 (progn
  (define-keysym 65470 :f1)
  (define-keysym 65471 :f2)
  (define-keysym 65472 :f3)
  (define-keysym 65473 :f4)
  (define-keysym 65307 :f5)
  (define-keysym 65475 :f6)
  (define-keysym 65476 :f7)
  (define-keysym 65477 :f8)
  (define-keysym 65478 :f9)
  (define-keysym 65479 :f10)
  (define-keysym 65480 :f11)
  (define-keysym 65481 :f12)
  (define-keysym 65365 :prior)
  (define-keysym 65366 :next)
  (define-keysym 65376 :select)
  (define-keysym 65361 :leftarrow)
  (define-keysym 65362 :uparrow)
  (define-keysym 65364 :downarrow)
  (define-keysym 65363 :rightarrow)
;;
;; the folowing definitions are for the key pad
;;
   (define-keysym 65425 :KP_F1)
   (define-keysym 65426 :KP_F2)
   (define-keysym 65427 :KP_F3)
   (define-keysym 65428 :KP_F4)
   (define-keysym 65453 #\- #\-)
   (define-keysym 65452 #\, #\,) 
   (define-keysym 65421 #\return #\return)
   (define-keysym 65454 #\. #\.)
   (define-keysym 65456 #\0 #\0)
   (define-keysym 65457 #\1 #\1)
   (define-keysym 65458 #\2 #\2)
   (define-keysym 65459 #\3 #\3)
   (define-keysym 65460 #\4 #\4)
   (define-keysym 65461 #\5 #\5)
   (define-keysym 65462 #\6 #\6)
   (define-keysym 65463 #\7 #\7)
   (define-keysym 65464 #\8 #\8)
   (define-keysym 65465 #\9 #\9)

;;
;; more function keys
;;
   (define-keysym 65386 :Menu)
;;
;; the following definitions are only for the DEC workstation keyboard
;; (if your CLX does not ignore invlid key's you should comment this out)
;;
#+(or vax dec3100) ;; could probably just do a (pushnew 'dec3100 *features*)
   (progn 
     (define-keysym 65386 :Help)
     (define-keysym 65384 :Find)
     (define-keysym 65379 :Insert)
     ;; ontop of the keypad on the dec's
     (define-keysym 65486 :F17)
     (define-keysym 65487 :F18)
     (define-keysym 65488 :F19)
     (define-keysym 65489 :F20)
     (define-keysym 268500736 :Remove)
     )
;;
;; these keys are only defined on a hp 46021A keyboard (normal 
;; workstation keyboard)
;;

#+(and hp-ux hp9000-300)   ;; this can probably be changed to just hp-ux
  (progn
    (define-keysym 65360 :Home)
    (define-keysym 65387 :Break)
    (define-keysym 65385 :Cancel)
    (define-keysym 65291 :Clear)
    (define-keysym 65378 :Execute)
    (define-keysym 268500850 :Insert-Char)
    (define-keysym 268500848 :Insert-Line)
    (define-keysym 268500849 :Delete-Line)
    (define-keysym 268500851 :Delete-Char)
    (define-keysym 268500847 :Clear-Line)
    (define-keysym 268500845 :User)          ;; user defined key 
    )
)

#-(or cmu kcl)
(progn
  (define-keysym 65470 :F1)
  (define-keysym 65471 :F2)
  (define-keysym 65472 :F3)
  (define-keysym 65473 :F4)
  (define-keysym 65474 :F5)
  (define-keysym 65475 :F6)
  (define-keysym 65476 :F7)
  (define-keysym 65477 :F8)
  (define-keysym 65478 :F9)
  (define-keysym 65479 :F10)
  (define-keysym 65480 :L1)
  (define-keysym 65481 :L2)
  (define-keysym 65482 :L3)
  (define-keysym 65483 :L4)
  (define-keysym 65484 :L5)
  (define-keysym 65485 :L6)
  (define-keysym 65486 :L7)
  (define-keysym 65487 :L8)
  (define-keysym 65488 :L9)
  (define-keysym 65489 :L10)
  (define-keysym 65490 :R1)
  (define-keysym 65491 :R2)
  (define-keysym 65492 :R3)
  (define-keysym 65493 :R4)
  (define-keysym 65494 :R5)
  (define-keysym 65495 :R6)
  (define-keysym 65496 :R7)
  (define-keysym 65498 :R9)
  (define-keysym 65500 :R11)
  (define-keysym 65502 :R13)
  (define-keysym 65504 :R15)
  (define-keysym 65361 :leftarrow)
  (define-keysym 65362 :uparrow)
  (define-keysym 65364 :downarrow)
  (define-keysym 65363 :rightarrow)
) ;; end -cmu

;;; "Named" keys.
;;;
#+kcl (define-keysym 65535 #\rubout #\rubout)
#-kcl (define-keysym 65535 #\delete #\delete)
(define-keysym 65289 #\tab #\tab)
#+kcl (define-keysym 65307 #\^[ #\^[)
#-kcl (define-keysym 65307 #\esc #\esc)
(define-keysym 65288 #\backspace #\backspace)
(define-keysym 65293 #\return #\return)			;enter on RT
(define-keysym 65512 #\newline #\newline)		;action on RT,
(define-keysym 32 #\space #\space)

;;; Letters.
;;;
(define-keysym 97 #\a) (define-keysym 65 #\A)
(define-keysym 98 #\b) (define-keysym 66 #\B)
(define-keysym 99 #\c ) (define-keysym 67 #\C )
(define-keysym 100 #\d) (define-keysym 68 #\D)
(define-keysym 101 #\e) (define-keysym 69 #\E)
(define-keysym 102 #\f) (define-keysym 70 #\F)
(define-keysym 103 #\g) (define-keysym 71 #\G)
(define-keysym 104 #\h) (define-keysym 72 #\H)
(define-keysym 105 #\i) (define-keysym 73 #\I)
(define-keysym 106 #\j) (define-keysym 74 #\J)
(define-keysym 107 #\k) (define-keysym 75 #\K)
(define-keysym 108 #\l) (define-keysym 76 #\L)
(define-keysym 109 #\m) (define-keysym 77 #\M)
(define-keysym 110 #\n) (define-keysym 78 #\N)
(define-keysym 111 #\o) (define-keysym 79 #\O)
(define-keysym 112 #\p) (define-keysym 80 #\P)
(define-keysym 113 #\q) (define-keysym 81 #\Q)
(define-keysym 114 #\r) (define-keysym 82 #\R)
(define-keysym 115 #\s) (define-keysym 83 #\S)
(define-keysym 116 #\t) (define-keysym 84 #\T)
(define-keysym 117 #\u) (define-keysym 85 #\U)
(define-keysym 118 #\v) (define-keysym 86 #\V)
(define-keysym 119 #\w) (define-keysym 87 #\W)
(define-keysym 120 #\x) (define-keysym 88 #\X)
(define-keysym 121 #\y) (define-keysym 89 #\Y)
(define-keysym 122 #\z) (define-keysym 90 #\Z)

;;; Standard number keys.
;;;
(define-keysym 49 #\1) (define-keysym 33 #\!)
(define-keysym 50 #\2) (define-keysym 64 #\@)
(define-keysym 51 #\3) (define-keysym 35 #\#)
(define-keysym 52 #\4) (define-keysym 36 #\$)
(define-keysym 53 #\5) (define-keysym 37 #\%)
(define-keysym 54 #\6) (define-keysym 94 #\^)
(define-keysym 55 #\7) (define-keysym 38 #\&)
(define-keysym 56 #\8) (define-keysym 42 #\*)
(define-keysym 57 #\9) (define-keysym 40 #\()
(define-keysym 48 #\0) (define-keysym 41 #\))

;;; "Standard" symbol keys.
;;;
(define-keysym 96 #\`) (define-keysym 126 #\~)
(define-keysym 45 #\-) (define-keysym 95 #\_)
(define-keysym 61 #\=) (define-keysym 43 #\+)
(define-keysym 91 #\[) (define-keysym 123 #\{)
(define-keysym 93 #\]) (define-keysym 125 #\})
(define-keysym 92 #\\) (define-keysym 124 #\|)
(define-keysym 59 #\;) (define-keysym 58 #\:)
(define-keysym 39 #\') (define-keysym 34 #\")
(define-keysym 44 #\,) (define-keysym 60 #\<)
(define-keysym 46 #\.) (define-keysym 62 #\>)
(define-keysym 47 #\/) (define-keysym 63 #\?)


;;; Sun keyboard.
;;;
#+kcl (define-keysym 65290 #\linefeed #\linefeed)
#-kcl (define-keysym 65290 #\linefeed #\s-linefeed)

;;; DECSystem keyboard
;;;
;;; Some of these will override
;;; previously defined keys.
#+(or dec3100 dec5000)
(progn
  (define-keysym 65307 :F11)
  (define-keysym 65312 :COMPOSE-CHARACTER)
  (define-keysym 65376 :SELECT)
  (define-keysym 65379 :INSERT-HERE)
  (define-keysym 65383 :DO)
  (define-keysym 65384 :FIND)
  (define-keysym 65386 :HELP)
  (define-keysym 65425 :PF1)
  (define-keysym 65426 :PF2)
  (define-keysym 65427 :PF3)
  (define-keysym 65428 :PF4)
  (define-keysym 65452 #\,)
  (define-keysym 65481 :F12)
  (define-keysym 65482 :F13)
  (define-keysym 65483 :F14)
  (define-keysym 65486 :F17)
  (define-keysym 65487 :F18)
  (define-keysym 65488 :F19)
  (define-keysym 65489 :F20)
  (define-keysym 268500736 :REMOVE)
) ; end DEC


;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/define-mouse-keys.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs

(in-package "INTERACTORS" :use '("LISP" "KR") :nicknames '("INTER"))

;;;;    definitions of garnet mouse keywords for the left button release
(define-mouse-up *left-button* nil :leftup)

(define-mouse-up *left-button* '(:control) :control-leftup)
(define-mouse-up *left-button* '(:shift) :shift-leftup)
(define-mouse-up *left-button* '(:lock) :shift-leftup)
(define-mouse-up *left-button* '(:meta) :meta-leftup)


(define-mouse-up *left-button* '(:control :shift) :shift-control-leftup) 
(define-mouse-up *left-button* '(:control :lock) :shift-control-leftup) 
(define-mouse-up *left-button* '(:control :meta) :control-meta-leftup)

(define-mouse-up *left-button* '(:shift :lock) :shift-leftup)
(define-mouse-up *left-button* '(:shift :meta) :shift-meta-leftup)

(define-mouse-up *left-button* '(:lock :meta) :shift-meta-leftup)


(define-mouse-up *left-button* '(:control :shift :lock) :shift-control-leftup)
(define-mouse-up *left-button* '(:control :shift :meta) :shift-control-meta-leftup)

(define-mouse-up *left-button* '(:shift :lock :meta) :shift-meta-leftup)

(define-mouse-up *left-button* '(:control :shift :lock :meta) :shift-control-meta-leftup)


;;;;    definitions of garnet mouse keywords for the middle button release
(define-mouse-up *middle-button* nil :middleup)

(define-mouse-up *middle-button* '(:control) :control-middleup)
(define-mouse-up *middle-button* '(:shift) :shift-middleup)
(define-mouse-up *middle-button* '(:lock) :shift-middleup)
(define-mouse-up *middle-button* '(:meta) :meta-middleup)


(define-mouse-up *middle-button* '(:control :shift) :shift-control-middleup) 
(define-mouse-up *middle-button* '(:control :lock) :shift-control-middleup) 
(define-mouse-up *middle-button* '(:control :meta) :control-meta-middleup)

(define-mouse-up *middle-button* '(:shift :lock) :shift-middleup)
(define-mouse-up *middle-button* '(:shift :meta) :shift-meta-middleup)

(define-mouse-up *middle-button* '(:lock :meta) :shift-meta-middleup)


(define-mouse-up *middle-button* '(:control :shift :lock) :shift-control-middleup)
(define-mouse-up *middle-button* '(:control :shift :meta) :shift-control-meta-middleup)

(define-mouse-up *middle-button* '(:shift :lock :meta) :shift-meta-middleup)


(define-mouse-up *middle-button* '(:control :shift :lock :meta)
  :shift-control-meta-middleup)



;;;;    definitions of garnet mouse keywords for the right button release
(define-mouse-up *right-button* nil :rightup)

(define-mouse-up *right-button* '(:control) :control-rightup)
(define-mouse-up *right-button* '(:shift) :shift-rightup)
(define-mouse-up *right-button* '(:lock) :shift-rightup)
(define-mouse-up *right-button* '(:meta) :meta-rightup)


(define-mouse-up *right-button* '(:control :shift) :shift-control-rightup) 
(define-mouse-up *right-button* '(:control :lock) :shift-control-rightup) 
(define-mouse-up *right-button* '(:control :meta) :control-meta-rightup)

(define-mouse-up *right-button* '(:shift :lock) :shift-rightup)
(define-mouse-up *right-button* '(:shift :meta) :shift-meta-rightup)

(define-mouse-up *right-button* '(:lock :meta) :shift-meta-rightup)


(define-mouse-up *right-button* '(:control :shift :lock) :shift-control-rightup)
(define-mouse-up *right-button* '(:control :shift :meta) :shift-control-meta-rightup)

(define-mouse-up *right-button* '(:shift :lock :meta) :shift-meta-rightup)


(define-mouse-up *right-button* '(:control :shift :lock :meta)
  :shift-control-meta-rightup)



;;;;    definitions of garnet mouse keywords for the left button press
(define-mouse-down *left-button* nil :leftdown)

(define-mouse-down *left-button* '(:control) :control-leftdown)
(define-mouse-down *left-button* '(:shift) :shift-leftdown)
(define-mouse-down *left-button* '(:lock) :shift-leftdown)
(define-mouse-down *left-button* '(:meta) :meta-leftdown)


(define-mouse-down *left-button* '(:control :shift) :shift-control-leftdown) 
(define-mouse-down *left-button* '(:control :lock) :shift-control-leftdown) 
(define-mouse-down *left-button* '(:control :meta) :control-meta-leftdown)

(define-mouse-down *left-button* '(:shift :lock) :shift-leftdown)
(define-mouse-down *left-button* '(:shift :meta) :shift-meta-leftdown)

(define-mouse-down *left-button* '(:lock :meta) :shift-meta-leftdown)


(define-mouse-down *left-button* '(:control :shift :lock) :shift-control-leftdown)
(define-mouse-down *left-button* '(:control :shift :meta) :shift-control-meta-leftdown)

(define-mouse-down *left-button* '(:shift :lock :meta) :shift-meta-leftdown)

(define-mouse-down *left-button* '(:control :shift :lock :meta) :shift-control-meta-leftdown)


;;;;    definitions of garnet mouse keywords for the middle button press
(define-mouse-down *middle-button* nil :middledown)

(define-mouse-down *middle-button* '(:control) :control-middledown)
(define-mouse-down *middle-button* '(:shift) :shift-middledown)
(define-mouse-down *middle-button* '(:lock) :shift-middledown)
(define-mouse-down *middle-button* '(:meta) :meta-middledown)


(define-mouse-down *middle-button* '(:control :shift) :shift-control-middledown) 
(define-mouse-down *middle-button* '(:control :lock) :shift-control-middledown) 
(define-mouse-down *middle-button* '(:control :meta) :control-meta-middledown)

(define-mouse-down *middle-button* '(:shift :lock) :shift-middledown)
(define-mouse-down *middle-button* '(:shift :meta) :shift-meta-middledown)

(define-mouse-down *middle-button* '(:lock :meta) :shift-meta-middledown)


(define-mouse-down *middle-button* '(:control :shift :lock) :shift-control-middledown)
(define-mouse-down *middle-button* '(:control :shift :meta) :shift-control-meta-middledown)

(define-mouse-down *middle-button* '(:shift :lock :meta) :shift-meta-middledown)


(define-mouse-down *middle-button* '(:control :shift :lock :meta) :shift-control-meta-middledown)



;;;;    definitions of garnet mouse keywords for the right button press
(define-mouse-down *right-button* nil :rightdown)

(define-mouse-down *right-button* '(:control) :control-rightdown)
(define-mouse-down *right-button* '(:shift) :shift-rightdown)
(define-mouse-down *right-button* '(:lock) :shift-rightdown)
(define-mouse-down *right-button* '(:meta) :meta-rightdown)


(define-mouse-down *right-button* '(:control :shift) :shift-control-rightdown) 
(define-mouse-down *right-button* '(:control :lock) :shift-control-rightdown) 
(define-mouse-down *right-button* '(:control :meta) :control-meta-rightdown)

(define-mouse-down *right-button* '(:shift :lock) :shift-rightdown)
(define-mouse-down *right-button* '(:shift :meta) :shift-meta-rightdown)

(define-mouse-down *right-button* '(:lock :meta) :shift-meta-rightdown)


(define-mouse-down *right-button* '(:control :shift :lock) :shift-control-rightdown)
(define-mouse-down *right-button* '(:control :shift :meta) :shift-control-meta-rightdown)

(define-mouse-down *right-button* '(:shift :lock :meta) :shift-meta-rightdown)


(define-mouse-down *right-button* '(:control :shift :lock :meta)
  :shift-control-meta-rightdown)


;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/interactors.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs

;;; This file includes the design for mouse and keyboard interactors
;;;
;;; Designed and implemented by Brad A. Myers

#| 
============================================================
Change log:
         2/27/91 Brad Myers - Exported new function Warp-Pointer.
	 1/14/91 Brad Myers - changed :custom to call the function, rather than
                              looking it up as a method, and doesn't check
                              the window of the object.
	 10/11/90 Brad Myers - added Stop-Interactor
	  9/21/90 Brad Myers - fixed final-feedback so works if :start-where returns
				:none and when :start-where is T.
			    Exported new procedures:
				Return-Final-Selection-Objs, gv-Final-Selection-Objs
				DeSelectObj, SelectObj
          7/26/90 Brad Myers - Added :custom branch to check-location
          7/25/90 Brad Myers - destroy-me removes inter from aggregadget
          7/11/90 Ed Pervin - new :destroy-me method
	  6/5/90 Brad Myers - export new transcript functions
	  4/9/90 Robert Cook - Changed append to copy-list.
	  4/9/90 Brad Myers - fixed so start-event can be T and interactor
				will start when created and won't stop.
	  3/6/90  Brad Myers - :type in start-where can be a list,
				export Insert-Text-Into-String
         12/11/89 Ed Pervin - Exporting *garnet-break-key*
         12/5/89  Ed Pervin - Removed extra `)'
         11/16/89 Brad Myers - Extra debugging output in general-go
         11/14/89 Ed Pervin - In Start-Interactor, added test to handle
                              when event is NIL.
         11/7/89  Ed Pervin - Main-event-loop, exit-main-event-loop and 
                              beep are exported.
         11/1/89  Ed Pervin - Split up check-location so it would compile
                              on Sun.
	 10/26/89 Brad Myers - Add new function Abort-Interactor
	 10/19/89 Brad Myers - If tracing any then also trace :events
	 10/5/89 Brad Myers - If window is NIL, then don't run interactor,
				Add new slots :first-obj-over, :start-char
				Change *event* to *Current-Event*
	 10/4/89 Roger Dannenberg - Change debugging output
	 8/15/89 Brad Myers - Added :list-leaf-element-of-or-none and
				    :list-element-of-or-none,
				    :list-check-leaf-but-return-element-or-none
				    :check-leaf-but-return-element-or-none
	 8/14/89 Brad Myers - Added multiple priority levels,
				exported event procedures
	 7/20/89 Brad Myers - Added new check-locations:
				:list-check-leaf-but-return-element
				:check-leaf-but-return-element
	 7/3/89 Brad Myers - Allow interactors to have multiple values in
				the window slot
	 6/26/89 Brad Myers - Fixed to have quote for create-schema
	 6/21/89 Brad Myers - Added :list-leaf-element-of
	 6/9/89 Brad Myers - New procedure to cause an interactor to start
				without waiting for its start event
	 5/26/89 Brad Myers - Allow stop-event and running-where to be set at any
				time. call-method => kr-send
	 5/19/89 Brad Myers - Removed all get-local-values (except for :state) so
				will work as prototypes
         5/11/89 Brad Myers - Make steal-mouse queue run all interactors there
         4/25/89 Brad Myers - Added :leaf-element-of-or-none
         4/19/89 Brad Myers - *schema-call -> call-method
			      *fixed so no update call if interactor destroyed,
			      *Window for interactor can be specified after created
			      *Fixed :in-box
         4/13/89 Brad Myers - add :list-element-of, fixed change-active
         4/7/89 Brad Myers - changed to new KR; merged Lynn's changes from 3/30
         4/5/89 Brad Myers - small change to get-gob-of-where for where=T
         3/30/89 Lynn Baumeister - altered code to work with portable events
         3/28/89 Brad Myers - make window slot be
		inheritable (in Check-Required-Slots), and fixed destroy to
		look at the erase field so hopefully it will be more robust
         3/2/89 Brad Myers - removed create and destroy procedures
         2/24/89 Brad Myers - add point-to-leaf and NIL in Check-location
         2/15/89 Lynn Baumeister - altered check-event big-time
         2/15/89 Lynn Baumeister - changed interactor funcs to receive an event 
                                   instead of just x,y 
         1/15/89 Lynn Baumeister - merged button-down, key-pressed, and button-up
                                   queues into one queue
	12/22/88 Brad Myers - moved calc-set-value to menuinter

	11/28/88 Brad Myers - changed to new Opal, moved Menus to their own file
	8/17/88 Brad Myers - moved to constraint version of KR
	7/24/88 Brad Myers - started 
============================================================
|#

(in-package "INTERACTORS" :use '("KR" "LISP") :nicknames '("INTER"))

;; the exported functions
(export '(
	                ;; entering and leaving main event loop
          #-sx main-event-loop
          #-sx exit-main-event-loop *garnet-break-key*

	  ;; waiting for an interaction to complete
	  ;; *** NOT WORKING YET Interaction-Complete Wait-Interaction-Complete

	  Change-Active Start-Interactor Abort-Interactor Stop-Interactor
	  		;; support for multiple priority levels
	  priority-level
	  normal-priority-level high-priority-level
	  running-priority-level
	  priority-level-list 
			;; the next ones are for debugging
	  Reset-Inter-Levels
          #-release-garnet Print-Inter-Levels
          #-release-garnet Print-Inter-Windows
	  #-release-garnet trace-inter
          #-release-garnet untrace-inter
	  		;; interactor event structure (copy of X's event structure)
	  *Current-Event* *Garnet-Break-Key*
	  event-x event-y event-char event-code event-mousep
	  event-downp event-window event-timestamp make-event
	  		;; key translations for text-inter
	  Bind-Key Unbind-Key Unbind-All-Keys Set-Default-Key-Translations
	  		;;transcripting functions
	  Transcript-Events-To-File Close-Transcript
	  Transcript-Events-From-File
	  		;; useful utility functions
	  Clip-And-Map Beep Insert-Text-Into-String Warp-Pointer
          ;; functions for dealing with selection for button and menu
	  Return-Final-Selection-Objs DeSelectObj SelectObj
	  		;; the various exported interactor types
	  interactor interactor-window button-interactor text-interactor
	  two-point-interactor move-grow-interactor menu-interactor
	  #-sx angle-interactor))

;;;============================================================
;;; Handy function
;;;============================================================

(defun Beep ()
  #-release-garnet"Causes a beep or bell to sound"
  (xlib:bell                 opal::*default-x-display*)
  (xlib:display-force-output opal::*default-x-display*)
)

(defun Warp-Pointer (window x y)
  #-release-garnet
"Move the cursor to the specified x y position in the window."
  (xlib:warp-pointer (g-value window :drawable) x y)
  (xlib:display-force-output
        (opal::display-info-display
		  (get-value window :display-info))))


;;;============================================================
;;;
;;; debugging aids:
;;;   if-debug is a macro for use around debugging code
;;;   trace-test is a (possibly expensive) test to enable selective tracing
;;;   trace-inter is a function to start tracing an interactor (T for all of them)
;;;   untrace-inter is a function to stop tracing an interactor or all of them

(defparameter *int-debug* NIL)    ; true if any debugging is enabled
(defparameter *int-trace* NIL)    ; list of interactors to be traced

(defparameter *Special-Trace-Values* '(:window :priority-level :mouse :event))

;;; test for selective tracing.  Put this around any print-out statements
;;;
;;; NOTE: inter is an interactor or may be one of: 
;;;    :window -- trace things about interactor windows (create, destroy, etc.)
;;;    :priority-level -- trace changes to priority levels
;;;    :mouse -- trace set-interested-in-moved and ungrab-mouse
;;;    :event -- show all events that come in

#-release-garnet
(defmacro if-debug (inter &rest body)
  `(when (and *int-debug* (trace-test ,inter))
     (let ((*print-pretty* NIL))
       ,@body)))

#+release-garnet
 (defmacro if-debug (inter &rest body)
   nil)

;;returns T or NIL based on whether should trace or not.  Should be same
;; test as in if-debug (used when debugging value being passed as a parameter)
#-release-garnet
(defmacro debug-p (inter)
  `(and *int-debug* (trace-test ,inter)))

#+release-garnet
(defmacro debug-p (inter))

;;; trace-test -- hook used to enable/disable fancy tracing
;;;
#-release-garnet
(defun trace-test (inter)
  (or (eq *int-trace* t) ;trace all
      (and inter (member inter *int-trace*))))

(proclaim '(special interactor)) ; defined below

;;; trace-inter -- trace a function (or all functions)
;;;
#-release-garnet
(defun trace-inter (&optional (trace-what :status))
  #-release-garnet
"Trace interactor execution.  (Inter:UnTrace-inter removes tracing.)
  Can be called more than once and adds new parameter to trace set.
  If no parameter, then prints what are tracing. Legal values for parameter are:
    T - trace everything
    an interactor - trace on that interactor
    NIL - untrace everything
    :window -- trace things about interactor windows (create, destroy, etc.)
    :priority-level -- trace changes to priority levels
    :mouse -- trace set-interested-in-moved and ungrab-mouse
    :event -- show all events that come in."
  (cond ((eq trace-what t)
	 (setf *int-trace* t))
	((eq trace-what :status) t)  ;; no argument provided
	((null trace-what)
	 (untrace-inter))
	((eq *int-trace* t)
	 (format t "Already tracing everything!~%"))
	((member trace-what *int-trace*)
	 (format t "Already tracing ~S~%" trace-what))
	((not (or (is-a-p trace-what interactor)
		  (member trace-what *Special-Trace-Values*)))
	 (format t "*** ~S is not an interactor or one of the special values:
	     T NIL ~{~s ~}
	 (Describe 'inter:Trace-Inter) for more information~%"
		 trace-what *Special-Trace-Values*))
	(t (push trace-what *int-trace*)
	   (pushnew :event *int-trace*)))  ; always trace events when
					   ; tracing anything else
  (setf *int-debug* (not (null *int-trace*)))
  *int-trace*)


;;; untrace-inter -- stop tracing an interactor (or all interactors)
;;;
#-release-garnet
(defun untrace-inter (&optional untrace-what)
"Turns off tracing on the parameter.  If no parameter supplied, then turns off
 all tracing.  See trace-inter for description of parameters."
  (cond ((or (eq untrace-what t) (null untrace-what))
	 (setf *int-trace* nil))
	((member untrace-what *int-trace*)
	 (setf *int-trace* (delete untrace-what *int-trace*)))
	(t
	 (format t "Not tracing ~S%" untrace-what)))
  ;;; only enable debugging if user is tracing some interactor
  (setf *int-debug* (not (null *int-trace*)))
  *int-trace*)

(Defun Error-Print (slotdesc value shouldbe inter)
  (Error "The ~a of the interactor ~s should be a ~a,~%     but it is ~s.~%~a"
	 slotdesc inter shouldbe value
	 (if (and value (atom value) )
  "  It is an atom, so maybe you quoted it, or if it is in an aggregadget,
  then maybe you forgot the comma in front."
  "")))



;;;============================================================
;;;   Macros to print debugging information

(defun dbprinter (slot obj val feedbackp)
  (format T "  * Setting ~s of ~s~a to ~s~%" slot obj
	  (if feedbackp " (Feedback-Obj)" "")
	  val))

#-release-garnet
(defmacro dbprint (slot obj val inter) 
  `(if-debug ,inter (dbprinter ,slot ,obj ,val NIL))) 

#-release-garnet
(defmacro dbprint-either (slot obj val inter feedbackp) 
  `(if-debug ,inter (dbprinter ,slot ,obj ,val ,feedbackp))) 

#-release-garnet
(defmacro dbprint-sel (obj val inter) 
  `(if-debug ,inter (dbprinter :selected ,obj ,val NIL)))

#-release-garnet
(defmacro dbprint-feed (slot obj val inter) 
  `(if-debug ,inter (dbprinter ,slot ,obj ,val T)))

#-release-garnet
(defun dbstrprinter (obj feedbackp)
  (format T "  * Setting :string of ~s~a to ~s and :cursor-index to ~s~%" obj
	  (if feedbackp " (Feedback-Obj)" "")
	  (g-value obj :string)
	  (g-value obj :cursor-index)))

#-release-garnet
(defmacro dbprint-str (obj inter feedbackp) 
  `(if-debug ,inter (dbstrprinter ,obj ,feedbackp)))



;;;============================================================
;;;
;;; Priority levels
;;;
;;;============================================================

(create-schema 'priority-level
	       (:local-only-slots '(:interactors NIL))
	       (:interactors NIL) 
	       (:active T) ; if NIL, then this level is totally ignored,
			   ; including its :stop-when field.  This can be a
			   ; formula, but if it changes to be NIL, interactors
			   ; will not be automatically aborted.  Use
			   ; change-active to get that behavior.
	       (:stop-when :if-any) ; choices are :if-any, :always, NIL
				; :if-any - then doesn't go down to the next
				; 	level if anything on this level runs.
				; :always - then never goes down to next level
				; NIL - never stops after this level (always goes on)
	       )

(create-schema 'normal-priority-level
	       (:is-a priority-level)
	       (:interactors NIL)
	       (:active T)
	       (:stop-when NIL))

(create-schema 'high-priority-level
	       (:is-a priority-level)
	       (:interactors NIL)
	       (:active T)
	       (:stop-when :if-any))

(create-schema 'running-priority-level
	       (:is-a priority-level)
	       (:interactors NIL)
	       (:active T)
	       (:stop-when :if-any))

(Defparameter priority-level-list
  (list running-priority-level high-priority-level normal-priority-level))

;;;============================================================
;;
;; useful macro
;;

(defmacro DeletePlace (item Place)
  `(setf ,Place (delete ,item ,Place)))

;;;============================================================

;; is this needed?
;;(proclaim '(function print-event)) ; defined just below

;; this defines event-x event-y event-char event-code event-mousep
;; event-downp event-window event-timestamp 
(defstruct (event (:print-function print-event))
  (window NIL)
  (char :leftdown)
  (code 1)
  (mousep t)
  (downp t)
  (x 0)
  (y 0)
  (timestamp 0))

#-release-garnet
(defun print-event (event stream depth)
  (declare (ignore depth))
  (format stream "#EV<CHAR:~s CODE:~s MOUSE:~s DN:~s X:~s Y:~s TIME:~s WIN:~s>"
	  (event-char event) (event-code event) (event-mousep event)
	  (event-downp event) (event-x event) (event-y event)
	  (event-timestamp event)(event-window event)))

(defparameter *Current-Event* (make-event))

(proclaim '(special all-inter-windows))

;;;============================================================
;;; Main, top level inter:interactor object
;;;============================================================

(Create-Schema 'interactor
	       	     (:current-state :start)
		     (:self-deactivate NIL)
		     (:window NIL) ; this slot used for interested-in-moved
				   ; and for destroy-window
		     (:active T)
		     (:continuous T)
		     (:final-function NIL)
		     (:waiting-priority normal-priority-level)
		     (:running-priority running-priority-level)
		     (:start-where :not-supplied)
		     (:start-event :leftdown)
		     (:stop-event NIL)
		     (:abort-event NIL)
		     (:running-where NIL)
		     (:start-action :not-supplied)
		     (:running-action :not-supplied)
		     (:stop-action :not-supplied)
		     (:abort-action :not-supplied)
		     (:outside-action :not-supplied)
		     (:back-inside-action :not-supplied)
		     (:feedback-obj NIL)
		     (:local-only-slots '(:current-state NIL) '(:window NIL)
					'(:operates-on NIL))
		     (:Go :not-supplied)  ; proc executed when events happen
		     (:Do-Start :not-supplied)       ; these are
		     (:Do-Running :not-supplied)     ;   called by GO
		     (:Do-Stop :not-supplied)        ;   to do
		     (:Do-Abort :not-supplied)       ;   the real work.
		     (:Do-Outside :not-supplied)     ;   They call the
		     (:Do-Back-Inside :not-supplied) ;   appropriate
		     (:Do-Outside-Stop :not-supplied);   -action procedures
		     (:initialize 'Top-Interactor-Initialize)) ;proc to call
							   ; when created



;;;============================================================
;;; Exported procedures
;;;============================================================

;;; Call this to change the active slot of an interactor or of an interactor
;;; priority-level.  New-Value should
;;; be T or NIL.  This procedure will make
;;; sure that the interactor (or all the interactors at the priority level) are
;;; aborted if becoming in-active.  If you just set the :active slot directly,
;;; this won't necessarily happen
;;;
;;; If the new-value is not supplied, then the current value is used.  This
;;; is useful if the active value is computed from a formula, but the
;;; interactor won't notice the value change unless change-active is called
;;; (or a new event comes in).  This is the case when one interactor causes
;;; the active field of a different interactor to change.  If in the future
;;; we can get notified when a field changes values (e.g. with eager
;;; evaluation) then this will not be needed.

(defun Change-Active (inter-or-level &optional
				    (new-value (g-value inter-or-level :active)))
  #-release-garnet
"Call this to change the status of an interactor or interactor priority-level
immediately.  If Active=T then will run, if active=NIL, then will not run."
  (cond ((is-a-p inter-or-level interactor)
	 (if new-value
	     (progn
	      #-release-garnet(if-debug inter-or-level
		(format T "Change interactor ~s TO active~%" inter-or-level))
	      (s-value inter-or-level :active T))
	     (progn
	         #-release-garnet
                 (if-debug inter-or-level 
		 (format T "Change interactor ~s TO IN-active~%" inter-or-level))
	       (s-value inter-or-level :active NIL)
	       (unless (eq :start (get-local-value inter-or-level :current-state))
		 (Kr-Send inter-or-level :Do-abort inter-or-level T NIL)
		 (opal:update-all)))))
	((is-a-p inter-or-level priority-level)
	 (if new-value 
	     (progn
	       #-release-garnet(if-debug :priority-level
			 (format T "Change priority level ~s TO active~%"
				 inter-or-level))
	       (s-value inter-or-level :active T))
	     (progn
	       #-release-garnet(if-debug :priority-level
			 (format T "Change priority level ~s TO IN-active~%"
				 inter-or-level))
	       (s-value inter-or-level :active NIL)
	       (dolist (inter (g-value inter-or-level :interactors))
		 (unless (eq :start (get-local-value inter :current-state))
		   (Kr-Send inter :Do-abort inter T NIL)))
	       (opal:update-all))))
	 (t (error "change active on object not interactor or priority level"))))

;;; Causes the interactor to start running (go from :start state to
;;; :running state) without waiting for the start event.  This does nothing
;;; if the interactor is already running or if it is not active.
;;;
;;; If an event is passed in, then this is used as the x and y location to
;;; start with.  If the event is T (the default), then the last event that
;;; was processed is re-used.  Events are defined in i-windows.lisp and not
;;; exported.  Only the x and y fields of the event are really needed.  If
;;; the other fields are there also, then the event is also used to calculate
;;; the stop event (needed if the start-event is
;;; a list).  If the position of the event is not inside the object, then the
;;; start object for the interactor will be NIL, which might be a problem
;;; (especially for button-interactors, for example)
;;;
;;; NOTE: If the interactor being started should not start by itself,
;;; its start-where can be set to NIL.
;;;
(defun Start-Interactor (an-interactor &optional (event T))
  #-release-garnet
"Causes an interactor to start running without waiting for the start event.
Event can be T to use the previous event."
  #-release-garnet(if-debug an-interactor
	    (format T "~% Starting ~s with event ~s~%" an-interactor event))
  (when (and (g-value an-interactor :active)
	     (eq :start (g-value an-interactor :current-state)))
    ;; first fix the generated stop-event of the interactor
    (when (eq T event)
      (setq event *Current-Event*))  ; this is the last event
    ; processed
    (unless (and event (check-event event :start-event an-interactor))
      ;; have to generate stop event here
      (Set-Invented-stop-event an-interactor))
    (let ((obj (when event (check-location event :start-where an-interactor))))
      ;; obj will sometimes be NIL, hope that's OK
      ;; first set the special slots of the interactor
      (s-value an-interactor :current-window (when event (event-window event)))
      (s-value an-interactor :first-obj-over obj)
      (s-value an-interactor :start-char (when event (event-char event)))
      ;; now start
      (Kr-Send an-interactor :Do-start an-interactor obj event))
    (opal:update-all)))

;;;; This procedure aborts the interactor if it is running.  This is like
;;;; calling (Change-Active inter NIL) except that it does not become
;;;; in-active (so it is ready to run again.)
(defun Abort-Interactor (inter)
  #-release-garnet
"Call this to abort the interactor if it is running."
  #-release-garnet(if-debug inter
	    (format T "Aborting interactor ~s explicitly~%" inter))
  (unless (eq :start (get-local-value inter :current-state))
    (Kr-Send inter :Do-abort inter NIL NIL)
    (opal:update-all)))

;;;; This procedure stops the interactor if it is running.  This is like
;;;; hitting the stop event, except that the previous value for the
;;;; interactor is used.  There are special messages in each interactor
;;;; type to allow stopping explicitly, since each one needs to do
;;;; something different to re-use the last value.
(defun Stop-Interactor (inter)
  #-release-garnet
"Call this to stop the interactor if it is running."
#-release-garnet  (if-debug inter
	    (format T "Stopping interactor ~s explicitly~%" inter))
  (case (get-local-value inter :current-state)
    (NIL NIL) ; ignore this object if state is NIL
    (:start NIL) ; if not running, just leave alone
    (:outside (if (eq :last (g-value inter :outside))
		 (Kr-Send inter :Do-explicit-stop inter)
		 (Kr-Send inter :Do-abort inter NIL NIL)))
    (:running (Kr-Send inter :Do-explicit-stop inter))
    (T (error "**illegal state for ~s in Stop-Interactor" inter)))
  (opal:update-all))


;;;============================================================
;;; Top level initialize routine
;;;============================================================
(defun Top-Interactor-Initialize (self)
  (declare (ignore self))
  (error "** Cannot create an instance of a top-level interactor"))

;;;============================================================
;;;Utility procedures for the various create procedures
;;;============================================================

;;;returns T if schema :is-a typ, otherwise raises an error
(defun Check-Interactor-Type (schema typ)
  (if (is-a-p schema typ)
      T
      (error "** Wrong type: Is a ~s, Not a ~s" (g-value schema :is-a) typ)))

(proclaim '(special interactor-window)) ; defined in i-windows

;;;Checks if schema was created with all the required slots.  If not, then
;;; raises an error
(defun Check-Required-Slots (schema)
  (let ((win (g-value schema :window))
	(start-where (g-value schema :start-where)))
    (cond ((null win)) ; fine
	  ((schema-p win)
	     (unless (is-a-p win interactor-window)
	       (error "** Window must be an interactor-window.")))
	    ((eq T win)) ; fine
	    ((listp win) ; then check each one 
	     (dolist (w win)
	       (unless (schema-p w)
		 (Error-Print ":Window in List" w "Inter:Interactor-window" schema))
	       (unless (is-a-p w interactor-window)
		 (error "** Each window in list must be an interactor-window."))))
	    (t (Error-Print ":Window" win "Inter:Interactor-window" schema)))
    (unless (is-a-p (g-value schema :waiting-priority) inter:priority-level)
      (Error-Print ":Waiting-Priority" (g-value schema :waiting-priority)
		   "inter:priority-level" schema))
    (unless (is-a-p (g-value schema :running-priority) inter:priority-level)
      (Error-Print ":Running-Priority" (g-value schema :running-priority)
		   "inter:priority-level" schema))
    (when (g-value schema :steal-mouse)
      (format T "~% **** Interactor ~s has a :STEAL-MOUSE slot, which is no
      longer used.  You probably want to use :waiting-priority instead. ****~%"
	      schema))
    (when (eq start-where :not-supplied)
      (error "** start-where must be supplied"))
    (when (and (listp start-where)
	       (eq '* (cadr start-where)))
      (error "** start-where cannot use '* (only running-where)"))))

;;;sets up the default values for slots.
(defun Set-Up-Defaults (schema)
  (when (eq t (g-value schema :feedback-obj))
    (error "** Sorry, creating a default feedback obj NIY ****"))
  (s-value schema :current-state :start) ; this slot must be local
  (Add-to-level schema NIL NIL)
  (when (and (eq T (g-value schema :start-event))
	     (g-value schema :active)) ; then make window start looking for
				       ; mouse moved events
    (turn-on-mouse-moved schema))
  )

;;;pulls the aggregate object out of the :where field specified
(defun Get-Gob-Of-Where (where)
  (cond ((null where) NIL)
	((eq where T) T)
	((listp where)
	 (case (first where)
	   ((:in :in-box :element-of :list-element-of
                 #-sx :in-but-not-on #-sx  :full-object-in
		 #-sx :element-of-or-none #-sx :leaf-element-of
                 :custom
		 :leaf-element-of-or-none
                 #-sx :list-leaf-element-of
		 #-sx :list-check-leaf-but-return-element
                 #-sx :check-leaf-but-return-element
		 #-sx :list-element-of-or-none
                 #-sx :list-leaf-element-of-or-none
		 #-sx :list-check-leaf-but-return-element-or-none
		 #-sx :check-leaf-but-return-element-or-none
		 )
	    (second where))
	   (otherwise (error "** Unknown keyword in Where"))))
	(T (error "** Bad where, should be T, NIL, or a list"))))

;;;============================================================
;;;Utility procedures handling the priority levels for interactors
;;;============================================================

;; useful for debugging
#-release-garnet
(defun Print-Inter-Levels ()
"Prints out the interactor priority levels (for debugging)"
  (let ((*print-pretty* NIL))
    (dolist (level priority-level-list)
      (format T "~%Level ~s: ~s~%" level (g-value level :interactors)))))

;;; useful for debugging, gets rid of all interactors.  Doesn't destroy them, but
;;; simply removes them from the levels.
 #-release-garnet
(defun Reset-Inter-Levels (&optional level)
"Removes all interactors from all a level, or all levels if none supplied
 (for debugging)"
  (if level
      (s-value level :interactors NIL)
      ;; otherwise, restore to original levels
      (progn
	(s-value running-priority-level :interactors NIL)
	(s-value high-priority-level :interactors NIL)
	(s-value normal-priority-level :interactors NIL)
	(setq priority-level-list
	      (list running-priority-level high-priority-level
		    normal-priority-level)))))

;;; checks to see if the actor should be destroyed when the window is.  This has
;;; a side-effect of removing the window from the interactor's window list, if
;;; it is in there.

(defun Check-actor-delete-window (win actor)
  (let ((interwin (g-value actor :window)))
    (cond ((schema-p interwin)(eq interwin win)) ; if just one, return eq'ness
	  ((null interwin) NIL) ; don't delete interactor if its window slot is nil
	  ((listp interwin) ; if list, return if no more windows for this inter
	   (null (deleteplace win (g-value actor :window))))
	  (t NIL)))) ; otherwise, don't delete it

;; destroys all the interactors on the window
;; *** be careful not to destroy something twice, since it may be on different
;; priority levels multiple times.
;; Note, this is implemented not very intelligently, but does not need to be
;; efficient.

(defun destroy-all-interactors (window)
  (if-debug :window
	    (format T "Destroy all interactors for win ~s~%" window))
  (dolist (level priority-level-list)
    (dolist (inter (copy-list (g-value level :interactors))) ; make a copy of top
							  ; level since might be
							  ; modified by the destroy
      (when (and (schema-p inter) (Check-actor-delete-window window inter))
	(opal:destroy inter NIL)))))

;;; Tells X to start reporting move events for the window of the
;;; interactor.  If the interactor has multiple windows, then turns on move
;;; events in all of them, and ungrabs the mouse.
(defun turn-on-mouse-moved (actor)
  #-release-garnet
  (if-debug actor (format T "turning on mouse-moved for ~s, win=~s~%"
			  actor (g-value actor :window)))
  (let ((win (g-value actor :window)))
    (when win
      (cond ((schema-p win)
	     (pushnew actor (g-value win :current-want-moved-interactors))
	     (set-interest-in-moved win T))  ; OK to set if already interested
	    ((eq T win) ; do all windows
	     (ungrab-mouse (or (event-window *Current-Event*)
	     		       (car all-inter-windows)))
	     (dolist (w all-inter-windows)
	       (pushnew actor (g-value w :current-want-moved-interactors))
	       (set-interest-in-moved w T)))
	    ((listp win) ; then do each one 
	     (ungrab-mouse (or (event-window *Current-Event*)
			       (car win)))
	     (dolist (w win)
	       (pushnew actor (g-value w :current-want-moved-interactors))
	       (set-interest-in-moved w T)))
	    (t (error "Window slot of inter ~s has wrong form" actor))))))

;;; Checks to see if should turn off mouse moved events from the window(s)
;;; because the specified interactor is no longer running, and if so, does it
(defun turn-off-mouse-moved (actor)
  (if-debug actor (format T "Turn off mouse moved for ~s~%" actor))
  (let ((win (g-value actor :window)))
    (when win
      (cond ((schema-p win)
	     (when (null
		    (deleteplace actor
				 (g-value win :current-want-moved-interactors)))
	       (set-interest-in-moved win NIL))) ; turn it off if no more
	    ((eq T win)  ; do all windows
	     (dolist (w all-inter-windows)
	       (when (null
		      (deleteplace actor
				   (g-value w :current-want-moved-interactors)))
		 (set-interest-in-moved w NIL))))
	    ((listp win) ; then do each one 
	     (dolist (w all-inter-windows)
	       (when (null
		      (deleteplace actor
				   (g-value w :current-want-moved-interactors)))
		 (set-interest-in-moved w NIL))))
	    (t (error "Window slot of inter ~s has wrong form" actor))))))
	
(defun add-actor (actor priority-level)
  #-release-garnet
  (if-debug :priority-level
	    (format T "adding ~s to priority level ~s~%" actor priority-level))
  (pushnew actor (g-value priority-level :interactors)))

(defun remove-actor (actor priority-level)
  #-release-garnet  (if-debug :priority-level
	    (format T "removing ~s from priority level ~s~%" actor priority-level))
  (deleteplace actor (g-value priority-level :interactors)))


(defun Remove-from-all-levels (an-interactor)
  #-release-garnet  (if-debug :priority-level (format T "removing ~s from all levels~%" an-interactor))
  (dolist (level priority-level-list)
    (remove-actor an-interactor level)))

;;; Adds the schema to the correct level and turns on mouse moved events,
;;; if necessary
(defun Add-to-level (an-interactor running-p need-mouse-moved)
  (add-actor an-interactor (if running-p
			       (g-value an-interactor :running-priority)
			       (g-value an-interactor :waiting-priority)))
  (when need-mouse-moved (turn-on-mouse-moved an-interactor)))

;;;removes from running or non-running level

(defun remove-from-level (an-interactor running-p)
  (remove-actor an-interactor (if running-p
			       (g-value an-interactor :running-priority)
			       (g-value an-interactor :waiting-priority)))
  (when (and running-p
	     ;;check to see if there is no start event, in which case,
	     ;;should always be running, so don't turn off.
	     (or (not (eq T (g-value an-interactor :start-event)))
		 (not (g-value an-interactor :active))))
    (turn-off-mouse-moved an-interactor)))
  

;;;============================================================
;;;Middle level dispatcher for events; called from i-windows
;;;============================================================

;; do all the steal-mouse interactors, and if at least one of them runs,
;; then quit, otherwise, run all of the check-all interactors
(defun Process-Event (event)
  (let (found-one)
    (when event
      (dolist (level priority-level-list)
	  #-release-garnet(if-debug :priority-level
		  (format T "~%------Doing priority level ~s~%" level))
	(if (g-value level :active)
	    (progn
	      (setf found-one NIL)
	       ; make a copy of top level since might be modified
	      (dolist (actor (copy-list (g-value level :interactors)))
		(when (kr-send actor :go actor event)
		  (setf found-one T))))
	    ; else print that skipped
	    #-release-garnet (if-debug :priority-level
		  (format T "   **Skipped because this level is not active~%")))
	  (case (g-value level :stop-when)
	    (:if-any (when found-one (return)))
	    (:always (return))
	    ((NIL) NIL) ; NIL means always go on to next
	    (t (error "bad :stop-when: ~s in priority level ~s"
		      (g-value level :stop-when) level)))))))

;; these all do the same thing, information is already coded into the event.
(defmacro button-pressed (event)
  `(Process-Event ,event))
(defmacro button-released (event)
  `(Process-Event ,event))
(defmacro key-pressed (event)
  `(Process-Event ,event))
(defmacro mouse-moved (event)
  `(Process-Event ,event))

;;;============================================================
;;; Utility procedures for the GO procedures
;;;============================================================

; return the item after the parameter in the sequence or NIL if not there
(defun GetNextItem (item sequence)
  (let ((index (position item sequence)))
    (when index (nth (1+ index) sequence))))

;;; Running where can either be supplied or generated.  If generated, it
;;; might be from start-where or if running-where was (:xx *).
;;; See Fix-Running-Where for full details
(defun Get-Running-where (an-interactor)
  (or (get-local-value an-interactor :generated-running-where)
      (g-value an-interactor :running-where)))


;; Check to see if obj is a type.  Type can be a list, in which case checks
;; to see if obj is any of the types in the list.
(defun checkobjtype (obj type)
  (cond ((eq t type) t)
	((listp type) (dolist (ty type)
			(when (is-a-p obj ty)
			  (return-from checkobjtype T))) NIL)
	(t (is-a-p obj type))))
      
(defun list-element-of-branch (agg control slot type win x y)
  (let ((lst (g-value agg slot)))
    (or (dolist (i lst)
	  (when (and (checkobjtype i type)
		     (eq (g-value i :window) win)
		     (opal:point-in-gob i x y))
	    (return i)))
	;if loop doesn't return anything, then return :none if
	;supposed to
	(if (eq control :list-element-of-or-none)
	    :none
	    NIL))))

    
#-sx
(defun list-leaf-element-of-branch (agg control slot type win x y)
  (let ((lst (g-value agg slot))
	ret)
    (or (dolist (i lst)
	  (when
	      (and (eq (g-value i :window) win)
		   (if (is-a-p i opal:aggregate)
		       ; if aggregate, then if point-to-leaf
		       (progn
			 (setq ret (kr-send i :point-to-leaf i x y
					    :type type))
			 (when (and ret
				    (or (eq control
					    :list-check-leaf-but-return-element)
					(eq control
					    :list-check-leaf-but-return-element-or-none)))
			   (setq ret i))
			 ret)
		       ; if not aggregate, then if inside
		       (progn
			 (when (and (checkobjtype i type)
				    (opal:point-in-gob i x y))
			   (setq ret i)))))
	    (return ret)))
	;if loop doesn't return anything, then return :none if
	;supposed to
	(if (or (eq control :list-leaf-element-of-or-none)
		(eq control :list-check-leaf-but-return-element-or-none))
	    :none
	    NIL))))

#-sx
(defun check-leaf-but-return-element-branch (agg an-interactor control type win x y)
  (when (opal:point-in-gob agg x y)
    ; otherwise, return NIL always
    (opal:do-components agg
	#'(lambda (child)
	    (when (and (eq (g-value child :window) win)
		       (if (is-a-p child opal:aggregate)
			   ; if aggregate, then if point-to-leaf
			   (kr-send child :point-to-leaf child x y
				    :type type)
			   ; if not aggregate, then if inside
			   (and (checkobjtype child type)
				(opal:point-in-gob child x y))))
	      (if-debug an-interactor
			(format T " ** SUCCESS: ~s~%" child))
	      (return-from check-leaf-but-return-element-branch child))))
    ; if get here, then didn't find anything, return NIL or :none
    (if (eq control :check-leaf-but-return-element-or-none)
	:none
	NIL)))


;;;checks to see if x,y is inside where
;;; returns the object under the mouse if passes.  If where is :element-of,
;;; this will be the element object.  If where is :in or :in-box, then will
;;; be the object itself.  Returns NIL if fails
;;;  ******** BUG ***NO WAY FOR OVERLAPPING OBJECTS TO HIDE EACH OTHER FROM
;;;  ********* THE MOUSE!  (Have to use priority levels)
(defun check-location (event which-where an-interactor)
  (let ((where (case which-where
		 (:start-where (g-value an-interactor :start-where))
		 (:running-where (Get-Running-where an-interactor))
		 (t (error "bad which-where"))))
	result)
  #-release-garnet    (if-debug an-interactor
	      (format T "Checking ~s = " which-where))
    (setq result
      (cond ((eq t where) t)  ;; T means anywhere in the window
	    ((null where) NIL) ;; NIL as where means failure, useful to have
			  ;; interactor not run (e.g, start-where is a formula)
	    ((listp where)
	     (let ((x (event-x event))
		   (y (event-y event))
		   (win (event-window event))
		   (control (first where))
		   (agg (second where))
		   (type (or (GetNextItem :type where) T)) ; T as type => everything
		   objwin slot)
	       (unless (schema-p agg)
		 (Error-Print (concatenate 'string "Object in :"
					   (symbol-name which-where))
			      agg "Opal Object" an-interactor))
	       (setf objwin (and agg (g-value agg :window)))
	       (if (or #-sx (eq control :list-element-of)
		       #-sx (eq control :list-leaf-element-of)
		       #-sx (eq control :list-check-leaf-but-return-element)
		       #-sx (eq control :list-element-of-or-none)
		       #-sx (eq control :list-leaf-element-of-or-none)
		       #-sx (eq control :list-check-leaf-but-return-element-or-none)
		       (eq control :custom))
		; If a list, then objects might be in different
  	        ; windows, so do test inside the case statement.
		; If Custom, let the user's procedure do the test.
		   (setf slot (third where))
		   ;; else check if window of object eq window of event
		   (unless (eq win objwin) ; otherwise test here
		      (if-debug an-interactor
			 (format T " **WINDOWS DON'T MATCH** ev-win=~s obj-win=~s~%" 
				 win objwin))
		      (return-from check-location NIL)))
	       (if-debug an-interactor (format T "~s of ~s" control agg)
			 (when slot (format T " slot ~s" slot)))
	       (case control
		 (:custom ; function from (third where) copied into "slot"
		  (apply slot agg an-interactor event (cdddr where)))
		 (:element-of
		  (kr-send agg :point-to-component agg x y :type type))
		 #-sx ((:list-element-of
		   :list-element-of-or-none)
		  (list-element-of-branch agg control slot type win x y))
		 #-sx ((:list-leaf-element-of
		   :list-check-leaf-but-return-element
		   :list-leaf-element-of-or-none
		   :list-check-leaf-but-return-element-or-none)
                  (list-leaf-element-of-branch agg control slot type win x y))
		 #-sx ((:check-leaf-but-return-element
		   :check-leaf-but-return-element-or-none)
                  (check-leaf-but-return-element-branch agg an-interactor
							control type win x y))
		 #-sx (:leaf-element-of
		  (kr-send agg :point-to-leaf agg x y :type type))
		 (:leaf-element-of-or-none   ;if in agg, then :none or object over
		  (if (opal:point-in-gob agg x y)
		      (or (kr-send agg :point-to-leaf agg x y :type type)
			  :none)  ; return :none if inside and no child
		      ; else return NIL if not in agg
		      NIL))
		 (:in-box
		  ; the top level point-in-gob method uses the bounding
		  ; rectangle, whereas the specific object may have a special
		  ; procedure
		  (and (kr-send opal:view-object :point-in-gob agg x y)
		       agg))    ;return agg if in box
		 (:in
		  (and (opal:point-in-gob agg x y)
		       agg))  ;return agg if in
		 #| **** NIY **********************
		 (:full-object-in ;;entire object to move
		  (let ((obj (g-value an-interactor :obj-being-changed)))
		    (unless obj
		      (error "No object being changed for :full-object-in"))
		    (and (opal:gob-in-gob agg obj)
			 agg)))  ;return agg if in
		 ******************
		 |#
		 #-sx (:in-but-not-on
		  (and (not (kr-send agg :point-to-component agg x y
				     :type type))
		       (opal:point-in-gob  agg x y)
		       agg))
		 #-sx(:element-of-or-none ;if in agg, then :none or object over
		  (if (opal:point-in-gob agg x y)
		      (or (kr-send agg :point-to-component agg x y :type type)
			  :none)  ; return :none if inside and no child
		      ; else return NIL if not in agg
		      NIL))
		 (t (error "** illegal where control: ~s" where)))))
	  (t (Error-Print (symbol-name which-where) where "T, NIL or list"
			  an-interactor))))
    (if-debug an-interactor
	      (if result (format T " **SUCCESS=~s~%" result)
		  (format T " **FAIL**~%")))
    result))

(proclaim '(special *left-button* *middle-button* *right-button*))

;;;handles the transformation of simple down events to up events.
;; this may not be  the most elegant way of doing this, but for now it is acceptable
(defun Convert-mouse-down (button-code)
  (cond ((= *left-button* button-code) :any-leftup)
	((= *middle-button* button-code) :any-middleup)
	((= *right-button* button-code) :any-rightup)))


;;;checks to see if the event from the window manager (wm-event) matches
;;; the desired event event-descriptor.  If so, returns matching stop-event
;;;  or NIL
;;;
;;; No checking for illegal keywords, they just always fail
;;;
;;; Converting and checking are combined, because they both have to go through
;;; the same cases (for all the special keywords)
(defun compare-and-get-possible-stop-event (event event-desired)
  (let ((mousep (event-mousep event))
	(code (event-code event))
	(key-button (event-char event))
	(downp (event-downp event)))
    
    (cond ((eq event-desired key-button)
	   (or (convert-mouse-down code) key-button))
	  ((and (eq event-desired :any-keyboard) (not mousep)) #\RETURN)
	  
	  ((or (and (eq event-desired :any-mouseup) mousep (null downp))
	       (and (eq event-desired :any-mousedown) mousep downp))
	   :any-mouseup)
	  
	  ((and (eq event-desired :any-leftdown)
		mousep downp (eq code *left-button*)) :any-leftup)
	  ((and (eq event-desired :any-middledown)
		mousep downp (eq code *middle-button*)) :any-middleup)
	  ((and (eq event-desired :any-rightdown)
		mousep downp (eq code *right-button*)) :any-rightup)
	  
	  ((and (eq event-desired :any-leftup)
		mousep (null downp) (eq code *left-button*)) :any-leftup)
	  ((and (eq event-desired :any-middleup)
		mousep (null downp) (eq code *middle-button*)) :any-middleup)
	  ((and (eq event-desired :any-rightup)
		mousep (null downp) (eq code *right-button*) :any-rightup)))))
;; if none of these pass, then the event doesn't match
  

;;; This procedure generates a stop event for an interactor based on its
;;; :start-event.  This does not use an actual event from X, so it just picks
;;; a plausible stop event.  This is called from
;;; Start-Interactor which starts an interactor without a real event happening
#-sx
(Defun Set-Invented-stop-event (an-interactor)
  (unless (g-value an-interactor :stop-event) ; don't bother if there is one
    (s-value an-interactor :generated-stop-event
	     (list :any-mouseup #\RETURN))))  ; this seems safe: either a
					      ; mouse up or a CR

;;; Looks in the "which-event" field of the "interact" and compares that to
;;; actual-event.  This comparison is fairly tricky because of all the
;;; possible kinds of event descriptions (:any-xxx, lists with exceptions,
;;; etc.)  If this is a start-event, then generates a corresponding stop
;;; event, in case needed, and stores this in the interactor.
(defun Check-Event (actual-event which-event interact)
  (let ((result (Int-Check-event actual-event which-event interact)))
  #-release-garnet
   (if-debug interact
	      (if result (format T " **SUCCESS=~s~%" result)
		  (format T " **FAIL~%")))
    result))

(defun Int-Check-event (actual-event which-event interact)
    #-release-garnet(if-debug interact (format T "Checking ~s " which-event))

  (let ((stop-event nil)
	(events-desired (g-value interact which-event)))

    ;; check if actual-event is :mouse-moved
    (when (eq (event-char actual-event) :mouse-moved)
      (return-from int-check-event
		   (if (eq which-event :start-event) ; then see if T
		       (if (eq events-desired T) :maybe NIL)
		       ; else if not start-event, always return NIL for moved
		       NIL)))

    ;; actual-event is not mouse-moved  
    (when (and (null events-desired) (eq :stop-event which-event))
      ;; when null, use the generated default stop event, if any
      (setq events-desired (g-value interact :generated-stop-event)))

      #-release-garnet(if-debug interact (format T " against wanted ~s" events-desired))
    (cond ((eq events-desired T)
	   ;;; for :abort-event or :Stop-event, T means don't stop
	   (if (eq which-event :start-event)
	       (return-from int-check-event :maybe)
	       (return-from int-check-event NIL)))
	  ((null events-desired) (return-from int-check-event NIL))
	  ((listp events-desired)
	   ;; check the exceptions first
	   (dolist (exception (member :except events-desired))
	     (when (compare-and-get-possible-stop-event actual-event exception)
	       (return-from int-check-event nil)))
	   ;; check allowable events
	   (dolist (option events-desired)
	     (if (eq option :except) (return-from int-check-event nil)) 
	     (when (setf stop-event
			 (compare-and-get-possible-stop-event actual-event option))
	       (return))))  ; break out of the dolist loop
	  ;; here, not a list
	  (t (setf stop-event (compare-and-get-possible-stop-event actual-event
							   events-desired))))
    
        (when stop-event ; then should return T, otherwise NIL
	  (when (eq which-event :start-event)
		;;; set default stop-event in case needed
		(s-value interact :generated-stop-event stop-event))
	  t)))


;;; If running-where is empty, then copies :start-where.
;;; Otherwise, checks to see if running-where is of the form '(:xx *), then
;;; changes running-where to be '(:xx new-obj-over).
;;; This is called from every interactor's start procedure if it is continuous.
(defun Fix-Running-Where (an-interactor new-obj-over)
  (let ((r-w (g-value an-interactor :running-where))
	r-w-copy)
    (if (null r-w) ; then copy start-where
	(s-value an-interactor :generated-running-where
		 (G-Value an-interactor :start-where))
	;; start-where cannot use the '* form, so don't have to worry about
	;; that if copying the start-where into running where.
	;; otherwise, check if need to have a special, edited start-where
	(if (and (listp r-w) (eq '* (second r-w)))
	  ;; then need to substitute new-obj-over for *
	  (progn
	    (unless (and (setq r-w-copy
			       (get-local-value an-interactor
						:generated-running-where))
			 (not (eq (car r-w-copy)(car r-w))))
	      ;; make a copy of the running-where, in case it is inherited,
	      ;; since are going to destructively modify it
	      ;; BUG: if running-where changes to have a new :type or
	      ;; something, this will fail to notice it.
	      (setq r-w-copy (copy-list r-w)))
	    (if (eq T new-obj-over)
		(s-value an-interactor :generated-running-where T) ;then just use T
		(progn ; else use the copy
		  (setf (second r-w-copy) new-obj-over)
		  (s-value an-interactor :generated-running-where r-w-copy))))
	  ;; otherwise, remove generated-running-where.
	  ;; Destroy-slot checks whether slot is there or not.
	  (destroy-slot an-interactor :generated-running-where)))))

(defun GoToRunningState (an-interactor needMouseMoved)
  (s-value an-interactor :current-state :running)
  (remove-from-level an-interactor NIL)
  (add-to-level an-interactor T needMouseMoved))

(defun GoToStartState (an-interactor set-waiting-level)
  (s-value an-interactor :current-state :start)
  (when (g-value an-interactor :self-deactivate)
    (s-value an-interactor :active NIL))
  (when set-waiting-level
    (remove-from-level an-interactor T)
    (add-to-level an-interactor NIL NIL)))

  

;;;============================================================
;;; Main General go procedure
;;;============================================================

;;;This is the main action procedure that makes the most interactors go.
;;; This procedure implements the state machine.  It
;;; is called by the main dispatcher when an event happens.
;;; The Event is the value returned by the window manager.
;;; This procedure call the Do-xxx procedures in the
;;; interactor, which are specialized for the particular type of interactor.
;;; The do-xxx procedures in turn call the xxx-action procedures.  These
;;; -action procedures my be supplied by outside applications.
;;;
;;;The complexity in the state machine implementation is that the same
;;; event may cause 
;;; two things, e.g., both going outside and stop.  We cannot count of
;;; getting different events for this.
(defun General-Go (an-interactor event)
  (let ((state (get-local-value an-interactor :current-state))
	(active (g-value an-interactor :active))
	(window (g-value an-interactor :window))
	(event-window (event-window event)))
  #-release-garnet    (if-debug an-interactor
      (format T "~%enter GO for ~s, state=~s...~%"
	      an-interactor state))
    (unless state
  #-release-garnet      (if-debug an-interactor
		(format T "returning because state=NIL~%"))
      (return-from General-Go NIL)) ; quick return if state is NIL (which
				    ; means that the interactor has been destroyed)
    ;; now, must have both :active and :window as Non-NIL
    (unless (and active window)
      (unless (eq :start state)
  #-release-garnet
       (if-debug an-interactor (format T "** Implicit become inactive~%")) 
	(Kr-Send an-interactor :Do-abort an-interactor T event)
	(opal:update-all))
  #-release-garnet      (if-debug an-interactor
		(format T "returning because ~a in inter is NIL~%"
			(if active ":window" ":active")))
      (return-from General-Go NIL)) ; return NIL
    (cond ((schema-p window)
	   (when (not (eq window event-window))
  #-release-garnet	     (if-debug an-interactor
		       (format T "returning because window doesn't match~%"))
	     (return-from General-Go NIL)))
	  ((eq T window)) ; then just go on
	  ((listp window) ; then check if member
	   (unless (member event-window window)
  #-release-garnet	     (if-debug an-interactor
		       (format T "returning because window ~s isn't in list ~s~%"
                               event-window window))
	     (return-from General-Go NIL)))
	  (t (error "Window slot of inter ~s has wrong form" an-interactor)))

    ;; Finished preliminary tests, now get to work
    (let (obj should-stop)
      (case state
	(:start (s-value an-interactor :current-window event-window)
		(if (and (check-event event   ; return of :maybe OK here
				      :start-event an-interactor)
			 (setf obj
			       (check-location event :start-where an-interactor)))
		    (progn
		      ;; these next two slots might be used in formulas
		      (s-value an-interactor :first-obj-over obj)
		      (s-value an-interactor :start-char (event-char event))
		      (Kr-Send an-interactor :Do-start an-interactor obj event))
		    ; else exit and return NIL
		    (return-from general-go NIL)))
	(:running (s-value an-interactor :current-window event-window)
		  (if (check-event event :abort-event an-interactor)
		      (Kr-Send an-interactor :Do-abort an-interactor NIL event)
		      (progn
			(setf obj
			      (check-location event :running-where an-interactor))
			(setf should-stop
			      (check-event event :stop-event an-interactor))
			
			(if (null obj) ;went outside
			    (progn
			      (Kr-Send an-interactor :Do-outside an-interactor)
			      (when (eq should-stop T)
				(Kr-Send an-interactor :Do-outside-stop
					 an-interactor event)))
			    ;here still inside; obj is ok
			    (if (eq should-stop T)
				(Kr-Send an-interactor :Do-stop
					     an-interactor obj event)
				(Kr-Send an-interactor :Do-running
					     an-interactor obj event))))))
	(:outside (s-value an-interactor :current-window event-window)
		  (if (check-event event :abort-event an-interactor)
		      (Kr-Send an-interactor :Do-abort an-interactor NIL event)
		      (progn
			(setf obj
			      (check-location event :running-where an-interactor))
			(setf should-stop
			      (check-event event :stop-event an-interactor))
			(if (null obj) ;still outside
			    (when should-stop
			      (Kr-Send an-interactor :Do-outside-stop
					   an-interactor event))
			    ;go back inside; obj is ok
			    (progn
			      (Kr-Send an-interactor
					   :Do-back-inside an-interactor
					   obj event)
			      (when should-stop
				(Kr-Send an-interactor :Do-stop
					     an-interactor obj event)))))))
	(otherwise (error "** illegal state ~s" state)))))
  (opal:update-all) ; update all windows
  T)  ;return T


;;;============================================================
;;; Exported procedures
;;;============================================================

;;; If erase is T, then aborts the interactor.  This may not be necessary,
;;; for example if the window is about to be destroyed.
;;; It is more robust to have erase NIL.
(define-method :destroy-me interactor (an-interactor &optional (erase T))
  #-release-garnet  (if-debug an-interactor
	    (format T "Interactor Destroying ~s erase=~s~%" an-interactor erase))
  (when erase
    (change-active an-interactor NIL))
  (Remove-from-all-levels an-interactor)
  (let ((in-obj (get-local-value an-interactor :operates-on)))
    (when in-obj
  #-release-garnet      (if-debug an-interactor
		(format T "Removing me from object ~s~%" in-obj))
      (kr-send in-obj :remove-local-interactor in-obj an-interactor)))
  (destroy-schema an-interactor))

(define-method :destroy interactor (an-interactor &optional (erase T))
  (dolist (instance (copy-list (get-local-values an-interactor :is-a-inv)))
     (kr-send instance :destroy instance erase))
  (kr-send an-interactor :destroy-me an-interactor erase))

#|
============================================================
Future: Make move-grow, etc not eat keyboard events, and keyboard
interactors not eat mouse events.
============================================================
|#

;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/i-windows.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs

#|
============================================================
Change log:
    8/2/90 Ed Pervin - Calls to Reparent-Notify must pass along event-window.
    7/25/90 Ed Pervin - Fixed bug so main-event-loop won't crash if you
			call it before you've ever created a window.
    7/11/90 Ed Pervin - new :destroy-me method
    7/2/90 Pervin  If an expose event occurs, just refresh the parts
                   of the window that were exposed.
    6/7/90 Brad Myers - Create and read back a transcript of events
    6/5/90 Brad Myers - fixed bug where motion events got the wrong window
    5/8/90 Sannella - In Motion-Notify, discard extra events.
    4/9/90 Pervin/Cook - Some changes to main-event-loop to work better in Lucid.
			 Also indented lines starting with #+cmu or #-cmu.
    3/22/90 Robert Cook - Changed #+(or allegro lcl3.0) to
			  #+(or allegro lcl3.0 explorer).
    2/22/90  Brad Myers - removed the :exposure from *report-motion-pem
			  that was causing errors in some CLX's
    12/13/89 Ed Pervin changed #+lcl3.0 to #+(or allegro lcl3.0) in one spot.
    12/11/89 Ed Pervin - hitting *garnet-break-key* exits main event loop in Lucid.
                        Uncommented a loop in Motion-Notify so as to throw away
			unnecessary motion events in Lucid 3.0.
    12/5/89 Ed Pervin - added a couple ignore declarations
    11/7/89 Ed Pervin - all changes marked by #-cmu
    10/6/89 Brad Myers - change name of *event* to *Current-Event* and
			export it
    10/4/89 Roger Dannenberg - Change debugging output
    8/23/89 Brad Myers - Moved event record to interactors.lisp and made
			destroy on the window only have one parameter.
    7/11/89 David Kosbie and Brad Myers - faster updates
    7/3/89 Brad Myers - Save a list of all interactor windows
    6/26/89 Brad Myers - Fixed to have quote for create-schema
    4/19/89 Brad Myers - *schema-call -> call-method, etc.
		      *Window in event record
    4/10/89 lkb -- event-downp now set correctly in Button-Press
    4/7/89 Brad Myers and Dario Giuse - Changed to new KR
    4/05/89  lkb - checked to be sure window is valid before setting
			its event mask in update
    4/05/89 lkb  same checking as above in all the event routines
    4/03/89 lkb - added fields to event structure, to accomodate switching to using
               portable keywords like (:shift-leftdown), instead of #\super-leftdown
    3/28/89 Brad Myers - Mouse moved return last point, not first
			point of throw-aways
    3/11/89 Lynn Baumeister - changed call to opal::destroy-notify to comply with
                       new release of windows.lisp
============================================================
|#

(in-package "INTERACTORS" :nicknames '("INTER") :use '("LISP" "KR"))

(proclaim '(declaration values))

;; Hitting the key *garnet-break-key* will cause an exit from the
;; main-event-loop and exit from replaying a transcript.
(defvar *Garnet-Break-Key* :F1)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Functions to deal with transcripts
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 

(defparameter *trans-from-file* NIL)
#-release-garnet(defparameter *trans-to-file* NIL)
#-release-garnet(defparameter *transcript-window-list* NIL)
#-release-garnet(defparameter *trans-to-file-motion* NIL)
#-release-garnet(defparameter *trans-time* 0)

#-release-garnet(defparameter *util_month-list*
  '("" "Jan" "Feb" "Mar" "Apr" "May" "Jun" "Jul" "Aug" "Sep" "Oct" "Nov" "Dec"))

#-release-garnet(defun Time-To-String ()
  (multiple-value-bind
      (second minute hour date month year day-of-week savingsp time-zone)
      (get-decoded-time)
    (declare (ignore second time-zone day-of-week))
    (if (>= hour 12) (progn (setq savingsp " PM")
		       (when (> hour 12)(incf hour -12)))
	(setq savingsp " AM"))
    (concatenate 'string
               (nth month *util_month-list*) " "
               (princ-to-string date) ", " (princ-to-string year)
                      ", "
               (princ-to-string hour)
               ":"
               (if (< minute 10) "0" "")
               (princ-to-string minute) savingsp)))

#-release-garnet
(defun Transcript-Events-To-File (filename window-list &key (motion T)
					   (if-exists :supersede))
  (when *trans-to-file* (error "Already transcripting to ~s" *trans-to-file*))
  (when *trans-from-file* (error "Can't send to a file when events from a file: ~s"
				 *trans-from-file*))
  (setf *trans-to-file* (open filename :direction :output :if-exists if-exists))
  (setf *trans-to-file-motion* motion)
  (unless (listp window-list)
    (setq window-list (list window-list)))
  (setq window-list (Add-All-Subwindows window-list))
  (setf *transcript-window-list* window-list)
  (unless (eq if-exists :append)
    (Format *trans-to-file*
	    "Transcript of Garnet session from ~a.  Garnet Version = ~a~%"
	    (Time-To-String) User::Garnet-Version-Number)
    (format *trans-to-file*
	    "Form for events: CHAR CODE MOUSEP DOWNP X Y TIME WIN-INDEX~%")
    (Format *trans-to-file* "Windows are:~%")
    (format *trans-to-file* "(~{\"~s\" ~})~%" window-list))
  (setq *trans-time* (get-internal-real-time))
  *trans-to-file*)

#-release-garnet
(defun Close-Transcript ()
  ;; make a local copy first, incase close's fail, will still be reset.
  (let ((old-to *trans-to-file*)(old-from *trans-from-file*))
    (setf *trans-to-file* NIL)
    (setf *trans-from-file* NIL)
    (when old-to
      (close old-to))
    (when old-from
      (close old-from))
    (or old-to old-from))) ; return whichever was closed

#-release-garnet
(defun Write-Transcript-Event (event)
  (let ((win (position (event-window event) *transcript-window-list*)))
    (when win
      (format *trans-to-file*
	  "> ~s ~s ~s ~s ~s ~s ~s ~s~%"
	  (event-char event) (event-code event) (event-mousep event)
	  (event-downp event) (event-x event) (event-y event)
	  (- (get-internal-real-time) *trans-time*) ; store time difference
						    ; from start time
	  win))))

;;recursively add all the subwindows of the windows in win-list 
(defun Add-All-Subwindows (win-list)
  (do* ((lst win-list (cdr lst))
	(item (car lst)(car lst))
	)
       ((null lst))
    (nconc lst (copy-list (get-values item :child))))
  (remove-duplicates win-list :from-end T))
 
;;; Uses *current-event*
#-release-garnet
(defun Read-Transcript-Event ()
  (let ((val (read-char *trans-from-file* NIL NIL)))
    (when val
      ;; else return NIL
      (unless (eq val #\>)
	(error "Transcript out of sync: first char is ~s, but should be >.
	Execute (inter:close-transcript) to recover." val))
      (setf (event-char *current-event*) (read *trans-from-file*)
	    (event-code *current-event*) (read *trans-from-file*)
	    (event-mousep *current-event*) (read *trans-from-file*)
	    (event-downp *current-event*) (read *trans-from-file*)
	    (event-x *current-event*) (read *trans-from-file*)
	    (event-y *current-event*) (read *trans-from-file*)
	    (event-timestamp *current-event*) (read *trans-from-file*)
	    val (read *trans-from-file*))
      (setf (event-window *current-event*) (nth val *transcript-window-list*))
      *current-event*)))

#-release-garnet
(defun Transcript-Events-From-File (filename window-list &key
					     (wait-elapsed-time T))
  (when *trans-from-file* (error "Already reading from transcript file ~s"
				 *trans-from-file*))
  (when *trans-to-file* (error "Can't read from a file when events to a file: ~s"
			       *trans-to-file*))
  (setf *trans-from-file* (open filename :direction :input))
  (unless (listp window-list)
    (setq window-list (list window-list)))
  (setq window-list (Add-All-Subwindows window-list))
  (setf *transcript-window-list* window-list)
  ;;flush the header information: 3 lines
  (read-line *trans-from-file*)
  (read-line *trans-from-file*)
  (read-line *trans-from-file*)
  ;; read the old window list
  (let ((old-wins (read *trans-from-file*)))
    (if (/= (length old-wins)(length window-list))
	(error "Number of windows in transcript ~s is not the same as supplied ~s
	Execute (inter:close-transcript) to recover."
	       (length old-wins)(length window-list))
	(progn
	  (format T "Replaying transcript from ~s.~%" filename)
	  (format T "Window mappings are as follows:~%")
	  (do ((o old-wins (cdr o))
	       (c window-list (cdr c)))
	      ((null o))
	    (format T "  old=~a => current ~s~%" (car o) (car c))))))
  ;; now start reading the events
  (let ((display (opal::display-info-display
			    (get-value (car window-list) :display-info)))
	(start-time (get-internal-real-time))
	(last-event-time NIL)
	new-ev cur-wait-interval)
    (block eventloop
      (loop
	(setf new-ev (Read-Transcript-Event))
	(if new-ev 
	    (progn
	      (if-debug :event 
			(format t "~%<><><><> Event from transcript ~s~%" new-ev))
	      (if wait-elapsed-time
		  (progn
		    (setf cur-wait-interval (if last-event-time
						(- (event-timestamp new-ev)
						   last-event-time)
						0))
		    (setf last-event-time (event-timestamp new-ev))
		    (loop ; until enough time elapsed
		      (when (eq (Trans-Check-CLX-Events display) :abort)
			(return-from eventloop))
		      (when (>= (- (get-internal-real-time) start-time)
				cur-wait-interval)
			(return))) ; return from time wait loop
		    (setf start-time (get-internal-real-time)))
		  ; else just check for events to see if abort or window refresh
		  (when (eq (Trans-Check-CLX-Events display) :abort)
		    (return-from eventloop)))
	      (xlib:warp-pointer (get-value (event-window new-ev) :drawable)
				 (event-x new-ev)(event-y new-ev))
	      (xlib:display-force-output display)
	      (Process-Event new-ev))
	    ; else no more chars, so exit
	    (progn
	      (format T "~%Transcript Complete~%")
	      (return)))))
    (beep)
    (close-transcript)))

#-release-garnet
(defmacro Trans-Out-Event (event)
  `(when *trans-to-file* (write-transcript-event ,event)))


;; since each clause returns NIL, this should loop until all pending events are
;; processed, at which time the :timeout 0 will cause it to exit
#-release-garnet
(defun Trans-Check-CLX-Events (display)
  (xlib:event-case (display :discard-p t :timeout 0)
    (:CLIENT-MESSAGE (event-window type data format)
          (when (and (eq format 32)
                     (eq type :WM_PROTOCOLS)
                     (eq (xlib:atom-name display (aref data 0))
                         :WM_DELETE_WINDOW))
            (opal::Delete-Notify (debug-p :event) event-window)) NIL)
    (:MAP-NOTIFY (event-window) (opal::Map-Notify (debug-p :event) event-window) NIL)
    (:UNMAP-NOTIFY (event-window)
		   (opal::Unmap-Notify (debug-p :event) event-window) NIL)
    (:REPARENT-NOTIFY (event-window x y)
		   (opal::Reparent-Notify (debug-p :event) event-window x y) NIL)
    (:CIRCULATE-NOTIFY () (opal::Circulate-Notify (debug-p :event)) NIL)
    (:GRAVITY-NOTIFY () (opal::Gravity-Notify (debug-p :event)) NIL)
    (:DESTROY-NOTIFY (event-window)
		     (opal::Destroy-Notify (debug-p :event) event-window) NIL)
    (:CONFIGURE-NOTIFY (x y width height event-window above-sibling)
		       (opal::Configure-Notify (debug-p :event) x y
					      width height
					      event-window above-sibling)
		       NIL)
    (:EXPOSURE (event-window count x y width height)
	       (opal::Exposure (debug-p :event) event-window count x y width height display) NIL)
    (:KEY-PRESS (state code) ;ignore these
		;;check if the abort key
		(let ((c (translate-character display code state)))
		  (when (eq c *garnet-break-key*)
		    (format T "~%**Aborting transcript due to user command**~%")
		    (return-from Trans-Check-CLX-Events :abort)))
		NIL)
    (:BUTTON-PRESS () NIL)  ;ignore these
    (:BUTTON-RELEASE () NIL) ;ignore these
    (:MOTION-NOTIFY () NIL) ;ignore these
    (:NO-EXPOSURE () NIL)
    (OTHERWISE () (format t "illegal event") NIL))
  T)



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Interactor Windows
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 

(create-schema 'interactor-window
  (:is-a opal:window)
  (:current-want-moved-interactors NIL)) ; holds a list of interactors that
					 ; want to know about mouse moved
					 ; events on this window


;;; pem = pointer-event-mask, used to change an active pointer grab
(defparameter *report-motion-pem* (xlib:make-event-mask
						 :button-press
						 :button-release
						 :pointer-motion
						 ))

;;; em = eventmask , used to change an event mask
(defparameter *ignore-motion-em* (xlib:make-event-mask :exposure
						    :button-press
						    :button-release
						    :key-press
						    :structure-notify
						    ))
;;; em = eventmask , used to change an event mask
(defparameter *report-motion-em* (xlib:make-event-mask
				  :exposure
				  :pointer-motion
				  :button-press
				  :button-release
				  :key-press
				  :structure-notify
				  ))

;; releases the mouse grab that X does when there is a down press.  This
;; should be called before set-interest-in-moved
(defun ungrab-mouse (window)
  (if-debug :mouse (format t "ungrabbing mouse~%"))
  (when window
    (let ((drawable (get-value window :drawable)))
    (when drawable
      (xlib:ungrab-pointer (opal::display-info-display
			    (get-value window :display-info)))))))

(defun set-interest-in-moved (window interestedp)
  (if-debug :mouse (format t "interested in mouse moved ~s~%" 
			   interestedp))
  (let ((drawable (get-value window :drawable)))
    (when drawable
      (if interestedp
	  (progn 
	    ;; this will change an active grab if one is in process because
	    ;; changing the window's event mask will have no effect if there is
	    ;; an active grab in session
	    (xlib:change-active-pointer-grab
	     (opal::display-info-display (get-value window :display-info))
	     *report-motion-pem*)
	    
	    (setf (xlib:window-event-mask drawable) *report-motion-em*)
	    (s-value window :event-mask
	       (setf (xlib:window-event-mask drawable) *report-motion-em*)))
	  (progn
	    (setf (xlib:window-event-mask drawable) *ignore-motion-em*)
	    (s-value window :event-mask
	     (setf (xlib:window-event-mask drawable) *ignore-motion-em*)))
	  )
  
      (xlib:display-finish-output
       (opal::display-info-display (get-value window :display-info))))))

(define-method :update interactor-window (window &optional (total nil))
  (opal::update-method-window window total) ; just call directly rather
					    ; than using call-prototype-method
  (let ((drawable (get-local-value window :drawable))
	(event-mask (get-local-value window :event-mask)))
    (if (null event-mask)
	(s-value window :event-mask
	   (setq event-mask (xlib:window-event-mask drawable))))
    (if (and drawable (eq event-mask opal::*exposure-event-mask*))
	(set-interest-in-moved window NIL))))

;;;;            Debugging tools


;; When true, *mouse-throw-aways* will increment each time a mouse-moved
;; event is thrown away
(defvar *mouse-debug* nil)
(defvar *mouse-throw-aways* 0)

;; When true, *expose-throw-aways* will increment each time an exposure
;; event is thrown away
(defvar *expose-debug* nil)
(defvar *expose-throw-aways* 0)

(defun Key-Press (event-window x y state code time)
  ;; state is the modifier-bits
  ;; code is the lookup in keysym
  (let ((window (gethash event-window
			  opal::*drawable-to-window-mapping*)))
    (when (null window)
      (return-from key-press t)) ;; if window was just destroyed, exit.
    (let ((c (translate-character
	      (opal::display-info-display (get-value window :display-info))
	      code state)))
      (when c
	#-release-garnet(if-debug :event
		  (format t "~%<><><><> Key ~S code=~s  state=~s  x=~s y=~s~%"
			  c code state x y))
	#-cmu
	(when (eq c *garnet-break-key*)
	      (if-debug :event
 		        (format t "Exiting main event loop because of *garnet-break-key*"))
	      (exit-main-event-loop))					   
	(setf (event-char *Current-Event*) c
	      (event-mousep *Current-Event*) nil
	      (event-code *Current-Event*) code
	      (event-x *Current-Event*) x
	      (event-y *Current-Event*) y
	      (event-window *Current-Event*) window
	      (event-timestamp *Current-Event*) time
	      )
	#-release-garnet(trans-out-event *Current-event*)
	(key-pressed *Current-Event*)))
  t))

(defun Button-Press (event-window x y state code event-key time)
  (let ((window (gethash event-window
			 opal::*drawable-to-window-mapping*))
	(c (translate-mouse-character code state event-key)))
    (when (null window)
      (return-from button-press t))  ;; if window was just destroyed, exit.
#-release-garnet    (if-debug :event 
      (format t "~%<><><><> Button down ~s event=~s code=~s state=~s window=~s"
	      c event-key code state window)
      (format t " x=~s  y=~S~%" x y))
    (setf (event-char *Current-Event*) c		
	  (event-mousep *Current-Event*) t
	  (event-x *Current-Event*) x
	  (event-y *Current-Event*) y
 	  (event-code *Current-Event*) code
	  (event-downp *Current-Event*) t 
	  (event-window *Current-Event*) window
	  (event-timestamp *Current-Event*) time
	  )	
    #-release-garnet(trans-out-event *Current-event*)
    (button-pressed *Current-Event*))
  t)

(defun Button-Release (event-window x y state code event-key time)
  (let ((window (gethash event-window
			 opal::*drawable-to-window-mapping*))
	(c (translate-mouse-character code state event-key)))
    (when (null window)
      (return-from button-release t))  ;; if window was just destroyed, exit.
#-release-garnet    (if-debug :event 
      (format t "~%<><><><> Button Up ~s event=~s code=~s state=~s window=~s"
	      c event-key code state window)
      (format t " x=~s  y=~s~%" x y))
    (setf (event-char *Current-Event*) c		
	  (event-mousep *Current-Event*) t
	  (event-x *Current-Event*) x
	  (event-y *Current-Event*) y
 	  (event-code *Current-Event*) code
 	  (event-downp *Current-Event*) nil
	  (event-window *Current-Event*) window
	  (event-timestamp *Current-Event*) time
	  )
    #-release-garnet(trans-out-event *Current-event*)
    (button-released *Current-Event*))
  t)
  
(defun Motion-Notify (event-window x y display)
  (let ((window (gethash event-window
			 opal::*drawable-to-window-mapping*))
	(current-x x)
	(current-y y)
	(current-win event-window))
    (when (null window)
      (return-from motion-notify t))  ;; if window was just destroyed, exit.

    ;; throw away mouse moved events, remembering the last x & y, 
    ;; drop out of this loop, once any other events show up.
    #+cmu
    (loop
      (unless (xlib:event-case (display :discard-p nil :timeout 0)
		(:motion-notify ((:x x-prime) (:y y-prime)
				 (:event-window win-prime))
				(setf current-x x-prime)
				(setf current-y y-prime)
				(setf current-win win-prime)
				(when *mouse-debug* 
				  (incf *mouse-throw-aways*))
				t)
		(t () nil)) ;; any other event, return nil (causes
	;; event-case to terminate), which causes
	;; loop to terminate
	(return)))

   ;; Having trouble getting Lucid 2.1 to throw away unnecessary events
   #+(or allegro lcl3.0 explorer)
   (block throw-away
      (xlib:event-case (display :discard-p t :timeout 0)
		(:motion-notify ((:x x-prime) (:y y-prime)
				 (:event-window win-prime))
				(setf current-x x-prime)
				(setf current-y y-prime)
				(setf current-win win-prime)
				(when *mouse-debug* 
				  (incf *mouse-throw-aways*))
				nil)
		(t () (return-from throw-away))))

    ;; done throwing away interim mouse-moved events
    (unless (eq current-win event-window)
      (setf window (gethash current-win
			 opal::*drawable-to-window-mapping*))
      (when (null window)
	(return-from motion-notify t)))  ;; if window was destroyed, exit.

#-release-garnet    (if-debug :event
	      (format t "~%<><><><> Mouse Moved ~s ~s  window=~s~%"
			     current-x current-y window))
    (setf (event-char *Current-Event*) :mouse-moved
	  (event-mousep *Current-Event*) t
	  (event-x *Current-Event*) current-x
	  (event-y *Current-Event*) current-y
	  (event-window *Current-Event*) window
	  (event-timestamp *Current-Event*) 0
	  )
    
    #-release-garnet(when (and *trans-to-file* *trans-to-file-motion*)
      (write-transcript-event *Current-event*))
    (mouse-moved *Current-Event*))
  t)




;;; In CMU CommonLisp, we want this to run once and then exit.  In other Lisps, 
;;; this should loop forever until exit-main-event-loop is called.  That is why
;;; if cmu each branch returns T, but if not cmu, then each branch returns
;;; NIL.
;;; you get a better one in inter-changes.lisp
#-release-sx
(defun opal::default-event-handler (display)
  #-release-garnet
  "Event handler for the interactor windows"
  (xlib:event-case (display :discard-p t)
    (:CLIENT-MESSAGE (event-window type data format)
          (when (and (eq format 32)
                     (eq type :WM_PROTOCOLS)
                     (eq (xlib:atom-name display (aref data 0))
                         :WM_DELETE_WINDOW))
	     (opal::Delete-Notify (debug-p :event) event-window))
	     #-cmu nil)
    (:MAP-NOTIFY (event-window)
		 (opal::Map-Notify (debug-p :event) event-window)
		 #-cmu nil)
    (:UNMAP-NOTIFY (event-window)
		   (opal::Unmap-Notify (debug-p :event) event-window)
		   #-cmu nil)
    (:REPARENT-NOTIFY (event-window x y)
		      (opal::Reparent-Notify (debug-p :event) event-window x y)
		      #-cmu nil)
    (:CIRCULATE-NOTIFY () (opal::Circulate-Notify (debug-p :event))
			   #-cmu nil)
    (:GRAVITY-NOTIFY () (opal::Gravity-Notify (debug-p :event)) #-cmu nil)
    (:DESTROY-NOTIFY (event-window)
		     (opal::Destroy-Notify (debug-p :event) event-window)
		     #-cmu nil)
    (:CONFIGURE-NOTIFY (x y width height event-window above-sibling)
		       (opal::Configure-Notify (debug-p :event) x y
					      width height
					      event-window above-sibling)
			#-cmu nil)
    (:EXPOSURE (event-window count x y width height)
	       (opal::Exposure (debug-p :event) event-window count x y width height display)
	       #-cmu nil)
    (:KEY-PRESS (event-window x y state code time)
		(if *trans-from-file* T ; ignore events when read transcript
		    (Key-Press event-window x y state code time))
		#-cmu nil)
    (:BUTTON-PRESS (event-window x y state code event-key time)
		   (if *trans-from-file* T ; ignore events when read transcript
		       (Button-Press event-window x y
				     state code event-key time))
		   #-cmu nil)
    (:BUTTON-RELEASE (event-window x y state code event-key time)
		     (if *trans-from-file* T ; ignore events when read transcript
			 (Button-Release event-window x y
					 state code event-key time))
		     #-cmu nil)
    (:MOTION-NOTIFY (event-window x y)
		    (if *trans-from-file* T ; ignore events when read transcript
			(Motion-Notify event-window x y display))
		    #-cmu nil)
    (:NO-EXPOSURE () t #-cmu nil)
    (OTHERWISE () (format t "illegal event") t #-cmu nil)))

(defun main-event-loop (&optional window)
  #-release-garnet
  "Event handler for the interactor windows"
  #+cmu (declare (ignore window))
  #+cmu
  (format t "Calling main-event-loop in CMU Common Lisp is not necessary")
  #-cmu
  (let ((display (if window
                     (opal::display-info-display
                        (g-value window :display-info))
		     (let ((win1 (caar (opal::get-table-contents))))
		       (if win1
			   (xlib:window-display win1)
                           opal::*default-x-display*)))))
   ; Changed call to xlib:discard-current-event to xlib:event-case
   ; (because the former was having no effect in Lucid). -- Pervin 4/9/90
   (unwind-protect
     (catch 'exit-main-loop-exception
       (opal::default-event-handler display)))
   (xlib:event-case (display :discard-p t :timeout 5) ; discard current event
     (otherwise () t)))				      ; which was the typing
)					   	      ; of the *garnet-break-key*

(defun exit-main-event-loop ()
  #-cmu
  (throw 'exit-main-loop-exception t))



(defparameter all-inter-windows NIL)

#-release-garnet
(defun Print-Inter-Windows ()
"Prints all the interactor windows.  Useful for debugging"
  (let ((*print-pretty* NIL))
    (dolist (i all-inter-windows)
      (format T "~s  " i))
    (format T "~%")))

;;; Removes all interactors from the window, removes the window from the
;;; global list
(define-method :destroy-me interactor-window (window)
  #-release-garnet
"Method to kill an interactor-window"
  (if-debug :window (format T "Destroying interactor window ~s~%" window))
  (setf all-inter-windows (delete window all-inter-windows))
  (destroy-all-interactors window)
  (call-prototype-method window))

(define-method :initialize interactor-window (window)
  #-release-garnet
"Method to initialize an interactor-window"
  (if-debug :window (format T "Initializing new interactor window ~s~%" window))
  (pushnew window all-inter-windows)
  (call-prototype-method window))


;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/menuinter.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs

;;; This file contains the mouse interactors to handle menus.
;;; It should be loaded after Interactor and after MoveGrowInter
;;;
;;; Designed and implemented by Brad A. Myers

#|
============================================================
Change log:
       3/26/91 Brad Myers - fixed bug introduced last time for main-agg from
                            running-where rather than start-where in do-start
       3/20/91 Brad Myers - fixed bug in SelectObj
       1/13/91 Brad Myers - made the selection list always be in reverse order
       12/4/90 Brad Myers - fixed bug in SelectObj for when interactor
                            hasn't run
       10/11/90 Brad Myers - added explicit Stop-Interactor code
	9/21/90 Brad Myers - fixed final-feedback so works if :start-where returns
				:none.
			    Added new procedures:
				Return-Final-Selection-Objs, gv-Final-Selection-Objs
				DeSelectObj, SelectObj
        7/23/90 Brad Myers - added new parameter to Destroy-Extra-Final-Feedback-Objs
          7/11/90 Ed Pervin - new :destroy-me method
  	  6/14/90 Brad Myers - added destroy method
 	  6/7/90  Brad Myers - add final-feedback-objs
	  4/27/90 Brad Myers - fixed so can be non-continuous
	 10/25/89 Brad Myers - small bug in setting the :selected slot
         10/5/89 Brad Myers - Add Final-Function
	 10/4/89 Roger Dannenberg - Change debugging output
         9/22/89 Brad Myers - Made more robust when :start-where = T
         8/14/89 Brad Myers - Fixed for multiple priority levels
         6/26/89 Brad Myers - Fixed to have quote for create-schema
         6/8/89  Brad Myers -  Fixed so how-set handled consistently
         5/30/89  Brad Myers -  call-method -> kr-send;
			allow running-where to be set after initialized
         4/20/89  Brad Myers - schema-call -> call-method
         4/14/89  Brad Myers - fixed self-deactivate
         4/7/89  Brad Myers and Dario Giuse - changed to work with new KR
         1/15/89 Lynn Baumeister - changed x,y to event structure in func calls
	12/22/88 Brad Myers - feedback both in feedbackobj and main aggregate
	11/28/88 Brad Myers - removed from Interactor.lisp
============================================================
|#

(in-package "INTERACTORS" :use '("LISP" "KR") :nicknames '("INTER"))

;;;============================================================
;;;  Utility procedures
;;;============================================================
;;;============================================================


;;;============================================================
;;; Final Feedback objects
;;;============================================================

(defun Clear-Finals (an-interactor feedback-objs-in-use)
  (dolist (f feedback-objs-in-use)
    #-release-garnet(dbprint-feed :obj-over f NIL an-interactor)    
    (s-value f :obj-over NIL)))

;; This clears the final feedback objects and resets the list in the interactor.
(defun Clear-Finals-And-Set (an-interactor feedback-objs-in-use)
  (clear-finals an-interactor feedback-objs-in-use)
  #-release-garnet
  (if-debug an-interactor (format T "Clearing interactor final feedback slots~%"))
  (s-value an-interactor :final-feed-avail
	   (append (g-value an-interactor :final-feed-avail)
		   feedback-objs-in-use))
  (s-value an-interactor :final-feed-inuse NIL))


;;; destroys any objects created to be extra final feedback objects.  This
;;; is called when the interactor is destroyed.
(defun Destroy-Extra-Final-Feedback-Objs (an-interactor erase)
  #-release-garnet  (if-debug an-interactor (format T "Destroying extra final feedback objects~%"))
  (let ((final-feedback-proto (g-value an-interactor :final-feedback-obj)))
    (when final-feedback-proto
      (dolist (obj (get-local-value an-interactor :final-feed-avail))
	(unless (eq obj final-feedback-proto)
	  (opal:destroy obj erase)))
      (s-value an-interactor :final-feed-avail NIL)
      (dolist (obj (get-local-value an-interactor :final-feed-inuse))
	(unless (eq obj final-feedback-proto)
	  (opal:destroy obj erase)))
      (s-value an-interactor :final-feed-inuse NIL))))

;;; sets the final feedback object to be only new-sel-obj, or if
;;; new-sel-obj is NIL, then sets there to be no final-feedback-objs.
;;; There always must be at least one final-feedback-obj (the prototype
;;; itself), so this procedure does not need to worry about allocating any.
(defun One-Final-Feedback-Obj (an-interactor new-sel-obj)
  (let ((final-feedback-proto (g-value an-interactor :final-feedback-obj)))
    (when final-feedback-proto ; otherwise, just exit
      (let ((feedback-objs-avail (get-local-value an-interactor :final-feed-avail))
	    (feedback-objs-in-use
	     (get-local-value an-interactor :final-feed-inuse)))
	(Clear-Finals an-interactor feedback-objs-in-use)
	(if new-sel-obj
	    ;; set feedback obj to it
	    (let* ((new-avail (append feedback-objs-avail feedback-objs-in-use))
		   (final-feedback (car new-avail)))
	      (s-value an-interactor :final-feed-inuse (list final-feedback))
	      (s-value an-interactor :final-feed-avail
		       (delete final-feedback new-avail))
	        #-release-garnet
                (dbprint-feed :obj-over final-feedback new-sel-obj an-interactor)
	      (s-value final-feedback :obj-over new-sel-obj))
	    ;; already cleared all, so just save lists
	    (progn 
	      (s-value an-interactor :final-feed-inuse NIL)
	      (s-value an-interactor :final-feed-avail
		       (append feedback-objs-avail feedback-objs-in-use))))))))

;;;Adds (if add-p is T) or removes (if add-p is NIL) any final-feedback
;;; objs refering to newval, but leaves rest of the final feedback objects alone
(defun List-Final-Feedback-Obj (an-interactor newval add-p)
  (let ((final-feedback-proto (g-value an-interactor :final-feedback-obj)))
    (when final-feedback-proto ; otherwise, just exit
      (let ((feedback-objs-avail (get-local-value an-interactor :final-feed-avail))
	    (feedback-objs-in-use
	     (get-local-value an-interactor :final-feed-inuse))
	    feed-for-newval)
	(dolist (f feedback-objs-in-use)
	  (when (eq newval (g-value f :obj-over))
	    (setq feed-for-newval f)
	    (return)))
	(if add-p
	    ; add new feedback obj unless one is there
	    (unless feed-for-newval
	      ; first check to see if have a feedback obj to use, and if
	      ; not, create one
	      (unless (setq feed-for-newval (pop feedback-objs-avail))
		(setq feed-for-newval (create-instance NIL final-feedback-proto))
		;; now add new object to aggregate the the other feedback is in
		(opal:add-component (g-value final-feedback-proto :parent)
				    feed-for-newval)
  #-release-garnet		(if-debug an-interactor
			  (format T "----Allocating final feedback obj:~s~%"
			    feed-for-newval)))
	        #-release-garnet(dbprint-feed :obj-over feed-for-newval newval an-interactor)
	      (s-value feed-for-newval :obj-over newval)
	      (s-value an-interactor :final-feed-inuse
		       (cons feed-for-newval feedback-objs-in-use))
	      (s-value an-interactor :final-feed-avail feedback-objs-avail))
	    ; else remove the feedback obj
	    (when feed-for-newval
	        #-release-garnet(dbprint-feed :obj-over feed-for-newval NIL an-interactor)    
	      (s-value feed-for-newval :obj-over NIL)
	      (s-value an-interactor :final-feed-avail
		       (cons feed-for-newval feedback-objs-avail))
	      (s-value an-interactor :final-feed-inuse
		       (delete feed-for-newval feedback-objs-in-use))))))))

;;;initialize the final-feedback internal slots if necessary
(defun Check-Start-Final-Feedback-Obj (an-interactor)
  (when (and (g-value an-interactor :final-feedback-obj)
	     (null (get-local-value an-interactor :final-feed-avail))
	     (null (get-local-value an-interactor :final-feed-inuse)))
    (s-value an-interactor :final-feed-avail
	     (list (g-value an-interactor :final-feedback-obj)))))


;;;============================================================
;;; Exported "useful" functions
;;;============================================================

(defun Return-Final-Selection-Objs (an-interactor)
"Returns a list of all the final-feedback objects currently in use by the
interactor.  This can be used to have another interactor operate on the
final feedback objects (e.g., moving from the selection handles)."
  (when (g-value an-interactor :final-feedback-obj)
    (copy-list (get-local-value an-interactor :final-feed-inuse))))

(defun DeSelectObj (an-interactor obj)
"Cause obj to no longer be selected.  Turns off the final-feedback
objects and clears the various :selected slots appropriately.  If obj is
not selected, this does nothing."
  (let ((how-set (g-value an-interactor :how-set))
	(main-agg (g-value an-interactor :main-aggregate)))
    (Check-Start-Final-Feedback-Obj an-interactor)
    (when (null main-agg) ; hasn't been run yet
      (setq main-agg
	    (s-value an-interactor :main-aggregate
		   (get-gob-of-where (g-value an-interactor :start-where)))))
    (setq how-set
	  (case how-set
	    ((:list-add :list-remove :list-toggle) :list-remove)
	    ((:set :clear :toggle) :clear)))
    ; first do object itself
      #-release-garnet(dbprint-sel obj NIL an-interactor)
    (s-value obj :selected NIL)
    ; now do aggregate
    (if (eq main-agg obj)
	;; if no aggregate, then just clear any final-feedbacks
	(Clear-Finals-And-Set an-interactor 
		      (get-local-value an-interactor :final-feed-inuse))
	;; otherwise, do the aggregate and any final-feedback objects
	(Calc-Set-Agg-Slot an-interactor main-agg obj how-set))
    obj))

(defun SelectObj (an-interactor obj)
  "Cause obj to be selected.  Turns on the final-feedback
  objects and sets the various :selected slots appropriately.  Does not
  check whether obj is part of the domain of an-interactor (in start-where)."
  (let ((how-set (g-value an-interactor :how-set))
	(main-agg (g-value an-interactor :main-aggregate)))
    (Check-Start-Final-Feedback-Obj an-interactor)
    (when (null main-agg) ; hasn't been run yet
      (setq main-agg
	    (s-value an-interactor :main-aggregate
		   (get-gob-of-where (g-value an-interactor :start-where)))))
    (setq how-set
	  (case how-set
	    ((:list-add :list-remove :list-toggle) :list-add)
	    ((:set :clear :toggle) :set)))
    ; first do object itself
    (Calc-set-obj-slot an-interactor obj how-set  
			 (if (eq obj main-agg)
			     NIL
			     (g-value main-agg :selected)))
    ; now do aggregate
    (if (eq main-agg obj)
	;; if no aggregate, then just set the final-feedback, if any
	(One-Final-Feedback-Obj an-interactor obj)
	;; otherwise, do the aggregate and any final-feedback objects
	(Calc-Set-Agg-Slot an-interactor main-agg obj how-set))
    obj))

;;;============================================================
;;; Calculating how to set the :selected slots
;;;============================================================

(Defun how-set-error (how-set)
  (error
  "** Bad how-set: ~s.  Options are :set :clear :toggle
   :list-add :list-remove :list-toggle <num> (<num> <num>)" how-set))

;;; Sets the :selected slot of the object according to how-set.
;;; Other-obj contains the other objects that may need
;;; to be cleared because this one was set.
;;; Does handle when obj or other-obj are not schemas
(defun Calc-set-obj-slot (an-interactor obj how-set other-obj)
  #-release-garnet  (if-debug an-interactor (format T "how-set=~s" how-set))
  ;; first clear other object, if necessary and if not same as the main obj
  (when (and other-obj (not (eq other-obj obj)))
    (case how-set
      ((:list-add :list-remove :list-toggle)) ; do nothing for these
      ((:set :clear :toggle) (if (listp other-obj)
				 ; then assume that used to be a list and
				 ; now isn't, so undo each element
				 (dolist (o other-obj)
				   (when (and (schema-p o)(not (eq o obj)))
				       #-release-garnet(dbprint-sel o NIL an-interactor)
				     (s-value o :selected NIL)))
				 ; otherwise, only one object to de-select
				 (progn
				     #-release-garnet(dbprint-sel other-obj NIL an-interactor)
				   (s-value other-obj :selected NIL))))
      (otherwise))) ; is a number so do nothing
  
  ;; now set the :selected slot of the new object
  (let (val)
    (when (schema-p obj) ; otherwise, can't set its :selected slot!
      (case how-set
	((:set :list-add)   #-release-garnet(dbprint-sel obj T an-interactor)
	 (s-value obj :selected T))
	((:clear :list-remove)   #-release-garnet (dbprint-sel obj NIL an-interactor)
	 (s-value obj :selected NIL))
	((:toggle :list-toggle) (setq val (if (g-value obj :selected) NIL T))
	   #-release-garnet(dbprint-sel obj val an-interactor)
	 (s-value obj :selected val))
	(otherwise (cond ((numberp how-set)
			  (incf (g-value obj :selected) how-set)
			    #-release-garnet(dbprint-sel obj
				 (g-value obj :selected) an-interactor))
			 ((and (listp how-set)(numberp (first how-set))
			       (numberp (second how-set))) ; mod
			  (setq val (mod (+ (g-value obj :selected) (first how-set))
					(second how-set)))
			    #-release-garnet(dbprint-sel obj val an-interactor)
			  (s-value obj :selected val))
			 (t (how-set-error how-set))))))))

;; used when the new values is :none, this clears out all the selections from the
;; aggregate and the final-feedback-objects
(defun Clear-All-Selected (an-interactor main-agg)
  (if-debug an-interactor (format T "clearing all selections from ~s~%" main-agg))
  (when (schema-p main-agg)
    ;; first, clear the :selected slots of any other objects
    (let ((other-obj (g-value main-agg :selected)))
      (if (listp other-obj)
	  ; undo each element
	  (dolist (o other-obj)
	    (when (schema-p o)
	        #-release-garnet(dbprint-sel o NIL an-interactor)
	      (s-value o :selected NIL)))
	  ; otherwise, only one object to de-select
	  (progn
	      #-release-garnet(dbprint-sel other-obj NIL an-interactor)
	    (s-value other-obj :selected NIL))))
    (s-value main-agg :selected NIL)) ; then clear out the aggregate's slot
  (when (g-value an-interactor :final-feedback-obj) ; then we are doing final
						    ; feedback objects
    (Clear-Finals-And-Set an-interactor 
			  (get-local-value an-interactor :final-feed-inuse))))

;;; Sets the :selected slot of the aggregate that the selected object is in
;;; according to how-set.  Newval is the new object selected.
(defun Calc-set-agg-slot (an-interactor agg newval how-set)
  (let ((old-sel (g-value agg :selected))
	val)
    (when (schema-p agg)
      (case how-set
	(:set   #-release-garnet(dbprint-sel agg newval an-interactor)
	      (s-value agg :selected newval)
	      (One-Final-Feedback-Obj an-interactor newval))
	(:clear   #-release-garnet(dbprint-sel agg NIL an-interactor)
		(s-value agg :selected NIL)
		(One-Final-Feedback-Obj an-interactor NIL))
	(:toggle (setq val
		       (if (listp old-sel)
			   ; then converting from a list to a single value
			   (if (member newval old-sel)
			       NIL ;if used to be selected, then clear
			       newval) ; else select just this one
			   ; otherwise, just check the old single value
			   (if (eq old-sel newval)
			       NIL ;if used to be selected, then clear
			       newval))) ; else select this one
		   #-release-garnet(dbprint-sel agg val an-interactor)
		 (s-value agg :selected val)
		 (One-Final-Feedback-Obj an-interactor val))
	(:list-add
	 (cond ((listp old-sel)
		(pushnew newval (g-value agg :selected))
		  #-release-garnet(dbprint-sel agg (g-value agg :selected) an-interactor))
	       ((schema-p old-sel)
		       ;; make it into a list (in case how-set changed
		       ;; from single-selectable to be multiple selectable).
		       ;; If new obj same as old, only include once, however.
		(setq val (if (eq newval old-sel)
			      (list newval)
			      (list newval old-sel)))
		  #-release-garnet(dbprint-sel agg val an-interactor)
		(s-value agg :selected val))
			     ;; otherwise, throw away old value
	       (t (setq val (list newval))
		    #-release-garnet(dbprint-sel agg val an-interactor)
		  (s-value agg :selected val)))
	 (List-Final-Feedback-Obj an-interactor newval T)) ; add newval
	(:list-remove
	 (cond ((listp old-sel)
		(setq val (delete newval (g-value agg :selected)))
		  #-release-garnet(dbprint-sel agg val an-interactor)
		(s-value agg :selected val)
		(Mark-As-Changed agg :selected)) ; s-value may not cause slot to
					       ;be marked since its value is
					       ;a list which will be
					       ;destructively modified by delete
	       ;; else convert to a list
	       ((eq old-sel newval)   #-release-garnet(dbprint-sel agg NIL an-interactor)
		(s-value agg :selected NIL)) ;remove old
	       ((schema-p old-sel) (setq val (list old-sel))
		  #-release-garnet(dbprint-sel agg val an-interactor)
		(s-value agg :selected val)) ;keep old
	       (t   #-release-garnet(dbprint-sel agg NIL an-interactor)
		  (s-value agg :selected NIL))) ; bad old value, remove it
	 (List-Final-Feedback-Obj an-interactor newval NIL)) ; remove newval
	(:list-toggle 
	 (cond ((listp old-sel)
		(if (member newval old-sel)
		    (progn
		      (setq val (delete newval old-sel))
		        #-release-garnet(dbprint-sel agg val an-interactor)
		      (s-value agg :selected val)
		      (Mark-As-Changed agg :selected);s-value may not cause slot
					       ; to be marked since its value is
					       ; a list which will be
					       ; destructively modified by delete
		      (List-Final-Feedback-Obj an-interactor newval NIL)) ;remove
		    (progn 
		      (push newval (g-value agg :selected))
		        #-release-garnet(dbprint-sel agg (g-value agg :selected)
				   an-interactor)
		      (List-Final-Feedback-Obj an-interactor newval T)))) ;add
	       ; otherwise, if was the old value, now none
	       ((eq old-sel newval)   #-release-garnet(dbprint-sel agg NIL an-interactor)
		(s-value agg :selected NIL)
		(List-Final-Feedback-Obj an-interactor newval NIL)) ;remove
	       ; if was a different object, use both
	       ((schema-p old-sel)
		(setq val (list newval old-sel))
		  #-release-garnet(dbprint-sel agg val an-interactor)
		(s-value agg :selected val)
		(List-Final-Feedback-Obj an-interactor newval T)) ;add
	       (t (setq val (list newval))   ; bad old val, remove it
		    #-release-garnet(dbprint-sel agg val an-interactor) 
		  (s-value agg :selected val)
		  (List-Final-Feedback-Obj an-interactor newval T)))) ;add
	(otherwise ; is a number, already incremented object's :selected slot,
	 ; here just note newval
	   #-release-garnet(dbprint-sel agg newval an-interactor)
	 (s-value agg :selected newval)
	 (List-Final-Feedback-Obj an-interactor newval T)))))) ;add

;;;============================================================
;;; Menu Interactors
;;;============================================================

;;;============================================================
;;; Default Procedures to go into the slots
;;;============================================================

(proclaim '(special Menu-Interactor))

(defun Menu-Interactor-Initialize (new-Menu-schema)
  #-release-garnet
  (if-debug new-Menu-schema (format T "Menu initialize ~s~%" new-menu-schema))
  (Check-Interactor-Type new-Menu-schema inter:menu-interactor)
  (Check-Required-Slots new-Menu-schema)
  (Set-Up-Defaults new-Menu-schema)
  (s-value new-Menu-schema :remembered-last-object NIL) ; this slot must be local
  ) ;end initialize procedure

(defun Menu-Int-Running-Action (an-interactor prev-obj-over new-obj-over)
  #-release-garnet  (if-debug an-interactor (format T "Menu int-running, old = ~s, new= ~s~%"
				  prev-obj-over new-obj-over))
  (unless (eq prev-obj-over new-obj-over)
    (let ((feedbackobj (g-value an-interactor :feedback-obj)))
      (when feedbackobj 
	  #-release-garnet(dbprint-feed :obj-over feedbackobj new-obj-over an-interactor)
	(s-value feedbackobj :obj-over new-obj-over))
      (when (and prev-obj-over
		 (schema-p prev-obj-over))
	  #-release-garnet(dbprint :interim-selected prev-obj-over NIL an-interactor)
	(s-value prev-obj-over :interim-selected NIL))
      (when (and new-obj-over
		 (schema-p new-obj-over))
	  #-release-garnet(dbprint :interim-selected new-obj-over T an-interactor)
	(s-value new-obj-over :interim-selected T)))))

(defun Menu-Int-Start-Action (an-interactor obj-under-mouse)
  #-release-garnet  (if-debug an-interactor (format T "Menu int-start over ~s~%" obj-under-mouse))
  (kr-send an-interactor :running-action
	   an-interactor NIL obj-under-mouse))  ;turn on feedback

(defun Menu-Int-Outside-Action (an-interactor outside-control prev-obj-over)
  #-release-garnet  (if-debug an-interactor (format T "Menu int-outside, old = ~s~%" prev-obj-over))
  (unless (eq :last outside-control)
    (kr-send an-interactor :running-action
	   an-interactor prev-obj-over NIL)))
  
(defun Menu-Int-Back-Inside-Action (an-interactor outside-control
					       prev-obj-over new-obj-over)
  #-release-garnet  (if-debug an-interactor (format T "Menu int-back-inside, old = ~s, new= ~s~%"
				  prev-obj-over new-obj-over))
  (kr-send an-interactor :running-action an-interactor
	   (if (eq :last outside-control) prev-obj-over NIL)
	   new-obj-over))

(defun Menu-Int-Stop-Action (an-interactor final-obj-over)
  #-release-garnet  (if-debug an-interactor (format T "Menu int-stop over ~s~%" final-obj-over))
  (let ((feedbackobj (g-value an-interactor :feedback-obj))
	(how-set (g-value an-interactor :how-set))
	(main-agg (g-value an-interactor :main-aggregate)))
    (when feedbackobj
        #-release-garnet(dbprint-feed :obj-over feedbackobj NIL an-interactor)
      (s-value feedbackobj :obj-over NIL))
    (when final-obj-over
      (when (schema-p final-obj-over)
	  #-release-garnet(dbprint :interim-selected final-obj-over NIL an-interactor)
	(s-value final-obj-over :interim-selected NIL))
      (Calc-set-obj-slot an-interactor
			 final-obj-over how-set 
			 ; old-object is the one that used to be selected,
			 ; and get it from the aggregate, if any
			 (if (eq final-obj-over main-agg)
			     NIL
			     (g-value main-agg :selected))))
    (if (eq :none final-obj-over)
	(Clear-All-Selected an-interactor main-agg)
	; else handle the new object normally
	(if (eq final-obj-over main-agg)  ;; if eq, then :selected already set,
	    				  ;; but still need to do final-feedback-obj
	    (One-Final-Feedback-Obj an-interactor
				    (if (g-value final-obj-over :selected)
					final-obj-over NIL))
	    ;; else set the :selected slot of the main-agg.  This procedure
	    ;; will also handle the final-feedback-obj
	    (Calc-set-agg-slot an-interactor main-agg final-obj-over how-set)))
    (KR-Send an-interactor :final-function an-interactor final-obj-over)))

(defun Menu-Int-Abort-Action (an-interactor final-obj-over)
  #-release-garnet  (if-debug an-interactor (format T "Menu int-abort over ~s~%" final-obj-over))
  (kr-send an-interactor :running-action an-interactor
	   final-obj-over NIL))

;; **** This is not used yet ****
(defun Menu-Int-Exception-p (an-interactor obj-under-mouse)
  #-release-garnet  (if-debug an-interactor (format T "Menu int-exception over ~s~%" obj-under-mouse))
  (g-value obj-under-mouse :illegal))

;;;============================================================
;;; Go procedure utilities
;;;============================================================

;;;remove from running level, put on start level, change state to
;;; start, call abort procedure.  Become-inactive ignored because :active
;;; set before this is called
(defun menu-do-abort (an-interactor become-inactive event)
  (declare (ignore event become-inactive))
  #-release-garnet  (if-debug an-interactor (format T "Menu aborting~%"))
  (GoToStartState an-interactor T)
  (kr-send an-interactor :Abort-Action an-interactor
	       (get-local-value an-interactor :remembered-last-object)))

;;; if continuous: (remove from start level, add to stop and abort
;;; 		    level, change state to running)
;;; save object over, call start procedure.
(defun menu-do-start (an-interactor new-obj-over event)
  (declare (ignore event))
  #-release-garnet  (if-debug an-interactor (format T "Menu starting over ~s~%" new-obj-over))
  
  (s-value an-interactor :remembered-last-object new-obj-over)
  (Fix-Running-Where an-interactor new-obj-over)
  (s-value an-interactor :main-aggregate
           (get-gob-of-where (Get-Running-where an-interactor)))
  (Check-Start-Final-Feedback-Obj an-interactor)
  (if (g-value an-interactor :continuous)  ;then will go to running state
    (progn
      (GoToRunningState an-interactor T)
      (kr-send an-interactor :start-action an-interactor new-obj-over))
    ;else call stop-action
    (progn
      (kr-send an-interactor :stop-action an-interactor new-obj-over)
      (GoToStartState an-interactor NIL))))


;;; call outside procedure, clear saved obj, change state to outside
(defun menu-do-outside (an-interactor)
  #-release-garnet  (if-debug an-interactor (format T "Menu outside~%"))
  (s-value an-interactor :current-state :outside)
  (kr-send an-interactor :outside-action an-interactor
	       (g-value an-interactor :outside)
	       (g-value an-interactor :remembered-last-object))
  (unless (eq :last (g-value an-interactor :outside))
    (s-value an-interactor :remembered-last-object NIL)))

;;;check to see if need to stop or abort based on whether :outside = :last
(defun menu-do-outside-stop (an-interactor event)
  #-release-garnet  (if-debug an-interactor (format T "Menu stop outside~%"))
  (if (eq :last (g-value an-interactor :outside))
      (menu-do-stop an-interactor (g-value an-interactor
					:remembered-last-object) event)
      (menu-do-abort an-interactor NIL event)))

;;; call back-inside procedure, change state to running
(defun menu-do-back-inside (an-interactor new-obj-over event)
  (declare (ignore event))
  #-release-garnet  (if-debug an-interactor (format T "Menu back-inside over ~s~%" new-obj-over))
  (s-value an-interactor :current-state :running)
  (let ((prev-obj-over (g-value an-interactor :remembered-last-object)))
    (kr-send an-interactor :back-inside-action an-interactor
		 (g-value an-interactor :outside) prev-obj-over new-obj-over)
    (s-value an-interactor :remembered-last-object new-obj-over)))

;;;if new object is different from old one, call running-procedure
(defun menu-do-running (an-interactor new-obj-over event)
  (declare (ignore event))
  #-release-garnet  (if-debug an-interactor (format T "Menu running over ~s~%" new-obj-over))
  (let ((prev-obj-over (g-value an-interactor :remembered-last-object)))
    (unless (eq prev-obj-over new-obj-over)
      (kr-send an-interactor :running-action an-interactor prev-obj-over
	       new-obj-over)
      (s-value an-interactor :remembered-last-object new-obj-over))))

;;;if new-obj-over not equal to :remembered-last-object, then call
;;; running-action on :remembered-last-object so its interim-feedback can
;;; be removed.  Then, remove from running level, add to start level
;;; change state to start, call stop procedure
(defun menu-do-stop (an-interactor new-obj-over event)
  (declare (ignore event))
  #-release-garnet  (if-debug an-interactor (format T "Menu stop over ~s~%" new-obj-over))
  (let ((prev-obj-over (g-value an-interactor :remembered-last-object)))
    (unless (eq prev-obj-over new-obj-over)
      (kr-send an-interactor :running-action an-interactor prev-obj-over
		   new-obj-over)
      (s-value an-interactor :remembered-last-object new-obj-over)))
  (GoToStartState an-interactor T)
  (kr-send an-interactor :Stop-Action an-interactor new-obj-over))

;;; This is used if explicitly call Stop-Interactor.  It uses the last
;;; selected object
(defun menu-explicit-stop (an-interactor)
  #-release-garnet  (if-debug an-interactor (format T "Menu explicit stop~%"))
  (let ((prev-obj-over (g-value an-interactor :remembered-last-object)))
    (GoToStartState an-interactor T)
    (kr-send an-interactor :Stop-Action an-interactor prev-obj-over)))

;;;============================================================
;;; Menu schema
;;;============================================================

(Create-Schema 'inter:menu-interactor
		     (:is-a inter:interactor)
		     (:name :First-Menu-interactor)
		     (:start-action 'Menu-Int-Start-Action)
		     (:running-action 'Menu-Int-Running-Action)
		     (:stop-action 'Menu-Int-Stop-Action)
		     (:abort-action 'Menu-Int-Abort-Action)
		     (:outside-action 'Menu-Int-Outside-Action)
		     (:back-inside-action 'Menu-Int-Back-Inside-Action)
		     (:how-set :set)
		     (:exception-p 'Menu-Int-Exception-p)  ; not used yet: NIY
		     (:pop-up NIL)
		     (:remembered-last-object NIL)
		     (:main-aggregate NIL)
		     (:Go 'General-Go)  ; proc executed when events happen
		     (:Do-Start 'Menu-Do-Start)     ; these are
		     (:Do-Running 'Menu-Do-Running) ;   called by GO
		     (:Do-Stop 'Menu-Do-Stop)       ;   to do
		     (:Do-Explicit-Stop 'Menu-Explicit-Stop) ;for stop-interactor
		     (:Do-Abort 'Menu-Do-Abort)     ;   the real work.
		     (:Do-Outside 'Menu-Do-Outside) ;   They call the
		     (:Do-Back-Inside 'Menu-Do-Back-Inside)  ; appropriate
		     (:Do-Outside-Stop 'Menu-Do-Outside-Stop); -action procedures
		     (:initialize 'Menu-Interactor-Initialize)) ;proc to call
							   ; when created


;;; Need special destroy to remove the extra final feedback objects that
;;; may have been allocated
(define-method :destroy-me menu-interactor (an-interactor &optional (erase T))
  #-release-garnet  (if-debug an-interactor
	    (format T "Menu special destroy ~s erase=~s~%" an-interactor erase))
  (Destroy-Extra-Final-Feedback-Objs an-interactor erase)
  (call-prototype-method an-interactor erase))

;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/movegrowinter.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

;;; This file contains the mouse and keyboard interactors to select objects
;;; and move them around or grow them.  It should be loaded after
;;; Interactors.lisp
;;;
;;; Designed and implemented by Brad A. Myers

#|
============================================================
Change log:
        12/31/90 Brad Myers - used Pavan's version of Clip-and-map that
                              works for real numbers also.
        10/11/90 Brad Myers - added explicit Stop-Interactor code
        10/6/89 Brad Myers - Export the function Clip-And-Map
			     Allow lines to be moved as well as changing ends
        10/5/89 Brad Myers - Add Final-Function,
				New default running-where is T
				Remove :new-obj-over slot (use :first-obj-over)
				Remove slots :x and :y
	10/4/89 Roger Dannenberg - Change debugging output
        9/20/89 Brad Myers - Added error message for bad attach
        8/14/89 Brad Myers - Fixed for multiple priority levels
        7/7/89  Brad Myers - Minimum size for growing objects and have ability to
				change end points of lines
        6/26/89  Brad Myers - Fixed to have quote for create-schema
        5/30/89  Brad Myers -  call-method -> kr-send;
			allow running-where to be set after initialized; changed name
        4/20/89  Brad Myers - schema-call -> call-method
        4/14/89  Brad Myers - fixed self-deactivate
        4/7/89 Brad Myers and Dario Giuse - fixed for new KR
        2/11/89 Lynn Baumeister - changed x,y to event in func calls
	11/8/88 Brad Myers - started adding the grow interactor
	8/30/88 Brad Myers - moved to constraint version of KR
	8/8/88 Brad Myers - started
============================================================
|#

(in-package "INTERACTORS" :use '("LISP" "KR") :nicknames '("INTER"))

;;;============================================================
;;;============================================================
;;;============================================================

;;; The Clip-and-Map procedure works as follows:
;;;    (Clip-and-Map (val val-1 val-2 target-val-1 target-val-2) takes val,
;;;    clips it to be in the range val-1 .. val-2, and if target-val-1 and
;;;    target-val-2 are provided, then scales and
;;;    translates the value (using linear-interpolation) to be between
;;;    target-val-1 and target-val-2.  Unless target-val-1 and target-val-2
;;;    are both integers, the mapping will be to a float.
;;; Val-1 is allowed to be less than or greater than Val-2.
;;;
(defun Clip-and-Map (val val-1 val-2 &optional target-val-1 target-val-2)
  (if (and target-val-1 target-val-2)
      ;; then do clip and map
      (cond ((< val val-1 val-2) target-val-1)
	    ((< val-1 val-2 val) target-val-2)
	    ((< val val-2 val-1) target-val-2)
	    ((< val-2 val-1 val) target-val-1)
	    (t (+ target-val-1
		  (if (and (integerp target-val-1) (integerp target-val-2))
		      ; integer targets
		      (round (* (- val val-1) (- target-val-2 target-val-1))
			     (- val-2 val-1))
		      ; float targets
		      (/ (* (- val val-1) (- target-val-2 target-val-1))
			 (- val-2 val-1))))))

      ;; else, just do clip (no map)
      (cond ((< val val-1 val-2) val-1)
	    ((< val-1 val-2 val) val-2)
	    ((< val val-2 val-1) val-2)
	    ((< val-2 val-1 val) val-1)
	    ; now make sure that return value is integer if val-1 and val-2
	    ; are both integers (this comes in real handy sometimes)
	    (t (if (and (integerp val-1) (integerp val-2))
		   (round val) val)))))


;;;============================================================
;;; Move-Grow-Interactor
;;;============================================================

;;;============================================================
;;; Helper procedures for the default procedures to go into the slots
;;;============================================================

			     ;left top width height
(defparameter *glo-points* (list 0 0 0 0))  ; use this to avoid cons-ing


;;; Calculates an object's position.
(defun CalcPosition (an-interactor obj x y)
  (let ((attach (g-value an-interactor :attach-point)))
  #-release-garnet
  (if-debug an-interactor (format T "   CalcPosition attach=~s, x,y=(~s,~s)~%"
				    attach x y))
;; use a global to avoid cons-ing
    (setf (first *glo-points*)
	  (case attach
	    ((:nw :sw :w) x)
	    ((:ne :se :e) (1+ (- x (g-value obj :width))))
	    ((:n :s) (- x (floor (g-value obj :width) 2)))
	    (:center (- x (floor (g-value obj :width) 2))) ; use integer divide
	    (:where-hit (- x (g-value an-interactor :x-off)))
	    (t (error "bad attach ~s on interactor ~s" attach an-interactor))))
    (setf (second *glo-points*)
	  (case attach
	    ((:nw :ne :n) y)
	    ((:sw :se :s) (1+ (- y (g-value obj :height))))
	    ((:e :w) (- y (floor (g-value obj :height) 2)))
	    (:center (- y (floor (g-value obj :height) 2)))
	    (:where-hit (- y (g-value an-interactor :y-off)))))
    (setf (third *glo-points*) (g-value obj :width))
    (setf (fourth *glo-points*) (g-value obj :height))
    *glo-points*))
    
;; Deals with changing an objects size, not position, returns a new left top w h
;; x and y in are the new mouse point
(defun CalcSizeAndPosition (an-interactor obj x y)
  (let* ((attach (g-value an-interactor :attach-point))
	 (minwidth (g-value an-interactor :Min-width))
	 (minheight (g-value an-interactor :Min-height))
	 (left (g-value obj :left))
	 (top (g-value obj :top))
	 (width (g-value obj :width))
	 (height (g-value obj :height))
	 rightp1 bottomp1)
  #-release-garnet    (if-debug an-interactor
	      (format T "   CalcSizeAndPosition attach=~s, obj=~s, x,y=(~s,~s)~%"
		      attach obj x y))
    (when minwidth (setq rightp1 (1+ (opal:right obj))))
    (when minheight (setq bottomp1 (1+ (opal:bottom obj))))
    (when (eq attach :where-hit)
      (setq attach (g-value an-interactor :where-hit-attach))
      (setq x (+ x (g-value an-interactor :x-off)))  ;these are + or - as needed
      (setq y (+ y (g-value an-interactor :y-off)))) ;set by CalcWhereHitAttach
 ;; use a global to avoid cons-ing
    ;; first do left and width
    (case attach
      ((:nw :sw :w) 
       (when (and minwidth
		(< (- rightp1 x) minwidth))
	 (setq x (- rightp1 minwidth)))
       (setf (first *glo-points*) x)
       (setf (third *glo-points*) (+ width (- left x))))
      ((:s :n) ; no changes for these
       (setf (first *glo-points*) left)
       (setf (third *glo-points*) width))
      ((:ne :se :e)
       (setf (first *glo-points*) left)
       (setf (third *glo-points*)
	     (if (and minwidth
		      (< (- x left) minwidth))
		 minwidth ; use minwidth if too small
		 (1+ (- x left)))))  ; otherwise, get new width
      (t (error "bad attach ~s on interactor ~s" attach an-interactor)))

    ;; now do top and height
    (case attach
      ((:nw :ne :n)
       (when (and minheight
		(< (- bottomp1 y) minheight))
	 (setq y (- bottomp1 minheight)))
       (setf (second *glo-points*) y)
       (setf (fourth *glo-points*) (+ height (- top y))))
      ((:e :w) ; no changes for these
       (setf (second *glo-points*) top)
       (setf (fourth *glo-points*) height))
      ((:se :sw :s)
       (setf (second *glo-points*) top)
       (setf (fourth *glo-points*)
	     (if (and minheight
		      (< (- y top) minheight))
		 minheight ; use minheight if too small
		 (1+ (- y top)))))  ; otherwise, get new height
      (t (error "bad attach ~s on interactor ~s" attach an-interactor)))
    *glo-points*))

(defconstant sqrt2 (sqrt 2))

;; Deals with changing a line object's end point.  The point to change is
;; determined by the value of :attach-point, which should be 1, 2 or :where-hit
;; returns a new points lines, for both sets of end points: (x1 y1 x2 y2)
;; but only one of the points will have changed.
(defun CalcLineEndPoint (an-interactor x y)
  (let ((attach (g-value an-interactor :attach-point))
	(minlength (g-value an-interactor :Min-length))
	(origpoints (g-value an-interactor :saved-original-points)))
  #-release-garnet    (if-debug an-interactor
	      (format T "   CalcLineEndPoint attach=~s, x,y=(~s,~s)~%"
		      attach x y))
    (when (eq attach :where-hit)
      (setq attach (g-value an-interactor :where-hit-attach))) ;set by
    						       ;CalcLineWhereHitAttach
    (if minlength
	; time for expensive math
	(let (firstx firsty movingx movingy xdist ydist denom)
	  (case attach
	    (1 (setf firstx (third origpoints))
	       (setf firsty (fourth origpoints)))
	    (2 (setf firstx (first origpoints))
	       (setf firsty (second origpoints)))
	    (t (error "bad attach for line ~s, should be 1, 2, or :where-hit" attach)))
	  (setf xdist (- x firstx))
	  (setf ydist (- y firsty))
	  (setf denom (sqrt (+ (* xdist xdist)(* ydist ydist))))
	  (if (< denom minlength)
	      (progn
		(if (zerop denom) ; don't devide by zero
		    (progn
		      (setf movingx (+ x (ceiling minlength sqrt2)))
		      (setf movingy (+ y (ceiling minlength sqrt2))))
		    ; not zero, use calculated points
		    (progn
		      (setf movingx (+ firstx (ceiling (* xdist minlength) denom)))
		      (setf movingy (+ firsty (ceiling (* ydist minlength) denom))))))
	      ; else not less than minimum length
	      (progn
		(setf movingx x)
		(setf movingy y)))
	  ; now set point-list
	  (case attach
	    (1 (setf (first *glo-points*) movingx)
	       (setf (second *glo-points*) movingy)
	       (setf (third *glo-points*) firstx)
	       (setf (fourth *glo-points*) firsty))

	    (2 (setf (first *glo-points*) firstx)
	       (setf (second *glo-points*) firsty)
	       (setf (third *glo-points*) movingx)
	       (setf (fourth *glo-points*) movingy))))

	; else don't worry about minimum length because no minimum length
	(case attach
	  (1 (setf (first *glo-points*) x)
	     (setf (second *glo-points*) y)
	     (setf (third *glo-points*) (third origpoints))
	     (setf (fourth *glo-points*) (fourth origpoints)))
	  
	  (2 (setf (first *glo-points*) (first origpoints))
	     (setf (second *glo-points*) (second origpoints))
	     (setf (third *glo-points*) x)
	     (setf (fourth *glo-points*) y))
	  (t (error "bad attach for line ~s, should be 1, 2, or :where-hit" attach))))
    *glo-points*))



;;; Calculates an line's position as it is moved without changing length or slope
(defun CalcLineMove (an-interactor x y)
  (let ((attach (g-value an-interactor :attach-point))
	(origxdist (g-value an-interactor :orig-x-dist))
	(origydist (g-value an-interactor :orig-y-dist))
	xoff yoff)
  #-release-garnet    (if-debug an-interactor (format T "   CalcLineMove attach=~s, x,y=(~s,~s)~%"
				    attach x y))
    (when (eq attach :where-hit)
      (setq xoff (g-value an-interactor :x-off))  ;these are + or - as needed
      (setq yoff (g-value an-interactor :y-off)))

;; use a global to avoid cons-ing
    (setf (first *glo-points*)
	  (case attach
	    (1 x)
	    (2 (- x origxdist))
	    (:center (- x origxdist))
	    (:where-hit (- x xoff))
	    (t (error "bad attach ~s on interactor ~s" attach an-interactor))))
    (setf (second *glo-points*)
	  (case attach
	    (1 y)
	    (2 (- y origydist))
	    (:center (- y origydist))
	    (:where-hit (- y yoff))))
    (setf (third *glo-points*)
	  (case attach
	    (1 (+ x origxdist))
	    (2 x)
	    (:center (+ x origxdist))
	    (:where-hit (+ (- x xoff) origxdist))))
    (setf (fourth *glo-points*)
	  (case attach
	    (1 (+ y origydist))
	    (2 y)
	    (:center (+ y origydist))
	    (:where-hit (+ (- y yoff) origydist))))
    *glo-points*))
    


;; ----------------------------------------------------------------------
;; functions to deal with :where-hit and initialize the interactor
;; ----------------------------------------------------------------------
;; Orig-?-dist is the distance from x2 to x1, unless centered in which case it
;; is half the distance.
(defun SetLineInitialSlots (an-interactor obj x y)
  (let ((dx (- (g-value obj :x2) (g-value obj :x1)))
	(dy (- (g-value obj :y2) (g-value obj :y1)))
	(attach (g-value an-interactor :attach-point)))
    (s-value an-interactor :orig-x-dist (if (eq attach :center)
					    (floor dx 2)
					    dx))
    (s-value an-interactor :orig-y-dist (if (eq attach :center)
					    (floor dy 2)
					    dy))
    (when (eq :where-hit attach)
      ;; then also set up where to grow from or offsets
      (if (g-value an-interactor :grow-p)
	  (CalcLineWhereHitAttach an-interactor x y) ; for growing lines
	  (progn
	    (s-value an-interactor :x-off (- x (g-value obj :x1)))
	    (s-value an-interactor :y-off (- y (g-value obj :y1))))))))

;; Call this when press and attach-point is :where-hit and moving an
;; end-point of a line to set the
;; interactor's :where-hit-attach slot based on hit position.
;; Returns :where-hit-attach
(defun CalcLineWhereHitAttach (an-interactor x y)
  (let* ((origpoints (g-value an-interactor :saved-original-points))
	 (x1 (first origpoints))
	 (y1 (second origpoints))
	 (x2 (third origpoints))
	 (y2 (fourth origpoints))
	 d1 d2 attach)
    (unless (and x1 y1 x2 y2)
      (error
       "Move-Grow a line (:line-p is T), but object has no X1,Y1,X2,Y2"))
    (setq d1 (+ (* (- x1 x)(- x1 x)) (* (- y1 y)(- y1 y))))
    (setq d2 (+ (* (- x2 x)(- x2 x)) (* (- y2 y)(- y2 y))))
    (setq attach (if (< d1 d2) 1 2))
    (s-value an-interactor :where-hit-attach attach)
  #-release-garnet    (if-debug an-interactor
	      (format T "Calculated attach point for line is endpoint ~s~%" attach))
    attach))

;; Call this when press and attach-point is :where-hit and growing a
;; rectangle to set the
;; interactor's :where-hit-attach slot based on hit position.  Also sets
;; x-off and y-off.  Returns :where-hit-attach
(defun CalcWhereHitAttach (an-interactor x y)
  (let* ((origbox (g-value an-interactor :saved-original-points))
	 (x-off (- (first origbox) x))  ; should be negative numbers
	 (y-off (- (second origbox) y))   ; if point is inside the box
	 (w3 (floor (third origbox) 3))
	 (h3 (floor (fourth origbox) 3))
	 (xcontrol (cond ((< x (+ (first origbox) w3))
			  (s-value an-interactor :x-off x-off)
			  :w)
			 ((> x (+ (first origbox) w3 w3))
			  (s-value an-interactor :x-off
				   (+ -1 (third origbox) x-off))
			  :e)
			 (T (s-value an-interactor :x-off 0)
			    :c)))
	 (control (cond ((< y (+ (second origbox) h3))
			 (s-value an-interactor :y-off y-off)
			 (case xcontrol 
			   (:w :nw)
			   (:e :ne)
			   (:c :n)))
			((> y (+ (second origbox) h3 h3)) 
			 (s-value an-interactor :y-off
				   (+ -1 (fourth origbox) y-off))
			 (case xcontrol 
			   (:w :sw)
			   (:e :se)
			   (:c :s)))
			(T
			 (s-value an-interactor :y-off 0)
			 (case xcontrol 
			      (:w :w)
			      (:e :e)
			      (:c     ;; *Hack* for center, use :nw
			       (s-value an-interactor :x-off x-off)
			       (s-value an-interactor :y-off y-off)
			       :nw))))))
  #-release-garnet    (if-debug an-interactor
	      (format T "Calculated attach point is  ~s~%" control))
    (s-value an-interactor :where-hit-attach control)
    control))

;; makes the feedback for interactor be visible if vis = T or invisible if
;; vis = NIL
(defun sel-change-feedback-visible (an-interactor feedback object-being-changed vis)
  (when feedback
    (let ((val (if vis object-being-changed NIL)))
  #-release-garnet      (dbprint-feed :obj-over feedback val an-interactor)
      (s-value feedback :obj-over val))))
  
;; old-list4 and new-list4 should both be lists of length four.  Copies the values
;; from the old one into the new one without consing.  Useful for box slots
;; and x1 x2 slots
(defun Copy-List4 (old-list4 new-list4)
  (setf (first old-list4) (first new-list4))
  (setf (second old-list4) (second new-list4))
  (setf (third old-list4) (third new-list4))
  (setf (fourth old-list4) (fourth new-list4)))

;; Copies the 4 values into an existing list if there, otherwise creates one
(defun set-obj-list4-slot (obj slot new-list4 inter feedbackp)
  #-release-garnet  (dbprint-either slot obj new-list4 inter feedbackp)
  (set-obj-list4-slot-no-db obj slot new-list4))

(defun set-obj-list4-slot-no-db (obj slot new-list4)
  (when obj
    (let ((oldval (get-local-value obj slot)))
      (if (and oldval (listp oldval) (eq 4 (length oldval)))
	  ; then re-use old slots so no cons-ing
	  (progn (Copy-List4 oldval new-list4)
	    (Mark-As-Changed obj slot)) ; do this to get constraints to go
	  ; else create a new one
	  (s-value obj slot (copy-list new-list4))))))

;; slot will usually be :box or :points
(defun obj-or-feedback-change
       (feedback object-being-changed new-points slot inter)
  (if feedback
      (set-obj-list4-slot feedback slot new-points inter T)
      (set-obj-list4-slot object-being-changed slot new-points inter NIL)))

;;;============================================================
;;; Default Procedures to go into the slots
;;;============================================================

(proclaim '(special Move-Grow-Interactor))

(defun Move-Grow-Interactor-Initialize (new-Move-Grow-schema)
  #-release-garnet  (if-debug new-Move-Grow-schema (format T "Select change initialize ~s~%"
					 new-Move-Grow-schema))
  (Check-Interactor-Type new-Move-Grow-schema inter:Move-Grow-Interactor)
  (Check-Required-Slots new-Move-Grow-schema)
  (Set-Up-Defaults new-Move-Grow-schema)
  ) ;end initialize procedure

(defun Move-Grow-Int-Start-Action (an-interactor object-being-changed
						  first-points)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow int-start moving ~s firstpoints=~s~%"
				  object-being-changed first-points))
  ;;change feedback or object first so no flicker when turned visible
  (let ((feedback (g-value an-interactor :feedback-obj)))
    (obj-or-feedback-change feedback object-being-changed
			    first-points
			    (if (g-value an-interactor :line-p) :points :box)
			    an-interactor)
    (when feedback (sel-change-feedback-visible 
		    an-interactor feedback object-being-changed T)
      )))

(defun Move-Grow-Int-Running-Action (an-interactor object-being-changed
						    new-points)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow int-running, obj = ~s, points=~s~%"
				  object-being-changed new-points))
  (obj-or-feedback-change (g-value an-interactor :feedback-obj)
			object-being-changed new-points
			(if (g-value an-interactor :line-p) :points :box)
			an-interactor))

(defun Move-Grow-Int-Outside-Action (an-interactor outside-control
						  object-being-changed) 
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow int-outside, mov = ~s~%"
				  object-being-changed))
  (unless (eq :last outside-control)
    (let ((feedback (g-value an-interactor :feedback-obj)))
      (if feedback
	  (sel-change-feedback-visible
	   an-interactor feedback object-being-changed NIL)
	  (set-obj-list4-slot object-being-changed
			      (if (g-value an-interactor :line-p) :points :box)
			      (g-value an-interactor :saved-original-points)
			      an-interactor NIL)))))

(defun Move-Grow-Int-Back-Inside-Action (an-interactor outside-control
					       object-being-changed
					       new-inside-points) 
  #-release-garnet  (if-debug an-interactor 
	    (format T "Move-Grow int-back-in, obj = ~s, new points=~s~%"
		    object-being-changed new-inside-points))
  ;;first change the feedback or object to the new position, and then make it
  ;; visible, if necessary
  (let ((feedback (g-value an-interactor :feedback-obj)))
    (obj-or-feedback-change feedback object-being-changed
			  new-inside-points
			  (if (g-value an-interactor :line-p) :points :box)
			  an-interactor)
    (when (and feedback
	       (null outside-control))
      (sel-change-feedback-visible an-interactor feedback object-being-changed T))))

(defun Move-Grow-Int-Stop-Action (an-interactor object-being-changed
						 final-points)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow int-stop obj ~s final-points=~s~%"
				  object-being-changed final-points))
  ;;turn off feedback
  (sel-change-feedback-visible an-interactor (g-value an-interactor :feedback-obj)
			       object-being-changed NIL)
  ;;set object to final position
  (set-obj-list4-slot object-being-changed
		      (if (g-value an-interactor :line-p) :points :box)
		      final-points an-interactor NIL)
  (KR-Send an-interactor :final-function an-interactor object-being-changed
	   final-points))

(defun Move-Grow-Int-Abort-Action (an-interactor object-being-changed)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow int-abort moving ~s~%"
				  object-being-changed))
  (let ((feedback (g-value an-interactor :feedback-obj)))
    (if feedback
	(sel-change-feedback-visible an-interactor feedback object-being-changed NIL)
	(set-obj-list4-slot object-being-changed
			    (if (g-value an-interactor :line-p) :points :box)
			    (g-value an-interactor :saved-original-points)
			    an-interactor NIL))))
  
;;;============================================================
;;; Go procedure utilities
;;;============================================================

;;Want a non-standard default running-where so call this instead of calling
;;Fix-Up-Running-where.    Default here is T (anywhere).
;;; probably it doesn't really make much sence to use '* with movegrow, but it
;;; is supported anyway
(defun Move-Grow-Fix-Running-where (an-interactor new-obj-over)
  (if (g-value an-interactor :running-where)
      ;; fix it up normally in case have '(:xxx *)
      (Fix-Running-Where an-interactor new-obj-over)
      ;; otherwise use T
      (s-value an-interactor :generated-running-where T)))

(defun CalcChangeBoxOrLine (an-interactor obj x y)
  (if (g-value an-interactor :line-p)
      (if (g-value an-interactor :grow-p)
	  (CalcLineEndPoint an-interactor x y)
	  (CalcLineMove an-interactor x y))
      (if (g-value an-interactor :grow-p)
	  (CalcSizeAndPosition an-interactor obj x y)
	  (CalcPosition an-interactor obj x y))))

;;; if continuous: (remove from start level, add to stop and abort
;;; 		    level, change state to running)
;;; save object over, call start procedure.
(defun Move-Grow-do-start (an-interactor new-obj-over event)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow starting over ~s~%" new-obj-over))
        ;; if obj-to-change supplied, then use that, otherwise use whatever was
	;; under the mouse when started
  (let ((x (event-x event))
	(y (event-y event))
	(obj (or (g-value an-interactor :obj-to-change) new-obj-over))
	points line-p)
   ;; (s-value an-interactor :x x)
   ;; (s-value an-interactor :y y)
  #-release-garnet (if-debug an-interactor (format T "   Move-Grow moving ~s~%" obj))
    (s-value an-interactor :obj-being-changed obj)
    ;; don't check line-p until the previous slots have been set, in case
    ;; there are formulas
    (setq line-p (g-value an-interactor :line-p))
    (s-value an-interactor :saved-original-points
	     (if line-p
		 (list (g-value obj :x1) (g-value obj :y1)
		       (g-value obj :x2) (g-value obj :y2))
		 (list (g-value obj :left) (g-value obj :top)
		       (g-value obj :width) (g-value obj :height))))
    (if (and obj (not (eq obj T)))
	(progn
	  (if (g-value an-interactor :line-p)
	      (SetLineInitialSlots an-interactor obj x y)
	      ;; otherwise, left,top,width,height
	      (when (eq :where-hit (g-value an-interactor :attach-point))
		(if (g-value an-interactor :grow-p)
		    (CalcWhereHitAttach an-interactor x y) ; for growing
		    (progn 		               ; for moving
		      (s-value an-interactor :x-off (- x (g-value obj :left)))
		      (s-value an-interactor :y-off (- y (g-value obj :top)))))))
	  (setf points (CalcChangeBoxOrLine an-interactor obj x y)))
	;else no object, just return x y
	(setf points (list x y 10 10)))  ; what use here for w h?
    (if (g-value an-interactor :continuous)  ;then will go to running state
	(progn
	  (Move-Grow-Fix-Running-where an-interactor new-obj-over)
	  (when (g-value an-interactor :outside) ;needed if stop while outside
	    (set-obj-list4-slot-no-db an-interactor :saved-last-points points))
	  (GoToRunningState an-interactor T)
	  (kr-send an-interactor :start-action an-interactor obj points))
	;; else call stop-action
	(progn
	  (kr-send an-interactor :stop-action an-interactor obj points)
	  (GoToStartState an-interactor NIL)))))

(defun Move-Grow-do-outside (an-interactor)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow outside~%"))
  (s-value an-interactor :current-state :outside)
  (kr-send an-interactor :outside-action an-interactor
	       (g-value an-interactor :outside)
	       (g-value an-interactor :obj-being-changed)))
;;;filtering based on :last is handled by the :outside-action procedure
;;;  (unless (eq :last (g-value an-interactor :outside))
;;;    (s-value an-interactor :remembered-last-object NIL)))

(defun Move-Grow-do-back-inside (an-interactor obj event)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow back-inside over ~s at:~s~%"
				  obj event))
  (let ((x (event-x event))
	(y (event-y event)))
   ;;  (s-value an-interactor :x x)
   ;;  (s-value an-interactor :y y)
    (s-value an-interactor :current-state :running)
    (let* ((moving-obj (g-value an-interactor :obj-being-changed))
	   (points (CalcChangeBoxOrLine an-interactor moving-obj x y)))
      (when (g-value an-interactor :outside) ;needed if stop while outside
	(set-obj-list4-slot-no-db an-interactor :saved-last-points points))
      (kr-send an-interactor :back-inside-action an-interactor
		   (g-value an-interactor :outside)
		   moving-obj points))))

(defun Move-Grow-do-running (an-interactor obj event)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow running over ~s at:~s~%" obj event))
  (let ((x (event-x event))
	(y (event-y event)))
  ;;  (s-value an-interactor :x x)
  ;;  (s-value an-interactor :y y)
    (let* ((moving-obj (g-value an-interactor :obj-being-changed))
	   (points (CalcChangeBoxOrLine an-interactor moving-obj x y)))
      (when (g-value an-interactor :outside) ;needed if stop while outside
	(set-obj-list4-slot-no-db an-interactor :saved-last-points points))
      (kr-send an-interactor :running-action an-interactor
		   moving-obj points))))

;;; points is the final value calculated
(defun Move-Grow-do-stop-helper (an-interactor points)
  (GoToStartState an-interactor T)
  (kr-send an-interactor :Stop-Action an-interactor
	       (g-value an-interactor :obj-being-changed) points))

(defun Move-Grow-do-stop (an-interactor obj event)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow stop over ~s at:~s~%" obj event))
  (let ((x (event-x event))
	(y (event-y event)))
    (s-value an-interactor :prev-x x) ; used in case explicit stop
    (s-value an-interactor :prev-y y)
    (Move-Grow-do-stop-helper an-interactor
			      (CalcChangeBoxOrLine
			       an-interactor (g-value an-interactor
						      :obj-being-changed) x y))))
(defun Move-Grow-Explicit-stop (an-interactor)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow explicit stop~%"))
  (let ((x (g-value an-interactor :prev-x))
	(y (g-value an-interactor :prev-y)))
    (Move-Grow-do-stop-helper an-interactor
			      (CalcChangeBoxOrLine
			       an-interactor (g-value an-interactor
						      :obj-being-changed) x y))))

(defun Move-Grow-do-abort (an-interactor become-inactive event)
  (declare (ignore event become-inactive))
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow aborting~%"))
  (GoToStartState an-interactor T)
  (kr-send an-interactor :Abort-Action an-interactor
	       (g-value an-interactor :obj-being-changed)))

;;;check to see if need to stop or abort based on whether :outside = :last
(defun Move-Grow-do-outside-stop (an-interactor event)
  #-release-garnet  (if-debug an-interactor (format T "Move-Grow stop outside~%"))
  (if (eq :last (g-value an-interactor :outside))
      (Move-Grow-do-stop-helper an-interactor
			   (g-value an-interactor :saved-last-points))
      (Move-Grow-do-abort an-interactor NIL event)))

;;;============================================================
;;; Move-Grow schema
;;;============================================================

(Create-Schema 'inter:Move-Grow-Interactor
		     (:is-a inter:interactor)
		     (:name :First-Move-Grow-interactor)
		     (:start-action 'Move-Grow-Int-Start-Action)
		     (:running-action 'Move-Grow-Int-Running-Action)
		     (:stop-action 'Move-Grow-Int-Stop-Action)
		     (:abort-action 'Move-Grow-Int-Abort-Action)
		     (:outside-action 'Move-Grow-Int-Outside-Action)
		     (:back-inside-action 'Move-Grow-Int-Back-Inside-Action)
		     (:obj-to-change NIL)  ;supplied by application program
		     (:Min-width 0); minimum allowed width and height
		     (:Min-height 0)
		     (:attach-point :where-hit) ; where attach to object
		     (:grow-p NIL) ; if T then grow, else move
		     (:line-p NIL) ; if T, then move an end of the line,
				   ; else move left,top,width,height of rectangle
		     (:x-off 0) ; needed for :where-hit.  Offset from where
		     (:y-off 0)    ;    hit to top left of object
		     (:saved-original-points NIL) ; used for ABORT or outside
		     (:saved-last-points NIL) ; used if stop and outside and
						; outside control is :last
		     (:obj-being-changed NIL) ; saved object under the mouse
		     (:Go 'General-Go)  ; proc executed when events happen
		     (:Do-Start 'Move-Grow-Do-Start)     ; these are
		     (:Do-Running 'Move-Grow-Do-Running) ;   called by GO
		     (:Do-Stop 'Move-Grow-Do-Stop)       ;   to do
		     (:Do-Explicit-Stop 'Move-Grow-Explicit-Stop);for stop-interactor
		     (:Do-Abort 'Move-Grow-Do-Abort)     ;   the real work.
		     (:Do-Outside 'Move-Grow-Do-Outside) ;   They call the
		     (:Do-Back-Inside 'Move-Grow-Do-Back-Inside)  ; appropriate
		     (:Do-Outside-Stop 'Move-Grow-Do-Outside-Stop); -action
								     ; procedures
		     (:initialize 'Move-Grow-Interactor-Initialize))


;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/buttoninter.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs

;;; This file contains the mouse and keyboard interactors to handle buttons.
;;; It should be loaded after Interactor.lisp
;;;
;;; Designed and implemented by Brad A. Myers

#|
============================================================
Change log:
       10/11/90 Brad Myers - added explicit Stop-Interactor code
	9/21/90 Brad Myers - fixed final-feedback so works if :start-where returns
				:none, and if :start-where is T
        7/23/90 Brad Myers - added new parameter to Destroy-Extra-Final-Feedback-Objs
	7/11/90 Ed Pervin - new :destroy-me method
	6/14/90 Brad Myers - added destroy method
         6/8/90 Brad Myers - add final-feedback-objs
        12/5/89 Ed Pervin  - Removed extra `)'
        10/5/89 Brad Myers - Add Final-Function
	10/4/89 Roger Dannenberg - Change debugging output
        9/22/89 Brad Myers - Made more robust when :start-where = T
        8/14/89 Brad Myers - Fixed for multiple priority levels
        6/26/89 Brad Myers - Fixed to have quote for create-schema
        6/8/89  Brad Myers -  Fixed so how-set handled consistently
        5/30/89  Brad Myers -  call-method -> kr-send;
			allow running-where to be set after initialized
        4/20/89  Brad Myers - schema-call -> call-method
        4/14/89  Brad Myers - fixed self-deactivate
        4/7/89 Dario Giuse and Brad Myers - changed to work with new KR
        2/15/89 Lynn Baumeister - changed x,y to event in func calls
	9/9/88 Brad Myers - started
============================================================
|#

(in-package "INTERACTORS" :use '("LISP" "KR") :nicknames '("INTER"))

;;;============================================================
;;;============================================================
;;;============================================================


;;;============================================================
;;; Button-Interactor
;;;============================================================


;;;============================================================
;;; Default Procedures to go into the slots
;;;============================================================

(proclaim '(special Button-Interactor))

(defun Button-Interactor-Initialize (new-Button-schema)
#-release-garnet
 (if-debug new-Button-schema
           (format T "Button initialize ~s~%" new-Button-schema))
  (Check-Interactor-Type new-Button-schema inter:button-interactor)
  (Check-Required-Slots new-Button-schema)
  (Set-Up-Defaults new-Button-schema)
  (s-value new-Button-schema :remembered-last-object NIL) ; this slot must be local
  ) ;end initialize procedure

;; this procedure not used for this type of interactor
(defun Button-Int-Running-Action (an-interactor prev-obj-over new-obj-over)
#-release-garnet
 (if-debug an-interactor (format T "Button int-running, old = ~s, new= ~s~%"
				  prev-obj-over new-obj-over)))

(defun Button-Int-Start-Action (an-interactor obj-under-mouse)
#-release-garnet
  (if-debug an-interactor (format T "Button int-start over ~s~%" obj-under-mouse))
  (Button-Int-Back-Inside-Action an-interactor obj-under-mouse)) ;turn on feedback

;;;Turn on feedback
(defun Button-Int-Back-Inside-Action (an-interactor new-obj-over)
#-release-garnet
  (if-debug an-interactor
	    (format T "Button int-back-inside, obj= ~s~%" new-obj-over))
  (let ((feedbackobj (g-value an-interactor :feedback-obj)))
    (when feedbackobj 
      #-release-garnet (dbprint-feed :obj-over
                                     feedbackobj new-obj-over an-interactor)
      (s-value feedbackobj :obj-over new-obj-over))
    (when (and new-obj-over
	       (schema-p new-obj-over))
      #-release-garnet (dbprint :interim-selected new-obj-over T an-interactor)
      (s-value new-obj-over :interim-selected T))))

;;;Turn off feedback
(defun Button-Int-Outside-Action (an-interactor prev-obj-over)
#-release-garnet
  (if-debug an-interactor (format T "Button int-outside, old = ~s~%" prev-obj-over))
  ;; *ignores :last  (unless (eq :last outside-control)
  (let ((feedbackobj (g-value an-interactor :feedback-obj)))
    (when feedbackobj 
      (when (eq prev-obj-over T) (error "new obj is T"))
      #-release-garnet (dbprint-feed :obj-over feedbackobj NIL an-interactor)
      (s-value feedbackobj :obj-over NIL))
    (when prev-obj-over
      #-release-garnet (dbprint :interim-selected prev-obj-over NIL an-interactor)
      (s-value prev-obj-over :interim-selected NIL))))

(defun Button-Int-Stop-Action (an-interactor final-obj-over)
#-release-garnet
  (if-debug an-interactor (format T "Button int-stop over ~s~%" final-obj-over))
  (let ((feedbackobj (g-value an-interactor :feedback-obj))
	(how-set (g-value an-interactor :how-set))
	(main-agg (g-value an-interactor :main-aggregate)))
    (when feedbackobj
       #-release-garnet (dbprint-feed :obj-over feedbackobj NIL an-interactor)
      (s-value feedbackobj :obj-over NIL))
    (when (and final-obj-over
	       (schema-p final-obj-over))
      #-release-garnet (dbprint :interim-selected final-obj-over NIL an-interactor)
      (s-value final-obj-over :interim-selected NIL)
      (calc-set-obj-slot an-interactor
			 final-obj-over how-set
			 ; old-object is the one that used to be selected,
			 ; and get it from the aggregate, if any
			 (if (eq final-obj-over main-agg)
			     NIL
			     (g-value main-agg :selected))))
    (if (eq :none final-obj-over)
	(Clear-All-Selected an-interactor main-agg)
	; else handle the new object normally
	(when (and main-agg (schema-p main-agg))
	  (if (eq final-obj-over main-agg)  ;; if eq, then :selected already set,
	      ;; but still need to do final-feedback-obj
	      (One-Final-Feedback-Obj an-interactor
				      (if (g-value final-obj-over :selected)
					  final-obj-over NIL))
	      ;; else set the :selected slot of the main-agg.  This procedure
	      ;; will also handle the final-feedback-obj
	      (Calc-set-agg-slot an-interactor main-agg final-obj-over how-set))))
    (KR-Send an-interactor :final-function an-interactor final-obj-over)))

(defun Button-Int-Abort-Action (an-interactor final-obj-over)
#-release-garnet
  (if-debug an-interactor (format T "Button int-abort over ~s~%" final-obj-over))
  (when final-obj-over
    (Button-Int-Outside-Action an-interactor final-obj-over))) ;turn off feedback

;;;============================================================
;;; Go procedure utilities
;;;============================================================


;;; if continuous: (remove from start level, add to stop and abort
;;; 		    levels, change state to running
;;; 		    *ALSO* fix running where to be the object started over)
;;; save object over, call start procedure.
(defun Button-do-start (an-interactor new-obj-over event)
  (declare (ignore event))
#-release-garnet
  (if-debug an-interactor (format T "Button starting over ~s~%" new-obj-over))
  (s-value an-interactor :main-aggregate
	   (get-gob-of-where (g-value an-interactor :start-where)))
  (s-value an-interactor :remembered-last-object new-obj-over)
  (Check-Start-Final-Feedback-Obj an-interactor)
  (if (g-value an-interactor :continuous)  ;then will go to running state
      (progn
	(Fix-Running-Where an-interactor new-obj-over)
	(GoToRunningState an-interactor T)
	(kr-send an-interactor :start-action an-interactor new-obj-over)
	)
      ;else call stop-action
      (progn
	(kr-send an-interactor :stop-action an-interactor new-obj-over)
	(GoToStartState an-interactor NIL))))

;;;remove from running level, put on start level, change state to
;;; start, call abort procedure.    Become-inactive ignored because :active
;;; set before this is called
(defun Button-do-abort (an-interactor become-inactive event)
  (declare (ignore event become-inactive))
#-release-garnet
  (if-debug an-interactor (format T "Button aborting~%"))
  (GoToStartState an-interactor T)
  (kr-send an-interactor :Abort-Action an-interactor
	       (if (eq (get-value an-interactor :current-state) :outside)
		   NIL ; pass NIL if now outside
		   (get-local-value an-interactor :remembered-last-object))))

(defun Button-do-outside (an-interactor)
#-release-garnet
  (if-debug an-interactor (format T "Button outside~%"))
  (s-value an-interactor :current-state :outside)
  (kr-send an-interactor :outside-action an-interactor
	       (g-value an-interactor :remembered-last-object)))

(defun Button-do-outside-stop (an-interactor event)
#-release-garnet
  (if-debug an-interactor (format T "Button stop outside~%"))
  (Button-do-abort an-interactor NIL event))

;;; call back-inside procedure, change state to running
(defun Button-do-back-inside (an-interactor new-obj-over event)
  (declare (ignore event))
#-release-garnet
  (if-debug an-interactor (format T "Button back-inside over ~s~%" new-obj-over))
  (unless (eq new-obj-over (get-local-value an-interactor :remembered-last-object))
    (error "wrong object"))  ; just for debugging
  (s-value an-interactor :current-state :running)
  (kr-send an-interactor :back-inside-action an-interactor
	       new-obj-over))

;;; doesn't do anything
(defun Button-do-running (an-interactor new-obj-over event)
  (declare (ignore event))
#-release-garnet
  (if-debug an-interactor (format T "Button running over ~s~%" new-obj-over)))

;;; Will be inside
;;; Remove from running level, add to start level
;;; unless :self-deactivate, change state to start, call stop procedure
(defun Button-do-stop (an-interactor new-obj-over event)
  (declare (ignore event))
#-release-garnet
  (if-debug an-interactor (format T "Button stop over ~s~%" new-obj-over))
  (unless (eq (get-local-value an-interactor :remembered-last-object) new-obj-over)
    (error "wrong object"))
  (GoToStartState an-interactor T)
  (kr-send an-interactor :Stop-Action an-interactor new-obj-over))

;;; This is used if explicitly call Stop-Interactor.  It uses the last
;;; selected object
(defun button-explicit-stop (an-interactor)
#-release-garnet
  (if-debug an-interactor (format T "Button explicit stop~%"))
  (let ((prev-obj-over (g-value an-interactor :remembered-last-object)))
    (GoToStartState an-interactor T)
    (kr-send an-interactor :Stop-Action an-interactor prev-obj-over)))


;;;============================================================
;;; Button schema
;;;============================================================

(Create-Schema 'inter:button-interactor
		     (:is-a inter:interactor)
		     (:name :First-Button-interactor)
		     (:start-action 'Button-Int-Start-Action)
		     (:running-action 'Button-Int-Running-Action)
		     (:running-where '(:in *))
		     (:stop-action 'Button-Int-Stop-Action)
		     (:abort-action 'Button-Int-Abort-Action)
		     (:outside-action 'Button-Int-Outside-Action)
		     (:back-inside-action 'Button-Int-Back-Inside-Action)
		     (:how-set :list-toggle)
		     (:remembered-last-object NIL)
		     (:main-aggregate NIL)
		     (:Go 'General-Go)  ; proc executed when events happen
		     (:Do-Start 'Button-Do-Start)     ; these are
		     (:Do-Running 'Button-Do-Running) ;   called by GO
		     (:Do-Explicit-Stop 'Button-Explicit-Stop) ;for stop-interactor
		     (:Do-Stop 'Button-Do-Stop)       ;   to do
		     (:Do-Abort 'Button-Do-Abort)     ;   the real work.
		     (:Do-Outside 'Button-Do-Outside) ;   They call the
		     (:Do-Back-Inside 'Button-Do-Back-Inside)  ; appropriate
		     (:Do-Outside-Stop 'Button-Do-Outside-Stop); -action procedures
		     (:initialize 'Button-Interactor-Initialize)) ;proc to call
							   ; when created


;;; Need special destroy to remove the extra final feedback objects that
;;; may have been allocated
(define-method :destroy-me inter:button-interactor (an-interactor &optional (erase T))
#-release-garnet
  (if-debug an-interactor
	    (format T "Button special destroy ~s erase=~s~%" an-interactor erase))
  (Destroy-Extra-Final-Feedback-Objs an-interactor erase)
  (call-prototype-method an-interactor erase))

;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/textkeyhandling.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1990, Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

;;; This file contains the commands to allow the text interactor's keyboard
;;; bindings to be changed.
;;; This should be loaded before Textinter.
;;;
;;; Designed and implemented by Brad A. Myers

#|
============================================================
Change log:
	 3/27/91 Greg Sylvain - adjusted for kcl
	 8/22/90 Brad Myers - remove #+cmu #\leftarrow kinds of things
	 4/9/90 Pervin/Cook - changed eq to eql
         4/9/90 Brad Myers - New functions: Unbind-All-Keys, Insert-Text-Into-String
         3/14/90 Brad Myers - Created.
============================================================
|#

(in-package "INTERACTORS" :use '("KR" "LISP"))

;;;============================================================
;;; Helper functions
;;;============================================================

(defun bind-key-internal (key function-operation-or-char hash-table)
  (setf (gethash key hash-table) function-operation-or-char))

(defun copy-hash-table (old-table) ; why isn't this built-in?
  (unless old-table
    (error "Key translation table missing"))
  (if-debug :event
      (format t "** Making a new Key-translation-table~%"))
  (let ((new (make-hash-table)))
    ;; for each item in the old table, put it into the new table
    (maphash #'(lambda (key value)
		 (setf (gethash key new) value))
	     old-table)
    new))

;;If the hash table is not local to the interactor, copy it's prototypes
;; table.  This is done because next the local one will be edited.
(defun get-or-make-local-key-table (an-interactor)
  (let ((ht (get-local-value an-interactor :key-translation-table)))
    (unless ht
      (setq ht (copy-hash-table (g-value an-interactor :key-translation-table)))
      (s-value an-interactor :key-translation-table ht))
    ht))

;;;============================================================
;;; Exported functions
;;;============================================================

(defun Insert-Text-Into-String (string-obj new-text
					   &optional (move-back-cursor 0))
  #-release-garnet
"Inserts the new text into the cursor-text (or multi-cursor-text) string object
at the current cursor index.  Cursor is moved to the end of the new text.  
If move-back-cursor is supplied, it should be an integer and the cursor is
moved back over that number of characters"
  (let* ((old-string (g-value string-obj :string))
	 (index (or (g-value string-obj :cursor-index)
		   (length old-string))))
    (s-value string-obj :string 
	     (concatenate 'string (subseq old-string 0 index)
			  new-text (subseq old-string index)))
    (when (g-value string-obj :cursor-index) ; when it used to be on, update it
      (s-value string-obj :cursor-index (+ index (length new-text)
					   (- move-back-cursor))))))

(defun Bind-Key (key val an-interactor)
  #-release-garnet
"   Binds a key in the key translation table of the interactor.  If the key
translation table used to be inherited, it is copied to the local
interactor and then modified.  
    The key can either be a Lisp character or a special keyword
used in a define-keysym call (see the file inter/define-keys.lisp) to a
particular editing operation.  The second parameter to bind-key can either be a
character to map into (e.g: #\super-4 maps to #\4), one of the built-in
editing operations which are keywords (see list in the manual), a string
(so that the key acts like a macro and expands into a string), or a
function that performs an edit.  The function should take three parameters:
the interactor, the cursor-text object and the inter:event."
  #-release-garnet  (if-debug :event
      (format t "Setting the binding of ~s to ~s for ~s~%"
	      key val an-interactor))
  (let ((ht (get-or-make-local-key-table an-interactor)))
    (bind-key-internal key val ht)))

(defun Unbind-Key (key an-interactor)
  #-release-garnet
"Remove the translation for the key from the keytranslation table of the
interactor.  If the key translation table used to be inherited, it is
copied to the local interactor and then modified."
  #-release-garnet  (if-debug :event
      (format t "Un-binding ~s for ~s~%" key an-interactor))
  (let ((ht (get-or-make-local-key-table an-interactor)))
    (remhash key ht)))

(defun Unbind-All-Keys (an-interactor)
  #-release-garnet
"Removes the translations for all keys from the keytranslation table of the
interactor."
  #-release-garnet  (if-debug :event
      (format t "Un-binding ALL KEYS for ~s~%" an-interactor))
  (let ((ht (get-local-value an-interactor :key-translation-table)))
    (if (not (hash-table-p ht))
      (s-value an-interactor :key-translation-table (setq ht (make-hash-table)))
      ; else re-initialize ht
      (clrhash ht))))

(defun Set-Default-Key-Translations (an-interactor)
  #-release-garnet
"Initializes the hash table of an-interactor with the standard
translations.  If there is no table in an-interactor, creates one.
Otherwise, removes any translations that are there before adding the new ones."
  (let ((ht (get-local-value an-interactor :key-translation-table)))
    (if (not (hash-table-p ht))
      (s-value an-interactor :key-translation-table (setq ht (make-hash-table)))
      ; else re-initialize ht
      (clrhash ht))
    (bind-key-internal :leftarrow :prev-char ht)
    (bind-key-internal #\control-b :prev-char ht)
    (bind-key-internal #\control-\b :prev-char ht)   ; \b is lower case
    
    (bind-key-internal :rightarrow :next-char ht)
    (bind-key-internal #\control-f :next-char ht)
    (bind-key-internal #\control-\f :next-char ht)
    
    (bind-key-internal :uparrow :up-line ht)
    (bind-key-internal #\control-p :up-line ht)
    (bind-key-internal #\control-\p :up-line ht)
    
    (bind-key-internal :downarrow :down-line ht)
    (bind-key-internal #\control-n :down-line ht)
    (bind-key-internal #\control-\n :down-line ht)
    
#+kcl (bind-key-internal #\rubout :delete-prev-char ht)
#-kcl (bind-key-internal #\delete :delete-prev-char ht)
    (bind-key-internal #\backspace :delete-prev-char ht)
    (bind-key-internal #\control-h :delete-prev-char ht)
    (bind-key-internal #\control-\h :delete-prev-char ht)
    
#+kcl (bind-key-internal #\\377 :delete-prev-word ht)
#-kcl (bind-key-internal #\control-backspace :delete-prev-word ht)
#-kcl (bind-key-internal #\control-delete :delete-prev-word ht)
    (bind-key-internal #\control-w :delete-prev-word ht)
    (bind-key-internal #\control-\w :delete-prev-word ht)
    
    (bind-key-internal #\control-d :delete-next-char ht)
    (bind-key-internal #\control-\d :delete-next-char ht)
    
    (bind-key-internal #\control-u :delete-string ht)
    (bind-key-internal #\control-\u :delete-string ht)
    
    #+(or cmu (and kcl (or mips vax)))
    (bind-key-internal :home :beginning-of-string ht)
    (bind-key-internal #\control-\, :beginning-of-string ht)
    (bind-key-internal #\control-< :beginning-of-string ht)
    
    (bind-key-internal #\control-a :beginning-of-line ht)
    (bind-key-internal #\control-\a :beginning-of-line ht)
    
    #+cmu (bind-key-internal :end :end-of-string ht) 
    (bind-key-internal #\control-. :end-of-string ht)
    (bind-key-internal #\control-> :end-of-string ht)
    
    (bind-key-internal #\control-e :end-of-line ht)
    (bind-key-internal #\control-\e :end-of-line ht)
    
    (bind-key-internal #\control-c :copy-to-X-cut-buffer ht)
    (bind-key-internal #\control-\c :copy-to-X-cut-buffer ht)
    
    #+(or cmu (and kcl (or mips vax)))
    (bind-key-internal :insert :copy-from-X-cut-buffer ht)
    #+(and kcl hp-ux)
    (bind-key-internal :insert-line :copy-from-X-cut-buffer ht)
    (bind-key-internal #\control-y :copy-from-X-cut-buffer ht)
    (bind-key-internal #\control-\y :copy-from-X-cut-buffer ht)
    
    (bind-key-internal #\control-j #\Newline ht)
    (bind-key-internal #\return #\Newline ht)
    (bind-key-internal #\control-\j #\Newline ht)
    
    ;; translate the number pad into regular characters (if CMU)
    #+cmu	(bind-key-internal #\super-1 #\1 ht)
    #+cmu	(bind-key-internal #\super-2 #\2 ht)
    #+cmu	(bind-key-internal #\super-3 #\3 ht)
    #+cmu	(bind-key-internal #\super-4 #\4 ht)
    #+cmu	(bind-key-internal #\super-5 #\5 ht)
    #+cmu	(bind-key-internal #\super-6 #\6 ht)
    #+cmu	(bind-key-internal #\super-7 #\7 ht)
    #+cmu	(bind-key-internal #\super-8 #\8 ht)
    #+cmu	(bind-key-internal #\super-9 #\9 ht)
    #+cmu	(bind-key-internal #\super-0 #\0 ht)
    #+cmu	(bind-key-internal #\super-/ #\/ ht)
    #+cmu	(bind-key-internal #\super-* #\* ht)
    #+cmu	(bind-key-internal #\super-- #\- ht)
    #+cmu	(bind-key-internal #\super-+ #\+ ht)
    #+cmu	(bind-key-internal #\super-. #\. ht)
    #+cmu	(bind-key-internal #\super-return #\NewLine ht)  ; the enter key
    ))

;;Look up in translation table and either return value there or the
;; original key
(defun Translate-key (key an-interactor)
  (let ((val (gethash key (g-value an-interactor :key-translation-table) key)))
  #-release-garnet    (if-debug :event
      (format t " key ~s translated to ~s for ~s ~%" key val an-interactor))
    val))

;;;-----------------------------------------------------------------------------
;;; Internal functions used for editing
;;;-----------------------------------------------------------------------------

;; adds char as the new index char
(defun add-char (char str index)
  (let ((s (concatenate 'string (subseq str 0 index)
			" " (subseq str index))))
    (fill s char :start index :end (1+ index))
    s))

;; removes char BEFORE index
(defun remove-char (str index)
  (concatenate 'string (subseq str 0 (1- index)) (subseq str index)))

;; check if char is whitespace
(defun white-space-p (char)
  (member char '(#\space #\tab #\newline)))

;; returns both the new string and the new index, removes the previous word
(defun remove-word (str index)
  (if (> (length str) 0)
    (let* ((start-search (1+ (or (position-if-not #'white-space-p
						  str :from-end T :end index)
				 0)))
	   (prev-space (1+ (or (position-if #'white-space-p
					    str :from-end T :end start-search)
			       -1)))) ; use beginning of string if no space
      (values (concatenate 'string (subseq str 0 prev-space) (subseq str index))
	      prev-space))
    (values str 0)))

(defun Add-X-Cut-Buffer (str index window)
  (let ((xstring (Opal:Get-X-Cut-Buffer window)))
    (values 
     (concatenate 'string (subseq str 0 index) xstring
		  (subseq str index))
     (+ index (length xstring)))))

;; String-object is modified based on char entered, based on the current
;; values in the :key-translation-table of the interactor.
(defun Edit-String (an-interactor string-object event)
  (if (or (null event) (not (schema-p string-object)))
      NIL ; ignore this event and keep editing
      ; else
      (let ((index (g-value string-object :cursor-index))
	    (str (g-value string-object :string))
	    pos)
	(if (and (event-mousep event) ; then see if want to move cursor
		 (event-downp event)
		 (g-value an-interactor :cursor-where-press)
		 (setq pos (opal:get-cursor-index string-object (event-x event)
						  (event-y event))))
	    ; then change the cursor position
	    (s-value string-object :cursor-index pos)
	    ; else use the translation
	    (let ((new-trans-char
		   (Translate-key (event-char event) an-interactor)))
	      (when new-trans-char
		(case new-trans-char
		  (:prev-char (s-value string-object :cursor-index
				       (max 0 (1- index))))
		  (:next-char (s-value string-object :cursor-index
				       (min (length str) (1+ index))))
		  (:up-line (opal:move-cursor-up-one-line string-object))
		  (:down-line (opal:move-cursor-down-one-line string-object))
		  (:delete-prev-char
		   (when (> index 0)
		     (s-value string-object :string (remove-char str index))
		     (s-value string-object :cursor-index (1- index))))
		  (:delete-prev-word
		   (multiple-value-setq (str index)(remove-word str index))
		   (s-value string-object :cursor-index index)
		   (s-value string-object :string str))
		  (:delete-next-char
		   (when (< index (length str))
		     (s-value string-object :string(remove-char str (1+ index)))))
		  (:delete-string 
		   (s-value string-object :cursor-index 0)
		   (s-value string-object :string ""))
		  (:beginning-of-string (s-value string-object :cursor-index 0))
		  (:beginning-of-line
		   (opal:move-cursor-to-beginning-of-line string-object))
		  (:end-of-string
		   (s-value string-object :cursor-index (length str)))
		  (:end-of-line (opal:move-cursor-to-end-of-line string-object))
		  (:copy-to-X-cut-buffer ; don't modify string, but copy it to
		   			 ; the X cut buffer
		   (opal:Set-X-Cut-Buffer (event-window event) str))
		  (:copy-from-X-cut-buffer
		   (multiple-value-setq (str index)
		     (Add-X-Cut-Buffer str index (event-window event)))
		   (s-value string-object :cursor-index index)
		   (s-value string-object :string str))
		  (T ;; here might be a keyword, character, string, or function
		   (cond ((event-mousep event) NIL) ; ignore these
			 ((and (characterp new-trans-char)
			       (or (graphic-char-p new-trans-char)
				   (eql new-trans-char #\NewLine)))
			  ; then is a regular character, so add to str
			  (s-value string-object :string
				   (add-char new-trans-char str index))
			  (s-value string-object :cursor-index (1+ index)))
			 ;; check if a string
			 ((stringp new-trans-char) ; then insert into string
			  (Insert-Text-Into-String string-object new-trans-char))
			 ; now check for functions
			 ((if (symbolp new-trans-char) ; check if a function,
			      		  ; need all 3 tests to do it right!
			      (fboundp new-trans-char)
			      (functionp new-trans-char))
			  ; then call the function
			  (funcall new-trans-char an-interactor
				   string-object event))
			 (T ; otherwise, must be a bad character
			  (Beep)))))))))))

;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/textinter.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: INTERACTORS; Base: 10 -*-
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

;;; This file contains the mouse and keyboard interactors to input an
;;; edited line of text.
;;; It should be loaded after Interactor
;;;
;;; Designed and implemented by Brad A. Myers

#|
============================================================
Change log:
	 3/26/91  Greg Sylvain - changes for kcl
        10/11/90 Brad Myers - added explicit Stop-Interactor code
	 6/18/90  Brad Myers - When starts, sets feedback-obj's :obj-over slot
	 6/01/90  Brad Myers - change so edit function is a method
	 3/14/90  Brad Myers - change to new key translation mechanism-
				much code moved to textkeybindings.lisp
         3/7/90   Brad Myers - Allow change of cursor position using the mouse
				while editing; ^C copies string to X cut buffer;
				^W does delete-back-word;
				added new function Insert-Text-Into-String
         12/11/89 Brad Myers - Fixed translate-event so no errors for
				uparrow,etc on Sun
         11/1/89 Ed Pervin - Altered Translate-event to handle
                             symbol characters like :leftarrow on Sun.
                             Beep now beeps on Sun.
         10/5/89 Brad Myers - Add Final-Function
				Remove :new-obj-over (use :first-obj-over)
	 10/4/89 Roger Dannenberg - Change debugging output
         9/22/89 Brad Myers - Made more robust when :start-where = T
         9/11/89 Brad Myers - Fixed for multi-line text
         8/14/89 Brad Myers - Fixed for multiple priority levels
         7/27/89 Brad Myers - Cursor goes where press by default
         6/26/89 Brad Myers - Fixed to have quote for create-schema
			Changed to have obj-to-change
         6/19/89  Brad Myers - Copy cut buffer into string if use ^y or INSERT
         6/7/89   Brad Myers -  fixed to work with lucid lisp also
         5/30/89  Brad Myers -  call-method -> kr-send;
			allow running-where to be set after initialized
         4/20/89  Brad Myers - schema-call -> call-method
         4/14/89  Brad Myers - fixed self-deactivate
         4/7/89 Brad Myers and Dario Giuse - fixed for new KR
         3/1/89 Brad Myers - radically change behavior
         2/10/89 Lynn Baumeister - added do-xxx and text-int-xxx funcs
         1/09/89 Lynn Baumeister - made sure that top 3 funcs worked
 	 11/29/88 Brad Myers - started


============================================================
|#

(in-package "INTERACTORS" :use '("KR" "LISP"))

;;;============================================================
;;;============================================================
;;;============================================================


;;;============================================================
;;; Helper procedures for the default procedures to go into the slots
;;;============================================================

;;; note:  In the case that the start eventis a mouse-down, the next event
;;;        to be preccessed is a leftup, which will get passed to the
;;;        translate-event routine, hence the (if (not (event-mousep event)))
;;; also,  uparrow and downarrow aren't printable in some fonts, 
;;;        so have to disallow them



 
;; edit either the feedback object or the main object
(defun obj-or-feedback-edit (an-interactor obj-over feedback-obj event)
  ;; the function used as :edit-func is edit-string which is in the file
  ;; textkeyhandling
  (kr-send an-interactor :edit-func an-interactor (or feedback-obj obj-over) event)
  #-release-garnet
  (dbprint-str (or feedback-obj obj-over) an-interactor feedback-obj))

;; turn the cursor visibility on or off
(defun obj-or-feedback-cursor-on-off (obj-over feedback-obj turn-on-p inter)
  (when (or feedback-obj (schema-p obj-over)) ; otherwise, just exit because no
                                              ; object to set
    (let ((obj (or feedback-obj obj-over))
	  val)
      (if turn-on-p
	  (progn
	    (setq val (g-value obj :saved-cursor-index))
	      #-release-garnet
              (dbprint-either :cursor-index obj val inter feedback-obj)
	    (s-value obj :cursor-index val))
	  ; else save current index and turn off cursor
	  (progn 
	    (s-value obj :saved-cursor-index (g-value obj :cursor-index))
	      #-release-garnet
              (dbprint-either :cursor-index obj NIL inter feedback-obj)
	    (s-value obj :cursor-index NIL))))))

;; Copies the 2 values into an existing list if there, otherwise creates one 
(defun set-obj-list2-slot (obj slot val1 val2)
  (let ((oldval (get-local-value obj slot)))
    (if (and oldval (listp oldval) (>= (length oldval) 2))
	; then re-use old slots so no cons-ing
	(progn
	  (setf (first oldval) val1)
	  (setf (second oldval) val2)
	  (Mark-As-Changed obj slot)) ; do this to get constraints to go
	; else create a new one
	(s-value obj slot (list val1 val2)))))

(defun Get-Cursor-Position (an-interactor obj event)
  (or (and (g-value an-interactor :cursor-where-press)
	   (opal:get-cursor-index obj (event-x event)
				  (event-y event)))
      (length (g-value obj :string))))

;;;============================================================
;;; Default Procedures to go into the slots
;;;============================================================

(proclaim '(special Text-Interactor))

(defun Text-Interactor-Initialize (new-Text-schema)
  #-release-garnet  (if-debug new-Text-schema (format T "Text initialize ~s~%" new-Text-schema))
  (Check-Interactor-Type new-Text-schema inter:text-interactor)
  (Check-Required-Slots new-Text-schema)
  (Set-Up-Defaults new-Text-schema)
  ) ;end initialize procedure

;;; make a copy of the orignal string in case :abort happens
(defun Text-Int-Start-Action (an-interactor new-obj-over start-event)
  #-release-garnet  (if-debug an-interactor (format T "Text int-start over ~s~%" new-obj-over))
  (let ((feedback (g-value an-interactor :feedback-obj))
	(startx (event-x start-event))
	(starty (event-y start-event))
	indx)
    (s-value an-interactor :startx startx)
    (s-value an-interactor :starty starty)
    (if feedback
	(progn
  #-release-garnet	  (if-debug an-interactor
	     (format T "  * Setting :box of ~s (feedback-obj) to (~s ~s ..)~%"
		     feedback startx starty))
	  (set-obj-list2-slot feedback :box startx starty)
  #-release-garnet	  (dbprint-feed :obj-over feedback new-obj-over an-interactor)
	  (s-value feedback :obj-over new-obj-over)
	  (s-value an-interactor :original-string
		   (copy-seq (g-value feedback :string)))
	  (setq indx (Get-Cursor-Position an-interactor feedback start-event))
  #-release-garnet	  (dbprint-feed :cursor-index feedback indx an-interactor)
	  (s-value feedback :cursor-index indx)
  #-release-garnet	  (dbprint-feed :visible feedback T an-interactor)
	  (s-value feedback :visible T))
	;; else modify new-obj-over
	(progn
	  (s-value an-interactor :original-string
		   (copy-seq (g-value new-obj-over :string)))
	  (when (schema-p new-obj-over)
	    (setq indx (Get-Cursor-Position an-interactor new-obj-over start-event))
  #-release-garnet	    (dbprint :cursor-index new-obj-over indx an-interactor)
	    (s-value new-obj-over :cursor-index indx))))
    (obj-or-feedback-edit an-interactor new-obj-over feedback start-event)))

(defun Text-Int-Running-Action (an-interactor obj-over event)
  #-release-garnet  (if-debug an-interactor (format T "Text int-running, edit-char = ~S~%"
				  (event-char event)))
  (obj-or-feedback-edit an-interactor obj-over
			(g-value an-interactor :feedback-obj) event))

(defun Text-Int-Outside-Action (an-interactor last-obj-over)
  #-release-garnet  (if-debug an-interactor (format T "Text int-outside object=~s~%" last-obj-over))
  (obj-or-feedback-cursor-on-off last-obj-over
				 (g-value an-interactor :feedback-obj) NIL
				 an-interactor))

(defun Text-Int-Back-Inside-Action (an-interactor obj-over event)
  #-release-garnet  (if-debug an-interactor (format T "Text int-back-inside, obj-ever = ~S ~% "
				  obj-over))
  (let ((feedback (g-value an-interactor :feedback-obj)))
    (obj-or-feedback-cursor-on-off obj-over feedback T an-interactor)
    (obj-or-feedback-edit an-interactor obj-over feedback event)))

(defun Text-Int-Stop-Action (an-interactor obj-over event)
  #-release-garnet  (if-debug an-interactor (format T "Text int-stop over ~s~%" obj-over))
  (let ((feedback (g-value an-interactor :feedback-obj))
	val)
    ;; ** NOTE final character is NOT edited into the string
    ;; ** (obj-or-feedback-edit an-interactor obj-over feedback event)
    (obj-or-feedback-cursor-on-off obj-over feedback NIL an-interactor)
    (when (and feedback (schema-p obj-over))
      (setq val (g-value feedback :string))
  #-release-garnet      (dbprint :string obj-over val an-interactor)
      (s-value obj-over :string (copy-seq val)))  ; copy the string so it
						  ; is not shared with the
						  ; feedback object
    (when feedback
  #-release-garnet      (dbprint-feed :visible feedback NIL an-interactor)
      (s-value feedback :visible NIL))
    (when (g-value an-interactor :final-function)
      (let ((str ; try to come up with a final string for final-function
	     (if (schema-p obj-over)
		 (g-value obj-over :string)
		 (if feedback (g-value feedback :string) NIL)))
	    startx starty)
	(if (g-value an-interactor :continuous)
	    (progn (setf startx (g-value an-interactor :startx))
	      (setf starty (g-value an-interactor :starty)))
	    (progn (setf startx (event-x event))
	      (setf starty (event-y event))))
	(KR-Send an-interactor :final-function an-interactor obj-over event
		 str startx starty)))))

(defun Text-Int-Abort-Action (an-interactor orig-obj-over event)
  (declare (ignore event))
  #-release-garnet  (if-debug an-interactor (format T "Text int-abort over ~s~%" orig-obj-over))
  (let ((feedback (g-value an-interactor :feedback-obj)))
    (if feedback
	(progn
	  (s-value feedback :string
		   (copy-seq (g-value an-interactor :original-string)))
	  (s-value feedback :cursor-index NIL)
  #-release-garnet	  (dbprint-str feedback an-interactor T)
  #-release-garnet	  (dbprint-feed :visible feedback NIL an-interactor)
	  (s-value feedback :visible NIL))
	(when (schema-p orig-obj-over)
	  (progn
	    (s-value orig-obj-over :string
		     (copy-seq (g-value an-interactor :original-string)))
	    (s-value orig-obj-over :cursor-index NIL)
  #-release-garnet	    (dbprint-str orig-obj-over an-interactor NIL))))))

;;;============================================================
;;; Go procedure utilities
;;;============================================================


;;; if continuous: (remove from start level, add to stop and abort
;;; 		    level, change state to running
;;; 		    )
(defun Text-do-start (an-interactor obj-over event)
  #-release-garnet  (if-debug an-interactor (format T "Text starting over ~s~%" obj-over))
        ;; if obj-to-change supplied, then use that, otherwise use whatever was
	;; under the mouse when started
  (let ((obj (or (g-value an-interactor :obj-to-change) obj-over)))
    (if (g-value an-interactor :continuous)  ;then will go to running state
	(progn
	  (Fix-Running-Where an-interactor obj-over)
	  (s-value an-interactor :remembered-object obj) ; object to edit
	  (GoToRunningState an-interactor
			    (if (eq T (Get-Running-where an-interactor))
				NIL  ; run anywhere so don't get mouse-moved
				T))  ; need mouse moved to see if outside
	  (kr-send an-interactor :start-action an-interactor obj event))
	;else call stop-action
	(progn
	  (kr-send an-interactor :stop-action an-interactor obj event)
	  (GoToStartState an-interactor NIL)))))

(defun Text-do-running (an-interactor obj-over event)
  #-release-garnet  (if-debug an-interactor (format T "Text running over ~s~%" obj-over))
  (kr-send an-interactor :running-action an-interactor
	(g-value an-interactor :remembered-object) event))

;;; Will be inside
;;; Remove from running level, add to start level
;;; unless :self-deactivate, change state to start, call stop procedure
(defun Text-do-stop (an-interactor obj-over event)
  #-release-garnet  (if-debug an-interactor (format T "Text stop over ~s~%" obj-over))
  (GoToStartState an-interactor T)
  (kr-send an-interactor :Stop-Action an-interactor
	       (g-value an-interactor :remembered-object) event))

(defun Text-Explicit-Stop (an-interactor)
  #-release-garnet  (if-debug an-interactor (format T "Text explicit stop~%"))
  (GoToStartState an-interactor T)
  ;; Fortunately, the stop-event is not edited into the string, so we can
  ;; afford to use the current event, even though it may contain a
  ;; character, or be outside, or whatever.
  (kr-send an-interactor :Stop-Action an-interactor
	   (g-value an-interactor :remembered-object) *current-event*))


;;;remove from running level, put on start level, change state to
;;; start, call abort procedure    Become-inactive ignored because :active
;;; set before this is called
(defun Text-do-abort (an-interactor become-inactive event)
  (declare (ignore become-inactive))
  #-release-garnet  (if-debug an-interactor (format T "Text aborting~%"))
  (GoToStartState an-interactor T)
  (kr-send an-interactor :Abort-Action an-interactor
	       (g-value an-interactor :remembered-object) event))

;;; call outside procedure, change state to outside
(defun Text-do-outside (an-interactor)
  #-release-garnet  (if-debug an-interactor (format T "Text outside~%"))
  (s-value an-interactor :current-state :outside)
  (kr-send an-interactor :outside-action an-interactor
	       (g-value an-interactor :remembered-object)))

(defun Text-do-outside-stop (an-interactor event)
  #-release-garnet  (if-debug an-interactor (format T "Text stop outside~%"))
  (if (eq :last (g-value an-interactor :outside))
      (text-do-stop an-interactor NIL event)
      (text-do-abort an-interactor NIL event)))

;;; call back-inside procedure, change state to running
(defun Text-do-back-inside (an-interactor obj-over event)
  #-release-garnet  (if-debug an-interactor (format T "Text back-inside over ~s~%" obj-over))
  (s-value an-interactor :current-state :running)
  (kr-send an-interactor :back-inside-action an-interactor
	       (g-value an-interactor :remembered-object) event))


;;;============================================================
;;; Text schema
;;;============================================================

(Create-Schema 'inter:text-interactor
		     (:is-a inter:interactor)
		     (:name :First-Text-interactor)
		     (:start-action 'Text-Int-Start-Action)
		     (:running-action 'Text-Int-Running-Action)
		     (:obj-to-change NIL)  ;supply if don't want to affect
					   ; result of :start-where
		     (:running-where T)
		     (:cursor-where-press T)
		     (:key-translation-table NIL) ;table of translations; set below
		     (:edit-func 'Edit-String)
		     (:stop-action 'Text-Int-Stop-Action)
#+kcl		     (:stop-event '(#\return #\return))
#-kcl		     (:stop-event '(#\return #\super-return))
		     (:abort-event '(#\control-g #\control-\g))
		     (:abort-action 'Text-Int-Abort-Action)
		     (:outside-action 'Text-Int-Outside-Action)
		     (:back-inside-action 'Text-Int-Back-Inside-Action)
		     (:remembered-last-object NIL)
		     (:Go 'General-Go)  ; proc executed when events happen
		     (:Do-Start 'Text-Do-Start)     ; these are
		     (:Do-Running 'Text-Do-Running) ;   called by GO
		     (:Do-Explicit-Stop 'Text-Explicit-Stop) ;for stop-interactor
		     (:Do-Stop 'Text-Do-Stop)       ;   to do
		     (:Do-Abort 'Text-Do-Abort)     ;   the real work.
		     (:Do-Outside 'Text-Do-Outside) ;   They call the
		     (:Do-Back-Inside 'Text-Do-Back-Inside)  ; appropriate
		     (:Do-Outside-Stop 'Text-Do-Outside-Stop); -action procedures
		     (:initialize 'Text-Interactor-Initialize)) ;proc to call
							   ; when created

(Set-Default-Key-Translations inter:text-interactor)

;;; Concatenated from type module "inter" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/inter/f1.4/inter-changes.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : inter-changes.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Sun Jul 21 17:11:42 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Wed Nov 20 19:17:26 1991
;;;; Update Count    : 9
;;;; 
;;;; PURPOSE
;;;; 	|>Description of module's purpose<|
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs



(eval-when (eval load compile)
  (in-package "INTERACTORS" :use '("KR" "LISP") :nicknames '("INTER")))

;; in interactors.lisp, put the following change:

;
;#-release-dsi
;(defmacro if-debug (inter &rest body)
;  `(when (and *int-debug* (trace-test ,inter))
;     (let ((*print-pretty* NIL))
;       ,@body)))
;
;#+release-dsi
; (defmacro if-debug (inter &rest body)
;   nil)


;;; actually defined in inter/i-windows.lisp! so overwrite must occur here
;;;
;;;	I.	Opal::Default-event-handler 
;;;
;;; added keywords to arg list to allow options to be set. -fer 8/90

(defun opal::default-event-handler
      (display &optional &key (discard-p t) (force-output-p t)
			      (peek-p nil) (timeout nil))
  #-release-garnet
  "Event handler for the interactor windows"
  (declare (ignore force-output-p discard-p))
  (xlib:event-case (display :discard-p t :force-output-p t
                    :force-output-p force-output-p :peek-p peek-p 
                    :timeout timeout)
    (:MAP-NOTIFY (event-window)
		 (opal::Map-Notify (debug-p :event) event-window)
		 #-cmu nil)
    (:UNMAP-NOTIFY (event-window)
		   (opal::Unmap-Notify (debug-p :event) event-window)
		   #-cmu nil)
    (:REPARENT-NOTIFY (event-window x y)
		      (opal::Reparent-Notify (debug-p :event) event-window x y)
		      #-cmu nil)
    (:CIRCULATE-NOTIFY () (opal::Circulate-Notify (debug-p :event))
			   #-cmu nil)
    (:GRAVITY-NOTIFY () (opal::Gravity-Notify (debug-p :event)) #-cmu nil)
    (:DESTROY-NOTIFY (event-window)
		     (opal::Destroy-Notify (debug-p :event) event-window)
		     #-cmu nil)
    (:CONFIGURE-NOTIFY (x y width height event-window above-sibling)
		       (opal::Configure-Notify (debug-p :event) x y
					      width height
					      event-window above-sibling)
			#-cmu nil)
    (:EXPOSURE (event-window count x y width height)
	       (opal::Exposure (debug-p :event) event-window count x y width height display)
	       #-cmu nil)
    (:KEY-PRESS (event-window x y state code time)
		(if *trans-from-file* T ; ignore events when read transcript
		    (Key-Press event-window x y state code time))
		#-cmu nil)
    (:BUTTON-PRESS (event-window x y state code event-key time)
		   (if *trans-from-file* T ; ignore events when read transcript
		       (Button-Press event-window x y
				     state code event-key time))
		   #-cmu nil)
    (:BUTTON-RELEASE (event-window x y state code event-key time)
		     (if *trans-from-file* T ; ignore events when read transcript
			 (Button-Release event-window x y
					 state code event-key time))
		     #-cmu nil)
    (:MOTION-NOTIFY (event-window x y)
		    (if *trans-from-file* T ; ignore events when read transcript
			(Motion-Notify event-window x y display))
		    #-cmu nil)
    (:NO-EXPOSURE () t #-cmu nil)
    (OTHERWISE () (format t "illegal event") t #-cmu nil)))

;;; Concatenated from type module "aggregadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/aggregadgets/f1.4/aggregadgets-loader.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GARNET-DEBUG; Base: 10 -*-
;;; 
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;

#|
=========================================================================
Change log:
        8 May 90 Roger Dannenberg - update for new aggregadgets version
         8/23/89 Ed Pervin - Removed load of aggregates
         7/20/89 Philippe Marchal - Added aggrelists, removed aggregitems
         6/29/89 Philippe Marchal - Added aggregitems
         6/21/89 Brad Myers - Made to work with Sun Lucid Lisp also
		 Philippe Marchal -- created
=======================================================================++
|#

(in-package "USER" :use '("LISP"))

;(format t "Loading Aggregadgets ...~%")
(setf *load-verbose* t)

;;; check first to see if place is set
;(unless (boundp 'Garnet-Aggregadgets-PathName)
;  (error "Load 'Garnet-Loader' first to set Garnet-Aggregadgets-PathName before loading Aggregadgets."))
;
;;; ---- Load aggregadgets themselves
;
;;;This is a defvar so it can be overridden if you don't want to compile everything
;
;(Defvar Garnet-Aggregadgets-Files
;  '(
;    "aggregadgets"
;    "aggrelists"
;    "add-agg"
;    "copy-agg"
;    "save-agg"
;    ))
;
;(dolist (file Garnet-Aggregadgets-Files)
;  (load (merge-pathnames file 
;                         #+cmu "aggregadgets:"
;                         #+(not cmu) Garnet-Aggregadgets-PathName
;                         )
;        :verbose T))
;
;(setf (get :garnet-modules :aggregadgets)  t)
(provide 'aggregadgets)
;(format t "...Done Aggregadgets.~%")




;;; Concatenated from type module "aggregadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/aggregadgets/f1.4/aggregadgets.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;; 
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie-Mellon University
;;; All rights reserved.  The CMU Software Licensing Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; The Aggregadgets. A straightforward way to define hierarchical
;;; graphical objects.
;;;
;;; Philippe Marchal Feb. 1989

#|
======================================================================
Change log:
  15 Apr 91 bam   Added the :behaviors slot to the :local-only-slots of aggregadget
  16 Jul 90 rbd   Changed compilation order: aggregadgets first
   8 May 90 rbd   Major changes for new version.
   11/28/89 ecp   Fixed bug in create-parts such that aggrelists were not
                  getting initialized correctly.
    9/28/89 ecp   Aggrelists can now have :interactors slots, too.
    9/18/89 ecp   Copy-parts should not have been calling itself recursively.
    9/14/89 ecp   The :initialize method for aggregadgets has optional
                  second argument to keep track of top level.
    8/2/89  prm   Optimized code after review meeting.
    7/20/89 prm   Removed aggregitems (now integrated to aggrelists).
    7/13/89 prm   Changed to work with aggrelists.
    7/6/89  prm   Changed syntax (class names must be comma-ed) to keep
                  everything consistent.
    6/28/89 prm   Changed to accept open formulas. This involved a change
                  of syntax (:parts and :interactors are now lists)
    6/28/89 prm   Changed the syntax: now :parts and :interactors are
                  lists instead of multi-value slots.
    6/28/89 prm   Fixed a bug: now sets :behaviors properly
    6/23/89 prm   Quoted the names in calls to create-instance, in order
                  to match KR 2.2
    6/8/89  prm   Added "element style" components (aggregitems)
    6/5/89  prm   Fixed a bug: now when copying a part that is an
                  aggregadget, create-prototype is called instead
                  of create-instance
    5/15/89 prm   Optimized the creation of instances of aggregadget
                  prototypes (makes copies of the prototype).
    5/11/89 prm   call-prototype-method moved to the beginning
                  of the :initialize method.
    4/18/89 prm   Changed again to match KR v2.0 (methods)
    4/07/89 prm   Changed to match KR v2.0
    3/28/89 prm   Added built-in interactors.
======================================================================
|#

(in-package "OPAL" :use '("LISP" "KR"))
(export '(GVL-SIBLING AGGREGADGET ADD-LOCAL-COMPONENT ADD-LOCAL-INTERACTOR
		      REMOVE-LOCAL-COMPONENT REMOVE-LOCAL-INTERACTOR))

;;; Macros for calling methods as if they were functions.

(defmacro add-local-component (schema &rest args)
  `(kr-send ,schema :add-local-component ,schema ,@args))

(defmacro add-local-interactor (schema &rest args)
  `(kr-send ,schema :add-local-interactor ,schema ,@args))

(defmacro remove-local-component (schema &rest args)
  `(kr-send ,schema :remove-local-component ,schema ,@args))

(defmacro remove-local-interactor (schema &rest args)
  `(kr-send ,schema :remove-local-interactor ,schema ,@args))


(defvar aggrelist) ; make the compiler happy


;;;
;;; Macros to access to the elements of a part or interactor
;;; definition of an aggregadget.
;;;

;;; Gives the name of the part or inter,
(defmacro get-name (def)
  `(car ,def))

;;; Gives the name of class of the part or inter.
(defmacro get-class-name (def)
  `(cadr ,def))

;;; Gives the body of the part  or inter (slots definitions)
(defmacro get-body (def)
  `(cddr ,def))

;;;
;;; An Aggregadget is an aggregate that builds himself, using a slot
;;; called "parts" where the components of the aggregadget are described;
;;; and a slot called "interactors" where the interactors that operates
;;; on the aggregadget are described.
;;;

(create-instance 'opal:aggregadget opal:aggregate
  (:local-only-slots '((:behaviors nil) (:window nil) (:parent nil))))

;;;
;;; The initialize method for aggregadgets.
;;; If the aggregadget is a prototype (an instance of opal:aggregadget), its
;;; components and interactors are created according to the :parts and
;;; :interactors slots.
;;; If it is an instance of a prototype, the :parts slot is a guide to
;;; making instances of the prototype's components and interactors.
;;; The algorithm is the following: 
;;;    if there is no parts list, just make instances of prototype's components
;;;    if the first item of the prototype is not in the parts list, make
;;;        instances of all the prototype components and then add from the
;;;        parts list
;;;    for each name in the parts list, do one of the following:
;;;        (1) if prototype is :omit, omit the component, but put a link to nil
;;;        (2) if prototype is :modify,  make an instance of the
;;;        corresponding part, but use the given slot/value list to override
;;;        inherited slots
;;;        (3) if prototype is an object, then make an instance of it

(define-method :initialize aggregadget (agget &optional top-agg)
  (setq top-agg (or top-agg agget))
  (call-prototype-method agget)
  
  (let ((prototype (get-local-value agget :is-a))
	(parts-list (get-local-value agget :parts))
	(inter-list (get-local-value agget :interactors)))
    (setf (get-local-values agget :behaviors) nil)
    (cond ((or (null parts-list) 
	       (not (first-obj-in-parts-list 
		     (get-local-values prototype :components) parts-list)))
	   ;; create instances of components of a prototype aggregadget
	   (make-instances-from agget prototype top-agg)))
    (cond ((or (null inter-list) 
	       (not (first-obj-in-parts-list
		     (get-local-values prototype :behaviors) inter-list)))
	   (make-inters-from agget prototype)))
    (make-parts agget parts-list prototype top-agg)
    (make-interactors agget inter-list prototype)))


;;; add-local-component -- to an aggregadget
;;;
(define-method :add-local-component opal:aggregadget
  (agg gob &optional key where loc)
  (let ((name (get-local-value gob :known-as)))
    (cond (name
	   (s-value agg name gob)))
    ;; this would be just a call-prototype-method, but we have to 
    ;;  invoke :add-component, not :add-local-component
    (kr-send opal:aggregate :add-component agg gob key where loc)))


;;; add-local-interactor -- to an aggregadget or aggrelist
;;;
(define-method :add-local-interactor aggregadget (agg inter)
  (let ((name (get-local-value inter :known-as)))
    (cond (name
	   (s-value agg name inter)))
    (s-value inter :operates-on agg)
    (set-values agg :behaviors 
		(nconc (get-local-values agg :behaviors) (list inter)))))


;;; remove-local-interactor -- from an aggregadget or aggrelist
;;;
(define-method :remove-local-interactor aggregadget (agg inter)
  (let ((name (get-local-value inter :known-as)))
    (cond (name
	   (destroy-slot agg name)))
    (s-value inter :operates-on nil)
    (set-values agg :behaviors
		(delete inter (get-local-values agg :behaviors)))))


;;; remove-local-component -- from an aggregadget
;;;
(define-method :remove-local-component opal:aggregadget (agg gob)
  (let ((name (get-local-value gob :known-as)))
    (cond (name
	   (destroy-slot agg name)))
    (kr-send opal:aggregate :remove-component agg gob)))


;;; destroy-me -- gets interactors as well as components
;;;
(define-method :destroy-me opal:aggregadget (agg &optional (top-level-p t))
  (dolist (behavior (copy-list (get-local-values agg :behaviors)))
    (destroy behavior))
  (call-prototype-method agg top-level-p))


;;; make-parts - make components for aggregadgets and aggrelists
;;;
(defun make-parts (agget parts-list prototype top-agg)
  (dolist (part parts-list)
    (let (name protopart slots)
      (cond ((keywordp part)
	     (setf name part)
	     (setf protopart :modify))
	    ((functionp part)
	     (get-parts-from-function agget part))
	    ((and (listp part) (>= (length part) 2))
	     (setf name (get-name part))
	     (setf protopart (get-class-name part))
	     (setf slots (get-body part)))
	    (t
	     (error "bad part specification" part)))
      ;; now make an instance
      (cond ((eq protopart :omit))  ;; do nothing
	    ((eq protopart :modify)
	     (setf protopart (g-value prototype name))
	     (cond ((null protopart)
		    (format
		     t 
		     "Warning in AGGREGADGET-INITIALIZE-METHOD: ~S not found in ~
		     prototype, ignoring this part: ~A~%" name parts-list))
		   (t
		    (create-part name protopart slots agget prototype top-agg))))
	    ((functionp part)) ;; instances were created already
	    (t
	     (create-part name protopart slots agget prototype top-agg))))))
  

;;; make-interactors -- make interactors for aggregadgets and aggrelists
;;;
(defun make-interactors (agget inter-list prototype)
  ;; now do the interactors
  (dolist (inter inter-list)
    (let (name slots protointer)
      (cond ((listp inter)
	     (setf name (get-name inter))
	     (setf protointer (get-class-name inter))
	     (setf slots (get-body inter)))
	    ((keywordp inter)
	     (setf name inter)
	     (setf protointer :modify))
	    (t
	     (error "bad interactor specification" inter)))
      (cond ((eq protointer :omit))
	    ((eq protointer :modify)
	     (setf protointer (g-value prototype name))
	     (cond ((null protointer)
		    (format
		     t 
		     "Warning in AGGREGADGET-INITIALIZE-METHOD: ~S not found in ~
		     prototype, ignoring this inter: ~A~%" name inter-list))
		   (t
		    (create-inter name protointer slots agget))))
	    (t
	     (create-inter name protointer slots agget))))))



;;;
;;; test if the first component of agg is in the parts-list
;;;
(defun first-obj-in-parts-list (objects parts-list)
  (let (first-obj)
    (cond (objects
	   (setf first-obj (g-value (car objects) :known-as))
	   (member first-obj parts-list 
		   :test #'(lambda (a part) 
			     (eq a (if (keywordp part)
				       part
				       (get-name part))))))
				    
	  (t nil))))


;;;----------------------------------------------------------------------
;;; This part deals with creating a new aggregadget (a prototype).
;;; Basically, creating a prototype means creating its components according
;;; to the :parts slot, and its interactors according to the :interactors
;;; slot.
;;;
;;; For each part, an instance is created, added to the components
;;; of the aggregadget, and, if the part is named, a slot named after
;;; this part is created in the aggregadget. Its value is the instance
;;; of the interactor. Furthermore (still if the part is named), a
;;; :known-as slot is created in the part, whose value is the name of the part.
;;; This processing is recursive in order to deal with aggregadgets inside
;;; aggregadgets.
;;; For each interactor, an instance is created, added to the "behaviors"
;;; slot of the aggregadget, and, if the interactor is named, a slot
;;; named after the interactor is created in the aggregadget. Its value is
;;; the instance of the interactor. Furthermore (still if the interactor is
;;; named), a :known-as slot is created in the interactor, whose value is
;;; the name of the interactor.
;;;----------------------------------------------------------------------


;;;
;;; Make instances of the components of a prototype.
;;;

(defun make-instances-from (agget prototype top-agg)
  (dolist (component (get-local-values prototype :components))
    (create-part (g-value component :known-as)
		 component nil agget prototype top-agg)))


(defun create-part (name class slots agget agget-proto top-agg)
  (unless (schema-p class)
    (error "~A ~A ~A ~A~%   ~A ~A?"
	   "Is a comma missing before" class "in declaration of part" name
	   "of aggregadget" agget))
  (let ((new-component
	 (if name
	      (create-prototype NIL :name-prefix name (:is-a class))
	      (create-prototype NIL (:is-a class)))))
    (do ()
	((null slots))
      (let ((slot-name-and-values (car slots)))
	(setf slots (cdr slots))
	(cond ((member slot-name-and-values '(:inherit :inherit-values))
	       (inherit-values
		new-component (car slots) (g-value agget-proto name))
	       (setf slots (cdr slots)))
	      (t
	       (set-values new-component (car slot-name-and-values)
			   (cdr slot-name-and-values))))))
    (s-value new-component :parent agget)
    (if (or (is-a-p new-component aggregadget)
	    (is-a-p new-component aggrelist))
	(kr-send new-component :initialize new-component top-agg)
	(kr-send new-component :initialize new-component))
    ;	  (append-value agget :proto-components new-component)
    (s-value new-component :parent nil)
    (when name (s-value new-component :known-as name))
    (add-local-component agget new-component)))


;; This function puts a constraint between a part's slot and the corresponding
;; slot in the corresponding part of the object's prototype.  This is
;; only appropriate if the class of the part is not class of the part of the 
;; prototype.  For example, I might want to specify that a part named
;; :box is an opal:circle rather than an instance of the :box part in
;; the prototype.  Nevertheless, I might want to still inherit :left, :top,
;; :width, and :height from the prototype part.  
;; :inherit constructs a new formula unless the inherited slot
;; has a formula in which case the formula is inherited.  (Since formulas
;; will tend to use links, the value in the instance may not be the same
;; as in the prototype.)  [*inherit-formula* is a prototype for inherited
;; value formulas -- this is needed to mark these formulas so they can
;; be written out correctly.]  Using :is-a to mark formulas did not work
;; (kr bug?) so I set :aggregadget-inherited-flag to T instead.
;;
;; The parameters are:
;;     part: the part being created,
;;     slots: the slots to inherit,
;;     prototype: the corresponding part from which to inherit
;;     name: the name of the part (used for error messages)

;(setf *inherit-formula* (o-formula nil))

(defun inherit-values (part slots prototype)
  (cond ((null prototype)
	 (format 
	  t
	  "Warning - ~S cannot :inherit ~S because ~S is not a part in ~S~%"
	  part slots part prototype))
	(t 
	 (dolist (slot slots)
	   (inherit-value part slot prototype)))))


(defun inherit-value (part slot prototype)
  (let (the-formula)
    (cond ((and (setf the-formula (get-value prototype slot))
		(formula-p the-formula))
	   (s-value part slot (formula the-formula)))
	  (t
	   ;; the let is necessary to capture the value of slot in the
	   ;; closure created by o-formula:
	   (setf the-formula
		 (let ((myslot slot))
		   (s-value part slot (o-formula (gv prototype myslot)))))
	   (s-value the-formula :aggregadget-inherited-flag t)
	   ;(s-value the-formula :is-a *inherit-formula*)
	   ))))


;;;
;;; The processing of the interactors.
;;;

(defun make-inters-from (agget prototype)
  (dolist (inter (get-local-values prototype :behaviors))
    (create-inter (g-value inter :known-as) inter nil agget)))


(defun create-inter (name class slots agget)
  (unless (schema-p class)
    (error "Comma missing before ~A in declaration of interactor ~A~%   of aggregadget ~A."
	   class name agget))
  (let ((new-inter
	 (if name
	     (create-prototype NIL :name-prefix name (:is-a class))
	     (create-prototype NIL (:is-a class)))))
    (dolist (slot-name-and-values slots)
      (set-values new-inter (car slot-name-and-values)
		  (cdr slot-name-and-values)))
    (set-values agget :behaviors 
		(nconc (get-local-values agget :behaviors) (list new-inter)))
    (s-value new-inter :operates-on agget)
    (when name            ; the current inter has a name
      (s-value agget name new-inter)
      (s-value new-inter :known-as name))
    (kr-send new-inter :initialize new-inter)))

;;;
;;; Calls part-function and add all the objects returned
;;; by part-function as components of agget
;;;

(defun get-parts-from-function (agget part-function)
  (multiple-value-bind (components names)
		       (funcall part-function agget)
    (cond ((null names)
	   ;; the function did not return names for the parts
	   (dolist (new-component components)
	     (add-local-component agget new-component)))
	  (t
	   ;; the function did returned names for the parts
	   (do ((components-list components (cdr components-list))
		(names-list names (cdr names-list)))
	       ((or (null components-list) (null names-list)))
	     (let ((this-part (car components-list))
		   (this-part-name (car names-list)))
	       (when this-part-name
		 (s-value this-part :known-as this-part-name))
	       (add-local-component agget this-part)))))))


;;;
;;; Calls inter-function and add all the interactors returned
;;; by inter-function as behaviors of agget
;;;

(defun get-inters-from-function (agget inter-function)
  (multiple-value-bind (inters names)
		       (funcall inter-function agget)
    (if (null names)
	
	;; the function did not return names for the inters
	(dolist (new-inter inters)
	  (set-values agget :behaviors 
		      (nconc (get-local-values agget :behaviors) (list new-inter)))
	  (s-value new-inter :operates-on agget))
	
	;; the function did returned names for the inters
	(do ((inters-list inters (cdr inters-list))
	     (names-list names (cdr names-list)))
	    ((or (null inters-list) (null names-list)))
	  (let ((this-inter (car inters-list))
		(this-inter-name (car names-list)))
	    (set-values agget :behaviors 
			(nconc (get-local-values agget :behaviors)
			       (list this-inter)))
	    (s-value this-inter :operates-on agget)
	    (when this-inter-name    ; the current inter has a name
	      (s-value agget this-inter-name this-inter)
	      (s-value this-inter :known-as this-inter-name)))))))


;;;---------------------------------------------------------
;;; Macros to make the pathes to other objects more readable
;;;---------------------------------------------------------

;;; To access slots in a sibling object.
;;; (gvl-sibling :brother :top) will expand into:
;;; (gvl :parent :brother :top)
(defmacro gvl-sibling (name &rest slots)
    `(gvl :parent ,name ,@slots))


;;; Concatenated from type module "aggregadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/aggregadgets/f1.4/aggrelists.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie-Mellon University
;;; All rights reserved.  The CMU Software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;;
;;; AGGRELISTS. This subclass of aggregates allow to create easily
;;; list-type objects, such as menu. Aggrelists features automatic
;;; and customizable horizontal or vertical layout, generation of
;;; items according to a prototype, and can be used with aggregadgets
;;; in order to create complex composed objects.

#|
======================================================================
Change log:
       16 Jul 90 Dannenberg - Fixed destroy-me by adding NIL to call that
                       destroys the item-prototype-object
       16 Jul 90 Dannenberg - Changed compilation order: aggregadgets first
       27 Jun 90 Dannenberg - added remove-nth-item method, 
                       remove-nth-component function
        8 May 90 Dannenberg - major mods for new version
        11/03/89 Dario Guise fixed "form is being self-evaluated" warning
         9/28/89 Ed Pervin - Aggrelists can now have :interactors slot
         7/27/89 Philippe Marchal - optimized
         7/25/89 Philippe Marchal - removed the :aggrelist slot
         7/18/89 Philippe Marchal - added "add-item" and "remove-item"
	 7/13/89 Philippe Marchal - Merged with Aggregitems
	 7/13/89 Philippe Marchal - Reviewed, Changed to match KR V2.2
	 5/24/89 David    Kosbie  - Created
======================================================================
|#

(in-package "OPAL" :use '("KR" "LISP"))

(export '(aggrelist null-object add-local-item remove-local-item notice-items-changed
		    change-item remove-nth-item remove-nth-component))


;;;
;;; Macros that allow to call the methods as if they were functions.
;;;

(defmacro add-local-item (schema &rest args)
  `(kr-send ,schema :add-local-item ,schema ,@args))

(defmacro add-item (schema &rest args)
  `(kr-send ,schema :add-item ,schema ,@args))

(defmacro change-item (schema &rest args)
  `(kr-send ,schema :change-item ,schema ,@args))

(defmacro remove-local-item (schema &rest args)
  `(kr-send ,schema :remove-local-item ,schema ,@args))

(defmacro remove-item (schema &rest args)
  `(kr-send ,schema :remove-item ,schema ,@args))

(defmacro remove-nth-item (schema n)
  `(kr-send ,schema :remove-nth-item ,schema ,n))

(defmacro remove-nth-component (schema n)
  `(kr-send ,schema :remove-nth-component ,schema ,n))


(create-instance 'aggrelist opal:aggregate
 (:update-slots '(:items))
 (:left 0)
 (:top 0)
 (:direction :vertical)	;;; :horizontal or :vertical or NIL
 (:head nil)
 (:tail nil)
 (:h-spacing 5)		;;; Pixels between horizontal elements
 (:v-spacing 5)		;;; Pixels between vertical elements
 (:indent 0)		;;; How much to indent on wraparound
 (:h-align :left)	;;; Can be :left, :center, or :right
 (:v-align :top)	;;; Can be :top, :center, or :bottom
 (:max-width  (o-formula (let ((width 0))
			   (dovalues (c kr::*schema-self* :components)
			      (when (gv c :visible)
				(setq width (max width (gv c :width)))))
			   width)))
 (:max-height (o-formula (let ((height 0))
			   (dovalues (c kr::*schema-self* :components)
			      (when (gv c :visible)
				(setq height (max height (gv c :height)))))
			   height)))
 (:fixed-width-p NIL)		;;; Width Fields of fixed-size?
 (:fixed-height-p NIL)		;;; Height Fields of fixed-size?
 (:fixed-width-size NIL)
 (:fixed-height-size NIL)
 (:rank-margin NIL)     ;;; If non-NIL, then after this many components, a
                ;;; new row/column will be started for horizontal/vertical lists
 (:items NIL)           ;;; List of the items (when itemized)
 (:item-prototype NIL)  ;;; Specification of prototype of the items (when itemized)
 (:item-prototype-object NIL) ;;; the actual object
 (:base-left (o-formula (base-left-fn)))
 (:each-left (o-formula (each-left-fn)))
 (:base-top  (o-formula (base-top-fn)))
 (:each-top  (o-formula (each-top-fn)))
 (:fixed-width   (o-formula (fixed-width-fn)))
 (:fixed-height  (o-formula (fixed-height-fn)))
 
)

(defmacro num-or-zero (x)
	`(if (numberp ,x) ,x 0))

(defmacro destroy-constraints (schema &rest slots)
	`(dolist (slot ',slots) (destroy-constraint ,schema slot)))

(defmacro destroy-slots (schema &rest slots)
  	`(dolist (slot ',slots) (destroy-slot ,schema slot)))


;;; Aggrelists and aggregadgets share some methods.  This function copies
;;; a method from aggregadget to aggrelist.  Since aggregadgets.lisp is loaded
;;; first, the aggregadget method is created and ready to be copied.
;;;
(defun share-aggregadget-method (slot)
  (s-value aggrelist slot
	 (let ((fn (get-local-value aggregadget slot)))
	   (unless fn (error "a method is missing from aggregadget"))
	   (s-value aggrelist slot fn)
	   fn)))


(share-aggregadget-method :add-local-interactor)

(share-aggregadget-method :remove-local-interactor)


(define-method :change-item aggrelist (agg item n)
  (let ((items (g-value agg :items)))
    (cond ((or (>= n (length items))
	       (< n 0))
	   (warn "Bad index in change-item: ~A" n)
	   (return-from change-item-method-aggrelist)))
    (cond ((has-slot-p agg :items)
	   ;; destructively modify since it is local
	   )
	  (t
	   ;; make a copy to avoid clobbering a shared value
	   (setf items (copy-list items))))
    (s-value agg :items (fill (g-value agg :items) item :start n :end (1+ n)))
    (mark-as-changed agg :items)  ; in case anything depends on :items
    (notice-items-changed agg)))


;;; destroy-me -- gets interactors, item-prototype, as well as components
;;;
(define-method :destroy-me opal:aggrelist (agg &optional (top-level-p t))
  (let ((item-prototype (get-local-value agg :item-prototype-object)))
    (dolist (behavior (copy-list (get-local-values agg :behaviors)))
      (destroy behavior))
    (when item-prototype
      (destroy item-prototype NIL))
    (call-prototype-method agg top-level-p)))


(defun notice-items-changed (agg &optional no-propagation)
  (let ((prototype (g-value agg :item-prototype-object))
	(instances (get-local-values agg :is-a-inv)))
    (when prototype
      (let* ((old-num-comps (g-local-value agg :number-of-comps))
	     (items (g-value agg :items))
	     (new-num-comps (if (numberp items) items (length items))))
	(cond ((< old-num-comps new-num-comps)
	       (dotimes (i (- new-num-comps old-num-comps))
		 (add-local-component agg
				(create-instance NIL prototype)
				:tail)))
	      ((> old-num-comps new-num-comps)
	       (dotimes (i (- old-num-comps new-num-comps))
		 (remove-local-component agg (g-value agg :tail)))))
	(cond ((and (not no-propagation) (/= old-num-comps new-num-comps))
	       (dolist (inst instances)
		 (notice-items-changed inst))))
	(s-value agg :number-of-comps new-num-comps)))))


;; This stops gv's throw on nil...
(defun my-gv (schema &rest slots)
  (dolist (slot slots)
     (unless (setq schema (gv schema slot)) (return-from my-gv nil)))
  schema)

;; Changes slot value, whether or not it will be or used to be a formula

(defmacro c-value (frame slot new-value)
  `(progn
     (destroy-constraint ,frame ,slot)	;;; not always necessary!
     (s-value ,frame ,slot ,new-value)))

(create-instance 'null-object opal:view-object
	(:visible T))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;; Here come the default functions:
;;;; The following are installed in the aggrelist itself
(defun fixed-width-fn()
  (if (gvl :fixed-width-p)
     (or (gvl :fixed-width-size)
	 (gvl :max-width))))
(defun fixed-height-fn()
  (if (gvl :fixed-height-p)
     (or (gvl :fixed-height-size)
	 (gvl :max-height))))

;;;; The following are installed in the aggrelist itself, *and* instances
;;;; of formulas derived from these functions are installed into each component
;;;;

;;; each-left-fn computes the :left slot
;;;   the basic :left coordinate is determined from :pre-align-left, but
;;;   if this is a fixed-width field then the object may be aligned
;;;   within the field
;;;
(defun each-left-fn ()
   (let* ((pre-align-left (gvl :pre-align-left))
	  (my-agg-list     (gvl :parent))
	  (fixed-width  (gv my-agg-list :fixed-width)))
					;; Now handle alignment
    (if fixed-width
	(case (gv my-agg-list :h-align)
	    (:center
		(+ pre-align-left
		   (floor (/ (- fixed-width (gvl :width)) 2))))
	    (:right
		(+ pre-align-left (- fixed-width (gvl :width))))
	    (:left
		pre-align-left))
	pre-align-left)))


;;; each-top-fn computes the :top slot
;;;   the basic :top coordinate is determined from pre-align-top, but
;;;   if this is a fixed height field then the object may be aligned
;;;   within the field
(defun each-top-fn ()
   (let* ((pre-align-top (gvl :pre-align-top))
	  (my-agg-list     (gvl :parent))
	  (fixed-height (gv my-agg-list :fixed-height)))
					;; Now handle alignment
    (if fixed-height
	(case (gv my-agg-list :v-align)
	    (:center
		(+ pre-align-top
		   (floor (/ (- fixed-height (gvl :height)) 2))))
	    (:bottom
		(+ pre-align-top (- fixed-height (gvl :height))))
	    (:top
		pre-align-top))
	pre-align-top)))


;;; base-left-fn computes the nominal left coordinate of each object.
;;;   For horizontal lists, this is the left of the previously visible
;;;   object + the width (fixed or variable) + spacing.  For vertical
;;;   lists, this is just the left of the previously visible component.
;;;   base-left-fn ignores breaks in rows/columns, but see
;;;   pre-align-left-fn and each-left-fn, which refine :base-left to
;;;   arrive at :left
;;;
(defun base-left-fn ()
   (let  ((prev-vis     (gvl :prev-visible))
	  (my-agg-list     (gvl :parent)))
	(if prev-vis
	    (if (eq (gv my-agg-list :direction) :horizontal)
      		(+  (gv prev-vis :pre-align-left)
	     	    (or (gv my-agg-list :fixed-width) (gv prev-vis :width))
	 	    (gv my-agg-list :h-spacing))
      		(gv prev-vis :pre-align-left))
	    (gv my-agg-list :left))))


;;; base-top-fn -- computes the value of the :base-top slot in each element
;;;    of the list.  See base-left-fn for more details.
;;;
(defun base-top-fn ()
   (let  ((prev-vis     (gvl :prev-visible))
	  (my-agg-list     (gvl :parent)))
	(if prev-vis
	    (if (eq (gv my-agg-list :direction) :vertical)
      		(+  (gv prev-vis :pre-align-top)
	     	    (or (gv my-agg-list :fixed-height) (gv prev-vis :height))
	 	    (gv my-agg-list :v-spacing))
      		(gv prev-vis :pre-align-top))
	    (gv my-agg-list :top))))


;;; pre-align-left-fn computes the left coordinate of the field for this
;;;    component.  If there is no line break, then the value will be
;;;    :base-left; however, if there is a line break, then compute where
;;;    to go after a line-wrap:  If this is a horizontal row, then start
;;;    at the aggrelist.left+indentation; if this is a vertical row, then
;;;    start at the previously visible's :pre-align-left.
;;;
(defun pre-align-left-fn ()
  (let* ((my-agg-list (gvl :parent)))
    ;; Now check if must wrap around
    (if (gvl :line-break-p)
	(if (eq (gv my-agg-list :direction) :horizontal)
	    (+ (gv my-agg-list :left)
	       (gv my-agg-list :indent))
	    (+ (gvl :prev-visible :pre-align-left)
	       (or (gv my-agg-list :fixed-width)
		   (gvl :prev-visible :col-width))
	       (gv my-agg-list :h-spacing)))
	(gvl :base-left))))


;;; pre-align-top-fn -- computes the value of the :pre-align-top slot in
;;;    each element of the list.  See PRE-ALIGN-LEFT-FN for a description.
;;;
(defun pre-align-top-fn ()
   (let* ((my-agg-list  (gvl :parent)))
					;; Now check if must wrap around
    (if (gvl :line-break-p)
	  (if (eq (gv my-agg-list :direction) :vertical)
			(+ (gv my-agg-list :top)
			   (gv my-agg-list :indent))
			(+ (gvl :prev-visible :pre-align-top)
			   (or (gv my-agg-list :fixed-height)
			       (gvl :prev-visible :row-height))
			   (gv my-agg-list :v-spacing)))
	  (gvl :base-top))))


;;; compute the rank (index) of each component
;;;
(defun rank-fn ()
	(let ((previous-rank (my-gv :self :prev :rank)))
	  (if previous-rank (1+ previous-rank) 0)))


;;; prev-visible-fn -- computes a link to the previously visible component
;;;
(defun prev-visible-fn ()
	(let ((prev (gvl :prev)))
	   (if prev
		(if (gv prev :visible)
			prev
			(gv prev :prev-visible))
		nil)))


;(defun prev-item-fn ()
;	(let ((prev (gvl :prev)))
;	   (if prev
;	       (if (eq (gvl :prev :is-a)
;		       (gvl :parent :item-prototype-object))
;			prev
;			(gv prev :prev-item))
;		nil)))


;;; line-break-fn computes :line-break-p
;;;   by seeing if the row or column would extend beyond the margin
;;;   established by :rank-margin or :pixel-margin
;;;
(defun line-break-fn ()
  (let* ((rank (gvl :rank))
	 (my-agg-list  (gvl :parent))
	 rank-margin pixel-margin)
    ;; Now check if must wrap around
    (and (> rank 0)
	 (or (and (setf rank-margin (gv my-agg-list :rank-margin))
		  (eql (mod rank rank-margin) 0))
	     (and (setf pixel-margin (gv my-agg-list :pixel-margin))
		  (if (eq (gv my-agg-list :direction) :horizontal)
		      (> (- (+ (gvl :base-left) (gvl :width)) 
			    (gv my-agg-list :left))
			 pixel-margin)
		      (> (- (+ (gvl :base-top) (gvl :height)) 
			    (gv my-agg-list :top)) 
			 pixel-margin)
		      ))))))

;; Supports Add-Component's terminology (screen related):
;;	:front :back :behind :in-front :at
;; And also the corresponding names (list related):
;;      :tail  :head :before :after    :at
;;
;; Also, you can call it as (add-element list-agg element :where :head)
;; or you can simply omit the ':where' field (again, to be like Add-Component)
;;
;; The default is for :where is :tail
;;
;; The big inefficiency right now is that after it finds the element in
;; the :components slot, it eventually calls "call-prototype-method", which will
;; do the same thing all over again!

(define-method :add-local-component aggrelist (my-agg-list element &rest args)
 (let ((elements (get-local-values my-agg-list :components)) 
       where locator
       (name (get-local-value element :known-as)))
   (when (member element elements)
	(remove-local-component my-agg-list element))
   (cond (name
	  (s-value my-agg-list name element)))
   (cond ((eq (first args) :where)
	  (setq where (second args))
	  (setq locator (third args)))
	 ((first args)
	  (setq where (first args))
	  (setq locator (second args)))
	 (t (setq where :tail)))
   (when (g-value my-agg-list :direction)
     (s-value element :base-left (formula (get-value my-agg-list :base-left)))
     (s-value element :base-top  (formula (get-value my-agg-list :base-top )))
     (s-value element :left (formula (get-value my-agg-list :each-left)))
     (s-value element :top  (formula (get-value my-agg-list :each-top )))
     (s-value element :pre-align-left (o-formula (pre-align-left-fn)))
     (s-value element :pre-align-top  (o-formula (pre-align-top-fn)))
     (when (not (has-slot-p element :line-break-p))
       (s-value element :line-break-p (o-formula (line-break-fn))))
     (s-value element :row-height
	      (o-formula (if (gvl :line-break-p)
			     (gvl :height)
			     (let ((prev (gvl :prev-visible)))
			       (if prev
				   (max (gvl :height)
					(gv prev :row-height))
				   (gvl :height))))))
     (s-value element :col-width
	      (o-formula (if (gvl :line-break-p)
			     (gvl :width)
			     (let ((prev (gvl :prev-visible)))
			       (if prev
				   (max (gvl :width)
					(gv prev :col-width))
				   (gvl :width)))))))
   (s-value element :rank (o-formula (rank-fn)))
   (s-value element :prev-visible (o-formula (prev-visible-fn)))
   ;  (s-value element :prev-item (o-formula (prev-item-fn)))
   (do ((successful nil successful))	;;; This is better done with a GO
       (successful t)
     (setq successful t)			;;; So we must set to NIL for repeat
     (setq elements (get-local-values my-agg-list :components))
     (cond ((null (get-local-value my-agg-list :tail))	;;;; NEW LIST ???
	    (c-value element :prev nil)
	    (c-value element :next nil)
	    (c-value my-agg-list :tail element)
	    (c-value my-agg-list :head element)
	    (kr-send aggregate :add-component my-agg-list element))
	   ((or (eq where :front)
		(eq where :tail))
	    (let ((old-tail (get-local-value my-agg-list :tail)))
	      (c-value old-tail :next element)
	      (c-value element :next nil)
	      (c-value element :prev old-tail)
	      (c-value my-agg-list :tail element)
	      (kr-send aggregate :add-component 
		       my-agg-list element :where :front)))
	   ((or (eq where :back)
		(eq where :head))
	    (let ((old-head (get-local-value my-agg-list :head)))
	      (c-value old-head :prev element)
	      (c-value element :prev nil)
	      (c-value element :next old-head)
	      (c-value my-agg-list :head element)
	      (kr-send aggregate :add-component 
		       my-agg-list element :where :back)))
	   ((or (eq where :behind)		;;; Goes after 'behind-element'
		(eq where :before))
	    (let ((mem-sublist (member locator elements)))
	      (if mem-sublist
		  (let ((behind-element (g-value locator :prev)))
		    (setq mem-sublist (cdr mem-sublist))
		    (c-value element :prev behind-element)
		    (c-value element :next locator )
		    (c-value locator :prev element)
		    (if behind-element
			(c-value behind-element :next element)
			(c-value my-agg-list :head element))
		    (kr-send aggregate :add-component 
			     my-agg-list element :where :behind locator))
		  (progn
		    (warn "New element being placed at back of aggrelist.")
		    (setq where :back)		;;; Just put it at the back
		    (setq successful nil)))))	;;; by looping again
	   ((eq where :at)
	    (let ((count (length elements)))
	      (setq locator (max (num-or-zero locator) 0))
	      (setq locator (min locator count))
	      (cond ((eq locator 0) (setq where :back))
		    ((eq locator count) (setq where :front))
		    (t (setq locator (nth locator elements))
		       (setq where :before)))
	      (setq successful nil)))	;;; by looping again
	   ((or (eq where :in-front)	;;; Search list backwards!
		(eq where :after))
	    (let ((mem-sublist (member locator elements)))
	      (if mem-sublist
		  (let ((infront-element (g-value locator :next)))
		    (c-value element :prev locator)
		    (c-value element :next infront-element )
		    (c-value locator :next element)
		    (if infront-element
			(c-value infront-element :prev element)
			(c-value my-agg-list :tail element))
		    (kr-send aggregate :add-component
			     my-agg-list element :where :in-front locator))
		  (progn
		    (warn "New element being placed at front of aggrelist.")
		    (setq where :front)		;;; Just put it at the front
		    (setq successful nil)))))	;;; by looping again
	   (t (format t "***Illegal :where ('~S') in 'list-add'~%" where)
	      (format t "***  Defaulting, settting :where to :front~%")
	      (setq where :front)
	      (setq successful nil))))))


(define-method :remove-local-component aggrelist (my-agg-list element)
  (let ((next (g-value element :next))
	(prev (g-value element :prev))
	(name (get-local-value element :known-as)))
    (cond (name
	   (destroy-slot my-agg-list name)))
    (if (eq element (g-value my-agg-list :tail)) (c-value my-agg-list :tail prev))
    (if (eq element (g-value my-agg-list :head)) (c-value my-agg-list :head next))
    (if prev (c-value prev :next next))
    (if next (c-value next :prev prev))
    (destroy-constraints element :prev :next :rank :prev-visible)
    (when (g-value my-agg-list :direction)
      (destroy-constraints element :left :top :base-left :base-left
			   :pre-align-left :pre-align-top))
    (kr-send aggregate :remove-component my-agg-list element)
    ))


(define-method :initialize aggrelist (my-agg-list &optional (top-agg nil))
  (setq top-agg (or top-agg my-agg-list))
  (call-prototype-method my-agg-list)
  (create-items my-agg-list top-agg)
  (let ((prototype (g-value my-agg-list :is-a))
	(items-proto (get-local-value my-agg-list :item-prototype-object))
	(parts-list (get-local-value my-agg-list :parts))
	(inter-list (get-local-value my-agg-list :interactors)))
    (cond ((not items-proto)
	   ;	   (cond ((or (null parts-list)
	   ;		      (not (first-obj-in-parts-list
	   ;			    (get-values prototype :components) parts-list)))
	   ;	   (make-instances-from my-agg-list prototype top-agg)))
	   (make-parts my-agg-list parts-list prototype top-agg)))
    (cond ((or (null inter-list)
	       (not (first-obj-in-parts-list
		     (get-values prototype :behaviors) inter-list)))
	   (make-inters-from my-agg-list prototype)))
    (make-interactors my-agg-list inter-list prototype)))


;;;----------------------------------------------------------------------
;;; ITEMIZED AGGRELISTS. When all the components of an aggrelist are of a
;;; same type, they can be automatically created according to a prototype
;;; (specified in the :item-prototype slot, the actual instance is in the
;;; :item-prototype-object slot) and a list of items (given in the
;;; :items slot). Add-Local-Item and Remove-Local-Item allow to modify
;;; the items of an itemized aggrelist after it has been created.
;;;----------------------------------------------------------------------

;;;
;;; Create-Items uses the value of :items if it's a number, or its
;;; cardinality if it's a list, to create that very number of instances
;;; of :item-prototype-object.  Each of these instances is added as a component
;;; of the aggrelist.
;;;

(defun create-items (agg top-agg)
  (let ((source-value (g-value agg :items))
	(items-def (get-local-value agg :item-prototype))
	item-prototype-proto ; the prototype of the :item-prototype-object
	item-prototype number-of-comps)
      (cond ((null items-def)  ; no definition, try to take the default
	     (setf item-prototype-proto (g-value agg :item-prototype-object))
	     (cond (item-prototype-proto
		    (setf item-prototype
	           	  (call-create-instance item-prototype-proto
						nil agg top-agg)))))
      	    ((listp items-def)
	     ;; the item-prototype has a definition -> create it
	     (setf item-prototype-proto (car items-def))
	     (cond ((eq item-prototype-proto :modify)
		    ;; get prototype for :item-prototype from agg's prototype
		    (setf item-prototype-proto (g-value agg
						      :item-prototype-object))))
	     (setf item-prototype
		   (call-create-instance item-prototype-proto
					 (cdr items-def)
					 agg top-agg)))
	    (t (setf item-prototype items-def)))   ; else, it is a schema

      ;; now, if there is an item-prototype, this is an itemized aggrelist
      (cond (item-prototype
	     (setf number-of-comps 
		   (if (numberp source-value)
		       source-value
		       (length source-value)))
	     (s-value agg :item-prototype-object item-prototype)
	     (s-value agg :number-of-comps number-of-comps)
	     (dotimes (count number-of-comps)
		(add-local-component agg (create-instance NIL item-prototype)))))))


;;;
;;; Add-Local-Item adds a new item to an itemized aggrelist. This means adding
;;; the item (when supplied) in the :items list and calling 
;;; notice-items-changed.  An earlier implementation added an instance of
;;; :prototype directly to the components lists, but this "optimization"
;;; would fail if :items is inherited by another aggrelist.
;;; Optional arguments allow to
;;; specify the position of the new item and to specify on what to test in
;;; case of insertion in a multi-value items list.
;;;

(define-method :add-local-item aggrelist (agg &optional item &rest args)
  (let ((items (g-value agg :items))
	where locator key)
    (cond ((eq (first args) :where)
	   (setq where (second args))
	   (setq locator (third args)))
	  ((first args)
	   (setq where (first args))
	   (setq locator (second args)))
	  (t (setq where :front)))
    (when locator
      (if (eq (first args) :where)
	  (if (eq (fourth args) :key)
	      (setf key (fifth args))
	      (setf key #'no-func))
	  (if (eq (third args) :key)
	      (setf key (fourth args))
	      (setf key #'no-func))))
	   
    (cond ((null item)  ;; No specific item supplied -> just add an instance
	                ;; of :prototype-item in the components
	   (cond ((numberp items)
		  (s-value agg :items (1+ items)))
		 (t
		  (s-value agg :items (add-last nil items)))))
	  ((or (eq where :front)
	       (eq where :tail))
	   (s-value agg :items (add-last item items)))
	  ((or (eq where :back)
	       (eq where :head))
	   (push item (g-value agg :items)))
	  ((or (eq where :behind)
	       (eq where :before))
	   (s-value agg :items (add-before item locator items key)))
	  ((eq where :at)
	   (s-value agg :items (add-at item locator items)))
	  ((or (eq where :in-front)
	       (eq where :after))
	   (s-value agg :items (add-after item locator items key)))
	  (t (format t "***Illegal :where ('~S') ~%" where)
	     (format t "***  Defaulting, setting :where to :front~%") 
	     (s-value agg :items (add-last item items))))
    (notice-items-changed agg)
    NIL))
  
;;;
;;; Remove-Local-Item removes an item from an itemized aggrelist. 
;;; This means removing the item (when supplied) from the :items list 
;;; and calling notice-items-changed.
;;; An earlier implemntation just removed one of the
;;; components, but this would not handle inherited :items. 
;;; The :key argument allow to specify on what to test in case
;;; of suppression in a multi-value items list.
;;;
(define-method :remove-local-item aggrelist
  (agg &optional item &key (key #'no-func))
  (let ((items (g-value agg :items)))
    (cond ((null item)
	   (cond ((and (numberp items) (> items 0))
		  (s-value agg :items (1- items)))
		 ((numberp items)) ;; no items, do nothing
		 (t
		  ;; nbutlast trims 1 element from the end destructively
		  (s-value agg :items (nbutlast items))
		  ;; since new value might be eq old one, tell kr about change:
		  (mark-as-changed agg :items)  )))
	  (t 
	   (s-value agg :items (delete-elt item (g-value agg :items) key))))
    (notice-items-changed agg)))


;;; remove-nth -- remove the nth element of a list destructively
;;;
;;; find the nthcdr before the element and splice out the nth element
;;;
(defun remove-nth (n l)
  (cond ((= n 0) 
	 (cdr l))
	(t
	 (let ((c (nthcdr (1- n) l)))
	   (cond ((cdr c)
		  (setf (cdr c) (cddr c))))
	   l))))


(define-method :remove-nth-item aggrelist (agg n)
  (let ((items (g-value agg :items)))
    (cond ((numberp items)  ;; just remove any item
	   (remove-local-item agg))
	  (t
	   (s-value agg :items (remove-nth n items))
	   ;; since new value might eq old one, tell kr about the change
	   (mark-as-changed agg :items)
	   (notice-items-changed agg)))))


(define-method :remove-nth-component aggrelist (agg n)
  (let ((target (nth n (get-local-values agg :components))))
    (cond (target
	   (remove-local-component agg target)))))


;;;-----------------------------------------------
;;; Miscelaneous function for itemized aggrelists.
;;;-----------------------------------------------

(defun call-create-instance (class slots agget top-agg)
  (unless (schema-p class)
    (error "~A ~A ~A ~A~%?"
	   "Is a comma missing before" class
	   "in declaration of :item-prototype of aggrelist" agget))
  (let ((item-prototype (create-prototype NIL (:is-a class))))
    (do ()
	((null slots))
      (let ((slot-name-and-values (car slots)))
	(setf slots (cdr slots))
	(cond ((member slot-name-and-values '(:inherit :inherit-values))
	       (inherit-values
		item-prototype (car slots) (g-value agget
						    :item-prototype-object))
	       (setf slots (cdr slots)))
	      (t
	       (set-values item-prototype (car slot-name-and-values)
			   (cdr slot-name-and-values))))))
    (if (or (is-a-p item-prototype aggregadget)
	    (is-a-p item-prototype aggrelist))
	(kr-send item-prototype :initialize item-prototype top-agg)
	(kr-send item-prototype :initialize item-prototype))
    item-prototype))


;;; Performs a call to create instance with class-name as prototype
;;; and def as argument list (slot values).
#+OBSOLETE
(defun call-create-instance (slot-definitions class-name)
  (let ((schema (create-schema nil)))
    (s-value schema :is-a (eval class-name))
    (dolist (definition slot-definitions)
      (let ((value (cdr definition)))
	(if (and value (listp value))
	    (set-values schema (car definition) value)
	    (s-value schema (car definition) value))))
    schema))
#+OBSOLETE
(defun call-create-instance (def class-name)
  `(create-instance NIL
		    ,class-name
		    ,.def))


 
;;; Adds elt at the end of list.
(defun add-last (elt list)
  (nreverse (cons elt (reverse list))))

;;; Adds elt at the index position of list.
(defun add-at (elt index list)
  (let ((new-list NIL) (cptr 0))
    (dolist (current-elt list)
      (when (eq cptr index)
	(push elt new-list))
      (push current-elt new-list)
      (incf cptr))
    (when (> index cptr)
      (push elt new-list))
    (nreverse new-list)))

;;; Adds elt before here in list, using key to do the matching.
(defun add-before (elt here list key)
  (let ((new-list NIL) (found NIL))
    (dolist (current-elt list)
      (if (and (null found)
	       (or (equal here (funcall key current-elt))
		   (and (listp here) (equal (funcall key here)
					    (funcall key current-elt)))))
	  (progn
	    (push elt new-list)
	    (push current-elt new-list)
	    (setf found T))
	  (push current-elt new-list)))
    (if (null found)
	(setf new-list (cons elt (nreverse new-list)))
	(setf new-list (nreverse new-list)))
    new-list))

;;; Adds elt after here in list, using key to do the matching.
(defun add-after (elt here list key)
  (let ((new-list NIL) (found NIL))
    (dolist (current-elt list)
      (if (and (null found)
	       (or (equal here (funcall key current-elt))
		   (and (listp here) (equal (funcall key here)
					    (funcall key current-elt)))))
	  (progn
	    (push current-elt new-list)
	    (push elt new-list)
	    (setf found T))
	  (push current-elt new-list)))
    (when (null found)
      (push elt new-list))
    (nreverse new-list)))

;;; Removes elt from list, using key to do the matching.
(defun delete-elt (elt list key)
  (let ((new-list NIL) (found NIL))
    (dolist (current-elt list)
      (if (and (null found)
	       (or (equal elt (funcall key current-elt))
		   (and (listp elt) (equal (funcall key elt)
					   (funcall key current-elt)))))
	  (setf found T)
	  (push current-elt new-list)))
    (nreverse new-list)))

;;; No-function: used as default value for the matching function.
(defun no-func (x) x)



;;; Concatenated from type module "aggregadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/aggregadgets/f1.4/add-agg.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;; 
;;; ______________________________________________________________________ 
;;;
;;; The Garnet User Interface Development Environment 
;;; Copyright (c) 1989, 1990 Carnegie-Mellon University 
;;; All rights reserved.  The CMU Software Licensing Agreement specifies 
;;; the terms and conditions for use and redistribution.  
;;; ;;; If you want to use this code or anything developed as part of the 
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).  
;;; ______________________________________________________________________ 
;;;
;;; Add a component to an aggregadget and its instances.
;;; 
;;; Roger B. Dannenberg, 1990

#|
======================================================================
Change log:
======================================================================
|#

#| Implementation details:

ADD-COMPONENT
Call add-local-component to add a new component at the prototype level.
Then go to each instance and recursively call add-component.
The insert point will be determined as follows:
  The default position is :front.
  If the position is :front/:tail, always insert at the :front.
  If the position is :back/:head, always insert at the :back.
  If the position is :behind/:before x, then
    if the instance aggregadget has a component that is an instance of x, then
      insert :behind the instance of x,
    otherwise if the instance aggregadget has a component y named xn, where
         x is :known-as xn, then
      insert :behind y
    otherwise, print a warning and insert at the :front  (the philosophy
      here is to err toward the front, making errors visible).
  If the position is :in-front/:after x, then the situation is analogous to
    :behind/:before.
  If the position is :at, then use :at and the same locator on each
    instance.

ADD-ITEM
Works just like add-component, but acts on :items slots.  If an
instance inherits its :item slot, then no local changes are made.
After the changes are made, notice-items-changed is called on each 
affected aggrelist.

|#

(in-package "OPAL" :use '("LISP" "KR"))
(export '(add-item remove-item add-interactor remove-interactor
		   take-default-component replace-item-prototype-object))

;;; duplicate code, removed -fer 21-Jul-91
;(defmacro add-item (schema &rest args)
;  `(kr-send ,schema :add-item ,schema ,@args))
;
;(defmacro remove-item (schema &rest args)
;  `(kr-send ,schema :remove-item ,schema ,@args))

(defmacro add-interactor (schema &rest args)
  `(kr-send ,schema :add-interactor ,schema ,@args))

(defmacro remove-interactor (schema &rest args)
  `(kr-send ,schema :remove-interactor ,schema ,@args))

(defmacro take-default-component (schema &rest args)
  `(kr-send ,schema :take-default-component ,schema ,@args))

(defmacro replace-item-prototype-object (schema &rest args)
  `(kr-send ,schema :replace-item-prototype-object ,schema ,@args))


(define-method :add-component aggregadget (agg element &rest args)
  (let (where locator known-as)
    (cond ((eq (first args) :where)
	   (setq where (second args))
	   (setq locator (third args)))
	  ((first args)
	   (setq where (first args))
	   (setq locator (second args)))
	  (t
	   (setq where :tail)))

    ;; first add to prototype
    (add-local-component agg element where locator)

    ;; now do instances
    (setf known-as (get-local-value agg :known-as))
    (dolist (agg-instance (get-local-values agg :is-a-inv))
      (let ((element-instance (create-instance nil element))
	    (my-where where)
	    my-locator)
	(s-value element-instance :known-as known-as)
	(cond ((member where '(:front :tail :back :head)))
	      ((member where '(:behind :before :in-front :after))
	       ;; see if instance of locator is in agg-instance
	       (setf my-locator (find-locator-instance locator agg-instance))
	       (cond (my-locator) ; no problem
		     (t           ; put new component at the :front
		      (setf my-where :front))))
	      ;; otherwise this must be an :at
	      (t (setf my-locator locator)))
	(add-component agg-instance element-instance my-where my-locator)))))


(share-aggregadget-method :add-component)


;;; add-interactor -- add an interactor to prototype and instances
;;;
(define-method :add-interactor aggregadget (agg interactor)
  (let (known-as)
    ;; first add to prototype
    (add-local-interactor agg interactor)

    ;; now do instances
    (setf known-as (get-local-value agg :known-as))
    (dolist (agg-instance (get-local-values agg :is-a-inv))
      (let ((interactor-instance (create-instance nil interactor)))
	(s-value interactor-instance :known-as known-as)
	(add-interactor agg-instance interactor-instance)))))


(share-aggregadget-method :add-interactor)


;;; find-locator-instance -- find a locator in agg-instance that corresponds
;;;  to locator, presumed to be a member of the prototype of agg-instance
;;;
(defun find-locator-instance (locator agg-instance)
  (let ((agg-instance-components (get-local-values agg-instance :components))
	my-locator ; the locator we are trying to find
	known-as)  ; the :known-as field of locator

    ;; first look to see if locator has an instance in agg-instance
    (dolist (locator-instance (get-local-values locator :is-a-inv))
      (cond ((member locator-instance agg-instance-components)
	     (setf my-locator locator-instance)
	     (return))))

    ;; if that fails, then look for a component with the same name as locator
    (cond ((null my-locator)
	   (setf known-as (get-local-value locator :known-as))
	   (cond (known-as
		  (setf my-locator (get-local-value agg-instance known-as))))))

    ;; if no locator was found, then print a warning
    (cond ((null my-locator)
	   (warn "~A ~A in aggregate ~A~%~A ~A."
		 "No component corresponding to locator"
		 locator (g-value locator :parent)
		 "could be found for aggregate " agg-instance)))

    my-locator))


;;; remove-component -- remove a component from an aggregate and 
;;;   remove instances of the component from instances of the aggregate
;;;
;;; NOTE: we could do a quick-and-dirty job by just removing all instances
;;;  of component from their :parents, but the :parent might not be an
;;;  instance of agg, and we would not get components with the same name.
;;; To get everything but not too much, we will
;;;  (1) remove all instances from parents IF the parent :is-a this agg
;;;  (2) remove all parts that have the same name (:known-as) from the
;;;      aggregate's instances
;;;
(define-method :remove-component aggregadget (agg component &optional destroy?)
  (let ((component-instances (get-local-values component :is-a-inv))
	(known-as (get-local-value component :known-as)))
    (dolist (instance component-instances)
      (let ((parent (get-local-value instance :parent)))
	(cond ((is-a-p parent agg)
	       (remove-component parent instance destroy?)))))
    (cond (known-as
	   (dolist (agg-instance (get-local-values agg :is-a-inv))
	     (let ((component (get-local-value agg-instance known-as)))
	       (cond (component
		      (remove-component 
		       agg-instance component destroy?)))))))
    (remove-local-component agg component)
    (cond (destroy?
	   (destroy component)))))


(share-aggregadget-method :remove-component)


;;; remove-interactor
;;;
(define-method :remove-interactor aggregadget (agg interactor &optional destroy?)
  (let ((interactor-instances (get-local-values interactor :is-a-inv))
	(known-as (get-local-value interactor :known-as))) ; 
    (dolist (instance interactor-instances)
      (let ((parent (get-local-value instance :operates-on)))
	(cond ((is-a-p parent agg)
	       (remove-interactor parent instance destroy?)))))
    (cond (known-as
	   (dolist (agg-instance (get-local-values agg :is-a-inv))
	     (let ((interactor (get-local-value agg-instance known-as)))
	       (cond (interactor
		      (remove-interactor 
		       agg-instance interactor destroy?)))))))
    (s-value interactor :active nil)
    (remove-local-interactor agg interactor)
    (cond (destroy?
	   (destroy interactor)))))


(share-aggregadget-method :remove-interactor)


;;; take-default-component -- remove a component and inherit default from prototype
;;;
;;; NOTICE that the argument is the NAME of the component to remove.  An instance
;;; of the default prototype (if there is one) is placed :in-front of the 
;;; appropriate component using add-component so that this change 
;;; propagates down to instances of agg.  If this component is not :in-front
;;; of anything, then :back is used.
;;;
(define-method :take-default-component aggregadget (agg name &optional destroy?)
  (let ((component (get-local-value agg name))
	(proto-agg (get-local-value agg :is-a))
	(where :in-front)
	locator)
    ;; if the component exists locally, remove it
    (cond (component
	   (remove-component agg component destroy?)))

    ;; find the new prototype component in the prototype aggregadget
    (setf component (get-local-value proto-agg name))

    (cond (component
	   ;; find the element before component to serve as a locator
	   (dolist (element (get-local-values proto-agg :components))
	     (if (eq element component) (return))
	     (setf locator element))))

    ;; map the locator into the current agg if possible, if there is no
    ;; locator, then the component is at the :back of the prototype; if
    ;; the locator has no instance in agg, then put the instance at the
    ;; :front.
    (cond (locator
	   (setf locator (find-locator-instance locator agg))
	   
	   (cond ((null locator)
		  (setf where :front)))) ; mapping failed, move to :front
	  (t 
	   (setf where :back))) ; null locator -> :back of aggregate

    ;; install a new prototype
    (cond (component
	   (add-component agg (create-instance nil component)
				where locator)))))


(share-aggregadget-method :take-default-component)


(define-method :add-item aggrelist (agg &optional item &rest args)
  (let (where locator key)
    (cond ((eq (first args) :where)
	   (setq where (second args))
	   (setq locator (third args)))
	  ((first args)
	   (setq where (first args))
	   (setq locator (second args)))
	  (t (setq where :front)))
    (when locator
      (if (eq (first args) :where)
	  (if (eq (fourth args) :key)
	      (setf key (fifth args))
	      (setf key #'no-func))
	  (if (eq (third args) :key)
	      (setf key (fourth args))
	      (setf key #'no-func))))

    ;; first add to the prototype
    (add-local-item agg item where locator :key key)

    ;; now do instances
    (dolist (agg-instance (get-local-values agg :is-a-inv))
      (cond ((has-slot-p agg-instance :items)
	     (add-item agg-instance item where locator :key key))
	    ;; otherwise, :items is inherited, so notice-items-changed 
	    ;; already did the work
	    ))))


(define-method :remove-item aggrelist (agg &optional item &key (key #'no-func))
  ;; first remove from the prototype
  (remove-local-item agg item :key key)

  ;; now do instances
  (dolist (agg-instance (get-local-values agg :is-a-inv))
    (cond ((has-slot-p agg-instance :items)
	   (remove-item agg-instance item :key key))
	  ;; otherwise, items is inherited, so notice-items-changed
	  ;; already did the work
	  )))


;;; replace the item-prototype slot and propagate the change to instances
;;; implementation: replace the top-most item-prototype and follow the
;;; agg's is-a-inv links to find instances whose item-prototypes are instances
;;; of the old item-prototype.  Replace these with instances of the new 
;;; item-prototype, and do this recursively down the instance tree.
;;; Now fix up the items: destroy all elements and call notice-items-changed
;;;
(define-method :replace-item-prototype-object aggrelist (agg item-proto)
  (let ((old-proto (g-value agg :item-prototype-object)))
    (dolist (agg-instance (get-local-values agg :is-a-inv))
      (cond ((is-a-p (g-value agg-instance :item-prototype-object) old-proto)
	     (replace-item-prototype-object agg-instance
					    (create-instance nil item-proto)))))
    (s-value agg :item-prototype-object item-proto)
    (remove-all-components agg)
    (s-value agg :number-of-comps 0)
    (notice-items-changed agg t)))



;;; Concatenated from type module "aggregadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/aggregadgets/f1.4/aggregadgets-changes.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : aggregadgets-changes.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Sun Jul 21 17:09:23 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Sun Jul 28 16:01:19 1991
;;;; Update Count    : 2
;;;; 
;;;; PURPOSE
;;;; 	
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;; Concatenated from type module "gadgets" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/gadgets/f1.4/gadgets-loader.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;; 
;;;___________________________________________________________________
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;___________________________________________________________________
;;;
;;; 20-Nov-91 -FER changed doc strings and if-debugs and dbprint-*s

#|
==================================================================
Change log:
	 03/14/91 Edward Pervin - Added motif-gauge,
			 motif-scrolling-labeled-box, motif-prop-sheen-win
         01/17/91 Andrew Mickish - Added motif gadgets
         08/10/90 Pavan Reddy - Changed "multi-feedback" to "polyline-creator"
         08/07/90 Pavan Reddy - Added "multi-feedback" and "scrolling-window"
         07/16/90 Andrew Mickish - Added "browser-gadget"
         06/18/90 Andrew Mickish - Removed "v-slider-parts" and added
                       "scrolling-input-string" and "scrolling-labeled-box"
	 03/22/90 Robert Cook - Define the package "GARNET-GADGETS"
				for the TI Explorer
         03/26/90 Andrew Mickish - Added scrolling-menu and error-gadget
         01/05/90 Andrew Mickish - Added setf's and provide's
	 1/4/90   Ed Pervin - Added version number
         10/19/89 Andrew Mickish - Updated to include entire gadgets
         08/11/89 Brad Myers - Put into standard form
         08/01/89 Andrew Mickish - created
==================================================================
|#

(in-package "USER" :use '("LISP"))

(defparameter Gadgets-Version-Number "1.0")

;(format t "Loading Gadgets...~%")
;(setf *load-verbose* t)
;
;;; check first to see if place is set
;(unless (boundp 'Garnet-Gadgets-PathName)
;  (error "Load 'Garnet-Loader' first to set Garnet-Gadgets-PathName before loading Gadgets."))
;
;;;; Load Aggregadgets unless already loaded  (this will load others if necessary)
;#+cmu
;(unless (get :garnet-modules :aggregadgets)
;  (load Garnet-Aggregadgets-Loader))
;
;#+(not cmu)
;(require 'aggregadgets Garnet-Aggregadgets-Loader)
;
;#+explorer
;(unless (find-package "GARNET-GADGETS")
;  (make-package "GARNET-GADGETS" :use '("LISP" "KR")))
;
;;; ---- Load gadgets files
;
;(Defvar Garnet-Gadgets-Files   ;; defvar rather than defparameter so can setq
;                               ;; this variable before loading if only want
;                               ;; to compile some of these files
;  '(
;    "GAD-scroll-parts"    ;;  Helper modules containing definitions for 
;    "GAD-slider-parts"    ;;    scroll bar and slider objects
;    "GAD-v-arrows"
;    "GAD-v-boxes"
;    "GAD-h-arrows"
;    "GAD-h-boxes"
;
;    "v-scroll-bar"
;    "h-scroll-bar"
;    "v-slider"
;    "h-slider"
;    "trill-device"       ;;  A horizontal slider without the shaft
;
;    "GAD-button-parts"    ;;  Helper module for button and menu objects
;    "x-buttons"
;    "text-buttons"
;    "radio-buttons"
;
;    "error-gadget"
;    "scrolling-menu"
;
;    "scrolling-input-string"
;    "scrolling-labeled-box"
;
;    "gauge"              ;;  Semi-circular gauge
;    "menu"
;    "labeled-box"        ;;  A box with editable text and a label
;    "arrow-line"         ;;  A line/arrowhead combination
;    "graphics-selection" ;;  Selection squares for move-grow interaction
;
;    "browser-gadget"
;    "polyline-creator"
;    "multi-selection"
;
;    "scrolling-window-parts"
;    "scrolling-window"
;
;    "prop-value-gadgets"
;    "prop-sheet"
;    "prop-sheet-win"
;
;    "motif-parts"
;    "motif-v-scroll-bar"
;    "motif-h-scroll-bar"
;    "motif-slider"
;    "motif-text-buttons"
;    "motif-check-buttons"
;    "motif-radio-buttons"
;    "motif-menu"
;    "motif-gauge"
;    "motif-scrolling-labeled-box"
;    "motif-prop-sheet-win"
;    "motif-scrolling-window"
;    ))
;
;
;(dolist (file Garnet-Gadgets-Files)
;  (load (merge-pathnames file 
;                         #+cmu "gadgets:"
;                         #+(not cmu) Garnet-Gadgets-PathName
;                         )
;        :verbose T))
;
;
;
;(setf (get :garnet-modules :gadgets)  t)
;(setf (get :garnet-modules :GAD-scroll-parts) t)
;(setf (get :garnet-modules :GAD-slider-parts) t)
;(setf (get :garnet-modules :GAD-v-arrows) t)
;(setf (get :garnet-modules :GAD-v-boxes) t)
;(setf (get :garnet-modules :GAD-h-arrows) t)
;(setf (get :garnet-modules :GAD-h-boxes) t)
;(setf (get :garnet-modules :v-scroll-bar) t)
;(setf (get :garnet-modules :h-scroll-bar) t)
;(setf (get :garnet-modules :v-slider) t)
;(setf (get :garnet-modules :h-slider) t)
;(setf (get :garnet-modules :trill-device) t)
;(setf (get :garnet-modules :GAD-button-parts) t)
;(setf (get :garnet-modules :x-buttons) t)
;(setf (get :garnet-modules :text-buttons) t)
;(setf (get :garnet-modules :radio-buttons) t)
;(setf (get :garnet-modules :gauge) t)
;(setf (get :garnet-modules :menu) t)
;(setf (get :garnet-modules :labeled-box) t)
;(setf (get :garnet-modules :arrow-line) t)
;(setf (get :garnet-modules :graphics-selection) t)
;(setf (get :garnet-modules :browser-gadget) t)
;(setf (get :garnet-modules :polyline-creator) t)
;(setf (get :garnet-modules :scrolling-window-parts) t)
;(setf (get :garnet-modules :scrolling-window) t)
;(setf (get :garnet-modules :scrolling-input-string) t)
;(setf (get :garnet-modules :scrolling-labeled-box) t)
;(setf (get :garnet-modules :multi-selection) t)
;(setf (get :garnet-modules :prop-value) t)
;(setf (get :garnet-modules :prop-sheet) t)
;(setf (get :garnet-modules :prop-sheet-win) t)
;(setf (get :garnet-modules :motif-parts) t)
;(setf (get :garnet-modules :motif-v-scroll-bar) t)
;(setf (get :garnet-modules :motif-h-scroll-bar) t)
;(setf (get :garnet-modules :motif-slider) t)
;(setf (get :garnet-modules :motif-text-buttons) t)
;(setf (get :garnet-modules :motif-check-buttons) t)
;(setf (get :garnet-modules :motif-radio-buttons) t)
;(setf (get :garnet-modules :motif-gauge) t)
;(setf (get :garnet-modules :motif-menu) t)
;(setf (get :garnet-modules :motif-scrolling-labeled-box) t)
;(setf (get :garnet-modules :motif-scrolling-window) t)
;(setf (get :garnet-modules :motif-prop-sheen-win) t)

#-release-garnet(provide 'GAD-scroll-parts)
#-release-garnet(provide 'GAD-slider-parts)
#-release-garnet(provide 'GAD-v-arrows)
#-release-garnet(provide 'GAD-v-boxes)
#-release-garnet(provide 'GAD-h-arrows)
#-release-garnet(provide 'GAD-h-boxes)
#-release-garnet(provide 'v-scroll-bar)
#-release-garnet(provide 'h-scroll-bar)
#-release-garnet(provide 'v-slider)
#-release-garnet(provide 'h-slider)
#-release-garnet(provide 'trill-device)
#-release-garnet(provide 'GAD-button-parts)
#-release-garnet(provide 'x-buttons)
#-release-garnet(provide 'text-buttons)
#-release-garnet(provide 'radio-buttons)
#-release-garnet(provide 'gauge)
#-release-garnet(provide 'menu)
#-release-garnet(provide 'scrolling-input-string)
#-release-garnet(provide 'scrolling-labeled-box)
#-release-garnet(provide 'labeled-box)     
#-release-garnet(provide 'arrow-line)       
#-release-garnet(provide 'graphics-selection)
#-release-garnet(provide 'browser-gadget)
#-release-garnet(provide 'polyline-creator)
#-release-garnet(provide 'multi-selection)
#-release-garnet(provide 'prop-value)
#-release-garnet(provide 'prop-sheet)
#-release-garnet(provide 'prop-sheet-win)
;(provide 'motif-parts)
;(provide 'motif-v-scroll-bar)
;(provide 'motif-h-scroll-bar)
;(provide 'motif-slider)
;(provide 'motif-text-buttons)
;(provide 'motif-check-buttons)
;(provide 'motif-radio-buttons)
;(provide 'motif-menu)
;(provide 'motif-gauge)
;(provide 'motif-scrolling-labeled-box)
;(provide 'motif-scrolling-window)
;(provide 'motif-prop-sheet-win)

;(format t "...Done Gadgets.~%")

