
;;; Concatenated from type module "general" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/general/f1.4/garnet-loader.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 
;;; This file loads all the garnet modules.
;;; 
;;; ** To prevent certain parts from being loader, first set
;;;      user::load-XX-p to NIL.
;;; ** To get some of the parts which are not loaded by default to be loaded,
;;;    set user::load-XX-p to T.
;;; ** If you are a non-CMU user, set Your-Garnet-Pathname to be your local
;;;    Garnet directory, and set Your-CLX-Pathname to be your local CLX
;;;    directory.
;;; ** To override where something is loaded from, set Garnet-xx-PathName
;;;    before loading this file and/or Garnet-xx-src
;;;
;;; The controlling variables are:
;;; 
;;;      load-clx-p          (Default: NIL  => clx not loaded)
;;;      load-kr-p           (Default: T  => kr loaded)
;;;      load-opal-p         (Default: T  => opal loaded)
;;;      load-inter-p        (Default: T  => interactors loaded)
;;;      load-aggregadgets-p (Default: T  => aggregadgets loaded)
;;;      load-aggregraphs-p  (Default: NIL => aggregraphs *NOT* loaded)
;;;      load-gadgets-p      (Default: NIL  => gadgets *NOT* loaded)
;;;      load-debug-p        (Default: T  => debugging tools loaded)
;;;      load-demos-p        (Default: NIL  => demos *NOT* loaded)
;;;      load-gilt-p         (Default: NIL  => gilt *NOT* loaded)
;;;      load-lapidary-p     (Default: NIL  => lapidary *NOT* loaded)
;;;
;;; The first part of this file lists the file names where the various
;;; parts of Garnet come from.  This will need to be modified for each new
;;; installation of Garnet.
;;;
;;; To override any particular file name place, it is only necessary to
;;; assign the variable name Garnet-XX-Pathname before this file is loaded
;;; (since they are defined here using defvar, the old name will stay in
;;; affect).
;;;



#|
============================================================
Change log:
	 4/25/91 Ed Pervin - Official release of version 1.4; alpha
				directory changed back to test.  No longer
				support :cmu-lucid3.1 and :cmu-lucid4.0
	 4/19/91 Ed Pervin - Added lispworks to switches	 
	 4/15/91 Ed Pervin - Changed (make-packages **) to
			   (unless (find-package **) (make-package **))
	 4/3/91 Ed Pervin - Changed :sparc-test4.0 --> :sparc-test and
				added :pmax-test.
	 3/21/91 Ed Pervin - Release 1.4; test directory changed to alpha.
         3/7/91 Andrew Mickish - added aggregraphs
	 3/7/91 Brad Myers - made new motif-gilt-loader, and also garnet-load
	 3/1/91 Ed Pervin - added :sparc-test for version compiled in Allegro 4.0
         2/27/91 Dilip D'Souza - added everything with #+allegro-v4.0 switches
	 2/25/91 Ed Pervin - pushed :garnet on *features* list.
         1/24/91 Andrew Mickish - Added Gilt
         1/2/90 Andrew Mickish - Added :rt-test and :sparc-test options.
         11/29/90 Brad Myers - Added :cmu-sparc option.
	 10/5/90 Ed Pervin - New variables Your-Garnet-Pathname and ; 
			Your-CLX-Pathname which determine all the
			:external pathnames.
	 8/9/90 Ed Pervin - Release 1.3
	 8/7/90 Ed Pervin - rbd --> ecp
	 7/25/90 Ed Pervin - Added *dont-load-modules-twice*
			    amickish --> preddy
	 4/2/90 Ed Pervin - Call xlib:load-clx in Lucid explicitly.
	 3/19/90 Ed Pervin - Got rid of Garnet-Font-Pathname
	 2/14/90 Ed Pervin - Added color screen option
	 1/4/90 Ed Pervin - Added :external option and version number
         12/19/89 Ed Pervin - Now loads CLX.
         12/13/89 Ed Pervin - Added :cmu-allegro option.
         12/5/89 Brad Myers - Fixed so works with garnet-compiler
         10/30/89 Brad Myers - New file structure and src directories,
				Change dont-load-xx to load-xxx-p
         10/17/89 Brad Myers - Added debug
         8/18/89 Brad Myers - Added Toolkit
         6/7/89 Brad Myers - Created
============================================================
|#

;; The function provide is no longer part of common lisp and so was
;; removed from the lisp package in the most recent release of
;; LispWorks (version 2.1 onwards). This will retrieve its definition.
;#+lispworks (setf (symbol-function 'lisp::provide)
;                  (symbol-function 'system::provide))
;#+lispworks (export 'provide 'lisp)

#+allegro-v4.0
(setf excl::*cltl1-in-package-compatibility-p* t)
#+allegro-v4.0
(setf comp:*cltl1-compile-file-toplevel-compatibility-p* t)

(in-package "USER" :use '("LISP"))

#+(or allegro-v4.0 lispworks)
(progn
  (unless (find-package "KR")
	  (make-package "KR" :use '("LISP" "CLTL1")))
  (unless (find-package "KR-DEBUG")
	  (make-package "KR-DEBUG" :use '("LISP" "CLTL1")))
  (unless (find-package "OPAL")
	  (make-package "OPAL" :use '("LISP" "KR" "CLTL1")))
  (unless (find-package "GARNET-GADGETS")
	  (make-package "GARNET-GADGETS" :use '("LISP" "CLTL1")))
  (unless (find-package "GARNET-DEBUG")
	  (make-package "GARNET-DEBUG" :use '("OPAL" "KR" "LISP" "CLTL1")))
  (unless (find-package "INTERACTORS")
	  (make-package "INTERACTORS" :use '("KR" "LISP" "CLTL1"))))

(defparameter Garnet-Version-Number "1.4")
(push :GARNET *features*)
(push :GARNET-V1.4 *features*)

;; 0 is primary screen (black and white on Sun)
;; 1 is secondary screen (color on Sun)
(defparameter Garnet-Screen-Number 0)

;;; Garnet-Version controls where the files are loaded from/
;;; Because this is a defvar, if Garnet-Version is set before this file is
;;; loaded, its original value will be used.

(defvar Garnet-Version :external)
	;; options are:
	;;	:test for the testing version
        ;;      :rt-test for the testing version compiled for the RT
        ;;      :sparc-test for the testing version compiled for the Sparc Station
	;;	:cmu for the released version for CMU CommonLisp
        ;;      :cmu-sparc for released version for Allegro on a Sparc Station
	;;	:cmu-pmax for releaseved version compiled for the PMax
	;;	:external for all other non-CMU versions

#-release-garnet
(format T "** Garnet Version being loaded is ~s~%" Garnet-Version)

;;; *dont-load-modules-twice* tells whether to re-load modules
;;; if a user loads garnet-loader.lisp a second time.
(defparameter *dont-load-modules-twice* t)

;;; load-XX-p control whether the various parts are loaded or not
;;; Because these use defvar, if they are set before this file is
;;; loaded, their original value will be used.

;(defvar load-clx-p #+(or cmu allegro-v4.0) NIL #-(or cmu allegro-v4.0) T)
;(defvar load-kr-p T)
;(defvar load-opal-p T)
;(defvar load-inter-p T)
;(defvar load-aggregadgets-p T)
;(defvar load-aggregraphs-p NIL)
;(defvar load-debug-p T)
;(defvar load-gadgets-p NIL)
;(defvar load-demos-p NIL)
;(defvar load-lapidary-p NIL)
;(defvar load-gilt-p NIL)

;;; Insert your pathname of Garnet into Your-Garnet-Pathname and where
;;; your CLX comes from into Your-CLX-pathname.  For example:
;;; (defvar Your-CLX-Pathname "/usr/local/lisp/clx/")
;;; (defvar Your-Garnet-Pathname "/usr/your-name/garnet/")
;;; All the :external pathnames will depend on these two pathnames.

;(defvar Your-CLX-Pathname "<your clx pathname>")       ;;; SET THIS
;(defvar Your-Garnet-Pathname "<your garnet pathname>") ;;; SET THIS

;(defvar CLX-PathName
;  (case Garnet-Version
;    (:external Your-CLX-Pathname)
;    (:sparc-test "/usr/misc/.allegro/lib/code/")
;    (:cmu-pmax "/usr/misc/.allegro/lib/code/")
;    (:cmu-sparc  "/usr/misc/.allegro/lib/code/")
;    (T NIL)))
;
;(defvar Garnet-KR-PathName
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "bin/kr/"))
;    (:test "/afs/cs/user/dzg/garnet/kr/")
;    (:rt-test "/afs/cs/project/garnet/test/rt-bin/kr/")
;    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/kr/")
;    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/kr/")
;    (:cmu  "/afs/cs/project/garnet/cmu-bin/kr/")
;    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/kr/")
;    (T (error "No version for KR"))))
;(defvar Garnet-KR-Src
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "src/kr/"))
;    (:test "/afs/cs/user/dzg/garnet/kr/")
;    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/kr/")
;    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/kr/")
;    (T (error "No version for KR"))))
;
;(defvar Garnet-Opal-PathName
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "bin/opal/"))
;    (:test "/afs/cs/user/ecp/garnet/opal/")
;    (:rt-test "/afs/cs/project/garnet/test/rt-bin/opal/")
;    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/opal/")
;    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/opal/")
;    (:cmu  "/afs/cs/project/garnet/cmu-bin/opal/")
;    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/opal/")
;    (T (error "No version for Opal"))))
;(defvar Garnet-Opal-Src
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "src/opal/"))
;    (:test "/afs/cs/user/ecp/garnet/opal/")
;    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/opal/")
;    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/opal/")
;    (T (error "No version for Opal"))))
;
;(defvar Garnet-Inter-PathName
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "bin/inter/"))
;    (:test "/afs/cs/user/bam/garnet/inter/")
;    (:rt-test "/afs/cs/project/garnet/test/rt-bin/inter/")
;    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/inter/")
;    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/inter/")
;    (:cmu  "/afs/cs/project/garnet/cmu-bin/inter/")
;    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/inter/")
;    (T (error "No version for Inter"))))
;(defvar Garnet-Inter-Src
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "src/inter/"))
;    (:test "/afs/cs/user/bam/garnet/inter/")
;    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/inter/")
;    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/inter/")
;    (T (error "No version for Inter"))))
;
;(defvar Garnet-Aggregadgets-PathName 
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "bin/aggregadgets/"))
;    (:test "/afs/cs/user/ecp/garnet/aggregadgets/")
;    (:rt-test "/afs/cs/project/garnet/test/rt-bin/aggregadgets/")
;    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/aggregadgets/")
;    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/aggregadgets/")
;    (:cmu  "/afs/cs/project/garnet/cmu-bin/aggregadgets/")
;    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/aggregadgets/")
;    (T (error "No version for Aggregadgets"))))
;(defvar Garnet-Aggregadgets-Src
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "src/aggregadgets/"))
;    (:test "/afs/cs/user/ecp/garnet/aggregadgets/")
;    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/aggregadgets/")
;    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/aggregadgets/")
;    (T (error "No version for Aggregadgets"))))
;
;(defvar Garnet-Gadgets-PathName
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "bin/gadgets/"))
;    (:test "/afs/cs/user/preddy/garnet/gadgets")
;    (:rt-test "/afs/cs/project/garnet/test/rt-bin/gadgets/")
;    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/gadgets/")
;    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/gadgets/")
;    (:cmu  "/afs/cs/project/garnet/cmu-bin/gadgets/")
;    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/gadgets/")
;    (T (error "No version for Gadgets"))))
;(defvar Garnet-Gadgets-Src
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "src/gadgets/"))
;    (:test "/afs/cs/user/preddy/garnet/gadgets/")
;    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/gadgets/")
;    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/gadgets/")
;    (T (error "No version for Gadgets"))))
;
;(defvar Garnet-Debug-PathName
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "bin/debug/"))
;    (:test "/afs/cs/user/ecp/garnet/debug/")
;    (:rt-test "/afs/cs/project/garnet/test/rt-bin/debug/")
;    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/debug/")
;    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/debug/")
;    (:cmu  "/afs/cs/project/garnet/cmu-bin/debug/")
;    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/debug/")
;    (T (error "No version for Debug"))))
;(defvar Garnet-Debug-Src
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "src/debug/"))
;    (:test "/afs/cs/user/ecp/garnet/debug/")
;    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/debug/")
;    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/debug/")
;    (T (error "No version for Debug"))))
;
;(defvar Garnet-Demos-PathName
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "bin/demos/"))
;    (:test "/afs/cs/user/oh/garnet/demos/")
;    (:rt-test "/afs/cs/project/garnet/test/rt-bin/demos/")
;    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/demos/")
;    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/demos/")
;    (:cmu  "/afs/cs/project/garnet/cmu-bin/demos/")
;    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/demos/")
;    (T (error "No version for Demos"))))
;(defvar Garnet-Demos-Src
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "src/demos/"))
;    (:test "/afs/cs/user/oh/garnet/demos/")
;    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/demos/")
;    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/demos/")
;    (T (error "No version for Demos"))))
;
;(defvar Garnet-Lapidary-PathName
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "bin/lapidary/"))
;    (:test "/afs/cs/user/bvz/garnet/lapidary/")
;    (:rt-test "/afs/cs/project/garnet/cmu-bin/lapidary/")
;    (:sparc-test "/afs/cs/project/garnet/sparc-bin/lapidary/")
;    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/lapidary/")
;    (:cmu  "/afs/cs/project/garnet/cmu-bin/lapidary/")
;    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/lapidary/")
;    (T (error "No version for Lapidary"))))
;(defvar Garnet-Lapidary-Src
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "src/lapidary/"))
;    (:test "/afs/cs/user/bvz/garnet/lapidary/")
;    ((:rt-test :sparc-test :cmu-pmax :cmu :cmu-sparc)
;     "/afs/cs/project/garnet/src/lapidary/")
;    (T (error "No version for Lapidary"))))
;
;(defvar Garnet-Gilt-PathName
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "bin/gilt/"))
;    (:test "/afs/cs/user/bam/garnet/gilt/")
;    (:rt-test "/afs/cs/project/garnet/test/rt-bin/gilt/")
;    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/gilt/")
;    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/gilt/")
;    (:cmu  "/afs/cs/project/garnet/cmu-bin/gilt/")
;    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/gilt/")
;    (T (error "No version for Gilt"))))
;(defvar Garnet-Gilt-Src
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "src/gilt/"))
;    (:test "/afs/cs/user/bam/garnet/gilt/")
;    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/gilt/")
;    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/gilt/")
;    (T (error "No version for Gilt"))))

;; Directory used for cursors and bitmaps
(defvar Garnet-Bitmap-PathName
  (case Garnet-Version
    (:external "/afs/cs/project/soar/garnet/1.4/src/bitmaps/1.4/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/lib/bitmaps/")
    ((:test :rt-test :sparc-test) "/afs/cs/project/garnet/test/lib/bitmaps/")
    (T (error "No version for bitmap"))))

;;; Directory used for bitmaps and things needed by Gilt
;(defvar Garnet-Gilt-Bitmap-PathName
;  (case Garnet-Version
;    (:external (concatenate 'string Your-Garnet-Pathname "lib/gilt/"))
;    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/lib/gilt/")
;    ((:test :rt-test :sparc-test) "/afs/cs/project/garnet/test/lib/gilt/")
;    (T (error "No version for Gilt bitmaps"))))

;;;----------------------------------------------------------

;;; When compiling, the binaries will be in the same directories as the
;;; source files, so make all the path names be the same
;;;
;;; After compilation is finished, the user should move all the binaries
;;; into their own directories, as specified the the pathnames above.

;(when (and (boundp '*Garnet-Going-To-Compile*)
;           *Garnet-Going-To-Compile*)
;  (setf Garnet-KR-Pathname Garnet-KR-Src)
;  (setf Garnet-Opal-Pathname Garnet-Opal-Src)
;  (setf Garnet-Inter-Pathname Garnet-Inter-Src)
;  (setf Garnet-Aggregadgets-Pathname Garnet-Aggregadgets-Src)
;  (setf Garnet-Gadgets-Pathname Garnet-Gadgets-Src)
;  (setf Garnet-Debug-Pathname Garnet-Debug-Src)
;  (setf Garnet-Demos-Pathname Garnet-Demos-Src)
;  (setf Garnet-Lapidary-Pathname Garnet-Lapidary-Src)
;  (setf Garnet-Gilt-Pathname Garnet-Gilt-Src)
;  )

;;;----------------------------------------------------------

;;; If at cmu, then set up the search lists
;#+cmu
;(progn
;  (unless (ext:search-list "kr:")
;    (setf (ext:search-list "kr:")
;          (list Garnet-KR-PathName)))
;  (unless (ext:search-list "kr-src:")
;    (setf (ext:search-list "kr-src:")
;          (list Garnet-KR-Src)))
;
;  (unless (ext:search-list "opal:")
;    (setf (ext:search-list "opal:")
;          (list Garnet-Opal-PathName)))
;  (unless (ext:search-list "opal-src:")
;    (setf (ext:search-list "opal-src:")
;          (list Garnet-Opal-Src)))
;
;  (unless (ext:search-list "inter:")
;    (setf (ext:search-list "inter:")
;          (list Garnet-Inter-PathName)))
;  (unless (ext:search-list "inter-src:")
;    (setf (ext:search-list "inter-src:")
;          (list Garnet-Inter-Src)))
;
;  (unless (ext:search-list "aggregadgets:")
;    (setf (ext:search-list "aggregadgets:")
;          (list Garnet-Aggregadgets-PathName)))
;  (unless (ext:search-list "aggregadgets-src:")
;    (setf (ext:search-list "aggregadgets-src:")
;          (list Garnet-Aggregadgets-Src)))
;
;  (unless (ext:search-list "gadgets:")
;    (setf (ext:search-list "gadgets:")
;          (list Garnet-Gadgets-PathName)))
;  (unless (ext:search-list "gadgets-src:")
;    (setf (ext:search-list "gadgets-src:")
;          (list Garnet-Gadgets-Src)))
;
;  (unless (ext:search-list "debug:")
;    (setf (ext:search-list "debug:")
;          (list Garnet-Debug-PathName)))
;  (unless (ext:search-list "debug-src:")
;    (setf (ext:search-list "debug-src:")
;          (list Garnet-Debug-Src)))
;
;  (unless (ext:search-list "demos:")
;    (setf (ext:search-list "demos:")
;          (list Garnet-Demos-PathName)))
;  (unless (ext:search-list "demos-src:")
;    (setf (ext:search-list "demos-src:")
;          (list Garnet-Demos-Src)))
;
;  (unless (ext:search-list "lapidary:")
;    (setf (ext:search-list "lapidary:")
;          (list Garnet-Lapidary-PathName)))
;  (unless (ext:search-list "lapidary-src:")
;    (setf (ext:search-list "lapidary-src:")
;          (list Garnet-Lapidary-Src)))
;
;  (unless (ext:search-list "gilt:")
;    (setf (ext:search-list "gilt:")
;          (list Garnet-Gilt-PathName)))
;  (unless (ext:search-list "gilt-src:")
;    (setf (ext:search-list "gilt-src:")
;          (list Garnet-Gilt-Src)))
;  )
;
;(defparameter CLX-Loader
;  (when CLX-PathName
;    #+allegro (merge-pathnames "clx" CLX-Pathname)
;    #+lucid (merge-pathnames "defsystem" CLX-Pathname)))
;
;(defparameter Garnet-KR-Loader
;  (merge-pathnames "kr-loader"
;                   #+cmu "kr:"
;                   #+(not cmu) Garnet-KR-PathName))
;
;(defparameter Garnet-Opal-Loader
;  (merge-pathnames "opal-loader"
;                   #+cmu "opal:"
;                   #+(not cmu) Garnet-Opal-PathName))
;
;(defparameter Garnet-Inter-Loader
;  (merge-pathnames "inter-loader"
;                   #+cmu "inter:"
;                   #+(not cmu) Garnet-Inter-PathName))
;
;(defparameter Garnet-Aggregadgets-Loader
;  (merge-pathnames "aggregadgets-loader"
;                   #+cmu "aggregadgets:"
;                   #+(not cmu) Garnet-Aggregadgets-PathName))
;
;(defparameter Garnet-Aggregraphs-Loader
;  (merge-pathnames "aggregraphs-loader"
;                   #+cmu "aggregadgets:"
;                   #+(not cmu) Garnet-Aggregadgets-PathName))
;
;(defparameter Garnet-Gadgets-Loader
;  (merge-pathnames "gadgets-loader"
;                   #+cmu "gadgets:"
;                   #+(not cmu) Garnet-Gadgets-PathName))
;
;(defparameter Garnet-Debug-Loader
;  (merge-pathnames "debug-loader"
;                   #+cmu "debug:"
;                   #+(not cmu) Garnet-Debug-PathName))
;
;(defparameter Garnet-Demos-Loader
;  (merge-pathnames "demos-loader"
;                   #+cmu "demos:"
;                   #+(not cmu) Garnet-Demos-PathName))
;
;(defparameter Garnet-Lapidary-Loader
;  (merge-pathnames "lapidary-loader"
;                   #+cmu "lapidary:"
;                   #+(not cmu) Garnet-Lapidary-PathName))
;
;(defparameter Garnet-Gilt-Loader
;  (merge-pathnames "gilt-loader"
;                   #+cmu "gilt:"
;                   #+(not cmu) Garnet-Gilt-PathName))
;
;(defparameter Garnet-Motif-Gilt-Loader
;  (merge-pathnames "motif-gilt-loader"
;                   #+cmu "gilt:"
;                   #+(not cmu) Garnet-Gilt-PathName))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 


;(format t "...Loading Garnet ...~%")
(setf *load-verbose* t)

;;;Patches for CLX on the RT.
;;;(load "/afs/cs/project/clisp-1/chiles/archive/clx-r3/clx")
;;;(load "/afs/cs/project/clisp-1/chiles/archive/clx-r3/display")

;(when load-clx-p
;   (format T "~% %%%%%%% Loading CLX %%%%%%%%~%")
;   (load CLX-Loader))
;#+lucid
;(when load-clx-p
;#+lcl3.0 (funcall (find-symbol 'load-clx 'xlib) CLX-Pathname)
;#-lcl3.0 (     load-clx CLX-Pathname))
;#-cmu
;(unless load-clx-p (format T "~%****** NOT Loading CLX *******~%"))
;
;(if load-kr-p
;    (if (and *dont-load-modules-twice* (get :garnet-modules :kr))
;        (format T "~%****** KR already loaded *******~%")
;        (progn
;          (format T "~% %%%%%%%% Loading KR %%%%%%%%~%")
;          (load Garnet-KR-Loader)))
;    (format T "~%****** NOT Loading KR *******~%"))
;
;(if load-opal-p
;    (if (and *dont-load-modules-twice* (get :garnet-modules :opal))
;        (format T "~%****** Opal already loaded *******~%")
;        (progn
;          (format T "~% %%%%%%%% Loading Opal %%%%%%%%~%")
;          (load Garnet-Opal-Loader)))
;    (format T "~%****** NOT Loading Opal *******~%"))
;
;(if load-inter-p
;    (if (and *dont-load-modules-twice* (get :garnet-modules :inter))
;        (format T "~%****** Interactors already loaded *******~%")
;        (progn
;          (format T "~% %%%%%%%% Loading Interactors %%%%%%%%~%")
;          (load Garnet-Inter-Loader)))
;    (format T "~%****** NOT Loading Interactors *******~%"))
;
;(if load-aggregadgets-p
;    (if (and *dont-load-modules-twice* (get :garnet-modules :aggregadgets))
;        (format T "~%****** Aggregadgets already loaded *******~%")
;        (progn
;          (format T "~% %%%%%%%% Loading Aggregadgets %%%%%%%%~%")
;          (load Garnet-Aggregadgets-Loader)))
;    (format T "~%****** NOT Loading Aggregadgets *******~%"))
;
;(if load-aggregraphs-p
;    (if (and *dont-load-modules-twice* (get :garnet-modules :aggregraphs))
;        (format T "~%****** Aggregraphs already loaded *******~%")
;        (progn
;          (format T "~% %%%%%%%% Loading Aggregraphs %%%%%%%%~%")
;          (load Garnet-Aggregraphs-Loader)))
;    (format T "~%****** NOT Loading Aggregraphs *******
;** To load aggregraph programs, execute (load Garnet-Aggregraphs-Loader)~%"))
;
;
;(if load-gadgets-p
;    (if (and *dont-load-modules-twice* (get :garnet-modules :gadgets))
;        (format T "~%****** Gadgets already loaded *******~%")
;        (progn
;          (format T "~% %%%%%%%% Loading Gadgets %%%%%%%%~%")
;          (load Garnet-Gadgets-Loader)))
;    (format T "~%****** NOT Loading Gadgets *******~%"))
;
;(if load-debug-p
;    (if (and *dont-load-modules-twice* (get :garnet-modules :debug))
;        (format T "~%****** Debugging programs already loaded *******~%")
;        (progn
;          (format T "~% %%%%%%%% Loading Debugging programs %%%%%%%%~%")
;          (load Garnet-Debug-Loader)))
;    (format T "~%****** NOT Loading DEBUG Files *******
;** To load debug programs, execute (load Garnet-Debug-Loader)~%"))
;
;(if load-demos-p
;    (if (and *dont-load-modules-twice* (get :garnet-modules :demos))
;        (format T "~%****** Demos already loaded *******~%")
;        (progn
;          (format T "~% %%%%%%%% Loading Demos %%%%%%%%~%")
;          (load Garnet-Demos-Loader)))
;    (format T "~%****** NOT Loading Demos *******
;** To load Demos, execute (load Garnet-Demos-Loader)~%"))
;
;(if load-lapidary-p
;    (if (and *dont-load-modules-twice* (get :garnet-modules :lapidary))
;        (format T "~%****** Lapidary already loaded *******~%")
;        (progn
;          (format T "~% %%%%%%%% Loading Lapidary %%%%%%%%~%")
;          (load Garnet-Lapidary-Loader)))
;    (format T "~%****** NOT Loading Lapidary *******
;** To load Lapidary, execute (load Garnet-Lapidary-Loader)~%"))
;
;(if load-gilt-p
;    (if (and *dont-load-modules-twice* (get :garnet-modules :gilt))
;        (format T "~%****** Gilt already loaded *******~%")
;        (progn
;          (format T "~% %%%%%%%% Loading Gilt %%%%%%%%~%")
;          (load Garnet-Gilt-Loader)))
;    (format T "~%****** NOT Loading Gilt *******
;** To load Gilt, execute (load Garnet-Gilt-Loader) or
;   (load Garnet-Motif-Gilt-Loader)~%"))
;
;(defun user::Garnet-Load (filename)
;  (let ((pos (position #\: filename)))
;    (if pos
;        (let* ((head (subseq filename 0 pos))
;               (tail (subseq filename (1+ pos)))
;               (prefix (cond
;                         ((string= head "clx") CLX-PathName)
;                         ((string= head "kr") Garnet-KR-PathName)
;                         ((string= head "opal") Garnet-Opal-PathName)
;                         ((string= head "inter") Garnet-Inter-PathName)
;                         ((string= head "aggregadgets") Garnet-Aggregadgets-PathName)
;                         ((string= head "gadgets") Garnet-Gadgets-PathName)
;                         ((string= head "debug") Garnet-Debug-PathName)
;                         ((string= head "demos") Garnet-Demos-PathName)
;                         ((string= head "demo") Garnet-Demos-PathName)
;                         ((string= head "lapidary") Garnet-Lapidary-PathName)
;                         ((string= head "gilt") Garnet-Gilt-PathName)
;                         (t (error "Bad prefix ~%" head))))
;               (finalname (merge-pathnames tail prefix)))
;          (format T "Loading ~s~%" finalname)
;          (load finalname))
;        ;; else no colon, load regular
;        (progn
;          (format T "NO COLON, Loading ~s~%" filename)
;          (load filename)))))
;
;
;(format t "~%... Garnet Load Complete ...~%")

;;; Concatenated from type module "general" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/general/f1.4/general-changes.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : general-changes.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Sun Jul 21 17:10:42 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Mon Nov 11 15:18:58 1991
;;;; Update Count    : 5
;;;; 
;;;; PURPOSE
;;;; 	|>Description of module's purpose<|
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(proclaim '(optimize
	    (speed 2)
	    (safety 2)
	    (space 3)
	    (compilation-speed 0)
	    ))

(in-package "USER") ; just to make lucid happy when it's around



;;;
;;;	i.	Make sure packages are safe
;;;

#+allegro-v4.0
(eval-when (eval compile load)
  (in-package "KR" :use '("LISP" "CLTL1"))
  (in-package "KR-DEBUG" :use '("LISP" "CLTL1"))
  (in-package "OPAL" :use '("LISP" "KR" "CLTL1"))
  (in-package "GARNET-GADGETS" :use '("LISP" "CLTL1"))
  (in-package "GARNET-DEBUG" :use '("OPAL" "KR" "LISP" "CLTL1"))
  (in-package "INTERACTORS" :use '("KR" "LISP" "CLTL1")) )

#-allegro-v4.0
(eval-when (eval compile load)
  (in-package "KR" :use '("LISP"))
  (in-package "KR-DEBUG" :use '("LISP"))
  (in-package "OPAL" :use '("LISP" "KR"))
  (in-package "GARNET-GADGETS" :use '("LISP"))
  (in-package "GARNET-DEBUG" :use '("OPAL" "KR" "LISP"))
  (in-package "INTERACTORS" :use '("KR" "LISP")) )


;;;
;;;	ii. 	Definitions & export
;;;

(rename-package (find-package "GARNET-GADGETS") "GARNET-GADGETS" '("GG"))
(rename-package (find-package "OPAL") "OPAL" '("OP"))

#-release-garnet
(rename-package (find-package "GARNET-DEBUG") "GARNET-DEBUG" '("GD"))

(in-package "GARNET-GADGETS")


;;; Concatenated from type module "kr" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/kr/f1.4/kr.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: KR; Base: 10 -*-


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




;;; TO DO:
;;; - G-CACHED-VALUE: multiple values!
;;; - DESTROY-CONSTRAINT: code to set the value after formula is destroyed
;;;   (for multiple-value case)
;;; - fix up APPEND-VALUE to be more efficient.
;;; - DESTROY-SLOT and DELETE-VALUE-N : do the appropriate thing when the
;;;   slot/value being destroyed is being depended upon by others.  In
;;;   particular:
;;;   - destroy-slot does NOT work for multi-formula slots;
;;;   - delete-value-n does not work at all for formula values.
;;; - Replace DELETE-FORMULA by DE-INSTALL-FORMULA ??
;;; - check out the "Are we installing a formula ...?" part in s-value-n; is
;;;   it ever used?
;;; - fix COPY-DOWN-FORMULAS to deal with multiple values!
;;; - dependencies should be on a schema/slot/value basis, instead of simply
;;;   schema/slot.  Use a 3-slot structure, which is cheaper than both an
;;;   array and a list of 3 elements.
;;; - PROPAGATE-CHANGE: FIX FOR MULTIPLE VALUES !!!!!
;;; - delete-value-n (check inheritance)
;;; - set relation slots, have inheritance propagated
;;; - check all places where formulas are assumed to be in first position only.
;;;


;;; The KR-DEBUG package is used to intern automatically-created names for
;;; unnamed schemata.
;;; 
(in-package "KR-DEBUG")


;;; The KR package contains the whole system and exports the functional
;;; interface.
;;; 
(in-package "KR")



(export '(PS NAME-FOR-SCHEMA
	  CREATE-SCHEMA CREATE-RELATION
	  SCHEMA-P RELATION-P IS-A-P HAS-SLOT-P
	  GET-VALUE GET-VALUES
	  G-LOCAL-VALUE GET-LOCAL-VALUES GET-LOCAL-VALUE
	  DOVALUES DOSLOTS DO-PRINTABLE-SLOTS S-VALUE S-VALUE-N
	  SET-VALUES APPEND-VALUE DELETE-VALUE-N
	  DESTROY-SLOT DESTROY-SCHEMA DESTROY-CONSTRAINT

	  ;; the object programming interface
	  DEFINE-METHOD METHOD-TRACE KR-SEND CALL-PROTOTYPE-METHOD
	  CREATE-INSTANCE CREATE-PROTOTYPE

	  *ALLOW-CHANGE-TO-CACHED-VALUE*
	  WITH-DEMONS-DISABLED
	  FORMULA-P FORMULA O-FORMULA CHANGE-FORMULA COPY-FORMULA
	  GV GVL GV-LOCAL G-VALUE G-CACHED-VALUE
	  MARK-AS-CHANGED MARK-AS-INVALID RECOMPUTE-FORMULA
	  UPDATE-SLOTS-LIST SET-UPDATE-SLOTS))



(defparameter *kr-version* "1.3.23")


;;; -------------------------------------------------- Internal structures.




;;; The internal representation of a schema is as a structure, where the
;;; <name> slot holds the name (or internal number) of the schema and the
;;; <slots> slot holds a p-list of slot names and slot values.
;;; 
(defstruct (schema (:print-function print-the-schema))
  name      ; the schema name, or a number
  slots     ; area for overflow slots (a plist)
  is-a      ; this and the following are special slots in all schemata
  update-slots
  )


;;; The basis KR schema (most schemata are of this type).
;;; 
(defstruct (a-schema (:include schema) (:print-function print-the-schema))
  left
  top
  width
  height
  window
  visible
  parent
  depended-slots
  update-info		; this is for the Update algorithm
  )


;;; This structure is similar to a schema, but is used to store formulas.
;;; It prints out with an F instead of an S, and it uses the same positions for
;;; different functions.
;;; 
(defstruct (a-formula (:include schema) (:print-function print-the-schema))
  kr-function	; the expression which gets evaluated to yield the value
  depends-on	; list of schemata on which this function depends
  schema	; schema on which this formula is installed
  slot		; slot on which this formula is installed
  cached-value	; the cached value
  cached-number ; valid/invalid bit, and sweep mark
  path		; holds cached paths
  )



;;; We do not necessarily use the built-in structure predicate, because it
;;; seems to be terribly slow on Lisp machines.
;;; 

(defmacro formula-p (thing)
  `(a-formula-p ,thing))




;;;  -------------------------------------------------- Low-level slot access



(defvar *schema-counter* 0
  #-release-garnet
  "This variable is simply used to generate schema numbers for schemata that
  are created with (create-schema NIL).")



(eval-when (eval compile load)
  (defparameter *schema-slots*
    '((:is-a . schema-is-a)
      (:update-slots . schema-update-slots)
      (:left . a-schema-left)
      (:top . a-schema-top)
      (:width . a-schema-width)
      (:height . a-schema-height)
      (:window . a-schema-window)
      (:visible . a-schema-visible)
      (:update-info . a-schema-update-info)
      (:parent . a-schema-parent)
      (:depended-slots . a-schema-depended-slots))
    "Names and slot accessorss in a schema structure"))

(eval-when (eval compile load)
  (defparameter *formula-slots*
    '((:kr-function . a-formula-kr-function))))

(eval-when (eval compile load)
  (defparameter *formula-safe-slots*
    '((:is-a . schema-is-a)
      (:update-slots . schema-update-slots)
      (:kr-function . a-formula-kr-function))))



(eval-when (eval compile load)
  ;; Associate the slot reference number to the slot names for special slots
  ;; (which are simply keywords, of course).
  (dolist (l *schema-slots*)
    (setf (get (car l) :KR-SLOT-NUMBER) (cdr l)))
  (dolist (l *formula-slots*)
    (setf (get (car l) :KR-SLOT-NUMBER) (cdr l))))



;;; --------------------------------------------------


(defvar *warning-on-create-schema* T
  #-release-garnet
  "If nil, no warning is printed when create-schema is redefining an existing
  schema.")

(defvar *warning-on-circularity* nil
  #-release-garnet
  "Set this to NIL to prevent warning when a circularity is detected.")

(defvar *warning-on-evaluation* nil
  #-release-garnet
  "If non-NIL, a warning is printed every time a formula is re-evaluated.
  This may be useful during debugging.")


(eval-when (compile load eval)
  (defvar *print-new-instances* T))

(eval-when (compile load eval)
  ;;; *LOCAL-SLOTS*
  (defvar *local-slots* '(:is-a-inv)
  #-release-garnet
    "A list of all slots which should be treated as local only, i.e., should
    never be inherited"))



(defvar *warning-on-null-link* NIL
  #-release-garnet
  "If non-NIL, a warning is printed when a null link is evaluated inside a
  GV (or GVL) within a formula.  This is the case when the stale value of the
  formula is reused.")

(defvar *warning-on-disconnected-formula* T
  #-release-garnet
  "If nil, no warning is printed when propagate-change sees a disconnected
  formula.")


(defvar *count-formulas* T
  #-release-garnet
  "If nil, we are setting a relation slot with objects which are formulas,
  but should NOT be considered as such (for instance, this happens in
  inherited formulas).  The relation should then be followed as is, rather
  than getting the value of each formula!")



(defvar *use-formulas-for-inheritance* t
  #-release-garnet
  "If this is NIL, formulas on relation links are NOT expanded when performing
  inheritance.  This is needed when inside inherited formulas, which are all
  of the form (:IS-A another-formula)")


(defvar *within-g-value* nil
  #-release-garnet
  "Set to non-nil within a sub-formula evaluation")


(defvar *sweep-mark* 0
  #-release-garnet
  "Used as a sweep mark to detect circularities")


(defvar *demons-disabled* nil
  #-release-garnet
  "May be bound to T to cause demons NOT to be executed when a slot is set.")


(defvar *allow-change-to-cached-value* T
  #-release-garnet
  "If non-nil, changes to a constrained slot (i.e., a slot which contains a
  formula) will be reflected immediately in the formula's cached value, without
  of course modifying the formula.")


(defvar *pre-set-demon* nil
  #-release-garnet
  "May be bound to a function to be called as a slot is set in a schema
  with the slots new-value.")

(defvar *invalidate-demon* 'invalidate-demon
  #-release-garnet
  "The demon that gets called when a slot on the :update-slots list of a schema
  is changed.")


(defvar *schema-self* nil
  #-release-garnet
  "The schema being acted upon by the accessor functions.")

(defvar *schema-slot* nil
  #-release-garnet
  "The slot in *schema-self* being acted upon by the accessor functions.")

(defvar *current-formula* nil
  #-release-garnet
  "The formula being acted upon by the accessor functions.")

(defvar *last-formula* nil
  #-release-garnet
  "Similar to *current-formula*, used for debugging only.")



(defvar *inheritance-relations* '()
  #-release-garnet
  "All relations in this list perform inheritance.")

(defvar *inheritance-inverse-relations* '()
  #-release-garnet
  "Inverses of all relations which perform inheritance.")

(defvar *relations* '()
  #-release-garnet
  "An a-list of relations known to the system, with their inverse(s).
   Used for the creation of automatic reverse-links.")


(defvar *schema-is-new* nil
  #-release-garnet
  "If non-nil, we are inside the creation of a new schema.  This guarantees
  that we do not have to search for inverse links when creating relations,
  and avoids the need to scan long is-a-inv lists.")


(defvar *print-as-structure* T
  #-release-garnet
  "If non-nil, schema names are printed as structure references.")

(defvar *print-structure-slots* nil
  #-release-garnet
  "List of slots that should be printed when printed schemata as structures.")




;;; --------------------------------------------------


(defmacro slot-accessor (schema sl)
  (if (keywordp sl)
      ;; Slot name is known at compile time.
      (let ((function (get sl :KR-SLOT-NUMBER)))
	(if function
	    ;; Slot name is a special name
	    `(,function ,schema)
	    ;; Slot name is not a special name.
	    `(getf (schema-slots ,schema) ,sl)))
      ;; Slot name is only known at runtime, so do the right thing (this
      ;; CASE is executed at runtime, unlike the first one).  This is
      ;; here mostly for safety reasons, and is not used at the user level.
      `(let ((function (get ,sl :KR-SLOT-NUMBER)))
	 (if function
	     (funcall function ,schema)
	     (getf (schema-slots ,schema) ,sl)))))




(defun accessor-constructor-fn (x)
  `(,(car x) (setf (,(cdr x) schema) value)))


;;; This function's definition is computed from the current contents of the
;;; list of special schema slots.
;;; The (generated) body function is essentially a big CASE statement which
;;; sets the appropriate slot.
;;; 
(eval `(defun set-any-slot (schema the-slot value)
	 ,(append '(case the-slot)
		  (mapcar #'accessor-constructor-fn *schema-slots*)
		  (mapcar #'accessor-constructor-fn *formula-slots*)
		  '((t (setf (getf (schema-slots schema) the-slot) value))))))

;;; Now compile the thingie
(compile 'set-any-slot)



;;; <value> must be a complete value descriptor.
;;; 
(defmacro set-slot-accessor (schema sl value)
  (let ((function (get sl :KR-SLOT-NUMBER)))
    (if function
	`(setf (,function ,schema) ,value)
	(if (keywordp sl)
	    ;; Slot name is known at compile time, but not a special name.
	    `(setf (getf (schema-slots ,schema) ,sl) ,value)
	    ;; Slot name is only known at runtime, so do the right thing (this
	    ;; CASE is executed at runtime, unlike the first one).  This is
	    ;; here mostly for safety reasons, and is not used at the user level.
	    `(set-any-slot ,schema ,sl ,value)))))


;;; A couple of specialized accessors for formula slots.
;;;
(defmacro on-schema (formula)
  `(a-formula-schema ,formula))


(defmacro on-slot (formula)
  `(a-formula-slot ,formula))






;;; Iterate the <body> for all the slots in the <schema>, with the variable
;;; <slot> bound to each slot in turn.
;;; 
(defmacro iterate-accessors ((a-schema &optional (inherited T))
			     &body body)
  `(do* ((schema ,a-schema)
	 (the-slot (slots-accessor schema) (cddr the-slot))
	 (slot (car the-slot) (car the-slot)))
	((null the-slot)
	 ;; Now apply to special slots as well (if they have a value, of course).
	 (dolist (entry (if (a-schema-p schema)
			    *schema-slots*
			    *formula-safe-slots*))
	   ,@(if inherited
		 ;; simpler expression: any slot will do
		 `((when (funcall (cdr entry) schema)
		     (setf slot (car entry))
		     ,@body))
		 ;; more complex: only local slots will do
		 `((let ((values (funcall (cdr entry) schema)))
		     (when (and values
				(not (is-inherited values)))
		       (setf slot (car entry))
		       ,@body))))))
     ,@(if inherited
	   body
	   `((let ((values (slot-accessor schema slot)))
	       (when (and values
			  (not (is-inherited values))
			  (not (null (cdr values))))
		 ,@body))))))





;;; -------------------- Definitions of value-information bits.



(eval-when (eval compile load)
  ;; bit is 1 if slot contains inherited values, 0 for local values
  (defparameter *inherited-bit* 0)
  ;; bit is 1 if any other schema inherited the value from here
  (defparameter *is-parent-bit* 1)
  ;; bit is 1 if any formula depends on this slot
  (defparameter *depended-bit* 2)
  ;; bit is 1 if slot contains at least one formula, 0 otherwise.  It should
  ;; be last, since formulas can be a multi-bit field.
  (defparameter *formula-bit* 3))


(eval-when (eval compile load)
  (defparameter *local-mask* 0)

  (defparameter *inherited-mask* (ash 1 *inherited-bit*))
  (defparameter *is-parent-mask* (ash 1 *is-parent-bit*))
  (defparameter *depended-mask* (ash 1 *depended-bit*))
  (defparameter *formula-mask* (ash 1 *formula-bit*))

  (defparameter *all-but-inherited-mask* (lognot *inherited-mask*))
  (defparameter *all-but-parent-mask* (lognot *is-parent-mask*))
  (defparameter *all-but-formula-mask* (lognot *formula-mask*)))

(defparameter *middle-mask*
  (logior *inherited-mask* *is-parent-mask* *depended-mask*)
  #-release-garnet
  "All bits but 'has formulas'")


(defparameter *no-value* (list *inherited-mask*)
  #-release-garnet
  "When no value is found, use this descriptor (inherited)")



(defmacro descriptor-is-inherited (thing)
  `(logbitp ,*inherited-bit* ,thing))

(defmacro is-inherited (thing)
  `(logbitp ,*inherited-bit* (car ,thing)))

;;; Bind <entry> if it is a complex expression, since this macro expands it
;;; twice.
;;; 
(defmacro set-is-inherited (entry new-value)
  (if new-value
      `(setf (car ,entry) (logior (car ,entry) ,*inherited-mask*))
      `(setf (car ,entry) (logand (car ,entry) ,(lognot *inherited-mask*)))))


(defmacro not-inherited (thing)
  ;; This relies on the fact the *inherited-bit* is bit 0.
  `(evenp (car ,thing)))

(defmacro is-parent (thing)
  `(logbitp ,*is-parent-bit* (car ,thing)))

(defmacro descriptor-is-parent (thing)
  `(logbitp ,*is-parent-bit* ,thing))

(defmacro is-depended (thing)
  `(and ,thing (logbitp ,*depended-bit* (car ,thing))))

(defmacro has-formulas (thing)
  `(logbitp ,*formula-bit* (car ,thing)))

(defmacro set-has-formulas (thing value)
  `(if ,value
      (setf (car ,thing) (logior (car ,thing) ,*formula-mask*))
      (setf (car ,thing) (logand (car ,thing) ,(lognot *formula-mask*)))))


(defmacro get-local-value (schema slot)
  `(let ((values (slot-accessor ,schema ,slot)))
     (when (and values (not (is-inherited values)))
       (cadr values))))


(defmacro get-local-values (schema slot)
  `(let ((values (slot-accessor ,schema ,slot)))
     (and values (not-inherited values)
	  (cdr values))))


(defmacro slots-accessor (thing)
  `(schema-slots ,thing))

(defmacro name-accessor (thing)
  `(schema-name ,thing))





;;; --------------------------------------------------

;;; This macro is used by macros such as GV or G-VALUE, which can
;;; be called with any number of slot names and expand into
;;; a nested chain of calls to <accessor-function>.
;;; 
(defmacro expand-accessor (accessor-function schema &rest slots)
  (if (= (length slots) 1)
      ;; Supply default position (0).
      (setf slots (list (car slots) 0)))
  (if slots
      ;; At least one slot was specified.
      (let* ((last-thing (car (last slots)))
	     (kernel schema)
	     (has-position (not (keywordp last-thing)))
	     (position
	      ;; ASSUMPTION: the last of the <slots> should be either an
	      ;; actual slot, known at compile time, or else a position number.
	      ;; In other words, the last slot CANNOT be specified by an
	      ;; expression or a variable.
	      (if has-position
		  last-thing
		  0)))
	;; "Grow" the kernel by wrapping more gv-fn's around it
	(do ((slot slots (cdr slot)))
	    ((or (null slot)  ; exit if finished, or last thing is a position.
		 (and has-position (null (cdr slot)))))
	  (setf kernel
		`(,accessor-function ,kernel ,(car slot)
				     ,(if (or (null (cdr slot))
					      ;; handle non-keyword case
					      (and has-position
						   (null (cddr slot))))
					  position
					  0))))
	kernel)
      ;; No slots!
      (error "expand-accessor: at least one slot is required")))



;;; ---------------------------------------------- CACHED VALUES (CONSTRAINTS)


;;; The following macros are used to reference particular slots from the
;;; cached value of formulas.

(defmacro cached-value (thing)
  `(a-formula-cached-value ,thing))

(defmacro cache-is-valid (thing)
  `(logbitp 0 (a-formula-cached-number ,thing)))


(defmacro set-cache-is-valid (thing value)
  (if value
      `(setf (a-formula-cached-number ,thing) 
	     (logior (a-formula-cached-number ,thing) 1))
      `(setf (a-formula-cached-number ,thing)
	     (logand (a-formula-cached-number ,thing) ,(lognot 1)))))


(defmacro cache-mark (thing)
  `(logand (a-formula-cached-number ,thing) ,(lognot 1)))

(defmacro set-cache-mark (thing mark)
  `(setf (a-formula-cached-number ,thing)
	 (logior (logand (a-formula-cached-number ,thing) 1) ,mark)))



;;; --------------------------------------------------



;;; Execute the <body> with pre- and post-demons disabled.
;;; 
(defmacro with-demons-disabled (&body body)
  `(let ((*demons-disabled* t))
     ,@body))



;;;; RELATION-P
;;; 
(defmacro relation-p (slot)
  `(assoc ,slot *relations*))



;;; -------------------------------------------------- MACROS



;;;; DOSLOTS
;;;
;;; Executes the <body> with <slot> bound in turn to each slot in the <schema>.
;;; 
(defmacro doslots ((slot-var a-schema) &body body)
  `(iterate-accessors (,a-schema NIL)
     (let ((,slot-var slot))
       ,@body)))



;;; 
;;; 
(defmacro get-value (schema slot)
  (if (member slot *local-slots*)
      `(cadr (slot-accessor ,schema ,slot))
      `(cadr (or (slot-accessor ,schema ,slot)
		 (g-value-inherit-values ,schema ,slot)))))


;;; 
(defmacro g-value-fn (schema slot the-position)
  (if (symbolp schema)
      (let ((values `(or (slot-accessor ,schema ,slot)
			 (g-value-inherit-values ,schema ,slot))))
	;; Simplify the expression slightly
	`(let ((value ,(cond ((not (numberp the-position))
			      `(if (zerop ,the-position)
				   (cadr ,values)
				   (nth (1+ ,the-position) ,values)))
			     ((zerop the-position)
			      `(cadr ,values))
			     (t
			      `(nth ,(1+ the-position) ,values)))))
	   (if (formula-p value)
	       (g-value-formula-value ,schema ,slot value)
	       ;; We are working with an ordinary value.
	       value)))
      ;; More complex expression - avoid repeating the <schema> in the
      ;; expansion of the macro.
      (let ((values `(or (slot-accessor the-schema ,slot)
			 (g-value-inherit-values the-schema ,slot))))
	`(let* ((the-schema ,schema)
		(value ,(cond ((not (numberp the-position))
			       `(if (zerop ,the-position)
				    (cadr ,values)
				    (nth (1+ ,the-position) ,values)))
			      ((zerop the-position)
			       `(cadr ,values))
			      (t
			       `(nth ,(1+ the-position) ,values)))))
	   (if (formula-p value)
	       (g-value-formula-value the-schema ,slot value)
	       ;; We are working with an ordinary value.
	       value)))))


#|
(defmacro g-value-slots-fn (schema slots the-position)
  (if (symbolp schema)
      (let ((values `(or (slot-accessor ,schema ,slot)
			 (g-value-inherit-values ,schema ,slot))))
	;; Simplify the expression slightly
	`(let ((value ,(cond ((not (numberp the-position))
			      `(if (zerop ,the-position)
				   (cadr ,values)
				   (nth (1+ ,the-position) ,values)))
			     ((zerop the-position)
			      `(cadr ,values))
			     (t
			      `(nth ,(1+ the-position) ,values)))))
	   (if (formula-p value)
	       (g-value-formula-value ,schema ,slot value)
	       ;; We are working with an ordinary value.
	       value)))
      ;; More complex expression - avoid repeating the <schema> in the
      ;; expansion of the macro.
      (let ((values `(or (slot-accessor the-schema ,slot)
			 (g-value-inherit-values the-schema ,slot))))
	`(let* ((the-schema ,schema)
		(value ,(cond ((not (numberp the-position))
			       `(if (zerop ,the-position)
				    (cadr ,values)
				    (nth (1+ ,the-position) ,values)))
			      ((zerop the-position)
			       `(cadr ,values))
			      (t
			       `(nth ,(1+ the-position) ,values)))))
	   (if (formula-p value)
	       (g-value-formula-value the-schema ,slot value)
	       ;; We are working with an ordinary value.
	       value)))))
|#



;;;
(defmacro g-local-value-fn (*schema-self* slot position)
  `(let ((values (slot-accessor ,*schema-self* ,slot)))
     (when (and values
		(not (is-inherited values)))
       (let ((value (nth ,(if (numberp position)
			      (1+ position)
			      `(1+ ,position)) values)))
	 (if (formula-p value)
	     (g-value-formula-value ,*schema-self* ,slot value)
	     ;; We are working with an ordinary value.
	     value)))))



;;;; G-VALUE
;;; This macro expands into nested calls to g-value-fn.  For example:
;;; (g-value schema :slot1 :slot2 :slot3 5) expands into
;;; (g-value-fn (g-value-fn (g-value-fn schema :slot1 0) :slot2 0) :slot3 5)
;;; 
(defmacro g-value (schema &rest slots)
  (if slots
      `(expand-accessor g-value-fn ,schema ,@slots)
      `(progn ,schema)))



;;;; G-LOCAL-VALUE
;;;
(defmacro g-local-value (schema &rest slots)
  (if slots
      `(expand-accessor g-local-value-fn ,schema ,@slots)
      `(progn ,schema)))



;;;; S-VALUE
;;; The basic value-setting function.
;;; NOTE:
;;; if *allow-change-to-cached-value* is nil (the default), a slot which
;;; contains a formula cannot be overwritten with a value, but just with
;;; another formula.
;;; 
(defmacro s-value (schema slot value)
  `(s-value-n ,schema ,slot 0 ,value))




;;;; GET-VALUES
;;; 

(defmacro get-values (schema slot)
  (if (eq slot :IS-A-INV)
      `(cdr (slot-accessor ,schema ,slot))
      `(cdr (or (slot-accessor ,schema ,slot)
		(g-value-inherit-values ,schema ,slot)))))
#|
(defmacro get-values (schema slot)
  `(cdr (or (slot-accessor ,schema ,slot)
	    (g-value-inherit-values ,schema ,slot))))
|#


;;;; DOVALUES
;;; Executes <body> with <var> bound to all the values of <slot> in <schema>.
;;; Note that the values are as per get-values.
;;; 
(defmacro dovalues ((variable schema slot &key (local nil) (result nil)
			      (formulas T) (in-formula NIL))
		    &rest body)
  `(let* ((schema ,@(if (eq schema :SELF)
			`(*schema-self*)
			`(,schema)))
	  (values ,(if local
		       `(slot-accessor schema ,slot)   
		       `(or (slot-accessor schema ,slot)
			    (inherit-slot-accessor schema ,slot)))))
     ;; If :IN-FORMULA is non-nil, do extra work to set up the dependencies.
     ,@(if in-formula
	   `((pushnew schema (a-formula-depends-on *current-formula*))))
     ,@(if in-formula
	   `((let ((entry (assoc ,slot
				 (get-local-values schema :DEPENDED-SLOTS))))
	       (unless entry
		 ;; This slot was not yet depended on by anybody.
		 (push (setf entry (list ,slot))
		       (get-local-values schema :DEPENDED-SLOTS))
		 (let ((the-entry (slot-accessor schema ,slot)))
		   (unless the-entry
		     (format t "DOVALUES: Entry is nil~%"))
		   ;; Mark this value as being depended on by someone.
		   (setf (car the-entry)
			 (logior (car the-entry) *depended-mask*))))
	       (pushnew *current-formula* (cdr entry)))))
     ;; Now iterate
     (cond ((null values)
	    nil)
	   ,@(cond ((eq local T)
		    `(((is-inherited values)
		       NIL)))
		   ((null local)
		    NIL)
		   (t
		    `(((and ,local
			    (is-inherited values))
		       NIL))))
	   #+COMMENT
	   ,@(if local
		 `(((is-inherited values)
		    NIL)))
	   (t
	    ,@(when formulas
		;; Extra code for the case FORMULAS = T
		`((let ((has-f (has-formulas values)))
		    (dolist (,variable (cdr values))
		      ;; Generate test for formula-p, unless :FORMULAS is nil
		      (if (and has-f (formula-p ,variable))
			  (setf ,variable
				(g-value-formula-value schema ,slot ,variable)))
		      ,@body))))
	    ,@(unless formulas
		;; Less code for the case FORMULAS = NIL
		`((dolist (,variable (cdr values))
		    ,@body)))))
     ,result))




;;; Looks in the :UPDATE-SLOTS of the <schema> to determine whether the <slot>
;;; has an associated demon.  This gives us the freedom to let different
;;; schemata have demons on possibly different slots.
;;; 
(defmacro slot-requires-demon (schema slot)
  `(member ,slot (get-value ,schema, :UPDATE-SLOTS)))





;;; ---------------------------------------- Setf forms for several macros

(defsetf slot-accessor set-slot-accessor)

(defsetf g-value s-value)

(defsetf get-values set-values)

(defsetf get-local-values set-values)




;;; -------------------------------------------------- INTERNALS


;;; This is for internal use only.
(defun get-value-function (schema slot)
  (let* ((value (or (slot-accessor schema slot)
		    (g-value-inherit-values schema slot))))
    (cadr value)))




(defun get-values-function (schema slot)
  (cdr (or (slot-accessor schema slot)
	   (g-value-inherit-values schema slot))))




;;; Internal function.  Like GET-VALUE, but takes a position parameter.
;;; 
(defun get-value-n (schema slot position)
  (elt (or (slot-accessor schema slot)
	   (g-value-inherit-values schema slot)) (1+ position)))



;;; -------------------------------------------------- PRINTING AND DEBUGGING


(defparameter *debug-names-length* 500)

(defvar *debug-names* (make-array *debug-names-length*))
(defvar *debug-index* -1)


(defvar *intern-unnamed-schemata* T
  #-release-garnet
  "This variable may be set to NIL to prevent PS from automatically creating
  any unnamed schemata it prints out.")



;;; This version does not cause any creation of symbol.  It simply records
;;; the schema in an array, thus creating a semi-permanent way to refer
;;; to a schema.
;;;
(defun cache-schema-name (schema name)
  (unless (find-if #'(lambda (x)
		       (and x (eql (name-accessor x) name)))
		   *debug-names*)
    ;; A new schema.  Store it in the next position (cycle if
    ;; we reach the end of the array).
    (setf (aref *debug-names*
		(setf *debug-index*
		      (mod (incf *debug-index*) *debug-names-length*)))
	  schema)))



;;; This version creates symbols for all automatic schema names that happen to
;;; be printed out.
;;; 
(defun make-new-schema-name (schema name)
  (let* ((debug-package (find-package "KR-DEBUG"))
	 parent
	 (symbol (intern (cond ((stringp name)
				;; a name-prefix schema
				(format nil "~A-~D"
					name (incf *schema-counter*)))
			       ((setf parent (get-local-value schema :is-a))
				(let ((parent-name (schema-name parent)))
				  (when (or (integerp parent-name)
					    (stringp parent-name))
				    ;; Parent is unnamed yet - force a name.
				    (with-output-to-string (bit-bucket)
				      (print-the-schema parent bit-bucket 0))
				    (setf parent-name (schema-name parent)))
				  (format nil "~A-~D" parent-name name)))
			       (t
				(format nil "~C~D"
					(if (formula-p schema) #\F #\S)
					name)))
			 debug-package)))
    (set symbol schema)
    (setf (schema-name schema) symbol)
    (export symbol debug-package)))



(defun print-the-schema (schema stream level)
  (declare (ignore level))
  (let ((name (schema-name schema)))
    ;; This version is for debugging.  Record the latest schemata in the
    ;; array.
    (cond ((or (integerp name) (stringp name))
	   ;; This is a nameless schema.  Print it out, and record it in the
	   ;; debugging array.
	   (if *intern-unnamed-schemata*
	       (make-new-schema-name schema name))
	   (cache-schema-name schema name)
	   ;; This gives control over whether unnamed schemata are interned.
	   (setf name (schema-name schema)))
	  ((null name)
	   ;; This was a deleted schema
	   (setf name '*DESTROYED*)))
    (if *print-as-structure*
	(progn
	  (format stream "#k<~S" name)
	  (dolist (slot *print-structure-slots*)
	    (let ((value (g-value schema slot)))
	      (when value
		(format stream " (~S ~S)" slot value))))
	  (format stream ">"))
	(format stream "~S" name))))



;;;; NAME-FOR-SCHEMA
;;; Given a schema, returns its string name.
;;; Note that this returns the pure name, without the #k<> notation.
;;; 
(defun name-for-schema (schema)
  #-release-garnet
  "Given a schema, returns its printable name as a string.  The string
  CANNOT be destructively modified."
  (let ((name (schema-name schema)))
    (when (or (integerp name) (stringp name))
      ;; This is a nameless schema.  Print it out, and record it in the
      ;; debugging array.
      (if *intern-unnamed-schemata*
	  (make-new-schema-name schema name))
      (cache-schema-name schema name)
      ;; This gives control over whether unnamed schemata are interned.
      (setf name (schema-name schema)))
    (symbol-name name)))



;;; This is a debugging function which returns a schema, given its internal
;;; number.  It only works if the schema was printed out rather recently,
;;; i.e., if it is contained in the temporary array of names.
;;; 
(defun s (number)
  (setf number (format nil "~D" number))
  (find-if #'(lambda (x)
	       (and x
		    (do* ((name (symbol-name (schema-name x)))
			  (i (1- (length name)) (1- i))
			  (j (1- (length number)) (1- j)))
			 ((minusp j)
			  (unless (digit-char-p (schar name i))
			    x))
		      (unless (char= (schar name i) (schar number j))
			(return nil)))))
	   *debug-names*))




;;; --------------------------------------------------





;;;; CREATE-RELATION
;;;
;;; Defines a new relation with its inverses.  In <inheritance-p> is non-nil,
;;; classifies the relation as one that performs inheritance.
;;; Note that <relation> should be a slot name, not a schema.
;;; 
(defmacro create-relation (relation inheritance-p &rest inverses)
  `(let ((inverses ',inverses))
     (when ,inheritance-p
       (pushnew ,relation *inheritance-relations*)
       (dolist (inverse inverses)
	 (pushnew inverse *inheritance-inverse-relations*)))
     (unless (assoc ,relation *relations*)
       (push (cons ,relation inverses) *relations*))
     (dolist (inv inverses)
       (let ((entry (assoc inv *relations*)))
	 (if entry
	     (pushnew ,relation (cdr entry))
	     (progn
	       (push (list inv ,relation) *relations*)))))))



;;; -------------------------------------------------- Relation Maintenance


;;; Remove the inverse link from <value> to <schema>, following the inverse
;;; of <slot>.
;;; 
(defun unlink-one-value (schema slot value)
  (let ((inverse (first (cdr (assoc slot *relations*)))))
    (when inverse
      ;; If the terminal has an INVERSE slot, remove <schema> from the
      ;; inverse slot.
      (let ((values (slot-accessor value inverse)))
	(when values
	  (setf (cdr values) (delete schema (cdr values))))))))



;;; Same as before, but unlinks all schemata that are in <slot>.
;;; 
(defun unlink-all-values (schema slot)
  (let ((inverse (first (cdr (assoc slot *relations*)))))
    (when inverse
      (dovalues (value schema slot :formulas NIL)
	;; If the terminal has an INVERSE slot, remove <schema> from the
	;; inverse slot.
	(let ((values (slot-accessor value inverse)))
	  (when values
	    (setf (cdr values) (delete schema (cdr values)))))))))



(defun low-level-set-value (the-entry position new-value is-formula)
  (setf is-formula (and *count-formulas* is-formula))
  (if (null the-entry)
      ;; There was no value
      (cond ((zerop position)
	     ;; Make this into a single-value slot.
	     (if is-formula
		 (setf the-entry (list *formula-mask* new-value))
		 (setf the-entry (list *local-mask* new-value))))
	    (t
	     ;; This is a multiple-value slot.
	     ;; SEMANTICS A LITTLE UNCLEAR.  ALL VALUES BEFORE <position>
	     ;; ARE SET TO NIL.
	     ;; *** THIS BETTER NOT BE A RELATION SLOT !!!!
	     (let ((new-list (make-list (1+ position))))
	       (setf (nth (1+ position) new-list) new-value)
	       (setf the-entry
		     (cons (if is-formula *formula-mask* 0)
			   new-list)))))
      ;; There already were values.
      (cond ((zerop position)
	     (if (cdr the-entry)
		 (setf (cadr the-entry) new-value)
		 (setf (cdr the-entry) (list new-value)))
	     (let ((was-formula (has-formulas the-entry)))
	       (unless (eq is-formula was-formula)
		 ;; There was a change
		 (cond (is-formula
			(set-has-formulas the-entry T))
		       ((cddr the-entry)
			(set-has-formulas
			 the-entry
			 (find-if #'a-formula-p (cddr the-entry))))
		       (t
			(set-has-formulas the-entry NIL))))))
	    (t
	     (let ((length (length the-entry)))
	       (if (< length (+ position 2))
		   ;; not enough values - extend the list
		   (progn
		     (setf (cdr (last the-entry))
			   (make-list (- (+ position 2) length)))
		     (setf (nth (1+ position) the-entry) new-value)
		     (if is-formula
			 (set-has-formulas the-entry T)))
		   ;; replace one of the values
		   (progn
		     (incf position)
		     ;; trade places
		     (rotatef (nth position the-entry) new-value)
		     ;; set the bit which tells whether there are formulas.
		     (if is-formula
			 ;; Set the bit
			 (set-has-formulas the-entry T)
			 ;; Do we need to reset the bit?
			 (when (and (has-formulas the-entry)
				    is-formula
				    (zerop (count-if #'a-formula-p
						     (cdr the-entry))))
			   (set-has-formulas the-entry NIL)))))))))
  the-entry)



(defun do-one-value (schema value inverse)
  (let ((previous-values (slot-accessor value inverse)))
    ;; Create the back-link.  We use primitives here to avoid
    ;; looping.
    (when (or *schema-is-new*
	      (not (member schema (cdr previous-values))))
      (let ((is-formula (formula-p schema)))
	(if is-formula
	    ;; More general case
	    (set-slot-accessor
	     value inverse
	     (if previous-values
		 (low-level-set-value previous-values
				      (1- (length previous-values))
				      schema T)
		 (low-level-set-value nil 0 schema T)))
	  ;; Handle an important special case efficiently
	  (if previous-values
	      (push schema (cdr previous-values))
	      (set-slot-accessor value inverse
				 (list *local-mask* schema))))))))



;;; Since <values> is being added to <slot>, see if we need to put in an inverse
;;; link to <schema> from each of the <values>.
;;; This happens when <slot> is a relation with an inverse.
;;; 
(defun link-in-relation (schema slot values)
  (let ((inverse (first (cdr (assoc slot *relations*)))))
    (when inverse
      ;; Does the terminal already have an INVERSE slot ?
      (if (listp values)
	  ;; <values> is a list: cycle through them all
	  (dolist (value values)
	    (do-one-value schema value inverse))
	  ;; <values> is a single value
	  (do-one-value schema values inverse)))))




;;; --------------------------------------------------

;;;; HAS-SLOT-P
;;; 
(defmacro has-slot-p (schema slot)
  `(let ((values (slot-accessor ,schema ,slot)))
     (and values
	  (not (is-inherited values)))))



(defun inherit-slot-accessor (schema slot)
  (dolist (relation *inheritance-relations*)
    (dovalues (parent schema relation :local T :formulas NIL)
     (when parent
       (let ((value (or (slot-accessor parent slot)
			(inherit-slot-accessor parent slot))))
	 (if value (return-from inherit-slot-accessor value)))))))




;;;; G-CACHED-VALUE
;;; 
(defun g-cached-value (schema slot)
  #-release-garnet
  "Returns the value in the first position of the <slot> in the <schema>.
  If this is a formula, it returns the cached value of the formula, without
  ever recomputing the formula."
  ;; Note use of GET-VALUE
  (let ((g-cached-value-val (get-value schema slot)))
    (if (formula-p g-cached-value-val)
	(cached-value g-cached-value-val)
	g-cached-value-val)))



(defvar *place-from-where-inherited* nil)

;;; search up the tree for inherited slot
;;; 
(defun g-value-inherit-values (schema slot)
  (dolist (relation *inheritance-relations*)
    (dovalues (*schema-self* schema relation :local T :formulas T)
      ;; dzg - changed from
      ;;     (setf *place-from-where-inherited* *schema-self*)
      ;; to the following, to fix problem in Gilt radio-button:
      (let ((*place-from-where-inherited* *schema-self*)
	    (values (or (slot-accessor *schema-self* slot)
			(g-value-inherit-values *schema-self* slot))))
	;; Set the bit in the parent which says that the value was
	;; inherited by someone.
	(setf (car values) (logior (car values) *is-parent-mask*))
	(when (cdr values)
	  ;; Copy the values down to the inheriting slot, unless the
	  ;; values contain formulas.
	  (if (has-formulas values)
	      ;; The values contain at least one formula - do something
	      ;; special, i.e., copy down a list of the ACTUAL values, getting
	      ;; rid of all formulas.
	      (let ((plain-values nil))
		;; Multiple values, with at least one formula.
		(dolist (v (cdr values))
		  (if (formula-p v)
		      ;; This is a formula
		      (push (g-value-formula-value
			     *place-from-where-inherited* slot v)
			    plain-values)
		      ;; This is a plain value
		      (push v plain-values)))
		(setf values (cons (logior (car values) *inherited-mask*)
				   (nreverse plain-values)))
		(return-from g-value-inherit-values values))
	      ;; There are no formulas - no problem.
	      (progn
		;; Set the bit in the parent which says that the value was
		;; inherited by someone.
		(setf (car values) (logior (car values) *is-parent-mask*))
		;; Now create a new cell for the copied-down value.
		(setf values (cons (logand (logior (car values) *inherited-mask*)
					   (lognot *is-parent-mask*))
				   (cdr values)))
		(set-slot-accessor schema slot values)
		(return-from g-value-inherit-values values)))))))
  ;; We didn't find anything, so return an appropriate null value and set
  ;; the local cache (even though we have no value) to avoid further
  ;; inheritance search.
  (set-slot-accessor schema slot (copy-list *no-value*)))



#|
(defparameter bob '(141 0 25 166 25 110 75 57 159 12 25 166 25 166 100 60 141 4 29 166 29 110 71 57 159 16 29 166 29 166 96 60))
(defparameter the-b -1)
(setf the-b -1)

  (let ((foo (elt bob (incf the-b))))
    (set-cache-is-valid *current-formula* t)
    (setf (cached-value *current-formula*) foo)
    (return-from re-evaluate-formula foo))

|#


;;; Helper function
;;; 
(defun re-evaluate-formula (*schema-self* *schema-slot* *current-formula*
					  the-result)
  (if *warning-on-evaluation*
      (format t "formula ~S (on ~S, slot ~S) is being evaluated~%"
	      *current-formula* *schema-self* *schema-slot*))
  (catch 'no-link		; no overhead
    ;; If no-link, return cached-value anyway.
    (setf the-result
	  (let ((*within-g-value* T)
		g-value-2-new-value)
	    (set-cache-mark *current-formula* *sweep-mark*)
	    ;; Evaluate the formula.
	    (setf g-value-2-new-value
		  (funcall
		   ;; Get the function from the formula.  Turn
		   ;; off formula evaluation for inheritance links,
		   ;; since this would cause problems.
		   (let ((*use-formulas-for-inheritance* nil))
		     (get-value *current-formula* :KR-FUNCTION))
		   *schema-self*))
	    ;; Call the pre-set-demon function on this schema if
	    ;; this slot is an interesting slot.
	    (when (and (not *demons-disabled*)
		       (fboundp *pre-set-demon*)
		       (slot-requires-demon *schema-self* *schema-slot*)
		       (not (equal g-value-2-new-value
				   (cached-value *current-formula*))))
	      (funcall *pre-set-demon*
		       *schema-self* *schema-slot* g-value-2-new-value))
	    ;; Set the cache to the new value
	    (setf (cached-value *current-formula*) g-value-2-new-value))))
  ;; Mark as valid
  (set-cache-is-valid *current-formula* t)
  the-result)



;;; g-value-formula-value
;;; We are working with a formula.  Note that broken links leave
;;; the formula valid.
;;; 
(defun g-value-formula-value (*schema-self* slot formula)
  (unless *use-formulas-for-inheritance*
    ;; This is a special case: we have a formula installed on a relation link,
    ;; but this must NOT be evaluated as a formula.  This happens inside
    ;; inherited formulas: (F2 :is-a F1), where the parent F1 is a formula
    ;; and clearly we do not want to return F1's cached value as the value
    ;; of the :is-a slot!
    (return-from g-value-formula-value formula))
  (let ((cached-value (a-formula-cached-value formula)))
    (unless (cache-is-valid formula)
      (unless *within-g-value*
	;; Bump the sweep mark only at the beginning of a chain of formula
	;; accesses.  Increment by 2 since lower bit is "valid" flag.
	(incf *sweep-mark* 2))
      (if (= (cache-mark formula) *sweep-mark*)
	  ;; If the sweep mark is the same as the current one, WE ARE IN THE
	  ;; MIDDLE OF A CIRCULARITY.  Just use the old value, and mark it
	  ;; valid.
	  (progn
	    (if *warning-on-circularity*
		(format t "Warning - circularity detected on ~S, slot ~S~%"
			*schema-self* slot))
	    (set-cache-is-valid formula T))
	  ;; Compute, cache and return the new value.
	  (setf cached-value
		(re-evaluate-formula *schema-self* slot formula cached-value))))
    cached-value))

#|
;;; g-value-formula-value
;;; We are working with a formula.  Note that broken links leave
;;; the formula valid.
;;; 
(defun g-value-formula-value (*schema-self* slot formula)
  (unless *use-formulas-for-inheritance*
    ;; This is a special case: we have a formula installed on a relation link,
    ;; but this must NOT be evaluated as a formula.  This happens inside
    ;; inherited formulas: (F2 :is-a F1), where the parent F1 is a formula
    ;; and clearly we do not want to return F1's cached value as the value
    ;; of the :is-a slot!
    (return-from g-value-formula-value formula))
  (let ((g-value-2-result (cached-value formula)))
    (unless (cache-is-valid formula)
      (unless *within-g-value*
	;; Bump the sweep mark only at the beginning of a chain of formula
	;; accesses.  Increment by 2 since lower bit is "valid" flag.
	(incf *sweep-mark* 2))
      (if (= (cache-mark formula) *sweep-mark*)
	  ;; If the sweep mark is the same as the current one, WE ARE IN THE
	  ;; MIDDLE OF A CIRCULARITY.  Just use the old value, and mark it
	  ;; valid.
	  (set-cache-is-valid formula T)
	  ;; Compute, cache and return the new value.
	  (progn
	    (catch 'no-link
	      ;; If no-link, return cached-value anyway.
	      (setf g-value-2-result
		    (let ((*current-formula* formula)
			  (*schema-slot* slot)
			  (*within-g-value* T)
			  g-value-2-new-value)
		      (set-cache-mark formula *sweep-mark*)
		      ;; Evaluate the formula.
		      (setf g-value-2-new-value
			    (funcall
			     ;; Get the function from the formula.  Turn
			     ;; off formula evaluation for inheritance links,
			     ;; since this would cause problems.
			     (let ((*use-formulas-for-inheritance* nil))
			       (g-value formula :KR-FUNCTION))
			     *schema-self*))
		      ;; Call the pre-set-demon function on this schema if
		      ;; this slot is an interesting slot.
		      (when (and (not *demons-disabled*)
				 (fboundp *pre-set-demon*)
				 (slot-requires-demon *schema-self* slot)
				 (not (equal g-value-2-new-value
					     (cached-value formula))))
			(funcall *pre-set-demon*
				 *schema-self* slot g-value-2-new-value))
		      ;; Set the cache to the new value
		      (setf (cached-value formula) g-value-2-new-value))))
	    ;; Mark as valid
	    (set-cache-is-valid formula t))))
    g-value-2-result))
|#



;;; This is similar to g-value-inherit-values, but it just returns what it finds,
;;; without changing the inherited bit.
;;; 
(defun get-inherited-values (schema slot)
  (dolist (relation *inheritance-relations*)
    (dovalues (*schema-self* schema relation :local T :formulas T)
      (let ((values (or (slot-accessor *schema-self* slot)
			(get-inherited-values *schema-self* slot))))
	(when (cdr values)
	  (return-from get-inherited-values values)))))
  *no-value*)


;;; --------------------------------------------------



;;;; IS-A-P
;;; 
;;; Test whether <schema> IS-A <type>, either directly or indirectly.
;;; 
(defun is-a-p (schema type)
  #-release-garnet
  "Tests whether the <schema> is linked via :IS-A to schema <type>, either
  directly or through several links.  Note that (is-a-p <schema> T) returns
  true if <schema> is a schema."
  (when (schema-p schema)
    (or (eq type T)	   	;; (is-a-p any-schema T) is true
	(eq schema type)	;; (is-a-p foo foo) is true
	(dovalues (parent schema :IS-A :local T :formulas NIL)
	  (if (eq parent type)
	      (return-from is-a-p T)))
	;; Not directly in the list: how about the parents?
	(dovalues (parent schema :IS-A :local T :formulas NIL)
	  (if (is-a-p parent type)
	      (return-from is-a-p t))))))




;;; --------------------------------------------------




;;; 
(defun set-value (schema slot value)
  ;; Is the slot a relation? If so, we may have to deal with the inverse.
  (let* ((the-entry (slot-accessor schema slot))
	 (old-bits (car the-entry))
	 (was-parent (and the-entry (is-parent the-entry))))
    (when (relation-p slot)
      ;; Check that what we are putting in makes sense.
      (unless (schema-p value)
	(format t "SET-VALUE: relation value ~S is not a schema!  Ignored.~%"
		value)
	(return-from set-value NIL))
      ;; Unlink all previous values
      (unlink-all-values schema slot)
      (link-in-relation schema slot value))
    ;; Make this a list of local values.
    (let ((bits (logand (or old-bits 0) *is-parent-mask*)))
      (when (and *count-formulas* (formula-p value))
	(setf bits (logior bits *formula-mask*)))
      (if the-entry
	  (setf (car the-entry) bits
		(cadr the-entry) value)
	  (setf the-entry (list bits value)))
      (set-slot-accessor schema slot the-entry)
      ;; Make sure the inheritance graph remains valid
      (if was-parent
	  (update-inherited-values schema slot the-entry old-bits T))))
  value)




;;;; SET-VALUES
;;; Does not deal with formulas.
;;; 
(defun set-values (schema slot values)
  #-release-garnet
  "Replace all previous value in the <slot> of the <schema> with <values>
  (a list of values, which may contain formulas)."
  ;; Is the slot a relation? If so, we may have to deal with the inverse.
  (let* ((slot-entry (slot-accessor schema slot))
	 (old-bits (or (car slot-entry) 0))
	 (parent-bit (logand old-bits *is-parent-mask*))
	 (was-parent (not (zerop parent-bit)))
	 (is-relation (relation-p slot)))
    (when is-relation
      ;; Check that what we are putting in makes sense.
      (do ((value values (cdr value))
	   (previous nil value))
	  ((null value))
	(cond ((not (schema-p (car value)))
	       (format
		t
		"SET-VALUES: relation value ~S is not a schema!  Ignored.~%"
		(car value))
	       (pop (cdr previous))
	       (setf value previous))
	      ((member (car value) (cdr value))
	       (format
		t
		"SET-VALUES: schema ~S appears more than once in relation ~S;~%"
		(car value) slot)
	       (format t "multiple occurrences ignored.~%")
	       (setf (cdr values) (delete (car value) (cdr value))))))
      ;; Unlink all previous values
      (unlink-all-values schema slot)
      (link-in-relation schema slot values))
    (when (null values)
      (when slot-entry		; do nothing if there is no slot entry
	;; Turn off the inherited bit, since this is now local information, and
	;; the bit which tells whether there are local formulas.
	(setf (car slot-entry)
	      (logand (car slot-entry)
		      *all-but-inherited-mask*
		      *all-but-formula-mask*))
	(setf (cdr slot-entry) nil))
      (if was-parent
	  (update-inherited-values schema slot slot-entry old-bits T))
      (return-from set-values nil))
    ;; Make this a list of local values.
    (let ((has-formulas nil)
	  ;; If this was a parent, keep it that way.
	  (bits parent-bit))
      (when *count-formulas*
	;; The list of values contains some formulas, and thus we need to
	;; install each of them.
	(dolist (value values)
	  (when (formula-p value)
	    (setf has-formulas T)
	    (setf (on-schema value) schema)
	    (setf (on-slot value) slot))))
      (when has-formulas
	(setf bits (logior bits *formula-mask*)))
      (if slot-entry
	  (setf (car slot-entry) bits
		(cdr slot-entry) values)
	  (progn
	    (setf slot-entry (cons bits values))
	    (set-slot-accessor schema slot slot-entry)))
      ;; Make sure the inheritance graph remains valid
      (if was-parent
	  (update-inherited-values schema slot slot-entry old-bits T)))
    (when is-relation
      ;; A relation slot is being changed.  We may need to invalidate all
      ;; inherited values.
      (reset-inherited-values schema))
    values))




;;; --------------------------------------------------


(defun delete-schema (schema)
  (when (schema-name schema)	; do nothing if schema is already destroyed
    ;; Remove all inverse links.
    (iterate-accessors (schema NIL)
      (if (relation-p slot)
	  (unlink-all-values schema slot)))
    (unless (formula-p schema)
      (iterate-accessors (schema NIL)
	;; Delete any formulas
	(let ((entry (slot-accessor schema slot)))
	  (dolist (v (cdr entry))
	    (when (formula-p v)
	      ;; This is a formula.  Get rid of it.
	      (de-install-formula v)
	      (delete-schema v))))))
    (iterate-accessors (schema T)
      (set-slot-accessor schema slot nil))
    ;; Delete user-defined slots.
    (setf (slots-accessor schema) nil)
    ;; Now wipe out the symbol value as well.
    (if (symbolp (name-accessor schema))
	(makunbound (name-accessor schema)))
    (setf (schema-name schema) nil)))




;;; Eliminate all dependency pointers from the <formula>, since it is no
;;; longer installed on a slot.
;;; This is less eager to eliminate slots than delete-formula.
;;;
(defun de-install-formula (formula)
  (dolist (schema (a-formula-depends-on formula))
    (dolist (d (get-local-values schema :DEPENDED-SLOTS))
      (when (member formula (cdr d))
	(setf (cdr d) (delete formula (cdr d)))))))



;;; Destroy a formula and all its related pointers.
;;; 
(defun delete-formula (formula)
  (dolist (schema (a-formula-depends-on formula))
    (dolist (d (get-local-values schema :DEPENDED-SLOTS))
      (when (member formula (cdr d))
	(setf (cdr d) (delete formula (cdr d)))))
    ;; If any of the depended-slots became nil, eliminate it.
    (setf (get-values schema :DEPENDED-SLOTS)
	  (delete-if #'(lambda (x) (null (cdr x)))
		     (get-local-values schema :DEPENDED-SLOTS)))
    ;; This is not really necessary, but it makes schemata a little cleaner.
    (unless (slot-accessor schema :DEPENDED-SLOTS)
      (destroy-slot schema :DEPENDED-SLOTS)))
  (destroy-schema formula))



;;; ---------------------------------------------------



;;; RETURNS: T if the given <expression>, or one of its subexpressions,
;;; directly depends on the <target>.  This must be a direct dependency,
;;; i.e., one which does not use a link.
;;; 
(defun find-direct-dependency (expression target)
  (when (listp expression)
    (or (and (eq (car expression) 'GV)
	     (eq (cadr expression) target))
	(dolist (thing expression)
	  (if (find-direct-dependency thing target)
	      (return T))))))



;;;; DESTROY-SCHEMA
;;; 
;;; Delete a schema, taking care not to leave around dangling constraint
;;; references.
;;;
(defun destroy-schema (schema)
  #-release-garnet
  "Destroys the <schema>, taking care to eliminate all dependencies to and
  from it."
  (when (and (schema-p schema)
	     ;; If schema is already destroyed, do nothing.
	     (a-schema-name schema))
    (let ((done nil)
	  bizarre)
      (unless (a-formula-p schema)	; formulas have no depended slot
	(dolist (entry (get-local-values schema :DEPENDED-SLOTS))
	  (dolist (formula (cdr entry))
	    (unless (or (null formula)	; defensive programming
			(member formula done))
	      ;; If this is a value depended on by others, replace their value
	      ;; by the current value.  Do this, however, only if the dependency
	      ;; is a DIRECT one, i.e., if the name of the schema we are
	      ;; destroying is wired into the formula.  If this is a link, leave
	      ;; things as they are.
	      (let ((the-form (let ((*use-formulas-for-inheritance* nil))
				;; for compiled formulas
				(or (g-value formula :KR-FUNCTION 1)
				    (and (setf bizarre
					       ;; This should always be a list,
					       ;; but be prudent just in case.
					       (get-value formula :KR-FUNCTION))
					 (listp bizarre)
					 (cddr bizarre))))))
		(when (find-direct-dependency the-form schema)
		  ;; This is indeed a direct-dependency formula.  Install the
		  ;; appropriate value.
		  (s-value (on-schema formula) (on-slot formula)
			   (g-value (on-schema formula) (on-slot formula) 0))
		  (push formula done)
		  ;; The formula now commits suicide.
		  (delete-formula formula))))))))
    (delete-schema schema)))



;;; This is an internal function used by CREATE-INSTANCE.  The purpose is to
;;; destroy not only the <schema> itself, but also its instances (and so on,
;;; recursively).
;;; 
(defun recursive-destroy-schema (schema level)
  (let ((children (slot-accessor schema :IS-A-INV)))
    (when children
      (dolist (child (cdr children))
	(unless (eq child schema)
	  (recursive-destroy-schema child (1+ level)))))
    (when *warning-on-create-schema*
      (if (zerop level)
	  (format t "Warning - create-schema is destroying the old ~S.~%"
		  schema)
	  (format t "Warning - create-schema is recursively destroying ~S.~%"
		  schema)))
    (destroy-schema schema)))




;;;; DESTROY-SLOT
;;; 
;;; Destroy a slot in a schema, taking care of possible constraints.
;;; 
(defun destroy-slot (schema slot)
  #-release-garnet
  "Eliminates the <slot>, and all the values it contains, from the <schema>."
  ;; Take care of all formulas which used to depend on this slot.
  (dolist (formula (cdr (assoc slot (get-local-values schema :DEPENDED-SLOTS))))
    ;; If this is a value depended on by others, replace their value
    ;; by the current value.
    ;; NOTE: this could be done differently, for instance, by
    ;; modifying the formulas that use this.
    (s-value (on-schema formula) (on-slot formula)
	     (g-value (on-schema formula) (on-slot formula) 0))
    ;; The formula is marked invalid.
    (set-cache-is-valid formula NIL))
  ;; Destroy the formula, if this was a constrained slot.
  (let ((value (get-value schema slot)))    ; Note use of GET-VALUE
    ;; If the value in the slot is a formula, destroy it
    (when (formula-p value)
      (delete-formula value)))
  ;; Physically delete the slot
  (when (relation-p slot)
    (unlink-all-values schema slot))
  (let* ((number (get slot :KR-SLOT-NUMBER))
	 (entry (slot-accessor schema slot))
	 (was-parent (and entry (is-parent entry))))
    (when was-parent
      ;; Was this slot inherited by other schemata?  If so, make sure they will
      ;; inherit the right value afterwards.
      (visit-inherited-values schema slot
			      #'(lambda (x slot)
				  ;; Make sure formulas are updated properly
				  (mark-as-changed x slot)
				  ;; Physically remove the slot in the child.
				  (set-slot-accessor x slot NIL))))
    ;; Now go ahead and physically destroy the slot.
    (if number
	(set-slot-accessor schema slot nil)
	(remf (slots-accessor schema) slot))))


;;; --------------------------------------------------




;;; Execute the update demon associated with the <schema> and <slot>, if there
;;; is one.
;;; 
(defmacro run-invalidate-demons (schema slot)
  `(unless *demons-disabled*
     (when (and *invalidate-demon* (slot-requires-demon ,schema ,slot))
       (funcall *invalidate-demon* ,schema ,slot nil))))



(defmacro run-pre-set-demons (schema slot new-value is-formula)
  `(unless *demons-disabled*
     ;; Display demon called only if slot is in update-slots
     (when ,@(if is-formula
		 `((and (fboundp *pre-set-demon*)
			(slot-requires-demon ,schema ,slot)
			(not (eql ,new-value (g-cached-value ,schema ,slot)))))
		 `((and (fboundp *pre-set-demon*)
			(slot-requires-demon ,schema ,slot))))
       (funcall *pre-set-demon* ,schema ,slot ,new-value))))



;;;; MARK-AS-CHANGED
;;;
;;; This function can be used when manually changing a slot (without using
;;; s-value).  It will run the demons and propagate the invalidate wave
;;; to all the ordinary places.
;;;
(defun mark-as-changed (schema slot)
  #-release-garnet
  "Forces formulas which depend on the <slot> in the <schema> to be invalidated.
  Mostly used for internal implementation."
  (run-invalidate-demons schema slot)
  (let ((entry (slot-accessor schema slot)))
    (when (and entry
               (is-parent entry))
      (update-inherited-values schema slot entry (car entry) T)))
  (propagate-change schema slot))



;;;; MARK-AS-INVALID
;;; 
(defun mark-as-invalid (schema slot &optional (position 0))
  #-release-garnet
  "Invalidates the value of the formula at <position> in the <slot> of the
  <schema>.  If the value is not a formula, nothing happens."
  (let ((value (get-value-n schema slot position)))
    (when (formula-p value)
      (set-cache-is-valid value NIL))))



;;;; RECOMPUTE-FORMULA
;;;
;;; Forces the formula installed on the <slot> of the <schema> to be
;;; recomputed, propagating the change as needed.
;;; This may be used for implementation of formulas which depend on some
;;; non-KR value.
;;; 
(defun recompute-formula (schema slot)
  (let* ((entry (slot-accessor schema slot))
	 (formula (second entry)))
    (when (formula-p formula)
      (re-evaluate-formula schema slot formula nil)
      (run-invalidate-demons schema slot)
      (when (and entry
		 (is-parent entry))
	(update-inherited-values schema slot entry (car entry) T))
      (propagate-change schema slot))))



;;; Since the <slot> of the <schema> was modified, we need to propagate the
;;; change to all the formulas which depended on the old value.
;;; 
(defun propagate-change (schema slot)
  (let (old-bits)
    ;; This invalidates all formulas which depend on the slot of the schema.
    (dolist (formula (cdr (assoc slot
				 (get-local-values schema :DEPENDED-SLOTS))))
      ;; Stop propagating if this was already marked dirty.
      (when (cache-is-valid formula)
	(let ((new-schema (on-schema formula))
	      (new-slot (on-slot formula)))
	  (unless (and new-schema new-slot)
	    (when *warning-on-disconnected-formula*
	      (format
	       t
	       "Warning - disconnected formula ~S in propagate-change ~S ~S~%"
	       formula schema slot))
	    (return-from propagate-change NIL))
	  (run-invalidate-demons new-schema new-slot)
	  ;; The formula gets invalidated here.
	  (set-cache-is-valid formula nil)
	  ;; Notify all children who used to inherit the old value.
	  (let ((new-schema-entry (slot-accessor new-schema new-slot)))
	    (when new-schema-entry
	      (if (is-parent new-schema-entry)
		  (update-inherited-values
		   new-schema
		   new-slot
		   new-schema-entry
		   (or old-bits
		       (setf old-bits (car (slot-accessor schema slot))))
		   T))
	      ;; Now recurse, following the slot in the schema on which the
	      ;; formula sits.
	      (when (is-depended new-schema-entry)
		(propagate-change new-schema new-slot)))))))))



;;; Remove all formulas from an entry, since we are copying it down to a place
;;; where it is inherited.
;;; 
(defun remove-formulas (values slot)
  (unless (has-formulas values)
    (return-from remove-formulas values))
  ;; The values contain at least one formula - do something
  ;; special, i.e., copy down a list of the ACTUAL values, getting
  ;; rid of all formulas.
  (let ((plain-values nil))
    ;; Multiple values, with at least one formula.
    (dolist (v (cdr values))
      (if (formula-p v)
	  ;; This is a formula
	  (push (g-value-formula-value *place-from-where-inherited* slot v)
		plain-values)
	  ;; This is a plain value
	  (push v plain-values)))
    (cons (logior (car values) *inherited-mask*) (nreverse plain-values))))




(defun update-inherited-internal (child a-slot new-values bits)
  (let ((child-values (slot-accessor child a-slot)))
    (when (and child-values
	       (is-inherited child-values)
	       ;; Check that the value was inherited from the right
	       ;; place, however (we don't want trouble in the
	       ;; following case:
	       ;;   the value is inherited from a schema which is NOT
	       ;;   the one we are modifying.  This can happen in the
	       ;;   case of multiple values in an inheritance slot).
	       ;;; *** THIS IS ENTIRELY WRONG - USE A DIFFERENT TEST !!!
	       ;;; ***
	       )
      ;; This child did indeed inherit from the <schema>.
      (if new-values
	  ;; Keep the inheritance bit, etc.
	  (progn
	    (setf (car child-values)
		  (logior bits (logand (car child-values) *middle-mask*)))
	    (setf (cdr child-values) (cdr new-values)))
	  ;; Construct the new values for the children: this is the
	  ;; same as the new list of values, except that the
	  ;; "inherited" bit is set.
	  (progn
	    (setf new-values
		  (cons (logior bits *inherited-mask*)
			(cdr new-values)))
	    ;; Change the child's inherited values.
	    (set-slot-accessor child a-slot new-values)))
      ;; Propagate down
      (update-inherited-values child a-slot child-values bits NIL))))




;;; This function is used when a value is changed in a schema.  It makes sure
;;; that any child schema which inherited the previous value is updated with
;;; the new value.
;;; INPUTS:
;;; - <the-entry>: the new (i.e., current) slot entry for the <schema>
;;; - <old-bits>: the setting of the slot bits for the <schema>, before the
;;;   current value-setting operation.
;;; - <is-first>: if non-nil, this is the top-level call.
;;; 
(defun update-inherited-values (schema a-slot the-entry old-bits is-first)
  (let ((*schema-self* schema))
    (unless is-first
      ;; Invoke demons and propagate change around.
      ;; *** (second the-entry) is NOT RIGHT, unless position = 0 !!!
      (run-pre-set-demons schema a-slot (second the-entry) NIL)
      (run-invalidate-demons schema a-slot)
      (propagate-change schema a-slot))
    ;; First of all, examine the all-important :IS-A-INV relation
    (dovalues (child schema :IS-A-INV :local T :formulas NIL)
      (when is-first
	(setf is-first NIL
	      the-entry (remove-formulas the-entry a-slot)
	      old-bits 0))
      (update-inherited-internal child a-slot the-entry 0))
    ;; If more inheritance relations have been defined, consider them as well
    ;; Look at all the CHILDREN (thus, use *inheritance-inverse-relations*)
    (dolist (inverse *inheritance-inverse-relations*)
      (unless (eq inverse :IS-A-INV)
	(dovalues (child schema inverse :local T :formulas NIL)
	  (when is-first
	    (setf is-first NIL
		  the-entry (remove-formulas the-entry a-slot)
		  old-bits 0))
	  (update-inherited-internal child a-slot the-entry old-bits))))))



;;; Similar to update-inherited-values, but used when the hierarchy is modified
;;; or when an inheritable slot is destroyed.
;;; SIDE EFFECTS:
;;; - the <function> is called on all children which actually inherit the
;;;   values in the <a-slot> of the <schema>.  This is determined by a fast
;;;   check (the list of values should be EQ to that of the parent).
;;; Note that the <function> is called after all children have been visited..
;;; This allows it to be a destructive function.
;;; 
(defun visit-inherited-values (schema a-slot function)
  (let ((parent-entry (cdr (slot-accessor schema a-slot))))
    ;; First of all, examine the all-important :IS-A-INV relation
    (dovalues (child schema :IS-A-INV :local T :formulas NIL)
      (let ((entry (slot-accessor child a-slot)))
	(when (and entry
		   (is-inherited entry)  ; on the off-change they might be EQ
		   (eq (cdr entry) parent-entry))
	  (visit-inherited-values child a-slot function)
	  (funcall function child a-slot))))
    ;; If more inheritance relations have been defined, consider them as well
    ;; Look at all the CHILDREN (thus, use *inheritance-inverse-relations*)
    (dolist (inverse *inheritance-inverse-relations*)
      (unless (eq inverse :IS-A-INV)
	(dovalues (child schema inverse :local T :formulas NIL)
	  (let ((entry (slot-accessor child a-slot)))
	    (when (and entry
		       (is-inherited entry)
		       (eq (cdr entry) parent-entry))
	      (visit-inherited-values child a-slot function)
	      (funcall function child a-slot))))))))



;;; Internal function which runs demons as appropriate (before changing the
;;; value) and then physically sets the <slot> in the <schema> to be
;;; <new-value>.
;;; 
(defun run-demons-and-set-value (schema slot new-value old-value position
					is-relation was-inherited is-formula
					was-formula the-entry)
  (run-invalidate-demons schema slot)	; 20 usec if no demon
  ;; Now set the value in the slot to be new-value.
  (cond ((and was-formula (not is-formula))
	 ;; This is the case when we allow temporary overwriting
	 (setf (cached-value old-value) new-value)
	 ;; Set this to NIL, temporarily, in order to cause propagation
	 ;; to leave the value alone.  It will be validated by s-value.
	 (set-cache-is-valid old-value NIL))
	(t
	 ;; All other cases
	 (when (and is-formula
		    ;; place old value in the cache only if
		    ;; an initial value was not provided for the
		    ;; new formula
		    (null (cached-value new-value)))
	   ;; Set value, but keep formula invalid.
	   (setf (cached-value new-value)
		 (if was-formula
		     (cached-value old-value)
		     old-value)))
	 (cond (the-entry
		;; A value descriptor for the slot already exists.
		(when was-inherited
		  ;; This value was inherited - make local.
		  (setf the-entry
			(copy-list the-entry))   ; No sharing of structure!
		  (setf (car the-entry)
			(logand (car the-entry) (lognot *inherited-mask*))))
		;; Take care of relations.
		(when is-relation
		  (let ((old-value (nth position (cdr the-entry))))
		    (when old-value
		      (unlink-one-value schema slot old-value))
		    (link-in-relation schema slot new-value)))
		(setf the-entry
		      (low-level-set-value the-entry position new-value
					   is-formula))
		(when was-inherited
		  (set-slot-accessor schema slot the-entry)))
	       (t
		;; This is a new value altogether
		(when (relation-p slot)
		  (link-in-relation schema slot new-value))
		(setf the-entry
		      (low-level-set-value the-entry position
					   new-value is-formula))
		(set-slot-accessor schema slot the-entry)))))
  ;; Now propagate the change to all the children which used to
  ;; inherit the previous value of this slot from the schema.
  (if (is-parent the-entry)
      (update-inherited-values schema slot the-entry (car the-entry) T)))




;;; SIDE EFFECTS:
;;; - <the-entry> may be modified, if it was an inherited list of values.
;;; 
(defun check-relation-slot (schema slot value position the-entry)
  (when (and the-entry (is-inherited the-entry))
    (when (> position 0)
      (format
       t "Position ~S is too large for slot ~S (a relation) in ~S!~%~
       Inherited values are NOT used in relation slots.~%"
       position slot schema)
      (return-from check-relation-slot nil))
    ;; We do not inherit values in relation slots, therefore we throw the
    ;; old entry away.
    (setf (cdr the-entry) nil)
    (set-is-inherited the-entry NIL)
    (return-from check-relation-slot T))
  (cond ((null the-entry)
	 (when (> position 0)
	   (format
	    t "Position ~S is too large for slot ~S (a relation) in ~S!~%"
	    position slot schema)
	   (return-from check-relation-slot nil)))
	((member value (cdr the-entry))
	 (format t "Value ~S already present in schema ~S, slot ~S!~%"
		 value schema slot)
	 (return-from check-relation-slot nil))
	((>= position (length the-entry))
	 (format
	  t "Position ~S is too large for slot ~S (a relation) in ~S!~%"
	  position slot schema)
	 (return-from check-relation-slot nil)))
  T)




;;; Since the <relation> slot was changed, all children of the <schema> may
;;; have to inherit different values.
;;; 
(defun reset-inherited-values (schema)
  (iterate-accessors (schema T)	; use inheritance!
    (unless (relation-p slot)
      (let ((entry (slot-accessor schema slot)))
	(when (and entry (is-inherited entry))
	  (destroy-slot schema slot))))))




;;;; S-VALUE-N
;;; Inputs:
;;; - <schema>: the name of a schema
;;; - <slot>: name of the slot to be modified.
;;; - <position>: a 0-based integer
;;; 
(defun s-value-n (schema slot position value)
  #-release-garnet
  "Sets the <position>-th value in the <slot> of the <schema> to be <value>.
  The <value> can be a Lisp object or a formula."
  (let* ((the-entry (slot-accessor schema slot))
	 is-inherited
	 (old-value (when (and the-entry
			       (not (setf is-inherited
					  (is-inherited the-entry))))
		      (if (zerop position)
			  (cadr the-entry)
			  (nth position (cdr the-entry)))))
	 was-formula is-formula is-depended is-relation)
    ;; Are we setting to the same value as the old one?
    (when (and (eq value old-value) value)
      (return-from s-value-n value))
    (setf was-formula (formula-p old-value)
	  is-formula (formula-p value))
    ;; Forbid changes to slots with a formula in them.
    (unless *allow-change-to-cached-value*
      (if (and was-formula is-formula)
	  ;; Do not change anything in this case.
	  (return-from s-value-n (cached-value old-value))))
    ;; Check for special cases in relation slots.
    (when (setf is-relation (relation-p slot))
      (unless (schema-p value)
	(format
	 t "S-VALUE-N: relation value ~s is not a schema!  Ignored.~%" value)
	(return-from s-value-n value))	
      (unless (check-relation-slot schema slot value position the-entry)
	(return-from s-value-n value)))
    
    ;; Now we call a demon to perform redisplay activities if the new
    ;; value is not a formula. If the new value is a formula, it has
    ;; not been evaluated yet so we do not know what its result is.
    ;; Since the display demon needs to know the new result to determine
    ;; if the object's bounding box should be merged with a clip region,
    ;; it does not make sense to call the display demon until the new
    ;; result is known
    (if (not is-formula)
	(run-pre-set-demons schema slot value NIL))
    
    ;; Now we can set the new value.
    (run-demons-and-set-value
     schema slot value old-value position
     is-relation is-inherited is-formula was-formula the-entry)

    ;; Notify all dependents that the value changed.
    (when (setf is-depended (is-depended the-entry))
      (let ((*warning-on-disconnected-formula* nil))
	(propagate-change schema slot)))
    
    (if (and (not is-formula) was-formula)
	;; We validate now, rather than earlier, because of a technicality
	;; in demons-and-old-values.
	(set-cache-is-valid old-value T))
    ;; Are we installing a formula on a slot which is depended upon? This
    ;; is typically a constraint loop.
    ;; *** THIS IS ONLY CORRECT FOR ONE-FORMULA SLOTS !  CHANGE!!!
    (when (and is-formula is-depended)
      (let* ((*schema-slot* slot)
	     (*current-formula* value)
	     s-value-result)
	;; Force computation of dependencies by actually evaluating the formula.
	(setf s-value-result
	      (funcall (let ((*use-formulas-for-inheritance* nil))
			 (g-value value :KR-FUNCTION))
		       schema))
	;; call the "display" demon, since the new value's formula has been
	;; evaluated
	(run-pre-set-demons schema slot s-value-result T)
	(setf (cached-value value) s-value-result)
	;; Mark as valid.
	(set-cache-is-valid value T)))
    ;; Was the old value a formula?
    (when (and was-formula is-formula)
      ;; This is replacing a formula with another.  Eliminate the dependency
      ;; to the old one.
      (de-install-formula old-value))
    ;; If we are installing a formula, make sure that the formula
    ;; points to the schema and slot.
    (when is-formula
      (setf (on-schema value) schema)
      (setf (on-slot value) slot))
    (when is-relation
      ;; A relation slot is being changed.  We may need to invalidate all
      ;; inherited values.
      (reset-inherited-values schema))
    value))





;;;; APPEND-VALUE
;;; 
(defun append-value (schema slot value)
  #-release-garnet
  "Add the <value> to the end of the list of values in the <slot> of the
  <schema>."
  (let ((entry (slot-accessor schema slot)))
    (if entry
	(s-value-n schema slot (length (cdr entry)) value)
	(s-value-n schema slot 0 value))))



;;; DELETE-VALUE-N
;;; 
(defun delete-value-n (schema slot position)
  #-release-garnet
  "Deletes the value currently at the given <position> in the <slot> of the
  <schema>."
  (let ((entry (slot-accessor schema slot)))
    (when entry 		; Do nothing if the slot is not there
      (when (< -1 position (length (cdr entry)))
	(let ((old-value (nth position (cdr entry))))
	  (when (relation-p slot)
	    (unlink-one-value schema slot old-value))
	  ;; Eliminate the position-th element from the list of values.
	  (if (zerop position)
	      (pop (cdr entry))
	      (pop (cdr (nthcdr position entry))))
	  (when (formula-p old-value)
	    (set-has-formulas
	     entry (find-if #'(lambda (x) (a-formula-p x)) (cdr entry)))))
	t))))



;;;; DO-PRINTABLE-SLOTS
;;; 
;;; A cross between DOSLOTS and PS: only slots that would be printed by
;;; PS are visited, in the right order.
;;;
(defun do-printable-slots (schema function &key (control t) (inherit nil))
  (declare (special print-schema-control))
  (when schema
    (cond ((eq control :default)
	   ;; use default control schema
	   (setf control PRINT-SCHEMA-CONTROL))
	  ((eq control T)
	   ;; use schema itself as the control schema (i.e., use hierarchy)
	   (setf control schema)))
    (let ((slots-ignored (if control (get-values control :IGNORED-SLOTS)))
	  (sorted (if control (get-values control :SORTED-SLOTS))))
      ;; Do all the sorted slots, first.
      (dolist (slot sorted)
	(let* ((descriptor (slot-accessor schema slot))
	       (is-inherited (and (car descriptor) (is-inherited descriptor))))
	  (if is-inherited
	      (if inherit
		  (funcall function schema slot t))
	      (if descriptor
		  (funcall function schema slot NIL)))))
      ;; Now do the remaining slots.
      (if inherit
	  (iterate-accessors (schema T)
	    (unless (or (member slot slots-ignored) (member slot sorted))
	      (funcall function schema slot 
		       (is-inherited (slot-accessor schema slot)))))	  
	  (iterate-accessors (schema NIL)
	    (unless (or (member slot slots-ignored) (member slot sorted))
	      (funcall function schema slot NIL)))))))



;;; -------------------------------------------------- Special printing


;;; 
(defun print-one-value (value)
  (let ((string (if (formula-p value)
		    (let ((cached (cached-value value)))
		      (if cached
			  (format nil "~S(~S . ~D)"
				  value
				  cached
				  (cache-is-valid value))
			  (format nil "~S(nil . NIL)" value)))
		    (format nil "~S" value))))
    (write-string string)
    (length string)))


(defun print-one-slot-helper (value column indent)
  (when (> column 78)
    (format t "~%    ")
    (setf column (indent-by indent)))
  (write-string " ")
  (incf column (print-one-value value))
  column)



(defun print-one-slot (schema name limit-values inherited-ok indent)
  (let* ((values (slot-accessor schema name))
	 (are-inherited (and (listp values)
			     (integerp (car values))
			     (is-inherited values))))
    (unless (or (null values)
		(and (not inherited-ok) are-inherited))
      (let ((position 0)
	    (printed nil)
	    (column (+ 20 (indent-by indent))))
	(if are-inherited
	    (format t "  ~(~S~) (inherited): " name)
	    (format t "  ~S = " name))
	(dovalues (value schema name :local (not inherited-ok)
			 :formulas NIL)
	  (setf printed t)
	  (setf column (print-one-slot-helper value column indent))
	  (when (and limit-values
		     (> position limit-values))
	    ;; Too many values: use ellipsis form.
	    (format t " ...~%")
	    (return-from print-one-slot nil)))
	(if printed
	    (terpri)
	    (format t " NIL~%"))))))



(defun indent-by (indent)
  (dotimes (i indent)
    (write-string "   "))
  (* indent 3))




;;;; PS
;;;
;;; PS allows fancy control of what gets printed and how.
;;; <control> is one of:
;;; - T, which means that the <schema> itself is used
;;;   as the controlling schema.
;;; - :default, which means that PRINT-SCHEMA-CONTROL is used as the
;;;   controlling schema;
;;; - a schema, which is used as the controlling schema; or
;;; - NIL or nothing, which means no schema control.
;;; <inherit> controls whether inherited slots are printed.  If non-nil,
;;; all slots that have been inherited are printed out.
;;; 
;;;
(defun ps (schema &key (control t) inherit (indent 0))
  #-release-garnet
  "PS prints the <schema>.  The optional arguments control what is printed.
  A control schema may be used to determine which options are printed, which
  ones are ignored, etc.  See the manual for details.

  <control> can be one of the following:
  NIL, which means that the <schema> is printed in its entirety;
  T, which means that the <schema> itself is used as the control schema;
  :DEFAULT, which means that the schema KR:PRINT-SCHEMA-CONTROL is used;
  any schema, which is used as the control schema.

  If <inherit> is non-nil, slots that have been inherited are also printed.
  <indent> is used for debugging and should not be set by the user."
  (declare (special print-schema-control))
  (if (numberp schema)
      (setf schema (s schema)))
  (when schema
    (indent-by indent)
    (cond ((eq control :default)
	   ;; use default control schema
	   (setf control PRINT-SCHEMA-CONTROL))
	  ((eq control T)
	   ;; use schema itself as the control schema (i.e., use hierarchy)
	   (setf control schema)))
    (let ((slots-ignored (if control (get-values control :IGNORED-SLOTS)))
	  (sorted (if control (get-values control :SORTED-SLOTS)))
	  (limit-values (if control (get-values control :LIMIT-VALUES)))
	  (global-limit (if control
			    (g-value control :global-limit-values)
			    most-positive-fixnum))
	  (*print-as-structure*
	   (if (and control
		    (get-values control :print-as-structure))
	       ; value is defined
	       (g-value control :print-as-structure)
	       ; value is undefined
	       *print-as-structure*))
	  (*print-structure-slots* (if control
				       (g-value control :print-slots)))
	  name)
      (format t "{~S~%" schema)
      ;; Print out all the sorted slots, first.
      (dolist (o sorted)
	(print-one-slot schema o
			(or (second (assoc name limit-values))
			    global-limit)
			inherit indent))
      ;; Now print the remaining slots.
      (iterate-accessors (schema)
	(unless (or (member slot slots-ignored) (member slot sorted))
	  (print-one-slot schema slot
			  (or (second (assoc slot limit-values))
			      global-limit)
			  inherit indent)))
      (when slots-ignored
	(indent-by indent)
	(format t "  List of ignored slots:  ~{ ~A~}~%" slots-ignored))
      ;; special formula slots?
      (when (a-formula-p schema)
	(indent-by indent)
	(format t "  on schema  ~S,  slot ~S~%"
		(on-schema schema) (on-slot schema))
	(format t "  cached value:  (~S . ~S)~%"
		(cached-value schema) (cache-is-valid schema)))
      (indent-by indent)
      (format t "  }~%"))))


;;; --------------------------------------------------


;;; Internal debugging - print out schemata in gory detail.


(defun the-bits (entry slot)
  (declare (ignore slot))
  (if (listp entry)
      ;; The normal case
      (format nil "~:[-~;f~]~:[-~;d~]~:[-~;P~]~:[-~;i~]"
	      (has-formulas entry)
	      (is-depended entry)
	      (is-parent entry)
	      (is-inherited entry))
      ;; A special case for formula slots which are stored in a special way
      (format nil "----")))



(defun full (&rest schemata)
  (dolist (schema schemata)
    (format t "----    schema ~S~%" schema)
    (let ((is-formula (a-formula-p schema)))
      ;; use iterate-accessors to get inherited slots as well
      (iterate-accessors (schema)
	(format t "~18S " slot)
	(let ((entry (slot-accessor schema slot)))
	  (if entry
	      (let ((first t))
		(format t "~A (" (the-bits entry slot))
		(if (listp entry)
		    ;; The normal case
		    (dolist (value (cdr entry))
		      (if first
			  (setf first nil)
			  (write-string " "))
		      (print-one-value value))
		    ;; A special formula slot
		    (print-one-value entry))
		(format t ")~%"))
	      (format t "NIL~%"))))
      ;; special formula slots?
      (when is-formula
	(format t "Schema, slot:           ~S  ~S~%"
		(on-schema schema) (on-slot schema))
	(format t "Cached value:           (~S . ~S)~%"
		(cached-value schema) (a-formula-cached-number schema))
	(format t "Depends on:             ~{~S~^ ~}~%"
		(a-formula-depends-on schema))))))



;;; --------------------------------------------------





;;; Auxiliary function for create-schema.
;;; Makes sure that all slot values are evaluated.
;;; 
(eval-when (compile load eval)

  (defun create-schema-body (schema rest)
    (when rest
      (do ((tail rest (cdr tail))
	   (generate-instance nil)
	   (body nil))
	  ((null tail)
	   (when generate-instance
	     ;; We are generating code for a CREATE-INSTANCE, really
	     (push '(copy-down-formulas schema) body)
	     (push '(kr-call-initialize-method schema :initialize) body))
	   (nreverse body))
	(let ((slot-init (car tail)))
	  (cond ((eq slot-init :NAME-PREFIX)
		 ;; Skip this and the following argument
		 (setf tail (cdr tail)))
		((eq slot-init :GENERATE-INSTANCE)
		 (setf generate-instance T))
		((consp slot-init)
		 (let ((slot-name (car slot-init))
		       (slot-value (cdr slot-init)))
		   (when slot-value
		     (push (if (= (length slot-value) 1)
			       ;; Note the use of S-VALUE, instead of SET-VALUE.
			       `(s-value ,schema ,slot-name ,@slot-value)
			       `(set-values ,schema ,slot-name
					    ',(mapcar #'eval slot-value)))
			   body))))))))))



(defun wipe-out-old-schema (name)
  (cond ((null name)
	 ;; An unnamed schema.
	 (let ((schema (make-a-schema)))
	   (setf *schema-counter* (1+ *schema-counter*))
	   (setf (schema-name schema) *schema-counter*)
	   schema))
	((and (boundp name)
	      (symbolp name))
	 (let ((schema (symbol-value name)))
	   (if (schema-p schema)
	       (recursive-destroy-schema schema 0)
	       (progn
		 (setf schema (make-a-schema))
		 (eval `(defvar ,name))))
	   ;; Assign the new schema as the value of the variable <name>.
	   (setf (schema-name schema) name)
	   (set name schema)))
	((symbolp name)
	 (eval `(defvar ,name))
	 (let ((schema (make-a-schema)))
	   (setf (schema-name schema) name)
	   (set name schema)))
	(t
	 (format t "Error in CREATE-SCHEMA - ~S is not a valid schema name.~%"
		 name))))


;;;; CREATE-SCHEMA
;;; 
;;; The keyword :OVERRIDE may be used to indicate that the schema should
;;; be kept, if it exists, and newly specified slots should simply override
;;; existing ones.  The default behavior is to wipe out the old schema.
;;; 
(defmacro create-schema (name &rest rest)
  (let ((prefix (member :NAME-PREFIX rest)))
    (cond ((and prefix (null name))
	   ;; We have an unnamed schema but a name prefix - use it.
	   (setf name (second prefix))
	   (let ((intern-immediately (not (stringp name))))
	     `(let* ((*schema-is-new* T)
		     (schema (make-a-schema))
		     ,@(when intern-immediately
			 '((debug-package (find-package "KR-DEBUG"))
			   new-name)))
		,@(when intern-immediately
		    `((setf *schema-counter* (1+ *schema-counter*))
		      (setf new-name (intern (format nil "~A-~D"
						     ,name
						     *schema-counter*)
					     debug-package))
		      (export new-name debug-package)
		      ;; for debugging purposes only
		      (cache-schema-name schema new-name)
		      ;; Assign the schema as a value to the symbol.
		      (set new-name schema)))
		(setf (schema-name schema) ,(if intern-immediately
						'new-name
						name))
		,@(let ((slot-forms (create-schema-body 'schema rest)))
		    (if slot-forms
			`((with-demons-disabled
			   ,@slot-forms))))
		schema)))
	  (T
	   ;; A named schema.
	   (when prefix
	     (format
	      t
	      "Warning - you specified both a name and a :NAME-PREFIX option in~@
	      (create-schema ~S).  Ignoring the :NAME-PREFIX.~%"
	      name)
	     (setf prefix nil))
	   ;; Make the schema name known at compile time, so we do not issue
	   ;; silly warnings.
	   (if (and (listp name)
		    (eq (car name) 'QUOTE))
	       (proclaim `(special ,(eval name))))
	   (let ((destroy (not (member :OVERRIDE rest))))
             ;; I think this is ignored anyhow 24-Jul-91 -FER
	     ;(eval-when (eval)
	       (when *print-new-instances*
		 (if (and (listp name)
			  (eq (car name) 'QUOTE))
		     (format *standard-output*
			     "Instance ~S created.~%" (eval name))))
             ;)
	     `(let (,@(when (and destroy rest) '((*schema-is-new* T)))
		      (schema ,(if destroy
				   `(wipe-out-old-schema ,name)
				   `(if (boundp ,name) (symbol-value ,name))))
		      (*demons-disabled* t))
		#+COMMENT
		,@(let ((slot-forms (create-schema-body 'schema rest)))
		    (if slot-forms
			`((with-demons-disabled
			   ,@slot-forms))))
		,@(create-schema-body 'schema rest)
		schema))))))





;;; -------------------------------------------------- O-O PROGRAMMING



(defvar *kr-send-self* nil
  #-release-garnet
  "The current schema for kr-send.")

(defvar *kr-send-slot* nil
  #-release-garnet
  "The current slot for kr-send.")



;;; Find a parent of <schema> from which the <slot> can be inherited.
;;; 
(defun find-parent (schema slot)
  #+DEBUGGING (accessed-slot schema slot :s-call-number)
  (dolist (relation *inheritance-relations*)
    (dovalues (a-parent schema relation :local T :formulas NIL)
      (when a-parent
	(let ((value (g-local-value a-parent slot)))
	  (if value
	      (return-from find-parent (values value a-parent))
	      (multiple-value-bind (value the-parent)
				   (find-parent a-parent slot)
		(if value
		    (return-from find-parent (values value the-parent))))))))))




;;;; KR-SEND
;;; 
;;; 
(defmacro kr-send (schema slot &rest args)
  `(let* ((schema ,schema)
	  (the-function (g-value schema ,slot)))
     (when the-function
       ;; Bind these in case call-prototype-method is used.
       (let ((*kr-send-self* schema)
	     (*kr-send-slot* ,slot))
	 (funcall the-function ,@args)))))



;;; Same, but as a function.
;;; 
;;; 24-Jul-91 - dead code -fer
;(defun kr-send-function (schema slot &rest args)
;  (let ((the-function (g-value schema slot)))
;    (when the-function
;      ;; Bind these in case call-prototype-method is used.
;      (let ((*kr-send-self* schema)
;            (*kr-send-slot* slot)
;            (*demons-disabled* T))
;        (apply the-function args)))))




;;; This is similar to kr-send-function, except that it is careful NOT to
;;; inherit the method, which is only used once.  This is to reduce unnecessary
;;; storage in every object.
;;; 
(defun kr-call-initialize-method (schema slot)
  (let ((the-function (g-value-no-copy-down schema slot)))
    (when the-function
      ;; Bind these in case call-prototype-method is used.
      (let ((*kr-send-self* schema)
	    (*kr-send-slot* slot)
	    (*demons-disabled* T))
	(funcall the-function schema)))))



;;; This is a specialized function which does inheritance but does NOT copy
;;; values down.  It is used by the :INITIALIZE method, which is called exactly
;;; once per object and should NOT copy down anything (since the method will
;;; never be used again).
;;; 
(defun g-value-no-copy-down (schema slot)
  ;; Is there a local value?
  (let ((entry (slot-accessor schema slot)))
    (if (cadr entry)
	(return-from g-value-no-copy-down (cadr entry))))
  ;; Now try inherited values.
  (dolist (relation *inheritance-relations*)
    (dovalues (*schema-self* schema relation :local T :formulas T)
      ;; dzg - changed from (setf *place-from-where-inherited* *schema-self*)
      (let* ((*place-from-where-inherited* *schema-self*)
	     (value (g-value-no-copy-down *schema-self* slot)))
	(if value
	    (return-from g-value-no-copy-down value))))))



;;;; CALL-PROTOTYPE-METHOD
;;; 
(defmacro call-prototype-method (&rest args)
  `(let (parent method)
     (declare (ignore method))
     (if (get-local-value *kr-send-self* *kr-send-slot*)
	 (setf parent *kr-send-self*)
	 (multiple-value-setq (method parent)
	   (find-parent *kr-send-self* *kr-send-slot*)))
     (multiple-value-bind (function- the-parent)
			  (find-parent parent *kr-send-slot*)
       (when function-
	 (let ((*kr-send-self* the-parent))
	   (funcall function- ,@args))))))



;;;; DEFINE-METHOD
;;; 
(defmacro define-method (name class arg-list &rest body)
  (unless (keywordp name)
    (setf name (intern (symbol-name name) (find-package "KEYWORD")))
    (format t "DEFINE-METHOD takes a keyword as the method name - using ~S~%"
	    name))
  (let* ((function-name (intern (concatenate 'string
					     (symbol-name name)
					     "-METHOD-"
					     (symbol-name class)))))
    `(progn
       (defun ,function-name ,arg-list
	 ,@body)
       (s-value ,class ,name ',function-name))))



;;;; METHOD-TRACE
;;; 
(defmacro method-trace (class generic-fn)
  (let ((fn (g-value class generic-fn))) 
    `(trace ,fn)))



;;; --------------------------------------------------


(defun copy-down-internal (the-schema slot parent)
  (unless (eq slot :IS-A-INV)
    ;; FIX THIS TO DEAL WITH ALL VALUES!
    ;; Note use of GET-VALUE
    (let ((c-p-value (get-value parent slot)))
      (when (and (formula-p c-p-value)
		 (not (has-slot-p the-schema slot)))
	;; Copy formula down to the instance level.
	(s-value the-schema slot
		 (formula
		  c-p-value
		  (cached-value c-p-value)))))))



;;; Install a copy of each formula (i.e., an inherited formula) on each
;;; slot of the instance <the-schema> which requires one.
;;; 
(defun copy-down-formulas (the-schema)
  (dovalues (parent the-schema :IS-A :local T)
    (let ((local-only (get-values parent :LOCAL-ONLY-SLOTS))
	  entry)
      (iterate-accessors (parent)
	(let ((value (get-value parent slot)))
	  (if (formula-p value)
	      ;; Formulas are copied down as formulas, in all cases.
	      (copy-down-internal the-schema slot parent)
	      ;; Otherwise, see if this is a local-only slot
	      (if (setf entry (assoc slot local-only))
		  ;; Prevent inheritance from ever happening
		  (unless (slot-accessor the-schema slot) ; do nothing if
		    		; already present (was set before)
		    (if (second entry)
			;; Copy down the parent value, once and for all.
			(set-value the-schema slot (g-value parent slot))
			;; We want to avoid inheritance and set the slot to NIL.
			(set-value the-schema slot NIL))))))))))




;;;; CREATE-PROTOTYPE
;;; 
(defmacro create-prototype (name &rest slots)
  `(let ((schema (create-schema ,name ,@slots)))
     (copy-down-formulas schema)
     schema))



;;;; CREATE-INSTANCE
;;; 
(defmacro create-instance (name class &body body)
  (when (and name
	     (listp name)
	     (eq (cadr name) class))
    (format t "CREATE-INSTANCE: cannot make ~S an instance of itself!  ~
    Using NIL instead.~%" class)
    (setf class nil))
  (when (assoc :IS-A body)
    (format t "CREATE-INSTANCE: do not specify the :IS-A slot!  Ignored.~%"
	    class)
    (setf body (remove (assoc :IS-A body) body)))
  `(create-schema ,name :GENERATE-INSTANCE
     ;; class might be nil, which means no IS-A slot
     ,@(if class `((:is-a ,class)))
     ,@body))



;;; --------------------------------------------------


;;;; INITIALIZE-KR
;;; 
;;; Call once at the beginning.
;;; 
(defun initialize-kr ()
  (setf *relations* nil)
  (setf *inheritance-relations* nil)
  ;; The IS-A relation, which should come first in the list.
  (create-relation :IS-A T :IS-A-INV)
  ;; Create the default schema which controls the behavior of PS
  ;; 
  (create-schema 'PRINT-SCHEMA-CONTROL
    ;; Names of slots which should be printed out first, in the right order.
    (:sorted-slots :left :top :width :height)
    ;; Names of slots which should not be printed out at all.
    (:ignored-slots :depended-slots)
    ;; A list of slots and maximum numbers.  If the number of values in a slot
    ;; exceed the limit, ellipsis will be printed.
    (:limit-values '(:IS-A-INV 5) '(:COMPONENTS 20))
    ;; Maximum limit for number of values (global).
    (:global-limit-values 10)))



;;; RETURNS:
;;; the list of update slots, i.e., the slots upon which demons are called
;;; at setting-time.
;;; 
(defun update-slots-list (schema)
  (get-value schema :update-slots))


(defun set-update-slots (schema list-of-slots)
  (set-values schema :update-slots list-of-slots))

;;; Concatenated from type module "kr" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/kr/f1.4/constraints.lisp".
;;; -*- Mode: LISP; Package: KR; Base: 10; Syntax: Common-Lisp -*-


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(in-package "KR")

(export '(path))

;;; Experimental, fixed-path code.

(defun fixed-path-accessor (schema slots path-number)
  (let* ((current (a-formula-path *current-formula*))
	 (length (length current)))
    (or (and (< path-number length)
	     (elt current path-number))
	(progn
	  (dolist (slot slots)
	    (setf schema (g-value schema slot)))
	  (unless (> length path-number)
	    ;; create more storage
	    (setf current
		  (setf (a-formula-path *current-formula*)
			(append current
				(make-list (- path-number length -1))))))
	  (setf (elt current path-number) schema)
	  schema))))




(defmacro path (path-number &rest slots)
  `(fixed-path-accessor *schema-self* ',slots ,path-number))


;;; -------------------------------------------------- FORMULAS


;;; This version stores the formula as an INTERPRETED lambda.
;;; If <initial-value> is supplied, it is stored as the cached value for the
;;; formula; the formula, however, is still marked invalid.
;;; 
(defun formula (form &optional (initial-value nil))
  #-release-garnet
  "Creates an interpreted formula.  The <form> can be either a Lisp expression
  (which is used as the body of the formula), or another formula.  In the
  latter case, the other formula is made the parent, and this function
  creates an inherited formula.  The <initial-value>, which defaults to nil,
  is used as the initial cached value before the formula is evaluated."
  (let ((formula (make-a-formula)))
    (setf (name-accessor formula) (incf *schema-counter*))
    (setf (cached-value formula) initial-value)
    (setf (a-formula-cached-number formula) 0)
    (if (formula-p form)
	;; We were passed an object which is already a formula.  Link to it.
	(let ((*schema-is-new* T)   ; No need to check the :IS-A-INV slot here!
	      (*count-formulas* NIL))
	  (set-value formula :IS-A form))
	;; Normal case: we were given a Lisp expression
	(set-slot-accessor formula :KR-FUNCTION
			   (list *local-mask*
				 `(lambda (*schema-self*) ,form))))
    formula))



(defun prepare-formula (initial-value)
  (let ((formula (make-a-formula)))
    (setf (name-accessor formula) (incf *schema-counter*))
    (setf (cached-value formula) initial-value)
    (setf (a-formula-cached-number formula) 0)
    formula))



;;; This version creates compilable formulas (but does not, by itself, actually
;;; compile them).
;;; 
(defmacro o-formula (form &optional (initial-value nil))
  `(if (formula-p ',form)
       ;; Just create an inherited formula
       (formula ,form ,initial-value)
       ;; This is a real o-formula
       (let ((formula (prepare-formula ,initial-value)))
	 (with-demons-disabled
	  (s-value formula :KR-FUNCTION
		   (function (lambda (*schema-self*) ,form)))
	  (s-value-n formula :KR-FUNCTION 1 ',form))
	 formula)))



;;;; CHANGE-FORMULA
;;; 
;;; Modify the function associated with a formula.  Several possible
;;; combinations exist:
;;; - If the function is local and there are no children, just go ahead and
;;;   invalidate the formula.
;;; - if the function is local and there are children, invalidate all the
;;;   children formulas as well.
;;; - if the function used to be inherited, replace it and eliminate the
;;;   link with the parent formula.
;;; 
(defun change-formula (schema slot form)
  #-release-garnet
  "Modifies the formula at position 0 in the <slot> of the <schema> to have
  <form> as its new function.  Inherited formulas are treated appropriately."
  (let ((formula (get-value schema slot)))
    (when (formula-p formula)
      (unless (get-local-value formula :KR-FUNCTION)
	;; This function was inherited.  Cut the link, i.e., IS-A.
	(destroy-slot formula :IS-A))
      ;; If this formula has children, we need to invalidate them as well.
      (dovalues (f-child formula :IS-A-INV :local T)
	;; Invalidate all the children
	(set-cache-is-valid f-child nil)
	(mark-as-changed (on-schema f-child) (on-slot f-child)))
      ;; Invalidate the formula itself.
      (set-cache-is-valid formula nil)
      (mark-as-changed schema slot)
      ;; Record the new function.
      (let ((entry (a-formula-kr-function formula)))
	(setf (cadr entry) `(lambda (*schema-self*) ,form))
	;; Eliminate the FORM, if there was one
	(setf (cddr entry) NIL)))))



;;;; COPY-FORMULA
;;; Makes a copy of a formula, keeping the same initial value and the same
;;; parent (if any)
;;; 
(defun copy-formula (formula)
  (let ((parent (cadr (a-formula-is-a formula)))
	(value (a-formula-cached-value formula)))
    (if parent
	(formula parent value)
	(let ((result (formula nil value)))
	  (setf (a-formula-kr-function result)
		(copy-list (a-formula-kr-function formula)))
	  result))))



;;; --------------------------------------------------


(defun broken-link-throw (slot position)
  ;; 1. eliminate the dependencies from the formula, since they are no longer
  ;;    accurate
  (setf (a-formula-depends-on *current-formula*) nil)
  (setf *last-formula* *current-formula*)
  ;; 2. give warning if so desired.
  (if *warning-on-null-link*
      (format
       t
       "Warning: broken link in schema ~S (last slot ~S, position ~S);~%  reusing stale value in formula ~S.~%"
       *schema-self* slot position *current-formula*))
  ;; 3. throw to the top level
  (throw 'no-link 'fail))


;;; This function is for use in formulas.  It represents a direct (i.e.,
;;; no-link) dependency.  If the <slot> of the <schema> changes, the formula
;;; will be re-evaluated. 
;;; 
(defun gv-fn (schema slot position)
  (if (eq schema :self)
      (setf schema *schema-self*))
  ;; Record the link dependency for this parent and formula
  (unless schema
    ;; A link is broken.  Get out of here!
    (broken-link-throw slot position))
  (let ((gv-fn-entry (assoc slot (get-local-values schema :DEPENDED-SLOTS))))
    (unless gv-fn-entry
      ;; This slot was not yet depended on by anybody.
      (push (setf gv-fn-entry (list slot))
	    (get-local-values schema :DEPENDED-SLOTS))
      (let ((entry (slot-accessor schema slot)))
	(unless entry
	  ;; This value was not present at all.  Get it (through inheritance,
	  ;; typically) and then mark it as depended on by someone.
	  (unless (member *current-formula* (cdr gv-fn-entry))
	    (push *current-formula* (cdr gv-fn-entry)))
	  (let ((value (g-value schema slot position)))
	    (setf entry (slot-accessor schema slot))
	    (when entry
	      (setf (car entry) (logior (car entry) *depended-mask*)))
	    (return-from gv-fn value)))
	;; Mark this value as being depended on by someone.
	(setf (car entry) (logior (car entry) *depended-mask*))))
    (unless (member *current-formula* (cdr gv-fn-entry))
      (push *current-formula* (cdr gv-fn-entry))
      ;; Check this only here - if the current formula was already in the
      ;; list, then the reverse pointer would be already in place.
      (unless (member schema (a-formula-depends-on *current-formula*))
	;; this is apparently a lot faster than PUSHNEW
	(push schema (a-formula-depends-on *current-formula*)))))
  ;; Now call G-VALUE to get the value from the slot.
  (g-value schema slot position))



;;; This is the core of GV-FN, without the G-VALUE at the end.  It returns
;;; the schema itself (converting :SELF if necessary).
;;; 
(defun setup-dependency (schema slot position)
  (if (eq schema :self)
      (setf schema *schema-self*))
  ;; Record the link dependency for this parent and formula
  (unless schema
    ;; A link is broken.  Get out of here!
    (broken-link-throw slot position))
  (let ((gv-fn-entry (assoc slot (get-local-values schema :DEPENDED-SLOTS))))
    (unless gv-fn-entry
      ;; This slot was not yet depended on by anybody.
      (push (setf gv-fn-entry (list slot))
	    (get-local-values schema :DEPENDED-SLOTS))
      (let ((entry (slot-accessor schema slot)))
	(unless entry
	  ;; This value was not present at all.  Get it (through inheritance,
	  ;; typically) and then mark it as depended on by someone.
	  (unless (member *current-formula* (cdr gv-fn-entry))
	    (push *current-formula* (cdr gv-fn-entry)))
	  (g-value schema slot position)
	  (setf entry (slot-accessor schema slot))
	  (when entry
	    (setf (car entry) (logior (car entry) *depended-mask*)))
	  (return-from setup-dependency schema))
	;; Mark this value as being depended on by someone.
	(setf (car entry) (logior (car entry) *depended-mask*))))
    (unless (member *current-formula* (cdr gv-fn-entry))
      (push *current-formula* (cdr gv-fn-entry))
      ;; Check this only here - if the current formula was already in the
      ;; list, then the reverse pointer would be already in place.
      (unless (member schema (a-formula-depends-on *current-formula*))
	;; this is apparently a lot faster than PUSHNEW
	(push schema (a-formula-depends-on *current-formula*)))))
  schema)



#|
(defmacro new-gv (object slot &optional (position 0))
  `(g-value (setup-dependency ,object ,slot ,position) ,slot ,position))

(export '(new-gv setup-dependency))
|#


#|
(defun gv-no-fn (schema slot position)
  (if (eq schema :self)
      (setf schema *schema-self*))
  ;; Record the link dependency for this parent and formula
  (unless schema
    ;; A link is broken.  Get out of here!
    (broken-link-throw slot position))
  ;; Now call G-VALUE to get the value from the slot.
  (g-value schema slot position))


(defmacro expand-0-accessor (accessor-function end-accessor schema &rest slots)
  (if (= (length slots) 1)
      ;; Supply default position (0).
      (setf slots (list (car slots) 0)))
  (if slots
      ;; At least one slot was specified.
      (let* ((last-thing (car (last slots)))
	     (position
	      ;; ASSUMPTION: the last of the <slots> should be either an
	      ;; actual slot, known at compile time, or else a position number.
	      ;; In other words, the last slot CANNOT be specified by an
	      ;; expression or a variable.
	      (cond ((keywordp last-thing)
		     0)
		    (t
		     (prog1
			 (car (last slots))
		       ;; Eliminate position number from list of slots.
		       (setf (cdr (nthcdr (- (length slots) 2) slots))
			     NIL)))))
	     (kernel schema))
	;; "Grow" the kernel by wrapping more gv-fn's around it
	(do ((slot slots (cdr slot)))
	    ((null slot))
	  (setf kernel `(,(if (cdr slot)
			      accessor-function
			      end-accessor)
			 ,kernel ,(car slot)
			 ,(if (null (cdr slot)) position 0))))
	kernel)
      ;; No slots!
      (error "expand-accessor: at least one slot is required")))


(defmacro gv-special (schema &rest slots)
  (cond (slots
	 `(expand-0-accessor gv-no-fn gv-fn ,schema ,@slots))
	((eq schema :self)
	 `(progn *schema-self*))
	(t
	 `(progn ,schema))))




;;; uses closures, but does not work for inherited formulas
;;; 
(defun generate-path (path-cache)
  #'(lambda (schema slots)
      (or path-cache
	  (dolist (slot slots
			(setf path-cache schema))
	    (setf schema (g-value schema slot))))))


(defmacro a-path (&rest slots)
  (let ((p-f (generate-path nil)))
    `(funcall ',p-f *schema-self* ',slots)))



(create-schema 'a (:left 10))
(create-schema 'b (:parent a) (:left (o-formula (a-path :parent :left))))
(create-schema 'c (:parent a) (:left (o-formula (gv (a-path :parent) :left))))
(full a b)
(g-value b :left)
(g-value c :left)
(full a c)
(incf (g-value a :left))

(create-instance 'd c (:top 12))
(g-value d :left)





;;; A version with built-in schema self
(defun generate-path (path-cache)
  #'(lambda (schema slots)
      (or path-cache
	  (dolist (slot slots
			(setf path-cache schema))
	    (setf schema (g-value schema slot))))))

(defmacro s-path (*schema-self* &rest slots)
  (let ((p-f (generate-path nil)))
    `(funcall ',p-f ,*schema-self* ',slots)))


|#


;;;; GV
;;; To be used in formulas.
;;; This macro expands into a chain of nested calls to gv-fn, which creates
;;; a dependency point in a formula.
;;;
(defmacro gv (schema &rest slots)
  (cond (slots
	 (let (slot)
	   (if (and (null (cdr slots))
		    (assoc (setf slot (car slots)) *schema-slots*))
	       ;; This is a GV with a single slot.  If this is one of the special
	       ;; slots, save a lot of time by using the macro for g-value
	       `(g-value (setup-dependency ,schema ,slot 0) ,slot)
	       ;; this is the more general case
	       `(expand-accessor gv-fn ,schema ,@slots))))
	((eq schema :self)
	 `(progn *schema-self*))
	(t
	 `(progn ,schema))))




(defun gv-local-fn (schema slot position)
  (if (eq schema :self)
      (setf schema *schema-self*))
  (unless schema
    ;; A link is broken.  Get out of here!
    (broken-link-throw slot position))
  ;; Record the link dependency for this parent and formula
  (unless (member schema (a-formula-depends-on *current-formula*))
    (push schema (a-formula-depends-on *current-formula*)))
  (let ((depended (assoc slot (get-local-values schema :DEPENDED-SLOTS))))
    (unless depended
      ;; This slot was not yet depended on by anybody.
      (push (setf depended (list slot))
	    (get-local-values schema :DEPENDED-SLOTS)))
    (pushnew *current-formula* (cdr depended)))
  (let ((entry (slot-accessor schema slot)))
    (unless entry
      ;; This value was not present at all.  Mark the slot as depended
      ;; on by someone.
      (setf (slot-accessor schema slot)
	    (cons *depended-mask* nil))
      (return-from gv-local-fn nil))
    ;; The value exists.  Mark it as being depended on by someone.
    (setf (car entry) (logior (car entry) *depended-mask*)))
  ;; Now call G-LOCAL-VALUE to get the value from the slot.
  (g-local-value schema slot position))



;;;; GV-LOCAL
;;; To be used in formulas.
;;; This macro expands into a chain of nested calls to gv-local-fn, which creates
;;; a dependency point in a formula.
;;;
(defmacro gv-local (schema &rest slots)
  (cond (slots
	 `(expand-accessor gv-local-fn ,schema ,@slots))
	((eq schema :self)
	 `(progn *schema-self*))
	(t
	 `(progn ,schema))))



;;;; GVL
;;; To be used in formulas.
;;; This is equivalent to a call to GV with a :SELF added as the first
;;; parameter.
;;; 
(defmacro gvl (name &rest names)
  `(gv :self ,name ,@names))


;;; --------------------------------------------------


(defun valid-link-p-fn (schema slot)
  (when schema
    (g-value (if (eq schema :self)
		 *schema-self*
		 schema)
	     slot 0)))


;;;; VALID-LINK-P
;;; This macro may be used within formulas to check whether a reference (i.e.,
;;; a GV) will return a value or will find some missing links.
;;; RETURNS:
;;; nil if reference is not complete, non-nil if a value can be found.
;;; 
(defmacro valid-link-p (name1 name2 &rest names)
  (let ((kernel `(valid-link-p-fn ,name1 ,name2)))
    (dolist (name names)
      (setf kernel `(valid-link-p-fn ,kernel ,name)))
    kernel))





;;; This is the default invalidate demon.
;;; 
(defun invalidate-demon (schema slot save)
  (kr-send schema :UPDATE-DEMON schema slot save))





;;;; DESTROY-CONSTRAINT
;;; Replaces the formula in the <slot> with its value, physically eliminating
;;; the constraint.  If there is no formula, <schema> is unchanged.
;;; 
(defun destroy-constraint (schema slot &optional (position 0))
  #-release-garnet
  "If the <position>-th value in the <slot> of the <schema> is a formula,
  replaces it with the current value of the formula and eliminates the
  formula.  This effectively eliminates the constraint on the value."
  (let ((values (or (slot-accessor schema slot)
		    (g-value-inherit-values schema slot)))
	formula)
    (cond ((null values)
	   ;; Nothing to destroy.
	   (return-from destroy-constraint nil))
	  ((>= position (length (cdr values)))
	   (return-from destroy-constraint nil))
	  (t
	   (setf formula (nth position (cdr values)))))
    (when (formula-p formula)
      (let ((value (g-cached-value schema slot)))
	;; All children formulas are eliminated as well.
	(dovalues (child formula :IS-A-INV :local T :formulas T)
	  (destroy-constraint (on-schema child) (on-slot child) 0))
	(de-install-formula formula)
	;; Replace formula with its cached value.
	(let ((values (slot-accessor schema slot)))
	  (setf (cadr values) value))
	NIL))))






;;; ---------------------------------------------- INITIALIZE THE WHOLE THING


(initialize-kr)


;;; Proclaim that the system was loaded successfully
;;;
(setf (get :garnet-modules :KR) t)

;;; Concatenated from type module "kr" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/kr/f1.4/kr-changes.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : kr-changes.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Sun Jul 21 17:12:26 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Jan 24 14:18:40 1992
;;;; Update Count    : 7
;;;; 
;;;; PURPOSE
;;;; 	|>Description of module's purpose<|
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "KR")
(export '(;; variables & schema
          ;; functions & macros
          destroy-p
	  gvs
          )
   (find-package "KR"))


;;;
;;;	IX.	destroy-p & gvs 
;;;

(in-package "KR")

(proclaim '(notinline destroy-p))

(defun destroy-p (schema)
  #-release-garnet
 "Current hack to see if item has been destroyed."
  (not (a-schema-name schema)))

(defmacro gvs (object slot)
  #-release-garnet
  "A little something to put into a formula to make an equivalent of get-values."
  ; (format t "~% Going into gvs macro with ~s ~s   ~%"
  ;     ,object ,slot)
 `(let ((results nil))
   (if (and ,object
            (get-values ,object ,slot))
       (dovalues (value ,object ,slot
                       :in-formula t)
         (push value results)))
   results))

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/opal-loader.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;; 
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Changes:
;;; 3/4/91  D'Souza Removed nickname "MO" of package Opal.
;;; 8/15/90 ECP Moved clean-up to after open-and-close
;;; 6/6/90  ECP Removed *twm-bug*
;;; 3/22/90 Robert Cook - Define the package "OPAL" for the TI Explorer
;;; 3/19/90 ECP Added *twm-bug*
;;; 3/9/90  ECP Added open-and-close
;;; 2/13/90 ECP Merged objects.lisp and eds-objects.lisp
;;; 1/4/90  ECP Added version number
;;;
(in-package "USER" :use '("LISP"))

(defparameter Opal-Version-Number "1.3")

;(format t "Loading Opal...~%")
;(setf *load-verbose* t)
;
;;;; check to see if place is set
;(unless (boundp 'Garnet-Opal-PathName)
;  (error "Load 'Garnet-Loader' first to set Garnet-Opal-PathName before loading opal."))
;
;;;; Load KR unless already loaded
;#+cmu
;(unless (get :garnet-modules :kr)
;  (load Garnet-Kr-Loader))
;
;#+(not cmu)
;(require 'kr Garnet-Kr-Loader)
;
;#+explorer
;(unless (find-package "OPAL")
;  (make-package "OPAL" :use '("LISP" "KR")))
;
;;;;  Load Opal  ...
;
;(Defparameter Garnet-Opal-Files
;  '(
;    "update-constants"
;    "defs"
;    "macros"
;    "new-defs"
;    "text-fonts"
;    "create-instances"
;    "create-instances2"
;
;    "rectintersect"
;    "update-basics"
;    "halftones"
;    "objects"
;    "roundtangles"
;    "basics"
;    "aggregates"
;    "windows"
;    "update"
;    "update-window"
;    "cursor-text"
;    "multi-text"
;    "open-and-close"
;    "clean-up"))
;
;(dolist (file Garnet-Opal-Files)
;  (load (merge-pathnames file Garnet-Opal-PathName)
;        :verbose T))
;
;(setf (get :garnet-modules :opal) t)
(provide 'opal)
;(format t "...Done Opal.~%")

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/update-constants.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Opal:Update-Constants
;;;
;;; This contains constants used to reference the Update-Slots-Values arrays.
;;; If you make any changes to an :update-slots slot, you must also make the
;;; corresponding changes in this file, lest havoc result...

;;; You do not have to supply constants for :visible, :line-style,
;;; :filling-style, or :draw-function.  

;;; Changes:
;;; 23-Mar-90 ecp  New slot :fill-background-p for text objects.

(in-package "OPAL" :use '("LISP" "KR"))

;;;; LINE
(defconstant *line-x1*		  2)
(defconstant *line-x2*		  3)
(defconstant *line-y1*		  4)
(defconstant *line-y2*		  5)
(defconstant *line-lstyle*        6)
(defconstant *line-fstyle*	  7)
(defconstant *line-draw-function* 8)

;;;; RECTANGLE
(defconstant *rect-top*           2)
(defconstant *rect-left*          3)
(defconstant *rect-width*         4)
(defconstant *rect-height*        5)
(defconstant *rect-lstyle*	  6)
(defconstant *rect-fstyle*	  7)
(defconstant *rect-draw-function* 8)

;;;; ROUNDTANGLE
(defconstant *roundt-top*           2)
(defconstant *roundt-left*          3)
(defconstant *roundt-width*         4)
(defconstant *roundt-height*        5)
(defconstant *roundt-radius*        6)
(defconstant *roundt-draw-radius*   7)
(defconstant *roundt-lstyle*	    8)
(defconstant *roundt-fstyle*	    9)
(defconstant *roundt-draw-function* 10)

;;;; MULTIPOINT
(defconstant *multi-point-list*      2)
(defconstant *multi-lstyle*	     3)
(defconstant *multi-fstyle*	     4)
(defconstant *multi-draw-function*   5)

;;;; POLYLINE
(defconstant *polyline-point-list*    2)
(defconstant *polyline-lstyle*	      3)
(defconstant *polyline-fstyle*	      4)
(defconstant *polyline-draw-function* 5)

;;;;; TEXT
(defconstant *text-top*		   2)
(defconstant *text-left*	   3)
(defconstant *text-height*	   4)
(defconstant *text-width*	   5)
(defconstant *text-string*	   6)
(defconstant *text-font*	   7)
(defconstant *text-xfont*	   8)
(defconstant *text-actual-heightp* 9)
(defconstant *text-fill-background-p* 10)
(defconstant *text-lstyle*	  11)
(defconstant *text-fstyle*	  12)
(defconstant *text-draw-function* 13)
(defconstant *text-text-extents*  14)

;;;; CURSOR-TEXT
(defconstant *cursor-text-cursor-index* 15)
(defconstant *cursor-text-x-substr*	16)

;;;; MULTITEXT
(defconstant *multi-text-justification* 14)
(defconstant *multi-text-cut-strings*	15)

;;;;; CURSOR-MULTI-TEXT
(defconstant *cursor-multi-text-cursor-index*	16)
(defconstant *cursor-multi-text-x-substr*	17)

;;;;; BITMAPS
(defconstant *bm-image*		2)
(defconstant *bm-top*		3)
(defconstant *bm-left*		4)
(defconstant *bm-lstyle*	5) 
(defconstant *bm-fstyle*	6) 
(defconstant *bm-draw-function* 7)

;;;;; ARC
(defconstant *arc-left*		 2)
(defconstant *arc-top*		 3)
(defconstant *arc-width*	 4)
(defconstant *arc-height*	 5)
(defconstant *arc-angle1*	 6)
(defconstant *arc-angle2*	 7)
(defconstant *arc-lstyle*	 8)
(defconstant *arc-fstyle*	 9)
(defconstant *arc-draw-function* 10)

;;;;; CIRCLE
(defconstant *circle-left*		2)
(defconstant *circle-top*		3)
(defconstant *circle-width*		4)
(defconstant *circle-height*		5)
(defconstant *circle-angle1*		6)
(defconstant *circle-angle2*		7)
(defconstant *circle-lstyle*		8)
(defconstant *circle-fstyle*		9)
(defconstant *circle-draw-function*	10)


;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/defs.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Opal:Defs.Lisp
;;;
;;; This file contains all the defvars, defconstants, defstructs, etc.,
;;;  which are used by Opal.  This does not contain any defmacros, however.
;;;  This file also contains the export list for Opal.
;;;
;;; Change Log:
;;;     date     who    what
;;;     ----     ---    ----
;;;   26-Mar-91  ecp    kcl patch
;;;    7-Mar-91  ecp    The question of whether the screen is color or
;;;                     black-and-white is now determined inside
;;;			initialize-default-x-values.
;;;   22-Feb-91  amickish  New exported motif colors and filling styles.
;;;   21-Feb-91  ecp    New exported variables *screen-width* and
;;;			*screen-height*, which are the width and height
;;;			of the screen.  Also iconify-window.
;;;   25-Oct-90  ecp    New exported commands opal:raise-window and
;;;		        opal:lower-window which move window to front or
;;;			back of screen.
;;;   11-Sep-90  ecp    Get display name in allegro by (sys::getenv "DISPLAY").
;;;                     Use (short-site-name) as an #+allegro alternative to
;;;                     (machine-instance).
;;;   15-Aug-90  ecp    Exporting destroy-me.
;;;                     Moved lots of initialization stuff
;;;			into new function initialize-default-x-values.
;;;    8-Aug-90  ecp    Use #+(and allegro clx-mit-r4) "" in
;;;			*default-x-display-name*
;;;   26-Jun-90  ecp    Due to temporary bug in clx, had to
;;;			coerce *twopi* to an short-float.
;;;   21-Jun-90  nesmith
;;;			Use #+allegro (short-site-name) in
;;;			*default-x-display-name*
;;;   19-Jun-90  ecp    New functions gv-center-x-is-center-of,
;;;			gv-center-y-is-center-of,
;;;			gv-right-is-left-of, gv-bottom-is-top-of.
;;;   18-Jun-90  ecp    Added *clear* for erasing buffers.
;;;    5-Jun-90  chris  Added lispworks.
;;;   14-Mar-90  ecp    Move-cursor-* functions added.
;;;    9-Mar-90  ecp    Changed *function-alist* again to try
;;;			to deal with "xor problem".
;;;			Moved lots of defvars here from new-defs.
;;;			New variables *white* and *black*.
;;;   13-Feb-90  ecp    Implemented color.
;;;   26-Jan-90  bam    Added :key-press and :button-press to
;;;                     *exposure-event-mask*
;;;   13-Dec-89  ecp    Changed #+lucid to #-cmu in declaration of
;;;                     *function-alist*
;;;   14-Jun-89  koz    Created.  Simply extracted all the def* from all the
;;;			Opal files.  No modifications were made to them.
(in-package "OPAL" :use '("LISP" "KR"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;; Export List  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; This is the export list for *all* of OPAL
(export '(bottom right center-x center-y
          gv-bottom gv-right gv-center-x gv-center-y
          gv-center-x-is-center-of
          gv-center-y-is-center-of
          gv-right-is-left-of gv-bottom-is-top-of
          top-side left-side bottom-side right-side
          #-release-garnet center #-release-garnet set-center
          bounding-box set-bounding-box
          set-position #-release-garnet set-size
          draw erase #-release-garnet rotate
          initialize calculate-bounding-box point-in-gob
          halftone #-release-garnet halftone-darker
          #-release-garnet halftone-lighter
          halftone-image #-release-garnet halftone-image-darker
          #-release-garnet halftone-image-lighter
          read-image write-image
          add-component remove-component move-component
          add-components remove-components remove-all-components
          do-components do-all-components
          point-to-component point-to-leaf
	  set-aggregate-hit-threshold
          update destroy destroy-me
          #-release-garnet type-check
	  raise-window lower-window iconify-window

          ;; Class names
          window aggregate view-object graphical-object line rectangle
          #-release-garnet roundtangle
          multipoint polyline polygon text bitmap arc
          #-release-garnet oval
          circle arrowhead multi-text cursor-multi-text

          line-style default-line-style filling-style default-filling-style
          font cursor-text graphic-quality font-from-file window-aggregate
          arrow-cursor arrow-cursor-mask default-font
          display-info-display display-info-screen
          display-info-root-window display-info-line-style-gc
	  display-info-filling-style-gc
          with-line-styles with-filling-styles
          convert-coordinates get-cursor-index string-width string-height
	  move-cursor-down-one-line
	  move-cursor-up-one-line
	  move-cursor-to-beginning-of-line
	  move-cursor-to-end-of-line

	  Get-X-Cut-Buffer Set-X-Cut-Buffer	;; for interactors' use

          ;; filling and line style constants
          no-fill black-fill white-fill
          gray-fill light-gray-fill dark-gray-fill
	  ;red-fill green-fill blue-fill yellow-fill
	  ;cyan-fill orange-fill purple-fill
	  ;motif-gray-fill motif-blue-fill motif-orange-fill motif-green-fill

	  make-filling-style

          no-line thin-line line-0 line-1 line-2
          ;line-4
          ;line-8
          ;; dotted-line dashed-line
          ;; gone! 28-Jul-91 -FER
	  ;red-line green-line blue-line yellow-line
	  ;cyan-line orange-line purple-line

	  ;; size of screen
	  *screen-width* *screen-height*

	  ;; Colors
	  color white black ;red green blue cyan yellow orange purple
	  ;motif-gray motif-blue motif-orange motif-green
          ;; From Clean-Up.Lisp
          clean-up #-release-garnet change-garnet-display
          update-all reset-cursor
))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;; DefConstants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defconstant *twopi* (coerce (* 2 pi) 'short-float))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;; DefParameters ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; These two 2x2x2 arrays are used as a correction to a flaw in xlib:draw-arc
(defparameter *left-adjustment*
  (make-array '(2 2 2) :initial-contents '(((0 1) (0 1)) ((0 1) (0 1)))))
(defparameter *top-adjustment*
  (make-array '(2 2 2) :initial-contents '(((0 1) (0 0)) ((0 0) (0 1)))))
(defparameter *width-adjustment*
  (make-array '(2 2 2) :initial-contents '(((0 1) (0 1)) ((0 1) (0 1)))))
(defparameter *height-adjustment*
  (make-array '(2 2 2) :initial-contents '(((0 1) (1 1)) ((1 1) (0 1)))))

;;;  This code also occurs in reconnect-garnet in open-and-close.lisp.
;;;  If this code is ever changed, make sure you also change
;;;  open-and-close.lisp.
(defvar *default-x-display-name*
        	(let* ((display
                       #+cmu (cdr (assoc :DISPLAY lisp::*environment-list*))
                       #+(or allegro lispworks kcl) (sys::getenv "DISPLAY")
                       #+(and lucid lcl3.0)
                             (lucid-common-lisp:environment-variable "DISPLAY")
                       #+(and lucid (not lcl3.0))
                             (system:environment-variable "DISPLAY"))
                      (colon-posn (position #\: display)))
                  (when colon-posn (setq display (subseq display 0 colon-posn)))
		  (or display #-allegro (machine-instance)
		              #+allegro (short-site-name))))


(defvar *default-x-display*)
(defvar *default-x-screen*)
(defvar *default-x-root*)
(defvar *default-x-colormap*)
(defvar *screen-width*)
(defvar *screen-height*)
(defvar *white*)
(defvar *black*)
(defvar *function-alist*)
(defvar *clear*)
(defvar *first-allocatable-colormap-index* 1)
(defvar *colormap-index-table-size* 256)  ;; Have to figure out what this really is.
(defvar *colormap-index-table* (make-array *colormap-index-table-size* :initial-element 0))
(defvar *is-this-a-color-screen?* nil)
(defvar *is-this-a-color-screen-and-is-black-zero?* nil)


;;; This is also called in reconnect-garnet.
(defun initialize-default-x-values ()
  (setq *default-x-display* (xlib:open-display *default-x-display-name*))
  (setq *default-x-screen* (nth user::Garnet-Screen-Number
                                (xlib:display-roots *default-x-display*)))
  (setq *screen-width* (xlib:screen-width *default-x-screen*))
  (setq *screen-height* (xlib:screen-height *default-x-screen*))
  (setq *default-x-root* (xlib:screen-root *default-x-screen*))
  (setq *default-x-colormap* (xlib:screen-default-colormap *default-x-screen*))
  (setq *white* (xlib:screen-white-pixel *default-x-screen*))
  (setq *black* (xlib:screen-black-pixel *default-x-screen*))
;;; This is really dumb, but it's the only way I can think of
;;; to find out if the screen is color or not.
  (let ((colormap-string (princ-to-string opal::*default-x-colormap*)))
    (if (or (search "PSEUDO-COLOR" colormap-string)
            (search "DIRECT-COLOR" colormap-string))
        (setq *is-this-a-color-screen?* t)
        (setq *is-this-a-color-screen?* nil)))
  (setq *is-this-a-color-screen-and-is-black-zero?*
	(and *is-this-a-color-screen?* (zerop *black*)))
;;; Alist since CLX likes to get the draw function in the form of an
;;; integer.  We want to specify nice keywords instead of those silly
;;; numbers.
  (setq *function-alist*
	(if (or *is-this-a-color-screen?* (zerop *white*))
	    `((:clear . ,boole-clr)
	      (:set . ,boole-set)
	      (:copy . ,boole-1)
	      (:no-op . ,boole-2)
	      (:copy-inverted . ,boole-c1)
	      (:invert . ,boole-c2)
	      (:and . ,boole-and)
	      (:or . ,boole-ior)
	      (:xor . ,boole-xor)
	      (:equiv . ,boole-eqv)
	      (:nand . ,boole-nand)
	      (:nor . ,boole-nor)
	      (:and-inverted . ,boole-andc1)
	      (:and-reverse . ,boole-andc2)
	      (:or-inverted . ,boole-orc1)
	      (:or-reverse . ,boole-orc2))
	    `((:clear . ,boole-set)
	      (:set . ,boole-clr)
	      (:copy . ,boole-1)
	      (:no-op . ,boole-2)
	      (:copy-inverted . ,boole-c1)
	      (:invert . ,boole-c2)
	      (:and . ,boole-ior)
	      (:or . ,boole-and)
	      (:xor . ,boole-eqv)
	      (:equiv . ,boole-xor)
	      (:nand . ,boole-nor)
	      (:nor . ,boole-nand)
	      (:and-inverted . ,boole-orc1)
	      (:and-reverse . ,boole-orc2)
	      (:or-inverted . ,boole-andc1)
	      (:or-reverse . ,boole-andc2))))
;;; For erasing buffers
  (setq *clear* (cdr (assoc :clear opal::*function-alist*)))
)

;;; Now, actually do the initialization
(initialize-default-x-values)

;;; Added :button-press and :key-press so garnet-debug:ident will work.
(defparameter *exposure-event-mask*
  (xlib:make-event-mask :exposure :structure-notify
                        :button-press :key-press))

(defparameter *cursor-width* 3)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;  DefVars  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar *halftone-table-size* 17)
(defvar *halftone-table* nil) ;;; used to be set to (build-halftone-table))
                              ;;; but now that's a forward reference.  So,
                              ;;; now we setq this after defining that fn.

(defvar *default-text-extents* (make-list 9 :initial-element 0))

(defvar no-fill nil)
(defvar no-line nil)

(defvar *drawable-to-window-mapping*
  (make-hash-table :test #'eq)
  #-release-garnet
  "Mapping from CLX windows to Opal windows to dertimine the window on
  which an event occurs.")

;; debugging tools
(defvar *event-debug* nil)
(defvar *expose-debug* nil)
(defvar *expose-throw-aways* 0)

(defvar *display-name-to-display-mapping* nil
  #-release-garnet
  "This is an alist to map display name strings to display-info structures
  for a window")

(defvar *opal-window-count* 0)

;(defvar diamond-fill NIL)		;; set in halftones.lisp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;  DefStructs  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; rectangle definition
(defstruct (OPAL-RECT
            (:constructor create-opal-rect (left top rightp1 bottomp1)))
  left
  top
  rightp1   ;; first pixel outside of the rectangle
  bottomp1) ;; first pixel outside of the rectangle

(defstruct (HALFTONE (:print-function halftone-print))
  (percent 0)
  (x-image nil))

(defstruct (DISPLAY-INFO (:print-function display-info-printer))
  display
  screen
  root-window
  line-style-gc
  filling-style-gc)

(defstruct CUT-STRING
  string
  width
  left-bearing)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;; DefSetfs ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Accessors that do calculation from basic gob properties

;;; The accessors for the bottom and right of the gob, make it easier to
;;; adjust the far side of the gob's bounding box.

(defsetf bottom (gob) (value)
  `(setf (g-value ,gob :top) (1+ (- ,value (g-value ,gob :height)))))

(defsetf right (gob) (value)
  `(setf (g-value ,gob :left) (1+ (- ,value (g-value ,gob :width)))))

;;; The accessors for the sides of the gob adjust both the dimensions, and
;;; position of the gob based on the given value.

(defsetf left-side (gob) (value)
  `(progn
     (setf (g-value ,gob :width)
           (- (g-value ,gob :width) (- ,value (g-value ,gob :left))))
     (setf (g-value ,gob :left) ,value)))

(defsetf right-side (gob) (value)
  `(setf (g-value ,gob :width)
         (+ (g-value ,gob :width) (- ,value (right ,gob)))))

(defsetf top-side (gob) (value)
  `(progn
     (setf (g-value ,gob :height)
           (- (g-value ,gob :height) (- ,value (g-value ,gob :top))))
     (setf (g-value ,gob :top) ,value)))

(defsetf bottom-side (gob) (value)
  `(setf (g-value ,gob :height)
         (+ (g-value ,gob :height) (- ,value (bottom ,gob)))))

;;; The following allow access and setting to the gobs center
;;; position.

(defsetf center-x (gob) (value)
  `(setf (g-value ,gob :left)
         (- ,value (truncate (g-value ,gob :width) 2))))

(defsetf center-y (gob) (value)
  `(setf (g-value ,gob :top)
         (- ,value (truncate (g-value ,gob :height) 2))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/macros.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Opal:Macros.Lisp
;;;
;;; This file contains all the defmacros which are used by Opal.
;;;
;;; Change Log:
;;;     date     who    what
;;;     ----     ---    ----
;;;    1-Mar-91  ecp    If a white xor-ed object is drawn on a color
;;;			screen for which *black* is 0, then it must
;;;			be drawn black instead.
;;;   13-Mar-91  ecp    Same as 3-Aug-90 change, but also don't do a total
;;;                     update if only :cursor is changed.
;;;    7-Mar-90  ecp    If a black xor-ed object is drawn on a color
;;;			screen for which *black* is 0, then it must
;;;			be drawn white instead.
;;;    3-Aug-90  ecp    In fix-properties-and-validate, do not return t if
;;;			only :top or :left has been changed (since then we
;;;			do not want a total update).
;;;   11-Jul-90  ecp    new :destroy-me method
;;;    9-Apr-90  cook   Indented format statement in get-stipple-pixmap-schema
;;;   19-Mar-90  ecp    Changed tile to stipple
;;;   12-Mar-90  ecp    Fixed bug so gray lines are possible.
;;;   13-Feb-90  ecp	Implemented color.
;;;   13-Feb-90  dzg    Certain macros, such as gv-bottom, have been
;;;			converted to defuns for efficiency.  They are
;;;			now declared in basics.lisp.
;;;   25-Jan-90  ecp    Image-p is not in the R4 release of CLX.
;;;   14-Jun-89  koz    Created.  Simply extracted all defmacros from all the
;;;			Opal files.  No modifications were made to them.

(in-package "OPAL" :use '("LISP" "KR"))

;;;;;;;;;;;;;;;;;;;;;;;;;; General Use ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmacro add-component (schema &rest args)
  `(kr-send ,schema :add-component ,schema ,@args))

(defmacro remove-component (schema &rest args)
  `(kr-send ,schema :remove-component ,schema ,@args))

(defmacro do-all-components (schema &rest args)
  `(kr-send ,schema :do-all-components ,schema ,@args))

(defmacro do-components (schema &rest args)
  `(kr-send ,schema :do-components ,schema ,@args))

(defmacro point-to-component (schema &rest args)
  `(kr-send ,schema :point-to-component ,schema ,@args))

(defmacro point-to-leaf (schema &rest args)
  `(kr-send ,schema :point-to-leaf ,schema ,@args))

(defmacro fix-properties (schema &rest args)
  `(kr-send ,schema :fix-properties ,schema ,@args))

(defmacro initialize (schema &rest args)
  `(kr-send ,schema :initialize ,schema ,@args))

(defmacro destroy-me (schema &rest args)
  `(kr-send ,schema :destroy-me ,schema ,@args))

(defmacro destroy (schema &rest args)
  `(kr-send ,schema :destroy ,schema ,@args))

#-release-garnet
(defmacro rotate (schema &rest args)
  `(kr-send ,schema :rotate ,schema ,@args))

(defmacro update (schema &rest args)
  `(kr-send ,schema :update ,schema ,@args))

(defmacro draw (schema &rest args)
  `(kr-send ,schema :draw ,schema ,@args))

(defmacro point-in-gob (schema &rest args)
  `(kr-send ,schema :point-in-gob ,schema ,@args))


;;;;;;;;;;;;;;;;;;;; For "RectIntersect.Lisp" ;;;;;;;;;;;;;;;;;;;;;;;

(defmacro RightP1obj (obj)
  `(+ (g-cached-value ,obj :left)(g-cached-value ,obj :width)))
(defmacro BottomP1obj (obj)
  `(+ (g-cached-value ,obj :top)(g-cached-value ,obj :height)))

(defmacro opal-rect-width (rect-struct)
  `(- (opal-rect-rightp1 ,rect-struct)(opal-rect-left ,rect-struct) 1))
(defmacro opal-rect-height (rect-struct)
  `(- (opal-rect-bottomp1 ,rect-struct)(opal-rect-top ,rect-struct) 1))


;;;;;;;;;;;;;;;;;;;;;;;;;; For "Objects.Lisp" ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; With-styles works like xlib:with-gcontext except it takes a gob and
;;; extracts all the relevant things for you. This is a win for the simple
;;; draw methods, it will be a lose for performance. See below.
;;;
;;; This is a quick hack to get around the caching of various gcontext
;;; values, it will work until we understand how CLX and the RT X11 server
;;; cache gcontexts better.

(defmacro set-gc (opal-gcontext xlib-gcontext slot value)
  (case slot
    (:foreground
     `(let ((v ,value))
        (unless (eq v (opal-gc-foreground ,opal-gcontext))
          (setf (opal-gc-foreground ,opal-gcontext)
          	(setf (xlib:gcontext-foreground ,xlib-gcontext) v)))))
    (:background
     `(let ((v ,value))
        (unless (eq v (opal-gc-background ,opal-gcontext))
          (setf (opal-gc-background ,opal-gcontext)
          	(setf (xlib:gcontext-background ,xlib-gcontext) v)))))
    (:function
     `(let ((v ,value))
        (unless (eq v (opal-gc-function ,opal-gcontext))
          (setf (opal-gc-function ,opal-gcontext)
          	(setf (xlib:gcontext-function ,xlib-gcontext) v)))))
    (:line-width
     `(let ((v ,value))
        (unless (eq v (opal-gc-line-width ,opal-gcontext))
          (setf (opal-gc-line-width ,opal-gcontext)
          	(setf (xlib:gcontext-line-width ,xlib-gcontext) v)))))
    (:line-style
     `(let ((v ,value))
        (unless (eq v (opal-gc-line-style ,opal-gcontext))
          (setf (opal-gc-line-style ,opal-gcontext)
          	(setf (xlib:gcontext-line-style ,xlib-gcontext) v)))))
    (:cap-style
     `(let ((v ,value))
        (unless (eq v (opal-gc-cap-style ,opal-gcontext))
          (setf (opal-gc-cap-style ,opal-gcontext)
          	(setf (xlib:gcontext-cap-style ,xlib-gcontext) v)))))
    (:join-style
     `(let ((v ,value))
        (unless (eq v (opal-gc-join-style ,opal-gcontext))
          (setf (opal-gc-join-style ,opal-gcontext)
          	(setf (xlib:gcontext-join-style ,xlib-gcontext) v)))))
    (:dashes
     `(let ((v ,value))
        (unless (eq v (opal-gc-dashes ,opal-gcontext))
          (setf (opal-gc-dashes ,opal-gcontext)
	     (if v					;; do not set to NIL
          	(setf (xlib:gcontext-dashes ,xlib-gcontext) v))))))
    (:font
     `(let ((v ,value))
        (unless (eq v (opal-gc-font ,opal-gcontext))
          (setf (opal-gc-font ,opal-gcontext)
	     (if v					;; do not set to NIL
          	(setf (xlib:gcontext-font ,xlib-gcontext) v))))))
    (:fill-style
     `(let ((v ,value))
        (unless (eq v (opal-gc-fill-style ,opal-gcontext))
          (setf (opal-gc-fill-style ,opal-gcontext)
          	(setf (xlib:gcontext-fill-style ,xlib-gcontext) v)))))
    (:fill-rule
     `(let ((v ,value))
        (unless (eq v (opal-gc-fill-rule ,opal-gcontext))
          (setf (opal-gc-fill-rule ,opal-gcontext)
          	(setf (xlib:gcontext-fill-rule ,xlib-gcontext) v)))))
    (:stipple
     `(let ((v ,value))
        (unless (eq v (opal-gc-stipple ,opal-gcontext))
          (setf (opal-gc-stipple ,opal-gcontext)
	     (if v					;; do not set to NIL
          	(setf (xlib:gcontext-stipple ,xlib-gcontext) v))))))
  ;; We must always set the clip-mask, since we'd otherwise have to store a
  ;; COPY of it, which would require cons'ing.  Why?  Because if we just set
  ;; *g-clip-mask* to be ,value then it will be EQ to it next time, because
  ;; ,value is changed IN PLACE!!

    (:clip-mask
     `(let ((v ,value))
        (unless (and (eq v :none) (eq v (opal-gc-clip-mask ,opal-gcontext)))
          (setf (opal-gc-clip-mask ,opal-gcontext)
          	(setf (xlib:gcontext-clip-mask ,xlib-gcontext) v)))))
  ))

;; This is called by with-*-styles, and it replaces the old :x-tiles slot.
;; It gets the *-style's :stipple, and checks its :root-pixmap-plist slot for an
;; entry for this Root.  If so, it returns it.  Else, it creates the
;; entry and places it at the head of the plist.
;; These were split into two macros because the draw method for opal:bitmap
;; also needs to use the first macro now...
(defmacro get-stipple-schema-pixmap (stipple-schema root-window bitmap-p)
   `(let ((root-plist   (g-value ,stipple-schema :root-pixmap-plist)))
     (or (getf root-plist ,root-window)
	 (let ((image (g-value ,stipple-schema :image))
	       roots-entry)
	  (if image
	     (if (typep image 'xlib::image)
		(progn
		  (setq roots-entry (build-pixmap ,root-window image
						  (xlib:image-width image)
						  (xlib:image-height image)
						  ,bitmap-p))
	  	  (s-value ,stipple-schema :root-pixmap-plist
			   (cons ,root-window (cons roots-entry root-plist)))
	   	  roots-entry)
                (format t "WARNING -- :image entry in schema ~A is not of type xlib:image!~%"
					,stipple-schema))
	(format t "WARNING -- no :image slot in schema ~A~%" ,stipple-schema))))))

(defmacro get-x-stipple (style-schema root-window)
 `(let ((stipple-schema  (g-value ,style-schema :stipple)))
   (if stipple-schema
	(get-stipple-schema-pixmap stipple-schema ,root-window nil))))

;;; The deal here is, if you're working in a color screen, and black-pixel = 0,
;;; and the draw-function is :xor, then draw black objects white, and
;;; white objects black.

(defun hack-for-black-xor-on-color-screen (x-draw-function index)
  (if (and *is-this-a-color-screen-and-is-black-zero?*
           (eq x-draw-function boole-xor))
      (cond ((zerop index) *white*)  ;; black --> white
	    ((eq index *white*) 0)   ;; white --> black
	    (t index))
      index))

(defmacro with-line-styles ((the-line-style opal-gc xlib-gc root-window
			     x-draw-function clip-mask) &body body)
    `(let ((line-style ,the-line-style))
       (when line-style
         (let ((x-stipple (get-x-stipple line-style ,root-window))
	        x-dash-pattern)
	   (unless (eq line-style (opal-gc-opal-style ,opal-gc))
		(setf (opal-gc-opal-style ,opal-gc) line-style)
		(set-gc ,opal-gc ,xlib-gc :foreground
                     (hack-for-black-xor-on-color-screen
			,x-draw-function
			(g-value line-style :foreground-color :colormap-index))
		)
		(set-gc ,opal-gc ,xlib-gc :background
                     (hack-for-black-xor-on-color-screen
			,x-draw-function
			(g-value line-style :background-color :colormap-index))
		)
                (set-gc ,opal-gc ,xlib-gc :line-width
			(g-value line-style :line-thickness))
                (set-gc ,opal-gc ,xlib-gc :line-style
			(g-value line-style :line-style))
                (set-gc ,opal-gc ,xlib-gc :cap-style
			(g-value line-style :cap-style))
                (set-gc ,opal-gc ,xlib-gc :join-style
			(g-value line-style :join-style))
                (if (setq x-dash-pattern (g-value line-style :dash-pattern))
		     (set-gc ,opal-gc ,xlib-gc :dashes x-dash-pattern)))

				;; This can't be in the "unless" since the same
				;; line-style can have different x-stipples
	   (if x-stipple
		     (progn
			(set-gc ,opal-gc ,xlib-gc :fill-style :opaque-stippled)
			(set-gc ,opal-gc ,xlib-gc :stipple x-stipple))
		     (set-gc ,opal-gc ,xlib-gc :fill-style :solid))

           (set-gc ,opal-gc ,xlib-gc :function ,x-draw-function)
           (set-gc ,opal-gc ,xlib-gc :clip-mask ,clip-mask))
         (xlib::with-gcontext (,xlib-gc)
           ,@body))))

(defmacro with-filling-styles ((the-filling-style opal-gc xlib-gc root-window
				x-draw-function clip-mask) &body body)
    `(let ((filling-style ,the-filling-style))
       (when filling-style
         (let ((x-stipple (get-x-stipple filling-style ,root-window)))
	   (unless (eq filling-style (opal-gc-opal-style ,opal-gc))
		(setf (opal-gc-opal-style ,opal-gc) filling-style)
		(set-gc ,opal-gc ,xlib-gc :foreground
                     (hack-for-black-xor-on-color-screen
			,x-draw-function
			(g-value filling-style :foreground-color
					       :colormap-index))
		)
		(set-gc ,opal-gc ,xlib-gc :background
                     (hack-for-black-xor-on-color-screen
			,x-draw-function
			(g-value filling-style :background-color
					       :colormap-index))
		)
                (set-gc ,opal-gc ,xlib-gc :fill-style
			(g-value filling-style :fill-style))
                (set-gc ,opal-gc ,xlib-gc :fill-rule
			(g-value filling-style :fill-rule)))
           (if x-stipple (set-gc ,opal-gc ,xlib-gc :stipple x-stipple))
           (set-gc ,opal-gc ,xlib-gc :function ,x-draw-function)
           (set-gc ,opal-gc ,xlib-gc :clip-mask ,clip-mask))
         ,@body)))

(defmacro get-thickness (gob)
  `(let* ((line-style (g-value ,gob :line-style))
	  (thickness  (and line-style (g-value line-style :line-thickness))))
     (if thickness (max thickness 1)
		   0)))

(defmacro point-in-rectangle (x y left top right bottom)
  `(and (<= ,left ,x ,right)
       (<= ,top ,y ,bottom)))

;;;  TEXT MACROS


(defmacro the-width (text-extents)
  `(first ,text-extents))

(defmacro the-actual-ascent (text-extents)
  `(second ,text-extents))

(defmacro the-actual-descent (text-extents)
  `(third ,text-extents))

(defmacro the-left-bearing (text-extents)
  `(fourth ,text-extents))

(defmacro the-right-bearing (text-extents)
  `(fifth ,text-extents))

(defmacro the-font-ascent (text-extents)
  `(sixth ,text-extents))

(defmacro the-font-descent (text-extents)
  `(seventh ,text-extents))

;;;   IMAGE MACROS

(defmacro read-image (pathname)
  `(xlib:read-bitmap-file ,pathname))

(defmacro write-image (pathname image)
  `(xlib:write-bitmap-file ,pathname ,image))

;;;;;;;;;;;;;;;;;;;;;;;;;; For "Basics.Lisp" ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; The accessors for the sides of the gob adjust both the dimensions, and
;;; position of the gob based on the given value.

(defmacro left-side (gob)
  `(g-value ,gob :left))

(defmacro right-side (gob)
  `(right ,gob))

(defmacro top-side (gob)
  `(g-value ,gob :top))

(defmacro bottom-side (gob)
  `(bottom ,gob))

;;; New code
;;;
;;; This is the code for handling the cacheing of old values in the update
;;; demons, the default update-demon, and the fix-properties macros.
;;;

(defmacro old (value-list)
  `(cdr ,value-list))

(defmacro old-value (value-list)
  `(cadr ,value-list))


(defmacro old-valid (value-list)
  `(cddr ,value-list))

;(defmacro g-old-value (gob slot)
;  `(old-value (get-values ,gob ,slot)))

;(defmacro changed-slots (gob)
;  `(g-value ,gob :changed-slots))

;; Now this returns T iff a total-p update is necessary.
;; This now can only be called with a window... yuck.
(defmacro fix-properties-and-validate (gob)
  `(let* ((win-info  (get-local-value ,gob :win-update-info))
	  (invalid-slots (win-update-info-invalid-slots win-info)))
     (when invalid-slots
       (fix-properties ,gob invalid-slots)
       (dolist (slot invalid-slots)
         (let ((values (get-values ,gob slot)))
           (when (old values)
             (setf (old-valid values) nil))))
	(setf (win-update-info-invalid-slots win-info) NIL)
	(not (subsetp invalid-slots '(:left :top :cursor))))))

;;;;;;;;;;;;;;;;;;;;;;; For "Text-Fonts.Lisp" ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Font-From-File

(defmacro extract-dir (font-name)
  `(subseq ,font-name 0 (1+ (position #\/ ,font-name :from-end t))))

(defmacro extract-font-name (font-name)
  `(subseq  ,font-name
            (1+ (position #\/ ,font-name :from-end t))
            (position #\. ,font-name :from-end t)))

;;;;;;;;;;;;;;;;;;;;;;; For "Windows.Lisp" ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmacro get-parent-win (a-window display-info)
  `(let ((win-parent (g-value ,a-window :parent)))
     (if win-parent
	 (g-value win-parent :drawable)
         (display-info-root-window ,display-info))))

;;;;;;;;;;;;;;;;;;;;;;; For "Clean-Up.Lisp" ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defmacro opal-window (window-pair)
  `(cdr ,window-pair))

(defmacro clx-window (window-pair)
  `(car ,window-pair))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/new-defs.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Changes:
;;; 26-Mar-91 sylvain  #+kcl patches
;;;  1-Oct-90 ecp  Made the print function for opal-gc not print font.
;;; 18-Jun-90 ecp  Added *clear* for erasing buffers.
;;;  5-Jun-90 dzg  Changed update-info structure to reduce storage allocation.
;;;  4-Jun-90 ecp  Altered erase-bbox to handle double buffering.
;;; 16-Apr-90 ecp  Moved defun of font-to-xfont from new-defs.lisp to
;;;		   create-instances2.lisp
;;; 19-Mar-90  Changed tile to stipple
;;;  9-Mar-90  Moved a bunch of defvars to defs.lisp.
;;;  5-Dec-89  Moved definition of new-garnet-window-name here from windows.lisp,
;;;            Added "#-cmu nil" to fix-font-path.
;;;             
(in-package "OPAL" :use '("LISP" "KR"))

(defstruct bbox
	x1
	y1
	x2
	y2
	valid-p)


;; Force-Computation-P is necessary since if an object R is in an aggregate A,
;; and you add-component that aggregate into another (visible) aggregate, then
;; R will be marked dirty, but it will not be added to the invalid-objects list
;; of the window, so at update time all its values in :update-slots-values will
;; be incorrect and will need to be recomputed.  Obtuse, but this works!

(defstruct (update-info (:print-function update-info-print-function))
	window
	old-bbox
	bits)

;;; The update-info-bits field is used to encode the following:
;;;   dirty-p
;;;   aggregate-p
;;;   invalid-p
;;;   force-computation-p
;;;   on-fastdraw-list-p

(defmacro bit-setter (object position value)
  (cond ((eq value T)
	 ;; Value is T at compile time.
	 `(setf (update-info-bits ,object)
		(logior (update-info-bits ,object) ,(ash 1 position))))
	((null value)
	 ;; Value is NIL at compile time.	 
	 `(setf (update-info-bits ,object)
		(logand (update-info-bits ,object)
			,(lognot (ash 1 position)))))
	(t
	 ;; Value is not known at compile time
	 `(if ,value
	      (setf (update-info-bits ,object)
		    (logior (update-info-bits ,object) ,(ash 1 position)))
	      (setf (update-info-bits ,object)
		    (logand (update-info-bits ,object)
			    ,(lognot (ash 1 position))))))))

(defmacro update-info-dirty-p (object)
  `(logbitp 0 (update-info-bits ,object)))

(defsetf update-info-dirty-p (object) (value)
  `(bit-setter ,object 0 ,value))


(defmacro update-info-aggregate-p (object)
  `(logbitp 1 (update-info-bits ,object)))

(defsetf update-info-aggregate-p (object) (value)
  `(bit-setter ,object 1 ,value))


(defmacro update-info-invalid-p (object)
  `(logbitp 2 (update-info-bits ,object)))

(defsetf update-info-invalid-p (object) (value)
  `(bit-setter ,object 2 ,value))


(defmacro update-info-force-computation-p (object)
  `(logbitp 3 (update-info-bits ,object)))

(defsetf update-info-force-computation-p (object) (value)
  `(bit-setter ,object 3 ,value))


(defmacro update-info-on-fastdraw-list-p (object)
  `(logbitp 4 (update-info-bits ,object)))

(defsetf update-info-on-fastdraw-list-p (object) (value)
  `(bit-setter ,object 4 ,value))
	 

(defun update-info-print-function (struct stream depth)
  (declare (ignore depth))
  (format stream "#<Update-Info dirty-p ~A invalid-p ~A>"
	(update-info-dirty-p struct)
	(update-info-invalid-p struct)))

(defstruct (win-update-info (:print-function win-update-info-print-function))
	invalid-objects
	last-invalid-obj
	invalid-slots
	new-bbox
	clip-mask-1
	clip-mask-2
	old-aggregate
)

(defun win-update-info-print-function (struct stream depth)
  (declare (ignore depth))
  (format stream "#<Win-Update-Info invalid-objects ")
  (let* ((invalid-objs (win-update-info-invalid-objects struct))
 	 (last-invalid-obj (win-update-info-last-invalid-obj struct))
	 (cdr-of-lio (cdr last-invalid-obj)))
    (if invalid-objs
	(progn
	  (setf (cdr last-invalid-obj) NIL)
	  (format stream "(")
	  (dolist (obj invalid-objs)
		(format stream "~A " obj))
	  (format stream ")")
	  (setf (cdr last-invalid-obj) cdr-of-lio))
	(format stream "NIL"))
    (format  stream " invalid-slots ~A>"
	(win-update-info-invalid-slots struct))))


(defstruct (opal-gc (:print-function opal-gc-print-function))
	gcontext
	opal-style		; This is either a line or filling style

	function
	foreground
	background
	line-width
	line-style
	cap-style
	join-style
	dashes		;; do not set to NIL
	font		;; do not set to NIL
	fill-style
	fill-rule
	stipple
	clip-mask
)

(defun opal-gc-print-function (gc stream depth)
  (declare (ignore depth))
  (format stream "#<Opal-GC function ~A clip-mask ~A>"
	  (opal-gc-function gc)
	  (opal-gc-clip-mask gc)))

(defvar *free-cons* NIL)

(defvar *font-hash-table* (make-hash-table :test #'equal))

;; This exists expressly to convert paths using CMU's
;; ext:search-list keys into normal paths.  Not robust, but better than
;; what used to be done...
(defun fix-font-path (path-argument)
  (when path-argument
    (let* ((path path-argument)
	   (colon-posn (position #\: path))
	   (search-path (when colon-posn
			  #+cmu (ext:search-list
				 (subseq path 0 (1+ colon-posn)))
			  #-cmu nil)))
      (if search-path
	  (concatenate 'string (car search-path) (subseq path (1+ colon-posn)))
	  (if (eq (position #\/ path :from-end t) (1- (length path)))
	      path
	      (concatenate 'string path "/"))))))

;; Hack used in font-to-xfont to counteract ridiculous tendency
;; of CLX to tack on #\null characters at the end of font paths.
(defun remove-null-char (s)
  #+kcl (remove #\^@   s :start (1- (length s)))
  #-kcl (remove #\null s :start (1- (length s))))

(defmacro merge-bbox (dest-bbox source-bbox)
  `(when (bbox-valid-p ,source-bbox)
     (if (bbox-valid-p ,dest-bbox)
      (progn
	(setf (bbox-x1 ,dest-bbox)
		(MIN (bbox-x1 ,dest-bbox) (bbox-x1 ,source-bbox)))
	(setf (bbox-y1 ,dest-bbox)
		(MIN (bbox-y1 ,dest-bbox) (bbox-y1 ,source-bbox)))
	(setf (bbox-x2 ,dest-bbox)
		(MAX (bbox-x2 ,dest-bbox) (bbox-x2 ,source-bbox)))
	(setf (bbox-y2 ,dest-bbox)
		(MAX (bbox-y2 ,dest-bbox) (bbox-y2 ,source-bbox))))
      (progn
	(setf (bbox-x1 ,dest-bbox) (bbox-x1 ,source-bbox))
	(setf (bbox-y1 ,dest-bbox) (bbox-y1 ,source-bbox))
	(setf (bbox-x2 ,dest-bbox) (bbox-x2 ,source-bbox))
	(setf (bbox-y2 ,dest-bbox) (bbox-y2 ,source-bbox))
	(setf (bbox-valid-p ,dest-bbox) T)))))

;;; Leaves the bboxes valid-p bits alone.  Only copies the dimensions.
(defmacro copy-bbox-dims (dest-bbox source-bbox)
  `(progn
	(setf (bbox-x1 ,dest-bbox) (bbox-x1 ,source-bbox))
	(setf (bbox-y1 ,dest-bbox) (bbox-y1 ,source-bbox))
	(setf (bbox-x2 ,dest-bbox) (bbox-x2 ,source-bbox))
	(setf (bbox-y2 ,dest-bbox) (bbox-y2 ,source-bbox))))

;; Returns T iff the dimensions of two bboxes are different. Ignores valid-p.
(defmacro bbox-dims-differ (bb1 bb2)
  `(not (and
	  (= (bbox-x1 ,bb1) (bbox-x1 ,bb2))
	  (= (bbox-y1 ,bb1) (bbox-y1 ,bb2))
	  (= (bbox-x2 ,bb1) (bbox-x2 ,bb2))
	  (= (bbox-y2 ,bb1) (bbox-y2 ,bb2)))))

;;; Updates the bbox given (probably the object's :old-bbox slot value) with
;;; the values from the object.  This *presumes* that the object is visible!
(defmacro update-bbox (object bbox)
    `(let ((left (g-value ,object :left))
	   (top  (g-value ,object :top )))
	(setf (bbox-x1 ,bbox) left)
	(setf (bbox-y1 ,bbox) top)
	(setf (bbox-x2 ,bbox) (+ left (g-value ,object :width )))
	(setf (bbox-y2 ,bbox) (+ top  (g-value ,object :height)))
	(setf (bbox-valid-p ,bbox) T)))

;;; Returns true if they intersect (ignores the valid bit!)
(defmacro bbox-intersect-p (bb1 bb2)
 `(and (<= (bbox-x1 ,bb1) (bbox-x2 ,bb2))   ;; 1 not right of 2
       (<= (bbox-x1 ,bb2) (bbox-x2 ,bb1))   ;; 2 not right of 1
       (<= (bbox-y1 ,bb1) (bbox-y2 ,bb2))   ;; 1 not below 2
       (<= (bbox-y1 ,bb2) (bbox-y2 ,bb1)))) ;; 2 not below 1

;;; Returns true iff bbox intersects either bb1 or bb2.  This will check if
;;; bb2 is NIL, but if bb1 is NIL this will crash.
(defmacro bbox-intersects-either-p (bbox bb1 bb2)
  `(or (bbox-intersect-p ,bbox ,bb1)
       (and ,bb2 (bbox-intersect-p ,bbox ,bb2))))

;; Erases this bbox from this window (or its buffer). Ignores valid bit.
(defun erase-bbox (bb drawable buffer buffer-gc)
  (if buffer
      (xlib:with-gcontext (buffer-gc :function opal::*clear*)
	(xlib:draw-rectangle buffer buffer-gc
			     (bbox-x1 bb)
			     (bbox-y1 bb)
			     (- (bbox-x2 bb) (bbox-x1 bb))
			     (- (bbox-y2 bb) (bbox-y1 bb))
			     t))
      (xlib:clear-area drawable
		       :x (bbox-x1 bb)
		       :y (bbox-y1 bb)
		       :width  (- (bbox-x2 bb) (bbox-x1 bb))
		       :height (- (bbox-y2 bb) (bbox-y1 bb)))))

#|
;;; NOTE THAT THE STUFF ABOUT THE LET IS CACA.
;; Returns True if slot does not have a formula and is non-NIL or if
;; it has a formula with a valid cached value.  NOTE:  this uses the
;; special variable "***formula".  This will be a global unless you place it
;; inside a LET (which is how it is normally called!)
(defmacro slot-is-valid (schema slot)
  `(if (formula-p (setq ***formula (get-local-value ,schema ,slot)))
	(kr::cache-is-valid (get-local-value ***formula :cached-value))
	***formula))

;; Returns True if the :top, :left, :width, and :height are either non-NIL
;; non-formulas or valid cached-values of formulas.  It is used so that if
;; an aggregate's dimensions are not valid, instead of computing them we'll
;; just go ahead and update it!
(defmacro dims-are-valid (schema)
  `(let (***formula)
	(and (slot-is-valid ,schema :left)
	     (slot-is-valid ,schema :top)
	     (slot-is-valid ,schema :width)
	     (slot-is-valid ,schema :height))))
|#

;; Takes a bbox and a clip mask, and goes through and sets the fields properly
;; within the clip mask.  Ignores valid bit.
(defmacro bbox-to-clip-mask (bb clip-mask)
  `(let ((cm ,clip-mask))
     (setf (car cm) (bbox-x1 ,bb))
     (setf (car (setq cm (cdr cm))) (bbox-y1 ,bb))
     (setf (car (setq cm (cdr cm))) (- (bbox-x2 ,bb) (bbox-x1 ,bb)))
     (setf (cadr cm) (- (bbox-y2 ,bb) (bbox-y1 ,bb)))))

;; propagate dirty bit of T from this object up towards root
;; this will do ugly things if called with object == NULL.
(defmacro propagate-dirty-bit (object update-info)
   `(unless (update-info-dirty-p ,update-info)
      (let ((temp ,object) (temp-update-info ,update-info))
        (loop
	  (setf (update-info-dirty-p temp-update-info) T)
	  (if (or (null (setq temp (get-local-value temp :parent)))
		  (update-info-dirty-p
		     (setq temp-update-info
			   (get-local-value temp :update-info))))
		(return))))))

;; this adds the object to the window's invalid-objects entry in its
;; :win-update-info slot and then sets the object's invalid-p to T.
(defmacro make-object-invalid (gob gob-update-info the-window)
  `(let* ((w-info (get-local-value ,the-window :win-update-info))
	  (last-invalid (win-update-info-last-invalid-obj w-info)))
    (if *free-cons*
      (progn
	(if last-invalid
	    				;; some free cons'es, Already entries
		(setf (win-update-info-last-invalid-obj w-info)
		   (setf last-invalid
			(setf (cdr last-invalid) *free-cons*)))

	     				;; some free cons'es, No entries
		(setf (win-update-info-invalid-objects w-info)
		    (setf (win-update-info-last-invalid-obj w-info)
			(setf last-invalid
			   *free-cons*))))
	(setf *free-cons* (cdr *free-cons*))
	(setf (car last-invalid) ,gob))

    ;else no *free-cons* cells...
	(if last-invalid
	    				;; no free cons'es, Already entries
		(setf (win-update-info-last-invalid-obj w-info)
		   (setf (cdr last-invalid)
			(list ,gob)))

	     				;; no free cons'es, No entries
		(setf (win-update-info-invalid-objects w-info)
		    (setf (win-update-info-last-invalid-obj w-info)
			(list ,gob)))))
    (setf (update-info-invalid-p ,gob-update-info) T)))

#|
	The following code is no longer used by the update algorithm!

;;; This is almost exactly a clone of the previous macro, but it deals
;;; with adding an object to a window's fastdraw-objects list...  It is a
;;; support macro for "add-to-fastdraw-list"
(defmacro add-obj-to-fastdraw-list (obj w-info)
  `(let ((last-fastdraw (win-update-info-last-fastdraw-obj ,w-info)))
    (if *free-cons*
      (progn
	(if last-fastdraw
	    				;; some free cons'es, Already entries
		(setf (win-update-info-last-fastdraw-obj ,w-info)
		   (setf last-fastdraw
			(setf (cdr last-fastdraw) *free-cons*)))

	     				;; some free cons'es, No entries
		(setf (win-update-info-fastdraw-objects ,w-info)
		    (setf (win-update-info-last-fastdraw-obj ,w-info)
			(setf last-fastdraw
			   *free-cons*))))
	(setf *free-cons* (cdr *free-cons*))
	(setf (car last-fastdraw) ,obj))

    ;else no *free-cons* cells...
	(if last-fastdraw
	    				;; no free cons'es, Already entries
		(setf (win-update-info-last-fastdraw-obj ,w-info)
		   (setf (cdr last-fastdraw)
			(list ,obj)))

	     				;; no free cons'es, No entries
		(setf (win-update-info-fastdraw-objects ,w-info)
		    (setf (win-update-info-last-fastdraw-obj ,w-info)
			(list ,obj)))))
))

(defmacro add-to-fastdraw-list (gob first-changed w-info)
  `(progn
    (add-obj-to-fastdraw-list ,gob ,w-info)
    (add-obj-to-fastdraw-list ,first-changed ,w-info)
    (setf (update-info-on-fastdraw-list-p (get-local-value ,gob :update-info))
	T)))
|#

(defun new-garnet-window-name ()
  (let ((*print-base* 10))
    (format nil "Opal ~S" (incf *opal-window-count*))))


;;; Wonderful hack that allows one to use update-all to update even
;;; those windows that have never been updated, and thus have an empty
;;; :drawable slot and do not appear in the hash-table
;;; opal::*drawable-to-window-mapping*.  I include NIL at the head of
;;; the list so that Common Lisp's delete will always work.
(defvar *windows-that-have-never-been-updated* '(NIL))

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/text-fonts.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Changes:
;;;  3/4/91 d'souza Removed nickname "MO" of package Opal.
;;; 3/18/90 ECP  Oops, I had "times" and "helvetica" switched.
;;;		 Actually, Times has the serifs, not Helvetica.
;;; 1/25/90 ECP  Total rewrite to take advantage of standard font files.
;;;              using X font naming conventions.
;;;

(in-package "OPAL" :use '("LISP" "KR"))

(defvar *Fixed-Font-Family*      "courier")
(defvar *Serif-Font-Family*      "times")
(defvar *Sans-Serif-Font-Family* "helvetica")

(defvar *Small-Font-Size*      10)
(defvar *Medium-Font-Size*     12)
(defvar *Large-Font-Size*      18)
(defvar *Very-Large-Font-Size* 24)

;; Returns either a string which describes the font using X conventions,
;; or a cons of the bad value and slot.
(defun make-xfont-name (key)
  (let ((family-part
          (case (first key)
            (:fixed      *Fixed-Font-Family*)
            (:serif      *Serif-Font-Family*)
            (:sans-serif *Sans-Serif-Font-Family*)
	    (otherwise   nil)))
        (face-part 
          (case (second key)
            (:roman "medium-r")
            (:bold "bold-r")
            (:italic (if (eq (first key) :serif) "medium-i" "medium-o"))
            (:bold-italic (if (eq (first key) :serif) "bold-i" "bold-o"))
            (otherwise nil)))
        (size-part
	  (case (third key)
            (:small      (princ-to-string *Small-Font-Size*))
            (:medium     (princ-to-string *Medium-Font-Size*))
            (:large      (princ-to-string *Large-Font-Size*))
            (:very-large (princ-to-string *Very-Large-Font-Size*))
            (otherwise   nil))))
    (cond ((null family-part)
           (cons (first key) :family)) ;; for reporting error
          ((null face-part)
           (cons (second key) :face))
          ((null size-part)
           (cons (third key) :size))
          (t
           (concatenate 'string
           "*-*-"
           family-part
           "-"
           face-part
           "-*-*-" 
           size-part
           "-*-*-*-*-*-iso8859-1")))))


;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/create-instances.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Opal:Create-Instances.Lisp
;;;
;;; This file contains all the calls to KR:Create-Instance which are in Opal.
;;; They appear in the order in which they are listed in the overall Opal
;;; hierarchy, which is listed first.  Please keep it that way!
;;; NOTE:  the first entry of ":update-slots" MUST be :visible (unless the
;;;   value is NIL), elsewise the update algorithm will break!
;;;
;;; Change Log:
;;;     date     who    what
;;;     ----     ---    ----
;;;   26-Mar-91  ecp    Added :components to :local-only-slots slot of
;;;			opal:aggregate.
;;;    7-Mar-91  ecp    The question of whether the screen is color or
;;;			black-and-white is now determined in defs.lisp.
;;;   22-Feb-91  amickish  New exported motif colors and filling styles.
;;;   14-Feb-91  ecp    Yet more changes to color so that colors are
;;;                     deallocated when they are not used anymore.
;;;    8-Feb-91  ecp    Added :color-p slot to opal:color to tell if
;;;                     screen is black-and-white or color.
;;;   10-Aug-90  loyall Made :width, :height of aggregate not depend
;;;                     directly on :top, :left.
;;;    1-Aug-90  dzg    New :local-only-slots slot in opal:view-object
;;;   19-Jul-90  ecp    Made thickness of line-1 be 1.
;;;   20-Jun-90  ecp    Temporarily made thickness of dotted-line be 1,
;;;			due to new CLX bug.
;;;    4-Jun-90  ecp    Removed inverse relation between :parent and :child
;;;   16-Apr-90  ecp    Moved creation of default-font earlier.
;;;   27-Mar-90  ecp    In build-pixmap, changed 0 and 1 to *black*
;;;			and *white*.
;;;   19-Mar-90  ecp    Got rid of Garnet-Font-Pathname.
;;;			Changed :tile to :stipple
;;;    1-Mar-90  ecp    In build-pixmap, changed the :bitmap-p argument
;;;			to xlib:put-image from t to nil.
;;;   13-Feb-90  ecp    Implemented color.
;;;   25-Jan-90  ecp    Changes to fonts.
;;;    5-Dec-89  ecp    Moved create-instance of FONT-FROM-FILE earlier.
;;;     ******* SEE OPAL CHANGE.LOG ********
;;;   15-Jun-89  koz	Placed Graphic-Quality hierarchy before View-Object
;;;			to resolve forward references (instead of s-value).
;;;			This should fix bug that made Cursor-Text not inherit
;;;			the right slots at creation time.
;;;   15-Jun-89  koz	Converted from kr:formula to kr:o-formula.
;;;   15-Jun-89  koz	Extracted all forward references and placed them all
;;;			in S-VALUEs at the end of this file, or in other files
;;;			if they needed functions not yet defined...
;;;   14-Jun-89  koz    Created.  Simply extracted all the calls to kr:create-
;;;			instance from all the Opal files.  No modifications
;;;			were made to them.

(in-package "OPAL" :use '("LISP" "KR"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; I *hate* to do this, but this function needs to go here so that the
;;; the reference to it below doesn't generate a warning at compile time.  Of
;;; course, we *should* be able to just declare it, but no...  Bug in compiler!
(defun build-pixmap (drawable image width height bitmap-p)
  (let* ((pixmap (xlib:create-pixmap :width width :height height
                                     :drawable drawable
                                     :depth 1))
         (gc (xlib:create-gcontext :drawable pixmap :function boole-1
                                   :foreground opal::*black*
                                   :background opal::*white*
                                   )))
    (xlib:put-image pixmap gc image
		    :x 0 :y 0 :width width :height height :bitmap-p bitmap-p)
    (xlib:free-gcontext gc)
    pixmap))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;  The Opal Hierarchy  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#|
  opal:GRAPHIC-QUALITY
	opal:FONT
	opal:COLOR
		opal:WHITE
		opal:BLACK
		opal:RED
		opal:GREEN
		opal:BLUE
		opal:YELLOW
		opal:CYAN
		opal:ORANGE
		opal:PURPLE
		opal:MOTIF-GRAY
		opal:MOTIF-BLUE
		opal:MOTIF-ORANGE
		opal:MOTIF-GREEN
	opal:LINE-STYLE
		opal:DEFAULT-LINE-STYLE
		opal:THIN-LINE
		opal:LINE-0
		opal:LINE-1
		opal:LINE-2
		opal:LINE-4
		opal:LINE-8
		opal:DOTTED-LINE
		opal:DASHED-LINE
		opal:RED-LINE
		opal:GREEN-LINE
		opal:BLUE-LINE
		opal:YELLOW-LINE
		opal:ORANGE-LINE
		opal:CYAN-LINE
		opal:PURPLE-LINE
	opal:FILLING-STYLE
		opal:DEFAULT-FILLING-STYLE
		opal:WHITE-FILL
		opal:LIGHT-GRAY-FILL
		opal:GRAY-FILL
		opal:DARK-GRAY-FILL
		opal:BLACK-FILL
		opal:RED-FILL
		opal:GREEN-FILL
		opal:BLUE-FILL
		opal:YELLOW-FILL
		opal:ORANGE-FILL
		opal:CYAN-FILL
		opal:PURPLE-FILL
		opal:MOTIF-GRAY-FILL
		opal:MOTIF-BLUE-FILL
		opal:MOTIF-ORANGE-FILL
		opal:MOTIF-GREEN-FILL
	opal:FONT-FROM-FILE
  opal:VIEW-OBJECT
	opal:AGGREGATE
		opal:WINDOW-AGGREGATE
	opal:GRAPHICAL-OBJECT
		opal:LINE
		opal:RECTANGLE
			opal:ROUNDTANGLE
		opal:ARC
			opal:OVAL
			opal:CIRCLE
		opal:MULTIPOINT
			opal:POLYLINE
                                opal:ARROWHEAD
		opal:TEXT
			opal:CURSOR-TEXT
                        opal:MULTI-TEXT
                                opal:CURSOR-MULTI-TEXT
		opal:BITMAP
			opal::WHITE-FILL-BITMAP
			opal::LIGHT-GRAY-FILL-BITMAP
			opal::GRAY-FILL-BITMAP
			opal::DARK-GRAY-FILL-BITMAP
			opal:ARROW-CURSOR
			opal:ARROW-CURSOR-MASK
	opal:WINDOW

|#
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;  Graphic-Quality Hierarchy  ;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(create-instance 'opal:GRAPHIC-QUALITY NIL)

(define-method :destroy-me opal:graphic-quality (quality)
  (destroy-schema quality))

(define-method :destroy opal:graphic-quality (quality)
  (dolist (instance (copy-list (get-local-values quality :is-a-inv)))
    (destroy instance))
  (destroy-me quality))
			   

(create-instance 'opal::FONT-FROM-FILE opal:graphic-quality
  (:ignored-slots :display-xfont-plist)
  (:display-xfont-plist NIL)
  (:font-path NIL)
  (:font-name ""))

(define-method :initialize opal:font-from-file (fff)
  (s-value fff :font-from-file fff))

(setf (gethash '(:fixed :roman :medium) *font-hash-table*)
  (create-instance 'opal::DEFAULT-FONT opal:font-from-file
    (:font-name	(make-xfont-name '(:fixed :roman :medium)))))

(create-instance 'opal:FONT opal:graphic-quality
  (:family :fixed)
  (:face :roman)
  (:size :medium)
  (:font-from-file
     (o-formula
       (let ((key (list (gvl :family) (gvl :face) (gvl :size))))
         (or (gethash key *font-hash-table*)
             (let ((xfont-name (make-xfont-name key)))
	       (if (stringp xfont-name)
                   (setf (gethash key *font-hash-table*)
		     (create-instance NIL opal:font-from-file
                       	            (:font-name xfont-name)))
		   (progn
                     (warn "~A not allowed for :~A slot of font; substituting default-font." (car xfont-name) (cdr xfont-name))
                     opal:default-font))))))))

;;; Find out the first colormap index that you are actually allowed to
;;; allocate and deallocate.
(when *is-this-a-color-screen?*
  (let ((indices (xlib:alloc-color-cells opal::*default-x-colormap* 1)))
    (setq *first-allocatable-colormap-index* (car indices))
    (xlib:free-colors opal::*default-x-colormap* indices)))

(create-instance 'opal:COLOR opal:graphic-quality
  (:red 1.0)
  (:green 1.0)
  (:blue 1.0)
  (:color-p *is-this-a-color-screen?*)
  (:xcolor (o-formula (xlib:make-color :red (gvl :red)
				       :green (gvl :green)
				       :blue (gvl :blue))))
  (:colormap-index
     (o-formula
	(let ((old-index (g-cached-value (gv :self) :colormap-index))
              (new-index (xlib:alloc-color opal::*default-x-colormap*
				           (gvl :xcolor))))
	  (when *is-this-a-color-screen?*
	    (when (and old-index
		       (>= old-index *first-allocatable-colormap-index*)
		       (zerop (decf (aref *colormap-index-table* old-index))))
	      (xlib:free-colors opal::*default-x-colormap* (list old-index)))
	    (incf (aref *colormap-index-table* new-index)))
	  new-index))))
	
(define-method :destroy-me opal:color (hue)
  (when *is-this-a-color-screen?*
    (let ((index (g-cached-value hue :colormap-index)))
      (when (and index
		 (zerop (decf (aref *colormap-index-table* index)))
		 (>= index *first-allocatable-colormap-index*))
	    (xlib:free-colors opal::*default-x-colormap* (list index)))))
  (destroy-schema hue))
				    
;; 28-Jul-91 -FER don't need
;(create-instance 'opal:RED opal:color
;  (:red 1.0) (:green 0.0) (:blue 0.0))
;
;(create-instance 'opal:GREEN opal:color
;  (:red 0.0) (:green 1.0) (:blue 0.0))
;
;(create-instance 'opal:BLUE opal:color
;  (:red 0.0) (:green 0.0) (:blue 1.0))
;
;(create-instance 'opal:YELLOW opal:color
;  (:red 1.0) (:green 1.0) (:blue 0.0))
;
;(create-instance 'opal:CYAN opal:color
;  (:red 0.0) (:green 1.0) (:blue 1.0))
;
;(create-instance 'opal:PURPLE opal:color
;  (:red 1.0) (:green 0.0) (:blue 1.0))
;
;(create-instance 'opal:ORANGE opal:color
;  (:red 0.75) (:green 0.25) (:blue 0.0))

(create-instance 'opal:WHITE opal:color
  (:red 1.0) (:green 1.0) (:blue 1.0))

(create-instance 'opal:BLACK opal:color
  (:red 0.0) (:green 0.0) (:blue 0.0))

(create-instance 'opal:LINE-STYLE opal:graphic-quality
  (:line-thickness 0)
  (:line-style :solid)    ;; or :dash or :double-dash
  (:cap-style :butt)      ;; or :not-last, :round or :projecting
  (:join-style :miter)    ;; or :round or :bevel
  (:dash-pattern nil)
  (:foreground-color opal::black)
  (:background-color opal::white)
  (:stipple nil))


(create-instance 'opal:DEFAULT-LINE-STYLE opal:line-style)


(create-instance 'opal::LINE-0 opal:line-style)
(defvar opal::THIN-LINE opal::LINE-0)
(create-instance 'opal::LINE-1 opal:line-style (:line-thickness 1))
(create-instance 'opal::LINE-2 opal:line-style (:line-thickness 2))
#-release-garnet(create-instance 'opal::LINE-4 opal:line-style (:line-thickness 4))
#-release-garnet(create-instance 'opal::LINE-8 opal:line-style (:line-thickness 8))

;; 28-Jul-91 -FER don't need
;(create-instance 'opal:RED-LINE opal:line-style
;                         (:foreground-color opal:red))
;(create-instance 'opal:GREEN-LINE opal:line-style
;                         (:foreground-color opal:green))
;(create-instance 'opal:BLUE-LINE opal:line-style
;                         (:foreground-color opal:blue))
;(create-instance 'opal:CYAN-LINE opal:line-style
;                         (:foreground-color opal:cyan))
;(create-instance 'opal:YELLOW-LINE opal:line-style
;                         (:foreground-color opal:yellow))
;(create-instance 'opal:ORANGE-LINE opal:line-style
;                         (:foreground-color opal:orange))
;(create-instance 'opal:PURPLE-LINE opal:line-style
;                         (:foreground-color opal:purple))
;
;
;(create-instance 'opal::DOTTED-LINE opal:line-style
;                      (:line-style :dash)
;                      (:line-thickness 1)
;                      (:dash-pattern '(1 1)))
;
;
;(create-instance 'opal::DASHED-LINE opal:line-style
;                      (:line-style :dash)
;                      (:dash-pattern '(4 4)))
;

(create-instance 'opal:FILLING-STYLE opal:graphic-quality
  (:fill-style :solid)    ;; or :opaque-stippled or :stippled
  (:fill-rule :even-odd)  ;; or :winding
  (:foreground-color opal::black)
  (:background-color opal::white)
  (:stipple nil))


(create-instance 'opal:DEFAULT-FILLING-STYLE opal:filling-style)

;;;; For the *-FILL schemas, please see the end of this file (to avoid
;;;; forward references, they had to be put there)....

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;  View-Object Hierarchy  ;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(create-instance 'opal:VIEW-OBJECT NIL
  (:left 0)
  (:top 0)
  (:width 0)
  (:height 0)
  (:hit-threshold 3)
  (:local-only-slots '(:window nil) '(:parent nil))
  (:visible (o-formula (let ((parent (gvl :parent)))
			    (or (null parent) (gv parent :visible)))
                       t))
  (:update-slots '(:visible :fast-redraw-p))
  ;; The following are the controls for the schema printer
  (:sorted-slots :is-a :left :top :width :height :visible :line-style
                 :filling-style :draw-function :components :parent)
  (:ignored-slots :depended-slots :update-slots :update-slots-values)
  (:limit-values '(:is-a-inv 5))
  (:global-limit-values 5))


;;; Aggregates allow for a group of graphical-objects to be associated
;;; together to form a new, more complex object.
;;;
;;; An implementation detail:
;;; The children of a gob are stored in a list from bottom most to top
;;; most, since we want to redraw fastest and redraws occur from bottom to
;;; top.

(create-instance 'opal:AGGREGATE opal:view-object
  (:components)
  (:update-slots NIL)	;; New update does not use AGGREGATE'S visible!
#|
  (:box (o-formula
	   (let ((box (g-cached-value kr::*schema-self* :box))
		 (agg-is-visible-p NIL)
		 (components (get-values kr::*schema-self* :components))
		 left top right bottom cleft ctop new-box-p)
	     (setq new-box-p (unless box (setq box (make-bbox))))
	     (gvl :components)
	     (dolist (child components)
		(if (gv child :visible)
		  (if agg-is-visible-p
		    (progn (setq left (min left (setq cleft (gv child :left))))
			   (setq top  (min top  (setq ctop  (gv child :top ))))
			   (setq right (max right (+ cleft (gv child :width))))
			   (setq bottom (max bottom (+ ctop
						       (gv child :height)))))
		    (progn (setq agg-is-visible-p t)
			   (setq left (gv child :left))
			   (setq top  (gv child :top))
			   (setq right (+ left (gv child :width)))
			   (setq bottom (+ top (gv child :height)))))))
	     (if agg-is-visible-p
					;; We get here iff the aggregate is now
					;; visible.  If it has changed from
					;; before, set it and mark-as-changed!
		(unless (and (bbox-valid-p box)
			     (= (bbox-x1 box) left)
			     (= (bbox-y1 box) top)
			     (= (bbox-x2 box) right)
			     (= (bbox-y2 box) bottom))
			(setf (bbox-x1 box) left)
			(setf (bbox-x2 box) top)
			(setf (bbox-y1 box) right)
			(setf (bbox-y2 box) bottom)
			(setf (bbox-valid-p box) T)
			(unless new-box-p
			  (mark-as-changed kr::*schema-self* :box)))

					;; We get here iff the aggregate is no
					;; longer visible.  If it was visible,
					;; reset its box.  Else, just do nada!
		(when (or new-box-p (bbox-valid-p box))
		  (setf (bbox-x1 box)
		    (setf (bbox-x2 box)
		      (setf (bbox-y1 box)
		        (setf (bbox-y2 box) 0))))
		  (setf (bbox-valid-p box) NIL)
		  (unless new-box-p
		    (mark-as-changed kr::*schema-self* :box))))
	     box)))
  (:left   (o-formula (bbox-x1 (gvl :box))))
  (:top    (o-formula (bbox-y1 (gvl :box))))
  (:width  (o-formula (let ((box (gvl :box)))
			(- (bbox-x2 box) (bbox-x1 box)))))
  (:height (o-formula (let ((box (gvl :box)))
			(- (bbox-y2 box) (bbox-y1 box)))))
  (:visible (o-formula (bbox-valid-p (gvl :box))))
|#

  (:left (o-formula
          (let ((min-x 999999))
	    (gvl :components)
	    (dolist (child (get-values kr::*schema-self* :components))
	      (when (gv child :visible)
		(setf min-x (min min-x (gv child :left)))))
	    (if (= min-x 999999) 0 min-x))))
  (:top (o-formula
	 (let ((min-y 999999))
	   (gvl :components)
	   (dolist (child (get-values kr::*schema-self* :components))
	     (when (gv child :visible)
	       (setf min-y (min min-y (gv child :top)))))
	   (if (= min-y 999999) 0 min-y))))
  (:width (o-formula
	   (let ((max-x -999999)
		 (min-x 999999))
	     (gvl :components)
	     (dolist (child (get-values kr::*schema-self* :components))
	       (when (gv child :visible)
		 (setf max-x (max max-x (+ (gv child :left)
					   (gv child :width))))
		 (setf min-x (min min-x (gv child :left)))))
	     (max 0 (- max-x min-x)))))
  (:height (o-formula
	    (let ((max-y -999999)
		  (min-y 999999))
	      (gvl :components)
	      (dolist (child (get-values kr::*schema-self* :components))
                 (when (gv child :visible)
                   (setf max-y (max max-y (+ (gv child :top)
					     (gv child :height))))
		   (setf min-y (min min-y (gv child :top)))))
	      (max 0 (- max-y min-y)))))
#| REPLACING THIS WITH OLD FORMULA!
  (:visible (o-formula
	     (progn
		(gvl :components)
		(dolist (child (get-values kr::*schema-self* :components))
			(if (gv child :visible)
				(return T))))
	      T))
|#
  (:visible (o-formula (let ((parent (gvl :parent)))
			    (or (null parent) (gv parent :visible)))
                       t))

#| TOA OMITTED
  ;; The TOA is the Topmost-Overlapping-Aggregate.  This slot will hopefully
  ;; improve the performance of the update algorithm.  The formula given here
  ;; is only for AGGREGATEs.  A different one appears within Graphical-Object.
  (:toa (o-formula
	  (let ((parent (gvl :parent)))
	    (or (and parent (gv parent :toa))
		(if (gvl :overlapping) kr::*schema-self*)))))
|#
)

;;; A patch for some problems with opal:window-aggregate, which is
;;; currently undefined  - Dario
;;;
(create-instance 'opal:WINDOW-AGGREGATE opal:aggregate)



;;; Class Graphical-object
(create-instance 'opal:GRAPHICAL-OBJECT opal:view-object
  (:top 0)
  (:left 0)
  (:width 20)
  (:height 20)
  (:draw-function :copy)
  (:line-style opal:default-line-style)
  (:filling-style nil)
  (:select-outline-only nil)
  (:update-slots '(:visible :fast-redraw-p
		   :line-style :filling-style :draw-function))

#| OMMITTING X-DRAW-FUNCTION
  ;; Translate the keyword values for :draw-function into values more
  ;; acceptable to CLX
  (:x-draw-function (o-formula
                     (let ((function (gvl :draw-function)))
                        (if (numberp function)
                            function
                            (cdr (assoc function *function-alist*))))))
|#
#| OMITTING TOA
  ;; The TOA is the Topmost-Overlapping-Aggregate.  This slot will hopefully
  ;; improve the performance of the update algorithm.  The formula given here
  ;; is for NON-AGGREGATE objects.  A different one appears within Aggregates.
  (:toa (o-formula
	  (let ((parent (gvl :parent)))
	    (and parent (gv parent :toa)))))
|#
#| OMITTING X-TILES
  ;; Build formulas for line and filling style tiles to be associated with
  ;; the object
  (:x-tiles (o-formula
              (let* ((a-line-style (gvl :line-style))
                     (a-filling-style (gvl :filling-style))
                     (root (display-info-root-window
				(gvl :window :display-info)))
                     (ls-tile (if a-line-style (gv a-line-style :tile)))
                     (fs-tile (if a-filling-style (gv a-filling-style :tile)))
                     (lst-image (if ls-tile (gv ls-tile :image)))
                     (fst-image (if fs-tile (gv fs-tile :image))))
                (cons
                 (if lst-image
                   (build-pixmap root lst-image))
                 (if fst-image
                   (build-pixmap root fst-image))))))
|#
  )

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/create-instances2.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Opal:Create-Instances2.Lisp
;;;
;;; Changes:
;;; 22-Feb-91 amickish  New exported motif colors and filling styles.
;;; 22-Oct-90 ecp  New improved formulae for top, left, width, height of line.
;;; 17-Oct-90 ecp  In formula for :width of text, allowed string to be nil.
;;;  5-Oct-90 ecp  More work on formula for :width of text.
;;; 11-Sep-90 ecp  Changed formula for :width of text.
;;; 30-Aug-90 ecp  Multipoints whose line-thicknesses are 0 must be
;;;                treated as if their line-thicknesses were 1 (since
;;;                they're drawn that way).
;;; 14-Aug-90 bam  Added :local-only-slots slot to opal:window.
;;;  1-Aug-90 dzg  New :local-only-slots slot in opal:cursor-text.
;;; 27-Jun-90 bam  Made :buffer-gc be :ignored-slot of opal:window.
;;;  4-Jun-90 dzg  Removed (:parent NIL) from opal:window.
;;;  1-May-90 ecp  If :image of bitmap is nil, width and height are 0.
;;; 16-Apr-90 ecp  Moved defun of font-to-xfont from new-defs.lisp to
;;;		   create-instances2.lisp
;;; 23-Mar-90 ecp  New slot :fill-background-p for text objects.
;;; 19-Mar-90 ecp  Changed :tile to :stipple
;;; 12-Mar-90 ecp  Setting :title and :icon-title of windows
;;;		   in :initialize method.
;;; 13-Feb-90 ecp Implemented color.

(in-package "OPAL" :use '("LISP" "KR"))

;;; This is only necessary because Lisp has problems with really large
;;; fasl files.  Great.

(create-instance 'opal:LINE opal:graphical-object
  (:x1 0)
  (:y1 0)
  (:x2 0)
  (:y2 0)
  (:left (o-formula (- (min (gvl :x1) (gvl :x2))
		       (if (eq (gvl :line-style :cap-style) :projecting)
			   (max 1 (gvl :line-style :line-thickness))
                           (floor (gvl :line-style :line-thickness) 2)))))
  (:top (o-formula  (- (min (gvl :y1) (gvl :y2))
		       (if (eq (gvl :line-style :cap-style) :projecting)
			   (max 1 (gvl :line-style :line-thickness))
                           (floor (gvl :line-style :line-thickness) 2)))))
  (:width  (o-formula (+ (abs (- (gvl :x1) (gvl :x2)))
			 (* (if (eq (gvl :line-style :cap-style) :projecting) 2 1)
                            (max 1 (gvl :line-style :line-thickness))))))
  (:height (o-formula (+ (abs (- (gvl :y1) (gvl :y2)))
			 (* (if (eq (gvl :line-style :cap-style) :projecting) 2 1)
                            (max 1 (gvl :line-style :line-thickness))))))
  (:update-slots '(:visible :fast-redraw-p :x1 :x2 :y1 :y2 :line-style
		   :filling-style :draw-function)))


(create-instance 'opal:RECTANGLE opal:graphical-object
  (:update-slots '(:visible :fast-redraw-p :top :left :width :height
		   :line-style :filling-style :draw-function)))


#-sx
(create-instance 'opal:ROUNDTANGLE opal:rectangle
  (:radius :small)
  (:update-slots '(:visible :fast-redraw-p
		   :top :left :width :height :radius :draw-radius
		   :line-style :filling-style :draw-function))
  (:draw-radius (o-formula (let ((r (gvl :radius))
                                (smaller-side (min (gvl :width)
                                                   (gvl :height))))
                            (if (numberp r)
                                (min (max r 0) (floor smaller-side 2))
                                (case r
                                  (:small (floor smaller-side 5))
                                  (:medium (floor smaller-side 4))
                                  (:large (floor smaller-side 3))
                                  (t 0)))))))


(create-instance 'opal:ARC opal:graphical-object
  (:angle1 0)
  (:angle2 (/ pi 4))
  (:update-slots '(:visible :fast-redraw-p :left :top :width :height
                           :angle1 :angle2
			   :line-style :filling-style :draw-function)))


;; 28-Jul-91 -FER don't need
;(create-instance 'opal:OVAL opal:arc)


(create-instance 'opal:CIRCLE opal:arc)


(create-instance 'opal:MULTIPOINT opal:graphical-object
  (:point-list nil)
  (:update-slots '(:visible :fast-redraw-p :point-list
		   :line-style :filling-style :draw-function))
  (:left (o-formula
           (let* ((min-x 9999)
                  (line-style (gvl :line-style))
                  (lsthickness (if line-style
                                   (* 2 (max 1 (gv line-style :line-thickness)))
                                   0)))
             (do ((point (gvl :point-list) (cddr point)))
                 ((null point) (- min-x lsthickness))
               (setf min-x (min min-x (car point)))))))
  (:top (o-formula
           (let* ((min-y 9999)
                  (line-style (gvl :line-style))
                  (lsthickness (if line-style
                                   (* 2 (max 1 (gv line-style :line-thickness)))
                                   0)))
             (do ((point (gvl :point-list) (cddr point)))
                 ((null point) (- min-y lsthickness))
               (setf min-y (min min-y (cadr point)))))))
  (:width (o-formula
           (let* ((min-x 9999)
                  (max-x 0)
                  (line-style (gvl :line-style))
                  (lsthickness (if line-style
                                   (* 4 (max 1 (gv line-style :line-thickness)))
                                   0)))
             (do ((point (gvl :point-list) (cddr point)))
                 ((null point) (+ (- max-x min-x) lsthickness))
               (setf min-x (min min-x (car point)))
               (setf max-x (max max-x (car point)))))))
  (:height (o-formula
           (let* ((min-y 9999)
                  (max-y 0)
                  (line-style (gvl :line-style))
                  (lsthickness (if line-style
                                   (* 4 (max 1 (gv line-style :line-thickness)))
                                   0)))
             (do ((point (gvl :point-list) (cddr point)))
                 ((null point) (+ (- max-y min-y) lsthickness))
               (setf min-y (min min-y (cadr point)))
               (setf max-y (max max-y (cadr point))))))))


(create-instance 'opal:POLYLINE opal:multipoint)

(defun font-to-xfont (opal-font display)
  (let* ((fff (g-value opal-font :font-from-file))
	 (dx-plist (g-value fff :display-xfont-plist)))
    (or (getf dx-plist display)
	(let ((font-path (opal::fix-font-path (g-value fff :font-path)))
	      (font-name (g-value fff :font-name)))
	  (when font-path
	    (let ((xfont-path (mapcar #'opal::remove-null-char
				      (xlib:font-path display))))
	      ;;; Add the font-path to the font-path, if necessary
	      (unless (member font-path xfont-path :test #'string=)
		(setf (xlib:font-path display)
		      (cons font-path xfont-path))
		;;; Now make sure it's there!
		(unless (member font-path (xlib:font-path display)
				:test #'string=)
		  (format t "WARNING: X did not add ~A to font-path!!~%"
			  font-path)))))
	  ;;; Open the font only if it's on the font-path
	  (if (xlib:list-font-names display font-name)
	      (let ((xfont (xlib:open-font display font-name)))
		(s-value fff :display-xfont-plist
			 (cons display (cons xfont dx-plist)))
		xfont)
	      (progn
		(format t "WARNING: Font '~A' not on font path!~%"
			font-name)
		(unless (eq opal-font opal:default-font)
		  (format t "  ****   Resorting to Default Font!~%")
		  (s-value opal-font :font-from-file opal:default-font)
		  (font-to-xfont opal:default-font display))
		))))))

(create-instance 'opal:TEXT opal:graphical-object
  (:string "")
  (:update-slots '(:visible :fast-redraw-p :top :left :height :width
                           :string :font :xfont :actual-heightp
			   :fill-background-p
			   :line-style :filling-style :draw-function
			   :text-extents))
  (:ignored-slots :depended-slots :update-slots :update-slots-values
		  :xfont :text-extents)
  (:fill-background-p nil)
  (:actual-heightp nil)
  (:xfont (o-formula (opal::font-to-xfont
		      (gvl :font)
		      (let ((w (gvl :window)))
			(if w
			    (let ((d (gv w :display-info)))
			      (if d
				  (display-info-display d)
				  opal::*default-x-display*))
			    opal::*default-x-display*)))))
  (:text-extents
   (o-formula (let ((xfont (gvl :xfont))
                    (string (gvl :string)))
                   (if (and xfont (not (zerop (length string))))
                       (multiple-value-list
                        (xlib:text-extents xfont string))
                       *default-text-extents*))
                *default-text-extents*))  ;; if font isn't present
  (:width
   (o-formula (let ((string (gvl :string))
		    (text-extents (gvl :text-extents)))
		(max *cursor-width* ; just in case it's really a cursor-text
		     (cond ((or (null string) (string= string "")) 0)
			   ; If the string ends with a space, use width...
			   ((eq (elt string (1- (length string))) #\space)
			    (the-width text-extents))
			   ; ... otherwise use right-bearing minus left-bearing
			   (t
			    (- (the-right-bearing text-extents)
			       (the-left-bearing text-extents))))))))
  (:height
   (o-formula (let ((text-extents (gvl :text-extents))
                    (xfont (gvl :xfont)))
                   (if (and text-extents xfont)
                       (if (gvl :actual-heightp)
                           (+ (the-actual-ascent text-extents)
                              (the-actual-descent text-extents))
                           (+ (xlib:max-char-ascent xfont)
                              (xlib:max-char-descent xfont)))
                       0)) 0))
  (:font opal:default-font))


(create-instance 'opal:CURSOR-TEXT opal:text
 (:update-slots '(:visible :fast-redraw-p :top :left :height :width
                           :string :font :xfont :actual-heightp
			   :fill-background-p
			   :line-style :filling-style :draw-function
			   :text-extents :cursor-index :x-substr))
 (:local-only-slots '(:cursor-index nil) '(:window nil) '(:parent nil))
 (:height
  (o-formula (let ((text-extents (gvl :text-extents))
                   (xfont (gvl :xfont)))
              (if (and text-extents xfont)
                  (if (and (gvl :actual-heightp)
                           (not (zerop (length (gvl :string)))))
                      (+ (the-actual-ascent text-extents)
                         (the-actual-descent text-extents))
                      (+ (xlib:max-char-ascent xfont)
                         (xlib:max-char-descent xfont)))
                  0)) 0))
 (:x-substr (o-formula (let ((string (gvl :string))
                             (index (gvl :cursor-index)))
                        (cond ((null index) "")
			      ((<= index 0) "")
			      ((>= index (length string)) string)
			      (t (subseq string 0 index)))))))

;;; multi-line text
(create-instance 'opal:MULTI-TEXT opal:text
 (:update-slots '(:visible :fast-redraw-p :top :left :height :width
                           :string :font :xfont :actual-heightp
			   :fill-background-p
			   :line-style :filling-style :draw-function
			   :justification :cut-strings))
 (:justification :left)
 (:cut-strings (o-formula (let ((string (gvl :string))
				(font (gvl :xfont)))
			    (do* ((list nil)
				  (i -1 j)
				  (j 0)
				  (substring nil))
				 ((null i) (nreverse list))
			      (setf j (position #\Newline string :start (1+ i))
 				    substring (subseq string (1+ i) j))
			      (multiple-value-bind
				  (width dummy2 dummy3
					  left-bearing right-bearing)
				  (xlib:text-extents font substring)
				(declare (ignore dummy2 dummy3))
				(push (make-cut-string
				       :string substring
				       :width
					(cond ((or (null substring)
						   (string= substring "")) 0)
					      ; If the substring ends with a space,
					      ; use width...
			                      ((eq (elt substring (1- (length substring)))
						   #\space)
			                       width)
					      ; ... otherwise use difference of bearings
			                      (t (- right-bearing left-bearing)))
				       :left-bearing left-bearing)
				      list))))))
  (:height (o-formula (let ((font (gvl :xfont)))
			(* (+ (xlib:max-char-ascent font)
			      (xlib:max-char-descent font))
			   (length (gvl :cut-strings))))))
  (:width (o-formula (let ((width *cursor-width*)) ;just in case it's really
		       (dolist (cstring (gvl :cut-strings)) ;a cursor-multi-text
			 (setq width (max width (cut-string-width cstring))))
		       width))))

(create-instance 'opal:CURSOR-MULTI-TEXT opal:multi-text
  (:update-slots '(:visible :fast-redraw-p :top :left :height :width
                            :string :font :xfont :actual-heightp
			    :fill-background-p
	 		    :line-style :filling-style :draw-function
  		 	    :justification :cut-strings
			    :cursor-index :x-substr))
  (:cursor-index NIL)
  (:x-substr
   (o-formula (let ((string (gvl :string))
                    (index (gvl :cursor-index)))
                (cond ((null index) "")
                      ((<= index 0) "")
                      (t (subseq
                          string
                          (1+ (or (position #\Newline string :from-end t
                                            :end (min index (length string)))
                                  -1))
                          index)))))))

(create-instance 'opal:BITMAP opal:graphical-object
  (:line-style opal:default-line-style)
  (:filling-style nil)
  (:image nil)
  (:width (o-formula (if (gvl :image) (xlib:image-width (gvl :image)) 0)))
  (:height (o-formula (if (gvl :image) (xlib:image-height (gvl :image)) 0)))
  (:ignored-slots :depended-slots :update-slots :update-slots-values
		  :root-pixmap-plist :image)
  (:update-slots '(:visible :fast-redraw-p :image :top :left
		   :line-style :filling-style :draw-function)))


;;; All the *-FILL-BITMAPs will have their :image slot set once the function
;;; "halftone-image" is defined...

(create-instance 'opal::WHITE-FILL-BITMAP opal:bitmap
           (:image))   ;;; will be (halftone-image 0)

(create-instance 'opal::LIGHT-GRAY-FILL-BITMAP opal:bitmap
           (:image))   ;;; will be (halftone-image 25)

(create-instance 'opal::GRAY-FILL-BITMAP opal:bitmap
           (:image))   ;;; will be (halftone-image 50)

(create-instance 'opal::DARK-GRAY-FILL-BITMAP opal:bitmap
           (:image))   ;;; will be (halftone-image 75)

;;; Colors and filling-styles for Motif

;;;  Orange, Green, Blue lists for defining colors
;(defvar MOTIF-GRAY-VALUE (float (/ #xd3d3 #xffff)))
;
;(defvar MOTIF-BLUE-VALUES
;  (list (float (/ #x7272 #xffff)) (float (/ #x9f9f #xffff)) 1))
;
;(defvar MOTIF-GREEN-VALUES
;  (list (float (/ #x5f5f #xffff)) (float (/ #x9e9e #xffff))
;        (float (/ #xa0a0 #xffff))))
;
;(defvar MOTIF-ORANGE-VALUES (list 1 .6 .4))
;
;(create-instance 'MOTIF-GRAY-FILL opal:default-filling-style
;   (:foreground-color (create-instance 'MOTIF-GRAY opal:color
;                         (:red MOTIF-GRAY-VALUE)
;                         (:green MOTIF-GRAY-VALUE)
;                         (:blue MOTIF-GRAY-VALUE))))
;
;(create-instance 'MOTIF-BLUE-FILL opal:default-filling-style
;   (:foreground-color (create-instance 'MOTIF-BLUE opal:color
;                         (:red (first MOTIF-BLUE-VALUES))
;                         (:green (second MOTIF-BLUE-VALUES))
;                         (:blue (third MOTIF-BLUE-VALUES)))))
;
;(create-instance 'MOTIF-ORANGE-FILL opal:default-filling-style
;   (:foreground-color (create-instance 'MOTIF-ORANGE opal:color
;                         (:red (first MOTIF-ORANGE-VALUES))
;                         (:green (second MOTIF-ORANGE-VALUES))
;                         (:blue (third MOTIF-ORANGE-VALUES)))))
;
;(create-instance 'MOTIF-GREEN-FILL opal:default-filling-style
;   (:foreground-color (create-instance 'MOTIF-GREEN opal:color
;                         (:red (first MOTIF-GREEN-VALUES))
;                         (:green (second MOTIF-GREEN-VALUES))
;                         (:blue (third MOTIF-GREEN-VALUES)))))

;;;  default cursor  (an arrow head)
(create-instance 'opal::ARROW-CURSOR opal:bitmap
  (:image (read-image
	    (merge-pathnames
		"garnet.cursor"
                user::Garnet-Bitmap-PathName  ;; from garnet-loader.lisp
                ))))


(create-instance 'opal::ARROW-CURSOR-MASK opal:bitmap
  (:image (read-image
	    (merge-pathnames
		"garnet.mask"
                user::Garnet-Bitmap-PathName  ;; from garnet-loader.lisp
                ))))



(create-instance 'opal:ARROWHEAD opal:polyline
  (:update-slots '(:visible :fast-redraw-p :point-list
		   :line-style :filling-style :draw-function
		   :head-x :head-y :from-x :from-y :length :diameter :open-p))
  (:head-x 0)
  (:head-y 0)
  (:from-x 0)
  (:from-y 0)
  (:radius (o-formula (/ (gvl :diameter) 2)))
  (:dx (o-formula (- (gvl :from-x) (gvl :head-x))))
  (:dy (o-formula (- (gvl :from-y) (gvl :head-y))))
  (:ftlength (o-formula (let ((dx (gvl :dx))
			      (dy (gvl :dy)))
			  (max 1.0 (sqrt (+ (* dx dx) (* dy dy)))))))
  (:ux (o-formula (/ (gvl :dx) (gvl :ftlength))))
  (:uy (o-formula (/ (gvl :dy) (gvl :ftlength))))
  (:connect-x (o-formula (round (+ (gvl :head-x) (* (gvl :length) (gvl :ux))))))
  (:connect-y (o-formula (round (+ (gvl :head-y) (* (gvl :length) (gvl :uy))))))
  (:ax (o-formula (round (- (gvl :connect-x) (* (gvl :radius) (gvl :uy))))))
  (:ay (o-formula (round (+ (gvl :connect-y) (* (gvl :radius) (gvl :ux))))))
  (:cx (o-formula (round (+ (gvl :connect-x) (* (gvl :radius) (gvl :uy))))))
  (:cy (o-formula (round (- (gvl :connect-y) (* (gvl :radius) (gvl :ux))))))
  (:point-list (o-formula (let ((ax (gvl :ax)) (ay (gvl :ay))
				(head-x (gvl :head-x))
				(head-y (gvl :head-y))
				(cx (gvl :cx)) (cy (gvl :cy)))
			    (if (gvl :open-p)
				(list ax ay head-x head-y cx cy)
				(list ax ay head-x head-y cx cy ax ay)))))
  (:length 10)
  (:diameter 10)
  (:open-p t)
)

;;; To create a window for displaying gobs, create a schema which is an
;;; instance of the window class described below specifying slots as
;;; needed. For example:
;;;
;;; (create-instance my-window opal:window
;;;   (:width 100)
;;;   (:height 100))
;;;
(create-instance 'opal:WINDOW opal:view-object
  (:top 0)
  (:left 0)
  (:width 355)
  (:height 277)
  (:display *default-x-display-name*)
  (:local-only-slots '(:drawable nil) '(:parent nil) '(:window nil))
  (:aggregate)
  (:title)       ; set in :initialize method
  (:icon-title)  ; set in :initialize method
  (:border-width 2)
  (:cursor (o-formula
	    (let ((parent (gvl :parent)))
	      (if parent
		  (gv parent :cursor)
		  (cons opal::arrow-cursor opal::arrow-cursor-mask)))))
  (:ignored-slots :buffer-gc)
  (:update-slots  '(:visible :fast-redraw-p :aggregate :parent
                    :top :left :width :height
                    :cursor :title :icon-title
                    :display)))

;;; Vile, icky, ugly hack to allow fonts to have sizes before being
;;; associated with a aggregate in a window.  Very likely to cause problems
;;; when making a Opal/Garnet core.
;(create-instance 'opal::FONT-HACK-WINDOW opal:window
;  (:visible nil)
;  (:width 0)
;  (:height 0))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;  *-FILL ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(create-instance 'opal::WHITE-FILL opal:filling-style
  (:fill-style :opaque-stippled)
  (:stipple opal::white-fill-bitmap))

(create-instance 'opal::LIGHT-GRAY-FILL opal:filling-style
  (:fill-style :opaque-stippled)
  (:stipple opal::light-gray-fill-bitmap))

(create-instance 'opal::GRAY-FILL opal:filling-style
  (:fill-style :opaque-stippled)
  (:stipple opal::gray-fill-bitmap))

(create-instance 'opal::DARK-GRAY-FILL opal:filling-style
  (:fill-style :opaque-stippled)
  (:stipple opal::dark-gray-fill-bitmap))

(create-instance 'opal::BLACK-FILL opal:filling-style
  (:fill-style :solid))

;; 28-Jul-91 -FER don't need
;(create-instance 'opal::RED-FILL opal:filling-style
;  (:foreground-color opal:red))
;(create-instance 'opal::GREEN-FILL opal:filling-style
;  (:foreground-color opal:green))
;(create-instance 'opal::BLUE-FILL opal:filling-style
;  (:foreground-color opal:blue))
;(create-instance 'opal::YELLOW-FILL opal:filling-style
;  (:foreground-color opal:yellow))
;(create-instance 'opal::ORANGE-FILL opal:filling-style
;  (:foreground-color opal:orange))
;(create-instance 'opal::CYAN-FILL opal:filling-style
;  (:foreground-color opal:cyan))
;(create-instance 'opal::PURPLE-FILL opal:filling-style
;  (:foreground-color opal:purple))


;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/rectintersect.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; CHANGES:
;;;  4-Mar-91 D'Souza Removed nickname "MO" of package Opal.
;;;
(in-package "OPAL" :use '("LISP" "KR"))

;;; Routines for rectangle intersection
;;; Designed and implemented by Brad A. Myers

;;; allocates and returns a struct with the parts of the object
(defun Get-Rect-From-Obj (obj)
  (create-opal-rect (g-cached-value obj :left)(g-cached-value obj :top)
		    (+ (g-cached-value obj :left)(g-cached-value obj :width))
		    (+ (g-cached-value obj :top)(g-cached-value obj :height))))

;;; assigns a struct with the parts of the object
(defun Assign-Rect-From-Obj (obj rect-struct)
  (setf (opal-rect-left rect-struct) (g-cached-value obj :left)
	(opal-rect-top rect-struct) (g-cached-value obj :top)
	(opal-rect-rightp1 rect-struct)
		(+ (g-cached-value obj :left)(g-cached-value obj :width))
	(opal-rect-bottomp1 rect-struct)
		(+ (g-cached-value obj :top)(g-cached-value obj :height))))

;;; Does the object's bounding box intersect with the given rectangle?
;;; Returns T if intersects or NIL if doesn't
(defun Intersect-Obj-with-rect (obj rect-struct)
  (if (or (eql rect-struct :none) (eql rect-struct nil)) nil
      (not (or (or (>= (g-cached-value obj :left)
		       (opal-rect-rightp1 rect-struct))
		   (<= (RightP1obj obj)(opal-rect-left rect-struct)))
	       (or (>= (g-cached-value obj :top)
		       (opal-rect-bottomp1 rect-struct))
		   (<= (BottomP1obj obj)(opal-rect-top rect-struct)))))))

;;; Given an object, adds its rectangle to the rect-struct provided.
;;; Rect-struct and object must both be non-NIL.  The Struct is
;;; destructively modified and returned.  Someone else should make sure
;;; that the object is in the same window that the struct is for.
(defun Add-Obj-To-Rect (obj rect-struct)
  (if (or (eq rect-struct :none) (eq rect-struct nil))
      (Get-Rect-From-Obj obj)
      (progn 
	(setf (opal-rect-left rect-struct)
	      (MIN (opal-rect-left rect-struct) (g-cached-value obj :left)))
	(setf (opal-rect-rightp1 rect-struct)
	      (MAX (opal-rect-rightp1 rect-struct)(RightP1obj obj)))
	(setf (opal-rect-top rect-struct)
	      (MIN (opal-rect-top rect-struct) (g-cached-value obj :top)))
	(setf (opal-rect-bottomp1 rect-struct)
	      (MAX (opal-rect-bottomp1 rect-struct)(BottomP1obj obj)))
	rect-struct)))

#|
;;;;;;;;;;;;;;  The following 2 functions have been eliminated by the TOA slot

;;; Internal function used by search-up-for-overlap-agg.  This one
;;; recursively goes up the aggregate tree looking for the top level
;;; overlapping one.
(defun search-up (obj lastfound)
  (if (null obj) ; then at top
      lastfound
      ; else keep searching
      (if (g-cached-value obj :overlapping) ; if I am overlapping then maybe me
	  (search-up (g-value obj :parent) obj)
	  (search-up (g-value obj :parent) lastfound))))

;;;search up for the highest overlapping aggregate above me.  If there are
;;; none, then return me.
(defun search-up-for-overlap-agg (obj)
  (or (search-up (g-value obj :parent) NIL) obj))
|#

;;; Internal function used by parent-p. This one recursively goes up
;;; the aggregate tree looking for the aggregate named "aggregate"
(defun search-up-for-parent (a-aggregate current-node)
  (cond ((null current-node) ; we are at the top level--aggregate is not a
	 nil)                ; parent of the object given parent-p
	
	((eql a-aggregate current-node) ; we have located aggregate in the
	 t)                           ; aggregate hierarchy

	; keep searching up
	(t (search-up-for-parent a-aggregate (g-value current-node
						      :parent)))))

;;; determine if aggregate is the parent of object
(defun parent-p (a-aggregate object)
  (search-up-for-parent a-aggregate (g-value object :parent)))


;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/update-basics.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;; ______________________________________________________________________
;;;
;;; Changes:
;;; 24-Apr-91 KOZ Patched Set-Display-Slots (see comment in text)
;;; 25-Mar-91 ECP In dovalues loops, use :local t so that we don't
;;;		  inherit values of :components.
;;; 12-Jun-90 BVZ Created clear-dirty-bits
;;;
(in-package "OPAL" :use '("LISP" "KR"))

(setf kr::*pre-set-demon* NIL)	;; NO MORE DEMON HERE!

;;; Called when you write a value of an :update-slots (it may not change)
;;; Used to be called "erase-and-invalidate", a misnomer
(setf kr::*invalidate-demon* 'update-slot-invalidated)

;;; push the slot onto a list of changed slots and push the object
;;; onto its window's changed-objects list

(defun update-slot-invalidated (gob slot save)
  (declare (ignore save))
  (let* ((gob-update-info (get-local-value gob :update-info))
	 (the-window (and gob-update-info
			  (update-info-window gob-update-info))))
  (if the-window
    (if (eq the-window gob)			;; is this a window?
      (pushnew slot (win-update-info-invalid-slots
			(get-local-value the-window :win-update-info)))
      (and (not (update-info-invalid-p gob-update-info))
	   the-window
	   (make-object-invalid gob gob-update-info the-window))
   ))))

;;;
;;; set the window and dirty slots of the object and 
;;; recursively set the same slots in its children
;;;
;;; If this is not at the top-level, this will also set the invalid-p entry
;;; in the :update-info to be NIL.
;;; The "with-demons-disabled" and "mark-window-slots-as-changed" were
;;; added by Koz to fix the following bug:  if you add, then
;;; remove, then add again some gadgets (eg, labeled-box), they would
;;; not appear.  This is because some parts depended on the :window
;;; slot, and so were added to the invalid-objects list of the window
;;; when the following lines were invoked...

(defun mark-window-slots-as-changed (object)
  (mark-as-changed object :window)
  (when (update-info-aggregate-p (get-local-value object :update-info))
    (dovalues (child object :components :local t)
      (mark-window-slots-as-changed child))))

(defun set-display-slots (object a-window dirty-bit &optional (top-level T))
  (let ((update-info (get-local-value object :update-info)))
    (with-demons-disabled
      (s-value object :window
	(setf (update-info-window update-info) a-window)))
    (if dirty-bit
      (when (g-value object :visible)
        (setf (update-info-force-computation-p update-info) T)
	(propagate-dirty-bit object update-info))
      (setf (update-info-dirty-p update-info) NIL))
    (when (update-info-aggregate-p update-info)
      (dovalues (child object :components :local t)
        (set-display-slots child a-window dirty-bit NIL)))
    (if top-level
      (mark-window-slots-as-changed object)
      (setf (update-info-invalid-p update-info) NIL))))

;;;
;;; recursively set the dirty bits of any children to nil
;;;

(defun clear-dirty-bits (agg update-info)
  (setf (update-info-dirty-p update-info) nil)
  (dovalues (child agg :components :local t)
     (let ((child-update-info (get-local-value child :update-info)))
       (when (update-info-dirty-p child-update-info)
	 (clear-dirty-bits child child-update-info)))))

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/halftones.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Change Log:
;;;     date     who    what
;;;     ----     ---    ----
;;;    4-Mar-91  D'Souza  Removed nickname "MO" of package Opal.
;;;   21-Feb-91  Pervin   Changed bitmap images in the halftone-table so that
;;;                       each halftone strictly contains the one before it.
;;;    8-May-90  Sannella The R4 CLX version of xlib:bitmap-image needs
;;;                       arguments like #*1011 instead of '#(1 1 0 1)
;;;   19-Mar-90  Pervin   Changed tile to stipple
;;;   13-Feb-90  Pervin   Implemented color.
;;;   07-Jul-89  Kosbie   Placed these within "WITH-DEMONS-DISABLED"
;;;   15-Jun-89  Kosbie   Added s-values to *-FILL-BITMAPs :image slots after the
;;;			  function "halftone-image" was defined.

(in-package "OPAL" :use '("LISP" "KR"))

(defun halftone-print (s stream ignore)
  (declare (ignore ignore))
  (format stream "#<Halftone ~D>" (halftone-percent s)))


;; 21-Nov-91 -FER made table much smaller
(setf *halftone-table-size* 5)

;;; a bit inelegant, perhaps, but very clear
(defun build-halftone-table ()
  (let ((halftone-table (make-array *halftone-table-size*)))
    (setf (aref halftone-table 0)
	  (make-halftone :percent 0   ;;; 0
			 :x-image (xlib:bitmap-image #*0000
						     #*0000
						     #*0000
						     #*0000)))
;    (setf (aref halftone-table 1)
;          (make-halftone :percent 6   
;                         :x-image (xlib:bitmap-image #*1000
;                                                     #*0000
;                                                     #*0000
;                                                     #*0000)))
;    (setf (aref halftone-table 2)
;          (make-halftone :percent 12 
;                         :x-image (xlib:bitmap-image #*1000
;                                                     #*0000
;                                                     #*0010
;                                                     #*0000)))
;    (setf (aref halftone-table 3)
;          (make-halftone :percent 18
;                         :x-image (xlib:bitmap-image #*1010
;                                                     #*0000
;                                                     #*0010
;                                                     #*0000)))
    (setf (aref halftone-table 1)
	  (make-halftone :percent 25
			 :x-image (xlib:bitmap-image #*1010
						     #*0000
						     #*1010
						     #*0000)))
;    (setf (aref halftone-table 5) 
;          (make-halftone :percent 31
;                         :x-image (xlib:bitmap-image #*1010
;                                                     #*0100
;                                                     #*1010
;                                                     #*0000)))
;    (setf (aref halftone-table 6) 
;          (make-halftone :percent 37
;                         :x-image (xlib:bitmap-image #*1010
;                                                     #*0100
;                                                     #*1010
;                                                     #*0001)))
;
;
;    (setf (aref halftone-table 7) 
;          (make-halftone :percent  43
;                         :x-image (xlib:bitmap-image #*1010
;                                                     #*0101
;                                                     #*1010
;                                                     #*0001)))
    (setf (aref halftone-table 2) 
	  (make-halftone :percent 50
			 :x-image (xlib:bitmap-image #*1010
						     #*0101
						     #*1010
						     #*0101)))
;    (setf (aref halftone-table 9) 
;          (make-halftone :percent 56
;                         :x-image (xlib:bitmap-image #*1010
;                                                     #*0101
;                                                     #*1010
;                                                     #*0111)))
;    (setf (aref halftone-table 10) 
;          (make-halftone :percent 62
;                         :x-image (xlib:bitmap-image #*1010
;                                                     #*1101
;                                                     #*1010
;                                                     #*0111)))
;    (setf (aref halftone-table 11) 
;          (make-halftone :percent 68
;                         :x-image (xlib:bitmap-image #*1010
;                                                     #*1101
;                                                     #*1010
;                                                     #*1111)))
    (setf (aref halftone-table 3) 
	  (make-halftone :percent 75
			 :x-image (xlib:bitmap-image #*1010
						     #*1111
						     #*1010
						     #*1111)))
;    (setf (aref halftone-table 13) 
;          (make-halftone :percent 81
;                         :x-image (xlib:bitmap-image #*1010
;                                                     #*1111
;                                                     #*1011
;                                                     #*1111)))
;    (setf (aref halftone-table 14) 
;          (make-halftone :percent 87
;                         :x-image (xlib:bitmap-image #*1110
;                                                     #*1111
;                                                     #*1011
;                                                     #*1111)))
;    (setf (aref halftone-table 15) 
;          (make-halftone :percent 93
;                         :x-image (xlib:bitmap-image #*1110
;                                                     #*1111
;                                                     #*1111
;                                                     #*1111)))
;
    (setf (aref halftone-table 4) 
	  (make-halftone :percent 100
			 :x-image (xlib:bitmap-image #*1111
						     #*1111
						     #*1111
						     #*1111)))

    halftone-table))


;;; This used to be done by a DefVar, but now the DefVars all occur at
;;; the start of loading Opal, before the function is defined, so we must
;;; Setf it here...
(setf *halftone-table* (build-halftone-table))

;; quick and dirty 
(defun find-halftone (percent halftone-table)
  (if (< percent (halftone-percent (aref halftone-table 0)))
      0
      (do ((i 1 (1+ i))
	   (tone nil))
	  ((>= i *halftone-table-size*) (1- *halftone-table-size*))
	
	;; decide which one is closer to the value desired
	(if (> (halftone-percent (setf tone (aref halftone-table i)))
	       percent)
	    (if (<= (- (halftone-percent tone) percent)
		    (- percent
		       (halftone-percent (aref halftone-table (1- i)))))
		(return-from find-halftone i)
		(return-from find-halftone (1- i)))))))


(defun halftone-image (percent)
  (let ((halftone (aref *halftone-table*
			(find-halftone percent *halftone-table*))))
    (values
     (halftone-x-image halftone)
     (halftone-percent halftone))))

(WITH-DEMONS-DISABLED
	(s-value opal::WHITE-FILL-BITMAP      :image (halftone-image  0))
	(s-value opal::LIGHT-GRAY-FILL-BITMAP :image (halftone-image 25))
	(s-value opal::GRAY-FILL-BITMAP       :image (halftone-image 50))
	(s-value opal::DARK-GRAY-FILL-BITMAP  :image (halftone-image 75)))

#-release-garnet
(defun halftone-image-darker (percent)
  (let ((halftone (aref *halftone-table*
			(min (1- *halftone-table-size*)
			     (1+ (find-halftone percent *halftone-table*))))))
    (values
     (halftone-x-image halftone)
     (halftone-percent halftone))))

#-release-garnet
(defun halftone-image-lighter (percent)
  (let ((halftone (aref *halftone-table*
			(max 0 (1- (find-halftone percent *halftone-table*))))))
    (values
     (halftone-x-image halftone)
     (halftone-percent halftone))))

;;; This takes a list-of-lists, representing the 1's and 0's of the mask of
;;; this filling-style, and creates a filling-style with a :stipple slot set to
;;; a bitmap which has a :image slot set to the x-image resulting from this
;;; mask.

(defun make-filling-style (fname-or-image-list &key
				 (from-file-p NIL)
				 (foreground-color opal:black)
				 (background-color opal:white))
  (let ((result      (create-instance NIL opal:filling-style
		        (:foreground-color foreground-color)
			(:background-color background-color)
			(:fill-style :opaque-stippled)))
	(stipple-entry  (create-instance NIL opal:bitmap))
	(fixed-list  (unless from-file-p
			(mapcar #'(lambda(x) (coerce x 'simple-bit-vector))
			     fname-or-image-list)))
	image)
    (if from-file-p
	(if (probe-file fname-or-image-list)
	  (setq image (read-image fname-or-image-list))
	  (format t "*** Warning: could not find bitmap file ~A~%"
		  fname-or-image-list))
	(setq image (apply 'xlib:bitmap-image fixed-list)))
    (unless image
	(format t "*** Warning: making filling-style ~A with a NIL image!~%"
		result))
    (s-value stipple-entry :image image)
    (s-value result :stipple stipple-entry)
    result
  )
)
;; 28-Jul-91 -FER don't need it
;(setq opal:diamond-fill (make-filling-style '(
;        (1 1 1 1 1 1 1 1 1)
;        (1 1 1 1 0 1 1 1 1)
;        (1 1 1 0 0 0 1 1 1)
;        (1 1 0 0 0 0 0 1 1)
;        (1 0 0 0 0 0 0 0 1)
;        (1 1 0 0 0 0 0 1 1)
;        (1 1 1 0 0 0 1 1 1)
;        (1 1 1 1 0 1 1 1 1)
;	(1 1 1 1 1 1 1 1 1))))

;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/objects.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Changes:
;;; 25-Mar-91 ecp Changed get-values -> get-local-values for :components.
;;;  4-Mar-91 d'souza Removed nickname "MO" of package Opal.
;;; 25-Oct-90 ecp Made get-cursor-index more robust.
;;;  7-Aug-90 ecp In draw method of bitmap, reverted to doing a put-image.
;;; 11-Jul-90 ecp new :destroy-me method
;;; 26-Jun-90 ecp Changed 0 to 0.0 in draw-arc due to temporary xbug.
;;;  1-May-90 ecp Only draw bitmap if :image is not NIL.
;;; 16-Apr-90 ecp Moved center-x, center-y from basics.lisp to objects.lisp
;;; 12-Apr-90 ecp  When rotating a rectangle (which turns it into a polyline)
;;;		   I must reset the :top, :left, :width, :height,
;;;		   :update-slots, and :update-slots-values slots.
;;;		   Rotating anything by an angle of 0 is a noop.
;;; 28-Mar-90 ecp  New slot :already-tried-to-destroy added to objects
;;;		   to avoid destroying twice.
;;; 23-Mar-90 ecp  New slot :fill-background-p for text objects.
;;; 19-Mar-90 ecp  Changed tile to stipple.
;;; 14-Mar-90 ecp  Get-index much more accurate.
;;; 13-Feb-90 ecp  Finally merged objects.lisp with the
;;;		   "temporary" file eds-objects.lisp
;;;  5-Dec-89 ecp  Removed a declare from draw-method for rectangle.
;;;

(in-package "OPAL" :use '("LISP" "KR"))
(proclaim '(declaration values))

;;; This is called by the destroy methods.  It will carefully erase an object,
;;; or return NIL if it could not do so (some values were illegal, etc..)
;;; Note:  object is not *actually* erased, but its bbox is simply added to
;;; its enclosing window's bbox -- you must call (update <that-window>)
(defun carefully-erase (object the-window)
 (let* ((update-info (get-local-value object :update-info))
        (old-bbox    (if (update-info-p update-info)
                          (update-info-old-bbox update-info)))
        (object-erased T)
        window-bbox win-uinfo)
  (if the-window
      (cond ((not (bbox-p old-bbox))       ;; if bbox isn't there, ie,something
                (setq object-erased NIL))  ;; broke, then we can't erase it!
            ((not (bbox-valid-p old-bbox)) ;; If it wasn't visible, do nothing
                NIL)
                                        ;; now check if all entries are numbers
            ((not (and (numberp (bbox-x1 old-bbox))
                       (numberp (bbox-y1 old-bbox))
                       (numberp (bbox-x2 old-bbox))
                       (numberp (bbox-y2 old-bbox))))
                (setq object-erased NIL)) ;; if not, couldn't erase it
                                        ;; now make sure window's old-bbox is
                                        ;; not destroyed...
            ((or (not (update-info-p (setq win-uinfo
                                               (get-local-value the-window
                                                          :update-info))))
                 (not (bbox-p (setq window-bbox
                                        (update-info-old-bbox win-uinfo)))))
                (setq object-erased NIL)) ;; if not, couldn't erase it
                                        ;; Finally, we know we can erase it!
            (T
                (merge-bbox window-bbox old-bbox)))
    (setq object-erased NIL))           ;; No window, so couldn't erase it!
  object-erased))

(define-method :destroy-me opal:view-object (object &optional (top-level-p T))
 (if object
  (let* ((the-window (g-value object :window))
	 (parent  (get-local-value object :parent))
	 (erase-p (and top-level-p the-window parent
		    (not (get-local-value object :already-tried-to-destroy)))))
    (when (and top-level-p parent)
	(setf (get-local-values parent :components)
	   (delete object (get-local-values parent :components)))
	(mark-as-changed parent :components))
    (s-value object :already-tried-to-destroy t)
    (if erase-p
	(update the-window (not (carefully-erase object the-window))))
    (destroy-schema object))))

(define-method :destroy opal:view-object (object &optional (top-level-p T))
  (dolist (instance (copy-list (get-local-values object :is-a-inv)))
    (destroy instance top-level-p))
  (destroy-me object top-level-p))

;;; Lines
(define-method :initialize opal:line (gob)
  (call-prototype-method gob))

(define-method :draw opal:line (gob line-style-gc filling-style-gc
				drawable root-window clip-mask)
  (declare (ignore filling-style-gc))
  (let* ((xlib-gc-line (opal-gc-gcontext line-style-gc))
	 (update-vals  (get-local-value gob :update-slots-values))
	 (x-draw-fn    (get (aref update-vals *line-draw-function*)
			    :x-draw-function)))
  (with-line-styles ((aref update-vals *line-lstyle*) line-style-gc
		     xlib-gc-line root-window x-draw-fn clip-mask)
    (xlib:draw-line drawable
		    xlib-gc-line
		    (aref update-vals *line-x1*)
		    (aref update-vals *line-y1*)
		    (aref update-vals *line-x2*)
		    (aref update-vals *line-y2*)))))

;;; Calculate approximate distance to the line by using similar triangles
;;; to calculate the point on the horozontal (or vertical) that the query
;;; point shares for mostly vertical (or horozontal) lines.
;;; 
(define-method :point-in-gob opal:line (gob x y)
 (and (g-value gob :visible)
  (let ((x1 (g-value gob :x1))
	(x2 (g-value gob :x2))
	(y1 (g-value gob :y1))
	(y2 (g-value gob :y2))
	(threshold (max (g-value gob :hit-threshold)
			(ceiling (get-thickness gob) 2))))
    (when (and (<= (- (min x1 x2) threshold) x (+ (max x1 x2) threshold))
	       (<= (- (min y1 y2) threshold) y (+ (max y1 y2) threshold)))
      (let* ((a (- y1 y2))                 ; equation for line is
	     (b (- x2 x1))                 ;  ax + by + c = 0
	     (c (- (* x1 y2) (* x2 y1)))
	     (d (+ (* a x) (* b y) c)))    ; d/sqrt(a^2+b^2) is the distance
	(<= (* d d)                        ; between line and point <x,y>
	    (* threshold threshold (+ (* a a) (* b b)))))))))

;;; The following functions allow access and setting to the gobs center
;;; position.

(defun center-x (gob)
  (+ (g-value gob :left) (truncate (g-value gob :width) 2)))

(defun center-y (gob)
  (+ (g-value gob :top) (truncate (g-value gob :height) 2)))

#-release-garnet
(define-method :rotate opal:line (gob angle &optional (center-x (center-x gob))
				(center-y (center-y gob)))
 (unless (zerop angle)
  (let* ((x1 (g-value gob :x1))
	 (x2 (g-value gob :x2))
	 (y1 (g-value gob :y1))
	 (y2 (g-value gob :y2))
	 (rx1 (- x1 center-x))
	 (ry1 (- y1 center-y))
	 (rx2 (- x2 center-x))
	 (ry2 (- y2 center-y))
	 (cos-angle (cos angle))
	 (sin-angle (sin angle)))
    (setf (g-value gob :x1)
	  (round (+ center-x (* rx1 cos-angle) (* -1 ry1 sin-angle))))
    (setf (g-value gob :y1)
	  (round (+ center-y (* ry1 cos-angle) (* rx1 sin-angle))))
    (setf (g-value gob :x2)
	  (round (+ center-x (* rx2 cos-angle) (* -1 ry2 sin-angle))))
    (setf (g-value gob :y2)
	  (round (+ center-y (* ry2 cos-angle) (* rx2 sin-angle)))))))


;;; Currently we use the point-in-gob method defined for gobs, not the
;;; best, but Dario has code for better ones that I will parasitize at a
;;; later time.

;;; Rectangles
(define-method :draw opal:rectangle (gob line-style-gc filling-style-gc
				     drawable root-window clip-mask)
  (let* ((update-vals (get-local-value gob :update-slots-values))
	 (left (aref update-vals *rect-left*))
	 (top (aref update-vals *rect-top*))
	 (width (aref update-vals *rect-width*))
	 (height (aref update-vals *rect-height*))
	 (min-width-height (min width height))
	 (x-draw-fn (get (aref update-vals *rect-draw-function*)
			 :x-draw-function))
	 (thickness (get-thickness gob))
	 (xlib-gc-line (opal-gc-gcontext line-style-gc))
	 (xlib-gc-filling (opal-gc-gcontext filling-style-gc)))
    (when (plusp min-width-height)  ; only draw if width, height > 0
      (if (>= (* 2 thickness) min-width-height) ; if rectangle too small,
	                                        ; just draw solid rectangle
	    (xlib:with-gcontext (xlib-gc-line :fill-style :solid
				 :function boole-1
				 :clip-mask clip-mask)
	      (xlib:draw-rectangle drawable xlib-gc-line
				left top width height t))
	  (let ((half-thickness (truncate thickness 2)))
	    (with-filling-styles ((aref update-vals *rect-fstyle*)
				  filling-style-gc xlib-gc-filling
				  root-window x-draw-fn clip-mask)
              (xlib:draw-rectangle drawable
				   xlib-gc-filling
				   (+ left thickness )
				   (+ top thickness)
				   (- width (* 2 thickness))
				   (- height (* 2 thickness))
				   t))
	    (with-line-styles ((aref update-vals *rect-lstyle*) line-style-gc
			       xlib-gc-line root-window x-draw-fn clip-mask)
              (xlib:draw-rectangle drawable
				   xlib-gc-line
				   (+ left half-thickness)
				   (+ top half-thickness)
				   (- width thickness)
				   (- height thickness)
				   nil)))))))

(define-method :point-in-gob opal:rectangle (gob x y)
 (and (g-value gob :visible)
  (let* ((thickness (get-thickness gob))
	 (width (g-value gob :width))
	 (height (g-value gob :height))
	 (select-outline-only (g-value gob :select-outline-only))
	 (threshold (max 0 (- (g-value gob :hit-threshold)
			      (truncate (if select-outline-only
					    thickness
					    (max width height))
					2))))
	 (left (g-value gob :left))
	 (top (g-value gob :top))
	 (right (+ left width))
	 (bottom (+ top height)))
    (and (point-in-rectangle x y (- left threshold) (- top threshold) 
			     (+ right threshold) (+ bottom threshold))
	 (not (and select-outline-only
		   (point-in-rectangle x y
				       (+ left thickness threshold)
				       (+ top thickness threshold)
				       (- right thickness threshold)
				       (- bottom thickness threshold))))))))

;;; The rotate method for rectangles has the sometimes nasty side effect of
;;; turning the rectangle into a polygon.

(define-method :rotate opal:rectangle (gob angle &optional
					   (center-x (center-x gob))
					   (center-y (center-y gob)))
  (unless (zerop angle)
    (let* ((top (g-value gob :top))
	   (left (g-value gob :left))
	   (right (+ left (g-value gob :width)))
	   (bottom (+ top (g-value gob :height))))
      ; convert into polyline and build point list.
      (s-value gob :is-a opal:polyline)
      (s-value gob :point-list 
	       (list left bottom right bottom right top left top left bottom))
      ; rebuild :top, :left, :width, :height slots
      (dolist (slot '(:top :left :width :height))
	(kr:destroy-slot gob slot))
      (kr::copy-down-formulas gob)	
      ; rebuild :update-slots and :update-slots-values slots
      (s-value gob :update-slots (g-value opal:polyline :update-slots))
      (s-value gob :update-slots-values nil)
      ; do the actual rotation
      (rotate gob angle center-x center-y))))

(defun point-in-ellipse (x y cx cy rx ry)
; Tells whether point <x,y> lies in ellipse with center <cx,cy>,
; horizontal radius rx and vertical radius ry
  (and (> rx 0)
       (> ry 0)
       (let ((dx (- cx x))
	     (dy (- cy y)))
	 (< (+ (* rx rx dy dy) (* ry ry dx dx)) (* rx rx ry ry)))))

;;; Multipoint objects
;;; 

;;; For a raw multipoint, just draw the points, all unimplimented
;;; multipoints inherit this method.
;;; 
(define-method :draw opal:multipoint (gob line-style-gc filling-style-gc
				      drawable root-window clip-mask)
  (declare (ignore filling-style-gc))
  (let* ((update-vals  (get-local-value gob :update-slots-values))
	 (xlib-gc-line (opal-gc-gcontext line-style-gc))
	 (x-draw-fn    (get (aref update-vals *multi-draw-function*)
			   :x-draw-function)))
     (with-line-styles ((aref update-vals *multi-lstyle*) line-style-gc
			xlib-gc-line root-window x-draw-fn clip-mask)
      (xlib:draw-points drawable xlib-gc-line
	(aref update-vals *multi-point-list*)))))

;; we don't use this in the dsi so far... 21-Jul-91 - FER
;(define-method :rotate opal:multipoint (gob angle &optional
;                                        (center-x (center-x gob))
;                                        (center-y (center-y gob)))
;  "rotates a multipoint object about (center-x,center-y) by angle radians"
; (unless (zerop angle)
;  (let ((sin-angle (sin angle))
;        (cos-angle (cos angle)))
;      (do ((point (g-value gob :point-list) (cddr point)))
;          ((null point) (kr:mark-as-changed gob :point-list))
;        (let ((rx (- (car point) center-x))
;              (ry (- (cadr point) center-y)))
;          (setf (car point)
;                (round (+ center-x (* rx cos-angle) (* -1 ry sin-angle))))
;          (setf (cadr point)
;                (round (+ center-y (* ry cos-angle) (* rx sin-angle)))))))))


;;; Polyline objects
;;; 

(define-method :draw opal:polyline (gob line-style-gc filling-style-gc
				    drawable root-window clip-mask)
  (let* ((update-vals (get-local-value gob :update-slots-values))
	 (xlib-gc-line (opal-gc-gcontext line-style-gc))
	 (xlib-gc-filling (opal-gc-gcontext filling-style-gc))
	 (point-list (aref update-vals *polyline-point-list*))
	 (x-draw-fn (get (aref update-vals *polyline-draw-function*)
			 :x-draw-function)))
    (with-filling-styles ((aref update-vals *polyline-fstyle*) filling-style-gc
			  xlib-gc-filling root-window x-draw-fn clip-mask)
      (xlib:draw-lines drawable xlib-gc-filling point-list :fill-p t))
    (with-line-styles ((aref update-vals *polyline-lstyle*) line-style-gc
		       xlib-gc-line root-window x-draw-fn clip-mask)
      (xlib:draw-lines drawable xlib-gc-line point-list))))

;;; Text and Fonts

(define-method :draw opal:text (gob line-style-gc filling-style-gc
				    drawable root-window clip-mask)
  (declare (ignore filling-style-gc))
  (let* ((update-vals (get-local-value gob :update-slots-values))
	 (xfont (aref update-vals *text-xfont*))
	 (xlib-gc-line (opal-gc-gcontext line-style-gc))
	 (text-extents (aref update-vals *text-text-extents*)))
    (with-line-styles ((aref update-vals *text-lstyle*) line-style-gc
		       xlib-gc-line root-window
		       (get (aref update-vals *text-draw-function*)
			    :x-draw-function)
		       clip-mask)
     (set-gc line-style-gc xlib-gc-line :font xfont)
     (if (aref update-vals *text-fill-background-p*)
         (xlib:draw-image-glyphs drawable
		       xlib-gc-line
		       (+ (* -1 (the-left-bearing text-extents))
			  (aref update-vals *text-left*))
		       (+ (aref update-vals *text-top*)
			  (if (aref update-vals *text-actual-heightp*)
			      (the-actual-ascent text-extents)
			      (xlib:max-char-ascent xfont)))
		       (aref update-vals *text-string*))
         (xlib:draw-glyphs drawable
		       xlib-gc-line
		       (+ (* -1 (the-left-bearing text-extents))
			  (aref update-vals *text-left*))
		       (+ (aref update-vals *text-top*)
			  (if (aref update-vals *text-actual-heightp*)
			      (the-actual-ascent text-extents)
			      (xlib:max-char-ascent xfont)))
		       (aref update-vals *text-string*))))))

(defun string-width (fnt str)
  (xlib:text-width (font-to-xfont fnt *default-x-display*) str))

(defun string-height (fnt str &key (actual-heightp nil))
  (let ((xfont (font-to-xfont fnt *default-x-display*)))
    (if actual-heightp
	(multiple-value-bind (ignore ascent descent)
			     (xlib:text-extents xfont str)
	  (declare (ignore ignore))
	  (+ ascent descent))
	(+ (xlib:max-char-ascent xfont)
	   (xlib:max-char-descent xfont)))))

(defun sign (n) (if (eq n 0) 0 (/ n (abs n))))

;; Given a string written in a certain font, find the index of the string
;; so that the xlib:text-width of (subseq str 0 index) is closest to
;; target.
(defun get-index (str fnt target)
  (let ((string-width (xlib:text-width fnt str))
	(string-length (length str)))
    (cond ((<= target 0) 0)
	  ((>= target string-width) string-length)
	  (t (if (= (xlib:max-char-width fnt)
		    (xlib:min-char-width fnt)) ;fixed width
		 (round target (xlib:max-char-width fnt))
		 (dotimes (n string-length)
		   (let ((low (xlib:text-width fnt (subseq str 0 n)))
			 (high (xlib:text-width fnt (subseq str 0 (1+ n)))))
		     (when (<= low target high)
		       (return (if (> (- target low) (- high target))
				   (1+ n)
				   n))))))))))

(defun get-cursor-index (txt x y)
  #-release-garnet
  "Given an object of type opal:text and two coordinates x and y, returns
   the index of the character in (g-value txt :string) that the point lies
   on."
  (when (point-in-gob txt x y)
    (let ((fnt (g-value txt :xfont))
	  (cut-strings (g-value txt :cut-strings)))
      (if cut-strings   ; multi-text
	  (let* ((line-number (max 0
				(min (1- (length cut-strings))
		                  (floor (- y (g-value txt :top))
				         (+ (xlib:max-char-ascent fnt)
					    (xlib:max-char-descent fnt))))))
		 (cut-string (nth line-number cut-strings))
		 (relative-index 0))
	    (dotimes (i line-number)
	      (incf relative-index
		    (1+ (length (cut-string-string (nth i cut-strings))))))
	    (+ relative-index
	       (get-index (cut-string-string cut-string)
			  fnt
			  (- x
			     (g-value txt :left)
			     (case (g-value txt :justification)
			       (:right (- (g-value txt :width)
					  (cut-string-width cut-string)))
			       (:center
				(floor (- (g-value txt :width)
					  (cut-string-width cut-string))
				       2))
			       (t 0))))))
	  (get-index (g-value txt :string) fnt
		     (- x (g-value txt :left)))))))

;;; Bitmaps

(define-method :draw opal:bitmap (gob line-style-gc filling-style-gc
				  drawable root-window clip-mask)
  (declare (ignore filling-style-gc))
  (let* ((update-vals (get-local-value gob :update-slots-values))
	 (xlib-gc-line (opal-gc-gcontext line-style-gc))
	 (x-draw-fn  (get (aref update-vals *bm-draw-function*)
			 :x-draw-function))
	 (image (aref update-vals *bm-image*)))
   (when image
    (with-line-styles ((aref update-vals *bm-lstyle*) line-style-gc
		       xlib-gc-line root-window x-draw-fn clip-mask)
     (xlib::put-image drawable xlib-gc-line
		     image
		     :x (aref update-vals *bm-left*)
		     :y (aref update-vals *bm-top*)
		     :width (xlib:image-width image)
		     :height (xlib:image-height image)
		     :bitmap-p t))
     )))

(define-method :initialize opal:bitmap (gob)
  (call-prototype-method gob))


;;; Arcs
(define-method :draw opal:arc (gob line-style-gc filling-style-gc
			       drawable root-window clip-mask)
 (let* ((update-vals (get-local-value gob :update-slots-values))
	(x-draw-fn  (get (aref update-vals *arc-draw-function*)	
			 :x-draw-function))
	(left       (aref update-vals *arc-left*))
	(top        (aref update-vals *arc-top*))
	(width      (aref update-vals *arc-width*))
	(height     (aref update-vals *arc-height*))
	(angle1     (aref update-vals *arc-angle1*))
	(angle2     (aref update-vals *arc-angle2*))
	(xlib-gc-line (opal-gc-gcontext line-style-gc))
	(xlib-gc-fill (opal-gc-gcontext filling-style-gc))
       )
   (with-filling-styles ((aref update-vals *arc-fstyle*) filling-style-gc
			 xlib-gc-fill root-window x-draw-fn clip-mask)
     (xlib:draw-arc drawable xlib-gc-fill left top width height
		    angle1 angle2 t))
   (with-line-styles ((aref update-vals *arc-lstyle*) line-style-gc
		      xlib-gc-line root-window x-draw-fn clip-mask)
     (xlib:draw-arc drawable xlib-gc-line left top width height
		    angle1 angle2 nil))))

;; 28-Jul-91 -FER
;(define-method :rotate opal:arc (gob &optional center-x center-y)
;  (declare (ignore gob center-x center-y))
;  "This isn't a trivial computation, so we aren't going to do it at all.")

;;;   Ovals

;(define-method :draw opal:oval (gob line-style-gc filling-style-gc
;                                drawable root-window clip-mask)
; (let* ( (update-vals (get-local-value gob :update-slots-values))
;         (x-draw-fn  (get (aref update-vals *arc-draw-function*)
;                          :x-draw-function))
;         (left (aref update-vals *arc-left*))
;         (top  (aref update-vals *arc-top*))
;         (width  (aref update-vals *arc-width*))
;         (height (aref update-vals *arc-height*))
;         (xlib-gc-line (opal-gc-gcontext line-style-gc))
;         (xlib-gc-fill (opal-gc-gcontext filling-style-gc))
;         (thickness (get-thickness gob))
;         (fill-width (- width (* 2 thickness)))
;         (fill-height (- height (* 2 thickness))))
;    (when (and (plusp width) (plusp height)) ; only draw if width, height > 0
;      (if (or (< fill-width 1) (< fill-height 1)) ; if oval too small,
;                                                  ; just draw black oval
;            (xlib:with-gcontext (xlib-gc-line
;                               :fill-style :solid
;                               :function boole-1)
;              (xlib:draw-arc drawable xlib-gc-line
;                             left top width height 0.0 *twopi* t))
;          (let ((half-thickness (floor thickness 2))
;                (w-mod-2 (mod width 2))
;                (h-mod-2 (mod height 2))
;                (t-mod-2 (mod thickness 2)))
;            (with-filling-styles ((aref update-vals *arc-fstyle*)
;                                  filling-style-gc xlib-gc-fill root-window
;                                  x-draw-fn clip-mask)
;              (xlib:draw-arc drawable
;                             xlib-gc-fill
;                             (+ left thickness)
;                             (+ top thickness)
;                             fill-width fill-height
;                             0.0 *twopi* t))
;            (with-line-styles ((aref update-vals *arc-lstyle*) line-style-gc
;                               xlib-gc-line root-window x-draw-fn clip-mask)
;              (xlib:draw-arc drawable
;                             xlib-gc-line
;                             (+ left half-thickness
;                                (aref *left-adjustment* w-mod-2 h-mod-2 t-mod-2))
;                             (+ top half-thickness
;                                (aref *top-adjustment* w-mod-2 h-mod-2 t-mod-2))
;                             (- width thickness
;                                (aref *width-adjustment* w-mod-2 h-mod-2 t-mod-2))
;                             (- height thickness
;                                (aref *height-adjustment* w-mod-2 h-mod-2 t-mod-2))
;                             0.0 *twopi*)))))))
;
;
;(define-method :point-in-gob opal:oval (gob x y)
; (and (g-value gob :visible)
;  (let* ((rx (/ (g-value gob :width) 2))
;         (ry (/ (g-value gob :height) 2))
;         (thickness (get-thickness gob))
;         (threshold (max 0 (- (g-value gob :hit-threshold)
;                              (/ thickness 2))))
;         (outer-rx (+ rx threshold))
;         (outer-ry (+ ry threshold))
;         (cx (center-x gob))
;         (cy (center-y gob)))
;    (and (point-in-ellipse x y cx cy outer-rx outer-ry)
;         (not (and (g-value gob :select-outline-only)
;                   (let ((inner-rx (- rx thickness threshold))
;                         (inner-ry (- ry thickness threshold)))
;                     (point-in-ellipse x y cx cy inner-rx inner-ry))))))))
;           


;;; Circles

(define-method :initialize opal:circle (gob)
  (call-prototype-method gob))

(define-method :draw opal:circle (gob line-style-gc filling-style-gc	
				  drawable root-window clip-mask)
 (let* ( (update-vals (get-local-value gob :update-slots-values))
	 (x-draw-fn (get (aref update-vals *circle-draw-function*)
			 :x-draw-function))
         (left (aref update-vals *circle-left*))
	 (top  (aref update-vals *circle-top*))
	 (width (aref update-vals *circle-width*))
	 (height (aref update-vals *circle-height*))
	 (xlib-gc-line (opal-gc-gcontext line-style-gc))
	 (xlib-gc-fill (opal-gc-gcontext filling-style-gc))
	 (thickness (get-thickness gob))
	 (diameter (min width height))
	 (fill-diameter (- diameter (* 2 thickness))))
    (when (plusp diameter)         ;don't draw anything unless diameter > 0
      (if (not (plusp fill-diameter))           ; if circle is too small,
	                                        ; just draw black circle
	    (xlib:with-gcontext (xlib-gc-line
			       :fill-style :solid
			       :function boole-1)
	      (xlib:draw-arc drawable xlib-gc-line
				left top diameter diameter 0.0 *twopi* t))
	  (let ((half-thickness (truncate thickness 2))
		(d-mod-2 (mod diameter 2))
		(t-mod-2 (mod thickness 2)))              
	    (with-filling-styles ((aref update-vals *circle-fstyle*)
				  filling-style-gc xlib-gc-fill root-window
				  x-draw-fn clip-mask)
	      (xlib:draw-arc drawable
			     xlib-gc-fill
			     (+ left thickness)
			     (+ top thickness)
			     fill-diameter fill-diameter
			     0.0 *twopi* t))
	    (with-line-styles ((aref update-vals *circle-lstyle*) line-style-gc
			       xlib-gc-line root-window x-draw-fn clip-mask)
	      (xlib:draw-arc drawable
			     xlib-gc-line
			     (+ left half-thickness
				(aref *left-adjustment* d-mod-2 d-mod-2 t-mod-2))
			     (+ top half-thickness
				(aref *top-adjustment* d-mod-2 d-mod-2 t-mod-2))
			     (- diameter thickness
				(aref *width-adjustment* d-mod-2 d-mod-2 t-mod-2))
			     (- diameter thickness
				(aref *height-adjustment* d-mod-2 d-mod-2 t-mod-2))
			     0.0 *twopi*)))))))


(define-method :point-in-gob opal:circle (gob x y)
 (and (g-value gob :visible)
  (let* ((r (/ (min (g-value gob :width)
		    (g-value gob :height)) 2))
	 (thickness (get-thickness gob))
	 (threshold (max 0 (- (g-value gob :hit-threshold)
			      (/ thickness 2))))
	 (outer-r (+ r threshold))
	 (cx (center-x gob))
	 (cy (center-y gob)))
    (and (point-in-ellipse x y cx cy outer-r outer-r)
	 (not (and (g-value gob :select-outline-only)
		   (let ((inner-r (- r thickness threshold)))
		     (point-in-ellipse x y cx cy inner-r inner-r))))))))




;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/basics.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Changes:
;;; 19-Jun-90 ecp New functions gv-center-x-is-center-of, gv-center-y-is-center-of,
;;;		  gv-right-is-left-of, gv-bottom-is-top-of.
;;;  5-Jun-90 dzg Changed update-info structure to reduce storage allocation.
;;; 16-Apr-90 ecp Moved center-x, center-y from basics.lisp to objects.lisp
;;; 19-Mar-90 ecp Changed :tile to :stipple
;;; 13-Feb-90 dzg Changed certain macros to defuns.
;;;               Added new arguments to halftone (for color).

(in-package "OPAL" :use '("LISP" "KR"))

;;; The following allow access and setting to the gobs center
;;; position.

#-release-garnet
(defun center (gob)
  (values (center-x gob) (center-y gob)))

;;; The accessors for the bottom and right of the gob, make it easier to
;;; adjust the far side of the gob's bounding box.
;;; Used to be macros, but were changed to defuns for efficiency.

(defun bottom (gob)
  (1- (+ (g-value gob :top) (g-value gob :height))))

(defun right (gob)
  (1- (+ (g-value gob :left) (g-value gob :width))))

(defun gv-bottom (gob)
  (1- (+ (gv gob :top) (gv gob :height))))

(defun gv-right (gob)
  (1- (+ (gv gob :left) (gv gob :width))))

(defun gv-center-x (gob)
  (+ (gv gob :left) (truncate (gv gob :width) 2)))

(defun gv-center-y (gob)
  (+ (gv gob :top) (truncate (gv gob :height) 2)))

;;; For formulas that want to set an object's center, right or bottom.

; Gives the value for :left such that (gv-right :self) equals (gv gob :left)
#-release-garnet
(defun gv-right-is-left-of (gob)
  (- (gv gob :left) (gvl :width)))

; Gives the value for :top such that (gv-bottom :self) equals (gv gob :top)
#-release-garnet
(defun gv-bottom-is-top-of (gob)
  (- (gv gob :top) (gvl :height)))

; Gives the value for :left such that (gv-center-x :self) equals (gv-center-x gob)
(defun gv-center-x-is-center-of (gob)
  (- (gv-center-x gob) (truncate (gvl :width) 2)))

; Gives the value for :top such that (gv-center-y :self) equals (gv-center-y gob)

(defun gv-center-y-is-center-of (gob)
  (- (gv-center-y gob) (truncate (gvl :height) 2)))

;;; bounding-box just returns the current cached value of the bounding box
;;; as four values (top left width height)
(defun bounding-box (gob)
  (values (g-value gob :left) (g-value gob :top)
	  (g-value gob :width) (g-value gob :height)))

;;; Unified setting methods
;;;
;;; These set more than one property of a gob, and may be much faster than
;;; calling numerous methods.

;;;
;;; Currently they aren't.
#-release-garnet
(defun set-center (gob x y)
  (setf (center-x gob) x)
  (setf (center-y gob) y))


(defun set-position (gob left top)
  (setf (g-value gob :left) left)
  (setf (g-value gob :top) top))

#-release-garnet
(defun set-size (gob width height)
  (setf (g-value gob :width) width)
  (setf (g-value gob :height) height))

(defun set-bounding-box (gob left top width height)
  (set-size gob width height)
  (set-position gob left top))


;;; Methods on view objects
;;; This sets up the update-info slot (allocates memory for it), and then
;;; copies down the :update-slots value to make it local.
(define-method :initialize opal:view-object (gob)
  (let ((temp-info (make-update-info))
	(update-slots (g-value gob :update-slots)))
    (setf (update-info-bits temp-info) 0)
    (setf (update-info-old-bbox temp-info) (make-bbox))
    (s-value gob :update-info temp-info)
    (s-value gob :update-slots update-slots)
    (unless (g-value gob :fast-redraw-p)
	(s-value gob :fast-redraw-p NIL))
  ))


;;; Methods on graphical objects

;;; Initialize sets up the default values of objects
(define-method :initialize opal:graphical-object (gob)
  (call-prototype-method gob)
  ;; This is not an aggregate!  Used by update algorithm for efficiency
  (setf (update-info-aggregate-p (get-local-value gob :update-info)) NIL))

(define-method :point-in-gob opal:view-object (gob x y)
 (and (g-value gob :visible)
  (let ((top (g-value gob :top))
	(left (g-value gob :left))
	(width (g-value gob :width))
	(height (g-value gob :height))
	(hit (g-value gob :hit-threshold)))
    (and (>= x (- left hit))
	 (< x (+ left width hit))
	 (>= y (- top hit))
	 (< y (+ top height hit))))))

(defun set-draw-functions ()
  (dolist (fn-pair *function-alist*)
    (setf (get (car fn-pair) :x-draw-function) (cdr fn-pair))))

(set-draw-functions)

(defun assign-draw-function (f n)
  (let ((pair (assoc f *function-alist*)))
    (when pair
	(setf (get f :x-draw-function) n)
	(rplacd pair n))))


;;; Halftone creation functions
(defun halftone (percent &key (foreground-color opal:black)
			      (background-color opal:white))
  (multiple-value-bind (image real-p)
		       (halftone-image percent)
    (values
     (create-instance nil opal:filling-style
       (:foreground-color foreground-color)
       (:background-color background-color)
       (:fill-style :opaque-stippled)
       (:stipple (create-instance NIL opal:bitmap
		(:image image))))
     real-p)))

#-release-garnet
(defun halftone-darker (percent)
  (multiple-value-bind (image real-p)
		       (halftone-image-darker percent)
    (values
     (create-instance nil opal:filling-style
       (:fill-style :opaque-stippled)
       (:stipple (create-instance NIL opal:bitmap
		(:image image))))
     real-p)))

#-release-garnet
(defun halftone-lighter (percent)
  (multiple-value-bind (image real-p)
		       (halftone-image-lighter percent)
    (values
     (create-instance nil opal:filling-style
       (:fill-style :opaque-stippled)
       (:stipple (create-instance NIL opal:bitmap
		(:image image))))
     real-p)))


;;; Concatenated from type module "opal" module-version "f1.4".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/garnet/1.4/src/opal/f1.4/aggregates.lisp".
;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: OPAL; Base: 10 -*-
;;;
;;; ______________________________________________________________________
;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet Project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;; ______________________________________________________________________
;;;
;;; Changes:
;;; 3/25/91 Pervin - Added :local t to dovalues loop.
;;; 3/4/91  D'Souza - Removed nickname "MO" of package Opal.
;;; 7/11/90 Ed Pervin - new :destroy-me method
;;; 6/1/90   RBD Fixed add-component to accept :head :tail :after :before
;;; 5/20/90  BVZ Changed g-value to g-local-value in add-component
;;;              to fix window bug.
;;; 5/8/90   Mike Sannella
;;;              Do-Components and Do-All-Components were ignoring
;;;              their :type argument.
;;; 3/6/90   ECP Allowed point-to-leaf, point-to-component,
;;;              do-components, and do-all-components to accept
;;;              a list of types as the argument to :type.
;;; 1/2/90   RBD Corrected a misplaced parenthesis in add-component.
;;;              Also, in add-component, replaced calls to append-value
;;;		 by calls to nconc.
;;; 12/11/89 ECP Point-to-leaf was returning T when :type was aggregate.

(in-package "OPAL" :use '("LISP" "KR"))

;;; Aggregate objects

;;; Aggregates allow for a group of graphical-objects to be associated
;;; together to form a new, more complex object.
;;; 
;;; An implementation detail:
;;; The children of a gob are stored in a list from bottom most to top
;;; most, since we want to redraw fastest and redraws occur from bottom to
;;; top.

;;; Methods on aggregates:

;;; Initialize
;;; 
;;; The :aggregate-p slot is used by the update algorithm for efficiency
(define-method :initialize opal:aggregate (a-aggregate)
  (call-prototype-method a-aggregate)
  (let ((components (get-local-values a-aggregate :components)))
    (setf (get-local-values a-aggregate :components) nil)
    (dolist (child components)
      (unless (g-local-value child :parent)
	(add-component a-aggregate child :where :front)))
    (setf (update-info-aggregate-p (get-local-value a-aggregate :update-info))
	  T)))

;;; Destroy method
;;; 
;;; If top-level-p is true, then you must erase the aggregate (carefully!).
;;; Otherwise, we can presume that the calling party has already gone
;;; through the trouble of erasing the aggregate.
;;; If, while trying to erase the aggregate, we hit illegal values, then the
;;; window will be updated fully (after the destroy).

(define-method :destroy-me opal:aggregate (a-aggregate &optional (top-level-p T))
 (if a-aggregate
   (let* ((the-window (g-local-value a-aggregate :window))
	  (erase-p (and top-level-p the-window))
	  (parent  (get-local-value a-aggregate :parent))
	  total-update-p)
    (if erase-p				;; If at top-level, then erase...
	(if (null parent)
	 (if (eq a-aggregate (g-value the-window :aggregate))
	   (s-value the-window :aggregate NIL)
	   (progn
(format t "~%Warning in Destroy: aggregate '~A' has no parent,~%" a-aggregate)
(format t   "        is in window '~A', but is not that window's :aggregate.~%"
		the-window)
	     (setq erase-p NIL)))
	 (setq total-update-p (not (carefully-erase a-aggregate the-window)))))
    (dolist (component (copy-list (get-local-values a-aggregate :components)))
      (when (schema-p component)
	(destroy component NIL)))
    (when (and top-level-p parent)
	(setf (get-local-values parent :components)
	  (delete a-aggregate (get-local-values parent :components)))
	(mark-as-changed parent :components))
    (destroy-schema a-aggregate)
    (if erase-p
	(update the-window total-update-p)))))


;;; Add-Component adds gob to aggregate covering according to the arguments of
;;; the where keyword argument.  Note that the :where keyword is now OPTIONAL.
;;; 
;;; Options for the :where keyword argument:
;;;    :front, :back, :behind, :in-front, or :at
;;;    :tail,  :head, :before, :after
;;; Interpretation of arg:
;;;  - if (member '(:behind :in-front :before :after) where) 
;;;    gob is positioned relative to (third arg)
;;;  - if (eq where :at) gob is positioned at (third arg) positions from
;;; the front of the children
;;;  - otherwise it is ignored.
;;; 
;;; This is really a lot less complicated than it seems, you can say things
;;; like:
;;; (add-component foo :where :front)       == (add-component foo :front)
;;; (add-component foo :where :behind bar)  == (add-component foo :behind :bar)
;;; (add-component foo :where :at 2)        == (add-component foo :at 2)


(define-method :add-component opal:aggregate (a-aggregate gob &rest args)
 (if (eq gob (g-local-value gob :window))		;; Is this a window?
  (format t "*** WARNING:  ~A is a WINDOW, and was not added to ~A~%"
	gob a-aggregate)
  (progn
  (let ((parent (get-local-value gob :parent))
	where locator)
    (when parent
      (error "Graphical-object ~S has :parent ~S already." gob parent))

    (cond ((eq (first args) :where)
                (setq where (second args))
                (setq locator (third args)))
          ((first args)
                (setq where (first args))
                (setq locator (second args)))
          (t (setq where :front)))

    (case where
      ((:front :tail)
       (set-values a-aggregate :components
		   (nconc (get-local-values a-aggregate :components) (list gob))))
      ((:behind :before)
       (let ((components (get-local-values a-aggregate :components)))
	 (do ((smash-slot components (cdr smash-slot))
	      (pre-splice nil smash-slot))
	     ((or (eq (car smash-slot) locator)
		  (null smash-slot))
	      (cond ((null smash-slot)
		     (error "Locator for :where :behind ~S is not in aggregate ~S."
			    locator a-aggregate))
		    (pre-splice
		     (setf (cdr pre-splice) (cons gob smash-slot))
		     (set-values a-aggregate :components components))
		    (t (set-values a-aggregate
				   :components (cons gob smash-slot))))))))
      ((:in-front :after)
       (let* ((components (get-local-values a-aggregate :components))
	      (remainder (member locator components))
	      (splice (cons gob (cdr remainder))))
	 (cond (remainder
		(setf (cdr remainder) splice)
		(set-values a-aggregate :components components))
	       (t (error "Locator for :where :in-front ~S is not in aggregate ~S"
			 locator a-aggregate)))))
      (:at
       (let* ((components (get-local-values a-aggregate :components))
	      (remainder (unless (zerop locator)
			   (nthcdr (1- locator) components))))
	 (set-values a-aggregate :components
		     (if (zerop locator)
			 (cons gob components)
			 (progn
			   (setf (cdr remainder) (cons gob (cdr remainder)))
			   components)))))
      ((:back :head) (push gob (get-local-values a-aggregate :components)))
      (otherwise
       (set-values a-aggregate :components
		   (nconc (get-local-values a-aggregate :components) (list gob)))
       (warn (format nil "Bad where option in add-component: ~S." where))))

    ;; Set up the reverse pointer from child to aggregate
    (s-value gob :parent a-aggregate))
    
    ;; Propagate window and dirty bit to children
    (let ((a-window (g-local-value a-aggregate :window))
	  (gob-update-info (get-local-value gob :update-info)))
      (when a-window
	(set-display-slots gob a-window t)
	
	;; Place the object on its window's invalid-objects list
	(make-object-invalid gob gob-update-info a-window)
   
    	;; Indicate that the old-bbox is definitely NOT valid now! (this was
	;; not visible in this window previouly)
    	(setf (bbox-valid-p (update-info-old-bbox gob-update-info)) NIL))

    ;; Signal we have changed components list
    (mark-as-changed a-aggregate :components)

    ;; Return gob
    gob))))


;;; Add multiple components at the same time
;;; 
(defun add-components (agg &rest components)
  (dolist (component components)
    (add-component agg component))
  (car (last components)))

;;; Remove-component deletes the topmost occurance of gob in aggregate
;;; 
(define-method :remove-component opal:aggregate (a-aggregate gob)

  ;; add the gob's bounding box to the clipping region of the topmost
  ;; overlapping aggregate that contains it (or to its parent if no
  ;; such aggregate is found), and clear the gob's drawable, display,
  ;; and dirty slots, and recursively clear the same slots in its children
  ;; as well

  (let* ((gob-update-info (get-local-value gob :update-info))
         (a-window (update-info-window gob-update-info)))
    (when a-window
      (let ((window-bbox (update-info-old-bbox
				(get-local-value a-window :update-info)))
            (bbox (update-info-old-bbox gob-update-info))
	    (invalid-objects
	     (win-update-info-invalid-objects (g-value a-window :win-update-info))))
	; since the object is no longer in the window, it should be
	; remove from the window's invalid objects list
	(setf (win-update-info-invalid-objects
	       (g-value a-window :win-update-info))
	      (delete gob invalid-objects))
        (merge-bbox window-bbox bbox)
        (set-display-slots gob nil nil)))

    (setf (update-info-invalid-p gob-update-info) NIL)
    (setf (get-local-values a-aggregate :components)
	(delete gob (get-local-values a-aggregate :components) :from-end t :count 1))
    (setf (get-local-values gob :parent) nil)

    ;; signal we have changed components list
    (mark-as-changed a-aggregate :components)))

;;; Similar to a call to remove-component followed by a call to
;;; add-component, but faster
(defun move-component (a-aggregate gob &rest arg)
  (setf (get-local-values a-aggregate :components)
	(delete gob (get-local-values a-aggregate :components) :from-end t :count 1))
  (s-value gob :parent nil)
  (apply #'add-component-method-aggregate (append (list a-aggregate gob) arg)))

;;; Remove multiple components at the same time
(defun remove-components (agg &rest components)
  (dolist (component components)
    (remove-component agg component)))

;;; Remove all components
(defun remove-all-components (agg)
  (dolist (component (copy-list (get-local-values agg :components)))
    (remove-component agg component)))

;;; Like kr:is-a-p, but types can be a list.
(defun my-is-a-p (child types)
  (when types
    (if (listp types)
	(or (is-a-p child (car types))
	    (my-is-a-p child (cdr types)))
	(is-a-p child types))))

;;; Do-Components applies function to all children of aggregate

(define-method :do-components opal:aggregate (a-aggregate function 
					     &key (type t) (self nil))
  (let ((children (get-local-values a-aggregate :components)))
    (dolist (child children)
      (when (or (eq type t)
		(is-a-p child type))
        (funcall function child)))
    (when self
      (funcall function a-aggregate))))


;;; Do-All-Components is like do-components, except it continued through all
;;; aggregates to their children

(define-method :do-all-components opal:aggregate (a-aggregate function
						 &key (type t) (self nil))
  (let ((children (get-local-values a-aggregate :components)))
    (dolist (child children)
      (if (is-a-p child opal:aggregate)
	  (do-all-components child function :type type :self t)
	  (when (or (eq type t)
		    (is-a-p child type))
	    (funcall function child))))
    (when self
      (funcall function a-aggregate))))


;;; Point-To-Component queries the aggregate for first generation children
;;; at point (x,y). If :type is specified only children of the specified
;;; type will be returned.

(defun point-to-component-recur (component-list x y type)
  (and component-list
       (or (point-to-component-recur (cdr component-list) x y type)
	   (let ((child (car component-list)))
	     (when (and (or (eq type t)
			    (my-is-a-p child type))
			(point-in-gob child x y))
	       child)))))
  
(define-method :point-to-component opal:aggregate
	       (a-aggregate x y &key (type t))
  (when (point-in-gob-method-view-object a-aggregate x y)
    (point-to-component-recur (get-local-values a-aggregate :components) x y type)))


;;; Point-To-Leaf is similar to Point-To-Component except that the query
;;; continues to the deepest children.

(defun point-to-leaf-recur (component-list x y type)
  (and component-list
       (or (point-to-leaf-recur (cdr component-list) x y type)
	   (let ((child (car component-list)))
	     (cond ((and (is-a-p child opal:aggregate)
			 (not (g-value child :pretend-to-be-leaf)))
		    (point-to-leaf child x y :type type))
		   ((or (eq type t)
			(my-is-a-p child type))
		    (when (point-in-gob child x y) child)))))))

(define-method :point-to-leaf opal:aggregate
	       (a-aggregate x y &key (type t))
  (when (point-in-gob-method-view-object a-aggregate x y)
    (or (and (not (eq type t))
	     (my-is-a-p a-aggregate type)
             a-aggregate)
	(point-to-leaf-recur (get-local-values a-aggregate :components)
			     x y type))))

;;; This routine sets the :hit-threshold slot of the aggregate
;;; agg to be the maximum of the hit-thresholds of its components.
(defun set-aggregate-hit-threshold (agg)
  (when (is-a-p agg opal:aggregate)
    (let ((max-hit 0))
      (dovalues (c agg :components :local t)
		(set-aggregate-hit-threshold c)
		(setq max-hit (max max-hit (g-value c :hit-threshold))))
      (s-value agg :hit-threshold max-hit))))

