;;;; -*- Mode: Emacs-Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : taql-line-indent.el
;;;; Author          : Thomas McGinnis
;;;; Created On      : Tue Oct 22 14:49:10 1991
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Oct 22 15:46:13 1991
;;;; Update Count    : 5
;;;; 
;;;; PURPOSE
;;;; 	Indent TC's properly.
;;;; TABLE OF CONTENTS
;;;;	I.	Taql-indent-line
;;;;	II.	Make TC's indent as defun's
;;;; 
;;;; (C) Copyright 1991, Carnegie Mellon University.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Status          : Unknown, Use with caution!
;;;; HISTORY
;;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(provide 'taql-line-indent)


;;;
;;;	I.	Taql-indent-line
;;;
;;; This fixes taql-mode's "marching" colon problem.

;;; Added 17-Oct-91 to handle indenting of TC's correctly -- TFMcG
(defun taql-indent-line (&optional whole-exp)
  "Indent-line-function for taql-mode. Indent current line as Lisp code.
With argument, indent any additional lines of the same expression
rigidly along with this one."
  (interactive "P")
  (let ((colon-syntax (char-syntax ?:)))
    (unwind-protect
	(progn
	  (modify-syntax-entry ?: "_")
	  (lisp-indent-line whole-exp))
      (modify-syntax-entry ?: (char-to-string colon-syntax)))))



;;;
;;;	II.	Make TC's indent as defun's
;;;

;;; Default indent value is (- taql-clause-indention 1), a magic number
;;; (one column(s) of indentation come for free).

(mapcar '(lambda (x)
	   (put x 'lisp-indent-hook
		(if (boundp 'taql-clause-indention)
		    (- taql-clause-indention 1)
		  0)))
	'(propose-space propose-initial-state propose-task-state
            propose-task-operator propose-operator prefer
            compare operator-control apply-operator result-superstate
            propose-superobjects goal-test-group
            evaluate-object evaluation-properties
            augment))
