;;;; -*- Mode: Emacs-Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : soar.el
;;;; Author          : Michael Hucka
;;;; Created On      : Sat Oct 14 14:45:09 1989
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Sun Oct  6 23:47:00 1991
;;;; Update Count    : 204
;;;; 
;;;;
;;;;			     GNU Emacs Soar mode
;;;;
;;;;		  Based on CMU lisp Common Lisp interface
;;;;  Soar interface functionality from "hypersoar" mode by Frank Ritter @ CMU
;;;;       Additional code by Michael Hucka @ Univ. of Michigan
;;;;  How to set it up is in the DOC file.
;;;;
;;;; TABLE OF CONTENTS
;;;;    i.      Comments on your .emacs file
;;;; 	ii.	Critical Global variables and macros.
;;;;    iii.    General Global variables
;;;;	iv.	Buffer-specific variables
;;;;    
;;;;    I. 	Code to load the rest of the packages.
;;;;    II.	Changes to other modes to handle soar
;;;;    N.	Run user set hook and provide soar
;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; $Locker: hucka $
;;;; $Log:	soar.el,v $
;;;; Revision 1.2  90/03/29  19:27:19  hucka
;;;; Initial release version.
;;;; 
;;;; Revision 1.1  90/02/15  14:02:15  hucka
;;;; Initial revision
;;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; should get documentation no matter what it takes, e.g. diff type
;;; 2 C-C C-z and C-c z should both get you to the soar



;;;
;;;	I.	Set up the site dependent load paths and such
;;;
;;;
;;; This sets up site specific items such as path to this file
;;; This load requires that soar-mode-defaults.el or its equivalent be loaded 
;;; first.  Once loaded, we can set up our relative loadpath, and dig in.

;; presumably only a few will use this....
;; actively used by soar-site.el
(defvar soar-mode-site-hook nil
 "Hook that gets run  to set up site stuff that depends on soar-mode being
 loaded (such as manual menus).")

(load "soar-site" nil t)

(setq load-path
      (cons soar-mode-home-directory
      (cons (concat soar-mode-home-directory "/utilities")
      (cons (concat soar-mode-home-directory "/allegro")
      (cons (concat soar-mode-home-directory "/" soar-ilisp-subdirectory)
            load-path)))))



;;;  YOUR .EMACS FILE
;;;===========================================================================
;;;  What you need to put in your .emacs file is in
;;;  soar-mode-defaults.el, which is also in this directory.
;;;




;;;
;;;	iii. 	Global variables
;;;---------------------------------------------------------------------------

;;;
;;; 	iii.a	Typically set by users 
;;; who should set them with setq in their .emacs file.
;;;

(defvar soar-version "5.2.1"
  "*Version of the Soar program run to put into headers, etc.")

(defvar soar-mode-hook nil
  "*Hook run after invoking soar-mode, for customising the editing
environment.")

(defvar soar-hook nil
  "*Hook run after starting up an inferior *soar* buffer, for customising
the interaction environment.  Could perhaps be called isoar-hook.")

(defvar soar-mode-load-hook nil
  "*Hook run at the end of loading this file.  This is a good place to put
keybindings.")

(defvar soar-print-into-diversion-p t 
 "*If t (default), prints descriptions into soar-diversion-buffer (*glide*)
buffer.  If nil, dump such printouts into *soar* buffer.")

(defvar soar-erase-diversion-buffer-p t
 "*If t (default), erase *glide* buffer before printing into it.")

(defvar soar-popup-diversion-buffer-p t
 "*If t (default), popup glide buffer when printing into it.")

(defvar soar-default-drm-arg 1
  "*Default arg (1) for d, r, and macrocyle when called from soar-mode.
It is set to the last arg passed in soar-mode to soar-d, soar-r, or 
macrocycle.")

(defvar soar-command-prefix "\C-c" "*Prefix sequence for Soar commands.")

(defvar soar-menu-prefix "\C-m" "*Prefix for putting up the menu.")

(defvar soar-file-types
   '("\\.soar"  "\\.soar5")
  "*File types to put into Soar-mode.")

(defvar soar-bugs-to "soar-bugs@cs.cmu.edu" "Who to send bug reports to.")

(defvar soar-diversion-buffer-use-popup t
  "*If t (default), use the popper package to display the diversion buffer.")


;;;
;;; 	iii.b	Typically not set by users
;;;

(defconst soar-comment-char ";"
  "Comment character in soar-mode.")

(defconst soar-mode-version "4.1+")


;;;
;;;	iv.	Buffer-specific variables
;;;

(make-variable-buffer-local 'soar-production-names)


;;;
;;; 	I. 	Load rest of packages
;;;--------------------------------------------------------------------------
;;; User visable function are fset to names without the leading soar-
;;; 
;;; 1. Require important libraries for functions used throughout.
;;; 2. Do a (provide 'soar) at the end; this prevents providing the symbol if
;;;    attempting to load some subpart of this package fails.
;;; 3. Run hook functions at the end of this file.

;; this extends gnu-emacs-lisp so that it looks more like common-lisp
;; we carry a copy in our directory in case some sites don't have it.
(require 'cl)

;; Franz's code
(require 'smallfi "allegro-mode-init")

;; Olin's & Chris's modes
(require 'soar-bridge)
(load "soar-ilisp-inits") ; extensions and clarifications to load before ilisp
(require 'ilisp)

(require 'soar-ilisp-changes)
(require 'soar-ilisp-bugs)

;; simple menus for the user
(require 'simple-menu)
(load "soar-simple-menus")

(load "soar-cmds" nil t)
(load "soar-indent" nil t)
(load "soar-misc" nil t)
(load "defdialect-soar" nil t)

(load "soar-tags" nil t)

;; where the manuals live
(require 'goto-manual)
(if (not (boundp 'man-manual-homes))
    (setq man-manual-homes
          (list (concat soar-mode-home-directory "/manuals/")))
    (setq man-manual-homes
          (append man-manual-homes
                  (list (concat soar-mode-home-directory "/manuals/")))))

(if (eq window-system 'x)
    (load "soar-x" nil t))

;; This provides a nice header for soar fixes
;; if you wish to use it for other files, use an autoload in your .emacs

(require 'header)
(require 'soar-header)

(autoload 'display-line-numbers  "line-num" "Display line numbers" t)

(require 'insert-date)


;;;
;;;  II.	Changes to other modes
;;;

;;;
;;; 	A.	To Emacs-Lisp mode
;;;

;; nothing currently, keep as placeholder 20-Aug-91 -FER


;;;
;;;	III.	Code to compile soar-mode at a remote-site
;;;

(defun recompile-soar-mode ()
  (interactive)
  (mapcar '(lambda (x) 
            (byte-recompile-directory 
              (concat soar-mode-home-directory "/" x)
              4))
          (list
            ""                       ;top dir
            "allegro"
            "allegro/fi"
            soar-ilisp-subdirectory
            "utilities"))  )


;;;
;;;	IV.	taql-bug (sets up mail message)
;;;
;;; Create way to send bugs in with all variables noted.
;;;

(defun soar-bug ()
 "Generate an taql-mode bug report."
 (interactive)
 (message "Setting up soar-bug...")
 (let ( (ilisp-bugs-to soar-bugs-to) )
  (if (fboundp 'ilisp-bug)
      (ilisp-bug)
      (progn
         (mail)
         (insert soar-bugs-to)))
  (save-excursion  ;ilisp-bug will leave you on subject
   (soar-bug-header))
  (message "Insert your problem.")))

(defun soar-bug-header ()
    (search-forward "Type C-c C-c to send")
    (forward-line 1)
    (insert 
       "\n;;;;;;;;;;;;;;;;;;;;;;;;; SOAR STATE INFO ;;;;;;;;;;;;;;;;;;;;;;;")
    (insert 
      (format "\nWindow System: %s %s" window-system window-system-version))
   (insert (format "\nsoar-mode version: %s" soar-mode-version))
   (insert (format "\nsoar-mode-home-directory: %s" soar-mode-home-directory))
   (insert (format "\nload-path: %s" load-path))
   (insert (format "\nsoar-mode-load-hook: %s" soar-mode-load-hook))
   (insert (format "\nsoar-mode-hook: %s" soar-mode-hook))
   (insert (format "\nsoar-hook: %s" soar-hook))
   (insert (format "\nGnu version: %s\n" (emacs-version)))
)

;;;
;;;  N.	   	Run user set hook and provide soar
;;;-----------------------------------------------------------------------------
;;;

;; soar-hook gets run by Ilisp
(run-hooks 'soar-mode-site-hook)
(run-hooks 'soar-mode-load-hook)

(provide 'soar)

;;-----------------------------------------------------------------------------
;; End of soar.el

(message "Type \"%s%s\" for the Soar command menu." 
         soar-command-prefix  soar-menu-prefix)
(sit-for 2)


; TO DO:
;================================================================

;back-trace [I] [G]        Prints a back-trace as though created by chunking. 52
;decide-trace [X]          Toggles the tracing of the decision procedure. 50
;excise P [*]              Removes productions from production memory. 55
;full-matches P [*]        Prints the most complete instantiation of a
;                          production.                                53
;init-context [G] [P] [S] [O]                                         Clears
;                          working memory and then creates an initial context.
;                          48
;init-wm [X] [*]           Calls init-soar and initializes working memory.
;                          48
;learn [A] [*]             Modifies or lists the flags that control chunking.
;                          56
;list-chunks ["filename"]  Prints all chunks, to a file, if specified.
;                          56
;list-justifications ["filename"]                                     Prints all
;                          justifications, to a file, if specified.   56
;load "filename"           Loads a file.                              49
;memories [N]              Prints the productions with the largest token
;                          memories.                                  57
;multi-attributes L        Declares multi-attributes to increase match
;                          efficiency.                                57
;op-apps L                 Declares productions to be operator-application
;                          productions.                               55
;op-apps-undo L            Undoes the effects of op-apps.             55
;pbreak [X] [*]            Sets or lists current break points.        49
;pfired [D]                Prints the number of times each production fired.
;                          54
;pi P [N]                  Prints a current instantiation of a production.
;                          54
;pm P [*]                  Prints productions; conditions are reordered by
;                          matcher.                                   54
;ppwm [X] [*]              Prints augmentations in working memory.    53
;po I                      Prints the augmentations for an identifier.
;                          52
;pop-goal [X]              Removes a goal and all objects supported by it.
;                          55
;preferences O A           Prints the preferences for a given object and
;                          attribute.                                 53
;print-stats               Prints a summary of run statistics.        54
;ptrace [X] [*]            Turns on tracing of items, or lists all items being
;                          traced.                                    50
;run [N] [X]               Runs Soar for a number of cycles or until a specified
;                          break.                                     50
;run-task [N]              Calls init-soar, init-task, and d.         50
;set-break-char X          Resets the break character when text input is on.
;                          56
;set-carriage-control X    Sets carriage-control mode for text input. 56
;set-char-mode X           Sets character mode for text input.        56
;set-input-functions L     Declares the functions to be called in the input
;                          cycle.                                     56
;set-learning-choice       Prompts user for learning mode.            49
;set-macro-character X Y Z R                                          Sets
;                          terminating characters for text input.     56
;set-output-mappings L     Declares the functions to be called in the output
;                          cycle.                                     56
;set-text-input X          Turns text input on or off.                57
;set-text-input-stream X   Redefines the text-input stream.           57
;set-text-output X         Turns text output on or off.               57
;set-text-output-stream X  Redefines the text-output stream.          57
;set-tab-settings N [*]    Redefines the tab settings used for text output.
;                          57
;set-user-select           Prompts user for user-select mode.         49
;smake X                   Adds preferences to preference memory.     55
;smatches P [*]            Prints partial instantiations of productions.
;                          54
;soar-menu "string" L      Provides a menu for the user.              49
;                          otherwise, returns NIL.                    49
;sp X                      Creates new productions.                   55
;spm P [*]                 Prints productions; conditions are not reordered.
;                          54
;spo I [* D]               Prints Soar objects in working memory.     52
;sppwm [X] [*]             Prints objects in working memory.          53
;spr X [*]                 Prints Soar objects or productions.        53
;sremove N [*]             Removes augmentations from working memory. 55
;swm N [*]                 Given time-tags, prints objects in working memory.
;                          53
;tally O A                 Runs a fake decision given object and attribute.
;                          53
;trace-attributes L        Adds attributes of context objects to the tracing of
;                          a run.                                     51
;unpbreak [X] [*]          Removes break points.                      50
;unptrace [X] [*]          Removes tracing set by unptrace.           51
;untrace-attributes L      Removes tracing set by trace-attributes.   51
;user-select [X]           Sets or displays the user-select mode.     49
;watch [N] [T]             Prints trace information about Soar's run. 51
;wm N [*]                  Given time-tags, prints augmentations in working
;                          memory.                                    53
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; SILLY as emacs commands
; ;d [N]                     Runs Soar for a number of decision cycles. 49
;
; DONE as emacs commands:
;
;excise-chunks             Removes all productions created by chunking.
;                          56
;excise-task               Removes all non-default productions.       55
;init-soar                 Empties working memory and re-initializes runtime
;                          statistics.                                48
;init-task                 A user-defined Lisp function that initializes the
;                          task.                                      48
;last-chunk                Prints the last production created by chunking.
;                          56
;last-justification        Prints the last justification created.     56
;lispsyntax                Changes the readtable to use standard Lisp
;                          conventions.                               49
;ms                        Prints the instantiations and retractions in the
;                          match set.                                 53
;pgs                       Prints the goal-context stack.             52
;restart-soar              Empties production and working memory and resets all
;                          globals.                                   48
;soarnews                  Prints news about the current release.     5
;soarsyntax                Changes the readtable to use Soar conventions.
;                          49
;soarsyntaxp               Returns T if the Soar readtable is being used;
