;;;; -*- Mode: Emacs-Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : soar-ilisp-changes.el
;;;; Author          : Frank Ritter
;;;; Created On      : Tue Oct  2 17:10:39 1990
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Fri Oct 11 15:58:15 1991
;;;; Update Count    : 93
;;;; 
;;;; PURPOSE
;;;; 	Changes to ilisp for DSI/Soar-mode to use.  These represent
;;;; permanent additions to ilisp that we do not expect them to support.
;;;; Each release of ilisp, we have to update the stuff we don't change in 
;;;; each file.
;;;;
;;;; TABLE OF CONTENTS
;;;;	i.	inits and reloads
;;;;	I.	lisp-send-region
;;;;	III.	describe- and inspect-lisp 
;;;;	IV.	ilisp-compile-inits
;;;;	V.	rebind some keys in ilisp-mode-map
;;;;	VI.	ilisp-bug
;;;;	VII.	ilisp-compile-inits
;;;;    VIII.   edit-definitions-lisp
;;;;	N.	Do provides and stuff
;;;; 
;;;; (C) Copyright 1990, Carnegie Mellon University, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;
;;;	i.	inits and reloads
;;;

; old comint might have been loaded, we want ours!
(load "comint")

(if (not (memq 'soar-mode lisp-source-modes))
    (setq lisp-source-modes (cons 'soar-mode lisp-source-modes)))

;; this should be done with regexp
;; -fer
(defun lisp-is-really-soar ()
  (string= (substring (format "%s" (ilisp-process))
                      0
                      (length "#<process soar"))
           "#<process soar"))


;;;
;;;	I.	lisp-send-region
;;;
;;;  changed to know about soarsyntax

;;;%Eval/compile
(defun lisp-send-region (start end switch message status format
			       &optional handler)
  "Given START, END, SWITCH, MESSAGE, STATUS, FORMAT and optional
HANDLER send the region between START and END to the lisp buffer and
execute the command defined by FORMAT on the region, its package and
filename.  If called with a positive prefix, the results will be
inserted at the end of the region.  If SWITCH is T, the command will
be sent and the buffer switched to the inferior LISP buffer.  if
SWITCH is 'call, a call will be inserted.  If SWITCH is 'result the
result will be returned without being displayed.  Otherwise the
results will be displayed in a popup window if lisp-wait-p is T and
the current-prefix-arg is not '- or if lisp-wait-p is nil and the
current-prefix-arg is '-.  If not displayed in a pop-up window then
comint-handler will display the results in a pop-up window if they are
more than one line long, or they are from an error.  STATUS will be
the process status when the command is actually executing.  MESSAGE is
a message to let the user know what is going on."
  (if (= start end) (error "Region is empty"))
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;; correct for soar-syntax here:  -fer
  (cond ;; soar process, lisp code:
        ((and (lisp-is-really-soar)
              (eq major-mode 'lisp-mode))
         (ilisp-send "(lispsyntax)" "Using lispsyntax.") )
        ;; soar process, soar code: 
        ((eq major-mode 'soar-mode)
         (ilisp-send "(soarsyntax)" "Using soarsyntax."))
        ;; lisp process, lisp code (the original definition):
        ((not (lisp-is-really-soar))) )
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  (let ((sexp (lisp-count-pairs start end ?\( ?\)))
	(string (buffer-substring start end)))
    (setq string
	  (format (ilisp-value format)
		  (lisp-slashify
		   (if (= sexp 1)
		       string
		       (format (ilisp-value 'ilisp-block-command) string)))
		  (lisp-buffer-package) (buffer-file-name)))
    (let ((result 
	   (ilisp-send
	    string message status
	    (cond ((memq switch '(t call)) switch)
		  ((or (not (eq lisp-wait-p (lisp-minus-prefix))) 
		       current-prefix-arg
		       (eq switch 'result)) nil)
		  (t 'dispatch))
	    handler)))
      (if result
	  (if current-prefix-arg
	      (save-excursion
		(goto-char end)
		(insert ?\n)
		(insert result))
	      (if (or (ilisp-value 'comint-errorp t)
		      (string-match "\n" result))
		  (lisp-display-output result)
		  (popper-bury-output t)
		  (message "%s" result)))
	  result))))



;;;
;;;	III.	describe- and inspect-lisp 
;;;
;;; just checks for arg now, not neg arg.
;;;

(defun describe-lisp (sexp)
  "Describe the current sexp using ilisp-describe-command.  With a
negative prefix, prompt for the expression.  If in an ILISP buffer,
and there is no current sexp, describe ilisp-last-command."
  (interactive
   (list
    (if current-prefix-arg   ; -fer
	(ilisp-read "Describe: " (lisp-previous-sexp t))
	(if (memq major-mode ilisp-modes)
	    (if (= (point)
		   (process-mark (get-buffer-process (current-buffer))))
		(or (ilisp-value 'ilisp-last-command t)
		    (error "No sexp to describe."))
		(lisp-previous-sexp t))
	    (lisp-previous-sexp t)))))
  (let ((result
	 (ilisp-send
	  (format (ilisp-value 'ilisp-describe-command) 
		  (lisp-slashify sexp) (lisp-buffer-package))
	  (concat "Describe " sexp)
	  'describe)))
    (lisp-display-output result)))

(defun inspect-lisp (sexp)
  "Inspect the current sexp using ilisp-inspect-command.  With a
negative prefix, prompt for the expression.  If in an ILISP buffer,
and there is no current sexp, inspect ilisp-last-command."
  (interactive
   (list
    (if current-prefix-arg
	(ilisp-read "Inspect: " (lisp-previous-sexp t))
	(if (memq major-mode ilisp-modes)
	    (if (= (point)
		   (process-mark (get-buffer-process (current-buffer))))
		(or (ilisp-value 'ilisp-last-command t)
		    (error "No sexp to inspect."))
		(lisp-previous-sexp t))
	    (lisp-previous-sexp t)))))
  (ilisp-send
   (format (ilisp-value 'ilisp-inspect-command) 
	   (lisp-slashify sexp) (lisp-buffer-package))
   (concat "Inspect " sexp)
   'inspect t))


;;;
;;;	IV.	ilisp-compile-inits
;;;
;;; Changed to make sure that soarsyntax doesn't get in our way.
;;;

(defun ilisp-compile-inits ()
  "Compile the initialization files for the current inferior LISP
dialect."
  (interactive)
  (ilisp-init t)
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;; make read (soar) syntax be right for ilisp -fer 
  (ilisp-send "(lispsyntax)" "Using lispsyntax.")
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  (let ((files (ilisp-value 'ilisp-load-inits t)))
    (while files
      (load-file-lisp (expand-file-name (cdr (car files)) ilisp-directory))
      (compile-file-lisp (expand-file-name (cdr (car files)) ilisp-directory)
			 (ilisp-value 'ilisp-init-binary-extension t))
      (setq files (cdr files)))))


;;;
;;;	V.	ilisp-init-internal
;;;

;(defun ilisp-init-internal ()
;  "Send all of the stuff necessary to initialize."
;  (unwind-protect
;       (progn
;	 (comint-sync
;	  (ilisp-process)
;	  "\"Start sync\""  "[ \t\n]*\"Start sync\""
;	  "\"End sync\""    "\"End sync\"")
;         ;; only change right here 18-Jul-91 - fer
;	 (ilisp-binary 'ilisp-binary-command 'ilisp-binary-extension)
;	 (ilisp-binary 'ilisp-init-binary-command 'ilisp-init-binary-extension)
;	 ;; This gets executed in the process buffer
;	 (comint-send-code
;	  (ilisp-process)
;	  (function (lambda ()
;	    (let ((files ilisp-load-inits)
;		  (done nil))
;	      (unwind-protect
;		   (progn
;		     (if (not ilisp-init-binary-extension)
;			 (setq ilisp-init-binary-extension 
;			       ilisp-binary-extension))
;		     (while files
;		       (ilisp-load-or-send
;			(expand-file-name 
;			 (cdr (car files)) ilisp-directory))
;		       (setq files (cdr files)))
;		     (comint-send-code (ilisp-process)
;				       'ilisp-done-init)
;		     (setq done t))
;		(if (not done)
;		    (progn
;		      (setq ilisp-initializing nil)
;		      (abort-commands-lisp))))))))
;	 (set-ilisp-value 'ilisp-initializing t))
;    (if (not (ilisp-value 'ilisp-initializing t))
;	(abort-commands-lisp))))


;;;
;;;	VI.	ilisp-bug
;;;

;Date: Wed,  4 Sep 1991 18:24:11 -0400 (EDT)
;From: Frank Ritter <fr07+@andrew.cmu.edu>
;To: Christopher.McConnell@CS.CMU.EDU
;Subject: ilisp-bug bug
;
;Your problem: 
;
;ilisp-bug croaks if it is called when there is no ilisp running.  Soar
;mode, and ilisp's lisp-mode may be used when there is no lisp (or at
;least not yet).  I include a fixed up version  that does not croak,
;with/or w/o an ilisp-buffer around.
;
;Frank

(defun ilisp-bug ()
  "Generate an ilisp bug report."
  (interactive)
  (let ((buffer (current-buffer)))
    (mail)
    (insert ilisp-bugs-to)
    (search-forward (concat "\n" mail-header-separator "\n"))
    (insert "\nYour problem: \n\n")
    (insert "Type C-c C-c to send\n")
    (insert "============= Emacs state below: for office use only ===========\n")
    (forward-line 1)
    (insert (emacs-version))
    (insert 
     (format "\nWindow System: %s %s" window-system window-system-version))
    (let ((mode (save-excursion (set-buffer buffer) major-mode))
	  (match "popper-\\|completer-")
	  (val-buffer buffer)
	  string)
      (if (or (memq mode lisp-source-modes) (memq mode ilisp-modes))
	  (progn
	    (setq match (concat "ilisp-\\|comint-\\|lisp-" match)
		  val-buffer (save-excursion (set-buffer buffer)
					     (or (if ilisp-buffer  ;-fer
                                                     (ilisp-buffer))
                                                 buffer)))
	    (mapcar (function (lambda (dialect)
		      (setq match (concat (format "%s-\\|" (car dialect))
					  match))))
		    ilisp-dialects)
	    (save-excursion
	      (set-buffer buffer)
	      (let ((point (point))
		    (start (lisp-defun-begin))
		    (end (lisp-end-defun-text t)))
		(setq string
		      (format "
Mode: %s
Start: %s
End: %s
Point: %s
Point-max: %s
Code: %s\n"
			      major-mode start end point (point-max)
			      (buffer-substring start end)))))
	    (insert string)))
      (mapatoms
       (function (lambda (symbol)
		   (if (and (boundp symbol)
			    (string-match match (format "%s" symbol))
			    (not (eq symbol 'ilisp-documentation)))
		       (let ((val (save-excursion
				    (set-buffer val-buffer) 
				    (symbol-value symbol))))
			 (if val
			     (insert (format "%s: %s\n" symbol val))))))))
      (insert (format "\nLossage: %s" (key-description (recent-keys))))
    (if (and (or (memq mode lisp-source-modes)
		 (memq mode ilisp-modes))
	       ilisp-buffer    ;-fer change here too
               (ilisp-buffer)  ;-fer change here too
	       (memq 'clisp (ilisp-value 'ilisp-dialect t))
	       (not (cdr (ilisp-value 'comint-send-queue))))
	  (insert (format "\nLISP: %s"
			  (comint-remove-whitespace
			   (car (comint-send
				 (save-excursion
				   (set-buffer buffer)
				   (ilisp-process))
				 "(lisp-implementation-version)"
				 t t 'version))))))
    (goto-char (point-min))
    (re-search-forward "^Subject")
    (end-of-line)
    (message "Send with sendmail or your favorite mail program."))))


;;;
;;;	VII.	ilisp-compile-inits
;;;

(defun ilisp-compile-inits ()
  "Compile the initialization files for the current inferior LISP
dialect."
  (interactive)
  (beep)
  (ilisp-init t) (beep)
  (let ((files (ilisp-value 'ilisp-load-inits t)))
    (while files
      (compile-file-lisp (expand-file-name (cdr (car files)) ilisp-directory)
			 (ilisp-value 'ilisp-init-binary-extension t))
      (setq files (cdr files)))))


;;;
;;;     VIII.   edit-definitions-lisp
;;;

;(defun edit-definitions-lisp (symbol type &optional stay search locator)
;  "Find the source files for the TYPE definitions of SYMBOL.  If STAY,
;use the same window.  If SEARCH, do not look for symbol in inferior
;LISP.  The definition will be searched for through the inferior LISP
;and if not found it will be searched for in the current tags file and
;if not found in the files in lisp-edit-files set up by
;\(\\[lisp-directory]) or the buffers in one of lisp-source-modes if
;lisp-edit-files is T.  If lisp-edit-files is nil, no search will be
;done if not found through the inferior LISP.  TYPES are from
;ilisp-source-types which is an alist of symbol strings or list
;strings.  With a negative prefix, look for the current symbol as the
;first type in ilisp-source-types."
;  (interactive 
;   (let* ((use-ilisp-buffer (comint-check-proc ilisp-buffer))
;          (types (and use-ilisp-buffer
;                      (ilisp-value 'ilisp-source-types t)))
;          (default (if types (car (car types))))
;          (function (and use-ilisp-buffer
;                         (lisp-function-name)))
;          (symbol (and use-ilisp-buffer
;                       (lisp-buffer-symbol function))))
;     (if (lisp-minus-prefix)
;         (list function default)
;         (list (ilisp-read-symbol 
;                (format "Edit Definition [%s]: " symbol)
;                function
;                nil
;                t)
;               (if types 
;                   (ilisp-completing-read
;                    (format "Type [%s]: " default)
;                    types default))))))
;  (if (comint-check-proc ilisp-buffer)
;  (let* ((name (lisp-buffer-symbol symbol))
;         (symbol-name (lisp-symbol-name symbol))
;         (command (and (comint-check-proc ilisp-buffer)
;                       (ilisp-value 'ilisp-find-source-command t)))
;         (source
;          (if (and command (not search) (comint-check-proc ilisp-buffer))
;              (ilisp-send
;               (format command symbol-name
;                       (lisp-symbol-package symbol)
;                       type)
;               (concat "Finding " type " " name " definitions")
;               'source)
;              "nil"))
;         (result (lisp-last-line source))
;         (case-fold-search t)
;         (source-ok (and (comint-check-proc ilisp-buffer)
;                         (not (or (ilisp-value 'comint-errorp t)
;                             (string-match "nil" (car result))))))
;         (tagged nil))
;    (unwind-protect
;         (if (and tags-file-name (not source-ok))
;             (progn (setq lisp-using-tags t)
;                    (find-tag symbol-name nil stay)
;                    (setq tagged t)))
;      (if (not tagged)
;          (progn
;            (setq lisp-last-definition (cons symbol type)
;                  lisp-last-file nil
;                  lisp-last-locator (or locator
;                                        (and (comint-check-proc ilisp-buffer)
;                                             (ilisp-value 'ilisp-locator))))
;            (lisp-setup-edit-definitions
;             (format "%s %s definitions:" type name)
;             (if source-ok (cdr result) lisp-edit-files))
;            (next-definition-lisp nil t)))))
;  (unwind-protect
;         (if tags-file-name
;             (progn (setq lisp-using-tags t)
;                    (find-tag symbol-name nil stay))))))


;;;
;;;	N.	Do provides and stuff
;;;

;; (require 'soar-ilisp-keymap-changes "soar-ilisp-keymap-changes")
;; no longer required

(provide 'soar-ilisp-changes)

(require 'ilisp-simple-menu)
