;;;; -*- Mode: Emacs-Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : soar-ilisp-bugs.el
;;;; Author          : Frank Ritter
;;;; Created On      : Tue Jun 11 12:08:01 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Jun 21 16:24:34 1991
;;;; Update Count    : 4
;;;; 
;;;; PURPOSE
;;;; 	Bugs in ilisp that we expect to get incorporated into ilisp.
;;;; Each ilisp release these should be checked to see if they have
;;;; been superceeded.
;;;;
;;;; TABLE OF CONTENTS
;;;;
;;;;	II.	find-file-lisp cleaner
;;;;	III.	ilisp-query-compile-on-load
;;;;	V.	ilisp-done-init
;;;;	VI.	defdialect
;;;	N.	Do provides and stuff
;;;; 
;;;; (C) Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; $Locker$
;;;; $Log$
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;
;;;	II.	find-file-lisp cleaner
;;;

;; removed "Lisp" and "find" from prompt
;; made less verbose prompt, 17 char worth.  particularly ironic since I first
;; wrote the code and olin didn't credit me, but it wasn't great code.
;; -fer

;; appears to be partially in 4.11, which is cleaned up in other ways
;; making this unnecessary

;(defconst find-file-lisp-prompt ;"Find Lisp file: "
;                                "IFile")
;
;(defun find-file-lisp (file-name)
;  "Find a file.  If point is on a string that points to an existing
;file, that will be the default.  If the buffer is one of
;lisp-source-modes, the buffer file will be the default.  Otherwise,
;the last file used in a lisp-source-mode will be used."
;  (interactive
;   (comint-get-source find-file-lisp-prompt lisp-prev-l/c-dir/file
;		      lisp-source-modes nil))
;  (setq lisp-prev-l/c-dir/file (cons (file-name-directory    file-name)
;				     (file-name-nondirectory file-name)))
;  (lisp-find-file file-name nil t))
;
;(defun comint-get-source (prompt prev-dir/file source-modes mustmatch-p)
;  (let* ((def (comint-source-default prev-dir/file source-modes))
;         (stringfile (comint-extract-string))
;	 (sfile-p (and stringfile
;		       (file-exists-p stringfile)
;		       (not (file-directory-p stringfile))))
;	 (defdir  (if sfile-p (file-name-directory stringfile)
;                      (car def)))
;	 (deffile (if sfile-p (file-name-nondirectory stringfile)
;                      (cdr def)))
;	 (ans (read-file-name (if deffile (format "%s [%s]:"
;						  prompt    deffile)
;				  prompt)
;			      defdir
;			      (concat defdir deffile)
;			      mustmatch-p)))
;    (list (expand-file-name (substitute-in-file-name ans)))))



;;;
;;;	III.	ilisp-query-compile-on-load
;;;
;;; Now allows the user to not ask for compiles.  Could/should be set for 
;;; each buffer.  But this is all.
;;;
;;; send in 11 june 91, will be in next release as ilisp-load-no-compile-query

(defvar ilisp-query-compile-on-load t
 "*Query the user to compile file when loading.")

;; Soar-mode doesn't need it!
(setq ilisp-query-compile-on-load nil)

(defun load-file-lisp (file-name)
  "Load a lisp file into the current inferior LISP and go there."
  (interactive (comint-get-source "Load Lisp file: " lisp-prev-l/c-dir/file
				  lisp-source-modes nil))
  (comint-check-source file-name)	; Check to see if buffer needs saved.
  (setq lisp-prev-l/c-dir/file (cons (file-name-directory    file-name)
				     (file-name-nondirectory file-name)))
  (ilisp-init t)
  (let* ((extension (ilisp-value 'ilisp-binary-extension t))
	 (binary (lisp-file-extension file-name extension)))
    (save-excursion
      (set-buffer (ilisp-buffer))
      (if (not (eq comint-send-queue comint-end-queue))
	  (if (y-or-n-p "Abort commands before loading? ")
	      (abort-commands-lisp)
	      (message "Waiting for commands to finish")
	      (while (not (eq comint-send-queue comint-end-queue))
		(accept-process-output)
		(sit-for 0))))
      (if (and (car (comint-send-variables (car comint-send-queue)))
	       (y-or-n-p "Interrupt top level? "))
	  (let ((result (comint-send-results (car comint-send-queue))))
	    (interrupt-subjob-ilisp)
	    (while (not (cdr result))
	      (accept-process-output)
	      (sit-for 0)))))
    (if (file-newer-than-file-p file-name binary)
	(if (and extension 
                 ilisp-query-compile-on-load    ;;; change here -fer 1/91
                 (y-or-n-p "Compile first? "))
	    ;; Load binary if just compiled
	    (progn
	      (message "")
	      (compile-file-lisp file-name)
	      (setq file-name binary)))
	;; Load binary if it is current
	(if (file-readable-p binary)
	    (setq file-name binary)))
    (switch-to-lisp t t)
    (comint-sender
     (ilisp-process)
     (format (ilisp-value 'ilisp-load-command) file-name))
    (message "Loading %s" file-name)))


;;;
;;;	V.	ilisp-done-init
;;;
;;; Slightly better finish.
;;;
;;; sent in 11 june 91
;;; will be in next release after 4.11

(defun ilisp-done-init ()
  "Make sure that initialization is done and if not dispatch another check."
  (if ilisp-load-files
      (comint-send-code (get-buffer-process (current-buffer))
			'ilisp-done-init)
      (if ilisp-initializing
	  (progn
	    (message "Done initializing %s." 
                     (car ilisp-dialect))
	    (setq ilisp-initializing nil
		  ilisp-initialized
		  (cons (buffer-name (current-buffer)) ilisp-initialized))))))


;;;
;;;	VI.	defdialect
;;;
;;; new version to handle after-ilisp-hook
;;; sent in 10 june 91

(defmacro defdialect (dialect full-name parent &rest body)
 "Define a new ILISP dialect.  DIALECT is the name of the function to
invoke the inferior LISP. The hook for that LISP will be called
DIALECT-hook.  
DIALECT-after-ilisp-hook holds commands to call to modify ilisp for that mode.
The default program will be DIALECT-program.  FULL-NAME
is a string that describes the inferior LISP.  PARENT is the name of
the parent dialect."
 (let ((setup (read (format "setup-%s" dialect)))
       (hook (read (format "%s-hook" dialect)))
       (after-ilisp-hook (read (format "%s-after-ilisp-hook" dialect)))
       (program (read (format "%s-program" dialect)))
       (dialects (format "%s" dialect)))
  (`
   (progn
    (defvar (, hook) nil (, (format "*Inferior %s hook." full-name)))
    (defvar (, after-ilisp-hook) nil 
       (, (format "*Inferior %s hook to run after ilisp has set up the bufer." full-name)))     
    (defvar (, program) nil
      (, (format "*Inferior %s default program." full-name)))
    (defun (, setup) (buffer)
      (, (format "Set up for interacting with %s." full-name))
      (, (read (format "(setup-%s buffer)" parent)))
      (,@ body)
      (setq ilisp-program (or (, program) ilisp-program)
            ilisp-dialect (cons '(, dialect) ilisp-dialect))
      (run-hooks '(, (read (format "%s-hook" dialect)))))
    (defun (, dialect) (&optional buffer program)
      (, (format "Create an inferior %s.  With prefix, prompt for buffer and program."
	        full-name))
      (interactive (list nil nil))
      (ilisp-start-dialect (or buffer (, dialects)) 
	       	           program 
			   '(, setup))
      (run-hooks '(, (read (format "%s-after-ilisp-hook" dialect))))
      (setq (, program) ilisp-program))
    (lisp-add-dialect (, dialects))))))



;;;
;;;	N.	Do provides and stuff
;;;

(provide 'soar-ilisp-bugs)
