;;;; -*- Mode: Emacs-Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : manual.el
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jul  6 10:56:04 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Wed Jul 17 17:57:41 1991
;;;; Update Count    : 23
;;;; 
;;;; 
;;;; PURPOSE
;;;; 	Provides quick way to look up manuals quickly by assigning 
;;;;  them a nickname.
;;;; HISTORY
;;;;    Originally part of hypersoar.
;;;; TABLE OF CONTENTS
;;;; 	i.   	Required packages and Global variable setup
;;;;    I.  	goto-manual
;;;;    II.     Helper functions
;;;;   III.  Provide the package
;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;
;;;         i.   Required packages and  Global variable setup
;;;

(defvar man-document-manuals nil "*Where the manuals live in an assoc list")
;; this may be an obsolete variable with the use of simple menus... fer 1/91
(defvar man-last-manual "taql-mode" "the last manual searched for")
(defvar man-last-manual-search 
        (getenv "USER")
  "The last string searched for.  Default is user's name.")
(defvar man-manual-home  "~/manuals/")

(if (string= man-last-manual-search "")
    (setq man-last-manual-search "Newell"))


;;;
;;;         I.  	goto-manual
;;;

(defun man-goto-manual (manual &optional mode)
  "Get the manual out.  MANUAL is a file name, mode is the mode to put the 
buffer in to start with."
  (interactive)
  (let ((topic (read-string "Search for: " man-last-manual-search)))
    (setq man-last-document-manual manual)
    ;;; and choose what to search
    (setq man-last-manual-search topic)
    (find-file (man-find-manual manual man-manual-homes))
    (if mode 
        (eval (list mode)))
    (search-forward topic) ) )

(fset 'goto-manual 'man-goto-manual)

(defun man-find-manual (manual homes)
  "Find manual."
  (if homes
     (let ( (file (expand-file-name manual (car homes))) )
       (if (file-exists-p file)
            file
            (man-find-manual manual (cdr homes)))
  )))


;;;
;;;   	II.	 Helper functions
;;;

;;;
;;;   III.  Provide the package
;;;

(provide 'goto-manual)
