;;;; -*- Mode: Soar -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : ps.tpl
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jun 21 11:56:16 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Jun 21 13:21:16 1991
;;;; Update Count    : 3
;;;; Soar Version    : 5.2
;;;; TAQL Version    : 3.1.3
;;;; 
;;;; PURPOSE
;;;; 	Templates for Old fashion TAQL stuff.  changes go here, the
;;;; section gets inserted into the template files before release.
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; (C) Copyright 1991, Frank Ritter University, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;
;;; 	V.	Old-fashioned taql templates
;;;



Template the-OSU-production-templates Selection
:begin
Top-Goal:
Goal-for-subgoals
Propose-top-problem-space
Propose-problem-spaces-for-subgoals
Compare-problem-spaces-binary-preferences
Select-problem-space-unary-preferences
Propose-initial-state-in-the-top-problem-space
Propose-initial-state-in-a-subgoal-no-copy
Propose-initial-state-in-a-subgoal-copy
Elaborate-state
Numeric-evaluation-of-state-in-subgoal-of-evaluate-object
Symbolic-evaluation-of-state
Propose-operator
Compare-operators-binary-preferences
binary-preferences
Select-operator-unary-preferences
Operator-application
Operator-termination
Goal-test-Detect-desired-feature
Detect-desired-state
Detect-failed-state
Result-superoperator
:end

Template Top-Goal Sequence
:begin
(sp top-goal*elaborate*goal*{textenter:goal-name}
  (goal <g> ^object nil)
-->
  (goal <g> ^desired <d> ^name {textenter:goal-name})
  {?preferences-for-desired-state-substructure})
:end

Template preferences-for-desired-state-substructure Sequence
:begin
(goal <g> {attribute-value-pairs})
:end

Template Goal-for-subgoals Sequence
:begin
(sp {textenter:superproblem-space}*elaborate*goal*{textenter:goal-name}
  (goal <g> ^object <sg> ^impasse {impasse-type} 
            ^attribute {evaluate-object-type}
            {?attribute-value-pairs})
  (goal <sg> {?attribute-value-pairs});necessary supercontext
-->
  (goal <g> ^desired <d> ^name {textenter:goal-name})
  )   ;[possibly preferences for desired state substructure]
:end

Template impasse-type Selection
:begin
tie
conflict
no-change
constraint-failure
:end

Template Propose-top-problem-space Sequence
:begin
(sp {textenter:goal-name}*propose*space*{textenter:problem-space}
  (goal <g> ^object nil ^name {textenter:goal-name})
-->
  (goal <g> ^problem-space <p>)
  ; [possibly preferences for desired state substructure]
  ; or use TAQL!
  (problem-space <p> ^name {textenter:problem-space}
                     ^default-state-copy yes  ; for state copying
                     ^one-level-attributes {?attribute-names}
                     ^two-level-attributes {?attribute-names}))
:end

Template Propose-problem-spaces-for-subgoals Sequence
:begin
(sp {textenter:goal-name}*propose*space*{textenter:problem-space}
  (goal <g> ^object <sg> ^name {textenter:goal-name})
 -->
  (goal <g> ^problem-space <p>)
  (problem-space <p> ^name {textenter:problem-space}
                     ^default-state-copy yes  ; for state copying
                     ^one-level-attributes {?attribute-names}
                     ^two-level-attributes {?attribute-names}))
:end

Template Compare-problem-spaces-binary-preferences Sequence
:begin
(sp {textenter:goal-name}*compare*spaces*{textenter:better-space]*{textenter:space-name}
  (goal <g> ^problem-space <p1> + { <> <p1> <p2> } +
            ^object <sg> ^impasse {impasse-type} ^attribute {ps-or-state-or-oper}
                       {?attribute-value-pairs}) ;necessary context about impasse
  (problem-space <p1> ^name {textenter:problem-space})
  (problem-space <p2> ^name {textenter:problem-space})
  (goal <sg> {?attribute-value-pairs}) ;necessary supercontext
  ;more supercontext structure if necessary
-->
  (goal <g> ^problem-space <p1> [ >, =, or < ] <p2>))
:end

Template Select-problem-space-unary-preferences Sequence
:begin
(sp {textenter:goal-name}*select*space*{textenter:problem-space}
  (goal <g> ^problem-space <p1> +
            ^object <sg> ^impasse {impasse-type} ^attribute [impasse role]
            {?attribute-value-pairs}) ;necessary context about impasse
  (problem-space <p1> ^name {textenter:problem-space})
  (goal <sg> {?attribute-value-pairs}) ;necessary supercontext
  ;[more supercontext structure if necessary]
-->
  (goal <g> ^problem-space <p1> {preference-value}))
:end

Template preference-value Selection
:begin
 !
 >
 =
 <
 -
 ~
:end

Template Propose-initial-state-in-the-top-problem-space Sequence
:begin
(sp {textenter:problem-space}*propose*state*top-initial-state
  (goal <g> ^problem-space <p> ^object nil)
  (problem-space <p> ^name {textenter:problem-space})
-->
  (goal <g> ^state <s>)
  (state <s> {?attribute-value-pairs}) ;structure of state
  ;[more preferences for state structure if necessary]
  )
:end

Template Propose-initial-state-in-a-subgoal-no-copy Sequence
:begin
(sp {textenter:problem-space}*propose*state*initial-state
  (goal <sg> ^state <ss> {?attribute-value-pairs}) ;[necessary supercontext]
  ; more supercontext, especially about the superstate
  (goal <g> ^problem-space <p> ^object <sg> {?attribute-value-pairs}) 
  ; context about impasse
  (problem-space <p> ^name {textenter:problem-space})
-->
  (goal <g> ^state <s>)
  (state <s> ^superstate <ss> {?attribute-value-pairs})
  ; structure of state (usually copied from superstate)
  ; more preferences state structure if necessary
)
:end

Template Propose-initial-state-in-a-subgoal-copy Sequence
:begin
(sp {textenter:superproblem-space]*propose*state*{textenter:problem-space}*initial-state
  (goal <sg> ^state <ss>)
  ;[necessary supercontext]
  (goal <g> ^problem-space <p> ^object <sg>
            {?attribute-value-pairs}) ; context about impasse
  (problem-space <p> ^name {textenter:problem-space})
-->
  (goal <g> ^state <ss>))
:end

Template Elaborate-state Sequence
:begin
(sp {textenter:problem-space}*elaborate*state
  (goal <g> ^problem-space <p> ^state <s>)
  (problem-space <p> ^name {textenter:problem-space})
  (state <s> {?attribute-value-pairs}) ;necessary context for elaboration
  {?conditions}
-->
  ; preferences for any arguments or substructure
  (state <s> {?attribute-value-pairs})) 
:end

Template Numeric-evaluation-of-state-in-subgoal-of-evaluate-object Sequence
:begin
(sp {textenter:problem-space}*evaluate*state*numeric
  (goal <g> ^problem-space <p> ^state <s> ^object <sg> ^applied <o>)
  (problem-space <p> ^name {textenter:problem-space})
  (goal <sg> ^state <ss> ^operator <so>)
  (state <ss> ^evaluation <e>)
  (operator <so> ^type evaluation ^evaluation <e> ^object <o>
                 ^desired <d>)
  : augmentations used to determine distance to desired state
  (state <s> {?attribute-value-pairs})
  ; augmentations used to determine distance of state
  (desired <d> {?attribute-value-pairs})
  -->
  (evaluation <e> ^numeric-value {textenter:number}))
:end

Template Symbolic-evaluation-of-state Sequence
:begin
(sp {textenter:problem-space}*evaluate*state*symbolic
  (goal <g> ^problem-space <p> ^state <s> ^desired <d>)
  (problem-space <p> ^name {textenter:problem-space})
  ; augmentations used to determine distance to desired state
  (state <s> {?attribute-value-pairs})
  ; augmentations used to determine distance of state
  (desired <d> {?attribute-value-pairs})
  -->
  (state <s> ^{symbolic-evaluation-type} <d>))
:end

Template symbolic-evaluation-type Selection
:begin
required-success
success
partial-success
indifferent
failure
partial-failure
prohibit-failure
:end

Template Propose-operator Sequence
:begin
(sp {textenter:problem-space}*propose*operator*{textenter:operator-name}
  (goal <g> ^problem-space <p> ^state <s>)
  (problem-space <p> ^name {textenter:problem-space})
  ; necessary context for proposal, arguments or substructure for operator
  (state <s> {?attribute-value-pairs})
  {?conditions}
-->
  (goal <g> ^operator <o>)
  (operator <o> ^name {textenter:operator-name}
                [preferences for any arguments or substructure])
:end

Template Compare-operators-binary-preferences Sequence
:begin
(sp {textenter:problem-space}*compare*operator*{textenter:better-operator}*{textenter:worse-operator}
  (goal <g> ^problem-space <p> ^state <s> ^operator <o1> + { <> <o1> <o2> } +)
  (problem-space <p> ^name {textenter:problem-space})
  ;structure tested to compare worth of operators
  (state <s> {?attribute-value-pairs})
  (operator <o1> ^name {textenter:better-operator})
  (operator <o2> ^name {textenter:worse-operator})))
-->
  (goal <g> ^operator <o1> {binary-preferences} <o2>))
:end

Template binary-preferences Selection
:begin
 >
 =
 <
:end

Template Select-operator-unary-preferences Sequence
:begin
(sp {textenter:problem-space}*select*operator*{textenter:operator-name}
  (goal <g> ^problem-space <p> ^state <s> ^operator <o1> +)
  (problem-space <p> ^name {textenter:problem-space})
  ; structure tested to determine worth of operator
  (state <s> {?attribute-value-pairs})
  (operator <o> ^name {textenter:operator-name})
-->
  (goal <g> ^operator <o1> {preferences}))
:end

Template Operator-application Sequence
:begin
(sp implement*{textenter:operator-name}
  (goal <g> ^state <s> ^operator <o>)
  ; structure to be augmented, changed, or removed by operator
  (state <s> {?attribute-value-pairs})
  (operator <o> ^name {textenter:operator-name} {?attribute-value-pairs}) 
  ; additional arguments
-->
  ; preferences to augment, change, or remove structure
  (state <s> {?attribute-value-pairs})
  ; preferences for state substructure
  )
:end


Template Operator-termination Sequence
:begin
(sp terminate*{textenter:operator-name}
  (goal <g> ^state <s> ^operator <o>)
  ; structure that indicates operator applied
  (state <s> {?attribute-value-pairs})
  ; arguments or structure
  (operator <o> ^name {textenter:operator-name} {?attribute-value-pairs})
-->
  (goal <g> ^operator <o> @))
:end

Template Goal-test-Detect-desired-feature Sequence
:begin
(sp {textenter:problem-space}*detect*state*{textenter:feature}
  (goal <g> ^problem-space <p> ^state <s> ^desired <d>)
  (problem-space <p> ^name {textenter:problem-space})
  ; structure indicates goal partially achieved
  (state <s> {?attribute-value-pairs})
  ; structure of desired compared to state
  (desired <d> {?attribute-value-pairs})
  -->
  ; structure that records goal partially achieved
  (state <s> {?attribute-value-pairs}))
:end

Template Detect-desired-state Sequence
:begin
(sp {textenter:problem-space}*detect*state*success
  (goal <g> ^problem-space <p> ^state <s> ^desired <d>)
  (problem-space <p> ^name {textenter:problem-space})
  ; structure that indicates goal is achieved
  (state <s> {?attribute-value-pairs})
  ; structure that indicates goal is achieved
  (desired <d> {?attribute-value-pairs})
-->
  (state <s> ^{success-value} <d>))
:end

Template success-value Selection
:begin
required-success
success
partial-success
:end

Template Detect-failed-state Sequence
:begin
(sp {textenter:problem-space}*detect*state*failure
  (goal <g> ^problem-space <p> ^state <s> ^desired <d>)
  (problem-space <p> ^name {textenter:problem-space})
  ; structure that indicates that state failed
  (state <s> {?attribute-value-pairs})
  ; structure that indicates that state failed
  (desired <d> {?attribute-value-pairs})
-->
  (state <s> ^{goal-failure-type} <d>))
:end

Template goal-failure-type Selection
:begin
required-failure
failure
partial-failure
:end

Template Result-superoperator Sequence
:begin
(sp {textenter:superproblem-space}*result*operator*{textenter:problem-space}
  (goal <g> ^problem-space <p> ^state <s> ^desired <d> ^object <sg>)
  (problem-space <p> ^name {textenter:problem-space})
  (state <s> ^success <d>
             ; structure indicating appropriate superoperator
             {?attribute-value-pairs}
             ; arguments or substructure to pass to superoperator
             {?attribute-value-pairs})
  (goal <sg> ^problem-space <sp> ^state <ss>)
-->
  (goal <sg> ^operator <o>)
  (operator <o> ^name {textenter:operator} ; appropriate operator name
                      ; arguments or substructure
                      {?attribute-value-pairs}))
:end
