;;;; -*- Mode: Emacs-Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : taql-mode-defaults.el
;;;; Author          : Frank Ritter
;;;; Created On      : Thurs July 5
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Thu Sep 26 15:19:59 1991
;;;; Update Count    : 60
;;;; 
;;;;
;;;;		     How to load GNU Emacs Soar mode
;;;;
;;;;	Details on a default set of commands to load and use taql mode.
;;;; Novice users with vanilla tastes can just always load this, more 
;;;; advanced users will want to cut and paste the commands out of this
;;;; into their .emacs files
;;;;
;;;; TABLE OF CONTENTS
;;;;    i. 	Example default code to load taql-mode
;;;;    ii.     Necessary variables
;;;;
;;;;	I.	Example user settable variables that can be set
;;;;    II.	Example of setting a key bindings with a taql-hook
;;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;
;;;                   i.  Code to load taql mode iff necessary
;;;

;; NOTE:  this setting is site specific
(defvar taql-mode-home-directory
  (expand-file-name "/afs/cs/project/soar/5.2/emacs/taql/2.1")
  "Explicit pathname to the directory containing this and other files of the
TAQL Emacs mode.")

;; relative pathname off of soar-mode
(setq taql-ilisp-subdirectory "ilisp/4.11")


;; soar-gnu-directory should be cons'ed onto the path only once 
;; per .emacs file...
(if (not (memq taql-mode-home-directory load-path))
    (setq load-path 
          (cons taql-mode-home-directory
                load-path)))

;; autoload to load on the single entry point to the mode:
;;

(autoload 'taql-mode "taql"
   "taql-mode on a buffer" t)

(setq auto-mode-alist
      (cons '("\\.taql$" . taql-mode)
             auto-mode-alist))

;; I want my buffers in soar-mode too if possible,
;; else, lisp-mode
(setq use-soar-mode-if-available t)
(setq use-lisp-mode-if-available t)


;;;
;;;                   ii.   Variables that should be set
;;;

;; Prefix sequence for Soar commands.  All Taql and soar keyboard commands 
;; start with this  character, e.g. \C-^ t will insert-taql-construct
;; \C-^ is also \C-6, C-c ("\C-c") is another option, as is C-z ("\C-z").
;; If you change this, use a setq instead of a defvar.

(defvar soar-command-prefix "\C-c")


;;;
;;;	I.	example user settable variables that can be set
;;;

;; the column to start each clause in
;; the default value is 2
;; (setq taql-clause-indention 2)

;; indicates which file to load, taql314 (default), taql313 or taql312
;; (setq taql-version "taql314")

;; Bring the closing paren up to the next to last line. default is t
;; (setq taql-pull-closing-paren-up t)

;; Load the latest patches if they exist.  Default is t.
;; (setq taql-load-patches t)

;; Use a menu to get the construct name to insert with taql-insert-construct.
;; Default is t; nil results in query with autocompletion of name.")
;; (setq taql-insert-construct-use-menu t)


;;;
;;;                   II.   How to set keybindings
;;;

;;; If you wish to change the keybindings or add to them for buffers 
;;; in taql+soar-mode, put the changes
;;; on the taql-mode-hook in your .emacs file with code 
;;; comparable to the code below.  Note the special function calls to set
;;; commands that begin with the soar-command-prefix.
;;;
;;; For example, here are all the keybindings for taql-mode as
;;; they are set in taql.el.  If they are on the taql-mode-hook, they 
;;; will overwrite the mode table when the hook gets called on each buffer
;;; taql-mode gets called on.

; (if (not (boundp 'taql-mode-hook)) (setq taql-mode-hook nil))
;(setq taql-mode-hook
;   (cons '(lambda () 
;             (let ((ilisp-prefix soar-command-prefix))
;                  ;; here we use dynamic binding
;                  (define-key taql-mode-map  "\M-e" 'taql-expand-constructs)
;                  (ilisp-defkey taql-mode-map "\C-t" 'taql-insert-construct)
;                  (ilisp-defkey taql-mode-map "\C-a" 'taql-add-clause) 
;                  (ilisp-defkey taql-mode-map "\C-f" 'taql-fixup-construct) ))
;           taql-mode-hook))

;; I find dabbrev so useful I now always bind it to tab, and use C-q
;; TAB to insert a tab.  Remove the ";" to do so too.
;(global-set-key "\C-i" 'dabbrev-expand)


;;;
;;;	III. 	Advanced usage
;;;
;;; Don't try these things unless you know what you are doing.
;;;

;; This lets me load templates from my home account...
;; this hook expects a single function and gets called after taql-mode loads. 
;; (setq template-mode-load-hook
;;       'taql-template-init)
;; 
;; (defun taql-template-init ()
;;   "make template mode more manageable"
;;    (beep) (sit-for 4)
;;    ;; NOTE: that it first searches the path for any compiled files first, 
;;    ;; then searches the list again for uncompiled files.
;;    (setq tpl-load-path
;;          (append (list (concat "/afs/cs/user/ritter" ""))
;;                  tpl-load-path))
;;    )
;; 
;; You can compile other templates. They have to be first loaded into
;; a buffer already in taql-mode with a command like
;;     (load-tpl-library taql-version 'taql-mode)
;;  and then compiled with:
;;     (compile-templates 
;;        "/afs/cs/project/soar/5.2/emacs/taql/new/template/taql314.tpl")
