@make(article)
@device(postscript)
@style(size 10)
@set(page=1)

@begin(transparent, indent 0)
@tabclear()
@b[Gregg Yost@>9 January 1991]
@end(transparent)

@blankspace(0.5 inches)
@center{@b[TAQL Tutorial Problem Set 1]}

@b[Exercise 1:] Read the following sections of the TAQL 3.1.3 manual:
1, 2, 3, 4-4.6 (except 4.5.3), 4.9, 6.2, 6.7, and 6.8.

@b[Exercise 2:]  Work through the hands-on TAQL script appearing at the
end of these exercises.

@b[Exercise 3:]  Modify the monkey and bananas task so that it uses
means-ends-analysis search control instead of the search control rules
in smarter-monkey.taql.  To make this easier, we'll describe the
search control at the problem space level, and your TAQL
implementation should correspond very closely to this description.

Means-ends analysis works by preferring operators that reduce
differences between the current and desired state to operators that do
not reduce differences.  For the monkey and bananas task, there are
four important differences:

@begin(enumerate)
 @i[On-box difference:]  Exists when the monkey is not on the box.

 @i[Reach difference:]  Exists when the monkey has not reached for and
obtained the bananas.

 @i[Box location difference:]  Exists when the bananas and the box are in
different places.

 @i[Monkey location difference:]  Exists when the monkey and the box are in
different places.
@end(enumerate)

One implementation of means-ends analysis consists of three groups of
TCs:

@begin(enumerate)
The first group of TCs elaborates the current state with the differences
between it and the desired state.  A convenient implementation uses
augment TCs, one for each difference.  Each of these TCs detects one
of the differences, and elaborates the state with the name of that
difference when it is present.  Because augment TCs retract when their
conditions are no longer satisfied, these elaborations will go away
when the state changes so that the difference no longer exists.

@begin(multiple)
The second group of TCs elaborates proposed operators with the names
of existing differences that they can resolve.  For example, if the
state has the on-box difference, and the climb(on) operator is
proposed, that operator is elaborated with a notation that it can
resolve the on-box difference.  You will need four such TCs, as there
is exactly one operator that can resolve each of the four differences.

To do this, you will have to use conditions that match against
operators that have been proposed but not yet selected.  You can do
this by testing the acceptable preference for the operator.  For
example, the conditions

@begin(programexample)
:when ((goal ^operator <o> +)
       (operator <o> ^name reach))
@end(programexample)

match whenever the reach operator is proposed.
@end(multiple)

@begin(multiple)
The third group of TCs makes preferences for operators based on
whether or not they reduce differences.  For the first part of this
exercise, we want you to implement the simplest preference strategy:
all operators that reduce differences are better than all that don't,
but operators in each of these two classes are otherwise indifferent.
You can implement this strategy by first making all operators
indifferent, and, in addition, making operators that reduce
differences best.

Using this simple strategy does not take into account the fact that
not all differences are equally important.  For example, reducing the
two location differences is more important than reducing the two other
differences, and reducing the on-box difference is more important than
reducing the reach difference.  Without taking these priorities into
account, the monkey could climb on and off the box before it pushes it
to the bananas (for example).

For the second part of this exercise, we want you to implement a
preference strategy that takes into account this difference ordering.
If you have implemented the TCs in Groups 1 and 2 as we described,
you should be able to make this change by modifying only your Group 3
rules.  Operators that reduce either of the location differences
should be best, followed operators that reduce the on-box difference,
operators that reduce the reach difference, and finally operators that
reduce no difference at all.
@end(multiple)
@end(enumerate)

@newpage
@center{@b[Hands-on TAQL Script]}

Below is a script of a brief interaction with TAQL.  In it, we load
the monkey-and-bananas TAQL code and its search control, and run it.
Then we make a small change to the initial state so that the monkey
starts out in the same place as the box.  Throughout, we illustrate
some of Soar's interface commands.

Text in @p[bold italics] is typed by the user.  Text in @i[normal
italics] is explanatory material we have inserted.  All other text is
output by the computer.

You should go through this script on the computer to get a feeling of
how to interact with TAQL, before you attempt to write your own TAQL
programs.  To begin, copy mab.taql and smarter-monkey.taql to one of
your own directories, and connect to that directory.  You can find
these two files in the @i[mab] subdirectory of the tutorial
directory.@foot{The
tutorial directory is the taql-tutorial subdirectory of the directory
TAQL is installed in at your site.  It is also available in
/afs/cs.cmu.edu/project/soar/member/gry/taql-tutorial.}

@begin(verbatim)
[gry!styraco] @p[Soar5]

@begin(format, facecode i)
Start up Soar 5.  My .soar-init.lisp file loads the latest Soar patch
file.  To run TAQL 3.1.4, you must use Soar 5.2.0 with the November
12, 1990 (or later) patch file.
@end(format)

Allegro CL 3.1.12 [DEC 3100] (3/30/90)
Copyright (C) 1985-1990, Franz Inc., Berkeley, CA, USA

Soar 5.2.0 (internal release)
Created August 7th, 1990
Bugs and questions should be sent to Soar-bugs@@cs.cmu.edu
The current bug-list may be obtained by sending mail to
Soar-bugs@@cs.cmu.edu with the Subject: line "bug list"
Copyright (c) 1990.  All Rights Reserved.

Use of this software is permitted for non-commercial
research purposes, and it may be copied only for that use.
This software is made available AS IS, and Carnegie Mellon
University and the University of Michigan make no warranty
about the software or its performance.

See (soarnews) for news.
; Loading /usr0/gry/.soar-init.lisp.
; Loading /usr/misc/.Soar5/bin/Soar5.latest.patches.lisp.
; Fast loading /usr/misc/.Soar5/bin/Soar5.patches.of.18.Feb.91.fasl.
; Soar 5 patches of 18 Feb. 1991.
##############################################################################
#################
Soar 5.2.0 (internal release)
Created August 7th, 1990
Bugs and questions should be sent to Soar-bugs@@cs.cmu.edu
The current bug-list may be obtained by sending mail to
Soar-bugs@@cs.cmu.edu with the Subject: line "bug list"
Copyright (c) 1990.  All Rights Reserved.

Use of this software is permitted for non-commercial
research purposes, and it may be copied only for that use.
This software is made available AS IS, and Carnegie Mellon
University and the University of Michigan make no warranty
about the software or its performance.

See (soarnews) for news.
; Loading /afs/cs.cmu.edu/project/soar/5.2/0/lib/default/default.soar.
******************************************************************************
************************

<cl> @p[(load "~/taql/release/load.lisp")]

@begin(format, facecode i)
Now load TAQL.  This load file loads the TAQL compiler
and the TAQL runtime support productions.  The load.lisp
file that loads TAQL resides in the directory TAQL is
installed in at your site.
@end(format)

; Loading /usr0/gry/taql/release/load.lisp.

Disabling selected default productions: #*#*#*#*#*#*#*#**#*#*#**#*#*
Loading TAQL support productions: ********************************************
********************************************



TAQL 3.1.4 (internal release)
Created June 14, 1991
Copyright (c) 1990 Carnegie Mellon University.  All Rights Reserved.

Bug reports should be sent to Soar-bugs@@cs.cmu.edu.
Send comments on TAQL to Gregg.Yost@@cs.cmu.edu or Erik.Altmann@@cs.cmu.edu.


t 
<cl> @p[(load "mab.taql")]

@begin(format, facecode i)
Now load mab.taql and smarter-monkey.taql.  The asterisks printed
represent the Soar productions that the TAQL constructs compile into.
@end(format)

; Loading /usr0/gry/taql-tutorial/mab/mab.taql.
*****************************
t 
<cl> @p[(load "smarter-monkey.taql")]

; Loading /usr0/gry/taql-tutorial/mab/smarter-monkey.taql.
****
t 
<cl> @p[(taql-stats)]

@begin(format, facecode i)
TAQL-stats prints information on the TAQL release, the number of TCs
loaded, and the number of productions they compiled into.
@end(format)

TAQL 3.1.4 (internal release)
Created June 14, 1991

TAQL statistics on June  15, 1991
Allegro CL 3.1.12 [DEC 3100] (3/30/90) DEC 3100  id: 385 Ultrix STYRACO.SOAR.
CS.CMU.EDU

20 TCs (19 user, 1 default)
    compiled into 56 productions (33 user, 23 default)
t 
<cl> @p[(d 6)]

@begin(format, facecode i)
Run the task for six decision cycles.  By cycle six, it has set up the
initial state in the mab space.
@end(format)


0   G: g1 
1   P: p4 (top-space)
2   S: s5 
3   O: o13 (do-mab)
4   ==>G: g18 (operator no-change)
5      P: p26 (mab)
6      S: s35 
***break***
nil 
<cl> @p[(spo s35)]

@begin(format, facecode i)
Print out the augmentations of the initial state.
@end(format)

(state s35 ^box-at place2 ^at place1 ^on-box false)
nil
<cl> @p[(d 5)]

@begin(format, facecode i)
Run five more cycles, reaching the final state.
@end(format)

7      O: o38 (place2 move)
8      O: o45 (bananas move-box)
9      O: o62 (on climb)
10     O: o57 (reach)
11     O: o33 (final-state)
***break***
nil 
<cl> @p[(spo s35)]

@begin(format, facecode i)
Print out the final state.  The dummy-att* and final-state*
augmentations are used internally by TAQL.  Ignore them.
@end(format)

(state s35 ^dummy-att* true ^at bananas ^box-at bananas ^box-by-monkey true
           ^tried climbing-on ^on-box true ^reached bananas
           ^final-state* f24)
nil 
<cl> @p[(run)]

@begin(format, facecode i)
Run until the task halts.
@end(format)

       Space mab succeeded in goal g18.
12  O: o6 (halt)
Applied task operator o13 (do-mab).  Final state is s5.
End -- Explicit Halt
nil 
<cl> @p[(propose-initial-state mab*pis
      :space mab
      :new (on-box false)
      :new (at place1)
      :new (box-at place1))]

@begin(format, facecode i)
Now we make a change to the TC that sets up the initial state.  We
change it so that both the monkey and the box start out at place1,
rather than starting in different locations.  The "###***" printed
below indicates that the three productions compiled from the old
version of this TC are excised before loading in the three productions
compiled from the new TC.
@end(format)

###***
t
<cl> @p[(init-soar)]

@begin(format, facecode i)
Init-soar clears working memory and resets Soar to decision cycle
zero, in preparation for running the task again from the beginning.
@end(format)

t
<cl> @p[(d 6)]


0   G: g1 
1   P: p4 (top-space)
2   S: s5 
3   O: o13 (do-mab)
4   ==>G: g18 (operator no-change)
5      P: p26 (mab)
6      S: s35 
***break***
nil 
<cl> @p[(spo s35)]

@begin(format, facecode i)
Print out the initial state again.  Note that the monkey and box now
both start out at place1.
@end(format)

(state s35 ^box-at place1 ^at place1 ^on-box false)
nil
<cl> @p[(d 4)]

@begin(format, facecode i)
Run four more cycles.  Note that the first operator applied this time
moves the box to the bananas.  Last time, the monkey had to move to
the box before doing this.
@end(format)

7      O: o43 (bananas move-box)
8      O: o61 (on climb)
9      O: o56 (reach)
10     O: o33 (final-state)
***break***
nil 
<cl> @p[(spo s35)]

(state s35 ^dummy-att* true ^at bananas ^box-at bananas ^box-by-monkey true
           ^tried climbing-on ^on-box true ^reached bananas
           ^final-state* f24)
nil 
<cl> @p[(init-soar)]

t
<cl> @p[(d 6)]

0   G: g1 
1   P: p4 (top-space)
2   S: s5 
3   O: o13 (do-mab)
4   ==>G: g18 (operator no-change)
5      P: p26 (mab)
6      S: s35 
***break***
nil 
<cl> @p[(watch 0.5 'task)]

@begin(format, facecode i)
The watch command controls trace information.  Soar starts up with
(watch 0) in effect.  Watch level 0.5 prints the names of productions
that fire.  The 'task argument tells Soar to only trace user-defined
productions, and not Soar's default productions or the TAQL runtime
support productions.  This can make traces more readable, though often
when debugging you really do want to trace @r[all] of the productions.
@end(format)

t
<cl> @p[(d 1)]

@begin(format, facecode i)
Run one decision cycle.  In the first preference phase below, the
box-by-monkey elaboation is created, and two instances of the move
operator are proposed (one for each of the two locations the monkey is
not currently at).  In the second preference phase, instances of the
move-box and climb operators are created in response to the
box-by-monkey augmentation created in the prior phase.  Also in the
second phase, the two operators proposed in the prior phase are made
indifferent.  In the third preference phase, the operator that moves
the box to the bananas is made best, and all three operators proposed
on the prior phase are made indifferent.
@end(format)

--Preference Phase--
Firing 7:39 mab<>a<>mab*a*box-by-monkey<>new<>85
Firing 7:39 mab<>po<>mab*po*move<>85
Firing 7:39 mab<>po<>mab*po*move<>85
--Working Memory Phase--
--Preference Phase--
Firing 7:41 mab<>po<>mab*po*move-box<>85
Firing 7:41 mab<>po<>mab*po*move-box<>85
Firing 7:41 mab<>po<>mab*po*climb<>86
Firing 7:41 mab<>p<>mab*p*all-ops-indifferent<>operator-pref<>89
Firing 7:41 mab<>p<>mab*p*all-ops-indifferent<>operator-pref<>89
--Working Memory Phase--
--Preference Phase--
Firing 7:43 mab<>p<>mab*p*box-to-bananas<>operator-pref<>89
Firing 7:43 mab<>p<>mab*p*all-ops-indifferent<>operator-pref<>89
Firing 7:43 mab<>p<>mab*p*all-ops-indifferent<>operator-pref<>89
Firing 7:43 mab<>p<>mab*p*all-ops-indifferent<>operator-pref<>89
--Working Memory Phase--
--Preference Phase--
--Working Memory Phase--
--Quiescence Phase--
7:47 DECIDE operator o43
7      O: o43 (bananas move-box)
***break***
nil 
<cl> @p[(watch 0)]

@begin(format, facecode i)
Reset the trace level to its default value.
@end(format)

t
<cl> @p[(d 1)]

8      O: o61 (on climb)
***break***
nil
<cl> @p[(ptrace mab*po*climb)]

@begin(format, facecode i)
Ptrace causes selected production names to be printed whenever they
fire (or retract, for productions whose effects are undone up
retraction, such as search control productions).  The mab*po*climb TC
compiles into two productions, so both of those productions will be
traced.
@end(format)

Rule Traces:
  (mab<>po<>mab*po*climb<>85 mab<>po<>mab*po*climb<>86)
Object Traces:
  nil
Tme Traces:
  nil
nil 
<cl> @p[(d 1)]

@begin(format, facecode i)
In this decision cycle, mab<>po<>mab*po*climb<>86 retracts,
withdrawing the operator for climbing onto the box.  It
retracts because the conditions under which it fired are no
longer satisfied (the monkey is now on the box).  Also
mab<>p-o<>mab*po*climb<>85 fires to propose climbing off of
the box, now that the monkey has climbed onto it.
Climbing off doesn't get selected though, reach does.
@end(format)

Retracting 9:67 mab<>po<>mab*po*climb<>86
Firing 9:69 mab<>po<>mab*po*climb<>85
9      O: o56 (reach)
***break***
nil 
<cl> @p[(unptrace)]

@begin(format, facecode i)
Stop tracing the selected productions.
@end(format)

t
@begin(comment)
GRY:  A few lines of this spilled to the top of the next page, and
      keeping it there didn't seem worth it...
> @p[(run)]

10     O: o33 (final-state)
       Space mab succeeded in goal g18.
11  O: o6 (halt)
Applied task operator o13 (do-mab).  Final state is s5.
End -- Explicit Halt
nil 
@end(comment)
@end(verbatim)
