
;;; Concatenated from type module "features" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/features/new/features.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/features/new/features.lisp
;;;
;;;		i.	Abstract
;;;
;;;	Define the features that control the compilation of Soar.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	II.	:DSM
;;;	III.	:SOAR-TIMES
;;;	IV.	:test-gelm
;;;     V.      :TI 
;;;
;;;


;;;
;;;		iii.	Declarations
;;;

(eval-when (compile load eval)
  (pushnew :Soar5 *features*)
  (pushnew :sx *features*)
 )


;;;
;;;
;;; Caution, Xlib is a new feature for CLX and may not yet be standard. -BGM 9/16/88



;;;
;;;		II.	:DSM
;;;

(eval-when (compile load eval)
;  (pushnew :DSM *features*) No longer neccesary.
;  (pushnew :DSMMACROS *features*)
  #+(or)  ;switch in if you want yarn to use a slots table.
  (pushnew :SLOTS *features*)
 )

(eval-when (compile)
 (format t "~% Compiling for DSM.")
)

(eval-when (load)
 (format t "~% Loading for DSM.")
)

(eval-when (compile)
)

(eval-when (load)
)


;;;
;;;		III.	:SOAR-TIMES
;;;
;;; This feature turns on a timing package.
;;;

(eval-when (compile load eval)
 ;(pushnew :soar-times *features*)
)

(eval-when (compile)
 #+:SOAR-TIMES(format t "~% Compiling with SOAR-TIMES.")
)

(eval-when (load)
 #+:SOAR-TIMES(format t "~% Loading with SOAR-TIMES.")
)

;;;
;;;		IV. :test-gelm
;;;
;;;	This feature turns on a package that test the distribution of 
;;; calls to GELM so that we may accurately speed up gelm across all machines.
;;;

(eval-when (compile load eval)
; (pushnew :test-gelm *features*)
)

(eval-when (compile)
 #+:TEST-GELM(format t "~% Compiling with TEST-GELM.")
)

(eval-when (load)
 #+:TEST-GELM(format t "~% Loading with TEST-GELM.")
)



;;;
;;;		V.	:TI
;;;
;;; added section. -KAM 6/14/89

(eval-when (compile load eval)
  ;(pushnew :TI *features*)
 )

(eval-when (compile)
 #+:TI(format t "~% Compiling for TI.")
)

(eval-when (load)
 #+:TI(format t "~% Loading for TI.")
)



;;; Concatenated from type module "package" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/package/new/package.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	package.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/package/new/package.lisp
;;;
;;;		i.	Abstract
;;;	This file, package.lisp, creates the Soar package.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Make Package Soar
;;;


;;;
;;;		iii.	Declarations
;;;

;;; Changed this and two other references to package "USER" in this file
;;; in preparation for imminent ANSI CL. Fixes bug number 135,
;;; ID 02Jul90-11.24.33 -- TFMcG 5-Jul-90

#-:TI
(if (find-package "COMMON-LISP-USER")
    (in-package "COMMON-LISP-USER")
    (in-package "USER"))

#+:TI
 (in-package "USER")



;;;
;;;		I.	Make Package Soar
;;;

(eval-when (eval compile load)
  (unless (find-package "SOAR")
    (make-package "SOAR"
                  :use (if (find-package "COMMON-LISP")
                         "COMMON-LISP"
                         "LISP"))))

#+:sx(eval-when (eval compile load)
       (make-package "SX"
			  :nicknames '("SIX")
                          :use (if (find-package "COMMON-LISP")
                                      "COMMON-LISP"
                                      "LISP"))
       (if (not (find-package "KR"))
           (make-package "KR"))
       (if (not (find-package "OPAL"))
           (make-package "OPAL"))
     )

(eval-when (eval compile load)
   (in-package "SOAR"))

(eval-when (eval compile load)
;; Teach SOAR to load SEM.
 (when (find-package "SEM")
  (use-package "SEM" "SOAR")))

(defvar *soar-package* (find-package "SOAR") "The Soar package.")

(eval-when (eval compile load)
   #+:lucid (shadowing-import '(soar::name soar::class)
			      (if (find-package "COMMON-LISP-USER")
				  "COMMON-LISP-USER"
				"USER"))
   #+:ccl (shadowing-import '(soar::object soar::value soar::item soar::@)
			      (if (find-package "COMMON-LISP-USER")
				  "COMMON-LISP-USER"
				"USER"))
   #+allegro (shadowing-import '(soar::top-state)
			      (if (find-package "COMMON-LISP-USER")
				  "COMMON-LISP-USER"
				"USER"))
   #+:TI (shadowing-import '(soar::^ soar::|\\| soar::name soar::serial 
 				     soar::standard soar::wait) "USER")
   (export '(***break***
	     <<
	     >>
	     <>
	     {
	     }
	     ^
	     -->
	     <=>
	     |\\| 

	     *alternate-readtable*
	     *chunk-classes*
	     *chunk-free-problem-spaces*
	     *chunks*
             *default-user-select*
	     *max-chunk-conditions*
	     *max-elaborations*
	     *mem-array-size*
	     *pcount*
	     *pfired*
             *pnames*
	     *spo-default-depth*
	     *subgoal-tabs*
	     *warning*
	     *watch-free-problem-spaces*
	     better
	     desired
	     success

	     accept
	     acceptable
	     add-input
             after-dc-hook
             ambiguous
	     applied 
	     atom
	     attribute
             attribute-value

	     back-trace
	     best
	     better
	     bind
	     bottom-up

	     call2
	     carriage-control
	     change-input-value
	     change-input-value-and-old
	     char-mode
	     choices
             class
	     closefile1
             complete-in-footprint
	     compute
	     constraint-failure
             context-object-name
             context-object-name-p
	     crlf
	     cc
	     current-input-link

	     d
	     decide
	     decide-trace
             decision-cycle-count
	     default
	     default-state-copy
	     delete-input
	     desired
	     draw
	     duplicate-of*
	     duplicates*
	     declare-objects
             dwi
	     
	     elaborate
             elaboration-cycle-count	  
	     evaluate-object
	     evaluation
	     excise
	     excise-chunks
	     excise-task
	     external

             find-production-ps 
	     first
	     flushpr
	     full-matches
	     full-trace
	     get-input-link
	     get-output-values
	     get-output-augmentations
	     goal

	     halt
	     higher

	     instance
	     impasse 
	      conflict
	      constraint-failure
	      multi-choice
	      no-change
	      no-choice
	      tie

      	      in
	      indifferent
	      init-context
	      init-edt
	      init-soar
              init-soar-hook
	      init-task
	      init-wm
	      io-state
	      item
	      implement-evaluate-object
	      
	      last-chunk
	      last-justification
	      list-chunks
	      list-justifications
	      lispload
	      lispsyntax
	      learn
	       on 
	       off 
	       never
	       all-goals
	       bottom-up
	       full-print
	       full-trace
	       print
	       trace
	       noprint
	       notrace
	      load-soar-init-file
	      lose
	      lower
	       
              macrocycle
               macrocycle-max-dc
               macrocycle-type
               macrocycle-n
               macrocycle-ps-types
               ;; FUNCTIONS
               after-macrocycle-hook
               m
               set-macrocycle
	      make
              make-io-object-symbol
              make-constant-symbol
	      match-input
	      memories
              merge-Events-In-Sequence
              miscellaneous
              ms
	      multi-attributes
	      multiple

	      name
	      new-input-link
	      next
	      no-change
	      none
	      numeric-value

	      object
	      openfile1
	      operator
	      one-level-attributes
	      out
	      operator-applications
	      operator-application
	      operator-creation
	      operator-modification
	      op-apps
	      op-crs
	      declare-p
	      results
	      non-results
	      goal-traces
	      rule-traces
	      

	      parallel
	      partial-success
	      partial-failure
	      pbreak
	      pclasses
	      pclass
	      pcount
	      pfired
	      pgs
	      pi
	      pm
	      po
	      pr
	      pop-goal
	      possible-operator-application
	      possible-operator-creation
	      possible-operator-modification
	      ppwm
              preference
	       ~
	       ! 
	       &
               @
	       ;; The others are lisp mathematical operators and so appear in the lisp package, that
	       ;; both the Soar package and the user package use. -BGM 1/30/90
              preferences
              print-compiled-p
              print-stats
	      problem-space 
	      proposed-operators
	      ptrace

	      quiescence

              r
	      restart-soar
	      require-success
	      required-success
	      role
	      rjust
	      run
              run-hooks
	      run-task
	      reference

	      serial
	      selection
	      set-break-char
	      set-carriage-control
	      set-carriage-control-mode
	      set-char-mode
	      set-edt
	      set-events
	      set-input-functions
	      set-input-mappings
	      set-io-stream
	      set-learning-choice
	      set-macro-character
	      set-output-mappings
	      set-print-events
	      set-print-times
	      set-standard-text-input
	      set-standard-text-input-stream
	      set-standard-text-output
	      set-standard-text-output-stream
	      set-tab-settings
	      set-text-input
	      set-text-input-stream
	      set-text-output-stream
              set-text-output
	      set-time
	      set-trace-tabto
	      set-user-select
              settings
	      selection
	      slot
	      smake
	      smatches
	      soar-format
	      soar-genid
	      soar-genvar
	      soar-genpname
	      soar-greeting
              soar-read-n
	      soar-menu
              soar-version
	      #+:TI soar-bind
	      soarload
	      soarresetsyntax
	      soarsyntax
	      soarsyntaxp
	      soarnews
	      sp
	      sp?
              sp-or-tc?       
	      space
	      spm
	      spo
	      spop
	      sppwm
	      spr
	      spr-spacep
	      sremove
	      sremove2
	      state
              status
	      start-default
	      stop-default
	      success
	      supergoal
	      superproblem-space
	      superoperator
	      superstate
	      swm
	      symbolic-value
               failure
	       success
	       prohibit-failure
	      suspend-current
	      activate-suspend
	      standard

	      tab
	      tab-settings
	      tabstop
	      tabto
	      tally
	      text-command
	      text-environment
	      text-input
	      text-input-stream
	      text-output
	      text-output-stream
	      text
	      tie
	      tried
              toggle-soarsyntax
	      top-goal
	      top-ps
              top-state
	      trace
	      trace-attributes
	      type

	      undecided
	      unpbreak
	      unptrace
	      untrace-attributes
	      user-select

	      value 
              variablep

	      wait
	      watch
	      what?
	      win
	      wm
	      wme-attribute
	      wme-class
	      wme-id
	      wme-value
              wm-structure?
	      write
	      write1
	      write1+
	      write2
	      write2+
	     )
	   (find-package "SOAR"))
   (use-package "SOAR"
 		#-:TI
  		(if (find-package "COMMON-LISP-USER")
  		    "COMMON-LISP-USER"
 		    "USER")
 		#+:TI
 		(in-package "USER")))

;;; Give Soar the external symbols of the SEM package for test coding purposes here at CMU. -BGM 9/5/89
(eval-when (eval load compile)
  (when (find-package "SEM")
   (use-package "SEM" "SOAR")))

(eval-when (eval compile load)

   (shadowing-import '(soar::top-state)
                     (if (find-package "COMMON-LISP-USER")
                                         "COMMON-LISP-USER"
                                         "USER"))

   (export '( 
              *alternate-readtable*
              *default-user-select*
              dwi
              init-soar-hook
              last-justification
              list-justifications
              make-io-object-symbol
              merge-Events-In-Sequence
              no-change
              *pnames*
              top-state
              text-environment
              text-command
              text-input-stream
              text-output-stream
              settings
              status
              set-text-output-stream
              variablep
              ) 
           (find-package :soar))
)

(eval-when (eval compile load)
  (if (find-package "COMMON-LISP-USER")
    (in-package "COMMON-LISP-USER")
    (in-package "USER")
    )  
)

;;; Concatenated from type module "macros" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/macros/new/macros.lisp".
(in-package "SOAR")




                                               
;;; <SOAR5.MACROS>
;;; Declarations, records, and macros used by more than one module.
                          

;;; GENERAL DECLARATIONS.

;; for full-matches bug. remove when 4.5.3. installed.
(defvar *indent* 0)

;; moved from Soar4.
(eval-when (compile eval load) (proclaim '(optimize (speed 3) (safety 0))))

(deftype timetag () 'fixnum)                                                     
(deftype timetag-or-NIL () '(or null fixnum))
(deftype integer-or-NIL () '(or null integer))
(deftype logical () '(member T NIL))
(deftype true () '(member T))
(deftype false () '(member NIL))
                                     

(defvar graphic-display? NIL "A boolean indicating whether the DSI is up")
(defvar *chunks* () "")
(defvar *pnames* () "")
(defvar *user-pnames* () "")
(defvar *never-learn* t "")
(defvar *added-tokens* 0 "The number of tokens added to the network.")
(defvar *right-added-tokens* 0 "The number of right tokens added to the network.")
(defvar *left-added-tokens* 0 "The number of left tokens added to the network.")
(defvar *removed-tokens* 0 "The number of tokens removed.")
(defvar *right-removed-tokens* 0 "The number of right tokens removed.")
(defvar *left-removed-tokens* 0 "The number of left tokens removed.")
(defparameter preferences-result nil
  "where preference results are stored.")

;;; TME: temporary memory element.    all ames and all pmes are tmes.                              
;;; WME: working memory element.      all ames and some pmes are wmes.
;;; AME: augmentation memory element. all ames are tmes. all ames are wmes.
;;; PME: preference memory element.   all pmes are tmes. some pmes are wmes.
(deftype tme ()
             "Temporary memory element. Includes p(reference)mes, a(ugmentation)mes, w(orking)mes."
             'list)    ;temporary memory element
(deftype tme-or-NIL () '(or null tme))
(deftype tme-class () 'symbol)
(deftype tme-object () 'symbol)
(deftype tme-attribute () '(or symbol fixnum string))
(deftype tme-type () 'symbol)
(deftype tme-value () '(or symbol fixnum string))
(deftype tme-value-or-NIL () '(or null symbol fixnum string))
(deftype tme-reference () 'tme-value)
;;; gme = goal memory element (problem-space, state ,operator)
(deftype gme-attribute () 'symbol)
(deftype gme-value () 'symbol)
(deftype gme-reference () 'gme-value)

(deftype slot () 'list)
(deftype slot-or-NIL () '(or null list))

                                  
#+:TI
(eval-when (compile eval load) (proclaim '(special *debug-print-length*)))
#+:TI
(eval-when (compile eval load) (proclaim '(special *debug-print-level*)))

#+:sx
(eval-when (compile eval load) (proclaim '(special sx::*sx*)))
#+:sx
(eval-when (compile eval load) (proclaim '(special sx::*top-goal*)))
#+:sx
(eval-when (compile eval load) (proclaim '(special sx::cleanup-chunks)))
#+:sx
(eval-when (compile eval load) (proclaim '(special sx::graphic-display-window)))
#+:sx
(eval-when (compile eval load) (proclaim '(special sx::soar-status-window)))


#+:sx(eval-when (compile eval load) (proclaim '(ftype (function nil nil) sx::SX-SOARSYNTAX-HOOK)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::SX-SOARRESETSYNTAX-HOOK)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::SX-EXCISE-CHUNKS)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) sx::FIND-OPERATOR-PROBLEM-SPACE)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) sx::GET-SX-ITEM)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::SX-SIGNAL-PREFERENCE-PHASE-START)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::SX-SIGNAL-QUIESCENCE-PHASE-START-HOOK)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function (tme-object gme-attribute gme-value) nil) sx::ADD-CONTEXT-ITEM)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function (symbol) nil) sx::ADD-CHUNK)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::CHECK-SX-X-SERVER)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::SX-AFTER-ELABORATION-HOOK)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::SX-DSM-WATCH-HOOK)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function (symbol) nil) sx::FIRE-GRAPHIC-RULE)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::CLEAR-GRAPHIC-DISPLAY)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::RESET-PSCM-STATS)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::UPDATE-GRAPHIC-WINDOWS)))
#+:sx(eval-when (compile eval load) (proclaim '(ftype (function () nil) sx::SX-SET-MACROCYCLE-HOOK)))

;;; CONSTANTS.

(defconstant require-token '! "Type symbol for require preference.")
(defconstant prohibit-token '~ "Type symbol for prohibit preference.")
(defconstant accept-token '+ "Type symbol for acceptable preference.")
(defconstant reject-token '- "Type symbol for reject preference.")
(defconstant reconsider-token '@ "Type symbol for reconsider preference.")
(defconstant better-token '> "Type symbol for better preference.")
(defconstant best-token '> "Type symbol for best preference.")
(defconstant worse-token '< "Type symbol for worse preference.")
(defconstant worst-token '< "Type symbol for worst preference.")
(defconstant indifferent-token '= "Type symbol for unary indifferent preference.")
(defconstant indifferent-to-token '= "Type symbol for binary indifferent preference.")
(defconstant parallel-token '& "Type symbol for unary parallel preference.")
(defconstant parallel-to-token '& "Type symbol for binary parallel preference.")



;;; MACROS.


;;; SOAR5 WME ACCESS.
(defmacro wme-type (wme) `(nth 4 ,wme))           
;; preferences only.
(defmacro wme-reference (wme) `(nth 5 ,wme)) 
   
;;; WME ACCESS. 
(defmacro wme-class (wme) `(nth 0 ,wme))
(defmacro wme-id (wme) `(nth 1 ,wme))
(defmacro wme-object (wme) `(nth 1 ,wme))
(defmacro wme-attribute (wme) `(nth 2 ,wme))
(defmacro wme-role (wme) `(nth 2 ,wme))
(defmacro wme-value (wme) `(nth 3 ,wme))

;;; SOAR5 TME ACCESS.
(defmacro tme-type (wme) `(nth 4 ,wme))           

;; preferences only.
(defmacro tme-reference (wme) `(nth 5 ,wme)) 
 
(defmacro tme-reference-p (pme)
 (declare (type tme pme))    
 ;; must distinguish no reference from reference that is NIL.
 `(not (null (cdr (cddddr ,pme))))
)

   
;;; TME ACCESS. 
(defmacro tme-class (wme) `(nth 0 ,wme))
(defmacro tme-id (wme) `(nth 1 ,wme))
(defmacro tme-object (wme) `(nth 1 ,wme))
(defmacro tme-attribute (wme) `(nth 2 ,wme))
(defmacro tme-role (wme) `(nth 2 ,wme))
(defmacro tme-value (wme) `(nth 3 ,wme))


#+(or)
(defun gme-value= (x y)
 ;; for context objects.
 (eq x y)
)

(defun tme-value= (tme-value1 tme-value2)
 ;; Fixed by GAP to match RETE Bug #06Sep90-14.55.53 27/Sep/90
 (declare (type tme-value tme-value1 tme-value2))
 (cond ((and (symbolp tme-value1) (symbolp tme-value2))
        (eq tme-value1 tme-value2))
       ((and (numberp tme-value1) (numberp tme-value2))
        (eql tme-value1 tme-value2))
       ((and (stringp tme-value1) (stringp tme-value2))
        (string= tme-value1 tme-value2))       
       #+(or)
       ((and (characterp tme-value1) (characterp tme-value2))
        (char= tme-value1 tme-value2))
       (T
        NIL))
)


(defun tme-attribute= (tme-value1 tme-value2)
 ;; Fixed by GAP to match RETE Bug #06Sep90-14.55.53 27/Sep/90
 (declare (type tme-value tme-value1 tme-value2))
 (cond ((and (symbolp tme-value1) (symbolp tme-value2))
        (eq tme-value1 tme-value2))
       ((and (numberp tme-value1) (numberp tme-value2))
        (eql tme-value1 tme-value2))
       ((and (stringp tme-value1) (stringp tme-value2))
        (string= tme-value1 tme-value2))
       (T
        NIL))
)


#+(or)
(defun gme-attribute= (x y)
 ;; for context objects.
 (eq x y)
)
  


;;; GELM.
(defmacro gelm (global-lhs index) 
 (declare (list global-lhs)
          (cons index))

 ;; selects a wme element from an instantiated lhs.
 ;; global variables representing the lhs are passed to gelm.
 ;; (first index) selects wme.
 ;; (rest index) selects wme element.

 `(prog ((wme-index (first ,index))
         (lhs ,global-lhs))
   (declare (integer wme-index)
            (list lhs))
  
   ;; why it is good to search the lhs five wmes at a time
   ;; is unknown.

   ;; select wme.
   wmeloop
    (and (eql wme-index 0)
     		  (go wme-element))
    (setf lhs (rest lhs))
    (and (eql wme-index 1)
     		  (go wme-element))
    (setf lhs (rest lhs))
    (and (eql wme-index 2)
     		  (go wme-element))
    (setf lhs (rest lhs))
    (and (eql wme-index 3)
     		  (go wme-element))
    (setf lhs (rest lhs))
    (and (eql wme-index 4)
     		  (go wme-element))
    (setf wme-index (- wme-index 4))
    (go wmeloop)
   wme-element
    ;; select wme element.
    (setf lhs (first lhs))
    (return
     (case (rest ,index)
      (0 (first lhs))
      (1 (second lhs))
      (2 (third lhs))
      (3 (fourth lhs))
      (4 (fifth lhs))       
 			  (otherwise NIL)))
))

(eval-when (eval load compile)
(defun substitute-into-backquote (arguments backquote-form)
 ;; this does not work for parameter lists containing &optional, &key,...
 (apply `(lambda ,arguments ,backquote-form) 
        arguments)
))                             
 


(defmacro defdsmmacro (name parameters argument-types return-type declare body)

 ;; used to define a form as either a macro or a function, depending upon
 ;; settings in *features*.
 ;; this does not work for parameter lists containing &optional, &key,...
 ;; there can be only one declare statement before the macro body.
 ;; body is the backquoted macro body.

  ;; define as macro.                          
  #+:DSMMACROS
  ;; these arguments are used only if form is to be compiled as a function.
  (declare (ignore argument-types return-type))
  #+:DSMMACROS
 `(defmacro ,name ,parameters ,declare ,body)
  ;; define as function.
  ;; compiling as functions generates some "assuming special" warnings;
  ;; they can be ignored; this mode is for development and testing only,
  ;; anyway.
  #-:DSMMACROS
  (let ((body (substitute-into-backquote parameters body)))
  `(eval-when (eval load compile)
    (eval-when (compile eval load) (proclaim '(ftype (function ,argument-types ,return-type) ,name)))
    (defun ,name ,parameters ,declare ,body)))
) 




;;; Concatenated from type module "utilities" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/utilities/new/utilities.lisp".

(in-package "SOAR")



;;; <UTILITIES.FUNCTIONS>



;;; UTILITIES MODULE: FUNCTIONS.

;;; MODULE FUNCTIONS.


;;; SLOTS.


;;; WMES.

(eval-when (compile eval load) (proclaim '(ftype (function
                     (tme-class tme-object tme-attribute tme-value 
                       &optional tme-type tme-value)
                     true) make-tme)))
(defun make-tme (class object attribute value
                      &optional type (reference NIL reference-p))
 (declare (type tme-class class)
          (type tme-object object)
          (type tme-attribute attribute)
          (type tme-type type)
          (type tme-value value reference))  
 (if type
     (if reference-p
        (list class object attribute value type reference)
        (list class object attribute value type))
     (list class object attribute value NIL))
) 




;;; PRODUCTION TRACE ACCESSORS.
                                                               
;;; Access functions for production traces represented as hash table. 



;;; EQUALITY PREDICATES.

(eval-when (compile eval load) (proclaim '(ftype (function (slot slot) logical) slot=)))
(defun slot= (slot1 slot2)                         
 (declare (type slot slot1 slot2))
 (and
  (eq (first slot1) (first slot2))
  (tme-attribute= (second slot1) (second slot2)))
)       

(eval-when (compile eval load) (proclaim '(ftype (function (tme tme) logical) augmentation=)))
(defun augmentation= (augmentation1 augmentation2)
 (declare (type tme augmentation1 augmentation2))
 (and 
  (tme-value= (wme-value augmentation1) (wme-value augmentation2))
  (eq (wme-object augmentation1) (wme-object augmentation2))
  (tme-attribute= (wme-attribute augmentation1) (wme-attribute augmentation2))
  (eq (wme-class augmentation1) (wme-class augmentation2)))
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme tme) logical) preference=)))
(defun preference= (preference1 preference2)
 (declare (type tme preference1 preference2))
 (and 
  (tme-value= (wme-value preference1) (wme-value preference2))       
  (eq (wme-object preference1) (wme-object preference2))
  (tme-attribute= (wme-attribute preference1) (wme-attribute preference2))
  (eq (wme-type preference1) (wme-type preference2))
  (tme-value= (wme-reference preference1) (wme-reference preference2))
  (eq (wme-class preference1) (wme-class preference2)))
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme tme) logical) tme=)))
(defun tme= (tme1 tme2)
 (declare (type tme tme1 tme2))

 (cond ((tme-type tme1)
        (cond ((tme-type tme2)
               ;; both preferences.
               (preference= tme1 tme2))
              (T
               NIL)) )
       ((null (tme-type tme2))
        ;; both augmentations.
        (augmentation= tme1 tme2)) 
       (T
        NIL))
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme tme) logical) fuzzy-tme=)))
(defun fuzzy-tme= (tme1 tme2)
 (declare (type tme tme1 tme2))

 ;;; for comparison of wmes without regard to the distinction
 ;;; between preferences and wmes.
 ;;; any preference for an augmentation is equal to any other preference
 ;;; for that augmentation and to the augmentation itself.

 (and 
  (tme-value= (tme-value tme1) (tme-value tme2))
  (eq (tme-object tme1) (tme-object tme2))
  (tme-attribute= (tme-attribute tme1) (tme-attribute tme2))
  (eq (tme-class tme1) (tme-class tme2)))
)
 


;;; MISCELLANEOUS.

(eval-when (compile eval load) (proclaim '(ftype (function (tme-object tme-value) logical) proper-subobject-p)))
(defun proper-subobject-p (superobject subobject)                
 (declare (type tme-object superobject)
          (type tme-value subobject))
 (and (proper-symbol-p subobject)
      (not (eq subobject superobject)))
)

(eval-when (compile eval load) (proclaim '(ftype (function () true) start-utilities)))
(defun start-utilities ()
 ;; system startup.
 T
)

(eval-when (compile eval load) (proclaim '(ftype (function () true) restart-utilities)))
(defun restart-utilities ()
 ;; system restart.
 T
)

(eval-when (compile eval load) (proclaim '(ftype (function () true) retask-utilities)))
(defun retask-utilities ()
 ;; task restart.
 T
)





;;; Concatenated from type module "mutilities" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mutilities/new/mutilities.lisp".
(in-package "SOAR")




;;; <UTILITIES.MACROS>

#|


 Modules: Utilities: Contents

          
 Introduction

 Functions
   Slots
   Wmes
   Equality Predicates
   Timetags
   Miscellaneous



 Modules: Utilities: Introduction


 Utilities contains general system utilities.

|#


;;; UTILITIES MODULE: MACROS. 


;;; MODULE DESCRIPTION.
;;;  Utility functions. 
                       

;;; MODULE MACROS.


;;; SLOTS.


(defdsmmacro make-slot (object attribute)
                       (tme-object tme-attribute) slot
 (declare (type tme-object object)
          (type tme-attribute attribute))
 `(list ,object ,attribute)
)

                                    
(defdsmmacro slot-object (slot)
                         (slot) tme-object                    
 (declare (type slot slot))
 `(first ,slot)
)
                      

(defdsmmacro slot-attribute (slot)
                            (slot) tme-attribute
 (declare (type slot slot))
 `(second ,slot)
)



;;; TIMETAGS.
                                    

(defdsmmacro timetag (wme)
                     (tme) (or null fixnum)                          
 ;; used by tracer.
 ;; also called by creation-time, which the non-DSM 
 ;; functions use; in non-DSM Soar, wmes are eq, but not in DSM.
 ;; augmentation wmes must have trailing NIL
 ;; (fifth field used only by preference wmes).     
 (declare (type tme wme))
 `(rest (assoc ,wme
               (get (wm-hash ,wme) 'wmpart*)
               :test #'equal))
)



;;; MISCELLANEOUS.
                


(defdsmmacro logicize (expression)
                      (T) logical
 (declare)
 `(cond (,expression
         T)
        (T
         NIL))
)


                     
(defdsmmacro proper-symbol-p (value)
                             (atom) atom                   
 (declare (atom value))
 `(and ,value (symbolp ,value))
)


                           
(defdsmmacro proper-subset-p (x y)
                             (list list) (or logical list)                                    
 (declare (list x y))
 `(and (null (set-difference ,x ,y))
       (set-difference ,y ,x))
)


                     
(defdsmmacro set= (x y)
                  (list list) (or logical list)                                     
 (declare (list x y))
 `(and (subsetp ,x ,y)
       (subsetp ,y ,x))
)

                     
(defdsmmacro atomize (list)
                     (list) (or atom list)                              
 (declare (list list))
 `(cond ((eql (length ,list) 1) 
         (first ,list))
        (T
         ,list))
)
 


(defmacro push-unless-null (item stack)
  ;; Turned from a DSM defmacro to a macro as this wasn't supposed to push onto the 
  ;; argument of a defun. -BGM 2/5/90
 (declare (list stack))
 `(if ,item
      (push ,item ,stack)
      ,stack)
)

                      





;;; Concatenated from type module "mtext" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mtext/new/mtext.lisp".
(in-package "SOAR")



;;; <TEXT.MACROS>


;;; TEXT (CONTEXT and SUBTEXT) MODULE: MACROS.


;;; DESCRIPTION.
;;;  Defstructs, deftypes, etc. for the TEXT (CONTEXT AND SUBTEXT) module.
;;;  These definitions are used throughout the system, but mostly by TEXT.

#|
  
 Modules: Text: Contents

          
 Introduction

 Data
   Records
     Aug
     Context-Fixed-Aug
     Pnode
     Preferences
     Anode
     Onode
     Gnode

 Functions
   Attribute Record (Anode) Utilities.



 Modules: Text: Introduction


 Text contains utilities and data types shared by the Context and Subtext
 modules.



 Modules: Text: Data: Records: Aug


   Augmentation Record (AUG).

     Represents an augmentation that is not a fixed goal augmentation.
     The pmes are stored in preference records.

     Contains these fields:
       Ame. The ame.
       Timetag. The ame's timetag.



 Modules: Text: Data: Records: Context-Fixed-Aug 


   Fixed Augmentation Record (CONTEXT-FIXED-AUG).

     Represents one of the fixed goal augmentations:
       object, attribute, impasse, item, choices, applied, or quiescence.

     Contains these fields:

       Ame. The ame.

       Timetag. The ame's timetag.

       Pme. The ame's simulated supporting pme. These are used to create
         simulated production traces so that fixed goal augmentations
         are backtraced through. Not all of these are backtraced through,
         but pmes are created for all of them anyway.

         These are the fixed ames that are backtraced through:
           Applied Augmentation. Backtraced through to the reconsider 
             preference that triggered its creation.
           Quiescence Augmentation. Backtraced through to a preference
             having as class 'this-is-a-hack and as object the top goal.
           Impasse Augmentation. The impasse augmentation for a constraint
             failure impasse is backtraced through to the constraint preferences
             (prohibits and requires) for the impassed slot.
           Item Augmentation. The item augmentations for tie and conflict
             impasses are backtraced through to the acceptable preferences
             for the impassed items.



 Modules: Text: Data: Records: Pnode

   
   Preference Record (PNODE).

     Represents a preference. 

     Contains these fields:
       Pme. The supporting pme. 
       Timetag. The pme's timetag. Timetags are assigned to pmes upon creation
         even if the pme will not be added to working memory.
       I-Support. A count of the number of instantiations supporting the preference.
       O-Support. The list of goals that give this preference O-support




 Modules: Text: Data: Records: Preferences


   Preferences Record (PREFERENCES).

     Represents all the preferences for a slot except acceptable and parallel
     preferences.

     Acceptable and unary parallel preferences are kept in the attribute record
     for a slot. If there are other preference types for a slot, a preferences
     record is created to hold them, which is itself kept in the attribute
     record. This to avoid creating fields for all the preference types for
     each slot, whether needed or not. 

     A better name for this record would have been "Pnodes".

     Contains these fields:
       Requires. A list of the require pnodes for a slot.
       Prohibits. A list of the prohibit pnodes for a slot.
       Reconsiders. A list of the reconsider pnodes for a slot.
       Rejects. A list of the reject pnodes for a slot.
         These are ordinary reject preferences - not OA-rejects. 
       Betters.  A list of the better pnodes for a slot.
       Bests. A list of the best pnodes for a slot.
       Worsts. A list of the worst pnodes for a slot.
       Indifferents. A list of the indifferent pnodes for a slot.
       Indifferent-Tos. A list of the binary indifferent pnodes for a slot.
       Parallel-Tos.  A list of the binary parallel pnodes for a slot.   



 Modules: Text: Data: Records: Anode


   Attribute Record (ANODE).

     Represents a slot (object, attribute).

     The anode is used extensively during decision: it is passed from 
     Context/Subtext to the Supervisor, then to the Decider, which updates
     the new decision fields, then to Conflux/Subflux, then back to
     Context/Subtext, which transfers the new decision fields to the current 
     decision fields.

     Contains these fields:

       General.
         Attribute. The attribute.
         Onode. The object record (onode) for the slot.
         Augs. A list of aug records representing the augmentations for the slot.
         Impasse-Onode. Points to the object record (onode) for the impasse object,
           if this slot is impassed. If the slot is a non-context slot, this will
           be the object record (onode) for a micro-impasse object, else it will
           be a goal (gnode) record.

       Preference.
         Accepts. A list of the acceptable pnodes for the slot.
         Parallels. A list of the unary parallel pnodes for the slot.
         Preferences. The preferences record for the slot, if there is one.

       Current Decision.
         Represent the slot's current status. Set by the Context module for
         context slots, else by the Subtext module.
         Status. One of: winner (slot has a value), winners (slot has parallel
           values), tie, conflict, constraint-failure, no-change (context slots only),
           super-no-change (context slots only).
         Items. If slot is impassed, a list of the impasse items, else a list of
           the slot's values.

       New Decision.
         Represent the new decision for the slot. Set by the Decider module.
         Cleared by the Context module for context slots, else by the Subtext module.  
         New-Status. One of: winner (slot has a value), winners (slot has parallel
           values), tie, conflict, constraint-failure, no-change (context slots only),
           super-no-change (context slots only).
         New-Items. If slot is impassed, a list of the impasse items, else a list of
           the slot's values.   

       Preference Phase Transition.
         These fields are set during the preference phase.
         Lost-Outnodes. A list of the values that have lost their supporting
           preferences for this slot. After the new decision is computed for this
           slot, these values, if they are objects, are checked to see if they
           are still attached to the context; if not, they are removed and any
           detached subobjects are removed.  
                        



 Modules: Text: Data: Records: Onode
         
          
   Object Record (ONODE).

     Represents an object.

     Contains these fields:
        
       General.
         Object. Object ID.
         Class. Object class. The class is not known for objects declared with
           declare-objects until the first pme for the object is created.  
         Type. One of: 
           Object. An ordinary object.
           IO-Object. An object created by SOAR/IO.
           Declared-Object. An object created with declare-object.
           Goal. A goal object.
           Impasse. A micro-impasse object.
         Owner. The goal that "owns" this object, that is, the highest goal to which
           this object is linked. For chunking and subgoal flushing.
     
       Preference Link (P-Link).
         Used for tracing object substructure, especially in detecting context
         detachment.
         Innodes. A list of the onodes of those objects that point
           to this object through acceptable or require preferences.
         Outnodes. A list of the onodes of those objects that are pointed to by this 
           object through acceptable or require preferences.

       Database Routing.
         Gnode. Points to the goal (gnode) record for this object, if it is a goal.
         Anode. A list of the anode records for this object's slots.




 Modules: Text: Data: Records: Gnode
     

   Goal Record (GNODE).

     Represents a goal object.

     Contains these fields:

       General.
         Goal. Goal object id.

       Problem-Space Slot.
         Space-Anode. Anode for the problem space.
         New-Space-Preferences-p. T if space preferences have been added
           or retracted since the last quiescence phase.

       State Slot.
         State-Anode. Anode for the state.
         New-State-Preferences-p. T if state preferences have been added
           or retracted since the last quiescence phase.

       Operator Slot.
         Operator-Anode. Anode for the operator.
         New-Operator-Preferences-p. T if operator preferences have been added
           or retracted since the last quiescence phase.

       Fixed Slot.
         Object-Aug. Context-fixed-aug record for the object augmentation.
         Attribute-Aug. Context-fixed-aug record for the attribute augmentation.
         Impasse-Aug. Context-fixed-aug record for the impasse augmentation.
         Item-Augs. List of context-fixed-aug records for the item augmentations.
         Choices-Aug. Context-fixed-aug record for the choices augmentation.
         Applied-Aug. Context-fixed-aug record for the applied augmentation.
         Quiescence-Aug. Context-fixed-aug record for the quiescence augmentation.

       Summary Information
         Impassed-Anode. If there is a subgoal, points to the anode for the
           impassed slot, that is, the space, state, or operator anode.
         Applied. The value of the applied augmentation.                

       Chunking.
         Traces. Hash table. Values are production traces (rtraces) and
           object traces (otraces) for the goal. Key is object id for object traces
           and action pme for production traces. 
           There is a production trace for every pme produced by the goal;
           if the pme was created more than once, there is one entry for each pme.
           There is an object trace for every object for which pmes were
           produced by the goal.   
         External-Objects. A list of the external (owned by supergoals) objects
           for which pmes were produced by the goal.
         Internal-Objects. A list of internal (local, owned) objects for which
           pmes were produced by the goal.
         Chunk-Actions. A list of the actions, or results, for the goal, produced
           by the most recent production firing. 
         Promoted-Chunk-Actions. A list of the actions, or results, for the goal,
           that were not produced by the most recent production firing, but 
           that instead were linked to a supergoal by the most recent production
           firing. These must be distinguished from ordinary chunk actions because
           they may not be o-supported even though the ordinary actions are,
           and, if learning is off, an internal chunk must be built to support
           the promoted actions even though the chunked rule is a o-supporting rule. 
         Subgoaled-p. T if the goal has had a subgoal. Used to determine whether
           to chunk when learning bottom-up.
         Chunks-p. T if chunks have been built for the goal. Used by chunking.
           This may not be needed anymore.

       Database Routing.
         Depth. Depth of goal in stack. Top goal has depth 0.
         Supernode. Gnode for supergoal.
         Subnode. Gnode for subgoal.
         Onode. Onode for goal object.
           The onode for a goal points back to the goal's gnode, so a gnode
           record can be accessed by lookup in the objects table or by 
           searching from the top of the goal stack.
           The goal's onode points to anodes for goal slots not created by
           the architecture, that is, user-created goal slots.
       


|#



;;; MODULE RECORD DEFINITIONS.               


;;; AUGMENTATION RECORDS.

(defstruct (aug (:constructor make-aug (ame timetag)))
                "Augmentation record. Attached to anode."
                (ame           NIL    :type tme)
                (timetag       0      :type timetag)
)

(defstruct (context-fixed-aug (:constructor make-context-fixed-aug (ame timetag pme)))
           "Fixed goal aug(mentation)."
           (ame           NIL    :type tme)
           (timetag       0      :type timetag) ;ame's timetag 
           (pme           NIL    :type tme)     ;simulated pme needs no timetag
)
                         

;;; PREFERENCE RECORDS.

(defstruct (preferences (:constructor make-preferences ()))
           "Full preferences for a slot. Core preferences are in the anode."
           (requires        NIL :type list)
           (prohibits       NIL :type list)
           (reconsiders     NIL :type list)
           (rejects         NIL :type list)
           (betters         NIL :type list)  ;includes converted worses.
           (bests           NIL :type list)
           (worsts          NIL :type list)
           (indifferents    NIL :type list)
           (indifferent-tos NIL :type list)
           (parallel-tos    NIL :type list) 
)   

(defstruct (pnode
            (:constructor make-pnode (pme timetag i-support o-support)))
           "Preference node. Contains preference TME, timetag, and support status."
           (pme         NIL   :type list)
           (timetag     0     :type integer)
           (i-support   0     :type integer) ;instantiation support count
           (o-support   NIL   :type tme-value-or-NIL) ;T if operator-supported
)

                       
;;; ATTRIBUTE (SLOT) RECORDS.

(defstruct (anode (:constructor make-anode (attribute preferences)))
            "Attribute Node. Attached to onode and gnode records."

                 (attribute         NIL     :type tme-attribute)
                 ;; for goals, gnode; else, onode.
                 (onode             NIL     :type (or null onode gnode))
                 (augs              NIL     :type (or aug list))
                 ;; for goals, gnode; else, onode.
                 (impasse-onode     NIL     :type (or null onode gnode))

                 ;; PREFERENCES.

                 ;; core preferences.
                 (accepts           NIL     :type list)
                 (parallels         NIL     :type list)   
                 ;; full preferences.
                 (preferences       NIL     :type (or null preferences))

                 ;; CURRENT DECISION.

                 (status            NIL     :type symbol)
                 (items             NIL     :type list)

                 ;; NEW DECISION.
                 
                 (new-status        NIL     :type symbol)  ;set by decider
                 (new-items         NIL     :type list)    ;set by decider

                 ;; TRANSITION DATA. Used in transition to new decision.
                 
                 ;; values that lost an accept or require preference
                 ;; during the last preference phase.
                 (lost-outnodes     NIL     :type list)
)

                             
;;; OBJECT RECORDS.

(defstruct (onode (:constructor make-onode (object type owner)))

                 "Object Node. Attached to object table."

                 (object            NIL :type tme-object)
                 (class             NIL :type tme-class)                
                 ;; object (ordinary), io-object, declared-object, goal, or impasse.
                 (type              NIL :type symbol)
                 ;; owner is highest goal to which object is linked.
                 (owner             NIL :type tme-object)  

                 ;; references via accept and require preferences.
                 (innodes           NIL :type list)  ;referencing onodes
                 (outnodes          NIL :type list)  ;referenced onodes
                 (marker            NIL :type logical) ;marker to make transitive closures O(n)
 
                 ;; context goal record. only for goal objects.
                 (gnode             NIL :type gnode-or-NIL) 
                 (anodes            NIL :type list)  
) 

(defstruct (gnode 
              (:constructor make-gnode (goal
                                        depth
                                        supernode)))
                                        
             "Goal record. Attached to object record (onode)."  
             ;ID.
                (goal                       NIL            :type tme-object)
             ;CONTEXT SLOTS.
               ;SPACE.
                (space-anode                (make-anode 'problem-space
                                                        (make-preferences))
                                                           :type anode)
                (new-space-preferences-p    NIL            :type logical)
               ;STATE.
                (state-anode                (make-anode 'state
                                                        (make-preferences))
                                                           :type anode)
                (new-state-preferences-p    NIL            :type logical)
               ;OPERATOR.
                (operator-anode             (make-anode 'operator
                                                        (make-preferences))
                                                           :type anode)
                (new-operator-preferences-p NIL            :type logical)
             ;FIXED SLOTS.
                (object-aug                 NIL            :type (or null context-fixed-aug))
                (attribute-aug              NIL            :type (or null context-fixed-aug))
                (impasse-aug                NIL            :type (or null context-fixed-aug))
                (item-augs                  NIL            :type list)
                (choices-aug                NIL            :type (or null context-fixed-aug))
                (applied-aug                NIL            :type (or null context-fixed-aug))   
                (quiescence-aug             NIL            :type (or null context-fixed-aug))
             ;SUMMARY INFORMATION.
                (impassed-anode             NIL            :type (or null anode))
                ;; last operator reconsidered (and so last applied).
                (applied                    NIL            :type gme-value)
             ;CHUNKING.                
                ;; one entry per action for each production fired for goal.
                ;; key is pme (eq). value is an rtrace record.
                ;; AND
                ;; one entry for each object for which preferences
                ;; created in goal.
                ;; key is object id. value is an otrace record. 
                (traces                     (make-hash-table
                                               :test #'eq :size 503 :rehash-size 1.5
                                               :rehash-threshold .5)
                                                           :type hash-table)          

                ;; objects created within but later linked above goal,
                ;; or created above and elaborated within goal.
                (external-objects           NIL            :type list)        
                ;; objects created within and not linked above goal.
                (internal-objects           (list goal)    :type list)

                ;; promoted chunk actions are pmes for a local object that
                ;; became a result when linked to an object owned by a supergoal.
                ;; such actions are not created by the instantiation
                ;; being chunked, but will nevertheless be among its
                ;; chunk's actions.
                ;; need to distinguish these from ordinary actions because
                ;; they may not be o-supported even though the ordinary
                ;; actions are, and, if learning is off, an internal chunk will have
                ;; to be built even though the chunked rule is an o-supporting rule. 

                ;; non-promoted actions for next chunk to be built.
                (chunk-actions              NIL            :type list)
                ;; promoted actions for next chunk to be built.
                (promoted-chunk-actions     NIL            :type list)

                ;; T if goal has had subgoals.
                (subgoaled-p                NIL            :type logical)
                ;; T if goal has chunks.
                (chunks-p                   NIL            :type logical)
             ;STACK.
                (depth                      0              :type fixnum) 
                (supernode                  NIL            :type (or null gnode))
                (subnode                    NIL            :type (or null gnode))        
                ;; subtext object record for goal.
                ;; for goal augmentations other than context and fixed.
                (onode                      NIL            :type (or null onode)) 
)


;;; MODULE TYPE DECLARATIONS.
                                            
(deftype aug-or-NIL () '(or null aug))
(deftype context-fixed-aug-or-NIL () '(or null context-fixed-aug))

(deftype preferences-or-NIL () '(or null preferences))
(deftype pnode-or-NIL () '(or null pnode))
                                            
(deftype anode-or-NIL () '(or null anode))
(deftype onode-or-NIL () '(or null onode))
(deftype gnode-or-NIL () '(or null gnode))



;;; MODULE MACROS.


;;; ANODE UTILITIES.


(defdsmmacro anode-processes (anode)                     
                             (anode) list
 (declare (type anode anode))
 `(if ,anode
      (mapcar
        #'(lambda (aug) (tme-value (aug-ame aug)))
        (anode-augs ,anode)))
)


(defdsmmacro anode-object (anode)
                          (anode) tme-object
 (declare (type anode anode))
 `(if (onode-p (anode-onode ,anode))
      (onode-object (anode-onode ,anode))
      (gnode-goal (anode-onode ,anode)))
)


(defdsmmacro anode-context-p (anode)
                             (anode) logical
 (declare (type anode anode))
 `(if (onode-p (anode-onode ,anode))
      NIL
      T)
)


(defdsmmacro anode-winners (anode)
                           (anode) list
 (declare (type anode anode))
 `(if (anode-impasse-onode ,anode)
      NIL
     (anode-items ,anode))
)



(defdsmmacro anode-reconsiders (anode)
                               (anode) list
 (declare (type anode anode))
 ;; only context slots can have reconsiders.
 `(if (onode-p (anode-onode ,anode))
      NIL          
      (if (anode-preferences ,anode)
          (preferences-reconsiders (anode-preferences ,anode))))
)



(defdsmmacro anode-superslot-status (anode)
                                    (anode) symbol
 (declare (type anode anode))
 `(if (onode-p (anode-onode ,anode))
      NIL            
      (gnode-superslot-status (anode-attribute ,anode) (anode-onode ,anode)))
) 

                            

(defdsmmacro anode-requires (anode)
                            (anode) list
 (declare (type anode anode))
 `(if (anode-preferences ,anode)
      (preferences-requires (anode-preferences ,anode)))
)
                            

(defdsmmacro anode-prohibits (anode)
                             (anode) list
 (declare (type anode anode))
 `(if (anode-preferences ,anode)
      (preferences-prohibits (anode-preferences ,anode)))
)
                            

(defdsmmacro anode-rejects (anode)
                           (anode) list
 (declare (type anode anode))
 ;; returns ordinary rejects not OA-rejects.
 `(if (anode-preferences ,anode)
      (preferences-rejects (anode-preferences ,anode)))
)
                            

(defdsmmacro anode-betters (anode)
                           (anode) list
 (declare (type anode anode))
 `(if (anode-preferences ,anode)
      (preferences-betters (anode-preferences ,anode)))
)
                            

(defdsmmacro anode-bests (anode)
                         (anode) list
 (declare (type anode anode))
 `(if (anode-preferences ,anode)
      (preferences-bests (anode-preferences ,anode)))
)
                            

(defdsmmacro anode-worsts (anode)
                          (anode) list
 (declare (type anode anode))
 `(if (anode-preferences ,anode)
      (preferences-worsts (anode-preferences ,anode)))
)
                            

(defdsmmacro anode-indifferents (anode)
                                (anode) list
 (declare (type anode anode))
 `(if (anode-preferences ,anode)
      (preferences-indifferents (anode-preferences ,anode)))
)
                            

(defdsmmacro anode-indifferent-tos (anode)
                                   (anode) list
 (declare (type anode anode))
 `(if (anode-preferences ,anode)
      (preferences-indifferent-tos (anode-preferences ,anode)))
)
                            

(defdsmmacro anode-parallel-tos (anode)
                                (anode) list
 (declare (type anode anode))
 `(if (anode-preferences ,anode)
      (preferences-parallel-tos (anode-preferences ,anode)))
)
 
                                                                      
(defdsmmacro anode-require-list (anode)
                                (anode) list
 (declare (type anode anode))
 `(list-unary-preferences (anode-requires ,anode))
)    


(defdsmmacro anode-prohibit-list (anode)
                                 (anode) list
 (declare (type anode anode))
 `(list-unary-preferences (anode-prohibits ,anode))
)

                                                                      

(defdsmmacro anode-accept-list (anode)
                               (anode) list
 (declare (type anode anode))
 `(list-unary-preferences (anode-accepts ,anode))
)
 
                                                                      
(defdsmmacro anode-reconsider-list (anode)
                                (anode) list
 (declare (type anode anode))
 `(list-unary-preferences (anode-reconsiders ,anode))
)    

                                                                      

(defdsmmacro anode-reject-list (anode)
                               (anode) list
 (declare (type anode anode))
 `(list-unary-preferences (anode-rejects ,anode))
)
                                                                      

(defdsmmacro anode-better-list (anode)
                               (anode) list
 (declare (type anode anode))
 `(list-binary-preferences (anode-betters ,anode))
)
                                                                      

(defdsmmacro anode-best-list (anode)
                             (anode) list
 (declare (type anode anode))
 `(list-unary-preferences (anode-bests ,anode))
)
                                                                      

(defdsmmacro anode-worst-list (anode)
                              (anode) list
 (declare (type anode anode))
 `(list-unary-preferences (anode-worsts ,anode))
)
                                                                      

(defdsmmacro anode-indifferent-list (anode)
                                    (anode) list
 (declare (type anode anode))
 `(list-unary-preferences (anode-indifferents ,anode))
)
                                                                      

(defdsmmacro anode-indifferent-to-list (anode)
                                       (anode) list
 (declare (type anode anode))
 `(list-binary-preferences (anode-indifferent-tos ,anode))
)
                                                                      

(defdsmmacro anode-parallel-list (anode)
                                 (anode) list
 (declare (type anode anode))
 `(list-unary-preferences (anode-parallels ,anode))
)
                                                                      

(defdsmmacro anode-parallel-to-list (anode)
                                    (anode) list
 (declare (type anode anode))
 `(list-binary-preferences (anode-parallel-tos ,anode))
)




;;; Concatenated from type module "msymbols" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/msymbols/new/msymbols.lisp".
(in-package "SOAR")




;;; <SYMBOLS.MACROS>  


;;; SYMBOLS MODULE: MACROS.



;;; MODULE DESCRIPTION.
;;;  Keeps track of LISP symbols.

;;; MODULE BACKGROUND.
;;;   EXCEPTIONS TO CLASSIFICATION OF SYMBOLS BY GENSYMED PROPERTY.
;;;     The rule is that gensymed symbols represent objects and non-gensymed
;;;      symbols are constants; but there are exceptions.
;;;      Users must declare non-gensymed object symbols and gensymed
;;;      constant (non-object) symbols.

#|


 Modules: Symbols: Contents

          
 Introduction

 Data
   Globals
     *declared-objects*
     *declared-constants*
     *negated-objects*

 Functions
   Object Symbol Generation
   Negated Object Symbol Generation
   Soar/IO Object Symbol Generation
   Constant Symbol Generation
   Goal Symbol Generation
   Impasse Symbol Generation

   Symbol Classification
   Symbol Classification Utilities

   Utilities


 Modules: Symbols: Introduction


 Symbols manages the creation and release of symbols.



 Modules: Symbols: Data: Globals


   *declared-objects*
     A list of the ids of declared objects, that is, objects declared as such
     by the user with the declare-objects command.
     Used to identify non-gensymed symbols as object symbols.

   *declared-constants*
     A list of the ids of gensymed symbols that are NOT object symbols.
     These symbols are created with the make-constant-symbol command,
     which is used by users who want to gensym values that are not to be 
     treated as objects.
     Used to identify gensymed symbols as constant  (non-object) symbols.

   *negated-objects*
     A list of the object symbols created to represent non-existent objects
     when negated clauses are added to the LHS of a fired instantiation for chunking.
     These symbols are released immediately after the chunk has been built.
|#



;;; MODULE GLOBALS.

(defvar *declared-objects*
        NIL
        "Object symbols declared as such with declare-objects.")

(defvar *declared-constants*
        NIL
        "Constant symbols declared as such with declare-constants.")

(defvar *negated-objects*
        NIL
        "For LHS variables that appear only in negated clauses.")
                 

;;; MODULE MACROS.
                          

;;; SYMBOL CLASSIFICATION UTILITIES.


(defdsmmacro symbol-type (symbol)
                          (atom) (or null symbol)                     
 (declare (atom symbol))       
 `(cond ((symbolp ,symbol)
         (cond ((object-type ,symbol))
               ((member ,symbol *declared-constants* :test #'eq)
                'declared-constant)))
        (T
         NIL))
)      


(defdsmmacro declared-objects ()
                              () list
 (declare)
 `*declared-objects*
)


(defdsmmacro declared-constants ()
                                () list
 (declare)
 `*declared-constants*
)

                  
;;; SYMBOL CLASSIFICATION.

                           
(defdsmmacro object-p (atom)
                      (atom) logical                              
 (declare (atom atom))        
 ;; used to use object-onode rather than property 'object-p, but 
 ;; the chunker may backtrace through an object after it has been removed, 
 ;; and so the symbol classification must outlive the object itself.
 `(logicize (and (symbolp ,atom) (get ,atom 'object-p)))
)

                          
(defdsmmacro soar-object-p (atom)
                           (atom) logical                                
  ;; Added a missing parenthesis. -BGM 1-Mar-90
  ;; Corrected keyword :type to :test -- TFMcG 29-Jun-90
 (declare (atom atom)) 
 `(logicize (and (symbolp ,atom)
            (member (object-type ,atom) '(goal impasse) :test #'eq))))


                          
(defdsmmacro io-object-p (atom)
                         (atom) logical                               
 (declare (atom atom)) 
 `(and (symbolp ,atom) (eq (object-type ,atom) 'io-object))
)

                           
(defdsmmacro constant-p (atom)
                        (atom) logical                              
 (declare (atom atom))                                     
 `(logicize (and (symbolp ,atom) (member ,atom *declared-constants* :test #'eq)))
)

                          
(defdsmmacro goal-p (atom)
                    (atom) logical                                
 (declare (atom atom)) 
 `(and (symbolp ,atom) (eq (object-type ,atom) 'goal))
)

                          
(defdsmmacro impasse-p (atom)
                       (atom) logical                               
 (declare (atom atom))
 `(and (symbolp ,atom) (eq (object-type ,atom) 'impasse))
)

                          
(defmacro production-p (atom)
 (declare (atom atom))
 ;; production names have the topnode property.
 `(logicize
   (and (symbolp ,atom) (get-p ,atom)))
)



(defdsmmacro gensymed-p (atom)
                        (atom) logical                     
 (declare (atom atom))
 `(logicize
   (and (symbolp ,atom) (get ,atom 'gensymed)))
)






;;; Concatenated from type module "mslots" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mslots/new/mslots.lisp".
(in-package "SOAR")




;;; <SLOTS.MACROS>




;;; SLOTS MODULE: MACROS.

;;; MODULE DESCRIPTION.
;;;  Mediates the split in the DSM representation of working memory,
;;;  that is, the split between the context and subtext modules.

#|


 Modules: Slots: Contents

          
 Introduction

 Functions
   Slot Classification
   Slot Inquiry
   Preference Removal
   Utilities



 Modules: Slots: Introduction

 Slots is used primarily to switch between the Context and Subtext modules, or,
 expressed another way, to conceal the distinction between the Context and
 Subtext portions of architecture memory.


|#


;;; MODULE MACROS.   



;;; SLOT CLASSIFICATION.

                      
(defdsmmacro non-context-slot-p (object attribute)
                                (tme-object tme-attribute) T
 (declare (type tme-object object)
          (type tme-attribute attribute))
 `(not (context-slot-p ,object ,attribute))
)


                      
(defdsmmacro context-slot-p (object attribute)
                            (tme-object tme-attribute) T
 (declare (type tme-object object)
          (type tme-attribute attribute))
 `(and (member ,attribute '(problem-space state operator) :test #'eq)
       (goal-p ,object))
)
                                 





;;; Concatenated from type module "msubtext" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/msubtext/new/msubtext.lisp".
(in-package "SOAR")

(eval-when (compile eval load) (proclaim '(special *trace-file*)))
;; Inserted special declaration for *trace-file*. -BGM 1-Mar-90

;;; <SUBTEXT.MACROS>


;;; SUBTEXT MODULE: MACROS.


;;; MODULE DESCRIPTION.
;;;   Architecture memory for all slots other than architecture-created goal
;;;   slots (problem-space, state, operator, and the fixed goal slots such as 
;;;   object and attribute). 
                             
#|

 Modules: Subtext: Contents

          
 Introduction

 Data
   Globals
     *objects*
     *slots*
     *subtext-changed-preferences*
     *subtext-delayed-rejections*
     *impasse-log*

 Functions
   Single Process Handling
   Parallel Process Handling

   Single Augmentation Utilities
   Parallel Augmentation Utilities
   Miscellaneous Augmentation Utilities

   Traffic Synchronization

   Object Inquiry

   Production Backtracing

   Traversal
     
   Heap Growth
   Heap Decay
   Heap Access

   Goals

   Impasse Installation
   Impasse Removal
   Impasse Revision
   Impasse Utilities

   Preference Addition
   Preference Removal
   C-Support Extension
   C-Support Withdrawal
   Preference Inquiry

   Utilities



 Modules: Subtext: Introduction

                               
 Subtext maintains the object table, user-created objects, user-created objects'
 slots, user-created goal slots, and micro-impasse objects and their slots.
                       
 In particular, Subtext does these things:

   Maintains object table.
   Maintains object (onode) and attribute (anode) records (excepting the
   problem-space, state, and operator anodes for goals).
   Guides the Supervisor through the changed non-context slots during the
   working memory phase.
   Effects non-context slot transitions under the direction of Subflux.
   Manages the extension and withdrawal of context support.
   Interacts with Context during subgoal flushing to remove flushed objects.



 Modules: Subtext: Data: Globals


  Database Access.
  
     *objects*
       Hash table mapping object ids to Object records (ONODEs).
       Discussed in Overview.

     *slots*                 
       Hash table mapping slot ids ((list object attribute)) to Attribute
       records (ANODEs).
       Not used unless keyword :SLOTS is in *features*; by default, it it not used.
       If it is used, anodes are accessed by direct hash; else, they are
       accessed by a hash to the Object record and a search through that
       object's anode records. 
       The slots table was causing preformance problems in earlier versions
       of Soar5 because it is large and volatile.


   Traffic Synchronization.

     *subtext-changed-preferences*
       A list of anode records for those non-context slots whose preferences
       changed during the last preference phase.
       These anodes are submitted for re-decision during the working memory
       phase. 

     *subtext-delayed-rejections*
        List of delayed oa-rejection operations for non-context slots.
        Each such operation is represented as:
         (list anode-of-rejecting-slot rejected-value).  
        These are queued when they arrive during the preference phase.
        They must await the end of the phase so that any new preferences
        arriving for that slot and value will be flushed by the rejection.
        This so that what gets flushed by a reject does not depend on
        instantiation order or RHS order. So, at the end of the cycle during
        which the reject arrived, there should be no preferences for that
        slot and value (requires excepted). 


     *impasse-log*
        List of entries representing current micro-impasses. 
        Entry format:
          (list micro-impasse-object's-onode impassed-slot's-anode).
        Used to locate micro-impasses by object during object removal
        and object flushing.

|#



;;; MODULE RECORD DEFINITIONS.               
;;;  See TEXT Module.



;;; MODULE GLOBALS.

(defvar *objects*
        (make-hash-table :test #'eq
                         :size 701
                         :rehash-size 1.5
                         :rehash-threshold .5)
        "Hash to object (onode) records. Key is object symbol.") 


#+:SLOTS
(defvar *slots*
        (make-hash-table :test #'equal
                         :size 5003
                         :rehash-size 1.5
                         :rehash-threshold .1)
        "Hash to slot (anode) record. Key is (list object attribute).")

(defvar *subtext-changed-preferences*
        NIL
        "Anodes awaiting decision in the next decision cycle.")



;;; synchronization.
;;; queue of delayed reject preferences.
;;; these are queued when they arrive during the preference phase.
;;; they must await the end of the phase so that any new preferences
;;; arriving for that slot and value will be flushed by the rejection.
;;; this so that what gets flushed by a reject does not depend on
;;; instantiation order or RHS order: 
;;;  at the end of the cycle during which the reject arrived, there
;;;  should be no preferences for that slot and value (requires excepted). 
(defvar *subtext-delayed-rejections* 
        NIL
        "Reject preferences awaiting end of preference phase.")

;;; impasse log.
;;; impassed slots and their impasse objects.
;;; each entry is a pair (impasse-onode impassed-anode).
;;; used for subgoal flushing.
(defvar *impasse-log* 
        NIL
        "Impasse object log. For subgoal flushing.")
                                                             

;;; MODULE MACROS.


;;; SINGLE PROCESS HANDLING.


(defdsmmacro subtext-start-process (anode process)
                                   (anode tme-value) T
 (declare (type anode anode)
          (type tme-value process))
 `(subtext-put-ame ,anode ,process)
)


(defdsmmacro subtext-stop-process (anode process)
                                  (anode tme-value) T
 (declare (type anode anode)
          (type tme-value process))
 `(subtext-drop-ame ,anode ,process)
)              


;;; PARALLEL PROCESS HANDLING.


(defdsmmacro subtext-start-parallel-processes (anode processes)
                                              (anode list) T
 (declare (type anode anode)
          (list processes))
 `(subtext-add-ames ,anode ,processes)
)


(defdsmmacro subtext-stop-parallel-processes (anode processes)
                                             (anode list) T
 (declare (type anode anode)
          (list processes))
 `(subtext-drop-ames ,anode ,processes)
)              

            

;;; MISCELLANEOUS AUGMENTATION UTILITIES.
 

(defdsmmacro aug-process (aug)
                         (aug) gme-value
 (declare (type aug aug))
 `(tme-value (aug-ame ,aug))
)


;;; TRAVERSAL.


(defdsmmacro subtext-next-anodes ()
                                 () list
 (declare)            
 `*subtext-changed-preferences*
)



;;; HEAP ACCESS.


(defdsmmacro object-onode (object)                             
                          (tme-object) onode-or-NIL
 (declare (type tme-object object))
 `(gethash ,object *objects*)
)


                                          
(defdsmmacro slot-anode (object attribute)
                        (tme-object tme-attribute) anode-or-NIL
 (declare (type tme-object object)
          (type tme-attribute attribute))
 ;;; look for anode. if not found, return NIL.
 #+(not :SLOTS) 
 `(let ((onode (object-onode ,object)))
   (declare (type onode-or-NIL onode))
   (if onode 
       (onode-to-anode onode ,attribute)))
 #+:SLOTS
 `(gethash (make-slot ,object ,attribute) *slots*)
)


(defdsmmacro onode-to-anode (onode attribute)
                            (onode tme-attribute) anode-or-NIL                            
 (declare (type onode onode)
          (type tme-attribute attribute))
 `(find-if
   #'(lambda (anode)           
      (declare (type anode anode))
      (tme-attribute= (anode-attribute anode) ,attribute))
   (onode-anodes ,onode))
) 



;;; MISCELLANEOUS AUGMENTATION UTILITIES.
       

(defdsmmacro find-aug (anode process)                               
                      (anode tme-value) aug-or-NIL
 (declare (type anode anode)
          (type tme-value process))
 `(find-if
   #'(lambda (aug)         
      (declare (type aug aug))
      (tme-value= (aug-process aug) ,process)) 
   (anode-augs ,anode))
)


(defdsmmacro find-augs (anode processes)        
                       (anode list) list       
 (declare (type anode anode)
          (list processes))
 `(mapcar
   #'(lambda (process)       
      (declare (type tme-value process))
      (find-aug ,anode process))
   ,processes)
)
       

(defdsmmacro find-ame (anode process)                               
                      (anode tme-value) tme-or-NIL
 (declare (type anode anode)
          (type tme-value process))
 `(let ((aug (find-aug ,anode ,process)))
   (declare (type aug-or-NIL aug))
   (cond (aug
          (aug-ame aug) )) )
)
       

(defdsmmacro find-ames (anode processes)                               
                       (anode list) list
 (declare (type anode anode)
          (list processes))
 `(mapcar #'aug-ame (find-augs ,anode ,processes))
)



(defdsmmacro subtext-single-process-p (value)                            
                                      (list) logical 
 (declare (list value))
 `(null (rest ,value))
)



(defdsmmacro subtext-parallel-processes-p (value)                          
                                          (list) logical 
 (declare (list value))
 `(not (null (rest ,value)))
)
            



(defdsmmacro subtext-active-process-p (anode process)                        
                                      (anode tme-value) logical
 (declare (type anode anode)
          (type tme-value process))       
 `(logicize
   (find-if
    #'(lambda (aug)         
       (declare (type aug aug))
       (tme-value= (aug-process aug) ,process))
    (anode-augs ,anode)))
)




;;; OBJECT INQUIRY.   

 

(defdsmmacro object-name (object)
                         (tme-object) symbol
 (declare (type tme-object object))
 `(let ((anode (slot-anode ,object 'name)))
   (declare (type anode-or-NIL anode))
   (if anode (first (anode-processes anode))))
)


;;; TRAVERSAL.



(defdsmmacro subtext-schedule-slot (anode)               
                                   (anode) list
 (declare (type anode anode))
 `(pushnew ,anode *subtext-changed-preferences* :test #'eq)   
)




(defdsmmacro subtext-unschedule-slot (anode)               
                                     (anode) list
 (declare (type anode anode))
 `(setf *subtext-changed-preferences*
        (delete ,anode
                *subtext-changed-preferences* 
                :test #'eq
                :count 1))
)



;;; HEAP GROWTH.


(defdsmmacro add-onode (object type owner)   
                       (tme-object symbol tme-object) onode
 (declare (type tme-object object owner)
          (symbol type))
  `(setf (gethash ,object *objects*) 
         (make-onode ,object ,type ,owner))
)

                

#+(or)
(defdsmmacro conjure-onode (object class)      
                           (tme-object tme-class) onode
 (declare (type tme-object object)
          (type tme-class class)) 
 ;; not used. must update arguments list if needed.                
 `(let ((onode (object-onode ,object)))
   (declare (type onode-or-NIL onode))
   (cond (onode
          onode)
         (T
          (add-onode ,object ,class)))
))
 




;;; HEAP DECAY.


(defdsmmacro garbage-if-no-preferences (anode)
                                       (anode) T
 (declare (type anode anode))   
 ;; called by subtext-collect-garbage.
 `(if (not (preferences-preferences-p ,anode))
      (remove-anode ,anode))
)



(defdsmmacro garbage-if-no-preferences-or-ames (anode)
                                               (anode) logical
 (declare (type anode anode))   
 `(if (not (or (anode-augs ,anode)
               (preferences-preferences-p ,anode)))
      (remove-anode ,anode))
)



;;; IMPASSE UTILITIES. 


(defdsmmacro impasse-log-impasse-object (impasse-log-entry)
                                        (list) symbol
 (declare (list impasse-log-entry))
 `(onode-object (first ,impasse-log-entry))
)



(defdsmmacro impasse-log-object (impasse-log-entry)
                                (list) symbol
 (declare (list impasse-log-entry))
 `(onode-object (anode-onode (second ,impasse-log-entry)))
)
       


(defdsmmacro impasse-log-attribute (impasse-log-entry)
                                   (list) symbol
 (declare (list impasse-log-entry))
 `(anode-attribute (second ,impasse-log-entry))
)


(defdsmmacro impasse-log-impasse-onode (impasse-log-entry)
                                       (list) onode
 (declare (list impasse-log-entry))
 `(first ,impasse-log-entry)
)



(defdsmmacro impasse-log-impassed-anode (impasse-log-entry)
                                        (list) anode
 (declare (list impasse-log-entry))
 `(second ,impasse-log-entry)
)



(defdsmmacro impasse-log-impassed-onode (impasse-log-entry)
                                        (list) onode
 (declare (list impasse-log-entry))
 `(anode-onode (second ,impasse-log-entry))
)
 


(defdsmmacro log-impasse (impasse-onode impassed-anode)
                         (onode anode) list
 (declare (type onode impasse-onode)
          (type anode impassed-anode))
 `(push (list ,impasse-onode ,impassed-anode) *impasse-log*)
)
 



(defdsmmacro unlog-impasse (impasse-onode)
                           (onode) list
 (declare (type onode impasse-onode))
 ;; unlog impasse object.
 `(setf *impasse-log*
        (delete-if       
         #'(lambda (entry)
            (declare (list entry))
            (eq (impasse-log-impasse-onode entry) ,impasse-onode))
         *impasse-log*
         :count 1))
)


 
(defdsmmacro protected-impasse-slot-p (attribute)            
                                      (tme-attribute) logical
 (declare (type tme-attribute attribute))                   
 `(member ,attribute '(class object attribute impasse item choices) :test #'eq)
)



(defdsmmacro fixed-impasse-slot-p (attribute)                        
                                  (tme-attribute) logical
 (declare (type tme-attribute attribute))
 `(member ,attribute '(class object attribute impasse item choices) :test #'eq)
)


   
;;; PREFERENCE ADDITION.


(defdsmmacro subtext-legal-preference-p (tme)
                                        (tme) logical
 (declare (type tme tme))
 `(let ((object (tme-object ,tme))
        (attribute (tme-attribute ,tme))
        (process (tme-value ,tme))
        (reference (tme-reference ,tme)))    
   (declare (type tme-object object)
            (type tme-attribute attribute)
            (type tme-value process reference)) 
   (cond
    ((or (goal-p process) (goal-p reference))
     (soar-format *trace-file*
                  "~%WARNING: Augmentations cannot point to goals. ~
                   ~%         Ignoring preference ~A."
                  (print-wme NIL ,tme))
     NIL)
    ((or (impasse-p process) (impasse-p reference))
     (soar-format *trace-file*
                  "~%WARNING: Augmentations cannot point to impasses. ~
                   ~%         Ignoring preference ~A."
                  (print-wme NIL ,tme))
     NIL)
    ((and (goal-p object) (fixed-goal-slot-p attribute))
     (soar-format *trace-file*
                  "~%WARNING: Cannot change architecture-created goal augmentation. ~
                   ~%         Ignoring preference ~A."
                  (print-wme NIL ,tme))
     NIL)
    ((and (impasse-p object) (fixed-impasse-slot-p attribute))
     (soar-format *trace-file*
                  "~%WARNING: Cannot change architecture-created impasse augmentation. ~
                   ~%         Ignoring preference ~A."
                  (print-wme NIL ,tme))
     NIL)
    ((eq (tme-type ,tme) '@)
     (soar-format *trace-file*
                  "~%WARNING: Reconsiders not allowed for non-context slots. ~
                   ~%         Ignoring preference ~A."
                  (print-wme NIL ,tme))
     NIL)
    (T            
     ;; legal preference.
     T)) )
)
    

;;; PREFERENCE REMOVAL.


(defdsmmacro subtext-delayed-reject-preferences (anode process)               
                                                (anode tme-value) list
 (declare (type anode anode)
          (type tme-value process)) 
 `(push (list ,anode ,process) *subtext-delayed-rejections*)
)


                        
;;; C-SUPPORT EXTENSION.
                        

(defdsmmacro c-support-preference-p (pme)
                                    (tme) logical
 (declare (type tme pme))
 `(let ((type (tme-type ,pme)))
   (declare (type tme-type type))
   (or (eq type accept-token) (eq type require-token)))
)


;;; C-SUPPORT WITHDRAWAL.

(defdsmmacro subtext-log-lost-outnode (anode value)
                                      (anode tme-value) list
 (declare (type anode anode)
          (type tme-value value))
 `(push ,value (anode-lost-outnodes ,anode))
)   


(defdsmmacro subtext-unlog-lost-outnodes (anode)
                                         (anode) true
 (declare (type anode anode))
 ;; called by subtext-walker after withdrawing c-support. 
 `(setf (anode-lost-outnodes ,anode) NIL)
)






;;; Concatenated from type module "mcontext" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mcontext/new/mcontext.lisp".
(in-package "SOAR")





;;; <CONTEXT.MACROS>

;;; CONTEXT MODULE: MACROS.


;;; MODULE DESCRIPTION.
;;;   Architecture memory for all architecture-created goal slots
;;;   (problem-space, state, operator, and the fixed goal slots such as 
;;;   object and attribute). 

#|

 Modules: Context: Contents

          
 Introduction

 Data
   Records
     Delayed-Traffic-Log
     Rtrace
     Otrace
   Globals
     *top-gnode*
     *bottom-gnode*
     *current-gnode*
     *attribute-queue*
     *context-goal-state-operators*
     *initializing-context*
     *initial-goal*
     *initial-space*
     *initial-state*
     *initial-operator*
     *context-delayed-traffic-log*
     *context-delayed-rejections*
     *applied-gnodes*

 Functions
   Process Handling
   External Process Handling
   Process Inquiry

   Space Augmentation Utilities
   State Augmentation Utilities
   Operator Augmentation Utilities
   Item Augmentation Utilities
   Applied Augmentation Utilities
   Other Fixed Augmentation Utilities
   Miscellaneous Augmentation Utilities

   Traffic Synchronization

   Production Backtracing
   Result Tracing

   Stack Traversal
   Stack Initialization
   Stack Flushing
   Stack Inquiry
   Stack Utilities

   Impasse Installation
   Impasse Removal
   Impasse Revision
   Impasse Utilities

   Preference Addition
   Preference Rejection
   Preference Retraction
   Preference Removal
   C-Support Withdrawal
   Preference Inquiry

   Utilities





 Modules: Context: Introduction

                               
 Context maintains the goal stack and the architecture-created goal slots,
 to wit, problem-space, state, operator, item, applied, object, attribute,
 impasse, choices, and quiescence.
                       
 In particular, Context does these things:

   Maintains goal stack.
   Maintains architecture-created goal slots.
   Maintains production and object traces for each goal.
   Maintains goal (gnode) records and problem-space, state, and operator
   attribute (anode) records.
   Guides the Supervisor through the goal stack during quiescence.
   Effects context slot transitions under the direction of Conflux.



 Modules: Context: Data: Records: Delayed-Traffic-Log


   Delayed-Traffic-Log Record (DELAYED-TRAFFIC-LOG).

     Used to hold context acceptable and require preference wme traffic
     arising during preference phase until the start of the working memory phase.                                               
     This because working memory traffic is not allowed during the preference
     phase.                                          

     Contains these fields:

       Preference-Adds. List of pmes to be added to working memory at start
         of working memory phase.

       Preference-Removes. List of pmes to be removed from working memory
         at start of working memory phase.



 Modules: Context: Data: Records: Rtrace


   Rule Trace Record (RTRACE).

     Represents a production trace LHS.

     Each action in the RHS is mapped to this LHS record by a hash table
     representing all the pmes produced in a particular goal.

     Contains these fields:
       
       General.
         Number. Each firing is assigned a trace number. This makes it possible to
           reconstruct an entire production trace by looking for all the entries
           in the rule table that map to an rtrace record having a particular
           trace number.
           This is used only for system level debugging.
         Name. Production name.

       LHS.
         Results. A list of LHS tmes that will be made conditions,
           (that is, will not be backtraced through), of any chunk for which
           the Backtracer uses this production trace.
         Non-Results. A list of LHS tmes that will be backtraced through
           for any chunk for which the Backtracer uses this production trace.
         Possible-Results. A list of the LHS tmes that may or may not be backtraced
           through for any chunk for which the Backtracer uses this production trace.
           This decision is made during backtracing.

       The LHS is broken into results, non-results, and possible results
       by the function split-apart-conditions in the Actions module.     
        


 Modules: Context: Data: Records: Otrace
                                                  

   Object Trace Record (OTRACE).

     Represents the pmes produced in a particular goal for a particular object.

     Contains these fields:

       Tmes. The tmes.
       Results-p. T if the tmes are results of the goal, else NIL.
     
            


 Modules: Context: Data: Globals


   Context Stack.

      *top-gnode*
        Points to gnode for the top goal.
        Stack is traversed by following the subnode and supernode pointers
        in the gnodes.

      *bottom-gnode*
        Points to the gnode for the bottom goal.
                   

   Context Stack Traversal.

      *current-gnode*
        Gnode for goal whose slot is currently undergoing decision. 

      *attribute-queue*                                          
        One of: problem-space, state, operator.
        Attribute for context slot currently undergoing decision.

      *context-goal-state-operator*
        A list of (list goal state operator) for each goal. 
        Updated and reported to Firer module whenever the context is changed.
        Used by Firer in rule classification.
                     

   Context Stack Initialization.

      *initializing-context*
        T if context is being initializing as specified by user with init-context,
        else NIL.
        Used because context installation tracing and event statistics updating
        is done differently when the context has been initialized by the user.

      *initial-goal*
        Initial goal id specified by user with init-context.

      *initial-space*
        Initial problem-space id specified by user with init-context.

      *initial-state*
        Initial state id specified by user with init-context.

      *initial-operator*
        Initial operator id specified by user with init-context.

    
   Traffic Synchronization.

      *context-delayed-traffic-log* 
        Points to a Delayed Traffic Log record, which contains the context
        acceptable and require preference wme traffic that arose during the
        preference phase and is to be released at the start of the working
        memory phase.               

      *context-delayed-rejections*
        List of delayed oa-rejection operations for context slots.
        Each such operation is represented as:
         (list rejected-value gnode-of-rejecting-slot   
                              attribute-of-rejecting-slot
                              anode-of-rejecting-slot).
        These are queued when they arrive during the preference phase.
        They must await the end of the phase so that any new preferences
        arriving for that slot and value will be flushed by the rejection.
        This so that what gets flushed by a reject does not depend on
        instantiation order or RHS order. So, at the end of the cycle during
        which the reject arrived, there should be no preferences for that
        slot and value (requires excepted). 
        
      *applied-gnodes*
        List of gnodes for which reconsider preferences arrived during the
        last preference phase for the operator slot.
        Operators just applied are compared to those last applied to determine
        changes to the applied augmentations of goals.
        But these changes, which arise during the preference phase, must be 
        delayed until the start of the working memory phase.

   
|#


                             

;;; MODULE RECORD DEFINITIONS.   
;;;  See TEXT Module.


;;; DELAYED WME CHANGES.
(defstruct (delayed-traffic-log
            (:constructor make-delayed-traffic-log ()))
            "Queues of delayed changes to working memory."
            (preference-adds         NIL  :type list)
            (preference-removes      NIL  :type list)
)



;;; PRODUCTION AND RESULT TRACES.
(defstruct (rtrace                ;rule trace
             (:constructor
               make-rtrace
	              (number name results non-results possible-results nots)))

             "Production trace. Kept in Loom goal node. Used by chunking."
             (number 0 :type fixnum)                 ;trace number
             (name NIL :type (or integer symbol))    ;rule name
             (results NIL :type list)
             (non-results NIL :type list)
             (possible-results NIL :type list) 
             (nots             nil :type list)
             ;; A list of the pairs of variables constrained to be not equal
             ;; in this instantiation. -BGM 29-Nov-90
)

(defstruct (otrace                ;object trace
             (:constructor
               make-otrace
               (tmes results-p)))

           "Goal-object trace. Tmes created for object during goal."
           (tmes        NIL       :type list)
           ;; if T, tmes are results of goal, else, they are non-results.
           (results-p   NIL       :type logical)
)  


;;; MODULE TYPE DECLARATIONS.
;;;  See TEXT.MACROS.LISP.
                                            
(deftype rtrace-or-NIL () '(or null rtrace))
(deftype otrace-or-NIL () '(or null otrace))



;;; MODULE GLOBAL DATA.

(defvar *top-gnode*
        NIL
        "Root of goal stack.")

(defvar *bottom-gnode*
        NIL
        "Bottom of goal stack.")

(defvar *current-gnode*
        NIL
        "Gnode whose slot is currently being analyzed by decider. For stack traversal.") 

(defvar *attribute-queue*
        NIL
        "Queue of attributes. Used in stack traversal.") 

(defvar *context-goal-state-operator*
        NIL
        "List of <goal state operator> for each goal. Used in rule classification.")


;;; SYNCHRONIZATION GLOBALS.
;;;  used during preference phase.
;;;    working memory changes are scheduled during preference phase: 
;;;    context acceptable preference additions and removals, and
;;;    applied goal augmentations additions and removals.
;;;    this traffic is released when the diplomat module signals the
;;;    start of the working memory phase.
(defvar *context-delayed-traffic-log*
        (make-delayed-traffic-log)
        "WM changes awaiting synchronization event.")

;;; queue of delayed reject preferences.
;;; these are queued when they arrive during the preference phase.
;;; they must await the end of the phase so that any new preferences
;;; arriving for that slot and value will be flushed by the rejection.
;;; this so that what gets flushed by a reject does not depend on
;;; instantiation order or RHS order: 
;;;  at the end of the cycle during which the reject arrived, there
;;;  should be no preferences for that slot and value (requires excepted). 
(defvar *context-delayed-rejections* 
        NIL
        "Reject preferences awaiting end of preference phase.")
        
;;; operators just applied are compared to those last applied to determine
;;; changes to the applied augmentations of goals. this is done at the end of
;;; the preference phase.
(defvar *applied-gnodes*
        NIL
        "Goal gnodes for which operator applications fired during preference phase.")

;;; initial top context.
;;; installation delayed until cycling begins.
;;; can, but need not, be set by the user function init-context.
;;; when run is called for the first time, if these values
;;; have been set, then these are installed in context and working memory.
(defvar *initializing-context*
        NIL
        "Used when init-context called before cycling.")
(defvar *initial-goal*
        NIL
        "Set by init-context.")

(defvar *initial-space*
        NIL
        "Set by init-context.")

(defvar *initial-state*
        NIL
        "Set by init-context.")

(defvar *initial-operator*
        NIL
        "Set by init-context.")




;;; MODULE MACROS.


;;; PROCESS INQUIRY.


(defdsmmacro problem-space (gnode)
                           (gnode) symbol
 (declare (type gnode gnode)) 
 `(let ((aug (anode-augs (gnode-space-anode ,gnode))))
   (declare (type aug-or-NIL aug))
   (if aug (tme-value (aug-ame aug))))
)

                             

(defdsmmacro state (gnode)     
                   (gnode) symbol      
 (declare (type gnode gnode))
 `(let ((aug (anode-augs (gnode-state-anode ,gnode))))
   (declare (type aug-or-NIL aug))
   (if aug (tme-value (aug-ame aug))))
)

                             

(defdsmmacro operator (gnode) 
                      (gnode) symbol              
 (declare (type gnode gnode))
 `(let ((aug (anode-augs (gnode-operator-anode ,gnode))))
   (declare (type aug-or-NIL aug))
   (if aug (tme-value (aug-ame aug))))
)
                                                             



;;; SPACE AUGMENTATION UTILITIES.

                       

(defdsmmacro active-space-p (gnode process)      
                            (gnode gme-value) symbol            
 (declare (type gnode gnode)
          (type gme-value process))
 `(eq ,process (problem-space ,gnode)) 
)                            


 
         
(defdsmmacro gnode-space-aug (gnode)
                             (gnode) aug-or-NIL
 (declare (type gnode gnode))
 `(anode-augs (gnode-space-anode ,gnode))
)  



(defdsmmacro gnode-lost-space-outnodes (gnode)
                                       (gnode) list
 (declare (type gnode gnode))
 `(anode-lost-outnodes (gnode-space-anode ,gnode))
)


;;; STATE AUGMENTATION UTILITIES.
                         

(defdsmmacro active-state-p (gnode process)               
                            (gnode gme-value) symbol            
 (declare (type gnode gnode)
          (type gme-value process))
 `(eq ,process (state ,gnode)) 
)

 

(defdsmmacro gnode-state-aug (gnode)
                             (gnode) aug-or-NIL
 (declare (type gnode gnode))
 `(anode-augs (gnode-state-anode ,gnode))
)



(defdsmmacro gnode-lost-state-outnodes (gnode)
                                       (gnode) list
 (declare (type gnode gnode))
 `(anode-lost-outnodes (gnode-state-anode ,gnode))
)



;;; OPERATOR AUGMENTATION UTILITIES.


(defdsmmacro active-operator-p (gnode process)              
                               (gnode gme-value) symbol            
 (declare (type gnode gnode)
          (type gme-value process))
 `(eq ,process (operator ,gnode)) 
)

 

(defdsmmacro gnode-operator-aug (gnode)
                                (gnode) aug-or-NIL
 (declare (type gnode gnode))
 `(anode-augs (gnode-operator-anode ,gnode))
)



(defdsmmacro gnode-lost-operator-outnodes (gnode)
                                          (gnode) list
 (declare (type gnode gnode))
 `(anode-lost-outnodes (gnode-operator-anode ,gnode))
)



;;; PRODUCTION BACKTRACING.


(defdsmmacro put-production-traces (gnode lhs rhs)
                                   (gnode rtrace list) true
 (declare (type gnode gnode)
          (type rtrace lhs)
          (list rhs))
 `(let ((traces (gnode-traces ,gnode)))
   (declare (hash-table traces))
   ;; rhs.
   ;; save one trace for each action.
   (dolist (action ,rhs)      
     (declare (type tme action))
     (setf (gethash action traces) ,lhs))
 T)
)     


#+(or) ;redefined as function.
(defdsmmacro put-chunk-traces (gnode lhs rhs)
                              (gnode rtrace list) true
 (declare (type gnode gnode)
          (type rtrace lhs)
          (list rhs))
 `(let ((traces (gnode-traces ,gnode)))
   (declare (hash-table traces))
   ;; rhs.
   ;; save one trace for each action.
   (dolist (action ,rhs)      
     (declare (type tme action))
     (setf (gethash action traces) ,lhs))
 T)
)


(defdsmmacro context-save-ame-production-trace (gnode ame pme)
                                               (gnode tme tme) rtrace-or-NIL
 (declare (type gnode gnode)
          (type tme ame pme))
 ;; save supporting pme's production trace for ame.
 `(setf (gethash ,ame (gnode-traces ,gnode)) (gethash ,pme (gnode-traces ,gnode)))
)
    


(defdsmmacro get-rule-traces (goal)                      
                             (tme-object) hash-table
 (declare (type tme-object goal))
 `(let ((gnode (goal-gnode ,goal)))
   (declare (type gnode-or-NIL gnode))
   (if gnode (gnode-traces gnode)))
)



(defdsmmacro gnode-rule-trace (gnode action)
                              (gnode tme) rtrace-or-NIL
 (declare (type gnode gnode)
          (type tme action))      
 `(gethash ,action (gnode-traces ,gnode))
)


  
(defdsmmacro production-trace-number (trace)
                                     (rtrace) fixnum
 (declare (type rtrace trace))
 `(rtrace-number ,trace)
)       

  
(defdsmmacro production-trace-results (trace)
                                      (rtrace) list
 (declare (type rtrace trace))
 `(rtrace-results ,trace)
)       

  
(defdsmmacro production-trace-non-results (trace)
                                          (rtrace) list
 (declare (type rtrace trace))
 `(rtrace-non-results ,trace)
)       

  
(defdsmmacro production-trace-possible-results (trace)
                                               (rtrace) list
 (declare (type rtrace trace))
 `(rtrace-possible-results ,trace)
)       


  
(defdsmmacro production-trace-name (trace)
                                   (rtrace) symbol
 (declare (type rtrace trace))
 `(rtrace-name ,trace)
)       

    


;;; RESULT TRACING.
             

(defdsmmacro put-internal-object (goal object)
                                 (tme-object tme-object) list
 (declare (type tme-object goal object))
 `(let ((gnode (goal-gnode ,goal)))
   (declare (type gnode-or-NIL gnode))
   (if gnode
       (push ,object (gnode-internal-objects gnode))) )
)
             

(defdsmmacro drop-internal-object (goal object)
                                  (tme-object tme-object) list
 (declare (type tme-object goal object))
 ;; called by remove-object, during c-support withdrawal,
 ;; and by release-negated-object-symbol.
 `(let ((gnode (goal-gnode ,goal)))
   (declare (type gnode gnode))
   (setf (gnode-internal-objects gnode)
         (delete ,object
                 (gnode-internal-objects gnode)
                 :test #'eq
                 :count 1)))
)
                 


(defdsmmacro put-chunk-actions (gnode tmes)
                               (gnode list) list
 (declare (type gnode gnode)
          (list tmes))
 ;;; Changed union to soar-set-union -- TFMcG 12/22/89
 `(setf (gnode-chunk-actions ,gnode)
        (soar-set-union (gnode-chunk-actions ,gnode) ,tmes :test #'preference=))
)
                 


(defdsmmacro put-promoted-chunk-actions (gnode tmes)
                                        (gnode list) list
 (declare (type gnode gnode)
          (list tmes))
 `(setf (gnode-promoted-chunk-actions ,gnode)
        (soar-set-union (gnode-promoted-chunk-actions ,gnode)
                        ,tmes
                        :test #'preference=))
)

                     

(defdsmmacro clear-chunk-actions (gnode)
                                 (gnode) null
 (declare (type gnode gnode))
 `(let ()
    (setf (gnode-chunk-actions ,gnode) NIL)
    (setf (gnode-promoted-chunk-actions ,gnode) NIL))
)



  
;;; STACK TRAVERSAL.

                                           

(defdsmmacro context-schedule-slot (gnode attribute) 
                                   (gnode gme-attribute) logical
 (declare (type gnode gnode)
          (type gme-attribute attribute))
 `(cond ((eq ,attribute 'operator) 
         (setf (gnode-new-operator-preferences-p ,gnode) T))
        ((eq ,attribute 'state)
         (setf (gnode-new-state-preferences-p ,gnode) T))
        (T
         (setf (gnode-new-space-preferences-p ,gnode) T) ))
)
 

(defdsmmacro schedule-space (gnode)
                            (gnode) logical
 (declare (type gnode gnode))
 `(setf (gnode-new-space-preferences-p ,gnode) T)
)       
 

(defdsmmacro schedule-state (gnode)
                            (gnode) logical
 (declare (type gnode gnode))
 `(setf (gnode-new-state-preferences-p ,gnode) T)
)       
 

(defdsmmacro schedule-operator (gnode)
                               (gnode) logical
 (declare (type gnode gnode))
 `(setf (gnode-new-operator-preferences-p ,gnode) T)
)       

                                           

(defdsmmacro context-unschedule-slot (gnode attribute) 
                                     (gnode gme-attribute) logical
 (declare (type gnode gnode)
          (type gme-attribute attribute))
 `(cond ((eq ,attribute 'operator) 
         (setf (gnode-new-operator-preferences-p ,gnode) NIL))
        ((eq ,attribute 'state)
         (setf (gnode-new-state-preferences-p ,gnode) NIL))
        (T
         (setf (gnode-new-space-preferences-p ,gnode) NIL) ))
)
 

(defdsmmacro unschedule-space (gnode)
                              (gnode) logical
 (declare (type gnode gnode))
 `(setf (gnode-new-space-preferences-p ,gnode) NIL)
)       
 

(defdsmmacro unschedule-state (gnode)
                              (gnode) logical
 (declare (type gnode gnode))
 `(setf (gnode-new-state-preferences-p ,gnode) NIL)
)       
 

(defdsmmacro unschedule-operator (gnode)
                                 (gnode) logical
 (declare (type gnode gnode))
 `(setf (gnode-new-operator-preferences-p ,gnode) NIL)
) 



;;; STACK INITIALIZATION. 

(defdsmmacro initialize-top-context-p ()
                                      () logical
 (declare)
 ;; when init-context called the top gnode is created
 ;; so context preferences can be added with init-wm.
 ;; else, there will be no top-gnode at start.
 `(not (and *top-gnode* (null *initial-goal*)))
)


;;; STACK INQUIRY.


(defdsmmacro top-goal ()         
                      () symbol
 (declare)
 `(if *top-gnode* (gnode-goal *top-gnode*))
)
                   

(defdsmmacro top-gnode ()         
                       () symbol
 (declare)           
 `*top-gnode*
)



(defdsmmacro bottom-goal ()             
                         () symbol
 (declare)
 `(if *bottom-gnode* (gnode-goal *bottom-gnode*))
)
        

           
       
(defdsmmacro bottom-gnode ()
                          () gnode-or-NIL
 (declare)
 `*bottom-gnode*
)



(defdsmmacro bottom-space-name () 
                               () symbol
 (declare)
 `(let ((gnode *bottom-gnode*))
   (declare (type gnode-or-NIL gnode))
   (if (and gnode (gnode-space-aug gnode))
       (object-name (tme-value (aug-ame (gnode-space-aug gnode))))))
)
                    
                         


(defdsmmacro superattribute (attribute)                    
                            (gme-attribute) symbol
 (declare (type gme-attribute attribute))
 `(cond ((eq ,attribute 'operator)
         'state)
        ((eq ,attribute 'state)
         'problem-space)
        (T
         'operator))
)
 



(defdsmmacro goal-depth (goal)             
                        (tme-object) (or null fixnum)                      
 (declare (type tme-object goal))
 `(let ((gnode (goal-gnode ,goal)))
   (declare (type gnode-or-NIL gnode))
   (if gnode (gnode-depth gnode)))
)

                    

(defdsmmacro stack-depth ()  
                         () (or null fixnum) 
 (declare)
 `(if *bottom-gnode* (gnode-depth *bottom-gnode*))
)


(defdsmmacro reset-context ()
                           () null
 (declare)
 ;; called by context walker module to signal that context has changed.
 `(setf *context-goal-state-operator* NIL)
)
            

(defdsmmacro gnode-impasse (gnode)
                           (gnode) symbol
 (declare (type gnode gnode))                                  
 `(let ((supernode (gnode-supernode ,gnode)))
   (declare (type gnode-or-NIL supernode))
   (if supernode (anode-status (gnode-impassed-anode supernode))))
)
            

(defdsmmacro gnode-items (gnode)
                         (gnode) list
 (declare (type gnode gnode))                                  
 `(let ((supernode (gnode-supernode ,gnode)))
   (declare (type gnode-or-NIL supernode))
   (if supernode (anode-items (gnode-impassed-anode supernode))))
)
            

(defdsmmacro gnode-impassed-attribute (gnode)
                                      (gnode) symbol
 (declare (type gnode gnode))                                  
 `(let ((supernode (gnode-supernode ,gnode)))
   (declare (type gnode-or-NIL supernode))
   (if supernode (anode-attribute (gnode-impassed-anode supernode))))
)



;;; STACK UTILITIES.


(defdsmmacro goal-gnode (goal)                  
                        (tme-object) gnode-or-NIL               
 (declare (type tme-object goal))
 ;; goal to gnode by default access method (hash).
 #+(not :GOAL-SEARCH)
 `(let ((onode (gethash ,goal *objects*)))
   (declare (type onode-or-NIL onode))
   (if onode (onode-gnode onode)))
 #+:GOAL-SEARCH
 `(do ((gnode *top-gnode* (gnode-subnode gnode)))
      ((null gnode) NIL)
   (if (eq (gnode-goal gnode) ,goal) (return gnode)))
)


;;; IMPASSE INSTALLATION.

            
(defdsmmacro context-install-constraint-failure-impasse (gnode attribute candidates)
                                                        (gnode gme-attribute list) T
 (declare (type gnode gnode)
          (type gme-attribute attribute) 
          (list candidates))
 `(put-goal ,gnode ,attribute 'constraint-failure ,candidates)
)   


(defdsmmacro context-install-conflict-impasse (gnode attribute candidates)
                                              (gnode gme-attribute list) T
 (declare (type gnode gnode)
          (type gme-attribute attribute)
          (list candidates))
 `(put-goal ,gnode ,attribute 'conflict ,candidates)
)



(defdsmmacro context-install-tie-impasse (gnode attribute candidates)
                                         (gnode gme-attribute list) T
 (declare (type gnode gnode)
          (type gme-attribute attribute)
          (list candidates))
 `(put-goal ,gnode ,attribute 'tie ,candidates)
)



(defdsmmacro install-no-change-impasse (gnode attribute)
                                       (gnode gme-attribute) T
 (declare (type gnode gnode)
          (type gme-attribute attribute))
 ;;; install no-change impasse for the single process in slot.
 `(put-goal ,gnode          ;supernode
            ,attribute
            'no-change
            NIL)
)


;;; IMPASSE REMOVAL.
                  

(defdsmmacro context-remove-constraint-failure-impasse (gnode attribute)       
                                                       (gnode gme-attribute) T
 (declare (type gnode gnode)
          (type gme-attribute attribute)) 
 `(remove-goal ,gnode ,attribute)
)



(defdsmmacro context-remove-conflict-impasse (gnode attribute)                     
                                             (gnode gme-attribute) T
 (declare (type gnode gnode)
          (type gme-attribute attribute))
 `(remove-goal ,gnode ,attribute)
)



(defdsmmacro context-remove-tie-impasse (gnode attribute)    
                                        (gnode gme-attribute) T
 (declare (type gnode gnode)
          (type gme-attribute attribute))
 `(remove-goal ,gnode ,attribute)
)



(defdsmmacro remove-no-change-impasse (gnode attribute)
                                      (gnode gme-attribute) T
 (declare (type gnode gnode)
          (type gme-attribute attribute)
          (ignore gnode attribute))   
 ;;; don't need to flush substructure for no-change impasse.
 ;;; this will have been done during process removal.
 ;;; (a slot with a no-change impasse has active processes.)
 ;;; also new processes or impasses will have been installed.
 `T
)


;;; IMPASSE REVISION.


(defdsmmacro context-drop-impasse-items (gnode attribute items)
                                        (gnode gme-attribute list) T
 (declare (type gnode gnode)
          (type tme-attribute attribute)
          (list items)
          (ignore attribute))
 `(drop-item-ames (gnode-subnode ,gnode) ,items)
)
            


(defdsmmacro context-add-impasse-items (gnode attribute items)                    
                                       (gnode gme-attribute list) T 
 (declare (type gnode gnode)
          (type gme-attribute attribute)
          (list items)
          (ignore attribute))
 `(add-item-ames (gnode-subnode ,gnode) ,items)
)
                     


;;; IMPASSE UTILITIES.


(defdsmmacro choices (impasse)             
                     (symbol) symbol                       
 (declare (symbol impasse))
 `(cond ((null ,impasse)
         NIL)
       ((member ,impasse '(conflict tie) :test #'eq)
        'multiple)
       (T
        'none))
)



(defdsmmacro fixed-goal-slot-p (attribute)                        
                               (gme-attribute) T
 (declare (type gme-attribute attribute))
 `(if (member ,attribute '(object attribute impasse item choices
                           supergoal applied quiescence) 
              :test #'eq)
      T)
)            



(defdsmmacro protected-goal-slot-p (attribute)            
                                   (gme-attribute) T
 (declare (type gme-attribute attribute))
 `(member ,attribute
          '(operator state problem-space
            object attribute impasse item choices
            supergoal applied quiescence) 
          :test #'eq)
)




(defdsmmacro context-goal-slot-p (attribute)                        
                                 (gme-attribute) logical
 (declare (type gme-attribute attribute))
 `(if (member ,attribute '(operator state problem-space) :test #'eq) T)
)            
       

;;; NEW PREFERENCE ARRIVAL.


(defdsmmacro context-legal-preference-p (tme)
                                        (tme) logical
 (declare (type tme tme))
 ;; assumes object is a goal and attribute is problem-space, state, or operator.
 `(let ((process (tme-value ,tme))     
        (reference (tme-reference ,tme)))
   (declare (type gme-value process reference)) 
   (cond
    ((or (goal-p process) (goal-p reference))
     (soar-format *trace-file*
                  "~%WARNING: Augmentations cannot point to goals. ~
                   ~%         Ignoring preference ~A."
                  (print-wme NIL ,tme))
     NIL)
    ((or (impasse-p process) (impasse-p reference))
     (soar-format *trace-file*
                  "~%WARNING: Augmentations cannot point to impasses. ~
                   ~%         Ignoring preference ~A."
                  (print-wme NIL ,tme))
     NIL)
    ((eq (tme-type ,tme) '&)
     (soar-format *trace-file*
                  "~%WARNING: Parallels not allowed for context slots. ~
                   ~%         Ignoring preference ~A."
                  (print-wme NIL ,tme))
     NIL)
    (T            
     ;; legal preference.
     T)) )
)
 


;;; C-SUPPORT WITHDRAWAL.

(defdsmmacro context-log-lost-outnode (gnode attribute value)
                                      (gnode gme-attribute gme-value) list
 (declare (type gnode gnode)
          (type gme-attribute attribute)
          (type gme-value value))
 `(cond ((eq ,attribute 'operator)
         (push ,value (anode-lost-outnodes (gnode-operator-anode ,gnode))))
        ((eq ,attribute 'state)                        
         (setf (anode-lost-outnodes (gnode-state-anode ,gnode)) NIL))
        (T
         (setf (anode-lost-outnodes (gnode-space-anode ,gnode)) NIL) ))
)


(defdsmmacro log-lost-space-outnode (gnode space)
                                    (gnode gme-value) list
 (declare (type gnode gnode)
          (type gme-value space))
 `(push ,space (anode-lost-outnodes (gnode-space-anode ,gnode)))
) 


(defdsmmacro log-lost-state-outnode (gnode state)
                                    (gnode gme-value) list
 (declare (type gnode gnode)
          (type gme-value state))
 `(push ,state (anode-lost-outnodes (gnode-state-anode ,gnode)))
) 


(defdsmmacro log-lost-operator-outnode (gnode operator)
                                       (gnode gme-value) list
 (declare (type gnode gnode)
          (type gme-value operator))
 `(push ,operator (anode-lost-outnodes (gnode-operator-anode ,gnode)))
) 


(defdsmmacro context-unlog-lost-outnodes (anode)
                                         (anode) list
 (declare (type anode anode))
 `(setf (anode-lost-outnodes ,anode) NIL)
)


(defdsmmacro context-unlog-lost-operator-outnodes (anode selected-operator)
                                                  (anode gme-value) list
 (declare (type anode anode)
          (type gme-value selected-operator))
 ;; do not remove the outnode for the selected operator.
 `(if (and ,selected-operator
           (member ,selected-operator (anode-lost-outnodes ,anode) :test #'eq))
      (setf (anode-lost-outnodes ,anode) (list ,selected-operator))
      (setf (anode-lost-outnodes ,anode) NIL))
)






;;; Concatenated from type module "mpreferences" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mpreferences/new/mpreferences.lisp".
(in-package "SOAR")



;;; <PREFERENCES.MACROS>


;;; PREFERENCES MODULE: MACROS.


;;; MODULE DESCRIPTION.
;;;  Preference handling utilities used by Context and Subtext modules.


;;; MODULE RECORD DEFINITIONS.   
;;;  See TEXT Module.

#|


 Modules: Preferences: Contents

          
 Introduction

 Data
   Globals
     *accept-trailer*
     *parallel-trailer*

 Functions
   Typed Preference Operations
   Untyped Preference Operations
   Other Preference Operations
   Preference Type Classification
   Preferences Report
   Utilities



 Modules: Preferences: Introduction


 Preferences is a utility module for the maintenance of the preference
 information in attribute (anode) records.

 More specifically, Preferences manages the pnode and preferences records
 attached to anodes.

 Preferences is used primarily by Context and Subtext to access and update
 the preferences database.



 Modules: Preferences: Data: Globals


   *accept-trailer*
     A constant: '(+).
     Used to make acceptable pmes for Soar/IO ames and context fixed ames.

   *parallel-trailer*
     A constant: '(&).
     Used to make parallel pmes for Soar/IO ames.

|#



;;; MODULE GLOBALS.

(defconstant *accept-trailer*
             '(+)
             "Used to make acceptable pmes for ames.")


(defconstant *parallel-trailer*
             '(&)
             "Used to make parallel pmes for ames.")



;;; MODULE MACROS.


;;; OTHER PREFERENCES OPERATIONS.


(defdsmmacro core-preference-type-p (internal-preference-type)
                                    (preferences) T
 (declare (symbol internal-preference-type))
 `(member ,internal-preference-type '(accept parallel) :test #'eq)
)


(defdsmmacro make-accept-pme-for-ame (ame)
                                     (tme) tme
 (declare (type tme ame))
 `(append (subseq ,ame 0 4) *accept-trailer*)
)


(defdsmmacro make-parallel-pme-for-ame (ame)
                                       (tme) tme
 (declare (type tme ame))
 `(append (subseq ,ame 0 4) *parallel-trailer*)
)

               

;;; PREFERENCE TYPE CLASSIFICATION.


(defdsmmacro require-tme-p (tme)
                           (tme) logical
 (declare (type tme tme))
 `(eq (tme-type ,tme) require-token)
)


(defdsmmacro prohibit-tme-p (tme)
                            (tme) logical
 (declare (type tme tme))
 `(eq (tme-type ,tme) prohibit-token)
)                      


(defdsmmacro accept-tme-p (tme)
                          (tme) logical
 (declare (type tme tme))
 `(eq (tme-type ,tme) accept-token)
)


(defdsmmacro reject-tme-p (tme)
                          (tme) logical
 (declare (type tme tme))
 `(eq (tme-type ,tme) reject-token)
)


(defdsmmacro reconsider-tme-p (tme)
                              (tme) logical
 (declare (type tme tme))
 `(eq (tme-type ,tme) reconsider-token)
)


(defdsmmacro better-tme-p (tme)
                          (tme) logical
 (declare (type tme tme))
 `(and (eq (tme-type ,tme) better-token) (tme-reference-p ,tme))
)


(defdsmmacro best-tme-p (tme)
                        (tme) logical
 (declare (type tme tme))
 ;; assume that have already tested for better so need not check reference.
 `(eq (tme-type ,tme) better-token)
)


(defdsmmacro worst-tme-p (tme)
                         (tme) logical
 (declare (type tme tme))
 ;; need not check reference, as there are no worses to distinguish worsts from
 ;; (worses are converted to betters).
 `(eq (tme-type ,tme) worst-token)
)                            


(defdsmmacro indifferent-tme-p (tme)
                               (tme) logical
 (declare (type tme tme))
 `(and (eq (tme-type ,tme) indifferent-token) (not (tme-reference-p ,tme)))
)


(defdsmmacro indifferent-to-tme-p (tme)
                                  (tme) logical
 (declare (type tme tme))
 `(and (eq (tme-type ,tme) indifferent-token) (tme-reference-p ,tme))
)


(defdsmmacro parallel-tme-p (tme)
                            (tme) logical
 (declare (type tme tme))
 `(and (eq (tme-type ,tme) parallel-token) (not (tme-reference-p ,tme)))
)


(defdsmmacro parallel-to-tme-p (tme)
                               (tme) logical
 (declare (type tme tme))
 `(and (eq (tme-type ,tme) parallel-token) (tme-reference-p ,tme))
)




;;; Concatenated from type module "mp-graph" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mp-graph/new/mp-graph.lisp".
(in-package "SOAR")





;;; <P-GRAPH.MACROS>

;;; P-GRAPH MODULE: MACROS.


;;; MODULE DESCRIPTION.
;;;  Traverses the graph represented by the acceptable and require preferences
;;;  in architecture memory.

#|


 Modules: P-Graph: Contents

          
 Introduction

 Functions
   Ancestors
   Descendents

   Parents
   Children

   Context Support

   Miscellaneous Inquiry
   User Inquiry

   Utilities



 Modules: P-Graph: Introduction


 P-Graph is traverses the graph represented by the acceptable and require
 preferences in architecture memory.
                                                                           
 Principal uses:

   P-graph is used by the Firer in rule classification.
   P-Graph is used by Subtext in context support withdrawal.
   P-graph is used for user inquiry and system level debugging.


|#



;;; MODULE MACROS.


;;; USER INQUIRY.
 

(defmacro p-graph (object &key (descendents T)
                               (nested T)     
                               (type 'O)) ;o(bjects), n(odes), or v(alues)
 (declare (type tme-object object)
          (type logical descendents nested)
          (symbol type))
 `(cond (,descendents
         (cond (,nested
                (cond ((eq ',type 'O)
                       (nested-object-p-descendent-objects ',object))
                      ((eq ',type 'N)
                       (nested-object-p-descendent-onodes ',object)) 
                      (T
                       (nested-object-p-descendent-values ',object))))
               (T
                (cond ((eq ',type 'O)
                       (object-p-descendent-objects ',object))
                      ((eq ',type 'N)
                       (flatten (nested-object-p-descendent-onodes ',object)))
                      (T
                       (flatten (nested-object-p-descendent-values ',object)) )) )) )
        (T ;ancestors.
         (cond (,nested
                (cond ((eq ',type 'O)
                       (nested-object-p-ancestor-objects ',object))
                      ((eq ',type 'N)
                       (nested-object-p-ancestor-onodes ',object))
                      (T
                       (soar-format *trace-file* "~%Invalid Setting.") )) )
               (T
                (cond ((eq ',type 'O)
                       (object-p-ancestor-objects ',object))
                      ((eq ',type 'N)
                       (flatten (object-p-ancestor-onodes ',object)))
                      (T
                       (soar-format *trace-file* "~%Invalid Setting.") )) )) ))
)  



;;; PARENTS.


(defdsmmacro onode-p-parent-onodes (onode)
                                   (onode) list
 (declare (type onode onode))
 `(onode-innodes ,onode)
)                      


;;; CHILDREN.


(defdsmmacro onode-p-child-onodes (onode)
                                  (onode) list
 (declare (type onode onode))
 `(onode-outnodes ,onode)
)                  


(defdsmmacro gnode-p-child-values (gnode onode)
                                  (gnode onode) list
 (declare (type gnode gnode)
          (type onode onode)
          (ignore gnode))

 ;; gnode's onode's outnodes include those of space, state, and operator.
 `(onode-p-child-values ,onode)
)                        


                 
;;; DESCENDENTS.

                                       
(defdsmmacro onode-p-descendent-onodes (onode)                                                    
                                       (onode) list
 (declare (type onode onode))
 `(if (onode-p-child-onodes ,onode)
      (delete ,onode
              (onode-p-descendent-onodes-aide (onode-p-child-onodes ,onode)
                                              (list ,onode))
              :test #'eq))
)



(defdsmmacro onode-p-descendent-internal-onodes (goals onode)                                                    
                                                (list onode) list
 (declare (type list goals)
          (type onode onode))
 ;; used during subgoal results tracing.
 ;; find all the onodes (object nodes) reachable from object and
 ;; owned by one of goals.                            
 `(if (onode-p-child-onodes ,onode)
      (delete ,onode
              (onode-p-descendent-internal-onodes-aide ,goals
                                                       (onode-p-child-onodes ,onode)
                                                       (list ,onode))
              :test #'eq))
)

                                       
(defdsmmacro onode-p-descendent-onode-p (candidates onode)                                                    
                                        (list onode) logical
 (declare (type onode onode)
          (list candidates))
 `(if (onode-p-child-onodes ,onode)
      (onode-p-descendent-onode-p-aide ,candidates
                                       (onode-p-child-onodes ,onode)
                                       (list ,onode)))
)


;;; CONTEXT SUPPORT (C-SUPPORT).
                          

(defdsmmacro onode-linked-to-context-p (onode)                                                    
                                       (onode) logical
 (declare (type onode onode))
 ;; used during c-support withdrawal.
 ;; does onode have an ancestor that is either a goal or an impasse?
 ;; then onode is p-linked to context.
 `(if (onode-p-parent-onodes ,onode)
      (onode-linked-to-context-p-aide (onode-p-parent-onodes ,onode) (list ,onode)))
)

    












;;; Concatenated from type module "ma-graph" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/ma-graph/new/ma-graph.lisp".
(in-package "SOAR")





;;; <A-GRAPH.MACROS>

;;; A-GRAPH MODULE: MACROS.


;;; MODULE DESCRIPTION.
;;;  Traverses the graph represented by the augmentations in working memory.

#|


 Modules: A-Graph: Contents

          
 Introduction

 Functions
   Ancestors
   Descendents

   Parents
   Children

   Trace Attributes

   Miscellaneous Inquiry
   User Inquiry

   Utilities



 Modules: A-Graph: Introduction


 A-Graph traverses the graph represented by the augmentations in
 working memory.
                                                                           
 Principal uses:

   A-Graph is used by the Tracer in the printing of trace-attribute values.
   A-Graph is used by the Decider in selecting among indifferent candidates by
   trace-attribute criteria.
   A-graph is used for user inquiry and system level debugging.

|#


;;; USER INQUIRY.
 

(defmacro a-graph (object &key (descendents T)
                               (nested T)     
                               (type 'O)) ;o(bjects), n(odes), or v(alues)
 (declare (type tme-object object)
          (type logical descendents nested)
          (symbol type))
 `(cond (,descendents
         (cond (,nested
                (cond ((eq ',type 'O)
                       (nested-object-a-descendent-objects ',object))
                      ((eq ',type 'N)
                       (nested-object-a-descendent-onodes ',object)) 
                      (T
                       (nested-object-a-descendent-values ',object))))
               (T
                (cond ((eq ',type 'O)
                       (object-a-descendent-objects ',object))
                      ((eq ',type 'N)
                       (flatten (nested-object-a-descendent-onodes ',object)))
                      (T
                       (flatten (nested-object-a-descendent-values ',object)) )) )) )
        (T ;ancestors.
         (cond (,nested
                (cond ((eq ',type 'O)
                       (nested-object-a-ancestor-objects ',object))
                      ((eq ',type 'N)
                       (nested-object-a-ancestor-onodes ',object))
                      (T
                       (soar-format *trace-file* "~%Invalid Setting.") )) )
               (T
                (cond ((eq ',type 'O)
                       (object-a-ancestor-objects ',object))
                      ((eq ',type 'N)
                       (flatten (object-a-ancestor-onodes ',object)))
                      (T
                       (soar-format *trace-file* "~%Invalid Setting.") )) )) ))
)  


;;; TRACE ATTRIBUTES.


(defdsmmacro nested-trace-attribute-values (object)
                                           (tme-object) list
 (declare (type tme-object object))         
 ;; used by watch.
 `(nested-trace-attribute-values-aide (object-trace-attribute-children ,object)
                                      (list ,object))
)



(defdsmmacro trace-attribute-value-p (object value)
                                     (tme-object tme-value) logical
 (declare (type tme-object object)
          (type tme-value value))
 ;; used by user-select.
 `(trace-attribute-value-p-aide ,value
                                (object-trace-attribute-children ,object)
                                (list ,object))
)


(defdsmmacro trace-attribute-values-p (object values)
                                      (tme-object list) logical
 (declare (type tme-object object)
          (list values)) 
 ;; used by user-select.
 `(trace-attribute-values-p-aide ,values
                                 (object-trace-attribute-children ,object)
                                 (list ,object))
)








;;; Concatenated from type module "mdecider" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mdecider/new/mdecider.lisp".
(in-package "SOAR")





;;; <DECIDER.MACROS>


;;; DECIDER MODULE: MACROS.  


;;; MODULE DESCRIPTION.
;;;   Computes slot status from the slot preferences.
;;;   Status is expressed as (list status items), where
;;;     status is one of: winner, winners, constraint-failure, tie, conflict,
;;;     or rejection, and
;;;     items is a list of values or impasse items.                  


#|


 Modules: Decider: Contents

          
 Introduction

 Data
   Globals
     *user-select*
     *default-user-select*
     *print-user-select-choices*

 Functions
   Preference Tally

   Conflict Utilities
   Mutuality Utilities
   Indifference Utilities
   Exhaustion Utilities

   Miscellaneous Utilities



 Modules: Decider: Introduction

 
 The Decider is the decision procedure.

 Decider is called by the Supervisor during the working memory phase, for
 non-context slots, and during the quiescence phase, for context slots, and
 by the user interface function tally.

 The Decider receives the anode for the slot in question, extracts the old
 status and preferences from the anode, computes a new status for the anode,
 and updates the anode with this new status. The Supervisor passes the updated
 anode to the Conflux or Subflux modules, which direct the slot transition,
 if the slot status has changed.



 Modules: Decider: Data: Globals


   *user-select*
     User-select setting, as specified by user with the user-select command.
     Default setting is 'first.


   *default-user-select*       
     Selection criterion to be used when those specified by the user-select command
     have been exhausted.
     Default is T.  


   *print-user-select-choices*
     If T, user-select choices are printed even if the selection is made
     automatically. 
     Default is NIL.

|#


;;; MODULE GLOBALS.

(defvar *user-select*
        'first
        "User-select setting. Default is first.") 

(defvar *default-user-select*
        T
        "Default (exhaustion fallback) user select setting. Default is T.")
   
(defvar *print-user-select-choices* 
        NIL
        "If T, print user-select choices even if selection is automatic."
)                                                                      



;;; MODULE MACROS.

;;; INDIFFERENCE UTILITIES.                        
;;;  Used when candidates reduced to a set of mutually indifferent
;;;  candidates.


(defdsmmacro select-first (candidates)               
                         (list) tme-value
 (declare (list candidates))
 ;; candidate list is in order of generation.
 `(first ,candidates)
)                         


(defdsmmacro select-last (candidates)               
                         (list) tme-value
 (declare (list candidates))
 ;; candidate list is in order of generation.
 `(first (last ,candidates))
)
                            

                            
(defdsmmacro select-randomly (candidates)               
                             (list) tme-value
 (declare (list candidates))
 `(elt ,candidates (random (length ,candidates)))
)

 
                            
(defdsmmacro select-by-asking (candidates)               
                              (list) tme-value
 (declare (list candidates))
  `(ask-for-choice ,candidates)
)




(defdsmmacro user-select-criterion-type ()     
                                        () symbol
 (declare)
 `(cond ((eq *user-select* 'first)
         'first)
        ((eq *user-select* 'last)
         'last)
        ((eq *user-select* NIL)
         'random)
        ((eq *user-select* T)
         'ask)
        ((integerp (first *user-select*))
         ;; note that a list of trace-attribute values that are
         ;; integers would be interpreted as a list of indices.
         'index)
        ((atom (first *user-select*))
         'trace-attribute-value)
        (T
         'trace-attribute-values))
)



       
(defdsmmacro user-select-criterion ()            
                                   () T
 (declare)
 ;;; changes *user-select*.
 `(let ((criterion (pop *user-select*)))
   (declare (atom criterion))
   (if (null *user-select*)
       (setf *user-select* *default-user-select*))
   criterion)
)        
       


;;; EXHAUSTION UTILITIES.
;;;  Used when all candidates have been eliminated.                          

(defdsmmacro exhaustion (anode)
                        (anode) T
 (declare (type anode anode))
 ;;; all acceptable candidates have been eliminated, that is,
 ;;; no process has preference support.
 `(throw-decision 'rejection NIL ,anode)
)                                   



;;; MISCELLANEOUS UTILITIES.


(defdsmmacro remove-if-candidate (candidates pairs)              
                                 (list list) list  
 (declare (list candidates pairs))
 `(cond ((and ,candidates ,pairs)
         (remove-if
          #'(lambda (pair) (or (member (first pair)
                                       ,candidates
                                       :test #'tme-value=)
                               (member (second pair)
                                       ,candidates
                                       :test #'tme-value=)))
          ,pairs))
         (T
          ,pairs))
) 


                                  
(defdsmmacro remove-if-not-candidate (candidates list)                
                                     (list list) list
 (declare (list candidates list))
 `(cond ((and ,candidates ,list)
         (remove-if-not
          #'(lambda (item) (member item ,candidates :test #'tme-value=))
          ,list))
        (T
         NIL))
)



(defdsmmacro remove-if-not-candidates (candidates pairs)
                                      (list list) list
 (declare (list candidates pairs))
 `(cond ((and ,candidates ,pairs)
         (remove-if-not
          #'(lambda (pair) (and (member (first pair)
                                       ,candidates
                                       :test #'tme-value=)
                                (member (second pair)
                                        ,candidates
                                        :test #'tme-value=)))
          ,pairs))
        (T
         NIL))
)


                                  
(defdsmmacro winner-or-winners (candidates)      
                               (list) symbol
 (declare (list candidates))
 `(if (null (rest ,candidates))
      'winner
      'winners)
)



(defdsmmacro relation= (relation1 relation2)
                       (list list) logical        
 (declare (list relation1 relation2))
 `(and (tme-value= (first ,relation1) (first ,relation2))
       (tme-value= (second ,relation1) (second ,relation2)))
)

       



;;; Concatenated from type module "mdiplomat" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mdiplomat/new/mdiplomat.lisp".
(in-package "SOAR")




;;; <DIPLOMAT.MACROS>




;;; DIPLOMAT MODULE: MACROS.


;;; MODULE DESCRIPTION.
;;;   Handles intermodule communications-                
;;;   but only those intermodule communications that are, or may be supposed
;;;   likely to be, of interest to more than two modules.

;;;   Intermodule communications are triggered by "events", examples of which
;;;   are cycle starts, cycle ends, and production firings.
;;;   These events are signalled from without upon detection.
;;;   The diplomat "handles" these events by updating event statistics,
;;;   running dynamic tasks scheduled for the events, including
;;;   break detection tasks, and informing other modules of the events.


;;; MODULE NOTES.
;;;   Should have instantiation-inception and retraction-inception events.



;;; MODULE BACKGROUND.
;;;   The EVENT CLASSES are:
;;;     preference-phase-start
;;;     preference-phase-end
;;;     working-memory-phase-start
;;;     working-memory-phase-end
;;;     quiescence-phase-start
;;;     quiescence-phase-end
;;;     firing
;;;     retraction
;;;     goal-creation
;;;     context-installation
;;;     augmentation-addition
;;;     augmentation-removal
;;;     preference-addition
;;;     preference-removal
;;;     decision

;;;   Internal events are not signalled from without but rather by the handlers
;;;   for other events.
;;;   The INTERNAL EVENT CLASSES are:
;;;     production-start
;;;     production-end
;;;     run-cycle-start
;;;     run-cycle-end 

;;;   The CYCLE NAMES are:
;;;     preference-phase
;;;     working-memory-phase
;;;     quiescence-phase
;;;     production (preference-phase or working-memory-phase or quiescence-phase)
;;;     run-cycle (either a preference phase and the succeeding working memory phase,
;;;                or a quiescence phase)
;;; END MODULE BACKGROUND.

#|
  


 Modules: Diplomat: Contents

          
 Introduction
 Data                         
   Records
     Event
     Events
   Globals 
     *events*
     *keyboard-breaks-p*
     *break-p*
     *halt-p*
     *forced-quiescence-p*
     *elaborations-since-quiescence* 

 Functions
   Event Handling
   Break Scheduling
   Breaking
   Halting
   Forced Quiescence
   Statistics Inquiry
   Event Table Utilities
   Miscellaneous Utilities



 Modules: Diplomat: Introduction


 The Diplomat handles events of public interest, to wit:
  
   Preference Phase Start.
     If there is a top state, the Soar/IO input cycle is invoked.
   Preference Phase End.
   Working Memory Phase Start.                                   
     The Context and Subtext modules release working memory traffic and
     internal operations delayed during the preference phase.
   Working Memory Phase End.                                 
     If there is a top state, the Soar/IO output cycle is invoked.
     If there is a top state, the Soar/IO input cycle is invoked.
   Quiescence Phase Start.
   Quiescence Phase End.

   Production Cycle Start.
   Production Cycle End.
   Run Cycle Start.
   Run Cycle End.

   Decision.
   Goal Creation.
   Context Installation.

   Production Firing.
   Production Retraction.

   Augmentation Addition.
   Augmentation Removal.
   Preference Addition.
   Preference Removal.
           
   Break.                                   
     Breaks can be signalled by the Diplomat itself, if some event satisfies
     break criteria specified by the user, or from an other module.
     The Supervisor polls the Diplomat for breaks.

   Halt.
     Halts can be signalled from any module.
     The Supervisor polls the Diplomat for halts.
                                               

  The Diplomat interacts extensively with the Tracer to determine what is being
  traced and to request trace reports.

  The Diplomat maintains the event statistics used by the user function 
  print-stats.
  


 Modules: Diplomat: Data: Records: Event

 
   Event Record (EVENT). 

     Represents one of the "public" events handled by the Diplomat module.

     Contains these fields:
       
       Count. Number of times event has occurred since last init-soar invocation.
         This is used by print-stats.
       Break-Count. Signal break when count is equal to break-count. 
         This is set when a break is scheduled through user functions run or pbreak.
       Break-Criteria. A list of break criteria.
         Signal break when the break criteria are met. 
         This is set when a break is scheduled through user functions run or pbreak.
         The criteria differ from event to event. 
         For example, if the user has scheduled a break on the addition of a
         ame, then this ame will be among the criteria for the event
         augmentation-addition.




 Modules: Diplomat: Data: Records: Events

                                 
   Events Record (EVENTS).

     Represents all the "public" events handled by the Diplomat module.

     Contains these fields:
                   
     Cycling Phases.
       Preference-Phase-Start. Event record for preference phase start.
       Preference-Phase-End. Event record for preference phase end.
       Working-Memory-Phase-Start. Event record for working memory phase start.  
       Working-Memory-Phase-End. Event record for working memory phase end.   
       Quiescence-Phase-Start. Event record for quiescence phase start.  
       Quiescence-Phase-End. Event record for quiescence phase start.  

     Firing.
       Firing. Event record for production firing.  
       Retraction. Event record for production retraction.

     Context Stack.
       Goal-Creation. Event record for goal creation.
       Goal-Removal. Event record for goal removal.
       Context-Installation. Event record for context installation.

     Augmentation Traffic. 
       Augmentation-Addition. Event record for addition of ame to working memory.
       Augmentation-Removal. Event record for removal of ame from working memory.

     Preference Traffic.
       Preference-Wme-Addition. Event record for addition of pme to working memory.
       Preference-Wme-Removal. Event record for removal of pme from working memory.
       Preference-Addition. Event record for addition of pme to architecture memory.
       Preference-Removal. Event record for removal of pme from architecture memory.

     Decision.
       Decision. Event record for decision.

     Meta-Events.
       Production Start. Event record for production cycle start, which is one of:
         preference phase start, working memory phase start, quiescence phase start.
       Production End. Event record for production cycle end, which is one of:
         preference phase end, working memory phase end, quiescence phase end.
       Run Cycle Start. Event record for run cycle start, which is one of:
         preference phase start, quiescence phase start.
       Run Cycle End. Event record for run cycle end, which is one of:
         preference phase end, quiescence phase end.



 Modules: Diplomat: Data: Globals


   *events*
     Points to events record (EVENTS), which represents internal events
     such as augmentation-addition and context-installation.

   *keyboard-breaks-p
     T if keyboard breaks are permitted.
     Used to suppress keyboard breaks when testing with file input.

   *break-p*
     T if a break has been signalled. Soar will break at end of next cycle
     (preference phase, working memory phase, or quiescence phase).
     Used when a break has been scheduled by the user using pbreak or run,
     and the criteria for the break have been satisfied.

   *halt-p*
     T if a halt has been signalled. Soar will halt at end of next cycle
     (preference phase, working memory phase, or quiescence phase).
     Used when system detects an error from which it cannot recover, or 
     when halt action is executed from a production RHS.

   *forced-quiescence-p*
     T if forced-quiescence has been signalled.
     Forced-quiescence is signalled when too many elaboration cycles 
     (that is, run cycles: preference phase followed by working memory phase)
     have been executed without reaching quiescence.
     The maximum number of elaboration cycles allowed without quiescence is
     specified by the global *max-elaborations*.

   *elaborations-since-quiescence*
     The number of elaboration cycles (run cycles) executed since the last 
     quiescence phase.
     Used to detect that *max-elaborations* has been exceeded and that quiescence
     should be forced.





|#



;;; MODULE RECORDS.

(defstruct (event (:constructor make-event ()))
                  "Event statistics and break criteria. Attached to events record."
                  (count           0    :type fixnum)
                  (break-count     0    :type fixnum) 
                  (break-criteria  NIL  :type list)
)                                       

(defstruct (events (:constructor make-events ()))
                  "Events record. Holds event records."
                  (preference-phase-start      (make-event)  :type event)
                  (preference-phase-end        (make-event)  :type event)
                  (working-memory-phase-start  (make-event)  :type event)
                  (working-memory-phase-end    (make-event)  :type event)
                  (quiescence-phase-start      (make-event)  :type event)
                  (quiescence-phase-end        (make-event)  :type event)
                  (firing                      (make-event)  :type event)
                  (retraction                  (make-event)  :type event)
                  (goal-creation               (make-event)  :type event)
                  (goal-removal                (make-event)  :type event)
                  (context-installation        (make-event)  :type event)
                  (augmentation-addition       (make-event)  :type event)
                  (augmentation-removal        (make-event)  :type event)
                  (preference-wme-addition     (make-event)  :type event)
                  (preference-wme-removal      (make-event)  :type event)
                  (preference-addition         (make-event)  :type event)
                  (preference-removal          (make-event)  :type event)
                  (decision                    (make-event)  :type event)
                  (production-start            (make-event)  :type event)
                  (production-end              (make-event)  :type event)
                  (run-cycle-start             (make-event)  :type event)
                  (run-cycle-end               (make-event)  :type event)
)                                       



;;; MODULE GLOBALS.

;;; EVENTS.
(defvar *events*
        (make-events)
        "Holds events record that holds event records.")


;;; BREAKING.

(defvar *keyboard-breaks-p*
        T
        "Should Soar break on input from the keyboard when standard text input is off ?")


;;; break at end of next production cycle
;;; (firing or working memory or quiescence cycle).
(defvar *break-p*
        NIL
        "T if a break has been signalled.")


;;; HALTING.   
;;;  Halting could be treated as a special case of breaking.
(defvar *halt-p*
        NIL
        "T if a halt has been signalled.")


;;; FORCED QUIESCENCE.
;;;  Set by signal-working-memory-phase-end when the maximum number of elaboration cycles
;;;  allowed between quiescence-phase phases exceeds *max-elaborations*.
;;;  Cleared by signal-quiescence-phase-start.
(defvar *forced-quiescence-p*
        NIL
        "T if forced quiescence (*max-elaborations* exceeded) has been signalled.")

;;; MISCELLANEOUS STATISTICS.
                      
;;; Number of elaboration cycles since the last quiescence.
;;; Incremented by signal-working-memory-phase-end.
;;; Cleared by signal-quiescence-phase-start.
;;; Used to detect that the maximum number of elaboration cycles 
;;; allowed between quiescence-phase phases has been exceeded.
(defvar *elaborations-since-quiescence*
        0
        "Used to detect that *max-elaborations* has been exceeded.")
                              

;;; MODULE DEFTYPES.

(deftype event-or-NIL () '(or null event))


;;; MODULE MACROS.       


;;; BREAKING.   


(defmacro keyboard-breaks (&optional (t-or-nil nil t-or-nil-p))
 (cond (t-or-nil-p 
      	 (unless (or (eq t-or-nil t) (null t-or-nil))
     	   (error "~% Keyboard-breaks takes an optional argument of either T or Nil, not ~A."
            	  	t-or-nil))
       	`(setf *keyboard-breaks-p* ,t-or-nil))
       (t
        '*keyboard-breaks-p*))
)                 



(defdsmmacro signal-break ()
                          () true
 (declare)
 `(setf *break-p* T)
)



(defdsmmacro break-p ()
                     () logical
 (declare)
 `*break-p*
)

                    

(defdsmmacro clear-break ()
                         () null
 (declare)
 `(setf *break-p* NIL)
)
            

(eval-when (compile eval load) (proclaim '(special *text-input* *break-char*)))

(defdsmmacro keyboard-break-p ()
                              () T
 ;; T if cycler should break.              
 ;; Changed to call listen only if it needs to, to prevent Allegro bug 
 ;; from surfacing. -BGM 7-Feb-90.
 ;; If text/io is on, only *break-char* causes break;
 ;; else, any character. -BGM 2/26/89.
 ;; *break-char* is defined in io.
 (declare)
 `(when *keyboard-breaks-p* 
   (if (listen)
      (if *text-input*
          (eq (peek-char) *break-char*)
          *keyboard-breaks-p*))))
  
(defdsmmacro clear-keyboard-break () 
                                  () T
 ;; unscheduled break overrides any scheduled cycle breaks.
 (declare)
 `(let ()
   (read-char *standard-input*)
   (unschedule-cycle-breaks))
)



;;; HALTING.


(defdsmmacro signal-halt ()
                         () true
 (declare)
 `(setf *halt-p* T)
)


(defdsmmacro halt-p ()
                    () logical
 (declare)
 `*halt-p*
)


  
(defdsmmacro clear-halt ()
                        () null
 (declare)
 `(setf *halt-p* NIL)
)



;;; FORCED QUIESCENCE.


(defdsmmacro signal-forced-quiescence ()
                                      () true
 (declare)
 `(setf *forced-quiescence-p* T)
)


(defdsmmacro forced-quiescence-p ()
                                 () logical
 (declare)
 `*forced-quiescence-p*
)

  

(defdsmmacro clear-forced-quiescence ()
                                     () null
 (declare)
 `(setf *forced-quiescence-p* NIL)
)


                        

;;; STATISTICS INQUIRY.
            


(defdsmmacro cycle-count (cycle-name)
                         (symbol) fixnum                   
 (declare (symbol cycle-name))
 ;; return the starting count in case called in mid-cycle (tracing).
 `(cycle-start-count ,cycle-name)
)
 

                  

;;; EVENT TABLE UTILITIES.
;;;  Class always means event-class.

(defdsmmacro class-event (class)
                         (symbol) event-or-NIL                               
 (declare (symbol class))
 ;; get event record given event class.
 `(cond ((eq ,class 'preference-phase-start)
         (events-preference-phase-start *events*))
        ((eq ,class 'preference-phase-end)
         (events-preference-phase-end *events*))
        ((eq ,class 'working-memory-phase-start)
         (events-working-memory-phase-start *events*))
        ((eq ,class 'working-memory-phase-end)
         (events-working-memory-phase-end *events*))
        ((eq ,class 'quiescence-phase-start)
         (events-quiescence-phase-start *events*))
        ((eq ,class 'quiescence-phase-end)
         (events-quiescence-phase-end *events*))
        ((eq ,class 'firing)
         (events-firing *events*))
        ((eq ,class 'retraction)
         (events-retraction *events*))
        ((eq ,class 'goal-creation)
         (events-goal-creation *events*))
        ((eq ,class 'goal-removal)
         (events-goal-removal *events*))
        ((eq ,class 'context-installation)
         (events-context-installation *events*))
        ((eq ,class 'augmentation-addition)
         (events-augmentation-addition *events*))
        ((eq ,class 'augmentation-removal)
         (events-augmentation-removal *events*))
        ((eq ,class 'preference-wme-addition)
         (events-preference-wme-addition *events*))
        ((eq ,class 'preference-wme-removal)
         (events-preference-wme-removal *events*))
        ((eq ,class 'preference-addition)
         (events-preference-addition *events*))
        ((eq ,class 'preference-removal)
         (events-preference-removal *events*))
        ((eq ,class 'decision)
         (events-decision *events*))
        ((eq ,class 'production-start)
         (events-production-start *events*))
        ((eq ,class 'production-end)
         (events-production-end *events*))
        ((eq ,class 'run-cycle-start)
         (events-run-cycle-start *events*))
        ((eq ,class 'run-cycle-end)
         (events-run-cycle-end *events*))
        (T
         NIL))
)



(defdsmmacro class-count (class)
                         (symbol) fixnum
 (declare (symbol class))
 ;; get event count given event class.
 `(let ((event (class-event ,class)))
   (declare (type event-or-NIL event))
   (if event
       (event-count event)
       0))
)

                    
(defdsmmacro class-break-count (class)
                               (symbol) fixnum
 (declare (symbol class))
 ;; get event break-count given event class.
 `(let ((event (class-event ,class)))
   (declare (type event-or-NIL event))
   (if event
       (event-break-count event)
       0))
)

                    
(defdsmmacro class-break-criteria (class)
                                  (symbol) list                                       
 (declare (symbol class))
 ;; get event break criteria given event class.
 `(let ((event (class-event ,class)))
   (declare (type event-or-NIL event))
   (if event (event-break-criteria event)))
)




;;; MISCELLANEOUS UTILITIES.

                                    

(defdsmmacro io-input-cycle ()
                            () T
 (declare)
 `(cond ((not (io-trace-p))
         (let ((current-watch (watch-level)))
          (declare (number current-watch))
          (watch 0)
          (input-cycle)
          (external-working-memory-decision-phase)
          (watch current-watch)))
         (T 
          (input-cycle)
          (external-working-memory-decision-phase) ))
)
                                    

(defdsmmacro io-output-cycle ()         
                             () T
 (declare)
 `(cond ((not (io-trace-p))
         (let ((current-watch (watch-level)))
          (declare (number current-watch))
          (watch 0)
          (output-cycle)
          (external-working-memory-decision-phase)
          (watch current-watch)))
         (T 
          (output-cycle) ))
)
                         

                         
(defdsmmacro cycle-start (cycle-name)
                         (symbol) symbol                  
 (declare (symbol cycle-name))
 ;; converts a cycle name to a
 ;; cycle-start event class.
 `(case ,cycle-name
   (preference-phase
     'preference-phase-start)
   (working-memory-phase
     'working-memory-phase-start)
   (quiescence-phase
     'quiescence-phase-start)
   (production 
     'production-start)
   (run-cycle
     'run-cycle-start)
   (otherwise
     'quiescence-phase-start))
)


                         
(defdsmmacro cycle-end (cycle-name)
                       (symbol) symbol                  
 (declare (symbol cycle-name))
 ;; converts a cycle name to a
 ;; cycle-end event class.
 `(case ,cycle-name
   (preference-phase
     'preference-phase-end)
   (working-memory-phase
     'working-memory-phase-end)
   (quiescence-phase
     'quiescence-phase-end)
   (production 
     'production-end)
   (run-cycle
     'run-cycle-end)
   (otherwise
     'quiescence-phase-end))
)






;;; Concatenated from type module "mfirer" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mfirer/new/mfirer.lisp".
(in-package "SOAR")




;;; <FIRER.MACROS>


;;; FIRER MODULE: MACROS.
           
;;; MODULE DESCRIPTION.
;;;  Handles production firing and retraction, and chunk compilation.


;;; MODULE BACKGROUND. 

;;; Internal Chunks and Internal Instantiations.
                    
;;;    An internal instantiation is a chunk instantiation that supports the
;;;    subgoal results created by the instantiation from which it was built.
                 
;;;    An external instantiation is an ordinary instantiation.

;;;    An internal chunk is a chunk built only to support subgoal results -
;;;    it is not to be "learned." When the single internal instantiation of
;;;    an internal chunk is retracted, it is excised. An internal chunk
;;;    has no external instantiations.

;;;    Internal chunks that do not have a conjunctive negation in their LHS
;;;    are not variablized, so they can have only one instantiation
;;;    and will have no duplicates.

;;;    An external chunk is an ordinary chunk, which is "learned." External chunks
;;;    have internal as well as external instantiations. An external chunk will
;;;    have more than one internal instantiation if and only if duplicates for it
;;;    were built during the same elaboration cycle. Such a chunk will have one
;;;    instantiation for itself and one for each of its duplicates
;;;    (which were not compiled).
;;;    External chunks are not excised when their internal instantiations have
;;;    retracted.


;;; Matcher Representation of Productions and Production Instantiations.
;;;
;;;    A production's bindings and RHS template are in the topnode
;;;    field of the p record for the production.
;;;
;;;    The bindings are represented as a mapping between variable names
;;;    and the positions of their values in the LHS instantiation.
;;;    The bindings so represented are called the LHS bindings.
;;;
;;;    A production instantiation is represented as a production-name 
;;;    and an instantiated LHS.
;;;
;;;    To get the instantiated RHS, one must:
;;;     Look up the LHS bindings and RHS template using the production name.
;;;     Use the LHS bindings and the instantiated LHS
;;;     to restate the bindings as a mapping between
;;;     variable names and values.
;;;     Instantiate the RHS template using the (restated) bindings.
;;;    
;;;    So, when an instantiation arrives:
;;;     Its LHS bindings are looked up.
;;;     Its LHS bindings are restated.  
;;;     (These bindings, not the instantiated LHS, are used to
;;;     identify the instantiation.)        
;;;     The bindings are stored with the instantiated LHS
;;;     in an instantiation record.
;;;     The RHS template is not looked up and instantiated unless and until
;;;     the instantiation is to be fired.

#|
  


 Modules: Firer: Contents

          
 Introduction
      
 Data
   Records
     Instantiation
     P
     Chunk-Seed
     New-Chunk
   Globals    
     *fire-set*
     *firing-goal*
     *firing-p*
     *rhs*
     *retracted-while-firing*
     *retract-set*
     *autonomous-rules*
     *internal-chunk-compilation* 
     *external-chunk-compilation* 
     *new-chunk-log*
     *internal-chunks*
     *rules*   

 Functions
   Instantiation Traffic
   Instantiation Utilities
   Chunk Compilation
   Firing
   Firing Utilities
   Retracting
   Rules
   Rule Classification
   Production Utilities
   Instantiation Queue Utilities
   RHS Preference Utilities
   Miscellaneous Utilities



 Modules: Firer: Introduction


 The Firer does these things:

   Maintains the conflict set.
   Processes the conflict set during the preference phase.
   Saves production and object traces after each production firing.
   Activates chunking after each production firing.
   Directs the compilation of new chunks.
   Refracts new chunk instantiations.                              
   Classifies productions as operator-application, operator-creation, or 
   miscellaneous.
   Maintains production information.


 Principal Module Interactions:
   
   Receives new instantiations and retractions from the Matcher.
   Sends pmes to be added or retracted to the Trafficker during rule firing.
   Invokes the Actions module to save production and object traces.
   Invokes the Conditions module to backtrace and build chunks.



 Modules: Firer: Data: Records: Instantiation


   Instantiation Record (INSTANTIATION).

     Represents an instantiation that has not yet been retracted.

     Contains these fields:  

       Name. Production name.
       LHS. Instantiated LHS.
       Internal-p. T if instantiation is internal. The RHS of an internal
         instantiation need not be instantiated before firing.
       RHS. If the instantiation has already fired, this is the instantiated RHS,
         which is used in retraction; if the instantiation has not yet fired,
         NIL. 



 Modules: Firer: Data: Records: P


   Rule Record (P). 

     Represents a production.

     Contains these fields:

       Name. Production name.
       Production. I don't know what this is.
         Used by the matcher or the parser.
       Type. If the production is serial, value is 'serial.
         I don't know what other values this may assume.
       Topnode. Used to instantiate an RHS for firing.
         The application (var-part (p-topnode p)) yields the LHS bindings
         for the production.
         The application (rhs-part (p-topnode p)) yields the RHS template
         for the production.
       Negation-Index. Locates the negations in the LHS.
         Used when adding negated conditions to the LHS for chunking.
       Backpointers. Used by matcher. I think this is the representation of the
         production within the network. 
       Autonomic. T if the production is autonomous.
       Class. One of: operator-application, operator-creation, miscellaneous, or
         NIL (not yet classified).
       RHS-Class. One of: 'no-o-support, 'partial-o-support, or 'full-o-support.
         After a rule is classified, its RHS is classified. 
         Rules that are neither operator-applications nor operator-creations
         have rhs-class 'no-o-support.
         Operator-applications and operator-creations that create context
         preferences have rhs-class 'partial-o-support, because context
         preferences are never o-supported.
         Operator-applications and operator-creations that do not create context
         preferences have rhs-class 'full-o-support.
         The analysis of the rhs in the classification of a rule itself
         is not to be confused with the classification of its rhs.
         The rhs-class is used by the Conditions module to decide whether
         an internal chunk is necessary when learning is off.
       Declared. T if the production class was explicitly declared, rather than
         computed using the automatic classification criteria. 
         Explicitly declared productions are not reclassified when reloaded.
       Count. Number of times production has fired since the last init-soar
         invocation.
       Fireds. A list of the instantiations of this production that have not
         yet retracted. This represents a part of the retract set.     



 Modules: Firer: Data: Records: Chunk-Seed


   Chunk Seed Record (CHUNK-SEED).                                                 

     Represents a chunk seed, that is, the LHS tmes and the RHS pmes from which
     the chunk was built.                          
     Created by the chunker after a chunk has been built and before it is compiled.
     Used to identify those chunk instanitations arising during chunk compilation
     that are to be refracted.
     Kept in the New Chunk record.

     Contains these fields:

       LHS. The LHS tmes from which the chunk LHS was built.

       LHS-Depth. The depth of the instantiation owner in the goal stack.

       RHS. The RHS pmes from which the chunk RHS was built.

       Fired. T if an instantiation matching this seed has fired.
         Only one firing is allowed per chunk seed.




 Modules: Firer: Data: Records: New-Chunk


   New Chunk Record (NEW-CHUNK). 

     Represents a new chunk. 
     Created when the Chunk5 module creates a Chunk Seed record for a chunk for
     which there is no New Chunk record.
     Used to manage internal instanitations, specifically to detect
     those that are to be refracted, using the chunk seeds, and when internal
     chunks are to be excised, using the i-count.
     Accessed through the global *new-chunk-log*, which is a hash table
     mapping chunk name to New Chunk records.

     Contains these fields:

       Name. Production (chunk) name.  

       Seeds. List of chunk seed records.
         There will be more than one chunk seed if duplicates of the chunk
         were built during the same preference phase.

       I-Count. Number of internal instanitations of an internal chunk that
         were not refracted and have not yet retracted. An internal chunk is
         excised when all its instantiations have been retracted.
         This count is incremented each time an instantiation is created and
         not refracted during chunk compilation; it is decremented each time
         one of these instantiations retract; when it returns to 0, the chunk
         is excised.
         This field not used for external chunks.




 Modules: Firer: Data: Globals


   *fire-set*
     A list of instantiations to be fired.
     Discussed in Overview.  

   *firing-goal*           
     The instantiation owner of the instantiation currently firing or of the
     instantiation last fired.
     New objects created during RHS instantiation and negated object symbols
     created when negated clauses are added to the LHS before chunking are
     assigned *firing-goal* as owner.


   *firing-p*                         
     The Production record (P) for the production currently firing.
     Used during rule classification and chunking.

   *rhs*  
      The instantiated RHS for the production currently firing. 
      Instantiated pmes are pushed onto this global by the make-preference
      macro during the evaluation of the RHS template, which contains
      make-preference calls for all the make actions.

   *retracted-while-firing*
      T if the production currently firing is retracted before it has finished
      firing.
      If the retracted instantiation is not found in the fireds queue in the 
      Rule record for the production, then this global is set, and, after firing,
      the fired instantiation is moved directly to the retract set,
      rather than to the fireds queue to await retraction.

   *retract-set*
      A list of instantiations to be retracted.
      Discussed in Overview. 

   *autonomous-rules*
      A list of the names of autonomous productions. Kept to avoid having to
      look up the Rule record for each incoming instantiation to see whether it is
      autonomous. 
      But now autonomy is not consulted; this global should be removed if this
      change is declared permanent.

   *internal-chunk-compilation*
      Chunk name if the chunk being compiled is internal.
      This will determine the refraction criterion used when instantiations
      arrive during chunk compilation.

   *external-chunk-compilation*
      Chunk name if the chunk being compiled is external.
      This will determine the refraction criterion used when instantiations
      arrive during chunk compilation.

   *new-chunk-log*
      Hash table mapping chunk names to New Chunk records.
      New Chunk records are added when new chunks are built.
      (Duplicate chunks cause the addition of a Chunk Seed record to
      the list of seeds in the New Chunk record.)    
      New Chunk records for external chunks are removed after chunk compilation.
      New Chunk records for internal chunks are removed when all its
      internal instantiations have been retracted.

   *internal-chunks*
      A list of internal chunks not yet excised.
      These chunks also appear in *chunks*.

   *rules*                  
      Represents Rule Table.
      Hash table mapping production name to Production record.
      Discussed in Overview.



|#



;;; MODULE RECORDS.
                        
;;; The LHS is needed to identify operator applications and to match
;;; incoming retractions against the fired instantiations.
;;; The RHS is needed to retract the actions.
;;; The RHS cannot be reinstantiated because of gensyms and RHS function calls.
;;; The RHS is not computed unless and until the instantiation
;;; is to be fired.                                                             

;;; Internal instantiations are chunk instantiations that support subgoal results.
;;; The user is not to know of them. 
;;; They do not have bindings because the RHS actions are the wmes from which
;;; the chunk was built.
;;; Timetag was added to instantiation to ensure that when an instantiation retracted
;;;   it would only retract information associated with it. This is done by including
;;;   on the pnode the timetag of the instantiation that created it. Then before the
;;;   support is removed in retracting the instantiation's timetag is checked against
;;;   the pnode timetag. If the pnode timetag indicates a later time then the pme 
;;;   retraction is discarded.
;;; Bug #18Apr90-15.56.10  20-Apr-90 GAP
(defstruct (instantiation
            (:constructor make-instantiation (name lhs internal-p rhs timetag)))
           "Represents an instantiated production. Attached to a rule queue."
           (name       NIL :type symbol)           ;rule name.               
           (lhs        NIL :type list)             ;instantiated LHS.
           (internal-p NIL :type logical)          ;supports subgoal results.
           ;; rhs supplied at creation only for internal instantiations.
           (rhs        NIL :type list)             ;instantiated RHS.
           (support-list '() :type list)           ;support list for this instantiation
           (timetag    0   :type integer)          ;timetag of instantiation
)

;; Moved to firer and integrated old rule record with this. -KAM 8/23/89
;; Added this defstruct and its print function to ptorete. -BGM 11/8/88
;; Removed references to production type 3/30/90 GAP
;; These patches are in reference to BUG 01Mar90-12.56.58

(defstruct (p (:constructor make-p (name production topnode negation-index 
                                    backpointers autonomic <>-tests))
              (:print-function print-p))
            "Represents a production. Attached to rule table."
            (name               NIL :type symbol)
            production
            topnode
            negation-index
            backpointers
            autonomic
            <>-tests ;; Added for not-ify. -BGM 29-Nov-90
            ;;
            ;; class is one of the following and is formed by textually checking production
            ;;   operator-creation - One goal whose state is checked and operator is added.
            ;;   operator-application - One goal whose state & operator is checked and state is modified
            ;;   possible-operator-creation - One goal whose state is checked.
            ;;   possible-operator-application - One goal whose state & operator is checked.
            ;;   ambiguous - More than one goal checked
            ;;   Not-operator - None of the above.
            ;;
            (class              NIL :type list)
            ;;
            ;; The next 3 items are used to calculate support at run time. 
            ;;   footprint-graph A graph of footprint-elements that can be searched to find
            ;;                the transitive closure within the footprint.
            ;;   ID-mapping,Value-mappint   A list of pointers into footprint-TC so that the 
            ;;                identifiers in an instantiation can be mapped to the variables in
            ;;                the footprint in linear time.
            ;;   support-list The list of O-support that can be inferred at production compile time.
            ;;
            (footprint-graph    NIL :type list)
            (ID-mapping         NIL :type list)
            (Value-mapping      NIL :type list)
            (support-list       NIL :type list)    ;list of O-Support for RHS-Actions

            (declared           NIL :type logical) ;T if rule class declared.
            (count              0   :type fixnum)  ;firing count.
            (fireds             NIL :type list)    ;fired unretracted instantiations.
)

(defstruct (p-footprint-node 
 ;; Fixed name to be tme-value to handle non-symbol cases 7/20/90 GAP
               (:constructor make-p-footprint-node (name next)))

                 "Production Footprint Node. Part of footprint graph."

                 (name              NIL :type tme-value)
                 (next              NIL :type list)  ;next node in graph

                 (outnodes          NIL :type list)  ;referenced onodes
                 (marker            NIL :type logical) ;marker to make transitive closures O(n)
 
                 (TC                NIL :type list)  ;Transitive closure within footprint
)      

(defun print-p (p stream depth)
  (declare (ignore depth))
  (soar-format stream "#<Production ~A>" (p-name p))
  (soar-format stream "   Nots - ~A" (p-<>-tests p))
)


(defstruct (new-chunk (:constructor make-new-chunk (name)))
           "New chunk data. Used during chunk compilation and retraction."
           (name NIL :type symbol)
           ;; list of chunk seed records.
           (seeds NIL :type list)
           ;; number of internal instantiations of internal chunk not refracted.
           ;; internal chunk is excised when all its instantiations have
           ;; been retracted.
           ;; not used for external chunks.
           (i-count 0 :type integer)
)

(defstruct (chunk-seed (:constructor make-chunk-seed 
                                     (lhs lhs-depth rhs)))
           "LHS and RHS wmes on which a newly built chunk was based."
           ;; used to identify internal and refractory instantiations
           ;; during chunk compilation.
           ;; chunked lhs wmes, excluding negations.          
           (lhs  NIL :type list)                 
           ;; lhs depth. deepest birth-goal over all objects in lhs.
           (lhs-depth  0 :type integer)
           ;; chunked rhs wmes.
           (rhs  NIL :type list)       
           ;; T if an instantiation matching this seed has fired.
           (fired NIL :type logical)
)



;;; MODULE TYPE DECLARATIONS.
                                            
(deftype p-or-NIL () '(or null p))
(deftype instantiation-or-NIL () '(or null instantiation))


;;; MODULE GLOBALS.


(defvar *WM-TC-starting-points*
        NIL
        "List of WM Transitive Closure starting point onodes")

(defvar *footprint-hash-table* (make-hash-table :test #'eq
                                                :size 200 
                                                :rehash-size 200 
                                                :rehash-threshold 0.8)
        "hash table for speeding up the footprint calculations")


;;; INSTANTIATION QUEUES.
;;;  The queues are lists of instantiation records.

(defvar *fire-set*
        NIL
        "Instantiations waiting to fire.")

(defvar *firing-goal*
        NIL
        "Goal for which current rule is firing.")

(defvar *firing-p*
        NIL
        "P(roduction) record for instantiation currently being fired.")

(defvar *rhs*
        NIL
        "Instantiated RHS of instantiation currently being fired.")

(defvar *retracted-while-firing*                                                    
        NIL
        "T if the instantiation being fired has been retracted since firing began.")

(defvar *retract-set*
        NIL
        "Retracted instantiations.")

;;; Can look in the rule record to see if rule is autonomous, but there
;;; are usually no autonomous rules, so better to avoid looking up each
;;; rule in *fire-set*.
(defvar *autonomous-rules*
        NIL
        "List of autonomous productions.")                        


;;; CHUNKING GLOBALS.
;;;  Used in communications between firer and chunker during chunk building and 
;;;  compilation: to detect internal chunks and internal instantiations of
;;;  external chunks.

(defvar *internal-chunk-compilation* 
        NIL
        "Name of internal chunk currently being compiled or NIL.")

(defvar *external-chunk-compilation*
        NIL
        "Name of external chunk currently being compiled or NIL.")

   
;; Maps from chunk name to a list of new-chunk records.
;; Used during chunk compilation.
(defvar *new-chunk-log*
        (make-hash-table :test #'eq
                         :size 101
                         :rehash-size 1.5
                         :rehash-threshold .5)
        "Data for newly-built chunks. Hash table. Key is chunk name.")

(defvar *internal-chunks*
        NIL
        "No learn only. Chunks supporting subgoal results. To be excised upon retraction.")
                                                                


;;; RULE GLOBALS.

(defvar *rules*
        (make-hash-table :test #'eq
                         :size 211
                         :rehash-size 1.5
                         :rehash-threshold .5)
        "Rule table. Key is rule-name. Value is p(roduction) record.")

(eval-when (compile eval load) (proclaim '(special *variable-memory*)))

    
;;; MODULE MACROS.
           
;;;  Working Memory Transitive Closure utilities


(defmacro WM-TC-member-p (object)
 ;; Fixed Bug so non-objects are correctly ignored
 ;; Bug #02Jan91-19.22.42 GAP 1/8/91
 (declare (type symbol object))
 `(if (object-p ,object)
    (let ((onode (object-onode ,object)))
         (if onode (onode-marker onode)))))

(defmacro remove-WM-TC-marks ()
  `(list (Unmark-WM-descendants *WM-TC-starting-points*)
         (setq *WM-TC-starting-points* NIL)))

;;; FOOTPRINT UTILITIES


(defmacro find-footprint-node-hash (footprint-graph name)
 ;; This either finds a footprint node corresponding to "name"
 ;; or returns NIL
 
 (declare (ignore footprint-graph)
          ( symbol         name))
 `(gethash ,name *footprint-hash-table*))

(defmacro get-footprint-node-hash (footprint-graph name)
 ;; This either finds a footprint node corresponding to "name"
 ;; or creates one. It assumes that it is only being called within classify-production and
 ;; thus uses the hash table to speed up the searches rather than the more general
 ;; find-footprint-node. The hash table is only useful for the analysis done by
 ;; classify production so it is thrown away afterwards.

  (declare (type p-footprint-node footprint-graph)
           (type symbol         name))
 `(cond ((find-footprint-node-hash ,footprint-graph ,name))
        (T (setq ,footprint-graph (make-p-footprint-node ,name ,footprint-graph))
           (setf (gethash ,name *footprint-hash-table*) ,footprint-graph))))


;;; INSTANTIATION UTILITIES.

  
(defdsmmacro lhs= (lhs1 lhs2)
                  (list list) logical
 (declare (list lhs1 lhs2))
 ;; used to use tree-equal for this.
 `(do ((wmes1 ,lhs1 (rest wmes1))
       (wmes2 ,lhs2 (rest wmes2)))
       ((or (null wmes1) 
            (null wmes2)
            (not (eq (first wmes1) (first wmes2))))
        (cond ((and (null wmes1) (null wmes2))
               T)
              (T
               NIL)))
   (declare (list wmes1 wmes2))) 
)

  

(defdsmmacro lhs-subset-p (lhs1 lhs2)
                          (list list) logical
 (declare (list lhs1 lhs2))
 ;; T if lhs1 is a subset of lhs2.
 `(subsetp ,lhs1 ,lhs2 :test #'eq)
)

(eval-when (compile eval load) (proclaim '(ftype (function (list list) logical) lhs-wme=)))
(defun lhs-wme= (wme1 wme2)
 (declare (type tme wme1 wme2))
 (and 
  (eq (wme-class wme1) (wme-class wme2))
  (eq (wme-object wme1) (wme-object wme2))
  (tme-attribute= (wme-attribute wme1) (wme-attribute wme2))
  (tme-value= (wme-value wme1) (wme-value wme2))       
  ;; type is either NIL (augmentation) or + (context accept).
  (eq (wme-type wme1) (wme-type wme2)))
)



;;; CHUNK COMPILATION.
          

(defdsmmacro wme-negation-p (item)
                            (T) logical
 (declare (type (or symbol tme) item))
 `(cond ((and (atom ,item) 
              (member ,item '(- *) :test #'eq))
         T)
        (T
         NIL))
)



(defdsmmacro remove-lhs-negations (lhs)                           
                                  (list) list
 (declare (list lhs))

 ;; used by internal-instantiation-p.  
 ;; returns lhs with negations omitted and in reverse order.

 `(let ((unnegated-wmes NIL))
   (do ((wmes ,lhs))
       ((null wmes) unnegated-wmes)
    (declare (list wmes))
    (cond ((wme-negation-p (first wmes))
           ;; skip negated wme.
           (setf wmes (rest (rest wmes))))
          (T
           (push (first wmes) unnegated-wmes)
           (setf wmes (rest wmes)) )) )
))    

                                 
(defdsmmacro conjure-new-chunk (chunk-name)
                               (symbol) new-chunk
 (declare (symbol chunk-name))
 `(let ((new-chunk (gethash ,chunk-name *new-chunk-log*)))
   (declare (type (or null new-chunk) new-chunk))
   (cond (new-chunk
          new-chunk)
         (T
          (setf (gethash ,chunk-name *new-chunk-log*)
                (make-new-chunk ,chunk-name)) ))
)) 
 

(defdsmmacro get-new-chunk (chunk-name)
                           (symbol) new-chunk
 (declare (symbol chunk-name))
 `(gethash ,chunk-name *new-chunk-log*)
)


(defdsmmacro drop-new-chunk (chunk-name)
                            (symbol) logical
 (declare (symbol chunk-name))
 `(remhash ,chunk-name *new-chunk-log*)
)    



(defdsmmacro put-chunk-seed (chunk-name lhs rhs)
                            (symbol list list) list
 (declare (symbol chunk-name)
          (list lhs rhs))
 `(let ((new-chunk (conjure-new-chunk ,chunk-name)))
   (declare (type new-chunk new-chunk))
   (push (make-chunk-seed (remove-lhs-negations ,lhs)
                          (lhs-depth-and-goal ,lhs)
                          ,rhs)
         (new-chunk-seeds new-chunk))
))                         
  


(defdsmmacro get-chunk-seeds (chunk-name)
                             (symbol) list
 (declare (symbol chunk-name))
 ;; returns a list of chunk-seed records.
 `(new-chunk-seeds (get-new-chunk ,chunk-name))
)
 

(defdsmmacro log-internal-chunk (rule-name)
                                (symbol) list
 (declare (symbol rule-name))            
 ;; used by post-process-results to log the chunk just built as internal.
 `(push ,rule-name *internal-chunks*)
)

                                           
(defdsmmacro internal-chunk-p (rule-name)            
                              (symbol) logical  
 (declare (symbol rule-name))
 `(member ,rule-name *internal-chunks* :test #'eq)
)



(defdsmmacro log-internal-chunk-instantiation (chunk-name)
                                              (symbol) integer
 (declare (symbol chunk-name))
 ;; i-count is decremented by excise-internal-chunk-p.
 `(incf (new-chunk-i-count (get-new-chunk ,chunk-name)))
)



(defdsmmacro excise-internal-chunk-p (chunk-name)            
                                     (symbol) logical
 (declare (symbol chunk-name))
 ;; called by instantiation-retraction when an instantiation of the
 ;; (internal) chunk is retracted.
 ;; chunk is to be excised when all its instantiations have been retracted.
 ;; i-count is incremented by log-internal-chunk-instantiation.
 `(let ((new-chunk (get-new-chunk ,chunk-name)))
   (declare (type new-chunk new-chunk))
   (cond ((= (decf (new-chunk-i-count new-chunk)) 0)
          T)
         (T
          NIL)) 
)) 


(defdsmmacro excise-internal-chunk (chunk-name)
                                   (symbol) list     
 (declare (symbol chunk-name))
 `(let ()
   (excise-p ,chunk-name T)      ;T signals that chunk is internal.
   (drop-new-chunk ,chunk-name)
   (setf *internal-chunks*
         (delete ,chunk-name *internal-chunks* :test #'eq :count 1)) )
) 
   


;;; INSTANTIATION AND FIRING.

(defmacro make-preference
          (class object attribute value type &optional (reference NIL reference-p))
 (declare (type tme-class class)
          (type tme-object object)
          (type tme-attribute attribute)
          (type tme-value value reference)
          (type tme-type type)) 
 ;; used during firing.
 ;; must distinguish NIL reference from no reference.
 `(push
    (if ,reference-p
        (instantiate-binary-preference ',class
                                       ',object
                                       ',attribute
                                       ',value
                                       ',type
                                       ',reference)
        (instantiate-unary-preference ',class
                                      ',object
                                      ',attribute
                                      ',value
                                      ',type))
        *rhs*)
)

(defdsmmacro make-variable-binding (variable value) 
                                   (symbol atom) list
 (declare (symbol variable)
          (atom value))
 `(push (cons ,variable ,value) *variable-memory*)
)

(defdsmmacro variable-dot-value (variable)                   
                                (symbol) cons
 (declare (symbol variable))
 ;; *variable-memory* is a list of dotted pairs.
 ;; returns (variable . value).
 ;; must return pair so can distinguish no value from NIL value.
 `(assoc ,variable *variable-memory* :test #'eq)
)                       

(defdsmmacro variable-prefix (variable)
                             (symbol) character
 (declare (symbol variable))
 `(schar (symbol-name ,variable) 1)
)



;;; FIRING UTILITIES.

                         
    
;;; RULES.
                     

(defdsmmacro get-p (name)       
                   (symbol) p-or-NIL
 (declare (symbol name))
 `(gethash ,name *rules*)
)


(defdsmmacro drop-p (name)       
                    (symbol) p-or-NIL
 (declare (symbol name))
 `(let ()
   (remhash ,name *rules*)
   (setf *autonomous-rules* (delete ,name *autonomous-rules* :test #'eq)))
)



(defdsmmacro get-rule-class (name)     
                            (symbol) symbol 
 (declare (symbol name))
 `(let ((p (get-p ,name)))
   (declare (type p-or-NIL p))
   (cond (p
          (p-class p))
         (T
          NIL)) )
)


(defdsmmacro get-rule-count (name)
                            (symbol) fixnum                         
 (declare (symbol name))
 `(let ((p (get-p ,name)))
   (declare (type p-or-NIL p))
   (cond (p
          (p-count p))
         (T
          0)) )
)

    

(defdsmmacro o-support-rule-class-p (rule-class)
                                    (symbol) logical
 (declare (symbol rule-class))
 `(logicize (member ,rule-class '(operator-creation operator-application) :test #'eq))
)




(defdsmmacro get-support-list (p-name)
                              (symbol) list
 ;; changed rhs-class to support-list
 ;; Partially done for Bug#26Feb90-14.11.46 & 19Apr90-21.34.59 19/May/90 GAP
 (declare (symbol p-name))
 `(let ((p (get-p ,p-name)))
   (declare (type p-or-NIL p))
   (if p (p-support-list p)))
)


;;; UTILITIES.
     

;;; PRODUCTION UTILITIES.
;;; The matcher represents a production by properties
;;; of its name symbol.
                          
(defmacro rule-topnode (rule-name)                
 (declare (symbol rule-name))
 ;; get rule topnode given rule name.
 `(p-topnode (get-p ,rule-name))
)
       

(defmacro autonomous-p (rule-name)
 (declare (symbol rule-name))
 `(p-autonomic (get-p ,rule-name))
)

                             
(defdsmmacro soar-rule-p (rule-name)
                         (symbol) logical
 (declare (symbol rule-name)
          (special *pnames*))
 `(logicize (member ,rule-name *pnames* :test #'eq))
)

                             
(defdsmmacro task-rule-p (rule-name)
                         (symbol) logical
 (declare (symbol rule-name)
          (special *user-pnames*))
 `(logicize (member ,rule-name *user-pnames* :test #'eq))
)

                             
(defdsmmacro default-rule-p (rule-name)
                            (symbol) logical
 (declare (symbol rule-name))
 `(and (soar-rule-p ,rule-name) (not (task-rule-p ,rule-name)))
)        
  

(defdsmmacro chunk-p (rule-name)
                     (symbol) logical 
 (declare (symbol rule-name)
          (special *chunks*))
 `(logicize (member ,rule-name *chunks* :test #'eq))
)       


 
(defdsmmacro lhs-bindings (p)
                          (p) list
 (declare (type p p))        
 ;; var-part is a matcher function.
 `(var-part (p-topnode ,p))  
)                                     

                           
(defdsmmacro rhs-template (p)
                          (p) list                
 (declare (type p p))
 ;; rhs-part is a matcher function.
 `(rhs-part (p-topnode ,p))  
) 
                 


;;; LHS BINDINGS UTILITIES.
;;; An LHS binding is a matcher data object attached to a pnode,
;;; representing a production's LHS.


#+(or)
(defdsmmacro binding= (binding1 binding2)
                      (cons cons) logical
  (declare (cons binding1 binding2))
  `(and (eq (first ,binding1) (first ,binding2))
        (eq (rest ,binding1) (rest ,binding2)))
)


#+(or)
(defmacro bindings= (lhs-bindings1 lhs-bindings2)
                    (list list) logical
 (declare (list lhs-bindings1 lhs-bindings2))
 `(do ((bindings1 ,lhs-bindings1 (rest bindings1))
       (bindings2 ,lhs-bindings2 (rest bindings2)))
       ((or (null bindings1) 
            (null bindings2)
            (not (binding= (first bindings1) (first bindings2))))
        (cond ((and (null bindings1) (null bindings2))
               T)
              (T
               NIL)))
   (declare (list bindings1 bindings2)))
) 



;;; INSTANTIATION QUEUE UTILITIES.


                                
(defdsmmacro instantiation= (rule-name lhs instantiation)
                            (symbol list instantiation) logical
 (declare (symbol rule-name)
          (list lhs)
          (type instantiation instantiation))
   `(and (eq ,rule-name (instantiation-name ,instantiation))
         (lhs= (instantiation-lhs ,instantiation) ,lhs))
)


(defdsmmacro find-unfired-instantiation (rule-name lhs)
                                        (symbol list) instantiation-or-NIL
 (declare (symbol rule-name)
          (list lhs))
 ;; for debugging only.
 `(find-if
   #'(lambda (instantiation)
    (instantiation= ,rule-name ,lhs instantiation))
   *fire-set*)
)



(defdsmmacro dequeue-unfired-instantiation (rule-name lhs)
                                           (symbol list) list
 (declare (symbol rule-name)
          (list lhs)) 
 ;; returns updated queue.
 `(setf *fire-set*
        (delete-if
          #'(lambda (instantiation)
             (instantiation= ,rule-name ,lhs instantiation))
          *fire-set*
          :count 1))
)



(defdsmmacro dequeue-unfired-instantiations (rule-name)
                                            (symbol) list
 (declare (symbol rule-name))
 `(setf *fire-set*
        (delete-if
          #'(lambda (instantiation)
             (eq ,rule-name (instantiation-name instantiation)))
          *fire-set*))
)



(defdsmmacro find-fired-instantiation (rule-name lhs)
                                      (symbol list) instantiation-or-NIL
 (declare (symbol rule-name)
          (list lhs))
 ;; for debugging only.
 ;; assumes rule record exists.
 `(let ((p (get-p ,rule-name)))
   (declare (type p p))
   (if p
      (find-if
        #'(lambda (instantiation) 
             (lhs= (instantiation-lhs instantiation) ,lhs))
        (p-fireds p))))
) 



(defdsmmacro dequeue-fired-instantiation (rule-name lhs)
                                         (symbol list) instantiation-or-NIL
 (declare (symbol rule-name)
          (list lhs))
 ;; returns dequeued instantiation. 
 ;; assumes rule record exists.
 `(let* ((p (get-p ,rule-name))
         (instantiation (if p
                            (find-if
                              #'(lambda (instantiation) 
                                  (lhs= (instantiation-lhs instantiation) ,lhs))
                              (p-fireds p)))))
   (declare (type p p)
            (type instantiation-or-NIL instantiation))
   (if instantiation
       (setf (p-fireds p)
             (delete instantiation (p-fireds p) :test #'eq :count 1)))
   instantiation)
) 



(defdsmmacro dequeue-fired-instantiations (rule-name)
                                          (symbol) null
 (declare (symbol rule-name))
 ;; for debugging only.
 ;; assumes rule record exists.
 `(setf (p-fireds (get-p ,rule-name)) NIL)
) 



(defdsmmacro find-retracted-instantiation (rule-name lhs)
                                          (symbol list) instantiation-or-NIL
 (declare (symbol rule-name)
          (list lhs))
 ;; for debugging only.
 `(find-if
   #'(lambda (instantiation)
    (instantiation= ,rule-name ,lhs instantiation))
   *retract-set*)
)



(defdsmmacro dequeue-retracted-instantiation (rule-name lhs)
                                             (symbol list) list
 (declare (symbol rule-name)
          (list lhs)) 
 ;; for debugging only.
 ;; returns updated queue.
 `(setf *retract-set*
        (delete-if
          #'(lambda (instantiation)
             (instantiation= ,rule-name ,lhs instantiation))
          *retract-set*
          :count 1))
)



(defdsmmacro dequeue-retracted-instantiations (rule-name)
                                              (symbol) list
 (declare (symbol rule-name))
 ;; for debugging only.
 `(setf *retract-set*
        (delete-if
          #'(lambda (instantiation)
             (eq ,rule-name (instantiation-name instantiation)))
          *retract-set*))
)


(defdsmmacro firing-p ()
                      () p-or-NIL
 (declare)
 `*firing-p*
)


             
;;; RHS PREFERENCE UTILITIES.       

(defmacro preference-internal-type (external-type &optional reference) 
 (declare (type tme-class external-type)
          (type tme-value reference))
  `(cond  ((null ,external-type)
           'accept)
          ((eq ,external-type '+)
           'accept)
          ((eq , external-type '-)
           'reject)
          ((eq ,external-type '@)
           'reconsider)
          ((eq ,external-type '>)
           (cond (,reference
                  'better)
                 (T
                  'best)))
          ((eq ,external-type '<)
           (cond (,reference
                  'worse)
                 (T
                  'worst)))
          ((eq ,external-type '=)
           (cond (,reference
                  'indifferent-to)
                 (T
                  'indifferent)))
          ((eq ,external-type '&)
           (cond (,reference
                  'parallel-to)
                 (T
                  'parallel)))
          ((eq ,external-type '!)
           'require)
          ((eq ,external-type '~)
           'prohibit)
          (T
           ;; assume already is internal type.
           ,external-type))
)



(defdsmmacro preference-external-type (internal-type)               
                                      (tme-type) symbol
 (declare (type tme-type internal-type))
  `(cond ((eq ,internal-type 'accept)
          '+)
         ((eq ,internal-type 'oa-reject)
          '-)
         ((eq ,internal-type 'reject)
          '-)
         ((eq ,internal-type 'reconsider)
          '@)
         ((eq ,internal-type 'better)
          '>)
         ((eq ,internal-type 'best)
          '>)
         ((eq ,internal-type 'worse)
          '<)
         ((eq ,internal-type 'worst)
          '<)
         ((eq ,internal-type 'indifferent-to)
          '=)
         ((eq ,internal-type 'indifferent)
          '=)
         ((eq ,internal-type 'parallel-to)
          '&)
         ((eq ,internal-type 'parallel)
          '&)
         ((eq ,internal-type 'require)
          '!)
         ((eq ,internal-type 'prohibit)
          '~)
         (T
          ;; assume already is external type.
          ,internal-type))
)




;;; Concatenated from type module "mtrafficker" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mtrafficker/new/mtrafficker.lisp".
(in-package "SOAR")




;;; <TRAFFICKER.MACROS>



;;; TRAFFICKER MODULE: MACROS.

;;; MODULE DESCRIPTION.
;;;   Handles and monitors the traffic between the Matcher and 
;;;   the DSM modules and between external sources and DSM.
;;;   Handles both ames and pmes.
;;;   Preferences do not really come directly from the Matcher
;;;   but first pass through the Firer module.


#|


 Modules: Trafficker: Contents

          
 Introduction

 Data
   Globals
     *last-timetag*

 Functions
   Internal Working Memory Traffic
   External Working Memory Traffic
   Working Memory Traffic Utilities

   Preference Traffic
     
   Timetags

   Support Utilities

   Utilities 
       


 Modules: Trafficker: Introduction


 The Trafficker mediates the relationship between architecture memory and
 working memory, that is, between the Matcher and the Context and Subtext
 modules, and between Soar/IO and the Context and Subtext modules.

 The Trafficker receives incoming preferences additions and retractions from the
 Firer and routes them to Context or Subtext.

 The Trafficker routes Soar/IO traffic to Context or Subtext.
     
 The Trafficker routes working memory additions and removals from Context and
 Subtext to the Matcher. It also updates the wmpart* property of objects
 that have been changed.
 


 Modules: Trafficker: Data: Globals


   *last-timetag*
      Last timetag assigned. Consulted and incremented each time an ame or a pme
      is created (including those pmes that are not added to working memory).
                                                                              

|#
                                 

;;; MODULE GLOBALS.

(defvar *last-timetag*
        0
        "Last timetag generated.")


;;; MODULE MACROS.

                                    
;;; WORKING MEMORY TRAFFIC UTILITIES.
                    

(defdsmmacro make-ame (class object attribute process)
                      (tme-class tme-object tme-attribute tme-value) tme
 (declare (type tme-class class)
          (type tme-object object)
          (type tme-attribute attribute)
          (type tme-value process))
 ;; the last NIL is so that augmentation wmes have the same length as
 ;; acceptable preference wmes.
 `(list ,class ,object ,attribute ,process NIL)
)


                                   
(defmacro make-pme (class object attribute process type
                                       &optional (reference NIL reference-p))
 (declare (type tme-class class)
          (type tme-object object)
          (type tme-attribute attribute)
          (type tme-value process reference)
          (type tme-type type))
 ;; must distinguish NIL reference from no reference.
 `(cond (,reference-p
         (list ,class ,object ,attribute ,process ,type ,reference) )
        (T  
         (list ,class ,object ,attribute ,process ,type) ))
)


                                   
(defmacro make-unary-pme (class object attribute process type)
 (declare (type tme-class class)
          (type tme-object object)
          (type tme-attribute attribute)
          (type tme-value process)
          (type tme-type type))
 `(list ,class ,object ,attribute ,process ,type)
)


                                   
(defmacro make-binary-pme (class object attribute process type reference)
 (declare (type tme-class class)
          (type tme-object object)
          (type tme-attribute attribute)
          (type tme-value process reference)
          (type tme-type type))
 `(list ,class ,object ,attribute ,process ,type ,reference)
)



(defdsmmacro protected-slot-p (object attribute)            
                              (tme-object tme-attribute) logical
 (declare (type tme-object object)
          (type tme-attribute attribute))
 `(logicize 
   (or
    (and (goal-p ,object)
         (protected-goal-slot-p ,attribute))
    (and (impasse-p ,object)               
         (protected-impasse-slot-p ,attribute))))
)

             

(eval-when (compile eval load) (proclaim '(special *trace-file*)))
(defdsmmacro legal-augmentation-p (tme)
                                  (tme) logical
 (declare (type tme tme))
 `(let ((object (tme-object ,tme))
        (attribute (tme-attribute ,tme))
        (value (tme-value ,tme)))
   (declare (type tme-object object)
            (type tme-attribute attribute)
            (type tme-value value))
   (cond
    ;; check for illegality.
    ((goal-p value)
     (soar-format *trace-file*
                  "~%WARNING: Augmentations cannot point to goals. ~
                   ~%         Ignoring augmentation ~A."
                  (print-wme NIL ,tme))
     NIL)
    ((impasse-p value)
     (soar-format *trace-file*
                  "~%WARNING: Augmentations cannot point to impasses. ~
                   ~%         Ignoring augmentation ~A."
                  (print-wme NIL ,tme))
     NIL)
    ((and (goal-p object) (protected-goal-slot-p attribute))
     (soar-format *trace-file*
                  "~%WARNING: Cannot change architecture-created goal augmentation. ~
                   ~%         Ignoring augmentation ~A."
                  (print-wme NIL ,tme))
     NIL)
    ((and (impasse-p object) (protected-impasse-slot-p attribute))
     (soar-format *trace-file*
                  "~%WARNING: Cannot change architecture-created impasse augmentation. ~
                   ~%       Ignoring augmentation ~A."
                  (print-wme NIL ,tme))
     NIL)
    (T            
     ;; legal augmentation.
     T)) )
)



;;; INTERNAL WORKING MEMORY TRAFFIC.


(defdsmmacro add-ame (tme timetag)
                     (tme timetag) T
 (declare (type tme tme)
          (type timetag timetag))
 `(let ()
   (add-to-wm ,tme ,timetag)
   (signal-augmentation-addition ,tme ,timetag))
)
                                                            


(defdsmmacro remove-ame (tme timetag)
                        (tme timetag) T
 (declare (type tme tme)
          (type timetag timetag)) 
 `(let ()
   (signal-augmentation-removal ,tme ,timetag)
   (remove-from-wm ,tme ,timetag))
)       



;;; EXTERNAL WORKING MEMORY TRAFFIC.

                                    
(defdsmmacro add-io-ame (tme)
                        (tme) T
 (declare (type tme tme))
 ;; add io augmentation to working memory.
 ;; add an acceptable and parallel preference for tme. tme itself is discarded. 
 ;; changes will be effected next time external-working-memory-decision-phase
 ;; is called by io-input-cycle or io-output-cycle.
 `(cond ((legal-augmentation-p ,tme)
          (subtext-add-preference (make-accept-pme-for-ame ,tme) NIL (make-timetag))
          (subtext-add-preference (make-parallel-pme-for-ame ,tme) NIL (make-timetag))))
)

                         
(defdsmmacro remove-io-ame (tme)
                           (tme) T
 (declare (type tme tme))
 ;; remove io augmentation from working memory.
 ;; retract acceptable and parallel preference for tme.
 ;; changes will be effected next time external-working-memory-decision-phase
 ;; is called by io-input-cycle or io-output-cycle.
 ;; maybe should check for legality here as in add-io-ame.
 `(let ()
   (subtext-retract-preference (make-accept-pme-for-ame ,tme) (make-timetag))
   (subtext-retract-preference (make-parallel-pme-for-ame ,tme) (make-timetag)) )
)



;;; PREFERENCE TRAFFIC.
        
;;; TIMETAGS.

(defdsmmacro make-timetag ()
                          () fixnum
 (declare)
 `(incf *last-timetag*)
)



;;; SUPPORT UTILITIES.

             
#+(or)  ;thought to be no longer needed.
(defdsmmacro io-link-p (object attribute subobject)            
                       (tme-object tme-attribute tme-object) logical
 (declare (type tme-object object subobject)
          (type tme-attribute attribute)
          (ignore subobject))
  `(logicize
    (and (eq ,object (top-state))
         (or (eq ,attribute 'text-input)
             (eq ,attribute 'text-output)
             (member ,attribute *input-link-attributes* :test #'eq)
             (member ,attribute *output-link-attributes* :test #'eq))))
)


                             
(defdsmmacro support-rule-p (rule-class)                           
                            (symbol) logical
 (declare (symbol rule-class))
 `(cond ((member ,rule-class '(operator-application operator-creation) :test #'eq)
         T)
        (T
         NIL))
)     






;;; Concatenated from type module "mconflux" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mconflux/new/mconflux.lisp".
(in-package "SOAR")




;;; <CONFLUX.MACROS>

               

;;; CONTEXT FLUX MODULE: MACROS.                    
     

;;; MODULE DESCRIPTION.
;;;   Keeps the rules for making context slot transitions.

                     
;;; MODULE BACKGROUND.                 

;;; The STATES are:
;;;   winner
;;;   rejection (no values proposed for slot)
;;;     only a "to" state
;;;   constraint-failure 
;;;   conflict
;;;   tie
;;;   no-change
;;;   NIL (new slot)
;;;     only a "from" state
;;;                     
;;;  Note the relationship between the NIL and REJECT states.
;;;   NIL is only a "from" state. It is for slots about to be added.
;;;   REJECT is only a "to" state. It is for slots about to be removed.
                  

;;; NOTES ON REJECT STATE:
;;; A context transition FROM any state to the reject state is always followed by
;;; a transition TO a no-change impasse for the superslot or for the goal itself.
;;; So in this case a decision changes TWO slots, and each slot transition
;;; represents half the decision transaction.
;;; The exception:
;;;  Rejection of the problem-space and transition to no-change-goal,
;;;  involves only one slot (problem-space) and so only one transition.
;;; So the slot in question is either removed, or, for a goal no-change, 
;;; the slot (problem-space) moves to status no-change-goal. 
;;; Note that problem-spaces can also have status no-change-winner, in which
;;; case there will also be a value.

;;; END MODULE BACKGROUND.

#|
  


 Modules: Conflux: Contents

          
 Introduction

 Data
   Globals
     *impasse-subset-not-equal*

 Functions
   Transition Function Lookup
   Winner Transitions
   Constraint Failure Transitions
   Rejection Transitions
   Conflict Transitions
   Tie Transitions
   No-Change Transitions
   New Slot Transitions
   Utilities



 Modules: Conflux: Introduction


 Conflux manages context slot transitions.

 Conflux is invoked by the Supervisor during the quiescence phase,
 after a new decision has been made for a context slot.

 Conflux issues commands to Context to effect the slot transition.

 Slot transitions are identified by the slot's old and new status,
 which are represented in the slot's anode.

 Slot transitions are broken into two steps:
   Removal of old structure.
   Creation of new structure.
                                          
 There is one transition function for each slot transition.
 
 The most difficult context slot transition involves the installation
 of no-change impasses on the superslot of a slot that has no candidate values.
 These are called super-no-change impasses. They are described below:

   If there are no candidates for a context slot that is not the bottom
   slot, a no-change impasse is installed for the superslot:
     If there are no candidates for a problem-space slot, a goal no-change
     impasse is installed.
     If there are no candidates for a state slot, a problem-space no-change
     impasse is installed.
     If there are no candidates for an operator slot, a state no-change
     impasse is installed.

   The super-no-change impasse is to be distinguished from the no-change impasse:
     If an operator is installed and nothing happens, an operator no-change
     impasse is installed.



 Modules: Conflux: Data: Globals


 *impasse-subset-not-equal*
   T if an impasse whose items are a subset of the previous impasse is to be treated
   as a new impasse (context substructure flushed) or as a revision (no context
   flushing). Default is NIL.

   Also used by Subflux module.
   


|#



;;; MODULE GLOBALS.

(defvar *impasse-subset-not-equal*
        NIL
        "T if an impasse having items that are a subset of the previous impasse is to be treated as a new impasse. Default is NIL.")


;;; MODULE MACROS.


;;; TRANSITION FUNCTION LOOKUP.


(defdsmmacro context-transition (anode)
                                (anode) logical
 (declare (type anode anode))
 `(let ((old (anode-status ,anode)))
   (declare (symbol old))
   (cond 
         ((null old)
          (context-from-NIL ,anode))
         ((eq old 'winner)
          (context-from-winner ,anode))
         ((eq old 'tie)
          (context-from-tie ,anode))
         ((eq old 'no-change)
          (context-from-no-change ,anode))
         ((eq old 'conflict)
          (context-from-conflict ,anode))
         ((eq old 'rejection)
          (context-from-rejection ,anode))
         ((eq old 'constraint-failure)
          (context-from-constraint-failure ,anode) )) )
)





;;; Concatenated from type module "msubflux" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/msubflux/new/msubflux.lisp".
(in-package "SOAR")
   



;;; <SUBFLUX.MACROS>

               

;;; SUBTEXT TRANSITIONS MODULE: MACROS.                    
     

;;; MODULE DESCRIPTION.
;;;   Keeps the rules for making non-context slot transitions.

                     
;;; MODULE BACKGROUND.                 

;;; The STATES are:
;;;   winner
;;;   winners          
;;;   rejection (no values proposed for slot)
;;;     only a "to" state
;;;   constraint-failure 
;;;   conflict
;;;   tie
;;;   NIL (new slot)
;;;     only a "from" state
;;;                     
;;;  Note the relationship between the NIL and REJECT states.
;;;   NIL is only a "from" state. It is for slots about to be added.
;;;   REJECT is only a "to" state. It is for slots about to be removed.

;;; NOTES ON REJECT STATE:
;;;   The slot is removed.

;;; END MODULE BACKGROUND.

#|
  


 Modules: Subflux: Contents

          
 Introduction

 Data
   Globals
     *impasse-subset-not-equal*

 Functions
   Transitions Function Lookup
   Winner Transitions
   Winners Transitions
   Constraint Failure Transitions
   Conflict Transitions
   Tie Transitions
   New Slot Transitions
   Utilities



 Modules: Subflux: Introduction


 Subflux manages non-context slot transitions.

 Subflux is invoked by the Supervisor during the working memory phase,
 after a new decision has been made for a non-context slot.

 Subflux issues commands to Subtext to effect the slot transition.

 Slot transitions are identified by the slot's old and new status,
 which are represented in the slot's anode.

 Slot transitions are broken into two steps:
   Removal of old structure.
   Creation of new structure.
                                          
 There is one transition function for each slot transition.
                                       


 Modules: Subflux: Data: Globals


 *impasse-subset-not-equal* 
   
   Defined in Conflux module.

  



|#


                             
;;; MODULE GLOBALS.
;;;  Uses *impasse-subset-not-equal* defined in the Conflux module.                    


;;; MODULE MACROS.


;;; TRANSITION FUNCTION LOOKUP.


(defdsmmacro subtext-transition (anode)
                                (anode) logical
 ;; Added from rejection GAP 06/2/90
 (declare (type anode anode))
 `(let ((old (anode-status ,anode)))
   (declare (symbol old))
   (cond 
         ((null old)
          (subtext-from-NIL ,anode))
         ((eq old 'winner)
          (subtext-from-winner ,anode))
         ((eq old 'winners)
          (subtext-from-winners ,anode))
         ((eq old 'tie)
          (subtext-from-tie ,anode))
         ((eq old 'conflict)
          (subtext-from-conflict ,anode))
         ((eq old 'rejection)
          (subtext-from-rejection ,anode))
         ((eq old 'constraint-failure)
          (subtext-from-constraint-failure ,anode) )) )
)
  





;;; Concatenated from type module "msupervisor" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/msupervisor/new/msupervisor.lisp".
(in-package "SOAR")



;;; <SUPERVISOR.MACROS>


;;; SUPERVISOR MODULE: MACROS.

                 
;;; MODULE DESCRIPTION.
;;;  Soar supervisor.  

;;; MODULE BACKGROUND.
;;;  Started in two different states:
;;;    Start Cycler (when soar starts or restarts).
;;;      *current-cycle* is NIL.
;;;    Restart Cycler (after break).
;;;      *current-cycle* is non-NIL.

#|


 Modules: Supervisor: Contents


 Introduction

 Data
   Globals
     *cycler-status*
     *current-cycle*

 Functions
   Cycling
   Preference Phase
   Working Memory Phase
   Quiescence Phase
   Utilities



 Modules: Supervisor: Introduction


 The Supervisor is the system supervisor; it is invoked by the run command.

 The Supervisor cycles through the preference, working memory, and quiescence
 phases until a break or halt is signalled. It polls the Diplomat for breaks
 and halts between phases.



 Modules: Supervisor: Data: Globals


   *cycler-status*
     One of: cycling, break, halt.


   *current-cycle*
     When cycling, the current cycle name: preference-phase, working-memory-phase,
       or quiescence-phase. 
     After init-soar, NIL.
     After break or halt, the last cycle executed before break or halt.


|#

                      


;;; MODULE GLOBALS.     

(defvar *cycler-status*
        'break
        "Cycling or break or halt.")

(defvar *current-cycle*
        NIL
        "When cycling, current cycle name; else, last cycle executed before break.")
                     
(defvar *first-time*
        T
        "first time through the preference cycle. makes sure not calling io too often.")

;;; QUIESCENCE PHASE.
                              

(defdsmmacro operator-no-change-impasse (anode)
                                        (anode) logical
 (declare (type anode anode))
 ;; goal, space, and state no-change impasses are detected through
 ;; a rejection status on the subslot and treated as super-no-change impasses. 
 ;; only operator no-change impasses are treated here.
 `(cond ((and (eq (anode-attribute ,anode) 'operator)
              (not (gnode-subnode (anode-onode ,anode))))
         (setf (anode-new-status ,anode) 'no-change)
         (context-transition ,anode)
         T))
)







;;; Concatenated from type module "mtracer" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mtracer/new/mtracer.lisp".
(in-package "SOAR")




;;; <TRACER.MACROS>

;;; TRACER MODULE: MACROS.

;;; MODULE DESCRIPTION.
;;;  Accumulates and displays trace information.


#|
  

 Modules: Tracer: Contents

          
 Introduction

 Data
   Records
     Decision
   Globals   
     *trace-attributes*
     *watch-level*
     *cycle-trace*
     *firing-trace-all-rules*
     *firing-trace-task-rules-only*
     *firing-trace-special-rules*
     *firing-trace-objects*
     *firing-trace-tmes*
     *lhs-trace*
     *rhs-trace*
     *lhs-special-trace*
     *rhs-special-trace*
     *retraction-trace*
     *internal-firing-trace*
     *chunk-trace*
     *goal-creation-trace*
     *context-installation-long-trace*
     *context-installation-short-trace*
     *augmentation-addition-trace*
     *augmentation-removal-trace*
     *preference-wme-addition-trace*
     *preference-wme-removal-trace*
     *preference-addition-trace*
     *preference-removal-trace*
     *decide-trace*
     *decision-trace*
     *io-trace*

 Functions
   Trace Attributes

   Event Tracing: Requests
   Event Tracing: Data
   Event Tracing: Reports
   Event Tracing: Inquiry

   Print Utilities

   Utilities



 Modules: Tracer: Introduction


 The Tracer keeps track of trace requests, reports trace settings,
 and prints trace reports.

 The User notifies the Tracer of user trace requests and trace cancellations.

 The Diplomat queries trace settings and requests trace reports.



 Modules: Tracer: Data: Records: Decision


   Decision Trace Record (DECISION).     

     Represents the stages in the most recent execution of the decision procedure.
     Used by the use function dtrace to print out the last decision, and
     used when decide-trace has been set to T, to trace all decisions.

     Contains these fields:

       Object. The object whose slot's decision this record represents.
       Attribute. Slot attribute.
       Old-Winners. If the slot had values before the decision, a list of these
         values.
       Require. A list of the candidates remaining before require preferences analyzed.
       Acceptable. A list of the candidates remaining before acceptable preferences 
         analyzed.
       Post-Reject. A list of the candidates remaining after reject preferences
         analyzed.
       Post-Better. A list of the candidates remaining after better/worse 
         preferences analyzed.
       Post-Best. A list of the candidates remaining after best preferences
         analyzed.
       Post-Worst. A list of the candidates remaining after worst preferences
         analyzed.
       Post-Indifferent. A list of the candidates remaining after indifferent preferences
         analyzed.
       Post-Parallel. A list of the candidates remaining after parallel preferences
         analyzed.
 


 Modules: Tracer: Data: Globals
   

   Trace Attributes.
     *trace-attributes*
       Hash table mapping object classes to a list of the attributes that are
       to be traced for objects in that class.
                                              

   Watch Level.
     *watch-level*
       Curent watch setting.
                             

   Cycle Trace Settings.
     *cycle-trace*
       T if tracing the start of the preference, working memory, and quiescence
       phases. 
               

   Firing Trace Settings.
    These settings also apply to retraction tracing; retraction is treated as
    a special case of firing, with the exception that retraction tracing can be
    turned off completely.

     *firing-trace-all-rules* 
       T if trace all rule firings.

     *firing-trace-task-rules-only*
       T if tracing all task rule firings, but not default rule firings.

     *firing-trace-special-rules*
       A list of the special rules being traced, that is, rules whose trace
       has been individually requested.
       Firings of these rules are traced even though general production
       tracing is off.

     *firing-trace-objects*
       A list of objects whose tmes will be traced when they appear in the LHS
       or the RHS of a firing rule.

     *firing-trace-tmes*
       A list of tmes to be traced when they appear in the LHS or the RHS of a
       firing rule. 

     *lhs-trace*
       T if the LHS of a firing rule is to be included in the trace.

     *rhs-trace*
       T if the RHS of a firing rule is to be included in the trace.

     *lhs-special-trace*
       T if the LHS of a individually traced firing rule is to be included
       in the trace.

     *rhs-special-trace*
       T if the RHS of a individually traced firing rule is to be included
       in the trace.
                                       

   Retraction Trace Settings.       
     The firing trace settings apply to retractions as well, with the exception that
     retraction tracing can be turned off entirely.
  
      *retraction-trace*                           
        T if retractions are to be traced as well as firings.

                             
   Internal Firing and Retraction Trace Settings.
      *internal-firing-trace*
        T if the firing and retraction of internal chunks is to be traced.
  
                                
   Chunk Trace Settings.

      *chunk-trace*
        T if chunk firings and retractions are to be traced.

                        
   Context Trace Settings.
      *goal-creation-trace*
        T if goal creations are to be traced.

      *context-installation-long-trace*      
        T if a long trace is to be printed for context installations.

      *context-installation-short-trace*
        T if a short trace is to be printed for context installations.
                    
          
   Working Memory Trace Settings.

      *augmentation-addition-trace*
        T if additions of augmentations to working memory are to be traced.

      *augmentation-removal-trace*
        T if removals of augmentations from working memory are to be traced.

      *preference-wme-addition-trace*                         
        T if additions of preferences to working memory are to be traced.

      *preference-wme-removal-trace*
        T if removals of preferences from working memory are to be traced.

      *preference-addition-trace*
        T if additions of preferences to architecture memory are to be traced.

      *preference-removal-trace*
        T if removals of preferences from architecture memory are to be traced.
                                                      

   Decide Trace Settings.

      *decide-trace*          
        T if the decision procedure is to be traced.

      *decision-trace*
        Decision record representing a trace of the most recent execution of
        the decision procedure. Decision traces are created even when
        *decide-trace* is NIL.
                         
 
   Soar/IO Trace Settings.

      *io-trace*                        
        T if Soar/IO traffic is to be traced when other augmentation traffic
        is traced. Used to turn off tracing of Soar/IO traffic.

|#




;;; MODULE RECORDS.
                             
;;; Represents the stages of preference analysis.
;;; For the slot most recently analyzed.
(defstruct (decision (:constructor make-decision (object attribute old-winners)))
           "Represents the stages of preference analysis."
           (object NIL :type tme-object)
           (attribute NIL :type tme-attribute)
           (old-winners  NIL :type list)
           (require NIL :type list)
           (acceptable NIL :type list)
           (post-reject NIL :type list)
           (post-better NIL :type list)
           (post-best NIL :type list)
           (post-worst NIL :type list)
           (post-indifferent NIL :type list)
           (parallel NIL :type list)
)
                       

;;; MODULE GLOBALS.

;;; TRACE ATTRIBUTES TABLE.      
;;; Key is object class.

(defvar *trace-attributes*
        NIL
        "Hash to trace-attributes through class name.") 

;;; EVENT TRACE SWITCHES.

(defvar *watch-level*
        0
        "Current Watch trace level.")

;; CYCLE trace settings.

(defvar *cycle-trace*
        NIL
        "T if cycle tracing.")
                 
;; FIRING trace settings.
;; These settings also apply to retraction tracing:
;;   Retraction is considered a special case of firing,
;;   and uses all the firing trace settings, except that
;;   retraction tracing can be turned off completely.
;;   (May have to make separate settings for retraction.)

;; Trace all rules (sometimes excepting non-task rules), not just
;; special rules.
(defvar *firing-trace-all-rules*
        NIL
        "T if tracing all rules.")

;; Trace task rules only (not default rules).
;; This is a qualification of *firing-trace-all-rules*, whose
;; setting is determined by the trace level. 
;; It will have an effect only if *firing-trace-all-rules* is T;
;; special rules will be traced whether they are task rules or not.

(defvar *firing-trace-task-rules-only*
        NIL
        "T if tracing task rules only.")

(defvar *firing-trace-special-rules*
        NIL
        "Special rules being traced.")

(defvar *firing-trace-objects*
        NIL
        "Objects for which working memory traffic is being traced.") 

(defvar *firing-trace-tmes*
        NIL
        "Tmes for which working memory traffic is being traced.")
                       
;; Consulted when all rules are being traced.
(defvar *lhs-trace*
        NIL
        "T if traced rule LHS is to be printed.") 

(defvar *rhs-trace*
        NIL
        "T if traced rule RHS is to be printed.")
                                             
;; Consulted when only special rules are being traced.
(defvar *lhs-special-trace*
        T
        "T if traced special rule LHS is to be printed.")

(defvar *rhs-special-trace*
        NIL
        "T if traced special rule RHS is to be printed.")


;; RETRACTION trace settings.                       
;; If T, all the firing trace settings apply to retractions.
(defvar *retraction-trace*
        T
        "T if retractions are to be traced as well as firings.")


;;; INTERNAL firing and retraction trace settings.
(defvar *internal-firing-trace*
        NIL
        "T if internal chunk firings and retractions are to be traced.")


;; CHUNK trace settings.                       
;; If NIL, chunks are not traced at any watch level.
(defvar *chunk-trace*
        T
        "T if chunks are to be traced.")
         
;; CONTEXT trace settings.
(defvar *goal-creation-trace*
        NIL
        "T if goal creations are to be traced.")

(defvar *context-installation-long-trace*
        NIL
        "T if context-installations are to be long-traced.") 

(defvar *context-installation-short-trace*
        NIL
        "T if context-installations are to be short-traced.") 

                          
;; WORKING MEMORY trace settings.
(defvar *augmentation-addition-trace*
        NIL
        "T if augmentation additions are to be traced.") 

(defvar *augmentation-removal-trace*
        NIL
        "T if augmentation removals are to be traced.") 

(defvar *preference-wme-addition-trace*
        NIL
        "T if preference wme additions are to be traced.") 

(defvar *preference-wme-removal-trace*
        NIL
        "T if preference wme removals are to be traced.") 

(defvar *preference-addition-trace*
        NIL
        "T if preference additions are to be traced.") 

(defvar *preference-removal-trace*
        NIL
        "T if preference removals are to be traced.") 

             
;; DECISION trace settings.
(defvar *decide-trace*
        NIL
        "T if decisions are to be traced.")

(defvar *decision-trace*
        NIL
        "Trace of the most recent decision. Decision record.")
                                                                      

;; IO trace settings.
(defvar *io-trace*
        T
        "T if io traffic is to be traced when other augmentation traffic is traced.")


                 
;;; MODULE MACROS.
              

;;; TRACE ATTRIBUTES.


(defdsmmacro class-trace-attributes (class)                      
                                    (tme-class) list
 (declare (type tme-class class))       
 `(remove NIL
         (cons 'name (gethash ,class *trace-attributes*)))
)



;;; EVENT TRACING: DATA.


(defdsmmacro decision-trace-slot (object attribute old-winners)
                                 (tme-object tme-attribute list) decision
 (declare (type tme-object object)
          (type tme-attribute attribute)
          (list old-winners))
 `(setf *decision-trace* (make-decision ,object ,attribute ,old-winners))
) 
                              
(defdsmmacro decision-trace-require (candidates)            
                                    (list) list
 (declare (list candidates))
 `(setf (decision-require *decision-trace*) ,candidates)
)


(defdsmmacro decision-trace-acceptable (candidates)
                                       (list) list
 (declare (list candidates))
 `(setf (decision-acceptable *decision-trace*) ,candidates)
)


(defdsmmacro decision-trace-post-reject (candidates)
                                        (list) list
 (declare (list candidates))
 `(setf (decision-post-reject *decision-trace*) ,candidates)
)


(defdsmmacro decision-trace-post-better (candidates)
                                        (list) list
 (declare (list candidates))
 `(setf (decision-post-better *decision-trace*) ,candidates)
)


(defdsmmacro decision-trace-post-best (candidates)
                                      (list) list
 (declare (list candidates))
 `(setf (decision-post-best *decision-trace*) ,candidates)
)


(defdsmmacro decision-trace-post-worst (candidates)
                                       (list) list
 (declare (list candidates))
 `(setf (decision-post-worst *decision-trace*) ,candidates)
)


(defdsmmacro decision-trace-post-indifferent (candidates)
                                             (list) list
 (declare (list candidates))
 `(setf (decision-post-indifferent *decision-trace*) ,candidates)
)


(defdsmmacro decision-trace-parallel (candidates)
                                     (list) list
 (declare (list candidates))
 `(setf (decision-parallel *decision-trace*) ,candidates)
)


;;; EVENT TRACING: INQUIRY.


(eval-when (compile eval load) (proclaim '(special *watch-free-problem-spaces*)))
(defdsmmacro watching-p ()
                        () T
 (declare)
 ;; returns T if the current (bottom) goals are to be watched.
 `(if (and *watch-free-problem-spaces* (>= *watch-level* 0))
      (not (member (bottom-space-name) *watch-free-problem-spaces* :test #'eq))
      T)
)

          
(defdsmmacro watch-level ()
                         () number
 (declare)
 `*watch-level*
)

          
(defdsmmacro cycle-trace-p ()
                           () logical
 (declare)
 `*cycle-trace*
)
          
(defdsmmacro goal-creation-trace-p ()
                                   () logical
 (declare)
 `*goal-creation-trace*
)


(defdsmmacro firing-trace-p ()               
                            () T
 (declare)
 `(or *firing-trace-all-rules* 
      *firing-trace-special-rules*
      *firing-trace-objects*
      *firing-trace-tmes*) 
)
                                      


(defdsmmacro firing-trace-all-rules-p (rule-name)
                                      (symbol) logical
 (declare (symbol rule-name))
 `(logicize
   (cond (*firing-trace-all-rules*
          ;; exceptions.
          (cond ((and *firing-trace-task-rules-only* (not (task-rule-p ,rule-name)))
                 NIL)
                ((and (not *chunk-trace*) (chunk-p ,rule-name))
                 NIL)
                (T
                 T)))
         (T
          NIL)) )
)



(defdsmmacro firing-trace-rule-p (rule-name)          
                                 (symbol) logical
 (declare (symbol rule-name))
 `(logicize
   (cond ((and (not *chunk-trace*) (chunk-p ,rule-name))
          NIL)
         (T
          (member ,rule-name *firing-trace-special-rules* :test #'eq) )) )
)
            


(defdsmmacro firing-trace-object-p (object)
                                   (tme-object) logical
 (declare (type tme-object object))
 `(logicize
   (member ,object *firing-trace-objects* :test #'eq))
)


(defdsmmacro firing-trace-tme-p (tme)            
                                (tme) logical
 (declare (type tme tme))
 `(logicize
   (member ,tme *firing-trace-tmes* :test #'fuzzy-tme=))
)
                       
 

(defdsmmacro firing-trace-rules ()
                                () list
 (declare)
 `*firing-trace-special-rules*
)

(defdsmmacro firing-trace-objects ()   
                                  () list
 (declare)
 `*firing-trace-objects*
)

(defdsmmacro firing-trace-tmes ()        
                               () list
 (declare)
 `*firing-trace-tmes*
)


(defdsmmacro retraction-trace-p ()    
                                () T
 ;; retraction is considered a special case of firing,
 ;; and uses all the firing trace settings, except that
 ;; retraction tracing can be turned off completely.
 (declare)
 `(and *retraction-trace*
       (firing-trace-p))
)


(defdsmmacro internal-firing-trace-p ()    
                                     () T
 (declare)
 `*internal-firing-trace*
)


(defdsmmacro lhs-trace-p ()         
                         () logical
 (declare)
 `*lhs-trace*
)


(defdsmmacro rhs-trace-p ()
                         () logical
 (declare)
 `*rhs-trace*
)


(defdsmmacro lhs-special-trace-p ()
                                 () logical
 (declare)
 `*lhs-special-trace*
)


(defdsmmacro rhs-special-trace-p ()
                                 () logical
 (declare)
 `*rhs-special-trace*
)


(defdsmmacro context-installation-trace-p ()
                                          () logical
 (declare)
 `(or (context-installation-long-trace-p)
      (context-installation-short-trace-p))
)
     


(defdsmmacro context-installation-long-trace-p ()
                                               () logical
 (declare)
 `*context-installation-long-trace*
)


(defdsmmacro context-installation-short-trace-p ()
                                                () logical
 (declare)
 `*context-installation-short-trace*
)                           


(defdsmmacro augmentation-addition-trace-p ()
                                           () logical
 (declare)
 `*augmentation-addition-trace*
)


(defdsmmacro augmentation-removal-trace-p ()
                                          () logical
 (declare)
 `*augmentation-removal-trace*
)


(defdsmmacro preference-wme-addition-trace-p ()
                                             () logical
 (declare)
 `*preference-wme-addition-trace*
)


(defdsmmacro preference-wme-removal-trace-p ()
                                            () logical
 (declare)
 `*preference-wme-removal-trace*
)


(defdsmmacro preference-addition-trace-p ()
                                         () logical
 (declare)
 `*preference-addition-trace*
)


(defdsmmacro preference-removal-trace-p ()
                                        () logical
 (declare)
 `*preference-removal-trace*
)


(defdsmmacro decision-trace-p ()
                              () logical
 (declare)
 `*decide-trace*
)                           


(defdsmmacro io-trace-p ()
                        () logical
 (declare)
 `*io-trace*
)                           




;;; Concatenated from type module "mstartup" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mstartup/new/mstartup.lisp".
(in-package "SOAR")



;;; <STARTUP.MACROS>


;;; STARTUP MODULE: MACROS.

;;; MODULE DESCRIPTION.
;;;  Starts SOAR5 modules on system load.
;;;  Restarts SOAR5 modules on system restart and retask.

;;;    Start means start the newly loaded system.
;;;    Restart means clear out task productions and everything else.
;;;      That is, prepare to start a new task.
;;;    Retask means clear out all but task productions.                                                          
;;;      That is, prepare to restart the current task.


#|

 Modules: Startup: Contents

          
 Introduction

 Data
   Globals
     *clearing-matcher-working-memory*

 Functions
   Start
   Restart
   Retask
   Utilities



 Modules: Startup: Introduction


 Startup initializes all the modules when start-soar, restart-soar, or init-soar
 are invoked.



 Modules: Startup: Data: Globals


   *clearing-matcher-working-memory*
      T if clearing working memory during init-soar or restart-soar.
      Used to suppress processing of new instantiations and retractions
      reported by Matcher.


|#
        

;;; MODULE GLOBALS.
                                                    
;;; If T, firer is not notified of instantiation and retraction arrivals.
(defvar *clearing-matcher-working-memory*
        NIL
        "T if flushing working memory (during init-soar or restart-soar).")

                

;;; MODULE MACROS.
;;;  None.




;;; Concatenated from type module "mactions" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mactions/new/mactions.lisp".
(in-package "SOAR")
              


;;; <ACTIONS.MACROS>


;;; MODULE DESCRIPTION.
;;;  Analyzes RHS of fired instantiations to accumulate information
;;;  used in chunking. Creates object and production traces. 

#|


 Modules: Actions: Contents

          
 Introduction

 Functions
   Result Tracing
   LHS Result Tracing
   Utilities



 Modules: Actions: Introduction

                           
 Actions is invoked by the Firer to save the production and object traces
 for a rule just fired.

 Object tracing is the determination of the results created by a firing for
 each of the goals in the stack from the producing goal up to the top goal.
 These results will be the basis for the actions of the chunk built for each
 goal.
      
 Object traces are also used to split the LHS tmes into results, non-results, and
 possible results. The LHS is stored in this broken-down form in a production
 trace.
         
 Actions sends the object and production traces to Context for storage.
                       
 Call hierarchy:
   Firer
     Actions        Compute production and object traces
       Context      Save object trace
       Context      Save productiion trace
         Actions    Split LHS tmes into results, non-results, possible results
           Context  Get object traces
 
|#


;;; ACTIONS MODULE: MACROS.
                           
;;; MODULE MACROS.

(defdsmmacro analyze-fired-instantiation (name lhs sorted-rhs firing-gnode nots)
                                         (symbol list list gnode) T
 ;; Added argument to handle nots. -BGM 29-Nov-90
 (declare (symbol name)
          (list lhs sorted-rhs)
          (type gnode firing-gnode))
 ;; called by fire-rule and fire-fake-rule.
 `(let ()
   (log-rhs-results ,firing-gnode ,sorted-rhs)
   (save-production-trace ,name ,lhs ,sorted-rhs ,firing-gnode ,nots))
)






             




;;; Concatenated from type module "mconditions" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mconditions/new/mconditions.lisp".
(in-package "SOAR")

                     


;;; <CONDITIONS.MACROS>

;;; MODULE DESCRIPTION.                               
;;   Supervises chunk backtracing and building.
;;;  Backtraces from chunk RHS pmes to chunk LHS wmes. 

#|


 Modules: Conditions: Contents

          
 Introduction

 Functions
   Instantiation Owner
   Instantiating Negated Conditions
     
   Supervision of Backtracing and Chunk Building
   Backtracing

   Utilities



 Modules: Conditions: Introduction

  
 Conditions supervises backtracing and chunk building.

 Conditions backtraces. 

 Conditions invokes Chunk5 to variablize the RHS and LHS tmes.

 Conditions invokes Chunk5 to build a chunk from the backtraced and variablized
 LHS and RHS. 


|#


;;; CONDITIONS MODULE: MACROS.


;;; MODULE GLOBALS.

                
;;; MODULE MACROS.       

;;; BACKTRACING.


(eval-when (compile eval load) (proclaim '(special *trace-file*)))
(defdsmmacro find-back-production (condition traces) 
                                  (tme hash-table) rtrace

 (declare (type tme condition)
          (hash-table traces))
 ;; Updated to print-wme-and-timetag. -BGM 1-Mar-90
 ;; returns rule-trace record.
 ;; called by:
 ;;  back-trace-production-conditions 
 ;; traces having goal augmentations as actions may have been created
 ;; by the decision-procedure.

 `(let ((rtrace (gethash ,condition ,traces)))
   (declare (type rtrace rtrace))
   (cond (rtrace      
          rtrace)
         (T 
          ;; goal augmentations are not created by rules.
          ;; (for some, fake rule traces are created.)
          ;; do not want to see this message for goal conditions.
          (cond ((not (goal-p (wme-object ,condition)))
                 (soar-format *trace-file* "~%Could not find producer: ~%")
		 (print-wme-and-timetag *trace-file* ,condition)
		 (soar-format *trace-file* "~%")))
          NIL))
   ))







;;; Concatenated from type module "mchunk5" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/mchunk5/new/mchunk5.lisp".
(in-package "SOAR")

              


;;; <CHUNK5.MACROS>

;;; MODULE DESCRIPTION.
;;;  Builds text of chunk under the supervision of the Conditions module.

#|


 Modules: Chunk5: Contents

          
 Introduction

 Data
   Globals
     *building-chunk*
     *building-internal-chunk*
     *building-constant-chunk*

 Functions
   Variablization
   Building
   Knotification

   CAV (Chunk Attribute Value) Knotification Utilities
   CAVI (Chunk Attribute Value Identifier) Knotification Utilities

   Utilities



 Modules: Chunk5: Introduction


 Chunk5 is invoked by Conditions to variablize the LHS and RHS tmes.

 Chunk5 is invoked by Conditions to build a chunk from a variablized RHS
 and LHS:

   Chunk5 reorders the chunk LHS, adds "nots" to variables to ensure that
   variables that correspond to different ids in the chunk seed instantiate
   to different values in the chunk, builds the chunk text, checks for duplicates
   created during the current preference phase, and queues the chunk for
   compilation at the end of the preference phase.

   The Firer directs the compilation of new chunks at the end of the preference
   phase.



 Modules: Chunk5: Data: Globals


   *building-chunk*
     T if chunk is to be built.
     At the start of chunking, it is assumed that a chunk will be built and that
     it will be an external chunk. 
     During chunking, the emerging chunk is tested for necessity and fitness.
     If judged unnecessary, the chunk is not built, and this global is
     set to NIL. 

   *building-internal-chunk*
     If an emerging chunk is being built when learning is off or is otherwise
     unfit for existence, but is needed to support subgoal results, then the
     chunk is built as an internal chunk, and this global is set.

   *building-constant-chunk*
     If an internal chunk is being built, and it is to be a constant chunk
     (because its LHS contains no conjunctive negations), then this global is set.

|#

;;; CHUNK5 MODULE: MACROS.


;;; MODULE GLOBALS.

(defvar *building-chunk*
        NIL
        "T if chunk is to be built.") 

(defvar *building-internal-chunk*
        NIL
        "T if chunk being built is to be an internal chunk.") 

(defvar *building-constant-chunk*
        NIL
        "T if chunk being built is to be a constant (internal) chunk.") 
                           

;;; MODULE MACROS.

                            
(defdsmmacro not-building-chunk ()
                                () logical
 (declare)
 `(setf *building-chunk* NIL)
)



(defdsmmacro building-chunk-p ()
                              () logical
 (declare)
 `*building-chunk*
)

 

(defdsmmacro building-external-chunk ()
                                     () logical
 (declare)
 `(let ()                         
   (setf *building-chunk* T) 
   (setf *building-internal-chunk* NIL)
   (setf *building-constant-chunk* NIL) )
)        



(defdsmmacro building-internal-chunk (lhs-wmes)
                                     (list) logical
 (declare (list lhs-wmes))
 `(let ()
   (setf *building-internal-chunk* T)
   (cond ((not (conjunctive-negations-p ,lhs-wmes))
          (setf *building-constant-chunk* T) )) )
)        

 
                 
(defdsmmacro building-external-chunk-p ()
                                       () logical
 (declare)
 `(not *building-internal-chunk*)
)

 
                 
(defdsmmacro building-internal-chunk-p ()
                                       () logical
 (declare)
 `*building-internal-chunk*
)

 
                 
(defdsmmacro building-constant-chunk-p ()
                                       () logical
 (declare)
 `*building-constant-chunk*
)


                                   


;;; Concatenated from type module "utility" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/utility/new/compat.lisp".
;;; -*-mode: soar; package: user -*-

(in-package "SOAR")

(defmacro soarlistp (z)
    `(consp ,z))

;; PRINC and SETF should be OK as they are

(defmacro soarputprop (n v a)
	`(setf (get ,n ,a) ,v))

(defun soaraddprop (n v a)
	(soarputprop n (cons v (get n a)) a))

(defun soarclearprops (sym)
  (setf (symbol-plist sym)  ()))

(defmacro soarmapc (func list)
	`(mapc ,func ,list))

(defmacro soarmapcar (func list)
	`(mapcar ,func ,list))

(defmacro soarmapconc (func list)
	`(mapcan ,func ,list))

(defmacro soarpush (item list)
	`(push ,item ,list))

(defmacro soar-i-to-s (n)
    `(format nil "~d" ,n))

; Code that uses this must take care that the keys are numbers.
; This was the case when soarcarsort was defined.  This same precaution
; must be taken with soarsort, but it must be given strings, characters,
; or symbols.

(defmacro soarcarsort (x)
	`(sort ,x #'< :key #'car))

(defun soarload (z)
    (soarsyntax)
    (load z)
    (soarresetsyntax))

;;; Removed start-soar defun. -KAM 4/1/89.

; New in version 3.2

(defmacro soarmember (a b)
    `(member ,a ,b :test #'equal))

(defmacro soarmemq (a b)
    `(member ,a ,b :test #'eql))

(defmacro soarassq (item alist)
	`(assoc ,item ,alist :test #'eql))

(defmacro soarassoc (item alist)
 `(assoc ,item ,alist :test #'equal))

(defmacro soarwhile (test &body body)
  `(prog nil
      loop
	 (when (not ,test) (return))
	 ,@body
	 (go loop)))

(defun soarnthchar (a b)
 ;; This is grossly inefficient to be calling writ-to-string down here.
 ;; This have all occurances replaced, mostly with calls to (schar (symbol-name ...)).
 ;; -BGM 1/8/88.
  (intern (make-string 1 :initial-element
		       (char (write-to-string a :escape nil :case :upcase)
			     (the fixnum (- (the fixnum b) 1))))))

(eval-when (compile eval load) (proclaim '(special *trace-file*)
  ;; Installed by BGM 3/2/89.
  ))

(defun showload (file)
  (prog (in nextexpr)
        (setq in (open file))
	(soar-format *trace-file* "~%")
     l1 (setq nextexpr (read in nil '**end-of-file**))
        (cond ((eq nextexpr '**end-of-file**) (return)))
        (soar-format *trace-file* "----> ~A~%~A~%" nextexpr (eval nextexpr))
        (go l1)))

(defun soardifference (x y)
    (mapcan (function (lambda (z)
			      (cond ((not (soarmember z y)) (cons z nil))
				    (t nil))))
	    x))

; For Soar 4.3
(defun span-chars (x prt)
    (do ((ch (peek-char nil prt) (peek-char nil prt)))
	((not (member ch x)))
      (read-char prt nil 'end-of-file)))

(defun soarconcat (a b c)
     (intern (concatenate 'string
			   (write-to-string a :escape nil :case :upcase)
			   (write-to-string b :escape nil :case :upcase)
			   (write-to-string c :escape nil :case :upcase))))

(defmacro forward-slash nil ''/)
(defmacro backward-slash nil ''\\)
(defmacro arithmetic-operators nil ''(+ - * / \\))
(defmacro quote-character nil ''/)
(defun single-slash () #\/)

(defmacro makevector (x)
  `(the simple-vector (make-array ,x)))

(defmacro putvector (array index value)
     `(setf (svref ,array ,index) ,value))

(defmacro getvector (name index)
    `(svref ,name ,index))


; Definitions and macros for Soar 4.4 and 5.0. -BGM 1/22/89

(defmacro wme-goal (wme) `(nth 5 ,wme))
(defmacro wme-problem-space (wme) `(nth 6 ,wme))
(defmacro wme-state (wme) `(nth 7 ,wme))
(defmacro wme-operator (wme) `(nth 8 ,wme))

(defun setf-wme-class (wme val) (rplaca wme val))
(defun setf-wme-id (wme val) (rplaca (cdr wme) val))
(defun setf-wme-object (wme val) (rplaca (cdr wme) val))
(defun setf-wme-attribute (wme val) (rplaca (nthcdr 2 wme) val))
(defun setf-wme-role (wme val) (rplaca (nthcdr 2 wme) val))
(defun setf-wme-value (wme val) (rplaca (nthcdr 3 wme) val))

(defun soar-date ()
    (multiple-value-bind (second minute hour date month year)
	(get-decoded-time)
	(declare (ignore second minute hour))
	(format nil "~A ~D, ~D"
	    (case month
		(1 "January ")
		(2 "February ")
		(3 "March ")
		(4 "April ")
		(5 "May ")
		(6 "June ")
		(7 "July ")
		(8 "August ")
		(9 "September ")
		(10 "October ")
		(11 "November ")
		(12 "December "))
	    date
	    year)))

;;; [RMW -- 7/8/86] Added dummy init-task function to avoid bombing
(defun init-task ()
	(format t "No init-task defined.~%")
)

; Number comparison function, using eql instead of = for now since some
; places call it with non-numbers nonetheless.
(defmacro eqp (&body z)
	(cons 'eql z))

;;; Concatenated from type module "utility" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/utility/new/utility.lisp".
;;; -*-mode: soar; package: user -*-
;;; Utility.lisp
;;;
(in-package "SOAR")


;;;	
;;;		?.	Global Variables
;;;
;;; *indent*

;;; *loading-default*
(defvar *loading-default* () "Am I loading the default production set ?")
;;;


(defun cdrmember (element list) ; John.Laird  3-Oct-85 09:41 
       (prog nil l0 (cond ((null list)
			   (return nil))
			  ((equal (cdr element)
				  (cdr (pop list)))
			   (return t)))
	     (go l0)))

(defun find-variables (list) ; John.Laird 11-Sep-85 17:29 
       (cond ((null list)
	      nil)
	     ((variablep-not-predicate (car list))
	      (cons (car list)
		    (find-variables (cdr list))))
	     (t (find-variables (cdr list)))))

(defun flatten (l) ; John.Laird 31-Jul-84 13:43 
       (soarmapconc #'(lambda (item)
			      (cond ((atom item)
				     (list item))
				    (t (flatten item))))
		    l))


(defun intrq (x y) ; John.Laird 18-Apr-85 08:11 
       (cond ((atom x)
	      nil)
	     ((soarmemq (car x)
			y)
	      (cons (car x)
		    (intrq (cdr x)
			   y)))
	     (t (intrq (cdr x)
		       y))))

(defun is-negation (item) ; Randy.Gobbel 13-Jun-86 18:40 
       (soarmemq item '(- *)))

(defun remove-nil (x) ; Randy.Gobbel 13-Jun-86 14:34 
       (cond ((null x)
	      x)
	     ((and (soarlistp x)
		   (null (car x)))
	      (remove-nil (cdr x)))
	     ((and (soarlistp x)
		   (eq (car x)
		       '!))
	      (remove-nil (cdr x)))
	     ((and (soarlistp x)
		   (null (cdr x)))
	      (remove-nil (car x)))
	     ((listp x)
	      (append (remove-nil (car x))
		      (remove-nil (cdr x))))
	     (t (list x))))

; For Soar 4.2
(defmacro subnumber (x)
    `(parse-integer (symbol-name ,x) :start 1 :junk-allowed t))

(defun start-default nil  ; Randy.Gobbel  9-May-86 10:13 
       (setq *loading-default* t))

(defun stop-default nil  ; Randy.Gobbel  9-May-86 10:14 
       (setq *loading-default* nil))

(defun t-in-list? (x) ; John.Laird  7-Oct-85 11:01 
       (soarmemq t (flatten x)))

(defun rematm (atm list) ; Randy.Gobbel 11-Sep-86 15:31 
       (cond ((atom list)
	      list)
	     ((eqp atm (car list))
	      (rematm atm (cdr list)))
	     (t (cons (car list)
		      (rematm atm (cdr list))))))

(defun flat-value (x) ; Randy.Gobbel 11-Jun-86 16:35 
       (cond ((atom x)
	      x)
	     (t (soarmapc #'flat-value x))))

(defun get-duplicates (vlist) ; Randy.Gobbel 13-May-86 14:18  ; RETURNS A 
 ; LIST OF ALL ELEMENTS THAT APPEAR TWICE IN VLIST 
       (do ((vl vlist (cdr vl))
		 (dup))
		((null vl)
		 (return dup))
		(cond ((and (soarmemq (car vl)
				      (cdr vl))
			    (not (soarmemq (car vl)
					   dup)))
		       (soarpush (car vl)
				 dup)))))

(defun get-non-duplicates (list) ; Randy.Gobbel 13-May-86 14:18 
       (do ((l1 list (cdr l1))
		 (nondup)
		 (dup))
		((null l1)
		 (return nondup))
		(cond ((soarmemq (car l1)
				 dup))
		      ((soarmemq (car l1)
				 (cdr l1))
		       (soarpush (car l1)
				 dup))
		      (t (soarpush (car l1)
				   nondup)))))

(defun nulla (x) ; pkh: 13-Feb-84 14:09 
       (cond ((null x)
	      nil)
	     ((atom x)
	      nil)
	     ((and (null (car x))
		   (nulla (cdr x)))
	      nil)
	     (t t)))
     
(defun variablep-not-predicate (thing) 

 ;; Modified from definition of variablep. -KAM 10/5/89
 ;; As the new parser has a variablep, that is strictly a variablep
 ;; I have renamed this variablep-not-predicate. BGM 7/28/88.

 (and (symbolp thing) 
      (let* ((symbol-name (symbol-name thing))
	            (length-symbol-name (length (the string symbol-name))))
       (declare (string symbol-name)
                (fixnum length-symbol-name))
       (and
            ;; not predicate.
            (> length-symbol-name 2) ;excludes << and all predicates except <=>. 
       	    (not (eq thing '<=>))    ;excludes <=>.

            ;; variable.
	           (char= (aref symbol-name 0) #\<)
         	  (char= (aref symbol-name (1- length-symbol-name)) #\>) )))
)


;;;
;;; In here for the micro vax which complains without it.
;;; Lucid and CMU lisp have it but really it decreases portability.
;;; Should this really be a #'eql or an #'eq ? -BGM 1/9/88.
;;; 

#+(and :vms :vax :dec)  ;added :'s. -KAM 6/15/89
(defmacro delq (item sequence)
  `(delete ,item ,sequence :test #'eql))

;;;
;;;	Added Soar-set-difference to reduce lisp system dependencies in the
;;; test code. -BGM 6/13/88.

#+(or)  ;superseded by BGM defun below. 10/23/89. -KAM
(defun soar-set-difference (list1 list2)
 (if list2
   (let ((res nil))
     (dolist (elt list1)
      (unless (member elt list2) (push elt res)))
    res)
    list1)) 

;; keep these 2 funs here until 5.1/4.5.3 merge.               
(defun soar-set-difference (list1 list2 &key (test #'eql testp))
 (if testp 
     (if list2
	 (let ((res nil))
	   (dolist (elt list1)
	     (unless (member elt list2 :test test) (push elt res)))
	   res)
       list1)
   (if list2
       (let ((res nil))
	 (dolist (elt list1)
	   (unless (member elt list2) (push elt res)))
	 res)
     list1)))



(defun soar-set-union (a b &key (key #'identity) (test #'eql testp) (test-not nil test-notp))
  (if (not a) b
    (if (not b) a
      (if (or a b) 
	  (if testp
	      (if test-not (error "Test and test-not both supplied.")
		(let ((res b))
		  (dolist (elt a)
		    (if (not (member (funcall key elt) b :test test))
		     (push elt res)))
		  res))
	    (if test-notp
		(let ((res b))
		  (dolist (elt a)
		    (if (not (member (funcall key elt) b :test-not test-not))
		     (push elt res)))
		  res)
		(let ((res b))
		  (dolist (elt a)
		    (if (not (member (funcall key elt) b))
		     (push elt res)))
		  res)))
	nil))))





;;; Concatenated from type module "utility" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/utility/new/time.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module Utility submodule Time
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the calls to timing packages.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Call Tree	
;;;	iv.	Global Variables

;;;
;;;		iv.	Global Variables
;;;

(in-package "SOAR")

(defvar *begin-build-time* () "")
(defvar *begin-time* () "")
(defvar *elapsed-build-time* 0 "")
(defvar *elapsed-time* 0 "")




(defmacro alwaystime ()
	`(get-internal-run-time))

#-:ti
(defmacro time-difference (&body z)
   (cons '- z))

(defun start-build-time nil  ; John.Laird 19-Jun-86 11:56 
       (setq *begin-build-time* (alwaystime)))

(defun stop-build-time nil  ; John.Laird 19-Jun-86 11:56 
       (setq *elapsed-build-time* (+ *elapsed-build-time*
					 (time-difference (alwaystime)
							  *begin-build-time*))))


(defmacro time-conversion (x)
  `(/ ,x ,(coerce internal-time-units-per-second 'float)))

(defun start-elapsed-time nil  ; Randy.Gobbel 13-Jun-86 14:34 
       (setq *begin-time* (alwaystime)))

(defun stop-elapsed-time nil  ; Randy.Gobbel 13-Jun-86 14:35 
       (setq *elapsed-time* (+ *elapsed-time* (time-difference (alwaystime)
								   *begin-time*)
				   )))


;;; -*-mode: lisp; package: user -*-
;;;
;;;	
;;;		Soar:	Module Utility Submodule Time
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file, utility time, implements as set of timings
;;; as a defstruct of timing information, two macros and a print-function.
;;; The calls to initialize and collect times using these conventions
;;; are conditionally compiled on the feature :soar-times. If these
;;; timing calls are not desired the following pushnew should be commented out.
;;;

;;;
;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Package Specification
;;;	I.	:Soar-times feature
;;;	II.	Soar-times defstruct
;;;	III.	*Soar-times* global variable
;;;	IV.	Internal-time-into-seconds
;;;	V.	Print-soar-times
;;;	VI.	Start-soar-time
;;;	VII.	Stop-soar-time
;;;	VIII.	Pause-soar-time
;;;

;;;
;;;		iii.	Package Specification
;;;

(in-package "SOAR")

;;;
;;;		I.	:Soar-times feature
;;;
;;;	The timing should be off by default.

;(eval-when (compile eval load)
;   (pushnew :soar-times *features*))



;;;
;;;		II.	Soar-times Defstruct
;;;
;;; Each field holds its total time spent directly in that module so far. The corresponding
;;; start- field holds the last internal-run[real]-time at which the current call
;;; to start-soar-time of that field started.
;;;

#+:soar-times
(eval-when (compile load eval)

(defstruct (soar-times (:print-function print-soar-times))
  (real 0)           (start-real 0)
  (run 0)            (start-run 0)
  (chunk 0)          (start-chunk 0)
  (decide 0)         (start-decide 0)
  (sp    0)          (start-sp 0)
  (sptop 0)          (start-sptop 0)
  (reorder 0)        (start-reorder 0)
  (ptorete 0)        (start-ptorete 0)
  (match 0)          (start-match 0)
  (add-to-wm 0)      (start-add-to-wm 0)
  (remove-from-wm 0) (start-remove-from-wm 0)
  (rhs 0)            (start-rhs 0)
  (cs  0)            (start-cs 0)
  (rete 0)           (start-rete 0)
)


;;;
;;;		III.	*Soar-times* global variable
;;;

(defvar *soar-times* (make-soar-times)
  "A defstruct full of times for the modules and submodules of soar.")


;;;
;;;		IV.	Internal-time-into-seconds
;;;

(defmacro internal-time-into-seconds (time)
  `(/ (float ,time) internal-time-units-per-second))


;;;
;;;		V.	Print-soar-times
;;;
;;; I've decided on an initial strategy of isolating calls
;;; across each module. This means that the chunking time
;;; won't include the parsing time, or the reorderer time, ... .
;;; If we need across module cumulative times they can be
;;; added later.

(defmacro print-a-time (time message)
  (let ((field (intern (concatenate 'string "SOAR-TIMES-" (symbol-name time))))
	(start (intern (concatenate 'string "SOAR-TIMES-START-" (symbol-name time)))))
  `(unless (zerop (,field soar-times))
     (format stream ,message 
	     (,field soar-times) 
	     (internal-time-into-seconds (,field soar-times)))
     (unless (zerop (,start soar-times))
       (format stream "~% Error: ~A start is not zero." ',field)))))

(defmacro print-a-time-percentage (units message &optional field-name)
  ;; Rewrote. -BGM 4/19/89
  `(progn
     (format stream "~%~2T~A~24T~9D units~40T~14,3F sec~65T~6,2F % run"
	     ,message 
	     ,units
	     (internal-time-into-seconds ,units)
	     (if (zerop (soar-times-run soar-times)) 0.0
		    (* 100.0 (/ (float ,units) (float (soar-times-run soar-times))))))
     ,(when field-name
	`(unless (zerop (,(intern (concatenate 'string "SOAR-TIMES-START-" (symbol-name field-name)))
			 soar-times))
	  (format stream "~% Error: ~A start is not zero." ',field-name)))))
	   
(defun print-soar-times (soar-times stream print-level)
  ;; Rewrote. BGM 4/19/89
  (declare (ignore print-level))
  (setf (soar-times-rete soar-times) 
	(+ (soar-times-add-to-wm soar-times)
	   (soar-times-remove-from-wm soar-times) 
	   (soar-times-sptop soar-times)
	   (soar-times-reorder soar-times)
	   (soar-times-ptorete soar-times)
	   (soar-times-rhs soar-times)
	   (soar-times-cs soar-times)
	   ))
  (format stream "~%~40TSoar Times")
  (print-a-time-percentage (soar-times-real soar-times) "Real elapsed time" real)
  (print-a-time-percentage (soar-times-run soar-times) "Real run time" run)
  (print-a-time-percentage (soar-times-chunk soar-times) "Chunk" chunk)
  (print-a-time-percentage (soar-times-decide soar-times) "Decide" decide)
  (print-a-time-percentage (soar-times-rete soar-times) "RETE" rete)
  (print-a-time-percentage (soar-times-sp soar-times) " all of Sp" sp)
  (print-a-time-percentage (soar-times-SptoP soar-times) " SptoP" SptoP)
  (print-a-time-percentage (soar-times-reorder soar-times) " Reorder"    reorder)
  (print-a-time-percentage (soar-times-ptorete soar-times) " Ptorete+Codegen" ptorete)
  (print-a-time-percentage (soar-times-match soar-times) " match" match)
  (print-a-time-percentage (soar-times-add-to-wm soar-times) " add-to-wm" add-to-wm)
  (print-a-time-percentage (soar-times-remove-from-wm soar-times) " remove-from-wm" remove-from-wm)
  (print-a-time-percentage (soar-times-rhs soar-times) " rhs execution" rhs)
  (print-a-time-percentage (soar-times-cs soar-times) " cs" cs)
  (let ((units
	  (+ (soar-times-chunk soar-times) (soar-times-decide soar-times) 
	     (soar-times-rete soar-times))))
    (print-a-time-percentage units "(+ Chunk Decide RETE)")
    (print-a-time-percentage (- (soar-times-run soar-times) units) "Timing Error")))




;;;
;;;		VI.	Start-soar-time
;;;
;;; Start soar time takes a field name and initializes its -start field
;;; equivalent with the internal-real or run -time. When stop-soar-time
;;; is called on the same field, it deposits the difference in the
;;; actual field. 
;;;

(defmacro start-soar-time-error (soar-times)
  `(let ((C (or (not (zerop (soar-times-start-add-to-wm ,soar-times)))
		(not (zerop (soar-times-start-remove-from-wm ,soar-times)))
		(not (zerop (soar-times-start-sptop ,soar-times)))
		(not (zerop (soar-times-start-reorder ,soar-times)))
		(not (zerop (soar-times-start-ptorete ,soar-times)))
		(not (zerop (soar-times-start-rhs ,soar-times)))
		(not (zerop (soar-times-start-cs ,soar-times)))))
	 (B (not (zerop (soar-times-start-chunk ,soar-times))))
	 (A (not (zerop (soar-times-start-decide ,soar-times)))))
     (when (or (and a b) (and a c) (and c b))
	   (error "~% Error in start-soar-time more than one of Decide ~A Chunk ~A ~
                    { sptop reorder ptorete rhs or cs } ~A on." a b c))))
  
(defmacro start-soar-time (field) 
  (let ((start (intern (concatenate 'string "SOAR-TIMES-START-" (symbol-name field)))))
  `(block nil
;  (unless (zerop (,start *soar-times*))
;	(error "Start-soar-time: Attempt to start time ~A which is already running." ',field))
     ,(if (eq field 'real)
	  `(setf (,start *soar-times*) (get-internal-real-time))
	`(setf (,start *soar-times*) (get-internal-run-time)))
     (start-soar-time-error *soar-times*)
     )))


;;;
;;;		VII.	Stop-soar-time
;;;
;;; Stop soar time takes a field name and increments the amount of 
;;; internal run [real] time stored in the -start field into the total count.
;;;

(defmacro stop-soar-time (field) 
  (let ((start (intern (concatenate 'string "SOAR-TIMES-START-" (symbol-name field))))
	(total (intern (concatenate 'string "SOAR-TIMES-" (symbol-name field)))))
    (if (eq field 'real)
	`(block nil
		(when (zerop (,start *soar-times*))
		      (error "Stop-soar-time: attempt to stop time ~A which was not running." ',field))
		(incf (,total *soar-times*)
		      (- (get-internal-real-time) (,start *soar-times*)))
		(setf (,start *soar-times*) 0))
      `(block nil
	      (when (zerop (,start *soar-times*))
		    (error "Stop-soar-time: attempt to stop time ~A which was not running." ',field))
	      (incf (,total *soar-times*)
		    (- (get-internal-run-time) (,start *soar-times*)))
	      (setf (,start *soar-times*) 0)))))




;;;
;;;		VIII.	Pause-soar-time
;;;
;;;	This macro, when given a time field, checks if it is running.
;;; If so it pauses and restarts it, otherwise it does nothing.
;;; Caution: this does not return the same value as the other form.
;;;

(defmacro pause-soar-time (field &body body)
  (let ((start (intern (concatenate 'string "SOAR-TIMES-START-" (symbol-name field))))
	(running (gensym)))
    `(let ((,running (not (zerop (,start *soar-times*)))))
       (when ,running (stop-soar-time ,field))
       ,@body
       (when ,running (start-soar-time ,field)))))

)


;;;
;;;		IX.	Initialize-soar-time
;;;

(defun initialize-soar-time ()  
  #+:soar-times(setq *soar-times* (make-soar-times))
)


;;;
;;;		X.	Restart-soar-time
;;;

(defun restart-soar-time ()
  #+:soar-times (setq *soar-times* (make-soar-times))
  (setq *elapsed-time* 0)
)


	

;;; Concatenated from type module "utility" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/utility/new/output.lisp".
;;; -*-mode: lisp; package: user -*-
;;;
;;;
;;;	Soar: Module UTILTITY submodule output
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements all content generic output functions.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	I.	Soar-format's descriptions
;;;	II.	soar-line-length
;;;	III.	soar-line-position
;;;	IV.	soar-format
;;;	V.	ms-soar-princ
;;;	VI.	wrapping-soar-format
;;;	VII.	soar-nspaces
;;;	VIII.	do-tabto
;;;	IX.	Soar's files
;;;	X.	Initialize-soar-files
;;;	XI.	Soar-file-p
;;;	XII.	open-Soar-file
;;;	XIII.	close-Soar-file
;;;	XIV.	Openfile1
;;;	XV.	Closefile1
;;;	XVI.	Default
;;;	XVII.	Accept
;;;	XVIII.	Write1&2
;;;	XIX.	CRLF
;;;	XX.	Rjust
;;;	XXI.	Tabto
;;;	XXII.	Restart-soar-output
;;;

(in-package "SOAR")



(eval-when (eval load)
  ;; I don't think that we should be messing with this. -BGM 
  ;;; Do not print a decimal point after integers
  (setq *print-radix* nil))


;;;
;;;		I.	Soar-format's description
;;;
;;;	Soar-format should be used for ALL soar-output. Soar-format uses
;;; format to actually generate the strings, see the common lisp manual.
;;; Soar-format keeps the *soar-line-length*, or number of characters on that line,
;;; updated for all output actions. Using Soar-format should be faster than
;;; the loads of spurious little IO calls we had in the past. Soar-format
;;; should be easier to read than scads of little calls. Ms-soar-princ
;;; should be used for any IO calls that print something that should be
;;; mouse selectable in the Graphic Interface, such as a pname, time-tag or
;;; object (gensym).
;;;
;;;	Soar-format expects that the default output stream is T, so that it
;;; can tell where to print things in the. If the sgi is installed and
;;; soar-format gets a T (or a text-window) for a stream then it prints
;;; to the appropriate text window(s). If soar-format gets a nil, it
;;; returns the finished output string, but does not print it.
;;; If soar-format gets any other file, it prints to there 
;;; (such as a trace-file or the write-file).
;;;




;;;
;;;		II.	Soar-line-length
;;;

(defvar *soar-line-length* 76 "The width of the output line for Soar.")

(defun soar-line-length (&optional (stream t))
  ;; Added the declare ignore. -BGM 1/27/89
  ;; Added . -BGM 12/7/88
  (declare (ignore stream))
   *soar-line-length*)

(eval-when (compile eval load) (proclaim '(fixnum *soar-line-length*)))


;;;
;;;		III.	Soar-line-position
;;;

(defvar *soar-cursor-position* 0 "The column 0 that the Soar cursor is on.")

(defun soar-line-position (&optional (stream t)) 
  ;; Added  -BGM 12/7/88
  (declare (ignore stream))
  *soar-cursor-position*)


;;;
;;;		IV.	Soar-format
;;; It occurs to me that we could gain some speed if we were to make a 
;;; soar-princ and then use that from a soar-format. -BGM 11/11/88.
  
;;;
;;;****************************************************************************
;;; Global variables. 
;;; Variables that should be set by users have associated macros.
;;;****************************************************************************

(defvar *edt* nil)                       ;Turns this code on or off.
(defvar *event-sequence* nil)          ;((t1 a1)(t2 a2)(t3 a3)...(tn an))
(defvar *current-timed-operator* nil)  ;Grabbed at decision.
(defvar *operator-times* nil)          ;((o1 t1)(o2 t2)(o3 t3)...)
(defvar *print-times* nil)             ;Allows printing of times.
(defvar *print-events* nil)            ;Allows printing of events.
(defvar *time* 0)                      ;Current time at decision.
(defvar *printing-time* nil)           ;Times are at far left of display.
(defvar *time-unit* "msec")            ;May be "" too.
(defvar *soar-trace-tabto* 16)         ;Where Soar trace tabbed to.
(defvar *last-printed-time* nil)       ;So decided operator can be on same line
				       ; as time of decision.
(defvar *time-last-printed* -1000000)  ;A little confusing. Above is to signal
				       ; that the last thing printed was a
				       ; time. This variable keeps the actual
				       ; value of the time printed so that 
                                       ; double printing can be avoided.

               

;;;*****************************************************************************
;;; Function: soar-format
;;; Description: Modified so that, if the *edt* option is selected,
;;; the Soar trace is printed with times on the far left-hand side and the
;;; usual Soar output and events are printed indented by *soar-trace-tabto*
;;; spaces.
;;;*****************************************************************************

(defun soar-format (stream control-string &rest arguments)
  ;; Rebound *print-pretty* -- 20-Dec-89 TFMcG
  ;; Modified to return the string for nil streams. BGM 9/8/88
;;; History: MDW; 4-17-90; *cycler-status* checked in soar-format.
  (declare (simple-string control-string))
  (let ((*print-pretty* nil))
    (declare (special *print-pretty*))
    
    (let ((string (apply #'format nil control-string arguments)))
      (declare (simple-string string))
      
      ;; Below are changes for EDT code.
      
      (when (and (eq *cycler-status* 'cycling)  ;Added check MDW 4-18-90.
	         stream           ;Skip if nil and return string below as before.
		 *edt*            ;EDT is on.
		 *print-times*
		 (null *printing-time*))
	
	(let ((text-stream (make-string-output-stream))
	      (format-stream (make-string-output-stream))
	      )
	  
	  (cond ((and (> (length string) 0)
		      (eq (char string 0) #\newline))
		 (cond (*last-printed-time*    ;Ignore Soar newline for decided operator.
			(setq *last-printed-time* nil)
			(format format-stream "~A~D~A" "~" (- *soar-trace-tabto* *soar-cursor-position*) "@T~A"))
		       (t
			(format format-stream "~A~D~A" "~%~" *soar-trace-tabto* "@T~A"))))
		(t
		 (format format-stream "~A~D~A" "~" (- *soar-trace-tabto* *soar-cursor-position*) "@T~A")))

	  (format text-stream (get-output-stream-string format-stream) (string-left-trim '(#\newline) string))
      
	  (setq string (get-output-stream-string text-stream))))
      
      (when *printing-time*
	(setq *last-printed-time* t))
      
      ;; End changes for Soar-EDT.
      
      (cond ((null stream)		; Just return the string, as format does.
	     string)
	    
	    (t
	     ;; Send all output by default to *standard-output*.

	    (princ string (if (eq stream t) *standard-output* stream))
	     (let ((position-of-last-newline (position #\newline string :from-end t :test #'char=)))
	       (cond (position-of-last-newline
		      (setq *soar-cursor-position* (- (length string) position-of-last-newline 1))
		      ;; Force lisp to finish the print if there is a CR in it.
		      (force-output))
		     (t (incf *soar-cursor-position* (length string)))))
	     *soar-cursor-position*)))))



;;;
;;;		V.	ms-soar-princ
;;;

(defun ms-soar-princ (stream symbol-or-integer ms-type)
  ;; Added s. -BGM 12/7/88
  (declare (ignore ms-type))
  (declare (type (or symbol integer) symbol-or-integer))
  (cond (t
	  ;; Send all output by default to *standard-output*.
	  (let ((string (princ-to-string symbol-or-integer)))
	    (declare (simple-string string))
	    (princ string (if (eq stream t) *standard-output* stream))
	    (let ((position-of-last-newline (position #\newline string :from-end t :test #'char=)))
	      (cond (position-of-last-newline
		      (setq *soar-cursor-position* (- (length string) position-of-last-newline 1))
		      ;; Force lisp to finish the print if there is a CR in it.
		      (force-output))
		    (t (incf *soar-cursor-position* (length string)))))
	    *soar-cursor-position*))))


;;;
;;;		VI.	Wrapping-soar-format
;;;

(defun wrapping-soar-format  (stream tab control-string &rest arguments)
  ;; Added  -BGM 12/7/88
  ;; Created to make SPM printing easier and faster. 
  ;; This is just like Soar-format, except it will optionally insert a carriage
  ;; return before the start of any string that will wrap. -BGM 10/27/88.
  ;; Added tab, a fixnum, that determines how many spaces to print after a 
  ;; wrapping carriage return. -BGM 10/28/88
  (declare (simple-string control-string))
  (let* ((string (apply #'format nil control-string arguments))
	 (position-of-first-newline (position #\newline string :test #'char=)))
   (declare (simple-string string))
   (cond ((null stream) ; Just return the string, as format does.
	  string)
	 (t
	   (let ((stream (if (eq stream t) *standard-output* stream))
		 (position-of-last-newline (position #\newline string :from-end t :test #'char=)))
	     (when (> (or position-of-first-newline (length string)) (- *soar-line-length* *soar-cursor-position*))
	       (terpri stream) (dotimes (i tab) (princ " " stream))
	       (setq *soar-cursor-position* tab))
	      ;; Send all output by default to *standard-output*.
	     (princ string stream)
	     (cond (position-of-last-newline
		     (setq *soar-cursor-position* (- (length string) position-of-last-newline 1))
		     ;; Force lisp to finish the print if there is a CR in it.
		     (force-output))
		   (t (incf *soar-cursor-position* (length string)))))
	    *soar-cursor-position*))))


;;;
;;;		VII.	Soar-nspaces
;;;

(defun soar-nspaces (n stream) (dotimes (i n) (soar-format stream " ")))


;;;
;;;		VIII.	Do-tabto
;;;

(defun do-tabto (col port) 
 ;; Fixed a fencepost error by adding 1+ to slp call. -BGM 11/9/88
 ;; Updated old style IO to soar-format. -BGM 8/18/88
 ; Randy.Gobbel 12-Sep-86 12:17 
 (prog (pos)
   (setq pos (1+ (soar-line-position port)))
   (cond ((> pos col)
         (soar-format port "~%")
         (setq pos 1)))
     (do ((k (- col pos) (1- k)))
	 ((not (> k 0)))
       (soar-format port " "))
     (return nil)))


;;;
;;;		IX.	Soar's files
;;;

(defvar *accept-file* t 
  "The file from which accept reads input from. T means *standard-input*.")

(defvar *trace-file*  t
 "The file that collects the trace output. T means *standard-output*.")
    
(defvar *write-file*  t
 "The file to which write1 & write2 output. T means *standard-output*.")


;;;
;;;		X.	Initialize-soar-files
;;;

(defvar *soar-open-files* ()
 "An assoc list mapping Soar file name to stream object, and vice versa.")
 
(defun initialize-soar-files ()
 (setq *accept-file* t)
 (setq *trace-file*  t)
 (setq *write-file*  t)
 (dolist (file-name.stream *soar-open-files*)
  (let ((file-name (car file-name.stream)))
   (multiple-value-bind (stream direction) (Soar-file-p file-name)
      (close stream)
      (remprop file-name direction))))
 (setq *soar-open-files* nil)
)

;;;
;;;		XI.	Soar-file-p
;;;

;;; A defun which acts as a pseudo predicate that returns
;;; the stream of a Soar-file and its direction.

(defun Soar-file-p (name)
 (when (symbolp name) 
   (let ((output-file (get name :output)))
    (if output-file
      (values output-file :output)
      (let ((input-file (get name :input)))
	(when input-file
	  (values input-file :input)))))))


;;;
;;;		XII.	open-Soar-file
;;;

(defun open-Soar-file (name path direction)
  ;; Updated for Franz Inc's allegro. -BGM 
  (cond ((not (symbolp name))
	 (soar-format *trace-file* "~% Warning: illegal name for a Soar file, ~A." name)
	 nil)
	((not (or (symbolp path) (stringp path)))
	 (soar-format *trace-file* "~% Warning: illegal path for a Soar file, ~A." path)
	 nil)
	((not (member direction '(in out) :test #'eq))
	 (soar-format *trace-file* "~% Warning: illegal direction for a Soar file, ~A."
		      direction) nil)
	((Soar-file-p name)
	 (soar-format *trace-file* "~% Warning: file already open, ~A." name))
	(t (let* ((direction (if (eq direction 'in) :input :output))
		  (stream (open path :direction direction :if-exists #-:allegro :new-version
				                                     #+:allegro :supersede)))
	     (setq *soar-open-files* (acons name stream *soar-open-files*))
	     (setf (get name direction) stream)
	     stream))))


;;;
;;;		XIII.	close-Soar-file
;;;

(defmacro check-soar-stream (name variable stream)
  `(when (eq ,variable ,stream)
     (setq ,variable t)
     (soar-format *trace-file* 
       "~%Warning: Closing current ~A file; executing a (default nil ~A)."
		  ',name ',name)))

(defun close-Soar-file (name)
  (multiple-value-bind (stream direction) (soar-file-p name)
   (cond (stream
	   (setq *soar-open-files* (remove name *soar-open-files* :key #'car))
	   (remprop name direction)
	   (close stream)
	   (check-soar-stream accept *accept-file* stream)
	   (check-soar-stream trace *trace-file* stream)
	   (check-soar-stream write *write-file* stream)
	   t)
	 (t (soar-format *trace-file* "~% Warning: illegal file name for close, ~A." 
			 name)))))


;;;
;;;		XIV.	Openfile1
;;;

(defmacro openfile1 (&rest name-path-direction)
 `(compiled-openfile1 (eval-args ',name-path-direction)))

(defun compiled-openfile1 (name-path-direction)
 (if (= (length name-path-direction) 3)
     (apply #'open-soar-file name-path-direction)
     (soar-format *trace-file* "~% Warning: wrong number of arguments to openfile1."))
 nil)


;;;
;;;		XV.	Closefile1
;;;

(defmacro closefile1 (&rest file-names)
  `(mapc #'close-soar-file (eval-args ',file-names)))


;;;
;;;		XVI.	Default
;;;

(defmacro default (&rest file-trace-accept-or-write)
  `(compiled-default (eval-args ',file-trace-accept-or-write)))

(defmacro set-soar-stream (name desired-direction stream direction variable)
  `(cond ((or (null ,direction) (eq ,direction ,desired-direction))
	  (setq ,variable ,stream))
	 (t (soar-format *trace-file* "~% Warning: bad file direction for ~A default."
			 ',name))))

(defun compiled-default (file-trace-accept-or-write)
 (if (/= (length file-trace-accept-or-write) 2)
   (soar-format *trace-file* "Warning: wrong number of arguments to default, ignored.")
   (let ((file (first file-trace-accept-or-write))
	 (trace-accept-or-write (second file-trace-accept-or-write)))
     (multiple-value-bind (stream direction) 
      (if (null file) (values t nil) (Soar-file-p file))
      (cond (stream 
	     (case trace-accept-or-write
	      (write 
		(set-soar-stream write :output stream direction *write-file*))
	      (trace 
		(set-soar-stream trace :output stream direction *trace-file*))
	      (accept
		(set-soar-stream accept :input stream direction *accept-file*))
	      (otherwise 
		(soar-format *trace-file* 
		 "Warning: bad default name, ~A, not accept, write or trace."
		 trace-accept-or-write))))
	     (t (soar-format *trace-file* "Warning: bad file name, ~A." file)))))))


;;;
;;;		XVII.	Accept
;;;

(defmacro #-:symbolics accept #+:symbolics soar-accept
  (&rest list-of-file-name)
  ;; Moderinized. -BGM 2/12/89
  ;; rg 11/19/86: accept moved from main file so eof can work properly
  ;; BGM 3/30/88: #+'d the symbolics otherwise the symbolics failes
  ;; horribly when you install this.
  `(compiled-accept (eval-args ',list-of-file-name)))

(defun compiled-accept (list-of-file-name)
  ;; Modernized. BGM 2/14/89.
  ;; Added *soar-end-of-file* catch to read. -BGM 2/12/89
  (cond ((> (length list-of-file-name) 1)
	 (soar-format *trace-file* 
	   "~% Warning: wrong number of arguments to accept. ~
             Reading as a nil.")
	 nil)
	(list-of-file-name
	  (let ((file-name (first list-of-file-name)))
	    (multiple-value-bind (stream direction) (Soar-file-p file-name)
	     (cond (stream
		     (cond ((eq direction :output)
			    (soar-format *trace-file* 
			     "~% Warning: accept given an output stream, ~A. ~
                             Reading as a nil." file-name)
			    nil)
			   (t (read-accept stream file-name))))
		   (t (soar-format *trace-file* 
			"~% Warning: accept given a bad file name, ~A. ~
                            Reading as a nil." file-name))))))
	(t (read-accept *accept-file* 'default))))

(defparameter *soar-end-of-file* (gensym "END-OF-FILE")
  "A read stopping symbol used by accept.")

(defun read-accept (stream file-name)
  ;;; Removed list call around flat-value. -BGM 18-Apr-90

  #+:soar-times (stop-soar-time real)
  #+:soar-times (stop-soar-time run)
  #+:soar-times (stop-soar-time rhs)
  (stop-elapsed-time)
  (prog1 
      (let ((read (read stream nil *soar-end-of-file*)))
	(cond ((eq read *soar-end-of-file*)
	       (soar-format *trace-file*
		 "~%ACCEPT: read beyond end of file, reading as nil."
		 file-name)
	       nil)
	      (t (flat-value read))))
    (start-elapsed-time)
    #+:soar-times (start-soar-time rhs)
    #+:soar-times (start-soar-time real)
    #+:soar-times (start-soar-time run)
    ))


;;;
;;;		XVIII.	Write1&2
;;;

(defmacro write1 (&rest write-items)
  ;; Modernized. -BGM 2/12/89
  `(compiled-write1 (eval-args ',write-items) t))

(defmacro write2 (&rest write-items)
  ;; Modernized. -BGM 2/12/89
  `(compiled-write1 (eval-args ',write-items) nil))

(defun compiled-write1 (write-items write1)
 ;; Rewrote. -BGM 2/14/89
 ;; Updated old style IO to soar-format. -BGM 8/18/88
  (cond (write-items
	  (let ((stream (or 
			  (multiple-value-bind (stream direction)
			    (Soar-file-p (car write-items))
			    (when (and stream (eq direction :output))
			      (pop write-items) stream))
			  *write-file*))
		(needspace t))
	    (loop 
	      (unless write-items (return t))
	      (let ((write-item (pop write-items)))
		(case write-item
		  (crlf (setq needspace nil) (soar-format stream "~%"))
		  (rjust 
		    (do-rjust (pop write-items)
			      (pop write-items) stream))
		  (tabto 
		    (setq needspace nil) 
		    (do-tabto (pop write-items) stream))
		  (otherwise
		    (when (and needspace write1) (soar-format stream " "))
		    (setq needspace t)
		    (soar-format stream "~A" write-item)))))))
	(t (soar-format *trace-file* (if write1
			      "~% Write1: nothing to write."
			    "~% Write2: nothing to write.")))))


;;;
;;;		XIX.	CRLF
;;;

(defmacro crlf (&rest z)
	  (list 'nlam-crlf (list 'quote z)))

(defun nlam-crlf (z) ; Randy.Gobbel 17-Jun-86 15:31 
       (cond (z (soarwarn "CRLF: Does not take arguments" z))
	     (t '(crlf))))


;;;
;;;		XX.	Rjust
;;;

(defmacro rjust (&rest z)
  (list 'nlam-rjust (list 'quote z)))

(defun nlam-rjust (z) ; Randy.Gobbel 11-Sep-86 15:31 
  (prog (val)
	(cond ((not (eqp (length z) 1))
	       (soarwarn "RJUST: Wrong number of arguments" z)
	       (return nil)))
	(setq val ($varbind (car z)))
	(cond ((or (not (numberp val))
		   (< val 1)
		   (> val 127))
	       (soarwarn "RJUST: Illegal value for field width" val)
	       (return nil)))
	(return (list 'rjust val))))

(defun do-rjust (width value port) 
 ;; Updated old style IO to soar-format. -BGM 8/18/88
  ; Randy.Gobbel 12-Sep-86 12:08 
       (prog (size)
	     (cond ((equal value "=== T A B T O ===")
		    (soarwarn "Rjust cannot precede this function"
			      'tabto)
		    (return nil))
		   ((equal value "=== C R L F ===")
		    (soarwarn "Rjust cannot precede this function"
			      'crlf)
		    (return nil))
		   ((equal value "=== R J U S T ===")
		    (soarwarn "Rjust cannot precede this function"
			      'rjust)
		    (return nil)))
	     (setq size (length (the string (format nil "~A" value))))
	     (cond ((> size width)
		    (soar-format port " ")
		    (soar-format port value)
		    (return nil)))
	     (do ((k (- width size)
			  (1- k)))
		      ((not (> k 0)))
		      (soar-format port ")"))
	     (soar-format port value)))

;;;
;;;		XXI.	Tabto
;;;

(defmacro tabto (&rest z)
  (list 'nlam-tabto (list 'quote z)))

(defun nlam-tabto (z) ; Randy.Gobbel 11-Sep-86 15:32 
  (prog (val)
	(cond ((not (eqp (length z) 1))
	       (soarwarn "TABTO: Wrong number of arguments" z)
	       (return nil)))
	(setq val ($varbind (car z)))
	(cond ((or (not (numberp val))
		   (< val 1))
	       (soarwarn "TABTO: Illegal column number" val)
	       (return nil)))
	(return (list val 'tabto))))


;;;
;;;		XXII.	Restart-soar-output
;;;

(defun restart-soar-output ()
  (initialize-soar-files)
  )


;;;
;;;		XXIII.	Initialize-soar-output
;;;

(defun initialize-soar-output ()
  nil
  )

;;; Concatenated from type module "utility" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/utility/new/soargensym.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	Gensym.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/utility/new/gensym.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file implements a gensym package for Soar. 
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Defstruct soar-gensyms & *soar-gensyms*
;;;	II.	Soar-genid
;;;	III.	Soar-genvar
;;;	IV.	Initialize-Soar-genvar
;;;	IV.	Soar-genpname
;;;	V.	Restart-Soar-genpname
;;;	VI.	Release-Soar-pname
;;;	VII.	Initialize-Soar-gensyms
;;;	VIII.	Hash-id
;;;	IX.	First-character-of
;;;	X.	Insert
;;;	XI.	Restart-soar-gensysms
;;;	XII.	Initialize-Soar-genid
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")


;;;
;;;		I.	Defstruct soar-gensyms & *soar-gensyms*
;;;

(defstruct soar-gensyms
  (count 0)         ;; A counter to use in the generation of ids and pnames.
  (ids nil)         ;; The list of the ids generated so far.
  (free-ids    (make-array char-code-limit :initial-element nil))
                    ;; An array of lists of the free ids by character.
  (pnames nil)      ;; The list of the pnames generated so far.
  (free-pnames nil) ;; The list of pnames that are now free.
  (variables nil)   ;; The list of variables generated so far.
  (variable-counters (make-array char-code-limit :initial-element 0))
  ;; An array that keeps a count of the number of variables generated that start with a particular
  ;; character.
  )

(defvar *soar-gensyms* (make-soar-gensyms) "A defstruct holding state for Soar gensym generation.")


;;;
;;;		II.	Soar-genid
;;;

(eval-when (compile eval load) (proclaim '(special *cycle-count*)))

(defun soar-genid (symbol-or-character)
  ;; now interns into the user package rather than wherever the user is running
  ;; Fixed by FR Bug ID  30Jan91-14.27.22
 (let* ((first-character (first-character-of symbol-or-character))
        (symbol (or (pop (svref (soar-gensyms-free-ids *soar-gensyms*)
                                (char-code first-character)))
                    (intern (concatenate 'string
					 (make-string 1 :initial-element first-character)
					 (write-to-string
					  (incf (soar-gensyms-count *soar-gensyms*))))
			    (or (find-package "COMMON-LISP-USER")
				(find-package "USER")) ))) )
   ;; Store the symbol so that it can have its properties cleared.
   (push symbol (soar-gensyms-ids *soar-gensyms*))
   (setf (get symbol 'gensymed) (hash-id symbol))
   ;; Give the RETE a hash index.
   (setf (get symbol 'wmpart*) nil)
   ;; Give the RETE a wmpart* property off of which to hang WMES of this ID.
   symbol))


;;;
;;;		III.	Soar-genvar
;;;

(defun soar-genvar (symbol-or-character)
 (let* ((character (first-character-of symbol-or-character))
        (symbol (intern 
		 (concatenate 'string 
		   "<"
		   (make-string 1 :initial-element character)
		   (write-to-string (incf (svref (soar-gensyms-variable-counters *soar-gensyms*)
						 (char-code character))))
		   ">"))))
   (soarclearprops symbol) 
   ;; This clearprops should not be required but is in the old code.
   (push symbol (soar-gensyms-variables *soar-gensyms*))
   symbol))


;;;
;;;		IV.	Initialize-Soar-genvar
;;;

(eval-when (compile eval load) (proclaim '(special *learn-ids*)))

(defun initialize-soar-genvar ()
  ;; Clear the properties of the variables.
  (mapc #'soarclearprops (soar-gensyms-variables *soar-gensyms*))
  ;; Release the list of variable gensyms.
  (setf (soar-gensyms-variables *soar-gensyms*) nil)
  ;; Reinitialize the array of counters.
  (let ((variable-counters (soar-gensyms-variable-counters *soar-gensyms*)))
    (dotimes (i char-code-limit)
      (setf (svref variable-counters i) 0)))
  t)


;;;
;;;		IV.	Soar-genpname
;;;

(defun soar-genpname (symbol-or-character)
  ;; now interns into the user package rather than wherever the user is running
  ;; Fixed by FR Bug ID  30Jan91-14.27.22
  (cond
    ((soar-gensyms-free-pnames *soar-gensyms*)
     (let ((symbol (pop (soar-gensyms-free-pnames *soar-gensyms*))))
       (push symbol (soar-gensyms-pnames *soar-gensyms*))
       (setf (get symbol 'gensymed) t)
       symbol))
    (t
      (let* ((prefix (make-string 1 :initial-element
                                    (first-character-of symbol-or-character)))
             (symbol (loop
                       (multiple-value-bind (symbol previously-existing)
                          (intern (concatenate 'string
                                     prefix
                                    (write-to-string (incf (soar-gensyms-count *soar-gensyms*))))
                                  (or (find-package "COMMON-LISP-USER")
                                      (find-package "USER")))
                          (unless (and previously-existing
                                      (get-p symbol))
                                      (return symbol))))))
            (push symbol (soar-gensyms-pnames *soar-gensyms*))
            (setf (get symbol 'gensymed) t)
            ;; Note that this is a gensym. I'm not sure who uses this.
            symbol))))


;;;
;;;		V.	Restart-Soar-genpname
;;;
;;;	Suitable for calling when you are deleting all of the productions like in
;;; Restart-soar.

(defun Restart-soar-genpname ()
  (dolist (pname (soar-gensyms-free-pnames *soar-gensyms*)) (remprop pname 'gensymed))
  (setf (soar-gensyms-free-pnames *soar-gensyms*) nil)
  (dolist (pname (soar-gensyms-pnames *soar-gensyms*)) (remprop pname 'gensymed))
  (setf (soar-gensyms-pnames *soar-gensyms*) nil)
  t)


;;;	
;;;		VI.	Release-Soar-pname
;;;
;;;	Release a single Pname, carefully to keep the pname generation ordering
;;; the same.

(defun release-Soar-pname (pname)
  (setf (soar-gensyms-pnames *soar-gensyms*)
	(delete pname (soar-gensyms-pnames *soar-gensyms*) :test #'eq))
  (remprop pname 'gensymed)
  (setf (soar-gensyms-free-pnames *soar-gensyms*)
	(insert pname (soar-gensyms-free-pnames *soar-gensyms*) #'string<
		:key #'symbol-name)))


;;;
;;;		VII.	Initialize-Soar-gensyms
;;;
;;;	 Clear the ID's and the variables, but not the Pnames.

(defun initialize-Soar-gensyms ()
  (initialize-Soar-genid)
  (initialize-Soar-genvar)
  t)


;;;
;;;		VIII.	Hash-id
;;;
;;;	Hash-id maps a Soar-gensym to a number used to hash it in the RETE.
;;; Each Soar-gensym has its hash-id stored on its gensymed property.
;;; *Mem-array-size* is the size of the alpha memory hash tables.
;;;

(eval-when (compile eval load) (proclaim '(special *mem-array-size*)))

(defun hash-id (id) (rem (subnumber id) *mem-array-size*))


;;;
;;;		IX.	First-character-of
;;;
;;; First character of finds the first character of a symbol or a character,
;;; or signals an error.
;;;

(defun first-character-of (symbol-or-character)
  (if (characterp symbol-or-character) 
      symbol-or-character
    (if (symbolp symbol-or-character)
	(let ((symbol-name (symbol-name symbol-or-character)))
	  (when (zerop (length (the simple-string symbol-name)))
	   (error "First-character-of given a symbol with an empty name, ||."))
	  (schar symbol-name 0))
      (error "First-character-of given a bad argument, ~A." symbol-or-character))))


;;;
;;;		X.	Insert
;;;
;;; Destructively insert a new item in a list of items.
;;;

(defun insert (item list test &key (key #'identity))
  ;; { List is ordered by test }
  (let ((key-item (funcall key item)))
    (cond ((null list) (list item))
	  ( ;; { (not (null list)) }
	   (funcall test key-item (funcall key (first list)))
	   ;; { (not (null list)) and (test item (first list)) }
	   (cons item list)
	   )
	  (t ;; Invarient:  { (not (test key-item (key (first previous-cons)))) }
	    (do ((previous-cons list          (cdr previous-cons))
		 (current-cons  (rest list) (cdr current-cons)))
		((null current-cons)
		 ;; { Forall l in list (not (test key-item l))}
		 (setf (cdr previous-cons) (cons item nil))
		 list)
		(when (funcall test key-item (first current-cons))
		 (setf (cdr previous-cons) (cons item current-cons))
		 (return list))))))
  ;; New list shares structure with old list, but has item destructively
  ;; inserted before the first element that (not (test item element)).
  )


;;;
;;;		XI.	Restart-soar-gensyms
;;;

(defun restart-soar-gensyms ()
  (restart-soar-genid)
  (restart-soar-genpname)
  (initialize-Soar-genvar) ; Same as for a init and a restart.
  (setf (soar-gensyms-count *soar-gensyms*) 0)
  )


;;;
;;;		XII.	Initialize-soar-genid
;;;

(defun initialize-soar-genid ()
  (mapc #'soarclearprops (soar-gensyms-ids *soar-gensyms*))
  ;; Put all of the gensyms back on the free list.
  (let ((free-ids (soar-gensyms-free-ids *soar-gensyms*)))
  (dolist (id (soar-gensyms-ids *soar-gensyms*))
   (push id (svref free-ids (char-code (schar (symbol-name id) 0))))))
  (setf (soar-gensyms-ids *soar-gensyms*) nil)
  )


;;;
;;;		XIII.	Restart-soar-genid
;;;

(defun restart-soar-genid ()
  (mapc #'soarclearprops (soar-gensyms-ids *soar-gensyms*))
  (let ((free-ids (soar-gensyms-free-ids *soar-gensyms*)))
    (dotimes (i char-code-limit)
      (setf (svref free-ids i) nil)))
  (setf (soar-gensyms-ids *soar-gensyms*) nil)
  )

;;; Concatenated from type module "utility" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/utility/new/consrecycling.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	Consrecycling
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/consrecycling.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file implements a free list of conses for Soar. It
;;; uses one global variable and six functions or macros. This
;;; cons recycling is most important in the RETE because it
;;; rapidly allocates and then deallocates conses.
;;; Some machines, such as the lisp machines may work better 
;;; using a time based (ephemeral) GC than keeping free lists.
;;; However, most standard architectures work better with a free
;;; list. The terminology used is pascal like, with get and dispose
;;; preceeding: cons, list, tree and pushes.
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	Lacunae
;;;	I.	ConsRecycling Variables
;;;	II.	Get-Cons
;;;	III.	Dispose-Cons
;;;	IV.	Get-List
;;;	V.	Dispose-List
;;;	VI.	Dispose-Tree
;;;	VII.	Get-Push
;;;	VIII.	Release-free-conses
;;;	IX.	Get-list-copy
;;;	X.	Initialize-consrecycling
;;;	XI.	Restart-consrecycling
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")
;; moved to top of file for DSM.


;;;
;;;		iv.	Lacunae
;;;
;;;	This package is not widely used in Soar. Even the new SPTOP
;;; parser does not use it extensively and should be tuned up to
;;; dispose lists that it builds and then throws away all at compile time.
;;;



;;;
;;;		I.	ConsRecycling Variables
;;;

(defvar *free-conses* nil
  "The list of free conses, consed onto each other.")



;;;
;;;		II.	Get-Cons
;;;

(defmacro get-cons (thecar cdr)
  (let ((ConsRecyclingCons (gentemp "ConsRecyclingCons")))
    `(cond (*free-conses* 
	     (let ((,ConsRecyclingCons *free-conses*))
	       (setq *free-conses* (cdr *free-conses*))
	       (setf (car ,ConsRecyclingCons) ,thecar)
	       (setf (cdr ,ConsRecyclingCons) ,cdr)
	       ,ConsRecyclingCons))
	   (t (cons ,thecar ,cdr)))))



;;;
;;;		III.	Dispose-Cons
;;;

(defun dispose-cons (cons)
  (assert (consp cons))
  (setf (car cons) nil) ; For readability when you have trouble debugging the free list routines.
  (setf (cdr cons) *free-conses*)
  (setq *free-conses* cons))



;;;
;;;		IV.	Get-List
;;;

(eval-when (compile load eval)
  (defun expand-get-list (arguments)
    ;; Added an enclosing eval-when compile load eval, because this is needed at 
    ;; compile time. -BGM 8/1/88.
    (cond ((null arguments) nil)
	  (t `(get-cons ,(car arguments) ,(expand-get-list (cdr arguments)))))))

;;; Is the expansion condition here right ?

(defmacro get-list (&rest arguments) (expand-get-list arguments))  



;;;
;;;		V.	Dispose-List
;;;
;;;	This initial recursive definition should be replaced
;;; with an iterative one later. Iterative is faster and not all
;;; of the compilers are smart enough to do tail recursion removal
;;; and some will give you stack overflow continuable errors.
;;;

(defun dispose-list (list)
  (cond ((null list) nil)
	((not (consp list)))
	(t
	  (dispose-list (cdr list))
	  (dispose-cons list))))



;;;
;;;		VI.	Dispose-tree
;;;

(defun dispose-tree (tree)
  (cond ((null tree))
	((not (consp tree)))
	(t (dispose-tree (car tree))
	   (dispose-tree (cdr tree))
	   (dispose-cons tree))))



;;;
;;;		VII.	Get-Push
;;;
;;;	This is a push operation that calls get-cons
;;; instead of cons. This should really be written with a 
;;; setf expander, to be a bit cleaner.
;;;

(defmacro Get-Push (form location)
  `(setf ,location (get-cons ,form ,location)))



;;;
;;;		VIII.	Release-free-conses
;;;
;;;	It is generally best to give the conses back to
;;; the garbage collector eventually. The GC can linearize
;;; the pages of conses, while this free list can not.
;;; Appropriate times to call this are restart-soar and
;;; perhaps init-soar.
;;;

(defun release-free-conses () (setq *free-conses* nil))



;;;
;;;		IX.	Get-list-copy
;;;
;;;	Copy a list using conses from the cons free list.

(defun get-list-copy (list)
  (if (consp list)
      (get-cons (car list) (get-list-copy (cdr list)))
    list))


;;;
;;;		X.	Initialize-consrecycling
;;;

(defun initialize-consrecycling () 
  (release-free-conses)
  )


;;;
;;;		XI.	Restart-consrecycling
;;;

(defun restart-consrecycling ()
  (initialize-consrecycling)
  )

;;; Concatenated from type module "utility" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/utility/new/hash.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	hash.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/utility/new/hash.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file implements a bucketing hash table that uses multiple symbolic keys or
;;; numeric keys. This is used by both the SPM printer and the SPO printers. A discussion
;;; below describes the desirability and use of this style of hashing as compared to Common Lisp's
;;; default hashing.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	Discussion
;;;	I.	Make-Soar-hash-table
;;;	II.	Soar-hash-keys-equal
;;;	III.	Soar-gethash
;;;	IV.	Soar-remhash
;;;	V.	Soar-puthash
;;;	VI.	Soar-pushhash
;;;

;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")



;;;
;;;		iv.	Discussion
;;;
;;;
;;;	This hash table implementation is designed to be used in two different but similar printing 
;;; operations. The first is SPM printing and the second is SPO printing. In SPM LHS printing, conditions
;;; are grouped by: sign (- or +), depth of negation, class, id,  attribute and an optional 
;;; value (in DSM optional acceptable preferences are added).
;;; In SPM RHS printing, makes are grouped by: class, id, attribute and value (DSM requires a preference 
;;; preference. 
;;;
;;;	The design of these printers requires a ballance of speed, no storage loss, minimal storage
;;; usage and portability to C. The current algorithms are O(n^2) in time and O(n) in space, all of
;;; which must be reclaimed by the garbage collector. Common Lisp's hash tables are not optimal
;;; for this because they rely on the garbage collector to reclaim the storage, treat their
;;; keys with uknown and probably equal importance.
;;;
;;;	This package implements a bucketing hash table that allows us to reclaim all storage.
;;;
;;;	This file has five external operations:
;;;
;;; Make-soar-hash-table - create a Soar hash-table.
;;; Soar-gethash - check for an entry in a Soar hash-table.
;;; Soar-remhash - checks for an entry in a Soar hash-table, returns it if it finds it,
;;;  and deletes its entry reclaiming storage used in the table.
;;; Soar-puthash - add an entry to a Soar hash-table; a function call style instead of
;;;  a setf style has been used to make this code port more easily to C eventually.
;;; Soar-pushhash - add an entry as a list, or push it onto the list of
;;;  any other entires under those keys.
;;;	


;;;
;;;		I.	Make-Soar-Hash-table
;;;

(defparameter soar-hash-table-size 97  "The default size for a Soar hash-table.") 

(defstruct internal-soar-hash-table 
   (test #'eql)
   (array (make-array (list soar-hash-table-size))))

(defun make-soar-hash-table (&key (test #'eql) (size soar-hash-table-size))
  (make-internal-soar-hash-table :test test :array (make-array (list size))))


;;;
;;;		II.	Soar-hash-keys-equal
;;;
;;; This is a macro for efficiency reasons.
;;;

(defmacro soar-hash-keys-equal (test keys1 keys2)
  (let ((key-ptr-1      (gensym "KEYPTR1"))
	(key-ptr-2      (gensym "KEYPTR2")))
  `(do ((,key-ptr-1 ,keys1 (cdr ,key-ptr-1))
	(,key-ptr-2 ,keys2 (cdr ,key-ptr-2)))
       ((null ,key-ptr-1) (null ,key-ptr-2))
     (unless (funcall ,test (car ,key-ptr-1) (car ,key-ptr-2)) (return nil)))))


;;;
;;;		III.	Soar-gethash
;;;
;;;	This relies upon the Common Lisp implementation to not cons up
;;; &rest lists to be efficient. Now that the CMU lisp seems to have cleaned this
;;; up, I don't know of a single lisp that conses &rest list, so this should
;;; work quite well.
;;; This returns two values: the value found and T iff the entry is found in the table.
;;; The hash table is bucketed with the sxhash of the keys stored first, then the list
;;; of the keys and finally the value.
;;;

(defun soar-gethash (soar-hash-table &rest keys)
  (let* ((sxhash (the fixnum (sxhash keys)))
	 (array (internal-soar-hash-table-array soar-hash-table))
	 (location (rem sxhash (first (array-dimensions array))))
	 (bucket (svref array location))
	 (test (internal-soar-hash-table-test soar-hash-table)))
    (when bucket 
      (dolist (sxhash.keys.items bucket nil)
	(when (and (= (the fixnum (car sxhash.keys.items)) sxhash)
		   (soar-hash-keys-equal test keys (cadr sxhash.keys.items)))
	      (return (values (cddr sxhash.keys.items) t)))))))


;;;
;;;		IV.	Soar-remhash
;;;
;;;	This returns two values: the item and t iff the item was found.
;;; The item is returned so that its storage may be reclaimed.
;;;

(defun soar-remhash (soar-hash-table &rest keys)
  (let* ((sxhash (the fixnum (sxhash keys)))
	 (array (internal-soar-hash-table-array soar-hash-table))
	 (location (rem sxhash (first (array-dimensions array))))
	 (bucket (svref array location))
	 (test (internal-soar-hash-table-test soar-hash-table)))
    ;; Standard double pointer walk down a list to allow
    ;; the destructive modification and reclamation of the list conses.
    (do* ((parent nil (if parent (cdr parent) bucket))
	  (sxhash.keys.item-ptr bucket (cdr sxhash.keys.item-ptr))
	  (sxhash.keys.item (car sxhash.keys.item-ptr) (car sxhash.keys.item-ptr)))
	 ((null sxhash.keys.item-ptr) (values nil nil))
     (when (and (= (the fixnum (car sxhash.keys.item)) sxhash)
		(soar-hash-keys-equal test keys (cadr sxhash.keys.item)))
      (let ((item (cddr sxhash.keys.item)))
	;; Dispose the conses of the key list.
	(dispose-list (cadr sxhash.keys.item))
	;; Dispose the cons linking the keys to the item.
	(dispose-cons (cdr sxhash.keys.item))
	;; Dispose the cons linking the sxhash to the keys.item.
	(dispose-cons sxhash.keys.item)
	(if parent
	  ;; The item is not the first in the bucket, so we must destructively
	  ;; slice it out of the list.
	  (setf (cdr parent) (cdr sxhash.keys.item-ptr))
	  (setf (svref array location) (cdr sxhash.keys.item-ptr))
	  ;; The item to be found is the first item in the bucket, so we must
	  ;; modify the bucket's location.
	  )
	(dispose-cons sxhash.keys.item-ptr)
	;; Dispose the cons pointing to the item's bucket entry.
	(return (values item t)))))))


;;;
;;;		V.	Soar-puthash
;;;
;;; To add a new bucket onto the table, cons the sxhash onto the keys onto the value
;;; and push it onto the array location.
;;;

(defun soar-puthash (soar-hash-table value &rest keys)
  (let* ((sxhash (the fixnum (sxhash keys)))
	 (array (internal-soar-hash-table-array soar-hash-table))
	 (location (rem sxhash (first (array-dimensions array)))))
    ;; Get conses only from the cons free list and copy the &rest list
    ;; to make sure that the hash-table owns the conses.
    (get-push (get-cons sxhash (get-cons (get-list-copy keys) value))
	      (svref array location))))

;;;
;;;		VI.	Soar-pushhash
;;;
;;; If Soar-pushhash finds an entry under keys, 
;;; it pushes value onto it and returns the list and T,
;;; otherwise it makes a list of value, enters it in the table.
;;; and returns the list and nil as values.
;;;

(defun soar-pushhash (soar-hash-table value &rest keys)
  (let* ((sxhash (the fixnum (sxhash keys)))
	 (array (internal-soar-hash-table-array soar-hash-table))
	 (location (rem sxhash (first (array-dimensions array))))
	 (bucket (svref array location))
	 (test (internal-soar-hash-table-test soar-hash-table)))
    (dolist (sxhash.keys.items bucket 
		   ;; If I didn't find it then 
		   (let ((list-of-value (get-list value)))
		     (get-push (get-cons sxhash (get-cons (get-list-copy keys) list-of-value))
			       (svref array location))
		     (values list-of-value nil)))
    (when (and (= (the fixnum (car sxhash.keys.items)) sxhash)
	       (soar-hash-keys-equal test keys (cadr sxhash.keys.items)))
       (return (values
		 (setf (cddr sxhash.keys.items) (get-cons value (cddr sxhash.keys.items)))
		 t))))))

;;; Concatenated from type module "utility" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/utility/new/utilityinitandrestart.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	startinitializeandrestart.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/utility/new/startinitializerestarts.lisp
;;;
;;;		i.	Abstract
;;;	
;;;	This file contains two functions: initialize-utility and restart-utility.
;;; initialize-utility gets called by init-soar and restart-utility gets called by restart-soar.
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Initialize-utility
;;;	II.	Restart-utility
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")


;;;
;;;		I.	Initialize-utility
;;;

(defun initialize-utility () 
  (initialize-soar-time)
  (initialize-soar-output)
  (initialize-soar-gensyms)
  (initialize-consrecycling)
)


;;;
;;;		II.	Restart-utility
;;;

(defun restart-utility () 
  (restart-soar-time)
  (restart-soar-output)
  (restart-soar-gensyms)
  (restart-consrecycling)
  ; From utility, but I'm too lazy to make it actually restart right.
  (setq *loading-default* nil)
)



;;; Concatenated from type module "graph" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/graph/new/graph.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	graph.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/graph/new/graph.lisp
;;;
;;;		i.	Abstract
;;;	
;;;	This file implements a graph package with incremental
;;; connectedness propagation. 
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	Discussion
;;;	I.	Graph
;;;	II.	Node
;;;	III.	Graph-and-node-print-hash
;;;	IV.	Print-graph
;;;	V.	Print-node
;;;	VI.	Create-graph
;;;	VII.	Delete-graph
;;;	VIII.	Create-node
;;;	IX.	Delete-node
;;;	X.	Add-arc
;;;	XI.	Propagate-connectedness
;;;

;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")
(eval-when (compile eval load) (proclaim '(optimize (speed 3) (safety 0))))


;;;
;;;		iv.	Discussion
;;;
;;;	This graph package implements graphs, with nodes, when
;;; both the graph and each node has a symbol name. Nodes
;;; are looked up on their plist, using the graph defstruct
;;; as a property, for speed of access. The arcs are
;;; bi-directional, and a connectedness property propagates
;;; both ways.
;;;

;;;
;;;		I.	Graph
;;;

(defstruct (graph (:print-function print-graph))
  (name nil  :type symbol)  ; A symbol naming the graph.
  (nodes nil :type list)    ; A list of the node defstructs of the graph.
  )


;;;
;;;		II.	Node
;;;

(defstruct (node (:print-function print-node))
  (name nil  :type symbol)      ; A symbol naming the node.
  (graph nil)       ; The graph defstruct of which I am.
  (outneighbors nil :type list)
            ; The list of my outneighbor's defstructs (arcs).
  (connected nil)    ; Is the node connected ?
)


;;;
;;;		III.	Graph-and-node-print-hash
;;;

(defvar graph-and-node-print-hash (make-hash-table :test #'eq)
  "Graph-and-node-print-hash is an eq hash table that maps
 the symbol names of graphs and nodes to their graph or node
 defstruct while printing. It is used by the graph and node
 printing routines to determine if a graph or node has been
 visited by the current invocation of print. ")

(defvar first-graph-or-node-printing nil
  "The first graph or node in a printing call.")


;;;
;;;		IV.	Print-graph
;;;
;;; Graphs print using #<, which common lisp defines to signal
;;; an error on read, so that they can not be read in.

(defun print-graph (graph stream depth)
  ;; Allowed the posibility of a null depth. -BGM 9/18/89
  ;; Replaced fixnump with integerp. -BGM 4/4/89
  (assert (graph-p graph))
  (assert (streamp stream))
  (assert (or (integerp depth) (null depth)))
  (unless depth (setq depth 0))
  (cond ((not first-graph-or-node-printing)
	 (setq first-graph-or-node-printing graph)
	 (print-graph graph stream depth)
	 (clrhash graph-and-node-print-hash)
	 (setq first-graph-or-node-printing nil))
	((and (not (gethash graph graph-and-node-print-hash)) (>= depth -1))
	 (setf (gethash graph graph-and-node-print-hash) graph)
	 (format stream "#<graph:~A" (graph-name graph))
	 (when (graph-nodes graph)
          (format stream ";nodes ")
	  (dolist (node (graph-nodes graph))
           (print-node node stream (1- depth))))
	 (format stream ">"))
	(t ;; I'm hashed so just print my type/name.
	  (format stream "#<ngraph:~A>" (graph-name graph)))))


;;;
;;;		V.	Print-node
;;;
;;; Nodes print using #<, which common lisp defines to signal
;;; an error on read, so that they can not be read in.

(defun print-node (node stream depth)
  ;; Replaced fixnump with integerp. -BGM 4/4/89
  (assert (node-p node))
  (assert (streamp stream))
  (assert (integerp depth))
  (cond ((not first-graph-or-node-printing)
	 (setq first-graph-or-node-printing node)
	 (print-node node stream depth)
	 (clrhash graph-and-node-print-hash)
	 (setq first-graph-or-node-printing nil))
	((and (not (gethash node graph-and-node-print-hash)) (>= depth -1))
	 (setf (gethash node graph-and-node-print-hash) node)
	 (format stream "#<node:~A" (node-name node))
	 (when (node-connected node)
	  (format stream ";connected "))
	 (when (node-outneighbors node)
          (format stream ";outs ")
	  (dolist (node (node-outneighbors node))
           (print-node node stream (1- depth))))
	 (format stream ">"))
	(t ;; I'm hashed so just print my type/name.
	 (format stream "#<node:~A>" (node-name node)))))

;;;
;;;		VI.	Create-graph
;;;

(defun create-graph (graph-name)
  (make-graph :name graph-name))

;;;
;;;		VII.	Delete-graph
;;;

(defun delete-graph (graph)
  (assert (graph-p graph))
  (dolist (node (graph-nodes graph))
    (assert (node-p node))
    (delete-node node graph))
  (setf (graph-name graph) nil)
  (setf (graph-nodes graph) nil))



;;;
;;;		VIII.	Create-node
;;;

(defun create-node (node-name graph connected)
 (assert (symbolp node-name))
 (assert (graph-p graph))
 (let ((node (get node-name graph)))
   (cond (node 
	   ;; If the node creation is connected and
	   ;; the node exists but is not connected,
	   ;; then propagate its new connectedness.
	   (when (and connected (not (node-connected node)))
             (propagate-connectedness node))
	   node)
	 (t (let ((node (make-node :name node-name :graph graph
			   :connected connected)))
	      (push node (graph-nodes graph))
	      (setf (get node-name graph) node)
	      node)))))


;;;
;;;		IX.	Delete-node
;;;

(defun delete-node (node graph)
  (assert (node-p node))
  (assert (graph-p graph))
  (remprop (node-name node) graph)
  (setf (node-name node) nil
	(node-outneighbors node) nil))


;;;
;;;		X.	Add-arc
;;;
;;;	Propagate connections both ways.

(defun add-arc (from to)
  (assert (node-p from))
  (assert (node-p to))
  (pushnew to (node-outneighbors from) :test #'eq)
  (pushnew from (node-outneighbors to) :test #'eq)
  (when (and (node-connected from) (not (node-connected to)))
     (propagate-connectedness to))
  (when (and (node-connected to) (not (node-connected from)))
     (propagate-connectedness from)))



;;;
;;;		XI.	Propagate-connectedness 
;;;
;;;	This simply DFS's the nodes passing on connectednesses.
;;;

(defun propagate-connectedness (node)
  (assert (node-p node))
  (setf (node-connected node) t)
  (dolist (out (node-outneighbors node))
   (unless (node-connected out)
     (propagate-connectedness out))))


;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/sptoplexer.lisp".


#|
From Brian.Milnes@PISANO.SOAR.CS.CMU.EDU Mon Oct 16 15:35:00 1989
Received: from PISANO.SOAR.CS.CMU.EDU by caen.engin.umich.edu (5.59.1/caen.0.9)
	id 464450ad7.001294c; Mon, 16 Oct 89 15:34:51 EDT
Received: from PISANO.SOAR.CS.CMU.EDU by PISANO.SOAR.CS.CMU.EDU; 16 Oct 89 15:36:44 EDT
To: mcmahon@caen.engin.umich.edu
Cc: soar-archive@PISANO.SOAR.CS.CMU.EDU
Subject: No backquote change.
Date: Mon, 16 Oct 89 15:36:41 EDT
Message-Id: <411.624569801@PISANO.SOAR.CS.CMU.EDU>
From: Brian.Milnes@PISANO.SOAR.CS.CMU.EDU
Status: RO


 Karen,

 I've changed the sptoplexer to no longer dually support both Lisp's
backquote comma, and Soar's comma. Only Soar's is supported.  This can
not be added as a patch file; please replace the sptoplexer file in
Soar 5.1 with the appended file.

 Users must be warned that "," inside of backquotes will not work.  A
(soarresetsyntax) ... (soarsyntax) is required. Inside of this, "^"
will not separate out. Allegro has a bug where the reader reads more
than one form ahead before evaluating the current form.  This may
cause users some trouble, so they may want to include code containing
backquotes in a separate file.

-Brian

P.S. I'm reporting the allegro bug.

 Milnes@cs.cmu.edu
 or Soar-bugs@centro.soar.cs.cmu.edu for Soar bugs mail
 School of Computer Science
 Carnegie Mellon University
 Pittsburgh PA 15213-3890
 (412) 268-2627

|#  

;;;-*-mode: lisp; package: soar -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	Lexer
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/lexer.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the very simple read table based lexer
;;; for Soar. The lexer has five external operations:
;;;  Soarsyntax - change the read time syntax of ^, { and } to 
;;;             be separating (e.g. "^foo" reads as "^ foo").
;;;             This is automatically called at load time.
;;;
;;;  Soarresetsyntax - changes the read time syntax of ^, { and } 
;;;                  back to their default syntax.
;;;  
;;;  Initialize-lexer - initialize the lexer with a lisp list of SP LHS
;;;                   or RHS input.
;;;
;;;  Get-lexeme       - read the next lexeme from the input.
;;;
;;;  Peek-lexeme      - look at but do not read the next input lexeme.
;;;
;;;  Peek-lexeme-1    - look two symbols ahead but do not read.
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.      Soarsyntax
;;;	II.	Soarresetsyntax
;;;	III.	Lexer Variables & Constants
;;;	IV.	Initialize-lexer
;;;	V.	Get-lexeme
;;;	VI.	Peek-lexeme
;;;	VII.	flatten-out-list-and-add-an-end-of-input
;;;	VIII.	Peek-lexeme-1
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")
#+(or)  ;new packaging not yet integrated with 5.1. -KAM 10/25/89
(in-package "SOAR")
(eval-when (compile eval load) (proclaim '(optimize (speed 3) (safety 0))))



;;;
;;;		I.	Soarsyntax
;;;

(defparameter *clean-readtable* (copy-readtable nil)
 "A clean readtable that Soar uses to remember the normal character settings for 
 later restoration. See soarsyntax and soarresetsyntax. This method is used
 because set-syntax-from-character is the only way to restore a macro character
 back to a normal character.")

(defun read-soar-left-bracket (stream char) (declare (ignore stream char)) '\{)

(defun read-soar-right-bracket (stream char) (declare (ignore stream char)) '\})               

(defun read-soar-circumflex (stream char) (declare (ignore stream char)) '\^)

(defun read-soar-exclamation-point (stream char) (declare (ignore stream char)) '\!)

(defun read-soar-tilde (stream char) (declare (ignore stream char)) '\~)

(defun read-soar-comma (stream char) (declare (ignore stream char)) '|,|)

(defun read-soar-at (stream char) (declare (ignore stream char)) '|@|)

;;; Removed read-soar-backquote because of all of the trouble it caused. -BGM 10/16/89

(defparameter *soars-macro-characters*
  `((#\{ . ,(function read-soar-left-bracket))
    (#\} . ,(function read-soar-right-bracket))
    (#\^ . ,(function read-soar-circumflex))
     ,@`((#\, . ,(function read-soar-comma))
	       (#\@ . ,(function read-soar-at))
	       (#\~ . ,(function read-soar-tilde))
	       (#\! . ,(function read-soar-exclamation-point))))
  "An assoc list that maps the characters that Soar changes the reader's syntax of,
   to the function.non-terminating-p used to change their syntax.")

(eval-when (compile eval load) (proclaim '(special *soar-readtable*)))

(defun soarsyntax ()
  ;; The *soar-readtable* is the *read-table* for now, because otherwise the TI
  ;; breaks because it exects to call load using the very first readtable ever built.
    (setq *soar-readtable* *readtable*)
    ;; Install all of the soar reader functions.
    (dolist (character.function *soars-macro-characters*)
      (set-macro-character (car character.function)
			   (cdr character.function) 
			   nil
			   *readtable*))
  #+sx(if soar::graphic-display?
          (sx::sx-soarsyntax-hook))
    t)

;;;
;;;		II.	Soarresetsyntax
;;;

(defun soarresetsyntax ()
  ;; As the TI won't let us use spanking new read tables, 
  ;; I've changed this to get a clean readtable and copy
  ;; back into our old readtable the favorite syntaxes for our characters.
  (dolist (character.function *soars-macro-characters*)
   (let ((character (car character.function)))
    (set-syntax-from-char character character *readtable* *clean-readtable*)))
  #+sx(if soar::graphic-display?
          (sx::sx-soarresetsyntax-hook))
  t)

;;; Brian will probably want me to re-comment this.
;;; Fixes bug number 71, ID 30Mar90-1749.27 -- TFMcG 5-Jul-90

(defun soarsyntaxp ()
  "returns t if soarsyntax is in effect"
  ;; uses somewhat of a kludge -fer 5/30/90
  ;; might run into package problems -fer 7/2/90
  (and (boundp '*clean-readtable*)
       (equal  #'read-soar-left-bracket
               (get-macro-character #\{ *readtable*))))



(eval-when (compile eval load) (proclaim '(inline toggle-soarsyntax)))

(defun toggle-soarsyntax ()
 (if (soarsyntaxp) 
     (soarresetsyntax)
     (soarsyntax))
 (soarsyntaxp))

;;;
;;;		III.	Lexer Variables & Constants
;;;
;;; I use gensym to create unique new tokens for the lexer,
;;; so that it need never confuse "(", ")" and end of file
;;; with anything else. Gensyming a variable name based on
;;; parentheses makes human reading of the lexeme stream
;;; simpler, although it seems very strange.
;;;

(defparameter *left-parenthesis* (gensym "(")
  "A left parenthesis constant so that the lexer will never confuse
 its internal left parenthesis with any other symbol.")

(defparameter *right-parenthesis* (gensym ")")
  "A right parenthesis constant so that the lexer will never confuse
 its internal right parenthesis with any other symbol.")

(defparameter *end-of-input* (gensym "END-OF-INPUT")
  "An end of input token so that the lexer will never confuse
 no input with the end of input.")
  
(defvar *used-lexemes* nil
  "The list of lexemes already consumed, used by the error
 printing routines, notice this is reversed.")

(defvar *first-lexeme* nil
  "A variable on which the next lexeme is stored.")

(defvar *rest-lexemes* nil
  "A variable on which the remaining lexemes, after *first-lexeme*,
 are stored all at top level.")

(defvar *current-lexeme-count* 0
  "A variable that holds the number of lexemes consumed so far.")

(eval-when (compile eval load) (proclaim '(fixnum *current-lexeme-count*)))



;;;
;;;		IV.	Initialize-lexer
;;;
;;;	Initialize lexer is expecting a list of the LHS or the RHS of an SP.
;;; It flattens this out, installing symbols for the "(" and the ")".
;;; This will be where some load speed is lost compared to the old parser
;;; that just digs through the actual input list from SP. This is a 
;;; speed for clenliness tradeoff. Some timings are in order.
;;;

(defun initialize-lexer (input-as-a-list-of-lists) 
  (assert (listp input-as-a-list-of-lists))
  (dispose-list *used-lexemes*)
  (setq *used-lexemes* nil)
  (setq *current-lexeme-count* 0)
  (let ((input-as-one-list 
	  (flatten-out-list-and-add-an-end-of-input input-as-a-list-of-lists)))
    (setq *first-lexeme* (car input-as-one-list))
    (setq *rest-lexemes* (cdr input-as-one-list))))



;;;
;;;		V.	Get-lexeme
;;;
;;;	This returns the next input lexeme, removing it from the input
;;; stream.

(defun get-lexeme () 
  (when (eq *first-lexeme* *end-of-input*)
   (error "~%Soar: Lexer: Get-lexeme: internal error, attempt to get-lexeme at end of input."))
  (let ((lexeme *first-lexeme*))
    (setq *first-lexeme* (car *rest-lexemes*))
    (incf *current-lexeme-count*)
    (let ((cons *rest-lexemes*))
      (setq *rest-lexemes* (cdr *rest-lexemes*))
      (setf (car cons) lexeme)
      (setf (cdr cons) *used-lexemes*)
      (setq *used-lexemes* cons)
      )
    lexeme))



;;;
;;;		VI.	Peek-lexeme
;;;
;;;	This returns the next input lexeme, without consuming it.
;;; Of course this assumes that the lexer is properly initialized.
;;; This is a speed for saftey tradeoff. The most common operation
;;; in a recursive descent parser is the peek-lexeme operation.
;;; To make this efficient and yet to make the code clear,
;;; I have defined this peek-lexeme macro to return the variable
;;; that holds the next input lexeme. This makes each lexeme check
;;; very fast, and yet the code reads as if I'm making a function call.
;;;

(defmacro peek-lexeme () '*first-lexeme*)



;;;
;;;		VII.	flatten-out-list-and-add-an-end-of-input
;;;
;;;	This does the bulk of the input conversion for initialize-lexer.
;;; This could be a little tenser in that the Nconc is doing a lot of list walking.
;;;

(defun flatten-out-list-and-add-an-end-of-input (list &optional (top-level t))
  (cond ((null list) (if top-level (get-list *end-of-input*) nil))
	((not (listp list)) list)
	((null (car list))
	 (get-cons nil
	     (if top-level 
		 (nconc
		   (flatten-out-list-and-add-an-end-of-input (cdr list) nil)
		   (get-list *end-of-input* nil))
	         (flatten-out-list-and-add-an-end-of-input (cdr list) nil))))
	((listp (car list))
	 (let ((flattened-list 
		 (flatten-out-list-and-add-an-end-of-input (car list) nil)))
	   (get-cons *left-parenthesis*
		(nconc flattened-list (get-list *right-parenthesis*)
		  (if top-level 
		      (nconc 
			(flatten-out-list-and-add-an-end-of-input (cdr list) 
								  nil)
			(get-list *end-of-input*))
		    (flatten-out-list-and-add-an-end-of-input (cdr list) 
								  nil))))))
	(t (get-cons (car list)
	     (if top-level 
		 (nconc
		   (flatten-out-list-and-add-an-end-of-input (cdr list) nil)
		   (get-list *end-of-input* nil))
	         (flatten-out-list-and-add-an-end-of-input (cdr list) nil))))))


;;;
;;;		VIII.	Peek-lexeme-1
;;;
;;;	Peek past the *first-lexeme*, unless *first-lexeme* is *end-of-input*, and return it.

(defun peek-lexeme-1 ()
  (when (eq *first-lexeme* *end-of-input*)
    (error "~%Soar: Lexer: Peek-lexeme-1: internal error, attempt to Peek-lexeme past end of input."))
  (car *rest-lexemes*))





;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/sptopsymboltable.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	SymbolTable
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/symboltable.lisp
;;;
;;;		i.	Abstract
;;;	
;;;	This file implements a very simple symbol table for Soar productions' variables.
;;; This is a minimal symbol table for SP alone, and will need to be extended to
;;; handle the actual code generation of P. 
;;;
;;; It defines one data structure: Symbol-table-entry; this will make extension much easier.
;;; The symbol table is accessed and modified using:
;;;
;;; Initialize-symbol-table - empties the symbol table.
;;;
;;; Add-variable-to-symbol-table - adds a new variable to the symbol table.
;;;
;;; Find-variable-in-symbol-table - this looks up the variable in the symbol table
;;;                                 and returns its entry, or nil if it is not present.
;;;
;;; Symbol-table-negation-start 
;;;   - call then when parsing a negation so that
;;;     its bindings may be later removed from the stack,
;;;     as you are not allowed to define new inter condition 
;;;     variables in a negation.
;;;
;;; Symbol-table-negation-end 
;;;   - this is called when you are finished parsing a negated condition element.
;;;     It cleans out all of the new bindings in the negated condition.
;;;
;;; Symbol-table-pop-last-entry-of-variable
;;;  - this clears out the last entry of a variable on the symbol table.
;;;    Variables may be repeatedly defined so that code generation can
;;;    access the most shallow binding of a LHS variable.
;;;
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	Discussion
;;;	I.	Symbol Table Variables
;;;	II.	Symbol-table-entry accessors
;;;	III.	Initialize-symbol-table
;;;	IV.	Add-variable-to-symbol-table
;;;	V.	Find-variable-in-symbol-table
;;;	VI.	Symbol-table-negation-start
;;;	VII.	Symbol-table-negation-end
;;;	VIII.	Symbol-table-pop-last-entry-of-variable
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")
(eval-when (compile eval load) (proclaim '(optimize (speed 3) (safety 0))))


;;;
;;;		iv.	Discussion
;;;
;;;	 This is a simple list based symbol table which uses assoc to look
;;; up variables. It could be that Soar productions have so many variables
;;; that it might be worthwhile to use a hash table, but I doubt it. Perhaps
;;; a plist based symbol table would be optimal. If so this remove-v-b-d-t
;;; function would force a slight change in the structure also.
;;;
;;;	This is initially implemented with only a condition element number
;;; stored under each variable. Other slots may be easily added. 
;;;
;;;



;;;
;;;		I.	Symbol Table Variables
;;;

(defvar *symbol-table* ()
  "The list of symbol table entries for Soar production variables.")

(eval-when (compile eval load) (proclaim '(type list *symbol-table*)))


;;;
;;;		II.	Symbol-table-entry accessors
;;;

(defmacro symbol-table-entry-p (ste) `(consp ,ste))
(defmacro get-symbol-table-entry () `(the cons (get-cons nil nil)))
(defmacro dispose-symbol-table-entry (ste) `(dispose-cons (the cons ,ste)))
(defmacro symbol-table-entry-variable (ste) `(car (the cons ,ste)))
(defmacro symbol-table-entry-condition-element-number (ste) 
  `(cdr (the cons ,ste)))



;;;
;;;		III.	Initialize-symbol-table
;;;

(defun initialize-symbol-table ()
  (dispose-tree *symbol-table*)
  (setq *symbol-table* nil))



;;;
;;;		IV.	Add-variable-to-symbol-table
;;;

(defun add-variable-to-symbol-table (variable condition-element-number)
  (setq *symbol-table*
	(get-cons (get-cons variable condition-element-number)
		  *symbol-table*)))


;;;
;;;		V.	Find-variable-in-symbol-table
;;;

(defun find-variable-in-symbol-table (variable)
  (car (member variable *symbol-table* 
	       :test #'eq
	       :key #'(lambda (symbol-table-entry) 
			(when (symbol-table-entry-p symbol-table-entry)
			      ;; This when avoids negation markers.
			      (symbol-table-entry-variable symbol-table-entry))))))



;;;
;;;		VI.	Symbol-table-negation-start
;;;

(defun symbol-table-negation-start ()  (push 'negation *symbol-table*))


;;;
;;;		VII.	Symbol-table-negation-end
;;;

(defun symbol-table-negation-end ()
  (setq *symbol-table* (cdr (member 'negation *symbol-table*))))



;;;
;;;		VIII.	Symbol-table-pop-last-entry-of-variable
;;;

(defun symbol-table-pop-last-entry-of-variable (variable)
  (setq *symbol-table* 
	(delete variable (the list *symbol-table*)
		:count 1
		:test #'eq
		:key #'(lambda (symbol-table-entry)
			 (when (symbol-table-entry-p symbol-table-entry)
                           (symbol-table-entry-variable symbol-table-entry))))))

;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/printlexedsp.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	PrintlexedSP
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/printlexedsp.lisp.
;;;
;;;		i.	Abstract
;;;
;;;	This file, printsp.lisp, prints part of an sp's LHS or RHS
;;; in its lexed format, up to a given number of tokens, so that error 
;;; messages may coherently display where syntactic/semantic errors occurred.
;;; There are three calls included here:
;;;
;;;	Print-last-lexed-CE - prints the last CE that has been lexed, so that
;;;      the error message printing routines can display where a syntactic error
;;;      occurred.
;;;
;;;	Print-last-lexed-action - does the same for lexed RHS actions.
;;;
;;;	Print-make-as-list - is used by the semantics routines. By the time
;;;      semantics gets to check if a RHS action is connected to the LHS,
;;;      it has already been parsed into P action format.  This prints
;;;      it as an SP make so that is is easier to read.
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Print-last-lexed-CE
;;;	II.	Print-last-lexed-action
;;;	III.	Print-make-as-list
;;;

;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")
(eval-when (compile eval load) (proclaim '(optimize (speed 3) (safety 0))))



;;;
;;;		I.	Print-last-lexed-CE
;;;
;;; Not quite the functionality that I was looking for. If there
;;; is only a left parenthesis it should print the previous condition element.
;;; I'll get around to fixing this later.

(defun print-last-lexed-CE (stream &optional (used-lexemes *used-lexemes*))
  (cond ((null used-lexemes))
	((eq (car used-lexemes) *left-parenthesis*)
	 (soar-format stream "~%(") nil)
	(t
	  (let ((lexeme (car used-lexemes))
		(space (print-last-lexed-CE stream (cdr used-lexemes))))
	    (cond ((eq lexeme *right-parenthesis*) (soar-format stream ")") nil)
		  ((eq lexeme '^)
		   (when space (soar-format stream " "))
		   (soar-format stream "^") nil)
		  (t (when space (soar-format stream " "))
		     (soar-format stream "~A" lexeme) t))))))



;;;
;;;		II.	Print-last-lexed-action
;;;
;;;

(eval-when (compile eval load) (proclaim '(special *rhs-smake-or-ppwm*)))

(defun print-last-lexed-action (stream depth &optional (used-lexemes *used-lexemes*))
   (cond ((null used-lexemes) 
	  (case *rhs-smake-or-ppwm*
	   (RHS   (soar-format stream "~%-->~%"))
	   (SMAKE (soar-format stream "~% (SMAKE"))
	   (PPWM  (soar-format stream "~% (PPWM")))
	  nil)
	 ((= depth 0) (soar-format stream "~%"))
	(t 
	  (print-last-lexed-action stream (1- depth) (cdr used-lexemes))
	  (let ((lexeme (car used-lexemes)))
	    ;; When recursing some things require a space 
	    ;; printed after them, such as left ps, ^
	    ;; and if the current lexeme is a right-parenthesis
	    ;; you must print also print a space after it.
	    (unless (or (eq (cadr used-lexemes) *left-parenthesis*)
			(eq (cadr used-lexemes) '^)
			(eq lexeme *right-parenthesis*))
		    (soar-format stream " "))
	    (cond ((eq lexeme *left-parenthesis*)
		   (soar-format stream "("))
		  ((eq lexeme *right-parenthesis*)
		   (soar-format stream ")"))
		  (t (soar-format stream "~A" lexeme)))))))
	     


;;;
;;;		III.	Print-make-as-list
;;;
;;; This prints a make which has already been parsed into P format
;;; to stream.
;;;

(defun print-make-as-list (stream make)
  (soar-format stream "~%(")
  (do* ((itemp make (cdr itemp))
	(item (car itemp) (car itemp)))
       ((null itemp))
    (cond ((eq item '^) (soar-format stream "^"))
	  ((cdr itemp) (soar-format stream "~A " item))
	  (t (soar-format stream "~A" item))))
  (soar-format stream ")"))

;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/sperrorsandwarnings.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	spparsererrorsandwarnings
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/sperrorsandwarnings.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file contains utilities to print the SP parser's errors and 
;;; warnings to the terminal, with coherent error message displaying
;;; functionality. 
;;;
;;;	This file exports five forms:
;;;
;;; Catch-SpToP-errors
;;;	- A macro that should be wrapped around calls to the LHS and RHS
;;;       parser. This catches and gracefully exits from signalled errors.
;;;
;;; SpToP-LHS [RHS] -error
;;;	- This signals a LHS [RHS] error, call the right lexed CE [ACTION] printing routine
;;;       to help display where the error is, and throws up to the catch.
;;;       The arguments that print the error message are a format style
;;;       string and an arbitrary number of arguments.
;;; SpToP-LHS [RHS] -warning
;;;	- This signals a warning and does all that LHS [RHS] -error does except
;;;       thow to the enclosing catch.
;;;
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	Lacunae
;;;	I.	Catch-SpToP-errors
;;;	II.	SpToP-LHS-error
;;;	III.	SpToP-LHS-warning
;;;	IV.	SpToP-RHS-error
;;;	V.	SpToP-RHS-warning
;;;	VI.	SpToP-error
;;;	VII.	SpToP-warning
;;;

;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")

(eval-when (compile eval load) (proclaim '(special *soar-production-name* *current-lexeme-count* *start-of-last-rhs-action*)))
(eval-when (compile eval load) (proclaim '(fixnum *current-lexeme-count* *start-of-last-rhs-action*)))



;;;
;;;		iv.	Lacunae
;;;
;;; Perhaps we only want to print one error or warning
;;; header per LHS or RHS.
;;;


;;;
;;;		I.	Catch-SpToP-errors
;;;

(defmacro catch-sptop-errors (&body body)
  `(catch 'sptop-error
     ,@body))


;;;
;;;		II.	SpToP-LHS-error
;;;

(defun SpToP-LHS-error (format-string &rest arguments)
  (soar-format *error-output* "~% Soar: Error in SP, ~A's LHS" *soar-production-name*)
  (print-last-lexed-ce *error-output*)
  (soar-format *error-output* "~%  ")
  (apply #'soar-format *error-output* format-string arguments)
  (throw 'sptop-error nil)
  )


;;;
;;;		III.	SpToP-LHS-warning
;;;

(defun SpToP-LHS-warning (format-string &rest arguments)
  (soar-format *error-output* "~% Soar: Warning in SP, ~A's LHS" *soar-production-name*)
  (print-last-lexed-ce *error-output*)
  (soar-format *error-output* "~%  ")
  (apply #'soar-format *error-output* format-string arguments)
  )


;;;
;;;		IV.	SpToP-RHS-error
;;;

(eval-when (compile eval load) (proclaim '(special *last-action*)))

(defvar *RHS-SMAKE-OR-PPWM* 'RHS 
  "A switch that tells Sptop-RHS-[error, warning] if the parser is being called on
   a RHS, SMAKE or (S)PPWM.")

(defun SpToP-RHS-error (format-string &rest arguments)
  (case *RHS-SMAKE-OR-PPWM*
    (RHS   (soar-format *error-output* "~% Soar: Error in SP, ~A's RHS" *soar-production-name*))
    (SMAKE (soar-format *error-output* "~% Soar: Error in SMAKE, "))
    (PPWM  (soar-format *error-output* "~% Soar: Error in (S)PPWM, ")))
  (print-last-lexed-action *error-output* (1+ (- *current-lexeme-count* *start-of-last-rhs-action*)))
  (soar-format *error-output* "~%  ")
  (apply #'soar-format *error-output* format-string arguments)
  (throw 'sptop-error nil)
  )


;;;
;;;		V.	SpToP-RHS-warning
;;;

(defun SpToP-RHS-warning (format-string &rest arguments)
  (case *RHS-SMAKE-OR-PPWM*
    (RHS     (soar-format *error-output* "~% Soar: Warning in SP, ~A's RHS" *soar-production-name*))
    (SMAKE (soar-format *error-output* "~% Soar: Warning in SMAKE, "))
    (PPWM (soar-format *error-output* "~% Soar: Warning in (S)PPWM, ")))
  (print-last-lexed-action *error-output* (1+ (- *current-lexeme-count* *start-of-last-rhs-action*)))
  (soar-format *error-output* "~%  ")
  (apply #'soar-format *error-output* format-string arguments)
  )


;;;
;;;		VI.	SpToP-error
;;;

(defun SpToP-error (format-string &rest arguments)
  (soar-format *error-output* "~% Soar: Error in SP, ~A" *soar-production-name*)
  (apply #'soar-format *error-output* format-string arguments)
  (throw 'sptop-error nil)
  )



;;;
;;;		VII.	SpToP-warning
;;;

(defun SpToP-warning (format-string &rest arguments)
  (soar-format *error-output* "~% Soar: Warning in SP, ~A" *soar-production-name*)
  (apply #'soar-format *error-output* format-string arguments)
  )



;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/spsemantics.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	SpSemantics
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/spsemantics.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the semantic tests required for the
;;; SPtoP parser. The semantic tests are documented before each
;;; function call. A general connectedness testing set of routines
;;; are included to test the LHS and RHS connectedness.
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	Lacunae
;;;	I.	Legal-<RELATION><SINGLE-TEST>
;;;	II.	Legal-<PREFERENCE-ATTRIBUTE-TEST>
;;;	III.	Legal-<PREFERENCE-MAKE>
;;;	IV.	Connected-<RHS>-P
;;;	V.	<LHS>-contains-a-positive-<CE>
;;;	VI.	find-<LHS>-positive-<CE>
;;;

;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")
(eval-when (compile eval load) (proclaim '(optimize (speed 3) (safety 0))))
(eval-when (compile eval load) (proclaim '(special *soar-production-name*)))


;;;
;;;		iv.	Lacunae
;;;
;;;	This is missing the connectedness checks for the LHS.
;;; This signals errors in the ops5 fashion for <> <foo> when <foo>
;;; has yet to be bound. The reorderer takes care of this and so
;;; this test should be reimplemented in the correct fashion.
;;;


;;;
;;;		I.	Legal-<RELATION><SINGLE-TEST>
;;;
;;;	This checks that a call to a relational LHS test is okay.
;;; It checks that you are not testing a variable before it is bound.
;;; It also checks that you are not using a numeric relational test
;;; on a non numeric constant.

(defun legal-<relation><single-test> (<relation> <single-test>)
 ;; Removed this first test. -BGM 1/26/89
 #| This test must be done by the reorderer.
  (when (variablep <single-test>)
   (unless (find-variable-in-symbol-table <single-test>)
     (SpToP-LHS-error 
       "parsed the relational test, ~A ~A, but ~A is a variable with no current binding."
       <relation> <single-test> <single-test>)))
 |#
  (when (member <relation> '(< > <= >= =) :test #'eq)
   (unless (or (variablep <single-test>) (numberp <single-test>))
     (SpToP-LHS-error
       "parsed the numeric relational test, ~A ~A, but ~A is a not a numeric constant or a variable."
       <relation> <single-test> <single-test>
       ))))




;;;
;;;		II.	Legal-<PREFERENCE-ATTRIBUTE-TEST>
;;;
;;;	This checks that the attribute tests in a preference CE
;;; hold acceptable values. Role and Value are tested to see
;;; that they are testing against a variable or one of their
;;; allowed constants. GPSO&R attributes are tested to not
;;; hold a constant.
;;;


;;;
;;;		III.	Legal-<PREFERENCE-MAKE>
;;;

;;; We really ought to define all of this once, and document it, in
;;; one file somewhere. I define the offsets in spparselhs with
;;; the defconstant preference-attribute-bindings.

;;;
;;; This routine takes a preference, as a by position list, generated
;;; from spparserhs's <preference-make> routine and checks the following:
;;;
;;; The rhs parser checks the simple syntactic stuff:
;;; A) ^role provided and is one of << <variable> problem-space state operator >>
;;; B) ^value provided and is one of << <variable> 
;;; C) the id is provided.
;;; 
;;; This checks that:
;;; D) if ^value is better or worse, I need a reference.
;;; E) that one of G, P, S or O is provided and not nil.
;;;



;;;
;;;		IV.	Connected-<rhs>-p
;;;
;;; Connected-<rhs>-p checks that a <RHS> is connected
;;; to the <LHS>. <RHS><Variable>* is the sequence of
;;; sets of all of variables used in each RHS action.
;;; <LHS><VARIABLE>* is the set of all of the variables positively 
;;; bound at the top level of the LHS.

(defun connected-<rhs>-p (<RHS> <RHS><VARIABLE>* <LHS><VARIABLE>*)
  (let ((g (create-graph *soar-production-name*)))
    ;; Get a graph structure, and make each <LHS> variable a connected node.
    (dolist (v <LHS><VARIABLE>*) (create-node v g t))
     ;; Iterate through the variable sets of each <RHS-ACTION>.
     (dolist (<RHS-ACTION><VARIABLE>* <RHS><VARIABLE>*)
       ;; First create a node for each variable.
       (dolist (v <RHS-ACTION><VARIABLE>*)
	 (create-node v g nil))
       ;; For each pair add in an arc.
       (do* ((v0p <RHS-ACTION><VARIABLE>* (cdr v0p))
	     (v0 (car v0p) (car v0p)))
	   ((null v0p))
	 (dolist (v1 (cdr v0p)) 
           (add-arc (create-node v0 g nil) (create-node v1 g nil)))))
     ;; Walk through the variable sets again looking for
     ;; non empty, non connected sets. Remember the
     ;; first one and the total count; warn the user.
     (let ((first-unconnected-variable-set nil)
	   (total-unconnected-variable-sets 0)
	   (count 0))
       (dolist (<RHS-ACTION><VARIABLE>* <RHS><VARIABLE>*)
	(when (and <RHS-ACTION><VARIABLE>* 
		(not (some #'(lambda (node-name)
			  (node-connected (create-node node-name g nil)))
		      <RHS-ACTION><VARIABLE>*)))
         (unless first-unconnected-variable-set
	   (setq first-unconnected-variable-set count))
	 (incf total-unconnected-variable-sets))
      (incf count))
      (when first-unconnected-variable-set
       (sptop-warning
	 "'s RHS~%  ~A make action~P not connected to the lhs: printing first one."
         total-unconnected-variable-sets total-unconnected-variable-sets)
       (print-make-as-list *error-output* (nth first-unconnected-variable-set <RHS>))))
     (delete-graph g)))


;;;
;;;		V.	<LHS>-contains-a-positive-<CE>
;;;
;;; When given a parsed LHS, this routine checks for the 
;;; existance of a positive condition element. If there is
;;; no positive condition element, an error is signalled.
;;; A LHS with no positive CE will loop in the reorderer.
;;;
  
(defun <LHS>-contains-a-positive-<CE> (<LHS>)
  (assert (listp <LHS>))
  (unless (find-<LHS>-positive-<CE> <LHS>)
    (sptop-error ",~%  the LHS does not contain a positive condition element. ")))
    


;;;
;;;		VI.	find-<LHS>-positive-<CE>
;;;
;;;	This function returns the first positive <CE> in a <LHS> or
;;; returns nil. It is a pseudo predicate used by the semantic
;;; check <LHS>-contains-a-positive-<CE>; there is no real reason
;;; to be returning the <+CE>, it is just a convenient way to 
;;; construct this routine.
;;;

(defun find-<LHS>-positive-<CE> (<LHS>)
  (when (and <LHS> (not (equal <LHS> '(}))))
	;; I've cheated on the reccurance here by
	;; throwing out the (}) <LHS> for the 
	;; conjunctive condition case.
   (let ((first-<CE> (first <LHS>)))
     (cond ((eq (first first-<CE>) '-)
	    ;; First <CE> is negative.
	    (find-<LHS>-positive-<CE> (rest <LHS>)))
	   ((eq (first first-<CE>) '{)
	    ;; Start of a conjunctive condition.
	    (or (find-<LHS>-positive-<CE> (rest <LHS>))
		(find-<LHS>-positive-<CE> (rest first-<CE>)))
	    )
	   (t ;; Since first-<CE> is not negative or conjunctive
	      ;; it must be positive.
	     first-<CE>)))))

;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/spparselhs.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	SpParseLhs
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/spparselhs.lisp.
;;;
;;;		i.	Abstract
;;;
;;;	 This file parses Sp LHS's into our internal OPS5 P-like format.
;;; The parser is recursive descent; stoping at the first error,
;;; aborting the compilation of the remainging condition elements.
;;;


;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	LHS Grammar
;;;	v.	Format of Grammar Calls
;;;	vi.	Lacunae
;;;	I.	Sp-Parse-LHS
;;;	II.	Variablep
;;;	III.	Mor
;;;	IV.	Zero-or-one
;;;	V.	One-or-more
;;;	VI.	Zero-or-more
;;;	VII.	let-grammar-values
;;;	VIII.	<LHS>
;;;	IX.	<CE-GROUP>
;;;	X.	<CE-GROUP>*
;;;	XI.	<+CE-GROUP>
;;;	XII.	<+CE>
;;;	XIV.	Positive-<Test>p
;;;	XV.	<+CEREST>
;;;	XVI.	<PREFERENCE-CE>
;;;     XVII.	<PREFERENCE-ATTRIBUTE-TEST>*
;;;	XVIII.	<PREFERENCE-ATTRIBUTE-TEST>
;;;	XIX.	<PREFERENCE-ATTRIBUTE>
;;;	XX.	<TEST>*
;;;	XXI.	<TEST>
;;;	XXII.	<+TEST>
;;;	XXIII.	<CONJUNCTIVE-TEST-+?>
;;;	XXIV.	  <CONJUNCTIVE-TEST-+?>+
;;;	XXV.	<CONJUNCTIVE-TEST>?
;;;	XXVI.	<CONJUNCTIVE-TEST>
;;;	XXVII.	<DISJUNCTIVE-TEST>+
;;;	XXVIII.	<DISJUNCTIVE-TEST>
;;;	XXIX.	<CONSTANT>+
;;;	XXX.	<CONSTANT>
;;;	XXXI.	<RELATIONAL-TEST>
;;;	XXXII.	<RELATION>
;;;	XXXIII.	<SINGLE-TEST>
;;;	XXXIV.	<SYMBOL-NOT-SPECIAL>
;;;	XXXV.	<NUMBER>
;;;	XXXVI.	<STRING>	
;;;	XXXVII.	<VARIABLE>
;;;	XXXVIII.<SIMPLE-CE>
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")
(eval-when (compile eval load) (proclaim '(optimize (speed 3) (safety 0))))
(eval-when (compile eval load) (proclaim '(special *soar-production-name*)))


;;;
;;;		iv.	LHS Grammar
;;;
;;;    This is the grammar for the parser below and should
;;; serve as the "source" of the Soar LHS grammar. When the
;;; manual is rewritten, the terminology for the different
;;; parts of Soar syntax should be standardized and this
;;; parser's error messages at least should be brought
;;; into line with this standard,
;;; as its error messages will be meta symbol name dependent.
;;;
;;;   For the grammar's description I'll use a modified
;;; BNF, with "<>" enclosed meta symbols, "::=" for
;;; definition, epsilon for the empty string and "[]" for
;;; grouping in the meta language.
;;; Trailing  "?" for zero or one, "+" for one or more
;;; and "*"s for zero or more. The rules are written
;;; in the exact order that the subsymbol parses are applied.
;;;
;;;  This grammar is a "worked out" version of what you might
;;; like to see as a simple Soar grammar. It has been worked
;;; out to allow semantic information, such as preference
;;; specific tests, to be applied only when they are needed.
;;; Additionally it has had been changed to force a lexeme
;;; to be read in at the start of each recursion, i.e., left
;;; recursion has been removed. Finally, the parser does not
;;; exactly reflect the grammar: sometimes kleen stars (<f>*)have
;;; been expanded (epsilon | <F> | <F> <F>+).
;;;
;;; One problem with installing this will be that this grammar
;;; parses more than the OPS5 like grammar in PtoRete will allow. I'll
;;; need a couple of ugly semantic checks to catch this
;;; for upward compatability.
;;;
;;;  Generally a positive condition element group is
;;; required first, however as we reorder this is no longer
;;; required and has been simply changed to be a sematics
;;; test for any positive condition element with in the 
;;; <LHS>. The reorderer must be changed to do the actual test for
;;; the existence of a correct ordering, including the existence
;;; of a positive condition element for each <CE-group>.
;;;
;;;	This file is the grammar and parser for both 4.0 and 5.0 (DSM).
;;; The grammar and the parser are both written conditional compilation
;;; on the feature :DSM.  means add in when :DSM is a feature and
;;;  remove when :DSM is a feature.
;;;
;;; <LHS>              
;;;	::= <CE-GROUP> <CE-GROUP>*
;;; <CE-GROUP>
;;;	::= - ( <SIMPLE-CE> ) | - <+CE-GROUP> | <+CE-GROUP>
;;; <CE-GROUP>*
;;;	::= <CE-GROUP> <CE-GROUP>* | epsilon
;;; <+CE-GROUP>
;;;	::= { <CE-GROUP> <CE-GROUP>* } | <+CE>
;;; <+CE>
;;;	::=  | ( <+CEREST> )
;;;     ::=  ( <+CEREST> )
;;; <+CEREST>
;;;	::= <CONJUNCTIVE-TEST> <CONJUNCTIVE-TEST>? <TEST>*
;;; <SIMPLE-CE>
;;;     ::= <CONJUNCTIVE-TEST> <CONJUNCTIVE-TEST>? <TEST>?
;;;     ;; This is used to catch - (goal <g> ^a a a) which should be - { (goal <g> ^a a b) }.
;;; <PREFERENCE-CE>
;;;	::= preference <CONJUNCTIVE-TEST>? <PREFERENCE-ATTRIBUTE-TEST>*
;;; <PREFERENCE-ATTRIBUTE-TEST>*
;;;	::= <PREFERENCE-ATTRIBUTE-TEST> <PREFERENCE-ATTRIBUTE-TEST>* | epsilon
;;; <PREFERENCE-ATTRIBUTE-TEST>
;;;	::= ^ <PREFERENCE-ATTRIBUTE> <CONJUNCTIVE-TEST> 
;;; <PREFERENCE-ATTRIBUTE>
;;;	::= role | value | goal | problem-space | state | operator | reference | object
;;; <TEST>
;;;	::= <TEST> <TEST>* | epsilon
;;; <TEST>
;;;	::= - <+TEST> | <+TEST>
;;; <+TEST>
;;;	::=  <CONJUNCTIVE-TEST> <CONJUNCTIVE-TEST>* 
;;;     ::=  ^ <CONJUNCTIVE-TEST> <CONJUNCTIVE-TEST-+?>* 
;;;  <CONJUNCTIVE-TEST-+?> ::= <CONJUNCTIVE-TEST> [ + | epsilon ]
;;; <CONJUNCTIVE-TEST>*
;;;	::= <CONJUNCTIVE-TEST> <CONJUNCTIVE-TEST>* | epsilon
;;; <CONJUNCTIVE-TEST>+
;;;	::= <CONJUNCTIVE-TEST> <CONJUNCTIVE-TEST>* | <CONJUNCTIVE-TEST>
;;; <CONJUNCTIVE-TEST>
;;;	::= { <DISJUNCTIVE-TEST> <DISJUNCTIVE-TEST>+ } | <DISJUNCTIVE-TEST>
;;; <DISJUNCTIVE-TEST>+
;;;	::= <DISJUNCTIVE-TEST> <DISJUNCTIVE-TEST>* | <DISJUNCTIVE-TEST>
;;; <DISJUNCTIVE-TEST>*
;;;	::= <DISJUNCTIVE-TEST> <DISJUNCTIVE-TEST>* | epsilon
;;; <DISJUNCTIVE-TEST>
;;;	::= << <CONSTANT> <CONSTANT>+ >> | <RELATIONAL-TEST>
;;; <CONSTANT>+
;;;	::= <CONSTANT> <CONSTANT>* | <CONSTANT>
;;; <CONSTANT>*
;;;	::= <CONSTANT> <CONSTANT>* | epsilon
;;; <CONSTANT>
;;;	::= <SYMBOL-NOT-SPECIAL> | <NUMBER> | <STRING>
;;; <RELATIONAL-TEST>
;;;	::= <RELATION> <SINGLE-TEST> | <SINGLE-TEST>
;;; <RELATION>
;;;	::= <> | < | > | <= | >= | = | <=>
;;; <SINGLE-TEST>
;;;	::= <VARIABLE> | <CONSTANT>
;;; <SYMBOL-NOT-SPECIAL>
;;;	::= a Common Lisp symbol that is not a variable, {, }, <<, >>, ^, -
;;; <NUMBER>
;;;	::= a Common Lisp number
;;; <STRING>
;;;	::= a Common Lisp string
;;;
;;; 

;;;
;;;		v.	Format of Grammar Calls
;;;
;;;	All of the lhs symbols defined above are realized
;;; as a defun in this recursive descent parser. Each routine
;;; returns one or two values. Each grammar constructed with *
;;; can not fail, it will always find zero of its string, so
;;; these return only the values parsed as a list. All others
;;; return two values, the first their value and the second
;;; t upon success and nil else. 
;;;
;;;	Three macros are provided to implement ?, * and +'s grammar
;;; operations: zero-or-one, zero-or-more and one-or-more.
;;;
;;;



;;;
;;;		vi.	Lacunae
;;;
;;; Synchronizing tokens could be sought, but as a single missing
;;; variable in an SP can generate scads of warnings, I have not
;;; done this. 
;;;
;;;	This is not set up to produce the variable sets of each
;;; CE correctly for the LHS connectedness checks. This should
;;; also be modified to handle calls for PPWM and SPPWM.
;;;
;;;	This should have common errors such as symbol at top level
;;; added as parses that signal error.
;;;
;;;	The lexer could be fleshed out to do the symbolp/numberp/stringp
;;; once and given a plist lookup for special symbols to speed things
;;; up. A count of the number of numberp/symbolp/stringp should
;;; be performed and compared to the cost of a linear symbolp/numberp/stringp
;;; at lex time. 
;;; 

;;;
;;;		I.	Sp-Parse-LHS
;;;

(defun sp-parse-lhs (lhs)
   (initialize-lexer lhs)
   ;; Set the current condition element number to -1,
   ;; so that the first one is registered as zero.
   (initialize-symbol-table)
   (<lhs>))


;;;
;;;		II.	Variablep
;;;
;;; This fixes the old VPS2 bug that "<foo" was a variable, this
;;; was particularly dangerous for "<3". We wouldn't want the
;;; mars rover to drop dead would we ?
;;;

(defun variablep (thing)
  (and (symbolp thing) 
   (let* ((symbol-name (symbol-name thing))
	  (length-symbol-name (length (the string symbol-name))))
     (and (> length-symbol-name 2)
	  (char= (aref symbol-name 0) #\<)
	  (char= (aref symbol-name (1- length-symbol-name)) #\>)))))


;;;
;;;		III.	Mor
;;;
;;;	This is used for recursive disjunctive calls of grammar routines
;;; from other grammar routines.
;;;

(defmacro mor (&body body)
  (let ((success (gensym "SUCCESS"))
	(value   (gensym "VALUE"))
	(<VARIABLE>* (gensym "<VARIABLE>*")))
    `(block nil
        ,.(mapcar #'(lambda (test) 
		      `(multiple-value-bind (,value ,<VARIABLE>* ,success) ,test
			  (when ,success (return (values ,value ,<VARIABLE>* t)))))
		      body)
        (values nil nil nil))))

 

;;;
;;;		IV.	zero-or-one
;;; 
;;;	When you try to parse zero or one of something (?) you always
;;; succeed.

(defmacro zero-or-one (grammar-routine-call)
  (let ((success (gensym "SUCCESS"))
	(value   (gensym "VALUE"))
	(<VARIABLE>* (gensym "<VARIABLE>*")))
    `(multiple-value-bind (,value ,<VARIABLE>* ,success) ,grammar-routine-call
       (values ,value ,<VARIABLE>* (if ,success 1 0)))))


;;;
;;;		V.	One-or-more
;;;
;;; You only succed on a call to parse one or more of something when
;;; you find one out there. Return the list of the subvalues parsed
;;; one at a time.
;;;

(defmacro one-or-more (grammar-routine-call &key (join :push) (join-variables :nunion))
  (unless (or (eq join :push) (eq join :nconc))
    (error "~%Error expanindg one-or-more bad join value ~A." join))
  (unless (or (eq join-variables :push) (eq join-variables :nunion))
    (error "~%Error expanindg one-or-more bad join-variables value ~A." join))
  (let ((success (gensym "SUCCESS"))
	(value   (gensym "VALUE"))
	(values  (gensym "VALUES"))
	(<VARIABLE>* (gensym "<VARIABLE>*"))
	(variables (gensym "VARIABLES")))
    `(let ((,values ())
	   (,variables ()))
     (loop
       (multiple-value-bind (,value ,<VARIABLE>* ,success) ,grammar-routine-call
         (cond (,success
		  (get-push ,value ,values)
		  ,(case join-variables
                    (:push `(get-push ,<VARIABLE>* ,variables))
		    (:nunion `(setq ,variables (nunion ,<VARIABLE>* ,variables)))
		    (:nconc `(setq ,variables (nconc ,variables ,<VARIABLE>*)))))
	       (t 
		 (return 
		   (values 
		     (setq ,values 
			   ,(if (eq join :push) 
				`(nreverse ,values)
			      `(apply #'nconc (nreverse ,values))))
		     ,(if (eq join-variables :push) `(nreverse ,variables) variables)
		     (not (null ,values)))))))))))


;;;
;;;		?.	Zero-or-more
;;;

(defmacro zero-or-more (grammar-routine-call &key (join :push) (join-variables :nunion))
  (unless (or (eq join :push) (eq join :nconc))
    (error "~%Error expanindg zero-or-more bad join value ~A." join))
  (unless (or (eq join-variables :push) (eq join-variables :nunion) (eq join-variables :nconc))
    (error "~%Error expanindg zero-or-more bad join-variables value ~A." join))
  (let ((success (gensym "SUCCESS"))
	(value   (gensym "VALUE"))
	(values  (gensym "VALUES"))
	(<VARIABLE>* (gensym "<VARIABLE>*"))
	(variables (gensym "VARIABLES")))
   `(let ((,values ())
	  (,variables nil))
     (loop
       (multiple-value-bind (,value ,<VARIABLE>* ,success) ,grammar-routine-call
         (cond (,success
		  (get-push ,value ,values)
		  ,(case join-variables
                    (:push `(get-push ,<VARIABLE>* ,variables))
		    (:nunion `(setq ,variables (nunion ,<VARIABLE>* ,variables)))
		    (:nconc `(setq ,variables (nconc ,variables ,<VARIABLE>*)))))
	       (t 
		 (return 
		   (values 
		     (setq ,values 
			   ,(if (eq join :push) 
				`(nreverse ,values)
			      `(apply #'nconc (nreverse ,values))))
		     ,(if (eq join-variables :push) `(nreverse ,variables) variables)
		     (length ,values))))))))))


;;;
;;;		VI.	let-grammar-values
;;;
;;;	Let-grammar-values is a syntactic sugar macro that expands
;;; into a multiple-value-bind that catches all three values returned
;;; from a grammar call. The first value is the return form for
;;; the meta symbol, the second the set of variables positively
;;; bound in the grammar symbol's parse and the third t if the 
;;; meta symbol parsed successfully.
;;;
;;;	It expands a call to "(let-grammar-values (<g>) ...)" into
;;; "(multiple-value-bind (<g> <g><variable>* found-<g>) (<g>) ...)".
;;;

(defmacro let-grammar-values ((symbol &key (prefix "")) &body body )
  `(multiple-value-bind (,(intern (concatenate 'string prefix (symbol-name symbol)))
			 ,(intern (concatenate 'string prefix (symbol-name symbol) "<VARIABLE>*"))
			 ,(intern (concatenate 'string "FOUND-" prefix (symbol-name symbol))))
			(,symbol)
			,@body))



;;;
;;;		VIII.	<LHS>
;;;
;;; <LHS> returns 4 values
;;; 1) The parse of the SP's <LHS> into OPS5 like conditions.
;;; 2) The list of all of the variables positively bound in the LHS.
;;; 3) T iff the parse succeeded.
;;; 4) The list of the list of variables positively bound in each coundition element.

(defun <LHS> ()
  (let-grammar-values (<CE-GROUP> :prefix "FIRST-")
    (unless found-first-<CE-GROUP> 
     (sptop-lhs-error "LHS's must contain at least on condition element group."))
      (let-grammar-values (<CE-GROUP>*)
        (unless (eq (peek-lexeme) *end-of-input*)
	  (sptop-lhs-error "Parsed an entire LHS but had extra input left over."))
	(if (> found-<CE-GROUP>* 0)
	    (values
	      (nconc first-<CE-GROUP> <CE-GROUP>*)
	      (union (reduce #'union first-<CE-GROUP><VARIABLE>*  :initial-value nil)
		      (reduce #'union <CE-GROUP>*<VARIABLE>* :initial-value nil))
	      t
	      (nconc first-<CE-GROUP><VARIABLE>* <CE-GROUP>*<VARIABLE>*)
	      )
	    (values
	      first-<CE-GROUP>
	      (reduce #'union first-<CE-GROUP><VARIABLE>* :initial-value nil)
	      t
	      first-<CE-GROUP><VARIABLE>*
	      )))))


;;;
;;;		IX.	<CE-GROUP>
;;;
;;;Returns on success:
;;; 1) a list of OPS5 condition elements, possibly on conjoined in ({ ... }).
;;; 2) a list of the set of variables postively bound in each
;;; 3) T.

(defun <CE-GROUP> ()
  ;; Fixed this up to eat right parenthesis, return the right lists for negations and to
  ;; eat preferences. -BGM 1/29/89
  ;; Added <simple-ce> call to catch - (goal <g> ^a a b). -BGM 1/27/89.
  ;; Added the not over not semantic error check.-BGM 1/11/88
  (cond ((eq (peek-lexeme) '-)
	   (get-lexeme)
	   (symbol-table-negation-start)
	   (cond 
	     ((and (eq (peek-lexeme) *left-parenthesis*)
		)
	      ;; Catch - ( ...) here to prevent the negating of conjunctions. 
	      (get-lexeme)
	      (let-grammar-values (<simple-ce>)
		(unless found-<simple-ce>
		 (sptop-lhs-error "found a negated condition element's start but could not find any tests."))
		(unless (eq (peek-lexeme) *right-parenthesis*)
			;; It would be nice to parse on and notice that they indeed do have an 
			;; extra test there, but it would require significant parser changes. 
		  (sptop-lhs-error "expecting a right parenthesis to end a negated simple condition element. ~
		    You either have a syntactically incorrect CE or perhaps you have more than one ~
		    value test; for Soar 4 and 5 negated condition elements can have only one ~
		    attribute/value test. If so, use a negated conjunctive condition element."))
		(get-lexeme) ; Eat the right parenthesis.
		(values (get-list (get-cons '- <simple-ce>)) <simple-ce><variable>* t)))
	     (t
	       (let-grammar-values (<+CE-GROUP>)
		(unless found-<+CE-GROUP>
		 (sptop-lhs-error "Found a - at top level in the LHS expected a condition element group."))
		;; Kill all bindings made within a not. 
		(symbol-table-negation-end)
		;; The user can enter -(goal <g> -^size a b) here, this is a syntactic error on
		;; his part, which I will signal now. 
		(when (member '- <+CE-GROUP> :key #'car :test #'eq)
		 (sptop-lhs-error 
		   "Found a - preceeding a condition element, but it contained a negated attribute test. ~
		   Perhaps you really want a conjunctive negation or only one negation."))
		;; Suspected bug involving -(goal <g> ^size a ^size b) here.
		(values (mapcar #'(lambda (<+CE>) (get-list '- <+CE>)) <+CE-GROUP>)
			<+CE-GROUP><VARIABLE>*
			;; Pass back the variables for the <LHS>.
			;; Somehow the new bindings made inside of the not must be
			;; expurgated here. Only positive bindings survive in 
			;; the symbol table so I'll do the check there.
			t)))))
	(t (<+CE-GROUP>))))
			      


;;;
;;;		X.	<CE-GROUP>*
;;;
;;;Returns on success:
;;; 1) a list of OPS5 condition elements
;;; 2) a list of the set of variables postively bound in each
;;; 3) T.

(defun <CE-GROUP>* () (zero-or-more (<CE-GROUP>) :join :nconc))



;;;
;;;		XI.	<+CE-GROUP>
;;;
;;;Returns on success:
;;; 1) a list of OPS5 condition elements
;;; 2) a list of the set of variables postively bound in each
;;; 3) T.

(defun <+CE-GROUP> ()
  (cond ((eq (peek-lexeme) '{)
         (get-lexeme)
	 (let-grammar-values (<CE-GROUP>)
           (unless found-<CE-GROUP>
       	    (sptop-lhs-error "Found a { at top level in a LHS, started parsing a condition element group ~
	      but could not find a first sub condition element group."))
	   (let-grammar-values (<CE-GROUP>*)
            (unless (eq (peek-lexeme) '})
	     (sptop-lhs-error "Parsing a condition element group but did not find closing }."))
            (get-lexeme)
	    (if (> found-<CE-GROUP>* 0)
		(values 
		  (get-list 
		    (get-cons '{ (nconc <CE-GROUP> <CE-GROUP>* (get-list '}))))
		  (get-list 
		    (reduce #'union 
			    (nconc <CE-GROUP><VARIABLE>* <CE-GROUP>*<VARIABLE>*)
			    :initial-value nil))
		  t)
	        (values
		  (get-list (get-cons '{ (nconc <CE-GROUP> (get-list '}))))
		  (get-list (reduce #'union <CE-GROUP><VARIABLE>* :initial-value nil))
		  t)))))
	(t (<+CE>))))



;;;
;;;		XII.	<+CE>
;;;
;;;Returns on success:
;;; 1) a list of OPS5 condition elements
;;; 2) a list of the set of variables postively bound in each
;;; 3) T.

(defun <+CE> ()
  (when (eq (peek-lexeme) *left-parenthesis*)
   (get-lexeme)
   ;; Keep track of the number of soar condition elements we have seen.
   (when (eq (peek-lexeme) 'preference)
    (sptop-lhs-error "found a condition element whose class is preference. Soar 5.0 no longer represents ~
 preferences as wmes, and so you can not match then in the LHS of an SP."))
   (let-grammar-values (<+CEREST>)
     (unless found-<+CEREST> 
	(sptop-lhs-error "found a condition element's start but could not find any tests."))
     (unless (eq (peek-lexeme) *right-parenthesis*)
	(sptop-lhs-error "expecting a right parenthesis to end a condition element."))
     (get-lexeme)
     (values <+CEREST>
	     <+CEREST><VARIABLE>*
	     t))))



;;;
;;;		XIV.	Positive-<Test>p
;;;

(defun positive-<test>p (<test>)
  (cond ((atom <test>) t)
	((listp <test>)
	 (if (eq (car <test>) '-) nil t))))


;;; 
;;;		XV.	<+CEREST>
;;;
;;;Returns on success:
;;; 1) a list of OPS5 condition elements
;;; 2) a list of the set of variables postively bound in each
;;; 3) T.

(defun <+CEREST> ()
  ;; Added not zerop to found-<test>*. 1/27/89
  (let-grammar-values (<CONJUNCTIVE-TEST> :prefix "CLASS-") 
   (let-grammar-values (<CONJUNCTIVE-TEST> :prefix "IDENTIFIER-")
    (let-grammar-values (<TEST>*)
     (unless (or found-class-<CONJUNCTIVE-TEST> found-identifier-<CONJUNCTIVE-TEST>
		 (not (zerop found-<TEST>*)))
      (sptop-lhs-error "Started parsing a condition element but could not find any tests in it."))
     (when (and found-class-<conjunctive-test> (symbolp class-<conjunctive-test>))
       ;; Possibly restrict this so that it can only be an atom or a warning is generated or some such.
       ;; Add in the class name so that restart-soar can cleanly remove its properties later.
       (create-new-class class-<conjunctive-test>))
     (let ((class-test (if found-class-<CONJUNCTIVE-TEST> class-<CONJUNCTIVE-TEST> '*unbound*))
	   (identifier-test ; If there is no identifier test found, pass an *unbound* on to reorder.
	     (if (and found-identifier-<CONJUNCTIVE-TEST> identifier-<CONJUNCTIVE-TEST>)
		 identifier-<CONJUNCTIVE-TEST> '*unbound*)))
       ;; Unless the <test>* has a positive test, I want to pop
       ;; the last binding of any positively bound variables.
       ;; I don't think that this test is right; what about multiple entries of a variable ?
       ;; Change.
       (unless (some #'positive-<test>p <test>*)
	 (mapc #'symbol-table-pop-last-entry-of-variable class-<CONJUNCTIVE-TEST><VARIABLE>*)
	 (mapc #'symbol-table-pop-last-entry-of-variable identifier-<CONJUNCTIVE-TEST><VARIABLE>*))
       ;; There was a cons sharing bug here, so I inserted the copy-trees as sptoptoreorder
       ;; thinks that it owns those conses.
       (if (> found-<TEST>* 0)
	   (values 
	     (mapcar #'(lambda (<TEST>) 
			 (if (eq (car <test>) '-)
			     (get-list '- 
			       (get-cons 
				(copy-tree class-test)
				(get-cons identifier-test (copy-tree (cdr (nth 1 <TEST>))))))
			   (get-cons (copy-tree class-test)
			     (get-cons (copy-tree identifier-test) (cdr <TEST>)))))
		       <TEST>*)
	     (mapcar #'(lambda (<TEST><VARIABLE>*)
			 (copy-tree
			   (union class-<CONJUNCTIVE-TEST><VARIABLE>*
			   (union  identifier-<CONJUNCTIVE-TEST><VARIABLE>*
				  <TEST><VARIABLE>*))))
		     <TEST>*<VARIABLE>*)
	     t)
	 (values 
	   (get-list (get-list class-test identifier-test  '*unbound*  '*unbound*  nil))
	   ;; When I get no <test>s in DSM I need to return *unbound* attribute and value tests followed by a nil,
	   ;; otherwise I get a test that could possibly match an acceptable preference.
	   (get-list (nunion class-<CONJUNCTIVE-TEST><VARIABLE>* identifier-<CONJUNCTIVE-TEST><VARIABLE>*))
	   t)))))))


;;;
;;;		XVI.	<PREFERENCE-CE>
;;;
;;;Returns on success:
;;; 1) a list of an OPS5 preference condition element
;;; 2) the list of the set of variables postively bound in it 
;;; 3) T.


;;;
;;;		XVII.	<PREFERENCE-ATTRIBUTE-TEST>*
;;;
;;;Returns on success:
;;; 1) a list of a preference attribute test (^ preference-attribute conjunctive-test>)
;;; 2) the set of variables postively bound in it 
;;; 3) T.



;;;
;;;		XVIII.	<PREFERENCE-ATTRIBUTE-TEST>
;;;
;;;Returns on success:
;;; 1) a list of a preference attribute test (^ preference-attribute conjunctive-test>)
;;; 2) the set of variables postively bound in it 
;;; 3) T.


;;;
;;;		XIX.	<PREFERENCE-ATTRIBUTE>
;;;
;;;
;;;Returns on success:
;;; 1) a preference attribute
;;; 2) nil
;;; 3) T.



;;;
;;;		XX.	<TEST>*
;;;
;;;Returns on success:
;;; 1) a list of attribute tests 
;;; 2) the list of the set of variables positively bound in each
;;; 3) T.

(defun <TEST>* () (zero-or-more (<TEST>) :join :nconc :join-variables :nconc))



;;;
;;;		XXI.	<TEST>
;;;
;;;Returns on success:
;;; 1) a list of negated attribute tests (- (^ attribute test)).
;;; 2) the list of the set of variables positively bound in each
;;; 3) T.

(defun <TEST> ()
  (cond ((eq (peek-lexeme) '-)
	 (get-lexeme)
         (symbol-table-negation-start)
	   ;; This form places a mark on the symbol table which
	   ;; is popped below. This is a defun and not a
           ;; macro so that it need not catch values from values forms.
           (let-grammar-values (<+TEST>)
            (unless found-<+TEST>
              (sptop-lhs-error  "found a - expecting a test."))
	    (symbol-table-negation-end)
	    (values (mapcar #'(lambda (test) (get-list '- test)) <+TEST>)
		    <+TEST><VARIABLE>*
		    t)))
	(t (<+TEST>))))



;;;
;;;		XXII.	<+TEST>
;;;
;;;Returns on success:
;;; 1) a list of attribute tests (^ attribute test)
;;; 2) the list of the set of variables positively bound in each
;;; 3) T.

(defun <+TEST> () 
  (cond ((eq (peek-lexeme) '^)
	 (get-lexeme)
	 (let-grammar-values (<CONJUNCTIVE-TEST>)
	   (unless found-<CONJUNCTIVE-TEST>
             (sptop-lhs-error 
	       "found an ^ expecting a possibly conjunctive test, most likely an attribute name."))
	   (let-grammar-values (<CONJUNCTIVE-TEST-+?>+)
	    (if found-<CONJUNCTIVE-TEST-+?>+
	      (let ((<+TEST>s nil)
		    (<VARIABLE>** nil))
		;; Build the list of the tests and the list of the variables used in each test.
		;; Is thie variable building stuff right ? Doesn't one-or-more union them in ?
		(do* ((CTs <CONJUNCTIVE-TEST-+?>+            (cdr CTs))
		      (CT  (car CTs)                      (car CTs))
		      (Vss  <CONJUNCTIVE-TEST-+?>+<VARIABLE>* (cdr Vss))
		      (Vs   (car Vss)                       (car Vss)))
		     ((null CTs))
                 (push (get-cons '^ (get-cons <CONJUNCTIVE-TEST> CT)) <+TEST>s)
		 (push (union <CONJUNCTIVE-TEST><VARIABLE>* Vs) <VARIABLE>**))
		(values 
		  (nreverse <+TEST>s)
		  (nreverse <VARIABLE>**)
		  t))
	      (values 
		(get-list (get-list '^ <CONJUNCTIVE-TEST>   '*UNBOUND*  nil))
		(get-list <CONJUNCTIVE-TEST><VARIABLE>*)
		t)))))
	(t (values nil nil))))



;;;
;;;		XXIIII.	<CONJUNCTIVE-TEST-+?>
;;;
;;;Returns on success:
;;; 1) a list of the test and + or the test and nil.
;;; 2) the list of the set of variables positively bound in the <CONJUNCTIVE-TEST>
;;; 3) T if it found a conjunctive test, nil otherwise.

(defun <CONJUNCTIVE-TEST-+?> () 
  (let-grammar-values (<CONJUNCTIVE-TEST>)
   (when found-<CONJUNCTIVE-TEST>
     (cond ((eq (peek-lexeme) '+)
	    (get-lexeme)
	    (values (get-list <CONJUNCTIVE-TEST> '+) <CONJUNCTIVE-TEST><VARIABLE>* t)
	    )
	   (t (values (get-list <CONJUNCTIVE-TEST> nil) <CONJUNCTIVE-TEST><VARIABLE>* t))))))


;;;
;;;		XXIV.	  <CONJUNCTIVE-TEST-+?>+
;;;
;;;Returns on success:
;;; 1) a list of tests
;;; 2) the list of the set of variables positively bound in each
;;; 3) T.

(defun   <CONJUNCTIVE-TEST-+?>+ ()
  (one-or-more (  <CONJUNCTIVE-TEST-+?>) 
	       :join-variables :push))


;;;
;;;		XXV.	<CONJUNCTIVE-TEST>?
;;;
;;;Returns on success:
;;; 1) a test
;;; 2) the set of variables positively bound in these tests
;;; 3) T.

(defun <CONJUNCTIVE-TEST>? () (zero-or-one (<CONJUNCTIVE-TEST>)))



;;;
;;;		XXVI.	<CONJUNCTIVE-TEST>
;;;
;;;Returns on success:
;;; 1) a test
;;; 2) the set of variables positively bound in these tests
;;; 3) T.

(defun <CONJUNCTIVE-TEST> ()
  (cond ((eq (peek-lexeme) '{)
	 (get-lexeme)
	 (let-grammar-values (<DISJUNCTIVE-TEST>)
	   (unless found-<DISJUNCTIVE-TEST>
            (sptop-lhs-error "expecting a first possibly disjunctive test inside of a conjunctive test."))
	   (let-grammar-values (<DISJUNCTIVE-TEST>+)
             (unless found-<DISJUNCTIVE-TEST>+
              (sptop-lhs-error 
                "expecting at least one more possibly disjunctive test inside of a conjunctive test."))
	     (unless (eq (peek-lexeme) '})
		     (sptop-lhs-error "expecting the closing } of a conjunctive test."))
	     (get-lexeme)
	     (values (get-cons '{ (get-cons <DISJUNCTIVE-TEST> 
					    (nconc <DISJUNCTIVE-TEST>+ (get-list '}))))
		     (nunion  <DISJUNCTIVE-TEST><VARIABLE>*
			      <DISJUNCTIVE-TEST>+<VARIABLE>*)
		     t))))
	(t ;; No need to test for a no parse error here, 
           ;; it gets caught down in <SINGLE-TEST>.
	  (<DISJUNCTIVE-TEST>))))



;;;
;;;		XXVII.	<DISJUNCTIVE-TEST>+
;;;
;;;Returns on success:
;;; 1) a list of possibly disjunctive tests 
;;; 2) the set of variables positvely bound in them
;;; 3) T.

(defun <DISJUNCTIVE-TEST>+ () (one-or-more (<DISJUNCTIVE-TEST>)))



;;;
;;;		XXXVIII.	<DISJUNCTIVE-TEST>
;;;
;;;Returns on success:
;;; 1) a single test
;;; 2) the set of its variables
;;; 3) T.

(defun <DISJUNCTIVE-TEST> ()
  (cond ((eq (peek-lexeme) '<<)
	 (get-lexeme)
	 (let-grammar-values (<CONSTANT>)
	   (declare (ignore <CONSTANT><VARIABLE>*))
	   (unless found-<CONSTANT>
            (sptop-lhs-error "expecting a first constant test inside of a disjunctive test."))
	   (let-grammar-values (<CONSTANT>+)
             (declare (ignore <CONSTANT>+<VARIABLE>*))
             (unless found-<CONSTANT>+
              (sptop-lhs-error "expecting at least one more constant test inside of a disjunctive test."))
	     (unless (eq (peek-lexeme) '>>)
		     (sptop-lhs-error "expecting the closing >> of a disjunctive test."))
	     (get-lexeme)
	     (values (get-cons '<< (get-cons <CONSTANT> (nconc <CONSTANT>+ (get-list '>>))))
		     nil ; No variables can be found in a disjunction.
		     t))))
	(t ;; No need to test for a no parse error here, 
           ;; it gets caught down in <SINGLE-TEST>.
	  (<RELATIONAL-TEST>))))


;;;
;;;		XXIX.	<CONSTANT>+
;;;
;;;Returns on success:
;;; 1) a list symbols, numbers or strings.
;;; 2) nil 
;;; 3) T.


(defun <CONSTANT>+ () (one-or-more (<CONSTANT>)))



;;;
;;;		XXX.	<CONSTANT>
;;;
;;;Returns on success:
;;; 1) a symbol, number or string
;;; 2) nil 
;;; 3) T.


(defun <CONSTANT> ()
  (mor (<SYMBOL-NOT-SPECIAL>) (<NUMBER>) (<STRING>)))



;;;
;;;		XXXI.	<RELATIONAL-TEST>
;;;
;;;Returns on success:
;;; 1) a list of a relation and a single test
;;; 2) nil 
;;; 3) T.
;;; OR
;;; 1) A single test
;;; 2) a list of a variable, if the single test is a variable
;;; 3) T.

(defun <RELATIONAL-TEST> () 
  (let-grammar-values (<RELATION>)
    (declare (ignore <RELATION><VARIABLE>*))
    (cond (found-<RELATION>		       
	    (let-grammar-values (<SINGLE-TEST>)
	      (declare (ignore <SINGLE-TEST><VARIABLE>*))
	      (unless found-<SINGLE-TEST>
		(sptop-lhs-error "parsed relation ~A but could not find a single test after it."
		  <RELATION>))
	      (legal-<RELATION><SINGLE-TEST> <RELATION> <SINGLE-TEST>)
	      (values (get-list <RELATION> <SINGLE-TEST>) nil t)))
	  (t 
	    (let-grammar-values (<SINGLE-TEST>)
	      (when (and found-<SINGLE-TEST> (variablep <SINGLE-TEST>))
		;; This is a positive occurance of a variable, so it gets a 
		;; new symbol table entry.
		 (add-variable-to-symbol-table <SINGLE-TEST> -1))
	      (values <SINGLE-TEST> <SINGLE-TEST><VARIABLE>* found-<SINGLE-TEST>))))))


;;;
;;;		XXXII.	<RELATION>
;;;
;;;Returns on success:
;;; 1) a relation
;;; 2) nil
;;; 3) T.


(defun <RELATION> ()
  (let ((peek (peek-lexeme)))
    (case peek
      ((<> < > <= >= = <=>) (values (get-lexeme) nil t))
      (t (values nil nil nil)))))



;;;
;;;		XXXIII.	<SINGLE-TEST>
;;;
;;;	As this parse must always succeed, an error is signalled immediately when
;;; it can not parse correctly.
;;;
;;;Returns on success:
;;; 1) a variable or constant
;;; 2) the list of the variable or nil
;;; 3) T.


(defun <SINGLE-TEST> ()
  (mor (<VARIABLE>) (<CONSTANT>)))


;;;
;;;		XXXIV.	<SYMBOL-NOT-SPECIAL>
;;;
;;;	If the next input is a symbol, and has a package as
;;; the lexer's special symbols are gensymed and so have not package,
;;; and its not a special symbol, then you have a symbol.
;;;
;;;Returns on success:
;;; 1) a symbol which is not a variable or special symbol
;;; 2) nil
;;; 3) T.
;;; This should just have  in front of the (+ clause, but CMU lisp is
;;; to braindammaged, but within standard, to read this.

(defun  <SYMBOL-NOT-SPECIAL>  ()
  (let ((peek (peek-lexeme)))
    (and (symbolp peek)
	 (symbol-package (the symbol peek))
	 (case peek
	   (({ } << >> ^ -) (values nil nil nil))
	   ;; the - used to appear in two of these cases (as it is used in
	   ;; two different contexts) but CoralCommonLisp complained; the
	   ;; return values being equal, I randomly chose to remove the -
	   ;; from the second case -- TFMcG 7-Aug-90
	   ;; ((+ - |,| ~ ! < = > & @ ) (values nil nil nil))
	   ((+ |,| ~ ! < = > & @ ) (values nil nil nil))
	   (t (values (get-lexeme) nil t))))))

(defun   <BOGUS> ()
  (let ((peek (peek-lexeme)))
    (and (symbolp peek)
	 (symbol-package (the symbol peek))
	 (case peek
	   (({ } << >> ^ -) (values nil nil nil))
	   (t (values (get-lexeme) nil t))))))

;;;
;;;		XXXV.	<NUMBER>
;;;
;;;Returns on success:
;;; 1) a number
;;; 2) nil
;;; 3) T.


(defun <NUMBER> ()
  (when (numberp (peek-lexeme)) 
    (values (get-lexeme) nil t)))


;;;
;;;		XXXVI.	<STRING>
;;;
;;;Returns on success:
;;; 1) a string
;;; 2) nil
;;; 3) T.


(defun <STRING> ()
  (when (stringp (peek-lexeme)) 
    (values (get-lexeme) nil t)))


;;;
;;;		XXXVII.	<VARIABLE>
;;;
;;;Returns on success:
;;; 1) a variable
;;; 2) a list of the variable
;;; 3) T.

(defun <VARIABLE> ()
  (when (variablep (peek-lexeme)) 
    (let ((<VARIABLE> (get-lexeme)))
      (values <VARIABLE> (get-list <VARIABLE>) t))))



;;;
;;;		XXXVIII.	<SIMPLE-CE>
;;;

(defun <SIMPLE-CE> ()
  ;; Added a or null <test>? to allow testless ces. -BGM 1/29/89
  ;; Added 1/27/89 to prevent -(c i ^v a0 a1) and also -(c i -^v ...). -BGM 1/27/89
  (let-grammar-values (<CONJUNCTIVE-TEST> :prefix "CLASS-") 
   (let-grammar-values (<CONJUNCTIVE-TEST> :prefix "IDENTIFIER-")
    (let-grammar-values (<TEST>?)
     (unless (or found-class-<CONJUNCTIVE-TEST> found-identifier-<CONJUNCTIVE-TEST>
		 (not (zerop found-<TEST>?)))
      (sptop-lhs-error "Started parsing a negated condition element but could not find any tests in it."))
     (when (and found-class-<conjunctive-test> (symbolp class-<conjunctive-test>))
       ;; Possibly restrict this so that it can only be an atom or a warning is generated or some such.
       ;; Add in the class name so that restart-soar can cleanly remove its properties later.
       (create-new-class class-<conjunctive-test>))
     (unless (null (cdr <test>?))
       (sptop-lhs-error "expecting a right parenthesis to end a negated simple condition element. ~
	 You either have a syntactically incorrect CE or perhaps you have more than one ~
	 value test; for Soar 4 and 5 negated condition elements can have only one ~
	 attribute/value test. If so, use a negated conjunctive condition element."))

     (let ((class-test (if found-class-<CONJUNCTIVE-TEST> class-<CONJUNCTIVE-TEST> '*unbound*))
	   (identifier-test ; If there is no identifier test found, pass an *unbound* on to reorder.
	     (if (and found-identifier-<CONJUNCTIVE-TEST> identifier-<CONJUNCTIVE-TEST>)
		 identifier-<CONJUNCTIVE-TEST> '*unbound*)))
       (unless (or (null <test>?) (some #'positive-<test>p <test>?))
        (sptop-lhs-error 
	  "Found a - preceeding a condition element, but it contained a negated attribute test. ~
	  Perhaps you really want a conjunctive negation or only one negation."))
       ;; There was a cons sharing bug here, so I inserted the copy-trees as sptoptoreorder
       ;; thinks that it owns those conses.
       ;; Simpler code would do here as I know that I have only zero or one <test>?.
       (if (> found-<TEST>? 0)
	   (values 
	     (mapcar #'(lambda (<TEST>) 
			 (if (eq (car <test>) '-)
			     (get-list '- 
			       (get-cons 
				(copy-tree class-test)
				(get-cons identifier-test (copy-tree (cdr (nth 1 <TEST>))))))
			   (get-cons (copy-tree class-test)
			     (get-cons (copy-tree identifier-test) (cdr <TEST>)))))
		       <TEST>?)
	     (mapcar #'(lambda (<TEST><VARIABLE>*)
			 (copy-tree
			   (union class-<CONJUNCTIVE-TEST><VARIABLE>*
			   (union  identifier-<CONJUNCTIVE-TEST><VARIABLE>*
				  <TEST><VARIABLE>*))))
		     <TEST>?<VARIABLE>*)
	     t)
	 (values 
	   (get-list (get-list class-test identifier-test  '*unbound*  '*unbound*  nil))
	   ;; When I get no <test>s in DSM I need to return *unbound* attribute and value tests followed by a nil,
	   ;; otherwise I get a test that could possibly match an acceptable preference.
	   (get-list (nunion class-<CONJUNCTIVE-TEST><VARIABLE>* identifier-<CONJUNCTIVE-TEST><VARIABLE>*))
	   t)))))))


;;;
;;;		XXXIX.		<TEST>?
;;;

(defun <TEST>? () (zero-or-one (<TEST>)))

;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/spparserhs.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	SpParseRhs
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/spparserhs.lisp.
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the RHS parsing function for the SP to P parser.
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	RHS grammar
;;;	I.	Sp-Parse-RHS
;;;	II.	<RHS>
;;;	III.	<RHS-ACTION>*
;;;	IV.	<RHS-ACTION>
;;;	V.	<CALL2-HALT-TABSTOP-WRITE1-OR-WRITE2>
;;;	VI.	<BIND>
;;;	VII.	<BIND-BODY>?
;;;	VIII.	<BIND-BODY>
;;;	IX.	<ACCEPT-COMPUTE-OR-CALL2-BY-DEFAULT>
;;;	X.	<ACCEPT>
;;;	XI.	<HALT>
;;;	XII.	<WRITE1>
;;;	XIII.	<WRITE2>
;;;	XIV.	<CRLF>
;;;	XV.	<TABTO>
;;;	XVI.	<TABSTOP>
;;;	XVII.	<VARIABLE-OR-INTEGER>
;;;	XVIII.	<WRITE-ITEM>+
;;;	XIX.	<WRITE-ITEM>
;;;	XX.	<TABTO-CRLF-OR-COMPUTE>
;;;	XXI.	<CALL2>
;;;	XXII.	<VARIABLE-OR-SYMBOL>
;;;	XXIII.	<VARIABLE-OR-CONSTANT>*
;;;	XXIV.	<VARIABLE-OR-CONSTANT>
;;;	XXV.	<MAKE>
;;;	XXVI.	<PREFERENCE-MAKE>
;;;	XXVII.	<PREFERENCE-ATTRIBUTE-MAKE>+
;;;     XXVIII.	<PREFERENCE-ATTRIBUTE-NAME-VALUE>
;;;	XXIX.	<PREFERENCE-ROLE-MAKE>
;;;	XXX.	<PREFERENCE-ROLE>
;;;	XXXI.	<PREFERENCE-VALUE-MAKE>
;;;	XXXII.	<PREFERENCE-VALUE>
;;;	XXXIII.	<PREFERENCE-G-P-S-O-R-MAKE>
;;;	XXXIV.	<G-P-S-O-R>
;;;	XXXV.	<MAKE-BODY>
;;;	XXXVI.	<ATTRIBUTE-MAKE>+
;;;	XXXVII.	<ATTRIBUTE-MAKE>
;;;	XXXVIII.	<VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>+
;;;	XXXIX.	<VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>
;;;	XL.	<ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>
;;;	XLI.	<INTEGER>
;;;	XLII.	<COMPUTE>
;;;	XLIII.	<E>
;;;	XLIV.	<Ep>
;;;	XLV.	<T>
;;;	XLVI.	<Tp>
;;;	XLVII.	<F>
;;;	XLVIII.	<NUMBER-OR-VARIABLE>
;;;	XLIX.	<PREFERENCE>
;;;	L.	<PREFERENCE-SPECIFIER>
;;;	LI.	<NATURALLY-UNARY-PREFERENCE>
;;;	LII.	<FORCED-UNARY-PREFERENCE>
;;;	LIII.	<BINARY-PREFERENCE>
;;;	LIV.	<PREFERENCE>*
;;;	LV.	<VARIABLE-OR-ANY-SYMBOL>
;;;	LVI.	<VARIABLE-OR-ANY-CONSTANT>
;;;	LVII.	<ANY-CONSTANT>
;;;	LVIII.	<SYMBOL>
;;;	LIX.	<VARIABLE-OR-ANY-CONSTANT>*
;;;	LX.	<CALL2-BY-DEFAULT>
;;;	LXI.	<OPENFILE1>
;;;	LXII.	<CLOSEFILE1>
;;;	LXIII.	<DEFAULT>
;;;	LXIV.	<VARIABLE-OR-STRING>
;;;	LXV.	<VARIABLE-OR-SYMBOL>+
;;;	LXVI.	<PREFERENCE-SPECIFIER>*
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")

(eval-when (compile eval load) (proclaim '(special *current-lexeme-count*)))


;;;
;;;		iv.	RHS grammar
;;;
;;;	See the notes on the grammar description in spparselhs.lisp.
;;;
;;;
;;;	<RHS>		::=	<RHS-ACTION>*
;;;	<RHS-ACTION>	::=	( <BIND> | <CALL2> | <HALT> | <TABSTOP> | <WRITE1> | <WRITE2> | <OPENFILE1> | <CLOSEFILE1> | <DEFAULT> | <MAKE>)
;;;	<BIND>		::=	bind <VARIABLE> <BIND-BODY>? 
;;;	<BIND-BODY>	::=	<ACCEPT> | <COMPUTE> | <CALL2-BY-DEFAULT>
;;;	<ACCEPT>	::=     accept <VARIABLE-OR-SYMBOL>+
;;;	<HALT>		::=	halt
;;;	<WRITE1>	::=	write1 <WRITE-ITEM>+
;;;	<WRITE2>	::=	write2 <WRITE-ITEM>+
;;;	<CRLF>		::=	crlf
;;;	<TABTO>		::=	tabto <VARIABLE-OR-INTEGER>
;;;	<TABSTOP>	::=	tabstop <VARIABLE-OR-INTEGER>
;;;	<WRITE-ITEM>	::=	( <TABTO> ) | ( <CRLF> ) | ( <COMPUTE> ) | <VARIABLE> | <CONSTANT>
;;;	<CALL2>		::=	call2 <VARIABLE-OR-SYMBOL> <VARIABLE-OR-CONSTANT>*
;;;     <OPENFILE1>     ::=
;;;	     openfile1  <VARIABLE-OR-SYMBOL> <VARIABLE-OR-STRING> <VARIABLE-OR-SYMBOL>
;;;     <CLOSEFILE1>    ::=     closefile1 <VARIABLE-OR-SYMBOL>+
;;;     <DEFAULT>       ;;=     default    <VARIABLE-OR-SYMBOL> <VARIABLE-OR-SYMBOL>
;;;	<VARIABLE-OR-SYMBOL>    
;;;                     ::=     <VARIABLE> | <SYMBOL>
;;;	<VARIABLE-OR-CONSTANT>
;;;			::=	<VARIABLE> | <CONSTANT>
;;;	<MAKE>		::=	 | <MAKE-BODY> 
;;;	                ::=      <MAKE-BODY>
;;;	
;;;			::=	preference <VARIABLE-OR-SYMBOL> <PREFERENCE-ATTRIBUTE-MAKE>+
;;;
;;;	
;;;			::=	^ <PREFERENCE-ROLE-MAKE>  |
;;;				^ <PREFERENCE-VALUE-MAKE> |
;;;				^ <PREFERENCE-G-P-S-O-R-MAKE>
;;;		
;;;			::=	ROLE <PREFERENCE-ROLE>
;;;	
;;;			::=	problem-space | state | operator | <VARIABLE>
;;;	
;;;			::=	VALUE <PREFERENCE-VALUE>
;;;	
;;;			::=	ACCEPTABLE | REJECT | BEST | WORST | BETTER | WORSE | REQUIRE | 
;;;                             INDIFFERENT | PARALLEL | <VARIABLE>
;;;	
;;;			::=	<G-P-S-O-R> <VARIABLE-OR-SYMBOL>
;;;	
;;;                     ::=     GOAL | PROBLEM-SPACE | STATE | OPERATOR | REFERENCE
;;;	<MAKE-BODY>	::=	<VARIABLE-OR-SYMBOL> <VARIABLE-OR-SYMBOL> <ATTRIBUTE-MAKE>+
;;;	<ATTRIBUTE-MAKE> 
;;;                     ::=      <VARIABLE-OR-SYMBOL> <VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>+
;;;                     ::=      ^ <VARIABLE-OR-SYMBOL> <PREFERENCE>*
;;;     <PREFERENCE>    ::= <VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE> <PREFERENCE-SPECIFIER>
;;;	 The <VCACOC> above could be made into <VCACOC>* and we could have the <PS> apply to all of
;;;       the variables if we care someday.
;;;     <PREFERENCE-SPECIFIER> 
;;;                     ::= <NATURALLY-UNARY-PREFERENCE> 
;;;			::= <FORCED-UNARY-PREFERENCE>
;;;                     ::= <BINARY-PREFERENCE> <VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>
;;;                     ::= epsilon 
;;;	Note: This changes the style of the lexer and parser as it is now a TWO symbol look ahead!
;;;	<NATURALLY-UNARY-PREFERENCE>  ::= + | - | ! | ~ | @
;;;	<FORCED-UNARY-PREFERENCE> ::= <BINARY-PREFERENCE> [, | ) | ^]
;;;	Note: This changes the syntax of common lisp to have "," a separating macro! 
;;;           Dangerous for lisp hacking but nice for Soar.
;;;	 Forced-unary-preference should do the lookahead for the ",", ")" and "^" but should not read in
;;;       the ")" or the "^" as <RHS-ACTION> or <ATTRIBUTE-MAKE> does this. 
;;;      Sloppy grammar writing but it is an artifact of the grammars construction and simpler.
;;;	<BINARY-PREFERENCE> ::= > | = | < | &
;;;	<VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>
;;;			::=  <VARIABLE> | <CONSTANT> 
;;;                     ::=  ( <ACCEPT> ) | ( <COMPUTE> ) | ( <CALL2-BY-DEFAULT> )
;;;	<CALL2-BY-DEFAULT>
;;;     		::=	call2? <VARIABLE-OR-SYMBOL> <VARIABLE-OR-CONSTANT>*
;;;      Call2's inside of makes and binds may drop their call2 symbol.
;;;	<INTEGER>	::=	a common lisp fixnum, as a bignum number of tabs would be awful.
;;;	<NUMBER>	::=     a common lisp number.
;;;	<NUMBER-OR-VARIABLE> 
;;;                     ::= <VARIABLE> | <NUMBER>
;;;	<COMPUTE>	::= compute <EXPRESSION>
;;;	This is straight out of the dragon book. Is the precedence right ?
;;;	<E>		::= <T> <Ep>
;;;	<Ep>		::= (+ | -) <T> <Ep> | epsilon
;;;     <T>		::= <F><Tp>
;;;	<Tp>		::= ( * | / | \\ ) <F> <Tp> | epsilon
;;;	<F>		::= ( <E> ) | <NUMBER-OR-VARIABLE>
;;;     


;;;
;;;		I.	SP-Parse-RHS
;;;

(defvar *sp-lhs-variables* nil 
       "The set of variables found positively bound on the lhs.")
(eval-when (compile eval load) (proclaim '(list *sp-lhs-variables*)))

(defun sp-parse-rhs (rhs <LHS><VARIABLE>*)
  (initialize-lexer rhs)
  (let-grammar-values (<RHS>)
    ;; Postprocess the condition elements of the RHS for connectedness again.
    (unless (eq (peek-lexeme) *end-of-input*)
      (sptop-rhs-error 
	"parsed a RHS but had extra lexemes left over; you must have an ungramatical construct."))
    (connected-<RHS>-p rhs <RHS><VARIABLE>* <LHS><VARIABLE>*)
    (values <RHS> <RHS><VARIABLE>* found-<RHS>)))


;;;
;;;		II.	<RHS> 
;;;

(defun <RHS> ()
  (<RHS-ACTION>*))


;;;
;;;		III.	<RHS-ACTION>* 
;;;

(defun <RHS-ACTION>* () (zero-or-more (<RHS-ACTION>) :join :nconc :join-variables :push))


;;;
;;;		IV.	<RHS-ACTION> 
;;;

(defvar *start-of-last-rhs-action* 0
  "The starting postion of the last rhs action. 
   The error printing for the rhs uses this to determine where to start printing from.")
(eval-when (compile eval load) (proclaim '(fixnum *start-of-last-rhs-action*)))


(defun <RHS-ACTION> ()
  (when (eq (peek-lexeme) *left-parenthesis*)
    (get-lexeme)
    (setq *start-of-last-rhs-action* *current-lexeme-count*)
    ;; Remember the position of the start of this rhs-action.
    (let-grammar-values (<CALL2-HALT-TABSTOP-WRITE1-WRITE2-OPENFILE1-CLOSEFILE1-OR-DEFAULT>)
      (cond (found-<CALL2-HALT-TABSTOP-WRITE1-WRITE2-OPENFILE1-CLOSEFILE1-OR-DEFAULT>
	      (unless (eq (peek-lexeme) *right-parenthesis*)
		;; Don't know how to signall this. Need to have
		;; a ballanced list in.
		(sptop-rhs-error "did not find a close parenthesis after a rhs action."))
	      (get-lexeme)
	      (values (get-list <CALL2-HALT-TABSTOP-WRITE1-WRITE2-OPENFILE1-CLOSEFILE1-OR-DEFAULT>) 
		      <CALL2-HALT-TABSTOP-WRITE1-WRITE2-OPENFILE1-CLOSEFILE1-OR-DEFAULT><VARIABLE>* t))
	    (t 
	      (let-grammar-values (<BIND>)
		(declare (ignore <BIND><VARIABLE>*))
               (cond (found-<BIND>
		       (unless (eq (peek-lexeme) *right-parenthesis*)
			 (sptop-rhs-error "did not find a close parenthesis after a rhs action."))
		       (get-lexeme)
		       (values (get-list <BIND>) nil t)
		       )
		     (t 
		       (let-grammar-values (<MAKE>)
			;; This clause will never fire as the <MAKE> will fail. -BGM 7/11/88.
			 (unless found-<MAKE>
			   (sptop-rhs-error 
			     "found a form on the rhs but it does not seem to be a legal action."))
			 (unless (eq (peek-lexeme) *right-parenthesis*)
			   (sptop-rhs-error "did not find a close parenthesis after a rhs action."))
			 (get-lexeme)
			 ;; When any of the variables here are connected,
			 ;; throw the other variables into the set.
			 (when (some #'(lambda (variable) (member variable *sp-lhs-variables*))
				       <MAKE><VARIABLE>*)
			   (setq *sp-lhs-variables* (nunion <MAKE><VARIABLE>* *sp-lhs-variables*)))
			 (values <MAKE> <MAKE><VARIABLE>* t))))))))))


;;;
;;;		V.	<CALL2-HALT-TABSTOP-WRITE1-WRITE2-OPENFILE1-CLOSEFILE1-OR-DEFAULT>
;;;

(defun <CALL2-HALT-TABSTOP-WRITE1-WRITE2-OPENFILE1-CLOSEFILE1-OR-DEFAULT> ()
  (mor (<CALL2>) (<HALT>) (<TABSTOP>) (<WRITE1>) (<WRITE2>) 
       (<OPENFILE1>) (<CLOSEFILE1>) (<DEFAULT>)))


;;;
;;;		VI.	<BIND> 
;;;

(defun <BIND> ()
   ;; Modified to know about soar-bind for the TI. -BGM 3/27/89
 (when (eq (peek-lexeme) #+:TI 'soar-bind #-:TI 'bind)
   (get-lexeme)
   (let-grammar-values (<VARIABLE>)
     (unless found-<VARIABLE> 
       (sptop-rhs-error "parsing a bind action, but could not find the variable to be bound."))
     (let-grammar-values (<BIND-BODY>?)
      ;; If I'm binding one variable to another
      ;; then add the connectedness information.
      ;; Is this correct ?
      (when (variablep <bind-body>?)
        (if (and (member <bind-body>? *sp-lhs-variables*)
		 (not (member <variable> *sp-lhs-variables*)))
	    (get-push <variable> *sp-lhs-variables*)))
      (values 
	(if (zerop found-<BIND-BODY>?)  (get-list 'bind <VARIABLE>)
            (get-list #+:TI 'soar-bind #-:TI 'bind <VARIABLE> <BIND-BODY>?))
	(nunion <VARIABLE><VARIABLE>* <BIND-BODY>?<VARIABLE>*)
	t)))))


;;;
;;;		VII.	<BIND-BODY>? 
;;;

(defun <BIND-BODY>? () (zero-or-one (<BIND-BODY>)))


;;;
;;;		VIII.	<BIND-BODY> 
;;;

(defun <BIND-BODY> ()
  (cond ((eq (peek-lexeme) *left-parenthesis*)
	 (get-lexeme)
	 (let-grammar-values (<ACCEPT-COMPUTE-OR-CALL2-BY-DEFAULT>)
	   (declare (ignore <ACCEPT-COMPUTE-OR-CALL2-BY-DEFAULT><VARIABLE>*))
	   (unless found-<ACCEPT-COMPUTE-OR-CALL2-BY-DEFAULT>
	     (sptop-rhs-error 
	       "parsing the body of a bind action, expecting but could not find an accept, compute or call2."))
           (unless (eq (peek-lexeme) *right-parenthesis*)
	     (sptop-rhs-error "did not find a close parenthesis after the body of a bind."))
           (get-lexeme)
           (values <ACCEPT-COMPUTE-OR-CALL2-BY-DEFAULT> nil t)))
	(t (<VARIABLE-OR-CONSTANT>))))


;;;
;;;		IX.	<ACCEPT-COMPUTE-OR-CALL2-BY-DEFAULT>				      
;;;

(defun <ACCEPT-COMPUTE-OR-CALL2-BY-DEFAULT> () (mor (<ACCEPT>) (<COMPUTE>) (<CALL2-BY-DEFAULT>)))



;;;
;;;		X.	<ACCEPT> 
;;;

(defun <ACCEPT> ()
  ;; Updated to the correct grammar. -BGM 2/9/89
  (when (eq (peek-lexeme) 'accept)
    (get-lexeme)
    (let-grammar-values (<VARIABLE-OR-SYMBOL>)
     (declare (ignore <VARIABLE-OR-SYMBOL><VARIABLE>*))
     (cond (found-<VARIABLE-OR-SYMBOL>
	     (values (get-list 'accept <variable-or-symbol>) nil t))
	   (t (values (get-list 'accept) nil t))))))


;;;
;;;		XI.	<HALT> 
;;;

(defun <HALT> ()
  (when (eq (peek-lexeme) 'halt)
    (get-lexeme)
    (values (list 'halt) nil t)))


;;;
;;;		XII.	<WRITE1> 
;;;

(defun <WRITE1> ()
  (when (eq (peek-lexeme) 'write1)
    (get-lexeme)
    (let-grammar-values (<WRITE-ITEM>+)
      (declare (ignore <WRITE-ITEM>+<VARIABLE>*))
      (unless found-<WRITE-ITEM>+
        (sptop-rhs-error "parsing a write action, but could not find one or more items to write out."))
      (values (get-cons 'write1 <WRITE-ITEM>+) nil t))))


;;;
;;;		XIII.	<WRITE2> 
;;;

(defun <WRITE2> ()
  (when (eq (peek-lexeme) 'write2)
    (get-lexeme)
    (let-grammar-values (<WRITE-ITEM>+)
      (declare (ignore <WRITE-ITEM>+<VARIABLE>*))
      (unless found-<WRITE-ITEM>+
        (sptop-rhs-error "parsing a write action, but could not find one or more items to write out."))
      (values (get-cons 'write2 <WRITE-ITEM>+) nil t))))


;;;
;;;		XIV.	<CRLF> 
;;;

(defun <CRLF> ()
  (when (eq (peek-lexeme) 'crlf)
   (get-lexeme)
   (values (get-list 'crlf) nil t)))


;;;
;;;		XV.	<TABTO> 
;;;

(defun <TABTO> ()
 (when (eq (peek-lexeme) 'tabto)
   (get-lexeme)
   (let-grammar-values (<VARIABLE-OR-INTEGER>)
     (declare (ignore <VARIABLE-OR-INTEGER><VARIABLE>*))
     (unless found-<VARIABLE-OR-INTEGER>
       (sptop-rhs-error 
	 "parsing the body of a tabto action but could not find a variable or integer tab value."))
     (values (get-list 'tabto <VARIABLE-OR-INTEGER>) nil t))))
     


;;;
;;;		XVI.	<TABSTOP> 
;;;

(defun <TABSTOP> ()
 (when (eq (peek-lexeme) 'tabstop)
   (get-lexeme)
   (let-grammar-values (<VARIABLE-OR-INTEGER>)
     (declare (ignore <VARIABLE-OR-INTEGER><VARIABLE>*))
     (unless found-<VARIABLE-OR-INTEGER>
       (sptop-rhs-error 
	 "parsing the body of a tabstop action but could not find a variable or integer tab value."))
     (values (get-list 'tabstop <VARIABLE-OR-INTEGER>) nil t))))


;;;
;;;		XVII.	<VARIABLE-OR-INTEGER> 
;;;

(defun <VARIABLE-OR-INTEGER> () (mor (<VARIABLE>) (<INTEGER>)))


;;;
;;;		XVIII.	<WRITE-ITEM>+ 
;;;

(defun <WRITE-ITEM>+ () (one-or-more (<WRITE-ITEM>)))


;;;
;;;		XIX.	<WRITE-ITEM> 
;;;

(defun <WRITE-ITEM> ()
  (cond ((eq (peek-lexeme) *left-parenthesis*)
          (get-lexeme)
          (let-grammar-values (<TABTO-CRLF-OR-COMPUTE>)
	   (declare (ignore <TABTO-CRLF-OR-COMPUTE><VARIABLE>*))
	   (unless found-<TABTO-CRLF-OR-COMPUTE>
             (sptop-rhs-error "parsing an item inside of a write, found a left parenthesis but could not ~
                find a tabto, crlf or compute."))
           (unless (eq (peek-lexeme) *right-parenthesis*)
             (sptop-rhs-error "parsed a write item but could not find a closing right parenthesis."))
	   (get-lexeme)
          (values <TABTO-CRLF-OR-COMPUTE> nil t)))
       (t (mor (<CONSTANT>) (<VARIABLE>)))))


;;;
;;;		XX.	<TABTO-CRLF-OR-COMPUTE>
;;;

(defun <TABTO-CRLF-OR-COMPUTE> ()
  (mor (<TABTO>) (<CRLF>) (<COMPUTE>)))


;;;
;;;		XXI.	<CALL2> 
;;;

(defun <CALL2> ()
  (when (eq (peek-lexeme) 'call2)
   (get-lexeme)
   (let-grammar-values (<VARIABLE-OR-ANY-SYMBOL>)
     (declare (ignore <VARIABLE-OR-ANY-SYMBOL><VARIABLE>*))
     ;; This probably should repeat the P semantic check for
     ;; an external declaration.
     (unless found-<VARIABLE-OR-ANY-SYMBOL>
       (sptop-rhs-error 
	 "found a call2 action but could not find a variable or symbol to call as a function."))
     (values (get-cons 'call2 (get-cons <VARIABLE-OR-ANY-SYMBOL> (<VARIABLE-OR-ANY-CONSTANT>*))) nil t))))


;;;
;;;		XXII.	<VARIABLE-OR-SYMBOL> 
;;;

(defun <VARIABLE-OR-SYMBOL> () (mor (<VARIABLE>) (<SYMBOL-NOT-SPECIAL>)))


;;;
;;;		XXIII.	<VARIABLE-OR-CONSTANT>*
;;;

(defun <VARIABLE-OR-CONSTANT>* () (zero-or-more (<VARIABLE-OR-CONSTANT>)))


;;;
;;;		XXIV.	<VARIABLE-OR-CONSTANT> 
;;;

(defun <VARIABLE-OR-CONSTANT> () (mor (<VARIABLE>) (<CONSTANT>)))


;;;
;;;		XV.	<MAKE> 
;;;

(defun <MAKE> () 
                  (<MAKE-BODY>))

;;;
;;;		XVI.	<PREFERENCE-MAKE> 
;;;


;;;
;;;		XXVII.	<PREFERENCE-ATTRIBUTE-MAKE>+
;;;


;;;
;;;		XXVII.	<PREFERENCE-ATTRIBUTE-MAKE> 
;;;
;;;	I really want to check here that the user has specified both a role and a value,
;;; and if he specified a reference he needs a binary value and vice versa.


;;;
;;;		XXVIII.	<PREFERENCE-ATTRIBUTE-NAME-VALUE>
;;;


;;;
;;;		XXIX.	<PREFERENCE-ROLE-MAKE> 
;;;


;;;
;;;		XXX.	<PREFERENCE-ROLE> 
;;;


;;;
;;;		XXXI.	<PREFERENCE-VALUE-MAKE> 
;;;


;;;
;;;		XXXII.	<PREFERENCE-VALUE> 
;;;


;;;
;;;		XXXIII.	<PREFERENCE-G-P-S-O-R-MAKE> 
;;;


;;;
;;;		XXXIV.	<G-P-S-O-R> 
;;;


;;;
;;;		XXXV.	<MAKE-BODY> 
;;;
      

(defun <MAKE-BODY> ()
  (when (eq (peek-lexeme) 'preference)
    (sptop-rhs-error
     "parsing a RHS found an old style preference make. Soar5.0 does not support old style preferences."))
 (let-grammar-values (<VARIABLE-OR-SYMBOL> :prefix "CLASS-")
  (unless found-class-<VARIABLE-OR-SYMBOL> 
   (sptop-rhs-error 
		    "parsing a preference make, but could not find a symbol or variable for the ~
     wme's class."))
  (let-grammar-values (<VARIABLE-OR-SYMBOL> :prefix "IDENTIFIER-")
    (unless found-identifier-<VARIABLE-OR-SYMBOL>
     (sptop-rhs-error 
       "parsing a preference make, found the class but could not find a variable or ~
       symbol for the identifier."
       ))
   (let-grammar-values (<ATTRIBUTE-MAKE>+)
    (unless found-<ATTRIBUTE-MAKE>+
      (sptop-rhs-error 
	"parsing a preference make, found the class and identifier but could not find ~
	one or more attribute makes."
	))
   (let ((nunion 
	    (nunion class-<VARIABLE-OR-SYMBOL><VARIABLE>*
	      (nunion 
		    identifier-<VARIABLE-OR-SYMBOL><VARIABLE>*
		    <ATTRIBUTE-MAKE>+<VARIABLE>*))))
    ;; Repatched wierd franz values bug so that connected-<rhs>-p test gets the right
    ;; variable list. -BGM 8/24/89.
    (values (mapcar #'(lambda (attribute-value) 
			(get-cons   'make-preference
			(get-cons class-<VARIABLE-OR-SYMBOL>
			  (get-cons identifier-<VARIABLE-OR-SYMBOL> attribute-value))))
		    <ATTRIBUTE-MAKE>+)
	    nunion
	    #| Patched to workaround franz inc values problem. -BGM 7/17/89
(nunion class-<VARIABLE-OR-SYMBOL><VARIABLE>*
	      (nunion 
		    identifier-<VARIABLE-OR-SYMBOL><VARIABLE>*
		    <ATTRIBUTE-MAKE>+<VARIABLE>*))|#
	    t))))))



;;;
;;;		XXXVI.	<ATTRIBUTE-MAKE>+ 
;;;

(defun <ATTRIBUTE-MAKE>+ () (one-or-more (<ATTRIBUTE-MAKE>) :join :nconc))


;;;
;;;		XXXVII.	<ATTRIBUTE-MAKE> 
;;;

;; This is the second half of <attribute-make> for Soar 4.5.

(defun <attribute-make-5> (<ATTRIBUTE> <ATTRIBUTE><VARIABLE>*)
  ;; Modified to hande a different return case from <PREFERENCE>*. -BGM 3/9/89
  (let-grammar-values (<PREFERENCE>*)
   (unless found-<PREFERENCE>*
     (sptop-rhs-error "found an ^ attribute, but could not find a value preference combination afterwards."))
   (let ((union (union <PREFERENCE>*<VARIABLE>* <ATTRIBUTE><VARIABLE>*)	))
    ;; Repatched wierd franz values bug so that connected-<rhs>-p test gets the right
    ;; variable list. -BGM 8/24/89.
   (values
     (mapcar #'(lambda (<PREFERENCE>) (get-cons <ATTRIBUTE> <PREFERENCE>)) <PREFERENCE>*)
     union
     #| Patched to work around Fran Inc's values problem -BGM 7/17/89
     (union <PREFERENCE>*<VARIABLE>* <ATTRIBUTE><VARIABLE>*) |#
     t))))

			
(defun <ATTRIBUTE-MAKE> ()
 (when (eq (peek-lexeme) '^)
   (get-lexeme)
   (let-grammar-values (<VARIABLE-OR-SYMBOL>)
    (unless found-<VARIABLE-OR-SYMBOL>
      (sptop-rhs-error 
	"parsing an attribute make inside of a preference make, found an ^ ~
	but could not find a variable or symbol for the attribute's name."
	))
    (<ATTRIBUTE-MAKE-5> <VARIABLE-OR-SYMBOL> <VARIABLE-OR-SYMBOL><VARIABLE>*))))


;;;
;;;		XXXVIII.	<VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>+
;;;


;;;
;;;		XXXIX.	<VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE> 
;;;

(defun <VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE> ()
  (cond ((eq (peek-lexeme) *left-parenthesis*)
	 (get-lexeme)
	 (let-grammar-values (<ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>)
           (unless found-<ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>
            (sptop-rhs-error 
	      "parsing a preference make, found an attribute make followed by a left parenthesis ~
              but could not find a following accept, call2 or compute."
	      ))
           (unless (eq (peek-lexeme) *right-parenthesis*)
            (sptop-rhs-error 
	      "parsing a preference make, found an attribute make followed by an accept, call2 or ~
               compute but it would not parse correctly. Perhaps you are missing a right parenthesis, ~
               or have extraneous lexemes before it."
	      ))
           (get-lexeme)
	   (values <ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE> <ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE><VARIABLE>* t)))
	(t (mor (<VARIABLE>) (<CONSTANT>)))))



;;;
;;;		XL.	<ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>
;;;

(defun <ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE> ()
  ;; Changed <call2> to <call2-by-default>. -BGM 12/17/88
 (mor (<ACCEPT>) (<COMPUTE>) (<CALL2-BY-DEFAULT>)))


;;;
;;;		XLI.	<INTEGER> 
;;;

(defun <INTEGER> ()
  ;; Replaced fixnump with integerp. -BGM 4/4/89
  (when (integerp (peek-lexeme)) (values (get-lexeme) nil t)))



;;;
;;;		XLII.	<COMPUTE> 
;;;

(defun <COMPUTE> ()
  (when (eq (peek-lexeme) 'compute)
    (get-lexeme)
    (values (get-cons 'compute (<E>)) nil t)))


;;;
;;;		XLIII.	<E> 
;;;

(defun <E> ()
  (let-grammar-values (<T>)
    (declare (ignore <T><VARIABLE>*))
    (unless found-<T>
      (sptop-rhs-error "error parsing a compute expression."))
    (let-grammar-values (<Ep>)
      (declare (ignore <Ep><VARIABLE>*))
     (unless found-<Ep>
       (sptop-rhs-error "error parsing a compute expression."))
      (values (nconc <T> <Ep>) nil t))))



;;;
;;;		XLIV.	<Ep>
;;;

(defun <Ep> () 
 (cond ((or (eq (peek-lexeme) '+) (eq (peek-lexeme) '-))
	(let ((operator (get-lexeme)))
          (let-grammar-values (<T>)
	    (declare (ignore <T><VARIABLE>*))
	    (unless found-<T>
              (sptop-rhs-error "error parsing a compute expression."))
	    (let-grammar-values (<Ep>)
	      (declare (ignore <Ep><VARIABLE>*))
              (unless found-<Ep>
                (sptop-rhs-error "error parsing a compute expression."))
	      (values (get-cons operator (nconc <T> <Ep>)) nil t)))))
       (t (values nil nil t))))
	      


;;;
;;;		XLV.	<T> 
;;;

(defun <T> ()
  (let-grammar-values (<F>)
    (declare (ignore <F><VARIABLE>*))
   (unless found-<F>
     (sptop-rhs-error "error parsing a compute expression."))
     (values (nconc <F> (<Tp>)) nil t)))



;;;
;;;		XLVI.	<Tp> 
;;;

(defun <Tp> () 
  (cond ((or (eq (peek-lexeme) '*) (eq (peek-lexeme) '/ ) (eq (peek-lexeme) '\\ ))
	 (let ((operator (get-lexeme)))
	   (let-grammar-values (<F>)
	     (declare (ignore <F><VARIABLE>*))
	     (unless found-<F> 
               (sptop-rhs-error "error while parsing a compute expression."))
             (let-grammar-values (<Tp>)
	       (declare (ignore <Tp><VARIABLE>*))
               (unless found-<Tp>
                 (sptop-rhs-error "error while parsing a compute expression."))
	       (values (get-cons operator (nconc <F> <Tp>)) nil t)))))
	(t (values nil nil t))))
               


;;;
;;;		XLVII.	<F> 
;;;

(defun <F> () 
  (cond ((eq (peek-lexeme) *left-parenthesis*)
          (get-lexeme)
	  (let-grammar-values (<E>)
	    (declare (ignore <E><VARIABLE>*))
            (unless found-<E> 
	      (sptop-rhs-error "error while parsing a compute expression."))
	    (unless (eq (peek-lexeme) *right-parenthesis*)
	      (sptop-rhs-error "error while parsing a compute expression."))
	    (get-lexeme)
	    (values (get-list <E>) nil t)))
	(t (let-grammar-values (<NUMBER-OR-VARIABLE>)
	     (declare (ignore <NUMBER-OR-VARIABLE><VARIABLE>*))
	    (when found-<NUMBER-OR-VARIABLE>
	      (values (get-list <NUMBER-OR-VARIABLE>) nil t))))))



;;;
;;;		XLVIII.	<NUMBER-OR-VARIABLE>
;;;

(defun <NUMBER-OR-VARIABLE> () (mor (<number>) (<variable>)))


;;;
;;;		XLIX.	<PREFERENCE>
;;;

(defun <PREFERENCE> ()
  ;; Changed the '(+) into a '((+)). -BGM 4/12/89
  ;; Modified by BGM on 3/9/89 to handle more than one preference specifier
  ;; for each <VCACOC>.
  (let-grammar-values (<VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>)
   (when found-<VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>
    (let-grammar-values (<PREFERENCE-SPECIFIER>*)
      (declare (ignore found-<PREFERENCE-SPECIFIER>*))
     (let ((union (union <VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE><VARIABLE>* 
	           <PREFERENCE-SPECIFIER>*<VARIABLE>*)))
    ;; Repatched wierd franz values bug so that connected-<rhs>-p test gets the right
    ;; variable list. -BGM 8/24/89.
      (values 
	(mapcar #'(lambda (<PREFERENCE-SPECIFIER>)
		    (get-cons <VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE> <PREFERENCE-SPECIFIER>))
		(or <PREFERENCE-SPECIFIER>* '((+))))
	union
	#| Patched to work around Fran INc's value problem.BGM  7/17/89
	(union <VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE><VARIABLE>* 
	       <PREFERENCE-SPECIFIER>*<VARIABLE>*) |#
	      t))))))

;;;
;;;		L.	<PREFERENCE-SPECIFIER>
;;;

(defun <PREFERENCE-SPECIFIER> ()
 ;; Modified to return NIL unless it actually finds a preference 
 ;; symbol. -BGM 3/9/89
  (let-grammar-values (<NATURALLY-UNARY-PREFERENCE>)
   (declare (ignore <NATURALLY-UNARY-PREFERENCE><VARIABLE>*))
   (if found-<NATURALLY-UNARY-PREFERENCE>
      (values (get-list <NATURALLY-UNARY-PREFERENCE>) nil t)
      (let-grammar-values (<FORCED-UNARY-PREFERENCE>)
        (declare (ignore <FORCED-UNARY-PREFERENCE><VARIABLE>*))
       (if found-<FORCED-UNARY-PREFERENCE>
           (values (get-list <FORCED-UNARY-PREFERENCE>) nil t)
           (let-grammar-values (<BINARY-PREFERENCE>)
	     (when found-<BINARY-PREFERENCE>
	      (let-grammar-values (<VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>)
		   (if found-<VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>
		      (values (get-list <BINARY-PREFERENCE> <VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE>)
			      (union <VARIABLE-CONSTANT-ACCEPT-CALL2-BY-DEFAULT-OR-COMPUTE><VARIABLE>*
				     <BINARY-PREFERENCE><VARIABLE>*)
			      t)
		      (sptop-rhs-error "error while parsing a <PREFERENCE>, found a binary preference symbol~
                                            , ~A, but it did not proceed a comma, an ^, the end of the make or ~
                                            a variable, constant accept, call2 or compute."
					  <BINARY-PREFERENCE>))))))))))


;;;
;;;		LI.	<NATURALLY-UNARY-PREFERENCE>
;;;
;;; Returns three values: 
;;; 1) The preference symbol returned or nil.
;;; 2) NIL, the set of variables found.
;;; 3) T if it found a variable symbol, nil otherwise.
;;;

(defun <NATURALLY-UNARY-PREFERENCE> () 
 (when (member (peek-lexeme) '(+ - ! ~ @))
   (values (get-lexeme) nil t)))


;;;
;;;		LII.	<FORCED-UNARY-PREFERENCE>
;;;
;;; Returns:
;;; 1) The preference symbol, if it found it followed by a , a ) or an ^.
;;; 2) NIL, for the variables found.
;;; 3) T if it found its symbols, else nil.
;;; This routine only devours a following comma, not the right parenthesis.
;;;

;;;  I'd like this to be #+'sed out, but CMULisp is too broken (but within standard)
;;; to read this correctly. -BGM 12/12/88

(defun <FORCED-UNARY-PREFERENCE> ()
 ;; Added check for eof for smakes. -BGM 1/28/89
  (when (member (peek-lexeme) '(> = < &))
    (cond ((eq (peek-lexeme-1) '|,|) 
	   (let ((preference-symbol (get-lexeme)))
	     (get-lexeme) ; Consume the comma.
	     (values preference-symbol nil t)))
	  ((or (eq (peek-lexeme-1) '^)
	       (eq (peek-lexeme-1) *right-parenthesis*)
	       (eq (peek-lexeme-1) *end-of-input*))
	   (values (get-lexeme) nil t)))))


;;;
;;;		LIII.	<BINARY-PREFERENCE>
;;;
;;; Returns three values: 
;;; 1) The preference symbol found or nil.
;;; 2) the set of variables found.
;;; 3) T if it found a preference symbol.

(defparameter *binary-preferences* '(> = < &)
  "The list of binary preference symbols.")

(defun <BINARY-PREFERENCE> ()
  (when (member (peek-lexeme) *binary-preferences*)
    (values (get-lexeme) nil t)))


;;;
;;;		LIV.	<PREFERENCE>*
;;;
 
(defun <PREFERENCE>* ()
 ;; Added the :join :nconc. -BGM 4/12/89
 (zero-or-more (<PREFERENCE>) :join :nconc))


;;;
;;;		LV.	<VARIABLE-OR-ANY-SYMBOL>
;;;
;;; Since CALL2 can use any symbol, including a special symbol, we need a 
;;; special version of <variable-or-symbol> and <variable-or-constant>.

(defun <VARIABLE-OR-ANY-SYMBOL> () (mor (<VARIABLE>) (<SYMBOL>)))


;;;
;;;		LVI.	<VARIABLE-OR-ANY-CONSTANT>
;;;
;;; Since CALL2 can use any symbol, including a special symbol, we need a 
;;; special version of <variable-or-symbol> and <variable-or-constant>.

(defun <VARIABLE-OR-ANY-CONSTANT> () (mor (<VARIABLE>) (<ANY-CONSTANT>)))



;;;
;;;		LVII.	<ANY-CONSTANT>
;;;

(defun <ANY-CONSTANT> ()
  (mor (<SYMBOL>) (<NUMBER>) (<STRING>)))



;;;
;;;		LVIII.	<SYMBOL>
;;;
;;;	A symbol can not be a parenthesis or end of input;
;;; to test this we check for the lack of package as gensyms
;;; have no package and *left-parenthesis* et all are gensyms.
;;;

(defun <SYMBOL> ()
  (let ((peek (peek-lexeme)))
    (when (and (symbolp peek) (symbol-package peek))
      (values (get-lexeme) nil t))))


;;;
;;;		LIX.	<VARIABLE-OR-ANY-CONSTANT>*
;;;

(defun <VARIABLE-OR-ANY-CONSTANT>* () (zero-or-more (<VARIABLE-OR-ANY-CONSTANT>)))



;;;
;;;		LX.	<CALL2-BY-DEFAULT>
;;;

(defun <CALL2-BY-DEFAULT> ()
  (cond ((eq (peek-lexeme) 'call2) (<call2>))
	(t 
	  ;; Assume that I've got a call two as I found a parenthesis before this.
	  (let-grammar-values (<VARIABLE-OR-ANY-SYMBOL>)
	    (declare (ignore <VARIABLE-OR-ANY-SYMBOL><VARIABLE>*))
	    ;; This probably should repeat the P semantic check for
	    ;; an external declaration.
	    (unless found-<VARIABLE-OR-ANY-SYMBOL>
	     (sptop-rhs-error 
	       "found a list, expecting that its a call2 action but could not find a variable or symbol to call as a function."))
	    (values (get-cons 'call2 (get-cons <VARIABLE-OR-ANY-SYMBOL> (<VARIABLE-OR-ANY-CONSTANT>*)))
		    nil t)))))


;;;
;;;		LXI.	<OPENFILE1>
;;;

(defun <OPENFILE1> ()
 (when (eq (peek-lexeme) 'openfile1)
   (get-lexeme)
   (let-grammar-values (<VARIABLE-OR-SYMBOL> :prefix "FILE-NAME-")
    (declare (ignore FILE-NAME-<VARIABLE-OR-SYMBOL><VARIABLE>*))
    (unless found-file-name-<VARIABLE-OR-SYMBOL>
      (sptop-rhs-error "found an openfile1 action but could not find ~
	a variable or symbol to name the file."))
    (let-grammar-values (<VARIABLE-OR-STRING>)
     (declare (ignore <VARIABLE-OR-STRING><VARIABLE>*))
     (unless found-<VARIABLE-OR-STRING>
       (sptop-rhs-error "found an openfile1 action but could not find ~
	 a variable or string to name the file for the system."))
     (let-grammar-values (<VARIABLE-OR-SYMBOL> :prefix "IN-OR-OUT-")
      (declare (ignore IN-OR-OUT-<VARIABLE-OR-SYMBOL><VARIABLE>*))
      (unless found-IN-OR-OUT-<VARIABLE-OR-SYMBOL>
	(sptop-rhs-error "found an openfile1 action but could not ~
	  find a variable or symbol to specify in or out."))
      (when (not (variablep IN-OR-OUT-<VARIABLE-OR-SYMBOL>))
       (unless (member IN-OR-OUT-<VARIABLE-OR-SYMBOL> '(in out))
	 (sptop-rhs-error "found an openfile1 action, and a symbol ~
	   meant to specify in or out, ~A, but it was not in or out."
			IN-OR-OUT-<VARIABLE-OR-SYMBOL>)))
      (values
	(get-list 'openfile1 FILE-NAME-<VARIABLE-OR-SYMBOL>
		  <VARIABLE-OR-STRING> IN-OR-OUT-<VARIABLE-OR-SYMBOL>)
	nil 
	t))))))



;;;
;;;		LXII.	<CLOSEFILE1>
;;;

(defun <CLOSEFILE1> ()
  (when (eq (peek-lexeme) 'closefile1)
   (get-lexeme)
   (let-grammar-values (<VARIABLE-OR-SYMBOL>+)
     (declare (ignore <VARIABLE-OR-SYMBOL>+<VARIABLE>*))
     (unless found-<VARIABLE-OR-SYMBOL>+ 
      (sptop-rhs-error "found a closefile1 action but could not find ~
       one or more variables or symbols to name the files."))
     (values (get-cons 'closefile1 <VARIABLE-OR-SYMBOL>+) nil t))))



;;;
;;;		LXIII.	<DEFAULT>
;;;

(defun <DEFAULT> ()
 (when (eq (peek-lexeme) 'default)
  (get-lexeme)
  (let-grammar-values (<VARIABLE-OR-SYMBOL> :prefix "FILE-")
    (declare (ignore FILE-<VARIABLE-OR-SYMBOL><VARIABLE>*))
    (unless found-FILE-<VARIABLE-OR-SYMBOL>
      (sptop-rhs-error "found a default action but could not find a ~
       variable or a symbol to specify a file."))
   (let-grammar-values (<VARIABLE-OR-SYMBOL> :prefix "LOCATION-")
    (declare (ignore LOCATION-<VARIABLE-OR-SYMBOL><VARIABLE>*))
    (unless found-LOCATION-<VARIABLE-OR-SYMBOL>
      (sptop-rhs-error "found a default action but could not find a ~
         variable or a symbol to specify which default to set."))
    (unless (variablep LOCATION-<VARIABLE-OR-SYMBOL>)
     (unless (member LOCATION-<VARIABLE-OR-SYMBOL> '(trace write accept))
      (sptop-rhs-error "found a default action and a symbol to ~
        specify a which default to set, ~A, but it was not one of ~
        trace, write or accept." LOCATION-<VARIABLE-OR-SYMBOL>)))
    (values (get-list 'default 
		      FILE-<VARIABLE-OR-SYMBOL> 
		      LOCATION-<VARIABLE-OR-SYMBOL>)
	    nil t)))))



;;;
;;;		LXIV.	<VARIABLE-OR-STRING>
;;;

(defun <VARIABLE-OR-STRING> () (mor (<VARIABLE>) (<STRING>)))



;;;
;;;		LXV.	<VARIABLE-OR-SYMBOL>+
;;;

(defun <VARIABLE-OR-SYMBOL>+ () (one-or-more (<VARIABLE-OR-SYMBOL>)))


;;;
;;;		LXVI.	<PREFERENCE-SPECIFIER>*
;;;

(defun <PREFERENCE-SPECIFIER>* () (zero-or-more (<PREFERENCE-SPECIFIER>)))

;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/sptop.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	SPtoP
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/sptop.lisp.
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the SP macro, which separates the LHS and
;;; RHS out of the SP, parses each, checking all semantic conditions, signalling
;;; and neatly printing error messages for any problems that it finds, and
;;; finally passing the parsed production onto the old reorderer.
;;; 
;;; 
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	SP Variables
;;;	II.	Get-SP-LHS
;;;	III.	Get-SP-RHS
;;;	IV.	SP
;;;	V.	Compiled-SP
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")
(eval-when (compile eval load) (proclaim '(optimize (speed 3) (safety 0))))



;;;
;;;		I.	SP Variables
;;;

(defvar *soar-production-name* nil
 "The name of the production which is currently being parsed in sp.")


;;;
;;;		II.	Get-SP-LHS
;;;
;;; The LHS returned is a top level copy, as some lisps seem
;;; to think that they own the conses of a macro call.
;;; Often users believe that they also own then, so
;;; we leave these conses untouched.
;;;
;;;	This should be replaced by an iterative version 
;;; someday over the rainbow.

(defun get-sp-lhs (conditions-->actions)
 (assert (listp conditions-->actions))
 (cond ((eq (car conditions-->actions) '-->) nil)
       (t (get-cons (car conditions-->actions)
		    (get-sp-lhs (cdr conditions-->actions))))))


;;;
;;;		III.	Get-SP-RHS
;;;

(defun get-sp-rhs (conditions-->actions)
 (assert (listp conditions-->actions))
 (cdr (member '--> conditions-->actions :test #'eq)))


;;;
;;;		IV.	SP
;;;
;;; Remember not to break serial productions here.
;;; You must do the atom check for the first CE and then
;;; assume that it is either: decide, serial, elaborate.
;;; Decide is a no no, both others are okay.
;;; This compiled-sp allows SP's to compile now.
;;; Not that it does anthing real when you compile them,
;;; but at least we'll stop getting bug reports for this.
;;;

(defmacro sp (*soar-production-name* &rest conditions-->actions)
  `(compiled-sp ',*soar-production-name* ',conditions-->actions))



;;;
;;;		V.	Compiled-sp
;;;
;;; I'd move some of these tests forward, but Lucid has what I think is a bug with
;;; trapping *error-output* while macroexpanding. So, it would ruin
;;; my test code and do other strange things to user code.
;;;
;;; Lacunae: I could do the sptop compile at "compile time" and
;;; then we could save that time by loading partially compiled Soar productions,
;;; like sptop compiled and reordered. 
;;;

(defvar *delete-duplicate-ces-in-ps* nil
  "Delete duplicate (equal) condition elements before P compiling them ?")

(eval-when (compile eval load) (proclaim '(special *learn-ids*)))

(defun compiled-sp (*soar-production-name* conditions-->actions)
 ;; Updated to allow documentation strings. -BGM 3/27/89
 ;; Updated to use new gensym package.-BGM 3/5/89
 ;; Added a declare ignore. -BGM 1/27/89
 (let ((sp-ok (catch-sptop-errors
  #+:soar-times (start-soar-time real)
  #+:soar-times (start-soar-time run)
  #+:soar-times (start-soar-time sp)
  #+:soar-times (start-soar-time sptop)
  (initialize-soar-genvar) ;; I don't think this call really has to be here. 
  (setq *learn-ids* nil) ;; Initialize this damn thing for chunking.
  (unless (symbolp *soar-production-name*)
    (sptop-error ", SP name, ~A, is not a symbol." *soar-production-name*))
  (unless (member '--> conditions-->actions) (sptop-error ", missing -->."))
    (let ((documentation (when (stringp (first conditions-->actions))
			       (pop conditions-->actions))))
    (when (write-expansion conditions-->actions)
      (setq conditions-->actions 
	(sp-write-expand conditions-->actions (get-used-symbols conditions-->actions))))
    (let ((lhs (get-SP-lhs conditions-->actions)))
      (unless lhs (sptop-error ", empty LHS."))
      (let ((rhs (get-SP-rhs conditions-->actions)))
	(unless rhs (sptop-warning ", empty RHS."))
	(multiple-value-bind (parsed-lhs lhs-positively-bound-variables) (sp-parse-lhs lhs)
          (<LHS>-contains-a-positive-<CE> parsed-lhs)
	  (when *delete-duplicate-ces-in-ps*
	    (setq parsed-lhs (delete-duplicates parsed-lhs :test #'equal)))
	  (dispose-list lhs)
	 (multiple-value-bind (parsed-rhs rhs-positively-bound-variables)
	      (sp-parse-rhs rhs lhs-positively-bound-variables)
	      (declare (ignore rhs-positively-bound-variables))

	   ; Install optional waring for singley used variable on the lhs.
	      ;; Call P in the standard ugly old manner.
	      ;; The reorderer is such bad code that you can't give it a
	      ;; type of elaborate, only serial.
	      (let ((pbody (nconc (sptoptoreorder parsed-lhs) (get-cons '--> parsed-rhs))))
	      #+:soar-times (stop-soar-time sptop)
		(eval (reorder-p-conds
			(get-cons *soar-production-name* 
			  pbody))))))))
    (when documentation 
      ;(setf (documentation *soar-production-name* 'sp) documentation)
      ))T)))
  #+:soar-times (stop-soar-time sp)
  #+:soar-times (stop-soar-time real)
  #+:soar-times (stop-soar-time run)
  sp-ok))


;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/sptoptoreorder.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	Sptoptoreorder
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/sptoptoreorder.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file maps the results of the SpToP parser back to 
;;; the output generated by the old parser. The old parser
;;; would map this LHS into:
;;;   (goal <g> ^name <a>)
;;; - (b <g>)
;;; - (goal <g> ^name << a b c d >>)
;;;   (goal <g> -^name < 8)
;;;   (goal <g> ^size { <z> << a b c d e >> < 8 })
;;; -{ (goal <g> ^size <a>)
;;;    (goal <a> ^size < <g>) }
;;;	
;;; But the new one, maps it into:
;;;
;;;((GOAL <G> NAME <A>)
;;; (- (B <G>))
;;; (- (GOAL <G> NAME (<< A B C D >>)))
;;; (- (GOAL <G> NAME <A>))
;;; (GOAL <G> SIZE ({ <Z> (<< A B C D E >>) }))
;;; (- ({ (GOAL <G> SIZE <A>) (GOAL <A> SIZE <G>) })))
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	SptopToReoder
;;;	II.	Translate-<CE-GROUP>
;;;	III.	Translate-<CONJUNCTIVE-TEST>
;;;	IV.	mapcanallbutlast
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")
(eval-when (compile eval load) (proclaim '(optimize (speed 3) (safety 0))))



;;;
;;;		I.	SpToPToReorded
;;;

(defun sptoptoreorder (<lhs>)
  (assert (listp <LHS>))
  (mapcan #'translate-<ce-group> <LHS>))


;;;
;;;		II.	Translate-<CE-GROUP>
;;;

(defun translate-<CE-GROUP> (<CE-GROUP>)
  (cond ((eq (car <ce-group>) '{)
	 (sptop-lhs-warning "Soar does not yet support positive conjunctions of condition elements. ~
 Perhaps you forgot a -. Assuming normal positive conditions.")
	 (mapcanallbutlast #'translate-<ce-group> (cdr <ce-group>)))
	((eq (first <ce-group>) '-)
	 (if (eq '{ (first (second <ce-group>)))
	     (get-cons '- 
		(nconc 
		  (get-cons '{
			 (mapcanallbutlast #'translate-<ce-group> (rest (second <ce-group>))))
		  (get-list '})))
	   (get-cons '- (mapcan #'translate-<ce-group> (cdr <ce-group>)))))
	(t ; A primitive condition.
	  (assert (listp <CE-GROUP>))
	  (get-list (mapcan #'translate-<conjunctive-test> <CE-GROUP>)))))



;;;
;;;		III.	 Translate-<CONJUNCTIVE-TEST>
;;;

(defun translate-<conjunctive-test> (<conjunctive-test>)
  (if (and (listp <conjunctive-test>) (eq (car <conjunctive-test>) '{))
      (get-list (mapcan #'(lambda (item) (if (consp item) item (get-cons item nil)))
			<conjunctive-test>))
      (get-list <conjunctive-test>)))



;;;
;;;		IV.	mapcanallbutlast
;;;

(defun mapcanallbutlast (function list)
  (let ((new-list ()))
    (do ((listp list (cdr listp)))
	((null (cdr listp)))
     (push (funcall function (car listp)) new-list))
    ;; Should this be a reduce or an apply ?
  (reduce #'nconc (nreverse new-list))))


;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/ppwm.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	ppwm.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/ppwm.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file implements PPWM and SPPWM using a recursive descent
;;; parser.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	Grammar
;;;	v.	Compiled-Old-ppwm
;;;	I.	Dowm
;;;	II.	PPWM
;;;	III.	Compiled-ppwm
;;;	IV.	Sppwm
;;;	V.	Compiled-sppwm
;;;	VI.	Wme-matches-ce
;;;	VII.	Sp-parse-ppwm
;;;	?.	<PPWM+CE>
;;;	?.	<PPWM+CEREST> 
;;;	?.	<PPWM-PREFERENCE-CE>
;;;	?.	<PPWM-PREFERENCE-ATTRIBUTE-TEST>*
;;;	?.	<PPWM-PREFERENCE-ATTRIBUTE-TEST>
;;;	?.	<PPWM-PREFERENCE-ATTRIBUTE-NAME-VALUE>
;;;	?.      <PPWM-PREFERENCE-ROLE-TEST>	
;;;	?.	<PPWM-PREFERENCE-ROLE>
;;;	?.	<PPWM-PREFERENCE-VALUE-TEST>
;;;	?.	<PPWM-PREFERENCE-VALUE>
;;;	?.	<PPWM-PREFERENCE-G-P-S-O-R-TEST>
;;;	?.	<PPWM-TEST>*
;;;	?.	<PPWM-TEST>
;;;	?.	<PPWM-CONSTANT?-PREFERENCE?> 
;;;	?.	<PPWM-CONSTANT?-PREFERENCE?>*
;;;	?.	<CONSTANT>* 
;;;	?.	<PPWM-PREFERENCE-SPECIFIER>
;;;	?.	<PPWM-FORCED-UNARY-PREFERENCE>
;;;	?.	find-wmes-of-timetag-id-or-pattern
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")


;;;
;;;		iv.	Grammar
;;;
;;;	A call to PPWM (or SPPWM) is just like a simplified LHS CE.
;;; There are no disjunctions, conjunctions, relational tests or
;;; variables and in DSM you can search for preferences other than
;;; +.
;;;
;;; <PPWM+CE>
;;;	::=   |  <PPWM+CEREST> 
;;;     ::=   <PPWM+CEREST> 
;;; <PPWM+CEREST> 
;;;     ::= <SYMBOL-NOT-SPECIAL>? <SYMBOL-NOT-SPECIAL>? <PPWM-TEST>*
;;; <PPWM-PREFERENCE-CE>
;;;	::= preference <SYMBOL-NOT-SPECIAL>? <PPWM-PREFERENCE-ATTRIBUTE-TEST>*
;;; <PPWM-PREFERENCE-ATTRIBUTE-TEST>*
;;;	::= <PPWM-PREFERENCE-ATTRIBUTE-TEST> <PPWM-PREFERENCE-ATTRIBUTE-TEST>* | epsilon
;;;	
;;;			::=	^ <PPWM-PREFERENCE-ROLE-TEST>  |
;;;				^ <PPWM-PREFERENCE-VALUE-TEST> |
;;;				^ <PPWM-PREFERENCE-G-P-S-O-R-TEST>
;;;		
;;;			::=	ROLE <PPWM-PREFERENCE-ROLE>
;;;	
;;;			::=	problem-space | state | operator 
;;;	
;;;			::=	VALUE <PPWM-PREFERENCE-VALUE>
;;;	
;;;			::=	ACCEPTABLE | REJECT | BEST | WORST |
;;;				BETTER | WORSE | REQUIRE | INDIFFERENT |
;;;                             PARALLEL 
;;;	
;;;			::=	<G-P-S-O-R> <SYMBOL-NOT-SPECIAL>
;;;	
;;; <PPWM-TEST>*
;;;	::= <PPWM-TEST> <PPWM-TEST>* | epsilon
;;; <PPWM-TEST>
;;;	::=  <SYMBOL-NOT-SPECIAL> <CONSTANT>* 
;;;     ::=  ^ <SYMBOL-NOT-SPECIAL> <PPWM-CONSTANT?-PREFERENCE?>* 
;;;  <PPWM-CONSTANT?-PREFERENCE?> 
;;;	::= <CONSTANT>? <PPWM-PREFERENCE-SPECIFIER>?
;;; <CONSTANT>* 
;;;	::= <CONSTANT> <CONSTANT>* | epsilon
;;;  <PPWM-PREFERENCE-SPECIFIER>
;;;                     ::= <NATURALLY-UNARY-PREFERENCE> 
;;;			::= <PPWM-FORCED-UNARY-PREFERENCE>
;;;                     ::= <BINARY-PREFERENCE> <CONSTANT>
;;;                     ::= epsilon 
;;;  <NATURALLY-UNARY-PREFERENCE>
;;;			 ::= + | - | ! | ~ | @
;;;  <PPWM-FORCED-UNARY-PREFERENCE>
;;;			 ::= <BINARY-PREFERENCE> [, | *end-of-input* | ^ ]
;;;	As in SPPARSERHS, don't read in the ")" or "^", just the ",".
;;;  <BINARY-PREFERENCE> 
;;;			 ::= > | = | < | &
;;;

;;;
;;;		v.	Compiled-Old-PPWM
;;;

#|
(defun compiled-old-ppwm (ces)
  ;; This first form does the equivalent of the old PPWM, e.g., it prints
  ;; each element that match any single CE generated.
  (format t "~% Old style PPWM.")
  (if ces
    (dowm (wme.tag)
     (dolist (ce ces)
      (when (wme-matches-ce (car wme.tag) ce)
       (soar-format *trace-file* "~%") (print-wme-and-timetag t (car wme.tag) (cdr wme.tag)))))
    (dowm (wme.tag) (soar-format *trace-file* "~%") (print-wme-and-timetag t (car wme.tag) (cdr wme.tag))))
  ;; This second form prints all of the wmes that are matched by the CES
  ;; as long as there is a wme of the same id for each CE.
  (format t "~% New style PPWM.")
  )
 |#


;;;
;;;		I.	DoWm
;;;
;;;	DoWm is a dolist like iterator that iterates across all of 
;;; the wme.timetags in Soar WM. Wmpart-list holds a list of all of
;;; the IDs in use in WM, and each ID has hanging off of its wmpart*
;;; property a list of wme.timetag.
;;;

(eval-when (compile eval load) (proclaim '(special *wmpart-list*)))

(defmacro dowm ((wme.timetag &optional (return-value nil)) &body body)
  (let ((wmepart (gensym "WMEPART")))
    `(dolist (,wmepart *wmpart-list*)
      (dolist (,wme.timetag (get ,wmepart 'wmpart*) ,return-value)
	,@body))))


;;;
;;;		II.	PPWM
;;;

(defmacro ppwm (&rest attribute-value-list)
  (let ((*rhs-smake-or-ppwm* 'ppwm))
    (catch-sptop-errors
      `(compiled-ppwm ',(sp-parse-ppwm attribute-value-list)))))



;;;
;;;		III.	SPPWM
;;;

(defmacro sppwm (&rest attribute-value-list)
  (let ((*rhs-smake-or-ppwm* 'ppwm))
    (catch-sptop-errors
      `(compiled-sppwm ',(sp-parse-ppwm attribute-value-list)))))


;;;
;;;		IV.	Compiled-ppwm
;;;
;;;	PPWM prints out, in wme form, the wmes
;;; that match ANY ONE OF the ces generated by the
;;; attribute value pattern. This is perhaps not 
;;; the functionality that we want, but is what we are
;;; used to living with. We really want to do the cross
;;; product of all matches by ID.
;;;

(defun compiled-ppwm (ces)
  ;; Hey, this could be optimized to only iterate through the WMEPART*
  ;; for a given ID if the CE holds the ID. -BGM 12/17/88
  ;; First collect up all of the wmes that match the first of the ces.
 (if ces
  (let ((ids.found.wmes nil))
    ;; After each id is a found tag. This is used as an optimization
    ;; to get rid of repeated O(N^2) set intersection operations.
    ;; On each pass through the WM after the first one, if I add a
    ;; new wme to the id.found.wmes's wme part, I turn on found.
    ;; If after a pass through all of wm for a CE, I have not
    ;; found a new wme to match that CE for a given ID, then
    ;; I remove the ID from consideration.
    (let ((ce (car ces)))
      (dowm (wme.tag)
	(let ((wme (car wme.tag)))
	  (when (wme-matches-ce wme ce)
	    (let* ((id (wme-id wme))
		   (id.found.wmes (assoc id ids.found.wmes)))
	      (cond (id.found.wmes (push wme (cddr id.found.wmes)))
		    (t (push (cons id (cons nil (list wme))) ids.found.wmes))))))))
    ;; And, then go through the remaining ces only adding matching wmes
    ;; if their ID is already in ids.wmes.
    (dolist (ce (cdr ces))
      (dowm (wme.tag)
	(let ((wme (car wme.tag)))
	  (when (wme-matches-ce wme ce)
	    (let ((id.found.wmes (assoc (wme-id wme) ids.found.wmes)))
	      (when id.found.wmes 
		(push wme (cddr id.found.wmes))
		(unless (cadr id.found.wmes) (setf (cadr id.found.wmes) t)))))))
      ;; Delete all of the elements that do not have a found flag on.
      (setq ids.found.wmes
	    (delete-if-not #'(lambda (id.found.wmes) (cadr id.found.wmes)) ids.found.wmes))
      ;; Turn all of the found tags to nil.
      (dolist (id.found.wmes ids.found.wmes) (setf (cadr id.found.wmes) nil)))
    ;; Finally, go through the ids and print their wmes in the
    ;; reverse order so that they correspond with the order of the ces.
    (dolist (id.found.wmes ids.found.wmes)
     (dolist (wme (nreverse (cddr id.found.wmes)))
       (soar-format *trace-file* "~%") 
       ;; Optimize by saving the time tags.
       (print-wme-and-timetag t wme)
       )))
  (dowm (wme.tag) (soar-format *trace-file* "~%")
    (print-wme-and-timetag t (car wme.tag) (cdr wme.tag)))))



;;;
;;;		V.	Compile-sppwm
;;;


(defun compiled-sppwm (ces) 
  ;; Patched so that it prints preferences for DSM by BGM 2/12/89.
  ;; Hey, this could be optimized to only iterate through the WMEPART*
  ;; for a given ID if the CE holds the ID. -BGM 12/17/88
  ;; First collect up all of the wmes that match the first of the ces.
 (if ces
  (if (eq (first (first ces)) 'preference)
      ;; If I've got one preference CE, they're all preference CEs and I should
      ;; just call PPWM, as it does all of this for me.
      (compiled-ppwm ces)
    (let ((ids.found nil))
      ;; After each id is a found tag. This is used as an optimization
      ;; to get rid of repeated O(N^2) set intersection operations.
      ;; On each pass through the WM after the first one, if I find a
      ;; matching wme, I turn on found for its ID.
      ;; If after a pass through all of wm for a CE, I have not
      ;; found a new wme to match that CE for a given ID, then
      ;; I remove the ID from consideration.
      (let ((ce (car ces)))
	(dowm (wme.tag)
	 (let ((wme (car wme.tag)))
	   (when (wme-matches-ce wme ce)
	    (let* ((id (wme-id wme))
		   (id.found (assoc id ids.found)))
	      (unless id.found
		(push (cons id nil) ids.found)))))))
      ;; And, then go through the remaining ces only turning on found
      ;; if their ID is already in ids.found
      (dolist (ce (cdr ces))
	(dowm (wme.tag)
	 (let ((wme (car wme.tag)))
	   (when (wme-matches-ce wme ce)
	     (let ((id.found (assoc (wme-id wme) ids.found)))
	       (when id.found 
		 (unless (cdr id.found) (setf (cdr id.found) t)))))))
	;; Delete all of the elements that do not have a found flag on.
	(setq ids.found
	   (delete-if-not #'(lambda (id.found) (cdr id.found)) ids.found))
	;; Turn all of the found tags to nil.
	(dolist (id.found ids.found) (setf (cdr id.found) nil)))
      ;; Finally, go through the ids and spo their id.
      (dolist (id.found ids.found) 
	      (compiled-spo (list (car id.found)) 
		      :print-wmes t :print-preferences t))))
  (dolist (id *wmpart-list*) 
	   (compiled-spo (list id) :print-wmes t :print-preferences t)
	  )))



;;;
;;;		VI.	Wme-matches-ce
;;;
;;;	This is used to match a wme against a CE pattern.
;;; Iterate through the CE and unless its part is '*unbound*,
;;; the wme must be = or eql or the match fails.
;;;

(defun wme-matches-ce (wme ce)
 (unless (and (eq (car wme) 'preference) (eq (car ce)  '*unbound*))
  ;; Don't match against preferences unless the CE starts with 'PREFERENCE.
  (dolist (cep ce t)
   (if (eq cep '*unbound*)
     (pop wme)
     (let ((wmep (pop wme)))
       (when (and (numberp cep) (numberp wmep)) (unless (= cep wmep) (return nil)))
       (unless (eql cep wmep) (return nil)))))))

;;;
;;;		VII.	Sp-parse-ppwm
;;;

(defun sp-parse-ppwm (attribute-value-list)
 (when attribute-value-list
  (initialize-lexer attribute-value-list)
  (let-grammar-values (<PPWM+CE>)
    (declare (ignore <PPWM+CE><VARIABLE>* found-<PPWM+CE>))
    (unless (eq (peek-lexeme) *end-of-input*)
      (sptop-rhs-error 
	"parsed a (s)ppwm but had extra lexemes left over; you must have an ungramatical construct."))
    <PPWM+CE>)))
    

;;;
;;;		?.	<PPWM+CE>
;;;

(defun <PPWM+CE> ()
   (<PPWM+CEREST>))

;;;
;;;		?.	<PPWM+CEREST> 
;;;

(defun <PPWM+CEREST> ()
 (let* ((class (or (<SYMBOL-NOT-SPECIAL>) '*unbound*))
	(id    (or (<SYMBOL-NOT-SPECIAL>) '*unbound*)))
   (let-grammar-values (<PPWM-TEST>*)
     (declare (ignore <PPWM-TEST>*<VARIABLE>* found-<PPWM-TEST>*))
     (values
       (if <PPWM-TEST>*
	   (mapcar #'(lambda (<PPWM-TEST>) (get-cons class (get-cons id <PPWM-TEST>)))
		   <PPWM-TEST>*)
	 (get-list (get-list class id)))
       nil t))))
		

;;;
;;;		?.	<PPWM-PREFERENCE-CE>
;;;


;;;
;;;		?.	<PPWM-PREFERENCE-ATTRIBUTE-TEST>*
;;;


;;;
;;;		?.	<PPWM-PREFERENCE-ATTRIBUTE-TEST>
;;;


;;;
;;;		?.	<PPWM-PREFERENCE-ATTRIBUTE-NAME-VALUE>
;;;


;;;
;;;		?.      <PPWM-PREFERENCE-ROLE-TEST>	
;;;


;;;
;;;		?.      <PPWM-PREFERENCE-ROLE>
;;;


;;;
;;;		?.      <PPWM-PREFERENCE-VALUE-TEST>
;;;


;;;
;;;		?.      <PPWM-PREFERENCE-VALUE>
;;;


;;;
;;;		?.      <PPWM-PREFERENCE-G-P-S-O-R-TEST>
;;;


;;;
;;;		?.	<PPWM-TEST>*
;;;

(defun <PPWM-TEST>* () (zero-or-more (<PPWM-TEST>) :join :nconc))


;;;
;;;		?.	<PPWM-TEST>
;;;

(defun <PPWM-TEST> ()
  (when (eq (peek-lexeme) '^)
   (get-lexeme)
   (let-grammar-values (<SYMBOL-NOT-SPECIAL>)
     (declare (ignore <SYMBOL-NOT-SPECIAL><VARIABLE>* found-<SYMBOL-NOT-SPECIAL>))
    (values (mapcar #'(lambda (whatever) 
			 (get-cons <symbol-not-special> whatever)
			)
		       (or (<PPWM-CONSTANT?-PREFERENCE?>*)
				 '((*unbound* *unbound* *unbound*))))
	    nil
	    t))))

;;;
;;;		?.      <PPWM-CONSTANT?-PREFERENCE?> 
;;;

(defun <PPWM-CONSTANT?-PREFERENCE?> ()
  (let-grammar-values (<CONSTANT>)
   (declare (ignore <CONSTANT><VARIABLE>*))		       
   (cond (found-<constant> 
	   (let-grammar-values (<PPWM-PREFERENCE-SPECIFIER>)
	     (declare (ignore <PPWM-PREFERENCE-SPECIFIER><VARIABLE>*))
	     (cond (found-<PPWM-PREFERENCE-SPECIFIER>
		     (values (get-cons <CONSTANT> <PPWM-PREFERENCE-SPECIFIER>)
			     nil t))
		   (t (values (get-list <constant>) nil t)))))
	 (t (let-grammar-values (<PPWM-PREFERENCE-SPECIFIER>)
	     (declare (ignore <PPWM-PREFERENCE-SPECIFIER><VARIABLE>*))
	     (when found-<PPWM-PREFERENCE-SPECIFIER>
	       (values (get-cons '*unbound* <PPWM-PREFERENCE-SPECIFIER>) 
		       nil t)))))))

;;;
;;;		?.	<PPWM-CONSTANT?-PREFERENCE?>*
;;;

(defun <PPWM-CONSTANT?-PREFERENCE?>* ()
 (zero-or-more (<PPWM-CONSTANT?-PREFERENCE?>)))


;;;
;;;		?.	<CONSTANT>* 
;;;

(defun <CONSTANT>* () (zero-or-more (<CONSTANT>)))


;;;
;;;		?.	<PPWM-PREFERENCE-SPECIFIER>
;;;

(defun <PPWM-PREFERENCE-SPECIFIER> ()
  (let-grammar-values (<NATURALLY-UNARY-PREFERENCE>)
   (declare (ignore <NATURALLY-UNARY-PREFERENCE><VARIABLE>*))
   (if found-<NATURALLY-UNARY-PREFERENCE>
      (values (get-list <NATURALLY-UNARY-PREFERENCE>) nil t)
      (let-grammar-values (<PPWM-FORCED-UNARY-PREFERENCE>)
        (declare (ignore <PPWM-FORCED-UNARY-PREFERENCE><VARIABLE>*))
       (if found-<PPWM-FORCED-UNARY-PREFERENCE>
           (values (get-list <PPWM-FORCED-UNARY-PREFERENCE> nil) nil t)
           (let-grammar-values (<BINARY-PREFERENCE>)
             (declare (ignore <BINARY-PREFERENCE><VARIABLE>*))
	     (if found-<BINARY-PREFERENCE>
		 (let-grammar-values (<CONSTANT>)
		   (declare (ignore <CONSTANT><VARIABLE>*))
		   (if found-<CONSTANT>
		      (values (get-list <BINARY-PREFERENCE> <CONSTANT>)
			      nil
			      t)
		      (sptop-rhs-error "error while parsing a (s)ppwm's preference, found a binary preference symbol~
                                            , ~A, but it did not proceed a comma, an ^, the end of the ppwm or a constant."
					  <BINARY-PREFERENCE>)))
	       (values nil nil nil) 
	       )))))))


;;;
;;;		?.      <PPWM-FORCED-UNARY-PREFERENCE>
;;;

(defun <PPWM-FORCED-UNARY-PREFERENCE> ()
  (when (member (peek-lexeme) '(> = < &))
    (cond ((eq (peek-lexeme-1) '|,|) 
	   (let ((preference-symbol (get-lexeme)))
	     (get-lexeme) ; Consume the comma.
	     (values preference-symbol nil t)))
	  ((or (eq (peek-lexeme-1) *end-of-input*)
	       (eq (peek-lexeme-1) '^))
	   (values (get-lexeme) nil t)))))

;;; Concatenated from type module "sptop" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sptop/new/sptopinitandrestart.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	initandrestart.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/sptop/new/initandrestart.lisp
;;;
;;;		i.	Abstract
;;;	
;;;	This file, initandrestart, contains an initialize-sptop (suitable for calling in
;;; init-soar) and an restart-sptop (suitable for calling in restart-soar).
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Initialize-sptop
;;;	II.	Restart-sptop
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")



;;;
;;;		I.	Initialize-sptop
;;;

(defun initialize-sptop ()
  (soarsyntax)
  )



;;;
;;;		II.	Restart-sptop
;;;

(defun restart-sptop ()
  (soarsyntax)
  )

;;; Concatenated from type module "interface" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/interface/new/interface.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;

;;;
;;;		?.	Global Variables
;;;
;;;  What about these guys ?
;;; *print-attribute-list*
;;; *pnames*
;;; *save-class-list*
;;; *user-ids*
;;;  These guys are all local to this file.
;;; *date-created*
;;; *version-number*
;;; *minor-version*
;;; *public-version*
;;; *release-number*
;;; *public-version*
;;; *version-number*
;;; *release-number*
;;; *version-number*
;;; *minor-version*
;;; *date-created*
;;; *public-version*
;;;

(in-package "SOAR")

(defvar *last-arg* () "The last argument to a variety of soar functions.")

(defun print-choice (choice)
 ;; DSM ==>
 (soar-format *trace-file*
              "~A "
              choice)
 (cond ((object-p choice)
        (soar-format *trace-file*
                     "~A ~A"
                     (object-class choice)
                     (format-trace-attributes choice)) ))
 (soar-format *trace-file* " ~%") 
)

(defvar *print-attribute-list* () "")

(defun print-id (id)
  ;; Updated to mouse IO for the . -BGM 8/18/88
 ;; Updated old style IO to soar-format. -BGM 8/18/88
  ; Randy.Gobbel 12-Sep-86 12:05 
       (ms-soar-princ *trace-file* id 'object)
       ;; ID's are known to be objects.
       (soar-format *trace-file* " ")
       (cond ((and id (symbolp id)
		   (not (eq id 'undecided)))
	      (and (get id 'name)
		   (soar-format *trace-file* "~A" (get id 'name)))
	      (setq *print-attribute-list* (list id))
	      (print-instance id *trace-file*)
	      (setq *print-attribute-list* nil))))

(defvar *full-print-id* t "Seems to be used in tracing. Very confusing.")

(defun print-instance (id &optional (stream t))
 ;; Moved here to interface. -BGM 1/25/89.
 ;;; Incorrectly placed here.
 ;; Added an optional stream so that I could catch this output in a string stream for the . -BGM9/8/88.
 ;; This deals with printing the trace-attribute information.
 ;; Updated old style IO to soar-format. -BGM 8/18/88
 ; Randy.Gobbel 17-Oct-86 12:34
  (prog (flag flag2)
    (cond
      ((and (symbolp id) (get id 'instance))
       (setq flag nil)
       (setq flag2 nil)
       (soarmapc
	 #'(lambda (object)
		   (cond ((and (symbolp object)
			       (get object 'name))
			  (cond ((not (eq '! (get object 'name)))
				 (cond ((or flag flag2)
					(soar-format stream " "))
				       (t (soar-format stream " (")
					  (setq flag t)))
				 (let ((thing (get object 'name)))
				   (if (and (symbolp thing) (get thing 'gensymed))
				       (ms-soar-princ stream thing 'object)
				       (soar-format stream "~A" thing)))
				 (cond ((not (soarmemq object 
						     *print-attribute-list*))
					(soarpush object *print-attribute-list*)
					(print-instance object stream))))))
			 (t (cond (*full-print-id*
				    (cond (flag (soar-format stream " "))
					  (t (soar-format stream "(")
					     (setq flag t)))
				   (if (and (symbolp object) (get object 'gensymed))
				       (ms-soar-princ stream object 'object)
				       (soar-format stream "~A" object))))
			    (cond ((not (soarmemq object *print-attribute-list*))
				   (soarpush object *print-attribute-list*)
				   (setq flag2 (print-instance object stream)))))))
	 (get id 'instance))
       (and flag (soar-format stream ")"))
       (return flag)))))

(defparameter *date-created* 
                             "August 26th, 1991"
                             "The date at which this soar version was created.")
(defparameter *version-number*   5 "The version number of this soar.")
(defparameter *release-number*   2 "The release number of soar whatever this means.")
(defparameter *minor-version*    2 "The minor version of this soar.")
(defparameter *public-version* t "Is this a public release of soar.")
(defparameter *soar-init-file-name* ".soar-init.lisp"
  "The name of the file searched for in the user's home directory at startup.
   NIL to discourage behavior.")

(defun soar-version nil
  ;; This print out the soar version information so that it is done in only one place.-BGM 8/18/88
  (if *public-version* 
      (soar-format *trace-file* "~%Soar (Version ~A, Release ~A)~%" *version-number* *release-number*)
      (soar-format *trace-file* "~%Soar ~A.~A.~A (internal release)~%" 
		   *version-number* *release-number* *minor-version*))
  (soar-format *trace-file* "Created ~A~%" *date-created*))


(defun soar-greeting nil  
 ;; Installed call to soar-version. -BGM 8/18/88
 ;; Updated old style IO to soar-format. -BGM 8/18/88
   ; Randy.Gobbel 12-Sep-86 12:06 
       (soar-version)
       (soar-format *trace-file* 
		   "Bugs and questions should be sent to Soar-bugs@cs.cmu.edu~%")
       (soar-format *trace-file* 
		   "The current bug-list may be obtained by sending mail to~%~
                    Soar-bugs@cs.cmu.edu with the Subject: line \"bug list\"~%")
       (soar-format *trace-file*
	"This software is in the public domain.~%~%~
        This software is made available AS IS, and Carnegie Mellon~%~
        University and the University of Michigan make no warranty~%~
        about the software or its performance.~%~%~
        See (soarnews) for news.")
       nil)
 
(defun soarnews nil  
 ;; Updated old style IO to soar-format. -BGM 8/18/88
 ;;; Fixed bug naming Soar 5.0.2 GAP 2/5/90
 ;; Fixed to 5.2.0 naming -- TFMcG 28-Jun-90
  (soar-format *trace-file*
	       "News for Soar 5.2.2~%~
	       This is a public domain release of the Soar 5 architecture.~%~%~
               This software may be obtained by anonymous FTP from~%~
               Centro.soar.cs.cmu.edu [128.2.242.245]. Retrieve the file~%~
               /afs/cs.cmu.edu/project/soar/5.2/2/public/compressedSoar.5.2.2.tar.Z~%~%~
               This software is actively maintained with bug fixes,~%~
               users are encouraged to send bug reports to: soar-bugs@cs.cmu.edu~%~%~
               If you would like to be notified of patches and bug fixes, send~%~
               mail to: soar-requests@cs.cmu.edu~%~%~
               For a manual, send an electronic request to: soar-doc@cs.cmu.edu~%~
               Or send a written request to:~%~%~
               The Soar Group~%~
               School of Computer Science~%~
               Carnegie Mellon UNiversity~%~
               5000 Forbes Avenue~%~
               Pittsburgh, Pennsylvania  15213-3890~%~
               USA~%~%~
               If you have any Soar research you would like to share with a larger~%~
               audience, please contact any of the above addresses.~%")
       nil)

(defun load-soar-init-file (&optional other-file-name)
 ;; Load the soar init file from the user's home directory, if it exists.
 ;; TFMcG 28-Jun-90
 ;; added other-file-name for use with sx too  -fer 9/90
  (let ((init-file (or other-file-name  *soar-init-file-name*)) )
  (and init-file
       (open (merge-pathnames (pathname init-file)
                              (user-homedir-pathname))
             :direction :probe)
       (lispload (merge-pathnames (pathname init-file)
                                  (user-homedir-pathname))))
  nil))

(defun soar-menu (header choice-list)
  ;; Added ~% for McMahon after "Choose ..." -BGM 12/17/88.
  ;; Updated old style IO to soar-format. -BGM 8/18/88.
  ;; Changed the prompt. -AC 1/12/91. Bug #13Jan91-11.08.08 22-Jan-91 GAP
  (prog (choice count result)
    l1
    (soar-format *trace-file*
                 "~%~A~%Choose from this list by position in list (1-n)~%"
                 header)
    (setq count 1)
    (soarmapc #'(lambda (x)
                  (soar-format *trace-file* "~A: " count)
                  (print-choice (cond ((soarlistp x)
                                       (car x))
                                      (t x)))
                  (setq count (1+ count)))
              choice-list)
    (soar-format *trace-file* "~%Enter Selection: ")
    (setq choice (read))
    (cond ((and (numberp choice)
                (> choice 0)
                (< choice (1+ (length choice-list))))
           (setq result (nth (1- choice)
                             choice-list))
           (cond ((and (soarlistp result)
                       (cdr result))
                  (return (cadr result)))
                 ((soarlistp result)
                  (return (cadr result)))
                 (t (return result)))))
    (soar-format *trace-file*
                 "~%Your answer was not a number between 1 and n.")
    (go l1))
  )


;;; Concatenated from type module "interface" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/interface/new/soarlisten.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module interface modsubmodule soarlisten

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the SoarListen function.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Call Tree	
;;;	I.	Soarlisten

;;;
;;;		I.	Soarlisten
;;;

(in-package "SOAR")

; This should return true iff something that should cause a break
; after the current decision cycle is in the input buffer.
; For now, always return nil.
                                             
(eval-when (compile eval load) (proclaim '(special *accepting-input*))) ;added. -KAM 6/14/89

#-:TI         ;changed TI to :TI -KAM 6/14/89
(DEFUN SOARLISTEN NIL ; From Jel may 18th 87.
       (BLOCK SOARLISTEN
         (COND ((LISTEN)
                (COND ((NOT (EQ (PEEK-CHAR) #\Newline)) T)
                      (T (READ-CHAR) NIL))))))

; [ARG -- 2/24/87] Rewritten to ignore character interrupts when 
; *accepting-input*.

#+:TI         ;changed TI to :TI -KAM 6/14/89
(defun soarlisten ()
 (let (c)
    (setq c (send *standard-input* :any-tyi-no-hang))

    (if (null c)
      	nil
      ;else
     	(if (or (and (listp c) (eq (car c) :mouse-button)) (not *accepting-input*))
     	    t
         	;else
           (let ()   ;; wrapped let around 2 forms. KAM. 4/3/89.
        	    (send *standard-input* :untyi c)
        	    nil)
    	)
    )
 )
)


;;; Concatenated from type module "interface" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/interface/new/statistics.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module UTILTITY submodule statistics
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the current statistics collection and output.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Call Tree	
;;;	iv.	Global Variables
;;;

;;;
;;;		iv.	Global Variables
;;;
(in-package "SOAR")


(eval-when (compile eval load) (proclaim '(special *break-flag*)))
(eval-when (compile eval load) (proclaim '(special *real-cnt*)))
(eval-when (compile eval load) (proclaim '(special *virtual-cnt*)))
(eval-when (compile eval load) (proclaim '(special *pcount*)))
(defvar *prod-count* 0
  "The number of production instantiations fired.")
;; Changed initial value of *initial-actions* to 0. -KAM 6/14/89
(defvar *initial-actions* 0 "Seems to be the *action-count* after init-wm has run.")
(defvar *total-wm* 0
  "The total number of working memory elements to pass through.")
(eval-when (compile eval load) (proclaim '(special *max-wm*)))
(eval-when (compile eval load) (proclaim '(special *current-wm*)))
(defvar *total-token* 0 "The total number of tokens to pass through token memories.")
(defvar *max-token* 0 "The maximum size that token memory has hit.")
(eval-when (compile eval load) (proclaim '(special *CURRENT-TOKEN*)))
(eval-when (compile eval load) (proclaim '(special *action-count*)))
;;;


(defun accum-stats nil  ; Randy.Gobbel 16-May-86 10:51 
       (setq *prod-count* (+ *prod-count* 1))
       (setq *total-token* (+ *total-token* *current-token*))
       (cond ((> *current-token* *max-token*)
	      (setq *max-token* *current-token*)))
       (setq *total-wm* (+ *total-wm* *current-wm*))
       (cond ((> *current-wm* *max-wm*)
	      (setq *max-wm* *current-wm*))))


;;;
;;;


(defun print-stats ()  
 ;; Modified a soar-format t to a soar-format *trace-file*. -BGM 17-Sep-90
 (prog (decision-cycles elaboration-cycles production-cycles firings ;<== DSM
        cc pc dc ec time tokens)

 (setq *break-flag* nil)
 (setq time (time-conversion *elapsed-time*))

 ;; decision cycle count.
 (setf decision-cycles (cycle-count 'quiescence-phase))
 (setq dc (+ (float decision-cycles)           ;<== DSM
	      		    1.0E-20))
                                   
 ;; elaboration cycle count.
 (setf elaboration-cycles (cycle-count 'preference-phase))
 (setq ec (+ (float elaboration-cycles)           ;<== DSM
 	      		    1.0E-20))

 ;; production cycle count.
 ;; this is decision cycles plus elaboration cycles.
 (setf production-cycles (+ dc ec))
 (setq cc (+ (float production-cycles)         ;<== DSM
       		    1.0E-20))

 ;; firing count. 
 ;; number of production firings.
 (setf firings (firing-count))
 (setq pc (+ (float firings)                   ;<== DSM
      			    1.0E-20))

 (soar-version)

 (soar-format *trace-file* "~%Run statistics on ~A~%" (soar-date))
 (format *trace-file* "~A ~A ~A ~A ~A ~A ~A ~A~%"
		       (lisp-implementation-type)
		       (lisp-implementation-version)
		       (machine-type)
         ;;; There is a bug in machine-version on lucid/Centro. 
         ;;; So I'll patch it here. -BGM 11/2/87.
  		     (let ((machine-version (machine-version)))
		        (if (and (string= machine-version "VAX")
			               	(string= (machine-instance) "CENTRO.SOAR.CS.CMU.EDU"))
   			        "8800"
			           machine-version))
		       (machine-instance)
		       (software-type)
		       (software-version)
		       (short-site-name))

 (soar-format *trace-file* "~%~A productions (~A / ~A nodes)"
              *pcount* *real-cnt* *virtual-cnt*)

 (soar-format *trace-file* "~% ~A chunks (~A / ~A productions)"
              (length *chunks*) (length *chunks*) *pcount*)

 (when (= decision-cycles 0)
        (soar-format *trace-file* "~%")
       (return))


 (soar-format *trace-file* "~%~A seconds elapsed " time)
 (unless *never-learn*
         (soar-format *trace-file* "~A seconds chunking overhead" 
			                   (time-conversion *elapsed-build-time*)))

 (cond ((eqp time 0)
  		    (setq time 1.0E-8)))

 (soar-format *trace-file* "~%~A decision cycles (~A ms per cycle)"
              decision-cycles
         			  (* 1000 (/ time (float decision-cycles))))

 (soar-format *trace-file* "~%~A elaboration cycles (~A ms per cycle)"
			           elaboration-cycles
         			  (* 1000 (/ time (float elaboration-cycles))))
 (soar-format *trace-file* "~%    (~A e cycles/d cycle)"
              (/ ec dc))

 (soar-format *trace-file* "~%~A production firings (~A ms per firing)"
         		  firings (* 1000 (/ time (float firings))))


 (when (< .01 (- cc decision-cycles))
       (soar-format *trace-file* "~%     ~A productions in parallel"
                    (/ (float firings) elaboration-cycles)))
 	     (soar-format *trace-file* "~%~A RHS actions after initialization (~A ms per action)"
	               		  (- *action-count* *initial-actions*)
               			  (* 1000 (/ time (float (- *action-count* *initial-actions*)))))


 (soar-format *trace-file* "~%~A mean working memory size (~A maximum, ~A current)"
         			  (round (/ (float *total-wm*) pc)) *max-wm* *current-wm*)


 (soar-format *trace-file* "~%~A mean token memory size (~A maximum, ~A current)"
         			  (round (/ (float *total-token*) pc)) *max-token* *current-token*)

 (soar-format *trace-file* "~%~A left tokens added, ~A right tokens added, ~A total tokens added" 
              *left-added-tokens* *right-added-tokens* *added-tokens*)
 (soar-format *trace-file* "~%~A left tokens removed, ~A right tokens removed, ~A total tokens removed" 
              *left-removed-tokens* *right-removed-tokens* *removed-tokens*)
 (soar-format *trace-file* "~%~A token changes (~A ms per change)"
         			  (setq tokens (+ *added-tokens* *removed-tokens*))
	         		  (* 1000 (/ time (float tokens))))
 (soar-format *trace-file* "~%     (~A changes/action)" (/ (float tokens) *action-count*))

 (return NIL)
))





(defun initialize-statistics ()
  (setq *total-token* 0)
  (setq *max-token*   0)
  (setq *total-wm*    0)
  (setq *prod-count*  0)
  
  nil
 )

(defun restart-statistics ()
  (setq *total-token* 0)
  (setq *max-token*   0)
  (setq *total-wm*    0)
  (setq *prod-count*  0)
  nil
)


;;; Concatenated from type module "interface" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/interface/new/warningsanderrors.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module Interface submodule warningsanderrors.
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the soar specific functions which
;;;  generate warnings and errors.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Call Tree	
;;;	iv.	Global Variables
;;;

;;;
;;;		iv.	Global Variables
;;;
;;; *warning*
;;; *p-name*
;;;


(in-package "SOAR")

(defvar *warning* t "*Warning* is a switch which when nil turns off warning messages.")

(eval-when (compile eval load) (proclaim '(special *p-name*)))

(defun soarwarn (warning warning2) ; Randy.Gobbel 12-Sep-86 12:12 
  (prog nil (and (null *warning*) (return))
     (soar-format *trace-file* "~%Warning: ")
     (and *p-name* (soar-format *trace-file* "~A" *p-name*))
     (soar-format *trace-file* "..~A ~A"warning warning2)
     (return warning2)))

(defun soarerror (what where) 
  ;; *Throw replaced with throw by BGM 9/14/88.
       (soarwarn what where)
       (throw 'soar-error 'soar-error))


;;; Concatenated from type module "interface" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/interface/new/interfaceinitandrestart.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	initandrestart.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/interface/new/intiandrestart.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file contains two fuctions: initialize-interface and restart-interface;
;;; to be called from init-soar and restart-soar.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Initialize-interface
;;;	II.	Restart-interface
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")



;;;
;;;		I.	Initialize-interface
;;;

(defun initialize-interface () 
  (initialize-statistics)
  nil)



;;;
;;;		II.	Restart-interface
;;;

(defun restart-interface ()
 (setq *last-arg* nil) ; Clear the last argument across resets.
 (setq *full-print-id* t)
 (restart-statistics)
 nil
 )



;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/reorder.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module RETE submodule Reorder
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file, reorder.lisp, implements a condition element reorderer 
;;; along the lines described in Dan Scale's master's thesis.
;;;
;;; Recomendations for fixing this code:
;;;  this code is so poorly written (old style, gotos, supurious gotos, temps, setqs,
;;;  consing instead of multiple values, spurious consing, no macros, bogus recursions,
;;;  bogus iterations, ...) that it should be comprehended and then replaced.
;;;  Actually, we should fix the multi-attribute stuff for preferences.
;;; 

(in-package "SOAR")

;;;
;;;		ii.	Table Of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Call Tree
;;;     iv.	Global Variables used
;;;	I.	Unmark-as-set
;;;	II.	Mark-as-set
;;;	III.	Bound-var?
;;;	IV.	All-bound?
;;;	V.	Lexless
;;;	VI.	Get-mult-num
;;;	VII.	Take-out-duplicates
;;;	VIII.	Strip-condition
;;;	IX.	Get-all-vars-in-neg
;;;	X.	Get-attr-val-types
;;;	XI.	Get-condition-type
;;;	XII.	Get-pred-vars-in-condition
;;;	XIII.	Get-id-var
;;;	XIV.	Get-vars-in-condition
;;;	XV.	Get-prev-rank
;;;	XVI.	Get-context-vars-in-pref
;;;	XVII.	Find-all-vars-in-condition
;;;	XVIII.	No-unbound-predicates?
;;;	XIX.	Predicatep
;;;	XX.	Put-rank
;;;	XXI.	Bound-preference?
;;;	XXII.	Check-negations
;;;	XXIII.	Classify
;;;	XXIV.	Classify-match-elt
;;;	XXV.	Pop-match-elt
;;;	XXVI.	Pop-term
;;;	XXVII.	Classify-term
;;;	XXVIII.	Find-best-condition
;;;	XXIX.	Find-info-on-cond
;;;	XXX.	Find-pred-vars-in-condition
;;;	XXXI.	Get-conditions-with-vars
;;;	XXXII.	Insert-ne-undec
;;;	XXXIII.	Re-order-conditions
;;;	XXXIV.	Reorder-p-conds
;;;	XXXV.	Reorder-p-conds1
;;;	XXXVI.	Sort-conditions
;;;     XXXVII.	test-connected-actions
;;;     XXXIX.  Rplnode (misnamed).
;;;	XXXX.	Multi-attribute
;;;	XXXXI.	Multi-attributes
;;;	XXXXII.	Any-bound?
;;;	XXXXIII.	Remove-condition-trash
;;;	XXXXIV.	Initialize-rete-reorder
;;;	XXXXV.	Restart-rete-reorder
;;;

;;;
;;;		iii.	Call tree from Reorder-p-conds
;;;
;;; reorder-p-conds -local complete
;;;  reorder-p-conds1 -local complete
;;;   re-order-conditions -local complete
;;;    sort-conditions -local complete
;;;     find-all-vars-in-condition -local complete
;;;     get-all-vars-in-neg - local complete
;;;     find-pred-vars-in-condition -local complete
;;;      pop-match-elt -local complete
;;;       classify-match-elt -local complete
;;;     find-info-on-cond -local complete
;;;      pop-term -local complete
;;;       classify-term -local complete
;;;     get-pred-vars-in-condition -local complete
;;;     get-duplicates -nonlocal utility
;;;     take-out-duplicates -local complete
;;;     get-non-duplicates - nonlocal utility
;;;    strip-condition -local complete
;;;    p-to-sp - non local for output only
;;;    unmark-as-set - local complete
;;;    get-condition-type - local complete
;;;    get-id-var - local complete
;;;    get-vars-in-condition -local complete
;;;    mark-as-set -local complete
;;;    get-conditions-with-vars -local complete
;;;     bound-var? -local complete
;;;     bound-preference? -local complete
;;;      get-context-vars-in-pref -local complete
;;;     no-unbound-predicates? -local complete
;;;      all-bound? -local complete
;;;    classify -local complete
;;;     get-prev-rank -local complete
;;;     put-rank -local complete
;;;     get-mult-num -local complete
;;;    find-best-condition -local complete
;;;     lexless -local complete
;;;    get-attr-val-types -local complete
;;;    insert-ne-undec -local complete
;;;     variablep -nonlocal utility
;;;    check-negations -local complete
;;;  test-connected-actions -local complete
;;;   find-variables -nonlocal utility

;;;
;;;		iv.	Global Variables used
;;;
(defvar *default-multi* 5
  "Used only in reorder. Seems to be the default value for the number of augmentations
  a multi attribute will have.")
(defvar *max-recurse* 2 "Some depth level limit for reorder.")
(defvar *multi-attribute* () "The listing of which class/attribute pairs are multi-attributes.")
(defvar *global-pair* (list nil)
 "Used in reorder to return two values.
  Should be converted to use the values mechanism of common lisp.")
(defvar *order-trace* () 
 "When I'm on trace the condition reordering process.")
(eval-when (compile eval load) (proclaim '(special *warning*)))
(defvar *last-value-var* () "Something in reorder.")

;;;
;;;		I.	Unmark-as-set
;;;
;;; Unmark as set takes a list of variables and removes thier
;;; 'bound property.

(defun unmark-as-set (vlist) ; Dan.Scales 23-Mar-85 10:33 
       (do ((vl1 (cond ((atom vlist) (list vlist))
			    (t vlist))
		      (cdr vl1)))
		((null vl1) vlist)
		(remprop (car vl1) 'bound)))


;;;
;;;		II.	Mark-as-set
;;;
;;;	Mark-as-set takes a variable list and iterates across it
;;; seting each unbound variable it finds to bound. 
;;; 
;;; The separate look for 'bound on the plist and then the
;;; setf will waste time here. At least the soarputprop
;;; could be replaced with a push.
;;;

(defun mark-as-set (vlist) ; Randy.Gobbel 11-Sep-86 15:08  ; John.Laird 
 ; 12-Sep-85 11:14 
       (cond ((or (null vlist)
		  (equal vlist '(nil)))
	      nil)
	     (t (do ((vl1 (cond ((atom vlist)
				      (list vlist))
				     (t vlist))
			       (cdr vl1))
			  (result))
			 ((null vl1) result)
			 (cond ((and (symbolp (car vl1))
				     (not (get (car vl1) 'bound)))
				(soarputprop (car vl1)
					     t
					     'bound)
				(soarpush (car vl1)
					  result)))))))



;;;
;;;		III.	Bound-var?
;;;
;;;	Bound-var? determines if a variable is bound.
;;; This should be a macro.

(defun bound-var? (v) ; Randy.Gobbel 26-Mar-86 20:49  ; John.Laird 
 ; 27-Mar-85 09:40 
       (get v 'bound))


;;;
;;;		IV.	All-bound?
;;;
;;;	All-bound determines if a list of variables are all bound.
;;;

(defun all-bound? (vlist) ; Randy.Gobbel 26-Mar-86 20:48  ; John.Laird 
 ; 14-Oct-85 15:44 
       (do ((vl1 vlist (cdr vl1)))
		((null vl1)
		 t)
		(cond ((not (bound-var? (car vl1)))
		       (return nil)))))



;;;
;;;		V.	Lexless
;;;
;;;	Lexless takes a list of numbers and returns T
;;; iff the first list is lexically less than the second.
;;;

(defun lexless (a b) ; Dan.Scales 23-Mar-85 10:33 
       (do ((a1 a (cdr a1))
		 (b1 b (cdr b1)))
		((null a1) t)
		(cond ((null a1) (return t))
		      ((null b1) (return nil))
		      ((< (car a1) (car b1))
		       (return t))
		      ((< (car b1) (car a1))
		       (return nil)))))


;;;
;;;		VI.	Get-mult-num
;;;
;;;	Get-mult-num takes a wme type (class) and an attribute and
;;; looks up the multi-attribute number information for this type.
;;;

(defun get-mult-num (type attr) ; Randy.Gobbel 11-Sep-86 18:09  ; 
 ; Dan.Scales 23-Mar-85 10:33 
       (do ((l *multi-attribute* (cdr l)))
		((null l)
		 1)
		(cond ((and (eq (caar l) type)
			    (eqp (cadar l) attr))
		       (cond ((car (cddar l))
			      (return (car (cddar l))))
			     (t (return *default-multi*)))))))


;;;
;;;		VII.	Take-out-duplicates
;;;
;;;	(delete-duplicates lst :test #'eq)
;;; Should use the system delete-duplicates though.
;;;

(defun take-out-duplicates (lst) ; Randy.Gobbel 11-Sep-86 15:06 
       (do ((l lst (cdr l))
		 (result))
		((null l)
		 (return (nreverse result)))
		(cond ((not (soarmemq (car l) (cdr l)))
		       (soarpush (car l)
				 result)))))


;;;
;;;		VIII.	Strip-condition
;;;
;;;	This seems to simply take the record off of the record.condition-element.

(defun strip-condition (x) ; Dan.Scales 23-Mar-85 11:22 
       (cond ((atom x) x)
	     (t (cdr x))))


;;;
;;;		IX.	Get-all-vars-in-neg
;;;
;;;	This seems to take the car of a list which is some record describing the ce
;;; pushed onto the condition element.
;;; and with a list of all of its variables pushed on top.
;;;	This should be a macro.
;;;

(defun get-all-vars-in-neg (neg) ; Dan.Scales 23-Mar-85 10:33 
       (car neg))


;;;
;;;		X.	Get-att-val-types
;;;
;;;	This should be a macro.
;;;
;;;	Get-att-val-types takes a variable list pushed onto a condition element
;;; and returns two pairs consed onto each other.
;;; The first describes the attribute of a condition element as a constant or a var
;;; and its cdr is the attribute name.
;;; The second describes the value as a constant or var dotted onto the value.

(defun get-attr-val-types (x) ; Dan.Scales 23-Mar-85 11:21 
       (cadr (cddar x)))


;;;
;;;		XI.	Get-condition-type
;;;
;;;	This routine takes a record.condition-element and returns the
;;; condition element's class.
;;; Ought to be a macro.

(defun get-condition-type (c) ; Dan.Scales 23-Mar-85 11:21 
       (cadr c))



;;;
;;;		XII.	Get-pred-vars-in-condition
;;; Ought to be a macro.

(defun get-pred-vars-in-condition (c) ; Dan.Scales 23-Mar-85 10:33 
       (car (car c)))


;;;
;;;		XIII.	Get-id-var
;;;
;;;	Get's the identifier variable from the record of a record.condition.
;;; Called four times should not be a macro.

(defun get-id-var (c) ; Dan.Scales 23-Mar-85 10:33  ; RETURN THE VARIABLE 
 ; ASSOCIATED WITH THE ID ATTRIBUTE IN CONDITION C * 
       (cadr (car c)))


;;;
;;;		XIV.	Get-vars-in-condition
;;;
;;;	Get's the variable list of the record of a record.condition.
;;;

(defun get-vars-in-condition (c) ; Dan.Scales 23-Mar-85 10:33 
       (caddr (car c)))


;;;
;;;		XV.	Get-prev-rank
;;;
;;;	Gets something out of the record of the record.condition.
;;; Called once should be a macro.

(defun get-prev-rank (c) ; Dan.Scales 23-Mar-85 10:33 
       (car (cddddr (car c))))


;;;
;;;		XVI.	Get-context-vars-in-pref
;;;
;;;	Gets the list of the context bound variables in record of
;;; a record.condition which happens to be a preference.
;;; Called once. Should be a macro.

(defun get-context-vars-in-pref (pr) ; Dan.Scales 23-Mar-85 10:33 
       (cadr (cddar pr)))


;;;
;;;		XVII.	Find-all-vars-in-condition
;;;
;;;	Append ought to be an nconc.
;;;
;;;	Find-all-vars-in-condition takes an condition and 
;;; returns the list of variables contained within.
;;; 

(defun find-all-vars-in-condition (c) 
 ;; Installed with ugly patches from TRJ via GRY. -BGM 1/98/89
 ; Randy.Gobbel 15-Jul-86 17:50  ; 
 ; Dan.Scales 23-Mar-85 10:33 
       (do ((vars))
		((null c) vars)
		(cond 
		 ((atom c) (setq c nil))    ; trj
		      ((variablep-not-predicate (car c))
		       (soarpush (car c) vars)
		       (pop c))
		      ((and (soarlistp (car c)) (eq (caar c) '<<))
		       (pop c))
		      ((soarlistp (car c))
		       (setq vars (append (find-all-vars-in-condition (cdar c)) vars))
		       (pop c))
		      (t (pop c)))))


;;;
;;;		XVIII.	No-unbound-predicates?
;;;
;;; Called once could be a macro.	

(defun no-unbound-predicates? (c) ; edited: 4-Feb-86 09:28 
       (all-bound? (get-pred-vars-in-condition c)))


;;;
;;;		XIX.	Predicatep
;;;
;;;	Checks to see that the argument is a symbol and that it has a
;;; predicate property denoting that it is one of the OPS5 predicates:
;;; <, >, ...
;;; Could be a macro.

(eval-when (eval load)
  (mapc #'(lambda (x) (setf (get x 'predicate) t)) '(< <= <=> <> = > >=)))

(defun predicatep (x) ; Randy.Gobbel 26-Mar-86 21:55  ; John.Laird 
 ; 10-May-85 16:20  ; TRUE IS X IS A PREDICATE SYMBOL 
       (and (symbolp x) (get x 'predicate)))



;;;
;;;		XX.	Put-rank
;;;
;;;	Seems to set some rank field in the record of a record.condition.
;;; Called five times.
;;;

(defun put-rank (c n) ; Dan.Scales 23-Mar-85 10:33 
   (rplaca (cddddr (car c)) n))



;;;
;;;		XXI.	Bound-preference?
;;;

(defun bound-preference? (pr) ; Randy.Gobbel 26-Mar-86 20:49  ; John.Laird 
 ; 7-Oct-85 10:53 
       (all-bound? (get-context-vars-in-pref pr)))



;;;
;;;		XXII.	Check-negations
;;;
;;;	

(defun check-negations (negations) ; Randy.Gobbel 13-May-86 14:04 
       (do ((neg negations (cddr neg))
		 (active)
		 (unactive))
		((null neg) (cons active unactive))
		(cond ((all-bound? (get-all-vars-in-neg (car neg)))
		       (soarpush (cadr neg) active)
		       (soarpush (strip-condition (car neg)) active))
		      (t (soarpush (cadr neg) unactive)
			 (soarpush (car neg) unactive)))))


;;;
;;;		XXII.	Dup-action
;;;

(eval-when (compile eval load) (proclaim '(special *suspected-duplicates*)))

(defun dup-action (condition action-list) ; John.Laird 19-Jun-86 17:23 
       (prog (shared-variable action)
	     (setq shared-variable (car (intrq condition *suspected-duplicates*)
					))
	     l1
	     (setq action (pop action-list))
	     (cond ((soarmemq shared-variable action)
		    (return action))
		   ((null action)
		    (return)))
	     (go l1)))



;;;
;;;		XXIII.	Classify
;;;
;;;	Returns some very magic numbers for value of the conditions.
;;; Returns a pair of some numeric value classifying the conditions
;;; consed onto some list of conditions.
;;; The values returned are:
;;; 102 the default
;;; 0 something about conjunctions
;;; 1 - constant attribute, constant value. (C Vb C C)
;;; 2 - (C Vb << C Vb>> << C Vb>>)
;;; 4 - (Goal Vb Cs ...
;;; 5 - (Goal Vb Cm ...
;;; 6 + m - ( ? Vb Cm Vu
;;; 6 + 5 (*default-multi*) -  (C Vb << Vu Vb >>  << C Vu Vb >>)
;;; 101 - last resort.
;;; 6 + *default-multi* for preferences with role operator
;;; 3 preferences with out role for an operator.
;;;   

(defun classify (dup-vars conditions flag) ; Randy.Gobbel 11-Sep-86 18:08  ; CLASSIFY 
 ; THE CONDITIONS OF OLD-CONDITIONS INTO GROUPS - RETURN A PAIR OF THE 
 ; RANK OF THE HIGHEST RANKING GROUP AND THE LIST OF ELEMENTS IN THAT 
 ; GROUP BASED ON THE TYPES OF ELEMENTS IN THEIR ATTRIBUTE AND VALUE 
 ; FIELDS - DUP-VARS A LIST OF ALL VARIABLES THAT OCCUR MORE THAN ONCE IN 
 ; THE ORIGINAL CONDITION LIST BEING ORDERED 
 ; Modified on 04-04-91 by BGM to correctly handle multi-attributes on goals
  (prog (attr-type attr-val val-type val-val temp c i mini result)
	(setq mini 102)
	l1
	(cond ((null conditions)
	       (return (rplnode *global-pair* mini (nreverse result)))))
	(setq c (pop conditions))
	(cond ((eq (get-id-var c) 'conj)
	       (setq i 0)
	       (go l2) ; Spurious goto.
	       )
	      ((setq i (get-prev-rank c)) 
               ; USE PREVIOUSLY CALCULATED RANK  IF IT EXISTS 
	       (cond (i (go l2))) ; Spurious goto.
	       )
	      ((eq (get-condition-type c) 'preference)
	       (cond ((eq 'operator (wme-role (cdr c)))
		      (setq i (+ 6 *default-multi*)))
		     (t (setq i 3)))
	       (and flag (put-rank c i)))
	      (t (setq temp (get-attr-val-types c))
		 (setq attr-type (caar temp))
		 (setq val-type (cadr temp))
		 (setq attr-val (cdar temp))
		 (setq val-val (cddr temp)) ; CHANGE TYPE OF FIELD TO 
 ; SET-VAR IF THE TYPE IS ALREADY VAR AND THE VARIABLE IN THE FIELD IS IN 
 ; SET-VAR 
		 (cond ((and (eq attr-type 'var) (bound-var? attr-val))
			(setq attr-type 'set-var)))
		 (cond ((and (eq val-type 'var) (bound-var? val-val))
			(setq val-type 'set-var)))
		 (cond ((and (eq attr-type 'const) (eq val-type 'const))
			(setq i 1)
			(put-rank c 1))
		       ((and (soarmemq attr-type '(const set-var))
			     (soarmemq val-type '(const set-var)))
			(setq i 2)
			(and flag (put-rank c 2)))
		       ((eq (get-condition-type c) 'goal)
			(cond ((eqp (get-mult-num (get-condition-type c) attr-val) 1)
			       (setq i 4))
			      (t 
                                 (if (and (eq attr-type 'const) (eq val-type 'var)
                                          (soarmemq val-val dup-vars))
                                     (setq i (+ 6 (get-mult-num (get-condition-type c) attr-val)))
                                     (setq i 5))))
			(put-rank c i))
		       ((and (eq attr-type 'const) (eq val-type 'var) (soarmemq val-val dup-vars))
			(setq i (+ 6 (get-mult-num (get-condition-type c) attr-val))))
		       ((and (soarmemq attr-type '(var set-var))
			     (soarmemq attr-val dup-vars)
			     (soarmemq val-type '(const var set-var))
			     (soarmemq val-val dup-vars))
			(setq i (+ 6 *default-multi*)))
		       (t (setq i 101)
			  (put-rank c 101)))))
	l2
	(cond ((< i mini)
	       (setq mini i)
	       (setq result (list c)))
	      ((= i mini)
	       (soarpush c result)))
	(go l1)))



;;;
;;;		XXIV.	Classify-match-elt
;;;
;;;	Take an unaugmented condition and returns a pair.
;;; Replaces the car of *global-pair* with cdr x and then
;;; the cdr with a pair describing the first matching element
;;; it found. This is a hack to save conses and all of this
;;; really ought to be replaced with multiple values.
;;; The rplnode should not be used here; it's a rete code generation operation.
;;;

(defun classify-match-elt (x) ; Randy.Gobbel 10-Jun-86 14:03  ; Dan.Scales 
 ; 23-Mar-85 10:33  ; RETURN A (TYPE VALUE) LIST CLASSIFYING THE NEXT 
 ; MATCH ELEMENT (VARIABLE - CONSTANT - PREDICATE EXPRESSION OR 
 ; DISJUNCTION) TYPE CAN BE VARIABLE - CONSTANT OR OTHER * 
       (cond ((and (soarlistp (car x)) (eq (caar x) '<<))
	      (rplnode *global-pair* (cdr x) '(other)))
	     ((predicatep (car x))
	      (rplnode *global-pair* (cddr x) '(other)))
	     ((variablep-not-predicate (car x))
	      (rplnode *global-pair* (cdr x) (cons 'var (car x))))
	     (t (rplnode *global-pair* (cdr x) (cons 'const (car x))))))



;;;
;;;		XXV.	Pop-match-elt
;;;
;;; Used to cdr over tests in conjunctions by classify-term.

(defmacro pop-match-elt (x)
	`(prog (temp)
	  (setq temp (classify-match-elt ,x))
	  (setq ,x (car temp))
	  (return (cdr temp))))



;;;
;;;		XXVI.	Pop-term
;;;
;;;	Used to classify terms by find-info-on-cond.

(defmacro pop-term (x)
	`(prog (temp)
	  (setq temp (classify-term ,x))
	  (setq ,x (car temp))
	  (return (cdr temp))))

;;;
;;;		XXVII.	Classify-term
;;;
;;;	Classify-term takes an augmented condition and 
;;; returns what classify-match-elt does on the first 
;;; thing in the ce part itself. Cdr's over conjunctions
;;; classifying them by their binding part (non predicate).
;;;

(defun classify-term  (x) 
 ; Randy.Gobbel 12-Jun-86 16:45  ; Dan.Scales 23-Mar-85 10:33  ; 
 ; RETURN (TYPE VALUE) LIST CLASSIFYING THE NEXT MATCH TERM (VARIABLE 
 ; CONSTANT PREDICATE DISJUNCTION OR CONJUNCTION OF MATCH ELEMENTS) IF THE 
 ; TERM IS A CONJUNCTION - IT IS CLASSIFIED ACCORDING TO ITS NON-PREDICATE 
 ; COMPONENT 
  (prog (result)
    (setq result '(other))
    (cond ((and (soarlistp (car x)) (eq (caar x) '{))
	   (return (prog (next-elt y)
			 (setq y (cdr x))
			 (setq x (cdar x))
			 loop
			 (cond ((eq (car x) '})
				(return (rplnode *global-pair* y result)))
			       (t (setq next-elt (pop-match-elt x))
				  (cond ((soarmemq (car next-elt) '(var const))
					 (setq result next-elt)))
				  (go loop))))))
	  (t (return (classify-match-elt x))))))


;;;
;;;		XXVIII.	Find-best-condition
;;;
;;;	
;;;	Dup-vars are the variables which are duplicated in the entire
;;; condition list.
;;; Active-conditions are those remaining conditions which have a bound
;;; variable in their id slot, and hence are good candidates for reordering.
;;; Un-active-conditions are those which do not have a their id bound.
;;; CCL is a classification of the active conditions from classify.
;;; Recurse-level is how deeply it's been called so far.
;;; Minsofar is very confusing; its a list of these numeric codes that
;;; are thoroughly undocumented.

(defun find-best-condition (dup-vars active-conditions un-active-conditions ccl 
				     recurse-level minsofar)
 ; Randy.Gobbel 26-Mar-86 21:54  ; RETURN THE BEST CONDITION TO APPEAR 
 ; NEXT IN THE ORDERING - DUP-VARS A LIST OF THE VARIABLES THAT OCCUR MORE 
 ; THAN ONCE IN THE ORIGINAL CONDITION LIST TO BE ORDERED - 
 ; ACTIVE-CONDITIONS ARE THE CONDITIONS WHOSE ID IS A SET-VAR AND HENCE 
 ; ARE ELIGIBLE FOR ORDERING - UN-ACTIVE-CONDITIONS IS A LIST OF THE 
 ; CONDITIONS THAT ARE TO BE ORDERED BUT ARE NOT YET ACTIVE, CCL IS A 
 ; CLASSIFICATION OF THE ACTIVE-CONDITONS, AND RECURSE-LEVEL IS HOW MANY 
 ; TIMES FIND-BEST-CONDITION HAS BEEN CALLED RECURSIVELY. 
       (prog (ccl1 i c tie-conds minc minrank temp new-vars act-conds 
		   un-act-conds s-v best)
	     (setq i (car ccl))
	     (setq tie-conds (cdr ccl))
 ; USING GROUP RETURNED BY CLASSIFY 
 ; - EITHER TAKE THE TOP CONDITION OR TRY TO BREAK THE TIE VIA A RECURSIVE 
 ; CALL TO FIND-BEST-CONDITIONS. TAKE THE TOP CONDITION IF: THE CURRENT 
 ; GROUP IS A THROUGH E OR GROUP I; THERE IS ONLY ONE CONDITION AND THE 
 ; CURRENT GROUP IS NOT GROUP 6 IN A RECURSIVE CALL; OR WE HAVE ALREADY 
 ; REACHED THE MAXIMUM RECURSION. 
	     (cond ((> i 101) (return nil))
		   ((or (<= i 6) (= i 101)
			(and (null (cdr tie-conds))
			     (or (not (= i 7)) (= recurse-level 0)))
			(= recurse-level *max-recurse*))
  ; TAKE TOP  ELEMENT OF GROUP 
		    (setq c (car tie-conds))
		    (return (cons (list i) c))))
 ; ATTEMPT TO BREAK A TIE BY  RECURSIVE CALLS 
	     (setq minrank '(102)) 
 ; STOP THIS SEARCH IF WE'VE ALREADY FOUND A CONDITION THAT'S BETTER 
	     (cond ((and minsofar 
			 (or (> i (car minsofar))
			     (and (= i (car minsofar)) (cdr minsofar) (= 1 (cadr minsofar)))))
		    (return '((100)))))
	     l2 ; RECURSIVELY RANK NEXT TYING CONDITION 
	     (setq c (pop tie-conds))
	     (and (null c) (go l3))
	     (setq temp (get-attr-val-types c))
	     (cond ((eq (cadr temp) 'const) 
                    ; NO VAR IN VALUE FIELD SO USE VAR IN ATTR FIELD 
		    (setq new-vars (list (cdar temp))))
		   (t (setq new-vars (list (cddr temp)))))
	     (setq act-conds (remove c active-conditions))
	     (setq s-v (mark-as-set new-vars))
	     (setq temp (get-conditions-with-vars s-v un-active-conditions))
	     (setq act-conds (append (car temp)
				     act-conds))
	     (setq un-act-conds (cdr temp))
	     (setq ccl1 (classify dup-vars act-conds nil))
	     (setq best 
		   (find-best-condition dup-vars act-conds un-act-conds 
					ccl1 (+ 1 recurse-level) (cdr minrank)))
	     (unmark-as-set s-v)
	     ; THIS LATEST CONDITION BETTER THAN THE  ONES SO FAR? 
	     (cond ((or (and (equal (car best) minrank)
			     (eq (get-id-var c) *last-value-var*))
			(lexless (car best) minrank)) ; SAVE IT 
		    (setq minrank (car best))
		    (setq minc c)))
	     (cond ((eq (car minrank) 1)
		    (go l3)))
	     (go l2)
	     l3 ; RETURN BEST CONDITION 
	     (return (cons (cons i minrank) minc))))



;;;
;;;		XXIX.	Find-info-on-cond
;;;
;;;	This seems to build the record that gets tacked onto each condition
;;; element.
;;;
;;; It's form for non preferences is: ID VARS ATT.VAL Rank.
;;;	Id is the condition element's identifier.
;;;	Vars are all of the variables of the condition.
;;;
;;;	Flag is used to signal a preference which gets a different
;;; record type.
;;; 
;;; It's form for preferences is: id vars prefvars rank.
;;; Id is the condition element identifier.
;;; Vars are the variables in the id, role and value slots.
;;; Prefvars are those other than the identifier and role: goal, problem-space, state, operator, reference.
;;; 
      

                 
(defun find-info-on-cond (c flag) 
  ;; Added tests of *warning* so chunker can suppress warnings during
  ;; compilation of constant internal chunks. -KAM 6/11/89.
  ;; Updated Soarwarns. -BGM 1/30/89
  ; Randy.Gobbel 16-Jul-86 16:47 
  (let ((condition c))
       (prog (attr val id vars next-term prefvars)
	     (setq attr '(const))
	     (setq val '(const))
	     (setq next-term (pop-term c))
	     (cond ((eq (car next-term) 'var)
		    (soarpush (cdr next-term) vars)))
	     (setq next-term (pop-term c))
	     (cond ((eq (car next-term) 'var)
		    (soarpush (cdr next-term) vars)
		    (setq id (cdr next-term)))
		   ((eq (car next-term)	'const)
		    (soarwarn "Constant identifier/object field in:  " "")
      (cond (*warning*                     ;Added. -KAM 6/11/89.
       		    (pm-lhs (list condition)) ))
		    (setq id 'const))
		   ((eq (car next-term) 'other)
		    (soarwarn "Identifier/object field not variable in:  " "")
      (cond (*warning*                     ;Added. -KAM 6/11/89.
       		    (pm-lhs (list condition)) ))
		    (setq id nil))
		   (t (setq id (cdr next-term))))
	     (setq next-term (pop-term c))
	     (cond ((eq (car next-term) 'var)
		    (soarpush (cdr next-term) vars)))
	     (setq attr next-term)
	     (setq next-term (pop-term c))
	     (cond ((eq (car next-term) 'var)
		    (soarpush (cdr next-term) vars)))
	     (setq val next-term)
	     (cond (flag (soarwhile (consp c) ; Changed endtest to prevent infinite loops. _BGM 3/27/89
				    (setq next-term (pop-term c))
				    (cond ((eq (car next-term) 'var)
					   (soarpush (cdr next-term) prefvars))))
			 (return (list id vars prefvars nil))))
	     (return (list id vars (cons attr val)
			   nil)))))




;;;
;;;		XXX.	Find-pred-vars-in-condition
;;;

(defun find-pred-vars-in-condition (c) ; Randy.Gobbel 10-Jun-86 14:51  ; 
 ; Dan.Scales 23-Mar-85 10:33  ; RETURNS ALL VARIABLES APPEARING IN 
 ; PREDICATES IN CONDITION C - USED TO ENSURE THAT A CONDITION IS REJECTED 
 ; IF IT CONTAINS A PREDICATE WITH A VARIABLE THAT HASN'T BEEN BOUND YET 
       (do ((type)
		 (varlist))
		((null c)
		 varlist)
		(cond ((predicatep (car c))
		       (pop c)
		       (setq type (pop-match-elt c))
		       (cond ((eq (car type)
				  'var)
			      (soarpush (cdr type)
					varlist))))
		      ((and (soarlistp (car c))
			    (eq (caar c)
				'<<))
		       (setq c (cdr c)))
		      ((soarlistp (car c))
		       (setq type (find-pred-vars-in-condition (pop c)))
		       (cond (type (setq varlist (append type varlist)))))
		      (t (pop c)))))


;;;
;;;		XXXI.	Get-conditions-with-vars
;;;
;;;	Get-conditions-with-vars splits the condition list
;;; into conditions whose id variables are in the vars list
;;; and which don't have any predicates with unbound variables.
;;; They are returned in a dotted pair.

(defun  get-conditions-with-vars (vars cl) 
 ; Randy.Gobbel 13-May-86 14:18  ; RETURNS A DOTTED PAIR OF A 
 ; LIST OF ALL CONDITIONS IN CL WHOSE ID VARIABLES ARE IN THE LIST VARS 
 ; AND WHICH DON'T HAVE ANY PREDICATES WITH VARIABLES NOT IN VARS AND A 
 ; LIST OF THE REST OF THE CONDITIONS 
  (cond
    ((null vars)
     nil)
    (t
      (do
	((cl1 cl (cdr cl1))
	 (result-with)
	 (result-wo)
	 (id))
	((null cl1)
	 (cons (nreverse result-with)
	       (nreverse result-wo)))
	(setq id (get-id-var (car cl1)))
	(cond ((and (or (and (not (eq (get-condition-type (car cl1))
				      'preference))
			     (bound-var? id))
			(eq id 'const)
			(and (eq id 'conj)
			     (any-bound? (get-vars-in-condition (car cl1))))
			(and (eq (get-condition-type (car cl1))
				 'preference)
			     (bound-preference? (car cl1))))
		    (no-unbound-predicates? (car cl1)))
	       (soarpush (car cl1)
			 result-with))
	      (t (soarpush (car cl1)
			   result-wo)))))))

;;;
;;;		XXXII.	Insert-ne-undec
;;;
;;;	Insert's <> undecided tests for all goal context variables.
;;; This is a little over general and causes a subtle bug.
;;; Patch from ARG installed by BGM 2/22/88.

(defun insert-ne-undec (c2) 
 ;; Modified to always return the input condition when compiled under DSM
 ;; to turn off the insertion of <> undecided, as they are no longer needed
 ;; in DSM. -BGM 7/30/88.   
 ; Randy.Gobbel 11-Sep-86 15:05  
 ; Insert <>  undecided along with any variables in c that do not appear in dup-vars 
 ; - which is meant to be a list of variables that appear more than once 
 ; in a production 
    c2
   )


;;;
;;;		XXXIII.	Re-order-conditions
;;;	
;;;	Takes a condition list and reorders the conditions and return the
;;; new condition list.
;;; First it sorts the conditions.
;;; 

(defvar *condition-vars* () "")

(defun re-order-conditions (cl) 
 ;; Exchanged delete for dremove. -BGM 2/11/89
 ;; Changed two calls to the old p style conversion/print to 
 ;; a call to pm-lhs-ce. -BGM 1/23/89
 ;; Updated old style IO to soar-format. -BGM 8/18/88
  ; Randy.Gobbel 12-Sep-86 12:06 
  (prog (un-active-conditions new-conditions set-vars dup ccl best 
			      active-conditions negations temp 
			      already-no-active-conditions)
	(cond ((null cl) (return nil)))
	(setq cl (sort-conditions cl))
	(setq *last-value-var* nil)
	(setq negations (cadr cl))
	(setq dup (caddr cl))
	(setq cl (car cl)) 
         ; UN-ACTIVE-CONDITIONS IS A LIST OF ALL 
         ; CONDITIONS THAT HAVEN'T BEEN ORDERED YET 
	(setq un-active-conditions cl)
	(setq active-conditions nil)
	(go l4)
	l0
	(cond ((null un-active-conditions)
	       (cond (negations
		      (soarwhile (consp negations) ; Changed endtest to prevent infinite loops. _BGM 3/27/89
 				 (soarpush (cadr negations) new-conditions)
                         (soarpush (strip-condition (car negations))
				   new-conditions)
			 (when *warning*
			  (soarwarn 
			    "Unlinked condition or unnecessary variable in condition "
			    "" ; Hack.
			    ; (p-to-sp (car new-conditions))
			    )
			  (pm-lhs (list '- (car new-conditions)))
			  ; Bug here. -BGM 1/30/89.
			  ;; Changed to pm-lhs. -BGM 1/30/89
			  )
			 (setq negations (cddr negations)))))
	       (unmark-as-set set-vars)
	       (setq *condition-vars* (append set-vars *condition-vars*))
	       (return (nreverse new-conditions)))
	      ((or already-no-active-conditions
		   (not (eq 'goal (get-condition-type (car un-active-conditions)))))
	       (soarpush (strip-condition (car un-active-conditions))
			 new-conditions)
	       (setq un-active-conditions (cdr un-active-conditions))
	       (setq already-no-active-conditions nil)
	       (cond ((not (eq (wme-class (car new-conditions))
			   'preference))
		      (when *warning*
			(soarwarn 
			  "Condition not linked to previous conditions "
			  "" ; Hack.
			  ;(p-to-sp (car new-conditions))
			  )
			;; Changed to PM lhs 1/30/89.
			(pm-lhs (list (car new-conditions))))
		      ))
	       (go l0)))
	l4
	(setq already-no-active-conditions t)
	(setq temp (get-id-var (car un-active-conditions)))
	(cond ((eq temp 'conj)
	       (setq temp (car (get-vars-in-condition (car un-active-conditions))))))
	(setq set-vars (append (mark-as-set temp) set-vars))
	l3
	(setq temp (get-conditions-with-vars set-vars un-active-conditions))
	(setq active-conditions (append (car temp)
					active-conditions))
	(setq un-active-conditions (cdr temp))
	(cond ((null active-conditions) (go l0)))
	(setq ccl (classify dup active-conditions t))
	(setq best (find-best-condition dup active-conditions 
					un-active-conditions ccl 0 nil))
	(setq already-no-active-conditions nil)
	(cond ((null best) (go l0)))
	(cond (*order-trace*
		(soar-format *trace-file* "~A~%" (cons (car best) (strip-condition (cdr best))))))
	(setq best (cdr best))
	(setq active-conditions (delete best active-conditions))
	(setq set-vars (append (mark-as-set (get-vars-in-condition best)) set-vars))
	(setq temp (get-attr-val-types best))
	(cond ((eq (cadr temp) 'var)
	       (setq *last-value-var* (cddr temp)))
	      (t (setq *last-value-var* nil)))
	(setq temp (strip-condition best)) ; INSERT <> UNDEC IN 
 ; APPROPRIATE PLACES IF THIS IS A GOAL-CONTEXT-INFO 
	(cond ((eq (get-condition-type best) 'goal)
	       (insert-ne-undec temp)))
	(soarpush temp new-conditions)
	(setq temp (check-negations negations))
	(setq new-conditions (append (car temp) new-conditions))
	(setq negations (cdr temp))
	(go l3)))



;;;
;;;		XXXIV.	Reorder-p-conds
;;;
;;;	This is the entry point of this submodule and the exit point. 
;;; Calls reorder-p-conds1 which recurses through and reorders.
;;; 

(eval-when (compile eval load) (proclaim '(special *p-name*)))

(defun reorder-p-conds (prod) ; Randy.Gobbel 16-Jul-86 16:48 
       (prog (type)
	     #+:soar-times (start-soar-time reorder)
	     (setq *p-name* (pop prod))
	     (setq *condition-vars* nil)
	     (setq type (cond ((soarmemq (car prod)
					 '(elaborate serial))
			       (pop prod))
			      (t 'elaborate)))
	     (setq prod (reorder-p-conds1 prod '-->))
	     (let ((value
		    (append (list 'p *p-name* type)
			    (cdr prod)
			    (list '-->)
			    (test-connected-actions (car prod)))))
	       #+:soar-times (stop-soar-time reorder)
	       (return value))))


;;;
;;;		XXXV.	Reorder-p-conds1
;;;
;;;	This recurses along ripping the conditions out of the condition
;;; list in a really stupid fashion. Then it calls re-order-conditions
;;; which does the actual work on the condition list. If you put a
;;; conjunctive negation in then it calls re-order-conditions on
;;; it in isolation of all of the outside variable bindings, after which
;;; it re-order-conditions over the entire condition list.

(defun reorder-p-conds1 (condlist delim) ; Randy.Gobbel 20-Jun-86 13:47 
       (prog (tmp conds)
	     condloop
	     (cond ((or (null condlist)
			(eq (car condlist) '-->)
			(eq (car condlist) '}))
		    (go doneconds)))
	     (cond ((eq (car condlist)'{)
		    (setq tmp (reorder-p-conds1 (cdr condlist)'}))
		    (setq condlist (car tmp))
		    (soarpush (cdr tmp) conds))
		   (t (soarpush (pop condlist) conds)))
	     (go condloop)
	     doneconds
	     (cond ((and (eq delim '})
			 (not (eq (car condlist) '})))
		    (soarerror "Missing }" nil))
		   ((eq delim '-->)
		    (cond ((eq (car condlist) '})
			   (soarerror "Extra }" nil))
			  ((not (eq (car condlist) '-->))
			   (soarerror "Missing -->" nil)))))
	     (pop condlist)
	     (cond ((null conds)
		    (cond ((eq delim '-->)
			   (soarerror "Missing conditions in rule LHS" nil))
			  (t (soarerror "Missing conditions between { and }" nil)))))
	     (return (cons condlist (re-order-conditions (nreverse conds))))))


;;;
;;;		XXXVI.	Sort-conditions
;;;  Returns a three list of the form:
;;; The goal context conditions consed onto the positive conditions.
;;; The negated conditions and foralls followed by their - or *.
;;; The duplicated variables.
      

(defun sort-conditions  (cl)     
 ;; Added test of *warning* to suppress warnings during compilation of
 ;; constant internal chunks. -KAM 6/11/89.
 ; Added new style PM output. -BGM 1/30/89
 ; Randy.Gobbel 11-Sep-86 15:06  ; SORT CONDITIONS IN CONDITION LIST 
 ; CL INTO PREFERENCES NEGATIONS AND REGULAR CONDITIONS 
  (prog
    (regulars c c1 foralls goal-contexts tmp varlist dup nl)
    (setq foralls nil)
    (soarwhile
      (consp cl) ; Changed endtest to prevent infinite loops. _BGM 3/27/89
      (setq c (pop cl))
      (cond ((is-negation c) ; C1 CONTAINS WHAT FOLLOWS - OR * 
	     (setq c1 (pop cl))
	     (cond ((listp (car c1))
		    (soarpush (cons 
				(soarmapconc #'find-all-vars-in-condition c1)
				c1)
			      foralls))
		   (t (soarpush (cons (find-all-vars-in-condition c1)
				      c1)
				foralls)))
	     (unmark-as-set (get-all-vars-in-neg (car foralls)))
	     (soarpush c foralls))
	    ((listp (car c))
	     (setq tmp (cons (list nil 'conj
				   (soarmapconc #'find-all-vars-in-condition c)
				   nil nil)
			     c))
	     (unmark-as-set (get-vars-in-condition tmp))
	     (cond ((eq (caar c)
			'goal)
		    (soarpush tmp goal-contexts))
		   (t (soarpush tmp regulars)))
	     (setq varlist (append (get-vars-in-condition tmp)
				   varlist)))
	    (t (setq tmp (cons (cons (find-pred-vars-in-condition c)
				     (find-info-on-cond
				       c
				       (cond ((eq (car c)
						  'preference)
					      'preference)
					     (t nil))))
			       c))
	       (unmark-as-set (get-pred-vars-in-condition tmp))
	       (unmark-as-set (get-vars-in-condition tmp))
	       (cond ((eq (car c)
			  'goal)
		      (soarpush tmp goal-contexts))
		     (t (soarpush tmp regulars)))
	       (setq varlist (append (get-pred-vars-in-condition tmp)
				     (append (get-vars-in-condition tmp)
					     varlist))))))
    (setq dup (get-duplicates varlist))
    (setq varlist (take-out-duplicates varlist))
    (setq nl foralls)
    (soarwhile nl (setq tmp (get-all-vars-in-neg (cadr nl)))
	       (rplaca (cadr nl)
		       (append (intrq (get-duplicates tmp)
				      varlist)
			       (get-non-duplicates tmp)))
	       (cond ((null (get-all-vars-in-neg (cadr nl)))
		      (soarwarn 
		       "Negation or forall unconnected to rest of production"
		       "")
        (cond (*warning*           ;added. KAM 6/11/89.
       		      (pm-lhs (list '- (cdadr nl))) ))
		      ))
	       (setq nl (cddr nl)))
    (return (list (append (nreverse goal-contexts)
			  (nreverse regulars))
		  (nreverse foralls)
		  dup))))


;;;
;;;		XXXVII.	 Test-connected-actions
;;;

(defun test-connected-actions (actions)
 ;; Changed the call to the old style p printing to a pm-rhs. -BGM 1/23/89
 ;; Removed *constants*. -BGM 12/7/88
 ; Randy.Gobbel 16-Jul-86 16:46 
  (prog (changed-flag action save-action saved-actions found-variable 
		      return-list make-flag label-binds)
	(setq changed-flag t)
	(setq label-binds nil)
	(setq make-flag nil)
	(soarwhile
	  (and actions changed-flag)
	  (setq saved-actions nil)
	  (setq changed-flag nil)
	  (soarwhile actions (setq action (pop actions))
		     (cond ((eq (car action)
				'make)
			    (setq save-action action)
			    (setq make-flag t)
			    (setq action (cdr action))
			    (setq found-variable nil)
			    (soarwhile (and action (not (soarmemq (car action)
								  
							   *condition-vars*)))
				       (cond ((variablep-not-predicate (car action))
					      (setq found-variable t)))
				       (pop action))
			    (cond ((and (null action)
					found-variable)
				   (soarpush save-action saved-actions))
				  ((soarmemq (car action)
					     *condition-vars*)
				   (setq *condition-vars*
					 (union (find-variables save-action)
						*condition-vars*))
				   (setq changed-flag t)
				   (soarpush save-action return-list))
				  (t (soarpush save-action return-list))))
			   (t (soarpush action return-list))))
	  (setq actions saved-actions))
	(soarwhile label-binds (setq return-list
				     (append return-list
					     (list (list 'label-bind
							 (caar label-binds)
							 (cdar label-binds)))))
		   (pop label-binds))
	(cond ((and make-flag (null changed-flag))
	       (soarwarn "Unconnected actions in production" 
			 "" ; Hack.
			 ; (p-to-sp actions)
			 )
	       (pm-rhs actions)
	       (return (append (nreverse return-list)
			       actions)))
	      ((null actions)
	       (return (nreverse return-list))))))


;;;
;;;		XXXIX.	Rplnode
;;;
;;; At one time this was a code generation operation.
;;; All it really does is a rplcar and a rplcdr.
;;; It is now only used by reorder.

(defun rplnode (x c d)
    (rplaca x c)
    (rplacd x d))



;;;
;;;		XXXX.	Multi-attribute
;;;

(defun multi-attribute (x) ; Randy.Gobbel 13-Jun-86 14:33 
       (prog (class)
	     (create-new-class (car x))
	     (setq class (pop x))
	     (cond ((and (cdr x)
			 (numberp (cadr x))
			 (or (> (cadr x)
				99)
			     (< (cadr x)
			       1)))
		    (soarwarn "Illegal multi-attribute value" (cadr x))
		    (setq x (list (car x)))))
	     (soarpush (cons class x)
		       *multi-attribute*)))



;;;
;;;		XXXXI.	Multi-attributes
;;;

(defun multi-attributes (&optional (x nil xp))
 ;; Changed to return the current multi-attributes when passedno argumetnt. -BGM 9/15/89
; John.Laird 25-Mar-85 15:47 
    (if xp
       (soarmapc #'multi-attribute x)
       *multi-attribute*))


;;;
;;;		XXXXII.	Any-bound?
;;;

(defun any-bound? (vlist) ; Randy.Gobbel 13-May-86 14:04 
       (do ((vl1 vlist (cdr vl1)))
		((null vl1)
		 nil)
		(cond ((bound-var? (car vl1))
		       (return t)))))


;;;
;;;		XXXXIII.	Remove-condition-trash
;;;


(defun remove-condition-trash (condition) 
  ;; Installed ugly patches from TRJ via GRY. -1/9/89
  ; Randy.Gobbel 17-Oct-86 12:36 
       (prog (return-condition)
	     (setq return-condition nil)
	     (soarwhile condition
	       (cond ((atom condition)   ; trj
		      (setq return-condition condition) ; trj
		      (setq condition nil)) ; trj
		     ((and (soarlistp (car condition))
			   (eq (caar condition) '<<))
		      (pop condition)
		      (soarpush '*unbound* return-condition))
		     ((soarlistp (car condition))
		      (soarpush (car (remove-condition-trash (cdr (pop condition))))
					 return-condition))
		     ((eq (car condition) '|}|)
 		      (pop condition))
	            ((predicatep (car condition))
		     (setq condition (cddr condition)))
		    (t (soarpush (pop condition) return-condition))))
	     (and (null return-condition) (return '(*unbound*)))
	     (and (atom return-condition) (return return-condition))
	     ; trj
	     (return (nreverse return-condition)))
)


;;;
;;;		XXXXIV.		Initialize-rete-reorder
;;;

(defun initialize-rete-reorder ()
 nil)


;;;
;;;		XXXXV.		Restart-rete-reorder
;;;


(defun restart-rete-reorder ()
  (setq *default-multi* 5)
  (setq *max-recurse* 2)
  (setq *multi-attribute* nil)
  (setq *order-trace* nil)
  (multi-attributes '((problem-space operator)
		      (goal item)
		      (state evaluation 2)))
  (setq *global-pair* (list nil))
  (mapc #'(lambda (x) (setf (get x 'predicate) t)) '(< <= <=> <> = > >=))
  nil)

;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/ptoretelexer.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module RETE Submodule Lexer.
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the routines which lex for the parsers.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Global Variables used
;;;
(in-package "SOAR")

;;;
;;;		iii.	Global Variables used
;;;
;;; *curcond*
(defvar *curcond* () "The current condition element being lexed.")
;;;

;;;

(defun end-of-ce nil (atom *curcond*))

(defun prepare-sublex (ce) (setq *curcond* ce))

(defun peek-sublex nil (car *curcond*))

(defun sublex nil  ; Randy.Gobbel  9-Jun-86 16:29 
       (prog1 (car *curcond*)
	      (setq *curcond* (cdr *curcond*))))

(defun rest-of-ce nil *curcond*)


;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/ptoretesymboltable.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module RETE submodule SymbolTable
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the symbol table of the RETE module.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Global Variables Used
;;;

(in-package "SOAR")


;;;
;;;		iii.	Global Variables Used
;;;
;;; 
;;; *save-class-list*
;;;


(defvar *save-class-list* () 
  "The list of class symbols that the productions use.")

(defun create-new-class (class) ; Randy.Gobbel 13-Jun-86 14:31 
       (cond ((not (soarmemq class *save-class-list*))
	      (soarpush class *save-class-list*))))

(eval-when (load eval)
  (create-new-class 'preference))

(defun initialize-rete-symboltable ()
  nil)

(defun restart-rete-symboltable ()
  (mapc #'soarclearprops *save-class-list*)
  (setq *save-class-list* nil)
  (create-new-class 'preference)
  nil)


;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/ptorete.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module RETE submodule PtoRete
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the submodule of the RETE which parses 
;;; ops5 productions into RETE code.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Call Tree
;;;	iv.	Global Variables Used
;;;

(in-package "SOAR")
;;;
;;;		iii.	Call Tree
;;;
;;; p -local complete
;;;  nlam-p -local complete
;;;   compile-production -local complete
;;;    cmp-p -local complete
;;;     check-rhs -local complete
;;;      check-action -local complete
;;;       check-bind -local complete
;;;        note-variable -local complete 
;;;        check-change& -local complete
;;;         check-rhs-value -local complete
;;;          check-rhs-function -local complete
;;;           check-compute -local complete
;;;            check-arithmetic -local complete
;;;             check-term -local complete
;;;             check-rhs-atomic -local complete
;;;           check-accept
;;;           check-crlf
;;;           check-tabto
;;;           check-rjust
;;;           externalp -nonlocal rhs
;;;       check-make
;;;       check-write
;;;       check-call
;;;       check-halt
;;;       check-openfile
;;;       check-closefile
;;;       check-default
;;;     compute-negation-index -local complete
;;;      find-all-vars-in-condition -nonlocal reorder
;;;     encode-dope -nonlocal codegeneration
;;;      encode-pair -nonlocal codegeneration
;;;     cmp-conds -local complete
;;;      make-branch -nonlocal codegeneration
;;;      set-branch-vars -nonlocal codegeneration
;;;      set-branch-tsize -nonlocal codegeneration
;;;      set-branch-path -nonlocal codegeneration
;;;      set-branch-backptrs -nonlocal codegeneration
;;;      branch-path -nonlocal codegeneration
;;;      cmp-ce -local complete
;;;       new-subnum -local complete
;;;       prepare-sublex -nonlocal lexer
;;;       incr-subnum -local complete
;;;       cmp-element -local complete
;;;        peek-sublex -nonlocal local
;;;        cmp-product -local complete
;;;         rest-of-ce - nonlocal lexer
;;;         sublext -nonlocal lexer
;;;         end-of-ce  - nonlocal lexer
;;;        cmp-atomic-or-any -local complete
;;;         cmp-any -local complete
;;;          link-new-node -nonlocal codegeneration
;;;          current-field -local complete
;;;         cmp-atomic -local complete
;;;          cmp-symbol -local complete
;;;           cmp-var     -local complete
;;;            branch-vars -nonlocal codegeneration
;;;            cmp-old-eq-var -local
;;;             current-field -local complete
;;;             field-name -local complete
;;;            cmp-new-eq-var -local complete
;;;            cmp-new-var -local complete
;;;           cmp-number -local complete
;;;           cmp-constant -local complete
;;;      flatten -nonlocal utility
;;;      cmp-beta -local complete
;;;       add-test -nonlocal codegeneration
;;;       promote-var -local complete
;;;       build-beta -nonlocal codegeneration
;;;     check-goal-ctx-test -local 
;;;     branch-node -nonlocal codegeneration
;;;     branch-backptrs -nonlocal codegeneration
;;;     

;;;
;;;		iv.	Global Variables Used
;;;
(defvar *matrix* () "The body of the production being parsed by the ptorete parser.")
(defvar *pcount* 0 "The number of productions entered.")
(eval-when (compile eval load) (proclaim '(special *loading-default*)))
(defvar *feature-count* 0
  "The specificity of the currently compiling production.")
(eval-when (compile eval load) (proclaim '(special *first-node*)))
(defvar *current-branch* ()
   "One of the two pointers into the network used by the parser which generates the network.")
(defvar *context-field-found* () 
  "Seems to be a variable for the ptorete parser.")
(defvar *subnum* () "The current field number.")

(defvar *print-compiled-p* nil
  "If not nil, the function nlam-p prints out the name of the compiled production.
   This variable can be set with the function print-compiled-p.")
;;;



(defun current-field nil (field-name *subnum*))

(defmacro p (&rest z)
  #+:soar-times (start-soar-time ptorete)
	  (list 'nlam-p (list 'quote z)))




(defun print-compiled-p (&rest arg)
  (cond ((null arg) *print-compiled-p*)
        ((car arg) (setf *print-compiled-p* t))
        (t (setf *print-compiled-p* nil))
        )
  )


(defun nlam-p (z) 
 ;; Removed references to production type 3/30/90 GAP
 ;; These patches are in reference to BUG 01Mar90-12.56.58
 ;; Exchanged finish-output for drain. -BGM 2/11/89
 ;; Updated old style IO to soar-format. -BGM 8/18/88
 ; Randy.Gobbel 12-Sep-86 12:05 
  ;; Added the option to print the name of the production
  ;; currently compiled. -AC 7/16/90

  (if *print-compiled-p*
    (soar-format *trace-file* "*~a~%" (car z))
    (soar-format *trace-file* "*")
    )
  (finish-output)
  (prog1 
     (cond ((soarlistp (cadr z))
	     (compile-production (car z)
		                 (cdr z)))
           (t (compile-production (car z)
		                 (cddr z))))
       #+:soar-times (stop-soar-time ptorete)
     )
)

(defvar *p-name* () "The name of the currently compiling P.")


(defun compile-production (name matrix) 
 ;; Removed references to p-type 3/30/90 GAP
 ;; These patches are in reference to BUG 01Mar90-12.56.58
 ;; Changed !error! into soar-error so that DSM can read separate !. -BGM 7/31/88.
 ; Randy.Gobbel 18-Jun-86 16:32.
       (setq *p-name* name)
       (setq *matrix* matrix)
       (catch 'soar-error (cmp-p *p-name* *matrix*))
       (setq *p-name* nil))



;;;
;;;		?.	P's & SP's
;;;
;;;

;;; 
;;;	This defstruct now encapsulates all of the production's symbol-properties, and is
;;; hung on the P's production property.
;;;



(defvar *print-pname* () "")
(defvar *rhs-bound-vars* () "")
(defvar *vars* () "")

(defvar *p-<>-tests* nil)
 ;; A list that collects pairs of indicies that are constrained with
 ;; <> in the production. Used by cmp-p and associated routines to
 ;; collect these and stash them in the production defstruct. This
 ;; is then used by not-ify during chunking. -BGM 29-Nov-90
(defvar *branch-<>-tests* nil)
 ;;  A list that collects the <> tests for just the branch under compilation. -BGM 16-July-91

(eval-when (compile eval load) (proclaim '(special *loading-chunks*)))
(defvar *loading-chunks* NIL)

(defun cmp-p (name matrix) 
 ;; Patched to handle branch-<>-tests. -BGM 16-Jul-91
 ;; patched to load chunks correctly -GAP 3/24/91
 ;; Patched to count <> tests. -BGM 29-Nov-90
 ;; Removed references to p-type 3/30/90 GAP
 ;; These patches are in reference to BUG 01Mar90-12.56.58
 ;; Added new defstruct style productions. -BGM 11/8/88
 ;; Updated old style IO to soar-format. -BGM 8/18/88
 ; Randy.Gobbel 12-Sep-86 12:05  ; COMPILE 
 ; A PRODUCTION GIVEN IN P-FORMAT BY MATRIX. 
       (prog (branch actions)
	     (cond ((soarlistp name)
		    (soarerror "Illegal production name" name))
		   ((equal (let ((p (get-p name))) 
                             (when p (p-production p))) matrix)
		    (return nil)))
	     (and *print-pname* (soar-format *trace-file* "~A" name))
	     (cond ((excise-p name)
		    (soar-format *trace-file* "(excised ~A)" name)))
	     (setq *pcount* (1+ *pcount*))
	     (setq *feature-count* 0)
	     (setq *rhs-bound-vars* nil)
	     (setq *p-<>-tests* nil)
	     (setq *branch-<>-tests* nil)
	     (setq branch (cmp-conds matrix))
	     (setq *vars* (branch-vars branch))
	     (cond ((not (soarmemq name *pnames*))
		    (soarpush name *pnames*)))
	     (cond ((and (not *loading-default*)
			 (not (soarmemq name *user-pnames*)))
		    (soarpush name *user-pnames*)))
	     (cond ((and *loading-chunks*
			 (not (soarmemq name *chunks*)))
		    (soarpush name *chunks*)))
	     (setq actions (cdr (soarmemq '--> matrix)))
	     (check-rhs actions)
	     (link-new-node (list '&p *feature-count* name (encode-dope)
				  nil
				  (cons 'progn actions))
			    branch)                           
      
	     (put-p-compilation
             name                                  ;name
             matrix                                ;production
             (branch-node branch)                  ;topnode         
             (compute-negation-index matrix)       ;negation-index
	     (nreverse (cons (branch-node branch)  ;backpointers
	                     (branch-bakptrs branch))) 
             (autonomous-production-p matrix)     ;autonomic
             *p-<>-tests*)

	     ; SAVE BACKPOINTERS TO THE MEMORY 
	     ; NODES OF THE PRODUCTION JUST BUILT. 
	     (return nil)))

 
(defun compute-negation-index
  (matrix) ; John.Laird 17-Jun-86 09:42  ; CREATES A LIST OF TRIPLES - 
 ; EACH TRIPLES CONSISTS OF A VARIABLE NAME - CONDITION INDEX - ELEMENT 
 ; INDEX 
  (prog
    (save-matrix negation-vars negation-list count1 neg-var save-negation-vars 
                 negated-conditions forall-conditions condition temp)
    (setq negated-conditions nil)
    (setq negation-vars nil)
    (setq negation-list nil)
    (setq forall-conditions nil)
    (setq save-matrix matrix)
    (soarwhile
      (consp matrix) ; Changed endtest to prevent infinite loops. _BGM 3/27/89
      (cond
        ((and (is-negation (car matrix))
              (not (soarlistp (caadr matrix))))
         (setq temp (cadr matrix))
         (cond ((eq (car matrix)
                    '-)
                (soarpush temp negated-conditions))
               ((eq (car matrix)
                    '*)
                (soarpush temp forall-conditions)))
         (pop matrix)
         (setq negation-vars (union (find-all-vars-in-condition temp)
                                    negation-vars)))
        ((is-negation (car matrix))
         (setq temp
               (soarmapcar
                 #'(lambda (x)
                           (setq temp x)
                           (setq negation-vars
                                 (union (find-all-vars-in-condition temp)
                                        negation-vars))
                           temp)
                 (cadr matrix)))
         (cond ((eq (car matrix)
                    '-)
                (soarpush temp negated-conditions))
               ((eq (car matrix)
                    '*)
                (soarpush temp forall-conditions)))
         (pop matrix)))
      (pop matrix))
    (and (null negated-conditions)
         (null forall-conditions)
         (return nil))
    (setq save-negation-vars negation-vars)
    (soarwhile
      save-negation-vars
      (setq neg-var (pop save-negation-vars))
      (setq count1 0)
      (setq temp nil)
      (setq matrix save-matrix)
      (soarwhile
        (and (not (eq (car matrix)
                  '-->))
             (null temp))
        (setq condition (pop matrix))
        (cond ((is-negation condition)
               (pop matrix))
              (t (cond ((setq temp (soarmemq
                                neg-var
                                (setq condition (remove-condition-trash 
                                                                  condition))))
                        (soarpush (list neg-var count1
                                        (- (length condition)
                                                    (length temp)))
                                  negation-list)))
                 (setq count1 (1+ count1))))))
    (return (list negated-conditions forall-conditions negation-list))))


(defun cmp-conds (cl) ; Randy.Gobbel 22-Aug-86 13:29 
       (prog (type last-branch last-sectflag)
	     (setq last-branch (make-branch))
	     (set-branch-vars last-branch nil)
	     (set-branch-tsize last-branch 0)
	     (set-branch-path last-branch nil)
	     (set-branch-bakptrs last-branch nil)
	     nextcond
	     (cond ((or (null cl)
			(eq (car cl)
			    '-->))
		    (return last-branch)))
	     (cond ((eq (car cl)
			'-)
		    (setq type '&not)
		    (pop cl))
		   ((eq (car cl)
			'*)
		    (setq type '&all)
		    (pop cl))
		   ((null (branch-path last-branch))
		    (setq type nil))
		   (t (setq type '&and)))
	     (cond ((soarlistp (caar cl))
		    (setq *current-branch* (cmp-conds (car cl))))
		   (t (set-branch-tsize *current-branch* 1)
		      (set-branch-path *current-branch* (list *first-node*))
		      (set-branch-vars *current-branch* nil)
		      (set-branch-bakptrs *current-branch* nil)
		      (cmp-ce (flatten (car cl)))))
	     (cmp-beta type last-branch *current-branch* last-sectflag
		       (soarlistp (caar cl)))
	     (setq last-sectflag (and (null type)
				      (soarlistp (caar cl))))
	     (pop cl)
	     (go nextcond)))

(defun cmp-any nil  ; Randy.Gobbel 13-May-86 14:04 
       (prog (a z)
	     (sublex)
	     la
	     (cond ((end-of-ce)
		    (soarerror "MISSING >>" a)))
	     (setq a (sublex))
	     (cond ((not (eq '>> a))
		    (setq z (cons a z))
		    (go la)))
	     (link-new-node (list '&any nil (current-field)
				  z)
			    *current-branch*)))

(defun cmp-atomic nil  ; edited: 21-Feb-84 20:02 
       (prog (test x)
	     (setq x (peek-sublex))
	     (cond ((eq x '=)
		    (setq test 'eq)
		    (sublex))
		   ((eq x '<>)
		    (setq test 'ne)
		    (sublex))
		   ((eq x '<)
		    (setq test 'lt)
		    (sublex))
		   ((eq x '<=)
		    (setq test 'le)
		    (sublex))
		   ((eq x '>)
		    (setq test 'gt)
		    (sublex))
		   ((eq x '>=)
		    (setq test 'ge)
		    (sublex))
		   ((eq x '<=>)
		    (setq test 'xx)
		    (sublex))
		   (t (setq test 'eq)))
	     (cmp-symbol test)))

(defun cmp-atomic-or-any nil (cond ((eq (peek-sublex)
					'<<)
				    (cmp-any))
				   (t (cmp-atomic))))

(defun fudge-<>-tests (locs inc) 
 ;; Added to increment the CE offset of each <> location when a new condition is added. 
 ;; Called fudge for ugly historical reasons. -BGM 29-Nov-90
  (dolist (l.r locs)
    (incf (caar l.r) inc)
    (incf (cadr l.r) inc)))

(defun cmp-beta (kind old-branch new-branch last-sectflag sectflag) 
 ;; Exchanged delete for dremove. -BGM 2/11/89
 ; 
 ; Randy.Gobbel 22-Aug-86 12:42 
       (prog (tlist newv vname vpred vpos oldv new-vars old-vars joinflag)
	     (setq new-vars (branch-vars new-branch))
	     (setq old-vars (branch-vars old-branch))
	     (setq joinflag (or (null kind) (eq kind '&and)))
	     la
	     (and (null new-vars)
		  (go lb))
	     (setq newv (pop new-vars))
	     (setq vname (car newv))
	     (setq vpred (cadr newv))
	     (setq vpos (cadddr newv))
	     (setq oldv (soarassq vname (branch-vars old-branch)))
	     (cond (oldv (setq tlist (add-test tlist newv oldv))
			 (cond ((and joinflag (eq vpred 'eq)
				     (< vpos (+ (caddr oldv)
						(cadddr oldv))))
				(set-branch-vars old-branch
						 (delete oldv
							  (branch-vars 
								 old-branch)))
				(promote-var old-branch newv))))
		   (joinflag (promote-var old-branch newv)))
	     (go la)
	     lb
	     (build-beta kind tlist old-branch new-branch)
	     (cond (joinflag  ; DON'T FUDGE THE VARS THAT WERE JUST 
 ; PROMOTED 
			     (fudge old-vars (branch-tsize new-branch))
			     ;; If this is an AND, then join in the branch <> tests to the 
                             ;; p <> tests. -BGM 16-Jul-91
                             (setq *p-<>-tests* (nconc *branch-<>-tests* *p-<>-tests*))
                             (setq *branch-<>-tests* nil)
			     ;; Must also fudge the <>s. -BGM 29-Nov-90
                             (fudge-<>-tests *p-<>-tests* (branch-tsize new-branch))
			     (set-branch-tsize old-branch
					       (+ (branch-tsize new-branch)
						  (branch-tsize old-branch))))
		   (t (setq *branch-<>-tests* nil) 
		      ;; Clear all those branch <> tests for nots. -BGM 16-Jul-91.
		      ))
	     (cond (last-sectflag (set-branch-bakptrs
				    old-branch
				    (list (nreverse (branch-bakptrs old-branch))
					  ))))
	     (cond ((not sectflag)
		    (set-branch-bakptrs old-branch
					(append (branch-bakptrs new-branch)
						(branch-bakptrs old-branch))))
		   ((not kind)
		    (set-branch-bakptrs old-branch (branch-bakptrs new-branch)))
		   (t (set-branch-bakptrs old-branch
					  (cons (nreverse
						  (branch-bakptrs new-branch))
						(branch-bakptrs old-branch))))))
       )


(defun cmp-ce (c) ; Randy.Gobbel 23-Jun-86 19:41 
       (prog (pref-found)
	     (new-subnum 0)
	     (and (atom c)
		  (soarerror "Atomic conditions are not allowed" c))
	     (setq pref-found (eq (wme-class c)
				  'preference))
	     (prepare-sublex c)
	     (return (soarwhile (not (end-of-ce))
				(incr-subnum)
				(setq *context-field-found*
				      (and pref-found (>= *subnum* 5)))
				(cmp-element)))))




(defun cmp-constant (test) ; Randy.Gobbel 13-Jun-86 11:29 
       (prog (sym)
	     (or (soarmemq test '(eq ne xx))
		 (soarerror "Non-numeric constant after numeric predicate"
			    (sublex)))
	     (cond ((not (eq (setq sym (sublex)) '*unbound*))
		    (link-new-node (list (get test 'a)
					 nil
					 (current-field)
					 sym)
				   *current-branch*)))))

(defun cmp-element nil  ; Randy.Gobbel 13-Jun-86 14:41 
       (cond ((eq (peek-sublex)
		  '{)
	      (cmp-product))
	     (t (cmp-atomic-or-any))))

(defun cmp-new-eq-var (name old) ; John.Laird 11-Jun-86 15:23 
       (prog (pred next)
     (set-branch-vars *current-branch*                                                   
                      ;; replaced delq on advice of TI compiler. -KAM 6/15/89
                      (delete old (the list (branch-vars *current-branch*)) :test #'eql))
	     (setq next (soarassq name (branch-vars *current-branch*)))
	     (cond (next (cmp-new-eq-var name next))
		   (t (cmp-new-var name 'eq)))
	     (setq pred (cadr old))
	     ;; This get here fails and returns nil at certain points. 
	     ;; I think that it should be generating an teqs.
	     (link-new-node (list (get pred 's)
				  nil
                                  (field-name (caddr old))
				  (current-field))
			    *current-branch*)))

(defun cmp-new-var (name test) ; Randy.Gobbel 13-May-86 14:04 
       (set-branch-vars *current-branch* (cons (list name test 1 *subnum*)
					       (branch-vars *current-branch*))))

(defun cmp-number (test) ; John.Laird 11-Jun-86 15:23 
       (link-new-node (list (get test 'n)
			    nil
			    (current-field)
			    (sublex))
		      *current-branch*))

(defun cmp-old-eq-var (test old) 
   ;; Modified to store <> tests on the branch <> variable. -BGM 16-Jul-91
   ;; Modified to remember the <> tests for chunking knotify. -BGM 29-Nov-90
   ;; John.Laird 11-Jun-86 15:23 
  (let ((current-field (current-field))
        (field-name    (field-name (cadddr old))))
   (when (eq test 'ne) 
    (push (cons (cons -1 (1- (nth 3 old))) (cons -1 (1- *subnum*))) *branch-<>-tests*))
   (link-new-node (list (get test 's)
			    nil
			    current-field
			    field-name)
		      *current-branch*)))

(defun cmp-product nil  ; Randy.Gobbel  3-Apr-86 14:28 
       (prog (save)
	     (setq save (rest-of-ce))
	     (sublex)
	     la
	     (cond ((end-of-ce)
		    (cond ((soarmember '} save)
			   (soarerror "Wrong context for }" save))
			  (t (soarerror "Missing }" save))))
		   ((eq (peek-sublex) '})
		    (sublex)
		    (return nil)))
	     (cmp-atomic-or-any)
	     (go la)))


(defun cmp-symbol (test) ; Randy.Gobbel 13-Jun-86 14:42 
       (cond ((variablep-not-predicate (peek-sublex))
	      (cmp-var test))
	     ((numberp (peek-sublex))
	      (cmp-number test))
	     ((symbolp (peek-sublex))
	      (cmp-constant test))
	     (t (soarerror "Unrecognized symbol" (sublex)))))

(defun cmp-var (test) ; Randy.Gobbel 13-May-86 14:09 
       (prog (old name)
	     (setq name (sublex))
	     (setq old (soarassq name (branch-vars *current-branch*)))
	     (cond ((and old (eq (cadr old) 'eq))
		    (cmp-old-eq-var test old))
		   ((and old (eq test 'eq))
		    (cmp-new-eq-var name old))
		   ((and (eq test 'eq)
			 *context-field-found*)
		    (cmp-new-var name 'eqnil))
		   (t (cmp-new-var name test)))))

(defun incr-subnum nil  ; RG: 20-Feb-86 12:03 
       (setq *subnum* (1+ *subnum*)))

(defun new-subnum (k) ; Randy.Gobbel  3-Apr-86 14:28 
       (or (numberp k)
	   (soarerror "Tab must be a number" k))
       (setq *subnum* (floor k)))

(defun autonomous-production-p (lhs-->rhs)
  ;; Rewrote and renames this based on JEL's desired changes. 1/11/89
  ; Randy.Gobbel 13-Jun-86 14:59 
  (if (null lhs-->rhs) t
    (let ((ce (first lhs-->rhs)))
      (if (eq ce '-->)  ; I've run out of LHS so I'm true.
	  t
	(if (atom ce) ; CE is -.
	    (autonomous-production-p (rest lhs-->rhs))
	     ;; A production is autonomous if it tests no goal augmentations, except those of the
	     ;; state, as IO comes in from the top level state.
	(let ((class (first ce))
	      (attribute (third ce)))
	  (cond ((not (eq class 'goal)) (autonomous-production-p (rest lhs-->rhs)))
		((null attribute) nil  ; (Goal <g>) case.
		 )
		((not (eq attribute 'state)) nil)
		(t (autonomous-production-p (rest lhs-->rhs))))))))))

(defun promote-var (branch dope) ; Randy.Gobbel 13-May-86 14:23 
       (prog (vname vpred)
	     (setq vname (car dope))
	     (setq vpred (cadr dope))
	     (and (not (eq vpred 'eqnil))
		  (not (eq vpred 'eq))
		  (soarerror "Illegal predicate for first occurrence"
			     (list vname vpred))) ; EQNIL IS NOT A VALID 
 ; PREDICATE FOR FIRST OCCURRENCE 
	     (and (eq vpred 'eqnil)
		  (rplaca (cdr dope)
			  'eq))
	     (set-branch-vars branch (cons dope (branch-vars branch)))))


(defun fudge (vars fudgefactor) ; Randy.Gobbel 13-May-86 14:18 
       (soarmapc #'(lambda (z)
			   (rplaca (cddr z)
				   (+ (caddr z)
				      fudgefactor)))
		 vars))


(defun check-0-args (x) ; Randy.Gobbel 11-Sep-86 15:19 
       (or (eqp (length x)
		1)
	   (soarwarn "Should not have arguments" x)))

(defun check-accept (x) ; Randy.Gobbel 11-Sep-86 15:20 
       (cond ((eqp (length x)
		   1)
	      nil)
	     ((eqp (length x)
		   2)
	      (check-rhs-atomic (cadr x)))
	     (t (soarwarn "Too many arguments" x))))

(defun check-action (x) 
 ;; Corrected call to check-make-preference. -BGM 5/4/89
 ;; Updated to handle DSM actions. -BGM 12/5/88
 ; Randy.Gobbel  2-Jul-86 16:23 
       (prog (a)
	     (cond ((atom x)
		    (soarwarn "Atomic Action" x)
		    (return nil)))
	     (setq a (car x))
	     (cond ((eq a #+TI 'soar-bind #-TI 'bind)
		    (check-bind x))
		   ((eq a 'label-bind)
		    (check-bind x))
		   ((eq a 'call2)
		    (return nil))
		   ((eq a 'tabstop)
		    (check-bind x))
		    ((eq a 'make-preference)
			   (check-make-preference x))
		   ((eq a 'write)
		    (soarwarn "Illegal action:" a))
		   ((eq a 'write1)
		    (check-write x))
		   ((eq a 'write2)
		    (check-write x))
		   ((eq a 'call1)
		    (check-call x))
		   ((eq a 'call)
		    (soarwarn "Illegal action:" a))
		   ((eq a 'halt)
		    (check-halt x))
		   ((eq a 'openfile)
		    (soarwarn "Illegal action:" a))
		   ((eq a 'openfile1)
		    (check-openfile x))
		   ((eq a 'closefile)
		    (soarwarn "Illegal action:" a))
		   ((eq a 'closefile1)
		    (check-closefile x))
		   ((eq a 'default)
		    (check-default x))
		   (t (soarwarn "Illegal Action" x)))))

(defun check-arithmetic (l) ; Randy.Gobbel  7-Apr-86 15:12 
       (cond ((atom l)
	      (soarwarn "Syntax error in arithmetic expression" l))
	     ((atom (cdr l))
	      (check-term (car l)))
	     ((not (soarmemq (cadr l)
			     (arithmetic-operators)))
	      (soarwarn "Unknown operator" l))
	     (t (check-term (car l))
		(check-arithmetic (cddr l)))))

(defun check-bind (z) ; Randy.Gobbel  3-Apr-86 13:45 
       (prog (v)
	     (or (> (length z)
		    1)
		 (soarwarn "Needs arguments" z))
	     (setq v (cadr z))
	     (or (variablep-not-predicate v)
		 (soarwarn "Takes variable as argument" z))
	     (note-variable v)
	     (check-change& (cddr z))))

(defun note-variable (var)
       (setq *rhs-bound-vars* (cons var *rhs-bound-vars*)))

(defun check-build-collect (args) ; Randy.Gobbel  7-Apr-86 15:15 
       (prog (r)
	     top
	     (and (null args)
		  (return nil))
	     (setq r (car args))
	     (setq args (cdr args))
	     (cond ((soarlistp r)
		    (check-build-collect r))
		   ((eq r (quote-character))
		    (and (null args)
			 (soarwarn "Nothing to evaluate" r))
		    (check-rhs-value (car args))
		    (setq args (cdr args))))
	     (go top)))

(defun check-call (z) ; Randy.Gobbel  3-Apr-86 13:47 
       (prog (f)
	     (and (null (cdr z))
		  (soarwarn "Needs arguments" z))
	     (setq f (cadr z))
	     (and (variablep-not-predicate f)
		  (soarwarn "Function name must be a constant" z))
	     (or (symbolp f)
		 (soarwarn "Function name must be a symbolic atom" f))
	     (or (externalp f)
		 (soarwarn "Function named not declared external" f))
	     (check-change& (cddr z))))

(defun check-change& (z) ; Randy.Gobbel 13-Jun-86 14:40 
       (soarwhile (not (atom z))
		  (check-rhs-value (pop z))))

(defun check-closefile (z) ; Randy.Gobbel  3-Apr-86 13:47 
       (and (null (cdr z))
	    (soarwarn "Needs arguments" z))
       (check-change& (cdr z)))

(defun check-compute (x) (check-arithmetic (cdr x)))

(defun check-crlf (x) (check-0-args x))

(defun check-default (z) ; Randy.Gobbel  3-Apr-86 13:48 
       (and (null (cdr z))
	    (soarwarn "Needs arguments" z))
       (check-change& (cdr z)))

(defun check-halt (z) ; Randy.Gobbel  3-Apr-86 14:04 
       (or (null (cdr z))
	   (soarwarn "Does not take arguments" z)))

(defun check-make-preference (z)
 ;; Removed references to p-type 3/30/90 GAP
 ;; These patches are in reference to BUG 01Mar90-12.56.58
  ;; Added to check make-preference calls for DSM, although we might
  ;; want to check more. -BGM 12/5/88
  ; Randy.Gobbel  8-May-86 16:41 
       (and (null (cdr z)) 
	    (soarwarn "Missing arguments in Make" " "))
       (check-change& (cdr z)))

(defun check-openfile (z) ; Randy.Gobbel  3-Apr-86 13:48 
       (and (null (cdr z))
	    (soarwarn "Needs arguments" z))
       (check-change& (cdr z)))

(defun check-print-control (x) ; Randy.Gobbel  3-Apr-86 13:48 
       (prog nil (cond ((bound? x)
			(return x)))
	     (cond ((or (not (numberp x))
			(< x 1)
			(> x 127))
		    (soarwarn "Illegal value for printer control" x)))))

(defun bound? (var) ; edited: 23-Mar-86 09:21 
       (or (soarmemq var *rhs-bound-vars*)
	   (var-dope var)))

(defun var-dope (var) ; edited: 23-Mar-86 09:17 
       (soarassq var *vars*))

(defun check-rhs (rhs) ; RG: 20-Feb-86 18:13 
       (soarmapc #'check-action rhs))

(defun check-rhs-atomic (x) ; Randy.Gobbel  3-Apr-86 14:05 
       (and (variablep-not-predicate x)
	    (not (bound? x))
	    (soarwarn "Unbound variable" x)))

(defun check-rhs-function (x) ; Randy.Gobbel 18-Jun-86 13:56 
       (prog (a)
	     (setq a (car x))
	     (cond ((eq a 'compute)
		    (check-compute x))
		   ((eq a 'arith)
		    (check-compute x))
		   ((eq a 'accept)
		    (check-accept x))
		   ((eq a 'crlf)
		    (check-crlf x))
		   ((eq a 'tabto)
		    (check-tabto x))
		   ((eq a 'rjust)
		    (check-rjust x))
		   ((not (externalp a))
		    (soarwarn "RHS function not declared external" a)))))

(defun check-rhs-value (x) ; John.Laird  4-Apr-85 10:04  ; ARGLIST = (X) 
       (cond ((soarlistp x)
	      (check-rhs-function x))))

(defun check-rjust (x) ; Randy.Gobbel 11-Sep-86 15:20 
       (or (eqp (length x)
		2)
	   (soarwarn "Wrong number of arguments" x))
       (check-print-control (cadr x)))

(defun check-tabto (x) ; Randy.Gobbel 11-Sep-86 15:20 
       (or (eqp (length x)
		2)
	   (soarwarn "Wrong number of arguments" x))
       (check-print-control (cadr x)))

(defun check-term (x) ; Randy.Gobbel  7-Apr-86 14:36 
       (cond ((soarlistp x)
	      (check-arithmetic x))
	     (t (check-rhs-atomic x))))

(defun check-write (z) ; Randy.Gobbel  3-Apr-86 13:51 
       (and (null (cdr z))
	    (soarwarn "Needs arguments" z))
       (check-change& (cdr z)))

(defun initialize-rete-ptorete ()
  (setq *p-name* nil)
  nil)

(defun restart-rete-ptorete ()
 nil)




;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/codegeneration.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module RETE submodule CodeGeneration
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the submodule of the RETE which builds the RETE network.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Call Tree
;;;	iv.	Global Variables Used
;;;

;;;
;;;		iii.	Call Tree
;;;
;;;
;;;  The interface into this code from the ptorete file is:
;;;
;;; Set-branch-vars -local complete
;;; set-branch-tsize -local complete
;;; set-branch-path -local complete
;;; set-branch-bakptrs -local complete
;;; branch-path -local complete
;;; branch-vars -local complete
;;; branch-node -local complete
;;; branch-bakptrs -local complete
;;; encode-dope -local complete
;;; kill-node -local complete (called by excise).
;;; make-bottom-node -local complete (called by i-g-v).
;;; make-branch -local complete (called by ptorete).
;;; link-new-node -local complete
;;;  link-left -local complete
;;;   left-outs -local complete
;;;   find-equiv-node -local complete
;;;    equiv -local complete
;;;   execute-node-path -nonlocal interpreter
;;;    push-wmes-down-path -nonlocal interperter
;;; add-test -local complete
;;;  encode-pair -local complete
;;; build-beta -local complete
;;;  link-new-beta-node -local complete
;;;   link-both -local complete
;;;    mem-outs -local complete
;;;    find-equiv-beta-node -local complete
;;;     beta-equiv -local complete
;;;    attatch-left -local complete
;;;    
;;; 

;;;
;;;		iv.	Global Variables Used
;;;
(in-package "SOAR")

(defvar *carray* () 
 "An array full of the *cn*'s used by the code generation.")
(defvar *last-node-on-bus* () "The last node on the bus.")
(defvar *real-cnt* 0 "The actual number of nodes in the network.")
(defvar *virtual-cnt* 0 "The virtual number of nodes in the network.")
(defvar *first-node* () "The bus of the network.")
(defvar *mem-array-size* 10 "The size of the hashing memories for right alpha memories.")
(defvar *execute-path* () 
 "Whatever the hell this is its only used in the network for building and interpreting.")
(eval-when (compile eval load) (proclaim '(special *flag-part* *soar-package*)))
;;;


(defun init-concat nil 
   ; Made case-insensitive -- TFMcG 16-Aug-90
   ; Replaced soarpack with an intern to the soar package. -BGM 7-Feb-90
   ;Randy.Gobbel 17-Oct-86 12:42 
   (let ((*print-case* :upcase))
       (setq *carray* (makevector 9))
       (putvector *carray* 0 '*c1*)
       (putvector *carray* 1 '*c2*)
       (putvector *carray* 2 '*c3*)
       (putvector *carray* 3 '*c4*)
       (putvector *carray* 4 '*c5*)
       (putvector *carray* 5 '*c6*)
       (putvector *carray* 6 '*c7*)
       (putvector *carray* 7 '*c8*)
       (putvector *carray* 8 '*c9*)
       (soarmapc
	 #'(lambda (x)
		   (soarmapc #'(lambda (y)
				       (soarputprop x (intern (format nil "T~A~A" x y) *soar-package*)
						    y))
			     '(a b s n)))
	 '(ge gt le lt ne eq xx))
       (soarputprop 'eqnil 'teqnilb 'b)))

(eval-when (eval load) (init-concat))

(defun set-branch-bakptrs (x y) ; Randy.Gobbel 23-Jun-86 19:07 
       (rplaca (cdddr x)
	       y))

(defun set-branch-path (x y) ; Randy.Gobbel 23-Jun-86 19:07 
       (rplaca (cdr x)
	       y))

(defun set-branch-tsize (x y) ; Randy.Gobbel 23-Jun-86 19:07 
       (rplaca (cddr x)
	       y))

(defun set-branch-vars (x y) ; Randy.Gobbel 23-Jun-86 19:07 
       (rplaca x y))

(defun branch-bakptrs (x) ; Randy.Gobbel 23-Jun-86 19:04 
       (cadddr x))

(defun branch-node (x) ; Randy.Gobbel 23-Jun-86 19:04 
       (caadr x))

(defun branch-path (x) ; Randy.Gobbel 23-Jun-86 19:04 
       (cadr x))

(defun branch-tsize (x) ; Randy.Gobbel 23-Jun-86 19:04 
       (caddr x))

(defun branch-vars (x) ; Randy.Gobbel 23-Jun-86 19:04 
       (car x))

(defun add-test (list new old) 
 ;; Modified to store the <> on the branch variable. -BGM 16-Jul-91
 ;; Updated to store the indicies of not equal to 
 ;; tests for chunking over <>s.  -BGM 29-Nov-90 
 ;; John.Laird 11-Jun-86 15:25 
       (prog (ttype lloc rloc)
	     (setq *feature-count* (1+ *feature-count*))
	     (setq ttype (get (cadr new)
			      'b))
	     (setq rloc (encode-pair (caddr new)
				     (cadddr new)))
	     (setq lloc (encode-pair (caddr old)
				     (cadddr old)))
	     (when (eq 'tneb ttype) 
               (push (cons (cons     (car lloc)  (cdr lloc))
                           (cons (1- (car rloc)) (cdr rloc)))
                  *branch-<>-tests*))
	     (return (cons ttype (cons lloc (cons rloc list))))))

(defun attach-left (old new)
       (rplaca (cdr old)
	       (cons new (cadr old))))


(defun beta-equiv (a b) ; edited: 16-Feb-84 11:52 
       (and (eq (car a)
		(car b))
	    (equal (cddddr a)
		   (cddddr b))
	    (or (eq (car a)
		    '&and)
		(equal (caddr a)
		       (caddr b)))))

(defun build-beta (type tests old-branch new-branch) ; Randy.Gobbel 
 ; 13-May-86 14:04  ; JOIN THE ALPHA BRANCH JUST BUILT AND THE BETA BRANCH 
 ; REPRESENTING THE PRODUCTION SO FAR BY A BETA NODE (&AND OR &NOT OR &ALL) 
 ; PUT A MEMORY NODE ON THE ALPHA BRANCH AND, IF NECESSARY, THE BETA 
 ; BRANCH, BEFORE JOINING. 
       (prog (rpred lpred)
	     (cond ((null type)
		    (set-branch-path old-branch (branch-path new-branch))
		    (return)))
	     (link-new-node (list '&rmem nil (protohmem))
			    new-branch)
	     (setq rpred (caddr (branch-node new-branch)))
	     (set-branch-bakptrs new-branch (cons (branch-node new-branch)
						  (branch-bakptrs new-branch)))
	     (cond ((eq type '&and)
		    (link-new-node (list '&lmem nil (protomem))
				   old-branch)
		    (setq lpred (caddr (branch-node old-branch)))
		    (set-branch-bakptrs old-branch
					(cons (branch-node old-branch)
					      (branch-bakptrs old-branch))))
		   (t (setq lpred (protomem))))
	     (link-new-beta-node (list type nil lpred rpred tests)
				 old-branch new-branch)
	     (cond ((not (eq type '&and))
		    (set-branch-bakptrs old-branch
					(cons (branch-node old-branch)
					      (branch-bakptrs old-branch)))))))


(defun equiv (a b) ; Dan.Scales 24-Jan-86 15:11  ; TWO MEMORY NODES ARE 
 ; EQUIVALENT IF THEY ARE THE SAME TYPE. TWO ALPHA-TEST NODES ARE 
 ; EQUIVALENT IF THEY ARE THE SAME TYPE AND CONTAIN THE SAME TEST. 
       (and (eq (car a)
		(car b))
	    (or (soarmemq (car a)
			  '(&lmem &rmem))
		(equal (cddr a)
		       (cddr b)))))

(defun encode-pair (a b) ; John.Laird  8-Nov-85 16:23 
       (cons (1- a)
	     (1- b)))

(defun find-equiv-beta-node (node list)
       (prog (a)
	     (setq a list)
	     l1
	     (cond ((atom a)
		    (return nil))
		   ((beta-equiv node (car a))
		    (return (car a))))
	     (setq a (cdr a))
	     (go l1)))

(defun find-equiv-node (node list)
       (prog (a)
	     (setq a list)
	     l1
	     (cond ((atom a)
		    (return nil))
		   ((equiv node (car a))
		    (return (car a))))
	     (setq a (cdr a))
	     (go l1)))


(defun kill-node (node) ; edited: 16-Feb-84 11:34 
       (prog nil top (and (atom node)
			  (return nil))
	     (rplaca node '&old)
	     (setq node (cdr node))
	     (go top)))

(defun left-outs (node)
       (cadr node))

(defun mem-outs (x) ; Randy.Gobbel 23-Jun-86 19:06 
       (cadr x))

(defun link-both (left right succ path) ; Dan.Scales 24-Jan-86 15:16  ; 
 ; LINK SUCC AS AN OUTPUT TO BOTH LEFT AND RIGHT, UNLESS AN EQUIVALENT 
 ; NODE ALREADY EXISTS. 
       (prog (a r)
	     (setq a (intrq (mem-outs left)
			    (mem-outs right)))
	     (setq r (find-equiv-beta-node succ a))
	     (and r (return (cons r path)))
	     (setq *real-cnt* (+ 1 *real-cnt*))
	     (attach-left left succ)
	     (attach-left right succ)
	     (return (cons succ path))))

(defun link-left (succ path) ; Randy.Gobbel 22-Aug-86 13:56  ; ADD SUCC TO 
 ; THE NESS AN EQUIVALENT NODE ALREADY EXISTS. IF SUCC IS A MEMORY OR &P 
 ; NODE, PRIME IT IF NECESSARY. RETURN UPDATE TO PATH. 
       (prog (pred a r class class-list attr pair flag)
	     (setq pred (car path))
	     (setq flag *last-node-on-bus*)
	     (setq *last-node-on-bus* nil) ; CHECK IF WE ARE COMPILING A 
 ; NODE THAT DOES A CLASS NAME CHECK OR ATTRIBUTE NAME CHECK. IF SO, STORE 
 ; THE NODE SPECIALLY SO WE CAN INDEX OFF CLASS AND ATTRIBUTE NAMES. 
	     (cond ((and (eq (car pred)
			     '&bus)
			 (eq (car succ)
			     'teqa)
			 (eq (caddr succ)
			     '*c1*))
		    (setq class (cadddr succ))
		    (setq class-list (get class '&bus-branch))
		    (setq *last-node-on-bus* t)
		    (cond ((null class-list)
			   (soarputprop class (cons succ nil)
					'&bus-branch))
			  (t (return (cons (car class-list)
					   path)))))
		   ((and flag (eq (car succ)
				  'teqa)
			 (eq (caddr succ)
			     '*c3*))
		    (setq class (cadddr pred))
		    (setq class-list (get class '&bus-branch))
		    (setq attr (cadddr succ))
		    (cond ((setq pair (soarassq attr (cdr class-list)))
			   (return (cons (cdr pair)
					 path)))
			  (t (soarputprop class (cons (car class-list)
						      (cons (cons attr succ)
							    (cdr class-list)))
					  '&bus-branch))))
		   (t (setq a (left-outs pred))
		      (setq r (find-equiv-node succ a))
		      (and r (cond ((soarmemq (car succ)
					      '(&p &lmem &rmem))
				    (return (list r)))
				   (t (return (cons r path)))))
		      (attach-left pred succ)))
	     (setq *real-cnt* (+ 1 *real-cnt*))
	     (cond ((soarmemq (car succ)
			      '(&p &lmem &rmem))
		    (execute-node-path (cons succ path))
		    (return (list succ)))
		   (t (return (cons succ path))))
	     (return succ)))

(defun link-new-beta-node (r lbranch rbranch) ; Randy.Gobbel 
 ; 11-Jun-86 14:24 
       (setq *virtual-cnt* (1+ *virtual-cnt*))
       (set-branch-path lbranch (link-both (branch-node lbranch)
					   (branch-node rbranch)
					   r
					   (branch-path lbranch))))

(defun link-new-node (r branch) ; Randy.Gobbel 22-Aug-86 13:41  ; LINK R 
 ; ONTO BRANCH * 
       (cond ((not (soarmemq (car r)
			     '(&p &lmem &rmem &and &not &all)))
	      (setq *feature-count* (1+ *feature-count*))))
       (setq *virtual-cnt* (1+ *virtual-cnt*))
       (set-branch-path branch (link-left r (branch-path branch))))

(defun make-bottom-node nil (setq *first-node* (list '&bus nil)))

(eval-when (eval load) (make-bottom-node))

(defun make-branch nil  ; Randy.Gobbel 20-Jun-86 14:35 
       (list nil nil nil nil))

(eval-when (eval load) (setq *current-branch* (make-branch)))

(defun protomem nil (list nil))

(defun protohmem nil  ; edited:  1-Feb-86 09:38 
       (makevector *mem-array-size*))

;;; These next three are not used.

(defun protolmem nil  ; Randy.Gobbel 23-Jun-86 19:06 
       (protomem))

(defun protonotmem nil  ; Randy.Gobbel 23-Jun-86 19:06 
       (protomem))

(defun protormem nil  ; Randy.Gobbel 23-Jun-86 19:06 
       (protomem))

(defun encode-dope nil  ; Randy.Gobbel 13-May-86 14:18 
       (prog (r all z k)
	     (setq all *vars*)
	     la
	     (and (atom all)
		  (return r))
	     (setq z (pop all))
	     (setq k (encode-pair (caddr z)
				  (cadddr z)))
	     (setq r (cons (car z)
			   (cons k r)))
	     (go la)))


(defun field-name (num) 
 ; Replaced soarpack call with an intern to *soar-package*. -BGM 2/7/89
 ;  Randy.Gobbel  3-Apr-86 14:29 
       (cond ((and (> num 0) 
		   (< num 65))
	      (cond ((<= num 9)
		     (getvector *carray* (1- num)))
		    ((intern (format nil "*C~A*" num) *soar-package*))))
	     ((soarerror "Condition is too long" (rest-of-ce)))))

(defun initialize-rete-codegeneration ()
 nil)

(defun restart-rete-codegeneration ()
 (init-concat)
 (setq *last-node-on-bus* nil)
 (setq *real-cnt* 0) 
 (setq *virtual-cnt* 0)
 (setq *current-branch* (make-branch))
 (make-bottom-node)
 nil)


;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/gelm.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	Gelm.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/rete/new/gelm.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file contains code for the different versions of gelm and read time
;;; conditionalized code for profiling the calls to gelm.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Profile-gelm
;;;	II.	Gelm
;;;	III.	Gelm
;;;	IV.	Gelm
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")

;;;
;;;		I.	Profile-gelm
;;;
;;;	This routine counts the number of calls to gelm,
;;; and the number of calls to gelm at each pair of indicies.
;;; This is used by the testcode file gelm to determine which
;;; of the three gelms should be used.

#+:TEST-GELM
(defparameter *token-length* 144
 "The length of tokens that gelm should measure.")

#+:TEST-GELM
(defvar *gelm* (make-array `(,*token-length* 9) :initial-element 0)
    "The number of calls to gelm at this position.")

#+:TEST-GELM
(defvar *gelm-count* 0 "The number of calls to *gelm*.")

#+:TEST-GELM
(defun profile-gelm (x.y)
  (incf *gelm-count*)
  (incf (aref *gelm* (car x.y) (cdr x.y))))

#+:TEST-GELM
(defun init-profile-gelm ()
  (setq *gelm-count* 0)
  (setq *gelm* (make-array `(,*token-length* 9) :initial-element 0)))

#+:TEST-GELM
(defun print-gelm-profile ()
 (format t "~%Gelm profile:")
 (dotimes (i *token-length*)
  (format t "~%~A:" i)
  (dotimes (j 9)
    (format t " ~A" (aref *gelm* i j)))))



;;;
;;;		II.	Gelm
;;;

;;; Amazing that this use of eql (inside eqp) compiles to as good code
;;; as the (= (the fixnum ...) (the fixnum ...)). I wonder if
;;; this really holds for the code down here in gelm. I wonder if
;;; a few declares would really help here.
;;; I'm not yet sure what is going on.



;;;
;;;		III.	Gelm
;;;
;;; Changed over to #+(OR). -BGM 2/25/89

#+(OR)
(defun gelm (x k) 
   ; Dale Thoms 11/20/88
       (setq x (nth (car k) x))
       (case (cdr k)
	 (0 (wme-class x))
	 (1 (wme-id x))
	 (2 (wme-attribute x))
	 (3 (wme-value x))
	 (4 (wme-reference x))
	 (5 (wme-goal x))
	 (6 (wme-problem-space x))
	 (7 (wme-state x))
	 (8 (wme-operator x))))



;;;
;;;		IV.	Gelm
;;;
;;; Changed over to #+(OR). -BGM 2/25/89

#+(OR)
(defun gelm (lhs index)
 ;; From Karen McMahon.
 ;;; lhs - instantiated LHS
 ;;; index - dotted pair (i . j), where:
 ;;;   i - locates preference in lhs
 ;;;   j - locates item in preference
 ;;; get item from preference.
 (nth (cdr index)          
      ;; get preference from lhs.
      (nth (car index) lhs))
)



;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/interpreter.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module RETE Submodule Interpreter
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the routines which interprete the rete structure.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Call Tree	
;;;     iv.	Global Variables Used
;;;

;;;
;;;		iii.	Call Tree
;;;
;;;	This call tree is going to look a little strange because all
;;; of the network operations calls are only built at run time.
;;; So, I must run the call tree from each node operation.
;;;
;;; Match -local complete
;;; &all -local complete
;;; &any -local complete
;;;  eval-nodelist -local complete
;;; &bus -local complete
;;;  left-outs -nonlocal codegeneration
;;; &not -local complete
;;;  not-left -local complete
;;;   check-execute -local complete
;;;   add-token -local complete
;;;    real-add-token -local complete
;;;     get-hash-id -local complete
;;;    remove-old -local complete
;;;     remove-old-num -local complete
;;;      top-levels-eq -local complete
;;;     remove-old-hash -local complete
;;;     remove-old-no-num -local complete
;;; &old -local complete
;;; &p -local complete
;;;  insertcs -nonlocal cs
;;;  removecs -nonlocal cs
;;; &lmem -local complete
;;;  and-left -local complete
;;; &rmem -local complete
;;;  and-right -local complete
;;;  not-right -local complete
;;; teqa
;;; teqb
;;; teqn
;;; teqs
;;; tgeb
;;; tgen
;;; tges
;;; tgtb
;;; tgtn
;;; tgts
;;; tleb
;;; tlen
;;; tles
;;; tltb
;;; tltn
;;; tlts
;;; tnea
;;; tneb
;;; tnes
;;; txxa
;;; txxb
;;; txxn
;;; txxs
;;; teqnilb
;;; refract-new-p -nonlocal cs
;;; execute-node-path -local complete
;;;  push-wme-down-path -local complete
;;;

(in-package "SOAR")

;;;
;;;		iv.	Gloabl Variables Used
(eval-when (compile eval load) (proclaim '(special *c1* *c2* *c3* *c4* *c5* *c6* *c7* *c8* *c9* *c10* *c11* *c12* *c13* *c14* *c15* *c16*)))
(eval-when (compile eval load) (proclaim '(special *first-node*)))
(eval-when (compile eval load) (proclaim '(special *mem-array-size*)))
(defvar *flag-part* ()  "The flag to the network: either new or not new.")
(defvar *current-token* 0 "The current number of tokens in token memory.")
(eval-when (compile eval load) (proclaim '(special *conflict-set*)))
(eval-when (compile eval load) (proclaim '(special *execute-path*)))

(defvar *path* () "")

(defmacro check-execute (outs)
	   `(and *execute-path* (setq ,outs (and *path* (list (pop *path*))))))

(defun &all (outs lmem rpred tests) ; Randy.Gobbel 13-May-86 13:54 
       (not-left outs rpred tests lmem nil))

(defun &any (outs register const-list) ; Randy.Gobbel 11-Sep-86 15:26 
       (prog (z c)
	     (setq z (eval register))
	     (cond ((numberp z)
		    (go number)))
	     symbol
	     (cond ((null const-list)
		    (return nil))
		   ((eq (car const-list)
			z)
		    (go ok))
		   (t (setq const-list (cdr const-list))
		      (go symbol)))
	     number
	     (cond ((null const-list)
		    (return nil))
		   ((and (numberp (setq c (car const-list)))
			 (eqp c z))
		    (go ok))
		   (t (setq const-list (cdr const-list))
		      (go number)))
	     ok
	     (eval-nodelist outs)))

(defvar *data-part* ()  "Seems to be the data being sent through the network.")

(defun &bus (outs) ; Randy.Gobbel 22-Aug-86 11:45  ; Set the registers to 
 ; the values of the fields of the active wme. execute each output, 
 ; indexing off class name and attribute name in the wme if possible to 
 ; speed things up. 
 ; Hey what's got 16 slots ? Not a goal context info ? Not a preference ?
       (prog (dp class-list pair)
	     (setq dp (car *data-part*))
	     (setq *c1* (car dp))
	     (setq dp (cdr dp))
	     (setq *c2* (car dp))
	     (setq dp (cdr dp))
	     (setq *c3* (car dp))
	     (setq dp (cdr dp))
	     (setq *c4* (car dp))
	     (setq dp (cdr dp))
	     (setq *c5* (car dp))
	     (setq dp (cdr dp))
	     (setq *c6* (car dp))
	     (setq dp (cdr dp))
	     (setq *c7* (car dp))
	     (setq dp (cdr dp))
	     (setq *c8* (car dp))
	     (setq dp (cdr dp))
	     (setq *c9* (car dp))
	     (setq dp (cdr dp))
	     (setq *c10* (car dp))
	     (setq dp (cdr dp))
	     (setq *c11* (car dp))
	     (setq dp (cdr dp))
	     (setq *c12* (car dp))
	     (setq dp (cdr dp))
	     (setq *c13* (car dp))
	     (setq dp (cdr dp))
	     (setq *c14* (car dp))
	     (setq dp (cdr dp))
	     (setq *c15* (car dp))
	     (setq dp (cdr dp))
	     (setq *c16* (car dp))
	     (setq class-list (get *c1* '&bus-branch))
	     (cond ((and (not *execute-path*)
			 class-list)
		    (eval-nodelist (left-outs (car class-list)))
		    (cond ((setq pair (soarassq *c3* (cdr class-list)))
			   (eval-nodelist (left-outs (cdr pair)))))))
	     (eval-nodelist outs)))

;;; What the F happened to not-right ? It's only called from
;;; &rmem's anyway so it only gets called there.
;;; This is a spurios function call here.
;;; Not-left ought to become &not; almost the number of parameters 
;;; changes or some such.

(defun &not (outs lmem rpred tests) ; John.Laird 23-Jun-86 11:04 
       (not-left outs rpred tests lmem t))

(defun &old (a b c d e)
   (declare (ignore a b c d e))
       nil)

(defun &p (rating name var-dope ce-var-dope rhs) ; Randy.Gobbel 
 ; 16-Jul-86 16:44  ; ADD OR REMOVE A TOKEN FROM THE CONFLICT SET. 
       (declare (ignore rhs ce-var-dope var-dope rating))
       #+:soar-times
       (pause-soar-time add-to-wm
	  (stop-soar-time match)
        (pause-soar-time remove-from-wm
          (prog nil 
		(cond ((eq *flag-part* 'new)
		       (insertcs name *data-part*)
		       )
		      (t (removecs name *data-part*)))
		)
	  (start-soar-time match)
	  ))
       #-:soar-times
          (prog nil 
		(cond ((eq *flag-part* 'new)
		       (insertcs name *data-part*)
		       )
		      (t (removecs name *data-part*)))
		))



(defun add-token (memlis data-part hashflag num) ; Dan.Scales 
 ; 13-Jan-86 17:54 
       (prog nil (cond ((eq *flag-part* 'new)
			(real-add-token memlis data-part hashflag num))
		       (t (remove-old memlis data-part hashflag num)))))


(defun and-left (outs mem tests) ; Randy.Gobbel 13-May-86 14:04 
       (prog (memdp tlist tst lind rind res path i memlist memlist1 flag id dp)
	     (check-execute outs)
	     (setq path *path*)
	     (setq dp *data-part*)
	     (cond ((and tests (eq (car tests) 'teqb)
;; Equal inline might help too.
			 (equal (caddr tests) '(0 . 1)))
		    (setq flag t)
		    (setq id (gelm *data-part* (cadr tests)))
		    (setq memlist (soarassq id (getvector mem (get-hash-id id))))
		    (or memlist (return nil))
		    (setq memlist1 (cdr memlist))
		    (setq memlist nil)
		    (setq tests (cdddr tests))
		    (go loop1))
		   (t (setq i 0)))
	     loopi
	     (and (>= i *mem-array-size*)
		  (return nil))
	     (setq memlist (getvector mem i))
	     fail
	     (cond ((null memlist)
		    (and flag (return nil))
		    (setq i (1+ i))
		    (go loopi)))
	     (setq memlist1 (cdr (pop memlist)))
	     loop1
	     (and (null memlist1)  (go fail))
	     (setq memdp (pop memlist1))
	     (setq tlist tests)
	     tloop
	     (and (null tlist) (go succ))
	     (setq tst (pop tlist))
	     (setq lind (pop tlist))
	     (setq rind (pop tlist))
	     (setq res (cond ((eq tst 'teqb)
			      (eqp (gelm memdp rind) (gelm *data-part* lind)))
			     (t (funcall tst (gelm memdp rind)
					   (gelm *data-part* lind)))))
	     (cond (res (go tloop))
		   (t (go loop1)))
	     succ
	     (setq tlist outs)
	     (setq *data-part* (append memdp *data-part*))
	     loop
	     (cond ((null tlist)
		    (setq *data-part* dp)
		    (go loop1)))
	     (setq *path* path)
	     (setq tst (pop tlist))
	     (setq res (pop tst))
	     (cond ((eq res '&lmem)
		    (&lmem (car tst)
			   (cadr tst)))
		   ((or (eq res '&not)
			(eq res '&all))
		    (not-left (car tst)
			      (caddr tst)
			      (cadddr tst)
			      (cadr tst)
			      (eq res '&not)))
		   (t (apply res tst)))
	     (go loop)))

(defun and-right (outs mem tests) ; Randy.Gobbel 13-May-86 14:04 
       (prog (dp memdp tlist tst lind rind res)
	     (setq dp *data-part*)
	     fail
	     (and (null mem) (return nil))
	     (setq memdp (pop mem))
	     (setq tlist tests)
	     tloop
	     (and (null tlist) (go succ))
	     (setq tst (pop tlist))
	     (setq lind (pop tlist))
	     (setq rind (pop tlist))
	     (setq res (cond ((eq tst 'teqb)
			      (eqp (gelm dp rind) (gelm memdp lind)))
			     (t (funcall tst (gelm dp rind) (gelm memdp lind)))))
	     (cond (res (go tloop))
		   (t (go fail)))
	     succ
	     (setq tlist outs)
	     (setq *data-part* (append dp memdp))
	     loop
	     (cond ((null tlist)
		    (setq *data-part* dp)
		    (go fail)))
	     (setq tst (pop tlist))
	     (setq res (pop tst))
	     (cond ((eq res '&lmem)
		    (&lmem (car tst) (cadr tst)))
		   ((or (eq res '&not)
			(eq res '&all))
		    (not-left (car tst)
			      (caddr tst)
			      (cadddr tst)
			      (cadr tst)
			      (eq res '&not)))
		   (t (apply res tst)))
	     (go loop)))


(defun match (flag wme) ; Randy.Gobbel 22-Apr-86 10:40  ; Send wme down 
 ; the network, with *flag-part* set to flag. 
       #+:soar-times (start-soar-time match)
       (setq *flag-part* flag)
       (setq *data-part* (list wme))
       (prog1 
	   (apply (car *first-node*) (cdr *first-node*))
	 #+:soar-times (stop-soar-time match)))

(defun not-left (outs mem tests own-mem flag) ; Randy.Gobbel 
 ; 11-Sep-86 15:29 
       (prog (memdp tlist tst lind rind res c i memlist memlist1)
	     (check-execute outs)
	     (setq c 0)
	     (setq i 0)
	     loopi
	     (and (>= i *mem-array-size*)
		  (go fin))
	     (setq memlist (getvector mem i))
	     fail
	     (cond ((null memlist)
		    (setq i (1+ i))
		    (go loopi)))
	     (setq memlist1 (cdr (pop memlist)))
	     loop1
	     (and (null memlist1)
		  (go fail))
	     (setq memdp (pop memlist1))
	     (setq tlist tests)
	     tloop
	     (cond ((null tlist)
		    (and flag (setq c (1+ c)))
		    (go loop1)))
	     (setq tst (pop tlist))
	     (setq lind (pop tlist))
	     (setq rind (pop tlist))
	     (setq res (funcall tst (gelm memdp rind)
				  (gelm *data-part* lind)))
	     (cond (res (go tloop))
		   (t (or flag (setq c (1+ c)))
		      (go loop1)))
	     fin
	     (add-token own-mem *data-part* nil c)
	     (or (eqp c 0)
		 (return))
	     (setq tlist outs)
	     loop
	     (or tlist (return))
	     (setq tst (pop tlist))
	     (setq res (pop tst))
	     (cond ((eq res '&lmem)
		    (&lmem (car tst)
			   (cadr tst)))
		   ((or (eq res '&not)
			(eq res '&all))
		    (not-left (car tst)
			      (caddr tst)
			      (cadddr tst)
			      (cadr tst)
			      (eq res '&not)))
		   (t (apply res tst)))
	     (go loop)))


;;; All of these bipartite beta nodes are a little weirdly
;;; coded. I'll have to spend some time messing with them.

(defun not-right (outs mem tests flag) ; Randy.Gobbel 11-Sep-86 15:29 
       (prog (fp dp memdp tlist tst lind rind res inc newc)
	     (setq fp *flag-part*)
	     (setq dp *data-part*)
	     (cond ((eq fp 'new)
		    (setq inc 1)
		    (setq *flag-part* nil))
		   (t (setq inc -1)
		      (setq *flag-part* 'new)))
	     fail
	     (cond ((null mem)
		    (setq *flag-part* fp)
		    (return)))
	     (setq memdp (car mem))
	     (setq newc (cadr mem))
	     (setq tlist tests)
	     tloop
	     (and (null tlist)
		  (cond (flag (go succ))
			(t (go nosend))))
	     (setq tst (pop tlist))
	     (setq lind (pop tlist))
	     (setq rind (pop tlist))
	     (setq res (funcall tst (gelm dp rind)
				  (gelm memdp lind)))
	     (cond (res (go tloop))
		   (t (cond (flag (go nosend)))))
	     succ
	     (setq newc (+ inc newc))
	     (rplaca (cdr mem) newc)
	     (cond ((not (or (and (eqp inc -1)
				  (eqp newc 0))
			     (and (eqp inc 1)
				  (eqp newc 1))))
		    (go nosend)))
	     (setq tlist outs)
	     (setq *data-part* memdp)
	     loop
	     (or tlist (go donesend))
	     (setq tst (pop tlist))
	     (setq res (pop tst))
	     (cond ((eq res '&lmem)
		    (&lmem (car tst)
			   (cadr tst)))
		   ((or (eq res '&not)
			(eq res '&all))
		    (not-left (car tst)
			      (caddr tst)
			      (cadddr tst)
			      (cadr tst)
			      (eq res '&not)))
		   (t (apply res tst)))
	     (go loop)
	     donesend
	     (setq *data-part* dp)
	     nosend
	     (setq mem (cddr mem))
	     (go fail)))


(defun real-add-token (lis data-part hashflag num) ; Randy.Gobbel 
 ; 23-Jun-86 18:26 
       (prog (hashval id l idl)
	     (setq *current-token* (1+ *current-token*))
	     (setq *added-tokens* (1+ *added-tokens*))
             (if hashflag
                 (setq *right-added-tokens* (1+ *right-added-tokens*))
                 (setq *left-added-tokens* (1+ *left-added-tokens*)))
	     (cond (num (rplaca lis (cons data-part (cons num (car lis)))))
		   (hashflag (setq id (wme-id (car data-part)))
			     (setq hashval (get-hash-id id))
			     (setq l (getvector lis hashval))
			     (setq idl (soarassq id l))
			     (cond (idl (rplacd idl (cons data-part (cdr idl))))
				   (t (putvector lis hashval
						 (cons (list id data-part)
						       l)))))
		   (t (rplaca lis (cons data-part (car lis)))))))

;;; This entire case in here can be expanded out simply by causing
;;; the call to its caller, add-token, expand the cond at coding
;;; time.

(defun remove-old (lis data hashloc num) ; Randy.Gobbel 21-Apr-86 12:18 
       (cond (num (remove-old-num lis data))
	     (hashloc (remove-old-hash lis data (wme-id (car data))))
	     (t (remove-old-no-num lis data))))


(defun remove-old-no-num (lis data) ; Randy.Gobbel 16-May-86 10:55 
       (prog (m next last)
	     (setq m (car lis))
	     (cond ((atom m)
		    (return nil))
		   ((top-levels-eq data (car m))
		    (setq *current-token* (1- *current-token*))
		    (setq *removed-tokens* (1+ *removed-tokens*))
                    (setq *left-removed-tokens* (1+ *left-removed-tokens*))
		    (rplaca lis (cdr m))
		    (return (car m))))
	     (setq next m)
	     loop
	     (setq last next)
	     (setq next (cdr next))
	     (cond ((atom next)
		    (return nil))
		   ((top-levels-eq data (car next))
		    (rplacd last (cdr next))
		    (setq *current-token* (1- *current-token*))
		    (setq *removed-tokens* (1+ *removed-tokens*))
                    (setq *left-removed-tokens* (1+ *left-removed-tokens*))
		    (return (car next)))
		   (t (go loop)))))

(defun remove-old-num (lis data) ; Randy.Gobbel 16-May-86 10:56 
       (prog (m next last)
	     (setq m (car lis))
	     (cond ((atom m)
		    (return nil))
		   ((top-levels-eq data (car m))
		    (setq *current-token* (1- *current-token*))
		    (setq *removed-tokens* (1+ *removed-tokens*))
                    (setq *left-removed-tokens* (1+ *left-removed-tokens*))
		    (rplaca lis (cddr m))
		    (return (car m))))
	     (setq next m)
	     loop
	     (setq last next)
	     (setq next (cddr next))
	     (cond ((atom next)
		    (return nil))
		   ((top-levels-eq data (car next))
		    (rplacd (cdr last)
			    (cddr next))
		    (setq *current-token* (1- *current-token*))
		    (setq *removed-tokens* (1+ *removed-tokens*))
                    (setq *left-removed-tokens* (1+ *left-removed-tokens*))
		    (return (car next)))
		   (t (go loop)))))

;;; Good god the eval's here could all be turned to
;;; symbol-values. Significant savings. 

(defun teqa (outs register constant) ; Randy.Gobbel 11-Sep-86 17:53 
       (prog (a)
	     (setq a (eval register))
	     (return (cond ((eq a constant)
			    (eval-nodelist outs))
			   ((and (numberp a)
				 (numberp constant)
				 (eqp a constant)
				 (eval-nodelist outs)))
			   (t nil)))))

(defun teqb (new eqvar) ; Randy.Gobbel 11-Sep-86 15:26 
       (cond ((eq new eqvar)
	      t)
	     ((not (numberp new))
	      nil)
	     ((not (numberp eqvar))
	      nil)
	     ((eqp new eqvar)
	      t)
	     (t nil)))

(defun teqn (outs register constant) ; Randy.Gobbel 11-Sep-86 15:26 
       (prog (z)
	     (setq z (eval register))
	     (and (numberp z)
		  (eqp z constant)
		  (eval-nodelist outs))))

(defun teqs (outs vara varb) ; Randy.Gobbel 11-Sep-86 15:26 
       (prog (a b)
	     (setq a (eval vara))
	     (setq b (eval varb))
	     (cond ((eq a b)
		    (eval-nodelist outs))
		   ((and (numberp a)
			 (numberp b)
			 (eqp a b))
		    (eval-nodelist outs)))))

(defun tgeb (new eqvar)
       (cond ((not (numberp new))
	      nil)
	     ((not (numberp eqvar))
	      nil)
	     ((not (> eqvar new))
	      t)
	     (t nil)))

(defun tgen (outs register constant) ; Randy.Gobbel  7-Apr-86 14:42 
       (prog (z)
	     (setq z (eval register))
	     (and (numberp z)
		  (not (> constant z))
		  (eval-nodelist outs))))

(defun tges (outs vara varb) ; Randy.Gobbel  7-Apr-86 14:42 
       (prog (a b)
	     (setq a (eval vara))
	     (setq b (eval varb))
	     (and (numberp a)
		  (numberp b)
		  (not (> b a))
		  (eval-nodelist outs))))

(defun tgtb (new eqvar)
       (cond ((not (numberp new))
	      nil)
	     ((not (numberp eqvar))
	      nil)
	     ((> new eqvar)
	      t)
	     (t nil)))

(defun tgtn (outs register constant) ; Randy.Gobbel  7-Apr-86 14:42 
       (prog (z)
	     (setq z (eval register))
	     (and (numberp z)
		  (> z constant)
		  (eval-nodelist outs))))

(defun tgts (outs vara varb) ; Randy.Gobbel  7-Apr-86 14:42 
       (prog (a b)
	     (setq a (eval vara))
	     (setq b (eval varb))
	     (and (numberp a)
		  (numberp b)
		  (> a b)
		  (eval-nodelist outs))))

(defun tleb (new eqvar)
       (cond ((not (numberp new))
	      nil)
	     ((not (numberp eqvar))
	      nil)
	     ((not (> new eqvar))
	      t)
	     (t nil)))

(defun tlen (outs register constant) ; Randy.Gobbel  7-Apr-86 14:42 
       (prog (z)
	     (setq z (eval register))
	     (and (numberp z)
		  (not (> z constant))
		  (eval-nodelist outs))))

(defun tles (outs vara varb) ; Randy.Gobbel  7-Apr-86 14:42 
       (prog (a b)
	     (setq a (eval vara))
	     (setq b (eval varb))
	     (and (numberp a)
		  (numberp b)
		  (not (> a b))
		  (eval-nodelist outs))))

(defun tltb (new eqvar)
       (cond ((not (numberp new))
	      nil)
	     ((not (numberp eqvar))
	      nil)
	     ((> eqvar new)
	      t)
	     (t nil)))

(defun tltn (outs register constant) ; Randy.Gobbel  7-Apr-86 14:42 
       (prog (z)
	     (setq z (eval register))
	     (and (numberp z)
		  (> constant z)
		  (eval-nodelist outs))))

(defun tlts (outs vara varb) ; Randy.Gobbel  7-Apr-86 14:42 
       (prog (a b)
	     (setq a (eval vara))
	     (setq b (eval varb))
	     (and (numberp a)
		  (numberp b)
		  (> b a)
		  (eval-nodelist outs))))

(defun tnea (outs register constant) ; Randy.Gobbel 11-Sep-86 17:52 
       (prog (a)
	     (setq a (eval register))
	     (return (cond ((eq a constant)
			    nil)
			   ((and (numberp a)
				 (numberp constant))
			    (and (not (eqp a constant))
				 (eval-nodelist outs)))
			   (t (eval-nodelist outs))))))

(defun tneb (new eqvar) ; Randy.Gobbel 11-Sep-86 15:26 
       (cond ((eq new eqvar)
	      nil)
	     ((not (numberp new))
	      t)
	     ((not (numberp eqvar))
	      t)
	     ((eqp new eqvar)
	      nil)
	     (t t)))

(defun tnen (outs register constant) ; Randy.Gobbel 11-Sep-86 15:27 
       (prog (z)
	     (setq z (eval register))
	     (and (or (not (numberp z))
		      (not (eqp z constant)))
		  (eval-nodelist outs))))

(defun tnes (outs vara varb) ; Randy.Gobbel 11-Sep-86 15:27 
       (prog (a b)
	     (setq a (eval vara))
	     (setq b (eval varb))
	     (cond ((eq a b)
		    (return nil))
		   ((and (numberp a)
			 (numberp b)
			 (eqp a b))
		    (return nil))
		   (t (eval-nodelist outs)))))

;;; I think that a straight eq will suffice here saving a little
;;; tie on non lisp machines.

(defun top-levels-eq (la lb) ; Randy.Gobbel 11-Sep-86 17:56 
       (prog nil lx (cond ((eqp la lb)
			   (return t))
			  ((null la)
			   (return nil))
			  ((null lb)
			   (return nil))
			  ((not (eqp (car la)
				     (car lb)))
			   (return nil)))
	     (setq la (cdr la))
	     (setq lb (cdr lb))
	     (go lx)))

(defun txxa (outs register constant) ; Randy.Gobbel  7-Apr-86 14:42 
  (declare (ignore constant))
       (and (symbolp (eval register))
	    (eval-nodelist outs)))

(defun txxb (new eqvar)
       (cond ((numberp new)
	      (cond ((numberp eqvar)
		     t)
		    (t nil)))
	     (t (cond ((numberp eqvar)
		       nil)
		      (t t)))))

(defun txxn (outs register constant) ; Randy.Gobbel  7-Apr-86 14:42 
  (declare (ignore constant))
       (prog (z)
	     (setq z (eval register))
	     (and (numberp z)
		  (eval-nodelist outs))))

(defun txxs (outs vara varb) ; Randy.Gobbel  7-Apr-86 14:42 
       (prog (a b)
	     (setq a (eval vara))
	     (setq b (eval varb))
	     (cond ((and (numberp a)
			 (numberp b))
		    (eval-nodelist outs))
		   ((and (not (numberp a))
			 (not (numberp b)))
		    (eval-nodelist outs)))))

(defun teqnilb (x y) ; Randy.Gobbel 11-Sep-86 17:58 
       (or (eq x y)
	   (null x)
	   (and (numberp x)
		(numberp y)
		(eqp x y))))


;;; This mapc should be a dolist.
;;;

(defun &lmem (outs memory) ; Dan.Scales 27-Jan-86 03:50 
       (add-token memory *data-part* nil nil)
       (check-execute outs)
       (soarmapc #'(lambda (node)
			   (setq node (cdr node))
			   (and-left (car node)
				     (caddr node)
				     (cadddr node)))
		 outs))

;;; Mapc to dolist.

(defun &rmem (outs memory) ; Randy.Gobbel 13-May-86 13:55 
       (add-token memory *data-part* t nil)
       (check-execute outs)
       (soarmapc #'(lambda (node)
			   (cond ((eq (car node)
				      '&and)
				  (and-right (cadr node)
					     (caaddr node)
					     (cadddr (cdr node))))
				 ((eq (pop node)
				      '&not)
				  (not-right (car node)
					     (caadr node)
					     (cadddr node)
					     t))
				 (t (not-right (car node)
					       (caadr node)
					       (cadddr node)
					       nil))))
		 outs))

(defun remove-old-hash (lis data hashid) 
 ;; Exchanged delete for dremove. -BGM 2/11/89
 ; Randy.Gobbel 16-May-86 10:57 
       (prog (m idlist next last)
	     (setq m (getvector lis (get-hash-id hashid)))
	     (setq idlist (soarassq hashid m))
	     (cond ((null idlist)
		    (return nil)))
	     (setq next idlist)
	     loop
	     (setq last next)
	     (setq next (cdr next))
	     (cond ((atom next)
		    (return nil))
		   ((top-levels-eq data (car next))
		    (rplacd last (cdr next))
		    (or (cdr idlist)
			;; Most crass, this is a linear operation 
			;; done twice instead of only once. -BGM 1/31/89
			(putvector lis (get-hash-id hashid)
				   (delete idlist m)))
		    (setq *current-token* (1- *current-token*))
		    (setq *removed-tokens* (1+ *removed-tokens*))
                    (setq *right-removed-tokens* (1+ *right-removed-tokens*))
		    (return (car next)))
		   (t (go loop)))))


;;; This is expensive to do this symbolp and this get.
;;; I wonder where the 'gensymed value comes from.
;;; I wonder how this affects the hashing of user
;;; symbols other than gensyms ?
;;; I bet that this 0 clause really goofs up 
;;; Yost's TAQ when it puts variables for classes.
;;;

(defun get-hash-id (id) ; Randy.Gobbel 23-Jun-86 19:05 
       (or (and (symbolp id) (get id 'gensymed))
	   0))


(defun eval-node (out)
   (apply (car out) 
          (cdr out)
))

(defun eval-nodelist (outs) 
  ;; changed for better performance GAP
       (cond (*execute-path* (cond (*path* (let ((path (pop *path*)))
                                                (apply (car path)
                                                       (cdr path))))))
	     (t (dolist (out outs)
		        (apply (car out) 
			       (cdr out)) )) )
)


(defvar *save-path* () "")

(defun execute-node-path (path) ; Randy.Gobbel 18-Mar-86 15:29  ; SEND 
 ; TOKENS FROM TOP NODE OF PATH THROUGH EACH NODE OF THE PATH * 
  #+:soar-times (stop-soar-time ptorete)
  #+:soar-times (start-soar-time match)
       (prog (node)
	     (setq path (nreverse path))
	     (setq node (car path))
	     (setq *execute-path* t)
	     (cond ((eq (car node) '&bus)
		    (setq *save-path* path)
		    ;;; Overly expensive build.
		    ;;; It should only push down wmes of the appropriate
		    ;;; class. Could be a significant speed up for chunking.
    		    (mapwm #'(lambda (x)
				     (push-wme-down-path (list (car x))))))
		   ((eq (car node) '&lmem)
		    (setq *save-path* (cdr path))
		    (soarmapc #'(lambda (x)
					(push-wme-down-path x))
			      (car (caddr node)))))
	     (setq *execute-path* nil)
	     #+:soar-times (start-soar-time ptorete)
	     #+:soar-times (stop-soar-time match)
	     ))

(defun push-wme-down-path (wme) ; Randy.Gobbel 18-Mar-86 15:30  ; PUSH WME 
 ; THROUGH THE NODES INDICATED BY PATH, STOPPING AT THE FIRST FAILING NODE 
       (prog (node)
	     (setq *flag-part* 'new)
	     (setq *data-part* wme)
	     (setq *path* *save-path*)
	     (setq node (pop *path*)) ; BEGINNING OF A PATH IS EITHER THE 
 ; &BUS NODE OR AN &AND NODE BELOW AN &LMEM NODE. 
	     (cond ((eq (pop node) '&bus)
		    (&bus (car node)))
		   (t (and-left (car node)
				(caddr node)
				(cadddr node))))))

(defun initialize-rete-interpreter ()
  (setq *current-token* 0)
  (setq *added-tokens*  0)
  (setq *right-added-tokens*  0)
  (setq *left-added-tokens*  0)
  (setq *removed-tokens* 0)
  (setq *right-removed-tokens* 0)
  (setq *left-removed-tokens* 0)
 NIL)

(defun restart-rete-interpreter ()
  (initialize-rete-interpreter)
  (setq *mem-array-size* 10)
  (setq *path* nil)
  (setq *execute-path* nil)  
  
 NIL)

;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/cs.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module RETE submodule CS
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the conflict set of the rete.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Tree of Calls
;;;     iv.	Global Variables used
;;;	I.	Docs
;;;

;;;
;;;		iii.	Tree of Calls
;;;
;;; insertcs -local complete
;;;  refracted -local complete
;;; removecs -local complete
;;;  record-refract -local complete
;;;  top-levels-eq -nonlocal network
;;; conflict-resolution -local complete
;;;  all-autonomic -local complete
;;; cs -local complete
;;;  nlam-cs -local complete
;;;   conflict-set -local complete
;;; refract-new-p -local complete
;;;  find-max-goal-depth -nonlocal utility
;;;  test-if-subset -nonlocal good question Utility ?
;;;   
;;;

;;;
;;;		iv.	Global variables used
;;;

(in-package "SOAR")

(defvar *conflict-set* ()  "This variable holds the conflict set as a list.")
(defvar *recording* () "Something else for back.")
(defvar *record* () "Something for back.")
(defvar *refracts* () "The refraction set for back.")




;;; These next three routines are not ever called.
;;; They date from the ops5 days and can be deleted.
;;; -BGM 11/21/87

#|
(defun conflict-set-compare (x y) ; JonL 23-Apr-84 19:06 
       (prog (xorder yorder xl yl xv yv)
	     (setq xorder (order-part x))
	     (setq yorder (order-part y))
	     (setq xl (car xorder))
	     (setq yl (car yorder))
	     data
	     (cond ((and (null xl)
			 (null yl))
		    (go ps))
		   ((nulla yl)
		    (return t))
		   ((nulla xl)
		    (return nil)))
	     (setq xv (car xl))
	     (setq yv (car yl))
	     (cond ((> xv yv)
		    (return t))
		   ((> yv xv)
		    (return nil)))
	     (setq xl (cdr xl))
	     (setq yl (cdr yl))
	     (go data)
	     ps
	     (setq xl (cdr xorder))
	     (setq yl (cdr yorder))
	     psl
	     (cond ((null xl)
		    (return t)))
	     (setq xv (car xl))
	     (setq yv (car yl))
	     (cond ((> xv yv)
		    (return t))
		   ((> yv xv)
		    (return nil)))
	     (setq xl (cdr xl))
	     (setq yl (cdr yl))
	     (go psl)))

(defun best-of* (best rem)
       (cond ((not rem)
	      best)
	     ((conflict-set-compare best (car rem))
	      (best-of* best (cdr rem)))
	     (t (best-of* (car rem)
			  (cdr rem)))))

(defun order-part (conflict-elem)
       (cdr conflict-elem))
|#

(defun insertcs (name data) 
 ;;; DSM version.
 #+:soar-times (start-soar-time cs)
 (cond ((not (clearing-matcher-working-memory-p))   ;<== DSM.
        ;; don't bother updating conflict set
        ;; if clearing working memory.
        (instantiation-arrival name data) ))        ;<== DSM.
	#+:soar-times (stop-soar-time cs)
 ;; this used to return the conflict set, but 
 ;; I think this unnecessary, and so suppressed this line.
 ;(conflict-set)
)

(defun removecs (name data)
 ;;; DSM version.
 #+:soar-times (start-soar-time cs)
 (cond ((not (clearing-matcher-working-memory-p))
        ;; don't bother updating conflict set
        ;; if clearing working memory.
        (instantiation-retraction name data)))   
  #+:soar-times (stop-soar-time cs)
 ;; this used to return the conflict set, but 
 ;; I think this unnecessary, and so suppressed this line.
 ;(conflict-set)
)

(defvar *atrace* t
  "Really good question as to what this variable does.")


;;;
;;;		I.	Docs
;;;

(defmacro docs ((instantiation &optional (return-value nil))  &body body)
  `(dolist (,instantiation (conflict-set) ,return-value)
     ,@body))


;;;
;;;		II.	Initialize-rete-cs
;;;

(defun initialize-rete-cs ()
  (setq *conflict-set* nil)
  NIL)



;;;
;;;		III.	Restart-rete-ce
;;;

(defun restart-rete-cs ()
  (setq *atrace* t)
  (setq *recording* nil)
  (setq *refracts* nil)
  (setq *conflict-set* nil)
  NIL)


;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/wm.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module RETE submodule WM.
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements some of the working memory functionality.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Call Tree
;;;	iv.	Global Variables Used
;;;

;;;
;;;		iii.	Call Tree
;;;
;;; *brkrun*
;;; *max-wm*
;;; *action-count*
;;; *current-wm*
;;; *wmpart-list*
;;; *wm*
;;; *last-tag*
;;; *last-obj-id*
;;; *PRINT-SPO-LIST*
;;; mapwm
;;; wm-hash
;;; creation-time
;;; ADD-TO-WM
;;; process-changes
;;; remove-from-wm
;;; spr
;;; nlam-spr
;;; trace-condition-action
;;; time-tag-print

(in-package "SOAR")


;;;
;;;		iv.	Global Variables Used
;;;
(defvar *brkrun* () 
  "This seems to be a list of wmes whose addition to working memory stops running.")
(eval-when (compile eval load) (proclaim '(special *break-flag*)))
(defvar *max-wm* 0  "The maximum size that working memory hit.")
(eval-when (compile eval load) (proclaim '(special *in-rhs*)))
(defvar *action-count* 0
  "The number of calls to add-to-wm and remove-from-wm.")

(defvar *current-wm* 0  "The current size of working memory.")
(eval-when (compile eval load) (proclaim '(special *critical*)))

(defvar *wmpart-list* ()  " The list of wme classes used so far.")
(defvar *wm* () "Something for iterating over wm. Not a list of all wmes ?")
(defvar *last-tag* () "The last timetag entered into a wm or a rhs function.")
(eval-when (compile eval load) (proclaim '(special *last-arg*)))
(defvar *last-obj-id* () "*last-obj*'s identifier ?")
(eval-when (compile eval load) (proclaim '(special *indent*)))



(defun mapwm (fn) ; RG: 20-Feb-86 18:02 
       (prog (wmpl part)
	     (setq wmpl *wmpart-list*)
	     lab1
	     (cond ((atom wmpl)
		    (return nil)))
	     (setq part (get (car wmpl)
			     'wmpart*))
	     (setq wmpl (cdr wmpl))
	     (soarmapc fn part)
	     (go lab1)))

(defun wm-hash (x) ; Randy.Gobbel 21-Apr-86 17:04 
       (wme-id x))

(defun creation-time (wme)
 ;; used by the non-DSM code.
 ;; DSM ==>
 ;; returns timetag.
 ;; before DSM wmes were eq. not anymore.
 (timetag wme)          
)

;;;*******************************************************************************
;;; Function: add-to-wm
;;; This function has been altered in order to support the new Soar IO definition.
;;;*******************************************************************************o

(defvar *wtrace* () 
  "When I'm true trace each wme added or removed.")

(eval-when (compile eval load) (proclaim '(special *chunk-all-paths* *ptrace* *ttrace*)))

(eval-when (compile eval load) (proclaim '(special *first-remove* *first-action*)))


;; Number: 274
;; Report Date: 11-Feb-91
;; Reported by: Frank Ritter <fr07+@ANDREW.CMU.EDU>
;; Status: User-Library
;; Cross Reference: 30Jan91-15.08.10
;; Priority: 5
;; Synopsis:
;; Code for getting the names and atribute value pairs of context objects.
;; 
;; Comments:
;; Frank, this is not really appropriate for Soar IO. I understand why you
;; needed it but in general the trend is to try to limit the information
;; available to Soar-IO. I'll file this away so that we won't lose it
;; if someone wants it.

(defun get-wmparts (&optional (object (soar::top-goal)))
  "Returns a list of strings corresponding to the wme's of OBJECT."
;  (mapcar #'(lambda (x)
;	     (let ((start (car x)))
;	      (format nil "^~s ~s ~a"
;	         (third start) (fourth start)
;		 (if (fifth start) (princ-to-string (fifth start)) ""))))
;	  (get object 'soar::wmpart*))
  (do* ( (Xs (get object 'soar::wmpart*) (cdr Xs))
	 (x (car Xs) (car Xs))
	 (result nil))
       ((null Xs) result)
    (setf result
	  (nconc result
                 (list
                 (let ((start (car x)))
                   (format nil "^~s ~s ~a"
                          (third start) (fourth start)
		           (if (fifth start)
			       (princ-to-string (fifth start)) ""))))))
    ))

;;;
;;;	VIb.	wm-structure?
;;;
;;; just a quick and dirty test to see if something can be expanded.
;;;

(defun recursive-context-member (item contexts)
  (cond ((null contexts) nil)
        ((member item (car contexts)))
        (t (recursive-context-member item (cdr contexts)))))

(defun context-member (item)
  (if (recursive-context-member item (contexts))
      t))

(defun wm-structure? (item)
  (and (symbolp item)
       (or (get-wmparts item)
           (context-member item))
       t))

;;;
;;;     VIII.   SPR
;;;
;;; Cons's a lot, could be cleaned up to use raw function calls that wm, spo, etc
;;; are built on.     (format t "This printing based on an idea by Bob. ~%")


(defvar spr-line-p t 
"*Try to put a blank line between each item if T (default).")

(defmacro spr (&rest args)
  (let ( (a (car args))
         (b (cdr args)) )
    ;(format t "Doing ~s of ~s w/ b= ~s" a args b)
    (cond
      ((null args) nil) ; done
      ((eq a :help)
       (format t "~a~%" (documentation 'soar::spr 'soar::function)))
      ((numberp a)      ; wme
       (eval `(wm ,a)))  ;puts its own space in
      ((wm-structure? a)        ; object
       (eval `(spo ,a))
       (if spr-line-p (format t "~%")))
      ((symbolp a) (eval `(spm ,a))       ; production
       (if spr-line-p (format t "~%")))
      ((listp a)          ; wm descriptions
       (eval `(sppwm ,@a)))
      (t (error "Fell off of spr cond.")) )
    (if b (eval `(spr ,@b)))))

;; bug in allegro makes us doc macros after we define them
(setf (documentation 'spr 'function)
  "Given a list of Soar objects, print them.
    For wmes: print just them
    For productions: print them
    For object ids: print them to the default level
    For wm descriptions (which now must be in lists): print them.")



;;;
;;;		?.	Initialize-rete-wm
;;;

(defun initialize-rete-wm ()
  (clear-matcher-working-memory)
  (setq *wmpart-list* nil)
  (setq *max-wm* 0)
  (setq *action-count* 0)
  (setq *current-wm* 0)
 NIL)


;;;
;;;		?.	Restart-rete-wm
;;;

(defun restart-rete-wm ()
  (compiled-sremove '(*))
  (setq *wmpart-list* nil)
  (setq *max-wm* 0)
  (setq *action-count* 0)
  (setq *current-wm* 0)
  (setq *last-tag* nil)
  (setq *last-arg* nil)
  NIL)


;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/rhs.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;
;;;	Soar: Module RETE submodule RHS
;;;
;;;

;;;
;;;
;;;		i.	Abstract
;;;
;;;	This file implements the stuff which evaluates the RHS of rules.
;;;

;;;
;;;		ii.	Table of Contents
;;;
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Call Tree	
;;;	iv.	Global Variables
;;;

;;;
;;;		iii.	Call Tree
;;;
;;; make -local
;;;  nlam-make -local complete
;;;   add-to-wm -nonlocal wm
;;;   eval-args -local complete
;;;    $change -local complete
;;;      eval-function -local complete
;;;      $varbind -local complete
;;;        make-var-bind -nonlocal ?
;;; accept -local complete
;;;   nlam-accept -local
;;;    $ifile -local complete
;;;    stop-elapsed-time  -nonlocal 
;;;    start-elapsed-time -nonlocal 
;;; call1 -local complete
;;;  nlam-call1 -local complete
;;; call2 -local complete
;;;  nlam-call2 -local complete
;;; compute -local complete
;;;  nlam-compute -local complete
;;;   ari -local complete
;;;    ari-unit -local complete
;;;     forward-slash -nonlocal compat
;;;     backward-slash -nonlocal compate
;;; smake  -local complete
;;;  nlam-smake -local complete
;;;  spm-to-make -local complete
;;; sremove -local complete
;;;  nlam-sremove -local complete
;;;   process-changes -nonlocal wm
;;;   get-wm -nolocal wm
;;; tabstop -local complete
;;;  nlam-tabstop -local complete
;;;   get-context-depth -nonlocal decide
;;; write1 -local complete
;;;  default-write-file -local complete
;;; write2 -local complete
;;;  nlam-write2 -local complete
;;; bind -local complete
;;;  nlam-bind -local complete
;;; label-bind -local complete
;;;  nlam-label-bind -local complete
;;;   
;;; external -local complete
;;;  nlam-external -local complete
;;;   external2 -local complete
;;;    external3 -local complete
;;; halt -local complete
;;; run -local complete
;;;  init-wm-context -
;;;  start-elapsed-time
;;;  do-continue -local complete
;;;   main -local complete
;;;    conflict-resolution -nonlocal cs
;;;    process-decide -nonlocal decide
;;;    trace-problem-space? -nonlocal decide
;;;    process-instance -local complete
;;;     accum-stats -nonlocal interface statistics
;;;     eval-rhs -local 
;;;      post-process-results -
;;;     check-limits
;;;     broken -nonlocal pm
;;;    create-production
;;;    control
;;;  stop-elapsed-time
;;; watch -local complete
;;;  nlam-watch -local complete
;;;  nlam-run -local complete
;;; 

(in-package "SOAR")

;;;
;;;		iv.	Global Variables
;;;
(eval-when (compile eval load) (proclaim '(special *conflict-set*)))
(defvar *limit-cs* 1000000
  "The total number of instantiations which may be in the conflict set at any one time.
   Checked in the RHS functions.")
(eval-when (compile eval load) (proclaim '(special *current-token*)))
(defvar *limit-token* 1000000 "The total number of tokens which may be in working memory at one time.")
(defvar *critical* () 
 "A variable which is used to detect the aborts during the network execution.
 This should be replaced with an unwind protect in add-to-wm and remove-from-wm.")
(eval-when (compile eval load) (proclaim '(special *char-mode*)))
(defvar *elaborations-count* 0
  "The number of elaboration cycles fired since the last decide.")
(defvar *max-elaborations* 100
  "The maximum number of elaboration cycles allowed before decide runs.")
(eval-when (compile eval load) (proclaim '(special *last-arg*)))
(eval-when (compile eval load) (proclaim '(special *last-tag*)))
(defvar *halt-flag* ()  "Did the user or the interpreter just issue a halt ?")
(defvar *break-flag* () 
  "This is how the break routines actually communicate.
   When this is set to T after the current production is fired things halt.")
(eval-when (compile eval load) (proclaim '(special *brkrun*)))
(defvar *in-rhs* ()   "Am I executing a RHS now ? ")
(defvar *label-bindings* () "Something to do with label-bind in the interface.")
                                                                   

(defun eval-args (z) ; Randy.Gobbel 17-Jun-86 15:31 
 (prog (val)
  (setq val nil)
   (soarwhile z
    (setq val (append ($change (pop z)) val)))
  (return (nreverse val)))
)


(defun $change (x) ; Randy.Gobbel 17-Jun-86 15:31 
       (cond ((soarlistp x)
	      (eval-function x))
	     (t (list ($varbind x)))))

(defun eval-function (form) 
  ;; Functions may now be called at top level. -BGM 2/14/89
  ; Randy.Gobbel  3-Apr-86 14:05 
  (eval form))

(defvar *variable-memory* () "")


(defun $varbind (x)
  ;; Changed soargensym to Soar-genid. -BGM 3/5/89
  ;; Installed DSM changed from McMahon. -BGM 3/2/89
  ; Randy.Gobbel 17-Jun-86 15:30 
       (prog (r)
	     (and (not *in-rhs*)
		  (return x))
	     (setq r (soarassq x *variable-memory*))
	     (cond (r (return (cdr r)))
		   ((variablep-not-predicate x)
      (setf r (make-object-symbol (soarnthchar x 2)))    ;<== DSM
		    (make-var-bind x r)
		    (return r))
		   (t (return x)))))

(defun ari (x) ; Randy.Gobbel  4-Apr-86 16:12 
       (cond ((atom x)
	      (soarwarn "Bad syntax in arithmetic expression" x)
	      0)
	     ((atom (cdr x))
	      (ari-unit (car x)))
	     ((eq (cadr x)
		  '+)
	      (+ (ari-unit (car x))
		    (ari (cddr x))))
	     ((eq (cadr x)
		  '-)
	      (- (ari-unit (car x))
			  (ari (cddr x))))
	     ((eq (cadr x)
		  '*)
	      (* (ari-unit (car x))
		     (ari (cddr x))))
	     ((eq (cadr x)
		  (forward-slash))
	      (/ (ari-unit (car x))
			(ari (cddr x))))
	     ((eq (cadr x)
		  (backward-slash))
	      (rem (floor (ari-unit (car x)))
		   (floor (ari (cddr x)))))
	     (t (soarwarn "Bad syntax in arithmetic expression" x)
		0)))

(defun ari-unit (a) ; Randy.Gobbel  7-Apr-86 14:35 
       (prog (r)
	     (cond ((soarlistp a)
		    (setq r (ari a)))
		   (t (setq r ($varbind a))))
	     (cond ((not (numberp r))
		    (soarwarn "Bad value in arithmetic expression" a)
		    (return 0))
		   (t (return r)))))

(defmacro compute (&rest z)
	  (list 'nlam-compute (list 'quote z)))

      
(defun nlam-compute (z)
 ;; Modified for DSM to not return a list of the results. -BGM 5/8/89
 ; Randy.Gobbel 25-Jun-86 14:27 
	 (ari z)
)

(defun check-limits (phase)
 (declare (string phase))

 ;; check-limits called by diplomat. 

 ;; phase is "Working Memory Phase" or "Quiet Phase". 

 ;; Check that conflict set and working memory have not exceeded
 ;; prescribed limits.
 ;; Used to be called after firing a rule
 ;; (by process-instance, after calling eval-rhs) and
 ;; after the decision-procedure (by process-context-stack).
 ;; In DSM, called after Working Memory and Quiet Phases.
 ;; Cannot check after each rule firing because rules do not add wmes.
 ;; Additions for each wave are now effectively batched.
 ;; Could check after each addition.

 ;; Updated old style IO to soar-format. -BGM 8/18/88

 ;; check size of conflict set.
 (cond ((> (cs-size) *limit-cs*)         ;<== DSM
;(cond ((> (length *conflict-set*) *limit-cs*)
 	      (soar-format t "~%")
	       (soar-format t "~%")
	       (soar-format t
                     "~% CONFLICT SET SIZE EXCEEDED THE LIMIT OF ~A AFTER ~A"
                     *limit-cs*
                     phase)
                     ;*p-name*)
        ;(setq *halt-flag* t)))
        (signal-halt) ))                  ;<== DSM

 
 ;; check size of working memory.  
 (cond ((> *current-token* *limit-token*)
 	      (soar-format t "~%")
	       (soar-format t "~%")
	       (soar-format t
                     "~% TOKEN MEMORY SIZE EXCEEDED THE LIMIT OF ~A AFTER ~A" 
			                 	*limit-token*
                     phase)
                     ;*p-name*)
        ;(setq *halt-flag* t)))
        (signal-halt) ))                  ;<== DSM

)

(defun var-part (pnode)
       (car (cdddr pnode)))

(defun rhs-part (pnode)
       (caddr (cdddr pnode)))

(defvar *data-matched* () "Seems to be used in the network, decide and chunking.")

(defvar *ttrace* () 
 "When I'm true trace the timetags of working memory elements added and removed.")

(defvar *ptrace* () 
  "When I'm true trace the firing of each instantiation.")

(eval-when (compile eval load) (proclaim '(special *decide-count* *pfired* *current-goal* *never-learn*)))

(defun init-var-mem (vlist)
       (prog (v ind r)
	     (setq *variable-memory* nil)
	     top
	     (and (atom vlist)
		  (return nil))
	     (setq v (car vlist))
	     (setq ind (cadr vlist))
	     (setq vlist (cddr vlist))
	     (setq r (gelm *data-matched* ind))
	     (setq *variable-memory* (cons (cons v r)
					   *variable-memory*))
	     (go top)))

(eval-when (compile eval load) (proclaim '(special *brknames*)))

(eval-when (compile eval load) (proclaim '(special *first-action*)))

(eval-when (compile eval load) (proclaim '(special *STANDARD-TEXT-INPUT* *OUTPUT-LINKS* *LAST-TOP-LEVEL-STATE-ID*
		    *STANDARD-TEXT-INPUT-AUGMENTATION* *STANDARD-TEXT-OUTPUT-AUGMENTATION*
		    *STANDARD-TEXT-INPUT-STREAM-AUGMENTATION* *STANDARD-TEXT-OUTPUT-STREAM-AUGMENTATION*
		    *CHAR-MODE-AUGMENTATION* *CARRIAGE-CONTROL-AUGMENTATION*
		    *TAB-SETTINGS-AUGMENTATIONS*)))


(eval-when (compile eval load) (proclaim '(special *break-char*)
 ;; Added -BGM 2/1/89 
))

(defvar *cycle-count* 0 "The number of elaboration cycles fired total ?")
(defvar *remaining-cycles* 1000000 "")
(defvar *remaining-decide* 1000000 "")

(eval-when (compile eval load) (proclaim '(special *context-stack* *phase* *first-remove*)))

(defmacro external (&rest z)
	  (list 'nlam-external (list 'quote z)))

(defun nlam-external (z) 
 ;; Changed !error! into soar-error for DSM. -BGM 7/31/88
 ; RG: 20-Feb-86 17:57 
       (catch 'soar-error (external2 z)))

(defun external2 (z) ; RG: 20-Feb-86 18:14 
       (soarmapc #'external3 z))

(defun external3 (x) ; Randy.Gobbel  3-Apr-86 14:29 
       (cond ((symbolp x)
	      (soarputprop x t 'external-routine))
	     (t (soarerror "Not a legal function name" x))))

(defun externalp (x) ; Randy.Gobbel  3-Apr-86 13:54 
       (cond ((symbolp x)
	      (get x 'external-routine))
	     (t (soarwarn "Not a legal function name" x)
		nil)))

(defmacro call1 (&rest z)
	  (list 'nlam-call1 (list 'quote z)))

(defun nlam-call1 (z) ; Randy.Gobbel 13-Jun-86 14:31 
       (prog (f)
	     (setq f (car z))
	     (eval-args (cdr z))
	     (funcall f)))

(defmacro call2 (&rest z)
	  (list 'nlam-call2 (list 'quote z)))


(eval-when (load eval) (external call2))

(defun nlam-call2 (x) 
  ;; Modified to distinquish macros from functions and to only quote
  ;; arguments to functions. -BGM 2/5/89
  ;;; Updated to work for things which do not self eval. -BGM 3/30/88.
    (cond ((not *in-rhs*)
            (soarwarn "Can not be called at top level " 'call2))
          ((not (symbolp (car x)))
            (soarwarn "Call2: illegal argument " (car x)))
          (t (let ((function ($varbind (car x))))
	       (unless (symbolp function)
		 (soarwarn "Call2: bad function name " function))
	       (cond ((macro-function function)
		      (eval (cons function (mapcar #'$varbind (cdr x)))))
		     ((symbol-function function)
		      (apply function (mapcar #'(lambda (x) `,($varbind x)) (cdr x))))
		     (t (error "Call2: function, ~A, has no macro-function or symbol-function" function)))))))


(defmacro smake (&rest <preference-make>-or-<make-body>)
  "Smake is a make from the top level of Soar; it works just like the make on the RHS of an SP."
  ;; Created 12/7/88. -BGM
  `,(compiled-smake <preference-make>-or-<make-body>))

(eval-when (compile eval load) (proclaim '(special *RHS-SMAKE-or-PPWM*)))
 
(defun compiled-smake (<preference-make>-or-<make-body>)
 ;; Fixed to check for ID connectedness. -BGM 29-Aug-90
 ;; Fixed for 5.2.0 by deleting an extra call to <make> installed in 5.0 ifying. -BGM 28-Aug-90
 ;; Installed some soar-times calls. BGM 5/12/89 
 ;; Created 12/7/88. -BGM
 (catch-sptop-errors
  (initialize-lexer <preference-make>-or-<make-body>)
  (let* ((*RHS-SMAKE-OR-PPWM* 'SMAKE)
 	       ;; Tell the parser that I'm a calling it from the top level.
	 (progn-of-makes
       	 `(progn
 	    #+:soar-times (start-soar-time real)
 	    #+:soar-times (start-soar-time run)
      	    (let ((*variable-memory* nil)
             		  ;; Clear the variable memory, just in case the last P firing did not
             		  ;; leave it clear.
             		  (*in-rhs* t)
             		  ;; Fool Soar into thinking that we are in a RHS so that it
             		  ;; translates variables into gensyms.
             	  )
              ;; in DSM, top-level makes and rhs makes are handled differently.
    	      ,@(mapcar #'(lambda (make)
			    (let ((symbol-or-variable (nth 2 make)))
			    `(cond ((object-onode ,(cond ((variablep symbol-or-variable)
							  `(cdr (assoc ',symbol-or-variable *variable-memory*)))
							 (t `',symbol-or-variable)))
				    ,make)
				   (,(variablep symbol-or-variable) 
				    (soarwarn "Identifier variable is not connected to context stack, ignoring smake."
					      ',symbol-or-variable))
				   (t (soarwarn "Identifier symbol is not connected to context stack, ignoring smake."
					      ',symbol-or-variable)))))
		  (make-preference-to-make (<make>)))
 	    #+:soar-times (stop-soar-time run)
 	    #+:soar-times (stop-soar-time real)
         ))))
  (unless (eq (peek-lexeme) *end-of-input*)
           (sptop-rhs-error 
          	"parsed an SMAKE but had extra lexemes left over; you must have an ungramatical construct."
          ))
  progn-of-makes))
)

(defmacro sremove (&rest timetags-or-*)
  ;; Updated. -BGM 1/16/89
  `(compiled-sremove ',timetags-or-*))

(defun compiled-sremove (timetags-or-*)
  ;; Updated and renamed. -BGM 1/16/89
  ; John.Laird 24-Jun-86 11:12 
  (cond ((null timetags-or-*)
	 (setq timetags-or-* *last-tag*))
	(t (setq *last-arg* (setq *last-tag* (list (car timetags-or-*))))))
  (let ((*in-rhs* t))
    (cond ((equal timetags-or-* '(*))
	   ;; I could do a dowm over a remove-from-wm, but
	   ;; the dowm's variable of iteration might get bashed by
	   ;; destructive list removal, so I do a small collect and 
	   ;; remove list using cons saving, so that I don't senselessly
	   ;; throw a few pages of conses away on each init-soar.
	   (dolist (wmepart *wmpart-list*)
	     (let ((wmes nil))
	       (dolist (wme.timetag (get wmepart 'wmpart*) nil)
                 (remove-from-wm (car wme.timetag) (cdr wme.timetag))
		(get-push (car wme.timetag) wmes))
	       (dispose-list wmes))))
	  (t (dolist (timetag timetags-or-*)
       (let ((tme (find-wme-of-timetag timetag)))
        (declare (type tme-or-NIL tme))
        (if tme (external-remove-tme tme))) 
       )))))

(defmacro tabstop (&rest z)
	  (list 'nlam-tabstop (list 'quote z)))

(eval-when (compile eval load) (proclaim '(special *context*)))

(defun nlam-tabstop (z) ; Randy.Gobbel 11-Sep-86 15:15 
       (prog (val)
	     (cond ((not *in-rhs*)
		    (soarwarn "TABSTOP can not be called at the top level" " ")
		    (return nil))
		   ((not (eqp (length z) 1))
		    (soarwarn "Wrong number of arguments for Tabstop:" z)
		    (return nil))
		   ((not (variablep-not-predicate (car z)))
		    (soarwarn "Illegal argument for Tabstop:" (car z))
		    (return nil))
		   ((eqp (length z) 1)
		       (setq val (+ 3 (* (stack-depth) 3))) 
		       ))
	     (make-var-bind (car z)
			    val)))

(defun make-var-bind (var elem)
       (setq *variable-memory* (cons (cons var elem)
				     *variable-memory*)))

(defmacro #+:TI soar-bind #-:TI bind (&rest z)
	  (list 'nlam-bind (list 'quote z)))




(defun nlam-bind (z) 
 ;; Changed soargensym to Soar-genid. -BGM 3/5/89
 ;; Installed DSM changes from McMahon. 3/2/89
 ;; Randy.Gobbel 13-Jun-86 14:40 
 (prog (val var)
  (setq var (car z))
  (cond ((not *in-rhs*)
    	    (soarwarn "Cannot be called at top level" 
			                #+:TI 'Soar-bind #-:TI 'bind)
		       (return nil))
   		   ((< (length z) 1)
		       (soarwarn #+:TI "Soar-Bind: Wrong number of arguments to"
			                #-:TI "Bind: Wrong number of arguments to" z)
   		    (return nil))
		      ((not (symbolp var))
   		    (soarwarn #+:TI "Soar-Bind: illegal argument"
			                #-:TI "Bind: illegal argument" var)
   		    (return nil))
		      ((eqp (length z) 1)
		       (setf val (make-constant-symbol 's)) 
         )
  		    (t
         ;; Installed DSM change. -KAM 6/29/89.
         (setq val ($instantiate (car (cdr z))))
         ))                                     
  ;; put binding in *variable-memory*.
  (make-var-bind var val)
))

(defun halt ()
 ;; called from RHS.
 (cond ((not *in-rhs*)
        (soarwarn "Cannot be called at top level" 'halt))
       (T                           ;<== DSM
        (signal-halt) ))            ;<== DSM
)      

;;; Fixed a bug which caused incorrect return of the watch value. -BGM 3/21/88.

(eval-when (compile eval load) (proclaim '(special *dtrace* *otrace*)))

(defun nlam-watch (z) ; John.Laird 26-Mar-85 16:57 
       (cond ((equal z '(-1))
	      (setq *wtrace* nil)
	      (setq *ptrace* nil)
	      (setq *otrace* nil)
	      -1)
	     ((equal z '(0))
	      (setq *wtrace* nil)
	      (setq *ptrace* nil)
	      (setq *otrace* t)
	      0)
	     ((equal z '(.5))
	      (setq *wtrace* nil)
	      (setq *ptrace* t)
	      (setq *ttrace* nil)
	      (setq *otrace* t)
	      .5)
	     ((equal z '(1))
	      (setq *wtrace* nil)
	      (setq *ptrace* t)
	      (setq *ttrace* t)
	      (setq *otrace* t)
	      1)
	     ((equal z '(1.5))
	      (setq *wtrace* t)
	      (setq *ttrace* nil)
	      (setq *ptrace* t)
	      (setq *otrace* t)
	      1.5)
	     ((equal z '(2))
	      (setq *wtrace* t)
	      (setq *ttrace* t)
	      (setq *ptrace* t)
	      (setq *otrace* t)
	      2)
	     ((equal z '(3))
	      (setq *otrace* t)
	      (setq *wtrace* t)
	      (setq *ptrace* t)
	      '(2 -- conflict set trace not supported))
	     ((atom z)
	      (cond ((and (not *wtrace*) (not *ttrace*) (not *ptrace*) (not *otrace*)) -1)
		    ((and (not *wtrace*) (not *ptrace*) *otrace*) 0)
		    ((and (not *wtrace*) (not *ttrace*) *ptrace* *otrace*) .5)
		    ((and (not *wtrace*) *ttrace* *ptrace* *otrace*) 1)
		    ((and *wtrace* (not *ttrace*) *ptrace* *otrace*) 1.5)
		    ((and *wtrace* *ttrace* *ptrace* *otrace*) 2)
		    (t 'error-in-watch)))
	     (t 'what?)))

(defmacro label-bind (&rest z)
	  (list 'nlam-label-bind (list 'quote z)))

(defun nlam-label-bind (z) ; John.Laird 18-Jun-86 11:48 
  ;; Changed Soargensym to Soar-genid. -BGM 3/5/89
       (prog (val new-id)
	     (cond ((not *in-rhs*)
		    (soarwarn "Cannot be called at top level"
			      'label-bind)
		    (return nil))
		   ((< (length z) 2)
		    (soarwarn "Label-Bind: Wrong number of arguments to" z)
		    (return nil))
		   ((not (variablep-not-predicate (car z)))
		    (soarwarn "Label-Bind: illegal argument" (car z))
		    (return nil))
		   (t (setq val (cadr (eval-args z)))))
	     (cond ((not (symbolp val))
		    (soarwarn "Label-Bind: illegal argument" val)
		    (return nil))
		   ((soarassq val *label-bindings*)
		    (make-var-bind (car z)
				   (cdr (soarassq val *label-bindings*))))
		   (t
        (setf new-id (make-constant-symbol 'x))    ;<== DSM
		      (soarpush (cons val new-id)
				*label-bindings*)
		      (make-var-bind (car z)
				     new-id)))))

(defvar *soar-actions* '(#+:TI soar-bind #-:TI bind 
			       build call1 call2 cbind closefile1 default halt 
			       label-bind openfile1 tabstop tabto
			       write1 Write2)
  ;; Updated for TI. -BGM 3/27/89 
  "The names of all of the RHS soar actions.")


(defun initialize-rete-rhs ()
  (setq *in-rhs* nil)
  (setq *cycle-count* 0)
  (setq *label-bindings* nil)
  (setq *data-matched* nil)
 NIL)

(defun restart-rete-rhs ()
  (setq *brkrun* nil)
  (setq *critical* nil)
  (setq *in-rhs* nil)
  (setq *limit-cs* 1000000)
  (setq *limit-token* 1000000)
  (setq *remaining-cycles* 1000000)
  (setq *remaining-decide* 1000000)
  (setq *ttrace* nil)
  (setq *max-elaborations* 100)
  (watch 0)
  (setq *cycle-count* 0)
  (setq *label-bindings* nil)
  (setq *data-matched* nil)
 NIL)

;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/spo.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	Spo.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/rete/new/spo.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file contains the code for SPO, as the last version consed its little
;;; brains out and contained too much code.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Spo
;;;	II.	Compiled-spo
;;;	III.	Spo-symbols
;;;	IV.	Spo-ids
;;;	V.	Spo-id
;;;	VI.	Spo-wme
;;;	VII.	Spo-hash-wmes
;;;	VIII.	Spo-print-wmes
;;;	IX.	Spo-print-attributes-of-class-id
;;;	X.	Spop
;;;	XI.	Spo-Stringify-values
;;;	XII.	Spo-Stringify-value
;;;	XIII.	Initialize-rete-spo
;;;	XIV.	Restart-rete-spo
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")



;;;
;;;		I.	Spo
;;;

(defvar *spo-default-depth* 1 "The depth to which to print SPO objects out to.")

(defmacro spo (&rest ids-optional-number) 
  `(compiled-spo ',ids-optional-number :print-wmes t :print-preferences nil))



;;;
;;;		II.	Compiled-spo
;;;

(defvar *spod-already* nil
 "A list of symbols that have already been spo'd in the current call to spo.
  Each symbol as it is spo'd is also entered into the spo hash table, *spo-hash*,
  and later removed for constant time access.")

(defvar *spo-hash* (make-soar-hash-table)
  "A hash table that maps class id to a list of attribute.values for SPO printing.")

(defun compiled-spo (ids &key print-wmes print-preferences)
  (cond ((null ids) (setq ids *last-obj-id*))
	((not (numberp (car ids)))
	 (setq *last-arg* (setq *last-obj-id* (list (car ids))))))
  (let ((aborted-in-critical-segment t))
    ;; This let, unwind protect and setq catches aborts during printing.
    ;; The first pass hashes and the second pass unhashes. If the 
    ;; first or second pass are interrupted then the hash table is manually cleared.
   (unwind-protect 
       (let ((last (car (last ids))))
	 (cond ((and (integerp last) (>= last 0))
		(spo-symbols (nbutlast ids 1) last print-wmes print-preferences))
	       (t (spo-symbols ids *spo-default-depth* print-wmes print-preferences)))
	 (dolist (id *spod-already*) (soar-remhash *spo-hash* id))
	 (setq *spod-already* nil)
	 (setq aborted-in-critical-segment nil))
    (when aborted-in-critical-segment
      ;; I could run the entire set of wmes and clear each entry, but the simpler thing to do
      ;; is just to rebuild the hash table in its current size, and the garabage collector
      ;; clear up the old storage.
     (setq *spod-already* nil)
     (setq *spo-hash* (make-soar-hash-table (first (array-dimensions *spo-hash*)))))))
   nil)
  

;;;
;;;		III.	Spo-symbols
;;;
;;;	The old SPO treated (spo id 0) the same as (spo id 1), but this one will not.

(defun spo-symbols (symbols depth print-wmes print-preferences)
  (unless (zerop depth)
    (dolist (symbol symbols)
     (when (and (symbolp symbol) (get symbol 'wmpart*)) ;; I'm a symbol and I have wmes.
      (unless (soar-gethash *spo-hash* symbol)
	;; If symbol is in the *spo-hash* then it is on *spo-already* and has already
        ;; been printed and so should not be printed again.
	(spo-id symbol depth 0 print-wmes print-preferences))))))


;;;
;;;		IV.	Spo-ids
;;;
;;; This is just like spo-symbols, except the input is a list of symbols that
;;; are guarenteed to have wmes.
;;;

(defun spo-ids (ids depth indent print-wmes print-preferences)
  (unless (zerop depth)
    (dolist (id ids) 
      (unless (soar-gethash *spo-hash* id)
	(spo-id id depth indent print-wmes print-preferences)))))



;;;
;;;		V.	Spo-id
;;;
;;;	Check that the entered symbol is an id symbol and if so
;;; collects its wmes and print them.
;;;

(defun spo-id (id depth indent print-wmes print-preferences)
  (let ((wmpart* (get id 'wmpart*)))
    (when wmpart*
      ;; Mark symbol as already having been spo'd in the hash table,
      ;; and put it on the *spod-already* list so that it is correctly cleared.
      (soar-puthash *spo-hash* t id)
      (get-push id *spod-already*)
      (spo-wmes-and-or-preferences wmpart* depth indent t print-wmes print-preferences))))



;;;
;;;		VI.	Spo-wme-and-or-preferences
;;;
;;;	This one is unwind-protected so that it can be called 
;;; directly from SPPWM, with only some of the total set of wmes.

(defvar *spo-spaces-per-recursion* 3
 "The number of spaces to indent SPO printing on each recurse of SPO.")

(defun spo-wmes-and-or-preferences (wmes depth indent timetags print-wmes print-preferences)
  (let ((value-outputs (spo-hash-wmes-and-find-outputs wmes depth timetags print-wmes print-preferences)))
    (spo-print-wmes-and-or-preferences wmes indent timetags print-wmes print-preferences)
    (spo-ids value-outputs (1- depth) (+ indent *spo-spaces-per-recursion*) print-wmes print-preferences)
    (dispose-list value-outputs)))



;;;
;;;		VII.	Spo-hash-wmes-and-find-outputs
;;;

(defmacro spo-remember-output (value)
 `(when (and (symbolp ,value) 
	     (get ,value 'wmpart*) ; I'm an id of some wmes,
	     (not (soar-gethash *spo-hash* ,value)) ; but I have yet to be printed.
	     ;; Do the hashtable check here and later as the id may be hit elsewhere
	     ;; down an earlier print path.
	     )
	;; O(n)^2 operation, for small n, can this be removed ? 
	;; One way is to keepa hash table entry for it. Hmm not a bad idea.
	;; Branching factor here could easily be O(10^2), but mostly is tiny.
	;; Or, I could just let the duplicated appear and have the hash table
	;; printing filter them out.
    (push ,value value-outputs)))

(defun spo-hash-wmes-and-find-outputs (wmes depth timetag print-wmes print-preferences)
  ;;; Modified to recurse through attributes. -BGM 2/22/89
  (let ((value-outputs nil))
    (dolist (wme wmes value-outputs)
      (let* ((wme (if timetag (car wme) wme))
	     ; If the list is of the form wme.timetag, strip off the tag.
	     (class (wme-class wme))
	     (id (wme-id wme))
	     (attribute (wme-attribute wme))
	     (value     (wme-value wme))
	     (type      (wme-type wme))
	     (reference (wme-reference wme)))
	(cond (type ;; I have a preference.
		(when print-preferences
		  (unless (soar-gethash *spo-hash* class id attribute)
		    (soar-pushhash *spo-hash* attribute class id))
		  (soar-pushhash *spo-hash* (get-list value type reference)
				 class id attribute)
		  (when (> depth 0) 
		    (spo-remember-output attribute)
		    (spo-remember-output value)
		    (spo-remember-output reference))))
	      (print-wmes ;; I have a normal wme, and I want to hash it.
		(unless (soar-gethash *spo-hash* class id attribute)
		  (soar-pushhash *spo-hash* attribute class id))
		(soar-pushhash *spo-hash* value class id attribute)
		(when (> depth 0) (spo-remember-output value)))
	      (print-preferences
		;; I have a normal wme, and I want to recurse through it,
		;; as I'm only printing preferences.
		  (when (> depth 0) 
		    (spo-remember-output attribute)
		    (spo-remember-output value))))))))


;;;
;;;		VIII.	Spo-print-wmes-and-or-preferences
;;;

(defun spo-print-wmes-and-or-preferences (wmes indent timetags print-wmes print-preferences)
   (declare (ignore print-wmes print-preferences))
  (dolist (wme wmes)
   (let* ((wme (if timetags (car wme) wme))
	  (class (wme-class wme)))
     (cond 
	   (  t
	     (let ((id (wme-id wme)))
	       (multiple-value-bind
		 (attributes found) (soar-remhash *spo-hash* class id)
		 (when found ; Only print the wmes the first time that one is found.
		   (soar-format *trace-file* "~%")
		   (soar-nspaces indent *trace-file*)
		   (soar-format *trace-file* "(~A ~A" class id)
		   (spo-print-attributes-of-class-id class id attributes)
		   (soar-format *trace-file* ")")
		   (dispose-list attributes)))))))))



;;;
;;;		IX.	Spo-print-attributes-of-class-id
;;;

(defun spo-print-attributes-of-class-id (class id attributes)
  (let ((attribute-tab (soar-line-position)))
    ;; Use a do instead of a dolist so that I can tell if I'm the last attribute out
    ;; and so I can leave space for the last parenthesis if at all possible.
    (do* ((attributes-p attributes (cdr attributes-p))
	  (attribute   (car attributes-p) (car attributes-p)))
	 ((null attributes-p))
     (let ((string-attribute (format nil " ^~A" attribute))
	   (soar-line-position (soar-line-position)))
       (multiple-value-bind (values length)
	 (spo-stringify-values *spo-hash* class id attribute string-attribute)
	 (unless (= soar-line-position attribute-tab)
	  ;; You can't do any better by printing a CRLF it you're the minimal distance out.
	  (when (> (+ (soar-line-position) length (if (null (cdr attributes-p)) 1 0))
		   (soar-line-length))
	   (soar-format *trace-file* "~%")
	   (soar-nspaces attribute-tab *trace-file*)))
	 (wrapping-soar-format *trace-file* attribute-tab "~A" string-attribute)
	 (let ((value-tab (soar-line-position)))
	   (dolist (value values)
	     (wrapping-soar-format *trace-file* value-tab "~A" value)))
	   (dispose-list values))))))

;;;
;;;		X.	Spop
;;;

(defmacro spop (&rest ids)
  ;; Moved here and rebuilt using compiled-spo. -BGM 1/18/89
  ;; Moved here and updated.-BGM 1/15/89
  ;;  Does this want to be DFSing through only preferences or through
  ;; augmentations and preferences but only printing preferences ? 
  `(compiled-spo ',ids :print-preferences t :print-wmes nil))



;;;
;;;		XI.	Spo-Stringify-values
;;;

(defun spo-stringify-values (soar-hash class id attribute string-attribute)
  (let ((collection ())
	(sum (length string-attribute))
	(values (nreverse (soar-remhash soar-hash class id attribute))))
    (do* ((valuesp values        (cdr valuesp))
	  (value   (car valuesp) (car valuesp)))
	((null valuesp))
      (let ((string-value (spo-stringify-value value (cdr valuesp))))
	(push string-value collection)
	(incf sum (length string-value))))
    (dispose-list values)
    (values (nreverse collection) sum)))


;;;
;;;		XII.	spo-Stringify-value
;;;
 


(defun spo-stringify-value (value more-values-to-come)
  ;; Patched (if (listp value) ..) so it doesn't print NIL NIL for nil values.
  ;; BGM 2/12/89
  (if (and value (listp value) )
      ;; DSM preference (value type reference) holder.
      (let ((v         (nth 0 value))
            (type      (nth 1 value))
            (reference (nth 2 value)))
        (dispose-list value)
        (if reference
               ;; Turned ~A into ~S so RHS strings print properly. -BGM 8/16/89
            (format nil " ~S ~A ~A" v type reference)
          ;; If the preference symbol is binary, and there is not reference,
          ;;but there is a following value, insert a comma to disambiguate that
          ;;the preference has been forced to be unary.
          (if (and (member type *binary-preferences*) more-values-to-come)
              ;; Turned ~A into ~S so RHS strings print properly. -BGM 8/16/89
            (format nil " ~S ~A," v type)
              ;; Turned ~A into ~S so RHS strings print properly. -RBD 4/19/91
            (format nil " ~S ~A"  v type)
          )))
    ;; Turned ~A into ~S so RHS strings print properly. -RBD 4/19/91
    (format nil " ~S" value)
  )
)



;;;
;;;		XIII.	Initialize-rete-spo
;;;

(defun initialize-rete-spo ()
 NIL)


;;;
;;;		XIV.	Restart-rete-spo
;;;

(defun restart-rete-spo ()
  (setq *spo-default-depth* 1)
  (setq *last-obj-id* nil)
  
  NIL)

;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/newpm.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	fileheader.text
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/rete/new/newpm.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file, newpm.lisp, replaces the old PM module in Soar.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	Lacunae
;;;	?.	PM and SPM spacing constants
;;;	?.	PM
;;;	?.	compiled-pm
;;;	?.	pm-pname
;;;	?.	do-lhs
;;;	?.	conjunctive-ce-p
;;;	?.	pm-lhs
;;;	?.	pm-lhs-ce
;;;	?.	
;;;	?.	
;;;	?.	  pm-lhs-positive-ce
;;;	?.	coerce-list-of-strings-to-string
;;;	?.	pm-lhs-conjunctive-test
;;;	?.	pm-lhs-conjunctive-test-to-list-of-strings
;;;	?.	pm-rhs
;;;	?.	pm-rhs-action
;;;	?.	
;;;	?.	
;;;	?.	spm
;;;	?.	compiled-spm
;;;	?.	spm-pname
;;;	?.	spm-rhs
;;;	?.	spm-rhs-hash-rhs
;;;	?.	spm-rhs-print-rhs
;;;	?.	spm-rhs-print-attributes
;;;	?.	
;;;	?.	spm-lhs
;;;	?.	spm-lhs-hash-lhs
;;;	?.	spm-lhs-hash-ce
;;;	?.	spm-lhs-print-lhs
;;;	?.	spm-lhs-print-ce
;;;	?.	spm-lhs-print-attributes
;;;	?.	spm-lhs-print-attribute-value-tests
;;;	?.	Spm-stringify-tests
;;;	?.	Smatches
;;;	?.	Full-matches
;;;	?.	Memories
;;;	?.	PI
;;;	?.	Excise
;;;	?.	Pbreak & Unpbreak
;;;	?.	Ptrace & Unptrace
;;;	?.	Ptrace-item-p
;;;	?.	Pfired
;;;	?.	Initialize-rete-newpm
;;;	?.	Restart-rete-newpm
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")

;;;
;;;		iv.	Lacunae
;;;
;;; Nreverse's may cause cons losses if they occur before dispose-lists.
;;;
;;; { <> Undecided } printing should be turned off for GOALx{Problem-space,state,operator}
;;; wmes in both PM and SPM, and this should be placed on a parameter.
;;;
;;; Partially converted for DSM with one confusion. 



;;;
;;;		?.	PM and SPM spacing variables.
;;;

(eval-when (eval load compile)
 (defparameter *pm-and-spm-spaces-before-closing-paren* 1
   "The number of spaces to print before the closing parenthesis, if the previous line wraps.")

 (defparameter  *pm-and-spm-spaces-before-a-ce-and-make* 3
   "The number of spaces that are printed before a CE and a make and action in both PM and SPM.")

 (defparameter  *pm-spaces-before-type* *pm-and-spm-spaces-before-a-ce-and-make*
   "The number of spaces to print before the type keyword, if the previous line wraps for PM.")
 
 (defparameter  *pm-spaces-before-id-test* (+ *pm-and-spm-spaces-before-a-ce-and-make* 2)
   "The number of spaces to print before an id test in a PM's LHS's CE, if the previous line wraps.")

 (defparameter  *pm-spaces-before-ce-closing-paren* (1+ *pm-and-spm-spaces-before-a-ce-and-make*)
   "The number of spaces to print before the closing parenthesis in a PM's LHS's CE, if the previous line wraps.")

 (defparameter  *pm-spaces-before-make-closing-paren* *pm-and-spm-spaces-before-a-ce-and-make*
  "The number of spaces to print before the closing parenthesis in a PM's RHS's make, if the previous line wraps.")

 (defparameter  *spm-spaces-before-type* (1+ *pm-and-spm-spaces-before-a-ce-and-make*)
   "The number of spaces to print before the type keyword, if the previous line wraps for SPM.")

 (defparameter  *spm-spaces-before-id-test* (+ *pm-and-spm-spaces-before-a-ce-and-make* 2)
  "The number of spaces to print before an id test in a SPM's LHS's CE, if the previous line wraps.")

 (defparameter  *spm-spaces-before-make-closing-paren* (1+ *pm-and-spm-spaces-before-a-ce-and-make*)
  "The number of spaces to print before the closing parenthesis in a PM's RHS's make, if the previous line wraps.")

 (defparameter  *spm-spaces-before-ce-closing-paren* (1+ *pm-and-spm-spaces-before-a-ce-and-make*)
  "The number of spaces to print before the closing parenthesis in a SPM's LHS's CE, if the previous line wraps.")

)



;;;
;;;		?.	pm
;;;

(defmacro pm (&rest pnames)
  ;; Rewrote SPM and PM to get rid of a bug. -BGM 10/13/88.
 `(compiled-pm ',pnames))



;;;
;;;		?.	compiled-pm
;;;

(defvar  *last-pname* () "The last pname entered into a pm function.")

(defun compiled-pm (pnames)
  ;; Calls to pm expand into calls to this function, which loops across all
  ;; of the argument pnames and calls pm-pname to actually print them. -BGM 10/13/88.
   (if pnames 
     (setq *last-arg* (setq *last-pname* (list (car pnames))))
     ; Remember the last argument and pname to be passed into a user interface function.
     (setq pnames *last-pname*) 
     ; By default call SPM on the last pname to be passed into a user interface function.
     )
   (dolist (pname pnames) (pm-pname pname))
   nil)



;;;
;;;		?.	pm-pname
;;;


(defun pm-pname (pname)
 ;; Removed references to p-type 3/30/90 GAP
;; These patches are in reference to BUG 01Mar90-12.56.58
 ;; Modified to pay attention to print case and vertical barring. -BGM 2/6/89
 ;; This routine, called from compiled-pm, takes a pname, looks up it's P
 ;; record on its P property and dispatches to a set of routines that print
 ;; the different parts of the production. -BGM 10/13/88
  (let ((p   (get-p pname)))
    (when p
     (let* ((pbody (p-production p))
	    (lhs   (get-sp-lhs pbody))
	    (rhs   (get-sp-rhs pbody)))
       (soar-format *trace-file* "~%(~A ~S" 'p pname)
       (pm-lhs lhs)
       (soar-format *trace-file* "~% -->")
       (pm-rhs rhs)
       (wrapping-soar-format *trace-file* *pm-and-spm-spaces-before-closing-paren* ")~%")))))



;;;
;;;		?.	Conjunctive-ce-p
;;;

(defun conjunctive-ce-p (ce)
  ;; This routine tests to see if a ce is conjunctive.
  ;; A conjunctive CE is represented internally as a list of CEs.
  ;; Since classes could be a conjunctive test you must test that
  ;; the first CE (which in the final reordering will not be negated)
  ;; is not a conjunctive test. A conjunctive test is represented as
  ;; as a list whose car will be one of {, <<, <, >, <>, <=>, <=, >=.
  (or (eq (car ce) '-)
      (and (listp (car ce))
	   (not (member (caar ce) '({ << < > <= >= <=>) :test #'eq)))))
       




;;;
;;;		?.	do-lhs
;;;
;;;	Do-lhs is a macro that iterates across the condition elements of a LHS. 
;;; It maps CE through the condition elements of the LHS. 
;;;
;;; If the top of CE is '-, signalling a negated condition, it sets negated
;;; to '- and assumes that the next thing is not another -. 
;;; 
;;; For each conjunctive CE, when scope is provided, it binds scope to a unique
;;; scoping number for that conjunctive CE.
;;;
;;; If the ce is a conjunctive ce, see conjunctive-ce-p, then it lambda binds
;;; depth to (1- depth), and then iterates ce through the elements of CE
;;; (negated is not set to true inside of conjunctive ces unless individual ce is
;;; is negated).
;;;
;;; When it iterates through a conjunctive ce, it binds first-ce-in-conjunction-p,
;;; to T for the first CE. It also executes a form before and after entering each
;;; conjunctive CE. 
;;;

(defmacro do-lhs ((ce lhs &optional &key
		      (negated nil negated-p)
		      (first-ce-in-conjunction-p nil first-ce-in-conjunction-p-p)
		      (depth nil depth-p)
		      (scope nil scope-p)
		      before-conjunction
		      after-conjunction)
		  &body body)
  (let ((ce-ptr (gentemp "CE-PTR"))
	(lhs-ptr (gentemp "LHS-PTR"))
	(do-lhs  (gentemp "DO-LHS"))
	(in-conjunction-p (gentemp "IN-CONJUNCTION-P"))
	(global-scope (gentemp "GLOBAL-SCOPE")))
    ;; I broke down and used a labels here, as it is very convenient in this lambda,
    ;; but the symbolics and TI will run this slowly. 
    `(let (,@(when scope-p (list (list global-scope 0))))
	  (labels ((,do-lhs (,lhs-ptr ,@(when first-ce-in-conjunction-p-p (list in-conjunction-p))
				      ,@(when depth-p (list depth))
				      ,@(when scope-p (list scope)))
 		    (do* ((,ce-ptr ,lhs-ptr (cdr ,ce-ptr))
			  (,ce     (car ,ce-ptr) (car ,ce-ptr))
			  ,@(when negated-p (list (list negated nil nil)))
			  ,@(when first-ce-in-conjunction-p-p 
				  (list (list first-ce-in-conjunction-p in-conjunction-p nil))))
			 ((null ,ce-ptr))
			 (when (eq '- ,ce) 
			   ,(if negated-p `(setq negated (pop ,ce-ptr)) `(pop ,ce-ptr))
			   (setq ,ce (car ,ce-ptr)))
			 (cond ((conjunctive-ce-p ,ce)
				,before-conjunction
				(,do-lhs ,ce 
					 ,@(when first-ce-in-conjunction-p-p (list t))
					 ,@(when depth-p (list `(1+ ,depth)))
					 ,@(when scope-p 
						 (list `(incf ,global-scope)))
					 )
				,after-conjunction)
			       (t ,@body)))))
		  (,do-lhs ,lhs ,@(when first-ce-in-conjunction-p-p (list nil))
			   ,@(when depth-p (list 0))
			   ,@(when scope-p (list global-scope)))))))



;;;
;;;		?.	pm-lhs
;;;

(defun pm-lhs (lhs)
 (do-lhs (ce lhs 
	     :negated negated
	     :first-ce-in-conjunction-p first-ce-in-conjunction-p
	     :before-conjunction
	     (block nil
	       (soar-format *trace-file* "~%")
	       (soar-nspaces (+ *pm-and-spm-spaces-before-a-ce-and-make* -2 (* depth 2)) *trace-file*)
	       (if negated (soar-format *trace-file* "-{") (soar-format *trace-file* " {"))
	       )
	     :depth depth
	     :after-conjunction
	     (wrapping-soar-format *trace-file* (+ *pm-and-spm-spaces-before-a-ce-and-make* (* depth 2)) "}")
	     )
  (pm-lhs-ce negated ce (not first-ce-in-conjunction-p)
	 (if (zerop depth) 0 (* 2 (1- depth))))))
	     

;;;
;;;		?.	pm-lhs-ce
;;;

(defun pm-lhs-ce (negated ce print-spaces offset)
 ;; This routine dispatches between preference CE's and non-preference CEs
 ;; for pm-lhs.
 (when print-spaces
  (soar-format *trace-file* "~%")
  (cond (negated 
	  (soar-nspaces (+ *pm-and-spm-spaces-before-a-ce-and-make* -2 offset) *trace-file*))
	(t (soar-nspaces (+ *pm-and-spm-spaces-before-a-ce-and-make* offset) *trace-file*))))
 (when negated (soar-format *trace-file* "- "))
 ;; The reorderer will indeed put a negated CE first under some cases, so you
 ;; have to be prepared to print the "- " even if you're not printing spaces. -BGM 1/27/89
  (pm-lhs-positive-ce ce offset))


;;;
;;;		?.	pm-lhs-preference-ce
;;;
;;;	This could do with the wrapping ")" paren bug fix.



;;;
;;;		?.	pm-lhs-preference-ce-attribute
;;;
;;;



;;;
;;;		?.	  pm-lhs-positive-ce 
;;;

(defun   pm-lhs-positive-ce (ce offset)
 ;; This routine takes a condition element, and a flag that denotes negation,
 ;; and prints that condition element directly and using
 ;; pm-lhs-conjunctive-test. -BGM 10/13/88
 (let* ((length    (length ce))
	(class     (first ce))
	(id        (second ce))
	(attribute (if (> length 2) (third ce) '*unbound*))
	;; Atributes are optional, so use *unbound* to signal this.
	(value     (if (> length 3) (fourth ce) '*unbound*))
	;; Values are optional, so use *unbound* to signal this.
  (type      (fifth ce))
	)
  (when type 
	 (unless (eq type '+) 
	   (error "Attempt to print a CE with a type field of other than +.")))
 (soar-format *trace-file* "(~A" (pm-lhs-conjunctive-test class))
 (let ((tab (soar-line-position)))
   (unless (eq id '*unbound*)
    (wrapping-soar-format *trace-file* (+ *pm-spaces-before-id-test* offset) " ~A" (pm-lhs-conjunctive-test id)))
   (unless (eq attribute '*unbound*)
    (if (eq value '*unbound*)
     (wrapping-soar-format *trace-file* tab " ^~A" (pm-lhs-conjunctive-test attribute))
     (if type 
      (wrapping-soar-format *trace-file* tab " ^~A ~A +" 
	(pm-lhs-conjunctive-test attribute) (pm-lhs-conjunctive-test value))
      (wrapping-soar-format *trace-file* tab " ^~A ~A" 
	(pm-lhs-conjunctive-test attribute) 
	(pm-lhs-conjunctive-test value))))))
 (wrapping-soar-format *trace-file* (+ *pm-spaces-before-ce-closing-paren* offset) ")")))



;;;
;;;		?.	coerce-list-of-strings-to-string
;;;

(defun coerce-list-of-strings-to-string (list-of-strings)
  ;; This routine coerces a list of strings into a single string
  ;; in an efficient manner. -BGM 10/28/88.
  (let ((result-string 
	  (make-string 
	    (let ((sum 0)) 
	      (dolist (string list-of-strings) (incf sum (length string))) 
	      sum))))
    (let ((current-position 0))
      (dolist (string list-of-strings)
	(let ((next-position (+ current-position (length string))))
         (replace result-string string :start1 current-position :end1 next-position)
	 (setq current-position next-position))))
    result-string))



;;;
;;;		?.	pm-lhs-conjunctive-test
;;;

(defun pm-lhs-conjunctive-test (conjunctive-test)
 ;; This routine prints out possibly conjunctive tests, for PM, to a string. 
 ;; The results are collected into a string instead of printed out incrementally
 ;; to allow more graceful line breaking.-BGM 10/13/88
 (coerce-list-of-strings-to-string (pm-lhs-conjunctive-test-to-list-of-strings conjunctive-test)))



;;;
;;;		?.	pm-lhs-conjunctive-test-to-list-of-strings
;;;
 

(defun pm-lhs-conjunctive-test-to-list-of-strings (conjunctive-test)
  ;; Modified to not goof up and reverse some lists. -BGM 8/17/89
  ;; Modified to print { <> UNDECIDED ... } as ... or { ... }. -BGM 8/17/89
 (cond ((null conjunctive-test) (list "NIL"))
       ((listp conjunctive-test)
	(cond ((and (eq (first conjunctive-test) '{)
		    (eq (second conjunctive-test) '<>)
		    (eq (third conjunctive-test) 'UNDECIDED))
		 (if (still-conjunctive-test-after-removing-<>-undecided conjunctive-test)
		     (pm-lhs-conjunctive-test-to-list-of-strings (cons '{ (nthcdr 3 conjunctive-test)))
		     (pm-lhs-conjunctive-test-to-list-of-strings (butlast (nthcdr 3 conjunctive-test) 1))))
	      (t (do ((result-list nil)
		      (subtestp conjunctive-test (cdr subtestp)))
		     ((null subtestp) result-list)
		   (setq result-list 
			 (nconc result-list
				(pm-lhs-conjunctive-test-to-list-of-strings (car subtestp))
				(when (cdr subtestp) (list " "))))))))
       ((stringp conjunctive-test) (list (format nil "~S" conjunctive-test)))
       (t (list (format nil "~A" conjunctive-test)))))


;;;
;;;		?.	Still-conjunctive-test-after-removing-<>-undecided
;;;
;;; This routine counts the number of disjunctive tests in a conjunctive-test
;;; (without its '{) and returns T if they are more than one. Each explicitly 
;;; disjunctive test is counted as only 1 test (i.e., << a b c>> is one test).


(defun still-conjunctive-test-after-removing-<>-undecided (conjunctive-test)
  (let ((number-of-disjunctive-tests 0))
    (let ((inside-disjunctive-test nil))
      (dolist (conjunctive-test-element (nthcdr 3 conjunctive-test))
	(case conjunctive-test-element
	  (<< (setq inside-disjunctive-test t))
	  (>>  (setq inside-disjunctive-test t) (incf number-of-disjunctive-tests))
	  (otherwise 
	    (unless inside-disjunctive-test
	      (unless (predicatep conjunctive-test-element)
		(unless (eq conjunctive-test-element '})
		   (incf number-of-disjunctive-tests))))))))
    (> number-of-disjunctive-tests 1)))



;;;
;;;		?.	pm-rhs
;;;

(defun pm-rhs (rhs) 
 ;; This routine takes a RHS, which is a list of actions, and
 ;; prints them by calling pm-rhs-action. -BGM 10/13/88
 (dolist (action rhs) (pm-rhs-action action)))



;;;
;;;		?.	pm-rhs-action
;;;

(defun pm-rhs-action (action)
 ;; Modified to pay attention to :downcase *print-case* printing. -BGM 2/6/89
 ;; This routine takes a RHS action and prints it out for PM. -BGM 10/13/88
  (cond ((and (listp action) (eq (first action) 'make))
	 (cond 
	   (t (soar-format *trace-file* "~%")
	      (soar-nspaces *pm-and-spm-spaces-before-a-ce-and-make* *trace-file*)
	      (let ((class     (second action))
		    (id    (third action))
		    (attribute (fourth action))
		    (value     (fifth action))
	      (type      (sixth action))
	      (reference (seventh action))
	      )
	      (soar-format *trace-file* "(~A ~A" 'make class)
	      (let ((tab (soar-line-position)))
		(wrapping-soar-format *trace-file* tab   " ~A" id)
		(if type 
                  (if reference 
		      (wrapping-soar-format *trace-file* tab " ^~A ~S ~A ~A)"
					    attribute value type reference)
		      (wrapping-soar-format *trace-file* tab " ^~A ~S)" 
					    attribute value type))
		  (wrapping-soar-format *trace-file* tab " ^~A ~S)" attribute value)))))))
	(t (soar-format *trace-file* "~%")
	   (soar-nspaces *pm-and-spm-spaces-before-a-ce-and-make* *trace-file*)
	   (soar-format *trace-file* "~S" action))))



;;;
;;;		?.	pm-rhs-preference-make
;;;
;;; This could do with the wrapping ")" bug fix.



;;;
;;;		?.	pm-rhs-preference-value
;;;



;;;
;;;		?.	spm
;;;

(defmacro spm (&rest pnames)
  ;; Rewrote SPM and PM to get rid of a bug. -BGM 10/13/88.
 `(compiled-spm ',pnames))



;;;
;;;		?.	compiled-spm
;;;

(defun compiled-spm (pnames)
  ;; Calls to spm expand into calls to this function, which loops across all
  ;; of the argument pnames and calls spm-pname to actually print them. -BGM 10/13/88.
  (if pnames 
      (setq *last-arg* (setq *last-pname* (list (car pnames))))
    ; Remember the last argument and pname to be passed into a user interface function.
    (setq pnames *last-pname*) 
    ; By default call SPM on the last pname to be passed into a user interface function.
    )
   (dolist (pname pnames) (spm-pname pname))
  nil)



;;;
;;;		?.	spm-pname
;;;



(defun spm-pname (pname)
 ;; This routine, called from compiled-spm, takes a pname, looks up it's P
 ;; record on its P property and dispatches to a set of routines that print
 ;; the different parts of the production. -BGM 10/13/88
 ;; Removed references to p-type 3/30/90 GAP
 ;; These patches are in reference to BUG 01Mar90-12.56.58
 ;; Fixed bug where a delcared production but not specified production caused 
 ;;   memory access problems. Bug # 07Mar90-16.07.00  GAP 16-Apr-90
  (let ((p   (get-p pname)))
    (if p
      (let ((pbody (p-production p)))   ; GAP 16-apr-90
         (if pbody
           (let* ((lhs   (get-sp-lhs pbody))
                  (rhs   (get-sp-rhs pbody)))
             (soar-format *trace-file* "~%(~A ~S" 'sp pname)
             (spm-lhs lhs)
             (spm-rhs rhs)
             (wrapping-soar-format *trace-file* 
                                   *pm-and-spm-spaces-before-closing-paren* ")~%"))
           ;else pbody does not exist
             (soar-format *trace-file* "~% ~A has been declared a production name, but the production ~
                                        does not exist" pname))) 
     ; else p does not exist
        (soar-format *trace-file* "~% ~A is not the name of a production" pname)))
)



;;;
;;;		?.	spm-rhs
;;;

(defvar  *spm-rhs-hash* (make-soar-hash-table)
 "A hash table that maps RHS make action's ID's to an assoc list keyed on class,
  to an assoc list keyed on attribute and finally a RHS make value.")

(defun spm-rhs (rhs)
  ;; Spm-rhs prints out the RHS of a preparsed P style production in the SP format.
  ;; This means that makes are printed without the make classes.
  ;; This is a very common operation and was very slow in Soar 4.4, so some
  ;; care has been taken to optimize this.
  ;; The algorithm is two pass:
  ;; First pass, walk the makes hashing normal makes, ignoring preference makes.
  ;; The hashing hashes id's (:test #'eq) to nested assoc lists of Class, Attribute and test.
  ;; The second pass walks the list again, as soon as it sees a make for any CAT bucket, it prints
  ;; all of the tests in that class and removes them from the bucket. If it can not find a test
  ;; it does not print it, as it has alread been printed.
  ;; This conses in proportion to the SP printed.
  (let ((aborted-in-critical-segment t))
    ;; This let, unwind protect and setq catches aborts during printing.
    ;; The first pass hashes and the second pass unhashes. If the 
    ;; first or second pass are interrupted then the hash table is manually cleared.
   (unwind-protect 
    (progn
      (spm-rhs-hash-rhs  rhs)
      (spm-rhs-print-rhs rhs)
      (setq aborted-in-critical-segment nil))
    (when aborted-in-critical-segment
      ;; I could run the entire RHS and clear each entry, but the simpler thing to do
      ;; is just to rebuild the hash table in its current size, and the garabage collector
      ;; clear up the old storage.
     (setq *spm-rhs-hash* 
	   (make-soar-hash-table :size
	     (first (array-dimensions (internal-soar-hash-table-array *spm-rhs-hash*)))))))))


;;;
;;;		?.	spm-rhs-hash-rhs
;;;

(defun spm-rhs-hash-rhs (rhs) 
  ;; This routine is the first pass of the two pass SPM RHS printer.
  ;; It takes a P ified RHS from spm-rhs and walks through it
  ;; building the hashtable entries for each non preference make.
  (dolist (action rhs)
    (when (eq (car action)   'make-preference) 
      (let ((class (second action)))
        (unless   NIL
	  (let* ((id        (third  action))
		 (attribute (fourth action))
		 (value     (fifth  action))
	   (type      (sixth  action))
	   (reference (seventh action))
	         )
	    ;; Maintain a list of the attributes found for class/id,
	    ;; but only store each attribute once.
	    (unless (soar-gethash *spm-rhs-hash* class id attribute)
	     (soar-pushhash *spm-rhs-hash* attribute class id))
	    ;; Add to each class/id/attribute, the list of its values.
	    ;; For DSM store value/type/reference as a list.
	    (soar-pushhash *spm-rhs-hash* 
			   (if type (get-list value type reference) value)
			  class id attribute)))))))


;;;
;;;		?.	spm-rhs-print-rhs
;;;

(defun spm-rhs-print-rhs (rhs)
  ;; This routine is the second pass of SPM RHS printing and is called from spm-rhs.
 (soar-format *trace-file* "~% -->")
 (dolist (action rhs)
  (cond ((eq (car action)   'make-preference)
	 (let ((class (second action)))
	   (cond 
	     (t (let* ((id        (third  action)))
		  (multiple-value-bind (attributes found-attributes) 
				       (soar-remhash *spm-rhs-hash* class id)
		        ;; Fetch the class.attribute bucket and then delete it.
		       (when found-attributes
			(spm-rhs-print-attributes-of-class-id class id attributes)
			(dispose-list attributes))))))))
	  (t 
	    (soar-format *trace-file* "~%")
	    (soar-nspaces *pm-and-spm-spaces-before-a-ce-and-make* *trace-file*)
	    (soar-format *trace-file* "~S" action)))))



;;;
;;;		?.	spm-rhs-print-attributes-of-class-id
;;;

(defun spm-rhs-print-attributes-of-class-id (class id attributes)
  ;; This routine prints a attribute.values from the rhs hash table for spm-rhs-print.
  ;; It prints out something of the form (class id ^att1 v0 v1 ... ^att2 vn ... vm ...).
  (soar-format *trace-file* "~%")
  (soar-nspaces *pm-and-spm-spaces-before-a-ce-and-make* *trace-file*)
  (soar-format *trace-file* "(~A ~A" class id)
  (let ((attribute-tab (soar-line-position)))
    ;; Use a do instead of a dolist so that I can tell if I'm the last attribute out
    ;; and so I can leave space for the last parenthesis if at all possible.
    (do* ((attributes-p (nreverse attributes) (cdr attributes-p))
	  (attribute   (car attributes-p) (car attributes-p)))
	 ((null attributes-p))
     (let ((string-attribute (format nil " ^~A" attribute))
	   (soar-line-position (soar-line-position)))
       (multiple-value-bind (values length)
	 (spo-stringify-values *spm-rhs-hash* class id attribute string-attribute)
	 (unless (= soar-line-position attribute-tab)
	  ;; You can't do any better by printing a CRLF it you're the minimal distance out.
	  (when (> (+ (soar-line-position) length (if (null (cdr attributes-p)) 1 0))
		   (soar-line-length))
	   (soar-format *trace-file* "~%")
	   (soar-nspaces attribute-tab *trace-file*)))
	 (wrapping-soar-format *trace-file* attribute-tab "~A" string-attribute)
	 (let ((value-tab (soar-line-position)))
	   (dolist (value values)
	     (wrapping-soar-format *trace-file* value-tab "~A" value)))))))
  (wrapping-soar-format *trace-file* *spm-spaces-before-make-closing-paren* ")"))



;;;
;;;		?.	
;;;



;;;
;;;		?.	spm-lhs
;;;

(defvar *spm-lhs-hash* (make-soar-hash-table :test #'equal)
 ;; Changed to use equal on 3/24/89. -BGM
 ;; This could be a bit faster than equal, but I don't have the time to use a better test.
 "A soar hash table that maps 
     depth/class/id/(nil or -) to a list of the attribute tests that follow them and
     depth/class/id/(nil or -)/attribute to the list value tests that follow them.")

(defun spm-lhs (lhs)
  ;; This routine, called from spm-pname, prints out the LHS of a preparsed P format 
  ;; rule in SP format.
  ;; This is a very common operation and was very slow in Soar 4.4, so some
  ;; care has been taken to optimize this.
  ;; The algorithm is two pass, just like for the RHS.
  ;; First pass, walk the CEs hashing normal makes, ignoring preference CEs.
  ;; The hashing hashes id tests (:test #'equal) to nested assoc lists of 
  ;; Class test, Attribute test, to a cons whose car holds the positive value tests
  ;; and whose cdr holds the negative value tests.
  ;; The second pass walks the list again, as soon as it sees a CE for any bucket, it prints
  ;; all of the tests of that class in that bucket and removes them from the table.
  ;; If it can not find a test, it does not print it, as it must have already been printed.
  ;; This conses in proportion to the SP LHS printed.
  (let ((aborted-in-critical-segment t))
    ;; This let, unwind protect and setq catches aborts during printing.
    ;; The first pass hashes and the second pass unhashes. If the 
    ;; first or second pass are interrupted then the hash table is manually cleared.
   (unwind-protect 
    (progn
      (spm-lhs-hash-lhs  lhs)
      (spm-lhs-print-lhs lhs)
      (setq aborted-in-critical-segment nil))
    (when aborted-in-critical-segment
      ;; I could run the entire LHS and clear each entry, but the simpler thing to do
      ;; is just to rebuild the hash table in its current size, and the garabage collector
      ;; clear up the old storage.
     (setq *spm-lhs-hash*
	   (make-soar-hash-table 
	     :size (first (array-dimensions (internal-soar-hash-table-array *spm-lhs-hash*)))
	     :test #'equal))))))


;;;
;;;		?.	spm-lhs-hash-lhs
;;;

(defun spm-lhs-hash-lhs (lhs)
  ;; This routine is the first pass of the two pass SPM LHS printer.
  ;; It takes a P ified LHS from spm-lhs and walks through it
  ;; building the hashtable entries for each non preference make.
  (do-lhs (ce lhs :scope scope :negated negated)
    (spm-lhs-hash-ce scope negated ce)))


;;;
;;;		?.	Spm-lhs-hash-ce
;;;

(defun spm-lhs-hash-ce (scope negated ce)
  (let ((class (first ce)))
    (unless (eq class 'preference)
       (let* ((id        (second  ce))
	      (attribute (third ce))
	      (value     (fourth  ce))
	(type      (fifth ce)) ; Can only be + for acceptable.
	)
	 ;; If you don't have an attribute, don't do a thing, it will get printed directly.
	 (when   (not (eq attribute '*unbound*))
	 ;; On each scope/class/id/negated combination, keep a list of the attributes found, 
	 ;; but don't add the attribute more than once.
	 (unless (or (soar-gethash *spm-lhs-hash* scope class id attribute nil)
		     (soar-gethash *spm-lhs-hash* scope class id attribute '-))
	   (soar-pushhash *spm-lhs-hash* attribute scope class id))
	 ;; If I've got a preference test send the (V P) from the CE's (C I A V P) down
	 ;; the line, to save consing a new thing. Pm-conjunctive-test prints it correctly.
	 (soar-pushhash *spm-lhs-hash*  (if type (nthcdr 3 ce) value) 
			scope class id attribute negated))))))



;;;
;;;		?.	spm-lhs-print-lhs
;;;

(defun spm-lhs-print-lhs (lhs)
  ;; This routine in the second pass of SPM LHS printing.
  ;; It walks through all of the condition elements, printing preference CEs as it encounters them,
  ;; looking normal CEs up in *spm-lhs-hash* and printing all of the grouped CE elements when 
  ;; the first of them are encountered.
  (do-lhs (ce lhs :scope scope :depth depth :negated negated 
	      :first-ce-in-conjunction-p first-ce-in-conjunction-p
	      :before-conjunction 
	      (block nil 
		(soar-format *trace-file* "~%")
		(soar-nspaces (+ *pm-and-spm-spaces-before-a-ce-and-make* -2 (* depth 2)) *trace-file*)
		(if negated (soar-format *trace-file* "-{") (soar-format *trace-file* " {")))
	      :after-conjunction
	      (wrapping-soar-format *trace-file* (+ *pm-and-spm-spaces-before-a-ce-and-make* (* depth 2)) "}"))     
    (spm-lhs-print-ce scope negated (not first-ce-in-conjunction-p) 
		      (if (zerop depth) 0 (* 2 (1- depth)))
		      ce)))


;;;
;;;		?.	spm-lhs-print-ce
;;;


(defun spm-lhs-print-ce (scope negated print-spaces offset ce)
  ;;; Modified to fix bug where (C <i>) gets hashed and subsumed by similar conditions on
  ;;; printout. -BGM 9/3/89
  (let ((class-test (first ce)))
    (cond 
	  (t
	    (let* ((id-test (second  ce)))
	      ;; Check to see if the CE needs to be directly printed, or looked up in the hash table.
	      (if   (eq (third ce) '*unbound*)
	       ;; If it's not a preference and it has no attribute test
               ;; then it must be a CE without an attribute and so should be printed directly.
		  (pm-lhs-ce negated ce print-spaces offset)
		  (multiple-value-bind (attribute-tests found) 
		      (soar-remhash *spm-lhs-hash* scope class-test id-test)
		     (when found
			(spm-lhs-print-attributes scope print-spaces offset class-test 
						  id-test attribute-tests)
			(dispose-list attribute-tests)))))))))





;;;
;;;		?.	spm-lhs-print-attributes
;;;

(defun spm-lhs-print-attributes (scope print-spaces offset class-test id-test attribute-tests)
  (cond ((and (null (cdr attribute-tests))
	      (null (cdr (soar-gethash *spm-lhs-hash* scope class-test id-test (first attribute-tests) '-)))
	      (not (soar-gethash *spm-lhs-hash* scope class-test id-test (first attribute-tests) nil)))
	 ;; When there is only one attribute test, and it has only negative tests and only one of those,
	 ;; then print it in -(class <id> ^att v0) form.
	 ;; Otherwise do the normal -^att v0 v1 ... form.
	 (let* ((attribute-test (first attribute-tests))
		(-value-tests    (soar-remhash *spm-lhs-hash* scope class-test id-test attribute-test '-))
		(-value-test     (first -value-tests)))
	   (dispose-list -value-tests)
	   (when print-spaces 
	     (soar-format *trace-file* "~%")
	     (soar-nspaces (+ *pm-and-spm-spaces-before-a-ce-and-make* -2 offset) *trace-file*) )
	   (soar-format *trace-file* "- (~A" (pm-lhs-conjunctive-test class-test))
	   (let ((tab (soar-line-position)))
	     (unless (eq id-test '*unbound*)
	       (wrapping-soar-format *trace-file* *spm-spaces-before-id-test*
		  " ~A" (pm-lhs-conjunctive-test id-test)))
	     (cond ((null -value-test)
		    ;; Fixed for DSM. -BGM 1-Mar-90
		    (wrapping-soar-format *trace-file* tab " ^~A" (pm-lhs-conjunctive-test attribute-test)))
		   (t 
		     (wrapping-soar-format *trace-file* tab " ^~A ~A"
		       (pm-lhs-conjunctive-test attribute-test) (pm-lhs-conjunctive-test -value-test)))))))
	(t 
	  (when print-spaces 
	    (soar-format *trace-file* "~%") 
	    (soar-nspaces (+ *pm-and-spm-spaces-before-a-ce-and-make* offset) *trace-file*))
	  (soar-format *trace-file* "(~A" (pm-lhs-conjunctive-test class-test))
	  (unless (eq id-test '*unbound*)
	   (wrapping-soar-format *trace-file* *spm-spaces-before-id-test* " ~A" (pm-lhs-conjunctive-test id-test)))
	  (let ((attribute-tab (soar-line-position)))
	    ;; Use the Do so that I can detect the last element to avoid hanging a parenthesis.
	    (do* ((attribute-tests-p (nreverse attribute-tests) (cdr attribute-tests-p))
		  (attribute-test    (car attribute-tests-p)    (car attribute-tests-p)))
		 ((null attribute-tests-p))
		 (spm-lhs-print-attribute-value-tests
		   attribute-tab
		   (format nil " ^~A" (pm-lhs-conjunctive-test attribute-test))
		   (spm-stringify-tests scope class-test id-test attribute-test nil)
		   ;; Add in a an offset of 1 to help prevent hanging the last parenthesis.
		   (if (null (cdr attribute-tests-p)) 1 0)
		   )
		 (spm-lhs-print-attribute-value-tests 
		   attribute-tab
		   (format nil " -^~A" (pm-lhs-conjunctive-test attribute-test))
		   (spm-stringify-tests scope class-test id-test attribute-test '-)
		   ;; Add in a an offset of 1 to help prevent hanging the last parenthesis.
		   (if (null (cdr attribute-tests-p)) 1 0))))))
	(wrapping-soar-format *trace-file* (+ *spm-spaces-before-ce-closing-paren* offset) ")"))



;;;
;;;		?.	spm-lhs-print-attribute-value-tests
;;;
;;; I could add a dispose-list of value-tests down here.

(defun spm-lhs-print-attribute-value-tests (attribute-tab attribute-test value-tests offset)
 ;; Added in the offset, so that the last test on a line can make space for the ")"
 ;; as it seemed to hang a significant amount of the time. -BGM 11/11/88.
 (when value-tests 
  (let ((length (let ((sum (length attribute-test)))
		  (dolist (value-test value-tests)
		   (when   (not (eq value-test '*unbound*))
			 (incf sum (length value-test)))) 
		  sum))
	(soar-line-position (soar-line-position)))
    (unless (= soar-line-position attribute-tab)
      ;; You can't do any better by printing a CRLF it you're the minimal
      ;; distance out.
      (when (> (+ (soar-line-position) length offset) (soar-line-length))
       (soar-format *trace-file* "~%")
       (soar-nspaces attribute-tab *trace-file*)))
    (wrapping-soar-format *trace-file* attribute-tab "~A" attribute-test)
      (let ((value-tab (soar-line-position)))
       (dolist (value-test value-tests)
	(when   (not (eq value-test '*unbound*))
         (wrapping-soar-format *trace-file* value-tab "~A" value-test)))))))


;;;
;;;		?.	Spm-stringify-tests
;;;

(defun spm-stringify-tests (scope class-test id-test attribute-test sign)
  (let ((collection nil)
	(value-tests (soar-remhash *spm-lhs-hash* scope class-test id-test attribute-test sign)))
    (dolist (value-test value-tests)
     (get-push 
       (if   (not (eq value-test '*unbound*))
	   (format nil " ~A" (pm-lhs-conjunctive-test value-test))
             '*unbound*)
       collection))
    (dispose-list value-tests)
    collection))


;;;
;;;		?.	Smatches
;;;

(eval-when (compile eval load) (proclaim '(special *last-arg*)))
(eval-when (compile eval load) (proclaim '(special *conflict-set*)))


(defmacro smatches (&rest rule-list)
 ;; Modernized by BGM, 11/7/88.
 `(nlam-smatches ',rule-list))

(defun nlam-smatches (rule-list)
 ;; Modernized by BGM, 11/7/88.
 ;; Updated old style IO to soar-format. -BGM 8/18/88
 ; Randy.Gobbel 12-Sep-86 12:08 
  (if (null rule-list)
    (setq rule-list *last-pname*)
    (setq *last-arg* (setq *last-pname* (list (car rule-list)))))
  (soar-format *trace-file* "~%")
  (dolist (rule rule-list) (smatches2 rule nil))
  (soar-format *trace-file* "~%")
  nil)


(defun smatches2 (p full-print-flag) 
 ;; Changed to pass the fired list to smatches so it can count correctly GAP 2/28/90
 ;; The modernization prints nothing if the pname is not a production.
 ;; Modernized by BGM, 11/7/88.
  ; Randy.Gobbel 11-Sep-86 15:08 
  (when (symbolp p)
    (let ((production   (get-p p)))
      (when production
	(smatches3 p (p-production production) (p-backpointers production) 
                     (p-fireds production) t full-print-flag)))))

(defvar *indent* 0 
 ;; Added *indent* defvar. -BGM 4/4/89
  "A variable used to keep trace of indenting for some printing functions.")

(defun smatches3 (name matrix nodes full-matches flag full-print-flag) 
  ;; Changed to output timetags of fired instantiations GAP 5/11/90 
  ;; For bug #09May90-09.14.49
  ;; Changed to remove the p-type field usage GAP 3/4/90
  ;; Changed to show matches in the list of fired productions 
  ;;   that have not been retracted. full matches is a list of the
  ;;   instantiations of the production. GAP 2/28/90
  ;; Changed two calls to print-instantiation into print-node-memory. -BGM 3/29/89
  ;; Changed conjunction printing a bit. -BGM 1/31/89
  ;; This has been modified to use the new print functions and docs. -BGM 1/17/89
  ;; This should be converted to work with DOLHS. -BGM 1/17/89
  ;; Updated old style IO to soar-format. -BGM 8/18/88
  ;; Brian Milnes 9-Mar-87 20:00
  (prog (left-mem right-mem result-mem ce nomatch nresult cond)
    (cond (flag 
	    (soar-format *trace-file* "(")
	    (ms-soar-princ *trace-file* name 'pname)
	    (soar-format *trace-file* "~%"))
	  (t (soar-format *trace-file* "{")))
    (setq ce 0)
    loop
    (cond ((null matrix)
	   (return result-mem)))
    (soar-nspaces *indent* *trace-file*)
    (setq ce (1+ ce))
    (setq cond (pop matrix))
    (cond ((eq cond '-->)
	      (cond ((and full-print-flag
                       (soarassq name (conflict-set)))
                      (soar-format *trace-file* "** MATCHES FOR ALL CONDITIONS **")
		      (docs (instantiation)
		        (when (eq (car instantiation) name)
		          (soar-format *trace-file* "~%")
                          (print-partial-instantiation t (cdr instantiation))))
		      (soar-format *trace-file* "~%"))
		    ((and full-matches full-print-flag) ; Change 5/11/90 GAP add fired stuff to full-matches
                      (soar-format *trace-file* "** MATCHES FOR ALL CONDITIONS already fired **")
		      (dolist (instantiation full-matches)
		        (soar-format *trace-file* "~%")
                        (print-partial-instantiation t (instantiation-lhs instantiation)))
		      (soar-format *trace-file* "~%")))
		      
	      (return))
	  ((is-negation cond)
	      (soar-format *trace-file* "- ")
	      (setq cond (pop matrix)))
	  (t (soar-format *trace-file* "  ")))
    (cond ((soarlistp (car cond))
	   (setq *indent* (+ 6 *indent*))
	   (soar-format *trace-file* "    ")
	   (setq right-mem (smatches3 name cond (pop nodes) full-matches nil nil))
	   (setq *indent* (- *indent* 6))
	   (setq cond "}")
	   (soar-format *trace-file* "  ~%"))
	  (t (setq right-mem (pop nodes))))
    (cond (result-mem (setq left-mem result-mem)
		      (setq result-mem (pop nodes)))
	  (t (setq result-mem right-mem)))
    (cond
      (nomatch (soar-format *trace-file* "    "))
      (t (cond ((eq (car result-mem) '&p)
		   (setq nresult (length full-matches))
		   (docs (instantiation)
		      (when (eq (car instantiation) name)
                                (incf nresult))))
	       (t (setq nresult (cond ((eq (car result-mem) '&rmem)
				           (length (find-right-mem result-mem)))
				      (t (mem-length (find-left-mem result-mem)))))))

        (cond ((zerop nresult)
		(soar-format *trace-file* ">>>>"))
	       (t (soar-format *trace-file* "~A" nresult)
		  (do-tabto (+ 7 *indent*) *trace-file*)))))
    (cond ((equal cond "}") ;; Yost Change from Patch2.
	   ;; Looks like this should never fire. -BGM 1/17/89.
	   (soar-format *trace-file* "}~%")
	   (soar-format *trace-file* "~%"))
	  (t (pm-lhs-ce nil cond nil 0)
	     (soar-format *trace-file* "~%")))
    (cond ((and (not nomatch)
		(zerop nresult)
		left-mem full-print-flag)
	   (soar-format *trace-file* "** MATCHES FOR LEFT ** ")
	   (print-node-memory t (find-left-mem left-mem))
	   (soar-format *trace-file* "~%** MATCHES FOR RIGHT ** ")
	   (print-node-memory t (find-right-mem right-mem))
	   (soar-format *trace-file* "~%")))
    (and (zerop nresult)
	 (setq nomatch t))
    (go loop)))


(defun find-left-mem (node) 
 ; Dan.Scales  5-Mar-86 09:37  
 ; GET THE LEFT MEMORY OF AN &AND NODE OR NOT-MEMORY OF A &NOT NODE. 
  (car (caddr node)))

(defun find-right-mem (node) 
  ; Randy.Gobbel 13-May-86 14:18  
  ; RETURN LIST OF TOKENS IN RIGHT (HASH) MEMORY OF &AND NODE. 
       (prog (i result tmp tmp1 mem)
	     (setq mem (caddr node))
	     (setq i 0)
	     loop
	     (and (>= i *mem-array-size*)
		  (return result))
	     (setq tmp (getvector mem i))
	     loop1
	     (cond ((null tmp)
		    (setq i (1+ i))
		    (go loop)))
	     (setq tmp1 (cdr (pop tmp)))
	     (cond (result (setq result (append tmp1 result)))
		   (t (setq result tmp1)))
	     (go loop1)))

(defun mem-length (mem) 
  ; Modernized, BGM 11/7/88.
  ; John.Laird 16-Apr-85 10:49 
  (let ((length 0))
    (dolist (ci mem)
      (when (consp ci) (incf length)))
    length))



;;;
;;;		?.	Full-matches
;;;

(defmacro full-matches (&rest rule-list)
  ;; Modernized, BGM 11/7/88.
  `(nlam-full-matches ',rule-list))

(defun nlam-full-matches (rule-list) 
  ;; Modernized, BGM 11/7/88.
  ;; Updated old style IO to soar-format. -BGM 8/18/88
   ; Randy.Gobbel 12-Sep-86 12:08 
  (if (null rule-list)
      (setq rule-list *last-pname*)
      (setq *last-arg* (setq *last-pname* (list (car rule-list)))))
  (soar-format *trace-file* "~%")
  (dolist (rule rule-list) (smatches2 rule t))
  (soar-format *trace-file* "~%"))

;;;
;;;		?.	Memories
;;;

(defmacro memories (&optional number)
  ;; Modernized, BGM 11/7/88.
  `(nlam-memories ,number))

(defun nlam-memories (number) 
  ;; Modernized, BGM 11/7/88.
  ;; Updated old style IO to soar-format. -BGM 8/18/88
   ; Randy.Gobbel 12-Sep-86 12:08 
  (let ((memory-sizes nil))
    (soar-format *trace-file* "~%")
    (dolist (pname *pnames*)
      (let ((production   (get-p pname)))
	;; Assume that the pnames are all valid, because I got them from *pnames*.
	(soarpush (memories2 pname (p-production production) (p-backpointers production))
		  memory-sizes)))
    ;; Don't sort and reverse when you can sort by a different predicate.
    (setq memory-sizes (sort memory-sizes #'>= :key #'car))
    (soar-format *trace-file* "Productions with largest memories~%")
    (dotimes (i (or number 10))
      (soar-format *trace-file* "~A: ~A~%" (caar memory-sizes) (cadar memory-sizes))
      (pop memory-sizes))))

(defun memories2 (pname matrix nodes)
 ; Left the hell alone by BGM, 11/7/88.
 ; Randy.Gobbel 19-Jun-86 17:54 
  (prog
    (right-mem result-mem cond memory-count)
    (setq memory-count 0)
    (soarwhile
      (and (consp matrix) (not (eq (car matrix) '-->))) 
      ; Changed endtest to prevent infinite loops. _BGM 3/27/89
      (pop matrix)
      (cond ((is-negation cond)
	     (setq cond (pop matrix))))
      (cond ((soarlistp (car cond))
	     (setq memory-count (+ memory-count (car (memories2 pname cond
								(pop nodes)))))
	     (setq cond ")"))
	    (t (setq right-mem (pop nodes))))
      (cond (result-mem (setq result-mem (pop nodes)))
	    (t (setq result-mem right-mem)))
      (cond ((not (eq (car result-mem) '&p))
	     (setq memory-count
		   (+ memory-count
		      (cond ((eq (car result-mem) '&rmem)
			     (length (find-right-mem result-mem)))
			    (t (mem-length (find-left-mem result-mem)))))))))
    (return (list memory-count pname))))

;;;
;;;		?.	PI
;;;

(defmacro pi (&rest pname-list)
  ;; Modernized BGM, 11/7/88.
  `(nlam-pi ',pname-list))

(defun nlam-pi (z) 
  ;; Changed name of prit-partial-instantiation to print-pi-partial-instantiation. -BGM 1/17/89
  ;; Modernized BGM, 11/7/88.
  ; Randy.Gobbel  9-May-86 14:37 
  (if (null z)
     (setq z *last-pname*)
     (setq *last-arg* (setq *last-pname* (list (car z)))))
  (print-pi-partial-instantiation (car z) (if (cdr z) (cadr z) 1)))

(defun print-pi-partial-instantiation (p i)
  ;; Changed to pass the useful list of full matches to ppi3 GAP 2/28/90
  ;; Changed name of prit-partial-instantiation to print-pi-partial-instantiation. -BGM 1/17/89
  ;; Modernized BGM, 11/7/88.
  ;; Updated old style IO to soar-format. -BGM 8/18/88
  ; Randy.Gobbel 12-Sep-86 12:08 
  (when (symbolp p)
   (let ((production   (get-p p)))
     (when production 
       (soar-format *trace-file* "~%")
       (ppi3 p i (p-backpointers production) (p-fireds production))))))

;;;
;;; This routine calls the recursive routine get-instan-list to get a list of
;;; tokens. It assumes that the list is ordered with the tokens of highest
;;; match coming first. Within a token the wmes are in reverse order to the
;;; condition elements of the production. Not all the list has to be instantiated.
;;; But at least the first 'i' elements must be there.
;;; 2/20/90 GAP 

(defun ppi3 (name i nodes full-matches) 
 ;; Chaged to remove the p-type field output GAP 03/4/90
 ;; Completely Rewritten by GAP 02/21/90
 ;; Modernized to about 1970 by BGM, 11/7/88.
 ;; Updated old style IO to soar-format. -BGM 8/18/88
 ;; Randy.Gobbel 12-Sep-86 12:17 

    (let ((saved-mems (nth (1- i) (get-instan-list name i nodes full-matches))))
        (soar-format *trace-file* "(")
        (ms-soar-princ *trace-file* name 'pname)
        (soar-format *trace-file* " ~A"
            (cond ((<= i (length full-matches))
                     "Fired Instantiation")
                  (t "")))
	(dolist (wme (reverse saved-mems))
		(soar-format *trace-file* "~%") (print-wme-and-timetag t wme))
        (soar-format *trace-file* ")~%")
	 t))
;;
;; This routine traverses the RETE newtork backpointers looking for all the
;; unique tokens in the network. These unique tokens are grouped within a list
;; that is returned. The parameter 'i' indicates which element of the list is
;; of interest to the calling routine. THus this routine stops adding to the
;; list when the list is at least 'i' long. As the uniqueness test is made at
;; the time the information is added to the list and this is an N**2 operation
;; this limits the bad effects to when one wants to see the end of the list.
;; GAP 2/21/90
;;

(defun get-instan-list (p i nodes full-matches)
    (let ((join_node (caar nodes)))
    (cond
      ((or (eq join_node '&not)    ; check for not joins
	   (eq join_node '&all))   ; or all joins
               (get-instan-list p i (cddr nodes) full-matches ))

      ((eq join_node '&p)     ; This production has instantiated to completion
         (let (instance-list)
           (dolist (ci (conflict-set))
              (cond ((eq (car ci) p)
			(push (cdr ci) instance-list))))
           (dolist (fm full-matches)
              (push (instantiation-lhs fm) instance-list))
           (nreverse instance-list)))

      (t (let ((saved-mems (find-left-mem (car nodes))))
	   (cond
	     (saved-mems 
                  (let ((lower-mems (get-instan-list p i (cddr nodes) full-matches))
                         (in-list nil)   ;in-list means already in list
	                 (diff-mems nil)) 
		       (cond ((> (list-length lower-mems) i)
                                 lower-mems)
	                      (t  (dolist (token saved-mems)
				    (cond (lower-mems 
                                              (setq in-list nil)
                                              (dolist (low-token lower-mems)
					         (setq in-list (or in-list
							           (not (null (search token low-token :test #'equal))))))
                                               (cond ((not in-list)
				                         (push token diff-mems ))))
				          (t (setq diff-mems saved-mems))))))
		       (nconc lower-mems (reverse diff-mems))))
 	     (t nil)))))))    ;; No more instantiations below this node



;;;
;;;		?.	Excise
;;;

(defmacro excise (&rest pname-list)
  ;; Modernized, BGM 11/7/88.
  `(nlam-excise ',pname-list))

(defun nlam-excise (pname-list)
  ;; Modernized, BGM 11/7/88.
  ; Randy.Gobbel  9-May-86 14:37 
  (if (null pname-list)
    (setq pname-list *last-pname*)
    (setq *last-arg* (setq *last-pname* (list (car pname-list)))))
  (dolist (pname pname-list) (excise-p pname))
  pname-list)

(eval-when (compile eval load) (proclaim '(special *chunks*)))



;;;
;;;		?.	Pbreak
;;;

(defvar  *brknames* () 
  "The names of things which will cause decide to break.
   Defaults to nil in i-g-v.")

(defvar  *brkpts* () 
 "The names of productions which have breakpoints set.
  Defaults to () i-g-v.")



;;;
;;;		?.	Ptrace and unptrace
;;;

(defmacro unptrace (&rest criteria)
 `(unptrace-aux (quote ,criteria))
)


;;;
;;;		?.	Ptrace-item-p
;;;


;;;
;;;		?.	Pfired
;;;

(defvar *pfired* () "Count the number of times each production fired for pfired.")


;;;
;;;		?.	Initialize-rete-newpm
;;;

(defun initialize-rete-newpm ()
 nil)


;;;
;;;		?.	Restart-rete-newpm
;;;

(defun restart-rete-newpm ()
  (eval `(excise ,@*pnames*)) ; Excise all of the pnames.
  (setq *pnames* nil)
  (setq *pcount* 0)
  (setq *user-pnames* nil)
  (setq *print-pname* nil)
  (setq *brknames* nil)  
  (setq *brkpts* nil)
  (setq *pfired* nil)
  (unptrace)
  (setq *indent* 0)  
  (setq *last-pname* nil)
  nil)

;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/print-wmes.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	print-wmes.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/rete/new/print-wmes.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file, print-wems, contains a variety of routines for printing wmes.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	iv.	Lacunae
;;;	I.	Print-preference-wme
;;;	II.	Print-non-preference-wme 
;;;	III.	Print-wme
;;;	IV.	Print-wme-and-timetag
;;;	V.	Print-wmes-timetag
;;;	VI.	Print-partial-instantiation
;;;	VII.	Print-partial-instantiations
;;;	VIII.	Print-node-memory
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")

;;;
;;;		iv.	Lacunae
;;;
;;;	This does not yet support the .
;;;

;;;
;;;		I.	Print-preference-wme
;;;

(defun print-preference-wme (stream preference-wme)
  (let ((class      (wme-class preference-wme))
	(id         (wme-id preference-wme))
	(attribute  (wme-attribute preference-wme))
	(value      (wme-value preference-wme))
	(type       (wme-type preference-wme))
	(reference  (wme-reference  preference-wme)))
    (if reference
      (soar-format stream "(~A ~A ^~A ~A ~A ~A)" class id attribute value type reference)
      (soar-format stream "(~A ~A ^~A ~A ~A)" class id attribute value type))))


;;;
;;;		II.    Print-non-preference-wme 
;;;

(defun print-non-preference-wme  (stream wme)
  (let ((class     (wme-class wme))
	(id        (wme-id wme))
	(attribute (wme-attribute wme))
	(value     (wme-value wme)))
      (soar-format stream "(~A ~A ^~A ~A)" class id attribute value)))

; I'd better not wrap, but just let wraparound do its job.
;    (let ((tab (soar-line-position)))
;      (wrapping-soar-format stream tab " ~A" id)
;      (wrapping-soar-format stream tab " ^~A ~S)" attribute value))))


;;;
;;;		III.	Print-wme
;;;

(defun print-wme (stream wme)
  (if   (wme-type wme)
      (print-preference-wme stream wme)
      (print-non-preference-wme stream wme)))


;;;
;;;		IV.	Print-wme-and-timetag
;;;
;;; Notice the trickyness with the optional timetag argument to avoid linear
;;; cdring into the wmes of the same id to get the timetag.

(defun print-wme-and-timetag (stream wme &optional (timetag (creation-time wme)))
  (print-wmes-timetag stream wme timetag)
  (soar-format stream ":")
  (print-wme stream wme))


;;;
;;;		V.	Print-wmes-timetag
;;;
;;; Notice the trickyness with the optional timetag argument to avoid linear
;;; cdring into the wmes of the same id to get the timetag.

(defun print-wmes-timetag (stream wme &optional (timetag (creation-time wme)))
  (ms-soar-princ stream timetag 'time-tag))



;;;
;;;		VI.	Print-partial-instantiation
;;;

(defun print-partial-instantiation (stream list-of-wmes)
  (when list-of-wmes
    (print-partial-instantiation stream (cdr list-of-wmes))
    (soar-format stream " ")
    (print-wmes-timetag stream (car list-of-wmes))))


;;;
;;;		VII.	Print-partial-instantiations
;;;

(defun print-partial-instantiations (stream list-of-partial-instantiations)
  (dolist (partial-instantiation list-of-partial-instantiations)
   (soar-format stream "~%")
   (print-partial-instantiation stream partial-instantiation)))


;;;
;;;		VIII.	Print-node-memory
;;;
;;; A node memory can be a list of partial instantiations, or a not memory which
;;; is a list of partial instantiations each followed by an integer counter.
;;;

(defun print-node-memory (stream node-memory)
  (dolist (count-or-partial-instantiation node-memory)
    (when (listp count-or-partial-instantiation)
      (soar-format stream "~%")
      (print-partial-instantiation stream count-or-partial-instantiation))))

;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/print-wm.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	print-wm.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/rete/new/print-wm.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file contains some routines to access and print the contents of wm.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	WM
;;;	II.	SWM
;;;	III.	PO
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")



;;;
;;;		I.	Wm
;;;

(defmacro wm (&rest timetags) `(compiled-wm ',timetags))

(defun compiled-wm (timetags)
  ;; Renamed to compiled-wm, moved and updated. -BGM 1/15/89
  ;; Updated old style IO to soar-format. -BGM 8/18/88
  ; Randy.Gobbel 12-Sep-86 12:17 
       (cond ((null timetags) (setq timetags *last-tag*))
	     (t (setq *last-arg* (setq *last-tag* (list (car timetags))))))
       (let ((wme.timetags nil))
	 ;; Collect wme.timetags in one fast pass through WM first,
	 ;; as there should be more wmes than specified timetags.
	 (dowm (wme.timetag)
	   (let ((timetag (cdr wme.timetag)))
	     (when (member timetag timetags :test #'eql)
	       (push wme.timetag wme.timetags))))
	 (dolist (wme.timetag 
		     ;; Now sort the wme.timetags so that they
		     ;; appear in the order of the timetag arguments,
		     ;; not the timetags.
		     (sort wme.timetags 
			   #'(lambda (x y) 
			       (let ((x-found (member x timetags))) (member y x-found)))
			   :key #'cdr))
	   (soar-format *trace-file* "~%")
	   (print-wme-and-timetag t (car wme.timetag) (cdr wme.timetag))))
       (soar-format *trace-file* "~%")
       nil)



;;;
;;;		II.	Swm
;;;

(defmacro swm (&rest timetags) `(compiled-swm ',timetags))

(defun compiled-swm (timetags)
  ;; Moved, renamed, and updated. -BGM 1/15/89
  ;; Maybe this needs a (soar-format *trace-file* "~%") up from for the . -BGM 8/18/88
  ; Randy.Gobbel  9-May-86 14:36 
       (cond ((null timetags) (setq timetags *last-tag*))
	     (t (setq *last-arg* (setq *last-tag* (list (car timetags))))))
       (let ((id.timetags nil))
	 (dowm (wme.timetag)
	  (let ((timetag (cdr wme.timetag)))
	    (when (member timetag timetags :test #'eql)
	      (let ((id (wme-id (car wme.timetag))))
		(unless (member id id.timetags 
				:test #'(lambda (id id.timetag) (eq id (car id.timetag))))
		  (push (cons id timetag) id.timetags))))))
	 (compiled-spo 
	   (mapcar #'car 
	     (sort id.timetags 
		   #'(lambda (x y) (let ((x-found (member x timetags))) (member y x-found)))
		   :key #'cdr))
	   :print-wmes t
	   ))
       nil)



;;;
;;;		III.	PO
;;;

(defmacro po (&rest ids)
  ;; Moved, updated. -BGM 1/15/89
  `(compiled-po ',ids))

(defun compiled-po (ids) 
  ;; Moved, changed name, updated. -BGM 1/15/89
  ; Randy.Gobbel 16-Jul-86 16:31 
  (cond ((null ids)
	 (setq ids *last-obj-id*))
	(t (setq *last-arg* (setq *last-obj-id* (list (car ids))))))
  (dolist (id ids)
   (when (symbolp id)
    (let ((wmes (get id 'wmpart*)))
      (dolist (wme.timetag wmes)
       (unless (eq (wme-class wme.timetag) 'preference)
	 (soar-format *trace-file* "~%")
	 (print-wme-and-timetag t (car wme.timetag) (cdr wme.timetag))))))))

;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/find-in-wm.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	find-in-wm
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/rete/new/find-in-wm.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file provides three different types of access functions for searching WM,
;;; and one more that cases on the accessors.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Find-wme-of-timetag
;;;	II.	Find-wmes-of-id
;;;	III.	Find-wmes-of-pattern
;;;	IV.	Find-wmes-of-timetag-id-or-pattern
;;;

;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")


;;;
;;;		I.	Find-wme-of-timetag
;;;

(defun find-wme-of-timetag (timetag)
  (dowm (wme.timetag nil)
   (when (eql (cdr wme.timetag) timetag) 
     (return-from find-wme-of-timetag (car wme.timetag)))))

;;;
;;;		II.	Find-wmes-of-id
;;;

(defun find-wmes-of-id (id)  (mapcar #'car (get id 'wmpart*)))


;;;
;;;		III.	Find-wmes-of-pattern
;;;

(defun find-wmes-of-pattern (pattern)
  (let ((*rhs-smake-or-ppwm* 'ppwm))
    (catch-sptop-errors
      (let ((ces (sp-parse-ppwm pattern ))
	    (wmes nil))
	(dowm (wme.tag)
	  (let ((wme (car wme.tag)))
	    (dolist (ce ces)
	      (when (wme-matches-ce wme ce) (pushnew wme wmes)))))
	wmes))))

;;;
;;;		IV.	find-wmes-of-timetag-id-or-pattern
;;;
;;; This has been placed here because it uses very PPWM-like operations
;;; to search wme.
;;;

(defun find-wmes-of-timetag-id-or-pattern (timetag-id-or-pattern)
  ;; Created. -BGM 1/15/89
  (cond ((numberp timetag-id-or-pattern)
	 (let ((wme (find-wme-of-timetag timetag-id-or-pattern)))
	   (when wme (list wme))))
	((symbolp timetag-id-or-pattern)
	 (find-wmes-of-id timetag-id-or-pattern))
	((listp timetag-id-or-pattern)
	 (find-wmes-of-pattern timetag-id-or-pattern))))


;;; Concatenated from type module "rete" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/rete/new/reteinitandrestart.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	initandrestart.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/rete/new/initandrestart.lisp
;;;
;;;		i.	Abstract
;;;	This file contains two functions: initialize-rete and restart-rete; to be called
;;; by init-soar and restart-soar.
;;;	
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Initialize-rete
;;;	II.	Restart-rete
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")



;;;
;;;		I.	Initialize-rete
;;;



(defun initialize-rete ()
  (initialize-rete-reorder)
  (initialize-rete-symboltable) 
  (initialize-rete-ptorete)
  (initialize-rete-codegeneration)
  ;(initialize-rete-interpreter)
  (initialize-rete-cs)
  (initialize-rete-wm)
  ;; *current-token* must be reset after wm initialized.
  ;; Moved from above. -KAM 7/8/89
  (initialize-rete-interpreter) 
  (initialize-rete-rhs)
  (initialize-rete-spo)
  (initialize-rete-newpm)
)


;;;
;;;		II.	Restart-rete
;;;

(defun restart-rete ()
  (restart-rete-reorder)
  (restart-rete-symboltable) 
  (restart-rete-ptorete)
  (restart-rete-codegeneration)
  (restart-rete-interpreter)
  (restart-rete-cs)
  (restart-rete-wm)
  (restart-rete-rhs)
  (restart-rete-spo)
  (restart-rete-newpm)
)

;;; Concatenated from type module "decide" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/decide/new/decide.lisp".
;;; -*-mode: soar; package: user -*-

(in-package "SOAR")
(defvar *decision-preferences* ()  "Used only in decide.")
      
;; uses up G1 symbol.

(defvar *current-goal* ()  "The current goal for decide.")

(defvar *impasse-subset-not-equal* ()    "Used in decide.")

(eval-when (compile eval load) (proclaim '(special *first-action*)))

(defvar *first-action* () "Seems to be used by decide and chunk; seems to be a brutal hack.")
(defvar *user-ids* () "")
(defvar *instance-attributes* 
  '((operator instance)
    (operator object)
    (goal superoperator)
    (goal desired)
    (goal impasse)
    (goal role))
 "What class/attribute pairs should I trace on ID prints ?")
(defvar *first-remove* () "Seems to be used by decide.")

(eval-when (compile eval load) (proclaim '(special *never-learn*)))

;;; Reinstalled for Golding by BGM, 2/29/88.

;;; the timing calls are not always balanced anymore in DSM;
;;; they were causing errors in this function.
(defun ask-for-choice (choice-list)
       (prog (choice)
#|
	     #+:soar-times (stop-soar-time real)
	     #+:soar-times (stop-soar-time run)
	     #+:soar-times (stop-soar-time decide)
|#
	     (stop-elapsed-time)
	     (setq choice (soar-menu "Select one" choice-list))
	     (start-elapsed-time)
#|
	     #+:soar-times (start-soar-time decide)
	     #+:soar-times (start-soar-time real)
	     #+:soar-times (start-soar-time run)
|#
	     (return choice)))

(defvar *decide-trace* () "When I'm on trace the decision procedure.")

;;; Installed by BGM from McMahon 6/7/88.

(eval-when (compile eval load) (proclaim '(special *always-learn*)))

;;; Installed by BGM 2/18/88 for McMahon.

(eval-when (compile eval load) (proclaim '(special *new-chunks*)))

;;;
;;; Installed by BGM 11/1/87 from GRY.
;;;

;;; Installed by BGM for McMahon. 2/18/88.
                               
;;; Installed by BGM for McMahon. 2/18/88.
 
;;; Installed by BGM for McMahon. 2/18/88.
    
;;; Installed by BGM for McMahon. 2/18/88.
 
;;; Installed by BGM for McMahon. 2/18/88.
 
;;; Installed by BGM for McMahon. 2/18/88.
 
;;; Installed by BGM for McMahon. 2/18/88.
;;; Modified by BGM, 6/13/88.
;;; The labels are slow on some machines.
;;; The use of sequence functions is causing differences between the Vax and
;;; the RT version which change the testcode. 

;;; This routine required the candidates argument from the enclosing 
;;; defun process-worse, so I added it as an argument.
 
;;; Modified by BGM at 6/29/88 for Arie Covrigaru. This really ought to check
;;; that its arguments are correct.
 
;;; Modified by BGM at 6/29/88 for Arie Covrigaru. This now always brings up the menu.
 
(defvar *slot-preferences* nil
   ;; Installed for JEL by BGM 1/11/89.
   ; Required so trace-back through acceptable preferences. -JEL ?
)

(defvar *necessity-preference-values* '(acceptable prohibit reject require) "")

;;; From Karen McMahon in response to a suspended subgoal problem of ARG's.
;;; Installed by Milnes, 2/7/88.

(defvar *decide-count* 0 "The total number of decide cycles fired.")

(defvar *subgoal-tabs* t "")

(eval-when (compile eval load) (proclaim '(special  *input-wme*)))

;; Moved spop to the rete module. -BGM 1/15/89

(defvar *gtrace* () 
 "When I'm true trace each goal; but I don't see how its used to do this.")
(defvar *otrace* t 
 "When I'm true trace each operator application. Defaults to T in i-g-v.")

(defvar *watch-free-problem-spaces* () "")

(defvar *init-wm* nil "Decide's variable to test if WM been initialized yet ?")
(eval-when (compile eval load) (proclaim '(special *learning*)))

(defun initialize-decide ()
 ;; Created by BGM 3/9/89
  (mapc #'soarclearprops *user-ids*)
  (setq *user-ids* nil)
  (setq *init-wm* nil)
  (setq *first-action* t)
  (setq *input-wme* nil)
  nil
  )


(defun restart-decide ()
 ;; Created by BGM 3/9/89
  (mapc #'soarclearprops *user-ids*)
  (setq *user-ids* nil)
  
  (setq *subgoal-tabs* t)
  (setq *watch-free-problem-spaces* nil)

  (setq *instance-attributes* nil)
  
  (setq *gtrace* nil)
  (setq *impasse-subset-not-equal* nil)
  (setq *necessity-preference-values* '(acceptable prohibit reject require))  
  (setq *init-wm* nil)
  (setq *first-action* t)
  (setq *input-wme* nil)
  nil
 )


;;; Concatenated from type module "chunk4" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/chunk4/new/chunk4.lisp".
;;; -*-mode: soar; package: user -*-
;;;  Chunk.lisp

(in-package "SOAR")
(defvar *chunk-all-paths* () "")
(defvar *chunk-free-problem-spaces* () "")
(defvar *max-chunk-conditions* 200 "")
(defvar *new-chunks* () "")
(defvar *cav* () "Something for chunking.")
(defvar *cavi* () "Something for chunking.")
(defvar *previously-traced* ()
   "Something for chunking.")

(defvar *always-learn* t "")
(defvar *learn-ids* () "")
(defvar *learning* () "")
(defvar *print-learn* 0 "")
(defvar *secondary-variables* () "")

(defvar *suspected-duplicates* () "")

;;; 
;;; Fixed, 4/2/88, belatedly by Milnes.

(defmacro back-trace (&optional (I ()) (G (bottom-goal))) `(nlam-back-trace ',I ',G))

(defun nlam-back-trace (I G)
  ;; Totally rewritten for sanity's sake. -BGM 2-Mar-90
  (if *never-learn* 
      (soar-format t "~%Learning was disabled.  Can not back-trace. ~%")
    ;; Check that G is a goal object.
    (let ((goal (goal-gnode g)))
      (if (not goal)
	  (soar-format t "~%~A is not a goal indentifier; back-trace." g)
	;; Check that I is a timetag, an object identifier, a pattern or nil.
	(if (null i) 
	    (dolist (result (gnode-external-objects goal)) (back-trace-conditions g goal result t))
	  (back-trace-conditions g goal (find-wmes-of-timetag-id-or-pattern I) t)))))
  (values)) 

(eval-when (compile eval load) (proclaim '(special *over-gen-chunk*)))

(defvar *potential-conditions* () "")

(defvar *over-gen-chunk* nil 
  "Is this chunk over general ? I don't know JEL did not commment this variable.")

(defvar *tracep* t "Trace something else ?")
(defvar *wme-list-stack* () "")
(defvar *unbound* () "")

(defvar *ltrace* () "Trace the learning of productions ?")

(defvar *action-closure* () "Used by chunking.")

(defvar *current-production-trace* 'cpt "A variable for chunking.")

(defvar *trace-number* 0
	 ;; Added defvar. -BGM 4/12/89
	 "A count of the number of production traces ?")
	 
(eval-when (compile eval load) (proclaim '(special *trace-number*))) ;added. -KAM 6/14/89



#| 
(defun save-production-trace (wme current-goal) 
  ;; Old Save-production-trace seems to be out of phase with the IO version.- Milnes, 7/3/88.
  ; John.Laird 
  ; 17-Mar-86 13:21  ; Save a production trace in the production-trace 
 ; property of the current-goal. The trace has a trace-number, the 
 ; data-matched - split into results and non-results, and the production 
 ; name 
       (cond (*data-matched*
	       (cond (*first-action*
		       (setq *current-production-trace*
			     (list (setq *trace-number* (1+ *trace-number*))
				   (split-apart-conditions (reverse 
							     *data-matched*)
							   current-goal)
				   *p-name*))
		       (setq *first-action* nil)))
	       (soaraddprop current-goal (cons wme *current-production-trace*)
			    'production-trace)
	       wme)))

|#

(eval-when (compile eval load) (proclaim '(special *INPUT-LINK-ATTRIBUTES*)))

(defun set-chunk-bit-t (goal) ; John.Laird 17-Jun-86 09:06 
       (cond (goal (rplaca (nthcdr 9 (get goal 'context))
			   t)
		   (soarmapc #'(lambda (x)
				       (rplaca (nthcdr 9
							   (get x
								'context))
					       t))
			     (get goal 'supergoals)))))

; [ARG -- 1/2/88] Do nothing if *chunks* is nil.
                                              
;;;
;;;     III.    last-chunk
;;;
;;; Now returns last chunk instead of nil, and can not print out if you wish.
;;;
;;; Changed by FR 11-Mar-91 Bug # 15Feb91-16.30.12

(defun last-chunk (&key (print-p t))
 ;; added DSM version of last-chunk. -KAM 7/8/89.
 (dolist (chunk *chunks*)
  (declare (symbol chunk))
  (cond ((not (internal-chunk-p chunk))
         (if print-p
             (eval (cons 'spm (list chunk))))
         (return chunk) )) )
)

(defun list-chunks (&optional filename) 
 ;; Added binding of chunks. -KAM 6/12/89
 ;; Removed the do not interrupt message. -BGM 3/2/89
 ;; removed reverse to print in the right order Bug #20Aug90-23.13.20 GAP 8/20/90
 ;; Added overwrite in reponse to bug-report 21Aug90-13.12.17 GAP 09/27/90
 (let ((chunks
               (soar-set-difference *chunks* *internal-chunks* :test #'eq)
      ))
  (cond (chunks
         (cond (filename
                (soar-format t
                             "~%Copying chunks to file ~A.~%"
                             filename)
                (with-open-file (*standard-output* filename :direction :output
                                                        :if-exists :supersede
                                                        :if-does-not-exist :create)
                 (eval (cons 'spm (reverse chunks))) ))
               (T
                (eval (cons 'spm (reverse chunks))) )) ))
 T
))


                                              
(defun last-justification ()
 ;; Added in reponse to bug-report 14Aug90-08.54.14 GAP 08/13/90
 ;; Added overwrite in reponse to bug-report 21Aug90-13.12.17 GAP 09/27/90
 (dolist (chunk *chunks*)            
  (declare (symbol chunk))
  (cond ((internal-chunk-p chunk)
         (eval (cons 'spm (list chunk)))
         (return) )) )
)

     

(defun list-justifications (&optional filename)
 ;; Added in reponse to bug-report 14Aug90-08.54.14 GAP 08/13/90
 (let ((chunks *internal-chunks*))
  (cond (chunks
         (cond (filename
                (soar-format t
                             "~%Copying Justifications to file ~A.~%"
                             filename)
                (with-open-file (*standard-output* filename :direction :output
                                                        :if-exists :supersede
                                                        :if-does-not-exist :create)
                 (eval (cons 'spm (reverse chunks))) ))
               (T
                (eval (cons 'spm (reverse chunks))) )) ))
 T
))


(defun excise-chunks nil  
  ;; also removes them from trace -fer 9/2/90
  ;; Installed # - :DSM from mcmahon. -BGM 2/3/89
  ;; Updated to use unptrace. -BGM 1/14/89
  ; [ARG -- 1/2/88] Do nothing if *chunks* is nil.
  (if (not (null *chunks*))
      (prog (chunks)
            ;; replaced append to NIL with copy-list. -KAM 6/14/89
            (setf chunks (copy-list *chunks*))
	    (eval (cons 'excise chunks))
            #+sx(if soar::graphic-display? (sx::sx-excise-chunks)))))

(defun initialize-chunk ()
 ;; Created 3/9/89. -BGM 
  (setq *current-production-trace* 'cpt)
  (setq *trace-number* 0)
  nil)

(defun restart-chunk ()
 ;; Created 3/9/89. -BGM
  (setq *always-learn* t)
  (setq *cav* nil)
  (setq *cavi* nil)
  (setq *chunks* nil)
  (setq *chunk-all-paths* nil)
  (setq *chunk-free-problem-spaces* nil)
  (setq *learn-ids* nil)
  (setq *learning* nil)
  (setq *ltrace* nil)
  (setq *max-chunk-conditions* 200)
  (setq *never-learn* t)
  (setq *new-chunks* nil)
  (setq *print-learn* 0)
  (setq *wme-list-stack* nil)  
  (setq *tracep* t)  
  
  nil)




;;; Concatenated from type module "io" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/io/new/io.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;; Soar Input/Output
;;; Written by Mark Wiesmeyer
;;; January 1988
;;;
;;;
;;;*****************************************************************************
;;;			Defvars
;;;*****************************************************************************

(in-package "SOAR")

(defvar *text-input* nil
;; Made the default value conincide with init-io. -BGM   2/17/89
 )

(defvar *text-input-augmentation* nil)
(defvar *text-output* nil
;; Turned off by default. -BGM 2/19/89
)
(defvar *text-output-augmentation* nil)
(defvar *text-input-stream* *standard-input*)
;; Added *standard-input* value here. -BGM 5/10/89
(defvar *text-input-stream-augmentation* nil)
(defvar *text-output-stream* nil)
(defvar *text-output-stream-augmentation* nil)
(defvar *char-mode* nil)
(defvar *char-mode-augmentation* nil)
(defvar *carriage-control* nil)
(defvar *carriage-control-augmentation* nil)
(defvar *tab-settings* nil)
(defvar *tab-settings-augmentations* nil)
(defvar *current-column* 0)
(defvar *output-mappings* nil)
(defvar *last-top-level-state-id* nil )
(defvar *output-links* nil)
(defvar *output-link-attributes* nil)
(defvar *alternate-readtable* nil)
(defvar *soar-readtable* nil)
(defvar *text-gensym-counter* nil)
(defvar *input-links* nil)      ;changed from input-link to *input-links*. -KAM 10/31/89
      

(defvar *input-functions* NIL)  ;added. -KAM 10/31/89
;; start additions for MDW. -KAM  10/31/89
(setq *tab-settings* '(nil))
(defvar *new-tab-settings* t)   ;;; This is a flag. It is used so that do not have to compare
                                ;;; a bunch of tab values for equality. It is true if 
                                ;;; 1. set-tab-settings has been called.
                                ;;; 2. any tab settings appear in text output sent to 
                                ;;;    set-globals (a new function). -MDW 7/30/89
;; end additions for MDW. -KAM  10/31/89

(defvar *input-mappings* nil)   ;added. -KAM 11/1/89
             
(eval-when (compile eval load) (proclaim '(special *in-rhs*)))
                        
;; added. KAM. 4/2/89.
(eval-when (compile eval load) (proclaim '(special *input-stream-mappings*)))
;; added. KAM. 4/2/89.
(eval-when (compile eval load) (proclaim '(special *output-stream-mappings*)))


;;;*****************************************************************************
;;;                        MISCELLANEOUS ACCESS MACROS
;;;*****************************************************************************

;; added. KAM. 2/14/89.
(defun signal-io-top-state-installation (top-state)
 (declare (ignore top-state))
 ;; called by the diplomat when a top state is installed.
 ;; not used at present.
)


;;;*****************************************************************************
;;;                  GLOBAL VARIABLE ACCESS MACROS AND FUNCTIONS
;;;*****************************************************************************
;;; replaced entire section for MDW. -KAM 10/31/89

;;;*****************************************************************************
;;; *text-input*
;;;*****************************************************************************
      
(defmacro set-text-input (z)  `(nlam-set-text-input ',z)) 

(defun nlam-set-text-input (value)   
     (cond ((or (eq value nil) (eq value t))
                (setq *text-input* value))
            (t (soarwarn "SET-TEXT-INPUT: invalid input value" value))))

;;;*****************************************************************************
;;; *text-output*
;;;*****************************************************************************

(defmacro set-text-output (z) `(nlam-set-text-output ',z))

(defun nlam-set-text-output (value)   
     (cond ((or (eq value nil) (eq value t))
                (setq *text-output* value))
            (t (soarwarn "SET-TEXT-OUTPUT: invalid input value" value))))

;;;*****************************************************************************
;;; *text-input-stream*
;;;*****************************************************************************

(defmacro set-text-input-stream (z) `(nlam-set-text-input-stream ',z)) 

(defun nlam-set-text-input-stream (value)   
     (cond ((streamp (eval value))
               (setq *text-input-stream* value))
           (t
               (soarwarn "SET-TEXT-INPUT-STREAM: stream uninitialized" value))))

;;;*****************************************************************************
;;; *text-output-stream*
;;;*****************************************************************************

(defmacro set-text-output-stream (z) `(nlam-set-text-output-stream ',z)) 

(defun nlam-set-text-output-stream (value)   
     (cond ((streamp (eval value))
               (setq *text-output-stream* value))
           (t
               (soarwarn "SET-TEXT-OUTPUT-STREAM: stream uninitialized" value))))

;;;*****************************************************************************
;;; *char-mode*
;;;*****************************************************************************

(defmacro set-char-mode (z) `(nlam-set-char-mode ',z))

(defun nlam-set-char-mode (value)   
     (cond ((or (eq value nil) (eq value t))
               (setq *char-mode* value))
           (t  (soarwarn "SET-CHAR-MODE: invalid input value" value))))

;;;*****************************************************************************
;;; *carriage-control*
;;;*****************************************************************************

(defmacro set-carriage-control (z) `(nlam-set-carriage-control ',z))

(defun nlam-set-carriage-control (value)   
     (cond ((or (eq value nil) (eq value t))
                (setq *carriage-control* value))
           (t (soarwarn "SET-CARRIAGE-CONTROL: invalid input value" value))))

;;;*****************************************************************************
;;; *tab-settings*
;;;*****************************************************************************

(defmacro set-tab-settings (&rest z) `(nlam-set-tab-settings ',z))

(defun nlam-set-tab-settings (values)   
     (cond ((null (first values))
                  (setq *new-tab-settings* t)
                  (setq *tab-settings* '(nil)))
           ((all-numbersp values)              
                  (setq *new-tab-settings* t)
                  (setq *tab-settings* (sort (setify values) #'<))) 
           (t (soarwarn "SET-TAB-SETTINGS: invalid input value" values)))) ;-MDW 11/89 Was "standard."

(defun all-numbersp (a-list)                  
    (let ((all-numbers t)
         )
          (mapc #'(lambda (a) (when (null (numberp a))
                                     (setq all-numbers nil)))
           a-list)
    all-numbers))

(defun setify (a-list)
    (do* ((a-list a-list (rest a-list))
          (an-element (car a-list) (car a-list))
          (the-set nil)
         )
         ((null a-list) the-set)

         (pushnew an-element the-set)))

;;;*****************************************************************************
;;; *input-functions*
;;;*****************************************************************************

(defmacro set-input-functions (z) `(nlam-set-input-functions ',z))

(defun nlam-set-input-functions (functions)
  (setq *input-functions* functions))

;;;*****************************************************************************
;;; *output-mappings*
;;;*****************************************************************************

(defmacro set-output-mappings (z) `(nlam-set-output-mappings ',z))

(defun nlam-set-output-mappings (mappings)
  (setq *output-mappings* (mapcar #'(lambda (mapping) (reverse mapping)) mappings)) ;-MDW 7/30/89
  (setq *output-link-attributes* (mapcar #'first *output-mappings*)))               ; reverse for
                                                                                    ; assoc.
    

;;;*****************************************************************************
;;;                        INITIALIZATION  FUNCTION
;;;*****************************************************************************

;;; Init-io deleted as it been replaced in newandimprovedio.lisp. -BGM 1/31/89
 
;;; restart-io deleted as it been replaced in newandimprovedio.lisp. -BGM 1/31/89

;;;*****************************************************************************
;;;                          BEGIN INPUT FUNCTIONS
;;;*****************************************************************************
                                             
;;; Removed input-cycle as its in newandimprovedio.lisp. -BGM 1/31/89
 

;;;*****************************************************************************
;;; Function: standard-text-input
;;;*****************************************************************************
;; replaced defun for MDW. -KAM 10/31/89
(defun standard-text-input ()
      (let ((input (read-line (eval *text-input-stream*))))  ;-MDW 7/30/89
      (cond (*char-mode*
               (add-input-character-mode input)) 
            (t                                                 ;-MDW 7/30/89 (removed args)
               (add-input-non-character-mode input)))))



;;;***********************************************************************************
;;; Function: add-input-character-mode
;;;***********************************************************************************
    
(defun add-input-character-mode (input-string)
  ;; Added a char=. -BGM 7/14/88.

   (do* ((input input-string)
         (input-length (length input-string))
         (input-index 0 (1+ input-index))                                                             
         (input-link (new-input-link 'standard 'text-input)) ;-MDW 11/89
         (next-text-symbol nil)
         (current-text-symbol (wme-value input-link) next-text-symbol) 
         (current-character nil)
        ) 

       ((>= input-index input-length)   
       ;;; The augmentations added below do not get added to *input-data* --- who would match-input 
       ;;;   on them anyway? -MDW 11/89  

          (add-io-ame (make-ame 'text                 ; add-io-ame & make-ame -MDW 11/89.
                                 current-text-symbol  ; Ditto for below.       
                                'item           
                                'crlf))
                                
          (add-io-ame (make-ame 'text
                                 current-text-symbol
                                'type
                                'cc)))

       (setq current-character (char input input-index))

       (cond ((char= current-character #\space)
                 (add-io-ame (make-ame 'text
                                        current-text-symbol
                                       'item
                                       'space))

                 (add-io-ame (make-ame 'text
                                        current-text-symbol
                                       'type
                                       'cc)))

             (t
                 (add-io-ame (make-ame 'text
                                        current-text-symbol
                                       'item
                                        current-character))

                 (add-io-ame (make-ame 'text
                                        current-text-symbol
                                       'type
                                       'atom))))
                                                          
       (setq next-text-symbol (make-io-object-symbol 'next))   ;-MDW 11/89       
       (add-io-ame (make-ame 'text                             ;-MDW 11/89       
                              current-text-symbol              ;-MDW 11/89       
                             'next                             ;-MDW 11/89       
                              next-text-symbol))))             ;-MDW 11/89       


;;;*****************************************************************************
;;; Function: add-input-non-character-mode
;;;*****************************************************************************

(defun add-input-non-character-mode (input-string)

   (setq *readtable* *alternate-readtable*)                                       

   (do* ((input-link (new-input-link 'standard 'text-input))             ;-MDW 11/89
         (stream-ptr  (make-string-input-stream input-string))  
         (current-item (read-preserving-whitespace stream-ptr nil nil)
                       (read-preserving-whitespace stream-ptr nil nil))
         (current-text-symbol (wme-value input-link))                    ;-MDW 11/89
         (next-text-symbol nil)                                          ;-MDW 11/89
         (this-is-not-the-first-item nil t)    
        )

        ((null current-item)                   
            (when *carriage-control*                    ;-MDW 11/89
                  (when this-is-not-the-first-item
                      (setq next-text-symbol (make-io-object-symbol 'next))
                      (add-io-ame (make-ame 'text 
                                             current-text-symbol
                                            'next
                                             next-text-symbol))
                      (setq current-text-symbol next-text-symbol))

                  (add-io-ame (make-ame 'text
                                         current-text-symbol
                                        'item
                                        'crlf))

                  (add-io-ame (make-ame 'text
                                         current-text-symbol
                                        'type
                                        'cc))))

       (cond ((and (listp current-item)  
                    *carriage-control*
                    (eq (first current-item) 'cc))

                   (when this-is-not-the-first-item                     ;-MDW 11/89
                         (setq next-text-symbol (make-io-object-symbol 'next))
                         (add-io-ame (make-ame 'text 
                                                current-text-symbol
                                               'next
                                                next-text-symbol))

                         (setq current-text-symbol next-text-symbol))

                   (add-io-ame (make-ame 'text
                                          current-text-symbol
                                         'item
                                          (second current-item)))

                   (add-io-ame (make-ame 'text
                                          current-text-symbol
                                         'type
                                         'cc)))


             ((and (listp current-item) 
                   (not (eq (first current-item) 'cc)))

                   (when this-is-not-the-first-item                     ;-MDW 11/89
                         (setq next-text-symbol (make-io-object-symbol 'next))
                         (add-io-ame (make-ame 'text 
                                                current-text-symbol
                                               'next
                                                next-text-symbol))
                         (setq current-text-symbol next-text-symbol))

                   (add-io-ame (make-ame 'text
                                          current-text-symbol
                                         'item
                                          (second current-item)))
                   
                   (add-io-ame (make-ame 'text
                                          current-text-symbol
                                         'type
                                          (first current-item))))

              ((atom current-item)

                   (when this-is-not-the-first-item                     ;-MDW 11/89
                         (setq next-text-symbol (make-io-object-symbol 'next))
                         (add-io-ame (make-ame 'text 
                                                current-text-symbol
                                               'next
                                                next-text-symbol))
                         (setq current-text-symbol next-text-symbol))

                   (add-io-ame (make-ame 'text
                                          current-text-symbol
                                         'item
                                          current-item))

                   (when *carriage-control*
                         (add-io-ame (make-ame 'text
                                                current-text-symbol
                                               'type
                                               'atom))))))
 
        (setq *readtable* *soar-readtable*))
 
;;;*****************************************************************************
;;; Function: intercept-output-links
;;; Set globals is now done in text-output by calling set-globals
;;;*****************************************************************************

(defun intercept-output-links (wme)
    (cond ((and (eq (wme-id wme) (top-state))
                (or (member (wme-attribute wme) *output-link-attributes* :test #'eq)
                    (and (eq (wme-attribute wme) 'text-output)
                         *text-output*)))
               (setq *output-links* (append *output-links* (list wme))))  ;-MDW 8/16/89
          ((eq (wme-attribute wme) 'text-command)                         ;-MDW 8/16/89
               (push wme *output-links*))))                               ;-MDW 8/16/89

;;;*****************************************************************************
;;; Function: set-globals
;;; Description: Called by output-cycle immediately before text-output.
;;; Sets IO globals to values specified in the last text output command.
;;; A lot more of "standard" stuff taken out. -MDW 11/89
;;;*****************************************************************************

(defun set-globals (outputs) 
   (let ((text-input-value-list           (get-output-values 'text-input outputs))
         (text-output-value-list          (get-output-values 'text-output outputs))
         (text-input-stream-value-list    (get-output-values 'text-input-stream outputs))
         (text-output-stream-value-list   (get-output-values 'text-output-stream outputs))
         (carriage-control-value-list     (get-output-values 'carriage-control outputs))
         (char-mode-value-list            (get-output-values 'char-mode outputs))
         (tab-settings-value-list         (get-output-values 'tab-settings outputs))
        )
                                                   

;;; We do not check that there may be conflicting or incorrect global settings. The user must take responsibility for this.

        (when text-input-value-list
              (setq *text-input* (first text-input-value-list)))

        (when text-output-value-list
              (setq *text-output* (first text-output-value-list)))
                                                         
        (when text-input-stream-value-list
              (let ((text-input-stream-value (first text-input-stream-value-list))
                   )
                   (cond ((streamp (eval text-input-stream-value))
                            (setq *text-input-stream* text-input-stream-value))
                         (t (soarwarn 
                              "SET-GLOBALS: invalid value for input stream mapping" 
                              text-input-stream-value)))))
               
        (when text-output-stream-value-list
              (let ((text-output-stream-value (first text-output-stream-value-list))
                   )
                   (cond ((streamp (eval text-output-stream-value))
                            (setq *text-output-stream* text-output-stream-value))
                         (t (soarwarn 
                              "SET-GLOBALS: invalid value for output stream mapping" 
                              text-output-stream-value)))))
               
        (when carriage-control-value-list
              (setq *carriage-control* (first carriage-control-value-list)))
               
        (when char-mode-value-list
              (setq *char-mode* (first char-mode-value-list)))

        (when tab-settings-value-list            
              (setq *new-tab-settings* t)
              (cond ((null (first tab-settings-value-list)) ; A nil among others is not checked for.
                         (setq *tab-settings* '(nil)))
                    (t 
                         (setq *tab-settings* (sort (setify tab-settings-value-list) #'<)))))))




;;;*****************************************************************************
;;; Function: add-in-order
;;; Auxillary function for intercept-output-links-and-set-globals      
;;;*****************************************************************************

(defun add-in-order (a-list an-item)
   (cond ((member an-item a-list :test #'eq)
             a-list)                           ;-MDW 2/3/89
         (t 
            (do* ((old-list a-list (cdr old-list))
                  (old-item (car old-list) (car old-list))
                  (new-list nil)
                 ) 
             
                 ((or (null old-list)
                      (< an-item old-item))
                      (nconc new-list (list an-item) old-list))

                 (setq new-list (nconc new-list (list old-item)))))))


;;;*****************************************************************************
;;; Function: output-cycle
;;; Input is state "link" from *output-links*.
;;;*****************************************************************************

 
;;;
;;; This patch comes from  Arie_Covrigaru@um.cc.umich.edu
;;;
;;; The definition of this function was changed from a do* loop
;;; to a let and loop forms because of weird problems when running
;;; the Hero 2000 on the Apple Macintosh.  The functionality hasn't changed.
;;; The bug number for this is 12Mar90-10.06.22

(defun output-cycle ()
  (let (output-link output-link-attribute outputs)
    (loop
      (if (null *output-links*) (return))
      (setf output-link (pop *output-links*))
      (setf output-link-attribute (wme-attribute output-link))
      (setf outputs (get-output-data output-link))
      (cond ((eq output-link-attribute 'text-command)    ;-MDW 8/16/89
             (set-globals outputs))
            ((and (eq output-link-attribute 'text-output) ;-MDW 11/89
                  *text-output*)
             (standard-text-output outputs))
            (t
             (let ((output-function
                    (second (assoc output-link-attribute *output-mappings*)))
                   )
               (funcall output-function outputs)))))
    ;;; from funcall -MDW 7/30/89
    )
  )



;;;*****************************************************************************
;;; Function: get-output-data
;;; Does an inorder traversal ... returns all augs, but sort of mixed up ...
;;;*****************************************************************************
                                        
(defvar *wmes-1-hash-table* (make-hash-table :test #'equal
                                                :size 1000 
                                                :rehash-size 1000 
                                                :rehash-threshold 0.8)
        "hash table for speeding up the conditions calculations")

(defun get-output-data (output-link)
;; Bug fix for 18Feb91-16.26.28 27-May-91. BGM
;; Bug fix for 18Feb91-16.26.28 11-Mar-91 GAP
     (get-output-data-aux 
         (when (symbolp (wme-value output-link)) (get (wme-value output-link) 'wmpart*))
	 (list output-link)))

;; Nconc to append. -BGM 6/14/88.

(defun get-output-data-aux (wm-data output-augs) 
  ;;
  ;; Changed to output the TC under the link
  ;; Fixed bug report #16Jul90-16.02.50 08.Jan.90 GAP
  ;; Fixed bug report #01Feb91-00.41.54 28.Jan.90 GAP

  (prog (output-augs-ht) 

  (setq output-augs-ht *wmes-1-hash-table*)

  (dolist (wme output-augs)
    (setf (gethash wme output-augs-ht) wme))

  (do* ((wmes wm-data     (cdr wmes)))
       ((null wmes) NIL)
    (let ((wme (caar wmes)))

       (if (object-onode (wme-value wme))
           (dolist (elem (get (wme-value wme) 'wmpart*))
                (if (not (gethash (car elem) output-augs-ht))
                    (setf wmes (append wmes (list elem))) )
           )
        )
       (if (not (gethash wme output-augs-ht))
           (progn
              (setf (gethash wme output-augs-ht) wme)
              (push wme output-augs) ) 
        )
    ) )

   ;;
   ;; Clean up output-augs-ht
   ;;
     (dolist (output-aug output-augs)
         (remhash output-aug output-augs-ht))

     (return (nreverse output-augs))
))
    
;;;*****************************************************************************
;;; Function: standard-text-output
;;; Comment: Terry Weymouth's fixes.
;;;*****************************************************************************

;; replaced defun for MDW. -KAM 10/31/89
(defun standard-text-output (outputs
;; forced output out in case of non terminal output. Bug #16Oct90-16.24.00
;; 12/Nov/90 Gap
   &aux                                 ;; added stream and check for stream
                                        ;; TEW 8/12/88
        (s (and (streamp (eval *text-output-stream*))  ;-MDW 7/30/89 (eval added)
                (eval *text-output-stream*))))
   (unless s
       (soarwarn "STANDARD-TEXT-OUTPUT: stream not set -- using standard-output" s)
       (setq s *standard-output*)
        )
          
;;; Do setup changed because of IO globals going through output. -MDW 7/30/89
   (do* ((current-id (first (get-output-values 'text-output outputs))  ;The first one is the link value.
                     (first (get-output-values 'next current-augs)))
         (current-augs (get-output-augmentations current-id outputs)
                       (get-output-augmentations current-id outputs))
         (type (first (get-output-values 'type current-augs)) (first (get-output-values 'type current-augs)))
         (item (first (get-output-values 'item current-augs)) (first (get-output-values 'item current-augs)))
         (tab-position nil nil)
        )
        ((null current-augs) t)

        (cond ((eq type 'cc)                        ; We must specify cc in item
                 (cond                              ;  even when not in cc mode.
                       ((eq item 'space)          
                          (setq *current-column* (1+ *current-column*))
                          (princ " " s))            ;; added s; TEW 8/12/88
                         
                       ((eq item 'tab)              ; Assume tab settings are in order.
                          (do* ((tab-settings *tab-settings* (cdr tab-settings)) 
                                (tab-setting (car tab-settings) (car tab-settings))  
                               )
                                ((or (null tab-setting)
                                     (> tab-setting *current-column*)) 
                               
                                     (setq tab-position tab-setting)))
                               
                          (cond ((null tab-position)
                                    (setq *current-column* (1+ *current-column*))
                                    (princ " " s))  ;; added s; TEW 8/12/88
                                (t 
                                    (do ((space-count (- tab-position *current-column*) (1- space-count))
                                        )   
                                        ((= space-count 0) nil)
                           
                                        (princ " " s))  ;; added s; TEW 8/12/88
                                    (setq *current-column* tab-position) )))                     


                       ((eq item 'crlf)
                          (setq *current-column* 0)
                          (terpri s))))              ;; added s; TEW 8/12/88
              ((eq type 'tabto)     
                     (terpri)
                     (do ((space-count item (1- space-count))
                         )   
                         ((= space-count 0) nil)
                         (princ " " s))              ;; added s; TEW 8/12/88
                     (setq *current-column* item))
              ((eq type 'atom) 
                 (cond ((numberp item)  
                           (setq *current-column* (+ (number-length item) *current-column*)))
                       (t 
                           (setq *current-column* (+ (length (string item)) *current-column*))))
                 (princ item s))))                  ;; added s; TEW 8/12/88
    (force-output s)   ; Added 12-Nov-90 Gap
)
   
(defun number-length (number)
   (do ((places 0 (1+ places))
       ) 
       ((>= 0 number) places)                                        

       (setq number (truncate (/ number 10.0))) ))


;;;*****************************************************************************
;;; Function: update-IO-globals-in-wm
;;; Description: Called by input-cycle immediately before text-input.
;;; Updates IO global settings in WM to reflect values specified by the text 
;;; environment. Text environment is specified by the IO globals and current text.
;;; A lot more of "standard" stuff taken out. -MDW 11/89
 ;; Settings to status in reponse to bug-report 19Sep90-22.02.21 GAP 09/27/90
;;;*****************************************************************************

;;;*****************************************************************************
;;; Function: update-IO-globals-in-wm
;;; Description: Called by input-cycle immediately before text-input.
;;; Updates IO global settings in WM to reflect values specified by the text 
;;; environment. Text environment is specified by the IO globals and current text.
;;; A lot more of "standard" stuff taken out. -MDW 11/89
 ;; Settings to status in reponse to bug-report 19Sep90-22.02.21 GAP 09/27/90
;;;*****************************************************************************

(defun update-IO-globals-in-wm ()   
        (let ((text-environment-link-value (wme-value (get-input-link 'text-environment 'text-environment)))
             )
        (when (null (eq *text-input* (wme-value *text-input-augmentation*)))

                     (delete-input 'text-environment  ;;; Deletes nothing on the first call since *unbound* is value. Ditto below.
                                   'status
                                    text-environment-link-value 
                                   'text-input
                                    (wme-value *text-input-augmentation*))

                     (setq *text-input-augmentation*
                           (add-input 'text-environment 
                                      'status
                                       text-environment-link-value 
                                      'text-input
                                       *text-input*)))


        (when (null (eq *text-output* (wme-value *text-output-augmentation*)))
                     (delete-input 'text-environment
                                   'status
                                    text-environment-link-value 
                                   'text-output
                                    (wme-value *text-output-augmentation*))

                     (setq *text-output-augmentation*
                           (add-input 'text-environment 
                                      'status
                                       text-environment-link-value 
                                      'text-output
                                       *text-output*)))

        (when (null (eq *text-input-stream* (wme-value *text-input-stream-augmentation*)))
                     (delete-input 'text-environment
                                   'status
                                    text-environment-link-value 
                                   'text-input-stream
                                    (wme-value *text-input-stream-augmentation*))

                     (setq *text-input-stream-augmentation*
                           (add-input 'text-environment
                                      'status
                                       text-environment-link-value 
                                      'text-input-stream
                                      *text-input-stream*)))
                                                         
        (when (null (eq *text-output-stream* (wme-value *text-output-stream-augmentation*)))
                     (delete-input 'text-environment
                                   'status
                                    text-environment-link-value 
                                   'text-output-stream
                                    (wme-value *text-output-stream-augmentation*))

                     (setq *text-output-stream-augmentation*
                           (add-input 'text-environment
                                      'status
                                       text-environment-link-value 
                                      'text-output-stream
                                      *text-output-stream*)))
                                                         

        (when (null (eq *carriage-control* (wme-value *carriage-control-augmentation*)))
                     (delete-input 'text-environment
                                   'status
                                    text-environment-link-value 
                                   'carriage-control
                                    (wme-value *carriage-control-augmentation*))

                     (setq *carriage-control-augmentation*
                           (add-input 'text-environment
                                      'status
                                       text-environment-link-value 
                                      'carriage-control
                                       *carriage-control*)))
               
        (when (null (eq *char-mode* (wme-value *char-mode-augmentation*)))
                     (delete-input 'text-environment
                                   'status
                                    text-environment-link-value 
                                   'char-mode
                                    (wme-value *char-mode-augmentation*))

                     (setq *char-mode-augmentation*
                           (add-input 'text-environment
                                      'status
                                       text-environment-link-value 
                                      'char-mode
                                       *char-mode*)))

        (when *new-tab-settings*                  
                     (setq *new-tab-settings* nil)
                     (mapc #'(lambda (tab-setting-augmentation)
                                      (delete-input 'text-environment
                                                    'status
                                                     text-environment-link-value 
                                                    'tab-settings
                                                     (wme-value tab-setting-augmentation)))
                     *tab-settings-augmentations*)
                     (setq *tab-settings-augmentations* nil)
                     (cond ((null (first *tab-settings*))
                                 (setq *tab-settings-augmentations* 
                                       (list (add-input 'text-environment
                                                        'status
                                                         text-environment-link-value 
                                                        'tab-settings
                                                         nil))))
                           (t
                                (mapc #'(lambda (tab-setting)
                                            (push (add-input 'text-environment
                                                             'status
                                                              text-environment-link-value 
                                                             'tab-settings
                                                              tab-setting)
                                                   *tab-settings-augmentations*))
                                 (reverse *tab-settings*)))))))


;;;*****************************************************************************
;;; Function: copy-links-and-io-settings 
;;; A lot of fixes below...a basic rewrite, so no comments on fixes. -MDW 2/1/89
;;;*****************************************************************************

;;;*****************************************************************************
;;;                        BEGIN ALTERED FUNCTIONS
;;;*****************************************************************************

;;;*****************************************************************************
;;; Function: save-wme-as-result-or-non-result
;;; Alteration: Return in-id-field of max-depth-goal. Solution to problem where
;;;             top-level state was returned instead of a goal.
;;;*****************************************************************************







;;;*****************************************************************************
;;;                           READTABLE FUNCTIONS
;;;*****************************************************************************
                          
;;; Three functions moved up into module sptop so that ^ reads before we get
;;; here. -BGM 7/28/88
;;; Two more ( ~, !) moved up to Sptop/lexer.lisp for DSM. -BGM 7/31/88

(defun create-alternate-readtable ()
  ;; Renamed read-ampersand to read-at-sign, and read-and-sign to read-ampersand. -BGM 7/30/88
  (setq *alternate-readtable* (copy-readtable nil))
  (set-macro-character #\!       #'read-exclamation-point nil *alternate-readtable*)
  (set-macro-character #\@       #'read-at-sign nil *alternate-readtable*)
  (set-macro-character #\#       #'read-pound-sign nil *alternate-readtable*)
  (set-macro-character #\$       #'read-dollar-sign nil *alternate-readtable*)
  (set-macro-character #\%       #'read-percent-sign nil *alternate-readtable*)   
  (set-macro-character #\^       #'read-circumflex nil *alternate-readtable*)
  (set-macro-character #\&       #'read-ampersand nil *alternate-readtable*)
  (set-macro-character #\*       #'read-asterisk nil *alternate-readtable*)
  (set-macro-character #\(       #'read-left-parenthesis nil *alternate-readtable*)
  (set-macro-character #\)       #'read-right-parenthesis nil *alternate-readtable*)
  (set-macro-character #\_       #'read-underline nil *alternate-readtable*)
  (set-macro-character #\-       #'read-hyphen-minus nil *alternate-readtable*)  
  (set-macro-character #\+       #'read-plus nil *alternate-readtable*)
  (set-macro-character #\=       #'read-equals nil *alternate-readtable*)
  (set-macro-character #\~       #'read-tilde nil *alternate-readtable*)
  (set-macro-character #\`       #'read-front-quote nil *alternate-readtable*)
  (set-macro-character #\{       #'read-left-bracket nil *alternate-readtable*)
  (set-macro-character #\[       #'read-left-square-bracket nil *alternate-readtable*)
  (set-macro-character #\}       #'read-right-bracket nil *alternate-readtable*)
  (set-macro-character #\]       #'read-right-square-bracket nil *alternate-readtable*)
  (set-macro-character #\:       #'read-colon nil *alternate-readtable*)
  (set-macro-character #\;       #'read-semicolon nil *alternate-readtable*)
  (set-macro-character #\"       #'read-double-quote nil *alternate-readtable*)
  (set-macro-character #\'       #'read-backquote nil *alternate-readtable*)
  (set-macro-character #\|       #'read-vertical-line nil *alternate-readtable*)
  (set-macro-character #\\       #'read-backslash nil *alternate-readtable*)
  (set-macro-character #\<       #'read-less-than nil *alternate-readtable*)
  (set-macro-character #\,       #'read-comma nil *alternate-readtable*)
  (set-macro-character #\>       #'read-greater-than nil *alternate-readtable*)
  (set-macro-character #\.       #'read-period nil *alternate-readtable*)
  (set-macro-character #\?       #'read-question-mark nil *alternate-readtable*)
  (set-macro-character #\/       #'read-forward-slash nil *alternate-readtable*)

  (set-macro-character #\space   #'read-space nil *alternate-readtable*)
  (set-macro-character #\newline #'read-newline nil *alternate-readtable*))
 
(defun read-exclamation-point (stream char)
  ;; Added when BDW noticed that it was missing. -BGM 2/8/89
  (declare (ignore stream char))
  #\!)

(defun read-tilde (stream char)
  ;; Added when BDW noticed that it was missing. -BGM 2/8/89
  (declare (ignore stream char))
  #\~)

(defun read-ampersand (stream char)
  ;; Renamed from read-and-sign to read-ampersand, as that is what #\& is called. -BGM 7/30/88
   (declare (ignore stream char))
   #\&)

(defun read-at-sign (stream char)
  ;; Renamed from read-ampersand to read-at-sign, as that is what #\@ is called. -BGM 7/30/88
   (declare (ignore stream char))
   #\@) 

(defun read-pound-sign (stream char)
   (declare (ignore stream char))
   #\#) 

(defun read-dollar-sign (stream char)
   (declare (ignore stream char))
   #\$) 

(defun read-percent-sign (stream char)
   (declare (ignore stream char))
   #\%) 

(defun read-circumflex (stream char)
   (declare (ignore stream char))
   #\^) 

(defun read-asterisk (stream char)
   (declare (ignore stream char))
   #\*) 

(defun read-left-parenthesis (stream char)
   (declare (ignore stream char))
   #\() 

(defun read-right-parenthesis (stream char)
   (declare (ignore stream char))
   #\)) 

(defun read-underline (stream char)
   (declare (ignore stream char))
   #\_) 

(defun read-hyphen-minus (stream char)
   (declare (ignore stream char))
   #\-) 

(defun read-plus (stream char)
   (declare (ignore stream char))
   #\+) 

(defun read-equals (stream char)
   (declare (ignore stream char))
   #\=) 
 
(defun read-front-quote (stream char)
   (declare (ignore stream char))
   #\`) 

(defun read-left-bracket (stream char)
   (declare (ignore stream char))
   #\{) 

(defun read-left-square-bracket (stream char)
   (declare (ignore stream char))
   #\[) 

(defun read-right-bracket (stream char)
   (declare (ignore stream char))
   #\}) 

(defun read-right-square-bracket (stream char)
   (declare (ignore stream char))
   #\]) 

(defun read-colon (stream char)
   (declare (ignore stream char))
   #\:) 

(defun read-semicolon (stream char)
   (declare (ignore stream char))
   #\;) 

(defun read-double-quote (stream char)
   (declare (ignore stream char))
   #\") 

(defun read-backquote (stream char)
   (declare (ignore stream char))
   #\')                    

(defun read-vertical-line (stream char)
   (declare (ignore stream char))
   #\|) 

(defun read-backslash (stream char)
   (declare (ignore stream char))
   #\\) 

(defun read-less-than (stream char)
   (declare (ignore stream char))
   #\<) 

(defun read-comma (stream char)
   (declare (ignore stream char))
   #\,) 

(defun read-greater-than (stream char)
   (declare (ignore stream char))
   #\>) 

(defun read-period (stream char)
   (declare (ignore stream char))
   #\.) 

(defun read-question-mark (stream char)
   (declare (ignore stream char))
   #\?) 

(defun read-forward-slash (stream char)
   (declare (ignore stream char))
   #\/) 

(defun read-space (stream char)
   (declare (ignore stream char))
   '(cc space)) 
         
(defun read-newline (stream char)
   (declare (ignore stream char))
   '(cc crlf)) 
   
;;;*****************************************************************************
;;;                    WRITE EXPANSION MACRO & FUNCTIONS
;;;*****************************************************************************

;;;*****************************************************************************
;;; Function: sp-aux
;;;*****************************************************************************

; This functionality is now in Compiled-sp.
;(defun sp-aux (a-list)
;  #+:soar-times (start-soar-time sp)
;       (cond ((write-expansion a-list)
;	      (nlam-sp (sp-write-expand a-list (get-used-symbols a-list))))
;             (t (nlam-sp a-list))))

;;;*****************************************************************************
;;; Function: write-expansion
;;; Checks for write.
;;;*****************************************************************************

(defun write-expansion (a-list)
   (do* ((a-list a-list (cdr a-list))
         (list-elt (car a-list) (car a-list))
         (write-found nil)
        )   

         ((null list-elt) write-found)
                      
         (when (and (listp list-elt)
                    (or (eq (car list-elt) 'write1+)
                        (eq (car list-elt) 'write2+)))

               (setq write-found t))))

;;;*****************************************************************************
;;; Function: get-used-symbols
;;; Gets symbols starting with a #\t or #\T.
;;;*****************************************************************************

(defun get-used-symbols (a-list)
  ;; Added a few char='s. -BGM 9/14/88.
   (do* ((a-list a-list (cdr a-list))
         (list-elt (car a-list) (car a-list))
         (the-variables nil)
        )   
          
        ((null a-list) the-variables)
                                                                         
         (when (listp list-elt)
              (setq the-variables (nconc the-variables 
              (do* ((a-list list-elt (cdr a-list))
                    (an-elt (car a-list) (car a-list))
                    (the-variables nil)
                   )

                  ((null a-list) the-variables)

                  (when (and (null (listp an-elt))
                             (char= (char (string an-elt) 0) #\<)  
                             (or (char= (char (string an-elt) 1) #\t)
                                 (char= (char (string an-elt) 1) #\T)))
                         (setq the-variables (nconc the-variables (list an-elt))))))))))

;;;*****************************************************************************
;;; Function: reset-textgansym
;;;*****************************************************************************
(defun reset-textgensym ()
   (setq *text-gensym-counter* 0))

;;;*****************************************************************************
;;; Function: textgensym
;;;*****************************************************************************       

(defun textgensym (used-symbols)  
   (do ((new-text-symbol 
	 (intern (format () "<T~A>" (incf *text-gensym-counter*)))
	  (intern (format () "<T~A>" (incf *text-gensym-counter*))))
       )
	  ;; #'equal and does it want to be an eq, eql, string= or what ? Eq I think. -BGM 1/13/88.
       ((null (member new-text-symbol used-symbols :test #'eq))
              new-text-symbol)))

;;;*****************************************************************************
;;; Function: sp-write-expand
;;;*****************************************************************************

(defun sp-write-expand (a-list used-symbols)
;; Added parallel and acceptable preferences to the text RHS to advoid
;; a micro impasse when 2 productions with write1+ and/or write2+ fire
;; in the same elaboration cycle. Bug #06May90-23.28.24 GAP 5/6/90
   (reset-textgensym)                          

   (let ((expanded-production (list (car a-list)))    
         (first-symbols-in-series nil)
         (last-symbols-in-series nil)                   
         (top-level-goal      (textgensym used-symbols)) ;-MDW 11/89
         (top-level-state     (textgensym used-symbols)) ;-MDW 11/89
         (output-link-pointer (textgensym used-symbols)) ;-MDW 11/89
        )                    
                                                
   (setq a-list (cdr a-list))
	;; This append is probably a wise idea as some lisp's think that they
        ;; own the conses of the body of any macro. -BGM 1/13/88.
   ;; added DSM top goal test. -KAM. 4/1/89.

                      ;-MDW 11/89
   (setq expanded-production (append expanded-production
          (list (list 'GOAL
                       top-level-goal                   ;-MDW 11/89
                      '^ 'OBJECT
                      'NIL
                      '^ 'STATE 
                       top-level-state))))              ;-MDW 11/89

   (do* ((symbols-and-expanded-write nil nil)
         (a-list a-list (cdr a-list))
         (list-elt (car a-list) (car a-list))
         (first-symbol output-link-pointer)   ;-MDW 11/89
        )   
        ((null a-list) nil)
              
        (cond ((and (listp list-elt)
                    (eq (car list-elt) 'write1+))
                      (setq symbols-and-expanded-write (write-expand list-elt used-symbols first-symbol 1)) ;-MDW 11/89
                      (setq first-symbol nil)) ;-MDW 11/89
              ((and (listp list-elt)
                    (eq (car list-elt) 'write2+))
                      (setq symbols-and-expanded-write (write-expand list-elt used-symbols first-symbol 2)) ;-MDW 11/89
                      (setq first-symbol nil))) ;-MDW 11/89

        (cond (symbols-and-expanded-write
                    (let ((first-symbol-in-series (first symbols-and-expanded-write))
                          (last-symbol-in-series (second symbols-and-expanded-write))
                          (expanded-write (third symbols-and-expanded-write))
                         )
                          (setq first-symbols-in-series (append first-symbols-in-series 
                                                                (list first-symbol-in-series)))
                          (setq last-symbols-in-series (append last-symbols-in-series 
                                                               (list last-symbol-in-series)))
                          (setq expanded-production (append expanded-production
                                                                expanded-write))))
              (t
                      (setq expanded-production (append expanded-production (list list-elt)))
                      (when (and (atom list-elt)
                                 (eq list-elt '-->))
                               (setq expanded-production (append expanded-production                     ;-MDW 11/89
                                                                 (list (list 'STATE                      ;-MDW 11/89
                                                                              top-level-state            ;-MDW 11/89
                                                                             '^ 'TEXT-OUTPUT             ;-MDW 11/89
                                                                              output-link-pointer '+ '&))))))));-GAP 05/07/90

   (pop first-symbols-in-series)

   (do* ((a-list expanded-production (cdr a-list))     
         (list-elt (car a-list) (car a-list))
         (expanded-expanded-production nil)
        )  

       ((null a-list) expanded-expanded-production) 
              
       (cond  ((and (listp list-elt)                                    
                    (< 1 (length last-symbols-in-series))
                    (eq (first last-symbols-in-series) (second list-elt)))
                  (setq expanded-expanded-production (append expanded-expanded-production
                                                             (list list-elt)))
                  (setq expanded-expanded-production (append expanded-expanded-production 
                                                             (list (list 'text
                                                                          (first last-symbols-in-series)
                                                                         '^ 'next
                                                                          (first first-symbols-in-series)))))

                  (pop first-symbols-in-series)
                  (pop last-symbols-in-series))

              (t
                  (setq expanded-expanded-production (append expanded-expanded-production 
                                                             (list list-elt))))))))


;;;*****************************************************************************
;;; Function: write-expand
;;; Changes: All occurances of class TEXT-OUTPUT were changed to TEXT. -MDW 2/23/89
;;;*****************************************************************************

(defun write-expand (list-elt used-symbols first-symbol write-mode) ;-MDW 11/89
  (do* ((output (cdr list-elt) (cdr output))
        (output-item (car output) (car output))
        (first-symbol (cond (first-symbol first-symbol)      ;-MDW 11/89
                            (t (textgensym used-symbols))))  ;-MDW 11/89
        (current-symbol first-symbol next-symbol)
        (expanded-write nil)  
        (next-symbol nil)
        )                                       
 
        ((null output) (list first-symbol current-symbol expanded-write))                  ;Exit condition.

        (cond ((equal output-item '(crlf))
                  (setq expanded-write (nconc expanded-write 
                                               (list (list 'text              ;-MDW 2/23/89
                                                            current-symbol
                                                           '^ 'type
                                                           'cc))

                                               (list (list 'text              ;-MDW 2/23/89
                                                            current-symbol
                                                           '^ 'item
                                                           'crlf)))))
   
              ((equal output-item '(tab))
                  (setq expanded-write (nconc expanded-write 
                                               (list (list 'text              ;-MDW 2/23/89
                                                            current-symbol
                                                           '^ 'type
                                                           'cc))

                                               (list (list 'text              ;-MDW 2/23/89
                                                            current-symbol
                                                           '^ 'item
                                                           'tab)))))
   
              ((and (listp output-item)
                    (eq (car output-item) 'tabto))
                  (setq expanded-write (nconc expanded-write 
                                               (list (list 'text              ;-MDW 2/23/89
                                                            current-symbol
                                                           '^ 'type
                                                           'tabto))
                                               (list (list 'text              ;-MDW 2/23/89
                                                            current-symbol
                                                           '^ 'item
							   ;; Changed from output to item. -BGM 6/14/88.
                                                           (cadr output-item))))))

              (t 
                  (setq expanded-write (nconc expanded-write 
                                               (list (list 'text              ;-MDW 2/23/89
                                                            current-symbol
                                                           '^ 'type
                                                           'atom))
                                               (list (list 'text              ;-MDW 2/23/89
                                                            current-symbol
                                                           '^ 'item
                                                            output-item))))))

              (when (< 1 (length output))                                  
                  (setq next-symbol (textgensym used-symbols))
                  (setq expanded-write (nconc expanded-write 
                                               (list (list 'text              ;-MDW 2/23/89
                                                            current-symbol
                                                           '^ 'next
                                                            next-symbol))))
                                    
                  (when (= write-mode 1)
                            (setq current-symbol next-symbol)
                            (setq next-symbol (textgensym used-symbols))

                            (setq expanded-write (nconc expanded-write 
                                                         (list (list 'text    ;-MDW 2/23/89
                                                                      current-symbol
                                                                     '^ 'type
                                                                     'cc))

                                                         (list (list 'text    ;-MDW 2/23/89
                                                                      current-symbol
                                                                     '^ 'item
                                                                     'space))

                                                         (list (list 'text    ;-MDW 2/23/89
                                                                      current-symbol
                                                                     '^ 'next
                                                                      next-symbol))))))))



;; Put back here. -BGM 3/9/89
(eval-when (eval load)
   (create-alternate-readtable)
  ;; addition for MDW. -KAM 10/31/89
  (set-text-input-stream *standard-input*)
  (set-text-output-stream *standard-output*)
   )                                          



;;; Concatenated from type module "io" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/io/new/newandimprovedio.lisp".
(in-package "SOAR")

;;;****************************************************************************
;;;
;;;       Title: New Code for Soar IO Input.
;;;  Written by: Mark Wiesmeyer
;;;        Date: 11/17/88
;;;
;;;  Description:
;;;     The following code replaces much of the code related to user input 
;;; functions in Soar IO. Text IO is completely unaffected.             

;;; Repair History
;;; 1. Changed *input-data* setq to a commented defvar. -MDW 1/31/89
;;; 2. Changed all mapcar's (except the last) to mapc's in MATCH-INPUT. -MDW 1/31/89
;;; 3. Changed temp construct to lets in MATCH-INPUT. -MDW 1/31/89
;;; 4. Changed suite of MATCH-INPUT functions to label format. -MDW 1/31/89
;;; 5. Changed &rest to &optional in ADD-INPUT (affects some checking code). -MDW 1/31/89
;;; 6. Changed some cons to pushes in MATCH-VALUE part of MATCH-INPUT. -MDW 1/31/89
;;; 7. Added *break-char* global, macro, and fix in main loop. -MDW 1/31/89     

;;; New global variable.

(defvar *input-data* '((dummy))                                    ;-MDW 1/31/89
 "Analog of *input-links* for keeping track of input data items.")

(defvar *break-char* #\newline
  ;; Added documentation string. -BGM 1/31/89
  ;-MDW 1/31/89
  "The character that causes Soar IO to break when found at the beginning of the line.")

(defmacro set-break-char (&optional value)
  "Set the break character for Soar IO. Defaults to #\newline."
  ;; Made value optional so that (set-break-char) ==> *break-char*, so that
  ;; we need never document *break-char*. This way a user won't directly
  ;; setq it and break MAIN.
  ;; Got rid of the nlam stuff as that is a hideous old franz lisp convention
  ;; that we should not be using. -BGM 1/31/89.
  ;;-MDW 1/31/89
  `(cond ((null ,value) *break-char*)
	 ((characterp ,value) (setq *break-char* ,value))
	 (t (soarwarn "SET-BREAK-CHAR: invalid input value" ,value))))


;;;*****************************************************************************
;;; Function: Main
;;; Is most up to datest. Has all fixes for Soar 4 including fix for break 
;;; on null line.
;;;*****************************************************************************
                                 ; of input data pointers. 
;; Moved to rete/new/rhs.lisp, but a copy has been retained here. -BGM 1/31/89
#|
(defun main nil
  ;;Deleted a bunch of setqs for Soar IO. -BGM 3/29/89
  ;; Merged with MDW's version of 1/31/89. -BGM 1/31/89
  ;; Turned **break** back into an atom, from a string. -BGM 1/31/89
  ;; Updated for interrupts during the . -BGM 8/23/88
  ;; Updated old style IO to soar-format. -BGM 8/18/88
  ;; Progs and gotos replaced. MDW 10/11/88.
  ;; Output bug fixed. MDW 10/7/88.
  ;; Added some soar times calls around IO calls. BGM 8/4/88.
  ;; Installed for SoarIO from Wiesmeyer by BGM 8/3/88.
  ;; Merged with RHS's version of main by BGM 6/13/88.
  ;; This consisted solely of adding soar time calls.
  ; Randy.Gobbel 12-Sep-86 12:08 
   #+:soar-times (start-soar-time rhs)  
       (let ((r nil)
            )

            (setq *halt-flag* nil)
            (setq *break-flag* nil)
            (setq *elaborations-count* 0)

            (do ((phase-set nil)                                                           
                )

              ((or *halt-flag*                ;Exit conditions from loop.
                   (zerop *remaining-decide*)  
                   (zerop *remaining-cycles*)
                   *break-flag*  
                   (and (listen *standard-input*)  ;;; MDW 1/12/88.
                        (eq (peek-char) *break-char*) ;;; Break on null line is the default. -MDW 1/31/89
                        (read-char *standard-input*))
		   ;; If the IO package is not reading, and the  is not in and the listener
		   ;; has input waiting, then break.
		   (and (not *text-input*) (soarlisten))
                   (cond (*halt-flag*
                            (setq r "End -- Explicit Halt"))  
			 (t (setq r '***break***))))
   
                (when (and (not (eq (top-level-state-id) 'undecided))   
                           (not (eq *phase* 'decide))) 
                      #+:soar-times (stop-soar-time rhs)
                      (input-cycle))
   
                #+:soar-times (start-soar-time rhs)
                (setq *first-remove* (setq *first-action* t))
                (setq phase-set (conflict-resolution))   

                (cond ((eq *phase* 'decide)
		        (decf *remaining-cycles*)
			(decf *remaining-decide*)
			(incf *cycle-count*)
			(incf *decide-count*)
			(setq *p-name* nil)
			(setq *elaborations-count* 0)
			(setq *in-rhs* t)
			#+:soar-times (stop-soar-time rhs)
			(process-decide)  
			#+:soar-times (start-soar-time rhs)
			(when (not (eq (top-level-state-id) *last-top-level-state-id*))
			  #+:soar-times (stop-soar-time rhs)
			  (copy-links-and-io-settings)
			  #+:soar-times (start-soar-time rhs)
			  
			  (setq *last-top-level-state-id* (top-level-state-id))
			  ;Deleted a bunch of setqs for Soar IO. -BGM 3/29/89
			  )

			  (setq *in-rhs* nil)
			(setq *phase* 'elaborate))

                      ((not phase-set) (setq *phase* 'decide))

		      (t (incf *cycle-count*)
			 (when (and *wtrace* (trace-problem-space?))
			       (soar-format *trace-file* "~%--Elaboration Phase--"))
		            (mapc #'process-instance phase-set)

;;; Fix on Oct 7, 1988 MDW.
;;; Begin alteration.
	                    #+:soar-times (stop-soar-time rhs)
                            (output-cycle) ; New for Soar I/O. 
          	            #+:soar-times (start-soar-time rhs)
                            (setq *output-links* nil)
;;; End alteration.

		            #+:soar-times (stop-soar-time rhs)
		            (create-production)
		            #+:soar-times (start-soar-time rhs)
		            (decf *remaining-cycles*)
		            (incf *elaborations-count*)
		            (when (eqp *max-elaborations* *elaborations-count*)
			             (soarwarn 
                                         "Exceeded *max-elaborations*. Proceeding to decision procedure."
                                         *max-elaborations*
                                     )
                                     (setq *phase* 'decide)))))
 ;End of DO.

                (setq *p-name* nil)
	        (soar-format *trace-file* "~%")
	        #+:soar-times (stop-soar-time rhs)
	        r))
|#
             
 
;Installed changed input-cycle as described by MDW below. -KAM 6/14/89
;The attention-message stuf in input-cycle has been removed. This makes
;it necessary for all user-input functions to be rewritten so that they
;do not require their third argument (the attention message). As it turned
;out attention messages are easily taken care of by output. The doco for
;Groningen will reflect this change. It is a temporary inconvenience for
;current users, but will help to demystify the architecture. -MDW

 
;;;*****************************************************************************
;;; Function: input-cycle
;;; Description: Called by main. In turn it calls each of the user input 
;;; functions using "funcall". 
;;;*****************************************************************************

;; replaced defun for MDW. -KAM 10/31/89
(defun input-cycle ()                    
   (update-IO-globals-in-wm)
   (when (and *text-input* (listen (eval *text-input-stream*)))
	 (let ((*current-goal*
           (top-state)
        )
	       (*in-rhs* t))
	   (standard-text-input) 
	   ))
   (do* ((input-functions *input-functions* (cdr input-functions))
         (input-function (car input-functions) (car input-functions))

;;; Input-mappings and input-link-attributes removed. -MDW 7/30/89
;;; Input-parameters removed -MDW 7/30/89
;;; Attention stuff removed. -MDW 6/1/89
        )
                   
        ((null input-functions) t)     


; Poll input functions
                                                      
        (let ((*current-goal*                        ;Get state stuff right.
                 (top-state)
              )
	             (*in-rhs* t)                           ;Be very careful here ...
              (*first-action* t) 
              (*data-matched* nil)
             )

             (setf (get *current-goal* 'goal-depth) 1.5)

             (funcall input-function)
;;; Attention stuff removed. -MDW 6/1/89
        )))                 


;;; removed new-input-link. the new version is below. -KAM 11/3/89


;;;*****************************************************************************
;;; Function: add-input
;;; Description: Adds new input item into working memory and also places a 
;;; pointer to it in *input-data*. It is not allowed for the users to place
;;; input data into working memory that has 'state as its class for obvious
;;; reasons.
;;;*****************************************************************************

;; replaced defun for MDW. changed external-add-ame to add-io-ame. -KAM 10/31/89
(defun add-input (owner class id attribute &optional (value '*unbound*))  ;-MDW 1/31/89 ;-MDW 3/3/89
 ;; changed external-add-ame to add-io-ame. -KAM 10/31/89
   (let ((add-aug nil)
         (owner-data nil)
         (class-data nil)
         (id-data nil)
         (attribute-data nil)
         (value-data nil)               
        )
                                                 
      ;;; Deleted check for using add-input for input links. -MDW 7/30/89

      (when (eq value '*unbound*)                            ;-MDW 1/31/89 ;-MDW 3/3/89
            (setq value (make-io-object-symbol attribute)))  ;<== DSM                                                         

      ;; Bug from last version. Did not have the numberp predicate.
      (when (or (symbolp value) (numberp value)) ;MDW 12/19/88
        (setq add-aug (list class id attribute value))
           

      (setq owner-data (assoc owner *input-data*))
      (cond (owner-data 
               (setq class-data (assoc class (cdr owner-data))) ; Added CDR. -BGM 3/29/89
               (cond (class-data
                        (setq id-data (assoc id (cdr class-data))) ; Added CDR. -BGM 3/29/89
                        (cond (id-data
                                 (setq attribute-data (assoc attribute (cdr id-data)))    
				 ; Added CDR. -BGM 3/29/89
                                 (cond (attribute-data 
                                           (setq value-data (assoc value (cdr attribute-data)))
					   ; Added CDR. -BGM 3/29/89
                                                (when (null value-data)
                                                      (nconc attribute-data (list (list value add-aug)))
                                                      (add-io-ame add-aug) 
                                                      add-aug))           ;MDW 12/19/88
                                       (t 
                                          (nconc id-data (list (list attribute
                                                               (list value add-aug))))
                                          (add-io-ame add-aug)
                                          add-aug)))          ;MDW 12/19/88
                              (t 
                                 (nconc class-data (list (list id
                                                         (list attribute
                                                         (list value add-aug)))))
                                 (add-io-ame add-aug)
                                 add-aug)))          ;MDW 12/19/88
                     (t 
                        (nconc owner-data (list (list class
                                                (list id
                                                (list attribute
                                                (list value add-aug))))))
                        (add-io-ame add-aug)
                        add-aug)))          ;MDW 12/19/88
            (t 
               (nconc *input-data* (list (list owner
                                             (list class 
                                             (list id
                                             (list attribute
                                             (list value add-aug)))))))
               (add-io-ame add-aug)
       	       ;MDW 12/19/88
               add-aug)))))


;;;*****************************************************************************
;;; Function: delete-input
;;; Description: Remove input data items (not input links) from working memory
;;; and *input-data* structure.
;;;*****************************************************************************

;; replaced defun for MDW. -KAM 10/31/89
(defun delete-input (owner class id attribute value)
       (let* ((owner-data      (assoc owner *input-data*)) 
              (class-data      (assoc class (cdr owner-data))) ; Added CDR. -BGM 3/29/89
              (id-data         (assoc id (cdr class-data))) ; Added CDR. -BGM 3/29/89
              (attribute-data  (assoc attribute (cdr id-data))) ; Added CDR. -BGM 3/29/89
              (value-data      (assoc value (cdr attribute-data))) ; Added CDR. -BGM 3/29/89
             )
                          
      ;;; Deleted check for using add-input for input links. -MDW 7/30/89

             (cond (value-data 
                      (remove-io-ame (cadr value-data)) ;new fun name. -KAM 11/1/89
                      (delete value attribute-data
                              :test #'(lambda (x y) 
                                              (and (listp y)
                                                   (eq x (first y)))))
                      (when (eq (length attribute-data) 1)
                            (delete attribute id-data 
                                    :test #'(lambda (x y) 
                                                    (and (listp y)
                                                         (eq x (first y)))))
                            (when (eq (length id-data) 1)
                                  (delete id class-data 
                                          :test #'(lambda (x y) 
                                                          (and (listp y)
                                                               (eq x (first y)))))
                                  (when (eq (length class-data) 1)
                                        (delete class owner-data 
                                                :test #'(lambda (x y) 
                                                                (and (listp y)
                                                                     (eq x (first y)))))))))
                   (t nil))
          (cadr value-data)))


;; start. installed new section for MDW. -KAM 10/31/89
;;;*****************************************************************************
;;; New user functions appear below:   
;;;*****************************************************************************

;;;*****************************************************************************
;;; Function: get-input-link 
;;; Description: If an input link already exists for the owner and input link
;;; attribute specified, then it returns that input link. If such an input link
;;; does not exist, then one is created. 
;;;*****************************************************************************

(defun get-input-link (owner input-link-attribute)
    (or (current-input-link owner)
        (new-input-link owner input-link-attribute)))

;;;*****************************************************************************
;;; Function: current-input-link (used to be called get-input-link)
;;; Description: Returns current input link associated with owner.
;;; Policy decision: One structure per owner and should be one owner per function.
;;;*****************************************************************************

(defun current-input-link (owner) 
    (first (match-input :owner owner :id (top-state))))

;;;*****************************************************************************
;;; Function: new-input-link (used to be called get-input-link)
;;; Description: Makes a new input link. The link is new even if the old one is
;;; identical.
;;;*****************************************************************************

(defun new-input-link (owner input-link-attribute &optional (value '*unbound*))
   (let* ((id (top-state))
          (current-input-link (match-input :owner owner :id (top-state) :attribute input-link-attribute))
         )

         (when current-input-link  
               (delete-input owner 'state id input-link-attribute 
                             (wme-value (first current-input-link))))

         (cond ((eq value '*unbound*)
                   (add-input owner 'state id input-link-attribute))
               (t 
                   (add-input owner 'state id input-link-attribute value)))))

;;;*****************************************************************************
;;; Function: get-output-augmentations
;;; Description: Given outputs from Soar architecture (a list of WMEs) and a
;;; particular id, it returns a list of all of the WMEs that share the id.
;;;*****************************************************************************

(defun get-output-augmentations (id outputs)
       (do* ((outputs outputs (rest outputs))
             (output (first outputs) (first outputs))
             (augmentations nil)
            )            
            ((null outputs) augmentations)

            (when (eq id (wme-id output))
                  (push output augmentations))))

;;;*****************************************************************************
;;; Function: get-output-values
;;; Description: Given outputs from Soar architecture (a list of WMEs) or the
;;; results of get-output-augmentations (a list of WMEs) and a particular attribute, 
;;; it returns a list of all of the values of WMEs that share the attribute.
;;;*****************************************************************************

(defun get-output-values (attribute outputs)
       (do* ((outputs outputs (rest outputs))
             (output (first outputs) (first outputs))
             (values nil)
            )            

            ((null outputs) values)

            (when (eq attribute (wme-attribute output))
                  (push (wme-value output) values))))

;; end. installed new section for MDW. -KAM 10/31/89

;;;*****************************************************************************
;;; Functions: match-input
;;; Description: This functions returns input data items maintained in 
;;; *input-data* satisfying the particular search specification indicated by 
;;; values of keywords. When a keyword and value is not specified, then it is a 
;;; wildcard. 
;;;*****************************************************************************
 
(defun match-input (&key (owner     nil)
                         (class     nil)
                         (id        nil)
                         (attribute nil)
                         (value     '*unbound*)  ;-MDW 8/28/89 
                         (tolerance nil))  ;Used for checking 
                                           ; values. If number is
                                           ; specified ...
                                           ; Must be a non-negative.

  (let ((matches nil)
       )                                               

  (labels ((match-owners (owner-data)
              (cond (owner    
                        (let ((wmes-of-owner (assoc owner owner-data))
                             )
                             (when wmes-of-owner (match-classes wmes-of-owner))))
                   (t   (mapc #'match-classes *input-data*))))

           (match-classes (class-data)              
              (cond (class 
                        (let ((wmes-of-owner (assoc class (cdr class-data)))
                             )
                             (when wmes-of-owner (match-ids wmes-of-owner))))
                    (t  (mapc #'match-ids (cdr class-data)))))

           (match-ids (id-data)
              (cond (id  
                        (let ((wmes-of-owner (assoc id (cdr id-data)))
                             )
                             (when wmes-of-owner (match-attributes wmes-of-owner))))
                        (t  (mapc #'match-attributes (cdr id-data)))))

           (match-attributes (attribute-data)
              (cond (attribute 
                        (let ((wmes-of-owner (assoc attribute (cdr attribute-data))) 
                             )
                             (when wmes-of-owner (match-values wmes-of-owner))))
                        (t  (mapc #'match-values (cdr attribute-data)))))

           (match-values (value-data)
              (cond ((eq value '*unbound*) ;-MDW 8/28/89 Stuff below is altered a bit ...
                       (setq matches (append matches (mapcar #'cadr (cdr value-data)))))
                    (value              
                        (cond ((symbolp value)                                  
                                    ;; Added cdr. -KAM 6/1/89.
                                    (let ((val-aug (assoc value (cdr value-data)))
                                          )
                                          (when val-aug
                                                (push (second val-aug) matches))))
                              ((numberp value)
                                    (cond ((or (null tolerance)
                                               (<= tolerance 0)) 
                                            ;; Added cdr. -KAM 6/1/89.
                                            (let ((val-aug (assoc value (cdr value-data)))
                                                 )
                                                 (when val-aug
                                                       (push (second val-aug) matches))))
                                           ((> tolerance 0)                
                                               (mapc #'(lambda (val-aug)                                   
                                                    (when (and (numberp (first val-aug))
                                                               (<= (abs (- (first val-aug) value))
                                                                   tolerance))
                                                               (push (second val-aug) matches)))
                                               (cdr value-data))))))
                        matches)
                    ((null value)  ;-MDW 8/28/89
                        (mapc #'(lambda (val-aug)
                                (when (null (first val-aug))                          
                                       (push (second val-aug) matches)))
                        (cdr value-data))))))

            (match-owners *input-data*))
            matches))


;;;*****************************************************************************                             
;;; The next two functions were John Laird's idea---he wrote the original versions
;;; and I fixed them up a little.
;;;*****************************************************************************

;;;*****************************************************************************
;;; Function: change-input-value
;;;*****************************************************************************

(defun change-input-value (owner class id attribute value &key (tolerance 0)) 
  ;; Installed from MDW. -BGM 3/29/89
  ;-MDW 2/20/89
         (cond ((match-input :owner owner :class class
                             :id id :attribute attribute 
                             :value value :tolerance tolerance) nil)
               (t 
                  (delete-input owner class id attribute 
                     (wme-value (first (match-input :owner owner :class class
                                 :id id :attribute attribute)))) ;;; :tolerance keyword removed
                  (add-input owner class id attribute value))))  ;;; -MDW 9/10/89

;;;*****************************************************************************
;;; Function: change-input-value-and-old
;;;*****************************************************************************

(defun change-input-value-and-old (owner class id new-attribute old-attribute new-value &key (tolerance 0)) 
  ;; Installed from MDW. -BGM 3/29/89
  ;;-MDW 2/20/89
  (let ((old-value (wme-value (first (match-input :owner owner :class class
                                                  :id id :attribute new-attribute)))))

;;; We will not check for the case that both new-values are not both numbers or symbols.

       (when (or (and (symbolp old-value)
                      (null (eq new-value old-value)))
                 (and (numberp old-value)
                      (< tolerance (abs (- old-value new-value)))))
                (delete-input owner class id new-attribute old-value)
                (add-input owner class id new-attribute new-value)

                (delete-input owner class id old-attribute 
                              (wme-value (first (match-input :owner owner :class class
                                                             :id id :attribute old-attribute))))
                (add-input owner class id old-attribute old-value))))

 

;;;*****************************************************************************
;;; Function: init-io
;;; Minor addition: *input-data* is reset.
;;;*****************************************************************************
;; replaced defun for MDW. -KAM 10/31/89
(defun init-io ()
  ;; Turned off standard text output by default. -BGM 2/19/89
  ;; Changed *text-input* to nil so that character based interrupts work. -BGM 7/11/88.
   (setq *text-input* nil)
   (setq *text-input-augmentation* (list 'dummy 'dummy 'dummy '*unbound*)) ;-MDW 7/30/89

   (setq *text-output* nil)
   (setq *text-output-augmentation* (list 'dummy 'dummy 'dummy '*unbound*)) ;-MDW 7/30/89

   (setq *text-input-stream* '*standard-input*)  ;-MDW 11/7/89
   (setq *text-input-stream-augmentation* (list 'dummy 'dummy 'dummy '*unbound*)) ;-MDW 7/30/89

   (setq *text-output-stream* '*standard-output*) ;-MDW 11/7/89
   (setq *text-output-stream-augmentation* (list 'dummy 'dummy 'dummy '*unbound*)) ;-MDW 7/30/89

   (setq *char-mode* nil)      
   (setq *char-mode-augmentation* (list 'dummy 'dummy 'dummy '*unbound*)) ;-MDW 7/30/89

   (setq *carriage-control* nil)
   (setq *carriage-control-augmentation* (list 'dummy 'dummy 'dummy '*unbound*)) ;-MDW 7/30/89

   (setq *tab-settings* nil)
   (setq *tab-settings-augmentations* (list (list 'dummy 'dummy 'dummy '*unbound*))) 
   (setq *new-tab-settings* t)   ;;; This is a new flag. -MDW 7/30/89

   (setq *current-column* 0)

   (setq *last-top-level-state-id*  'undecided)  ;changed from call. -MDW 11/29/88
   (setq *output-links* nil) ; Contains links from states to data.
   (setq *input-data* (list (list 'dummy)))  ;New for new-input-cycle. -MDW 11/14/88
   nil
)

  
;;;*****************************************************************************
;;; Function: restart-io
;;; Minor addition: *input-data* is reset.
;;;*****************************************************************************

(defun restart-io nil
 ;; Created, 8/5/88, because IO was not turning off on restart-soar calls.
 ;; Called by restart-soar. BGM 8/5/88.
   (setq *output-mappings* nil)
   (setq *input-mappings* nil)
   (setq *input-data* '((dummy)))     ;New for new-input-cycle. -MDW 11/14/88
   (setq *output-link-attributes* (mapcar #'car *output-mappings*))
   ; Names of valid output labels.
   (setq *input-link-attributes*  (mapcar #'car *input-mappings*))
   ; Names of valid input labels.
)

(defun initialize-io ()
;; Added by BGM 3/9/89
  (init-io))


;;;*****************************************************************************
;;; Code for stream fixes begins here... -MDW 2/3/89
;;; Stream mappings are ((symbol-1 stream-1)(symbol-2 stream-2)...) so that symbol
;;; in wm maps to a stream pointer. I should document this stuff soon. Early next
;;; week.
;;;
;;; Example of call to macros below:
;;; (set-output-stream-mapping b *standard-output*)
;;; (set-input-stream-mapping a *standard-input*)
;;;*****************************************************************************
                                                    
;;; New global variables.
(defvar *input-stream-mappings* nil)
(defvar *output-stream-mappings* nil)

(defmacro set-input-stream-mapping (&optional symbol stream) 
   `(nlam-set-input-stream-mapping ',symbol ',stream))
         
(defun nlam-set-input-stream-mapping (symbol stream)
   (cond ((null symbol) 
               (setq *input-stream-mappings* nil))
         ((null (or (symbolp symbol) 
                    (numberp symbol)))                                 
               (soarwarn "SET-INPUT-STREAM-MAPPING: invalid symbol value" symbol))
         ((null (and (symbolp stream)
                     (boundp stream)
                     (streamp  (eval stream))))
               (soarwarn "SET-INPUT-STREAM-MAPPING: invalid stream value" stream))
         (t (let ((symbol-mapping-used (assoc symbol *input-stream-mappings*))
                 )
                 (when symbol-mapping-used        
                       (setq *input-stream-mappings*
                             (delete symbol-mapping-used *input-stream-mappings*)))
                 (push (list symbol (eval stream)) *input-stream-mappings*))))
    *input-stream-mappings*)

;;; Function below identical to above except "output" substituted for "input".

(defmacro set-output-stream-mapping (&optional symbol stream) 
   `(nlam-set-output-stream-mapping ',symbol ',stream))
         
(defun nlam-set-output-stream-mapping (symbol stream)
   (cond ((null symbol) 
               (setq *output-stream-mappings* nil))
         ((null (or (symbolp symbol) 
                    (numberp symbol)))                                 
               (soarwarn "SET-INPUT-STREAM-MAPPING: invalid symbol value" symbol))
         ((null (and (symbolp stream)
                     (boundp stream)
                     (streamp  (eval stream))))
               (soarwarn "SET-INPUT-STREAM-MAPPING: invalid stream value" stream))
         (t (let ((symbol-mapping-used (assoc symbol *output-stream-mappings*))
                 )
                 (when symbol-mapping-used        
                       (setq *output-stream-mappings*
                             (delete symbol-mapping-used *output-stream-mappings*)))
                 (push (list symbol (eval stream)) *output-stream-mappings*))))
    *output-stream-mappings*)


;;; A function for use with IO.
;;; Written by Mark Wiesmeyer.
;;; Date: 18 April 1990
;;;
;;; This function allows the user to specify a number of decision cycles
;;; and a string to be input by Soar text input.
;;;
;;; Very useful in making demos that have interactive text requirements.
;;;
;;; Example usage in conjunction with Soar-EDT:
;;;
;;;         (defun vision-demo ()
;;;                (init-edt)
;;;                (reset-vision)
;;;                (d 4)

;;;                (dwi 6 "letter-wheel")  ;6 decision cycles with text input

;;;
;;;                (initialize-scene *fixation-scene*)
;;;                (initialize-scene *letter-wheel-cue*)
;;;                (initialize-scene *letter-wheel-stimulus*)
;;;
;;;                (set-edt t)
;;;                (set-events *vision-demo-events*)
;;;                (set-time -500)
;;;                (set-print-events t)
;;;                (set-print-times t)
;;;                (d 21)
;;;                (dwi 25 "execute another demo")
;;;                )


(defun decisions-with-input (decision-cycles input-string) ;;; AKA DWI
  (let* ((*temporary-stream* (make-string-input-stream input-string))
         (*text-input-stream* '*temporary-stream*)
        )
    (declare (ignore *temporary-stream*))
    (run-aux (list decision-cycles 'd))))

(defun dwi (dcycles input-string)
  (decisions-with-input dcycles input-string))

;;; Concatenated from type module "initialize" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/initialize/new/init-wm-and-context.lisp".
;;;-*-mode: lisp; package: user -*-
;;;
;;;
;;;		Soar:	A General Cognitive Architecture
;;;		File:	init-wm-and-context.lisp
;;;		Last Writen:
;;;		Last Writer:
;;;		Resides in: /afs/cs/project/soar/4.5/src/initialize/new/init-wm-and-context.lisp
;;;
;;;		i.	Abstract
;;;
;;;	This file deals with the macros init-wm and init-context.
;;;
;;;

;;;
;;;		ii.	Table of Contents
;;;	i.	Abstract
;;;	ii.	Table of Contents
;;;	iii.	Declarations
;;;	I.	Init-wm
;;;	II.	Init-context
;;;	III.	Compiled-init-context
;;;


;;;
;;;		iii.	Declarations
;;;

(in-package "SOAR")



;;;
;;;		I.	Init-wm
;;;


(defmacro init-wm (&rest init-context-and-smakes)
 ;; Rewritten to work with the new parser. 1/14/89 BGM 
 (catch-sptop-errors
  `(let ((*p-name* 'init-wm);; I'm not sure how many of these really need to be here.
       	 (*in-rhs* t) 
       	 (*current-goal* nil)
       	 (*data-matched* nil)
       	 (*variable-memory* nil))
         ;; Put the init-context out front.
         ,@(dolist (init-context-or-smake init-context-and-smakes nil)
          	 (when (and (listp init-context-or-smake) 
                            (eq (car init-context-or-smake) 'init-context))
     	       (return (list init-context-or-smake))))
         ,@(mapcan #'(lambda (init-context-or-smake)
                 		   (unless (and (listp init-context-or-smake) 
                               			(eq (car init-context-or-smake) 'init-context))
                  			   (initialize-lexer init-context-or-smake)		     
                  			   (let ((makes (make-preference-to-make (<make>)) ))
		                 	      (unless (eq (peek-lexeme) *end-of-input*)
                			        (sptop-rhs-error 
                      				  "parsed an SMAKE in an init-context but had extra lexemes left over; you must have an ungramatical construct."))
                  			     makes)))
	                  init-context-and-smakes) ))
)                                   






;;;
;;;		II.	Init-context
;;;



;;;
;;;		III.	Compiled-init-context
;;;







;;; Concatenated from type module "initialize" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/initialize/new/init.lisp".
;;; -*-mode: soar; package: user -*-
;;;
;;;

;;;
;;;		?.	Global Variables
;;;


(in-package "SOAR")

;;;
;;; 	I.  init-soar-hook added to init-soar
;;;

(defvar init-soar-hook nil 
  "*Hook to run after init-soar. Items can be
function names, lists to eval, lambda forms, or nil.")


(defun init-soar ()  
 (retask-dsmsoar)
 (run-hooks 'init-soar-hook))

(defun run-hooks (hook-or-list-of-hooks)
 "run the commands on the hook-or-list-of-hooks"
 (cond ((not hook-or-list-of-hooks))
       ((and (symbolp hook-or-list-of-hooks)
             (boundp hook-or-list-of-hooks))
        (run-hook (eval hook-or-list-of-hooks)))
       ((symbolp hook-or-list-of-hooks)
        (run-hook hook-or-list-of-hooks))
       ((and hook-or-list-of-hooks
             (listp hook-or-list-of-hooks))
        (mapc #'run-hook hook-or-list-of-hooks)))
 nil)

(defun run-hook (hook-fn)
  "eval the lists of hook"
  (cond ((not hook-fn))
        ((and (symbolp hook-fn)
	      (fboundp hook-fn))
	 (funcall hook-fn))
        ((eq (first hook-fn) 'lambda)
         (funcall hook-fn))
        ((listp (first hook-fn))
         (mapc #'run-hook hook-fn))
        ((and (listp hook-fn)
	      (fboundp (first hook-fn)))
	 (eval hook-fn))
	(t (format *error-output*
		   "Couldn't figure out what to do with ~s in run-hooks."
		   hook-fn)) ))

(defun restart-soar ()  
  ;; Have allegro do a full gc after a restart soar. -BGM 1-Mar-90
  #+(and :allegro :gsgc)
   (setf (sys:gsgc-switch :next-gc-is-global) t)
 (restart-dsmsoar)  
)

(defun output-pm-to-string (ps)
 ;; Created for the more expensive init-soar 3-24-91
      (let* ((s (make-string-output-stream)) (*trace-file* s))
         (eval (cons 'spm ps))
         (get-output-stream-string s)))

(defun exp-init-soar ()
 ;; Created for the more expensive init-soar 3-24-91
 (let* ((*print-length* NIL)
        (*print-level* NIL)
        (chunks (output-pm-to-string 
               (set-difference *chunks* *internal-chunks* :test #'eq)))
        (default-productions (output-pm-to-string 
               (set-difference *pnames* *user-pnames* :test #'eq)))
        (user-productions (output-pm-to-string 
               (set-difference *user-pnames* *chunks* :test #'eq)))
        (s (make-string-output-stream)) 
        (*trace-file* s) )
   (init-soar)
   (stop-chunks)
   (restart-rete)  ;; restarts the rete code from scratch
   (start-default)
   (let ((prod T)
         (last-end 0))
     (do  ((start 0 last-end))
          ((NULL prod))
          (multiple-value-setq (prod last-end)
                               (read-from-string default-productions NIL NIL
                                                 :start start))
          (eval prod)
     ) )
   (stop-default)
   (let ((prod T)
         (last-end 0))
     (do  ((start 0 last-end))
          ((NULL prod))
          (multiple-value-setq (prod last-end)
                               (read-from-string user-productions NIL NIL
                                                 :start start))
          (eval prod)
     ) )
   (start-chunks)
   (let ((prod T)
         (last-end 0))
     (do  ((start 0 last-end))
          ((NULL prod))
          (multiple-value-setq (prod last-end)
                               (read-from-string chunks NIL NIL
                                                 :start start))
          (eval prod)
          (when *tracep*
            (trace-firing-rule (car *chunks*)))
     ) )
   (stop-chunks)
  )
)

(defun start-chunks nil
 ;; Created for the more expensive init-soar 3-24-91
   (setq *loading-chunks* T)
)

(defun stop-chunks nil
 ;; Created for the more expensive init-soar 3-24-91
   (setq *loading-chunks* NIL)
)


;;; Initialize soar here as it is the last file loaded.





;;; Concatenated from type module "user" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/user/new/user.lisp".
(in-package "SOAR")



;;; <USER.FUNCTIONS>



;;; USER MODULE.

                  
;;; MODULE DESCRIPTION.
;;;  Contains top-level user functions.

#|


 Modules: User: Contents

          
 Introduction

 Data
   Records
     Break-Log
   Globals
     *run-break-log*
     *pbreak-break-log*

 Functions
   Working Memory Initialization
   Working Memory Traffic
   Production Memory

   Running
   Learning

   Pbreak
   Pgs
   Pfired
   Watch
   Decide-Trace
   Pop-Goal
   Ptrace

   Break Scheduling Utilities
   Break Unscheduling Utilities

   Preferences
   Rules

   Subgoal Result Traces
   Production Traces

   Miscellaneous Utilities



 Modules: User: Introduction


 User contains those user interface functions that were rewritten for
 Soar5.

 These user functions interact extensively with the Tracer, when traces are
 requested, and with the Diplomat, when breaks are requested.



 Modules: User: Data: Records: Break-Log


   Break Log Record (BREAK-LOG).        

     Log of all the breaks that have been scheduled using the run or pbreak
     commands, by break tyoe. 
     One break log is kept for the run command and one for the pbreak command. 
     Used to cancel all breaks issued by a particular command.

     Contains these fields:

       Augmentation-Additions. List of the augmentations upon whose addition a
         break has been requested.
       Augmentation-Removals. List of the augmentations upon whose removal a
         break has been requested.
       Preference-Additions. List of the preferences upon whose addition a
         break has been requested.
       Preference-Removals. List of the preferences upon whose removal a
         break has been requested.
       Firings. List of the productions upon whose firing a break has been requested.
       Retractions. List of the productions upon whose retraction a break has been
         requested.
       Context-Installations. List of the objects upon whose installation as a
         problem-space, state, or operator a break has been requested.



 Modules: User: Data: Globals


   *run-break-log*
     Points to the Break Log record (BREAK-LOG) for the run command.
     Used to cancel all breaks scheduled with the run command.
     Run breaks are cancelled when a restart-soar or an init-soar command
     is issued.

   *pbreak-break-log*
     Points to the Break Log record (BREAK-LOG) for the pbreak command.
     Used to cancel all breaks scheduled with the pbreak command.
     Pbreak breaks are cancelled when an unpbreak or restart-soar
     command is issued.

|#


;;; MODULE FUNCTION DIRECTORY: USER.FUNS.

;;; MODULE RECORDS.

;;; Updated to BOA constructor by Milnes 2/27/89.
(defstruct (break-log (:constructor make-break-log ()))
                      (augmentation-additions   NIL :type list)
                      (augmentation-removals    NIL :type list)
                      (preference-additions     NIL :type list)
                      (preference-removals      NIL :type list)
                      (firings                  NIL :type list)
                      (retractions              NIL :type list)
                      (context-installations    NIL :type list)
)


;;; MODULE GLOBALS.
               
;;; breaks scheduled with the run command.                           
(defvar *run-break-log* (make-break-log))
                         
;;; breaks scheduled with the pbreak command.
(defvar *pbreak-break-log* (make-break-log))       




;;; WORKING MEMORY INITIALIZATION.      

(defmacro init-context (&optional goal space state operator)
 `(init-context-aux ',goal ',space ',state ',operator)
)  

(defun init-context-aux (goal space state operator)       

 (init-soar)
 ;; top context will be initialized during first call to run.
 (delayed-initialize-top-context ($instantiate goal)
                                 ($instantiate space)
                                 ($instantiate state)
                                 ($instantiate operator))
 T
)



;;; WORKING MEMORY TRAFFIC.
;;; sremove only works for preferences in working memory,
;;; so need sremove2 for the others.

(defmacro make (class object attribute value type
                                       &optional (reference NIL reference-p))
 ;; called by make-preference-to-make.
 ;; if the pme is for a non-context slot, the decider is run immediately;
 ;; else, the pme is just saved for the next quiescence phase.
 `(external-add-pme
    (if ,reference-p
        (instantiate-preference ',class
                                ',object
                                ',attribute
                                ',value
                                ',type
                                ',reference)
        (instantiate-preference ',class
                                ',object
                                ',attribute
                                ',value
                                ',type)))
)

(defun make-preference-to-make (make-preference)
 ;; called by smake and init-wm.
 (subst 'make 'make-preference make-preference :test #'eq)
)

(defmacro sremove2 (&rest tmes)
 `(sremove2-aux ',tmes)
)

(defun sremove2-aux (tmes) 
 (dolist (tme (parse-tmes tmes) T)
  (external-remove-tme tme))
)

(defmacro flushpr (object attribute &optional (value NIL value-p))
 `(flushpr-aux ',object ',attribute ',value ',value-p)
)

(defun flushpr-aux (object attribute value value-p)
 (if value-p
     (remove-preferences object attribute value)
     (remove-preferences object attribute))
 (if (not (context-slot-p object attribute))
     (external-working-memory-decision-phase))
 T
)



;;; PRODUCTION MEMORY.

(defun excise-task ()
  ;; Changed to initialize Soar when the task gets excised to remove all
  ;; leftover stuff. If excising all the productions is desired the the
  ;; command "excise-all-user-P" will do it.
  ;; Bug #20Mar90-10.04.00 GAP 26-Mar-90
  (init-soar)
  (excise-all-user-P)
)
	 


(defun excise-all-user-P ()
  ;; Added the initialization of chunk-free-problem-spaces
  ;; Bug #22Aug90-22.47.00 GAP 25-Aug-90
  ;; changed name from excise-task to fix user understanding bug 
  ;; Bug #20Mar90-10.04.00 GAP 26-Mar-90
  ;; Changed to get the initial value of *instance-attributes*. -BGM 1-Mar-90
   (prog (pnames)
  ;; replaced append to NIL with copy-list. -KAM 6/14/89
  (setf pnames (copy-list *user-pnames*))
  ;; excise will remove trace on rules.
  (if pnames
      (eval (cons 'excise pnames)))
  (initialize-trace-attributes)
  (setq *chunk-free-problem-spaces* nil)
  (setq *instance-attributes*
  '((operator instance)
    (operator object)
    (goal superoperator)
    (goal desired)
    (goal impasse)
    (goal role)))))


;;; RUNNING.                               

;;;   run-task         
;;;     run-task-aux
;;;       d          
;;;        d-aux
;;;          run
;;;            run-aux
;;;              set-run-break 
;;;       pr         
;;;        pr-aux
;;;          run
;;;            run-aux
;;;              set-run-break 

(defmacro run (&rest cycles)
 `(run-aux ',cycles)
)




(defun run-aux (break-criterion)

 ;; was nlam-run.
 ;; Modified to use PPWM style wme expansion for run breaking. -BGM 1/15/89
 ;; Modified to send context trace information, under the si, to the run trace. -BGM.
 ;; Updated old style IO to soar-format. -BGM 8/18/88

 (let ((status NIL))
  (cond ((= *pcount* 0)
         (setf status "Please load in some productions first."))
        (T
         ;; set break and go.
         (cond ((set-run-break break-criterion)
                ;; valid break criterion. go.

                ;; initialize top context.
                (cond ((initialize-top-context-p)
                       #+:soar-times (start-soar-time decide)
                       ;; these lines copied from old init-wm-context.
                       (and *learning* (learn-aux nil))
                       (initialize-top-context)
                       (setq *initial-actions* *action-count*)
                       (setq *elapsed-time* 0)
                        (setq *elapsed-build-time* 0)
                       #+:soar-times (stop-soar-time decide) ))

                ;; go.
                #+:soar-times (start-soar-time real)
                #+:soar-times (start-soar-time run)
                (start-elapsed-time)
                (setf status (cycle))
                (if (eq status 'break)
                    (setf status '***BREAK***)
                    (setf status "End -- Explicit Halt"))

                 (stop-elapsed-time)
                 #+:soar-times (stop-soar-time real)
                 #+:soar-times (stop-soar-time run) )

               (T
                ;; invalid break criterion.
                (setf status "What?") )) ))

 (soar-format *trace-file* "~%~A" status)
 NIL))

(eval-when (compile eval load) (proclaim '(ftype (function (list) logical) set-run-break)))
(defun set-run-break (criterion)
 (declare (list criterion))                   

 ;; edits run command break criterion and, if valid, sets break.
 ;; returns break specification if criterion is valid, else NIL.

 ;; clear old break criteria.
 (unschedule-general-breaks *run-break-log*)

 ;; schedule and log new break.
 (schedule-general-break criterion *run-break-log*)
)

(defmacro d (&rest decision-cycles)
 `(d-aux ',decision-cycles)
)

(defun d-aux (decision-cycles)
 ;; was nlam-d.
 (cond ((null decision-cycles)
        (run))
	      (T
        (eval (list 'run (first decision-cycles) 'd)) ))
)

(defmacro pr (&rest production-cycles)
 `(pr-aux ',production-cycles)
)

(defun pr-aux (production-cycles)
 (cond ((null production-cycles)
       	(run))
	      (T
        (eval (list 'run (first production-cycles) 'p)) ))
)

;;; Fixes number 110, ID 16May90-10.59.20 -- TFMcG
(defmacro run-task (&optional decision-cycles)
 `(run-task-aux ,decision-cycles)
)

(defun run-task-aux (decision-cycles) 
 ;; was nlam-run-task.
 (init-soar)
 (init-task)
 (cond (decision-cycles
        (eval (list 'd decision-cycles)))
       (T
        (d) ))
)



;;; LEARNING.

(defmacro learn (&rest settings)
 `(learn-aux ',settings)
)

(defun learn-aux (settings) 
 ;; Updated old style IO to soar-format. -BGM 8/18/88
 (cond ((atom settings)
        (print-status))
       (t
        (cond ((eq (car settings) 'on)         
               ;; Do not need to check *never-learn* in Soar 5; it is always off.
               (setq *never-learn* NIL) ;just in case.
               (setq *learning* t))
              ((eq (car settings) 'off)
               ;; Do not need to check *never-learn* in Soar 5; it is always off.
               (setq *never-learn* NIL) ;just in case
               (setq *learning* nil))
	      ((eq (car settings) 'never)
               (soar-format *trace-file* "Soar 5 runs only with learn on or off."))
     	      ((eq (car settings) 'full-print)
      		       (setq *print-learn* 1))
              ((eq (car settings) 'prd53int)
      		       (setq *print-learn* 0))
              ;; added clause. KAM. 4/8/89.  
              ((eq (car settings) 'print)
      		       (setq *print-learn* 0))
              ((eq (car settings) 'noprint)
      		       (setq *print-learn* nil))
              ((eq (car settings) 'full-trace)
      		       (setq *ltrace* t)
	               (setq *tracep* t))
      	      ((eq (car settings) 'trace)
      		       (setq *tracep* t)
	               (setq *ltrace* nil))
              ((eq (car settings) 'notrace)
      		       (setq *tracep* nil)
	               (setq *ltrace* nil))
      	      ((eq (car settings) 'all-goals)
      		       (setq *always-learn* t))
	      ((eq (car settings) 'bottom-up)
      		       (setq *always-learn* nil))
	      (t
               (soar-format *trace-file* "~%Error: unknown option~%")))
      	 (eval (cons 'learn (cdr settings))) ))
)

(defun print-status ()
 ;; Updated old style IO to soar-format. -BGM 8/18/88
 ;; Do not need to check *never-learn* in Soar 5; it is always off.

 (soar-format *trace-file* "~%Learn status: ")
 (values 
  (cond (*learning*
         (soar-format *trace-file* "on ")
         'on)
	       (t
         (soar-format *trace-file* "off ")
         'off))

  (cond (*always-learn*
         (soar-format *trace-file* "all-goals ")
         'all-goals)
	       (t
         (soar-format *trace-file* "bottom-up ")
         'bottom-up))

  (cond ((eqp *print-learn* 0)
  	      (soar-format *trace-file* "print ")
         'print)
	       (*print-learn*
         (soar-format *trace-file* "full-print ")
         'full-print)
	       (t
         (soar-format *trace-file* "noprint ")
         'noprint))

  (cond ((and *ltrace* *tracep*)
  	      (soar-format *trace-file* "full-trace ~%")
         'full-trace)
	       (*tracep*
         (soar-format *trace-file* "trace ~%")
         'trace)
 	      (t
         (soar-format *trace-file* "notrace ~%")
         'notrace)) )
)

(defun set-learning-choice () 
 (eval (soar-menu "Learning choice"
		  '(("Learning at all levels" (learn on all-goals))
		    ("Learning bottom-up" (learn on bottom-up))
		    ("No learning" (learn off)))))  ;<== DSM
 )




;;; PBREAK.

(defmacro pbreak (&rest criteria)
 `(pbreak-aux ',criteria)
)

(defun pbreak-aux (criteria)
 (cond (criteria
        (dolist (criterion criteria T) 
         (set-pbreak (list criterion))) )
       (T
        (break-log-settings *pbreak-break-log*) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function (list) logical) set-pbreak)))
(defun set-pbreak (criterion)
 (declare (list criterion))                   

 ;; edits pbreak command break criterion and, if valid, sets break.
 ;; returns break specification if criterion is valid, else NIL.

 ;; schedule and log new break.
 (schedule-general-break criterion *pbreak-break-log*)
)

(defmacro unpbreak (&rest criteria)
 `(unpbreak-aux ',criteria)
)

(defun unpbreak-aux (criteria)
 (cond ((null criteria)
        (unschedule-general-breaks *pbreak-break-log*) ) 
       (T      
        (dolist (criterion criteria T)
          (unschedule-general-break (list criterion) *pbreak-break-log*)) ))
)  



;;; PGS.

(defun pgs ()
 (dolist (context (contexts)) 
   (print-pgs-context (first context)    ;depth
                      (second context)   ;goal
                      (third context)    ;space
                      (fourth context)   ;state
                      (fifth context)))  ;operators
 (soar-format *trace-file*
              "~%Decision Cycle ~D"
              (cycle-count 'quiet))
 (values)
)







;;; PFIRED.

(defmacro pfired (&optional number)
 `(pfired-aux ',number)
)

(defun pfired-aux (number)          

 ;; no longer necessary to set *pfired* to T.

 ;; number = 0 ==> list the productions that did not fire.
 ;; number = n ==> list the N productions that fired most often.
 ;; number not specified ==> list all productions sorted in ascending order
 ;;                          of firing frequency.      

 (prog (fired-counts)                              
      
  ;; list of production names and firing counts.
  (setf fired-counts
   		   (mapcar
         #'(lambda (rule-name) (list (get-rule-count rule-name) rule-name))
		       *pnames*))

  ;; if no number, set to number of productions.
  (or number (setq number (length *pnames*)))   

  (cond ((not (= number 0))                   
         ;; sort.
   		    (setf fired-counts (reverse (soarcarsort fired-counts)))
         (soar-format *trace-file*
                      "~%Number of times each production fired:")

         ;; print until N productions reported.
   		    (soarwhile (< 0 number)
           (soar-format *trace-file*
                        "~%~A: ~D"
             			        (caar fired-counts)
             			        (cadar fired-counts))
			        (pop fired-counts)
			        (setq number (1- number))) )
                      
         ;; list the productions that did not fire.
  		    ((setf fired-counts (soarcarsort fired-counts))
         (soar-format *trace-file*
                      "~%Productions that never fired:")
		       (soarwhile (= 0 (caar fired-counts))
          (soar-format *trace-file*
                       "~%~A"
			                    (cadar fired-counts))
			       (pop fired-counts)) ))
))

    


;;; WATCH.

(defun watch (&optional level task-rules-only)
 (cond (level
        (dsm-watch level task-rules-only))
       (T
        (dsm-watch-level) ))
)
          

;;; DECIDE-TRACE.

(defmacro tally (object attribute)
 `(tally-aux ',object ',attribute)
)          

(defun tally-aux (object attribute)
 (declare (type tme-object object)
          (type tme-attribute attribute))
 (let ((anode (get-anode object attribute)))
  (declare (type anode-or-NIL anode))
  (cond (anode
         (setf anode (copy-anode anode)) 
         (let ((decide-trace-setting (decide-trace)))
          (declare (type logical decide-trace-setting))
          (decide-trace T)
          (soar-format *trace-file*
                       "~%Old Preference Tally: ~
                        ~%Status:         ~A ~
                        ~%Winning Values: ~A ~
                        ~%Impasse Items:  ~A"
                        (anode-status anode)
                         (if (member (anode-status anode)
                                     '(winner winners)
                                     :test #'eq)
                             (anode-items anode)) 
                         (if (not (member (anode-status anode)
                                          '(winner winners)
                                          :test #'eq))
                             (anode-items anode)))
          (soar-format *trace-file*
                       "~%~%Decide Trace:")
          (decide anode)                    ;decide sets anode fields.
          (soar-format *trace-file*
                       "~%~%New Preference Tally: ~
                        ~%Status:         ~A ~
                        ~%Winning Values: ~A ~
                        ~%Impasse Items:  ~A"
                         (anode-new-status anode)
                         (if (member (anode-new-status anode)
                                     '(winner winners)
                                     :test #'eq)
                             (anode-new-items anode)) 
                         (if (not (member (anode-new-status anode)
                                          '(winner winners)
                                          :test #'eq))
                             (anode-new-items anode)))
          ;; restore decide-trace setting.
          (decide-trace decide-trace-setting) ) ))
 T
))

(defun decide-trace (&optional (setting 'inquiry))
 (cond ((eq setting 'inquiry)
        (decision-trace-p))
       (setting
        (trace-decision))
       (T
        (untrace-decision)))
)

(defun dtrace ()
 (last-decision-trace)
)



;;; POP-GOAL.

(defmacro pop-goal (&rest goals)
 ;; DSM ==>
 (cond (goals
     	  (list 'pop-goal-aux (list 'quote goals)))
       (T
        (list 'pop-goal-aux) ))
) 

(defun pop-goal-aux (&optional (goals (list (bottom-goal))))
 (cond ((member (top-goal) goals :test #'eq)            
        (soar-format *trace-file*
                     "~%Re-initializing Soar.") 
        (init-soar))
       (T 
        (mapc #'flush-popped-goal goals) ))
 T
)

                             

;;; PTRACE AND UNPTRACE.

(defmacro ptrace (&rest criteria)
 `(ptrace-aux ',criteria)
)

(defun ptrace-aux (criteria)       
 ;; criteria is either:
 ;;  null - list the current ptrace settings
 ;;  list - criterion list
 (cond ((null criteria) 
        (firing-trace-settings))    
       (t                           
        (dolist (criterion criteria (firing-trace-settings))
     				 (cond ((listp criterion)
                 (trace-firing-tme (parse-tme criterion)))
                 ((soar-rule-p criterion)
                  (trace-firing-rule criterion))
                 ((symbolp criterion)
                  (trace-firing-object criterion))
                 ((and (integerp criterion) (timetag-tme criterion))
                  (trace-firing-tme (timetag-tme criterion)) )
                (t
                 (error "Ptrace: found ~A but it is not a production-name, possible identifier, 
                     		 possible timetag or a ppwm style specification." 
                        criterion) )) ) ))
)

(defun unptrace-aux (criteria)       
 ;; criteria is either:
 ;;  null - remove all ptraces
 ;;  list - criterion list
 (cond ((null criteria) 
        (untrace-firing-rules)
        (untrace-firing-objects)
        (untrace-firing-tmes))
       (t                           
        (dolist (criterion criteria (firing-trace-settings))
     				 (cond ((listp criterion)
                 (untrace-firing-tmes (list (parse-tme criterion))))
                ((soar-rule-p criterion)
                 (untrace-firing-rules (list criterion)))
                ((symbolp criterion)
                 (untrace-firing-objects (list criterion)))
                ((and (integerp criterion) (timetag-tme criterion))
                 (untrace-firing-tmes (list (timetag-tme criterion))) )
                (t
                 (error "Unptrace: found ~A but it is not a production-name, possible identifier, 
                     		 possible timetag or a ppwm style specification." 
                        criterion) )) ) ))
)



;;; BREAK SCHEDULING UTILITIES.           

(eval-when (compile eval load) (proclaim '(ftype (function
                     (list &optional (or null break-log))
                     logical) schedule-general-break)))
(defun schedule-general-break (criterion &optional break-log)
 (declare (list criterion)
          (type (or null break-log) break-log))                   
 
 ;; classifies break criterion, and, if valid, schedules break.                                                 
 ;; if valid, returns T, else NIL.
 ;; if break-log passed, updates it.

 ;; classifies break criterion as one of:
 ;;  cycle
 ;;  augmentation addition
 ;;   also returns interpreted tme 
 ;;  augmentation removal
 ;;   also returns interpreted tme 
 ;;  preference addition
 ;;   also returns interpreted tme 
 ;;  preference removal
 ;;   also returns interpreted tme 
 ;;  firing
 ;;  retraction
 ;;  context-installation
 ;;  NIL (invalid)
 
 (let ((first-criterion (first criterion)))
 
 (cond ((null criterion)
        ;; schedule no break.
        T)          

       ((listp first-criterion)
        ;; tme criterion.      
        (let ((tme (parse-tme first-criterion)))
         (cond (tme 
                (schedule-break-tme-criterion tme (second criterion) break-log))
               (T 
                ;; invalid tme, so invalid criterion.              
                NIL)) ))

       ((soar-rule-p first-criterion)
        ;; rule criterion.
        (schedule-break-rule-criterion first-criterion (second criterion) break-log))

       ((and (numberp first-criterion) (= first-criterion 0))
        (cond ((initialize-top-context-p)
               ;; initialize.
               (schedule-break-cycle-criterion 1
                                               (second criterion)
                                               break-log) )
              (T
               NIL)) )

       ((integerp first-criterion)
        ;; cycle criterion.
        (schedule-break-cycle-criterion first-criterion (second criterion) break-log))

       ((symbolp first-criterion)
        ;; object id or object name criterion: context installation.
        (schedule-break-object-criterion first-criterion break-log))

       (T
        NIL))
))                                                      

(defun schedule-break-tme-criterion (tme event-type &optional break-log)
 ;; returns break type.
 (cond ((tme-type tme)
        ;; preference tme criterion. 
        (case event-type
         (R
          ;; preference removal break. 
          (schedule-preference-removal-break tme)
          (cond (break-log
                 (pushnew tme (break-log-preference-removals break-log) :test #'tme=) ))
          T)
         (otherwise
          ;; preference addition break.
          (schedule-preference-addition-break tme)
          (cond (break-log
                 (pushnew tme (break-log-preference-additions break-log) :test #'tme=) ))
          T)) )
       (T
        (case event-type             
         (R
          ;; augmentation removal break.
          (schedule-augmentation-removal-break tme)
          (cond (break-log
                 (pushnew tme (break-log-augmentation-removals break-log) :test #'tme=) )) 
          T)
         (otherwise
          ;; augmentation addition break.
          (schedule-augmentation-addition-break tme)
          (cond (break-log
                 (pushnew tme (break-log-augmentation-additions break-log) :test #'tme=) ))
          T)) ))
)

(defun schedule-break-cycle-criterion
      (cycle-count cycle-type &optional break-log)
 (declare (ignore break-log))
 ;; returns break type.

 (cond ((null (top-goal))
        ;; do not count creation of first goal
        ;; or initial space, state, or operators 
        ;; set by init-context. 
        (incf cycle-count) ))

 (case cycle-type
  (D
   ;; decision cycle break.  
   (schedule-cycle-break 'quiet cycle-count))
  (P
   ;; production cycle break.
   (schedule-cycle-break 'production cycle-count))  
  (otherwise
   ;; run cycle break.   
   (schedule-cycle-break 'run-cycle cycle-count)))
 T     
)

(defun schedule-break-rule-criterion (rule event-type &optional break-log)
 ;; returns break type.
 (case event-type
  (R
   ;; retraction break.    
   (schedule-retraction-break rule)
   (cond (break-log
          (pushnew rule (break-log-retractions break-log) :test #'eq) ))
   T)       
  (otherwise
   ;; firing break.
   (schedule-firing-break rule)
   (cond (break-log
          (pushnew rule (break-log-firings break-log) :test #'eq) ))
   T))
)

(defun schedule-break-object-criterion (object &optional break-log)
 ;; object is id or name.
 ;; returns break type.
 (schedule-context-installation-break object)
 (cond (break-log
        (pushnew object (break-log-context-installations break-log) :test #'eq) ))
 T
)



  
;; not used.                                      
(defun log-general-break (break break-log)
 (case (cond ((listp break)
              (first break))
             (T
              break))
  (augmentation-addition
   (push (second break) (break-log-augmentation-additions break-log)) )
  (augmentation-removal
   (push (second break) (break-log-augmentation-removals break-log)) )
  (preference-addition
   (push (second break) (break-log-preference-additions break-log)) )
  (preference-removal
   (push (second break) (break-log-preference-removals break-log)) )
  (firings
   (push (second break) (break-log-firings break-log)) )
  (retractions
   (push (second break) (break-log-retractions break-log)) )
  (context-installations
   (push (second break) (break-log-context-installations break-log)) ))
)

(defun break-log-settings (break-log)
 (soar-format *trace-file* 
              "~%Augmentation Addition Breaks:~%  ~A"
              (break-log-augmentation-additions break-log))
 (soar-format *trace-file* 
              "~%Augmentation Removal Breaks:~%  ~A"
              (break-log-augmentation-removals break-log))
 (soar-format *trace-file* 
              "~%Preference Addition Breaks:~%  ~A"
              (break-log-preference-additions break-log))
 (soar-format *trace-file* 
              "~%Preference Removal Breaks:~%  ~A"
              (break-log-preference-removals break-log))
 (soar-format *trace-file* 
              "~%Firing Breaks:~%  ~A"
              (break-log-firings break-log))
 (soar-format *trace-file* 
              "~%Retraction Breaks:~%  ~A"
              (break-log-retractions break-log))
 (soar-format *trace-file* 
              "~%Context Installation Breaks:~%  ~A"
              (break-log-context-installations break-log))
 (values)
)


                     

                     
;;; BREAK UNSCHEDULING UTILITIES.

(eval-when (compile eval load) (proclaim '(ftype (function
                     (list &optional (or null break-log))
                     logical) unschedule-general-break)))
(defun unschedule-general-break (criterion &optional break-log)
 (declare (list criterion)
          (type (or null break-log) break-log))                   
                        
 ;; classifies break criterion, and, if valid, unschedules break.                                                 
 ;; see schedule-general-break.
 
 (let ((first-criterion (first criterion)))
 
 (cond ((null criterion)
        NIL)

       ((listp first-criterion)
        ;; tme criterion.      
        (let ((tme (parse-tme first-criterion)))
         (cond (tme 
                (unschedule-break-tme-criterion tme (second criterion) break-log))
               (T 
                ;; invalid tme, so invalid criterion.              
                NIL)) )) 

       ((soar-rule-p first-criterion)
        ;; rule criterion.
        (unschedule-break-rule-criterion
          first-criterion (second criterion) break-log))

       ((integerp first-criterion)
        ;; cycle criterion.
        (unschedule-break-cycle-criterion
          first-criterion (second criterion) break-log))

       ((symbolp first-criterion)
        ;; object id or object name criterion: context installation.
        (unschedule-break-object-criterion first-criterion break-log))

       (T
        NIL))
))                                                      

(defun unschedule-break-tme-criterion (tme event-type &optional break-log)
 ;; returns break type.
 (cond ((tme-type tme)
        ;; preference tme criterion. 
        (case event-type
         (R
          ;; preference removal break. 
          (unschedule-preference-removal-break tme)
          (cond (break-log
                 (setf (break-log-preference-removals break-log)
                      (delete tme
                              (break-log-preference-removals break-log)
                              :test #'tme=
                              :count 1)) )) 
          T)
         (otherwise
          ;; preference addition break.
          (unschedule-preference-addition-break tme)
          (cond (break-log
                 (setf (break-log-preference-additions break-log)
                      (delete tme
                              (break-log-preference-additions break-log)
                              :test #'tme=
                              :count 1)) )) 
          T)) )
       (T
        (case event-type             
         (R
          ;; augmentation removal break.
          (unschedule-augmentation-removal-break tme)
          (cond (break-log
                 (setf (break-log-augmentation-removals break-log)
                      (delete tme
                              (break-log-augmentation-removals break-log)
                              :test #'tme=
                              :count 1)) )) 
          T)
         (otherwise
          ;; augmentation addition break.
          (unschedule-augmentation-addition-break tme)
          (cond (break-log
                 (setf (break-log-augmentation-additions break-log)
                      (delete tme
                              (break-log-augmentation-additions break-log)
                              :test #'tme=
                              :count 1)) )) 
          T)) ))
)

(defun unschedule-break-cycle-criterion (cycle-count cycle-type &optional break-log)
 (declare (ignore cycle-count break-log))
 ;; returns break type.                                                             
 (case cycle-type
  (D
   ;; decision cycle break.  
   (unschedule-break) )
  (P
   ;; production cycle break.
   (unschedule-cycle-break 'production) )
  (otherwise
   ;; run cycle break.   
   (unschedule-cycle-break 'run-cycle) ))
 T
)

(defun unschedule-break-rule-criterion (rule event-type &optional break-log)
 ;; returns break type.
 (case event-type
  (R
   ;; retraction break.    
   (unschedule-retraction-break rule)
   (cond (break-log
          (setf (break-log-retractions break-log)
                (delete rule
                        (break-log-retractions break-log)
                        :test #'eq
                        :count 1)) )) 
   T)
  (otherwise
   ;; firing break.
   (unschedule-firing-break rule)
   (cond (break-log
          (setf (break-log-firings break-log)
                (delete rule
                        (break-log-firings break-log)
                        :test #'eq
                        :count 1)) )) 
   T))
)

(defun unschedule-break-object-criterion (object &optional break-log)
 ;; object is id or name.
 ;; returns break type.
 (unschedule-context-installation-break object)
 (cond (break-log
        (setf (break-log-context-installations break-log)
              (delete object
                      (break-log-context-installations break-log)
                      :test #'eq
                      :count 1)) )) 
)

(defun unschedule-general-breaks (break-log)

 (cond ((break-log-augmentation-additions break-log)
        (dolist (tme (break-log-augmentation-additions break-log) T)
         (unschedule-break-tme-criterion tme 'A break-log)) ))

 (cond ((break-log-augmentation-removals break-log)
        (dolist (tme (break-log-augmentation-removals break-log) T)
         (unschedule-break-tme-criterion tme 'R break-log)) ))

 (cond ((break-log-preference-additions break-log)
        (dolist (tme (break-log-preference-additions break-log) T)
         (unschedule-break-tme-criterion tme 'A break-log)) ))

 (cond ((break-log-preference-removals break-log)
        (dolist (tme (break-log-preference-removals break-log) T)
         (unschedule-break-tme-criterion tme 'R break-log)) ))

 (cond ((break-log-firings break-log)
        (dolist (tme (break-log-firings break-log) T)
         (unschedule-break-rule-criterion tme 'F break-log)) ))

 (cond ((break-log-retractions break-log)
        (dolist (tme (break-log-retractions break-log) T)
         (unschedule-break-rule-criterion tme 'R break-log)) ))

 (cond ((break-log-context-installations break-log)
        (dolist (tme (break-log-context-installations break-log) T)
         (unschedule-break-object-criterion tme break-log)) ))

)

(defun unlog-general-break (break break-log)
 ;; not used. 
 (case (cond ((listp break)
              (first break))
             (T
              break))
  (augmentation-addition
   (delete (second break)
           (break-log-augmentation-additions break-log)
           :test #'tme=
           :count 1) )
  (augmentation-removal
   (delete (second break)
           (break-log-augmentation-removals break-log)
           :test #'tme=
           :count 1) )
  (preference-addition
   (delete (second break)
           (break-log-preference-additions break-log)
           :test #'tme=
           :count 1) )
  (preference-removal
   (delete (second break)
           (break-log-preference-removals break-log)
           :test #'tme=
           :count 1) )
  (firings
   (delete (second break)
           (break-log-firings break-log)
           :test #'eq
           :count 1) )
  (retractions
   (delete (second break)
           (break-log-retractions break-log)
           :test #'eq
           :count 1) )
  (context-installations
   (delete (second break)
           (break-log-context-installations break-log)
           :test #'eq
           :count 1) ))
)


;;; PREFERENCES.


(defmacro preferences (&optional object (attribute nil) &key (return-p nil) (print-p t) )
#-allegro"Finds within OBJECT (defaults to highest meta-level goal if not passed)
preferences for ATTRIBUTE (no default)."
  (cond (attribute `(slot-preferences ',object ',attribute ',return-p ',print-p))
	;; you got passed no object, use the top level goal
	(object  `(slot-preferences ',(bottom-goal) ',object ',return-p ',print-p))
	;; you got passed nothing, use defaults
        (t  `(slot-preferences ',(bottom-goal) 'operator ',return-p ',print-p)))
)

;; allegro won't let you set doc string directly for macros...
#+allegro
(setf (documentation 'preferences 'function)
      "Finds within OBJECT (defaults to highest meta-level goal if not passed)
preferences for ATTRIBUTE (no default).")

;;; RULES.

(defun pclasses ()
 (rule-classes)
)

(defmacro pclass (rule-name)
 `(get-rule-class ',rule-name)
)

(defmacro pcount (rule-name)
 `(get-rule-count ',rule-name)
)

(defmacro auto-p (rule-name)
 `(autonomous-p ',rule-name)
)

(defmacro op-apps (&rest rule-names)
 `(operator-applications ',rule-names)
)

(defmacro op-crs (&rest rule-names)
 `(operator-creations ',rule-names)
)

(defmacro declare-p (class &rest rule-names)
 ;; class can be operator-application, operator-creation,
 ;; miscellaneous (neither operator-application nor operator-creation),
 ;; or unknown (will be classified by internal criteria at next firing).
 `(declare-rules ',class ',rule-names)
)



;;; SUBGOAL RESULT TRACES.

(defmacro results (goal)
 `(goal-results ',goal)
)

(defmacro non-results (goal)
 `(goal-non-results ',goal)
)




;;; PRODUCTION TRACES.

(defmacro goal-traces (&optional goal)
 `(cond (',goal
         (goal-traces-aux ',goal) )
        (T
         (mapc #'goal-traces-aux (goals)) ))
)

(defun goal-traces-aux (goal)
 (pretty-print-goal-production-traces goal (goal-production-traces goal))
 T
)

(defmacro rule-traces (name &optional goal)                  
 `(cond (',goal
         (rule-traces-aux ',name ',goal))
        (T 
         (rule-traces-aux ',name) ))
)

(defun rule-traces-aux (name &optional goal)
 (cond (goal
        (pretty-print-goal-production-traces
          goal
          (goal-name-production-traces goal name)))
       (T
        (dolist (goal (goals) T)
          (pretty-print-goal-production-traces
            goal
            (goal-name-production-traces goal name))) ))
 T
) 

(defun goal-production-traces (goal)
 (let ((trace-hash (get-rule-traces goal)))
  (cond (trace-hash
         ;; convert hash table to list.
         (let ((trace-list NIL))
          (maphash
           #'(lambda (action trace)
              ;; must filter out object traces.
              (cond ((rtrace-p trace)         
                     (push (list action trace) trace-list)))
           trace-hash)
          trace-list)) ))
))

(defun goal-name-production-traces (goal name)
 ;; trace is the list (action rtrace).
 (remove-if-not
  #'(lambda (trace)
     (eq (rtrace-name (second trace)) name))
  (goal-production-traces goal))
)

(defun name-production-traces (name)
 (apply #'append 
        (mapcar
         #'(lambda (goal)
            (goal-name-production-traces goal name))
         (goals))) 
)      

(defun pretty-print-goal-production-traces (goal traces)
 (soar-format *trace-file*
              "~%~%Goal: ~A"
              goal)
 (pretty-print-production-traces traces)
 T
)    

(defun pretty-print-production-traces (traces)
 (mapc #'pretty-print-production-trace traces) 
 T
)

(defun pretty-print-production-trace (trace)
 (let ((action (first trace))
       (rtrace (second trace)))
  (declare (type tme action)
           (type rtrace rtrace))
 (soar-format *trace-file*
              "~%~%Production Name: ~A Trace Number: ~D~
               ~%Action: ~A~
               ~%Results:~
               ~%~A~
               ~%Non-Results:~
               ~%~A~                              
               ~%Possible Results:~
               ~%~A"
              (production-trace-name rtrace)
              (production-trace-number rtrace)
              action
              (production-trace-results rtrace)
              (production-trace-non-results rtrace)
              (production-trace-possible-results rtrace))
 T
)) 





;;; MISCELLANEOUS UTILITIES.

(defun timetag-tme (integer)   
 (declare (fixnum integer))
 ;; if integer is a current timetag, returns the tme.
 ;; (to get timetag from tme, use function timetag,
 ;; for example (timetag (state s4 ^att a1 NIL)).)
 (cond ((> integer 0)
        (find-wme-of-timetag integer))
       (T
        NIL))
)

                          

;; not used.
(defun parse-and-instantiate-tmes (raw-tmes)
 (let ((*in-rhs* T) 
       (*variable-memory* NIL))
  (mapcar
   #'(lambda (tme)
      (declare (type tme tme)) 
      (instantiate-tme (tme-class tme)
                       (tme-object tme)
                       (tme-attribute tme)
                       (tme-value tme)
                       (tme-type tme)
                       (tme-reference tme)))
   (parse-tmes raw-tmes))
))

(defun parse-tmes (tmes)
 (let ((*rhs-smake-or-ppwm* 'ppwm))
  (catch-sptop-errors                    
    (sp-parse-ppwm tmes))
))

(defun parse-tme (tme)
 (first (parse-tmes tme))
)

(defun lispload (file-string)

 ;; suspends soar syntax while loading file.

 ;; lispload installs lisp syntax, loads, and
 ;; then installs soar syntax.
 ;; soarload installs soar syntax, loads, and 
 ;; then installs lisp syntax.

 (lispsyntax)
 (load file-string)
 (soarsyntax)
)      

(defun lispsyntax ()
 (soarresetsyntax)
)

(eval-when (compile eval load) (proclaim '(ftype (function (break-log) break-log) clear-break-log)))
(defun clear-break-log (log)
 (declare (type break-log log))               
 (setf (break-log-augmentation-additions log) NIL)
 (setf (break-log-augmentation-removals log) NIL)
 (setf (break-log-preference-additions log) NIL)
 (setf (break-log-preference-removals log) NIL)
 (setf (break-log-firings log) NIL)
 (setf (break-log-retractions log) NIL)
 (setf (break-log-context-installations log) NIL)
 log
)

(defun start-user ()
 T
)

(defun restart-user ()
 (unschedule-general-breaks *run-break-log*)
 (setf *run-break-log* (clear-break-log *run-break-log*))    
 (unschedule-general-breaks *pbreak-break-log*)
 (setf *pbreak-break-log* (clear-break-log *pbreak-break-log*))
)

(defun retask-user ()
 (unschedule-general-breaks *run-break-log*)
 (setf *run-break-log* (clear-break-log *run-break-log*))    
)



;;;*****************************************************************************
;;; File name: soar-edt.lisp 
;;; Purpose:   Event and Decision Timing (EDT) code for Soar5.
;;; Author:    Mark Wiesmeyer
;;; Date:      4-9-90
;;; Address:   wiesmeye@caen.engin.umich.edu
;;;
;;; Description:
;;; This code extends Soar 5 so that it can be a more useful tool for cognitive
;;; modeling and simulation. It allows users to specify the timing of operators 
;;; and events in Soar. Times associated with operators are used to "clock" the 
;;; system at the decision phase and events occur during operator applications 
;;; in the elaboration phase. The user specifies a list of operators and times 
;;; that they require to apply (*operator-times*). The times associated with 
;;; operators are simple integers without time units specified. (I think of my
;;; operators as having times in msec.) 
;;;
;;; At decision, the operator chosen, if it appears in the list of operators and 
;;; times, is saved as the current timed operator (*current-timed-operator*).
;;; Before each preference phase during the elaboration phase in which 
;;; the current timed operator is applied, the time (*time*) is temporarily 
;;; updated so that the events that are slated to occur before the end of the
;;; current decision cycle can be executed. The reason time is not updated 
;;; permanently is because the current time is used to merge events that happen
;;; during elaboration into their proper place in the list of events that is 
;;; to be executed (*event-sequence*); some of these events may need to occur
;;; during the current elaboration phase. Permanent updating of the time occurs 
;;; at decision cycles after the application of a timed operator. Operators 
;;; that are applied, but are not timed do not update the time. Likewise,
;;; operators that are applied using operator application subgoals do not update 
;;; the time, but the operators in the subgoals may update the time, if they 
;;; are timed.
;;;                                             
;;; An event is defined to be a time and an action. The times again 
;;; do not have specified units, but must be at the same scale as the operator
;;; times. Two functions are used to specify events to the system: (1)
;;; SET-EVENTS allows the user to initialize the system to a list of events to 
;;; be executed. (2) MERGE-EVENTS-IN-SEQUENCE allows Soar to merge lists of 
;;; new events into the initialized sequence as it is running. Event times are 
;;; specified as exact times for SET-EVENTS and as times relative to when the 
;;; new events are posted by MERGE-EVENTS-IN-SEQUENCE. Events come from two
;;; sources: the "environment" (using 1 and 2) and Soar output (Motor) functions 
;;; (only using 2), and all end up merged in the same event sequence.
;;;
;;; To summarize, this code allows:
;;;    (1) Actions caused by motor output to occur after a motor operator
;;;        applies, which simulates independence between Cognition and Motor.
;;;    (2) Actions related to environmental events to be independent
;;;        of operator firing, which simulates independence of the Soar
;;;        agent and its environment. 
;;;    (3) Operator decision and action times to be printed in a Soar trace.
;;;
;;; This is a first-pass attempt and I realize that there may be shortcomings 
;;; in both the code and the description that I have provided. There are no 
;;; bugs in the code, as far as I can tell, but I may have forgotten features
;;; that might be useful to some. The description (you just read it) is very 
;;; terse and I am depending on the (early) user to read the code and the 
;;; demonstration program that I have provided in order to figure out how to
;;; use the code. I think that the demonstration program (edt-demo.lisp) 
;;; should be very helpful and I suggest that if you are interested in using
;;; this facility, that you load this file and then the demo file on top of
;;; Soar 5. The demo will run automatically when loaded. There is a good 
;;; possibility that this code will become part of a new release of Soar. In
;;; any case, I would like to hear comments from user community about both 
;;; the features and description of the code before I put a lot more effort 
;;; into them. It would be nice if we could work as a group and push together 
;;; to make Soar a better tool for simulation and cognitive modeling. My 
;;; suspicion is that if this code becomes an official part of Soar that
;;; the finished documentation for it will appear in a new chapter of the Soar
;;; manual. I have found this code to be useful for my work and I hope that
;;; you can find it useful in yours! 
;;; 
;;; A caveat:
;;; One of the biggest problems with this code (and one that may never be
;;; resolved) is that actions can occur at any time during elaboration as 
;;; long as they are slated to occur before the next decision. There are two
;;; subproblems:
;;;
;;; _Bunching_ can occur when there are a number of actions in the event 
;;; sequence that must happen before the next decision. Even if the times for
;;; each action are well spread apart, the actions will occur at the same time
;;; and as soon as possible (at the first preference phase in the elaboration 
;;; phase of an operator application). This problem occurs because the smallest 
;;; unit of time that is defined in Soar-EDT is the time associated with 
;;; operator applications and many events are defined on smaller time scales 
;;; and are not necessarily synchronized to operator decisions. Since actions 
;;; occur before each preference phase in the elaboration phase of an operator
;;; application a possible solution might be to predict how many preference
;;; phases are likely to occur during elaboration, which would make it possible 
;;; to spread out actions. Unfortunately, there is no way of making such 
;;; predictions accurately, since the number of elaboration cycles is often 
;;; contingent upon input. It is also unclear whether this level of time 
;;; resolution is warranted or would even be helpful. After all Soar is a 
;;; cognitive model at the operator level.
;;;
;;; A worse problem is _Mixing of order of actions_, which occurs when an
;;; event occurs as a consequence of a motor output during an elaboration cycle. 
;;; The time of the new action is calculated from the time of the last
;;; decision and it is possible that other actions may have occurred already 
;;; in the current elaboration phase (because of bunching) that should have 
;;; occurred after it.
;;;
;;; If you don't understand the details of these problems, don't worry. In most
;;; situations I am pretty sure that they will not affect the quality of your 
;;; simulations. I look forward to your comments and solutions to these problems.
;;;
;;; To use this code, simply compile it (run lispsyntax function first) and load 
;;; it in on top of your Soar5 image.
;;;
;;; To run the Soar-EDT demo, simply load edt-demo.lisp after loading this code.
;;; Don't compile it since there are productions in it.
;;;
;;; File organization:
;;;   Global variables                 
;;;   Functions to hook into Soar5
;;;   EDT functions (not to be called by Soar or user)
;;;   Function to be called by Soar output or environment simulation code.
;;;          MERGE-EVENTS-IN-SEQUENCE (event-list)
;;;   User macros
;;;          INIT-EDT ()                - Must be called first after or as  
;;;                                        part of init-task; automatically
;;;                                        turns facility on in process.
;;;          SET-EDT (nil-or-t)         - Turn this facility on or off.
;;;          SET-TIME (time)            - Set time to any value.
;;;          SET-EVENTS (event-list)    - Initialize event sequence.
;;;          PRINT-TIMES (nil-or-t)     - Nil = no print; T = print
;;;          PRINT-EVENTS (nil-or-t)    - Nil = no print; T = print
;;;          SET-TRACE-TABTO (a-number) - Default is 16 spaces. Number of
;;;                                        spaces that Soar trace will be
;;;                                        tabbed to.


;;;*****************************************************************************
;;; Function: update-time-and-get-current-operator
;;; Description: Called at decision.
;;;*****************************************************************************

(defun update-time-and-get-timed-operator (object) 
  (when *current-timed-operator*
    (setq *time* (update-time *current-timed-operator*))
    (when *print-times*
      (let ((*printing-time* t)
	    )
	(soar-format t "~%~4D~A~A" *time* " " *time-unit*))  ;Decision ends.
      (setq *time-last-printed* *time*))
					
    (setq *current-timed-operator* nil))
  
  (let ((context-object (get-object-name object)) ;;May actually not be an operator or
	)                                         ;; may not be in *operator-times*.
    (when (in-operator-timesp context-object)
      (setq *current-timed-operator* context-object))))

(defun get-object-name (object)                  
  (declare (type tme-object object))

  (first (nested-trace-attribute-values object)))

;;;*****************************************************************************
;;; Function: event-timing
;;; Description: Called immediately before each preference phase.
;;;*****************************************************************************

(defun event-timing ()
  (when *current-timed-operator*
    (execute-events)))


;;;*****************************************************************************
;;; Function: in-operator-timesp
;;;*****************************************************************************

(defun in-operator-timesp (operator)
  (assoc operator *operator-times*))
     
;;;*****************************************************************************
;;; Function: update-time
;;;*****************************************************************************

(defun update-time (operator)
  (+ *time* (second (assoc operator *operator-times*))))

;;;*****************************************************************************
;;; Function: execute-events
;;;*****************************************************************************

(defun execute-events ()
  (do* ((decision-time (update-time *current-timed-operator*)) 
	(events *event-sequence* (rest events))
	(event (first events)(first events))
	(current-event-time (first event)(first event))
	)
       
       ((or (null events)
	    (>= current-event-time decision-time))
	 (setq *event-sequence* events))

    (when (and *print-times*
	       (null (eq current-event-time *time-last-printed*)))
      (setq *time-last-printed* current-event-time)
      (let ((*printing-time* t)
	    )
	(soar-format t "~%~4D~A~A" current-event-time " " *time-unit*)))
    
    (cond ((stringp (second event))
	   (when *print-events*
	     (soar-format t "~%~A" (second event))))
	  (t 
	   (eval (second event))))))
	
;;;*****************************************************************************
;;; Function: absolute-times
;;;*****************************************************************************

(defun relative-events-get-absolute-times (events)
  (mapcar #'(lambda (event) (list (+ *time* (first event))(second event)))
	events))

;;;*****************************************************************************
;;; Function: merge-events-in-sequence
;;;*****************************************************************************

(defun merge-events-in-sequence (relative-events)
  (setq *event-sequence* (merge 'list 
				*event-sequence* 
				(relative-events-get-absolute-times relative-events)
				#'(lambda (x y) (< (first x)(first y))))))

;;;*****************************************************************************
;;; EDT User Functions: 
;;;*****************************************************************************

(defun init-edt ()
  (setq *time* 0)
  (setq *current-timed-operator* nil)
  (setq *event-sequence* nil)
  (setq *print-events* nil)
  (setq *print-times* nil)
  (setq *edt* nil))

(defmacro set-edt (nil-or-t)
  `(cond ((or (eq ,nil-or-t nil) (eq ,nil-or-t t))
	  (setq *edt* ,nil-or-t))
	 (t (soarwarn "SET-EDT: invalid input value" ,nil-or-t))))
  
(defmacro set-time (an-integer)
  `(cond ((integerp ,an-integer)
	  (setq *time* ,an-integer))
	 (t (soarwarn "SET-TIME: invalid input value" ,an-integer))))

(defmacro set-events (event-sequence)
  `(when (all-events-ok ,event-sequence)
     (setq *event-sequence* (copy-list ,event-sequence)))) ;Merge is destructive.


(defun all-events-ok (events) ; EHP 17 may 90
  (not (find-if #'event-not-ok events)))



(defun event-not-ok (event) ; EHP 17 may 90
    (cond ((null (listp event))
           (soarwarn "SET-EVENTS: input must be a list of lists" event)
           t)
          ((null (integerp (first event)))
           (soarwarn "SET-EVENTS: sublists must start with a number" event)
           t)
          ((null (or (and (listp (second event))
                          (fboundp (first (second event))))
                     ;;changed to fboundp EHP 17 may 90
                     (stringp (second event))))
 (soarwarn "SET-EVENTS: second of sublists must be a function call or string"
          event)
           t)))
    

(defmacro set-print-times (nil-or-t)
  `(cond ((or (eq ,nil-or-t nil) (eq ,nil-or-t t))
	  (setq *print-times* ,nil-or-t))
	 (t (soarwarn "SET-PRINT-TIMES: invalid input value" ,nil-or-t))))

(defmacro set-print-events (nil-or-t)
  `(cond ((or (eq ,nil-or-t nil) (eq ,nil-or-t t))
	  (setq *print-events* ,nil-or-t))
	 (t (soarwarn "SET-PRINT-EVENTS: invalid input value" ,nil-or-t))))

(defmacro set-trace-tabto (an-integer)
  `(cond ((integerp ,an-integer)
	  (setq *soar-trace-tabto* ,an-integer))
	 (t (soarwarn "SET-TRACE-TABTO: invalid input value" ,an-integer))))

(defun sp? (prod)
     (if (soar::soarmemq prod soar::*pnames*)
         t))

(defmacro r (&optional n)
  `(if ,n
      (run ,n)
      (run)))

(defun attribute-value (symbol attribute)
 "return the value of ATTRIBUTE for SYMBOL"
 (let ((result (find attribute (get symbol 'wmpart*)
                     :test  #'(lambda (x y) (equal x (third (car y) ))))))
 (if result
     (fourth (car result)))))

(defun context-object-name (symbol)
 "get name of SYMBOL"
  (format nil "~a" (or (attribute-value symbol 'name)
                        symbol)))

(defun context-object-name-p (symbol)
 "does SYMBOL still have a soar name?"
 (and (attribute-value symbol 'name)))


(defdsmmacro top-ps ()
                       () symbol
 (declare)
 `(if *top-gnode* (problem-space *TOP-GNODE*))
)

(defun find-production-ps (achunk)
 "Finds the ps that ACHUNK belongs to.
If not accesable by name, tries to find ps based on operator,
else returns the top-level problem space.  If passed nil, it returns nil."
 (if (get-p achunk)
 (let ( (left-side (get-sp-lhs (p-production (get-p achunk)))))
  (do ( (clause left-side (pop left-side))
        (ps-name nil) 
        (operator-name nil) )
   ;; end test & result
   ( (and (not left-side) (not clause))
     (cond ( ps-name)
           ( operator-name
            ;; better wrapper here -fer
	     #+sx(if soar::graphic-display?
                     (sx::find-operator-problem-space operator-name)
                     (top-ps))
	     ;; lose early
	     #-sx(top-ps))
           (t (format t "GOT a chunk without a PS or O !: ~a~%" achunk)
              (top-ps))) )
   ;; body
   (if (listp clause)  ; you could eat a negation bad here...
	               ; actually should check for -^problem-space
       (let ( (name (second (member 'name clause)))
              (type (car clause))  )
         (if name  
             (cond ((eq 'operator type)
                    (setq operator-name name) )
                   ((eq 'problem-space type)
                    (setq ps-name
			  ;#+sx(sx::get-sx-item name)
                          #+sx name
			  #-sx name)))))) ))))


(eval-when (compile eval load) (proclaim '(inline decision-cycle-count)))
(defun decision-cycle-count ()
   (- (cycle-count 'quiescence-phase) 1))

(eval-when (compile eval load) (proclaim '(inline elaboration-cycle-count)))
(defun elaboration-cycle-count ()
   (- (cycle-count 'preference-phase) 1))

;;; Concatenated from type module "actions" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/actions/new/actions.lisp".
(in-package "SOAR")


;;; <ACTIONS.FUNS>


;;; ACTIONS MODULE: FUNCTIONS.
            
;;; CHUNKING: ACTION IDENTIFICATION (RESULTS).
                             

;;; MODULE FUNCTIONS.
                        
                         
;;; RESULT TRACING.

(eval-when (compile eval load) (proclaim '(ftype (function (gnode list) true) log-rhs-results)))
(defun log-rhs-results (creator-gnode rhs)
 ;; Hard to read code; let-dolist-let recommened.  -BGM 17-Jul-90
 ;; changed so that the sorting is done here. This routine takes a list of tmes
 ;; and finds the ones with a common object and then adjusts the onode for that object
 ;;   to show all the changes.
 ;; Partially done for Bug#26Feb90-14.11.46 & 19Apr90-21.34.59 19/May/90 GAP
 (declare (type gnode creator-gnode)
          (list rhs))

 (let ((sorted-rhs (sort (copy-list rhs) #'string< :key #'second)))  ;sort on object id.

 (do* ((tmes sorted-rhs (rest tmes))
       (tme NIL)
       (object (tme-object (first tmes)))
       (object-tmes NIL))
      ((null tmes)                   
       ;; last object.
       (log-object-results creator-gnode (object-onode object) object-tmes))

  (declare (list tmes)
           (type tme tme)
           (type tme-object object)
           (list object-tmes))

  (setf tme (first tmes))                                                 
  (cond ((eq (tme-object tme) object)
         ;; another tme for current object.
         (push tme object-tmes))
        (T
         ;; first tme for a new object. log results for current object and
         ;; set up new object. 
         (log-object-results creator-gnode (object-onode object) object-tmes) 
         (setf object (tme-object tme))
         (setf object-tmes (list tme)) )) )
 T
))

(eval-when (compile eval load) (proclaim '(ftype (function (gnode onode list) true) log-object-results)))
(defun log-object-results (creator-gnode augmented-onode preferences)
 ;; Log-object-results seems to be getting duplicate calls for context preferences.
 ;; Once for when the preference is asserted by a production, and once when
 ;; its context augmentation is asserted. -BGM 17-Jul-90
 (declare (type gnode creator-gnode)                   
          (type onode augmented-onode)
          (list preferences))

 ;; log object's actions as results or non-results.
 
 (let ((owner (onode-owner augmented-onode)))
  (declare (type tme-object owner))
 
  (cond ((eq owner (gnode-goal creator-gnode))
         ;; non-results.
         (put-object-non-results creator-gnode augmented-onode preferences))
        (T              
         ;; results.
         (let ((owner-gnode (goal-gnode owner)))
          (declare (type gnode owner-gnode))
                                                                          
          ;; log new pmes as results for creator goal up to
          ;; but excluding owner goal.
          (do ((gnode creator-gnode (gnode-supernode gnode)))
              ((eq gnode owner-gnode))
            (declare (type gnode gnode))
            (put-object-results gnode augmented-onode preferences)
            (put-chunk-actions gnode preferences))

          ;; log new pmes as non-results for owner goal.
          (put-object-non-results owner-gnode augmented-onode preferences)           
 
          ;; trace substructure of new pmes, promoting non-results to results.
          (trace-subobject-results
             ;; owner's gnode.
             owner-gnode                
             ;; owner's subgoals.
             ;; Spurious consing; trace-subobject-results should do the iteration. -BGM 17-Jul-90
             (do ((gnode (gnode-subnode owner-gnode)
                         (gnode-subnode gnode))
                  (owner-subgoals NIL))
                 ((null gnode) owner-subgoals)
               (declare (type gnode-or-NIL gnode)
                        (list owner-subgoals))
               (push (gnode-goal gnode) owner-subgoals))
             ;; new preference tmes.
             preferences) ) ))
 T
))     

(eval-when (compile eval load) (proclaim '(ftype (function (gnode list list) true) trace-subobject-results))) 
(defun trace-subobject-results (owner-gnode owner-subgoals preferences)   
 (declare (type gnode owner-gnode)
          (list owner-subgoals preferences))

 ;; trace through the attribute and value fields of the actions
 ;; looking for objects to promote to ownership by the higher goal
 ;; represented by owner-gnode.

 (do ((tmes preferences (rest tmes))
      (tme NIL)                 
      (attribute NIL)
      (attribute-onode NIL)
      (value NIL)
      (value-onode NIL))
      ((null tmes))
  (declare (list tmes)
           (type tme tme)
           (type tme-attribute attribute)
           (type tme-value value) 
           (type onode-or-NIL attribute-onode value-onode))

  (setf tme (first tmes))  
  (cond ((member (tme-type tme) '(+ !) :test #'eq)

         ;; trace through attribute object.
         (setf attribute (tme-attribute tme))
         (cond ((symbolp attribute)
                (setf attribute-onode (object-onode attribute)) 
                (cond ((and attribute-onode
                            (member (onode-owner attribute-onode)
                                    owner-subgoals
                                    :test #'eq))
                       (trace-sub-subobject-results owner-gnode
                                                    owner-subgoals
                                                    attribute-onode) )) ))
         ;; trace through value object.
         (setf value (tme-value tme))
         (cond ((symbolp value)
                (setf value-onode (object-onode value))             
                (cond ((and value-onode
                            (member (onode-owner value-onode)
                                    owner-subgoals
                                    :test #'eq))
                       (trace-sub-subobject-results owner-gnode
                                                    owner-subgoals
                                                    value-onode) )) )) )) )
 T
)

(eval-when (compile eval load) (proclaim '(ftype (function (gnode list onode) true) trace-sub-subobject-results)))
(defun trace-sub-subobject-results (new-owner-gnode new-owner-subgoals linking-onode)
 ;; Changed to get the preferences rather than the otraces
 ;; for bug #14May90-09.23.07 GAP 10/1/90
 ;; Fixed Bug where old-owner was not being updated correctly in do loop
 ;; Bug #02Jan91-19.22.42 GAP 1/8/91
 (declare (type gnode new-owner-gnode)
          (list new-owner-subgoals)
          (type onode linking-onode))
             

 ;; promote subobjects owned by a lower goal to ownership by the higher goal
 ;; represented by new-owner-gnode.

 (let ((linked-onodes
         (onode-p-descendent-internal-onodes new-owner-subgoals linking-onode)))
  (declare (list linked-onodes))

  ;; linked-onodes is a list of all the onodes reachable from linking-onode and
  ;; having owners below the new owner.
 
  ;; for each PROMOTED OBJECT, including linking-onode.
  (do* ((onode linking-onode (pop linked-onodes))
        (new-object-results NIL))
       ((null onode)) 
   (declare (type onode-or-NIL onode)
            (list new-object-results))                                     
   (let  ((old-owner-gnode (goal-gnode (onode-owner onode)) ))
   (declare (type gnode old-owner-gnode))

   ;; update promoted object's OLD OWNER.                                    
   ;; may not be any tmes for object yet.
   (setf new-object-results (make-internal-object-external old-owner-gnode onode))
   (put-promoted-chunk-actions old-owner-gnode new-object-results)

   ;; update goals BETWEEN promoted object's OLD OWNER and NEW OWNER.
   (do* ((gnode (gnode-supernode old-owner-gnode) (gnode-supernode gnode)))
        ((eq gnode new-owner-gnode))
      (declare (type gnode gnode))
      (put-object-results gnode onode new-object-results)
      (put-promoted-chunk-actions gnode new-object-results) )

   ;; update promoted object's NEW OWNER.
   (push (onode-object onode) (gnode-internal-objects new-owner-gnode))
   (put-object-non-results new-owner-gnode onode new-object-results)

   ;; update PROMOTED OBJECT itself.
   (setf (onode-owner onode) (gnode-goal new-owner-gnode)) ))
 T
))

    

;;; LHS RESULT TRACING.
 
(defun split-apart-conditions (data-matched current-gnode)
 (declare (list data-matched)
          (type gnode current-gnode))

 ;; splits conditions into:
 ;;  negations and results (appended)        - external to current-goal
 ;;  non-results                             - internal to current-goal
 ;;  possible results                        - possibly external to current goal
                     
 ;; another description:
 ;; Separate wme elements into those that are pre-existing structure
 ;; or results and those that are local to the subgoal.             

 ;; a wme is classified as a possible result even if it is known to be 
 ;; a result, if it cannot be determined to be a result from the portion
 ;; of the working memory tested in the LHS.

 (prog
  (wme object next-object object-traces object-trace
   current-goal results non-results possible-results negated-results
   one-time-results object-results non-result-objects
   negsym external-ids re-process-possible-results)
        
  (setf current-goal (gnode-goal current-gnode))
  (setf object nil)                                            
  (setf object-traces (gnode-traces current-gnode))
  (setf results nil)
  (setf negated-results nil)
  (setf non-results nil)
  (setf possible-results nil)
  (setf non-result-objects (gnode-internal-objects current-gnode))
  (setf external-ids nil)
  (setf re-process-possible-results t)

  (setf one-time-results (gnode-chunk-actions current-gnode))

  l1
   (cond ((and (null data-matched)	re-process-possible-results)
          ;; re-process possible-results.
      	   (setf re-process-possible-results nil)
      	   (setf data-matched (reverse possible-results))
      	   (setf possible-results nil) ))

    (cond ((and (null data-matched)	(null re-process-possible-results))
           ;; done.
           (return (values (reverse (append results negated-results))
                         		 non-results
                         		 (nreverse possible-results))) ))
                      
    ;; next LHS wme.
    ;; this was being done with pop.
    (setf wme (first data-matched))    
    (setf data-matched (rest data-matched))

    (cond ((is-negation wme)  
           ;; negated wme.
       	   (setf negsym wme)
       	   (setf wme (first data-matched))
           (setf data-matched (rest data-matched))
       	   (cond ((consp (car wme))
              		  (cond ((negated-chunk-condition-test (car wme) current-goal)
                     			 (soarpush negsym negated-results)
                     			 (soarpush wme negated-results))) )
       		               ((negated-chunk-condition-test wme current-goal)
              	       	  (soarpush negsym negated-results)
                     		  (soarpush wme negated-results) )))

          (t
           ;; positive wme.

           ;; get object-trace for current wme's object.
           (setf next-object (tme-object wme))
           (cond ((eq object next-object))
                 (T
                  (setf object next-object)
                  (setf object-trace (gethash object object-traces))
                  (cond ((null object-trace)
                         ;; may not be one if tracing a fake firing;
                         ;; the condition may be (this-is-a-hack...).
                         (setf object-results NIL))
                        ((otrace-results-p object-trace)
                         (setf object-results (otrace-tmes object-trace)))
                        (T
                         (setf object-results NIL) )) ))

         	 (cond ((eq (wme-class wme) 'goal)
                  ;; positive goal wme. 
              	   (cond ((member object non-result-objects :test #'eq)
                         ;; non-result. internal.
                     		  (push wme non-results))
                     		 (t  
                         ;; external.             
                         (setf external-ids (add-external-ids wme external-ids))
                   		    (push wme results)
                   		    (setf re-process-possible-results t) )))

              	  (t                                                                  
                  ;; positive non-goal wme.
                  (cond ((member object non-result-objects :test #'eq) 
                         ;; internal object. preference is non-result.
                   		    (push wme non-results))
                   		   ((or (member wme object-results :test #'action=)
                             (member wme one-time-results :test #'action=))
                         ;; external object.
                         ;; but preference not treated as a result unless externality
                         ;; can be established using only the subgraph represented
                         ;; by the LHS.
                         (cond  ((member object external-ids :test #'eq)  
                                 ;; preference is result.
                              	  (push wme results)
                                 (setf external-ids (add-external-ids wme external-ids))
                            			  (setf re-process-possible-results t))
                           			  (t
                                 ;; preference may be a result.
                                 ;; depends on whether result reached in lhs
                                 ;; along external or internal path.
                                 (push wme possible-results))))
                   		    (t    
                          ;; external object. pre-existing structure.
                          ;; (wme not on any of the result lists, so not even created
                          ;;  in current-goal.)
                          (setf external-ids (add-external-ids wme external-ids))
                          (push wme results)
                  		      (setf re-process-possible-results t) )) )) ))
  (go l1)
))

(defun add-external-ids (tme external-ids)
 (declare (type tme tme)
          (list external-ids))
 ;; called by split-apart-conditions.
 ;; replaces extract-ids.
 (pushnew (tme-id tme) external-ids :test #'eq)
 (let ((attribute (tme-attribute tme))
       (value (tme-value tme)))
  (declare (type tme-attribute attribute)
           (type tme-value value))
  (cond ((object-p attribute)
         (pushnew attribute external-ids :test #'eq) ))
  (cond ((object-p value)
         (pushnew value external-ids :test #'eq) ))
 external-ids
))
 
(defun negated-chunk-condition-test (wme current-goal)   
 (let* ((id (wme-id wme))                               
        (owner (if id (object-owner id))))
  (not (eq owner current-goal))
))


;;; UTILITIES.


(defun start-actions ()
 T
)


(defun restart-actions ()
 T
)


(defun retask-actions ()
 T
)




 
                                   

;;; Concatenated from type module "conditions" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/conditions/new/conditions.lisp".
(in-package "SOAR")


;;; <CONDITIONS.FUNS>


;;; CONDITIONS MODULE: FUNCTIONS.


;;; CHUNK MODULE: BACKTRACING TO CONDITIONS. 

                                 
;;; MODULE FUNCTIONS.


;;; INSTANTIATION OWNER.

(defun lhs-depth-and-goal (lhs)
 ;; Inefficient, spurious consing: this is doing a collect and test O(n^2),
 ;; when it should be doing a linear search. -BGM 17-Jul-90
 ;; I'm also curious as to why this is returning the goal of the deepest object matched,
 ;; and not the deepest goal matched. -BGM 17-Jul-90
 (declare (list lhs))

  ;; compute instantiation owner. 
  ;; used to be find-max-goal-depth.
  ;; lhs is lhs of instantiated rule.
  ;; returns deepest goal in which an lhs object was created and its depth,
  ;; as multiple values (depth goal).      
  ;; used by lhs-goal (fire-rule), put-chunk-seed,
  ;; internal-chunk-refraction, and external-chunk-refraction.

 (let ((max-depth -1)
       (max-goal NIL))
  (declare (fixnum max-depth)
           (symbol max-goal))
  (do ((wmes lhs)
       (object NIL)
       (goal NIL)
       (depth 0)
       (tested-objects NIL))
      ((null wmes) (values max-depth max-goal))
   (declare (list wmes tested-objects)
            (type tme-object object goal)
            (fixnum depth))
   (cond ((wme-negation-p (first wmes))
          ;; skip negated wme.
          (pop wmes)
          (pop wmes))
         (T
          (setf object (tme-object (pop wmes)))
          (cond ((not (member object tested-objects :test #'eq))
                 (push object tested-objects)
                 (setf goal (object-owner object))
                 (setf depth (goal-depth goal))
                 (cond ((not (integerp depth))
                        (lhs-depth-and-goal-error object)
                        (return))
                       ((< max-depth depth)
                        (setf max-depth depth)
                        (setf max-goal goal) )) )) )) )
))                               

(defun lhs-depth-and-goal-error (object)
 (declare (type tme-object object))
 (soar-format *trace-file*
              "~%Error from lhs-goal-and-depth: Object symbol ~A ~
                 should have been created with ~
                 make-io-object-symbol or ~
                 make-user-object-symbol or ~
                 declared with declare-objects.~
                 ~%Halting at cycle end."
              object)
 (signal-halt)
)
 
    

                                      
;;; INSTANTIATING NEGATED CONDITIONS.

(defun add-negations (current-goal data-matched)
  #+:soar-times (start-soar-time chunk)
  (prog (firing-p negation-index var-list)
   (setf firing-p (firing-p))                                     
   ;; there will be no firing-p, and no negations, for a "fake" rule firing,
   ;; that is, firings faked to represent the decision procedure.
   (setf negation-index (if firing-p (p-negation-index firing-p)))
   (cond ((null negation-index)
                    #+:soar-times (stop-soar-time chunk)
                    (return nil)))
   (setf var-list (caddr negation-index)) ;variable > variable position in lhs
   (return 
    (prog1 
       (instantiate-remaining-conditions (car negation-index)  ;negated conditions
                                          current-goal
                                          var-list
                                          data-matched
                                          '-)
#+:soar-times
       (stop-soar-time chunk) ))
))

(defun instantiate-remaining-conditions
       (conditions current-goal var-list data-matched symbol)
  (prog (condition new-condition return-list)
        (soarwhile (consp conditions) ; Added check for CONSP. -BGM 3/27/89
                   (setq condition (pop conditions))
                   (setq *secondary-variables* nil)
                   (cond ((soarlistp (car condition))
                          ;; conjunctive negation.
                          (setq new-condition
                                (soarmapconc
                                 #'(lambda (x)
                                     (instantiate-negated-condition x 
                                                                    data-matched 
                                                                    var-list 
                                                                    current-goal
                                                                    1))
                                 condition))
                          (cond (new-condition
                                 (soarpush symbol return-list)
                                 (soarpush new-condition return-list))) )
                         ((setq new-condition (instantiate-negated-condition condition 
                                                                             data-matched 
                                                                             var-list 
                                                                             current-goal
									     1))
                          ;; simple negation.
                          (soarpush symbol return-list)
                          (soarpush (car new-condition) return-list))) )
(return return-list)
))

(defun instantiate-negated-item (item
                                 data-matched
                                 var-list
                                 new-condition)
 (prog (element new-id)
   (cond ((variablep-not-predicate item)
           ;; variable. 
           (setf element (cdr (soarassq item var-list)))
           (cond ((and element (soarlistp element))                      
              ;; variable appears in LHS.
              ;; var-list locates a variable in the instantiated LHS.
                    (return (nth (cadr element)
                                   (nth (car element) data-matched)) ))
                 ((setf element (cdr (soarassq item *secondary-variables*)))
                  ;; variable does not appear in LHS, but has already been
                  ;; created during negation instantiation.
                    (return element))
                 (t                                        
                  ;; variable does not appear in LHS, and has not already been
                  ;; created during negation instantiation.
                    (setf new-id
                          (make-negated-object-symbol (soarnthchar item 2)
                                                      (or
                                                        (object-owner ;; if this is part of another goal then
                                                          (wme-id      ;; make the symbol part of the goal.
                                                                      ;; thus connectedness to the goal is
                                                                      ;; maintained within the conjunction.
                                                             (reverse new-condition)))
                                                      (firing-goal))))
                    (soarpush (cons item new-id) *secondary-variables*)
                    (return new-id) )) )
          (t
           ;; not variable.
             (return item) ))
  )
)

(defun instantiate-negated-condition (condition
                                      data-matched
                                      var-list
                                      current-goal
                                      depth)
 ;; *secondary-variables* used only by this function and its caller,
 ;; instantiate-remaining-variables, which only initializes it.
 (prog (new-condition item)

 (if (eq condition '-)
     ;; chunker cannot handle negations within conjuctive negations.
     ;; this will work for some such cases, not all.
     ;; without this, it does not work for any case.
     (return NIL)) 
 (setf new-condition nil)
 (soarwhile (consp condition) ; Added by BGM 3/27/89 to stop infinite loops.
    (setf item (pop condition))
    (if (listp item)  ;;
     (soarpush (car (instantiate-negated-condition item data-matched 
                                                   var-list 
						   current-goal (+ 1 depth)))
               new-condition)
    ;;else
     (soarpush (instantiate-negated-item item data-matched var-list new-condition)
               new-condition) )
 )
 (setf new-condition (nreverse new-condition))

  ;; don't bother to save if new-condition's wme-id born in current-goal.
 (cond ((or (not (eq depth 1))
            (negated-chunk-condition-test new-condition current-goal))
        (return (list new-condition))))
 (return nil)
))


;;; SUPERVISION OF BACKTRACING AND CHUNK BUILDING.                

(defun post-process-results (firing-gnode support-list) 
 ;; Added processing to handle per preference support
 ;; Bug #13Mar90-17:00.27   GAP 4/11/90
 (declare (type gnode firing-gnode)
          (list support-list))

 ;;; called by fire-rule after a production fires.

 (do ((gnode firing-gnode (gnode-supernode gnode))
      (chunk-actions NIL)
      (promoted-chunk-actions NIL))
     ((null gnode))       
   (declare (type gnode-or-NIL gnode)
            (list chunk-actions promoted-chunk-actions)) 
 
   ;; the chunk actions are computed during results tracing (log-rhs-results).
   (setf chunk-actions (gnode-chunk-actions gnode))
   (setf promoted-chunk-actions (gnode-promoted-chunk-actions gnode))

   (cond (chunk-actions

          ;; chunk.
          (start-build-time)
          (handle-back-trace-actions gnode chunk-actions promoted-chunk-actions 
                                     support-list)
          (stop-build-time) 
         
          (if (and (not (gnode-chunks-p gnode))
                   (building-chunk-p)
                   (building-external-chunk-p))
              ;; chunk just built was an external chunk. 
              ;; tag goal as having chunks (for bottom-up learning).
              (setf (gnode-chunks-p gnode) T))
              
          (clear-chunk-actions gnode) )) )

   ;; created for LHS variables appearing only in negations.
   (release-negated-object-symbols)
)


(defun handle-back-trace-actions (gnode chunk-actions promoted-chunk-actions support-list)
 ;; Patched to put the right nots into chunk traces. -BGM 20-May-91
 ;; Mangled to deal with nots. -BGM 17-Apr-91
 ;; Hacked call to save-chunk-trace to handle nots as NIL. -BGM 17-Apr-91
 ;; changed rhs-class to support-list
 ;; Partially done for Bug#26Feb90-14.11.46 & 19Apr90-21.34.59 19/May/90 GAP
 ;; Changed to not build chunks with no left hand side. This is basically from
 ;; when tracing back directly through the object link in a production. 
 ;;   Bug #13Mar90-17.00.27    GAP 14-May-90
 ;; Changed to not chunk when partial o-support is found in non-learning
 ;;   situations. This gets rid of internal chunks that are not needed.
 ;;   Bug #05Feb90-16.03.00    GAP 25-Mar-90
 ;; Changed to give O-support to chunks that don't fire but would have 
 ;;   given o-support bug #05Sep90-13.02.05 GAP 28-Nov.90

 (declare (type gnode gnode)
          (list chunk-actions promoted-chunk-actions)
          (ignore support-list))

 ;; replaced clear-var-list with initialize-soar-genvar. KAM. 4/3/89.

 ;; Changed old style printing of wmes to new print-wme style. -BGM 1/17/89
 ;; Bug fix of (set-chunk-bit-t goal) to ditto (car (get goal 'supergoals)) from JEL for DMS by BGM. 7/14/88.
 ;; From JEL for the exhaustion hack, installed by Milnes, 7/3/88.

 ;; called by post-process-results.

 #+:soar-times (start-soar-time chunk)
 (prog (condition-list
        negation-list
        wme-list     ;lhs wmes
        rhs-wme-list ;rhs wmes
        nots         ;not id pairs
        vnots        ;not variable pairs
        action-list            
        goal
        supernode
        build-condition-list
        build-action-list
        learning-p
        data-matched
       )    
                                    
   (if promoted-chunk-actions
      (setf chunk-actions (append chunk-actions promoted-chunk-actions)))

   (setf goal (gnode-goal gnode))
      
   ;; are we learning in this goal?
   (setf learning-p (learning-p gnode))
                   
   ;; assume chunk will be external.                               
   (building-external-chunk)

  ;; part of gensym module. just cleans up globals and
  ;; properties of symbols used during chunking.
  (initialize-soar-genvar)
  (setq *learn-ids* nil) ;clear-var-list used to do this.

  ;; supergoal.
  (cond ((gnode-supernode gnode)
   		    (setf supernode (gnode-supernode gnode)))
   		   (T 
  		     #+:soar-times (stop-soar-time chunk)
                     (return) ))

  ;; actions.
  (setf action-list chunk-actions)
  (setf rhs-wme-list action-list)
            
  #+(or)  ;debug
  (soar-format *trace-file*
               "~%Backtracing. Goal: ~A Rule: ~A"
               goal
               (p-name (firing-p)))

  ;; back-trace to conditions.
  ;; must backtrace even if not learning or not building chunk
  ;; unless learn is never because learn might be turned back on and then 
  ;; the backtraces would be needed.

  (multiple-value-setq (wme-list nots)
    (back-trace-conditions goal gnode action-list *ltrace*))

  (setf data-matched (reverse wme-list))

  ;; save production trace. 
  ;; there is one production trace for each action of the instantiation
  ;; being chunked. 
  ;; save these as traces for the supergoal.    
  ;; represents subgoal activities after subgoal flushed.
  ;; goal will be rule-name in trace.
  (if supernode
      (save-chunk-trace goal data-matched action-list supernode nots))

  #+(or)  ;debug
  (soar-format *trace-file*
               "~%Chunking.    Goal: ~A Rule: ~A"
               goal
               (p-name (firing-p)))

  ;; building internal chunk?
  (cond (*over-gen-chunk* 
         ;; have backtraced through a test of the goal quiescence augmentation.
         ;; chunk is over-general. 
         ;; just drop this condition; it is always true.      
         (setf wme-list
               (remove-if
                #'(lambda (wme)
                   (and (listp wme)  ;might be a - or *
                        (eq (wme-class wme) 'this-is-a-hack)))
                wme-list)) 
         (building-internal-chunk wme-list) )
        ((not learning-p)
         (building-internal-chunk wme-list) ))
  (cond ((building-constant-chunk-p)
         (cond ((or (null wme-list) (null rhs-wme-list)) ;3/14/90
                (return nil))
	       (T (build-constant-internal-chunk wme-list rhs-wme-list)
                (return) )) ))
  
  ;; make variables for condition ids. 
  ;; augments id to variable map in *learn-ids*.
  (augment-variable-value-mappings (condition-tmes-to-objects wme-list))

  ;; variablize conditions.
  (setf condition-list
   		   (soarmapcar #'(lambda (x)
                                   (clean-up-clause x 'condition))
          			       wme-list))
  ;; Variabilize nots.
  (setf vnots (mapcar #'(lambda (id1.id2) 
			 (let* ((id1 (car id1.id2))
				(id2 (cdr id1.id2))
				(v1 (cdr (assoc id1 *learn-ids* :test #'eq)))
				(v2 (cdr (assoc id2 *learn-ids* :test #'eq))))
			   (cons (or v1 id1) (or v2 id2))))
		     nots))

  ;; make variables for action ids.
  ;; augments id to variable map in *learn-ids*.
  (augment-variable-value-mappings (action-tmes-to-objects action-list))

  ;; variablize actions.
	 (setf action-list (mapcar #'clean-up-action action-list))

  ;; negations.
	 (setf condition-list (process-negations condition-list))
	 (setf negation-list (cdr condition-list))
  (setf condition-list (car condition-list))        


  ;; building internal chunk?
  (setf build-condition-list (append condition-list negation-list))
  (setf build-action-list (rebind-action-ids action-list
                                             (find-constant-ids action-list)))
  (cond ((null action-list)
    	    (soarwarn "No chunk was built because there were no actions" " ")
   		    (return nil))
	((null condition-list)
    	    (soarwarn "No chunk was built because there were no conditions" " ")
   		    (return nil))
        ((> (length condition-list) *max-chunk-conditions*)
  	    (soarwarn "No chunk was built because *max-chunk-conditions* was exceeded:"
			       (length condition-list))
         (building-internal-chunk wme-list) ))
  (cond ((building-constant-chunk-p)
         (build-constant-internal-chunk wme-list rhs-wme-list)
         (return) ))                                        
      

  ;; build chunk.
  (build-variablized-chunk build-condition-list
                           build-action-list
                           wme-list                   ;lhs wmes
                           rhs-wme-list               ;rhs wmes
			   vnots)

  (initialize-soar-genvar)
  (setq *learn-ids* nil) ;clear-var-list used to do this.

  #+:soar-times (stop-soar-time chunk)
))
                              

(defvar *conditions-1-hash-table* (make-hash-table :test #'eq
                                                :size 1000 
                                                :rehash-size 1000 
                                                :rehash-threshold 0.8)
        "hash table for speeding up the conditions calculations")

(defvar *conditions-2-hash-table* (make-hash-table :test #'eq
                                                :size 1000 
                                                :rehash-size 1000 
                                                :rehash-threshold 0.8)
        "hash table for speeding up the conditions calculations")

(defvar *conditions-3-hash-table* (make-hash-table :test #'eq
                                                :size 1000 
                                                :rehash-size 1000 
                                                :rehash-threshold 0.8)
        "hash table for speeding up the conditions calculations")

(defvar *conditions-4-hash-table* (make-hash-table :test #'eq
                                                :size 1000 
                                                :rehash-size 1000 
                                                :rehash-threshold 0.8)
        "hash table for speeding up the conditions calculations")



(defmacro union-with-negations-hash (list2 hash-table2 list1) 

  ;; add to list2 all the elements in list1 that are not already in list2,
  ;; including negations, which have a special syntax: 
  ;;     (negation-symbol element) rather that (element).

  ;; performs modified union of 2 condition lists.
  ;; modifications for negated conditions and foralls.
  ;; called by:
  ;;  back-trace-conditions 
  ;;  back-trace-production-conditions.
  ;; Hashes the elements of list 2 to create a linear time algorithm GAP 8/20/90
  ;; creates the union of two lists of conditions,
  ;; correctly handles negation and forall,
  ;; it also maintains order of first list
  ;; and effectively appends unique items in list1 onto end of list2. - JEL 7/14/88 

  `(let ((added-list NIL)
        (symbol nil))
      (nconc ,list2 
         (do* ((mylist ,list1 (cdr mylist))
               (element (car mylist) (car mylist)))
              ((null mylist) (nreverse added-list))
           (cond ((null element))        ;; Added by JEL 7/13/88 to fix {} chunking bug.
                 ((is-negation element)
                     (setq symbol element)
                     (setq mylist (cdr mylist))
                     (setq element (car mylist))
                     (cond ((not (gethash element ,hash-table2))
                             (push symbol added-list)
                             (push element added-list)
                             (setf (gethash element ,hash-table2) element) )
                           ))
                 ((not (gethash element ,hash-table2))
                       (push element added-list) 
                       (setf (gethash element ,hash-table2) element))
                 ) ) ) 
))

(defmacro union-with-negations (list2 list1) 

  ;; add to list2 all the elements in list1 that are not already in list2,
  ;; including negations, which have a special syntax: 
  ;;     (negation-symbol element) rather that (element).

  ;; performs modified union of 2 condition lists.
  ;; modifications for negated conditions and foralls.
  ;; called by:
  ;;  back-trace-conditions 
  ;;  back-trace-production-conditions.
  ;; Installed from JEL by BGM 7/14/88.
  ;; creates the union of two lists of conditions,
  ;; correctly handles negation and forall,
  ;; it also maintains order of first list
  ;; and effectively appends unique items in list1 onto end of list2. - JEL 7/14/88 

  `(let ((added-list NIL)
        (symbol nil))
      (nconc ,list2 
         (do* ((mylist ,list1 (cdr mylist))
               (element (car mylist) (car mylist)))
              ((null mylist) (nreverse added-list))
           (cond ((null element))        ;; Added by JEL 7/13/88 to fix {} chunking bug.
                 ((is-negation element)
                     (setq symbol element)
                     (setq mylist (cdr mylist))
                     (setq element (car mylist))
                     (cond ((not (member element ,list2 :test #'trace-action=))
                             (push symbol added-list)
                             (push element added-list))
                           ))
                 ((not (member element ,list2 :test #'trace-action=))
                       (push element added-list)))
            ) ) ) 
)

;;; BACKTRACING.


(defun back-trace-conditions (current-goal current-gnode conditions trace-flag)
 (declare (type gnode current-gnode))

 ;; Modified to handle instantiated nots. -BGM 17-Apr-91

 ;; using the production traces for the current goal, perform a dependency
 ;; analysis to determine the conditions of the chunk.
 ;; completely rewritten 8/18/90 GAP to fix bugs and make work faster.


  (prog (grounded-potentials rule-traces condition-ht nots new-nots)

   (if (null conditions)
       (return NIL))

;;
;; First put all the wmes in the first conditions hash table
;;

  (setq condition-ht *conditions-1-hash-table*)
  (dolist (wme conditions)
    (setf (gethash wme condition-ht) wme))

   (setf rule-traces (gnode-traces current-gnode))
   (if trace-flag 
      (progn
       (soar-format *trace-file*
                    " ~%Backtracing to determine conditions for goal: ~%")
       (ms-soar-princ t current-goal 'object) ;; Current-goal is known to be a valid object.
       (soar-format *trace-file*
                    " ~%Working-memory elements being traced: ")
       (spo-wmes-and-or-preferences conditions 1 0 nil t t)
       (soar-format *trace-file*
       	            " ~%Productions and conditions traced through:~%") ))

   (setq *previously-traced* nil)
   (setq *potential-conditions* nil)
   (setq *over-gen-chunk* nil)            
                                                 
 ;; backtrace ==>
   (multiple-value-setq (conditions condition-ht new-nots)
         (back-trace-production-conditions trace-flag 
                                           rule-traces
                                           conditions  ;intermediate wmes
                                           condition-ht
                                           *conditions-2-hash-table*))
   (setq nots (soar-set-union nots new-nots))
 ;; grounded potentials are wmes that are results of the subgoal 
 ;; but for which there was not a direct access path from
 ;; other results or superstructure.
      
 ;; handle potential conditions ==> 
 ;; handle-potentials appears to return the grounded-potentials
 ;; and to put the ungrounded-potentials in *potential-conditions*.
 ;; back-trace-production-conditions returns some conditions and puts
 ;; others in *potential-conditions*.
 ;; determine grounded and ungrounded-potentials.

    (setq grounded-potentials (handle-potentials conditions))
          
    (cond ((or grounded-potentials *potential-conditions*)
            ;; grounded potentials.
           (setq conditions (union-with-negations-hash conditions condition-ht
                                                       grounded-potentials))  
        ;; ungrounded potentials.
	   (if trace-flag
                (progn
                  (soar-format *trace-file* 
                               "~%Potentials that become conditions:~%")
                  (soarmapc #'(lambda (x)
                      	              (trace-new-condition x trace-flag 1))
                            grounded-potentials)
                  (soar-format *trace-file*
                               "~%Traceback through ungrounded potentials:~%")))

           (let* ((intermediate-wmes *potential-conditions*)
                  (intermediate-ht  (dolist (wme intermediate-wmes *conditions-3-hash-table*)
                                      (setf (gethash wme *conditions-3-hash-table*) wme)))
                  (new-conditions NIL)
                  (new-condition-ht *conditions-4-hash-table*)
		  (new-nots nil))
              (setq *potential-conditions* nil)

             ;; ==> backtrace through ungrounded potentials.

              (multiple-value-setq (new-conditions new-condition-ht new-nots)
                   (back-trace-production-conditions 
                                            trace-flag
                                            rule-traces
                                            intermediate-wmes
                                            intermediate-ht
                                            new-condition-ht))
             ;;
             ;; Clean up the new-condition-ht
             ;;
              (dolist (condition new-conditions)
                 (remhash condition new-condition-ht))
	      (setq nots (soar-set-union nots new-nots))
              (setq conditions (union-with-negations-hash conditions condition-ht new-conditions)) )))

   ;;
   ;; Clean up condition-ht
   ;;
     (dolist (condition conditions)
         (remhash condition condition-ht))

     (return (values conditions nots))
))


(defmacro remove-first (intermediate-wmes hash-table)
`(progn
   (remhash (first ,intermediate-wmes) ,hash-table)
   (pop ,intermediate-wmes))
)

(defun back-trace-production-conditions
       (trace-flag production-traces intermediate-wmes 
        intermediate-wmes-hash-table working-hash-table)
                                   
 ;;; Modified to handle instantiated nots. -BGM 17-Apr-91 

 ;;; when called (by back-trace-conditions), intermediate-wmes is the
 ;;; list of condition wmes for the instantiation being chunked;
 ;;; conditions, the list of ultimate conditions for the chunk, is NIL.
 ;;; subsequent recursive calls gradually reduce intermediate-wmes to NIL, and
 ;;; build up conditions to a complete list of the final conditions of
 ;;; the chunk. 
 ;;; Each iteration of the loop expands an entry of intermediate-wmes into
 ;;  the conditions of the production that created it. The results of
 ;;; that production are added to conditions, and the non-results are 
 ;;; added to intermediate-wmes; 
 ;;; the possible-results are added to *potential-conditions*, to be analysed
 ;;; later by handle-potential-conditions.            
 ;;; so intermediate-wmes expands and contracts until it is exhausted.

(let ((conditions NIL)
      (depth 1)
      (nots nil))

 (setq intermediate-wmes (append  intermediate-wmes (list 'mark)))

 (do* ((wme (remove-first intermediate-wmes intermediate-wmes-hash-table) 
            (remove-first intermediate-wmes intermediate-wmes-hash-table)))
      ((null intermediate-wmes) conditions)

  (cond ((eq wme 'mark)
           (setq intermediate-wmes (append  intermediate-wmes (list 'mark)))
           (setq depth (1+ depth)))

        ((eq wme '-) ;skip wme
            (remove-first intermediate-wmes intermediate-wmes-hash-table))
        (T
;; find trace of production that produced wme. 
;; a production-trace consists of:
;;     ONE action       
;;     trace-number
;;     data matched - results and (appended) negated-results
;;                    non-results
;;                    possible results
;;     production name
;; find-back-production returns the trace without the action. 

(let (( production-trace (find-back-production wme production-traces)))
;;
;; no trace; not created by production firing in current goal; skip wme.
;;
   (cond ((null production-trace))
    (T

#+(or)
      (format t "~% Back-trace-production-conditions ~
Wme ~A P ~A Results ~A Non-Results ~A Nots ~A."
  wme (production-trace-name production-trace) (production-trace-results production-trace)
      (production-trace-non-results production-trace) (rtrace-nots production-trace))

;;
;; Optimization to not trace productions again
;;  Later unions would catch this but catching it here is cheap
;;
  (cond ((soarmemq (production-trace-number production-trace) *previously-traced*))
    (T 
 (soarpush (production-trace-number production-trace) *previously-traced*) 
          
;; print trace.
;; print name of production being traced.
 (cond (trace-flag
        (soar-nspaces (* 3 depth) *trace-file*)
        (soar-format *trace-file* "<--")
        (ms-soar-princ *trace-file* (production-trace-name production-trace)
		       'pname)
        (soar-format *trace-file* "  ")
        (print-wme-and-timetag *trace-file* wme)
        (soar-format *trace-file* "~%")))

;; print those wme's that were results or pre-existing structure and
;; will be conditions.  

 (cond (trace-flag
  (soarmapc
   #'(lambda (x)
      (trace-new-condition x trace-flag depth))
   (nreverse (soar-set-difference 
                   (remove-negatives (production-trace-results production-trace))
                   conditions
                   :test
                    #'(lambda (action condition)
                     (cond ((not (or (eq action '-) (eq condition '-)))
                            (action= action condition))
                           (T
                            NIL)))) ) ) ))
               
  ;; backtracing.          
  (setq nots (append (rtrace-nots production-trace) nots))

  (setq conditions 
        (union-with-negations-hash conditions working-hash-table
                                   (production-trace-results production-trace)))


  (setq intermediate-wmes
        (union-with-negations-hash intermediate-wmes
                                   intermediate-wmes-hash-table
                                   (production-trace-non-results production-trace)))


  ;; Made change here -- TFMcG 21-Dec-89
  (setq *potential-conditions*
        (soar-set-union *potential-conditions*
                        (production-trace-possible-results production-trace)
                        :test #'trace-action=))

       )) ))) ))
    ) ;end of do

  ;; test results for over-generality. 
  ;; sets *over-gen-chunk*.
  (test-for-over-gen conditions)
  
 ;; return

    (values conditions working-hash-table nots)
))

(defun action= (cme1 cme2)
 (declare (type tme cme1 cme2))
                          
 ;; cme = condition memory element: ame or context acceptable pme.
 ;; back-trace-production-conditions
 ;;  trace-action=
 ;;   action=
 ;;  union-with-negations                        
 ;;   trace-action=
 ;;    action=
 ;; split-apart-conditions
 ;;   action=
 ;; action must be a pme.
            
 (if (eq cme1 cme2)  ;2 eq pmes.
     t
     (and            
       (tme-value= (wme-value cme1) (wme-value cme2))
       (eq (wme-object cme1) (wme-object cme2))
       (tme-attribute= (wme-attribute cme1) (wme-attribute cme2))
       (eq (wme-class cme1) (wme-class cme2))))
)                             



#+(or)
(defun action= (condition action)
   
 ;; back-trace-production-conditions
 ;;  trace-action=
 ;;   action=
 ;;  union-with-negations                        
 ;;   trace-action=
 ;;    action=
 ;; split-apart-conditions
 ;;   action=
 ;; action must be a pme.
 ;; condition may be an ame or a pme-wme (context accepts).

 (cond ((tme-type condition)
        ;; condition is a preference (acceptable).
        (eq condition action))
       (T
        ;; condition is an augmentation.
        (and 
             ;; action is an acceptable or a require preference. 
             (member (wme-type action) '(+ !) :test #'eq)
             ;; action is a preference for the condition augmentation.
             (tme-value= (wme-value action) (wme-value condition))
             (eq (wme-object action) (wme-object condition))
             (tme-attribute= (wme-attribute action) (wme-attribute condition))
             (eq (wme-class action) (wme-class condition)) ) ))
)                             

(defun trace-action= (condition action)
 ;; 7/9/90: Fixed so that printing of backtraces outdents properly. - Dirk Kalp
 ;; called by back-trace-production-conditions, union-with-negations.
 (cond ((or (eq condition 'mark) (eq action 'mark))
        NIL)
       ((eq condition '-)
        (eq action '-))
       ((eq action '-)
        NIL)
       (T 
        (action= condition action) ))
)

(defun test-for-over-gen (wmes)

 ;; sets *over-gen-chunk*, if results of firing meet test for over-generality. 
 ;; From JEL for the exhaustion hack, installed by Milnes, 7/3/88.
 ;; called by:
 ;;   back-trace-production-conditions

 (dolist (wme wmes NIL)
   (cond ((and (listp wme)
               (eq (first wme) 'this-is-a-hack))
          (setf *over-gen-chunk* t) 
          (return T) )) )   
)


(defun trace-new-condition (action trace-flag depth) 
 ;; Updated in 4.5.3/5.1.1 merge. -BGM 1-Mar-90
 ;; Updated old style make print to new print-make, cleaned on the way. -BGM 1/17/89
 ;; Updated old style IO to soar-format. -BGM 8/18/88

 ;; prints trace info.
 ;; called by:
 ;;   back-trace-conditions
 ;;   back-trace-production-conditions.

 (when trace-flag 
  (cond ((is-negation action)
	 (soar-nspaces (1- (+ 3 (* 3 depth))) *trace-file*)
	 (soar-format *trace-file* "~A" action))
	(t 
	  (soar-nspaces (+ 3 (* 3 depth)) *trace-file*)
	  (print-wme-and-timetag *trace-file* action)
	  (soar-format *trace-file* "~%"))))
)

(defun handle-potentials (conditions)                        

 ;; called by back-trace-conditions.

 ;; conditions is a list of already identified ultimate conditions
 ;; for the chunk.

 ;; *potential-conditions* is set by back-trace-production-conditions,
 ;; which is called by back-trace-conditions before it calls this function.

 ;; handle-potentials returns those of the *potential-conditions* that are
 ;; "grounded" and these are added to the ultimate conditions by
 ;; back-trace-conditions; it leaves only the "ungrounded" potentials in
 ;; *potential-conditions*, which are then backtraced through. 

 (prog (condition potential results id potential-conds)

  (setf results nil)

  (soarwhile (and (consp conditions) *potential-conditions*) 
 		;;	 Changed endtest to prevent infinite loops. -BGM 3/27/89
		 (setf condition (pop conditions))
	  (cond ((is-negation condition)
                 ;; can't there be more than one negation in a row?
	          (setf condition (pop conditions)) ))
          (setf id (wme-value condition))                    

	  (setq potential-conds *potential-conditions*)
   ;; rebuilds *potential-conditions* in loop below.
          (setq *potential-conditions* nil)

	  (soarwhile potential-conds
            (setf potential (pop potential-conds))
	    (cond ((eq id (wme-id potential))
		     (push potential results)
   		     (setf conditions	(append conditions	(list potential))))
   		  (t
                   (push potential *potential-conditions*)))))

 ;; grounded potentials are results.
 (return results)
))

(eval-when (compile eval load) (proclaim '(ftype (function (list) list) augment-variable-value-mappings)))
(defun augment-variable-value-mappings (objects) 
 (declare (list objects))                                            
 ;; updates variable-value mappings (*learn-ids*) for chunk being built.
 (do* ((remaining-objects objects (rest remaining-objects))
       (object (first remaining-objects) (first remaining-objects))
       (mappings *learn-ids*))  ;avoid repeated global access.
      ((null object) (setf *learn-ids* mappings))
  (declare (list remaining-objects mappings)
           (type tme-object object)) 
  (cond ((assoc object mappings :test #'eq))
        (T
         ;; new variable.                                    
         (push (cons object (soar-genvar object)) mappings) )) )
)

(eval-when (compile eval load) (proclaim '(ftype (function (list) list) condition-tmes-to-objects)))
(defun condition-tmes-to-objects (tmes) 
 (declare (list tmes))

 ;; tmes may include negations and conjunctive negations.
 ;; returns a list of the objects referenced by tmes.
 ;; called by handle-back-trace-actions.
 
 (do* ((remaining-tmes tmes (rest remaining-tmes))
       (tme (first remaining-tmes) (first remaining-tmes))
       (attribute NIL)
       (value NIL)
       (objects NIL))
      ((null tme) objects)
  (declare (list remaining-tmes objects)
           (type (or null symbol tme) tme)
           (type tme-attribute attribute) 
           (type tme-value value))
  (cond ((is-negation tme))         
         ;; skip negation symbols.
        ((listp (first tme))                                      
         ;; conjunctive negation.        
         (setf remaining-tmes
               (cons tme (append tme (rest remaining-tmes)))))
        (T
         (setf attribute (tme-attribute tme))
         (setf value (tme-value tme))
         (if (object-p (tme-object tme))
	     (pushnew (tme-object tme) objects :test #'eq))
         (if (object-p attribute)
             (pushnew attribute objects :test #'eq))
         (if (object-p value)
             (pushnew value objects :test #'eq)) )) )
)

(eval-when (compile eval load) (proclaim '(ftype (function (list) list) action-tmes-to-objects)))
(defun action-tmes-to-objects (tmes) 
 (declare (list tmes))

 ;; tmes do NOT include negations and conjunctive negations.
 ;; returns a list of the objects referenced by tmes.
 ;; called by handle-back-trace-actions.
 
 (do* ((remaining-tmes tmes (rest remaining-tmes))
       (tme (first remaining-tmes) (first remaining-tmes))
       (attribute NIL)
       (value NIL)
       (reference NIL)
       (objects NIL))
      ((null tme) objects)
  (declare (list remaining-tmes objects)
           (type (or null symbol tme) tme)
           (type tme-attribute attribute) 
           (type tme-value value reference))
  (setf attribute (tme-attribute tme))
  (setf value (tme-value tme))
  (setf reference (tme-reference tme))
  (if (object-p (tme-object tme))
      (pushnew (tme-object tme) objects :test #'eq))
  (if (object-p attribute)
      (pushnew attribute objects :test #'eq))
  (if (object-p value)
      (pushnew value objects :test #'eq))
  (if (and reference (object-p reference))
      (pushnew reference objects :test #'eq)) )
)



(defun start-conditions ()
 T
)

(defun restart-conditions ()
 (retask-conditions)
) 

(defun retask-conditions ()
 (setf *building-internal-chunk* NIL)
)





;;; Concatenated from type module "chunk5" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/chunk5/new/chunk5.lisp".
(in-package "SOAR")


;;; <CHUNK5.FUNS>

                                  

;;; CHUNK5 MODULE: BUILDING CHUNKS.


;;; VARIABLIZATION.

(defun clean-up-item (item c-or-a)

 ;; c-or-a is either 'condition or 'action.

 (prog (new-item element)
    (setq new-item item)
    (cond ((setq element (assoc new-item *learn-ids* :test #'eq))    
           ;; look up id's variable.
             (setq new-item (cdr element))
             (cond ((eq c-or-a 'condition)
                  ;; keep track of how many times variables are tested. 
                     (soarputprop new-item (1+ (or (get new-item 'tested) 0)) 'tested) )) )
           ((object-p new-item)
             (setq element (cons new-item (soar-genvar new-item)))
             (push element *learn-ids*)
             (setq new-item (cdr element))
             (cond ((eq c-or-a 'condition)
                  ;; keep track of how many times variables are tested. 
                     (soarputprop new-item (1+ (or (get new-item 'tested) 0)) 'tested) )) )
	   )
  (return new-item)
))

(defun clean-up-clause (condition c-or-a)
                                            
 ;; variablizes clause.
 ;; c-or-a is either 'condition or 'action.

 (prog (new-condition item)

  (cond ((is-negation condition)
                    (return condition))
        ((soarlistp (car condition))
         ;; conjunctive negation.
                    (return
                       (soarmapcar
                          #'(lambda (x)
                               (clean-up-clause x c-or-a))
                               condition)) ))

  ;; variablize clause.
  (setq new-condition (list (pop condition))) ;; class test
  (soarwhile (consp condition) ;Changed endtest to prevent infinite loops. -BGM 3/27/89
    (setq item (pop condition))
    (if (and item (listp item))
      (let ((complex-item NIL)
            (inner-items item)
            (new-item (car item)))
        (loop
	 (push (clean-up-item new-item c-or-a) complex-item)
         (setq inner-items (cdr inner-items))
         (setq new-item (car inner-items))
         (unless inner-items (return))
        )
        (soarpush (nreverse complex-item) new-condition)
      )
    ;; Else
      (soarpush (clean-up-item item c-or-a) new-condition)
    )
  )

  (return (reverse new-condition)) 
))

(defun clean-up-action (action)
 (cons 'make-preference (clean-up-clause action 'action))
)

(defun process-negations (conditions) 
 (prog (return-conditions negations foralls)

  (setq negations nil)
  (setq foralls nil)
  
  ;; sort negations and foralls out of condition list.
  (soarwhile (consp conditions); Changed endtest to prevent infinite loops. -BGM 3/27/89
   (cond ((eq (car conditions) '-)
           (pop conditions)
           (soarpush (pop conditions) negations))
         ((eq (car conditions) '*)
           (pop conditions)
           (soarpush (pop conditions) foralls))
         (t
            (soarpush (pop conditions) return-conditions) )) )
                                                      
  ;; tersify negations and foralls. 
  ;; returns list whose car is the conditions that are neither negations or foralls
  ;; and whose cdr is the variablized, tersified negations and foralls.
  (return
   (cons (nreverse return-conditions)
                           (append (nreverse (tersify-negations negations       '-))
                                           (nreverse (tersify-negations foralls '*)))))
))

(defun variablize-negations (negations) 
 ;; called by process-negations.
 (prog (condition return-list new-condition id value)
  (setq return-list nil)
  (soarwhile (consp negations) ;Changed endtest to prevent infinite loops. -BGM 3/27/89
    (setq condition (pop negations))
    (cond ((soarlistp (car condition))
           ;; conjunctive negation.
     	     (setq return-list (cons (variablize-negations condition) return-list)))
	         (t                       
           ;; simple negation.
           (setq new-condition (list (pop condition)))
   	       (soarwhile (consp condition) ;Changed endtest to prevent infinite loops. -BGM 3/27/89
             (setq id (pop condition))
		        	  (setq value (cdr (assoc id *learn-ids* :test #'eq)))
		        	  (cond (value
                    ;; keep track of how many times variables are tested. 
                    (soarputprop value (1+ (or (get value 'tested) 0)) 'tested))
	               			(t
                    (setq value id)))
		        	  (soarpush value new-condition))
	            (setq new-condition (nreverse new-condition))
	            (cond ((not (soarmember new-condition return-list))
		                  (soarpush new-condition return-list) )) )) )
 (return (reverse return-list))
))

(defun tersify-negations (negations symbol) 
 (prog (condition return-list)
  (setq return-list nil)
  (soarwhile (consp negations) ;Changed endtest to prevent infinite loops. -BGM 3/27/89
    (setq condition (pop negations))
	 		(cond ((and (not (soarlistp (car condition)))
		        		    (eqp (get (wme-id condition) 'tested) 1))
           ;; if this is not a conjunctive negation and
           ;; the id variable is tested only once, it is unbound.
			        (setf-wme-id condition '<unbound>) ))
 			(cond ((not (soarmember condition return-list))
	 		       (soarpush symbol return-list)
		 	       (soarpush condition return-list) )) )
  (return return-list)
))

(defun find-constant-ids (action-list) 
 (declare (list action-list))
                                 
 ;; rewrote and changed test from variablep-not-predicate to variablep. -KAM 10/5/89
 ;; called by:
 ;;  handle-back-trace-actions.
 ;;  (used to be called by build-copies).

 (let ((action-ids NIL)
       (id NIL))
  (declare (list action-ids)
           (type tme-object id))

  (dolist (action action-list action-ids)
   (declare (type tme action))
   (setf id (tme-object (rest action)))
   (if (and (not (assoc id action-ids :test #'eq))
            (not (variablep id)))
       (push (cons id (soar-genvar id)) action-ids)) )
)) 

(defun rebind-action-ids (action-list copy-list) 

 ;; called by:
 ;;  handle-back-trace-actions.
 ;;  (used to be called by build-copies).
 ;; copy-list is a list of variablized constant ids.

 (prog (element new-element return-list val val2)

  (setq return-list nil)

  l1
   (and (null action-list)
    		  (return return-list))
   (setq element (pop action-list))
   (setq new-element nil)

   l2
    (and (null element)
     		  (go l3))
    (setq val2 (pop element))
    (setq val (cdr (soarassq val2 copy-list)))
    (or val
        (setq val val2))
    (soarpush val new-element)
	  (go l2)

	  l3
	   (soarpush (nreverse new-element) return-list)

  (go l1)
))

                   

;;; BUILDING.

(defun build-variablized-chunk (condition-list action-list lhs-wmes rhs-wmes nots)

 ;; Modified from Soar4 function build-a-production.

 ;; knotify and reorder conditions.
 (setf *unbound* nil)  ;set during execution of knotify-conditions (by knotify).

 (let ((*warning* (not (building-internal-chunk-p))))

 ;; name chunk.
 (do ((pname (soar-genpname #\P) (soar-genpname #\P)))
     ((not (member pname *pnames*)) (setf *p-name* pname)))

  ;; reorder warnings are suppressed for internal chunks.
  (setf condition-list (nreverse
                        (not-ify-conditions 
                                        (prog2 (block ()
                                            #+:soar-times (stop-soar-time chunk)
                                            #+:soar-times (start-soar-time reorder) )
                          (re-order-conditions condition-list)
                                         #+:soar-times (stop-soar-time reorder)
                                         #+:soar-times (start-soar-time chunk) )
					nots )))

  ;; must reorder again.
  (cond (*unbound*                                       
         (setf condition-list 
                           (prog2 (block ()
                               #+:soar-times (stop-soar-time chunk)
                               #+:soar-times (start-soar-time reorder) )
                            (re-order-conditions condition-list)
                      #+:soar-times (stop-soar-time reorder)
                         #+:soar-times (start-soar-time chunk) )) )) )

 (cond ((building-internal-chunk-p)
        (build-semi-constant-internal-chunk condition-list
                                            action-list
                                            lhs-wmes
                                            rhs-wmes))
       (T
        (build-external-chunk condition-list
                              action-list
                              lhs-wmes
                              rhs-wmes) ))
)



(defun build-external-chunk (conditions actions lhs-wmes rhs-wmes)
 ;; Removed references to production type 3/30/90 GAP
 ;; These patches are in reference to BUG 01Mar90-12.56.58
 ;; CHanged to reverse the rhs returned by test-connected-actions
 ;; THese patches are in reference to BUG 08Mar90-10.25.32
 (declare (list conditions actions lhs-wmes rhs-wmes))

 ;; external chunks are fully variablized.
                                                           
 (let ((chunk NIL)
       (duplicate-chunk-name NIL))
  (declare (symbol duplicate-chunk-name)
           (list chunk))

   ;; make chunk text.
   (setf chunk (list (list 'quote *p-name*)    
                (list 'quote (nconc (nconc conditions (list '-->))
                       (nreverse (test-connected-actions actions))))));GAP
                                              
    ;; duplicate chunk?
    (setf duplicate-chunk-name (duplicate-chunk-p chunk *new-chunks*))
    (cond (duplicate-chunk-name               
           ;; don't build chunk, but assign its seed to its duplicate.
              (cond (*print-learn* 
                  (soar-format *trace-file* "~%Duplicate chunk") ))
           (put-chunk-seed duplicate-chunk-name lhs-wmes rhs-wmes) )
                (T
              (push *p-name* *chunks*)
              (push chunk *new-chunks*)
           #+(or)
           (put-p-declaration *p-name* (p-class (firing-p)))
           (put-chunk-seed *p-name* lhs-wmes rhs-wmes) )) )
)  


(defun build-constant-internal-chunk (lhs-wmes rhs-wmes)
 ;; Removed references to production type 3/30/90 GAP
 ;; These patches are in reference to BUG 01Mar90-12.56.58
 ;; Changed to give O-support to chunks that don't fire but would have 
 ;;   given o-support bug #05Sep90-13.02.05 GAP 28-Nov.90
 (declare (list lhs-wmes rhs-wmes))
                     
 ;; internal chunks that do not have conjunctive-negations with variables
 ;; unconnected outside them can be left unvariablized.
 ;; such chunks are "constant" chunks.

 (if (internal-chunk-matchable-p lhs-wmes)
     (let ((chunk NIL)
           (actions NIL)) 
      (declare (list chunk actions))

       ;; make chunk name.
       (do ((pname (soar-genpname #\P) (soar-genpname #\P)))
            ((not (member pname *pnames*)) (setf *p-name* pname)))
  
       ;; reorder conditions.
       (let ((*warning* NIL))  ;suppress warning messages
        (setf lhs-wmes (re-order-conditions lhs-wmes)) )

       ;; clean up actions.
       (setf actions
             (mapcar 
              #'(lambda (action)
                 (cons 'make-preference action))
              rhs-wmes))
                      
       ;; make chunk text.
       (setf chunk (list (list 'quote *p-name*)    
                       (list 'quote (append (append lhs-wmes (list '-->))
                                 actions)))) 

       ;; no need to check for duplicates to a constant chunk.

       (push *p-name* *chunks*)
       (push chunk *new-chunks*)
       (log-internal-chunk *p-name*)                     
       (put-chunk-seed *p-name* lhs-wmes rhs-wmes) )

   ;; Else the chunk won't fire
   ;;  remove nots and create the production. Then classify it. Then
   ;;  put in the appropriate support.

     (let* ((firing-goal (lhs-goal lhs-wmes))
            (support-list (classify-chunk-seed (remove-lhs-negations lhs-wmes)
                                              rhs-wmes
                                              firing-goal)) )
      (declare (list support-list))
      (setq *firing-goal* firing-goal)
      (do* ((o-support-list support-list (cdr o-support-list))
            (preference-list rhs-wmes (cdr preference-list))
            (o-support (car o-support-list) (car o-support-list))
            (preference (car preference-list) (car preference-list)))
           ((null preference))
              (when o-support
                    (give-o-support preference o-support) )
       ) ;; end of do
      ) ;; end of let for Else
    )
)       

(defun build-semi-constant-internal-chunk (conditions actions lhs-wmes rhs-wmes)
 ;; Removed references to production type 3/30/90 GAP
 ;; These patches are in reference to BUG 01Mar90-12.56.58
 ;; Changed to give O-support to chunks that don't fire but would have 
 ;;   given o-support bug #05Sep90-13.02.05 GAP 28-Nov.90
 (declare (list conditions actions lhs-wmes rhs-wmes))
                     
 ;; chunk has a conjunctive negation (CN) that has ids not connected outside the CN.
 ;; such CNs must be variablized. 
 ;; such chunks are called "semi-constant" chunks.

 ;; BUT for now, just building an ordinary (fully variablized) chunk.
 ;; so this function is almost the same as build-external-chunk.
                                                                       
 (if (internal-chunk-matchable-p lhs-wmes)
     (let ((chunk NIL)
           (duplicate-chunk-name NIL))
      (declare (symbol duplicate-chunk-name)
               (list chunk))

       ;; make chunk text.
       (setf chunk (list (list 'quote *p-name*)    
                         (list 'quote (nconc (nconc conditions (list '-->))
					     (reverse (test-connected-actions actions))))))
                                              
        ;; duplicate chunk?
        (setf duplicate-chunk-name (duplicate-chunk-p chunk *new-chunks*))
        (cond (duplicate-chunk-name               
               ;; don't build chunk, but assign its seed to its duplicate.
               (put-chunk-seed duplicate-chunk-name lhs-wmes rhs-wmes) )
                    (T
                  (push *p-name* *chunks*)
                  (push chunk *new-chunks*)
               #+(or)
               (put-p-declaration *p-name* (p-class (firing-p)))
               (log-internal-chunk *p-name*)
               (put-chunk-seed *p-name* lhs-wmes rhs-wmes) )) ) 

   ;; Else the chunk won't fire
   ;;  remove nots and create the production. Then classify it. Then
   ;;  put in the appropriate support.

     (let* ((firing-goal (lhs-goal lhs-wmes))
            (support-list (classify-chunk-seed (remove-lhs-negations lhs-wmes)
                                              rhs-wmes
                                              firing-goal)) )
      (declare (list support-list))
      (setq *firing-goal* firing-goal)
      (do* ((o-support-list support-list (cdr o-support-list))
            (preference-list rhs-wmes (cdr preference-list))
            (o-support (car o-support-list) (car o-support-list))
            (preference (car preference-list) (car preference-list)))
           ((null preference))
              (when o-support
                    (give-o-support preference o-support) )
       ) ;; end of do
      ) ;; end of let for Else
    )
)

(eval-when (compile eval load) (proclaim '(ftype (function (list) logical) internal-chunk-matchable-p)))
(defun internal-chunk-matchable-p (lhs)
 (declare (list lhs))

  ;; checks that constant chunk's positive conditions still exist.
  ;; they may not, if backtraced through an o-supported pme,
  ;; which could outlive its predecessors.
                     
  (do ((wmes lhs))
      ((null wmes) T)
   (declare (list wmes))
   (cond ((wme-negation-p (first wmes))
          ;; skip negated wme.
          (pop wmes)
          (pop wmes))
         (T                      
          ;; if object does not exist, the LHS will never match.
          ;; could check for tme itself, but this seems good enough.
          (if (not (object-onode (tme-object (pop wmes))))
              (return NIL)) )) )
)                               

             
;;; KNOTIFICATION.
;;; Deleted old knotify routines. See chunk5/not-ify.lisp.


;;; UTILITIES.

(defun flattop (l) 
 ;; Turn a list-of-lists into a list (one level shallower). 
 ;; called by:
 ;;  remove-subgoal-objects (not chunk but also not DSM?)
 ;;  split-apart-conditions  
 (cond ((null l)
            l)
          (t
        (append (car l)   (flattop (cdr l))) ))
)



(defun start-chunk5 ()
 (setf *building-internal-chunk* NIL)
 T
)


(defun restart-chunk5 ()
 (setf *building-internal-chunk* NIL)
 T
)


(defun retask-chunk5 ()
 (setf *building-internal-chunk* NIL)
 (setf *conditions-1-hash-table* (clrhash *conditions-1-hash-table*))
 (setf *conditions-2-hash-table* (clrhash *conditions-2-hash-table*))
 (setf *conditions-3-hash-table* (clrhash *conditions-3-hash-table*))
 (setf *conditions-4-hash-table* (clrhash *conditions-4-hash-table*))
)
         






;;; Concatenated from type module "chunk5" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/chunk5/new/not-ify.lisp".
;;; -*-mode: lisp; package: user -*-
;;
;; This file implements the new not-ify. In this not-ify, only 
;; the nots actually tested in the justifications are used to constrain
;; the chunks. -BGM 29-Nov-90
;;

(in-package "SOAR")

(defun instantiate-nots (nots instantiation)
  ;; Updated to fix not-ify bugs. -BGM 20-May-91.
  ;; This routine takes a list of the <> tests (each a pair of offsets into the token)
  ;; and returns the equivalent table of pairs of identifiers of the tokens that
  ;; were actually constrained to be different. 
  ;; This information is stored in the RTrace and then used while building the chunk.
  ;; -BGM 29-Nov-90
 (let ((token (instantiation-lhs instantiation))
       (notted-variables nil))
   (dolist (not nots)
     (let ((v1 (gelm token (car not))))
       (when (object-p v1)
         (let ((v2 (gelm token (cdr not))))
           (when (object-p v2)
              (push (if (string< v1 v2) (cons v1 v2) (cons v2 v1))  notted-variables))))))
     notted-variables))

;; Notify conditions takes a list of conditions, and a list of pairs of variables
;; that it should constrain to be not equal. It walks the conditions remember
;; which variables are bound. When the last variable of a not test's variables are bound,
;; it adds a <> test at that spot. This is all built using lists, so it could be
;; rebuilt for efficiency using hash tables.
;; As the nots are built up during backtracing, the conditions that the identifiers
;; are tested in may be backtraced through. This leaves old identifiers around that
;; may never be variablized. However, I think that we need them in case two other
;; conditions match them, we still want to constrain that they are unequal. -BGM 17-Apr-91

(defun not-ify-conditions (conditions nots)
  ;; The output of this must place each conjunction in a list. -BGM 20-May-91
  ;; Delete any duplicate entries here. -BGM 20-May-91
  ;; Make it handle conjunctive negations -GAP 20-Jun-91
  (setq nots (delete-duplicates nots :test #'equal))
  (let ((newconditions nil)
        (condition-stack nil)
        (bound nil))
    (do-lhs (ce conditions :negated negated 
                           :before-conjunction (progn (when negated (push '- newconditions))
                                                      (push newconditions condition-stack)
                                                      (setq newconditions NIL) )
                           :after-conjunction  (progn (setq newconditions
                                                            (nconc (list newconditions)
                                                                   (pop condition-stack)))) )
      (when negated (push '- newconditions))
      ;; As these conditions are coming from chunking, the tests are all simple,
      ;; so I can just walk through them with a dolist.
      (let ((newce nil))
        (dolist (test ce)
           (when (variablep test) (pushnew test bound))
           (let ((installed-nots nil)
                 (not-tests nil))
             (dolist (v1.v2 nots)
              (let ((v1 (car v1.v2))
                    (v2 (cdr v1.v2)))
                (cond ((and (eq v1 test) (member v2 bound))
                       (setq not-tests (append `(<> ,v2) not-tests))
                       (push v1.v2 installed-nots))
                      ((and (eq v2 test) (member v1 bound))
                       (setq not-tests (append `(<> ,v1) not-tests))
                       (push v1.v2 installed-nots)))))
             (cond (not-tests 
                    (setq nots (soar-set-difference nots installed-nots))
                    (setq newce (cons `({ ,@not-tests ,test }) newce)))
                   (t (push test newce)))))
        (push (nreverse newce) newconditions)))
    newconditions))

(defun remove-negatives (conditions)
   (let ((ret-val NIL))
     (do* ((conds conditions (cdr conds))
           (cond (car conds) (car conds)))
          ((null cond) (nreverse ret-val))
       (if (eq cond '-)
           (pop conds)
       ;;else
           (push cond ret-val)
       )
     )
   )
)

#|
(defun not-ify-conditions (conditions nots)
  (let ((new (not-ify-conditions1 conditions nots)))
    (cond ((equal conditions new)
	   (format t "~% Notify identical."))
	  (t (format t "~% Notify new difference.")
	     (pprint new))))
  (knotify-conditions conditions))
|#

;;; Concatenated from type module "symbols" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/symbols/new/symbols.lisp".
(in-package "SOAR")



;;; <SYMBOLS.FUNCTIONS>  


;;; SYMBOLS MODULE: FUNCTIONS.



;;; OBJECT SYMBOL GENERATION.
;;; Object symbols (other than goal and impasse) are created:
;;;   by RHS make-preference - make-object-symbol
;;;   by soario -              make-io-object-symbol

(eval-when (compile eval load) (proclaim '(ftype (function (&optional character) symbol) make-object-symbol)))
(defun make-object-symbol (&optional (prefix #\O))
 (declare (character prefix))
 ;; usually used during RHS instantiation.
 (let ((symbol (soar-genid prefix)))
  (declare (symbol symbol))
  (clear-object-properties symbol)
  (log-object-symbol symbol) 
  symbol          
))

(eval-when (compile eval load) (proclaim '(ftype (function (symbol &optional symbol) symbol) log-object-symbol)))
(defun log-object-symbol (symbol &optional (owner (firing-goal)))                     
 (declare (symbol symbol owner))
 (subtext-add-object symbol owner 'object) 
 (setf (get symbol 'object-p) T)
 symbol
)                 

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) release-object-symbol)))
(defun release-object-symbol (symbol)
 (declare (symbol symbol))
 ;; should tell soar-genid.
 (clear-object-properties symbol)
 (setf *wmpart-list* (delete symbol *wmpart-list* :test #'eq))
 symbol
)



;;; NEGATION OBJECT SYMBOL GENERATION.
;;;  Object symbols generated during chunking for variables that
;;;  do not appear elsewhere in the LHS.

(eval-when (compile eval load) (proclaim '(ftype (function (character symbol) symbol) make-negated-object-symbol)))
(defun make-negated-object-symbol (prefix owner)
 (declare (character prefix)
          (symbol owner))
 ;; usually used during RHS instantiation.
 ;; negated object symbols are treated separately so that their
 ;; onodes are garbage-collected. 
 (let ((symbol (soar-genid prefix)))
  (declare (symbol symbol))
  (clear-object-properties symbol)
  (log-negated-object-symbol symbol owner)
  symbol          
))

(eval-when (compile eval load) (proclaim '(ftype (function (symbol symbol) symbol) log-negated-object-symbol)))
(defun log-negated-object-symbol (symbol owner)
 (declare (symbol symbol owner))
 (subtext-add-object symbol owner 'object) 
 (push symbol *negated-objects*)
 (setf (get symbol 'object-p) T)
 symbol
)                 

(eval-when (compile eval load) (proclaim '(ftype (function () null) release-negated-object-symbols)))
(defun release-negated-object-symbols ()
 ;; should tell soar-genid.
 (dolist (object *negated-objects*)
  (declare (type tme-object object))
  (subtext-remove-negated-object object)
  (clear-object-properties object)
  (setf *wmpart-list* (delete object *wmpart-list* :test #'eq)))
 (setf *negated-objects* NIL) 
 nil
)


;;; SOAR/IO OBJECT SYMBOL GENERATION.

(eval-when (compile eval load) (proclaim '(ftype (function (&optional character) symbol) make-io-object-symbol)))
(defun make-io-object-symbol (&optional (prefix #\I))
 (declare (character prefix))
 (let ((symbol (soar-genid prefix)))
  (declare (symbol symbol))
  (clear-object-properties symbol)
  (log-io-object-symbol symbol) 
  symbol          
))

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) log-io-object-symbol)))
(defun log-io-object-symbol (symbol)                     
 (declare (symbol symbol))
 (subtext-add-object symbol (top-goal) 'io-object) 
 (setf (get symbol 'object-p) T)
 symbol
)                 

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) release-io-object-symbol)))
(defun release-io-object-symbol (symbol)
 (declare (symbol symbol))
 ;; should tell soar-genid.
 (clear-object-properties symbol)
 (setf *wmpart-list* (delete symbol *wmpart-list* :test #'eq))
 symbol
)



;;; CONSTANT SYMBOL GENERATION.

(eval-when (compile eval load) (proclaim '(ftype (function (&optional character) symbol) make-constant-symbol)))
(defun make-constant-symbol (&optional (prefix #\O))
 (declare (character prefix))
 ;; constant symbols are created:
 ;;  by lisp reader - not classified here
 ;;  by RHS bind function
 (let ((symbol (soar-genid prefix)))
  (declare (symbol symbol))
  (clear-object-properties symbol)
  (log-constant-symbol symbol)
  symbol                         
))

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) log-constant-symbol)))
(defun log-constant-symbol (symbol)                     
 (declare (symbol symbol))
 (setf (get symbol 'object-p) NIL)
 symbol
)                 

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) release-constant-symbol)))
(defun release-constant-symbol (symbol)
 (declare (symbol symbol))
 ;; should tell soar-genid.
 symbol
)
                    

;;; GOAL SYMBOL GENERATION.

(eval-when (compile eval load) (proclaim '(ftype (function () symbol) make-goal-symbol)))
(defun make-goal-symbol ()
 ;; the top goal symbol may be created by the matcher;
 ;; all others are created by context.
 ;; subtext is informed directly by context of goal creations and removals.
 (let ((symbol (soar-genid #\G)))         
  (declare (symbol symbol))
  (clear-object-properties symbol)
  (log-goal-symbol symbol) 
  symbol
))

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) log-goal-symbol)))
(defun log-goal-symbol (symbol)                       
 (declare (symbol symbol))
 (setf (get symbol 'object-p) T)
 symbol
)

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) release-goal-symbol)))
(defun release-goal-symbol (symbol)
 (declare (symbol symbol))
 ;; should tell soar-genid.
 (clear-object-properties symbol)
 (setf *wmpart-list* (delete symbol *wmpart-list* :test #'eq))
 symbol
)
                    

;;; IMPASSE SYMBOL GENERATION.

(eval-when (compile eval load) (proclaim '(ftype (function () symbol) make-impasse-symbol)))
(defun make-impasse-symbol ()
 ;; impasse symbols are created by the subtext module.
 (let ((symbol (soar-genid #\I)))                  
  (declare (symbol symbol))
  (clear-object-properties symbol)
  (log-impasse-symbol symbol)
  symbol
))

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) log-impasse-symbol)))
(defun log-impasse-symbol (symbol)             
 (declare (symbol symbol))
 (setf (get symbol 'object-p) T)
 symbol
)

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) release-impasse-symbol)))
(defun release-impasse-symbol (symbol)                   
 (declare (symbol symbol))
 ;; should tell soar-genid.
 (clear-object-properties symbol)
 (setf *wmpart-list* (delete symbol *wmpart-list* :test #'eq))
 symbol
)

                  
;;; SYMBOL CLASSIFICATION.

(eval-when (compile eval load) (proclaim '(ftype (function (list) (or list atom)) declare-objects)))
(defun declare-objects (symbols)                            
 (declare (list symbols))
 (cond ((null symbols)
        T)
       ((atom symbols)
        (declare-object symbols))
       (T
        (mapc #'declare-object symbols) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) declare-object)))
(defun declare-object (symbol)                     
 (declare (symbol symbol))
 ;; top goal is not installed until cycling begins.
 ;; symbol-owner sets owner to top goal on first call for object.
 (clear-object-properties symbol)
 (setf (get symbol 'object-p) T)
 (subtext-add-object symbol (top-goal) 'declared-object)
 (pushnew symbol *declared-objects* :test #'eq)
)                                          

(eval-when (compile eval load) (proclaim '(ftype (function (atom) (or list atom)) non-gensymed-object-p)))
(defun non-gensymed-object-p (atom)                            
 (declare (atom atom))        
 ;; could also see if symbol in *declared-objects*.
 (and (object-p atom) (not (gensymed-p atom)))
)                                                                  

(eval-when (compile eval load) (proclaim '(ftype (function (list) (or list atom)) declare-constants)))
(defun declare-constants (symbols)                            
 (declare (list symbols))
 (cond ((null symbols)
        T)
       ((atom symbols)
        (declare-constant symbols))
       (T
        (mapc #'declare-constant symbols) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) declare-constant)))
(defun declare-constant (symbol)                     
 (declare (symbol symbol))
 (clear-object-properties symbol)
 (setf (get symbol 'object-p) NIL)
 (pushnew symbol *declared-constants* :test #'eq)
)                                                                  

(eval-when (compile eval load) (proclaim '(ftype (function (atom) (or list atom)) gensymed-constant-p)))
(defun gensymed-constant-p (atom)                            
 (declare (atom atom))
 ;; could also see if symbol is in *declared-constants*.
 (and (constant-p atom) (gensymed-p atom))
)                                                                  



;;; SYMBOL CLASSIFICATION UTILITIES.

(eval-when (compile eval load) (proclaim '(ftype (function (atom) symbol) object-symbol-owner)))
(defun object-symbol-owner (thing)            
 (declare (atom thing))

 ;; returns object symbol's owner, that is,
 ;; the goal "during" which the symbol was created.
 ;; if no owner, and symbol has been declared as a non-gensymed
 ;; object symbol, returns top goal.
 ;; if no owner, and symbol has NOT been declared as a non-gensymed 
 ;; object symbol, returns NIL.

 (cond ((null thing))
       ((not (symbolp thing)))
       ((object-owner thing))
       ((non-gensymed-object-p thing)
        ;; there may not be a top goal when declare-objects is executed.
        (put-object-owner thing (top-goal)))
       (T
        NIL))
)        

(eval-when (compile eval load) (proclaim '(ftype (function (symbol) symbol) conjure-object-symbol-owner)))
(defun conjure-object-symbol-owner (symbol)

 ;; like symbol-owner, except:
 ;;   if no owner, and symbol has NOT been declared as a non-gensymed 
 ;;   object symbol, declares symbol as a non-gensymed object symbol,
 ;;   and returns the top goal.

 (declare (symbol symbol))                         
 (cond ((object-owner symbol))
       ((non-gensymed-object-p symbol)
        ;; there may not be a top goal when declare-objects is executed.
        (put-object-owner symbol (top-goal)))
       (T 
        ;; assume symbol should have been declared with declare-objects.
        ;; this will set owner to and return top-goal.
        (declare-object symbol) ))
)                              


            
;;; UTILITIES.

(eval-when (compile eval load) (proclaim '(ftype (function (tme-object) true) clear-object-properties)))
(defun clear-object-properties (object)
 (declare (type tme-object object))
 ;; object-p property is not cleared because the object may be
 ;; backtraced through after it has been removed.
 (cond ((null (get object 'wmpart*)))     
        ;; this is the only other object property at present,
        ;; so there is nothing to do.
       (T 
        (soar-format *trace-file*
                     "~%~
                      ****************************************************************~
                      ~%INTERNAL DSM ERROR:~
                      ~%Attempt to flush the properties of object ~A while it still~
                      ~%has augmentations.~
                      ~%Wmpart* Property:~
                      ~%~A~
                      ~%Halting.~
                      ~%Symbols Module: Clearprops-if-no-wmes.~
                      ~%~
                      ****************************************************************~
                      ~%"
                      object
                      (get object 'wmpart*))
        (signal-halt) ))
 T
)

(eval-when (compile eval load) (proclaim '(ftype (function () true) start-symbols)))                        
(defun start-symbols ()
 ;; system startup.
 T
)

(eval-when (compile eval load) (proclaim '(ftype (function () true) restart-symbols)))                        
(defun restart-symbols ()               
 ;; system restart.
 (mapc #'clear-object-properties *declared-objects*)
 (mapc #'clear-object-properties *declared-constants*)
 (setf *declared-objects* NIL)
 (setf *declared-constants* NIL)
 (setf *negated-objects* NIL)
 T
)                  

(eval-when (compile eval load) (proclaim '(ftype (function () true) retask-symbols)))                        
(defun retask-symbols ()
 ;; task restart.
 (declare-objects *declared-objects*)
 (declare-constants *declared-constants*)
 (setf *negated-objects* NIL)
 T
)





;;; Concatenated from type module "slots" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/slots/new/slots.lisp".
(in-package "SOAR")



;;; <SLOTS.FUNCTIONS>




;;; SLOTS MODULE: FUNCTIONS.


;;; MODULE FUNCTIONS.   


;;; SLOT CLASSIFICATION.

(eval-when (compile eval load) (proclaim '(ftype (function  (tme-object tme-attribute) logical) space-slot-p)))
(defun space-slot-p (object attribute)
 (declare (type tme-object object)
          (type tme-attribute attribute))
 (and (eq attribute 'problem-space) (goal-p object))
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme-object tme-attribute) logical) state-slot-p)))
(defun state-slot-p (object attribute)
 (declare (type tme-object object)
          (type tme-attribute attribute))
 (and (eq attribute 'state) (goal-p object))
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme-object tme-attribute) logical) operator-slot-p)))
(defun operator-slot-p (object attribute)
 (declare (type tme-object object)
          (type tme-attribute attribute))
 (and (eq attribute 'operator) (goal-p object))
)



;;; SLOT INQUIRY.

(eval-when (compile eval load) (proclaim '(ftype (function (tme-object tme-attribute logical logical) list) slot-preferences)))
(defun slot-preferences (object attribute return-p print-p)
 (declare (type tme-object object)
          (type tme-attribute attribute)
          (type logical return-p)
          (type logical print-p))
 (setq preferences-result nil)
 (cond ((context-slot-p object attribute)
        (context-preferences-report object attribute print-p))
       (T
        (subtext-preferences-report object attribute print-p) ))
 (if return-p 
     preferences-result
     t))

;;; PREFERENCE REMOVAL.

(eval-when (compile eval load) (proclaim '(ftype (function (tme) true) remove-preference)))
(defun remove-preference (tme)
 ;; will remove a preference even if multiply-supported.
 (declare (type tme tme))
 (cond ((context-slot-p (tme-object tme) (tme-attribute tme))
        (context-remove-preference tme))
       (T
        (subtext-remove-preference tme) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function
                    (tme-object tme-attribute &optional tme-value) true) remove-preferences)))
(defun remove-preferences (object attribute &optional (value NIL value-p))
 ;; will remove a preference even if multiply-supported.
 ;; must distinguish NIL value from no value.
 (declare (type tme-object object)
          (type tme-attribute attribute)
          (type tme-value value))
 (cond ((context-slot-p object attribute)
        (cond (value-p
               (context-remove-preferences-value object attribute value))
              (T
               (context-remove-preferences-slot object attribute) )) )
       (T
        (cond (value-p
               (subtext-remove-preferences-value object attribute value))
              (T
               (subtext-remove-preferences-slot object attribute) )) ))
)            



;;; UTILITIES.

(eval-when (compile eval load) (proclaim '(ftype (function () true) start-slots)))
(defun start-slots ()
 ;; system startup.
 T
)

(eval-when (compile eval load) (proclaim '(ftype (function () true) restart-slots)))
(defun restart-slots ()
 ;; system restart.
 T
)

(eval-when (compile eval load) (proclaim '(ftype (function () true) retask-slots)))
(defun retask-slots ()
 ;; task restart.
 T
)


 








;;; Concatenated from type module "preferences" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/preferences/new/preferences.lisp".

(in-package "SOAR")



;;; <PREFERENCES.FUNCTIONS>


;;; PREFERENCES MODULE: FUNCTIONS.
 


;;; MODULE FUNCTIONS.
                     

;;; TYPED PREFERENCE OPERATIONS.

(eval-when (compile eval load) (proclaim '(ftype (function (tme logical anode timetag) timetag-or-NIL) preferences-add-preference)))
(defun preferences-add-preference (pme o-support anode i-timetag)
 ;; The timetag of the instantiation is passed in so that we can properly handle
 ;;  retracting of this pme. If the instantiation timetag is less than the
 ;;  pme timetag then the retract should be thrown away. 23-Apr-90 GAP
 ;;
 ;; Changed to give O-support to chunks that don't fire but would have 
 ;;   given o-support bug #05Sep90-13.02.05 GAP 28-Nov.90
 ;;   NIL for an i-timetag means no instantiation supports the preference
 ;;   thus do not give it O-Support
 ;;
 (declare (type tme pme)                 
          (type logical o-support)
          (type anode anode)
          (type timetag i-timetag))
 ;; if new preference added (rather than old preference given more i-support),
 ;; returns new preference's timetag, else NIL.
 ;; anode is provided so core-preferences records can be upgraded to a
 ;; preferences record for subtext slots.
 ;; context slots are assumed to have a full-preferences record; anode is NIL.
 ;; this sequence of preference types represents a guess about the
 ;; relative frequencies of each type.
 ;; The timetag of the instantiation is passed in so that we can properly handle
 ;;  retracting of this pme later. 23-Apr-90 GAP
 (cond
  ((accept-tme-p pme)
   (multiple-value-bind (new-preferences timetag)
    (add-unary-preference pme o-support (anode-accepts anode) i-timetag)
    (declare (list new-preferences)
             (type timetag-or-NIL timetag))
    (setf (anode-accepts anode) new-preferences)
    timetag))
  ((parallel-tme-p pme)
   (multiple-value-bind (new-preferences timetag)
    (add-unary-preference pme o-support (anode-parallels anode) i-timetag)
    (declare (list new-preferences)
             (type timetag-or-NIL timetag))
    (setf (anode-parallels anode) new-preferences)
    timetag))
  (T
   (if (not (anode-preferences anode))
       ;; context slots always have full-preferences.
       (setf (anode-preferences anode) (make-preferences)))
   (cond
    ((indifferent-tme-p pme)
     (multiple-value-bind (new-preferences timetag)
      (add-unary-preference pme o-support (anode-indifferents anode) i-timetag)
       (declare (list new-preferences)
                (type timetag-or-NIL timetag))
       (setf (preferences-indifferents (anode-preferences anode)) new-preferences)
       timetag))
    ((indifferent-to-tme-p pme)
     (multiple-value-bind (new-preferences timetag)
     (add-binary-preference pme o-support (anode-indifferent-tos anode) i-timetag)
        (declare (list new-preferences)
                (type timetag-or-NIL timetag))
       (setf (preferences-indifferent-tos (anode-preferences anode)) new-preferences)
       timetag))
    ((reconsider-tme-p pme)
     (multiple-value-bind (new-preferences timetag)
      (add-unary-preference pme o-support (anode-reconsiders anode) i-timetag)
       (declare (list new-preferences)
                (type timetag-or-NIL timetag))
       (setf (preferences-reconsiders (anode-preferences anode)) new-preferences)
       timetag))
    ((reject-tme-p pme)
     (multiple-value-bind (new-preferences timetag)
      (add-unary-preference pme o-support (anode-rejects anode) i-timetag)
       (declare (list new-preferences)
                (type timetag-or-NIL timetag))
       (setf (preferences-rejects (anode-preferences anode)) new-preferences)
       timetag))
    ((parallel-to-tme-p pme)
     (multiple-value-bind (new-preferences timetag)
      (add-binary-preference pme o-support (anode-parallel-tos anode) i-timetag)
       (declare (list new-preferences)
                (type timetag-or-NIL timetag))
       (setf (preferences-parallel-tos (anode-preferences anode)) new-preferences)
       timetag))
    ((better-tme-p pme)
     (multiple-value-bind (new-preferences timetag)
      (add-binary-preference pme o-support (anode-betters anode) i-timetag)
       (declare (list new-preferences)
                (type timetag-or-NIL timetag))
       (setf (preferences-betters (anode-preferences anode)) new-preferences)
       timetag))
    ((best-tme-p pme)
     (multiple-value-bind (new-preferences timetag)
      (add-unary-preference pme o-support (anode-bests anode) i-timetag)
       (declare (list new-preferences)
                (type timetag-or-NIL timetag))
       (setf (preferences-bests (anode-preferences anode)) new-preferences)
       timetag))
    ((worst-tme-p pme)
     (multiple-value-bind (new-preferences timetag)
      (add-unary-preference pme o-support (anode-worsts anode) i-timetag)
       (declare (list new-preferences)
                (type timetag-or-NIL timetag))
       (setf (preferences-worsts (anode-preferences anode)) new-preferences)
       timetag))
    ((require-tme-p pme)
     (multiple-value-bind (new-preferences timetag)
      (add-unary-preference pme o-support (anode-requires anode) i-timetag)
       (declare (list new-preferences)
                (type timetag-or-NIL timetag))
       (setf (preferences-requires (anode-preferences anode)) new-preferences)
       timetag))
    (T
     (multiple-value-bind (new-preferences timetag)
      (add-unary-preference pme o-support (anode-prohibits anode) i-timetag)
       (declare (list new-preferences)
                (type timetag-or-NIL timetag))
       (setf (preferences-prohibits (anode-preferences anode)) new-preferences)
       timetag) )) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme anode timetag) timetag-or-NIL) preferences-retract-preference)))
(defun preferences-retract-preference (pme anode i-timetag)
 ;; The timetag of the instantiation is passed in so that we can properly handle
 ;;  retracting of this pme. If the instantiation timetag is less than the
 ;;  pme timetag then the retract should be thrown away. 23-Apr-90 GAP
 (declare (type tme pme)
          (type anode anode)
          (type timetag i-timetag))
 ;; if preference removed, returns removed preference's timetag, else NIL.
 ;; this sequence of preference types represents a guess about the
 ;; relative frequencies of each type.
 (cond
  ((accept-tme-p pme)
   (multiple-value-bind (new-preferences timetag)
    (retract-unary-preference pme (anode-accepts anode) i-timetag)
    (declare (list new-preferences)
             (type timetag-or-NIL timetag))
     (setf (anode-accepts anode) new-preferences)
     timetag))
  ((parallel-tme-p pme)
   (multiple-value-bind (new-preferences timetag)
    (retract-unary-preference pme (anode-parallels anode) i-timetag)
    (declare (list new-preferences)
             (type timetag-or-NIL timetag))
     (setf (anode-parallels anode) new-preferences)
     timetag))
  (T
   (cond ((anode-preferences anode)
          (cond
           ((indifferent-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (retract-unary-preference pme (anode-indifferents anode) i-timetag)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-indifferents (anode-preferences anode)) new-preferences)
              timetag))
           ((indifferent-to-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (retract-binary-preference pme (anode-indifferent-tos anode) i-timetag)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-indifferent-tos (anode-preferences anode)) new-preferences)
              timetag))
           ((reconsider-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (retract-unary-preference pme (anode-reconsiders anode) i-timetag)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-reconsiders (anode-preferences anode)) new-preferences)
              timetag))
           ((reject-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (retract-unary-preference pme (anode-rejects anode) i-timetag)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-rejects (anode-preferences anode)) new-preferences)
              timetag))
           ((parallel-to-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (retract-binary-preference pme (anode-parallel-tos anode) i-timetag)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-parallel-tos (anode-preferences anode)) new-preferences)
              timetag))
           ((better-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (retract-binary-preference pme (anode-betters anode) i-timetag)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-betters (anode-preferences anode)) new-preferences)
              timetag))
           ((best-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (retract-unary-preference pme (anode-bests anode) i-timetag)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-bests (anode-preferences anode)) new-preferences)
              timetag))
           ((worst-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (retract-unary-preference pme (anode-worsts anode) i-timetag)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-worsts (anode-preferences anode)) new-preferences)
              timetag))
           ((require-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (retract-unary-preference pme (anode-requires anode) i-timetag)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-requires (anode-preferences anode)) new-preferences)
              timetag))
           (T
            (multiple-value-bind (new-preferences timetag)
             (retract-unary-preference pme (anode-prohibits anode) i-timetag)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-prohibits (anode-preferences anode)) new-preferences)
              timetag) )) )) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function
                     (tme-type tme-value tme-value anode) timetag-or-NIL) preferences-remove-preference)))
(defun preferences-remove-preference (type process reference anode)
 (declare (type tme-value process reference) 
          (symbol type)
          (type anode anode))
 ;; returns removed preference's timetag.
 (cond
  ((eq type accept-token)
   (multiple-value-bind (new-preferences timetag)
    (remove-unary-preference process (anode-accepts anode))
    (declare (list new-preferences)
             (type timetag-or-NIL timetag))
     (setf (anode-accepts anode) new-preferences)
     timetag))
  ((eq type parallel-token)
   (multiple-value-bind (new-preferences timetag)
    (remove-unary-preference process (anode-parallels anode))
    (declare (list new-preferences)
             (type timetag-or-NIL timetag))
     (setf (anode-parallels anode) new-preferences)
     timetag))
  (T
   (cond ((anode-preferences anode)
          (cond
           ((eq type indifferent-token)
            (multiple-value-bind (new-preferences timetag)
             (remove-unary-preference process (anode-indifferents anode))
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-indifferents (anode-preferences anode)) new-preferences)
              timetag))
           ((eq type indifferent-to-token)
            (multiple-value-bind (new-preferences timetag)
             (remove-binary-preference process reference (anode-indifferent-tos anode))
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-indifferent-tos (anode-preferences anode)) new-preferences)
              timetag))
           ((eq type reconsider-token)
            (multiple-value-bind (new-preferences timetag)
             (remove-unary-preference process (anode-reconsiders anode))
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-reconsiders (anode-preferences anode)) new-preferences)
              timetag))
           ((eq type reject-token)
            (multiple-value-bind (new-preferences timetag)
             (remove-unary-preference process (anode-rejects anode))
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-rejects (anode-preferences anode)) new-preferences)
              timetag))
           ((eq type parallel-to-token)
            (multiple-value-bind (new-preferences timetag)
             (remove-binary-preference process reference (anode-parallel-tos anode))
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-parallel-tos (anode-preferences anode)) new-preferences)
              timetag))
           ((eq type better-token)
            (multiple-value-bind (new-preferences timetag)
             (remove-binary-preference process reference (anode-betters anode))
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-betters (anode-preferences anode)) new-preferences)
              timetag))
           ((eq type best-token)
            (multiple-value-bind (new-preferences timetag)
             (remove-unary-preference process (anode-bests anode))
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-bests (anode-preferences anode)) new-preferences)
              timetag))
           ((eq type worst-token)
            (multiple-value-bind (new-preferences timetag)
             (remove-unary-preference process (anode-worsts anode))
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-worsts (anode-preferences anode)) new-preferences)
              timetag))
           ((eq type require-token)
            (multiple-value-bind (new-preferences timetag)
             (remove-unary-preference process (anode-requires anode))
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-requires (anode-preferences anode)) new-preferences)
              timetag))
           ((eq type prohibit-token)
            (multiple-value-bind (new-preferences timetag)
             (remove-unary-preference process (anode-prohibits anode))
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-prohibits (anode-preferences anode)) new-preferences)
              timetag))
          ) )) ))
)                  

(eval-when (compile eval load) (proclaim '(ftype (function (tme-value anode) anode) preferences-remove-preferences-value)))
(defun preferences-remove-preferences-value (process anode)
 (declare (type tme-value process)
          (type anode anode))
 (setf (anode-accepts anode)
       (remove-unary-preference process (anode-accepts anode)))
 (setf (anode-parallels anode)
       (remove-unary-preference process (anode-parallels anode)))
 (cond ((anode-preferences anode)
        (setf (preferences-indifferents (anode-preferences anode))
              (remove-unary-preference process (anode-indifferents anode)))
        (setf (preferences-indifferent-tos (anode-preferences anode))
              (remove-binary-preferences process (anode-indifferent-tos anode)))
        (setf (preferences-reconsiders (anode-preferences anode))
              (remove-unary-preference process (anode-reconsiders anode)))
        (setf (preferences-rejects (anode-preferences anode))
              (remove-unary-preference process (anode-rejects anode)))
        (setf (preferences-parallel-tos (anode-preferences anode))
              (remove-binary-preferences process (anode-parallel-tos anode)))
        (setf (preferences-betters (anode-preferences anode))
              (remove-binary-preferences process (anode-betters anode)))
        (setf (preferences-bests (anode-preferences anode))
              (remove-unary-preference process (anode-bests anode)))
        (setf (preferences-worsts (anode-preferences anode))
              (remove-unary-preference process (anode-worsts anode)))
        (setf (preferences-requires (anode-preferences anode))
              (remove-unary-preference process (anode-requires anode)))
        (setf (preferences-prohibits (anode-preferences anode))
              (remove-unary-preference process (anode-prohibits anode))) ))
 anode
)                  

(eval-when (compile eval load) (proclaim '(ftype (function (anode) anode) preferences-remove-preferences-slot)))
(defun preferences-remove-preferences-slot (anode)
 (declare (type anode anode))
 
 (setf (anode-accepts anode) NIL)
 (setf (anode-parallels anode) NIL)
 (cond ((anode-preferences anode)
        (setf (preferences-requires (anode-preferences anode)) 
              (remove-all-preferences (anode-requires anode)))
        (setf (preferences-prohibits (anode-preferences anode))
              (remove-all-preferences (anode-prohibits anode)))
        (setf (preferences-reconsiders (anode-preferences anode))
              (remove-all-preferences (anode-reconsiders anode)))
        (setf (preferences-rejects (anode-preferences anode))
              (remove-all-preferences (anode-rejects anode)))
        (setf (preferences-betters (anode-preferences anode)) 
              (remove-all-preferences (anode-betters anode)))
        (setf (preferences-bests (anode-preferences anode)) 
              (remove-all-preferences (anode-bests anode)))
        (setf (preferences-worsts (anode-preferences anode))
              (remove-all-preferences (anode-worsts anode)))
        (setf (preferences-indifferents (anode-preferences anode))
              (remove-all-preferences (anode-indifferents anode)))
        (setf (preferences-indifferent-tos (anode-preferences anode))
              (remove-all-preferences (anode-indifferent-tos anode)))
        (setf (preferences-parallel-tos (anode-preferences anode))
              (remove-all-preferences (anode-parallel-tos anode))) ))
 anode                           
)

(eval-when (compile eval load) (proclaim '(ftype (function
                     (tme-value anode)
                     anode) preferences-reject-preferences)))
(defun preferences-reject-preferences (process anode)
 (declare (type tme-value process)
          (type anode anode))
 (setf (anode-accepts anode)
       (remove-unary-preference process (anode-accepts anode)))
 (setf (anode-parallels anode)
       (remove-unary-preference process (anode-parallels anode)))
 (cond ((anode-preferences anode)
        (setf (preferences-indifferents (anode-preferences anode))
              (remove-unary-preference process (anode-indifferents anode)))
        (setf (preferences-indifferent-tos (anode-preferences anode))
              (remove-binary-preferences process (anode-indifferent-tos anode)))
        #+(or) ;oa-rejects don't flush reconsidrs.
        (setf (preferences-reconsiders (anode-preferences anode))
              (remove-unary-preference process (anode-reconsiders anode)))
        (setf (preferences-rejects (anode-preferences anode))
              (remove-unary-preference process (anode-rejects anode)))
        (setf (preferences-parallel-tos (anode-preferences anode))
              (remove-binary-preferences process (anode-parallel-tos anode)))
        (setf (preferences-betters (anode-preferences anode))
              (remove-binary-preferences process (anode-betters anode)))
        (setf (preferences-bests (anode-preferences anode))
              (remove-unary-preference process (anode-bests anode)))
        (setf (preferences-worsts (anode-preferences anode))
              (remove-unary-preference process (anode-worsts anode)))
        (setf (preferences-prohibits (anode-preferences anode))
              (remove-unary-preference process (anode-prohibits anode))) ))
 anode
)                  

(eval-when (compile eval load) (proclaim '(ftype (function (tme anode list) 
                                        timetag-or-NIL) preferences-pop-preference)))
(defun preferences-pop-preference (pme anode flushed-goals)
 ;; changed to remove O-support from objects whose firing goals have been
 ;;  flushed
 ;; Partially done for Bug#26Feb90-14.11.46 & 19Apr90-21.34.59 19/May/90 GAP
 (declare (type tme pme)
          (type anode anode)
          (list flushed-goals))
 ;; used to pop preference results during pop-goal.
 ;; if preference removed, returns removed preference's timetag, else NIL.
 ;; this sequence of preference types represents a guess about the
 ;; relative frequencies of each type.
 (cond
  ((accept-tme-p pme)
   (multiple-value-bind (new-preferences timetag)
    (pop-unary-preference pme (anode-accepts anode) flushed-goals)
    (declare (list new-preferences)
             (type timetag-or-NIL timetag))
     (setf (anode-accepts anode) new-preferences)
     timetag))
  ((parallel-tme-p pme)
   (multiple-value-bind (new-preferences timetag)
    (pop-unary-preference pme (anode-parallels anode) flushed-goals)
    (declare (list new-preferences)
             (type timetag-or-NIL timetag))
     (setf (anode-parallels anode) new-preferences)
     timetag))
  (T
   (cond ((anode-preferences anode)
          (cond
           ((indifferent-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (pop-unary-preference pme (anode-indifferents anode) flushed-goals)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-indifferents anode) new-preferences)
              timetag))
           ((indifferent-to-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (pop-binary-preference pme (anode-indifferent-tos anode) flushed-goals)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-indifferent-tos (anode-preferences anode)) new-preferences)
              timetag))
           ((reconsider-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (pop-unary-preference pme (anode-reconsiders anode) flushed-goals)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-reconsiders (anode-preferences anode)) new-preferences)
              timetag))
           ((reject-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (pop-unary-preference pme (anode-rejects anode) flushed-goals)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-rejects (anode-preferences anode)) new-preferences)
              timetag))
           ((parallel-to-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (pop-binary-preference pme (anode-parallel-tos anode) flushed-goals)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-parallel-tos (anode-preferences anode)) new-preferences)
              timetag))
           ((better-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (pop-binary-preference pme (anode-betters anode) flushed-goals)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-betters (anode-preferences anode)) new-preferences)
              timetag))
           ((best-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (pop-unary-preference pme (anode-bests anode) flushed-goals)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-bests (anode-preferences anode)) new-preferences)
              timetag))
           ((worst-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (pop-unary-preference pme (anode-worsts anode) flushed-goals)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-worsts (anode-preferences anode)) new-preferences)
              timetag))
           ((require-tme-p pme)
            (multiple-value-bind (new-preferences timetag)
             (pop-unary-preference pme (anode-requires anode) flushed-goals)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-requires (anode-preferences anode)) new-preferences)
              timetag))
           (T
            (multiple-value-bind (new-preferences timetag)
             (pop-unary-preference pme (anode-prohibits anode) flushed-goals)
              (declare (list new-preferences)
                       (type timetag-or-NIL timetag))
              (setf (preferences-prohibits (anode-preferences anode)) new-preferences)
              timetag))
          ) )) ))
)


(eval-when (compile eval load) (proclaim '(ftype (function
                     (tme-type tme-value tme-value anode)
                     pnode-or-NIL) preferences-find-preference)))
(defun preferences-find-preference (type process reference anode)
 (declare (type tme-value process reference)
          (symbol type)
          (type anode anode))
 ;; this sequence of preference types represents a guess about the
 ;; relative frequencies of each type.
 (cond
  ((eq type accept-token)
   (find-unary-preference process (anode-accepts anode)))
  ((eq type parallel-token)
   (find-unary-preference process (anode-parallels anode)))
  (T
   (cond ((anode-preferences anode)
          (cond
           ((eq type indifferent-token)
            (find-unary-preference process (anode-indifferents anode)))
           ((eq type indifferent-to-token)
            (find-binary-preference process reference (anode-indifferent-tos anode)))
           ((eq type reconsider-token)
            (find-unary-preference process (anode-reconsiders anode)))
           ((eq type reject-token)
            (find-unary-preference process (anode-rejects anode)))
           ((eq type parallel-to-token)
            (find-binary-preference process reference (anode-parallel-tos anode)))
           ((eq type better-token)
            (find-binary-preference process reference (anode-betters anode)))
           ((eq type best-token)
            (find-unary-preference process (anode-bests anode)))
           ((eq type worst-token)
            (find-unary-preference process (anode-worsts anode)))
           ((eq type require-token)
            (find-unary-preference process (anode-requires anode)))
           ((eq type prohibit-token)
            (find-unary-preference process (anode-prohibits anode)))  ) )) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function
                     (tme-type tme-value anode)
                     (or list pnode)) preferences-find-preferences)))
(defun preferences-find-preferences (type process anode)
 (declare (type tme-value process)
          (symbol type)
          (type anode anode))
 ;; this sequence of preference types represents a guess about the
 ;; relative frequencies of each type.
 (cond
  ((eq type accept-token)
   (find-unary-preference process (anode-accepts anode)))
  ((eq type parallel-token)
   (find-unary-preference process (anode-parallels anode)))
  (T
   (cond ((anode-preferences anode)
          (cond
           ((eq type indifferent-token)
            (find-unary-preference process (anode-indifferents anode)))
           ((eq type indifferent-to-token)
            (find-binary-preferences process (anode-indifferent-tos anode)))
           ((eq type reconsider-token)
            (find-unary-preference process (anode-reconsiders anode)))
           ((eq type reject-token)
            (find-unary-preference process (anode-rejects anode)))
           ((eq type parallel-to-token)
            (find-binary-preferences process (anode-parallel-tos anode)))
           ((eq type better-token)
            (find-binary-preferences process (anode-betters anode)))
           ((eq type best-token)
            (find-unary-preference process (anode-bests anode)))
           ((eq type worst-token)
            (find-unary-preference process (anode-worsts anode)))
           ((eq type require-token)
            (find-unary-preference process (anode-requires anode)))
           ((eq type prohibit-token)
            (find-unary-preference process (anode-prohibits anode)) )) )) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function
                     (tme-type anode)
                     list) preferences-slot-preferences)))
(defun preferences-slot-preferences (type anode)
 (declare (type tme-type type)
          (type anode anode))
 ;; this sequence of preference types represents a guess about the
 ;; relative frequencies of each type.
 (cond
  ((eq type accept-token)
   (anode-accepts anode))
  ((eq type parallel-token)
   (anode-parallels anode))
  (T
   (cond ((anode-preferences anode)
          (cond
           ((eq type indifferent-token)
            (anode-indifferents anode))
           ((eq type indifferent-to-token)
            (anode-indifferent-tos anode))
           ((eq type reconsider-token)
            (anode-reconsiders anode))
           ((eq type reject-token)
            (anode-rejects anode))
           ((eq type parallel-to-token)
            (anode-parallel-tos anode))
           ((eq type better-token)
            (anode-betters anode))
           ((eq type best-token)
            (anode-bests anode))
           ((eq type worst-token)
            (anode-worsts anode))
           ((eq type require-token)
            (anode-requires anode))
           ((eq type prohibit-token)
            (anode-prohibits anode) )) )) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme-type anode) list) preferences-list-preferences)))
(defun preferences-list-preferences (type anode)
 (declare (type tme-type type)
          (type anode anode))
 ;; this sequence of preference types represents a guess about the
 ;; relative frequencies of each type.
 (cond
  ((eq type accept-token)
   (list-unary-preferences (anode-accepts anode)))
  ((eq type parallel-token)
   (list-unary-preferences (anode-parallels anode)))
  (T
   (cond ((anode-preferences anode)  ;full preferences
          (cond
           ((eq type indifferent-token)
            (list-unary-preferences (anode-indifferents anode)))
           ((eq type indifferent-to-token)
            (list-binary-preferences (anode-indifferent-tos anode)))
           ((eq type reconsider-token)
            (list-unary-preferences (anode-reconsiders anode)))
           ((eq type reject-token)
            (list-unary-preferences (anode-rejects anode)))
           ((eq type parallel-to-token)
            (list-binary-preferences (anode-parallel-tos anode)))
           ((eq type better-token)
            (list-binary-preferences (anode-betters anode)))
           ((eq type best-token)
            (list-unary-preferences (anode-bests anode)))
           ((eq type worst-token)
            (list-unary-preferences (anode-worsts anode)))
           ((eq type require-token)
            (list-unary-preferences (anode-requires anode)))
           ((eq type prohibit-token)
            (list-unary-preferences (anode-prohibits anode))) ) )) ))
)




;;; UNTYPED PREFERENCE OPERATIONS.

(eval-when (compile eval load) (proclaim '(ftype (function (tme logical list timetag)
                                          (or (values list timetag) list)) add-unary-preference)))
(defun add-unary-preference (pme o-support unary-preferences i-timetag)
 ;; Changed to give O-support from a goal. So O-support can be retracted
 ;; Partially done for Bug#26Feb90-14.11.46 & 19Apr90-21.34.59 19/May/90 GAP
 ;; The timetag of the instantiation is passed in so that we can properly handle
 ;;  retracting of this pme later. 23-Apr-90 GAP
 ;;
 ;; Changed to give O-support to chunks that don't fire but would have 
 ;;   given o-support bug #05Sep90-13.02.05 GAP 28-Nov.90
 ;;   NIL for an i-timetag means no instantiation supports the preference
 ;;   thus do not give it O-Support
 ;;
 (declare (type tme pme)
          (list unary-preferences)
          (type logical o-support)
	  (type timetag i-timetag))
 ;; returns preferences and, if preference added, new preference's timetag.
 (let* ((value (tme-value pme))
        (pnode (find-if
                 #'(lambda (pnode)
                    (declare (type pnode pnode))
                    (tme-value= (tme-value (pnode-pme pnode)) value))
                 unary-preferences)))
  (declare (type tme-value value)
           (type pnode-or-NIL pnode))
  (cond (pnode                         
         (when i-timetag
               (incf (pnode-i-support pnode)))
         (cond (o-support
                (if (or  (not (goal-gnode (pnode-o-support pnode)))
                         ( < (gnode-depth (goal-gnode *firing-goal*))
                         (gnode-depth (goal-gnode (pnode-o-support pnode)))))
                     (setf (pnode-o-support pnode) *firing-goal*))
                ;; to make goal termination computationally reasonable we
                ;; need to add to the goal all the pnodes that this goal
                ;; supports
                ))
         (signal-preference-addition (pnode-pme pnode)
                                     (pnode-timetag pnode))
         unary-preferences)

        ((not i-timetag)  ;; throw away o-support if preference not there. It should be.
         unary-preferences)

        (T        
         (let ((timetag i-timetag))
          (declare (type timetag timetag))                     
          (signal-preference-addition pme timetag)
          (cond (o-support
                  (push (make-pnode pme timetag 1 *firing-goal*) 
                         unary-preferences)
                ;; to make goal termination computationally reasonable we
                ;; need to add to the goal all the pnodes that this goal
                ;; supports
                 )
                (T
                  (push (make-pnode pme timetag 1 NIL) 
                         unary-preferences)))
          (values unary-preferences timetag)) ))
))

(eval-when (compile eval load) (proclaim '(ftype (function (tme logical list timetag)
                                           (or (values list timetag) list)) add-binary-preference)))
(defun add-binary-preference (pme o-support binary-preferences i-timetag)
 ;; The timetag of the instantiation is passed in so that we can properly handle
 ;;  retracting of this pme later. 23-Apr-90 GAP
 (declare (type tme pme)
          (type list binary-preferences)
          (type logical o-support)
	  (type timetag i-timetag))
 ;; returns preferences and, if preference added, new preference's timetag.
 (let* ((value (tme-value pme))
        (reference (tme-reference pme))
        (pnode (find-if
                 #'(lambda (pnode)
                    (declare (type pnode pnode))
                    (and (tme-value= (tme-value (pnode-pme pnode)) value)
                         (tme-value= (tme-reference (pnode-pme pnode)) reference)))
           binary-preferences)))
  (declare (type tme-value value reference)
           (type pnode-or-NIL pnode))
  (cond (pnode                         
         (when i-timetag
               (incf (pnode-i-support pnode)))
         (cond (o-support
                (if (or  (not (goal-gnode (pnode-o-support pnode)))
                         ( < (gnode-depth (goal-gnode *firing-goal*))
                         (gnode-depth (goal-gnode (pnode-o-support pnode)))))
                     (setf (pnode-o-support pnode) *firing-goal*))
                ;; to make goal termination computationally reasonable we
                ;; need to add to the goal all the pnodes that this goal
                ;; supports
                ))
         (signal-preference-addition (pnode-pme pnode)
                                     (pnode-timetag pnode))
         binary-preferences)

        ((not i-timetag)  ;; throw away o-support if preference not there. It should be.
         binary-preferences)

        (T                              
         (let ((timetag i-timetag))
          (declare (type timetag timetag))                     
          (signal-preference-addition pme timetag)
          (cond (o-support
                  (push (make-pnode pme timetag 1 *firing-goal*) 
                         binary-preferences)
                ;; to make goal termination computationally reasonable we
                ;; need to add to the goal all the pnodes that this goal
                ;; supports
                 )
                (T
                  (push (make-pnode pme timetag 1 NIL) 
                         binary-preferences)))
          (values binary-preferences timetag)) ))
))

(defmacro find-goal-p (goal)
  ;; logical function returning a goal
 ;; Changed to retract O-support appropriately 11-Feb-90 GAP
 ;; In response to bug #19Apr90-21.34.59
   `(not (goal-p ,goal))
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme list timetag)
                                              (or (values list timetag) list)) retract-unary-preference)))



(defun retract-unary-preference (pme unary-preferences i-timetag)
 ;; The timetag of the instantiation is passed in so that we can properly handle
 ;;  retracting of this pme. If the instantiation timetag is less than the
 ;;  pme timetag then the retract should be thrown away. 23-Apr-90 GAP
 ;;  Changed to retract preferences whose goal-support is gone. 11-Feb.91 GAP
 ;;  For Bug #19Apr90-21.34.59
 (declare (type tme pme unary-preferences)
          (type timetag i-timetag))
 ;; returns preferences and, if preference removed, removed preference's timetag.
 ;; will leave preference if it still has i-support or o-support.
 ;; same as retract-binary-preference.     
 ;; if more than one instantiation is supporting this preference, only the first 
 ;; creator will retract the eq-pme.
 (let ((pnode (find-if #'(lambda (pnode)
                          (declare (type pnode pnode))
                          (let ((eq-pme (pnode-pme pnode)))
                            (declare (type tme eq-pme))
                            (or (eq pme eq-pme)
                                (tme-value= (tme-value eq-pme) (tme-value pme)))))
                       unary-preferences)))
  (declare (type pnode-or-NIL pnode))
  (cond ((and pnode                    
	      ( >= i-timetag (pnode-timetag pnode)))
           (signal-preference-removal pme (pnode-timetag pnode))
           (decf (pnode-i-support pnode))
           (cond ((and (= (pnode-i-support pnode) 0)
                       (or (not (pnode-o-support pnode))
                           (find-goal-p (pnode-o-support pnode))))
                (let ((timetag (pnode-timetag pnode)))
                 (declare (type timetag timetag)) 
                 (values (delete pnode unary-preferences :test #'eq :count 1)
                         timetag)) )
               (T
                unary-preferences)) )
        (T
         unary-preferences))
))



(eval-when (compile eval load) (proclaim '(ftype (function (tme list timetag)
                                               (or (values list timetag) list)) retract-binary-preference)))
(defun retract-binary-preference (pme binary-preferences i-timetag)
 ;; The timetag of the instantiation is passed in so that we can properly handle
 ;;  retracting of this pme. If the instantiation timetag is less than the
 ;;  pme timetag then the retract should be thrown away. 23-Apr-90 GAP
 ;;  Changed to retract preferences whose goal-support is gone. 11-Feb.91 GAP
 ;;  For Bug #19Apr90-21.34.59
 (declare (type tme pme)
          (list binary-preferences)
          (type timetag i-timetag))
 ;; returns preferences and, if preference removed, removed preference's timetag.
 ;; will leave preference if it still has i-support or o-support.
 ;; same as retract-unary-preference.
 ;; if more than one instantiation is supporting this preference, only the first 
 ;; creator will retract the eq-pme.
 (let ((pnode (find-if #'(lambda (pnode)
                          (declare (type pnode pnode))
                          (let ((eq-pme (pnode-pme pnode)))
                            (declare (type tme eq-pme))
                            (or (eq pme eq-pme)
                                (and 
                                 (tme-value= (tme-value eq-pme) (tme-value pme))
                                 (tme-value= (tme-reference eq-pme)
                                             (tme-reference pme))))))
                       binary-preferences)))
  (declare (type pnode-or-NIL pnode))
  (cond ((and pnode                         
	     ( >= i-timetag (pnode-timetag pnode)))
           (signal-preference-removal pme (pnode-timetag pnode))
           (decf (pnode-i-support pnode))
           (cond ((and (= (pnode-i-support pnode) 0)
                       (or (not (pnode-o-support pnode))
                           (find-goal-p (pnode-o-support pnode))))
                (let ((timetag (pnode-timetag pnode)))
                 (declare (type timetag timetag)) 
                 (values (delete pnode binary-preferences :test #'eq :count 1)
                         timetag)) )
               (T
                binary-preferences)) )
        (T
         binary-preferences))
))

(eval-when (compile eval load) (proclaim '(ftype (function (tme-value list)
                                             (or (values list timetag) list)) remove-unary-preference)))
(defun remove-unary-preference (process unary-preferences)
 (declare (type tme-value process)
          (list unary-preferences))
 ;; returns preferences and removed preference's timetag.
 (let ((pnode
        (find-if #'(lambda (pnode)
                    (declare (type pnode pnode))
                    (tme-value= (tme-value (pnode-pme pnode)) process))
                 unary-preferences)))
  (declare (type pnode-or-NIL pnode))
  (cond (pnode
         (signal-preference-removal (pnode-pme pnode) (pnode-timetag pnode))
         (values (delete pnode unary-preferences :count 1 :test #'eq) 
                 (pnode-timetag pnode)) )
        (T
         unary-preferences))
))

(eval-when (compile eval load) (proclaim '(ftype (function (tme-value tme-value list)
                                              (or (values list timetag) list)) remove-binary-preference)))
(defun remove-binary-preference (process reference binary-preferences)
 (declare (type tme-value process reference)
          (list binary-preferences))
 ;; returns preferences and removed preference's timetag.
 (let ((pnode
        (find-if #'(lambda (pnode)
                    (declare (type pnode pnode))
                    (and (tme-value= (tme-value (pnode-pme pnode)) process)
                         (tme-value= (tme-reference (pnode-pme pnode)) reference)))
                 binary-preferences)))
  (declare (type pnode-or-NIL pnode))
  (cond (pnode
         (signal-preference-removal (pnode-pme pnode) (pnode-timetag pnode))
         (values (delete pnode binary-preferences :count 1 :test #'eq) 
                 (pnode-timetag pnode)) )
        (T
         NIL))
))

(eval-when (compile eval load) (proclaim '(ftype (function (tme-value list) list) remove-binary-preferences)))
(defun remove-binary-preferences (process binary-preferences)
 (declare (type tme-value process)
          (list binary-preferences))   
 (let ((preferences NIL))
  (declare (list preferences))
  (dolist (pnode binary-preferences preferences)
   (declare (type pnode pnode))
   (cond ((or (tme-value= (tme-value (pnode-pme pnode)) process)
              (tme-value= (tme-reference (pnode-pme pnode)) process))
          (signal-preference-removal (pnode-pme pnode) (pnode-timetag pnode)) )
         (T
          (push pnode preferences) )) )
))

(eval-when (compile eval load) (proclaim '(ftype (function (list) list) remove-all-preferences)))
(defun remove-all-preferences (preferences)
 (declare (list preferences))   
 (dolist (pnode preferences NIL)
  (declare (type pnode pnode))
  (signal-preference-removal (pnode-pme pnode) (pnode-timetag pnode)) )
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme list list)
                                          (or (values list timetag) list)) pop-unary-preference)))
(defun pop-unary-preference (pme unary-preferences flushed-goals)
 ;; changed to remove O-support from objects whose firing goals have been
 ;;  flushed
 ;; Partially done for Bug#26Feb90-14.11.46 & 19Apr90-21.34.59 19/May/90 GAP
 (declare (type tme pme unary-preferences)
          (list flushed-goals))
 ;; returns preferences and, if preference removed, removed preference's timetag.
 ;; will leave preference if it still has i-support, but not if it has
 ;; only o-support.
 ;; same as pop-binary-preference.
 (let ((pnode (find-if #'(lambda (pnode)
                           (declare (type pnode pnode))
                           (eq (pnode-pme pnode) pme))
                       unary-preferences)))
  (declare (type pnode-or-NIL pnode))
  (cond (pnode                         
         (signal-preference-removal pme (pnode-timetag pnode))
         (if (and (pnode-o-support pnode)
                  (member (pnode-o-support pnode) flushed-goals))
              (setf (pnode-o-support pnode) NIL))
         (cond ((and (not (pnode-o-support pnode))
                     (= (pnode-i-support pnode) 1))
                (let ((timetag (pnode-timetag pnode)))
                 (declare (type timetag timetag)) 
                 (values (delete pnode unary-preferences :test #'eq :count 1)
                         timetag)) )
               (T
                (decf (pnode-i-support pnode))
                unary-preferences)) )
        (T
         unary-preferences))
))

(eval-when (compile eval load) (proclaim '(ftype (function (tme list list)
                                           (or (values list timetag) list)) pop-binary-preference)))
(defun pop-binary-preference (pme binary-preferences flushed-goals)
 ;; changed to remove O-support from objects whose firing goals have been
 ;;  flushed
 ;; Partially done for Bug#26Feb90-14.11.46 & 19Apr90-21.34.59 19/May/90 GAP
 (declare (type tme pme)
          (list binary-preferences)
          (list flushed-goals))
 ;; returns preferences and, if preference removed, removed preference's timetag.
 ;; will leave preference if it still has i-support, but not if it has
 ;; only o-support.
 ;; same as pop-unary-preference.
 (let ((pnode (find-if #'(lambda (pnode)
                           (declare (type pnode pnode))
                           (eq (pnode-pme pnode) pme))
                       binary-preferences)))
  (declare (type pnode-or-NIL pnode))
  (cond (pnode                         
         (signal-preference-removal pme (pnode-timetag pnode))
         (if (and (pnode-o-support pnode)
                  (member (pnode-o-support pnode) flushed-goals))
              (setf (pnode-o-support pnode) NIL))
         (cond ((and (not (pnode-o-support pnode))
                     (= (pnode-i-support pnode) 1))
                (let ((timetag (pnode-timetag pnode)))
                 (declare (type timetag timetag)) 
                 (values (delete pnode binary-preferences :test #'eq :count 1)
                         timetag)) )
               (T
                (decf (pnode-i-support pnode))
                binary-preferences)) )
        (T
         binary-preferences))
))

(eval-when (compile eval load) (proclaim '(ftype (function (tme-value list) pnode-or-NIL) find-unary-preference)))
(defun find-unary-preference (process unary-preferences)
 (declare (type tme-value process)
          (list unary-preferences))
 (find-if
  #'(lambda (pnode)
     (declare (type pnode pnode))
     (tme-value= (tme-value (pnode-pme pnode)) process))
  unary-preferences)
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme-value tme-value list) pnode-or-NIL) find-binary-preference)))
(defun find-binary-preference (process reference binary-preferences)
 (declare (type tme-value process reference)
          (list binary-preferences))
 (find-if
  #'(lambda (pnode)
     (declare (type pnode pnode))
     (and (tme-value= (tme-value (pnode-pme pnode)) process)
          (tme-value= (tme-reference (pnode-pme pnode)) reference)))
  binary-preferences)
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme-value list) list) find-binary-preferences)))
(defun find-binary-preferences (process binary-preferences)
 (declare (type tme-value process)
          (list binary-preferences))
 (remove-if #'(lambda (pnode)
               (declare (type pnode pnode))
               (not (or (tme-value= (tme-value (pnode-pme pnode)) process)
                        (tme-value= (tme-reference (pnode-pme pnode)) process))))
            binary-preferences)
)

(eval-when (compile eval load) (proclaim '(ftype (function (list) list) list-unary-preferences)))
(defun list-unary-preferences (unary-preferences)
 (declare (list unary-preferences))
 (if unary-preferences
     (mapcar 
      #'(lambda (pnode)
         (declare (type pnode pnode))
         (tme-value (pnode-pme pnode)))
      unary-preferences))
)

(eval-when (compile eval load) (proclaim '(ftype (function (list) list) list-binary-preferences)))
(defun list-binary-preferences (binary-preferences)
 (declare (list binary-preferences))
 (if binary-preferences
     (mapcar 
      #'(lambda (pnode)
         (declare (type pnode pnode))
         (list (tme-value (pnode-pme pnode))
               (tme-reference (pnode-pme pnode))))
      binary-preferences))
)                                                       




;;; OTHER PREFERENCES OPERATIONS.

(eval-when (compile eval load) (proclaim '(ftype (function
                     (anode)
                     (values list list list list
                             list list list list list)) preferences-parse-preferences)))
(defun preferences-parse-preferences (anode)
 (declare (type anode anode))
 (let ((full-p (anode-preferences anode)))
  (declare (type preferences-or-NIL full-p))
  (values
   (if full-p (anode-requires anode))
   (if full-p (anode-prohibits anode))
   (anode-accepts anode)
   (if full-p (anode-reconsiders anode))
   (if full-p (anode-rejects anode))
   (if full-p (anode-betters anode))
   (if full-p (anode-bests anode))
   (if full-p (anode-worsts anode))
   (if full-p (anode-indifferents anode))
   (if full-p (anode-indifferent-tos anode))
   (anode-parallels anode)
   (if full-p (anode-parallel-tos anode)) )
))

(eval-when (compile eval load) (proclaim '(ftype (function (anode) list) preferences-preferences-p)))
(defun preferences-preferences-p (anode)
 (declare (type anode anode))
 (let ((full-p (anode-preferences anode)))
  (declare (type preferences-or-NIL full-p))
  (or
   (anode-accepts anode)
   (anode-parallels anode)
   (if full-p (anode-requires anode))
   (if full-p (anode-prohibits anode))
   (if full-p (anode-reconsiders anode))
   (if full-p (anode-rejects anode))
   (if full-p (anode-betters anode))
   (if full-p (anode-bests anode))
   (if full-p (anode-worsts anode))
   (if full-p (anode-indifferents anode))
   (if full-p (anode-indifferent-tos anode))
   (if full-p (anode-parallel-tos anode)) )
))

  

;;; PREFERENCES REPORT.
;;;  Should be using print-wme here.

(eval-when (compile eval load) (proclaim '(ftype (function
                     (tme-class tme-object tme-attribute list anode logical)
                     true) preferences-report)))
(defun preferences-report (class object attribute oa-rejects anode print-p)                 
 (declare (type tme-class class)
          (type tme-object object)
          (type tme-attribute attribute)
          (list oa-rejects)
          (type anode anode)
          (type logical print-p))

 (multiple-value-bind (requires prohibits
                       accepts reconsiders rejects
                       betters bests worsts 
                       indifferents indifferent-tos
                       parallels parallel-tos)
                      (preferences-parse-preferences anode)
  (declare (list requires prohibits
                 accepts reconsiders rejects
                 betters bests worsts
                 indifferents indifferent-tos
                 parallels parallel-tos)) 

  (cond (oa-rejects  
         (print-typed-preferences
           class object attribute 'oa-reject oa-rejects print-p) ))

  (cond (reconsiders
         (print-typed-preferences
           class object attribute 'reconsider reconsiders print-p) ))
  (cond (requires
         (print-typed-preferences
           class object attribute 'require requires print-p) ))
  (cond (prohibits
         (print-typed-preferences
           class object attribute 'prohibit prohibits print-p) ))
  (cond (accepts
         (print-typed-preferences
           class object attribute 'accept accepts print-p) ))
  (cond (rejects  
         (print-typed-preferences
           class object attribute 'reject rejects print-p) ))
  (cond (betters
         (print-typed-preferences
           class object attribute 'better betters print-p) ))
  (cond (bests
         (print-typed-preferences
           class object attribute 'best bests print-p) ))
  (cond (worsts
         (print-typed-preferences
           class object attribute 'worst worsts print-p) ))
  (cond (indifferents
         (print-typed-preferences
           class object attribute 'indifferent indifferents print-p) ))
  (cond (indifferent-tos
         (print-typed-preferences
           class object attribute 'indifferent-to indifferent-tos print-p) ))
  (cond (parallels
         (print-typed-preferences
           class object attribute 'parallel parallels print-p) ))
  (cond (parallel-tos
         (print-typed-preferences
           class object attribute 'parallel-to parallel-tos print-p) ))
 T
))

(eval-when (compile eval load) (proclaim '(ftype (function
                     (tme-class tme-object tme-attribute tme-type list logical)
                     true) print-typed-preferences)))
(defun print-typed-preferences (class object attribute type typed-preferences print-p)
 (declare (type tme-class class)
          (type tme-object object)
          (type tme-attribute attribute)
          (type tme-type type)
          (list typed-preferences)
          (type logical print-p))

 (let ((parser (cond ((eq type 'oa-reject)
                      #'parse-oa-reject)
                     ((member type '(better indifferent-to parallel-to) :test #'eq)
                      #'parse-binary-preference)
                     (T
                      #'parse-unary-preference)) ))

  (if print-p
    (soar-format *trace-file*
               "~%~As:"
               (string-capitalize type)))

  (dolist (preference typed-preferences T)
    (multiple-value-bind (process reference i-support o-support) 
                         (funcall parser preference) 
      (declare (type tme-value process reference)
               (atom i-support o-support)) 
     (push (format nil
                  "~A   I-Support: ~A   O-Support: ~A"
                  (format-preference class 
                                     object
                                     attribute
                                     type  
                                     process 
                                     reference)
                  i-support
                  o-support)
           preferences-result)

     (if print-p 
       (soar-format *trace-file*
                  "~%~A   I-Support: ~A   O-Support: ~A"
                  (format-preference class 
                                     object
                                     attribute
                                     type  
                                     process 
                                     reference)
                  i-support
                  o-support)) ))
))

(eval-when (compile eval load) (proclaim '(ftype (function
                     (tme-class tme-object tme-attribute tme-type tme-value tme-value)
                     string) format-preference)))
(defun format-preference (class object attribute type process reference)
 (declare (symbol class object attribute type)
          (atom process reference))
 (cond (reference
        (soar-format NIL                                       
                     "(~A ~A ^~A ~A ~A ~A)"
                     class
                     object
                     attribute
                     process
                     (preference-external-type type)
                     reference))
       (T
        (soar-format NIL                                       
                     "(~A ~A ^~A ~A ~A)"
                     class
                     object
                     attribute
                     process
                     (preference-external-type type)) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function (atom) (values tme-value NIL string string)) parse-oa-reject)))
(defun parse-oa-reject (reject)
 (declare (type tme-value reject))
 (values reject NIL "N/A" "N/A")
)


(eval-when (compile eval load) (proclaim '(ftype (function (pnode)
                                (values tme-value tme-value fixnum tme-value)) parse-unary-preference)))
(defun parse-unary-preference (pnode)
 (declare (type pnode pnode))
 (values (tme-value (pnode-pme pnode))
         NIL
         (pnode-i-support pnode)
         (pnode-o-support pnode))
)

(eval-when (compile eval load) (proclaim '(ftype (function (pnode)
                                (values tme-value tme-value fixnum tme-value)) parse-binary-preference)))
(defun parse-binary-preference (pnode)
 (declare (type pnode pnode))
 (values (tme-value (pnode-pme pnode))
         (tme-reference (pnode-pme pnode))
         (pnode-i-support pnode)
         (pnode-o-support pnode))
)



;;; UTILITIES.

(eval-when (compile eval load) (proclaim '(ftype (function () true) start-preferences)))
(defun start-preferences ()
 T
)

(eval-when (compile eval load) (proclaim '(ftype (function () true) restart-preferences)))
(defun restart-preferences ()
 T
)

(eval-when (compile eval load) (proclaim '(ftype (function () true) retask-preferences)))
(defun retask-preferences ()
 T
)




;;;
;;;	XV.	proposed-operators
;;;

(defparameter proposed-operators-result nil)

(defun proposed-operators (&optional (goal (bottom-goal)))
  "Returns a list of operators proposed for GOAL."
 (setq proposed-operators-result nil)
 (if (not goal) (return-from proposed-operators nil))
 (let* ( (anode (gnode-operator-anode (goal-gnode goal))) )
  (declare (type anode-or-NIL anode))
 (multiple-value-bind (requires prohibits accepts reconsiders rejects
                       betters bests worsts indifferents indifferent-tos
                       parallels parallel-tos)
                      (preferences-parse-preferences anode) 
  (declare (list requires prohibits accepts reconsiders rejects
                 betters bests worsts indifferents indifferent-tos
                 parallels parallel-tos))
  (if reconsiders (push-typed-preferences goal 'reconsider reconsiders))
  (if requires (push-typed-preferences goal 'require requires))
  (if prohibits (push-typed-preferences goal 'prohibit prohibits))
  (if accepts (push-typed-preferences goal 'accept accepts))
  (if rejects (push-typed-preferences goal 'reject rejects))
  (if betters (push-typed-preferences goal 'better betters))
  (if bests (push-typed-preferences goal 'best bests))
  (if worsts (push-typed-preferences goal 'worst worsts))
  (if indifferents (push-typed-preferences goal 'indifferent indifferents))
  (if indifferent-tos (push-typed-preferences goal 'indifferent-to indifferent-tos))
  (if parallels (push-typed-preferences goal 'parallel parallels))
  (if parallel-tos (push-typed-preferences goal 'parallel-to parallel-tos))
  (sort proposed-operators-result #'string-lessp)))
)

(defun push-typed-preferences (object type typed-preferences)
 (declare (ignore object)
          (type tme-type type)
          (list typed-preferences))
 (let ((parser (cond ((member type '(better indifferent-to parallel-to)
			      :test #'eq)
                      #'parse-binary-preference)
                     (T #'parse-unary-preference)) ))
  (dolist (preference typed-preferences T)
    (multiple-value-bind (process reference i-support o-support) 
                         (funcall parser preference) 
      (declare (type tme-value process reference)
               (atom i-support o-support)) 
     (push (soar-format nil
                  "~A"  ;ISupp:~A OSupp:~A
                  (format-preference2
                                     type  
                                     process 
                                     reference)
                  i-support
                  o-support)
	   proposed-operators-result)))
))

(eval-when (compile eval load) (proclaim '(ftype (function  (tme-type tme-value tme-value)
                     string) format-preference2
               )))
(defun format-preference2 ( type process reference)
 (declare (symbol type)
          (atom process reference))
 (cond (reference
        (soar-format NIL                                       
                     "~A (~a) ~A ~A"
                     process
		     (context-object-name process)
                     (preference-external-type type)
                     reference))
       (T
        (soar-format NIL                                       
                     "~A (~a) ~A"
                     process
		     (context-object-name process)		     
                     (preference-external-type type)) ))
)

;;; Concatenated from type module "p-graph" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/p-graph/new/p-graph.lisp".
(in-package "SOAR")




;;; <P-GRAPH.FUNCTIONS>

;;; P-GRAPH MODULE: FUNCTIONS.

;;; MODULE GLOBALS.


;;; MODULE FUNCTIONS.
                     

;;; WORKING MEMORY TRANSITIVE CLOSURE



(defun mark-WM-descendants (visitee-nodes)
 (declare (list visitee-nodes))

  (dolist (node visitee-nodes)  ;Mark everything 
      (declare (type onode node))
      (cond ((onode-marker node))    ;; cycle break. 
            (T     
             ;; leaf or branch.
             (setf (onode-marker node) T)
             (mark-WM-descendants (onode-outnodes node))) ))
)

(defun Unmark-WM-descendants (visitee-nodes)
 (declare (list visitee-nodes))

  (dolist (node visitee-nodes)  ;Mark everything 
      (declare (type onode node))
      (cond ((not (onode-marker node)))    ;; cycle break. 
            (T     
             ;; leaf or branch.
             (setf (onode-marker node) NIL)
             (Unmark-WM-descendants (onode-outnodes node))) ))
)


(defun Mark-Working-Memory-TC (objects)
 (declare (list objects))
 ;; used during rule classification (OA or OC).
 (let ((onodes '()))
   (dolist (object objects)
     (let ((onode (object-onode object)))
        (if onode
           (push onode onodes)) )) 
  
   (setq *WM-TC-starting-points* (nconc *WM-TC-starting-points* onodes))

   (mark-WM-descendants onodes)
))

;;; FOOTPRINT UTILITIES


(defun mark-some-production-footprint-descendants (footprint-graph visitee-nodes dont-visit-nodes)
 (declare (type p-footprint-node footprint-graph)
          (list visitee-nodes)
          (list dont-visit-nodes))

  (dolist (node visitee-nodes)  ;Mark everything 
      (declare (type p-footprint-node node))
      (cond ((p-footprint-node-marker node))    ;; cycle break. 
            ((member node dont-visit-nodes))    ;; trim graph
            (T     
             ;; leaf or branch.
             (setf (p-footprint-node-marker node) T)
             (if (p-footprint-node-outnodes node)
		 (mark-some-production-footprint-descendants footprint-graph
							     (p-footprint-node-outnodes node) 
							     dont-visit-nodes))) ))
)

(defun mark-production-footprint-descendants (footprint-graph visitee-nodes)
 (declare (type p-footprint-node footprint-graph)
          (list visitee-nodes))

  (dolist (node visitee-nodes)  ;Mark everything 
      (declare (type p-footprint-node node))
      (cond ((p-footprint-node-marker node))    ;; cycle break. 
            (T     
             ;; leaf or branch.
             (setf (p-footprint-node-marker node) T)
             (if (p-footprint-node-outnodes node)
		 (mark-production-footprint-descendants footprint-graph
							(p-footprint-node-outnodes node)))) ))
)

(defun unmark-production-footprint-descendants (footprint-graph visitee-nodes)
 (declare (type p-footprint-node footprint-graph)
          (list visitee-nodes))

  (dolist (node visitee-nodes)  ;Mark everything 
      (declare (type p-footprint-node node))
      (cond ((not (p-footprint-node-marker node)))    ;; cycle break. 
            (T     
             ;; leaf or branch.
             (setf (p-footprint-node-marker node) NIL)
             (unmark-production-footprint-descendants footprint-graph
                                      (p-footprint-node-outnodes node))) ))
)

(defun gather-production-footprint-descendants (footprint-graph visitee-nodes)
 (declare (type p-footprint-node footprint-graph)
          (list visitee-nodes))

  (let ((all-children '()))
  (dolist (node visitee-nodes all-children)  ;Mark everything 
      (declare (type p-footprint-node node))
      (cond ((not (p-footprint-node-marker node)))    ;; cycle break. 
            (T     
             ;; leaf or branch.
             (setf (p-footprint-node-marker node) NIL)
             (push (p-footprint-node-name node) all-children)
             (setf all-children (nconc all-children 
                    (gather-production-footprint-descendants footprint-graph
                                      (p-footprint-node-outnodes node))))) ))

))

(defun production-footprint-symbol-descendants (footprint-graph visitee-nodes)
 (declare (type p-footprint-node footprint-graph)
          (list visitee-nodes))
 
 (mark-production-footprint-descendants footprint-graph visitee-nodes)

 (gather-production-footprint-descendants footprint-graph visitee-nodes)
)


(defmacro footprint-TC (footprint-graph node)
 ;; This macro returns a list that is the footprint TC
 ;;
 (declare (type p-footprint-node footprint-graph)
          (type p-footprint-node node))

 `(when ,node
    (cond ((p-footprint-node-TC ,node))
        (T (setf (p-footprint-node-TC ,node) 
                 (production-footprint-symbol-descendants ,footprint-graph
                                                          (list ,node)))) )))

(defmacro footprint-TC-list (footprint-graph nodes)
 ;; This macro returns a list that is the footprint TC
 ;;
 (declare (type p-footprint-node footprint-graph)
          (list nodes))

 `(if ,nodes (production-footprint-symbol-descendants ,footprint-graph ,nodes) NIL))

(defun find-footprint-node (footprint-graph name)
 ;; This either finds a footprint node corresponding to "name"
 ;; or returns NIL
 
 (declare (type p-footprint-node footprint-graph)
          ( symbol         name))
 (do ((node footprint-graph (p-footprint-node-next node)))
      ((null node) NIL)
      (when (eq (p-footprint-node-name node) name)
            (return node))))

  
;;; ANCESTORS.

(eval-when (compile eval load) (proclaim '(ftype (function (tme-object) list) object-p-ancestor-objects)))
(defun object-p-ancestor-objects (object)
 (declare (type tme-object object))
 (let ((onode (object-onode object)))
  (declare (type onode-or-NIL onode))
  (if onode (mapcar #'onode-object (onode-p-ancestor-onodes onode)))
))

(eval-when (compile eval load) (proclaim '(ftype (function (onode) list) onode-p-ancestor-onodes)))
(defun onode-p-ancestor-onodes (onode)                                                    
 (declare (type onode onode))
 (delete onode
         (onode-p-ancestor-onodes-aide (onode-p-parent-onodes onode) (list onode))
         :test #'eq)
)

(eval-when (compile eval load) (proclaim '(ftype (function (list list) list) onode-p-ancestor-onodes-aide)))
(defun onode-p-ancestor-onodes-aide (visitees visited)
 (declare (list visitees visited))                         
 (cond ((null visitees)
        visited)
       (T         
        (let ((visitee (first visitees)))
         (declare (type onode visitee))
         (cond ((member visitee visited :test #'eq)
                ;; cycle break.
                (onode-p-ancestor-onodes-aide (rest visitees) visited))
               (T       
                ;; branch.
                (onode-p-ancestor-onodes-aide (append (onode-p-parent-onodes visitee)
                                                      (rest visitees))
                                              (push visitee visited)) )) ) ))
)

(eval-when (compile eval load) (proclaim '(ftype (function (tme-object) list) nested-object-p-ancestor-objects)))
(defun nested-object-p-ancestor-objects (object)
 (declare (type tme-object object))
 (let ((onode (object-onode object)))
  (declare (type onode-or-NIL onode))
  (if onode (nested-onode-p-ancestor-objects onode))
))

(eval-when (compile eval load) (proclaim '(ftype (function (onode) list) nested-onode-p-ancestor-objects)))
(defun nested-onode-p-ancestor-objects (onode)
 (declare (type onode on