
/****************************************************************************
 *
 * MODULE:  wminput.c
 *
 ****************************************************************************
 *
 * Abstract:
 *    Routines to handle input of wmes.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    10 Aug 89 V4.0  Dirk Kalp
 *                    Merged with ParaOPS5 4.3.
 *    12 May 89 V2.0  Dirk Kalp
 *                    Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    25 Jun 89 V4.3  Dirk Kalp
 *                    Change global routine names to have "ops_" prefix. This
 *                    is to prevent conflicts with system and user defined
 *                    names at link time.
 *    24 Oct 88 V4.0  Dirk Kalp
 *                    Release of ParaOPS5 Version 4.0.
 *    24 Sep 88 V3.1  Dirk Kalp
 *                    Added "ops_do_make" routine to process top level MAKE
 *                    user interface cmd.
 *    13 Aug 88 V3.0  Dirk Kalp
 *                    Use fprintf instead of printf.
 *    25 May 88 V2.0  Dirk Kalp
 *                    Updated to consolidate Vax and Encore versions.
 *    26 Oct 86 V1.0  Dirk Kalp
 *
 * Copyright (c) 1986, 1987, 1988, 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 ****************************************************************************/


#include "global.h"



/* Exported routines:
 *    void  ops_do_loadwm(infile)
 *    void  ops_do_make()
 *    void  yyerror(str)
 *    void  ops_tab_att(str)
 *    void  ops_tab_num(n)
 *    void  ops_wme_num(n)
 *    void  ops_wme_atom(str)
 *
 */



/* Imported Routines:
 *    From utility.c:
 *       ops_malloc
 *       ops_fatal
 *       ops_warn
 *
 *    From gensymbol.c:
 *       ops_symname_lookup
 *       ops_new_symbol
 *
 *    From rhsrtn.c:
 *       ops_value
 *       ops_settab
 *       ops_bmake
 *       ops_emake
 *       ops_emptytarget
 */



/* External Routines:
 *    These routines from other modules return values other than the
 *    standard integer and so their return types are declared here
 *    for routines in this module that call them.
 */
extern symptr   ops_symname_lookup();     /* Imported from gensymbol.c. */
extern symptr   ops_new_symbol();         /* Imported from gensymbol.c. */
extern char    *ops_malloc();             /* Imported from utility.c. */
extern void     ops_fatal();              /* Imported from utility.c. */
extern void     ops_warn();               /* Imported from utility.c. */
extern boolean  ops_emptytarget();        /* Imported from rhsrtn.c. */
extern void     ops_value();              /* Imported from rhsrtn.c. */
extern void     ops_settab();             /* Imported from rhsrtn.c. */
extern void     ops_bmake();              /* Imported from rhsrtn.c. */
extern void     ops_emake();              /* Imported from rhsrtn.c. */


/* Forward Declarations:
 *    These routines return values other than the standard integer and
 *    their return types are given here for other routines in this module
 *    that call them before they are defined.
 */
/* There are none! */

   

void
ops_do_loadwm(infile)
   string infile;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    Process a file holding wme MAKEs. Parse the file of MAKEs, build the
 *    wmes, and add them to working memory.
 *
 * Parameters:
 *    infile - the file containing the MAKEs.
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    yyparse in y.tab.c.
 *    ops_fatal in utility.c.
 *
 * Called by:
 *    "ops_main" in "rhsrtn.c".
 *
 *-------------------------------------------------------------------------*/
{
   yyin = fopen(infile, "r");
   if (yyin == NULL)
     {
      fprintf(fp_err, "* File %s not found.\n", infile);
      return;
     }

   MakeInputLineNum = 0;
   if (yyparse())
     {
      fprintf(fp_err, "** Error parsing make input file at line number %d.\n", MakeInputLineNum);
      ops_fatal("Exitting program on parsing error.\n");
     }
}

void
ops_do_make()
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    Process the rhs_term_list for a top level MAKE and add the wme to
 *    working memory.
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Interacting with user at top level cmd interface.
 *
 * Calls:
 *    yyparse in y.tab.c.
 *    ops_fatal in utility.c.
 *
 * Called by:
 *    "ops_main" in "rhsrtn.c".
 *
 *-------------------------------------------------------------------------*/
{
   yyin = stdin;

   ops_bmake();

   MakeInputLineNum = 0;
   if (yyparse())
     {
      fprintf(fp_err, "** Error parsing make input file at line number %d.\n", MakeInputLineNum);
     }

/*   if (ops_emptytarget())
      fprintf(fp_err, "Empty pattern for MAKE. MAKE ignored!\n");
   else
*/
      ops_emake();
}


void
yyerror(str)
   string str;

{
   fprintf(fp_err, "** Lex error in make input file at line number %d.\n", MakeInputLineNum);
   fprintf(fp_err, "** String is %s\n", str);
   ops_fatal("Exitting program on lex error.\n");
}

void
ops_tab_att(str)
    string str;
{
   symptr psym;

   psym = ops_symname_lookup(str);
   if ((psym == NULL) || (psym->OpsBind == INVALIDBINDING))
     {
      fprintf(fp_err, " Line number %d of make input file has an invalid att name: %s.\n ", MakeInputLineNum, str);
      ops_fatal("Exitting program.\n");
     }
   
   ops_settab(psym->OpsBind);
}


void
ops_tab_num(n)
   int n;
{
   if ((n < WMEMINNDX) || (n > WMEMAXNDX))
     {
      fprintf(fp_err, " Line number %d of make input file has out of range att index: %d.\n ", MakeInputLineNum, n);
      ops_warn("Ignoring illegal value after '^'.\n"); 
     }
   
   ops_settab(n);
}


void
ops_wme_num(n)
   int n;
{
   ops_value(int2val(n));
}


void
ops_wme_atom(str)
   string str;    /* string in yacc value stack */

{
   symptr psym;
   string s;

   psym = ops_symname_lookup(str);

   if (psym == NULL)
     {
      /* Allocate permanent storage for the symbol name and
       * copy the str from the yacc value stack. Then enter
       * the symbol in the symbol table.
       */
      s = (string) ops_malloc(strlen(str) + 1);
      strcpy(s, str);

      psym = ops_new_symbol(s);
     }

   ops_value(sym2val(psym->SymId));
}
