/****************************************************************************
 * 
 * MODULE:  user.c
 * 
 ****************************************************************************
 *
 * Abstract:
 *    This module contains the fake routine ops_user_init().  This enables
 *    users of ParaOPS5 to add their own specific command line switches
 *    (and actions) and process them with ops_user_init.  If the user maintains
 *    the ParaOPS5 binaries (from the rhs directory) in a library archive,
 *    he should define a ops_user_init routine and place it on the linker command
 *    line BEFORE the library archive. If the ParaOPS5 binaries are specified
 *    explicitly on the linker command line, then the user should modify this
 *    user.c module by inserting his own ops_user_init routine and recompile it.
 *
 *    Also added fake routine ops_user_exit() as an additional convenience to allow
 *    user program to specify actions (eg., closing files, connections, or
 *    whatever that he finds easier to do here) before the production system
 *    program exits. User can specify his own ops_user_exit() routine in a like
 *    manner as described above for ops_user_init().
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    10 Aug 89 V4.0  Dirk Kalp
 *                    Merged with ParaOPS5 4.3.
 *    12 May 89 V2.0  Dirk Kalp
 *                    Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    25 Jun 89 V4.3  Dirk Kalp
 *                    Change global routine names to have "ops_" prefix. This
 *                    is to prevent conflicts with system and user defined
 *                    names at link time.
 *    19 Apr 88 V4.2  Wilson Harvey and Dirk Kalp
 *                    Added ops_user_exit routine.
 *    14 Feb 88 V4.1  Wilson Harvey and Dirk Kalp
 *                    Created.
 *
 * Copyright (c) 1986, 1987, 1988, 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 ****************************************************************************/


#include "global.h"   /* This include file is not necessarily required. */



/* Exported routines:
 *    void     ops_user_init(u_argc, u_argv)
 *    void     ops_user_exit()
 */



void
ops_user_init(u_argc, u_argv)
   int  u_argc;
   char *u_argv[];
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    This routine is called at initialization time to permit the user to
 *    perform some application-specific initialization. Arguments from the
 *    user's command line can be passed using the "--" switch. All command
 *    line arguments that appear after the "--" switch are paseed to
 *    ops_user_init.
 *
 *    For example,
 *        mab -p2 -w1 -- foo 99
 *    results in the 2 args, "foo" and "99", being passed to ops_user_init
 *    after the system has processed the args, "-p2" and "-w1".
 *
 *    Note that the "--" switch is also recognized in an argument file.
 *    Thus, for example, if file "argfile" contains
 *        -p2 -w1 -- foo 99
 *    then using the "-f" switch to supply the argument file with
 *        mab -fargfile
 *    has the same effect as above.
 *
 *    Note here, however, that the "--" switch applies only within the
 *    argument file and not to any other arguments on the original
 *    command line. Thus, in the example,
 *        mab -fargfile -d -c
 *    the system processes the "-d" and "-c" args.  Ops_user_init processes
 *    only the "foo" and "99" args.
 *
 * Parameters:
 *    u_argc - the number of command line args passed.
 *    u_argv - an array of pointers to the command line arg character strings.
 *
 * Environment:
 *    The ParaOPS5 environment is being initialized with processing of switch
 *    arguments from the command line. Up to this point, only some global
 *    parameters have been initialized. The production system cycle has not
 *    been initialized and the production system data structures, such
 *    as working memory, conflict set, token memories, task queues, and run-
 *    time symbol table, have not been allocated and initialized.
 *
 * Returns:
 *    Nothing.
 *
 * Calls:
 *    As determined by user.
 *
 * Called by:
 *    "ops_rt_init" in "rhsrtn.c".
 *
 *-------------------------------------------------------------------------*/
{
  /* this space intentionally left blank */
}



void
ops_user_exit()
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    This routine is called to perform application-specific termination
 *    for the user before the program exits.
 *
 * Parameters:
 *    None.
 *
 * Environment:
 *    The ParaOPS5 program has completed or stopped and is just about to
 *    exit. Any match processes created at the start have been killed.
 *
 * Returns:
 *    Nothing.
 *
 * Calls:
 *    As determined by user.
 *
 * Called by:
 *    "kill_processes" in "rhsrtn.c".
 *
 *-------------------------------------------------------------------------*/
{
  /* this space intentionally left blank */
}

