%{

/****************************************************************************
 *
 * MODULE:  make.yacc
 *
 ****************************************************************************
 *
 * Abstract:
 *    Provides specifications to YACC for the parser.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    10 Aug 89 V4.0  Dirk Kalp
 *                    Merged with ParaOPS5 4.3.
 *    12 May 89 V2.0  Dirk Kalp
 *                    Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    25 Jun 89 V4.3  Dirk Kalp
 *                    Change global routine names to have "ops_" prefix. This
 *                    is to prevent conflicts with system and user defined
 *                    names at link time.
 *    24 Oct 88 V4.0  Dirk Kalp
 *                    Release of ParaOPS5 Version 4.0.
 *    23 Sep 88 V3.1  Anurag Acharya
 *
 *			Modified to make it jell together with the changes in
 *			make.lex. The yacc tables shrunk to one-fifth the size
 *			as a result. 
 *			Details:
 *			  * merged CSATOM and ANYATOM into ATOM
 *			  * merged ANYNUMBER and FIXNUM into FIXNUM
 *			  * simplified the spec for "atomic_value"
 *
 *    13 Aug 88 V3.0  Dirk Kalp
 *    25 May 88 V2.0  Dirk Kalp
 *                    Updated to consolidate Vax and Encore versions.
 *                    Added this module header.     
 *
 * Copyright (c) 1986, 1987, 1988, 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 *
 ****************************************************************************/

#include "global.h"

/* External Routines:
 *    These routines from other modules return values other than the
 *    standard integer and so their return types are declared here
 *    for routines in this module that call them.
 */
extern void    ops_bmake();            /* Imported from rhsrtn.c. */
extern void    ops_emake();            /* Imported from rhsrtn.c. */
extern void    ops_tab_att();          /* Imported from wminput.c. */
extern void    ops_tab_num();          /* Imported from wminput.c. */
extern void    ops_wme_num();          /* Imported from wminput.c. */
extern void    ops_wme_atom();         /* Imported from wminput.c. */

%}
%union {
    int ival;
    char cval;
    string128 sval;
}
%token <ival> MAKE
%token <ival> FIXNUM
%token <sval> ATOM
%type  <cval> '(', ')', '^'
%start make_input
%%
make_input              :    /* empty */
                        |    make_input make_action
			;

                        ;
make_action             :    '('  MAKE  {ops_bmake();}  wme_term_list  {ops_emake();} ')'
                        ;

wme_term_list           :    /* empty */
                        |    wme_term_list wme_term
			;

wme_term                :    '^'  ATOM   {ops_tab_att($2);}  atomic_value
                        |    '^'  FIXNUM   {ops_tab_num($2);}  atomic_value
			|    atomic_value
			;

atomic_value            :    ATOM         {ops_wme_atom($1);}
			|    FIXNUM         {ops_wme_num($1);}
			;

