
#/****************************************************************************
# *
# * MODULE:  ENCORE_locks.s
# *
# ****************************************************************************
# *
# * Abstract:
# *    ENCORE assembly coded routines for lock operations defined in psm_locks.h.
# *
# ****************************************************************************
# *
# * CParaOPS5
# * Change Log:
# *    10 Aug 89 V4.0  Dirk Kalp
# *                    Update for CParaOPS5 Version 4.0 P4.3.
# *    15 May 89 V3.0  Dirk Kalp
# *                    Create for CParaOPS5 Version 3.0 P4.2.
# *
# * Copyright (c) 1986, 1987, 1988, 1989 Carnegie-Mellon University
# * All rights reserved.  The CMU software License Agreement
# * specifies the terms and conditions for use and redistribution.
# *
# ****************************************************************************/




#/*--------------------------------------------------------------------------
# *
# *	ENCORE_Test_Then_Lock(lockptr)
# *         LockPtr lockptr;
# *      {
# *         ENCORE assembly code
# *      }
# *--------------------------------------------------------------------------*/
	.globl	_ENCORE_Test_Then_Lock
_ENCORE_Test_Then_Lock:
LC:	cmpqb	$0, 0(4(sp))			#/* memory ref in cache */
	bne	LC
	sbitib	$0, 0(4(sp))			#/* memory ref on bus */
	bfs	LC
	ret	$0


#/*--------------------------------------------------------------------------
# *
# *	ENCORE_Release(lockptr)
# *         LockPtr lockptr;
# *      {
# *         ENCORE assembly code
# *      }
# *--------------------------------------------------------------------------*/
	.globl	_ENCORE_Release
_ENCORE_Release:
	movqb	$0, 0(4(sp))
	ret	$0


#/*--------------------------------------------------------------------------
# *
# *	ENCORE_Lock(lockptr)
# *         LockPtr lockptr;
# *      {
# *         ENCORE assembly code
# *      }
# *--------------------------------------------------------------------------*/
	.globl	_ENCORE_Lock
_ENCORE_Lock:
LB:	sbitib	$0, 0(4(sp))			#/* memory ref on bus */
	bfs	LB
	ret	$0





#/*--------------------------------------------------------------------------
# *
# *	ENCORE_LA_LR_RW_HT(bucket)
# *         int bucket;
# *      {
# *         ENCORE assembly code
# *      }
# *--------------------------------------------------------------------------*/
	.globl	_ENCORE_LA_LR_RW_HT
_ENCORE_LA_LR_RW_HT:
	movd	4(sp), r0			#/* r0 = bucket index */
	addr	0(_tokHTlock)[r0:b], r1		#/* r1 = addr of lock */
	addr	0(_LeftRightCounter)[r0:d], r0	#/* r0 = addr of counters */

	#/* Test counters to see if in correct state.  We test and spin here */
	#/* rather than lock first in order to avoid going out of the cache. */
L1:	cmpw	0(r0), $0			#/* RightCount == 0 ? (need write access) */
	bne	L1				#/* loop if not */
	cmpw	2(r0), $0			#/* LeftCount >= 0 ? (need read access) */
	blt	L1				#/* loop if not */

	#/* Counters look OK, but have to check them under lock. */
L2:	cmpqb	$0, 0(r1)			#/* Test_Then_Lock(tokHTlock[bucket]) */
	bne	L2
	sbitib	$0, 0(r1)
	bfs	L2

	cmpw	0(r0), $0			#/* RightCount == 0 ? (need write access) */
	bne	L3				#/* abort if not */
	cmpw	2(r0), $0			#/* LeftCount >= 0 ? (need read access) */
	blt	L3				#/* abort if not */

	#/* State OK, so set Right for write access and Left for read access. */
	movqw	$-1, 0(r0)			#/* RightCount = -1 */
	addqw	$1, 2(r0)			#/* LeftCount++ */

	movqb	$0, 0(r1)			#/* Release(tokHTlock[bucket]) */
	ret	$0

L3:	movqb	$0, 0(r1)			#/* Release(tokHTlock[bucket]) */
	br	L1				#/* go try again */


#/*--------------------------------------------------------------------------
# *
# *	ENCORE_Rel_LR_HT(bucket)
# *         int bucket;
# *      {
# *         ENCORE assembly code
# *      }
# *--------------------------------------------------------------------------*/
	.globl	_ENCORE_Rel_LR_HT
_ENCORE_Rel_LR_HT:
	movd	4(sp), r0			#/* r0 = bucket index */
	addr	0(_tokHTlock)[r0:b], r1		#/* r1 = addr of lock */
	addr	0(_LeftRightCounter)[r0:d], r0	#/* r0 = addr of counters */

L4:	cmpqb	$0, 0(r1)			#/* Test_Then_Lock(tokHTlock[bucket]) */
	bne	L4
	sbitib	$0, 0(r1)
	bfs	L4

	addqw	$-1, 2(r0)			#/* LeftCount-- */

	movqb	$0, 0(r1)			#/* Release(tokHTlock[bucket]) */
	ret	$0


#/*--------------------------------------------------------------------------
# *
# *	ENCORE_Rel_RW_HT(bucket)
# *         int bucket;
# *      {
# *         ENCORE assembly code
# *      }
# *--------------------------------------------------------------------------*/
	.globl	_ENCORE_Rel_RW_HT
_ENCORE_Rel_RW_HT:
	movd	4(sp), r0			#/* r0 = bucket index */
	movqw	$0, 0(_LeftRightCounter)[r0:d]	#/* RightCount = 0 */
	ret	$0





#/*--------------------------------------------------------------------------
# *
# *	ENCORE_LA_LW_RR_HT(bucket)
# *         int bucket;
# *      {
# *         ENCORE assembly code
# *      }
# *--------------------------------------------------------------------------*/
	.globl	_ENCORE_LA_LW_RR_HT
_ENCORE_LA_LW_RR_HT:
	movd	4(sp), r0			#/* r0 = bucket index */
	addr	0(_tokHTlock)[r0:b], r1		#/* r1 = addr of lock */
	addr	0(_LeftRightCounter)[r0:d], r0	#/* r0 = addr of counters */

	#/* Test counters to see if in correct state.  We test and spin here */
	#/* rather than lock first in order to avoid going out of the cache. */
L5:	cmpw	2(r0), $0			#/* LeftCount == 0 ? (need write access) */
	bne	L5				#/* loop if not */
	cmpw	0(r0), $0			#/* RighttCount >= 0 ? (need read access) */
	blt	L5				#/* loop if not */

	#/* Counters look OK, but have to check them under lock. */
L6:	cmpqb	$0, 0(r1)			#/* Test_Then_Lock(tokHTlock[bucket]) */
	bne	L6
	sbitib	$0, 0(r1)
	bfs	L6

	cmpw	2(r0), $0			#/* LefttCount == 0 ? (need write access) */
	bne	L7				#/* abort if not */
	cmpw	0(r0), $0			#/* RightCount >= 0 ? (need read access) */
	blt	L7				#/* abort if not */

	#/* State OK, so set Right for write access and Left for read access. */
	movqw	$-1, 2(r0)			#/* LeftCount = -1 */
	addqw	$1, 0(r0)			#/* RightCount++ */

	movqb	$0, 0(r1)			#/* Release(tokHTlock[bucket]) */
	ret	$0

L7:	movqb	$0, 0(r1)			#/* Release(tokHTlock[bucket]) */
	br	L5				#/* go try again */


#/*--------------------------------------------------------------------------
# *
# *	ENCORE_Rel_RR_HT(bucket)
# *         int bucket;
# *      {
# *         ENCORE assembly code
# *      }
# *--------------------------------------------------------------------------*/
	.globl	_ENCORE_Rel_RR_HT
_ENCORE_Rel_RR_HT:
	movd	4(sp), r0			#/* r0 = bucket index */
	addr	0(_tokHTlock)[r0:b], r1		#/* r1 = addr of lock */
	addr	0(_LeftRightCounter)[r0:d], r0	#/* r0 = addr of counters */

L8:	cmpqb	$0, 0(r1)			#/* Test_Then_Lock(tokHTlock[bucket]) */
	bne	L8
	sbitib	$0, 0(r1)
	bfs	L8

	addqw	$-1, 0(r0)			#/* RightCount-- */

	movqb	$0, 0(r1)			#/* Release(tokHTlock[bucket]) */
	ret	$0


#/*--------------------------------------------------------------------------
# *
# *	ENCORE_Rel_LW_HT(bucket)
# *         int bucket;
# *      {
# *         ENCORE assembly code
# *      }
# *--------------------------------------------------------------------------*/
	.globl	_ENCORE_Rel_LW_HT
_ENCORE_Rel_LW_HT:
	movd	4(sp), r0			#/* r0 = bucket index */
	movqw	$0, 2(_LeftRightCounter)[r0:d]	#/* LeftCount = 0 */
	ret	$0






