
/****************************************************************************
 *
 * MODULE:  ops5.c
 *
 ****************************************************************************
 *
 * Abstract:
 *    This module contains the "main" program.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    29 Sep 89 V5.3 Dirk Kalp
 *                   Update version to "CParaOPS5 Compiler Version 5.3 P4.4".
 *                   Bug fixes, etc. to CParaOPS5 in ../rhs and also incorporate
 *                   ParaOPS5 4.4.
 *    29 Sep 89 V5.2 Anurag Acharya
 *                   Modified the mechanism by which output files are generated
 *                   Instead of using a temporary file as the eventual 
 *                   output file, it now uses explicit output files. The 
 *                   temporary files subfile and rootfile (for the subroutines
 *                   and the alpha-test code respectively) are erased 
 *                   everytime a new output file is generated. On the other
 *                   hand, inclfile (for stuff to be included in all output 
 *                   files) is written to in the append mode.
 *                   The input file name's first tag (the sequence of chars
 *                   till the first '.') is taken as the base filename and
 *                   all other file names are generated by appending 
 *                   appropriate extensions. 
 *                   Modified the way in which the new file names are
 *                   generated -- uses sprintf instead of the routine
 *                   ofile_name(). Deleted "ofile_name()" since it became
 *                   redundant.
 *                   Replaced calls to "opserror" in "cat_ofiles" and 
 *                   "create_new_ofile()" by calls to printf -- this allowed
 *                   me to print better diagnostics.
 *    30 Aug 89 V5.1 Anurag Acharya
 *                   Fixed bug that caused problems with external routines
 *                   Now the names of the external routines are included
 *                   at the top and are available to be used in intializations.
 *    25 Jun 89 V4.0 Dirk Kalp
 *                   Update with ParaOPS5 4.3.
 *    12 May 89 V2.0 Dirk Kalp
 *                   Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    29 Sep 89 V4.4  Dirk Kalp
 *                    Update version number to 4.4 for compiler fix in
 *                    "cmplhs.c" for multiple output files and for bug
 *                    fix made in ../rhs/rhsrtn.c.
 *    25 Jun 89 V4.3  Dirk Kalp
 *                    Changed version number to 4.3.
 *                    Fixed comment in cmplhs.c to clear up "bind" bug.
 *                    Change all compiler generated routine names to have
 *                    "ops_" prefix. This is to ensure no conflicts with
 *                    system or user routine names when user programs are
 *                    linked. Affected cmplhs.c, gencode.c, ops5.yacc.
 *    19 Apr 89 V4.2  Dirk Kalp
 *                    Changed version number to 4.2 for "default" fix in
 *                    "ops5.yacc" and changes to "gencode.c" for quoted symbols.
 *    14 Feb 89 V4.1  Dirk Kalp
 *                    Added support for standard OPS5 print format for wmes.
 *                    Fixed bug in ExternalList at end of assembly file.
 *    24 Oct 88 V4.0  Dirk Kalp
 *                    Release of ParaOPS5 Version 4.0.
 *     1 Oct 88 V3.1  Dirk Kalp
 *                    Set g_max_rules_in_rete to be a very large number so
 *                    that compiling all productions to a single output file
 *                    is the default.
 *    13 Aug 88 V3.0  Dirk Kalp
 *                    Increase g_max_rules_in_rete from 100 to 200.
 *    25 May 88 V2.0  Dirk Kalp
 *                    Updated to consolidate Vax and Encore versions.
 *    17 Sep 86       Dirk Kalp
 *    15 Sep 86       Dirk Kalp
 *     1 May 86
 *    29 Apr 86 V1.0  Dirk Kalp
 *                    Put together from previous version created by
 *                    Quei-Len Lee.
 *
 * Copyright (c) 1986, 1987, 1988, 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 ****************************************************************************/

 
   
#include "defs.h"
#include <sys/file.h>

string  ParaOPS5_Version = "CParaOPS5 Compiler Version 5.3 P4.4";


#define LITERALIZE_VAL 		0
#define LITERAL_VAL		1
#define EXTERNAL_VAL		2
#define VECTOR_ATTRIBUTE_VAL	3
#define PRODUCTION_VAL		4

char *toptypes[] = { "literalize",
		     "literal",
		     "external",
		     "vector_attribute",
		     "production",
		     ""
		     };




/* Imported Routines:
 *    From system:
 *       fopen
 *       exit
 *       malloc
 *
 *    From y.tab.c:
 *       yyparse
 *
 *    From literal.c:
 *       init_decl
 *       strlength
 *
 *    From cmplhs.c:
 *       init_cmp
 *
 *    From gencode.c:
 *       leave_main
 *
 *    From printops.c:
 *       write_symtab
 *       write_net
 */

/* External Routines:
 *    These routines from other modules return values other than the
 *    standard integer and so their return types are declared here
 *    for routines in this module that call them.
 */
/* There are none. */



/* Forward Declarations:
 *    These routines return values other than the standard integer and
 *    their return types are given here for other routines in this module
 *    that call them before they are defined.
 */
/* There are none! */


boolean is_int();   /* declaration */

static char *infile, *outfile;

static char *subfile, *rootfile, *inclfile;

static str_arr basefilename;

extern char yytext[];   /* used for printing the error token */

extern int topleveltype;
extern char *prodname;



main(argc, argv)
   int  argc;
   char *argv[];
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    The "C" "main" program.
 *
 * Parameters:
 *    argc - the count of the arguments on the command line.
 *    argv - an array holding the arguments from the command line..
 *
 * Environment:
 *    Program entry point.
 *
 * Calls:
 *    "opserror", "puteol", and "ofile_name" in this module.
 *    "yyparse" in "y.tab.c".
 *    "leave_main" in "gencode.c".
 *    "strlength" in "literal.c".
 *    "write_symtab" and "write_net" in "printops.c".
 *    "fopen", "malloc", and "exit" in system.
 *
 *-------------------------------------------------------------------------*/
{
   int i; /* loop control variable */

   printf("%s\n", ParaOPS5_Version);

   if (argc == 1) { yyin = stdin;  infile =0; }
   

   debug = debugnet = 0;
   g_max_rules_in_rete = 999999;    /* A big number. */
   while ((--argc > 0) && ((*++argv)[0] == '-'))
      {
	switch(argv[0][1])
	{
	  case 'd': if (argv[0][2] == 'n') debugnet = 1;
	  	    else debug = 1;
		    printf("*** Debugging On ***\n");
		    break;
	  case 'n': if (is_int(&(argv[0][2])))
	  	      g_max_rules_in_rete = atoi(&(argv[0][2]));
		    break;
	  default:  printf("Ignoring unknown flag '%c'. \n", argv[0][1]);
	  	    break;
        }
      }
     
   if (argc > 0) infile = argv[0];		    

   if (infile == NULL)  exit(0);

   /* open input file for reading */

   if ((yyin = fopen(infile, "r")) == NULL)
     {
      fprintf(stderr, "Can't open %s\n", infile);
      exit(1);
     }

   /* delete the extension from the input file name to generate the basefile name */

 
   for (i = strlength(infile); i >= 0 && infile[i] != '.'; i--);
   
   if (infile[i] == '.') infile[i] = '\0';

   /* infile now contains the basefile name. all other names are generated by 
    * appending extensions to it, as appropriate.
    */

   if ((outfile = (string)malloc(10+strlength(infile))) == NULL)
     {
      opserror("main:  no more memory...");  puteol();
      exit(1);
     }
     
   /* generate  output file name */

    sprintf(outfile,"%s.c",infile);


   codeout = NULL; 

   /* alloc space for names of the different temporary files */
   if ((rootfile = (string)malloc(10+strlength(infile))) == NULL)
     {
      opserror("main:  no more memory...");  puteol();
      exit(1);
     }
   if ((subfile = (string)malloc(10+strlength(infile))) == NULL)
     {
      opserror("main:  no more memory...");  puteol();
      exit(1);
     }
   if ((inclfile = (string)malloc(10+strlength(infile))) == NULL)
     {
      opserror("main:  no more memory...");  puteol();
      exit(1);
     }

   /* generate names of the temporary files */
   sprintf(rootfile,"%s.root",infile);
   sprintf(subfile,"%s.sub",infile);
   sprintf(inclfile,"%s.incl",infile);

   /* open the temoprary files needed */

   if ((fp_root = fopen(rootfile, "w")) == NULL)
       {
       printf("Unable to open temporary file %s in the current directory\n",rootfile);
       bomb_out();
   }

  if ((fp_sub = fopen(subfile, "w")) == NULL)
       {
       printf("Unable to open temporary file %s in the current directory\n",subfile);
       bomb_out();
   }  

  if ((fp_incl = fopen(inclfile, "w")) == NULL)
       {
       printf("Unable to open temporary file %s in the current directory\n",inclfile);
       bomb_out();
   }

   init();
   
   if (yyparse())
     {
      opserror("Error in parse at source line number ");
      printf("%d.\nError occurred in a %s declaration ",SourceLineNum,
	                                               toptypes[topleveltype]);
      if ( topleveltype == PRODUCTION_VAL )
	  printf("( %s )\n",prodname);
      else printf("\n");
      printf("The erring token was \"%s\"\n",yytext);
      printf("\n\n");
      bomb_out();
     }

   if (csw.errcnt == 0)
     {
      leave_main();
      if (debug)  write_symtab();
      if (debugnet)  write_net();
      puteol();
      print_lhs_stats();
      exit(0);
     }
   else
      bomb_out();


}



init()
{
   init_decl();
   init_cmp();
   csw.errcnt     = 0;
   csw.flag_error = FALSE;
   csw.warncnt    = 0;
   csw.flag_warn  = FALSE;
   SourceLineNum  = 1;
}



create_new_ofile()
{
   char num[8];
   char *ptr;
   int fd_sub, fd_root, fd_incl, fd_out;
   int n;
   char buf[2048];
   FILE *fp_out;

   /* First close the output files. Then reopen them so we can use
    * calls to system IO routines to copy the temporary files to the 
    * output file.
    */
   printf("\n...writing output file %s\n", outfile);

   fclose(fp_sub);
   fclose(fp_root);
   fclose(fp_incl);

   fd_incl = open(inclfile,O_RDONLY, NULL);
   fd_sub = open(subfile, O_RDONLY, NULL);
   fd_root = open(rootfile, O_RDONLY, NULL);

    /* open output file, creating if, necessary, with read/write permissions */
    /* warning! gross hack ahead -- couldn't get open to create the file 
     * in a decent way. therefore, fopen, fclose and then fopen
     */
   fp_out = fopen(outfile, "w");
   fclose(fp_out);
   fd_out = open(outfile, O_WRONLY);


    /* copy the three temporary files into the output file */

   while ((n = read(fd_incl, buf, 2048)) > 0)
     {
      if (n == -1)  
	{
	  printf("IO read error on temporary file :%s\n",inclfile); 
	  bomb_out();
	}
      if (write(fd_out, buf, n) != n)  
      {	
	  printf("IO write error on output file : %s\n",outfile);
	  bomb_out();
      }
     }
   while ((n = read(fd_sub, buf, 2048)) > 0)
     {
      if (n == -1)  
	{
	  printf("IO read error on temporary file : %s\n",subfile); 
	  bomb_out();
	}
      if (write(fd_out, buf, n) != n)  
      {
	  printf("IO write error on output file : %s\n", outfile); 
	  bomb_out();
      }
     }
   while ((n = read(fd_root, buf, 2048)) > 0)
     {
      if (n == -1)  
	{
	  printf("IO read error on temporary file : %s\n", rootfile); 
	  bomb_out();
	}
      if (write(fd_out, buf, n) != n)  
      {
	  printf("IO write error on output file : %s\n",rootfile); 
	  bomb_out();
      }
     }

   /* close all the files */
   close(fd_incl);
   close(fd_sub);
   close(fd_root);
   close(fd_out);

   /* create a new file name to be used for the next outfile. */

   sprintf(outfile,"%s%d.c",infile,g_num_rete_roots);

   /* reopen the temporary files for further code generation */
   /* the include file is opened for appending -- the other two 
    * are zeroed and opened for writing
    */
   fp_sub  = fopen(subfile, "w"); 
   fp_root = fopen(rootfile, "w"); 
   fp_incl = fopen(inclfile, "a");  

}

 /*************************************************************************************
  * cat_ofiles() : Used only for the last set of ofiles (or the only set if we don't 
  * use multiple files.
  *
  * Called by write_data() in gencode.c
   *********************************************************************************/

cat_ofiles()  
{
   int fd_sub, fd_root, fd_incl, fd_out;
   int n;          /* buffer length */
   char buf[2048]; /* temp buffer to copy files */
   FILE *fp_out;

   /* First close the output files. Then reopen them so we can use
    * calls to system IO routines to cat the root file to the sub file.
    */
   printf("\n...writing output file %s\n", outfile);

   fclose(fp_sub);
   fclose(fp_root);
   fclose(fp_incl);

   fd_sub = open(subfile, O_RDONLY, NULL);
   fd_root = open(rootfile, O_RDONLY, NULL);
   fd_incl = open(inclfile, O_RDONLY, NULL);

   /* open the output file to write ( create if necessary ) */
   /* gross hack -- somehow couldn't get open to create files with the
    * with the right mode 
    */
   fp_out = fopen(outfile,"w");
   fclose(fp_out);
   fd_out = open(outfile, O_WRONLY);
 
   while ((n = read(fd_incl, buf, 2048)) > 0)
     {
      if (n == -1)  
	{
	  printf("IO read error on temporary file : %s\n", inclfile); 
	  bomb_out();
	}
      if (write(fd_out, buf, n) != n)  
      {
	  printf("IO write error on output file : %s\n", inclfile); 
	  bomb_out();
      }
     }

   while ((n = read(fd_sub, buf, 2048)) > 0)
     {
      if (n == -1)  
	{
	  printf("IO read error on temporary file : %s\n", subfile); 
	  bomb_out();
	}
      if (write(fd_out, buf, n) != n)  
      {
	  printf("IO write error on output file : %s\n", subfile); 
	  bomb_out();
      }
     }

   while ((n = read(fd_root, buf, 2048)) > 0)
     {
      if (n == -1)  
	{
	  printf("IO read error on temporary file : %s\n", rootfile); 
	  bomb_out();
	}
      if (write(fd_out, buf, n) != n)  
      {
	  printf("IO write error on output file : %s\n", outfile); 
	  bomb_out();
      }
     }

   /* close all files */
   close(fd_incl);
   close(fd_sub);
   close(fd_root);
   close(fd_root);

   /* Now reopen the same output file so we can finish writing out
    * the rest of the global data in gencode.c.
  
   if (( fp_sub = fopen(outfile, "a")) == NULL)
       {
         printf("Unable to open output file : %s\n",outfile);
	 bomb_out();
	 }

     /* wipe out the temporary files */
   unlink(rootfile);  
   unlink(subfile);
   unlink(inclfile);
}


boolean
is_int(str)
   char str[];
{
   int i;

   if ((str[0] == '+') || (str[0] == '-'))
     {
      if (str[1] != '\0')
         i = 1; 
      else
         return(FALSE);
     }
   else
      i = 0;

   while (str[i] != '\0')
      if ((str[i] < '0') || (str[i] > '9'))
         return(FALSE);
      else
         i++;

   return(TRUE);
}




yyerror(s)
   char *s;
{
   /* Just a dummy for YACC? */
}



bomb_out()
{
   /* Add code to destroy code output file here. Also implement cmd
    * line switch to override that for debugging.
    */

   /* For now, just exit.
    */
   exit(1);
}



opserror(errmsg)
   string errmsg;
{
   csw.flag_error = TRUE;
   csw.errcnt++;
   printf("\n%s", errmsg);  fflush(stdout);
}



opswarn(warnmsg)
   string warnmsg;
{
   csw.flag_warn = TRUE;
   csw.warncnt++;
   fprintf(stderr,"\n%s", warnmsg);  fflush(stdout);
}



putstring(s)
   string s;
{
   printf("%s", s);  fflush(stdout);
}



putstrarr(s)
  char s[];
{
    printf("%s",&s[0]);  fflush(stdout);
}


putint(num)
   int num;
{
   printf("%d", num);  fflush(stdout);
}



puttab()
{
   printf("\t");  fflush(stdout);
}



puteol()
{
   printf("\n");  fflush(stdout);
}

