;;; TAQL Compiler, Version Module
;;;
;;; Gregg Yost, Erik Altmann
;;; School of Computer Science
;;; Carnegie Mellon University
;;;
;;; Working file: /afs/cs.cmu.edu/user/altmann/taql/taql-version.lisp
;;; Created September 28, 1990
;;;
;;; This file contains the constants that define TAQL version information,
;;; and the main functions that report that information.
;;; *taql-date-created* should be updated every time any of the TAQL files
;;; change.
;;;
;;; Known bugs/funnies:
;;; 
;;; =======================================================================
;;; Modification history:
;;; =======================================================================
;;;
;;; 7-15-91 - gry - Updated for TAQL 3.1.4 external release
;;;
;;; 6-14-91 - gry - Updated for TAQL 3.1.4 internal release
;;;
;;; 1-6-91 - gry - Updated for TAQL 3.1.3 external release
;;;
;;; 9-28-90 - gry - Created
;;;    Moved from taql-compiler.lisp so that we don't have to recompile
;;;    taql-compiler every time we want to update version information.

;;; *** BEGIN CODE ***

(eval-when (compile load eval)
  (lispsyntax))

(eval-when (compile load eval)
   (if (find-package "COMMON-LISP-USER")
       (in-package "COMMON-LISP-USER")
       (in-package "USER")))

(pushnew :taql *features*)
(pushnew :taql-3 *features*)
(pushnew :taql-3.1 *features*)
(pushnew :taql-3.1.4 *features*)

(defparameter *taql-date-created* "July 15, 1991" ; was: 14-jun-1991
  "The date at which this TAQL version was created.")
(defparameter *taql-version-number* 3 "The version number of this TAQL.")
(defparameter *taql-release-number* 1 "The release number of this TAQL.")
(defparameter *taql-minor-version* 4 "The minor version of this TAQL.")
(defparameter *taql-public-version* t "Is this a public release of TAQL.")

;; 2-5:
;; This prints out the TAQL version information.
;;
(defun taql-version ()
  (if *taql-public-version* 
      (format t "~%TAQL ~A.~A.~A~%" 
	  *taql-version-number* *taql-release-number* *taql-minor-version*)
      (format t "~%TAQL ~A.~A.~A (internal release)~%" 
	  *taql-version-number* *taql-release-number* *taql-minor-version*))
  (format t "Created ~A~%" *taql-date-created*))

(defun taql-greeting ()
  (terpri)
  (taql-version)
  (format t
    "~%Bug reports should be sent to Soar-bugs@cs.cmu.edu.~%")
  (format t
    "Send comments on TAQL to Gregg.Yost@cs.cmu.edu or Erik.Altmann@cs.cmu.edu.~2%")
  nil)

(eval-when (compile load eval)
  (soarsyntax))
