;;; TAQL Compiler, Initialization Module
;;;
;;; Gregg Yost, Erik Altmann
;;; School of Computer Science
;;; Carnegie Mellon University
;;;
;;; Working file: /afs/cs/user/altmann/soar/taql/space-model.lisp
;;; Created April 5, 1991
;;;
;;; This file implements the functions that initialize TAQL.  It must be
;;; loaded last.  Also, the function (init-taql) must be called by
;;; taql-restart-soar-extras.
;;;
;;; EXPORTED ROUTINES:
;;;
;;;    - init-taql
;;;
;;; Known bugs/funnies:
;;; 
;;; =======================================================================
;;; Modification history:
;;; =======================================================================
;;;
;;; 4-5-91 - gry - Created.

;;; *** BEGIN CODE ***

(eval-when (compile load eval)
  (lispsyntax))

(eval-when (compile load eval)
   (if (find-package "COMMON-LISP-USER")
       (in-package "COMMON-LISP-USER")
       (in-package "USER")))

;; Init-segment-stuff must be called before initializing the data and space
;; models.
;;
(defun init-taql ()
  (init-segment-stuff)
  (init-data-model-stuff)
  (init-space-model-stuff))

(eval-when (eval)
  (format
   *error-output*
   "~%You are loading the interpreted version of TAQL.  It will run very~
    ~%slowly.  You should compile TAQL (see the manual for details).~%"))

(eval-when (load eval)
  (init-taql))

(eval-when (compile load eval)
  (soarsyntax))
