%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (C)1992 Institute for New Generation Computer Technology %
% $BG[I[$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F2<$5$$(B          %
% ( Read COPYRIGHT for detailed information. )             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- public start/0,start/1.

starts(N) :-
	mk_exe(N,Goals),
	time(Goals).

start :-
	read(Sent),
	mk_exe(Sent,Goals),
	time(Goals),
	told.

start(File) :-
	see(File),
	repeat,
	read(Sent),
      ( Sent=end_of_file,
	   seen ;
	mk_exe(Sent,Goals),
	   time(Goals),fail ).

mk_exe(Sent,(Goals,Fin)) :-
	expand_term((dummy --> (Sent,fin)),
		    (dummy([begin(_,_)],_) :- Gs)),
	Gs = (Words,fin(Arg,_)),
	change(Words,Goals),
	Fin =.. [fin,Arg], !.

change((First,Tail),(Frsl,Trsl)) :-
	First =.. [Fword,A1,A2],
	Frsl =.. [Fword,A1,Fword,A2,_],!,
	change(Tail,Trsl).
change(Func,Rfunc) :-
	Func =.. [Word,A1,A2],
	Rfunc =.. [Word,A1,Word,A2,_],!.

fin([]) :- !.
fin([end(_,_,_,L)|Y]) :- !,
	display('parsed  '),
	print_LC_tree(L),
	fin(Y).
fin([_|Y]) :- !,
	fin(Y).


tp_ck([],_,[]) :- !.
tp_ck([Idn|Rest],Term,[Idn|Rest1]) :-
	functor(Idn,Id,_),
	id_pair(Id,Top_cat),
	link(Term,Top_cat),!,
	tp_ck(Rest,Term,Rest1).
tp_ck([_|Rest],Term,New_head) :- !,
	tp_ck(Rest,Term,New_head).

tp_out([],_,_,Y,Y) :- !.
tp_out([_|_],Y,Yt,Y,Yt).

