/*
 * FUNCTION      void  r_generic_rule(LEXENTRY *start, *next)
 *
 * PURPOSE       To combine a <start description> with a <next description>.
 * 
 * DECL          For all interpretations of both the start and the next word:
 *
 *               The selection specification of this rule says:
 *
 *
 *      	 The input condition of this rule says:
 *
 *
 *        	 The output specification of this rule says:
 * 
 *
 * INPUT         LEXENTRY  *start, *next    -    the current sentence start
 *               and (evaluated) next word.
 * 
 * OUTPUT        None.
 * 
 * PARENTS
 *  
 * SIDE EFFECTS  The passed start is changed. As with all rules and rule 
 *               packages, the control flow is altered.
 */

void
  r_generic_rule(start, next)
LEXENTRY    *start, *next;
{
  LEXENTRY  result;  /* local result, will be loaded into "start" */
  SURFACE   last_surface;
  int       index, s_seg_index, s_cat_index, r_cat_index = 1;
  int       n_cat_index, n_len, s_len, i;
  SEG       s_seg, n_seg;


  result.segments[0][0] = 0;

  /* 
   * start->segments[0][0] gets corrupted by the output spec, so we
   * set it outside its loop 
   */
  s_len = start->segments[0][0];

  /* Allow for each interpretation (categorization) of "start" */
  for (s_cat_index = 1; s_cat_index <= s_len; s_cat_index++)
    {
      /* condition(s) on start, setting s_seg */
      
      /* 
       * allow for each interpretation of "next", paying attention to the size 
       * of result.segments.
       */
      for (n_cat_index = 1; (n_cat_index <= next->segments[0][0]) && 
	   (r_cat_index < MAX_CATEGORIES); n_cat_index++)
	{
	  /* condition on next */
	  if (VALID)
	    {
	      /* central rule logic may proceed; set n_seg */

	      /* input spec */
	      if (VALID)
		{
		  /* denote success */
		  curr_condition = VALID;
		  history[curr_deriv].rules[0] += 1;
		  index = history[curr_deriv].rules[0];
		  history[curr_deriv].rules[index] =
		    GENERIC_RULE;

		  /* output spec */
		  copy_category(result.segments[r_cat_index],
				start->segments[s_cat_index]);

		  result.segments[r_cat_index][index] = s_seg;
		  result.segments[r_cat_index][0] = index;
		  result.segments[0][0] += 1;

		  /* 
		   * increment r_cat_index at end of successful rule 
		   * processing. Failures are not recorded.
		   */
		  r_cat_index += 1;

		  /* diagnostics follow */
		  printf("   Rule 'generic rule' combines meaning %d of phrase '%s' with meaning %d of word '%s'\n", s_cat_index, start->surface, n_cat_index, next->surface); 
		  if (r_cat_index == MAX_CATEGORIES)
		    {
		      printf("   The maximum number of interpretations has been reached, in rule 'determiner plus adj'. Start = '%s', next = '%s'.\n", 
			     start->surface, next->surface);
		    }
		}
	    }
	  else
	    {
	      fprintf(stderr, "    Rule 'generic rule' is throwing \
out meaning %d of next word %s, moves to start meaning %d.\n",
		      n_cat_index, next->surface, s_cat_index);
	    } 
	}
    }

  if ((--r_cat_index == 0) && (!backtracked))  /* there were no successes */
    {
      /* this is, of course, very wimpy */
      strcpy(error, "   Rule 'generic rule' has failed. You tried to follow the phrase '%s'");
      strcat(error, start->surface);
      strcat(error, "' with '");
      strcat(error, next->surface);
      strcat(error, "', which (reason for rule failure).");
    }
  
  else
    {
      /* load the result into start */
      for (index = 1; index <= r_cat_index; index++)
	copy_category(start->segments[index],
		      result.segments[index]);
      start->segments[0][0] = r_cat_index;
      
      /* remove redundancies */
      comb_definition(start->segments);
    }
  
} /* end: void r_generic_rule(LEXENTRY *start, *next) : finished template */
