/* $Revision: 1.1 $ */
/* hashtable functions */

#include  <errno.h>
#include  <stdio.h>
#include  <string.h>
#include  <ctype.h>
#include  <sys/types.h>
#include  <sys/stat.h>
#include  <sys/file.h>
#include  <malloc.h>
#include  <stuff.h>

#include  "hash.h"


/* extern char *malloc(); malloc.h prototypes it as extern void *malloc() */

/* create a hashtable with n buckets.  n should be a power of 2 */

extern hashtable *
NewHash(n)
  int n;
{
    hashtable *h;
    int s;

    h = (hashtable *) malloc(sizeof(hashtable));
    h->size = n;
    h->count = 0;
    s = sizeof(hashbucket *) * n;
    h->buf = (hashbucket **) malloc(s);
    if (h->buf == NULL)
      printf("Gah!\n");
    bzero(h->buf, s);
    return(h);
}

/* 
  look in the hashtable for the string "key", and return its associated
  data value (or NULL if not found) 
*/

extern char *
LookupHash(h, key)
  hashtable *h;
  char *key;
{
    int s;
    hashbucket *b;

    s = hash(key) & (h->size - 1); /* note h->size is power of 2 */
    b = h->buf[s];
    while (b) {
	if ( strcmp(b->key, key) == 0 )
	    return (b->data);
	b = b->next;
    }
    return (NULL);
}

/*
  insert the string "key" (make our own copy of it), and the associated
  "data" into the hashtable.  If buckets are "too full", then resize the
  hashtable first. 
*/

extern void
InsertHash(h, key, data)
  hashtable *h;
  char *key;
  char *data;
{
    int s,hv;
    hashbucket *b;
    void resize_hash();

    if (h->count*2 > h->size)
	resize_hash(h);
    
/* get a new bucket and fill the elements */
    b = (hashbucket *) malloc(sizeof(hashbucket));
    hv = b->hashval = hash(key);
    s = hv & (h->size - 1);
    strcpy(b->key = malloc(strlen(key)+1), key);
    b->hashval = hv;
    strcpy(b->data = malloc(strlen(data)+1), data);
    b->next = h->buf[s];
    h->buf[s] = b;
    h->count++;
}


void
FreeHash(h)
  hashtable *h;
{
    void freebuckets();

    freebuckets(h->buf, h->size);
    free((char*) h);
}

static void
freebuckets(bb, num)
  hashbucket **bb;
  int num;		/* number of said */
{
    int i;
    hashbucket *b,*c;

    for (i=0 ; i<num ; i++)
	for (b=bb[i] ; b ; b = c ) {
	    c = b->next;
	    free(b->key);
	    free(b->data);
	    free((char*)b);
	}
}

/* given a key, returns a pseudo-random, pseudo-unique integer */

static int
hash(key)
  char *key;
{
    static int m[8] = { 97, 3370891, 48551, 3179, 571235, 997, 17383, 19471 };
    int i,sum=0;

    for (i=0 ; *key ; i++,key++ ) {
	if (i>=8)
	    i = 0;
	sum += *key * m[i];
    }
    return(sum);
}

static void
resize_hash(h)
  hashtable *h;
{
    int ns;		/* new size */
    int nh;		/* new hash-value */
    int i;
    int s;		/* size of bucket-table */
    hashbucket *b, *c, **nb;

    ns = h->size * 2;
    s = sizeof(hashbucket *) * ns;
    nb = (hashbucket **) malloc(s);
    bzero((char*)nb, s);

/* move buckets into new bucket-table (nb) */
    for (i=0 ; i<h->size ; i++)
	for (b=h->buf[i] ; b ; b=c) {
	    c = b->next;
	    nh = b->hashval & (ns-1);
	    b->next = nb[nh];
	    nb[nh] = b;
	}

    free((char*)h->buf);
    h->buf = nb;
    h->size = ns;
}
