:- eccs_srcload(['ops.pl', 
	'generic.pl', 
	'term_structure.pl', 
	'srcparser.pl',			% The simple parser
	'printers.pl',
 	'templates.pl']).


/*

Tue Feb 9 12:32:59 1993 JC The following changes needed to fix
incompatibilities with Pleuk version 1.0

*/

:- dynamic eccs_user_analyse_error/4.

:- dynamic eccs_special_print_type/1.

eccs_debug(_, Goal) :- eccs_sys_call(Goal).

/*

Tue Feb  9 12:33:40 1993 End of changes

*/



/*

Reader for the term based system.

eccs_term_unif_reader(_, Name, Type, Definition)

*/

eccs_term_unif_reader(_, Name, Type, Definition) :-
    eccs_sys_read(X),
    (X == end_of_file, X = Name -> X = Definition; 
    	(X = source(File) -> Definition = source(File); 
	    eccs_well_formed_grammar_object(X, Name, Type, Definition))).


/*

eccs_well_formed_grammar_object(X, Name, Type, Definition).

Check for high-level well-formedness and Name and Type

*/

eccs_well_formed_grammar_object(Word: Definition, Word, lexical_entry, Definition).
eccs_well_formed_grammar_object(lexical_rule(Name, Defn), Name, lexical_rule, Defn).
eccs_well_formed_grammar_object((Name =>( Mother --> Daughters)), Name, grammar_rule, grammar_rule(Mother, Daughters)).
eccs_well_formed_grammar_object(path_abbreviation(Abb, Path), Abb, path_abbreviation, path_abbreviation(Abb, Path)).
eccs_well_formed_grammar_object(aliases(Name, Definition), TName, template, aliases(Name, Definition)) :-
    eccs_template_name(Name, TName).	% needed for parameterized templates
eccs_well_formed_grammar_object((Name => Definition), TName, template, (Name => Definition)) :-
    eccs_template_name(Name, TName).	% needed for parameterized templates--does this make sense for aliases?
eccs_well_formed_grammar_object(declare(Label, Labels), Label, term_structure, term_structure(Label, Labels)).
eccs_well_formed_grammar_object(top_level_type(Label), top_level_type, term_structure, top_level_type(Label)).





/*

Compilers for the term-based system

*/

eccs_path_abbreviation(path_abbreviations, path_abbreviation, Name, _, path_abbreviation(Name, Abb),  Abb, []).

eccs_term_structure(term_structures, term_structure, top_level_type, _, top_level_type(Name), Name, []).
eccs_term_structure(term_structures, term_structure, Name, Args, 
	term_structure(Name, L:R), 
	term_structure(Name, Types, Pattern, Term), []) :-
    !,
    eccs_get_argument(file, File, Args),
    eccs_mds(File, Name, L:R, 1, Types, Pattern, Term).
eccs_term_structure(term_structures, term_structure, Name, Args, 
	term_structure(Name, Complex), 
	term_structure(Name, Complex1, Pattern, Pattern1), []) :-
    eccs_get_argument(file, File, Args),
    eccs_sys_functor(Complex, F, N),
    eccs_not_eq(F, ':'), 
    eccs_sys_functor(Pattern, F, N),
    eccs_sys_functor(Complex1, F, N),
    eccs_sys_functor(Pattern1, F, N),
    eccs_mds1(File, Complex, Complex1, Pattern1, 0, N).



eccs_generic_term_compiler(templates,template, Name, _Args, Defn, CDefn, []) :-
    eccs_template(Defn, CDefn).
eccs_generic_term_compiler(lexical_rules, lexical_rule, Name, _Args, Defn, CDefn, []) :-
    eccs_lexical_rule(Defn, CDefn).
eccs_generic_term_compiler(dictionary, lexical_entry, Name, _Args, Defn, CDefn, []) :-
    eccs_lexical_entry(Name, Defn, CDefn).

eccs_grammar_rule(grammar_rules, grammar_rule, Name, _Args, grammar_rule(Mother, Daughters), CDefn, []) :-
    eccs_commas_to_list(Daughters, Daus),
    eccs_process_list_of_fs([Mother|Daus], [M1|D1]),
    eccs_reverse(D1, D1R),
    CDefn = rule(M1, D1R).

eccs_lexical_rule(Defn, lexical_rule(In, Out)) :-
    eccs_user_empty_structure(In1),
    eccs_user_empty_structure(Out1),
    eccs_lexical_rule(Defn, In1, Out1, ST, 0, _, In, Out).

eccs_lexical_rule([], In, Out, ST, N, N, In, Out) :- !.
eccs_lexical_rule([LRule|R], In1, Out1, ST, M, N, In, Out) :-
    eccs_sys_atomic(LRule), 
    eccs_get_from_database(lexical_rule, LRule, lexical_rule(LRIn, LROut)),
    eccs_user_unify(In1, LRIn, In2),
    eccs_user_unify(Out1, LROut, Out2),
    eccs_lexical_rule(R, In2, Out2, ST, I, N, In, Out).
eccs_lexical_rule([:in = Defn|R], In1, Out1, ST, M, N, In, Out) :-
    eccs_template1_rhs(Defn, In1, In2, ST, M, I),
    eccs_lexical_rule(R, In2, Out1, ST, I, N, In, Out).
eccs_lexical_rule([:out = Defn|R], In1, Out1, ST, M, N, In, Out) :-
    eccs_template1_rhs(Defn, Out1, Out2, ST, M, I),
    eccs_lexical_rule(R, In1, Out2, ST, I, N, In, Out).
    


eccs_process_list_of_fs(Defns, FSs) :-
    eccs_process_list1(Defns, _, 0, N, FSs).

eccs_process_list1([], _, N, N, []).
eccs_process_list1([D|Ds], ST, M, N, [FS|FSs]) :-
    eccs_user_empty_structure(New),
    eccs_template1_rhs(D, New, FS, ST, M, O),
    eccs_process_list1(Ds, ST, O, N, FSs).

