/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 09:59:44 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Term/RCS/term_structure.pl,v $',
	'$State: Exp $').

$Log: term_structure.pl,v $
% Revision 1.0  1993/05/04  09:59:44  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  13:55:12  pleuk
% revisions from SLE - April 1992
%
% Revision 0.6  1991/09/02  13:29:13  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.1  1991/03/06  13:14:49  pleuk
% *** empty log message ***
%

*/


/*---------------------------------------------------------------------------+
|                                                                            |
|        eccs_mds(Node, L:R, N, T)                                              |
|                                                                            |
|        make the dag structure corresponding  to the list of labels.  Node  |
|        is the dominating node which will be the functor for the term       |
|        T representing the node.  N is the argument position that the       |
|        the label L will occupy.  Note that we have to make this left       |
|        recursive, in order to know how many arg places the term needs.     |
|                                                                            |
+---------------------------------------------------------------------------*/
eccs_mds(FileName, Node, Label:R, N, spec(L1, T1, V):TR, _:Term, T) :- !,
	eccs_map_type(Label, L1 ** T1),
        eccs_succ(N, M),
        eccs_mds(FileName, Node, R, M, TR, Term, T),
        eccs_sys_arg(N, T, V),
	eccs_store_in_database(FileName, term_structure, L1, _, d(L1, T, V, T1), []).
eccs_mds(FileName, Node, Label, N, spec(L, Type, V), _Term, T) :- 
	eccs_map_type(Label, L ** Type),
        eccs_sys_functor(T, Node, N),
        eccs_sys_arg(N, T, V),
	eccs_store_in_database(FileName, term_structure, L, _, d(L, T, V, Type), []), !.
eccs_mds(FileName, Node, Label, N, Type, _Term, T) :-
	eccs_error([problems, with, Node, Label, N, Type, T]).


eccs_mds1(FileName, Complex, Complex1, Pattern, Max, Max) :- !.
eccs_mds1(FileName, Complex, Complex1, Pattern, Count, Max) :-
    eccs_succ(Count, I),
    eccs_sys_arg(I, Complex, Spec),
    eccs_map_type(Spec, Label ** Type),
    eccs_sys_arg(I, Complex1, spec(Label, Type, Var)),
    eccs_sys_arg(I, Pattern, Var),
    eccs_store_in_database(FileName, term_structure, Label, _, d( Label, Pattern, Var, Type), []),
    eccs_mds1(FileName, Complex, Complex1, Pattern, I, Max).


eccs_map_type(A, A ** basic) :- eccs_sys_atomic(A).
eccs_map_type(A ** T, A ** T) :- eccs_sys_atomic(A), eccs_sys_atomic(T).
eccs_map_type(Label ** {L}, Label ** Types) :- 
	eccs_commas_to_list(L, Types).
