/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 09:59:44 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Term/RCS/templates.pl,v $',
	'$State: Exp $').

$Log: templates.pl,v $
% Revision 1.0  1993/05/04  09:59:44  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  13:55:12  pleuk
% revisions from SLE - April 1992
%
% Revision 0.6  1991/09/02  13:30:54  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.2  1991/07/07  23:51:50  pleuk
% *** empty log message ***
%
% Revision 0.1  1991/03/06  13:14:49  pleuk
% *** empty log message ***
%

*/



eccs_template_name(Definition, T) :-
    eccs_sys_functor(Definition, Name, N), 
    N > 0,
    eccs_sys_functor(T, Name, N).
eccs_template_name(Definition, Name) :-
    eccs_sys_functor(Definition, Name, 0), !.

eccs_template(aliases(Name, Defn), template(PName, alias, CDefn)) :-
    eccs_template(Name, PName, Defn, CDefn).

eccs_template((Name => Defn), template(PName, not_an_alias, CDefn)) :-
    eccs_template(Name, PName, Defn, CDefn).

eccs_template(Name, NameParams, [F|R], Out) :-
	!,
	eccs_get_from_database(term_structure, top_level_type, T),
	eccs_user_empty_structure(In),
	eccs_template1([F|R], In, Out, ST, 0, N),
	eccs_user_template_params(Name, NameParams, ST, N, M).
eccs_template(Name, NameParams, L ** T, Out) :-
	!,
	eccs_user_emptystructure(In),
        eccs_template1(L, In, Out, ST, 0, N),
	eccs_user_template_params(Name, NameParams, ST, N, M).
eccs_template(Name, NameParams, T :: Sort, Out) :-
	eccs_user_term(FS, New),
	eccs_mk_typ(Sort, New, B2),
	eccs_user_bits(FS, B2),
	eccs_user_unify(FS, _, In),
        eccs_template1(L, In, Out, ST, 0, N),
	eccs_user_template_params(Name, NameParams, ST, N, M).
    	

eccs_user_template_params(Name, NameParams, ST, N, M) :-
    	eccs_sys_functor(Name, F, I),
	eccs_sys_functor(NameParams, F, I),
	eccs_user_template_params(Name, NameParams, ST, N, M, I).

eccs_user_template_params(Name, _, _ST, N, N, 0) :- !.
eccs_user_template_params(Name, NameParams, ST, N, M, I) :-
    	I > 0, 
    	eccs_sys_arg(I, Name, Variable),
    	eccs_sys_arg(I, NameParams, V),
    	eccs_variable(Variable, V, ST),
	eccs_succ(J, I),
	eccs_user_template_params(Name, NameParams, ST, N, M, J).

/*----------------------------------------------------------------------+
|									|
|	eccs_template1 is the main routine for constructing terms.		|
|									|
+----------------------------------------------------------------------*/

% The following block of code is heavily modified to split up the
% functionality of the previous version of the eccs_template1 predicate
% into several predicates.  According to my fgrep, the only other file
% which references eccs_template1 is qprocess.pl and it is clear that the
% only two references there correspond to actual template definitions
% and not the lower level functionality of the original eccs_template1
% predicate.  Thus, the following splitting of functionality appears
% to be safe.

% eccs_template1 takes a list of elements defining a template and creates
% a term from them.  The elements of the list can be template names,
% lexical rules, path equations and feature-value structures (using
% the Stuttgart notation).  Each element of the list is processed by
% eccs_template1_element.

eccs_template1([], In, In, _ST, N, N) :- !.
eccs_template1([H|T], In, Out, ST, M, O) :- !,
        eccs_template1_element(H, In, Out1, ST, M, N),
        eccs_template1(T, Out1, Out, ST, N, O).
eccs_template1(@T, In, Out, ST, N, O) :- !,
	eccs_template1_template(T, In, Out, ST, M, N).
eccs_template1(T, In, Out, ST, N, O) :-
    	eccs_user_possible_ptemplate(T), 
	eccs_template1_template(T, In, Out, ST, M, N).


% eccs_template1_element processes an element of a list defining a
% template.  The four possible types are listed above.

eccs_template1_element(H, In, Out, ST, M, N) :-
        eccs_sys_atomic(H), !,           % lexical rule 
	eccs_template1_lexical_rule(H, In, Out, ST, M, N).
eccs_template1_element(@T, In, Out, ST, M, N) :- !,
	eccs_template1_template(T, In, Out, ST, M, N).
eccs_template1_element((:P = Value), In, Out, ST, M, N) :- !,     	% P is a path
	eccs_template1_path_equation((:P = Value), In, Out, ST, M, N).
eccs_template1_element([H|T], In, Out, ST, M, N) :-
	eccs_template1_feature_structure([H|T], In, Out, ST, M, N).
eccs_template1_element(T, In, Out, ST, M, N) :- 			% New case 
    	eccs_user_possible_ptemplate(T), 
	eccs_template1_template(T, In, Out, ST, M, N).

% eccs_template1_feature_structure is very simple.  Since, a
% feature structure is just a list of path equations, it just recurses
% through the list calling eccs_template1_path_equation.

eccs_template1_feature_structure([], In, In, _, N, N).
eccs_template1_feature_structure([H|T], In, Out, ST, M, O) :- !,
        eccs_template1_path_equation(H, In, Out1, ST, M, N),
        eccs_template1_feature_structure(T, Out1, Out, ST, N, O).

% eccs_template1_path_equation handles path equations.  It reduces the
% complexity of the right hand sides before calling eccs_template1_path_value.
% The cut at the end is for efficiency, under the assumption that path names
% give rise to a unique feature structure.  This is not true in general
eccs_template1_path_equation((:P = :V), In, Out, ST, M, M) :- !,
    eccs_path_translate(V, V1),
    eccs_path_translate(P, P1),
    eccs_path_value(P1, T1, In, X),
    eccs_path_value(V1, T2, In, X1),	% Assume prolog unification
    eccs_user_unify(X, X1, _),
    eccs_user_unify(In, _, Out), !.

% The cut at the end is allowed as atomic values cannot be disjunctive.

eccs_template1_path_equation((:P = Value0), In, Out, ST, M, N) :- !,
    eccs_path_translate(P, P1),
    eccs_path_value(P1, _, In, New),
    eccs_template1_rhs(Value0, New, Out1, ST, M, N),
    eccs_user_mask_term(Out1, NewFS),
    eccs_user_unify(In, NewFS, Out),
    (eccs_sys_atomic(Value) -> !; true).
eccs_template1_path_equation(@ T, In, Out, ST, M, N) :- !,
    eccs_template1_template(T, In, Out, ST, M, N).
eccs_template1_path_equation(T, In, Out, ST, M, N) :- !,
    eccs_user_possible_ptemplate(T), 
    eccs_template1_template(T, In, Out, ST, M, N).
    	

% The same kind of comments for cuts apply here.  A Key#Exp pair cannot
% give rise to disjunction.

eccs_template1_rhs(Var, In, Out, ST, N, N) :-
	eccs_sys_var(Var), !,
    	eccs_user_term(In, Var),
	eccs_user_unify(In, _, Out).
eccs_template1_rhs( `Term, In, Out, ST, N, O) :- 	% arbtirary prolog term
    	!,
	eccs_user_empty_structure(X),
	eccs_user_term(X, Term),
	eccs_user_unify(X, In, Out), !.
eccs_template1_rhs(Key#Exp, In, Out, ST, N, O) :-
    	eccs_sys_integer(Key), !,
	eccs_variable(#Key, D, ST),
	eccs_user_empty_structure(X),
	eccs_user_term(X, D),
	eccs_user_unify(In, X, Out1), !,
	eccs_template1_rhs(Exp, Out1, Out, ST, N, O).
eccs_template1_rhs(Exp#Key, In, Out, ST, N, O) :-
    	eccs_sys_integer(Key), !,
	eccs_variable(#Key, D, ST),
	eccs_user_empty_structure(X),
	eccs_user_term(X, D),
	eccs_user_unify(In, X, Out1), !,
	eccs_template1_rhs(Exp, Out1, Out, ST, N, O).
eccs_template1_rhs(Value0::Type, In, Out, ST, N, O) :- !,
	eccs_template1_rhs(Value0, In, Out1, ST, N, O),
	eccs_user_term(Out1, TOut),
	eccs_mk_typ(Type, TOut, B2),
	eccs_user_bits(New, B2),
	eccs_user_unify(Out1, New, Out), !.
eccs_template1_rhs([], In, In, ST, N, N) :- !.
eccs_template1_rhs([H|T], In, Out, ST, N, O) :- !,
	eccs_template1_feature_structure([H|T], In, Out, ST, N, O).
eccs_template1_rhs(V, In, Out, ST, N, O) :-
	eccs_template1_path_value(V, In, Out, ST, N, O).

% eccs_template1_path_value handles the values or right hand side of path
% equations.  The possible value types are variables (extremely
% useful) , path equations, feature-value structures, template names,
% and the + notation and of course atomic values.

% There is some redundancy between this and the preceding clauses, but it 
% appears useful to separate things out in this way.  The clauses here have 
% been rearranged so that one has to wade through less in debugging.

eccs_template1_path_value([], In, In, ST, M, M) :- !.	% NB the first clause above
eccs_template1_path_value([H|T], In, Out, ST, M, N) :- !,
	eccs_template1_feature_structure([H|T], In, Out, ST, M, N).
eccs_template1_path_value(@T, In, Out, ST, M, N) :- !,
	eccs_template1_template(T, In, Out, ST, M, N).
eccs_template1_path_value(Atom, In, Out, ST, N, N) :-
	eccs_sys_atomic(Atom), !,
	eccs_user_new_term_old_constraints(In, In1, _, Atom),
	eccs_user_unify(In, In1, Out).
eccs_template1_path_value(V, In, Out, ST, N, N) :-
        eccs_variable(V, Val, ST), !,
	eccs_user_new_term_old_constraints(In, In1, _, Val),
	eccs_user_unify(In, In1, Out).
eccs_template1_path_value(V, In, Out, _ST, N, N) :-
        eccs_eq_type(V, Constr), !,
	eccs_user_term(New, D),
	eccs_user_bits(New, B1),
	eccs_user_constraints(New, ['C'(X, Constr)]),
	eccs_user_unify(In, New, Out).
eccs_template1_path_value(T, In, Out, ST, M, N) :- !,
    	eccs_user_possible_ptemplate(T), 		% Assume we've caught all the special cases above
	eccs_template1_template(T, In, Out, ST, M, N).


eccs_template1_lexical_rule(H, In, Out, _ST, M, N) :-
        eccs_sys_atomic(H), !,           % lexical rule 
	Goal = eccs_get_from_database(lexical_rule, H, lexical_rule(LRIn, LROut)),
	eccs_sys_if_then_else(eccs_verify(Goal), eccs_sys_call(Goal), 
		eccs_error(['No', such, lexical, 'rule:', H])),
	eccs_user_unify(LRIn, In, _),
	eccs_user_unify(LROut, _, Out).

eccs_template1_template(T, In, Out, _ST, N, M) :-
    	eccs_sys_functor(T, F,NArgs),
	eccs_sys_functor(T1, F, NArgs),
	eccs_if(eccs_get_from_database(template, T1, template(T1, _, TFS)), true,
                        eccs_error([T, no, such, template])), 
	eccs_user_unify(In, TFS, Out1),
	eccs_template1_template_do_args(T, T1, Out1, Out, _ST,NArgs, N, M).

eccs_template1_template_do_args(T, T1, In, In, _, 0, N, N).
eccs_template1_template_do_args(T, T1, In, Out, ST, I, N, M) :-
    I > 0,
    eccs_sys_arg(I, T, Value),
    eccs_sys_arg(I, T1, ValueInFS),
    NewFS = ValueInFS:[]:[],		% ?? temporary fix
    eccs_template1_rhs(Value, NewFS, OutFS, ST, N, O),
    OutFS = _:B:C,
    eccs_user_unify(In, _:B:C, Out1),
    eccs_succ(J, I),
    eccs_template1_template_do_args(T, T1, Out1, Out, ST, J, O, M).

eccs_user_possible_ptemplate(T) :-
	eccs_sys_functor(T, F, I), I > 0,
	\+ eccs_memberchk(F, ['.', ':', '@', '#', '=', '::', '~', 'or', '&', '`']).


eccs_path_value(Path, LastType, In:Bits:Cons, Out:Bits:Cons) :-
    eccs_path_value1(Path, LastType, In, Out).

eccs_path_value1(Path, Last, DAG, Val) :- 
    	eccs_sys_nonvar(Path), Path = Label:Rest, !,
	eccs_if(eccs_get_from_database(term_structure, Label, d(Label, DAG, V, _)), true,
					   eccs_user_analyse_error(Label, DAG, V, _)),
	eccs_path_value1(Rest, Last, V, Val).
eccs_path_value1(Last, Type, DAG, Val) :-
    	eccs_sys_atomic(Last), !,
	eccs_if(eccs_get_from_database(term_structure, Label, d(Last, DAG, Val, Type)), true,
        				   eccs_user_analyse_error(Label, DAG, V, _)).


:- eccs_new_variable(path_for_lex_symbol, phonology, 
		     parsing, run,
         "Path under which the string that appears in a word's definition will be stored").

eccs_lexical_entry(Word, Defn, CDefn) :-
    eccs_global_variable(path_for_lex_symbol, Path),
    eccs_user_term(New, Word),
    eccs_path_value(Path, _, In, New),
    eccs_template1(Defn, In, CDefn, ST, 0, N).

