/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 09:59:44 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Term/RCS/srcparser.pl,v $',
	'$State: Exp $').

$Log: srcparser.pl,v $
% Revision 1.0  1993/05/04  09:59:44  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  13:55:12  pleuk
% revisions from SLE - April 1992
%
% Revision 0.6  1991/09/02  13:30:35  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.2  1991/07/07  23:51:40  pleuk
% *** empty log message ***
%
% Revision 0.1  1991/03/06  13:14:49  pleuk
% *** empty log message ***
%

*/

/*


The Protolexicon and PIMPLE grammar development system.

Copyright 1986, 1989, 
University of Edinburgh, Centre for Cognitive Science.

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('%M%', '%I%', %R%').

*/
/*
file:		srcparse.pl
created:	around December 1986
by:		Jo
contents:	A shift-reduce parser with a well-formed substring table.
*/

:- eccs_new_variable(parser, eccs_shift_reduce, parsing, run, 
			"The name of the parser to be used for analyzing input").

eccs_user_parser_spec(eccs_shift_reduce, 
	[prehook = eccs_clean,
	 fs_drawer = eccs_printfs_from_parse,
	 tree_drawer = eccs_print_tree_from_parse]).

eccs_shift_reduce(_Args, ToParse, Out) :- 
    eccs_clean,
    eccs_post_last_sentence(ToParse),
%    start_stats,
    eccs_global_variable(parser, Parser),
    eccs_parse_top_level(Parser, ToParse, Out).

eccs_parse_top_level(eccs_shift_reduce, String, Results) :- 
	eccs_src_parse(String, 48, End), !, 	% 48 ascii = 0
	eccs_sys_name(StartV, [118, 48]),
	eccs_sys_name(EndV, [118, End]),
	eccs_src_find_edges(StartV, EndV, D:C:B, Results).


eccs_src_parse( [], End, End).
eccs_src_parse( [H|T], This, End) :-
	eccs_succ(This, Next),
	eccs_sys_name(ThisV, [118, This]),	% 118 ascii = v
	eccs_sys_name(NextV, [118, Next]),
	eccs_src_shift(H, ThisV, NextV), !,
	eccs_src_parse(T, Next, End).

eccs_src_shift(Word, This, Next) :-
	eccs_retrieve_word(Word, D, This, _Real),
	eccs_sys_recordz( Next, s(This, D, lexical, _), Ref),
	eccs_src_reduce(This, Next, D, Ref). % always fails.
eccs_src_shift(_, _, _).


/*---------------------------------------------------------------------------+
|        								     |
|        eccs_src_reduce(ThisV, NextV, Dag:Conds:Bits, Ref)		     |
|        								     |
|        There is a configuration of edges ending at NextV and ending at     |
|	 ThisV which can be analysed by a rule whose right daughter is	     |
|	 unifiable with Dag:Conds:Bits.					     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_src_reduce(ThisV, NextV, Dag:Conds:Bits, Ref) :-
	'&compiled_rule'(Dag:Conds:Bits, MD:MC:MB, ThisV, StartV, NewConds, NewBits, Name, Ds),
	eccs_once(( eccs_check_constraints([MC, NewConds], ResC), eccs_ck_typ([MB|NewBits], ResB) )),
	eccs_sys_recordz(NextV, s(StartV, MD:ResC:ResB, Name, [Ref|Ds]), NewRef),
	eccs_src_reduce(StartV, NextV, MD:ResC:ResB, NewRef),
	fail.

eccs_compile_rules :-
	eccs_sys_abolish('&compiled_rule', 8),
	eccs_get_from_database(grammar_rule, Name, rule(D:DC:DB, Daus)),
	sr_mk_rule(Name, D:DC:DB, Daus),
	fail.
eccs_compile_rules.

% The next two procedures altered to take account of the setting of the 
% global variable ``unification'' JC Wed Jun 15 14:23:54 1988
sr_mk_rule(Name, Mother, [D:C:B|T]) :-
    Term = 
	('&compiled_rule'(D1:RC:RB, MD:MC:MB, ThisV, StartV, [NewC|RestC], [NewB|RestB], Name, Refs) :-
	        eccs_user_unify(D:B:C, D1:RC:RB, NewFS),
 		R,
		eccs_once((eccs_check_constraints([RC, C], NewC), U)),
		eccs_user_unify(MD:MC:MB, _, Mother)), 

    eccs_sys_if_then_else( B == [], 
      U = eccs_ck_typ(RB, NewB) ,
      U = eccs_ck_typ([B|RB], NewB)),
    sr_mk_rule1(T, R, ThisV, StartV, RestC, RestB, Refs),
    eccs_sys_assertz(Term).

sr_mk_rule1([], true, ThisV, ThisV, [], [], []) :- !.
sr_mk_rule1([D:C:B|T], Term, ThisV, StartV, [NewC|RestC], [NewB|RestB], [Ref|RestRef]) :-
	Term = (eccs_sys_recorded(ThisV, s(PrevV, D1:RC:RB, _, _), Ref),
		eccs_user_unify(D:C:B, D1:RC:RB, _),
		R,
		eccs_once((eccs_check_constraints([C, RC], NewC), U))),
	eccs_sys_if_then_else( B == [],
	  U = eccs_ck_typ(RB, NewB),
	  U = eccs_ck_typ([B|RB], NewB) ),
	sr_mk_rule1(T, R, PrevV, StartV, RestC, RestB, RestRef).

/*---------------------------------------------------------------------------+
|        								     |
|        eccs_src_find_edges(Start, End, L)				     |
|        								     |
|        List contains all instances of inactive edges 			     |
|        extending from Start to End.   				     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_src_find_edges(S, E, _:_:_, Edges) :- 
    Entry = s(S, _, _, _),
    findall(Entry, eccs_sys_recorded(E, Entry, _), Edges).


/*


eccs_src_find_edges(S, E, D:C:B, _) :-
	(eccs_sys_recorded('EDGES', _, Ref), eccs_sys_erase(Ref), fail; true),
	eccs_sys_recorded(E, s(S, D1:C1:B1, Name, Refs), Ref), 
%	merge(D, D1),		% Fri Jan  8 13:56:52 1988  mkr term unif.
	D = D1,			% Fri Jan  8 13:56:52 1988  mkr term unif.
	eccs_once(( eccs_check_constraints(C, _), eccs_check_constraints(C1, _))),
	eccs_append(C, C1, NewC),
	eccs_ck_typ(B, _),
	eccs_ck_typ(B1, _),
	eccs_append(B, B1, NewB),
	eccs_sys_recordz('EDGES', s(S, D:NewC:NewB, Name, Refs), _), 
	fail.
eccs_src_find_edges(S, _E, D:_C:_B, Edges) :- 
	eccs_src_gather(S, D, Edges1),
	eccs_sys_if_then_else(eccs_global_variable(sort_edges_by_complexity, on),
		eccs_sort_edges_by_complexity(Edges1, Edges), 
		Edges = Edges1),
	eccs_length(Edges, N).



eccs_sort_edges_by_complexity(Unsorted, Sorted) :-
    eccs_sort_edges_by_complexity1(0, Unsorted, Numbered),
    sort(Numbered, SortedNumbered),
    eccs_strip_numbering(SortedNumbered, Sorted).

eccs_sort_edges_by_complexity1(_, [], []) :- !.
eccs_sort_edges_by_complexity1(Position, [H|T], [F|R]) :- 
    H = s(_,D,_,_), F = number(N, Position, H),
    eccs_global_variable(path_for_lex_symbol, Phonology),
    eccs_path_value(Phonology, _, D, Phon),
    eccs_complexity(Phon, N),
    NewPos = Pos +1,
    eccs_sort_edges_by_complexity1(NewPos, T, R).

eccs_complexity(Phon, M) :-
    eccs_complexity(Phon, 0, N),
    M is N.

eccs_complexity(Phon, M, M+10) :-
    eccs_sys_atom(Phon),
    eccs_member(Phon, [inverselim, gapelim, gapintro, ppintro]),
    !.
eccs_complexity(Phon, N, N) :-
    (eccs_sys_atomic(Phon); eccs_sys_var(Phon)), !.
eccs_complexity(Phon, M, M+(1.5 * N)) :-
    eccs_sys_functor(Phon, F, Arity),
    eccs_complexity(Phon, 0, 1, Arity, N).

eccs_complexity(Phon, M, A, Arity, M) :-
    eccs_succ(Arity, A), 
    !.
eccs_complexity(Phon, M, A, Arity, Result) :-
    eccs_sys_arg(A, Phon, T),
    eccs_complexity(T, N),
    eccs_succ(A, J),
    eccs_complexity(Phon, (N/(2*A))+M, J, Arity, Result).
    
eccs_strip_numbering([], []) :- !.
eccs_strip_numbering([number(N, Position, H)|T], [H|R]) :-
    eccs_strip_numbering(T, R).


eccs_src_gather(Start, _D, [Edge|T]) :-
	eccs_sys_recorded('EDGES', Edge, Ref), !,
	eccs_sys_erase(Ref),
	eccs_src_gather(Start, __D, T).
eccs_src_gather(_S, _D, []).

*/

eccs_back_end(List) :-
	eccs_global_variable(back_end, P), !,
	Goal =.. [P, D:C:B],
	eccs_member(s(_, D:C:B, _, _), List),
	call(Goal),
	eccs_pausefail, !, 
	fail.
eccs_back_end(_) :-
	eccs_error([no, back, end, procedure, 'specified.', eccs_sys_nl,
		 use, 'set(back_end, ProcedureName)']).


/*

Database manipulation

*/

eccs_clean :- 
        eccs_sys_retractall(eccs_last_sentence_analysis(_,_,_)),
	eccs_global_variable(last_sentence, S), !,
	eccs_length(S, N), E is 48 + N,
	eccs_srcclean(48, E).
eccs_clean.

eccs_srcclean(N, M) :- 
    eccs_succ(M, N), !.
eccs_srcclean(I, N) :-
	eccs_sys_name(V, [118, I]),
	(eccs_sys_recorded(V, _, Ref), eccs_sys_erase(Ref), fail; 
	 O is I + 1, eccs_srcclean(O, N)).


eccs_retrieve_word(Word, D, This, _Real) :-
    eccs_get_from_database(lexical_entry, Word, D).
eccs_retrieve_word(Word, D, This, _Real) :-
    eccs_get_from_database(pderived_entry, Word, D).
