/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 09:59:44 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Term/RCS/printers.pl,v $',
	'$State: Exp $').

$Log: printers.pl,v $
% Revision 1.0  1993/05/04  09:59:44  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  13:55:12  pleuk
% revisions from SLE - April 1992
%
% Revision 0.6  1991/09/02  13:29:13  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.1  1991/03/06  13:14:49  pleuk
% *** empty log message ***
%

*/

/*

File:	/home/user2/jo/Pleuk/Term/printers.pl
Date:	Mon Jun 18 21:42:06 1990
By:	Jonathan Calder

Printers for the term unification system

*/

/*


	 tree_drawer = 

*/


eccs_printfs_from_parse(Args, String, Parse, captioned(String, SPF)) :-
    eccs_printfs_from_parse(Args, Parse, SPF).

eccs_printfs_from_parse(_Args, s(_, FS, _Rule, _Tree), STDForm) :-
    eccs_printfs(FS, STDForm).


qp(L) :-
    D:_C:_B =  L,
    D = sign(P, Cat, S, O, I, Out, OccL, Occn),
    eccs_sys_write('phonology:	'), eccs_sys_write(P), eccs_sys_nl,
    eccs_sys_write('category:  	'), eccs_sys_write(Cat), eccs_sys_nl,
    eccs_sys_write('semantics:  	'), eccs_sys_write(S), eccs_sys_nl,
    eccs_sys_write('order: 	'), eccs_sys_write(O), eccs_sys_nl,
    eccs_sys_write('in: 		'), eccs_sys_write(I), eccs_sys_nl,
    eccs_sys_write('out: 	'), eccs_sys_write(Out), eccs_sys_nl,
    eccs_sys_write('occlist:	'), eccs_sys_write(OccL), eccs_sys_nl,
    eccs_sys_write('occnum:	'), eccs_sys_write(OccN), eccs_sys_nl.



eccs_print_tree_from_parse(_Args, T) :-
    eccs_global_variable(last_sentence, X),
    eccs_length(X, N),
    eccs_concat(v, N, LastV),
    eccs_gather_tree(LastV, v0, T, Tree),
    eccs_print_tree(Tree).

eccs_gather_tree(LastV, Start, T, leaf(Phon)) :-
    T = s(Start, FS, lexical, Daus),
    !,
    eccs_global_variable(path_for_lex_symbol, Path),
    eccs_global_variable(path_for_lex_symbol, Phonology),
    eccs_path_value(Phonology, _, FS, Phon).

eccs_gather_tree(LastV, Start, T, nonterminal(Name, DTs)) :-
    T = s(Start, FS, Name, Daus),
    eccs_gather_daughters(LastV, Start, Daus, DTs).


eccs_gather_daughters(Start, Start, [], []) :- !.
eccs_gather_daughters(LastV, Start, [D|Ds], [DT|DTs]) :-
    SMid = s(Mid, FS, _, _),
    eccs_sys_recorded(LastV, SMid, D),
    eccs_gather_tree(LastV, SMid, T, DT),
    eccs_gather_daughters(Mid, Start, Ds, DTs).


eccs_print_tree(Tree) :-
    eccs_sys_write(Tree), eccs_sys_nl.


/*
eccs_print_tree(nonterminal(Name, Ds), Tab, Offset) :-
    eccs_prlength(Name, N),
    O is Offset + N +2,
    eccs_sys_write(Name), eccs_sys_write('| '),
    Ds = [F|R],
    eccs_sys_write(F),
    eccs_print_branches(Ds, Tab, 0 ).
eccs_print_tree([F|R], Tab, Offset) :-
    
    
*/

/*

eccs_printfs(Term, STDform)

a bare-bones printer for decompiling terms to feature structures in the 
standard printing format. 

*/

eccs_printfs(FS, STDform) :-
    eccs_zero(node),
    eccs_zero(index),
    eccs_zero(fs_count),
    eccs_printfs1(FS, STDform).

eccs_printfs1(FS, STDform) :- 
    FS = D:C:B, 
    eccs_get_from_database(term_structure, top_level_type, T),
    eccs_u_findunifs(spec('DUMMY', T, D), C, B, R, [], [], OutL), !,
    eccs_number_rentrant_structures(OutL, 1, _),
    eccs_term_to_fs(R, Print),
    eccs_u_print(Print, STDform), !.  

eccs_number_rentrant_structures([], N, N) :- !.
eccs_number_rentrant_structures(_Struct = 'TAG'('UNREF', 'UNREF'), N, N) :-
    !.
eccs_number_rentrant_structures(_Struct = 'TAG'(N, Seen), N, I) :-
    Seen == seen, !,
    I is N + 1.
eccs_number_rentrant_structures([F|R], N, M) :- 
    eccs_number_rentrant_structures(F, N, I),
    eccs_number_rentrant_structures(R, I, M).


/*---------------------------------------------------------------------------+
|                                                                            |
|        eccs_u_findunifs(M, Dag:Conds:Bits, Result, InL, OutL)                   |
|                                                                            |
|        Work through the Dag, building Result, which has unifications       |
|        made explicit.  M is the mother of this subgraph, D possible        |
|        labels from this node.  InL is a list of such variables already     |
|        encountered, and OutL the newly constructed list.                   |
|                                                                            |
+---------------------------------------------------------------------------*/

% note that the following will work for any typed variable (i.e.,
% which is explicitly typed by the user and has a bit term in the bit
% constraint list).   on the other hand it won't do anything with
% untyped variables anywhere (those with nothing in the bit
% constraint list).  So, all InL variables have to be typed.

eccs_u_findunifs(spec(M, _Type, Dag), Conds, Bits, Result, ResultOut, InL, OutL) :- 
    eccs_special_print_type(M), !,
    eccs_calculate_special_print(M, spec(M, _Type, Dag), Conds, Bits, Result, ResultOut, 
    				 InL, OutL).

eccs_u_findunifs(spec(M, _Type, Dag), Conds, Bits, [M = Dag|Result], Result, InL, InL) :- 
     eccs_sys_atomic(Dag), !.
eccs_u_findunifs(spec(M, _Type, Dag), Conds, Bits, [M = 'TAG'(N)|Result], Result, InL, InL) :-
    eccs_p_assq(Dag = 'TAG'(N, seen), InL).
eccs_u_findunifs(spec(M, _Type, Var), Conds, Bits, [M = 'TAG'(N)|Result], Result, InL, 
			[Var = 'TAG'(N, _Seen)|InL]) :-
     eccs_sys_var(Var), !.
eccs_u_findunifs(spec(M, Type, Dag), Conds, Bits, 
			[M = 'NODE'(N, Seen, Result)|Rs], Rs, InL, OutL) :-
     eccs_u_term_type(Type, _Entry, Labels, Dag),
     eccs_u_findunifs1(Labels, Conds, Bits, Result, [], [Dag = 'TAG'(N, Seen)|InL], OutL).

eccs_u_findunifs1(Labels, Conds, Bits, R1, R3, InL, OutL) :-
        Labels =.. [Op, S1, S2],
        eccs_not_eq(Op, ':'),
        !,
        eccs_u_findunifs(S1, Conds, Bits, R1, R2, InL, O1),
        eccs_u_findunifs(S2, Conds, Bits, R2, R3, O1, OutL).
eccs_u_findunifs1(S:Ss, Conds, Bits, Res, ResOut, InL, Out) :-
        eccs_u_ful(S:Ss, Conds, Bits, Res, ResOut, InL, Out).

eccs_u_ful(L:R, Conds, Bits, Res, ResOut, Inl, Out) :-
        !,
        eccs_u_findunifs(L,Conds, Bits, Res, Res1, Inl, O1), 
        eccs_u_ful(R, Conds, Bits, Res1, ResOut, O1, Out).
eccs_u_ful(L, Conds, Bits, Res, ResT, Inl, Out) :-
        eccs_u_findunifs(L, Conds, Bits, Res, ResT, Inl, Out).

eccs_p_assq(X = B, [A = B|_]) :-
        X == A, !.
eccs_p_assq(X = Y, [_|T]) :-
        eccs_p_assq(X = Y, T).


/*

eccs_map_findunifs(FSs, PrintSpecs)

Find relevant unifications across a list of feature structures.
Things such as lexical rules can be coerced to lists and then 
taken apart by the relevant routine.

*/

eccs_map_findunifs(FSs, PrintSpecs, OutL) :-
    eccs_zero(node),
    eccs_zero(index),
    eccs_zero(fs_count),
    eccs_u_mapfindunifs(FSs, [], PrintSpecs, OutL).

eccs_u_mapfindunifs([], Out, [], Out) :- !.
eccs_u_mapfindunifs([H:C:B|T1], In, [R|T2], Out) :-
    eccs_get_from_database(term_structure, top_level_type, T),
    eccs_u_findunifs(spec('DUMMY', T, H), C, B, [R], [], In, Out1), !,
    eccs_u_mapfindunifs(T1, Out1, T2, Out).

eccs_u_print(Dag, Tab, Col, N) :-
    eccs_print_real_fs(Dag, Tab, Col, N).

eccs_print_real_fs(FS, Tab, Col, N) :-
    eccs_print_real_fs(FS, Tab, Col),
    eccs_sys_nl.

eccs_print_real_fs([], Tab, Col).
eccs_print_real_fs([Label = Value|FS], Tab, Col) :-
    (eccs_sys_atomic(Value); Value = 'TAG'(Tag)), !,
    eccs_sys_tab(Tab),
    eccs_sys_write(Label),
    eccs_sys_write(':'),
    eccs_sys_if_then_else(Value = 'TAG'(Tag),  
  			  (eccs_sys_write(' #'), eccs_sys_write(Tag)), 
			  eccs_sys_write(Value)),
    eccs_sys_if_then_else(FS = [], 
    		(eccs_sys_write(']')),
		(eccs_sys_write(','),  eccs_sys_nl, eccs_print_real_fs(FS, Col, Col))).
eccs_print_real_fs([Label = Value|FS], Tab, Col) :-
    Value = (Tag # V1), !,
    eccs_sys_tab(Tab),
    eccs_sys_write(Label),
    eccs_sys_write(': '),
    eccs_sys_write(Tag),
    eccs_sys_write('#['),
    eccs_prlength(Label, LLength),
    eccs_prlength(Tag, TLength),
    Newcol is LLength+TLength+Col +4,     
    eccs_print_real_fs(V1, 0, Newcol), 
    eccs_sys_if_then_else(FS = [], 
    		(eccs_sys_write(']')),
		(eccs_sys_write(','),  eccs_sys_nl, eccs_print_real_fs(FS, Col, Col))).
eccs_print_real_fs([Label = Value|FS], Tab, Col) :-
    eccs_sys_tab(Tab),
    eccs_sys_write(Label),
    eccs_sys_write(':['),
    eccs_prlength(Label, Length),
    Newcol is Length+Col +2, 
    eccs_print_real_fs( Value, 0, Newcol),
    eccs_sys_if_then_else(FS = [], 
    		(eccs_sys_write(']')),
		(eccs_sys_write(','),  eccs_sys_nl, eccs_print_real_fs(FS, Col, Col))).
    
    

/*

Turn a term representation into a graph.  We assume that at this point 
Dag is ground

*/

eccs_term_to_fs(['DUMMY' = 'NODE'(_, _, L)], X) :-
    !,
    eccs_term_to_fs(L, X, []).
eccs_term_to_fs(['DUMMY' = 'TAG'(N)], 'TAG'(N)).


eccs_term_to_fs([], [], []). 
eccs_term_to_fs([F|R], Dag1, Tail) :-
    eccs_term_to_fs(F, Dag1, T1),
    eccs_term_to_fs(R, T1, Tail).
eccs_term_to_fs(Label = 'TAG'('UNREF'), Tail, Tail) :-
    !.
eccs_term_to_fs(Label = Atom, [Label = Atom|Tail], Tail) :-
    eccs_sys_atomic(Atom), !.
eccs_term_to_fs(Label = 'TAG'(N), [Label = 'TAG'(N)|Tail], Tail) :-
    !.
eccs_term_to_fs(Label = 'NODE'(Tag, Seen, Value), [Label = Tr|Tail], Tail) :-
    eccs_sys_if_then_else(seen == Seen, Tr = (Tag#V1), Tr = V1),
    eccs_term_to_fs(Value, V1, []).
/*eccs_term_to_fs('NODE'(Label, Tag), [Label = (#Tag)|Tail], Tail).
eccs_term_to_fs('PRINT_ME'(Label, _, Value, _), [Label = Value|Tail], Tail).
eccs_term_to_fs('LEAF'(Label, Value), [Label = Value|Tail], Tail).
eccs_term_to_fs('OP'(Op, Left, Right),  V1, Tail) :-
    eccs_sys_functor(Dag, Op, 2),
    eccs_once(eccs_u_term_type(Type, _Entry, Labels, Dag)),
    arg(1, Labels, spec(Label1, _, _)),
    arg(2, Labels, spec(Label2, _, _)),
    eccs_term_to_fs(Left, V1, V2),
    eccs_term_to_fs(Right, V2, Tail).*/

    		      
    





/*---------------------------------------------------------------------------+
|                                                                            |
|        eccs_u_print(Dag:Con:Bits, Tab, Col, N)                                  |
|                                                                            |
|        Print out the Dag offset by Tab.  Dag, is the result of             |
|        eccs_u_findunifs/2, and so is ground. N tells us how deep we are in the  |
|        dag.                                                                |
|                                                                            |
+---------------------------------------------------------------------------*/
/*
eccs_u_print('NODE'(Lab, N), _Tab, _, Depth) :- !,
        eccs_u_lab(Lab, Depth),
%       tab(_Tab),
        write('#'), write(N).
eccs_u_print('NODE'(Lab, _N, L, unseen), Tab, Col, Depth) :- !,
        (eccs_not_eq(Depth, 0),
         Lab == active
                -> write('('), Bracket = true; true),
        eccs_u_lab(Lab, Depth),
        eccs_u_print(L, Tab, Col, Depth),
        (Bracket == true -> write(')') ; true),
        !.
eccs_u_print('NODE'(Lab, N, L, seen), Tab, Col, Depth) :-
        !,
        eccs_u_lab(Lab, Depth),
        eccs_succ(Depth, Depth1),
        write(N), write('#('),
        eccs_u_print(L, Tab, NewCol, Depth1),
        write(')').
        
eccs_u_print('PRINT_ME'(M, _N, Result, unseen), _, _, _Depth) :- !,
        eccs_u_lab(M, _Depth), 
        write(Result).
eccs_u_print('PRINT_ME'(M, N, Result, seen), _, _, _Depth) :- !,
        eccs_u_lab(M, _Depth), 
        write(N), write('#('),
        write(Result), write(')').
eccs_u_print([], _, _, _) :- !.
eccs_u_print([NODE|T], Tab, Col, Depth) :-
        !,
        eccs_succ(Depth, Depth1),
        eccs_u_print(NODE, Tab, Col, Depth1),
        (Depth = 0 -> nl; T = [_|_] ->write(':'); true),
        eccs_u_print(T, Col, Col, Depth).

eccs_u_print('LEAF'(Lab, Value), _, _, Depth) :-
        !,
        eccs_u_lab(Lab, Depth),
        write(Value).
eccs_u_print('OP'('.', Arg1, Arg2), _, _, Depth) :- !,
        eccs_succ(Depth, Depth1),
        write('['),
        eccs_u_printl('OP'('.', Arg1, Arg2), _, _, Depth1).
eccs_u_print('OP'(OP, Arg1, Arg2), _, _, Depth) :-
        eccs_succ(Depth, Depth1),
        eccs_u_print(Arg1, _, _, Depth1),
        write(OP),
        eccs_u_print(Arg2, _, _, Depth1).
*/

eccs_u_printl('OP'('.', Arg1, 'NODE'(_A, _B, 'OP'(., A1, A2), _Seen)), 
                _, _, Depth) :- !,
        eccs_succ(Depth, Depth1),
        eccs_u_print(Arg1, _, _, Depth1),
        write(','),
        eccs_u_printl('OP'(., A1, A2), _, _, Depth).
eccs_u_printl('OP'('.', Arg1, 'LEAF'(_, [])), _, _, Depth) :- !,
        eccs_succ(Depth, Depth1),
        eccs_u_print(Arg1, _, _, Depth1),
        write(']').
eccs_u_printl('OP'('.', Arg1, Arg2), _, _, Depth) :-
        eccs_succ(Depth, Depth1),
        eccs_succ(Depth, Depth1),
        eccs_u_print(Arg1, _, _, Depth1),
        write('|'),
        eccs_u_print(Arg2, _, _, Depth1),
        write(']').


eccs_p_ppval(X, _Tab, _Col) :-
        (eccs_sys_var(X) -> eccs_p_genvar(X);
         atomic(X)), !,
        write(' = '), write(X), nl.
eccs_p_ppval(l(F, Rest, Tail), Tab, Col) :- !,
        tab(Tab), write(':first'),
        NTab is Col + 6,
        eccs_p_ppval(F, 0, NTab),
        tab(Col), write(':rest'), 
        NTab1 is Col + 5,
        eccs_p_ppval(Rest, 0, NTab1),
        (nonvar(Tail) -> tab(Col), 
                         write(':tail'), 
                         NTab2 is Col + 5,
                         eccs_p_ppval(Tail, 0, NTab2);
                        true).

eccs_u_lab(Label, 1) :- !, write(Label), eccs_prlength(Label, N),
                tab(15 - N).
eccs_u_lab(_, _).
eccs_p_ppval('OR'(Real, Disj), Tab, C) :- !,
        (nonvar(Real) -> eccs_p_ppval(Real, Tab, C);
         Disj = [H] -> tab(Tab), eccs_p_ppval(H, Tab, C);
         Disj = [H|T] -> tab(Tab), eccs_p_ppval(H, Tab, C),
                              tab(C), write(or), nl,
                              eccs_p_ppval('OR'(_, T), C, C)).
eccs_p_ppval('NOT'(Real, Neg), Tab, C) :- !,
        (nonvar(Real) -> eccs_p_ppval(Real, Tab, C);
                        write(' = ~'), eccs_p_ppval(Neg, 0, C + 4)).

eccs_p_ppval(X, Tab, Col) :-
        eccs_p_ppdag(X, Tab, Col).

/*---------------------------------------------------------------------------+
|                                                                            |
|        eccs_p_ppor(Paths, Real, Disjuncts, Tab, Col)                            |
|                                                                            |
|        print a disjunctive constraint, which may be a full DAG (i.e.       |
|        Paths is not []                                                     |
|                                                                            |
+---------------------------------------------------------------------------*/
eccs_p_ppor(Paths, Real, [[_DisjH|_T]], Tab, Col) :- 
        nonvar(Real), !,
        (Paths = [] -> eccs_p_ppdag(Real, Tab, Col);
                       eccs_p_ppdag4(Paths, Real, Tab, Col)).
eccs_p_ppor([], _Real, [[DisjH|T]], Tab, Col) :- !,
        mapmerge([DisjH|T]), 
        eccs_p_ppdag(DisjH, Tab, Col).
eccs_p_ppor([], Real, [[DisjH|T]|Rest], Tab, Col) :- !,
        mapmerge([DisjH|T]), 
        eccs_p_ppdag(DisjH, Tab, Col),
        tab(Col), write('or'), nl,
        eccs_p_ppor([], Real, Rest, Col, Col).
eccs_p_ppor(Paths, _Real, [[DisjH|T]], Tab, Col) :-
        mapmerge([DisjH|T]), 
        eccs_p_ppdag4(Paths, DisjH, Tab, Col).
eccs_p_ppor(Paths, _Real, [[DisjH|T]|Rest], Tab, Col) :-
        mapmerge([DisjH|T]), 
        eccs_p_ppdag4(Paths, DisjH, Tab, Col),
        tab(Col), write('or'), nl,
        eccs_p_ppor([], Rest, Col, Col).

/***********************************************************************/
/*                                                                      *
/*       eccs_p_mappp(L, TAB)                                                *
/*                                                                      *
/*       (pimp_map_prettyprinter)                                       *
/*                                                                      *
/*       work through a list of dags, printing them with TAB offset     *
/*       Used when we need to maintain a set of unifications across     *
/*       a set of DAGs                                                  *
/*                                                                      *
/***********************************************************************/
eccs_p_mappp([], _) :- !.
eccs_p_mappp([H:C:B|T], Tab) :- 
                eccs_p_print(H, Tab, Tab), 
                eccs_p_pconstraints(C),
                line_of_eqs,
                eccs_p_mappp(T, Tab).



eccs_p_pconstraints([]) :- !.
eccs_p_pconstraints([[]|T]) :- !, eccs_p_constraints(T).
eccs_p_pconstraints(X) :- 
        eccs_p_message(['The',following, constraints, are, in, 'force:']),  
        eccs_p_pconstraints1(X).

eccs_p_pconstraints1([]) :- !.
eccs_p_pconstraints1([H|T]) :- eccs_p_pconstraints1(H), eccs_p_pconstraints1(T).
eccs_p_pconstraints1('C'(V, X)) :- 
        eccs_sys_var(V), !,
        write(detached),
        eccs_p_ppval(X, 2, 10).
eccs_p_pconstraints1('C'(V, X)) :- 
        atomic(V), !,
        write(V),
        eccs_p_ppval(X, 9, 10).
eccs_p_pconstraints1('C'(V, X)) :- 
        eccs_p_ppval(V, 0, 10),
        eccs_p_message([has, the, 'constraint:']),
        eccs_p_ppval(X, 0, 10).

eccs_p_plr(lr(In:IC:IB, Out:OC:OB)) :-
        eccs_p_message(['The', in, 'DAG', 'is:']),
        eccs_p_ppdag(In),
        eccs_p_pconstraints(IC),
        eccs_p_message(['The', out, 'DAG', 'is:']),
        eccs_p_ppdag(Out),
        eccs_p_pconstraints(OC).


eccs_bits_member_eq(bits(Term0,Bits),[bits(Term1,Bits)|_]) :-
  Term0 == Term1.
eccs_bits_member_eq(A,[_|Y]) :-
  eccs_bits_member_eq(A,Y).

eccs_u_term_type(Type, Entry, Labels, Term) :-
        eccs_u_atom_or_list(T, Type), 
        eccs_get_from_database(term_structure, T, term_structure(T, Labels, Entry1, Term)),
        \+ \+ (Entry1 = Entry),
        ((functor(Entry1, ':', 2), nonvar(Entry)) ->
                eccs_u_colon_subsumes(Entry1, Entry);
                true).

eccs_u_colon_subsumes(Entry1, _Entry) :- 
        var(Entry1), !.
eccs_u_colon_subsumes(Entry1, Entry) :-
        functor(Entry1, ':', 2),
        nonvar(Entry),
        functor(Entry, ':', 2),
        arg(2, Entry1, E1),
        arg(2, Entry, E),
        eccs_u_colon_subsumes(E1, E).

eccs_u_atom_or_list(A, A) :- eccs_sys_atomic(A), !.
eccs_u_atom_or_list(A, L) :- eccs_member(A, L).

eccs_p_genvar(Var) :-
    eccs_sys_var(Var), !,
    eccs_increment(fs_count, N),
    eccs_sys_if_then_else(N > 26, (M is N mod 26, eccs_set_counter(fs_count, M)), true),
    Char is N + 64,
    eccs_sys_name(Var, [Char]).

eccs_make_var(Symbol, Print) :-
    eccs_increment(index, N),
    eccs_concat(Symbol, N, Print).
    

/*

Printers for the different object types

It's up to these routines to take apart any terms that are stored in 
the database.

eccs_print_template(Name, Template)

*/

eccs_print_template(_, Name, Template) :-
    Template = template(Name, Alias, Defn),
    eccs_sys_if_then_else(Alias == alias, As = (aliases), As = (=>)),
    eccs_sys_write(Name), eccs_sys_write(' '), 
    eccs_sys_write(As), eccs_sys_nl,
    eccs_printfs(Defn).

eccs_print_lexical_entry(_, Name, Defn, captioned(Caption, STDform)) :-
    
    eccs_interpolate_char(' ', ['The', lexical, entry, '"', Name, '"'], C),
    eccs_concat_list(C, Caption),
    eccs_printfs(Defn, STDform).

eccs_print_grammar_rule(_, Name, Rule, STDForm) :-
    Rule = rule(Mother, Daughters),
    STDForm = captioned(Caption, infix(symbol(arrowright), M1, parenth(D1))),
    eccs_map_findunifs([Mother|Daughters], [M|Ds], OutL),
    eccs_number_rentrant_structures(OutL, 1, _),
    eccs_interpolate_char(' ', ['The', grammar, 'rule:', '"', Name, '"'], C1),
    eccs_concat_list(C1, Caption),
    eccs_u_print_list([M|Ds], [M1|D1]).
    
%    (eccs_member(DSpec, Ds), eccs_u_print(DSpec, 10, 0, 0), fail; true).

     
eccs_print_lexical_rule(_, Name, LRule) :-
    LRule = lexical_rule(In, Out),
    eccs_map_findunifs([In, Out], [I1, O1]),
    eccs_sys_write('Lexical rule '),
    eccs_sys_write(Name), eccs_sys_write(' has the definition:'), 
    eccs_sys_nl,
    eccs_sys_write('in:  '),
    eccs_u_print(I1, 5, 5, 0),
    eccs_sys_write('out: '),
    eccs_u_print(O1, 5, 5, 0).

eccs_u_print([], []).
eccs_u_print([F=V|R], avm(AVM)) :-
    eccs_u_print_avm([F=V|R], AVM).
eccs_u_print(Atom, atomic(Atom)) :-
    eccs_sys_atomic(Atom), !.
eccs_u_print('TAG'(N), tag(N)) :- !.
eccs_u_print((N # FS), tagged_avm(N, FS1)) :-
    eccs_u_print_avm(FS, FS1).

eccs_u_print_avm([], []).
eccs_u_print_avm([F=[]|R], [F=uninstantiated|R1]) :-
    !,
    eccs_u_print_avm(R, R1).
eccs_u_print_avm([F=V|R], [F=V1|R1]) :-
    eccs_u_print(V, V1),
    eccs_u_print_avm(R, R1).

eccs_u_print_list(L, L1) :-
    eccs_u_print_list(L, L1, 1, _).

eccs_u_print_list([], [], N, N).
eccs_u_print_list([F|R], [F1|T1], N, M) :-
    eccs_term_to_fs([F], Print),
    eccs_u_print(Print, F1),
    eccs_u_print_list(R,T1, N, M).
