/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 09:53:06 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Sort/RCS/unpack.pl,v $',
	'$State: Exp $').

$Log: unpack.pl,v $
% Revision 1.0  1993/05/04  09:53:06  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  13:48:20  pleuk
% revisions from SLE - April 1992
%
% Revision 0.7  1992/01/24  12:17:53  pleuk
% revisions from Jo - January 1992
%
% Revision 0.6  1991/09/02  13:36:11  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.1  1991/03/06  13:45:50  pleuk
% *** empty log message ***
%

*/
/*


The Protolexicon and PIMPLE grammar development system.

Copyright 1986, 1989, 
University of Edinburgh, Centre for Cognitive Science.

These files may not be redistributed in any form 
without prior permission.

Contact: jo@uk.ac.ed.epistemi

Jonathan Calder
University of Edinburgh
Centre for Cognitive Science
2 Buccleuch Place
Edinburgh
Scotland
EH8 9LW

'SCCSId'('%M%', '%I%', %R%').

*/

eccs_unpack([],[]).
eccs_unpack([H|T],Ln) :-
  eccs_get_from_database(sort_definition, number_of_models, Num),
  eccs_reverse([H|T],L0),
  eccs_unpack0(1,Num,L0,Ln).

eccs_unpack0(_,_,[],[]) :- !.
eccs_unpack0(Num0,Num,[A|B],Ln) :-
  eccs_unpack1(1,Num0,Num1,Num,A,Ln,L0),
  eccs_unpack0(Num1,Num,B,L0).

/* The exponentiation operator which Jo originally used here is not supported
 * by Quintus, so I (CHB) replaced it with a logical left shift in the
 * following predicates
 */
eccs_unpack1(28,Num0,Num1,_,A,L,L) :-
  0 is ((01 << 27) /\ A), !,
  eccs_succ(Num0, Num1).
eccs_unpack1(28,Num0,Num1,_,_A,[Num0|L],L) :- !,
  eccs_succ(Num0, Num1).
eccs_unpack1(Pos,Num,_,Num,A,L,L) :-
  0 is ((01 << (Pos-1)) /\ A), !.
eccs_unpack1(_Pos,Num,_,Num,_A,[Num|L],L) :- !.
eccs_unpack1(Pos,Num0,Num2,Num,A,Ln,L0) :-
  0 is ((01 << (Pos-1)) /\ A), !,
  eccs_succ(Pos, Pos1),
  eccs_succ(Num0, Num1),
  eccs_unpack1(Pos1,Num1,Num2,Num,A,Ln,L0).
eccs_unpack1(Pos,Num0,Num2,Num,A,[Num0|Ln],L0) :-
  eccs_succ(Pos, Pos1),
  eccs_succ(Num0, Num1),
  eccs_unpack1(Pos1,Num1,Num2,Num,A,Ln,L0).

