/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 09:53:06 $',
	'$Revision: 1.0 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/Sort/RCS/sortmodule.pl,v $',
	'$State: Exp $').

$Log: sortmodule.pl,v $
% Revision 1.0  1993/05/04  09:53:06  pleuk
% Version 1.00beta from Jo
%
% Revision 0.11  1992/04/16  13:48:20  pleuk
% revisions from SLE - April 1992
%
% Revision 0.7  1992/01/24  12:17:53  pleuk
% revisions from Jo - January 1992
%
% Revision 0.6  1991/09/02  13:35:02  pleuk
% revisions up to SLE visit 20 August 1991
%
% Revision 0.1  1991/03/06  13:45:50  pleuk
% *** empty log message ***
%

*/

:- eccs_srcload(['sortops.pl', 'bits.pl', 'type.pl', 
		 'sort.pl', 'unpack.pl', 'dm_reader.pl']).


/*

readers for the sort system files

*/

eccs_axiom_file_reader(_, Name, Type, Definition) :-
    eccs_sys_read(X), 
    eccs_well_formed_axiom(X, Name, Type, Definition).

eccs_well_formed_axiom(end_of_file, _, _, end_of_file).
eccs_well_formed_axiom(properties(X), properties, properties, X).
eccs_well_formed_axiom(axiom(X), axiom, axiom, X).

eccs_sort_definition_reader(_, Name, Type, Definition) :-
    eccs_sys_read(X), 
    eccs_well_formed_sort_definition(X, Name, Type, Definition).

eccs_well_formed_sort_definition(end_of_file, _, _, end_of_file).
eccs_well_formed_sort_definition(sort_definition(Name, Formula), 
				 sort, sort_definition, sort_definition(Name, Formula)). 
eccs_well_formed_sort_definition(dm_test(Relations, R1, R2), dm_test, dm_test, dm_test(Relations, R1, R2)).



/* 

"Compilation" routines for the sort system.  Most of these are the identity mapping
and the real action is in the global endcoding routines called as a posthook to the 
definitions of sorts.

*/

eccs_axiom(axioms, properties, properties, _, List, List, []) :-
    (eccs_get_from_database(properties, properties, _) -> eccs_error([properties, should, have, a, unique, definition]); true).
eccs_axiom(axioms, axiom, axiom, _, Axiom, Axiom, []).

eccs_sort(sorts, sort_definition, sort, _, sort_definition(Sort, Definition), 
			 sort(Sort, Definition), []).
eccs_sort(sorts, dm_test, dm_test, _, dm_test(Relations, Relatum1, Relatum2), 
			    uncompiled_dm_test(Relations, Relatum1, Relatum2), []).



