/*

rcsid('$Author: pleuk $',
	'$Date: 1993/05/04 09:43:01 $',
	'$Revision: 1.60 $',
	'$Source: /usr/export/home/projects/ltg2/Pleuk/Distribution/Pleuk/SLE/RCS/srcparser.pl,v $',
	'$State: Exp $').

$Log: srcparser.pl,v $
% Revision 1.60  1993/05/04  09:43:01  pleuk
% Version 1.00beta from Jo
%
% Revision 1.5  1992/04/16  13:43:35  pleuk
% revisions from SLE - April 1992
%
% Revision 1.4  1992/01/24  12:15:14  pleuk
% revisions from Jo - January 1992
%
% Revision 1.3  1991/10/21  12:51:29  pleuk
% revisions up to SLE visit 10 October 1991
%
% Revision 1.2  1991/09/25  13:11:10  pleuk
% revisions up to SLE tape 27 September 1991
%
% Revision 1.1  1991/09/16  19:20:11  pleuk
% Initial revision
%
% Revision 0.2  1991/07/07  23:51:40  pleuk
% *** empty log message ***
%
% Revision 0.1  1991/03/06  13:14:49  pleuk
% *** empty log message ***
%

Wed Jan  8 10:29:13 1992 JC

This file is now misnamed as it contains not just the CF-based
shift-reduce parser but also a satisfaction routine for single feature
structures and a generator. (These last two are essentially the same
thing).

*/

/*
file:		srcparse.pl
created:	around December 1986
by:		Jo
contents:	A shift-reduce parser with a well-formed substring table.
*/

:- eccs_new_variable(parser, eccs_shift_reduce, parsing, run, 
			"The name of the parser to be used fro analyzing input").

eccs_user_parser_spec(eccs_shift_reduce, 
	[prehook = eccs_clean,
	 fs_drawer = eccs_printfs_from_parse,
	 tree_drawer = eccs_print_tree_from_parse]).

eccs_user_parser_spec(eccs_sle_satisfy_phon, 
	[prehook = true,
	 fs_drawer = eccs_printfs_from_parse,
	 tree_drawer = eccs_print_tree_from_parse]).

/* 

eccs_sle_satisfy_phon is a parser which operates by satisfying a
system of templates, rather than having a rewrite rule backbone.  It's
defined towards the end of this file.

*/

eccs_shift_reduce(_Args, ToParse, Out) :- 
    eccs_clean,
    eccs_post_last_sentence(ToParse),
%    start_stats,
    eccs_global_variable(parser, Parser),
    eccs_parse_top_level(Parser, ToParse, Out).

eccs_parse_top_level(eccs_shift_reduce, String, Results) :- 
	eccs_src_parse(String, 0, End), !, 	% 48 ascii = 0
	eccs_src_find_edges(0, End, D:C:B, Results).


eccs_src_parse( [], End, End).
eccs_src_parse( [H|T], This, End) :-
	eccs_succ(This, Next),
	eccs_src_shift(H,This, Next), !,
	eccs_src_parse(T, Next, End).

% :- dynamic sle_edge/5.

eccs_src_shift(Word, This, Next) :-
	eccs_retrieve_word(Word, D, This, _Real),
	eccs_sys_assertz(sle_edge(Next, This, D, lexical, _), Ref),
	eccs_src_reduce(This, Next, D, Ref). % always fails.
eccs_src_shift(_, _, _).


/*---------------------------------------------------------------------------+
|        								     |
|        eccs_src_reduce(ThisV, NextV, Dag:Conds:Bits, Ref)		     |
|        								     |
|        There is a configuration of edges ending at NextV and ending at     |
|	 ThisV which can be analysed by a rule whose right daughter is	     |
|	 unifiable with Dag:Conds:Bits.					     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_src_reduce(ThisV, NextV, Dag:Conds:Bits, Ref) :-
	'&compiled_rule'(Dag:Conds:Bits, MD:MC:MB, ThisV, StartV, NewConds, NewBits, Name, Ds),
	eccs_once(( eccs_check_constraints([MC, NewConds], ResC), eccs_ck_typ([MB|NewBits], ResB) )),
	eccs_sys_assertz(sle_edge(NextV, StartV, MD:ResC:ResB, Name, [Ref|Ds]), NewRef),
	eccs_src_reduce(StartV, NextV, MD:ResC:ResB, NewRef),
	fail.

eccs_src_reduce(ThisV, NextV, FS, Ref) :-
    eccs_get_from_database(grammar_rule, Name, rule(Mom, [D|Ds])),
    eccs_user_unify(FS, D, Dout),
    eccs_src_match(Ds, ThisV, DausOut, Refs, StartV),
    eccs_check_daus_constraints(DausOut, Residue),
    eccs_graph_plus_constraints(Mom, MG, MCs),
    eccs_opt_append(Residue, MCs, MC1s),
    eccs_check_constraints(MC1s, NewMCs),
    eccs_graph_plus_constraints(Mom1, MG, NewMCs),
    eccs_sys_assertz(sle_edge(NextV, StartV, Mom1, Name, [Ref|Refs]), NewRef),
    eccs_src_reduce(StartV, NextV, Mom1, NewRef),
    fail.

eccs_src_match([], ThisV, [], [], ThisV).
eccs_src_match([RuleD|RuleDs], ThisV, [DOut|DausOut], [Ref|Refs], StartV) :-
    sle_edge(ThisV, PrevV, TableD, _Name, _Structure), 
    eccs_user_unify(RuleD, TableD, DOut),
    eccs_src_match(RuleDs, PrevV, DausOut, Refs, StartV).


eccs_check_daus_constraints(DausOut, Residue) :-
    eccs_strip_cs(DausOut, Cs),
    eccs_flatten(Cs, C1s),
    eccs_check_constraints(C1s, Residue).

eccs_strip_cs([], []).
eccs_strip_cs([GC|GCs], [C|Cs]) :-
    eccs_graph_plus_constraints(GC, _, C),
    eccs_strip_cs(GCs, Cs).




eccs_compile_rules :-
	eccs_sys_abolish('&compiled_rule', 8),
	eccs_get_from_database(grammar_rule, Name, rule(D:DC:DB, Daus)),
	sr_mk_rule(Name, D:DC:DB, Daus),
	fail.
eccs_compile_rules.

% The next two procedures altered to take account of the setting of the 
% global variable ``unification'' JC Wed Jun 15 14:23:54 1988
sr_mk_rule(Name, Mother, [D:C:B|T]) :-
    Term = 
	('&compiled_rule'(D1:RC:RB, MD:MC:MB, ThisV, StartV, [NewC|RestC], [NewB|RestB], Name, Refs) :-
	        eccs_user_unify(D:B:C, D1:RC:RB, NewFS),
 		R,
		eccs_once((eccs_check_constraints([RC, C], NewC), U)),
		eccs_user_unify(MD:MC:MB, _, Mother)), 

    eccs_sys_if_then_else( B == [], 
      U = eccs_ck_typ(RB, NewB) ,
      U = eccs_ck_typ([B|RB], NewB)),
    sr_mk_rule1(T, R, ThisV, StartV, RestC, RestB, Refs),
    eccs_sys_assertz(Term).

sr_mk_rule1([], true, ThisV, ThisV, [], [], []) :- !.
sr_mk_rule1([D:C:B|T], Term, ThisV, StartV, [NewC|RestC], [NewB|RestB], [Ref|RestRef]) :-
	Term = (eccs_sys_recorded(ThisV, s(PrevV, D1:RC:RB, _, _), Ref),
		eccs_user_unify(D:C:B, D1:RC:RB, _),
		R,
		eccs_once((eccs_check_constraints([C, RC], NewC), U))),
	eccs_sys_if_then_else( B == [],
	  U = eccs_ck_typ(RB, NewB),
	  U = eccs_ck_typ([B|RB], NewB) ),
	sr_mk_rule1(T, R, PrevV, StartV, RestC, RestB, RestRef).

/*---------------------------------------------------------------------------+
|        								     |
|        eccs_src_find_edges(Start, End, L)				     |
|        								     |
|        List contains all instances of inactive edges 			     |
|        extending from Start to End.   				     |
|        								     |
+---------------------------------------------------------------------------*/
eccs_src_find_edges(S, E, _, Edges) :- 
    findall(Entry, sle_edge(E, S, Entry, _, _), Edges).


eccs_back_end(List) :-
	eccs_global_variable(back_end, P), !,
	Goal =.. [P, D:C:B],
	eccs_member(s(_, D:C:B, _, _), List),
	call(Goal),
	eccs_pausefail, !, 
	fail.
eccs_back_end(_) :-
	eccs_error([no, back, end, procedure, 'specified.', eccs_sys_nl,
		 use, 'set(back_end, ProcedureName)']).


/*

Database manipulation

*/

eccs_clean :- 
        eccs_sys_retractall(eccs_last_sentence_analysis(_,_,_)),
	eccs_global_variable(eccs_last_sentence, S), !,
	eccs_length(S, N), E is 48 + N,
	eccs_srcclean.

eccs_srcclean :-
    eccs_sys_retractall(sle_edge(_, _, _, _, _)),
    eccs_sys_retractall(sle_chart(_)).



eccs_retrieve_word(Word, D, This, _Real) :-
    eccs_get_from_database(lexical_entry, Word, D).
eccs_retrieve_word(Word, D, This, _Real) :-
    eccs_get_from_database(pderived_entry, Word, D).



/* ----------------------------------------------------------------------

Additions to allow a parser which is just a satisfaction routine for a 
system of templates.  

eccs_sle_satisfy_phon(Args, String, Results).

String is a shorthand for some phonology specification which is
satisfiable as an instantiation of the template given as
top_level_template.

Certain aspects of these routines are overspecific.  Some call out
should be provided for arbitrary routines to massage the input into
the right form.

---------------------------------------------------------------------- */


eccs_sle_satisfy_phon(_Args, ToParse, Outs) :-
    eccs_global_variable(top_level_template, T),
    eccs_sys_retractall(eccs_last_sentence_analysis(_,_,_)),
    eccs_post_last_sentence(ToParse),
    eccs_map_list_to_phon(ToParse, Phon),
    P1 = Phon:[],
    findall(Out, (template(T, _, _, template(_, _, Def)),
    		 eccs_user_unify(P1, Def, Out)), Outs).

:- eccs_new_variable(top_level_template, sign, parsing, run, 
	"Any input string should correspond to an instantiation of the named template's definition").

eccs_map_list_to_phon(List, [phon = R|_]) :-
    eccs_map_list_to_phon1(List, R).

eccs_map_list_to_phon1([], nil).
eccs_map_list_to_phon1([F|R], [first = F, rest = Rest |_]) :-
    eccs_map_list_to_phon1(R, Rest).


/*

stuff for trivial generation

*/

/*  The menu for generation is in sletemplates.pl
    so that we don't get redefinition errors.
*/

eccs_do_generate :-
    eccs_do_menu(generatedbox).


eccs_generate(N, _) :-
    eccs_length(String, N), 
    eccs_map_list_to_phon(String, Phon),
    P1 = Phon:[],
    eccs_global_variable(top_level_template, T),
    template(T, _, _, template(_, _, Def)),
    eccs_user_unify(Def, P1, Out),
    eccs_interpolate_char(' ', [generating, strings, of, length, N], Caption1),
    eccs_concat_list(Caption1, Caption),
    eccs_print_result1(Caption, Out),
    (eccs_do_menu(confirm, [alert = ['Would you like another generation']]) ->
    	fail; !, fail).
eccs_generate(_, _) :-
    eccs_to_user([no, more, generations]).
