/*  
rcsid('$Id: sledebug.pl,v 1.60 1993/05/04 09:43:01 pleuk Exp $').
$Log: sledebug.pl,v $
% Revision 1.60  1993/05/04  09:43:01  pleuk
% Version 1.00beta from Jo
%
% Revision 1.5  1992/04/16  13:44:19  pleuk
% revisions from SLE - April 1992
%
% Revision 1.4  1992/02/11  10:29:12  chrisbr
% Changes to parser and debugging routines. Dead code removed
%
% Revision 1.3  1992/02/07  17:38:43  pete
% improved chart display and allowed minimum edge length to be varied
% by user.
% known bug: if minimum_edge_length is reset, it has no effect on
% vertex spacing until a new sentence is parsed
%
% Revision 1.2  1992/01/17  09:42:40  chrisbr
% *** empty log message ***
%
 -- debugging utilities for Pleuk, CHB December 1991
EXPORTS test_assertions/0  -- test current assertions
        assertion/2        -- assert a relation which should hold of
                              a predicate and its models
        init_assertions/0  -- remove all assertions
        sle_profile_start/0
        sle_profile_stop/0

*/
:- multifile '$assertion'/2.
:- dynamic '$assertion'/2.
/* Profiling code not yet properly thought out , so the following two predicates
 * are commented out. Problem is that in order to profile code one needs to 
 * recompile it, and that an overwhelmingly wide range of profiling information
 * then becomes available. See pp60-61 of the Sicstus 0.7 manual for more information.
 * (Also, the whole thing is non-portable ....
 */



/* assertion/2 -- add a clause saying what the results of calling something 
               -- should be. 
               -- If it is already known do nothing, 
	       -- If a different answer is given fail with a message
 */


init_assertions :-
	retractall('$assertion'(_X,_Y)).

assertion(X,Y) :-
	'$assertion'(X, Y),!.
assertion(X,Y) :-
	'$assertion'(X, Y1),!, write([inconsistent, assertion,X,Y,Y1]),nl,fail.
assertion(X,Y) :-
	assert('$assertion'(X,Y)),!.
 

/* test_assertions/0 -- scan all clauses of $assertion/2 and try the
                        calls specified checking against the results
 */

test_assertions :-
	'$assertion'(Term, Results),
	try_assertion(Term, Results),
	fail.
test_assertions.

try_assertion(X,Y) :-
	bagof(X,X,Z),
	compare_solutions(X,Y,Z).

compare_solutions(_, X, X) :- !.
compare_solutions(X, Y, Z) :-
	write('Test '), write(X), nl,
	write('Expected: '),write(Y), nl,
	write('Actual: '), write(Z), nl,
	eccs_flush_output.  % kwh - 2/4/92


/* debugging tools culled from srcparser.pl */

:- dynamic sle_chart/1.

eccs_show_debug_chart :-
    (sle_chart(Chart) -> true; eccs_sle_dump_chart(Chart)),
    eccs_print_debug_chart(Chart), eccs_flush_output, !.
% cut added by CHB December 1991, otherwise backtracking into this
% code makes a mess on the screen.
% flush added by kwh 2/4/92


/* eccs_sle_dump_chart -- save the chart - CHB, December 1991 */
/* we now need access predicates for the elements of the chart, and
   a way of getting them from menus
 */
eccs_sle_dump_chart(Chart) :-
    eccs_sys_retractall(sle_chart(_)),
    eccs_make_debug_chart(Chart),
    eccs_sys_assertz(sle_chart(Chart)).


/*
eccs_make_debug_chart/1
Note that we turn the start and end positions in the term around

*/

eccs_make_debug_chart(chart(Pattern, Numbered)) :-
    Edge = sle_edge(Start, End, FS, SubS, Refs, Ref, _ID),
    findall(Edge,
    eccs_sys_clause(sle_edge(End, Start, FS, SubS, Refs), _, Ref), Edges),
    (Edges = [] -> eccs_message([no, elements, in, chart]), fail; true),
    eccs_sort(Edges, Es),
    eccs_partition_lexical(Es, Lex, NonLex),
    eccs_append(Lex, NonLex, E1s),
    eccs_number_edges(E1s, Numbered),
    eccs_global_variable(eccs_last_sentence, S),
    eccs_length(S, N),
    eccs_ensure_variable(minimum_edge_length,10,printing,run,
	"the length of a lexical edge in characters when drawing chart"),
    eccs_make_pattern(0, N, S, Pattern).


eccs_partition_lexical([], [], []).
eccs_partition_lexical([Edge|Es], [Edge|Ls], NonLs) :-
    Edge = sle_edge(_Start, _End, _FS, lexical, _Refs, _Ref, _ID), % singleton vars CHB
    !,
    eccs_partition_lexical(Es, Ls, NonLs).
eccs_partition_lexical([Edge|Es], Ls, [Edge|NonLs]) :-
    eccs_partition_lexical(Es, Ls, NonLs).

/*

Compute by how much to separate the vertices and gather
together the lexical edges for the individual nodes.

Changed so that words are chopped to their first N characters
where N is value of global variable minimum_edge_length

*/

eccs_make_pattern(N, N, [], []) :- !.
eccs_make_pattern(I, N, [W|Ws], [v(_Length, I, J, PadW)|P]) :-
    eccs_global_variable(minimum_edge_length, Length),
    eccs_prlength(I,IN),
    AdjustedLength is Length - IN + 1,
    padword(AdjustedLength,W,PadW),
    J is 1 + I,
    eccs_make_pattern(J, N, Ws, P).

/*
padword(Length,W,PadW)
PadW is W truncated or padded to Length
*/

padword(Length,W,PadW) :-
    name(W,ChW),
    padword1(Length,ChW,ChPadW),
    name(PadW,ChPadW).

padword1(0,[],[]) :- !.		% finished padding
padword1(1,[X],[X]) :- !.	% exactly right length
padword1(1,[_,_|_],"-") :- !.	% mark truncation
padword1(N,[],[X|T1]) :-
	[X] = " ",
	N1 is N-1,
	padword1(N1,[],T1).
padword1(N,[H|T],[H|T1]) :-
	N1 is N-1,
	padword1(N1,T,T1).


eccs_number_edges(Es, Es) :-
    eccs_number_edges(1, Es).

eccs_number_edges(_, []).
eccs_number_edges(I, [E|Es]) :-
    eccs_succ(I, J),
    eccs_sys_arg(7, E, I),
    eccs_number_edges(J, Es).



/*

Printing the debug chart


eccs_print_debug_chart(chart(Pattern, Edges))

Format and print

*/

eccs_print_debug_chart(chart(Pattern, Edges)) :-
    eccs_print_pattern(Pattern),
    eccs_print_edges(Pattern, Edges), eccs_sys_nl.

eccs_print_pattern(P) :-
    eccs_sys_write(0),
    eccs_print_pattern1(P).


eccs_print_pattern1([]) :- eccs_sys_nl.
eccs_print_pattern1([v(_Length, _, N, Word)|P]) :-
    eccs_sys_write(' '),
    eccs_sys_write(Word),
    eccs_sys_write(' '),
    eccs_sys_write(N),
    eccs_print_pattern1(P).

eccs_print_edges(_Pattern, []) :- !.
eccs_print_edges(Pattern, [F|R]) :-
    eccs_print_line(Pattern, [F|R], Out),
    eccs_print_edges(Pattern, Out).

eccs_print_line([], Out, Out) :-
    eccs_sys_nl, !.
eccs_print_line([v(_Length, Start, _End, _Word)|P], In, Out) :-  % CHB - singleton vars
    Edge = sle_edge(Start, EdgeEnd, _FS, _SubS, _Refs, _Ref, ID),
    eccs_delete(Edge, In, In1),
    !,
    eccs_sys_write(' < '),
    eccs_sys_write(ID),
    eccs_prlength(ID, N),
    eccs_global_variable(minimum_edge_length, Length),
    % following changed so that chart stops slipping to right pjw
    eccs_sys_tab(Length - (N+1)),
    eccs_print_line1(EdgeEnd, P, In1, Out).
eccs_print_line([v(_Length, _Start, _End, _Word)|P], In, Out) :-  % CHB - singleton vars
    eccs_global_variable(minimum_edge_length, Length),
    % following changed so that chart stops slipping to right pjw
    eccs_sys_tab(Length + 3),
    eccs_print_line(P, In, Out).


/*

Looking for another element to print on this line
Actually this is a totally misleading comment
print_line1 prints the rest of an edge, and
calls print_line to find another element to print
on this line

*/

eccs_print_line1(_, [], R, R) :-
    eccs_sys_write('>'),
    eccs_sys_nl, !.
eccs_print_line1(Start,[v(Length, Start, End, Word)|P], In, Out) :-
    eccs_sys_write('>'),
    eccs_print_line([v(Length, Start, End, Word)|P], In, Out).
eccs_print_line1(Start, [v(_N, _, _, _)|P], In, Out) :-
    eccs_global_variable(minimum_edge_length, Length),
    eccs_sys_tab(Length+3),
    eccs_print_line1(Start, P, In, Out).
/* the following predicate shows what edges contain, is called from the
 * debugging menu, which is defined in slemenus.pl
 */
sle_edge_show(X) :-
	sle_chart(chart(_,Edges)),
	number(X),
	eccs_member(sle_edge(N1, N2, FS, _, _,_Ref, X), Edges),
	sle_edge_show(FS, N1, N2),
	eccs_flush_output.    % added by kwh.
/* Would probably be good to define a set of reporting routines
 * which go to a trace window, making it easier to channel output
 * from debugging routines to the right place
 */
sle_edge_show(FS,N1, N2):-
        eccs_sle2std(FS, Std),!,
	eccs_sys_write(edge(N1,N2)),
	eccs_sys_nl,
	eccs_dumb_draw_fs(Std),
	eccs_sys_nl, eccs_sys_nl.


/*
 * Given the name of a predicate, display the name of a file containing a
 * definition of a predicate, of any arity, with that name.
 */

sle_predicate(Predicate):-
        eccs_sys_current_predicate(Predicate, Term),
	source_file(Term,File),
	eccs_sys_write([Term, defined,in, File]),
	eccs_sys_nl.
/* Hacky editor interface for Prolog source files  CHB - 1/92 */

eccs_edit_source_file(Predicate) :-   % sicstus specific due to use of source_file
	eccs_sys_current_predicate(Predicate,Term),
	eccs_once(source_file(Term,File)), % multiple arity items not supported!
	eccs_user_editor(X),
	eccs_unix_format_and_call([X, File]).


/* Hooks for debugging menu ...
 * We will assume that we get an atom, but really want to
 * trace all templates with that functor. So we need to
 * ensure that we can find all templates with a given functor...
 * Not done yet..and could wait until we can get non-atom input
 * from the menus. 

call to eccs_atom_to_functor added by kwh - 2/4/92
 */
template_spy(TemIn) :-
	eccs_atom_to_functor(TemIn, Tem),
	sle_spy(Tem) -> true ; eccs_sys_assert(sle_spy(Tem)).
template_unspy(TemIn) :-
	eccs_atom_to_functor(TemIn, Tem),
	sle_spy(Tem) -> eccs_sys_retract(sle_spy(Tem)) ; true.

/*
 * dbgformat/3 -- check debugging level, printing message if it is high enough
 * dbgwait/1 -- wait for user confirmation if debugging level is high enough
 */
dbgformat(Level, F, Args) :-
	eccs_global_variable(debugging_level, Level1),
	(Level > Level1 -> true
	; format(F,Args)
	).
dbgwait(Level) :-
	eccs_global_variable(debugging_level, Level1),
	(Level > Level1 -> true
	; skip(10)
	).


/*
%%
% sle_profile_start/0 -- enable execution profiling
%%
sle_profile_start :-
	eccs_sys_if_then_else(eccs_global_variable(prolog_type, sicstus),
	(eccs_to_user(['Profiling' ,on]),prolog_flag(compiling,_,profiledcode)),
	 eccs_to_user(['No',profiling, available])).
%%
% sle_profile_stop/0 -- disable profiling
%%
sle_profile_stop :-
	eccs_to_user(['End', of,'Profiling..']).
*/
