% The following list of chars_to_list_of_integer predicates is
% inspired, copied or adapted from the qp library.

eccs_atom_to_chars(Atom,Chars,L) :-
	eccs_sys_name(Atom,IntegerList),
	eccs_map_integer_list_to_chars(IntegerList,Chars,L).

eccs_map_integer_list_to_chars([],L,L).
eccs_map_integer_list_to_chars([H0|T],[H:_|L0],L) :-
	eccs_sys_name(H,[H0]),
	eccs_map_integer_list_to_chars(T,L0,L).
	
eccs_chars_to_integer_list([],[]).
eccs_chars_to_integer_list([H0|T0],[H|T]) :-
	eccs_sys_name(H0,[H]),
	eccs_chars_to_integer_list(T0,T).

eccs_chars_to_atom(X0,X) :-
	eccs_string_flatten(X0,X1),
	eccs_chars_to_integer_list(X1,X2),
	eccs_sys_name(X,X2).


%  Another version of flatten, but this time map to format that 
%  chars_to_atom expects from things in constraint list form. 

eccs_string_flatten(X,Y) :-
	eccs_string_flatten(X,[],Y,[]).

eccs_string_flatten(X,R,[X|L0],L) :-
	xvar(X), !,
	eccs_string_flatten(R,[],L0,L).
eccs_string_flatten([],[],L,L) :- !.
eccs_string_flatten([],X,L0,L) :- !,
	eccs_string_flatten(X,[],L0,L).
eccs_string_flatten(0:_,0:_,L,L) :- !.
eccs_string_flatten(0:_,X,L0,L) :- !,
	eccs_string_flatten(X,[],L0,L).
eccs_string_flatten([H0|T0]:_,R,L0,L) :- !,
	eccs_string_flatten(H0,[],L0,L1),
	eccs_string_flatten(T0,[],L1,L2),
	eccs_string_flatten(R,[],L2,L).
eccs_string_flatten([H0|T0],R,L0,L) :- !,
	eccs_string_flatten(H0,[],L0,L1),
	eccs_string_flatten(T0,[],L1,L2),
	eccs_string_flatten(R,[],L2,L).
eccs_string_flatten(X,R,[V|L0],L) :-
	xnonvar(X), !,
	X = V:_, 
	eccs_string_flatten(R,[],L0,L).
eccs_string_flatten(A,R,[A|L0],L) :-
	eccs_string_flatten(R,[],L0,L).

   
