/*
File:	/mnt/jo/Protolexicon/qtemplates.pl
Date:	Wed Apr 20 15:59:17 1988
By:	Jo Calder

Routines for handling templates and lexical rules

*/

/*

eccs_q_templates(Ts, S, S)

structure S corrsponds to the conjunction of information in the templates Ts
The two occurrences of S are there to handle constraint information.

*/

eccs_q_templates(L, S, Morph) :- 
    eccs_user_empty_structure(X),
    eccs_q_templates(L, X, S, m(_, _, _, [], []), Morph).

eccs_q_templates([], S, S, M, M) :- !.
eccs_q_templates([T|R], S, S1, M, Morph) :-
    eccs_get_from_database(template, T, _), !,
    eccs_template1_template(T, S, S2, _, 0, _),	% From templates
    eccs_q_templates(R, S2, S1, M, Morph).
eccs_q_templates([T|R], S, S1, M, Morph) :-
    eccs_q_special(T, M, M1), !,
    eccs_q_templates(R, S, S1, M1, Morph).
eccs_q_templates([T|R], S, S1, MIn, Morph) :-
    (eccs_global_variable(ignore_unknown_templates, true) -> 
    			eccs_q_templates(R, S, S1, MIn, Morph);
    eccs_debug(1, eccs_error([problems, with, template, T]))).
/*
eccs_q_special(Template, MorphIn, MorphOut)

Template is one which should not be directly evaluated.  The info that 
it contains is added to the morphology record m/5.

*/
eccs_q_special(morphology(Cl),m(Cl,St,R,MS,MR), m(Cl,St,R,MS,MR)).
eccs_q_special(morph_stem(St),m(Cl,St,R,MS,MR), m(Cl,St,R,MS,MR)).
eccs_q_special(morph_root(R),m(Cl,St,R,MS,MR), m(Cl,St,R,MS,MR)).
eccs_q_special(morph_stem(K,St0),m(Cl,St,R,MS,MR), m(Cl,St,R,[K-St0|MS],MR)).
eccs_q_special(morph_root(K,R0),m(Cl,St,R,MS,MR), m(Cl,St,R,MS,[K-R0|MR])).

/*

eccs_q_merge(Obj, Obj1, Obj2)

Obj and Obj1 unify to give Obj2

We handle the discrepancies between term and graph unification here

*/

eccs_q_merge(T, T1, T2) :-
    eccs_user_unify(T, T1, T2).



/*

eccs_q_apply_lexical_rules(Ts, LRs, L3, Struct, Struct1),

Apply in order the lexical_rules named in LRs to the templates Ts and the 
structure Struct to get L3 and Struct1

*/
eccs_q_apply_lexical_rules(Ts, [], Ts, Struct, Struct) :- !.
eccs_q_apply_lexical_rules(Ts, LRs, TsOut, Struct, Struct1) :- 
    apply_lexical_rules(Struct, Struct1, Ts, TsOut, LRs).
% last line is a hook to Mike's routine

lexical_rule(Name, In, Out:COut:BOut, IProps, OProps) :-
    global_variable(unification, term), !,
    (verify( pimple_obj('&lexical_rule', lr(Name, (IProps -> OProps), RIn, ROut))) -> true; p_error([no, such, lexical, 'rule:', Name])),
    pimple_obj('&lexical_rule', lr(Name, (IProps -> OProps), RIn, ROut)),
    eccs_q_merge(In, RIn, _:C1:B1),
    eccs_q_merge(Out:[]:[], ROut, _:C2:B2),
    check_constraints([C1|C2], COut),
    once(append(B1, B2, B3)),
    u_ck_typ(B3, BOut).
lexical_rule(Name, In, Out, IProps, OProps) :-
    global_variable(unification, graph),
    (verify(
    	pimple_obj('&lexical_rule', lr(Name, (IProps -> OProps), RIn, ROut)))->
	true;  p_error([no, such, lexical, 'rule:', Name])),
    pimple_obj('&lexical_rule', lr(Name, (IProps -> OProps), RIn, ROut)),
    eccs_q_merge(In, RIn, _),
    eccs_q_merge(Out, ROut, _).

