eccs_q_network_entry(fulfils(Dimension, F), fulfils(Dimension, F), '&fulfils').

eccs_q_network_entry(requires(T, R), requires(T, R), '&requires').

eccs_q_network_entry(default(Dim, Df), default(Dim, Df, no_condition), '&default').

eccs_q_network_entry((default(Dim, Df) :- Condition), default(Dim, Df, Condition), '&default').


eccs_q_lexical_rule(lexical_rule(Name, Map, SRCIn, SRCOut), 
	lr(Name, (ICL -> OCL), In, Out:OutCOut:OutBOut), '&lexical_rule') :-
	global_variable(unification, term), !,
	Map = (IC -> OC), 
	eccs_q_commas_to_list(IC, ICL),
	eccs_q_commas_to_list(OC, OCL),
	u_mk_lr(SRCIn:[]:[], SRCOut:[]:[], In, Out:OutCOut:OutBOut1),
	filter_bits(Out,OutBOut1,OutBOut).
	
eccs_q_lexical_rule(lexical_rule(Name, Map, Eqs), 
	lr(Name, (ICL -> OCL), In, Out), '&lexical_rule') :-
	    global_variable(unification, graph), !,
	    Map = (IC -> OC),
	    eccs_q_commas_to_list(IC, ICL),
	    eccs_q_commas_to_list(OC, OCL),
	    make_lexical_rule(Eqs, _:[]:[], _:[]:[], In, Out).
/*
The first clause here deals with template equivalences.  These are stored
te/2.  The second and third deal with parameterized templates.
*/


u_mk_template((A <-> B), te(A, L), '&template') :- !,
    eccs_q_commas_to_list(B, L).
u_mk_template((A => In), template(A1, not_an_alias, Out), '&template') :-
    u_template(A, A1, In, Out).
u_mk_template((A aliases In), template(A, alias, Out), '&template') :-
    u_template(A, A1, In, Out).

u_template(A, A, In, D:COut:BOut) :-
    eccs_sys_atomic(A), !,
    u_template1(In, _, [], [], D, COut, BOut, _ST, 0, _N).
u_template(A, A1, In, D:COut:BOut) :-
    A =.. [F|Args],
    u_template1(In, _, [], [], D, COut, BOut, _ST, 0, _N),
    u_fix_parameters(Args, Args1, _ST, D),
    A1 =.. [F|Args1].

u_fix_parameters([], [], _, _) :- !.
u_fix_parameters(['UVAR'(N)|R], [Val|T], ST, D) :-
    memberchk('UVAR'(N, _, Val), ST), !,
    u_fix_parameters(R, T, ST, D).
u_fix_parameters([:P|R], [Val|T], ST, D) :-
    p_path_translate(P, P1),
    (global_variable(unification, term) -> u_path_value(P1, _, D, Val);
                    p_path_value(P1, D, Val)),
    u_fix_parameters(R, T, ST, D).

/* 

Routines for processing morph tables and character classes

*/
eccs_q_character_classes(class(Abb, {Class}), table_class(Abb, C), '&cclass') :-
    !,
    eccs_q_commas_to_list(Class, C).
eccs_q_character_classes(class(Abb, {}), table_class(Abb, []), '&cclass').

eccs_q_table_class(C, R) :-
    eccs_get_from_database(cclass, _, table_class(C, R)).

eccs_q_table(table(Id,C0,LR,F), table(Id,Tem,D,Spe,Eq,m(Cl,St,Rt,MS,MR),LR,F), '&table') :-
	  mklist(C0,C),
	  map_entry_list(C,Tem,D,[],Spe,Eq,m(Cl,St,Rt,[],[]),m(Cl,St,Rt,MS,MR)).

/* 

Get rid of this!

*/

mklist([],[]) :- !.
mklist([X|Y],[X|Y]) :- !.
mklist(X,[X]).

